/*
 * Decompiled with CFR 0.152.
 */
package org.eso.gasgano.keyword;

import java.io.Serializable;
import java.util.Enumeration;
import javax.swing.tree.TreeNode;
import org.eso.gasgano.keyword.DefaultBoolKeywordExpr;
import org.eso.gasgano.keyword.ExpressionEvaluationException;
import org.eso.gasgano.keyword.Keyword;
import org.eso.gasgano.keyword.KeywordSet;

public class KeywordExpression
implements Serializable {
    private String asString = null;
    private DefaultBoolKeywordExpr expressionTree = null;
    static final long serialVersionUID = 7804384734795496229L;

    public KeywordExpression() {
    }

    public KeywordExpression(DefaultBoolKeywordExpr exp) {
        this.setExpressionTree(exp);
    }

    public void setExpressionTree(DefaultBoolKeywordExpr n) {
        this.expressionTree = n;
        this.asString = null;
    }

    public KeywordExpression copy() {
        return new KeywordExpression(this.getExpressionTree().copy());
    }

    public DefaultBoolKeywordExpr getExpressionTree() {
        return this.expressionTree;
    }

    private void resolveExpressionToString(StringBuffer s, DefaultBoolKeywordExpr n) {
        s.append("(");
        if (n.getChildCount() > 0) {
            Enumeration<TreeNode> e2 = n.children();
            boolean firstPrinted = false;
            while (e2.hasMoreElements()) {
                DefaultBoolKeywordExpr expr = (DefaultBoolKeywordExpr)e2.nextElement();
                if (firstPrinted) {
                    s.append(" " + n.getOpString() + " ");
                } else {
                    firstPrinted = true;
                }
                this.resolveExpressionToString(s, expr);
            }
        } else {
            s.append(n.toString());
        }
        s.append(")");
    }

    public String toString() {
        if (this.asString == null) {
            StringBuffer s = new StringBuffer();
            if (this.expressionTree != null) {
                this.resolveExpressionToString(s, this.expressionTree);
            }
            this.asString = s.toString();
        }
        return this.asString;
    }

    public boolean evaluate(KeywordSet kws) throws ExpressionEvaluationException {
        return this.expressionTree.evaluate(kws);
    }

    public static Object stringToValue(String arg) {
        Object rc = null;
        if (arg.startsWith("\"")) {
            try {
                rc = new String(arg.substring(1, arg.lastIndexOf("\"")));
            }
            catch (StringIndexOutOfBoundsException e2) {
                rc = null;
            }
        } else {
            try {
                rc = Float.valueOf(arg);
            }
            catch (NumberFormatException e3) {
                rc = new Keyword(arg, null);
            }
        }
        return rc;
    }

    public static String valueToString(Object arg) {
        String rc = null;
        if (arg instanceof String) {
            rc = new String("\"" + (String)arg + "\"");
        } else if (arg instanceof Keyword) {
            Keyword k = (Keyword)arg;
            rc = k.getName();
        } else {
            rc = arg.toString();
        }
        return rc;
    }
}

