/*
 * Decompiled with CFR 0.152.
 */
package org.eso.gasgano.tools;

import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.eso.gasgano.datamodel.gui.KeywordContainerOBComponent;
import org.eso.gasgano.properties.PropertyDB;

public class SortedHashtable
extends Dictionary {
    private Hashtable hTable = new Hashtable();
    private Vector sortedList = null;
    private String title = null;
    private boolean mjdsort;

    public SortedHashtable() {
    }

    public SortedHashtable(boolean mjdsort) {
        this.mjdsort = mjdsort;
    }

    public SortedHashtable(String label) {
        this.title = label;
    }

    public synchronized boolean contains(Object value) {
        return this.hTable.contains(value);
    }

    public synchronized boolean containsKey(Object key) {
        return this.hTable.containsKey(key);
    }

    public synchronized Object get(Object key) {
        return this.hTable.get(key);
    }

    public synchronized Object put(Object key, Object value) {
        this.destroySortedList();
        return this.hTable.put(key, value);
    }

    public synchronized Object remove(Object key) {
        this.destroySortedList();
        return this.hTable.remove(key);
    }

    public synchronized Enumeration elements() {
        return this.hTable.elements();
    }

    public synchronized Enumeration keys() {
        return this.hTable.keys();
    }

    public synchronized void clear() {
        this.destroySortedList();
        this.hTable.clear();
    }

    @Override
    public int size() {
        return this.hTable.size();
    }

    @Override
    public boolean isEmpty() {
        return this.hTable.isEmpty();
    }

    public synchronized String toString() {
        String rc = this.title;
        if (rc == null) {
            rc = this.hTable.toString();
        }
        return rc;
    }

    public synchronized Object elementAt(int index) {
        this.buildSortedList();
        return this.sortedList.elementAt(index);
    }

    public int indexOf(Object elem) {
        this.buildSortedList();
        return this.sortedList.indexOf(elem);
    }

    private void buildSortedList() {
        if (this.sortedList == null) {
            this.sortedList = new Vector(this.hTable.size());
            int numInserted = 0;
            Enumeration e2 = this.hTable.elements();
            while (e2.hasMoreElements()) {
                int i;
                Object insertee = e2.nextElement();
                String insertVal = insertee.toString();
                for (i = 0; i < numInserted && !(this.mjdsort && PropertyDB.getInstance().getProperty("MJD_SORTING").equals("true") ? insertee instanceof KeywordContainerOBComponent && insertee instanceof KeywordContainerOBComponent && this.sortedList.elementAt(i) instanceof KeywordContainerOBComponent && ((KeywordContainerOBComponent)insertee).precedes((KeywordContainerOBComponent)this.sortedList.elementAt(i)) : insertVal.compareTo(this.sortedList.elementAt(i).toString()) <= 0); ++i) {
                }
                this.sortedList.insertElementAt(insertee, i);
                ++numInserted;
            }
        }
    }

    private void destroySortedList() {
        this.sortedList = null;
    }
}

