/*
 * Decompiled with CFR 0.152.
 */
package org.eso.oca.parser;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.apache.log4j.Logger;
import org.eso.oca.fits.TypedHeaderCard;
import org.eso.oca.fits.UndefinedFITSValue;
import org.eso.oca.parser.InterpretationException;
import org.eso.oca.parser.OCAState;
import org.eso.oca.parser.OcaParser;
import org.eso.oca.parser.OcaParserVisitor;
import org.eso.oca.parser.OcaVisitorException;
import org.eso.oca.parser.SimpleNode;

public class ASTDivision
extends SimpleNode {
    static Logger logger = Logger.getLogger(ASTDivision.class);
    private static int FITS_PRECISION = 20;

    public ASTDivision(int id) {
        super(id);
    }

    public ASTDivision(OcaParser p, int id) {
        super(p, id);
    }

    @Override
    public Object jjtAccept(OcaParserVisitor visitor, Object data) throws OcaVisitorException {
        return visitor.visit(this, data);
    }

    @Override
    public int precedence() {
        return 50;
    }

    private int exponent(BigDecimal number) {
        int exponent = number.unscaledValue().toString().length();
        exponent = number.signum() < 0 ? (exponent -= 2) : --exponent;
        return exponent - number.scale();
    }

    private int divisionScale(BigDecimal leftOperand, BigDecimal rightOperand) {
        int scale = this.exponent(rightOperand) - this.exponent(leftOperand) + FITS_PRECISION;
        if (scale < 0) {
            scale = 0;
        }
        return scale;
    }

    Object divide(Object leftOperand, Object rightOperand) throws InterpretationException {
        String message = this.getNodeLocationString() + "Operator '/' may not be used for \"" + TypedHeaderCard.findFITSTypeString(leftOperand) + " / " + TypedHeaderCard.findFITSTypeString(rightOperand) + "\".";
        logger.error(message);
        throw new InterpretationException(message);
    }

    UndefinedFITSValue divide(UndefinedFITSValue leftOperand, Object rightOperand) {
        String message = this.getNodeLocationString() + "Operator '/' used with undefined operand: \"" + TypedHeaderCard.findFITSTypeString(leftOperand) + " / " + TypedHeaderCard.findFITSTypeString(rightOperand) + "\".";
        logger.warn(message);
        return new UndefinedFITSValue();
    }

    UndefinedFITSValue divide(Object leftOperand, UndefinedFITSValue rightOperand) {
        String message = this.getNodeLocationString() + "Operator '/' used with undefined operand: \"" + TypedHeaderCard.findFITSTypeString(leftOperand) + " / " + TypedHeaderCard.findFITSTypeString(rightOperand) + "\".";
        logger.warn(message);
        return new UndefinedFITSValue();
    }

    BigDecimal divide(BigDecimal leftOperand, BigDecimal rightOperand) {
        return leftOperand.divide(rightOperand, this.divisionScale(leftOperand, rightOperand), 4);
    }

    BigDecimal divide(BigDecimal leftOperand, BigInteger rightOperand) {
        logger.warn(this.getNodeLocationString() + "Performing '" + TypedHeaderCard.findFITSTypeString(leftOperand) + " / " + TypedHeaderCard.findFITSTypeString(rightOperand) + "'.");
        BigDecimal promotedRightOperand = new BigDecimal(rightOperand);
        return leftOperand.divide(promotedRightOperand, this.divisionScale(leftOperand, promotedRightOperand), 4);
    }

    BigDecimal divide(BigInteger leftOperand, BigDecimal rightOperand) {
        logger.warn(this.getNodeLocationString() + "Performing '" + TypedHeaderCard.findFITSTypeString(leftOperand) + " / " + TypedHeaderCard.findFITSTypeString(rightOperand) + "'.");
        BigDecimal promotedLeftOperand = new BigDecimal(leftOperand);
        return promotedLeftOperand.divide(rightOperand, this.divisionScale(promotedLeftOperand, rightOperand), 4);
    }

    BigInteger divide(BigInteger leftOperand, BigInteger rightOperand) {
        return leftOperand.divide(rightOperand);
    }

    @Override
    public void interpret(OCAState state) throws InterpretationException {
        logger.trace("interpret() called.");
        this.jjtGetChild(0).interpret(state);
        this.jjtGetChild(1).interpret(state);
        state.stack[--state.top] = this.dispatch(this.getClass(), "divide", new Object[]{state.stack[state.top], state.stack[state.top + 1]});
    }
}

