/*
 * Decompiled with CFR 0.152.
 */
package org.eso.util.archive;

import java.io.File;
import java.io.IOException;
import org.apache.http.client.HttpClient;
import org.apache.log4j.Logger;
import org.eso.util.archive.ChecksumUtil;
import org.eso.util.archive.MimeType;
import org.eso.util.archive.NgasHost;
import org.eso.util.archive.PostTask;

public class ArchiveTask
extends PostTask {
    static final Logger logger = Logger.getLogger(ArchiveTask.class);

    public ArchiveTask(HttpClient httpClient, NgasHost host, File file, String mimeType, String fileId) {
        super(httpClient, host, file);
        this.command = "ARCHIVE";
        this.mimeType = mimeType;
        this.fileId = fileId;
    }

    @Override
    protected String createContentDisposition() throws IOException {
        String contentDisposition = "attachment;";
        contentDisposition = contentDisposition + "filename=\"" + this.file.getName() + "\";";
        contentDisposition = contentDisposition + "wait=\"1\";";
        if (this.mimeType == MimeType.OCTET_STREAM.toString()) {
            if (this.fileId != null) {
                contentDisposition = contentDisposition + "file_id=\"" + this.fileId + "\";";
            }
            contentDisposition = contentDisposition + "checksum=\"" + ChecksumUtil.calculateNgamsCrc32(this.file.getAbsolutePath()) + "\";";
            contentDisposition = contentDisposition + "checksum_cmd=\"ngamsGenCrc32\";";
        }
        return contentDisposition;
    }
}

