/*
 * Decompiled with CFR 0.152.
 */
package org.eso.util.configuration;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeSet;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.eso.util.configuration.CommandLineHandler;
import org.eso.util.configuration.ConfigurationOption;
import org.eso.util.configuration.MetaConfigurationError;
import org.eso.util.configuration.MetaConfigurator;
import org.eso.util.configuration.PropertyHandler;
import org.eso.util.misc.WrappedString;

public class Configuration {
    static final Logger logger = Logger.getLogger(Configuration.class);
    private static final String classLogName = "Configuration";
    private boolean constructionComplete = false;
    private HashMap<String, ConfigurationOption> modifiableConfigurationMap = new HashMap();
    private final Map<String, ConfigurationOption> configurationMap = Collections.unmodifiableMap(this.modifiableConfigurationMap);
    private boolean commandLineParsed = false;
    private ArrayList<String> modifiableRemainingCommandLineArgumentList = new ArrayList();
    private final List<String> remainingCommandLineArgumentList = Collections.unmodifiableList(this.modifiableRemainingCommandLineArgumentList);

    protected Configuration(String metaConfigurationFilePath) throws NullPointerException, MetaConfigurationError {
        String methodLogName = "Configuration::Configuration()";
        logger.trace("Configuration::Configuration()");
        logger.debug("Configuration::Configuration() - commencing meta-configuration.");
        MetaConfigurator.metaConfigure(this, metaConfigurationFilePath);
        this.modifiableConfigurationMap = null;
        this.constructionComplete = true;
        logger.debug("Configuration::Configuration() - meta-configuration complete.");
    }

    final void addOption(ConfigurationOption option) throws IllegalStateException, MetaConfigurationError, NullPointerException {
        String methodLogName = "Configuration::addOption()";
        logger.trace("Configuration::addOption()");
        if (option == null) {
            String message = "Configuration::addOption() - option must not be null.";
            logger.fatal("Configuration::addOption() - option must not be null.");
            throw new NullPointerException("Configuration::addOption() - option must not be null.");
        }
        if (this.constructionComplete) {
            String message = "Configuration::addOption() - this method can only be called at construction time.";
            logger.fatal("Configuration::addOption() - this method can only be called at construction time.");
            throw new IllegalStateException("Configuration::addOption() - this method can only be called at construction time.");
        }
        if (this.modifiableConfigurationMap.containsKey(option.optionName)) {
            String message = "Configuration::addOption() - option [" + option.optionName + "] rejected as a duplicate.";
            logger.fatal(message);
            throw new MetaConfigurationError(message);
        }
        this.modifiableConfigurationMap.put(option.optionName, option);
    }

    final boolean constructionComplete() {
        String methodLogName = "Configuration::constructionComplete()";
        logger.trace("Configuration::constructionComplete()");
        return this.constructionComplete;
    }

    final Map<String, ConfigurationOption> getSelectedOptionMap(int valueSources) throws IllegalArgumentException {
        String methodLogName = "Configuration::getSelectedOptionMap()";
        logger.trace("Configuration::getSelectedOptionMap()");
        if (!ConfigurationOption.allValueSourcesDefined(valueSources)) {
            String message = "Configuration::getSelectedOptionMap() - valueSources [" + ConfigurationOption.getValueSourceString(valueSources) + "] must specify defined value sources.";
            logger.fatal(message);
            throw new IllegalArgumentException(message);
        }
        logger.debug("Configuration::getSelectedOptionMap() - selecting [" + ConfigurationOption.getValueSourceString(valueSources) + "] options.");
        HashMap<String, ConfigurationOption> selectedOptions = new HashMap<String, ConfigurationOption>();
        Iterator<ConfigurationOption> configurationMapIterator = this.configurationMap.values().iterator();
        ConfigurationOption currentOption = null;
        while (configurationMapIterator.hasNext()) {
            currentOption = configurationMapIterator.next();
            if ((valueSources & currentOption.validValueSources) == 0) {
                logger.debug("Configuration::getSelectedOptionMap() - ignoring option [" + currentOption.optionName + "].");
                continue;
            }
            logger.debug("Configuration::getSelectedOptionMap() - selecting option [" + currentOption.optionName + "].");
            selectedOptions.put(currentOption.optionName, currentOption);
        }
        return selectedOptions;
    }

    protected final synchronized boolean loadApplicationProperties(File propertyFile) {
        String methodLogName = "Configuration::loadApplicationProperties()";
        logger.trace("Configuration::loadApplicationProperties()");
        return PropertyHandler.loadApplicationProperties(propertyFile, this);
    }

    protected final synchronized boolean loadSystemProperties() {
        String methodLogName = "Configuration::loadSystemProperties()";
        logger.trace("Configuration::loadSystemProperties()");
        return PropertyHandler.loadSystemProperties(this);
    }

    protected final synchronized boolean loadProperties(Properties properties) {
        String methodLogName = "Configuration::loadProperties()";
        logger.trace("Configuration::loadProperties()");
        return PropertyHandler.loadProperties(properties, this);
    }

    final boolean commandLineParsed() {
        String methodLogName = "Configuration::commandLineParsed()";
        logger.trace("Configuration::commandLineParsed()");
        return this.commandLineParsed;
    }

    public final synchronized String[] getRemainingCommandLineArguments() {
        String methodLogName = "Configuration::getRemainingCommandLineArguments()";
        logger.trace("Configuration::getRemainingCommandLineArguments()");
        String[] remainingCommandLineArguments = new String[this.remainingCommandLineArgumentList.size()];
        return this.remainingCommandLineArgumentList.toArray(remainingCommandLineArguments);
    }

    final synchronized void setRemainingCommandLineArguments(String[] arguments) throws IllegalStateException, NullPointerException {
        String methodLogName = "Configuration::setRemainingCommandLineArguments()";
        logger.trace("Configuration::setRemainingCommandLineArguments()");
        if (arguments == null) {
            String message = "Configuration::setRemainingCommandLineArguments() - arguments must not be null.";
            logger.fatal("Configuration::setRemainingCommandLineArguments() - arguments must not be null.");
            throw new NullPointerException("Configuration::setRemainingCommandLineArguments() - arguments must not be null.");
        }
        if (this.commandLineParsed) {
            String message = "Configuration::setRemainingCommandLineArguments() - this method can only be called once per Configuration instance.";
            logger.fatal("Configuration::setRemainingCommandLineArguments() - this method can only be called once per Configuration instance.");
            throw new IllegalStateException("Configuration::setRemainingCommandLineArguments() - this method can only be called once per Configuration instance.");
        }
        for (int i = 0; i < arguments.length; ++i) {
            this.modifiableRemainingCommandLineArgumentList.add(arguments[i]);
        }
        this.modifiableRemainingCommandLineArgumentList = null;
        this.commandLineParsed = true;
    }

    protected final synchronized boolean parseCommandLine(String[] arguments) throws NullPointerException {
        String methodLogName = "Configuration::parseCommandLine()";
        logger.trace("Configuration::parseCommandLine()");
        if (this.commandLineParsed) {
            String message = "Configuration::parseCommandLine() - this method can only be called once per Configuration instance.";
            logger.fatal("Configuration::parseCommandLine() - this method can only be called once per Configuration instance.");
            throw new IllegalStateException("Configuration::parseCommandLine() - this method can only be called once per Configuration instance.");
        }
        return CommandLineHandler.parseCommandLine(arguments, this);
    }

    protected synchronized boolean checkConfiguration() {
        String methodLogName = "Configuration::checkConfiguration()";
        logger.trace("Configuration::checkConfiguration()");
        int unsetOptions = 0;
        logger.debug("Configuration::checkConfiguration() - checking configuration options.");
        Iterator<ConfigurationOption> configurationMapIterator = this.configurationMap.values().iterator();
        ConfigurationOption currentOption = null;
        while (configurationMapIterator.hasNext()) {
            currentOption = configurationMapIterator.next();
            if (currentOption.getActualValue() == null ^ currentOption.getActualValueSource() == 0) {
                String message = "Configuration::checkConfiguration() - value source [" + ConfigurationOption.getValueSourceString(currentOption.getActualValueSource()) + "] and value [" + currentOption.getActualValue() + "] are mismatched for option [" + currentOption.optionName + "].";
                logger.fatal(message);
                throw new AssertionError((Object)message);
            }
            if (currentOption.getActualValue() == null) {
                logger.error("Configuration::checkConfiguration() - option [" + currentOption.optionName + "] has not been properly" + " set. It can be set from the following source" + (ConfigurationOption.isSingleDefinedValueSource(currentOption.validValueSources) ? ": " : "s: ") + ConfigurationOption.getValueSourceString(currentOption.validValueSources) + ".");
                ++unsetOptions;
                continue;
            }
            logger.debug("Configuration::checkConfiguration() - option [" + currentOption.optionName + "] has been set from a valid source [" + ConfigurationOption.getValueSourceString(currentOption.getActualValueSource()) + "].");
        }
        if (unsetOptions == 0) {
            logger.debug("Configuration::checkConfiguration() - all configuration options successfully checked.");
        } else {
            logger.error("Configuration::checkConfiguration() - " + unsetOptions + " configuration option" + (unsetOptions == 1 ? " has" : "s have") + " not been properly set.");
        }
        return unsetOptions == 0;
    }

    protected synchronized void logConfiguration(Level logLevel) throws NullPointerException {
        String methodLogName = "Configuration::logConfiguration()";
        logger.trace("Configuration::logConfiguration()");
        if (logLevel == null) {
            String message = "Configuration::logConfiguration() - logLevel must not be null.";
            logger.fatal("Configuration::logConfiguration() - logLevel must not be null.");
            throw new NullPointerException("Configuration::logConfiguration() - logLevel must not be null.");
        }
        logger.log(logLevel, "Configuration::logConfiguration() - configuration options are set as follows:");
        HashMap<String, ConfigurationOption> optionMap = new HashMap<String, ConfigurationOption>(this.configurationMap);
        Iterator<String> redundantPropertyIterator = MetaConfigurator.mandatoryMetaConfigurationProperties.iterator();
        while (redundantPropertyIterator.hasNext()) {
            optionMap.remove(redundantPropertyIterator.next());
        }
        Iterator<ConfigurationOption> optionMapIterator = optionMap.values().iterator();
        TreeSet<String> messageSet = new TreeSet<String>();
        ConfigurationOption currentOption = null;
        String logMessage = null;
        while (optionMapIterator.hasNext()) {
            currentOption = optionMapIterator.next();
            logMessage = currentOption.optionName + "] type [" + ConfigurationOption.getTypeString(currentOption.optionType) + "] value [" + currentOption.getActualValue() + "] source [" + ConfigurationOption.getValueSourceString(currentOption.getActualValueSource()) + "]";
            switch (currentOption.getActualValueSource()) {
                case 0: {
                    logMessage = logMessage + "[not set yet].";
                    break;
                }
                case 1: {
                    logMessage = logMessage + ".";
                    break;
                }
                case 2: {
                    logMessage = logMessage + " property [" + currentOption.propertyName + "] file [" + currentOption.getPropertyFile() + "].";
                    break;
                }
                case 4: {
                    logMessage = logMessage + " property [" + currentOption.propertyName + "].";
                    break;
                }
                case 8: {
                    logMessage = logMessage + " parameter [";
                    boolean useSeparator = false;
                    if (currentOption.commandLineChar != '\u0000') {
                        logMessage = logMessage + "-" + currentOption.commandLineChar;
                        useSeparator = true;
                    }
                    if (currentOption.commandLineName != "") {
                        logMessage = logMessage + (useSeparator ? " / " : "") + "--" + currentOption.commandLineName;
                    }
                    logMessage = logMessage + "].";
                    break;
                }
                case 16: {
                    logMessage = logMessage + ".";
                    break;
                }
                default: {
                    String message = "Configuration::logConfiguration() - configuration option [" + currentOption.optionName + "] value source [" + ConfigurationOption.getValueSourceString(currentOption.getActualValueSource()) + "] not recognised.";
                    logger.fatal(message);
                    throw new AssertionError((Object)message);
                }
            }
            messageSet.add(logMessage);
        }
        Iterator messageIterator = messageSet.iterator();
        while (messageIterator.hasNext()) {
            logger.log(logLevel, "Configuration::logConfiguration() - option [" + (String)messageIterator.next());
        }
        logger.log(logLevel, "Configuration::logConfiguration() - all configuration options logged.");
    }

    protected void logVersionMessage(Level logLevel) {
        String methodLogName = "Configuration::logVersionMessage()";
        logger.trace("Configuration::logVersionMessage()");
        logger.log(logLevel, "Configuration::logVersionMessage() - " + this.getString("application.name") + " version: " + this.getString("application.version"));
    }

    protected void printVersionMessage() {
        String methodLogName = "Configuration::printVersionMessage()";
        logger.trace("Configuration::printVersionMessage()");
        logger.debug("Configuration::printVersionMessage() - printing version message to standard output.");
        System.out.print(new WrappedString("", this.getString("application.name") + " version: " + this.getString("application.version")) + "\n");
    }

    protected void printCommandLineHelpMessage() {
        String methodLogName = "Configuration::printCommandLineHelpMessage()";
        logger.trace("Configuration::printCommandLineHelpMessage()");
        CommandLineHandler.printCommandLineHelpMessage(this);
    }

    protected void printSystemPropertyHelpMessage() {
        String methodLogName = "Configuration::printSystemPropertyHelpMessage()";
        logger.trace("Configuration::printSystemPropertyHelpMessage()");
        PropertyHandler.printSystemPropertyHelpMessage(this);
    }

    protected final boolean createTemplatePropertyFile(File outputFile) throws NullPointerException {
        String methodLogName = "Configuration::createTemplatePropertyFile()";
        logger.trace("Configuration::createTemplatePropertyFile()");
        return PropertyHandler.createTemplatePropertyFile(outputFile, this);
    }

    private final ConfigurationOption getConfigurationOption(String optionName) throws IllegalArgumentException, NullPointerException {
        String methodLogName = "Configuration::getConfigurationOption()";
        logger.trace("Configuration::getConfigurationOption()");
        if (optionName == null) {
            String message = "Configuration::getConfigurationOption() - optionName must not be null.";
            logger.fatal("Configuration::getConfigurationOption() - optionName must not be null.");
            throw new NullPointerException("Configuration::getConfigurationOption() - optionName must not be null.");
        }
        logger.debug("Configuration::getConfigurationOption() - option [" + optionName + "] requested.");
        ConfigurationOption option = this.configurationMap.get(optionName);
        if (option == null) {
            String message = "Configuration::getConfigurationOption() - unknown configuration option [" + optionName + "] requested.";
            logger.fatal(message);
            throw new IllegalArgumentException(message);
        }
        return option;
    }

    private final synchronized <T> T getConfiguredValue(String optionName, Class<T> valueType) throws IllegalArgumentException, NullPointerException {
        String methodLogName = "Configuration::getConfiguredValue()";
        logger.trace("Configuration::getConfiguredValue()");
        logger.debug("Configuration::getConfiguredValue() - value requested for option [" + optionName + "].");
        if (optionName == null || valueType == null) {
            String message = "Configuration::getConfiguredValue() - optionName [" + optionName + "] and valueType [" + valueType + "] must not be null.";
            logger.fatal(message);
            throw new NullPointerException(message);
        }
        ConfigurationOption option = this.getConfigurationOption(optionName);
        if (option.getActualValueSource() == 0) {
            String message = "Configuration::getConfiguredValue() - configuration option [" + optionName + "] does not have a value.";
            logger.fatal(message);
            throw new IllegalArgumentException(message);
        }
        Object value = option.getActualValue();
        if (!valueType.isInstance(value)) {
            String message = "Configuration::getConfiguredValue() - configuration option [" + optionName + "] is not mapped to a value of the specified type [mapped: " + (value == null ? null : value.getClass().getName()) + "][specified: " + valueType.getName() + "].";
            logger.fatal(message);
            throw new IllegalArgumentException(message);
        }
        return valueType.cast(value);
    }

    public final String getString(String optionName) throws IllegalArgumentException, NullPointerException {
        String methodLogName = "Configuration::getString()";
        logger.trace("Configuration::getString()");
        logger.debug("Configuration::getString() - option [" + optionName + "] requested.");
        return this.getConfiguredValue(optionName, String.class);
    }

    public final Boolean getBoolean(String optionName) throws IllegalArgumentException, NullPointerException {
        String methodLogName = "Configuration::getBoolean()";
        logger.trace("Configuration::getBoolean()");
        logger.debug("Configuration::getBoolean() - option [" + optionName + "] requested.");
        return this.getConfiguredValue(optionName, Boolean.class);
    }

    public final Integer getInteger(String optionName) throws IllegalArgumentException, NullPointerException {
        String methodLogName = "Configuration::getInteger()";
        logger.trace("Configuration::getInteger()");
        logger.debug("Configuration::getInteger() - option [" + optionName + "] requested.");
        return this.getConfiguredValue(optionName, Integer.class);
    }

    private final synchronized <T> T getDefaultValue(String optionName, Class<T> valueType) throws IllegalArgumentException, NullPointerException {
        String methodLogName = "Configuration::getDefaultValue()";
        logger.trace("Configuration::getDefaultValue()");
        logger.debug("Configuration::getDefaultValue() - default value requested for option [" + optionName + "].");
        if (optionName == null || valueType == null) {
            String message = "Configuration::getDefaultValue() - optionName [" + optionName + "] and valueType [" + valueType + "] must not be null.";
            logger.fatal(message);
            throw new NullPointerException(message);
        }
        ConfigurationOption option = this.getConfigurationOption(optionName);
        if (!ConfigurationOption.isValidValueSource(1, option.validValueSources)) {
            String message = "Configuration::getDefaultValue() - configuration option [" + optionName + "] does not have a default value.";
            logger.fatal(message);
            throw new IllegalArgumentException(message);
        }
        Object value = option.defaultValue;
        if (!valueType.isInstance(value)) {
            String message = "Configuration::getDefaultValue() - configuration option [" + optionName + "] is not mapped to a value of the specified type [mapped: " + (value == null ? null : value.getClass().getName()) + "][specified: " + valueType.getName() + "].";
            logger.fatal(message);
            throw new IllegalArgumentException(message);
        }
        return valueType.cast(value);
    }

    public final String getDefaultString(String optionName) throws IllegalArgumentException, NullPointerException {
        String methodLogName = "Configuration::getDefaultString()";
        logger.trace("Configuration::getDefaultString()");
        logger.debug("Configuration::getDefaultString() - option [" + optionName + "] requested.");
        return this.getDefaultValue(optionName, String.class);
    }

    public final Boolean getDefaultBoolean(String optionName) throws IllegalArgumentException, NullPointerException {
        String methodLogName = "Configuration::getDefaultBoolean()";
        logger.trace("Configuration::getDefaultBoolean()");
        logger.debug("Configuration::getDefaultBoolean() - option [" + optionName + "] requested.");
        return this.getDefaultValue(optionName, Boolean.class);
    }

    public final Integer getDefaultInteger(String optionName) throws IllegalArgumentException, NullPointerException {
        String methodLogName = "Configuration::getDefaultInteger()";
        logger.trace("Configuration::getDefaultInteger()");
        logger.debug("Configuration::getDefaultInteger() - option [" + optionName + "] requested.");
        return this.getDefaultValue(optionName, Integer.class);
    }

    public final synchronized void setValue(String optionName, Object optionValue) throws IllegalArgumentException, NullPointerException {
        String methodLogName = "Configuration::setValue()";
        logger.trace("Configuration::setValue()");
        if (optionName == null || optionValue == null) {
            String message = "Configuration::setValue() - optionName [" + optionName + "] and optionValue [" + optionValue + "] must not be null.";
            logger.fatal(message);
            throw new NullPointerException(message);
        }
        ConfigurationOption option = this.getConfigurationOption(optionName);
        option.setActualValue(optionValue, 16, null);
    }

    public final synchronized void setValueToDefault(String optionName) throws IllegalArgumentException, NullPointerException {
        String methodLogName = "Configuration::setValueToDefault()";
        logger.trace("Configuration::setValueToDefault()");
        if (optionName == null) {
            String message = "Configuration::setValueToDefault() - optionName must not be null.";
            logger.fatal("Configuration::setValueToDefault() - optionName must not be null.");
            throw new NullPointerException("Configuration::setValueToDefault() - optionName must not be null.");
        }
        ConfigurationOption option = this.getConfigurationOption(optionName);
        if (!ConfigurationOption.isValidValueSource(1, option.validValueSources)) {
            String message = "Configuration::setValueToDefault() - configuration option [" + optionName + "] does not have a default value.";
            logger.fatal(message);
            throw new IllegalArgumentException(message);
        }
        option.setActualValue(option.defaultValue, 16, null);
    }

    public final synchronized int getValidValueSources(String optionName) throws NullPointerException, IllegalArgumentException {
        String methodLogName = "Configuration::getValidValueSources()";
        logger.trace("Configuration::getValidValueSources()");
        if (optionName == null) {
            String message = "Configuration::getValidValueSources() - optionName must not be null.";
            logger.fatal("Configuration::getValidValueSources() - optionName must not be null.");
            throw new NullPointerException("Configuration::getValidValueSources() - optionName must not be null.");
        }
        return this.getConfigurationOption((String)optionName).validValueSources;
    }

    public final synchronized boolean isValidValueSource(String optionName, int valueSource) throws NullPointerException, IllegalArgumentException {
        String methodLogName = "Configuration::isValidValueSource()";
        logger.trace("Configuration::isValidValueSource()");
        if (optionName == null) {
            String message = "Configuration::isValidValueSource() - optionName must not be null.";
            logger.fatal("Configuration::isValidValueSource() - optionName must not be null.");
            throw new NullPointerException("Configuration::isValidValueSource() - optionName must not be null.");
        }
        return ConfigurationOption.isValidValueSource(valueSource, this.getConfigurationOption((String)optionName).validValueSources);
    }

    public final synchronized int getActualValueSource(String optionName) throws NullPointerException, IllegalArgumentException {
        String methodLogName = "Configuration::getActualValueSource()";
        logger.trace("Configuration::getActualValueSource()");
        if (optionName == null) {
            String message = "Configuration::getActualValueSource() - optionName must not be null.";
            logger.fatal("Configuration::getActualValueSource() - optionName must not be null.");
            throw new NullPointerException("Configuration::getActualValueSource() - optionName must not be null.");
        }
        return this.getConfigurationOption(optionName).getActualValueSource();
    }

    public final boolean valueAvailable(String optionName) throws NullPointerException, IllegalArgumentException {
        String methodLogName = "Configuration::valueAvailable()";
        logger.trace("Configuration::valueAvailable()");
        return this.getActualValueSource(optionName) != 0;
    }
}

