/*
 * Decompiled with CFR 0.152.
 */
package org.eso.util.dal;

import java.sql.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import org.eso.util.dal.DAOException;

public class ReplicationRequest {
    private String d_fileId = null;
    private Integer d_fileVersion = null;
    private String d_diskId = null;
    private String d_submitterId = null;
    private Date d_submissionTime = null;
    private Integer d_priority = null;
    private Integer d_statusId = null;
    private Date d_lastUpdateTime = null;
    private String d_message = null;

    public String getFileId() {
        return this.d_fileId;
    }

    public void setFileId(String id) {
        this.d_fileId = id;
    }

    public Integer getFileVersion() {
        return this.d_fileVersion;
    }

    public void setFileVersion(Integer version) {
        this.d_fileVersion = version;
    }

    public String getDiskId() {
        return this.d_diskId;
    }

    public void setDiskId(String id) {
        this.d_diskId = id;
    }

    public String getSubmitterId() {
        return this.d_submitterId;
    }

    public void setSubmitterId(String id) {
        this.d_submitterId = id;
    }

    public Date getSubmissionTime() {
        return this.d_submissionTime;
    }

    public void setSubmissionTime(Date time) {
        this.d_submissionTime = time;
    }

    public Integer getPriority() {
        return this.d_priority;
    }

    public void setPriority(Integer d_priority) {
        this.d_priority = d_priority;
    }

    public Status getStatusId() {
        return Status.get(this.d_statusId);
    }

    public void setStatusId(Status status) {
        this.d_statusId = status.getCode();
    }

    public Date getLastUpdateTime() {
        return this.d_lastUpdateTime;
    }

    public void setLastUpdateTime(Date updateTime) {
        this.d_lastUpdateTime = updateTime;
    }

    public String getMessage() {
        return this.d_message;
    }

    public void setMessage(String d_message) {
        this.d_message = d_message;
    }

    public static void validate(ReplicationRequest disk) throws DAOException {
        String fields = "";
        if (disk.getFileId() == null) {
            fields = fields + ", file_id";
        }
        if (disk.getSubmitterId() == null) {
            fields = fields + ", submitter_id";
        }
        if (fields.length() > 0) {
            throw new DAOException("Mandatory field(s) " + fields.substring(2) + " missing");
        }
    }

    public String toString() {
        String res = "ReplicationRequest instance";
        res = res + "\n\tfile_id " + this.d_fileId;
        res = res + "\n\tfile_version " + this.d_fileVersion;
        res = res + "\n\tdisk_id " + this.d_diskId;
        res = res + "\n\tsubmitter_id " + this.d_submitterId;
        res = res + "\n\tsubmission_time " + this.d_submissionTime;
        res = res + "\n\tpriority " + this.d_priority;
        res = res + "\n\tstatus_id " + this.d_statusId;
        res = res + "\n\tlast_update_time " + this.d_lastUpdateTime;
        res = res + "\n\tmessage " + this.d_message;
        return res;
    }

    public static enum Status {
        SCHEDULED(0),
        PENDING(1),
        REQUESTED(2),
        READY(3),
        REPLICATING(4),
        REPLICATED(5),
        REPORTED(6),
        ERROR(-1);

        private static final Map<Integer, Status> lookup;
        private int code;

        private Status(int code) {
            this.code = code;
        }

        public int getCode() {
            return this.code;
        }

        public static Status get(int code) {
            return lookup.get(code);
        }

        static {
            lookup = new HashMap<Integer, Status>();
            for (Status s : EnumSet.allOf(Status.class)) {
                lookup.put(s.getCode(), s);
            }
        }
    }
}

