/*
 * Decompiled with CFR 0.152.
 */
package org.eso.util.dal;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.Hashtable;
import java.util.List;
import org.apache.commons.dbcp.BasicDataSource;
import org.apache.log4j.Logger;
import org.eso.util.dal.ConnectionServiceException;

public class SybaseConnectionService {
    static final Logger logger = Logger.getLogger(SybaseConnectionService.class);
    public static final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
    private static Hashtable<String, BasicDataSource> dataSources = new Hashtable();

    private SybaseConnectionService() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Connection getConnection(String serverUrl, String userName, String userPassword) throws IllegalArgumentException, ConnectionServiceException {
        String debugMessage;
        SybaseConnectionService.testStringArg(serverUrl, "The data base server URL cannot be null or empty.");
        SybaseConnectionService.testStringArg(userName, "The user name cannot be null or empty.");
        SybaseConnectionService.testStringArg(userPassword, "The password cannot be null or empty.");
        String logHead = "SybaseConnectionService::getInstance - ";
        String connectionPoolName = serverUrl.concat(userName);
        BasicDataSource dataSource = null;
        Hashtable<String, BasicDataSource> hashtable = dataSources;
        synchronized (hashtable) {
            if (SybaseConnectionService.connectionPoolExists(connectionPoolName)) {
                dataSource = SybaseConnectionService.getConnectionPool(connectionPoolName);
                debugMessage = "Using existing connection pool for data base server [" + serverUrl + "], user [" + userName + "].";
            } else {
                dataSource = new BasicDataSource();
                dataSource.setDriverClassName("com.sybase.jdbc3.jdbc.SybDriver");
                dataSource.setUrl("jdbc:sybase:Tds:" + serverUrl);
                dataSource.setUsername(userName);
                dataSource.setPassword(userPassword);
                dataSource.setMinEvictableIdleTimeMillis(3600000L);
                dataSource.setTimeBetweenEvictionRunsMillis(600L);
                dataSource.setTestOnBorrow(true);
                dataSource.setTestWhileIdle(true);
                dataSource.setMaxActive(4);
                dataSource.setMaxIdle(4);
                SybaseConnectionService.addConnectionPool(connectionPoolName, dataSource);
                debugMessage = "New connection pool created for data base server [" + serverUrl + "], user [" + userName + "].";
            }
        }
        logger.debug("SybaseConnectionService::getInstance - " + debugMessage);
        Connection connection = null;
        try {
            connection = dataSource.getConnection();
            logger.debug("SybaseConnectionService::getInstance - Connected to server [" + serverUrl + "], user [" + userName + "].");
        }
        catch (SQLException e2) {
            throw new ConnectionServiceException("SybaseConnectionService::getInstance - Cannot get connection to data base server [" + serverUrl + "], user [" + userName + "]. Reason: " + e2.getMessage());
        }
        return connection;
    }

    public static ResultSet executeStatement(Connection connection, String sqlStatement) throws IllegalArgumentException, ConnectionServiceException {
        SybaseConnectionService.testArg(connection, "The connection cannot be null.");
        SybaseConnectionService.testStringArg(sqlStatement, "The sql statement cannot be null or empty.");
        String logHead = "SybaseConnectionService::executeStatement - ";
        ResultSet resultSet = null;
        try {
            Statement statement = connection.createStatement();
            statement.execute(sqlStatement);
            resultSet = statement.getResultSet();
            logger.debug("SybaseConnectionService::executeStatement - SQL statement [" + sqlStatement + "] successfully executed.");
        }
        catch (SQLException e2) {
            String errorMessage = "Error while executing SQL statement [" + sqlStatement + "]. Reason: " + e2.getMessage();
            logger.error("SybaseConnectionService::executeStatement - " + errorMessage);
            throw new ConnectionServiceException(errorMessage);
        }
        catch (Exception e3) {
            String errorMessage = "Unexpected error while executing SQL statement [" + sqlStatement + "]. Reason: " + e3.getMessage();
            logger.error("SybaseConnectionService::executeStatement - " + errorMessage);
            throw new ConnectionServiceException(errorMessage);
        }
        return resultSet;
    }

    public static int executeUpdateStatement(Connection connection, String sqlStatement) throws IllegalArgumentException, ConnectionServiceException {
        SybaseConnectionService.testArg(connection, "The connection cannot be null.");
        SybaseConnectionService.testStringArg(sqlStatement, "The sql statement cannot be null or empty.");
        int updatedRowNb = 0;
        String logHead = "SybaseConnectionService::executeStatement - ";
        try {
            Statement statement = connection.createStatement();
            statement.execute(sqlStatement);
            updatedRowNb = statement.getUpdateCount();
            logger.debug("SybaseConnectionService::executeStatement - SQL statement [" + sqlStatement + "] successfully executed " + updatedRowNb + " rows updated ");
        }
        catch (SQLException e2) {
            String errorMessage = "Error while executing SQL statement [" + sqlStatement + "]. Reason: " + e2.getMessage();
            logger.error("SybaseConnectionService::executeStatement - " + errorMessage);
            updatedRowNb = -1;
            throw new ConnectionServiceException(errorMessage);
        }
        catch (Exception e3) {
            String errorMessage = "Unexpected error while executing SQL statement [" + sqlStatement + "]. Reason: " + e3.getMessage();
            logger.error("SybaseConnectionService::executeStatement - " + errorMessage);
            updatedRowNb = -1;
            throw new ConnectionServiceException(errorMessage);
        }
        return updatedRowNb;
    }

    public static ResultSet executeBatchedStatement(Connection connection, List<String> sqlStatements) throws IllegalArgumentException, ConnectionServiceException {
        SybaseConnectionService.testArg(connection, "The connection cannot be null.");
        SybaseConnectionService.testStringListArg(sqlStatements, "The sql statements cannot be null or empty.");
        String logHead = "SybaseConnectionService::executeStatement - ";
        ResultSet resultSet = null;
        try {
            Statement statement = connection.createStatement();
            for (String query : sqlStatements) {
                statement.addBatch(query);
            }
            statement.executeBatch();
            resultSet = statement.getResultSet();
            logger.debug("SybaseConnectionService::executeStatement - SQL statement [" + sqlStatements + "] successfully executed.");
        }
        catch (SQLException e2) {
            String errorMessage = "Error while executing SQL statement [" + sqlStatements + "]. Reason: " + e2.getMessage();
            logger.error("SybaseConnectionService::executeStatement - " + errorMessage);
            throw new ConnectionServiceException(errorMessage);
        }
        catch (Exception e3) {
            String errorMessage = "Unexpected error while executing SQL statement [" + sqlStatements + "]. Reason: " + e3.getMessage();
            logger.error("SybaseConnectionService::executeStatement - " + errorMessage);
            throw new ConnectionServiceException(errorMessage);
        }
        return resultSet;
    }

    public static void closeConnection(Connection connection) throws ConnectionServiceException {
        String logHead = "SybaseConnectionService::closeConnection() - ";
        try {
            if (connection != null) {
                connection.close();
                logger.debug("SybaseConnectionService::closeConnection() - Released connection to the database.");
            }
        }
        catch (Exception e2) {
            String errorMessage = "Cannot release connection to the database. Reason: " + e2.getMessage();
            logger.error("SybaseConnectionService::closeConnection() - " + errorMessage);
            throw new ConnectionServiceException(errorMessage);
        }
    }

    private static boolean connectionPoolExists(String connectionPoolName) {
        return dataSources.containsKey(connectionPoolName.toLowerCase());
    }

    private static void addConnectionPool(String connectionPoolName, BasicDataSource dataSource) {
        dataSources.put(connectionPoolName.toLowerCase(), dataSource);
    }

    private static BasicDataSource getConnectionPool(String connectionPoolName) {
        return dataSources.get(connectionPoolName.toLowerCase());
    }

    private static void testStringArg(String arg, String errorMessage) throws IllegalArgumentException {
        String logHead = "SybaseConnectionService::testStringArg - ";
        if (arg == null || arg.length() <= 0) {
            logger.error("SybaseConnectionService::testStringArg - " + errorMessage);
            throw new IllegalArgumentException(errorMessage);
        }
    }

    private static void testStringListArg(List<String> arg, String errorMessage) throws IllegalArgumentException {
        String logHead = "SybaseConnectionService::testStringArg - ";
        if (arg == null) {
            logger.error("SybaseConnectionService::testStringArg - " + errorMessage);
            throw new IllegalArgumentException(errorMessage);
        }
        for (String s : arg) {
            if (s != null && s.length() > 0) continue;
            logger.error("SybaseConnectionService::testStringArg - " + errorMessage);
            throw new IllegalArgumentException(errorMessage);
        }
    }

    private static void testArg(Object arg, String errorMessage) throws IllegalArgumentException {
        String logHead = "SybaseConnectionService::testArg - ";
        if (arg == null) {
            logger.error("SybaseConnectionService::testArg - " + errorMessage);
            throw new IllegalArgumentException(errorMessage);
        }
    }
}

