// Code generated by protoc-gen-go-grpc. DO NOT EDIT.

package bundlev1

import (
	context "context"
	types "github.com/spiffe/spire-api-sdk/proto/spire/api/types"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion7

// BundleClient is the client API for Bundle service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type BundleClient interface {
	// Count bundles.
	//
	// The caller must be local or present an admin X509-SVID.
	CountBundles(ctx context.Context, in *CountBundlesRequest, opts ...grpc.CallOption) (*CountBundlesResponse, error)
	// Gets the bundle for the trust domain of the server.
	//
	// The RPC does not require authentication.
	GetBundle(ctx context.Context, in *GetBundleRequest, opts ...grpc.CallOption) (*types.Bundle, error)
	// Append to the bundle. Items specified in the bundle in the request are
	// appended to the existing bundle. If the bundle does not exist, NOT_FOUND
	// is returned. This is the only RPC that can be used to update the
	// bundle for the trust domain of the SPIRE server.
	//
	// The caller must be local or present an admin X509-SVID.
	AppendBundle(ctx context.Context, in *AppendBundleRequest, opts ...grpc.CallOption) (*types.Bundle, error)
	// Publishes a downstream JWT authority to the SPIRE server. If the server
	// is itself a downstream server (i.e. configured with an UpstreamAuthority
	// plugin), the JWT authority is published further upstream using the
	// UpstreamAuthority plugin. If the server is not a downstream server, or
	// if the UpstreamAuthority does not support publishing JWT authorities,
	// the server appends the JWT authority to its own bundle.
	//
	// The caller must present a downstream X509-SVID.
	PublishJWTAuthority(ctx context.Context, in *PublishJWTAuthorityRequest, opts ...grpc.CallOption) (*PublishJWTAuthorityResponse, error)
	// Lists federated bundles.
	//
	// The caller must be local or present an admin X509-SVID.
	ListFederatedBundles(ctx context.Context, in *ListFederatedBundlesRequest, opts ...grpc.CallOption) (*ListFederatedBundlesResponse, error)
	// Gets a federated bundle. If the bundle does not exist, NOT_FOUND is returned.
	//
	// The caller must be local or present an admin or an active agent X509-SVID.
	GetFederatedBundle(ctx context.Context, in *GetFederatedBundleRequest, opts ...grpc.CallOption) (*types.Bundle, error)
	// Batch creates one or more federated bundles.
	//
	// The caller must be local or present an admin X509-SVID.
	BatchCreateFederatedBundle(ctx context.Context, in *BatchCreateFederatedBundleRequest, opts ...grpc.CallOption) (*BatchCreateFederatedBundleResponse, error)
	// Batch updates one or more federated bundles.
	//
	// The caller must be local or present an admin X509-SVID.
	BatchUpdateFederatedBundle(ctx context.Context, in *BatchUpdateFederatedBundleRequest, opts ...grpc.CallOption) (*BatchUpdateFederatedBundleResponse, error)
	// Batch upserts one or more federated bundles.
	//
	// The caller must be local or present an admin X509-SVID.
	BatchSetFederatedBundle(ctx context.Context, in *BatchSetFederatedBundleRequest, opts ...grpc.CallOption) (*BatchSetFederatedBundleResponse, error)
	// Batch deletes one or more federated bundles.
	//
	// The caller must be local or present an admin X509-SVID.
	BatchDeleteFederatedBundle(ctx context.Context, in *BatchDeleteFederatedBundleRequest, opts ...grpc.CallOption) (*BatchDeleteFederatedBundleResponse, error)
}

type bundleClient struct {
	cc grpc.ClientConnInterface
}

func NewBundleClient(cc grpc.ClientConnInterface) BundleClient {
	return &bundleClient{cc}
}

func (c *bundleClient) CountBundles(ctx context.Context, in *CountBundlesRequest, opts ...grpc.CallOption) (*CountBundlesResponse, error) {
	out := new(CountBundlesResponse)
	err := c.cc.Invoke(ctx, "/spire.api.server.bundle.v1.Bundle/CountBundles", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bundleClient) GetBundle(ctx context.Context, in *GetBundleRequest, opts ...grpc.CallOption) (*types.Bundle, error) {
	out := new(types.Bundle)
	err := c.cc.Invoke(ctx, "/spire.api.server.bundle.v1.Bundle/GetBundle", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bundleClient) AppendBundle(ctx context.Context, in *AppendBundleRequest, opts ...grpc.CallOption) (*types.Bundle, error) {
	out := new(types.Bundle)
	err := c.cc.Invoke(ctx, "/spire.api.server.bundle.v1.Bundle/AppendBundle", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bundleClient) PublishJWTAuthority(ctx context.Context, in *PublishJWTAuthorityRequest, opts ...grpc.CallOption) (*PublishJWTAuthorityResponse, error) {
	out := new(PublishJWTAuthorityResponse)
	err := c.cc.Invoke(ctx, "/spire.api.server.bundle.v1.Bundle/PublishJWTAuthority", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bundleClient) ListFederatedBundles(ctx context.Context, in *ListFederatedBundlesRequest, opts ...grpc.CallOption) (*ListFederatedBundlesResponse, error) {
	out := new(ListFederatedBundlesResponse)
	err := c.cc.Invoke(ctx, "/spire.api.server.bundle.v1.Bundle/ListFederatedBundles", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bundleClient) GetFederatedBundle(ctx context.Context, in *GetFederatedBundleRequest, opts ...grpc.CallOption) (*types.Bundle, error) {
	out := new(types.Bundle)
	err := c.cc.Invoke(ctx, "/spire.api.server.bundle.v1.Bundle/GetFederatedBundle", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bundleClient) BatchCreateFederatedBundle(ctx context.Context, in *BatchCreateFederatedBundleRequest, opts ...grpc.CallOption) (*BatchCreateFederatedBundleResponse, error) {
	out := new(BatchCreateFederatedBundleResponse)
	err := c.cc.Invoke(ctx, "/spire.api.server.bundle.v1.Bundle/BatchCreateFederatedBundle", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bundleClient) BatchUpdateFederatedBundle(ctx context.Context, in *BatchUpdateFederatedBundleRequest, opts ...grpc.CallOption) (*BatchUpdateFederatedBundleResponse, error) {
	out := new(BatchUpdateFederatedBundleResponse)
	err := c.cc.Invoke(ctx, "/spire.api.server.bundle.v1.Bundle/BatchUpdateFederatedBundle", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bundleClient) BatchSetFederatedBundle(ctx context.Context, in *BatchSetFederatedBundleRequest, opts ...grpc.CallOption) (*BatchSetFederatedBundleResponse, error) {
	out := new(BatchSetFederatedBundleResponse)
	err := c.cc.Invoke(ctx, "/spire.api.server.bundle.v1.Bundle/BatchSetFederatedBundle", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bundleClient) BatchDeleteFederatedBundle(ctx context.Context, in *BatchDeleteFederatedBundleRequest, opts ...grpc.CallOption) (*BatchDeleteFederatedBundleResponse, error) {
	out := new(BatchDeleteFederatedBundleResponse)
	err := c.cc.Invoke(ctx, "/spire.api.server.bundle.v1.Bundle/BatchDeleteFederatedBundle", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// BundleServer is the server API for Bundle service.
// All implementations must embed UnimplementedBundleServer
// for forward compatibility
type BundleServer interface {
	// Count bundles.
	//
	// The caller must be local or present an admin X509-SVID.
	CountBundles(context.Context, *CountBundlesRequest) (*CountBundlesResponse, error)
	// Gets the bundle for the trust domain of the server.
	//
	// The RPC does not require authentication.
	GetBundle(context.Context, *GetBundleRequest) (*types.Bundle, error)
	// Append to the bundle. Items specified in the bundle in the request are
	// appended to the existing bundle. If the bundle does not exist, NOT_FOUND
	// is returned. This is the only RPC that can be used to update the
	// bundle for the trust domain of the SPIRE server.
	//
	// The caller must be local or present an admin X509-SVID.
	AppendBundle(context.Context, *AppendBundleRequest) (*types.Bundle, error)
	// Publishes a downstream JWT authority to the SPIRE server. If the server
	// is itself a downstream server (i.e. configured with an UpstreamAuthority
	// plugin), the JWT authority is published further upstream using the
	// UpstreamAuthority plugin. If the server is not a downstream server, or
	// if the UpstreamAuthority does not support publishing JWT authorities,
	// the server appends the JWT authority to its own bundle.
	//
	// The caller must present a downstream X509-SVID.
	PublishJWTAuthority(context.Context, *PublishJWTAuthorityRequest) (*PublishJWTAuthorityResponse, error)
	// Lists federated bundles.
	//
	// The caller must be local or present an admin X509-SVID.
	ListFederatedBundles(context.Context, *ListFederatedBundlesRequest) (*ListFederatedBundlesResponse, error)
	// Gets a federated bundle. If the bundle does not exist, NOT_FOUND is returned.
	//
	// The caller must be local or present an admin or an active agent X509-SVID.
	GetFederatedBundle(context.Context, *GetFederatedBundleRequest) (*types.Bundle, error)
	// Batch creates one or more federated bundles.
	//
	// The caller must be local or present an admin X509-SVID.
	BatchCreateFederatedBundle(context.Context, *BatchCreateFederatedBundleRequest) (*BatchCreateFederatedBundleResponse, error)
	// Batch updates one or more federated bundles.
	//
	// The caller must be local or present an admin X509-SVID.
	BatchUpdateFederatedBundle(context.Context, *BatchUpdateFederatedBundleRequest) (*BatchUpdateFederatedBundleResponse, error)
	// Batch upserts one or more federated bundles.
	//
	// The caller must be local or present an admin X509-SVID.
	BatchSetFederatedBundle(context.Context, *BatchSetFederatedBundleRequest) (*BatchSetFederatedBundleResponse, error)
	// Batch deletes one or more federated bundles.
	//
	// The caller must be local or present an admin X509-SVID.
	BatchDeleteFederatedBundle(context.Context, *BatchDeleteFederatedBundleRequest) (*BatchDeleteFederatedBundleResponse, error)
	mustEmbedUnimplementedBundleServer()
}

// UnimplementedBundleServer must be embedded to have forward compatible implementations.
type UnimplementedBundleServer struct {
}

func (UnimplementedBundleServer) CountBundles(context.Context, *CountBundlesRequest) (*CountBundlesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CountBundles not implemented")
}
func (UnimplementedBundleServer) GetBundle(context.Context, *GetBundleRequest) (*types.Bundle, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetBundle not implemented")
}
func (UnimplementedBundleServer) AppendBundle(context.Context, *AppendBundleRequest) (*types.Bundle, error) {
	return nil, status.Errorf(codes.Unimplemented, "method AppendBundle not implemented")
}
func (UnimplementedBundleServer) PublishJWTAuthority(context.Context, *PublishJWTAuthorityRequest) (*PublishJWTAuthorityResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method PublishJWTAuthority not implemented")
}
func (UnimplementedBundleServer) ListFederatedBundles(context.Context, *ListFederatedBundlesRequest) (*ListFederatedBundlesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListFederatedBundles not implemented")
}
func (UnimplementedBundleServer) GetFederatedBundle(context.Context, *GetFederatedBundleRequest) (*types.Bundle, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetFederatedBundle not implemented")
}
func (UnimplementedBundleServer) BatchCreateFederatedBundle(context.Context, *BatchCreateFederatedBundleRequest) (*BatchCreateFederatedBundleResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method BatchCreateFederatedBundle not implemented")
}
func (UnimplementedBundleServer) BatchUpdateFederatedBundle(context.Context, *BatchUpdateFederatedBundleRequest) (*BatchUpdateFederatedBundleResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method BatchUpdateFederatedBundle not implemented")
}
func (UnimplementedBundleServer) BatchSetFederatedBundle(context.Context, *BatchSetFederatedBundleRequest) (*BatchSetFederatedBundleResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method BatchSetFederatedBundle not implemented")
}
func (UnimplementedBundleServer) BatchDeleteFederatedBundle(context.Context, *BatchDeleteFederatedBundleRequest) (*BatchDeleteFederatedBundleResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method BatchDeleteFederatedBundle not implemented")
}
func (UnimplementedBundleServer) mustEmbedUnimplementedBundleServer() {}

// UnsafeBundleServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to BundleServer will
// result in compilation errors.
type UnsafeBundleServer interface {
	mustEmbedUnimplementedBundleServer()
}

func RegisterBundleServer(s grpc.ServiceRegistrar, srv BundleServer) {
	s.RegisterService(&_Bundle_serviceDesc, srv)
}

func _Bundle_CountBundles_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CountBundlesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BundleServer).CountBundles(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/spire.api.server.bundle.v1.Bundle/CountBundles",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BundleServer).CountBundles(ctx, req.(*CountBundlesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Bundle_GetBundle_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetBundleRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BundleServer).GetBundle(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/spire.api.server.bundle.v1.Bundle/GetBundle",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BundleServer).GetBundle(ctx, req.(*GetBundleRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Bundle_AppendBundle_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AppendBundleRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BundleServer).AppendBundle(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/spire.api.server.bundle.v1.Bundle/AppendBundle",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BundleServer).AppendBundle(ctx, req.(*AppendBundleRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Bundle_PublishJWTAuthority_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(PublishJWTAuthorityRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BundleServer).PublishJWTAuthority(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/spire.api.server.bundle.v1.Bundle/PublishJWTAuthority",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BundleServer).PublishJWTAuthority(ctx, req.(*PublishJWTAuthorityRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Bundle_ListFederatedBundles_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListFederatedBundlesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BundleServer).ListFederatedBundles(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/spire.api.server.bundle.v1.Bundle/ListFederatedBundles",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BundleServer).ListFederatedBundles(ctx, req.(*ListFederatedBundlesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Bundle_GetFederatedBundle_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetFederatedBundleRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BundleServer).GetFederatedBundle(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/spire.api.server.bundle.v1.Bundle/GetFederatedBundle",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BundleServer).GetFederatedBundle(ctx, req.(*GetFederatedBundleRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Bundle_BatchCreateFederatedBundle_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(BatchCreateFederatedBundleRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BundleServer).BatchCreateFederatedBundle(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/spire.api.server.bundle.v1.Bundle/BatchCreateFederatedBundle",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BundleServer).BatchCreateFederatedBundle(ctx, req.(*BatchCreateFederatedBundleRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Bundle_BatchUpdateFederatedBundle_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(BatchUpdateFederatedBundleRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BundleServer).BatchUpdateFederatedBundle(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/spire.api.server.bundle.v1.Bundle/BatchUpdateFederatedBundle",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BundleServer).BatchUpdateFederatedBundle(ctx, req.(*BatchUpdateFederatedBundleRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Bundle_BatchSetFederatedBundle_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(BatchSetFederatedBundleRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BundleServer).BatchSetFederatedBundle(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/spire.api.server.bundle.v1.Bundle/BatchSetFederatedBundle",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BundleServer).BatchSetFederatedBundle(ctx, req.(*BatchSetFederatedBundleRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Bundle_BatchDeleteFederatedBundle_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(BatchDeleteFederatedBundleRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BundleServer).BatchDeleteFederatedBundle(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/spire.api.server.bundle.v1.Bundle/BatchDeleteFederatedBundle",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BundleServer).BatchDeleteFederatedBundle(ctx, req.(*BatchDeleteFederatedBundleRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _Bundle_serviceDesc = grpc.ServiceDesc{
	ServiceName: "spire.api.server.bundle.v1.Bundle",
	HandlerType: (*BundleServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CountBundles",
			Handler:    _Bundle_CountBundles_Handler,
		},
		{
			MethodName: "GetBundle",
			Handler:    _Bundle_GetBundle_Handler,
		},
		{
			MethodName: "AppendBundle",
			Handler:    _Bundle_AppendBundle_Handler,
		},
		{
			MethodName: "PublishJWTAuthority",
			Handler:    _Bundle_PublishJWTAuthority_Handler,
		},
		{
			MethodName: "ListFederatedBundles",
			Handler:    _Bundle_ListFederatedBundles_Handler,
		},
		{
			MethodName: "GetFederatedBundle",
			Handler:    _Bundle_GetFederatedBundle_Handler,
		},
		{
			MethodName: "BatchCreateFederatedBundle",
			Handler:    _Bundle_BatchCreateFederatedBundle_Handler,
		},
		{
			MethodName: "BatchUpdateFederatedBundle",
			Handler:    _Bundle_BatchUpdateFederatedBundle_Handler,
		},
		{
			MethodName: "BatchSetFederatedBundle",
			Handler:    _Bundle_BatchSetFederatedBundle_Handler,
		},
		{
			MethodName: "BatchDeleteFederatedBundle",
			Handler:    _Bundle_BatchDeleteFederatedBundle_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "spire/api/server/bundle/v1/bundle.proto",
}
