// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.32.0
// 	protoc        v4.23.2
// source: google/cloud/policytroubleshooter/iam/v3/troubleshooter.proto

package iampb

import (
	context "context"
	reflect "reflect"
	sync "sync"

	iampb "cloud.google.com/go/iam/apiv1/iampb"
	iampb1 "cloud.google.com/go/iam/apiv2/iampb"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	status "google.golang.org/genproto/googleapis/rpc/status"
	expr "google.golang.org/genproto/googleapis/type/expr"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status1 "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	structpb "google.golang.org/protobuf/types/known/structpb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Whether IAM allow policies gives the principal the permission.
type AllowAccessState int32

const (
	// Not specified.
	AllowAccessState_ALLOW_ACCESS_STATE_UNSPECIFIED AllowAccessState = 0
	// The allow policy gives the principal the permission.
	AllowAccessState_ALLOW_ACCESS_STATE_GRANTED AllowAccessState = 1
	// The allow policy doesn't give the principal the permission.
	AllowAccessState_ALLOW_ACCESS_STATE_NOT_GRANTED AllowAccessState = 2
	// The allow policy gives the principal the permission if a condition
	// expression evaluate to `true`. However, the sender of the request didn't
	// provide enough context for Policy Troubleshooter to evaluate the condition
	// expression.
	AllowAccessState_ALLOW_ACCESS_STATE_UNKNOWN_CONDITIONAL AllowAccessState = 3
	// The sender of the request doesn't have access to all of the allow policies
	// that Policy Troubleshooter needs to evaluate the principal's access.
	AllowAccessState_ALLOW_ACCESS_STATE_UNKNOWN_INFO AllowAccessState = 4
)

// Enum value maps for AllowAccessState.
var (
	AllowAccessState_name = map[int32]string{
		0: "ALLOW_ACCESS_STATE_UNSPECIFIED",
		1: "ALLOW_ACCESS_STATE_GRANTED",
		2: "ALLOW_ACCESS_STATE_NOT_GRANTED",
		3: "ALLOW_ACCESS_STATE_UNKNOWN_CONDITIONAL",
		4: "ALLOW_ACCESS_STATE_UNKNOWN_INFO",
	}
	AllowAccessState_value = map[string]int32{
		"ALLOW_ACCESS_STATE_UNSPECIFIED":         0,
		"ALLOW_ACCESS_STATE_GRANTED":             1,
		"ALLOW_ACCESS_STATE_NOT_GRANTED":         2,
		"ALLOW_ACCESS_STATE_UNKNOWN_CONDITIONAL": 3,
		"ALLOW_ACCESS_STATE_UNKNOWN_INFO":        4,
	}
)

func (x AllowAccessState) Enum() *AllowAccessState {
	p := new(AllowAccessState)
	*p = x
	return p
}

func (x AllowAccessState) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (AllowAccessState) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_policytroubleshooter_iam_v3_troubleshooter_proto_enumTypes[0].Descriptor()
}

func (AllowAccessState) Type() protoreflect.EnumType {
	return &file_google_cloud_policytroubleshooter_iam_v3_troubleshooter_proto_enumTypes[0]
}

func (x AllowAccessState) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use AllowAccessState.Descriptor instead.
func (AllowAccessState) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_policytroubleshooter_iam_v3_troubleshooter_proto_rawDescGZIP(), []int{0}
}

// Whether IAM deny policies deny the principal the permission.
type DenyAccessState int32

const (
	// Not specified.
	DenyAccessState_DENY_ACCESS_STATE_UNSPECIFIED DenyAccessState = 0
	// The deny policy denies the principal the permission.
	DenyAccessState_DENY_ACCESS_STATE_DENIED DenyAccessState = 1
	// The deny policy doesn't deny the principal the permission.
	DenyAccessState_DENY_ACCESS_STATE_NOT_DENIED DenyAccessState = 2
	// The deny policy denies the principal the permission if a condition
	// expression evaluates to `true`. However, the sender of the request didn't
	// provide enough context for Policy Troubleshooter to evaluate the condition
	// expression.
	DenyAccessState_DENY_ACCESS_STATE_UNKNOWN_CONDITIONAL DenyAccessState = 3
	// The sender of the request does not have access to all of the deny policies
	// that Policy Troubleshooter needs to evaluate the principal's access.
	DenyAccessState_DENY_ACCESS_STATE_UNKNOWN_INFO DenyAccessState = 4
)

// Enum value maps for DenyAccessState.
var (
	DenyAccessState_name = map[int32]string{
		0: "DENY_ACCESS_STATE_UNSPECIFIED",
		1: "DENY_ACCESS_STATE_DENIED",
		2: "DENY_ACCESS_STATE_NOT_DENIED",
		3: "DENY_ACCESS_STATE_UNKNOWN_CONDITIONAL",
		4: "DENY_ACCESS_STATE_UNKNOWN_INFO",
	}
	DenyAccessState_value = map[string]int32{
		"DENY_ACCESS_STATE_UNSPECIFIED":         0,
		"DENY_ACCESS_STATE_DENIED":              1,
		"DENY_ACCESS_STATE_NOT_DENIED":          2,
		"DENY_ACCESS_STATE_UNKNOWN_CONDITIONAL": 3,
		"DENY_ACCESS_STATE_UNKNOWN_INFO":        4,
	}
)

func (x DenyAccessState) Enum() *DenyAccessState {
	p := new(DenyAccessState)
	*p = x
	return p
}

func (x DenyAccessState) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (DenyAccessState) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_policytroubleshooter_iam_v3_troubleshooter_proto_enumTypes[1].Descriptor()
}

func (DenyAccessState) Type() protoreflect.EnumType {
	return &file_google_cloud_policytroubleshooter_iam_v3_troubleshooter_proto_enumTypes[1]
}

func (x DenyAccessState) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use DenyAccessState.Descriptor instead.
func (DenyAccessState) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_policytroubleshooter_iam_v3_troubleshooter_proto_rawDescGZIP(), []int{1}
}

// Whether a role includes a specific permission.
type RolePermissionInclusionState int32

const (
	// Not specified.
	RolePermissionInclusionState_ROLE_PERMISSION_INCLUSION_STATE_UNSPECIFIED RolePermissionInclusionState = 0
	// The permission is included in the role.
	RolePermissionInclusionState_ROLE_PERMISSION_INCLUDED RolePermissionInclusionState = 1
	// The permission is not included in the role.
	RolePermissionInclusionState_ROLE_PERMISSION_NOT_INCLUDED RolePermissionInclusionState = 2
	// The sender of the request is not allowed to access the role definition.
	RolePermissionInclusionState_ROLE_PERMISSION_UNKNOWN_INFO RolePermissionInclusionState = 3
)

// Enum value maps for RolePermissionInclusionState.
var (
	RolePermissionInclusionState_name = map[int32]string{
		0: "ROLE_PERMISSION_INCLUSION_STATE_UNSPECIFIED",
		1: "ROLE_PERMISSION_INCLUDED",
		2: "ROLE_PERMISSION_NOT_INCLUDED",
		3: "ROLE_PERMISSION_UNKNOWN_INFO",
	}
	RolePermissionInclusionState_value = map[string]int32{
		"ROLE_PERMISSION_INCLUSION_STATE_UNSPECIFIED": 0,
		"ROLE_PERMISSION_INCLUDED":                    1,
		"ROLE_PERMISSION_NOT_INCLUDED":                2,
		"ROLE_PERMISSION_UNKNOWN_INFO":                3,
	}
)

func (x RolePermissionInclusionState) Enum() *RolePermissionInclusionState {
	p := new(RolePermissionInclusionState)
	*p = x
	return p
}

func (x RolePermissionInclusionState) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (RolePermissionInclusionState) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_policytroubleshooter_iam_v3_troubleshooter_proto_enumTypes[2].Descriptor()
}

func (RolePermissionInclusionState) Type() protoreflect.EnumType {
	return &file_google_cloud_policytroubleshooter_iam_v3_troubleshooter_proto_enumTypes[2]
}

func (x RolePermissionInclusionState) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use RolePermissionInclusionState.Descriptor instead.
func (RolePermissionInclusionState) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_policytroubleshooter_iam_v3_troubleshooter_proto_rawDescGZIP(), []int{2}
}

// Whether the permission in the request matches the permission in the policy.
type PermissionPatternMatchingState int32

const (
	// Not specified.
	PermissionPatternMatchingState_PERMISSION_PATTERN_MATCHING_STATE_UNSPECIFIED PermissionPatternMatchingState = 0
	// The permission in the request matches the permission in the policy.
	PermissionPatternMatchingState_PERMISSION_PATTERN_MATCHED PermissionPatternMatchingState = 1
	// The permission in the request matches the permission in the policy.
	PermissionPatternMatchingState_PERMISSION_PATTERN_NOT_MATCHED PermissionPatternMatchingState = 2
)

// Enum value maps for PermissionPatternMatchingState.
var (
	PermissionPatternMatchingState_name = map[int32]string{
		0: "PERMISSION_PATTERN_MATCHING_STATE_UNSPECIFIED",
		1: "PERMISSION_PATTERN_MATCHED",
		2: "PERMISSION_PATTERN_NOT_MATCHED",
	}
	PermissionPatternMatchingState_value = map[string]int32{
		"PERMISSION_PATTERN_MATCHING_STATE_UNSPECIFIED": 0,
		"PERMISSION_PATTERN_MATCHED":                    1,
		"PERMISSION_PATTERN_NOT_MATCHED":                2,
	}
)

func (x PermissionPatternMatchingState) Enum() *PermissionPatternMatchingState {
	p := new(PermissionPatternMatchingState)
	*p = x
	return p
}

func (x PermissionPatternMatchingState) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (PermissionPatternMatchingState) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_policytroubleshooter_iam_v3_troubleshooter_proto_enumTypes[3].Descriptor()
}

func (PermissionPatternMatchingState) Type() protoreflect.EnumType {
	return &file_google_cloud_policytroubleshooter_iam_v3_troubleshooter_proto_enumTypes[3]
}

func (x PermissionPatternMatchingState) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use PermissionPatternMatchingState.Descriptor instead.
func (PermissionPatternMatchingState) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_policytroubleshooter_iam_v3_troubleshooter_proto_rawDescGZIP(), []int{3}
}

// Whether the principal in the request matches the principal in the policy.
type MembershipMatchingState int32

const (
	// Not specified.
	MembershipMatchingState_MEMBERSHIP_MATCHING_STATE_UNSPECIFIED MembershipMatchingState = 0
	// The principal in the request matches the principal in the policy. The
	// principal can be included directly or indirectly:
	//
	//   - A principal is included directly if that principal is listed in the
	//     role binding.
	//   - A principal is included indirectly if that principal is in a Google
	//     group, Google Workspace account, or Cloud Identity domain that is listed
	//     in the policy.
	MembershipMatchingState_MEMBERSHIP_MATCHED MembershipMatchingState = 1
	// The principal in the request doesn't match the principal in the policy.
	MembershipMatchingState_MEMBERSHIP_NOT_MATCHED MembershipMatchingState = 2
	// The principal in the policy is a group or domain, and the sender of the
	// request doesn't have permission to view whether the principal in the
	// request is a member of the group or domain.
	MembershipMatchingState_MEMBERSHIP_UNKNOWN_INFO MembershipMatchingState = 3
	// The principal is an unsupported type.
	MembershipMatchingState_MEMBERSHIP_UNKNOWN_UNSUPPORTED MembershipMatchingState = 4
)

// Enum value maps for MembershipMatchingState.
var (
	MembershipMatchingState_name = map[int32]string{
		0: "MEMBERSHIP_MATCHING_STATE_UNSPECIFIED",
		1: "MEMBERSHIP_MATCHED",
		2: "MEMBERSHIP_NOT_MATCHED",
		3: "MEMBERSHIP_UNKNOWN_INFO",
		4: "MEMBERSHIP_UNKNOWN_UNSUPPORTED",
	}
	MembershipMatchingState_value = map[string]int32{
		"MEMBERSHIP_MATCHING_STATE_UNSPECIFIED": 0,
		"MEMBERSHIP_MATCHED":                    1,
		"MEMBERSHIP_NOT_MATCHED":                2,
		"MEMBERSHIP_UNKNOWN_INFO":               3,
		"MEMBERSHIP_UNKNOWN_UNSUPPORTED":        4,
	}
)

func (x MembershipMatchingState) Enum() *MembershipMatchingState {
	p := new(MembershipMatchingState)
	*p = x
	return p
}

func (x MembershipMatchingState) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (MembershipMatchingState) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_policytroubleshooter_iam_v3_troubleshooter_proto_enumTypes[4].Descriptor()
}

func (MembershipMatchingState) Type() protoreflect.EnumType {
	return &file_google_cloud_policytroubleshooter_iam_v3_troubleshooter_proto_enumTypes[4]
}

func (x MembershipMatchingState) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use MembershipMatchingState.Descriptor instead.
func (MembershipMatchingState) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_policytroubleshooter_iam_v3_troubleshooter_proto_rawDescGZIP(), []int{4}
}

// The extent to which a single data point contributes to an overall
// determination.
type HeuristicRelevance int32

const (
	// Not specified.
	HeuristicRelevance_HEURISTIC_RELEVANCE_UNSPECIFIED HeuristicRelevance = 0
	// The data point has a limited effect on the result. Changing the data point
	// is unlikely to affect the overall determination.
	HeuristicRelevance_HEURISTIC_RELEVANCE_NORMAL HeuristicRelevance = 1
	// The data point has a strong effect on the result. Changing the data point
	// is likely to affect the overall determination.
	HeuristicRelevance_HEURISTIC_RELEVANCE_HIGH HeuristicRelevance = 2
)

// Enum value maps for HeuristicRelevance.
var (
	HeuristicRelevance_name = map[int32]string{
		0: "HEURISTIC_RELEVANCE_UNSPECIFIED",
		1: "HEURISTIC_RELEVANCE_NORMAL",
		2: "HEURISTIC_RELEVANCE_HIGH",
	}
	HeuristicRelevance_value = map[string]int32{
		"HEURISTIC_RELEVANCE_UNSPECIFIED": 0,
		"HEURISTIC_RELEVANCE_NORMAL":      1,
		"HEURISTIC_RELEVANCE_HIGH":        2,
	}
)

func (x HeuristicRelevance) Enum() *HeuristicRelevance {
	p := new(HeuristicRelevance)
	*p = x
	return p
}

func (x HeuristicRelevance) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (HeuristicRelevance) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_policytroubleshooter_iam_v3_troubleshooter_proto_enumTypes[5].Descriptor()
}

func (HeuristicRelevance) Type() protoreflect.EnumType {
	return &file_google_cloud_policytroubleshooter_iam_v3_troubleshooter_proto_enumTypes[5]
}

func (x HeuristicRelevance) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use HeuristicRelevance.Descriptor instead.
func (HeuristicRelevance) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_policytroubleshooter_iam_v3_troubleshooter_proto_rawDescGZIP(), []int{5}
}

// Whether the principal has the permission on the resource.
type TroubleshootIamPolicyResponse_OverallAccessState int32

const (
	// Not specified.
	TroubleshootIamPolicyResponse_OVERALL_ACCESS_STATE_UNSPECIFIED TroubleshootIamPolicyResponse_OverallAccessState = 0
	// The principal has the permission.
	TroubleshootIamPolicyResponse_CAN_ACCESS TroubleshootIamPolicyResponse_OverallAccessState = 1
	// The principal doesn't have the permission.
	TroubleshootIamPolicyResponse_CANNOT_ACCESS TroubleshootIamPolicyResponse_OverallAccessState = 2
	// The principal might have the permission, but the sender can't access all
	// of the information needed to fully evaluate the principal's access.
	TroubleshootIamPolicyResponse_UNKNOWN_INFO TroubleshootIamPolicyResponse_OverallAccessState = 3
	// The principal might have the permission, but Policy Troubleshooter can't
	// fully evaluate the principal's access because the sender didn't provide
	// the required context to evaluate the condition.
	TroubleshootIamPolicyResponse_UNKNOWN_CONDITIONAL TroubleshootIamPolicyResponse_OverallAccessState = 4
)

// Enum value maps for TroubleshootIamPolicyResponse_OverallAccessState.
var (
	TroubleshootIamPolicyResponse_OverallAccessState_name = map[int32]string{
		0: "OVERALL_ACCESS_STATE_UNSPECIFIED",
		1: "CAN_ACCESS",
		2: "CANNOT_ACCESS",
		3: "UNKNOWN_INFO",
		4: "UNKNOWN_CONDITIONAL",
	}
	TroubleshootIamPolicyResponse_OverallAccessState_value = map[string]int32{
		"OVERALL_ACCESS_STATE_UNSPECIFIED": 0,
		"CAN_ACCESS":                       1,
		"CANNOT_ACCESS":                    2,
		"UNKNOWN_INFO":                     3,
		"UNKNOWN_CONDITIONAL":              4,
	}
)

func (x TroubleshootIamPolicyResponse_OverallAccessState) Enum() *TroubleshootIamPolicyResponse_OverallAccessState {
	p := new(TroubleshootIamPolicyResponse_OverallAccessState)
	*p = x
	return p
}

func (x TroubleshootIamPolicyResponse_OverallAccessState) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (TroubleshootIamPolicyResponse_OverallAccessState) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_policytroubleshooter_iam_v3_troubleshooter_proto_enumTypes[6].Descriptor()
}

func (TroubleshootIamPolicyResponse_OverallAccessState) Type() protoreflect.EnumType {
	return &file_google_cloud_policytroubleshooter_iam_v3_troubleshooter_proto_enumTypes[6]
}

func (x TroubleshootIamPolicyResponse_OverallAccessState) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use TroubleshootIamPolicyResponse_OverallAccessState.Descriptor instead.
func (TroubleshootIamPolicyResponse_OverallAccessState) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_policytroubleshooter_iam_v3_troubleshooter_proto_rawDescGZIP(), []int{1, 0}
}

// Request for
// [TroubleshootIamPolicy][google.cloud.policytroubleshooter.iam.v3.PolicyTroubleshooter.TroubleshootIamPolicy].
type TroubleshootIamPolicyRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The information to use for checking whether a principal has a permission
	// for a resource.
	AccessTuple *AccessTuple `protobuf:"bytes,1,opt,name=access_tuple,json=accessTuple,proto3" json:"access_tuple,omitempty"`
}

func (x *TroubleshootIamPolicyRequest) Reset() {
	*x = TroubleshootIamPolicyRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_policytroubleshooter_iam_v3_troubleshooter_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TroubleshootIamPolicyRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TroubleshootIamPolicyRequest) ProtoMessage() {}

func (x *TroubleshootIamPolicyRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_policytroubleshooter_iam_v3_troubleshooter_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TroubleshootIamPolicyRequest.ProtoReflect.Descriptor instead.
func (*TroubleshootIamPolicyRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_policytroubleshooter_iam_v3_troubleshooter_proto_rawDescGZIP(), []int{0}
}

func (x *TroubleshootIamPolicyRequest) GetAccessTuple() *AccessTuple {
	if x != nil {
		return x.AccessTuple
	}
	return nil
}

// Response for
// [TroubleshootIamPolicy][google.cloud.policytroubleshooter.iam.v3.PolicyTroubleshooter.TroubleshootIamPolicy].
type TroubleshootIamPolicyResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Indicates whether the principal has the specified permission for the
	// specified resource, based on evaluating all types of the applicable IAM
	// policies.
	OverallAccessState TroubleshootIamPolicyResponse_OverallAccessState `protobuf:"varint,1,opt,name=overall_access_state,json=overallAccessState,proto3,enum=google.cloud.policytroubleshooter.iam.v3.TroubleshootIamPolicyResponse_OverallAccessState" json:"overall_access_state,omitempty"`
	// The access tuple from the request, including any provided context used to
	// evaluate the condition.
	AccessTuple *AccessTuple `protobuf:"bytes,2,opt,name=access_tuple,json=accessTuple,proto3" json:"access_tuple,omitempty"`
	// An explanation of how the applicable IAM allow policies affect the final
	// access state.
	AllowPolicyExplanation *AllowPolicyExplanation `protobuf:"bytes,3,opt,name=allow_policy_explanation,json=allowPolicyExplanation,proto3" json:"allow_policy_explanation,omitempty"`
	// An explanation of how the applicable IAM deny policies affect the final
	// access state.
	DenyPolicyExplanation *DenyPolicyExplanation `protobuf:"bytes,4,opt,name=deny_policy_explanation,json=denyPolicyExplanation,proto3" json:"deny_policy_explanation,omitempty"`
}

func (x *TroubleshootIamPolicyResponse) Reset() {
	*x = TroubleshootIamPolicyResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_policytroubleshooter_iam_v3_troubleshooter_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TroubleshootIamPolicyResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TroubleshootIamPolicyResponse) ProtoMessage() {}

func (x *TroubleshootIamPolicyResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_policytroubleshooter_iam_v3_troubleshooter_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TroubleshootIamPolicyResponse.ProtoReflect.Descriptor instead.
func (*TroubleshootIamPolicyResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_policytroubleshooter_iam_v3_troubleshooter_proto_rawDescGZIP(), []int{1}
}

func (x *TroubleshootIamPolicyResponse) GetOverallAccessState() TroubleshootIamPolicyResponse_OverallAccessState {
	if x != nil {
		return x.OverallAccessState
	}
	return TroubleshootIamPolicyResponse_OVERALL_ACCESS_STATE_UNSPECIFIED
}

func (x *TroubleshootIamPolicyResponse) GetAccessTuple() *AccessTuple {
	if x != nil {
		return x.AccessTuple
	}
	return nil
}

func (x *TroubleshootIamPolicyResponse) GetAllowPolicyExplanation() *AllowPolicyExplanation {
	if x != nil {
		return x.AllowPolicyExplanation
	}
	return nil
}

func (x *TroubleshootIamPolicyResponse) GetDenyPolicyExplanation() *DenyPolicyExplanation {
	if x != nil {
		return x.DenyPolicyExplanation
	}
	return nil
}

// Information about the principal, resource, and permission to check.
type AccessTuple struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The email address of the principal whose access you want to
	// check. For example, `alice@example.com` or
	// `my-service-account@my-project.iam.gserviceaccount.com`.
	//
	// The principal must be a Google Account or a service account. Other types of
	// principals are not supported.
	Principal string `protobuf:"bytes,1,opt,name=principal,proto3" json:"principal,omitempty"`
	// Required. The full resource name that identifies the resource. For example,
	// `//compute.googleapis.com/projects/my-project/zones/us-central1-a/instances/my-instance`.
	//
	// For examples of full resource names for Google Cloud services, see
	// https://cloud.google.com/iam/help/troubleshooter/full-resource-names.
	FullResourceName string `protobuf:"bytes,2,opt,name=full_resource_name,json=fullResourceName,proto3" json:"full_resource_name,omitempty"`
	// Required. The IAM permission to check for, either in the `v1` permission
	// format or the `v2` permission format.
	//
	// For a complete list of IAM permissions in the `v1` format, see
	// https://cloud.google.com/iam/help/permissions/reference.
	//
	// For a list of IAM permissions in the `v2` format, see
	// https://cloud.google.com/iam/help/deny/supported-permissions.
	//
	// For a complete list of predefined IAM roles and the permissions in each
	// role, see https://cloud.google.com/iam/help/roles/reference.
	Permission string `protobuf:"bytes,3,opt,name=permission,proto3" json:"permission,omitempty"`
	// Output only. The permission that Policy Troubleshooter checked for, in
	// the `v2` format.
	PermissionFqdn string `protobuf:"bytes,4,opt,name=permission_fqdn,json=permissionFqdn,proto3" json:"permission_fqdn,omitempty"`
	// Optional. Additional context for the request, such as the request time or
	// IP address. This context allows Policy Troubleshooter to troubleshoot
	// conditional role bindings and deny rules.
	ConditionContext *ConditionContext `protobuf:"bytes,5,opt,name=condition_context,json=conditionContext,proto3" json:"condition_context,omitempty"`
}

func (x *AccessTuple) Reset() {
	*x = AccessTuple{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_policytroubleshooter_iam_v3_troubleshooter_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AccessTuple) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AccessTuple) ProtoMessage() {}

func (x *AccessTuple) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_policytroubleshooter_iam_v3_troubleshooter_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AccessTuple.ProtoReflect.Descriptor instead.
func (*AccessTuple) Descriptor() ([]byte, []int) {
	return file_google_cloud_policytroubleshooter_iam_v3_troubleshooter_proto_rawDescGZIP(), []int{2}
}

func (x *AccessTuple) GetPrincipal() string {
	if x != nil {
		return x.Principal
	}
	return ""
}

func (x *AccessTuple) GetFullResourceName() string {
	if x != nil {
		return x.FullResourceName
	}
	return ""
}

func (x *AccessTuple) GetPermission() string {
	if x != nil {
		return x.Permission
	}
	return ""
}

func (x *AccessTuple) GetPermissionFqdn() string {
	if x != nil {
		return x.PermissionFqdn
	}
	return ""
}

func (x *AccessTuple) GetConditionContext() *ConditionContext {
	if x != nil {
		return x.ConditionContext
	}
	return nil
}

// Additional context for troubleshooting conditional role bindings and deny
// rules.
type ConditionContext struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Represents a target resource that is involved with a network activity.
	// If multiple resources are involved with an activity, this must be the
	// primary one.
	Resource *ConditionContext_Resource `protobuf:"bytes,1,opt,name=resource,proto3" json:"resource,omitempty"`
	// The destination of a network activity, such as accepting a TCP connection.
	// In a multi-hop network activity, the destination represents the receiver of
	// the last hop.
	Destination *ConditionContext_Peer `protobuf:"bytes,2,opt,name=destination,proto3" json:"destination,omitempty"`
	// Represents a network request, such as an HTTP request.
	Request *ConditionContext_Request `protobuf:"bytes,3,opt,name=request,proto3" json:"request,omitempty"`
	// Output only. The effective tags on the resource. The effective tags are
	// fetched during troubleshooting.
	EffectiveTags []*ConditionContext_EffectiveTag `protobuf:"bytes,4,rep,name=effective_tags,json=effectiveTags,proto3" json:"effective_tags,omitempty"`
}

func (x *ConditionContext) Reset() {
	*x = ConditionContext{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_policytroubleshooter_iam_v3_troubleshooter_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ConditionContext) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ConditionContext) ProtoMessage() {}

func (x *ConditionContext) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_policytroubleshooter_iam_v3_troubleshooter_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ConditionContext.ProtoReflect.Descriptor instead.
func (*ConditionContext) Descriptor() ([]byte, []int) {
	return file_google_cloud_policytroubleshooter_iam_v3_troubleshooter_proto_rawDescGZIP(), []int{3}
}

func (x *ConditionContext) GetResource() *ConditionContext_Resource {
	if x != nil {
		return x.Resource
	}
	return nil
}

func (x *ConditionContext) GetDestination() *ConditionContext_Peer {
	if x != nil {
		return x.Destination
	}
	return nil
}

func (x *ConditionContext) GetRequest() *ConditionContext_Request {
	if x != nil {
		return x.Request
	}
	return nil
}

func (x *ConditionContext) GetEffectiveTags() []*ConditionContext_EffectiveTag {
	if x != nil {
		return x.EffectiveTags
	}
	return nil
}

// Details about how the relevant IAM allow policies affect the final access
// state.
type AllowPolicyExplanation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Indicates whether the principal has the specified permission for the
	// specified resource, based on evaluating all applicable IAM allow policies.
	AllowAccessState AllowAccessState `protobuf:"varint,1,opt,name=allow_access_state,json=allowAccessState,proto3,enum=google.cloud.policytroubleshooter.iam.v3.AllowAccessState" json:"allow_access_state,omitempty"`
	// List of IAM allow policies that were evaluated to check the principal's
	// permissions, with annotations to indicate how each policy contributed to
	// the final result.
	//
	// The list of policies includes the policy for the resource itself, as well
	// as allow policies that are inherited from higher levels of the resource
	// hierarchy, including the organization, the folder, and the project.
	//
	// To learn more about the resource hierarchy, see
	// https://cloud.google.com/iam/help/resource-hierarchy.
	ExplainedPolicies []*ExplainedAllowPolicy `protobuf:"bytes,2,rep,name=explained_policies,json=explainedPolicies,proto3" json:"explained_policies,omitempty"`
	// The relevance of the allow policy type to the overall access state.
	Relevance HeuristicRelevance `protobuf:"varint,3,opt,name=relevance,proto3,enum=google.cloud.policytroubleshooter.iam.v3.HeuristicRelevance" json:"relevance,omitempty"`
}

func (x *AllowPolicyExplanation) Reset() {
	*x = AllowPolicyExplanation{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_policytroubleshooter_iam_v3_troubleshooter_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AllowPolicyExplanation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AllowPolicyExplanation) ProtoMessage() {}

func (x *AllowPolicyExplanation) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_policytroubleshooter_iam_v3_troubleshooter_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AllowPolicyExplanation.ProtoReflect.Descriptor instead.
func (*AllowPolicyExplanation) Descriptor() ([]byte, []int) {
	return file_google_cloud_policytroubleshooter_iam_v3_troubleshooter_proto_rawDescGZIP(), []int{4}
}

func (x *AllowPolicyExplanation) GetAllowAccessState() AllowAccessState {
	if x != nil {
		return x.AllowAccessState
	}
	return AllowAccessState_ALLOW_ACCESS_STATE_UNSPECIFIED
}

func (x *AllowPolicyExplanation) GetExplainedPolicies() []*ExplainedAllowPolicy {
	if x != nil {
		return x.ExplainedPolicies
	}
	return nil
}

func (x *AllowPolicyExplanation) GetRelevance() HeuristicRelevance {
	if x != nil {
		return x.Relevance
	}
	return HeuristicRelevance_HEURISTIC_RELEVANCE_UNSPECIFIED
}

// Details about how a specific IAM allow policy contributed to the final access
// state.
type ExplainedAllowPolicy struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Indicates whether _this policy_ provides the specified permission
	// to the specified principal for the specified resource.
	//
	// This field does _not_ indicate whether the principal actually has the
	// permission for the resource. There might be another policy that overrides
	// this policy. To determine whether the principal actually has the
	// permission, use the `overall_access_state` field in the
	// [TroubleshootIamPolicyResponse][google.cloud.policytroubleshooter.iam.v3.TroubleshootIamPolicyResponse].
	AllowAccessState AllowAccessState `protobuf:"varint,1,opt,name=allow_access_state,json=allowAccessState,proto3,enum=google.cloud.policytroubleshooter.iam.v3.AllowAccessState" json:"allow_access_state,omitempty"`
	// The full resource name that identifies the resource. For example,
	// `//compute.googleapis.com/projects/my-project/zones/us-central1-a/instances/my-instance`.
	//
	// If the sender of the request does not have access to the policy, this field
	// is omitted.
	//
	// For examples of full resource names for Google Cloud services, see
	// https://cloud.google.com/iam/help/troubleshooter/full-resource-names.
	FullResourceName string `protobuf:"bytes,2,opt,name=full_resource_name,json=fullResourceName,proto3" json:"full_resource_name,omitempty"`
	// Details about how each role binding in the policy affects the principal's
	// ability, or inability, to use the permission for the resource. The order of
	// the role bindings matches the role binding order in the policy.
	//
	// If the sender of the request does not have access to the policy, this field
	// is omitted.
	BindingExplanations []*AllowBindingExplanation `protobuf:"bytes,3,rep,name=binding_explanations,json=bindingExplanations,proto3" json:"binding_explanations,omitempty"`
	// The relevance of this policy to the overall access state in the
	// [TroubleshootIamPolicyResponse][google.cloud.policytroubleshooter.iam.v3.TroubleshootIamPolicyResponse].
	//
	// If the sender of the request does not have access to the policy, this field
	// is omitted.
	Relevance HeuristicRelevance `protobuf:"varint,4,opt,name=relevance,proto3,enum=google.cloud.policytroubleshooter.iam.v3.HeuristicRelevance" json:"relevance,omitempty"`
	// The IAM allow policy attached to the resource.
	//
	// If the sender of the request does not have access to the policy, this field
	// is empty.
	Policy *iampb.Policy `protobuf:"bytes,5,opt,name=policy,proto3" json:"policy,omitempty"`
}

func (x *ExplainedAllowPolicy) Reset() {
	*x = ExplainedAllowPolicy{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_policytroubleshooter_iam_v3_troubleshooter_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ExplainedAllowPolicy) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExplainedAllowPolicy) ProtoMessage() {}

func (x *ExplainedAllowPolicy) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_policytroubleshooter_iam_v3_troubleshooter_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExplainedAllowPolicy.ProtoReflect.Descriptor instead.
func (*ExplainedAllowPolicy) Descriptor() ([]byte, []int) {
	return file_google_cloud_policytroubleshooter_iam_v3_troubleshooter_proto_rawDescGZIP(), []int{5}
}

func (x *ExplainedAllowPolicy) GetAllowAccessState() AllowAccessState {
	if x != nil {
		return x.AllowAccessState
	}
	return AllowAccessState_ALLOW_ACCESS_STATE_UNSPECIFIED
}

func (x *ExplainedAllowPolicy) GetFullResourceName() string {
	if x != nil {
		return x.FullResourceName
	}
	return ""
}

func (x *ExplainedAllowPolicy) GetBindingExplanations() []*AllowBindingExplanation {
	if x != nil {
		return x.BindingExplanations
	}
	return nil
}

func (x *ExplainedAllowPolicy) GetRelevance() HeuristicRelevance {
	if x != nil {
		return x.Relevance
	}
	return HeuristicRelevance_HEURISTIC_RELEVANCE_UNSPECIFIED
}

func (x *ExplainedAllowPolicy) GetPolicy() *iampb.Policy {
	if x != nil {
		return x.Policy
	}
	return nil
}

// Details about how a role binding in an allow policy affects a principal's
// ability to use a permission.
type AllowBindingExplanation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Indicates whether _this role binding_ gives the specified
	// permission to the specified principal on the specified resource.
	//
	// This field does _not_ indicate whether the principal actually has the
	// permission on the resource. There might be another role binding that
	// overrides this role binding. To determine whether the principal actually
	// has the permission, use the `overall_access_state` field in the
	// [TroubleshootIamPolicyResponse][google.cloud.policytroubleshooter.iam.v3.TroubleshootIamPolicyResponse].
	AllowAccessState AllowAccessState `protobuf:"varint,1,opt,name=allow_access_state,json=allowAccessState,proto3,enum=google.cloud.policytroubleshooter.iam.v3.AllowAccessState" json:"allow_access_state,omitempty"`
	// The role that this role binding grants. For example,
	// `roles/compute.admin`.
	//
	// For a complete list of predefined IAM roles, as well as the permissions in
	// each role, see https://cloud.google.com/iam/help/roles/reference.
	Role string `protobuf:"bytes,2,opt,name=role,proto3" json:"role,omitempty"`
	// Indicates whether the role granted by this role binding contains the
	// specified permission.
	RolePermission RolePermissionInclusionState `protobuf:"varint,3,opt,name=role_permission,json=rolePermission,proto3,enum=google.cloud.policytroubleshooter.iam.v3.RolePermissionInclusionState" json:"role_permission,omitempty"`
	// The relevance of the permission's existence, or nonexistence, in the role
	// to the overall determination for the entire policy.
	RolePermissionRelevance HeuristicRelevance `protobuf:"varint,4,opt,name=role_permission_relevance,json=rolePermissionRelevance,proto3,enum=google.cloud.policytroubleshooter.iam.v3.HeuristicRelevance" json:"role_permission_relevance,omitempty"`
	// The combined result of all memberships. Indicates if the principal is
	// included in any role binding, either directly or indirectly.
	CombinedMembership *AllowBindingExplanation_AnnotatedAllowMembership `protobuf:"bytes,5,opt,name=combined_membership,json=combinedMembership,proto3" json:"combined_membership,omitempty"`
	// Indicates whether each role binding includes the principal specified in the
	// request, either directly or indirectly. Each key identifies a principal in
	// the role binding, and each value indicates whether the principal in the
	// role binding includes the principal in the request.
	//
	// For example, suppose that a role binding includes the following principals:
	//
	// * `user:alice@example.com`
	// * `group:product-eng@example.com`
	//
	// You want to troubleshoot access for `user:bob@example.com`. This user is a
	// member of the group `group:product-eng@example.com`.
	//
	// For the first principal in the role binding, the key is
	// `user:alice@example.com`, and the `membership` field in the value is set to
	// `NOT_INCLUDED`.
	//
	// For the second principal in the role binding, the key is
	// `group:product-eng@example.com`, and the `membership` field in the value is
	// set to `INCLUDED`.
	Memberships map[string]*AllowBindingExplanation_AnnotatedAllowMembership `protobuf:"bytes,6,rep,name=memberships,proto3" json:"memberships,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// The relevance of this role binding to the overall determination for the
	// entire policy.
	Relevance HeuristicRelevance `protobuf:"varint,7,opt,name=relevance,proto3,enum=google.cloud.policytroubleshooter.iam.v3.HeuristicRelevance" json:"relevance,omitempty"`
	// A condition expression that specifies when the role binding grants access.
	//
	// To learn about IAM Conditions, see
	// https://cloud.google.com/iam/help/conditions/overview.
	Condition *expr.Expr `protobuf:"bytes,8,opt,name=condition,proto3" json:"condition,omitempty"`
	// Condition evaluation state for this role binding.
	ConditionExplanation *ConditionExplanation `protobuf:"bytes,9,opt,name=condition_explanation,json=conditionExplanation,proto3" json:"condition_explanation,omitempty"`
}

func (x *AllowBindingExplanation) Reset() {
	*x = AllowBindingExplanation{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_policytroubleshooter_iam_v3_troubleshooter_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AllowBindingExplanation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AllowBindingExplanation) ProtoMessage() {}

func (x *AllowBindingExplanation) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_policytroubleshooter_iam_v3_troubleshooter_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AllowBindingExplanation.ProtoReflect.Descriptor instead.
func (*AllowBindingExplanation) Descriptor() ([]byte, []int) {
	return file_google_cloud_policytroubleshooter_iam_v3_troubleshooter_proto_rawDescGZIP(), []int{6}
}

func (x *AllowBindingExplanation) GetAllowAccessState() AllowAccessState {
	if x != nil {
		return x.AllowAccessState
	}
	return AllowAccessState_ALLOW_ACCESS_STATE_UNSPECIFIED
}

func (x *AllowBindingExplanation) GetRole() string {
	if x != nil {
		return x.Role
	}
	return ""
}

func (x *AllowBindingExplanation) GetRolePermission() RolePermissionInclusionState {
	if x != nil {
		return x.RolePermission
	}
	return RolePermissionInclusionState_ROLE_PERMISSION_INCLUSION_STATE_UNSPECIFIED
}

func (x *AllowBindingExplanation) GetRolePermissionRelevance() HeuristicRelevance {
	if x != nil {
		return x.RolePermissionRelevance
	}
	return HeuristicRelevance_HEURISTIC_RELEVANCE_UNSPECIFIED
}

func (x *AllowBindingExplanation) GetCombinedMembership() *AllowBindingExplanation_AnnotatedAllowMembership {
	if x != nil {
		return x.CombinedMembership
	}
	return nil
}

func (x *AllowBindingExplanation) GetMemberships() map[string]*AllowBindingExplanation_AnnotatedAllowMembership {
	if x != nil {
		return x.Memberships
	}
	return nil
}

func (x *AllowBindingExplanation) GetRelevance() HeuristicRelevance {
	if x != nil {
		return x.Relevance
	}
	return HeuristicRelevance_HEURISTIC_RELEVANCE_UNSPECIFIED
}

func (x *AllowBindingExplanation) GetCondition() *expr.Expr {
	if x != nil {
		return x.Condition
	}
	return nil
}

func (x *AllowBindingExplanation) GetConditionExplanation() *ConditionExplanation {
	if x != nil {
		return x.ConditionExplanation
	}
	return nil
}

// Details about how the relevant IAM deny policies affect the final access
// state.
type DenyPolicyExplanation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Indicates whether the principal is denied the specified permission for
	// the specified resource, based on evaluating all applicable IAM deny
	// policies.
	DenyAccessState DenyAccessState `protobuf:"varint,1,opt,name=deny_access_state,json=denyAccessState,proto3,enum=google.cloud.policytroubleshooter.iam.v3.DenyAccessState" json:"deny_access_state,omitempty"`
	// List of resources with IAM deny policies that were evaluated to check the
	// principal's denied permissions, with annotations to indicate how each
	// policy contributed to the final result.
	//
	// The list of resources includes the policy for the resource itself, as well
	// as policies that are inherited from higher levels of the resource
	// hierarchy, including the organization, the folder, and the project. The
	// order of the resources starts from the resource and climbs up the resource
	// hierarchy.
	//
	// To learn more about the resource hierarchy, see
	// https://cloud.google.com/iam/help/resource-hierarchy.
	ExplainedResources []*ExplainedDenyResource `protobuf:"bytes,2,rep,name=explained_resources,json=explainedResources,proto3" json:"explained_resources,omitempty"`
	// The relevance of the deny policy result to the overall access state.
	Relevance HeuristicRelevance `protobuf:"varint,3,opt,name=relevance,proto3,enum=google.cloud.policytroubleshooter.iam.v3.HeuristicRelevance" json:"relevance,omitempty"`
	// Indicates whether the permission to troubleshoot is supported in deny
	// policies.
	PermissionDeniable bool `protobuf:"varint,4,opt,name=permission_deniable,json=permissionDeniable,proto3" json:"permission_deniable,omitempty"`
}

func (x *DenyPolicyExplanation) Reset() {
	*x = DenyPolicyExplanation{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_policytroubleshooter_iam_v3_troubleshooter_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DenyPolicyExplanation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DenyPolicyExplanation) ProtoMessage() {}

func (x *DenyPolicyExplanation) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_policytroubleshooter_iam_v3_troubleshooter_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DenyPolicyExplanation.ProtoReflect.Descriptor instead.
func (*DenyPolicyExplanation) Descriptor() ([]byte, []int) {
	return file_google_cloud_policytroubleshooter_iam_v3_troubleshooter_proto_rawDescGZIP(), []int{7}
}

func (x *DenyPolicyExplanation) GetDenyAccessState() DenyAccessState {
	if x != nil {
		return x.DenyAccessState
	}
	return DenyAccessState_DENY_ACCESS_STATE_UNSPECIFIED
}

func (x *DenyPolicyExplanation) GetExplainedResources() []*ExplainedDenyResource {
	if x != nil {
		return x.ExplainedResources
	}
	return nil
}

func (x *DenyPolicyExplanation) GetRelevance() HeuristicRelevance {
	if x != nil {
		return x.Relevance
	}
	return HeuristicRelevance_HEURISTIC_RELEVANCE_UNSPECIFIED
}

func (x *DenyPolicyExplanation) GetPermissionDeniable() bool {
	if x != nil {
		return x.PermissionDeniable
	}
	return false
}

// Details about how a specific resource contributed to the deny policy
// evaluation.
type ExplainedDenyResource struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Indicates whether any policies attached to _this resource_ deny
	// the specific permission to the specified principal for the specified
	// resource.
	//
	// This field does _not_ indicate whether the principal actually has the
	// permission for the resource. There might be another policy that overrides
	// this policy. To determine whether the principal actually has the
	// permission, use the `overall_access_state` field in the
	// [TroubleshootIamPolicyResponse][google.cloud.policytroubleshooter.iam.v3.TroubleshootIamPolicyResponse].
	DenyAccessState DenyAccessState `protobuf:"varint,1,opt,name=deny_access_state,json=denyAccessState,proto3,enum=google.cloud.policytroubleshooter.iam.v3.DenyAccessState" json:"deny_access_state,omitempty"`
	// The full resource name that identifies the resource. For example,
	// `//compute.googleapis.com/projects/my-project/zones/us-central1-a/instances/my-instance`.
	//
	// If the sender of the request does not have access to the policy, this field
	// is omitted.
	//
	// For examples of full resource names for Google Cloud services, see
	// https://cloud.google.com/iam/help/troubleshooter/full-resource-names.
	FullResourceName string `protobuf:"bytes,2,opt,name=full_resource_name,json=fullResourceName,proto3" json:"full_resource_name,omitempty"`
	// List of IAM deny policies that were evaluated to check the principal's
	// denied permissions, with annotations to indicate how each policy
	// contributed to the final result.
	ExplainedPolicies []*ExplainedDenyPolicy `protobuf:"bytes,3,rep,name=explained_policies,json=explainedPolicies,proto3" json:"explained_policies,omitempty"`
	// The relevance of this policy to the overall access state in the
	// [TroubleshootIamPolicyResponse][google.cloud.policytroubleshooter.iam.v3.TroubleshootIamPolicyResponse].
	//
	// If the sender of the request does not have access to the policy, this field
	// is omitted.
	Relevance HeuristicRelevance `protobuf:"varint,4,opt,name=relevance,proto3,enum=google.cloud.policytroubleshooter.iam.v3.HeuristicRelevance" json:"relevance,omitempty"`
}

func (x *ExplainedDenyResource) Reset() {
	*x = ExplainedDenyResource{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_policytroubleshooter_iam_v3_troubleshooter_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ExplainedDenyResource) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExplainedDenyResource) ProtoMessage() {}

func (x *ExplainedDenyResource) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_policytroubleshooter_iam_v3_troubleshooter_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExplainedDenyResource.ProtoReflect.Descriptor instead.
func (*ExplainedDenyResource) Descriptor() ([]byte, []int) {
	return file_google_cloud_policytroubleshooter_iam_v3_troubleshooter_proto_rawDescGZIP(), []int{8}
}

func (x *ExplainedDenyResource) GetDenyAccessState() DenyAccessState {
	if x != nil {
		return x.DenyAccessState
	}
	return DenyAccessState_DENY_ACCESS_STATE_UNSPECIFIED
}

func (x *ExplainedDenyResource) GetFullResourceName() string {
	if x != nil {
		return x.FullResourceName
	}
	return ""
}

func (x *ExplainedDenyResource) GetExplainedPolicies() []*ExplainedDenyPolicy {
	if x != nil {
		return x.ExplainedPolicies
	}
	return nil
}

func (x *ExplainedDenyResource) GetRelevance() HeuristicRelevance {
	if x != nil {
		return x.Relevance
	}
	return HeuristicRelevance_HEURISTIC_RELEVANCE_UNSPECIFIED
}

// Details about how a specific IAM deny policy [Policy][google.iam.v2.Policy]
// contributed to the access check.
type ExplainedDenyPolicy struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Indicates whether _this policy_ denies the specified permission
	// to the specified principal for the specified resource.
	//
	// This field does _not_ indicate whether the principal actually has the
	// permission for the resource. There might be another policy that overrides
	// this policy. To determine whether the principal actually has the
	// permission, use the `overall_access_state` field in the
	// [TroubleshootIamPolicyResponse][google.cloud.policytroubleshooter.iam.v3.TroubleshootIamPolicyResponse].
	DenyAccessState DenyAccessState `protobuf:"varint,1,opt,name=deny_access_state,json=denyAccessState,proto3,enum=google.cloud.policytroubleshooter.iam.v3.DenyAccessState" json:"deny_access_state,omitempty"`
	// The IAM deny policy attached to the resource.
	//
	// If the sender of the request does not have access to the policy, this field
	// is omitted.
	Policy *iampb1.Policy `protobuf:"bytes,2,opt,name=policy,proto3" json:"policy,omitempty"`
	// Details about how each rule in the policy affects the principal's inability
	// to use the permission for the resource. The order of the deny rule matches
	// the order of the rules in the deny policy.
	//
	// If the sender of the request does not have access to the policy, this field
	// is omitted.
	RuleExplanations []*DenyRuleExplanation `protobuf:"bytes,3,rep,name=rule_explanations,json=ruleExplanations,proto3" json:"rule_explanations,omitempty"`
	// The relevance of this policy to the overall access state in the
	// [TroubleshootIamPolicyResponse][google.cloud.policytroubleshooter.iam.v3.TroubleshootIamPolicyResponse].
	//
	// If the sender of the request does not have access to the policy, this field
	// is omitted.
	Relevance HeuristicRelevance `protobuf:"varint,4,opt,name=relevance,proto3,enum=google.cloud.policytroubleshooter.iam.v3.HeuristicRelevance" json:"relevance,omitempty"`
}

func (x *ExplainedDenyPolicy) Reset() {
	*x = ExplainedDenyPolicy{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_policytroubleshooter_iam_v3_troubleshooter_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ExplainedDenyPolicy) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExplainedDenyPolicy) ProtoMessage() {}

func (x *ExplainedDenyPolicy) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_policytroubleshooter_iam_v3_troubleshooter_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExplainedDenyPolicy.ProtoReflect.Descriptor instead.
func (*ExplainedDenyPolicy) Descriptor() ([]byte, []int) {
	return file_google_cloud_policytroubleshooter_iam_v3_troubleshooter_proto_rawDescGZIP(), []int{9}
}

func (x *ExplainedDenyPolicy) GetDenyAccessState() DenyAccessState {
	if x != nil {
		return x.DenyAccessState
	}
	return DenyAccessState_DENY_ACCESS_STATE_UNSPECIFIED
}

func (x *ExplainedDenyPolicy) GetPolicy() *iampb1.Policy {
	if x != nil {
		return x.Policy
	}
	return nil
}

func (x *ExplainedDenyPolicy) GetRuleExplanations() []*DenyRuleExplanation {
	if x != nil {
		return x.RuleExplanations
	}
	return nil
}

func (x *ExplainedDenyPolicy) GetRelevance() HeuristicRelevance {
	if x != nil {
		return x.Relevance
	}
	return HeuristicRelevance_HEURISTIC_RELEVANCE_UNSPECIFIED
}

// Details about how a deny rule in a deny policy affects a principal's ability
// to use a permission.
type DenyRuleExplanation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Indicates whether _this rule_ denies the specified permission to
	// the specified principal for the specified resource.
	//
	// This field does _not_ indicate whether the principal is actually denied on
	// the permission for the resource. There might be another rule that overrides
	// this rule. To determine whether the principal actually has the permission,
	// use the `overall_access_state` field in the
	// [TroubleshootIamPolicyResponse][google.cloud.policytroubleshooter.iam.v3.TroubleshootIamPolicyResponse].
	DenyAccessState DenyAccessState `protobuf:"varint,1,opt,name=deny_access_state,json=denyAccessState,proto3,enum=google.cloud.policytroubleshooter.iam.v3.DenyAccessState" json:"deny_access_state,omitempty"`
	// Indicates whether the permission in the request is listed as a denied
	// permission in the deny rule.
	CombinedDeniedPermission *DenyRuleExplanation_AnnotatedPermissionMatching `protobuf:"bytes,2,opt,name=combined_denied_permission,json=combinedDeniedPermission,proto3" json:"combined_denied_permission,omitempty"`
	// Lists all denied permissions in the deny rule and indicates whether each
	// permission matches the permission in the request.
	//
	// Each key identifies a denied permission in the rule, and each value
	// indicates whether the denied permission matches the permission in the
	// request.
	DeniedPermissions map[string]*DenyRuleExplanation_AnnotatedPermissionMatching `protobuf:"bytes,3,rep,name=denied_permissions,json=deniedPermissions,proto3" json:"denied_permissions,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Indicates whether the permission in the request is listed as an exception
	// permission in the deny rule.
	CombinedExceptionPermission *DenyRuleExplanation_AnnotatedPermissionMatching `protobuf:"bytes,4,opt,name=combined_exception_permission,json=combinedExceptionPermission,proto3" json:"combined_exception_permission,omitempty"`
	// Lists all exception permissions in the deny rule and indicates whether each
	// permission matches the permission in the request.
	//
	// Each key identifies a exception permission in the rule, and each value
	// indicates whether the exception permission matches the permission in the
	// request.
	ExceptionPermissions map[string]*DenyRuleExplanation_AnnotatedPermissionMatching `protobuf:"bytes,5,rep,name=exception_permissions,json=exceptionPermissions,proto3" json:"exception_permissions,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Indicates whether the principal is listed as a denied principal in the
	// deny rule, either directly or through membership in a principal set.
	CombinedDeniedPrincipal *DenyRuleExplanation_AnnotatedDenyPrincipalMatching `protobuf:"bytes,6,opt,name=combined_denied_principal,json=combinedDeniedPrincipal,proto3" json:"combined_denied_principal,omitempty"`
	// Lists all denied principals in the deny rule and indicates whether each
	// principal matches the principal in the request, either directly or through
	// membership in a principal set.
	//
	// Each key identifies a denied principal in the rule, and each value
	// indicates whether the denied principal matches the principal in the
	// request.
	DeniedPrincipals map[string]*DenyRuleExplanation_AnnotatedDenyPrincipalMatching `protobuf:"bytes,7,rep,name=denied_principals,json=deniedPrincipals,proto3" json:"denied_principals,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Indicates whether the principal is listed as an exception principal in the
	// deny rule, either directly or through membership in a principal set.
	CombinedExceptionPrincipal *DenyRuleExplanation_AnnotatedDenyPrincipalMatching `protobuf:"bytes,8,opt,name=combined_exception_principal,json=combinedExceptionPrincipal,proto3" json:"combined_exception_principal,omitempty"`
	// Lists all exception principals in the deny rule and indicates whether each
	// principal matches the principal in the request, either directly or through
	// membership in a principal set.
	//
	// Each key identifies a exception principal in the rule, and each value
	// indicates whether the exception principal matches the principal in the
	// request.
	ExceptionPrincipals map[string]*DenyRuleExplanation_AnnotatedDenyPrincipalMatching `protobuf:"bytes,9,rep,name=exception_principals,json=exceptionPrincipals,proto3" json:"exception_principals,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// The relevance of this role binding to the overall determination for the
	// entire policy.
	Relevance HeuristicRelevance `protobuf:"varint,10,opt,name=relevance,proto3,enum=google.cloud.policytroubleshooter.iam.v3.HeuristicRelevance" json:"relevance,omitempty"`
	// A condition expression that specifies when the deny rule denies the
	// principal access.
	//
	// To learn about IAM Conditions, see
	// https://cloud.google.com/iam/help/conditions/overview.
	Condition *expr.Expr `protobuf:"bytes,11,opt,name=condition,proto3" json:"condition,omitempty"`
	// Condition evaluation state for this role binding.
	ConditionExplanation *ConditionExplanation `protobuf:"bytes,12,opt,name=condition_explanation,json=conditionExplanation,proto3" json:"condition_explanation,omitempty"`
}

func (x *DenyRuleExplanation) Reset() {
	*x = DenyRuleExplanation{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_policytroubleshooter_iam_v3_troubleshooter_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DenyRuleExplanation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DenyRuleExplanation) ProtoMessage() {}

func (x *DenyRuleExplanation) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_policytroubleshooter_iam_v3_troubleshooter_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DenyRuleExplanation.ProtoReflect.Descriptor instead.
func (*DenyRuleExplanation) Descriptor() ([]byte, []int) {
	return file_google_cloud_policytroubleshooter_iam_v3_troubleshooter_proto_rawDescGZIP(), []int{10}
}

func (x *DenyRuleExplanation) GetDenyAccessState() DenyAccessState {
	if x != nil {
		return x.DenyAccessState
	}
	return DenyAccessState_DENY_ACCESS_STATE_UNSPECIFIED
}

func (x *DenyRuleExplanation) GetCombinedDeniedPermission() *DenyRuleExplanation_AnnotatedPermissionMatching {
	if x != nil {
		return x.CombinedDeniedPermission
	}
	return nil
}

func (x *DenyRuleExplanation) GetDeniedPermissions() map[string]*DenyRuleExplanation_AnnotatedPermissionMatching {
	if x != nil {
		return x.DeniedPermissions
	}
	return nil
}

func (x *DenyRuleExplanation) GetCombinedExceptionPermission() *DenyRuleExplanation_AnnotatedPermissionMatching {
	if x != nil {
		return x.CombinedExceptionPermission
	}
	return nil
}

func (x *DenyRuleExplanation) GetExceptionPermissions() map[string]*DenyRuleExplanation_AnnotatedPermissionMatching {
	if x != nil {
		return x.ExceptionPermissions
	}
	return nil
}

func (x *DenyRuleExplanation) GetCombinedDeniedPrincipal() *DenyRuleExplanation_AnnotatedDenyPrincipalMatching {
	if x != nil {
		return x.CombinedDeniedPrincipal
	}
	return nil
}

func (x *DenyRuleExplanation) GetDeniedPrincipals() map[string]*DenyRuleExplanation_AnnotatedDenyPrincipalMatching {
	if x != nil {
		return x.DeniedPrincipals
	}
	return nil
}

func (x *DenyRuleExplanation) GetCombinedExceptionPrincipal() *DenyRuleExplanation_AnnotatedDenyPrincipalMatching {
	if x != nil {
		return x.CombinedExceptionPrincipal
	}
	return nil
}

func (x *DenyRuleExplanation) GetExceptionPrincipals() map[string]*DenyRuleExplanation_AnnotatedDenyPrincipalMatching {
	if x != nil {
		return x.ExceptionPrincipals
	}
	return nil
}

func (x *DenyRuleExplanation) GetRelevance() HeuristicRelevance {
	if x != nil {
		return x.Relevance
	}
	return HeuristicRelevance_HEURISTIC_RELEVANCE_UNSPECIFIED
}

func (x *DenyRuleExplanation) GetCondition() *expr.Expr {
	if x != nil {
		return x.Condition
	}
	return nil
}

func (x *DenyRuleExplanation) GetConditionExplanation() *ConditionExplanation {
	if x != nil {
		return x.ConditionExplanation
	}
	return nil
}

// Explanation for how a condition affects a principal's access
type ConditionExplanation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Value of the condition.
	Value *structpb.Value `protobuf:"bytes,1,opt,name=value,proto3" json:"value,omitempty"`
	// Any errors that prevented complete evaluation of the condition expression.
	Errors []*status.Status `protobuf:"bytes,3,rep,name=errors,proto3" json:"errors,omitempty"`
	// The value of each statement of the condition expression. The value can be
	// `true`, `false`, or `null`. The value is `null` if the statement can't be
	// evaluated.
	EvaluationStates []*ConditionExplanation_EvaluationState `protobuf:"bytes,2,rep,name=evaluation_states,json=evaluationStates,proto3" json:"evaluation_states,omitempty"`
}

func (x *ConditionExplanation) Reset() {
	*x = ConditionExplanation{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_policytroubleshooter_iam_v3_troubleshooter_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ConditionExplanation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ConditionExplanation) ProtoMessage() {}

func (x *ConditionExplanation) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_policytroubleshooter_iam_v3_troubleshooter_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ConditionExplanation.ProtoReflect.Descriptor instead.
func (*ConditionExplanation) Descriptor() ([]byte, []int) {
	return file_google_cloud_policytroubleshooter_iam_v3_troubleshooter_proto_rawDescGZIP(), []int{11}
}

func (x *ConditionExplanation) GetValue() *structpb.Value {
	if x != nil {
		return x.Value
	}
	return nil
}

func (x *ConditionExplanation) GetErrors() []*status.Status {
	if x != nil {
		return x.Errors
	}
	return nil
}

func (x *ConditionExplanation) GetEvaluationStates() []*ConditionExplanation_EvaluationState {
	if x != nil {
		return x.EvaluationStates
	}
	return nil
}

// Core attributes for a resource. A resource is an
// addressable (named) entity provided by the destination service. For
// example, a Compute Engine instance.
type ConditionContext_Resource struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name of the service that this resource belongs to, such as
	// `compute.googleapis.com`. The service name might not match the DNS
	// hostname that actually serves the request.
	//
	// For a full list of resource service values, see
	// https://cloud.google.com/iam/help/conditions/resource-services
	Service string `protobuf:"bytes,1,opt,name=service,proto3" json:"service,omitempty"`
	// The stable identifier (name) of a resource on the `service`. A resource
	// can be logically identified as `//{resource.service}/{resource.name}`.
	// Unlike the resource URI, the resource name doesn't contain any protocol
	// and version information.
	//
	// For a list of full resource name formats, see
	// https://cloud.google.com/iam/help/troubleshooter/full-resource-names
	Name string `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
	// The type of the resource, in the format `{service}/{kind}`.
	//
	// For a full list of resource type values, see
	// https://cloud.google.com/iam/help/conditions/resource-types
	Type string `protobuf:"bytes,3,opt,name=type,proto3" json:"type,omitempty"`
}

func (x *ConditionContext_Resource) Reset() {
	*x = ConditionContext_Resource{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_policytroubleshooter_iam_v3_troubleshooter_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ConditionContext_Resource) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ConditionContext_Resource) ProtoMessage() {}

func (x *ConditionContext_Resource) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_policytroubleshooter_iam_v3_troubleshooter_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ConditionContext_Resource.ProtoReflect.Descriptor instead.
func (*ConditionContext_Resource) Descriptor() ([]byte, []int) {
	return file_google_cloud_policytroubleshooter_iam_v3_troubleshooter_proto_rawDescGZIP(), []int{3, 0}
}

func (x *ConditionContext_Resource) GetService() string {
	if x != nil {
		return x.Service
	}
	return ""
}

func (x *ConditionContext_Resource) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *ConditionContext_Resource) GetType() string {
	if x != nil {
		return x.Type
	}
	return ""
}

// This message defines attributes for a node that handles a network request.
// The node can be either a service or an application that sends, forwards,
// or receives the request. Service peers should fill in
// `principal` and `labels` as appropriate.
type ConditionContext_Peer struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The IPv4 or IPv6 address of the peer.
	Ip string `protobuf:"bytes,1,opt,name=ip,proto3" json:"ip,omitempty"`
	// The network port of the peer.
	Port int64 `protobuf:"varint,2,opt,name=port,proto3" json:"port,omitempty"`
}

func (x *ConditionContext_Peer) Reset() {
	*x = ConditionContext_Peer{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_policytroubleshooter_iam_v3_troubleshooter_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ConditionContext_Peer) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ConditionContext_Peer) ProtoMessage() {}

func (x *ConditionContext_Peer) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_policytroubleshooter_iam_v3_troubleshooter_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ConditionContext_Peer.ProtoReflect.Descriptor instead.
func (*ConditionContext_Peer) Descriptor() ([]byte, []int) {
	return file_google_cloud_policytroubleshooter_iam_v3_troubleshooter_proto_rawDescGZIP(), []int{3, 1}
}

func (x *ConditionContext_Peer) GetIp() string {
	if x != nil {
		return x.Ip
	}
	return ""
}

func (x *ConditionContext_Peer) GetPort() int64 {
	if x != nil {
		return x.Port
	}
	return 0
}

// This message defines attributes for an HTTP request. If the actual
// request is not an HTTP request, the runtime system should try to map
// the actual request to an equivalent HTTP request.
type ConditionContext_Request struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. The timestamp when the destination service receives the first
	// byte of the request.
	ReceiveTime *timestamppb.Timestamp `protobuf:"bytes,1,opt,name=receive_time,json=receiveTime,proto3" json:"receive_time,omitempty"`
}

func (x *ConditionContext_Request) Reset() {
	*x = ConditionContext_Request{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_policytroubleshooter_iam_v3_troubleshooter_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ConditionContext_Request) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ConditionContext_Request) ProtoMessage() {}

func (x *ConditionContext_Request) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_policytroubleshooter_iam_v3_troubleshooter_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ConditionContext_Request.ProtoReflect.Descriptor instead.
func (*ConditionContext_Request) Descriptor() ([]byte, []int) {
	return file_google_cloud_policytroubleshooter_iam_v3_troubleshooter_proto_rawDescGZIP(), []int{3, 2}
}

func (x *ConditionContext_Request) GetReceiveTime() *timestamppb.Timestamp {
	if x != nil {
		return x.ReceiveTime
	}
	return nil
}

// A tag that applies to a resource during policy evaluation. Tags can be
// either directly bound to a resource or inherited from its ancestor.
// `EffectiveTag` contains the `name` and `namespaced_name` of the tag value
// and tag key, with additional fields of `inherited` to indicate the
// inheritance status of the effective tag.
type ConditionContext_EffectiveTag struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Resource name for TagValue in the format `tagValues/456`.
	TagValue string `protobuf:"bytes,1,opt,name=tag_value,json=tagValue,proto3" json:"tag_value,omitempty"`
	// Output only. The namespaced name of the TagValue. Can be in the form
	// `{organization_id}/{tag_key_short_name}/{tag_value_short_name}` or
	// `{project_id}/{tag_key_short_name}/{tag_value_short_name}` or
	// `{project_number}/{tag_key_short_name}/{tag_value_short_name}`.
	NamespacedTagValue string `protobuf:"bytes,2,opt,name=namespaced_tag_value,json=namespacedTagValue,proto3" json:"namespaced_tag_value,omitempty"`
	// Output only. The name of the TagKey, in the format `tagKeys/{id}`, such
	// as `tagKeys/123`.
	TagKey string `protobuf:"bytes,3,opt,name=tag_key,json=tagKey,proto3" json:"tag_key,omitempty"`
	// Output only. The namespaced name of the TagKey. Can be in the form
	// `{organization_id}/{tag_key_short_name}` or
	// `{project_id}/{tag_key_short_name}` or
	// `{project_number}/{tag_key_short_name}`.
	NamespacedTagKey string `protobuf:"bytes,4,opt,name=namespaced_tag_key,json=namespacedTagKey,proto3" json:"namespaced_tag_key,omitempty"`
	// The parent name of the tag key.
	// Must be in the format `organizations/{organization_id}` or
	// `projects/{project_number}`
	TagKeyParentName string `protobuf:"bytes,6,opt,name=tag_key_parent_name,json=tagKeyParentName,proto3" json:"tag_key_parent_name,omitempty"`
	// Output only. Indicates the inheritance status of a tag value
	// attached to the given resource. If the tag value is inherited from one of
	// the resource's ancestors, inherited will be true. If false, then the tag
	// value is directly attached to the resource, inherited will be false.
	Inherited bool `protobuf:"varint,5,opt,name=inherited,proto3" json:"inherited,omitempty"`
}

func (x *ConditionContext_EffectiveTag) Reset() {
	*x = ConditionContext_EffectiveTag{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_policytroubleshooter_iam_v3_troubleshooter_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ConditionContext_EffectiveTag) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ConditionContext_EffectiveTag) ProtoMessage() {}

func (x *ConditionContext_EffectiveTag) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_policytroubleshooter_iam_v3_troubleshooter_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ConditionContext_EffectiveTag.ProtoReflect.Descriptor instead.
func (*ConditionContext_EffectiveTag) Descriptor() ([]byte, []int) {
	return file_google_cloud_policytroubleshooter_iam_v3_troubleshooter_proto_rawDescGZIP(), []int{3, 3}
}

func (x *ConditionContext_EffectiveTag) GetTagValue() string {
	if x != nil {
		return x.TagValue
	}
	return ""
}

func (x *ConditionContext_EffectiveTag) GetNamespacedTagValue() string {
	if x != nil {
		return x.NamespacedTagValue
	}
	return ""
}

func (x *ConditionContext_EffectiveTag) GetTagKey() string {
	if x != nil {
		return x.TagKey
	}
	return ""
}

func (x *ConditionContext_EffectiveTag) GetNamespacedTagKey() string {
	if x != nil {
		return x.NamespacedTagKey
	}
	return ""
}

func (x *ConditionContext_EffectiveTag) GetTagKeyParentName() string {
	if x != nil {
		return x.TagKeyParentName
	}
	return ""
}

func (x *ConditionContext_EffectiveTag) GetInherited() bool {
	if x != nil {
		return x.Inherited
	}
	return false
}

// Details about whether the role binding includes the principal.
type AllowBindingExplanation_AnnotatedAllowMembership struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Indicates whether the role binding includes the principal.
	Membership MembershipMatchingState `protobuf:"varint,1,opt,name=membership,proto3,enum=google.cloud.policytroubleshooter.iam.v3.MembershipMatchingState" json:"membership,omitempty"`
	// The relevance of the principal's status to the overall determination for
	// the role binding.
	Relevance HeuristicRelevance `protobuf:"varint,2,opt,name=relevance,proto3,enum=google.cloud.policytroubleshooter.iam.v3.HeuristicRelevance" json:"relevance,omitempty"`
}

func (x *AllowBindingExplanation_AnnotatedAllowMembership) Reset() {
	*x = AllowBindingExplanation_AnnotatedAllowMembership{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_policytroubleshooter_iam_v3_troubleshooter_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AllowBindingExplanation_AnnotatedAllowMembership) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AllowBindingExplanation_AnnotatedAllowMembership) ProtoMessage() {}

func (x *AllowBindingExplanation_AnnotatedAllowMembership) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_policytroubleshooter_iam_v3_troubleshooter_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AllowBindingExplanation_AnnotatedAllowMembership.ProtoReflect.Descriptor instead.
func (*AllowBindingExplanation_AnnotatedAllowMembership) Descriptor() ([]byte, []int) {
	return file_google_cloud_policytroubleshooter_iam_v3_troubleshooter_proto_rawDescGZIP(), []int{6, 0}
}

func (x *AllowBindingExplanation_AnnotatedAllowMembership) GetMembership() MembershipMatchingState {
	if x != nil {
		return x.Membership
	}
	return MembershipMatchingState_MEMBERSHIP_MATCHING_STATE_UNSPECIFIED
}

func (x *AllowBindingExplanation_AnnotatedAllowMembership) GetRelevance() HeuristicRelevance {
	if x != nil {
		return x.Relevance
	}
	return HeuristicRelevance_HEURISTIC_RELEVANCE_UNSPECIFIED
}

// Details about whether the permission in the request is denied by the
// deny rule.
type DenyRuleExplanation_AnnotatedPermissionMatching struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Indicates whether the permission in the request is denied by the deny
	// rule.
	PermissionMatchingState PermissionPatternMatchingState `protobuf:"varint,1,opt,name=permission_matching_state,json=permissionMatchingState,proto3,enum=google.cloud.policytroubleshooter.iam.v3.PermissionPatternMatchingState" json:"permission_matching_state,omitempty"`
	// The relevance of the permission status to the overall determination for
	// the rule.
	Relevance HeuristicRelevance `protobuf:"varint,2,opt,name=relevance,proto3,enum=google.cloud.policytroubleshooter.iam.v3.HeuristicRelevance" json:"relevance,omitempty"`
}

func (x *DenyRuleExplanation_AnnotatedPermissionMatching) Reset() {
	*x = DenyRuleExplanation_AnnotatedPermissionMatching{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_policytroubleshooter_iam_v3_troubleshooter_proto_msgTypes[18]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DenyRuleExplanation_AnnotatedPermissionMatching) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DenyRuleExplanation_AnnotatedPermissionMatching) ProtoMessage() {}

func (x *DenyRuleExplanation_AnnotatedPermissionMatching) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_policytroubleshooter_iam_v3_troubleshooter_proto_msgTypes[18]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DenyRuleExplanation_AnnotatedPermissionMatching.ProtoReflect.Descriptor instead.
func (*DenyRuleExplanation_AnnotatedPermissionMatching) Descriptor() ([]byte, []int) {
	return file_google_cloud_policytroubleshooter_iam_v3_troubleshooter_proto_rawDescGZIP(), []int{10, 0}
}

func (x *DenyRuleExplanation_AnnotatedPermissionMatching) GetPermissionMatchingState() PermissionPatternMatchingState {
	if x != nil {
		return x.PermissionMatchingState
	}
	return PermissionPatternMatchingState_PERMISSION_PATTERN_MATCHING_STATE_UNSPECIFIED
}

func (x *DenyRuleExplanation_AnnotatedPermissionMatching) GetRelevance() HeuristicRelevance {
	if x != nil {
		return x.Relevance
	}
	return HeuristicRelevance_HEURISTIC_RELEVANCE_UNSPECIFIED
}

// Details about whether the principal in the request is listed as a denied
// principal in the deny rule, either directly or through membership in a
// principal set.
type DenyRuleExplanation_AnnotatedDenyPrincipalMatching struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Indicates whether the principal is listed as a denied principal in the
	// deny rule, either directly or through membership in a principal set.
	Membership MembershipMatchingState `protobuf:"varint,1,opt,name=membership,proto3,enum=google.cloud.policytroubleshooter.iam.v3.MembershipMatchingState" json:"membership,omitempty"`
	// The relevance of the principal's status to the overall determination for
	// the role binding.
	Relevance HeuristicRelevance `protobuf:"varint,2,opt,name=relevance,proto3,enum=google.cloud.policytroubleshooter.iam.v3.HeuristicRelevance" json:"relevance,omitempty"`
}

func (x *DenyRuleExplanation_AnnotatedDenyPrincipalMatching) Reset() {
	*x = DenyRuleExplanation_AnnotatedDenyPrincipalMatching{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_policytroubleshooter_iam_v3_troubleshooter_proto_msgTypes[19]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DenyRuleExplanation_AnnotatedDenyPrincipalMatching) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DenyRuleExplanation_AnnotatedDenyPrincipalMatching) ProtoMessage() {}

func (x *DenyRuleExplanation_AnnotatedDenyPrincipalMatching) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_policytroubleshooter_iam_v3_troubleshooter_proto_msgTypes[19]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DenyRuleExplanation_AnnotatedDenyPrincipalMatching.ProtoReflect.Descriptor instead.
func (*DenyRuleExplanation_AnnotatedDenyPrincipalMatching) Descriptor() ([]byte, []int) {
	return file_google_cloud_policytroubleshooter_iam_v3_troubleshooter_proto_rawDescGZIP(), []int{10, 1}
}

func (x *DenyRuleExplanation_AnnotatedDenyPrincipalMatching) GetMembership() MembershipMatchingState {
	if x != nil {
		return x.Membership
	}
	return MembershipMatchingState_MEMBERSHIP_MATCHING_STATE_UNSPECIFIED
}

func (x *DenyRuleExplanation_AnnotatedDenyPrincipalMatching) GetRelevance() HeuristicRelevance {
	if x != nil {
		return x.Relevance
	}
	return HeuristicRelevance_HEURISTIC_RELEVANCE_UNSPECIFIED
}

// Evaluated state of a condition expression.
type ConditionExplanation_EvaluationState struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Start position of an expression in the condition, by character.
	Start int32 `protobuf:"varint,1,opt,name=start,proto3" json:"start,omitempty"`
	// End position of an expression in the condition, by character,
	// end included, for example: the end position of the first part of
	// `a==b || c==d` would be 4.
	End int32 `protobuf:"varint,2,opt,name=end,proto3" json:"end,omitempty"`
	// Value of this expression.
	Value *structpb.Value `protobuf:"bytes,3,opt,name=value,proto3" json:"value,omitempty"`
	// Any errors that prevented complete evaluation of the condition
	// expression.
	Errors []*status.Status `protobuf:"bytes,4,rep,name=errors,proto3" json:"errors,omitempty"`
}

func (x *ConditionExplanation_EvaluationState) Reset() {
	*x = ConditionExplanation_EvaluationState{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_policytroubleshooter_iam_v3_troubleshooter_proto_msgTypes[24]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ConditionExplanation_EvaluationState) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ConditionExplanation_EvaluationState) ProtoMessage() {}

func (x *ConditionExplanation_EvaluationState) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_policytroubleshooter_iam_v3_troubleshooter_proto_msgTypes[24]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ConditionExplanation_EvaluationState.ProtoReflect.Descriptor instead.
func (*ConditionExplanation_EvaluationState) Descriptor() ([]byte, []int) {
	return file_google_cloud_policytroubleshooter_iam_v3_troubleshooter_proto_rawDescGZIP(), []int{11, 0}
}

func (x *ConditionExplanation_EvaluationState) GetStart() int32 {
	if x != nil {
		return x.Start
	}
	return 0
}

func (x *ConditionExplanation_EvaluationState) GetEnd() int32 {
	if x != nil {
		return x.End
	}
	return 0
}

func (x *ConditionExplanation_EvaluationState) GetValue() *structpb.Value {
	if x != nil {
		return x.Value
	}
	return nil
}

func (x *ConditionExplanation_EvaluationState) GetErrors() []*status.Status {
	if x != nil {
		return x.Errors
	}
	return nil
}

var File_google_cloud_policytroubleshooter_iam_v3_troubleshooter_proto protoreflect.FileDescriptor

var file_google_cloud_policytroubleshooter_iam_v3_troubleshooter_proto_rawDesc = []byte{
	0x0a, 0x3d, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x70,
	0x6f, 0x6c, 0x69, 0x63, 0x79, 0x74, 0x72, 0x6f, 0x75, 0x62, 0x6c, 0x65, 0x73, 0x68, 0x6f, 0x6f,
	0x74, 0x65, 0x72, 0x2f, 0x69, 0x61, 0x6d, 0x2f, 0x76, 0x33, 0x2f, 0x74, 0x72, 0x6f, 0x75, 0x62,
	0x6c, 0x65, 0x73, 0x68, 0x6f, 0x6f, 0x74, 0x65, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12,
	0x28, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x70, 0x6f,
	0x6c, 0x69, 0x63, 0x79, 0x74, 0x72, 0x6f, 0x75, 0x62, 0x6c, 0x65, 0x73, 0x68, 0x6f, 0x6f, 0x74,
	0x65, 0x72, 0x2e, 0x69, 0x61, 0x6d, 0x2e, 0x76, 0x33, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x61, 0x70, 0x69, 0x2f, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65,
	0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x1a, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x69, 0x61, 0x6d, 0x2f, 0x76, 0x31,
	0x2f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1a, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x69, 0x61, 0x6d, 0x2f, 0x76, 0x32, 0x2f, 0x70, 0x6f, 0x6c,
	0x69, 0x63, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x73, 0x74, 0x72, 0x75, 0x63,
	0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61,
	0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x72, 0x70, 0x63, 0x2f, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x16, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x74, 0x79, 0x70, 0x65, 0x2f, 0x65,
	0x78, 0x70, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x78, 0x0a, 0x1c, 0x54, 0x72, 0x6f,
	0x75, 0x62, 0x6c, 0x65, 0x73, 0x68, 0x6f, 0x6f, 0x74, 0x49, 0x61, 0x6d, 0x50, 0x6f, 0x6c, 0x69,
	0x63, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x58, 0x0a, 0x0c, 0x61, 0x63, 0x63,
	0x65, 0x73, 0x73, 0x5f, 0x74, 0x75, 0x70, 0x6c, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x70,
	0x6f, 0x6c, 0x69, 0x63, 0x79, 0x74, 0x72, 0x6f, 0x75, 0x62, 0x6c, 0x65, 0x73, 0x68, 0x6f, 0x6f,
	0x74, 0x65, 0x72, 0x2e, 0x69, 0x61, 0x6d, 0x2e, 0x76, 0x33, 0x2e, 0x41, 0x63, 0x63, 0x65, 0x73,
	0x73, 0x54, 0x75, 0x70, 0x6c, 0x65, 0x52, 0x0b, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x54, 0x75,
	0x70, 0x6c, 0x65, 0x22, 0x88, 0x05, 0x0a, 0x1d, 0x54, 0x72, 0x6f, 0x75, 0x62, 0x6c, 0x65, 0x73,
	0x68, 0x6f, 0x6f, 0x74, 0x49, 0x61, 0x6d, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x8c, 0x01, 0x0a, 0x14, 0x6f, 0x76, 0x65, 0x72, 0x61, 0x6c,
	0x6c, 0x5f, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0e, 0x32, 0x5a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x74, 0x72, 0x6f, 0x75, 0x62, 0x6c,
	0x65, 0x73, 0x68, 0x6f, 0x6f, 0x74, 0x65, 0x72, 0x2e, 0x69, 0x61, 0x6d, 0x2e, 0x76, 0x33, 0x2e,
	0x54, 0x72, 0x6f, 0x75, 0x62, 0x6c, 0x65, 0x73, 0x68, 0x6f, 0x6f, 0x74, 0x49, 0x61, 0x6d, 0x50,
	0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x2e, 0x4f, 0x76,
	0x65, 0x72, 0x61, 0x6c, 0x6c, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x53, 0x74, 0x61, 0x74, 0x65,
	0x52, 0x12, 0x6f, 0x76, 0x65, 0x72, 0x61, 0x6c, 0x6c, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x53,
	0x74, 0x61, 0x74, 0x65, 0x12, 0x58, 0x0a, 0x0c, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x5f, 0x74,
	0x75, 0x70, 0x6c, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79,
	0x74, 0x72, 0x6f, 0x75, 0x62, 0x6c, 0x65, 0x73, 0x68, 0x6f, 0x6f, 0x74, 0x65, 0x72, 0x2e, 0x69,
	0x61, 0x6d, 0x2e, 0x76, 0x33, 0x2e, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x54, 0x75, 0x70, 0x6c,
	0x65, 0x52, 0x0b, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x54, 0x75, 0x70, 0x6c, 0x65, 0x12, 0x7a,
	0x0a, 0x18, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x5f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x5f, 0x65,
	0x78, 0x70, 0x6c, 0x61, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x40, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x74, 0x72, 0x6f, 0x75, 0x62, 0x6c, 0x65, 0x73, 0x68, 0x6f,
	0x6f, 0x74, 0x65, 0x72, 0x2e, 0x69, 0x61, 0x6d, 0x2e, 0x76, 0x33, 0x2e, 0x41, 0x6c, 0x6c, 0x6f,
	0x77, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x45, 0x78, 0x70, 0x6c, 0x61, 0x6e, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x52, 0x16, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x45,
	0x78, 0x70, 0x6c, 0x61, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x77, 0x0a, 0x17, 0x64, 0x65,
	0x6e, 0x79, 0x5f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x5f, 0x65, 0x78, 0x70, 0x6c, 0x61, 0x6e,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3f, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x70, 0x6f, 0x6c, 0x69, 0x63,
	0x79, 0x74, 0x72, 0x6f, 0x75, 0x62, 0x6c, 0x65, 0x73, 0x68, 0x6f, 0x6f, 0x74, 0x65, 0x72, 0x2e,
	0x69, 0x61, 0x6d, 0x2e, 0x76, 0x33, 0x2e, 0x44, 0x65, 0x6e, 0x79, 0x50, 0x6f, 0x6c, 0x69, 0x63,
	0x79, 0x45, 0x78, 0x70, 0x6c, 0x61, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x15, 0x64, 0x65,
	0x6e, 0x79, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x45, 0x78, 0x70, 0x6c, 0x61, 0x6e, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x22, 0x88, 0x01, 0x0a, 0x12, 0x4f, 0x76, 0x65, 0x72, 0x61, 0x6c, 0x6c, 0x41,
	0x63, 0x63, 0x65, 0x73, 0x73, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x24, 0x0a, 0x20, 0x4f, 0x56,
	0x45, 0x52, 0x41, 0x4c, 0x4c, 0x5f, 0x41, 0x43, 0x43, 0x45, 0x53, 0x53, 0x5f, 0x53, 0x54, 0x41,
	0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00,
	0x12, 0x0e, 0x0a, 0x0a, 0x43, 0x41, 0x4e, 0x5f, 0x41, 0x43, 0x43, 0x45, 0x53, 0x53, 0x10, 0x01,
	0x12, 0x11, 0x0a, 0x0d, 0x43, 0x41, 0x4e, 0x4e, 0x4f, 0x54, 0x5f, 0x41, 0x43, 0x43, 0x45, 0x53,
	0x53, 0x10, 0x02, 0x12, 0x10, 0x0a, 0x0c, 0x55, 0x4e, 0x4b, 0x4e, 0x4f, 0x57, 0x4e, 0x5f, 0x49,
	0x4e, 0x46, 0x4f, 0x10, 0x03, 0x12, 0x17, 0x0a, 0x13, 0x55, 0x4e, 0x4b, 0x4e, 0x4f, 0x57, 0x4e,
	0x5f, 0x43, 0x4f, 0x4e, 0x44, 0x49, 0x54, 0x49, 0x4f, 0x4e, 0x41, 0x4c, 0x10, 0x04, 0x22, 0xa4,
	0x02, 0x0a, 0x0b, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x54, 0x75, 0x70, 0x6c, 0x65, 0x12, 0x21,
	0x0a, 0x09, 0x70, 0x72, 0x69, 0x6e, 0x63, 0x69, 0x70, 0x61, 0x6c, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x09, 0x70, 0x72, 0x69, 0x6e, 0x63, 0x69, 0x70, 0x61,
	0x6c, 0x12, 0x31, 0x0a, 0x12, 0x66, 0x75, 0x6c, 0x6c, 0x5f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x02, 0x52, 0x10, 0x66, 0x75, 0x6c, 0x6c, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x4e, 0x61, 0x6d, 0x65, 0x12, 0x23, 0x0a, 0x0a, 0x70, 0x65, 0x72, 0x6d, 0x69, 0x73, 0x73, 0x69,
	0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x70,
	0x65, 0x72, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x2c, 0x0a, 0x0f, 0x70, 0x65, 0x72,
	0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x66, 0x71, 0x64, 0x6e, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0e, 0x70, 0x65, 0x72, 0x6d, 0x69, 0x73, 0x73,
	0x69, 0x6f, 0x6e, 0x46, 0x71, 0x64, 0x6e, 0x12, 0x6c, 0x0a, 0x11, 0x63, 0x6f, 0x6e, 0x64, 0x69,
	0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x18, 0x05, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x74, 0x72, 0x6f, 0x75, 0x62, 0x6c, 0x65, 0x73,
	0x68, 0x6f, 0x6f, 0x74, 0x65, 0x72, 0x2e, 0x69, 0x61, 0x6d, 0x2e, 0x76, 0x33, 0x2e, 0x43, 0x6f,
	0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x52, 0x10, 0x63, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f,
	0x6e, 0x74, 0x65, 0x78, 0x74, 0x22, 0xff, 0x06, 0x0a, 0x10, 0x43, 0x6f, 0x6e, 0x64, 0x69, 0x74,
	0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x12, 0x5f, 0x0a, 0x08, 0x72, 0x65,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x43, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x70, 0x6f, 0x6c, 0x69,
	0x63, 0x79, 0x74, 0x72, 0x6f, 0x75, 0x62, 0x6c, 0x65, 0x73, 0x68, 0x6f, 0x6f, 0x74, 0x65, 0x72,
	0x2e, 0x69, 0x61, 0x6d, 0x2e, 0x76, 0x33, 0x2e, 0x43, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f,
	0x6e, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x2e, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x52, 0x08, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x61, 0x0a, 0x0b, 0x64,
	0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x3f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x74, 0x72, 0x6f, 0x75, 0x62, 0x6c, 0x65, 0x73, 0x68, 0x6f,
	0x6f, 0x74, 0x65, 0x72, 0x2e, 0x69, 0x61, 0x6d, 0x2e, 0x76, 0x33, 0x2e, 0x43, 0x6f, 0x6e, 0x64,
	0x69, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x2e, 0x50, 0x65, 0x65,
	0x72, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x5c,
	0x0a, 0x07, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x42, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x70,
	0x6f, 0x6c, 0x69, 0x63, 0x79, 0x74, 0x72, 0x6f, 0x75, 0x62, 0x6c, 0x65, 0x73, 0x68, 0x6f, 0x6f,
	0x74, 0x65, 0x72, 0x2e, 0x69, 0x61, 0x6d, 0x2e, 0x76, 0x33, 0x2e, 0x43, 0x6f, 0x6e, 0x64, 0x69,
	0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x2e, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x52, 0x07, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x73, 0x0a, 0x0e,
	0x65, 0x66, 0x66, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x5f, 0x74, 0x61, 0x67, 0x73, 0x18, 0x04,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x47, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x74, 0x72, 0x6f, 0x75, 0x62, 0x6c,
	0x65, 0x73, 0x68, 0x6f, 0x6f, 0x74, 0x65, 0x72, 0x2e, 0x69, 0x61, 0x6d, 0x2e, 0x76, 0x33, 0x2e,
	0x43, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74,
	0x2e, 0x45, 0x66, 0x66, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x54, 0x61, 0x67, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x0d, 0x65, 0x66, 0x66, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x54, 0x61, 0x67,
	0x73, 0x1a, 0x4c, 0x0a, 0x08, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x18, 0x0a,
	0x07, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07,
	0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x74,
	0x79, 0x70, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x1a,
	0x2a, 0x0a, 0x04, 0x50, 0x65, 0x65, 0x72, 0x12, 0x0e, 0x0a, 0x02, 0x69, 0x70, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x02, 0x69, 0x70, 0x12, 0x12, 0x0a, 0x04, 0x70, 0x6f, 0x72, 0x74, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x03, 0x52, 0x04, 0x70, 0x6f, 0x72, 0x74, 0x1a, 0x4d, 0x0a, 0x07, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x42, 0x0a, 0x0c, 0x72, 0x65, 0x63, 0x65, 0x69, 0x76,
	0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54,
	0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b, 0x72,
	0x65, 0x63, 0x65, 0x69, 0x76, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x1a, 0x8a, 0x02, 0x0a, 0x0c, 0x45,
	0x66, 0x66, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x54, 0x61, 0x67, 0x12, 0x20, 0x0a, 0x09, 0x74,
	0x61, 0x67, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x08, 0x74, 0x61, 0x67, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x35, 0x0a,
	0x14, 0x6e, 0x61, 0x6d, 0x65, 0x73, 0x70, 0x61, 0x63, 0x65, 0x64, 0x5f, 0x74, 0x61, 0x67, 0x5f,
	0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03,
	0x52, 0x12, 0x6e, 0x61, 0x6d, 0x65, 0x73, 0x70, 0x61, 0x63, 0x65, 0x64, 0x54, 0x61, 0x67, 0x56,
	0x61, 0x6c, 0x75, 0x65, 0x12, 0x1c, 0x0a, 0x07, 0x74, 0x61, 0x67, 0x5f, 0x6b, 0x65, 0x79, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x06, 0x74, 0x61, 0x67, 0x4b,
	0x65, 0x79, 0x12, 0x31, 0x0a, 0x12, 0x6e, 0x61, 0x6d, 0x65, 0x73, 0x70, 0x61, 0x63, 0x65, 0x64,
	0x5f, 0x74, 0x61, 0x67, 0x5f, 0x6b, 0x65, 0x79, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x10, 0x6e, 0x61, 0x6d, 0x65, 0x73, 0x70, 0x61, 0x63, 0x65, 0x64, 0x54,
	0x61, 0x67, 0x4b, 0x65, 0x79, 0x12, 0x2d, 0x0a, 0x13, 0x74, 0x61, 0x67, 0x5f, 0x6b, 0x65, 0x79,
	0x5f, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x06, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x10, 0x74, 0x61, 0x67, 0x4b, 0x65, 0x79, 0x50, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x4e, 0x61, 0x6d, 0x65, 0x12, 0x21, 0x0a, 0x09, 0x69, 0x6e, 0x68, 0x65, 0x72, 0x69, 0x74, 0x65,
	0x64, 0x18, 0x05, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x09, 0x69, 0x6e,
	0x68, 0x65, 0x72, 0x69, 0x74, 0x65, 0x64, 0x22, 0xcd, 0x02, 0x0a, 0x16, 0x41, 0x6c, 0x6c, 0x6f,
	0x77, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x45, 0x78, 0x70, 0x6c, 0x61, 0x6e, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x12, 0x68, 0x0a, 0x12, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x5f, 0x61, 0x63, 0x63, 0x65,
	0x73, 0x73, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x3a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x70, 0x6f,
	0x6c, 0x69, 0x63, 0x79, 0x74, 0x72, 0x6f, 0x75, 0x62, 0x6c, 0x65, 0x73, 0x68, 0x6f, 0x6f, 0x74,
	0x65, 0x72, 0x2e, 0x69, 0x61, 0x6d, 0x2e, 0x76, 0x33, 0x2e, 0x41, 0x6c, 0x6c, 0x6f, 0x77, 0x41,
	0x63, 0x63, 0x65, 0x73, 0x73, 0x53, 0x74, 0x61, 0x74, 0x65, 0x52, 0x10, 0x61, 0x6c, 0x6c, 0x6f,
	0x77, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x6d, 0x0a, 0x12,
	0x65, 0x78, 0x70, 0x6c, 0x61, 0x69, 0x6e, 0x65, 0x64, 0x5f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x69,
	0x65, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x74, 0x72,
	0x6f, 0x75, 0x62, 0x6c, 0x65, 0x73, 0x68, 0x6f, 0x6f, 0x74, 0x65, 0x72, 0x2e, 0x69, 0x61, 0x6d,
	0x2e, 0x76, 0x33, 0x2e, 0x45, 0x78, 0x70, 0x6c, 0x61, 0x69, 0x6e, 0x65, 0x64, 0x41, 0x6c, 0x6c,
	0x6f, 0x77, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x11, 0x65, 0x78, 0x70, 0x6c, 0x61, 0x69,
	0x6e, 0x65, 0x64, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x69, 0x65, 0x73, 0x12, 0x5a, 0x0a, 0x09, 0x72,
	0x65, 0x6c, 0x65, 0x76, 0x61, 0x6e, 0x63, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x3c,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x70, 0x6f,
	0x6c, 0x69, 0x63, 0x79, 0x74, 0x72, 0x6f, 0x75, 0x62, 0x6c, 0x65, 0x73, 0x68, 0x6f, 0x6f, 0x74,
	0x65, 0x72, 0x2e, 0x69, 0x61, 0x6d, 0x2e, 0x76, 0x33, 0x2e, 0x48, 0x65, 0x75, 0x72, 0x69, 0x73,
	0x74, 0x69, 0x63, 0x52, 0x65, 0x6c, 0x65, 0x76, 0x61, 0x6e, 0x63, 0x65, 0x52, 0x09, 0x72, 0x65,
	0x6c, 0x65, 0x76, 0x61, 0x6e, 0x63, 0x65, 0x22, 0xb4, 0x03, 0x0a, 0x14, 0x45, 0x78, 0x70, 0x6c,
	0x61, 0x69, 0x6e, 0x65, 0x64, 0x41, 0x6c, 0x6c, 0x6f, 0x77, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79,
	0x12, 0x6d, 0x0a, 0x12, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x5f, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73,
	0x5f, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x3a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x70, 0x6f, 0x6c, 0x69,
	0x63, 0x79, 0x74, 0x72, 0x6f, 0x75, 0x62, 0x6c, 0x65, 0x73, 0x68, 0x6f, 0x6f, 0x74, 0x65, 0x72,
	0x2e, 0x69, 0x61, 0x6d, 0x2e, 0x76, 0x33, 0x2e, 0x41, 0x6c, 0x6c, 0x6f, 0x77, 0x41, 0x63, 0x63,
	0x65, 0x73, 0x73, 0x53, 0x74, 0x61, 0x74, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x10, 0x61,
	0x6c, 0x6c, 0x6f, 0x77, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12,
	0x2c, 0x0a, 0x12, 0x66, 0x75, 0x6c, 0x6c, 0x5f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x10, 0x66, 0x75, 0x6c,
	0x6c, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x74, 0x0a,
	0x14, 0x62, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x5f, 0x65, 0x78, 0x70, 0x6c, 0x61, 0x6e, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x41, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x70, 0x6f, 0x6c, 0x69, 0x63,
	0x79, 0x74, 0x72, 0x6f, 0x75, 0x62, 0x6c, 0x65, 0x73, 0x68, 0x6f, 0x6f, 0x74, 0x65, 0x72, 0x2e,
	0x69, 0x61, 0x6d, 0x2e, 0x76, 0x33, 0x2e, 0x41, 0x6c, 0x6c, 0x6f, 0x77, 0x42, 0x69, 0x6e, 0x64,
	0x69, 0x6e, 0x67, 0x45, 0x78, 0x70, 0x6c, 0x61, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x13,
	0x62, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x45, 0x78, 0x70, 0x6c, 0x61, 0x6e, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x12, 0x5a, 0x0a, 0x09, 0x72, 0x65, 0x6c, 0x65, 0x76, 0x61, 0x6e, 0x63, 0x65,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x74, 0x72, 0x6f, 0x75,
	0x62, 0x6c, 0x65, 0x73, 0x68, 0x6f, 0x6f, 0x74, 0x65, 0x72, 0x2e, 0x69, 0x61, 0x6d, 0x2e, 0x76,
	0x33, 0x2e, 0x48, 0x65, 0x75, 0x72, 0x69, 0x73, 0x74, 0x69, 0x63, 0x52, 0x65, 0x6c, 0x65, 0x76,
	0x61, 0x6e, 0x63, 0x65, 0x52, 0x09, 0x72, 0x65, 0x6c, 0x65, 0x76, 0x61, 0x6e, 0x63, 0x65, 0x12,
	0x2d, 0x0a, 0x06, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x15, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x69, 0x61, 0x6d, 0x2e, 0x76, 0x31, 0x2e,
	0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x06, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x22, 0x86,
	0x0a, 0x0a, 0x17, 0x41, 0x6c, 0x6c, 0x6f, 0x77, 0x42, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x45,
	0x78, 0x70, 0x6c, 0x61, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x6d, 0x0a, 0x12, 0x61, 0x6c,
	0x6c, 0x6f, 0x77, 0x5f, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x74, 0x72, 0x6f, 0x75,
	0x62, 0x6c, 0x65, 0x73, 0x68, 0x6f, 0x6f, 0x74, 0x65, 0x72, 0x2e, 0x69, 0x61, 0x6d, 0x2e, 0x76,
	0x33, 0x2e, 0x41, 0x6c, 0x6c, 0x6f, 0x77, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x53, 0x74, 0x61,
	0x74, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x10, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x41, 0x63,
	0x63, 0x65, 0x73, 0x73, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x72, 0x6f, 0x6c,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x72, 0x6f, 0x6c, 0x65, 0x12, 0x6f, 0x0a,
	0x0f, 0x72, 0x6f, 0x6c, 0x65, 0x5f, 0x70, 0x65, 0x72, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x46, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x74, 0x72, 0x6f, 0x75,
	0x62, 0x6c, 0x65, 0x73, 0x68, 0x6f, 0x6f, 0x74, 0x65, 0x72, 0x2e, 0x69, 0x61, 0x6d, 0x2e, 0x76,
	0x33, 0x2e, 0x52, 0x6f, 0x6c, 0x65, 0x50, 0x65, 0x72, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e,
	0x49, 0x6e, 0x63, 0x6c, 0x75, 0x73, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x52, 0x0e,
	0x72, 0x6f, 0x6c, 0x65, 0x50, 0x65, 0x72, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x78,
	0x0a, 0x19, 0x72, 0x6f, 0x6c, 0x65, 0x5f, 0x70, 0x65, 0x72, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f,
	0x6e, 0x5f, 0x72, 0x65, 0x6c, 0x65, 0x76, 0x61, 0x6e, 0x63, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x0e, 0x32, 0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x74, 0x72, 0x6f, 0x75, 0x62, 0x6c, 0x65, 0x73, 0x68,
	0x6f, 0x6f, 0x74, 0x65, 0x72, 0x2e, 0x69, 0x61, 0x6d, 0x2e, 0x76, 0x33, 0x2e, 0x48, 0x65, 0x75,
	0x72, 0x69, 0x73, 0x74, 0x69, 0x63, 0x52, 0x65, 0x6c, 0x65, 0x76, 0x61, 0x6e, 0x63, 0x65, 0x52,
	0x17, 0x72, 0x6f, 0x6c, 0x65, 0x50, 0x65, 0x72, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x52,
	0x65, 0x6c, 0x65, 0x76, 0x61, 0x6e, 0x63, 0x65, 0x12, 0x8b, 0x01, 0x0a, 0x13, 0x63, 0x6f, 0x6d,
	0x62, 0x69, 0x6e, 0x65, 0x64, 0x5f, 0x6d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x73, 0x68, 0x69, 0x70,
	0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x5a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x74, 0x72, 0x6f, 0x75,
	0x62, 0x6c, 0x65, 0x73, 0x68, 0x6f, 0x6f, 0x74, 0x65, 0x72, 0x2e, 0x69, 0x61, 0x6d, 0x2e, 0x76,
	0x33, 0x2e, 0x41, 0x6c, 0x6c, 0x6f, 0x77, 0x42, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x45, 0x78,
	0x70, 0x6c, 0x61, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61,
	0x74, 0x65, 0x64, 0x41, 0x6c, 0x6c, 0x6f, 0x77, 0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x73, 0x68,
	0x69, 0x70, 0x52, 0x12, 0x63, 0x6f, 0x6d, 0x62, 0x69, 0x6e, 0x65, 0x64, 0x4d, 0x65, 0x6d, 0x62,
	0x65, 0x72, 0x73, 0x68, 0x69, 0x70, 0x12, 0x74, 0x0a, 0x0b, 0x6d, 0x65, 0x6d, 0x62, 0x65, 0x72,
	0x73, 0x68, 0x69, 0x70, 0x73, 0x18, 0x06, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x52, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x70, 0x6f, 0x6c, 0x69, 0x63,
	0x79, 0x74, 0x72, 0x6f, 0x75, 0x62, 0x6c, 0x65, 0x73, 0x68, 0x6f, 0x6f, 0x74, 0x65, 0x72, 0x2e,
	0x69, 0x61, 0x6d, 0x2e, 0x76, 0x33, 0x2e, 0x41, 0x6c, 0x6c, 0x6f, 0x77, 0x42, 0x69, 0x6e, 0x64,
	0x69, 0x6e, 0x67, 0x45, 0x78, 0x70, 0x6c, 0x61, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x4d,
	0x65, 0x6d, 0x62, 0x65, 0x72, 0x73, 0x68, 0x69, 0x70, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52,
	0x0b, 0x6d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x73, 0x68, 0x69, 0x70, 0x73, 0x12, 0x5a, 0x0a, 0x09,
	0x72, 0x65, 0x6c, 0x65, 0x76, 0x61, 0x6e, 0x63, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0e, 0x32,
	0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x70,
	0x6f, 0x6c, 0x69, 0x63, 0x79, 0x74, 0x72, 0x6f, 0x75, 0x62, 0x6c, 0x65, 0x73, 0x68, 0x6f, 0x6f,
	0x74, 0x65, 0x72, 0x2e, 0x69, 0x61, 0x6d, 0x2e, 0x76, 0x33, 0x2e, 0x48, 0x65, 0x75, 0x72, 0x69,
	0x73, 0x74, 0x69, 0x63, 0x52, 0x65, 0x6c, 0x65, 0x76, 0x61, 0x6e, 0x63, 0x65, 0x52, 0x09, 0x72,
	0x65, 0x6c, 0x65, 0x76, 0x61, 0x6e, 0x63, 0x65, 0x12, 0x2f, 0x0a, 0x09, 0x63, 0x6f, 0x6e, 0x64,
	0x69, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x11, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x74, 0x79, 0x70, 0x65, 0x2e, 0x45, 0x78, 0x70, 0x72, 0x52, 0x09,
	0x63, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x73, 0x0a, 0x15, 0x63, 0x6f, 0x6e,
	0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x65, 0x78, 0x70, 0x6c, 0x61, 0x6e, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x74, 0x72,
	0x6f, 0x75, 0x62, 0x6c, 0x65, 0x73, 0x68, 0x6f, 0x6f, 0x74, 0x65, 0x72, 0x2e, 0x69, 0x61, 0x6d,
	0x2e, 0x76, 0x33, 0x2e, 0x43, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x45, 0x78, 0x70,
	0x6c, 0x61, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x14, 0x63, 0x6f, 0x6e, 0x64, 0x69, 0x74,
	0x69, 0x6f, 0x6e, 0x45, 0x78, 0x70, 0x6c, 0x61, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x1a, 0xd9,
	0x01, 0x0a, 0x18, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x65, 0x64, 0x41, 0x6c, 0x6c, 0x6f,
	0x77, 0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x73, 0x68, 0x69, 0x70, 0x12, 0x61, 0x0a, 0x0a, 0x6d,
	0x65, 0x6d, 0x62, 0x65, 0x72, 0x73, 0x68, 0x69, 0x70, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32,
	0x41, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x70,
	0x6f, 0x6c, 0x69, 0x63, 0x79, 0x74, 0x72, 0x6f, 0x75, 0x62, 0x6c, 0x65, 0x73, 0x68, 0x6f, 0x6f,
	0x74, 0x65, 0x72, 0x2e, 0x69, 0x61, 0x6d, 0x2e, 0x76, 0x33, 0x2e, 0x4d, 0x65, 0x6d, 0x62, 0x65,
	0x72, 0x73, 0x68, 0x69, 0x70, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x69, 0x6e, 0x67, 0x53, 0x74, 0x61,
	0x74, 0x65, 0x52, 0x0a, 0x6d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x73, 0x68, 0x69, 0x70, 0x12, 0x5a,
	0x0a, 0x09, 0x72, 0x65, 0x6c, 0x65, 0x76, 0x61, 0x6e, 0x63, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0e, 0x32, 0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x74, 0x72, 0x6f, 0x75, 0x62, 0x6c, 0x65, 0x73, 0x68,
	0x6f, 0x6f, 0x74, 0x65, 0x72, 0x2e, 0x69, 0x61, 0x6d, 0x2e, 0x76, 0x33, 0x2e, 0x48, 0x65, 0x75,
	0x72, 0x69, 0x73, 0x74, 0x69, 0x63, 0x52, 0x65, 0x6c, 0x65, 0x76, 0x61, 0x6e, 0x63, 0x65, 0x52,
	0x09, 0x72, 0x65, 0x6c, 0x65, 0x76, 0x61, 0x6e, 0x63, 0x65, 0x1a, 0x9a, 0x01, 0x0a, 0x10, 0x4d,
	0x65, 0x6d, 0x62, 0x65, 0x72, 0x73, 0x68, 0x69, 0x70, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12,
	0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65,
	0x79, 0x12, 0x70, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x5a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x74, 0x72, 0x6f, 0x75, 0x62, 0x6c, 0x65, 0x73, 0x68, 0x6f,
	0x6f, 0x74, 0x65, 0x72, 0x2e, 0x69, 0x61, 0x6d, 0x2e, 0x76, 0x33, 0x2e, 0x41, 0x6c, 0x6c, 0x6f,
	0x77, 0x42, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x45, 0x78, 0x70, 0x6c, 0x61, 0x6e, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x2e, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x65, 0x64, 0x41, 0x6c, 0x6c,
	0x6f, 0x77, 0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x73, 0x68, 0x69, 0x70, 0x52, 0x05, 0x76, 0x61,
	0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0xfd, 0x02, 0x0a, 0x15, 0x44, 0x65, 0x6e, 0x79,
	0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x45, 0x78, 0x70, 0x6c, 0x61, 0x6e, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x12, 0x65, 0x0a, 0x11, 0x64, 0x65, 0x6e, 0x79, 0x5f, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73,
	0x5f, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x39, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x70, 0x6f, 0x6c, 0x69,
	0x63, 0x79, 0x74, 0x72, 0x6f, 0x75, 0x62, 0x6c, 0x65, 0x73, 0x68, 0x6f, 0x6f, 0x74, 0x65, 0x72,
	0x2e, 0x69, 0x61, 0x6d, 0x2e, 0x76, 0x33, 0x2e, 0x44, 0x65, 0x6e, 0x79, 0x41, 0x63, 0x63, 0x65,
	0x73, 0x73, 0x53, 0x74, 0x61, 0x74, 0x65, 0x52, 0x0f, 0x64, 0x65, 0x6e, 0x79, 0x41, 0x63, 0x63,
	0x65, 0x73, 0x73, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x70, 0x0a, 0x13, 0x65, 0x78, 0x70, 0x6c,
	0x61, 0x69, 0x6e, 0x65, 0x64, 0x5f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x18,
	0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x74, 0x72, 0x6f, 0x75, 0x62,
	0x6c, 0x65, 0x73, 0x68, 0x6f, 0x6f, 0x74, 0x65, 0x72, 0x2e, 0x69, 0x61, 0x6d, 0x2e, 0x76, 0x33,
	0x2e, 0x45, 0x78, 0x70, 0x6c, 0x61, 0x69, 0x6e, 0x65, 0x64, 0x44, 0x65, 0x6e, 0x79, 0x52, 0x65,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x52, 0x12, 0x65, 0x78, 0x70, 0x6c, 0x61, 0x69, 0x6e, 0x65,
	0x64, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x12, 0x5a, 0x0a, 0x09, 0x72, 0x65,
	0x6c, 0x65, 0x76, 0x61, 0x6e, 0x63, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x3c, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x70, 0x6f, 0x6c,
	0x69, 0x63, 0x79, 0x74, 0x72, 0x6f, 0x75, 0x62, 0x6c, 0x65, 0x73, 0x68, 0x6f, 0x6f, 0x74, 0x65,
	0x72, 0x2e, 0x69, 0x61, 0x6d, 0x2e, 0x76, 0x33, 0x2e, 0x48, 0x65, 0x75, 0x72, 0x69, 0x73, 0x74,
	0x69, 0x63, 0x52, 0x65, 0x6c, 0x65, 0x76, 0x61, 0x6e, 0x63, 0x65, 0x52, 0x09, 0x72, 0x65, 0x6c,
	0x65, 0x76, 0x61, 0x6e, 0x63, 0x65, 0x12, 0x2f, 0x0a, 0x13, 0x70, 0x65, 0x72, 0x6d, 0x69, 0x73,
	0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x64, 0x65, 0x6e, 0x69, 0x61, 0x62, 0x6c, 0x65, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x08, 0x52, 0x12, 0x70, 0x65, 0x72, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x44,
	0x65, 0x6e, 0x69, 0x61, 0x62, 0x6c, 0x65, 0x22, 0xfb, 0x02, 0x0a, 0x15, 0x45, 0x78, 0x70, 0x6c,
	0x61, 0x69, 0x6e, 0x65, 0x64, 0x44, 0x65, 0x6e, 0x79, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x12, 0x6a, 0x0a, 0x11, 0x64, 0x65, 0x6e, 0x79, 0x5f, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73,
	0x5f, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x39, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x70, 0x6f, 0x6c, 0x69,
	0x63, 0x79, 0x74, 0x72, 0x6f, 0x75, 0x62, 0x6c, 0x65, 0x73, 0x68, 0x6f, 0x6f, 0x74, 0x65, 0x72,
	0x2e, 0x69, 0x61, 0x6d, 0x2e, 0x76, 0x33, 0x2e, 0x44, 0x65, 0x6e, 0x79, 0x41, 0x63, 0x63, 0x65,
	0x73, 0x73, 0x53, 0x74, 0x61, 0x74, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0f, 0x64, 0x65,
	0x6e, 0x79, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x2c, 0x0a,
	0x12, 0x66, 0x75, 0x6c, 0x6c, 0x5f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x10, 0x66, 0x75, 0x6c, 0x6c, 0x52,
	0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x6c, 0x0a, 0x12, 0x65,
	0x78, 0x70, 0x6c, 0x61, 0x69, 0x6e, 0x65, 0x64, 0x5f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x69, 0x65,
	0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x74, 0x72, 0x6f,
	0x75, 0x62, 0x6c, 0x65, 0x73, 0x68, 0x6f, 0x6f, 0x74, 0x65, 0x72, 0x2e, 0x69, 0x61, 0x6d, 0x2e,
	0x76, 0x33, 0x2e, 0x45, 0x78, 0x70, 0x6c, 0x61, 0x69, 0x6e, 0x65, 0x64, 0x44, 0x65, 0x6e, 0x79,
	0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x11, 0x65, 0x78, 0x70, 0x6c, 0x61, 0x69, 0x6e, 0x65,
	0x64, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x69, 0x65, 0x73, 0x12, 0x5a, 0x0a, 0x09, 0x72, 0x65, 0x6c,
	0x65, 0x76, 0x61, 0x6e, 0x63, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x3c, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x70, 0x6f, 0x6c, 0x69,
	0x63, 0x79, 0x74, 0x72, 0x6f, 0x75, 0x62, 0x6c, 0x65, 0x73, 0x68, 0x6f, 0x6f, 0x74, 0x65, 0x72,
	0x2e, 0x69, 0x61, 0x6d, 0x2e, 0x76, 0x33, 0x2e, 0x48, 0x65, 0x75, 0x72, 0x69, 0x73, 0x74, 0x69,
	0x63, 0x52, 0x65, 0x6c, 0x65, 0x76, 0x61, 0x6e, 0x63, 0x65, 0x52, 0x09, 0x72, 0x65, 0x6c, 0x65,
	0x76, 0x61, 0x6e, 0x63, 0x65, 0x22, 0xf8, 0x02, 0x0a, 0x13, 0x45, 0x78, 0x70, 0x6c, 0x61, 0x69,
	0x6e, 0x65, 0x64, 0x44, 0x65, 0x6e, 0x79, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12, 0x6a, 0x0a,
	0x11, 0x64, 0x65, 0x6e, 0x79, 0x5f, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x5f, 0x73, 0x74, 0x61,
	0x74, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x74, 0x72,
	0x6f, 0x75, 0x62, 0x6c, 0x65, 0x73, 0x68, 0x6f, 0x6f, 0x74, 0x65, 0x72, 0x2e, 0x69, 0x61, 0x6d,
	0x2e, 0x76, 0x33, 0x2e, 0x44, 0x65, 0x6e, 0x79, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x53, 0x74,
	0x61, 0x74, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0f, 0x64, 0x65, 0x6e, 0x79, 0x41, 0x63,
	0x63, 0x65, 0x73, 0x73, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x2d, 0x0a, 0x06, 0x70, 0x6f, 0x6c,
	0x69, 0x63, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x15, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x69, 0x61, 0x6d, 0x2e, 0x76, 0x32, 0x2e, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79,
	0x52, 0x06, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12, 0x6a, 0x0a, 0x11, 0x72, 0x75, 0x6c, 0x65,
	0x5f, 0x65, 0x78, 0x70, 0x6c, 0x61, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x03, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x74, 0x72, 0x6f, 0x75, 0x62, 0x6c, 0x65,
	0x73, 0x68, 0x6f, 0x6f, 0x74, 0x65, 0x72, 0x2e, 0x69, 0x61, 0x6d, 0x2e, 0x76, 0x33, 0x2e, 0x44,
	0x65, 0x6e, 0x79, 0x52, 0x75, 0x6c, 0x65, 0x45, 0x78, 0x70, 0x6c, 0x61, 0x6e, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x52, 0x10, 0x72, 0x75, 0x6c, 0x65, 0x45, 0x78, 0x70, 0x6c, 0x61, 0x6e, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x12, 0x5a, 0x0a, 0x09, 0x72, 0x65, 0x6c, 0x65, 0x76, 0x61, 0x6e, 0x63,
	0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x74, 0x72, 0x6f,
	0x75, 0x62, 0x6c, 0x65, 0x73, 0x68, 0x6f, 0x6f, 0x74, 0x65, 0x72, 0x2e, 0x69, 0x61, 0x6d, 0x2e,
	0x76, 0x33, 0x2e, 0x48, 0x65, 0x75, 0x72, 0x69, 0x73, 0x74, 0x69, 0x63, 0x52, 0x65, 0x6c, 0x65,
	0x76, 0x61, 0x6e, 0x63, 0x65, 0x52, 0x09, 0x72, 0x65, 0x6c, 0x65, 0x76, 0x61, 0x6e, 0x63, 0x65,
	0x22, 0x94, 0x15, 0x0a, 0x13, 0x44, 0x65, 0x6e, 0x79, 0x52, 0x75, 0x6c, 0x65, 0x45, 0x78, 0x70,
	0x6c, 0x61, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x6a, 0x0a, 0x11, 0x64, 0x65, 0x6e, 0x79,
	0x5f, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0e, 0x32, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x74, 0x72, 0x6f, 0x75, 0x62, 0x6c, 0x65,
	0x73, 0x68, 0x6f, 0x6f, 0x74, 0x65, 0x72, 0x2e, 0x69, 0x61, 0x6d, 0x2e, 0x76, 0x33, 0x2e, 0x44,
	0x65, 0x6e, 0x79, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x53, 0x74, 0x61, 0x74, 0x65, 0x42, 0x03,
	0xe0, 0x41, 0x02, 0x52, 0x0f, 0x64, 0x65, 0x6e, 0x79, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x53,
	0x74, 0x61, 0x74, 0x65, 0x12, 0x97, 0x01, 0x0a, 0x1a, 0x63, 0x6f, 0x6d, 0x62, 0x69, 0x6e, 0x65,
	0x64, 0x5f, 0x64, 0x65, 0x6e, 0x69, 0x65, 0x64, 0x5f, 0x70, 0x65, 0x72, 0x6d, 0x69, 0x73, 0x73,
	0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x59, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x74,
	0x72, 0x6f, 0x75, 0x62, 0x6c, 0x65, 0x73, 0x68, 0x6f, 0x6f, 0x74, 0x65, 0x72, 0x2e, 0x69, 0x61,
	0x6d, 0x2e, 0x76, 0x33, 0x2e, 0x44, 0x65, 0x6e, 0x79, 0x52, 0x75, 0x6c, 0x65, 0x45, 0x78, 0x70,
	0x6c, 0x61, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74,
	0x65, 0x64, 0x50, 0x65, 0x72, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x4d, 0x61, 0x74, 0x63,
	0x68, 0x69, 0x6e, 0x67, 0x52, 0x18, 0x63, 0x6f, 0x6d, 0x62, 0x69, 0x6e, 0x65, 0x64, 0x44, 0x65,
	0x6e, 0x69, 0x65, 0x64, 0x50, 0x65, 0x72, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x83,
	0x01, 0x0a, 0x12, 0x64, 0x65, 0x6e, 0x69, 0x65, 0x64, 0x5f, 0x70, 0x65, 0x72, 0x6d, 0x69, 0x73,
	0x73, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x54, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x70, 0x6f, 0x6c, 0x69, 0x63,
	0x79, 0x74, 0x72, 0x6f, 0x75, 0x62, 0x6c, 0x65, 0x73, 0x68, 0x6f, 0x6f, 0x74, 0x65, 0x72, 0x2e,
	0x69, 0x61, 0x6d, 0x2e, 0x76, 0x33, 0x2e, 0x44, 0x65, 0x6e, 0x79, 0x52, 0x75, 0x6c, 0x65, 0x45,
	0x78, 0x70, 0x6c, 0x61, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x44, 0x65, 0x6e, 0x69, 0x65,
	0x64, 0x50, 0x65, 0x72, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x45, 0x6e, 0x74, 0x72,
	0x79, 0x52, 0x11, 0x64, 0x65, 0x6e, 0x69, 0x65, 0x64, 0x50, 0x65, 0x72, 0x6d, 0x69, 0x73, 0x73,
	0x69, 0x6f, 0x6e, 0x73, 0x12, 0x9d, 0x01, 0x0a, 0x1d, 0x63, 0x6f, 0x6d, 0x62, 0x69, 0x6e, 0x65,
	0x64, 0x5f, 0x65, 0x78, 0x63, 0x65, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x70, 0x65, 0x72, 0x6d,
	0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x59, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x70, 0x6f, 0x6c, 0x69,
	0x63, 0x79, 0x74, 0x72, 0x6f, 0x75, 0x62, 0x6c, 0x65, 0x73, 0x68, 0x6f, 0x6f, 0x74, 0x65, 0x72,
	0x2e, 0x69, 0x61, 0x6d, 0x2e, 0x76, 0x33, 0x2e, 0x44, 0x65, 0x6e, 0x79, 0x52, 0x75, 0x6c, 0x65,
	0x45, 0x78, 0x70, 0x6c, 0x61, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x41, 0x6e, 0x6e, 0x6f,
	0x74, 0x61, 0x74, 0x65, 0x64, 0x50, 0x65, 0x72, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x4d,
	0x61, 0x74, 0x63, 0x68, 0x69, 0x6e, 0x67, 0x52, 0x1b, 0x63, 0x6f, 0x6d, 0x62, 0x69, 0x6e, 0x65,
	0x64, 0x45, 0x78, 0x63, 0x65, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x65, 0x72, 0x6d, 0x69, 0x73,
	0x73, 0x69, 0x6f, 0x6e, 0x12, 0x8c, 0x01, 0x0a, 0x15, 0x65, 0x78, 0x63, 0x65, 0x70, 0x74, 0x69,
	0x6f, 0x6e, 0x5f, 0x70, 0x65, 0x72, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x05,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x57, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x74, 0x72, 0x6f, 0x75, 0x62, 0x6c,
	0x65, 0x73, 0x68, 0x6f, 0x6f, 0x74, 0x65, 0x72, 0x2e, 0x69, 0x61, 0x6d, 0x2e, 0x76, 0x33, 0x2e,
	0x44, 0x65, 0x6e, 0x79, 0x52, 0x75, 0x6c, 0x65, 0x45, 0x78, 0x70, 0x6c, 0x61, 0x6e, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x2e, 0x45, 0x78, 0x63, 0x65, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x65, 0x72,
	0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x14, 0x65,
	0x78, 0x63, 0x65, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x65, 0x72, 0x6d, 0x69, 0x73, 0x73, 0x69,
	0x6f, 0x6e, 0x73, 0x12, 0x98, 0x01, 0x0a, 0x19, 0x63, 0x6f, 0x6d, 0x62, 0x69, 0x6e, 0x65, 0x64,
	0x5f, 0x64, 0x65, 0x6e, 0x69, 0x65, 0x64, 0x5f, 0x70, 0x72, 0x69, 0x6e, 0x63, 0x69, 0x70, 0x61,
	0x6c, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x5c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x74, 0x72, 0x6f,
	0x75, 0x62, 0x6c, 0x65, 0x73, 0x68, 0x6f, 0x6f, 0x74, 0x65, 0x72, 0x2e, 0x69, 0x61, 0x6d, 0x2e,
	0x76, 0x33, 0x2e, 0x44, 0x65, 0x6e, 0x79, 0x52, 0x75, 0x6c, 0x65, 0x45, 0x78, 0x70, 0x6c, 0x61,
	0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x65, 0x64,
	0x44, 0x65, 0x6e, 0x79, 0x50, 0x72, 0x69, 0x6e, 0x63, 0x69, 0x70, 0x61, 0x6c, 0x4d, 0x61, 0x74,
	0x63, 0x68, 0x69, 0x6e, 0x67, 0x52, 0x17, 0x63, 0x6f, 0x6d, 0x62, 0x69, 0x6e, 0x65, 0x64, 0x44,
	0x65, 0x6e, 0x69, 0x65, 0x64, 0x50, 0x72, 0x69, 0x6e, 0x63, 0x69, 0x70, 0x61, 0x6c, 0x12, 0x80,
	0x01, 0x0a, 0x11, 0x64, 0x65, 0x6e, 0x69, 0x65, 0x64, 0x5f, 0x70, 0x72, 0x69, 0x6e, 0x63, 0x69,
	0x70, 0x61, 0x6c, 0x73, 0x18, 0x07, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x53, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79,
	0x74, 0x72, 0x6f, 0x75, 0x62, 0x6c, 0x65, 0x73, 0x68, 0x6f, 0x6f, 0x74, 0x65, 0x72, 0x2e, 0x69,
	0x61, 0x6d, 0x2e, 0x76, 0x33, 0x2e, 0x44, 0x65, 0x6e, 0x79, 0x52, 0x75, 0x6c, 0x65, 0x45, 0x78,
	0x70, 0x6c, 0x61, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x44, 0x65, 0x6e, 0x69, 0x65, 0x64,
	0x50, 0x72, 0x69, 0x6e, 0x63, 0x69, 0x70, 0x61, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52,
	0x10, 0x64, 0x65, 0x6e, 0x69, 0x65, 0x64, 0x50, 0x72, 0x69, 0x6e, 0x63, 0x69, 0x70, 0x61, 0x6c,
	0x73, 0x12, 0x9e, 0x01, 0x0a, 0x1c, 0x63, 0x6f, 0x6d, 0x62, 0x69, 0x6e, 0x65, 0x64, 0x5f, 0x65,
	0x78, 0x63, 0x65, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x70, 0x72, 0x69, 0x6e, 0x63, 0x69, 0x70,
	0x61, 0x6c, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x5c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x74, 0x72,
	0x6f, 0x75, 0x62, 0x6c, 0x65, 0x73, 0x68, 0x6f, 0x6f, 0x74, 0x65, 0x72, 0x2e, 0x69, 0x61, 0x6d,
	0x2e, 0x76, 0x33, 0x2e, 0x44, 0x65, 0x6e, 0x79, 0x52, 0x75, 0x6c, 0x65, 0x45, 0x78, 0x70, 0x6c,
	0x61, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x65,
	0x64, 0x44, 0x65, 0x6e, 0x79, 0x50, 0x72, 0x69, 0x6e, 0x63, 0x69, 0x70, 0x61, 0x6c, 0x4d, 0x61,
	0x74, 0x63, 0x68, 0x69, 0x6e, 0x67, 0x52, 0x1a, 0x63, 0x6f, 0x6d, 0x62, 0x69, 0x6e, 0x65, 0x64,
	0x45, 0x78, 0x63, 0x65, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x69, 0x6e, 0x63, 0x69, 0x70,
	0x61, 0x6c, 0x12, 0x89, 0x01, 0x0a, 0x14, 0x65, 0x78, 0x63, 0x65, 0x70, 0x74, 0x69, 0x6f, 0x6e,
	0x5f, 0x70, 0x72, 0x69, 0x6e, 0x63, 0x69, 0x70, 0x61, 0x6c, 0x73, 0x18, 0x09, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x56, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x74, 0x72, 0x6f, 0x75, 0x62, 0x6c, 0x65, 0x73, 0x68,
	0x6f, 0x6f, 0x74, 0x65, 0x72, 0x2e, 0x69, 0x61, 0x6d, 0x2e, 0x76, 0x33, 0x2e, 0x44, 0x65, 0x6e,
	0x79, 0x52, 0x75, 0x6c, 0x65, 0x45, 0x78, 0x70, 0x6c, 0x61, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x2e, 0x45, 0x78, 0x63, 0x65, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x69, 0x6e, 0x63, 0x69,
	0x70, 0x61, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x13, 0x65, 0x78, 0x63, 0x65, 0x70,
	0x74, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x69, 0x6e, 0x63, 0x69, 0x70, 0x61, 0x6c, 0x73, 0x12, 0x5a,
	0x0a, 0x09, 0x72, 0x65, 0x6c, 0x65, 0x76, 0x61, 0x6e, 0x63, 0x65, 0x18, 0x0a, 0x20, 0x01, 0x28,
	0x0e, 0x32, 0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x74, 0x72, 0x6f, 0x75, 0x62, 0x6c, 0x65, 0x73, 0x68,
	0x6f, 0x6f, 0x74, 0x65, 0x72, 0x2e, 0x69, 0x61, 0x6d, 0x2e, 0x76, 0x33, 0x2e, 0x48, 0x65, 0x75,
	0x72, 0x69, 0x73, 0x74, 0x69, 0x63, 0x52, 0x65, 0x6c, 0x65, 0x76, 0x61, 0x6e, 0x63, 0x65, 0x52,
	0x09, 0x72, 0x65, 0x6c, 0x65, 0x76, 0x61, 0x6e, 0x63, 0x65, 0x12, 0x2f, 0x0a, 0x09, 0x63, 0x6f,
	0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x11, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x74, 0x79, 0x70, 0x65, 0x2e, 0x45, 0x78, 0x70, 0x72,
	0x52, 0x09, 0x63, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x73, 0x0a, 0x15, 0x63,
	0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x65, 0x78, 0x70, 0x6c, 0x61, 0x6e, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3e, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79,
	0x74, 0x72, 0x6f, 0x75, 0x62, 0x6c, 0x65, 0x73, 0x68, 0x6f, 0x6f, 0x74, 0x65, 0x72, 0x2e, 0x69,
	0x61, 0x6d, 0x2e, 0x76, 0x33, 0x2e, 0x43, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x45,
	0x78, 0x70, 0x6c, 0x61, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x14, 0x63, 0x6f, 0x6e, 0x64,
	0x69, 0x74, 0x69, 0x6f, 0x6e, 0x45, 0x78, 0x70, 0x6c, 0x61, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x1a, 0x80, 0x02, 0x0a, 0x1b, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x65, 0x64, 0x50, 0x65,
	0x72, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x69, 0x6e, 0x67,
	0x12, 0x84, 0x01, 0x0a, 0x19, 0x70, 0x65, 0x72, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x5f,
	0x6d, 0x61, 0x74, 0x63, 0x68, 0x69, 0x6e, 0x67, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0e, 0x32, 0x48, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x74, 0x72, 0x6f, 0x75, 0x62, 0x6c,
	0x65, 0x73, 0x68, 0x6f, 0x6f, 0x74, 0x65, 0x72, 0x2e, 0x69, 0x61, 0x6d, 0x2e, 0x76, 0x33, 0x2e,
	0x50, 0x65, 0x72, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x50, 0x61, 0x74, 0x74, 0x65, 0x72,
	0x6e, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x69, 0x6e, 0x67, 0x53, 0x74, 0x61, 0x74, 0x65, 0x52, 0x17,
	0x70, 0x65, 0x72, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x69,
	0x6e, 0x67, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x5a, 0x0a, 0x09, 0x72, 0x65, 0x6c, 0x65, 0x76,
	0x61, 0x6e, 0x63, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x3c, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79,
	0x74, 0x72, 0x6f, 0x75, 0x62, 0x6c, 0x65, 0x73, 0x68, 0x6f, 0x6f, 0x74, 0x65, 0x72, 0x2e, 0x69,
	0x61, 0x6d, 0x2e, 0x76, 0x33, 0x2e, 0x48, 0x65, 0x75, 0x72, 0x69, 0x73, 0x74, 0x69, 0x63, 0x52,
	0x65, 0x6c, 0x65, 0x76, 0x61, 0x6e, 0x63, 0x65, 0x52, 0x09, 0x72, 0x65, 0x6c, 0x65, 0x76, 0x61,
	0x6e, 0x63, 0x65, 0x1a, 0xdf, 0x01, 0x0a, 0x1e, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x65,
	0x64, 0x44, 0x65, 0x6e, 0x79, 0x50, 0x72, 0x69, 0x6e, 0x63, 0x69, 0x70, 0x61, 0x6c, 0x4d, 0x61,
	0x74, 0x63, 0x68, 0x69, 0x6e, 0x67, 0x12, 0x61, 0x0a, 0x0a, 0x6d, 0x65, 0x6d, 0x62, 0x65, 0x72,
	0x73, 0x68, 0x69, 0x70, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x41, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79,
	0x74, 0x72, 0x6f, 0x75, 0x62, 0x6c, 0x65, 0x73, 0x68, 0x6f, 0x6f, 0x74, 0x65, 0x72, 0x2e, 0x69,
	0x61, 0x6d, 0x2e, 0x76, 0x33, 0x2e, 0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x73, 0x68, 0x69, 0x70,
	0x4d, 0x61, 0x74, 0x63, 0x68, 0x69, 0x6e, 0x67, 0x53, 0x74, 0x61, 0x74, 0x65, 0x52, 0x0a, 0x6d,
	0x65, 0x6d, 0x62, 0x65, 0x72, 0x73, 0x68, 0x69, 0x70, 0x12, 0x5a, 0x0a, 0x09, 0x72, 0x65, 0x6c,
	0x65, 0x76, 0x61, 0x6e, 0x63, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x3c, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x70, 0x6f, 0x6c, 0x69,
	0x63, 0x79, 0x74, 0x72, 0x6f, 0x75, 0x62, 0x6c, 0x65, 0x73, 0x68, 0x6f, 0x6f, 0x74, 0x65, 0x72,
	0x2e, 0x69, 0x61, 0x6d, 0x2e, 0x76, 0x33, 0x2e, 0x48, 0x65, 0x75, 0x72, 0x69, 0x73, 0x74, 0x69,
	0x63, 0x52, 0x65, 0x6c, 0x65, 0x76, 0x61, 0x6e, 0x63, 0x65, 0x52, 0x09, 0x72, 0x65, 0x6c, 0x65,
	0x76, 0x61, 0x6e, 0x63, 0x65, 0x1a, 0x9f, 0x01, 0x0a, 0x16, 0x44, 0x65, 0x6e, 0x69, 0x65, 0x64,
	0x50, 0x65, 0x72, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79,
	0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b,
	0x65, 0x79, 0x12, 0x6f, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x59, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x74, 0x72, 0x6f, 0x75, 0x62, 0x6c, 0x65, 0x73, 0x68,
	0x6f, 0x6f, 0x74, 0x65, 0x72, 0x2e, 0x69, 0x61, 0x6d, 0x2e, 0x76, 0x33, 0x2e, 0x44, 0x65, 0x6e,
	0x79, 0x52, 0x75, 0x6c, 0x65, 0x45, 0x78, 0x70, 0x6c, 0x61, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x2e, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x65, 0x64, 0x50, 0x65, 0x72, 0x6d, 0x69, 0x73,
	0x73, 0x69, 0x6f, 0x6e, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x69, 0x6e, 0x67, 0x52, 0x05, 0x76, 0x61,
	0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x1a, 0xa2, 0x01, 0x0a, 0x19, 0x45, 0x78, 0x63, 0x65,
	0x70, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x65, 0x72, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73,
	0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x6f, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x59, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x74, 0x72, 0x6f, 0x75,
	0x62, 0x6c, 0x65, 0x73, 0x68, 0x6f, 0x6f, 0x74, 0x65, 0x72, 0x2e, 0x69, 0x61, 0x6d, 0x2e, 0x76,
	0x33, 0x2e, 0x44, 0x65, 0x6e, 0x79, 0x52, 0x75, 0x6c, 0x65, 0x45, 0x78, 0x70, 0x6c, 0x61, 0x6e,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x65, 0x64, 0x50,
	0x65, 0x72, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x69, 0x6e,
	0x67, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x1a, 0xa1, 0x01, 0x0a,
	0x15, 0x44, 0x65, 0x6e, 0x69, 0x65, 0x64, 0x50, 0x72, 0x69, 0x6e, 0x63, 0x69, 0x70, 0x61, 0x6c,
	0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x72, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x5c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x74, 0x72, 0x6f,
	0x75, 0x62, 0x6c, 0x65, 0x73, 0x68, 0x6f, 0x6f, 0x74, 0x65, 0x72, 0x2e, 0x69, 0x61, 0x6d, 0x2e,
	0x76, 0x33, 0x2e, 0x44, 0x65, 0x6e, 0x79, 0x52, 0x75, 0x6c, 0x65, 0x45, 0x78, 0x70, 0x6c, 0x61,
	0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x65, 0x64,
	0x44, 0x65, 0x6e, 0x79, 0x50, 0x72, 0x69, 0x6e, 0x63, 0x69, 0x70, 0x61, 0x6c, 0x4d, 0x61, 0x74,
	0x63, 0x68, 0x69, 0x6e, 0x67, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01,
	0x1a, 0xa4, 0x01, 0x0a, 0x18, 0x45, 0x78, 0x63, 0x65, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x72,
	0x69, 0x6e, 0x63, 0x69, 0x70, 0x61, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a,
	0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12,
	0x72, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x5c,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x70, 0x6f,
	0x6c, 0x69, 0x63, 0x79, 0x74, 0x72, 0x6f, 0x75, 0x62, 0x6c, 0x65, 0x73, 0x68, 0x6f, 0x6f, 0x74,
	0x65, 0x72, 0x2e, 0x69, 0x61, 0x6d, 0x2e, 0x76, 0x33, 0x2e, 0x44, 0x65, 0x6e, 0x79, 0x52, 0x75,
	0x6c, 0x65, 0x45, 0x78, 0x70, 0x6c, 0x61, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x41, 0x6e,
	0x6e, 0x6f, 0x74, 0x61, 0x74, 0x65, 0x64, 0x44, 0x65, 0x6e, 0x79, 0x50, 0x72, 0x69, 0x6e, 0x63,
	0x69, 0x70, 0x61, 0x6c, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x69, 0x6e, 0x67, 0x52, 0x05, 0x76, 0x61,
	0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0x83, 0x03, 0x0a, 0x14, 0x43, 0x6f, 0x6e, 0x64,
	0x69, 0x74, 0x69, 0x6f, 0x6e, 0x45, 0x78, 0x70, 0x6c, 0x61, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x12, 0x2c, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x2a,
	0x0a, 0x06, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x12,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x72, 0x70, 0x63, 0x2e, 0x53, 0x74, 0x61, 0x74,
	0x75, 0x73, 0x52, 0x06, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x73, 0x12, 0x7b, 0x0a, 0x11, 0x65, 0x76,
	0x61, 0x6c, 0x75, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x65, 0x73, 0x18,
	0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x4e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x74, 0x72, 0x6f, 0x75, 0x62,
	0x6c, 0x65, 0x73, 0x68, 0x6f, 0x6f, 0x74, 0x65, 0x72, 0x2e, 0x69, 0x61, 0x6d, 0x2e, 0x76, 0x33,
	0x2e, 0x43, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x45, 0x78, 0x70, 0x6c, 0x61, 0x6e,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x45, 0x76, 0x61, 0x6c, 0x75, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x53, 0x74, 0x61, 0x74, 0x65, 0x52, 0x10, 0x65, 0x76, 0x61, 0x6c, 0x75, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x73, 0x1a, 0x93, 0x01, 0x0a, 0x0f, 0x45, 0x76, 0x61, 0x6c,
	0x75, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x14, 0x0a, 0x05, 0x73,
	0x74, 0x61, 0x72, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x05, 0x52, 0x05, 0x73, 0x74, 0x61, 0x72,
	0x74, 0x12, 0x10, 0x0a, 0x03, 0x65, 0x6e, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x03,
	0x65, 0x6e, 0x64, 0x12, 0x2c, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x12, 0x2a, 0x0a, 0x06, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x12, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x72, 0x70, 0x63, 0x2e, 0x53,
	0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x06, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x73, 0x2a, 0xcb, 0x01,
	0x0a, 0x10, 0x41, 0x6c, 0x6c, 0x6f, 0x77, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x53, 0x74, 0x61,
	0x74, 0x65, 0x12, 0x22, 0x0a, 0x1e, 0x41, 0x4c, 0x4c, 0x4f, 0x57, 0x5f, 0x41, 0x43, 0x43, 0x45,
	0x53, 0x53, 0x5f, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49,
	0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x1e, 0x0a, 0x1a, 0x41, 0x4c, 0x4c, 0x4f, 0x57, 0x5f,
	0x41, 0x43, 0x43, 0x45, 0x53, 0x53, 0x5f, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x47, 0x52, 0x41,
	0x4e, 0x54, 0x45, 0x44, 0x10, 0x01, 0x12, 0x22, 0x0a, 0x1e, 0x41, 0x4c, 0x4c, 0x4f, 0x57, 0x5f,
	0x41, 0x43, 0x43, 0x45, 0x53, 0x53, 0x5f, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x4e, 0x4f, 0x54,
	0x5f, 0x47, 0x52, 0x41, 0x4e, 0x54, 0x45, 0x44, 0x10, 0x02, 0x12, 0x2a, 0x0a, 0x26, 0x41, 0x4c,
	0x4c, 0x4f, 0x57, 0x5f, 0x41, 0x43, 0x43, 0x45, 0x53, 0x53, 0x5f, 0x53, 0x54, 0x41, 0x54, 0x45,
	0x5f, 0x55, 0x4e, 0x4b, 0x4e, 0x4f, 0x57, 0x4e, 0x5f, 0x43, 0x4f, 0x4e, 0x44, 0x49, 0x54, 0x49,
	0x4f, 0x4e, 0x41, 0x4c, 0x10, 0x03, 0x12, 0x23, 0x0a, 0x1f, 0x41, 0x4c, 0x4c, 0x4f, 0x57, 0x5f,
	0x41, 0x43, 0x43, 0x45, 0x53, 0x53, 0x5f, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x4b,
	0x4e, 0x4f, 0x57, 0x4e, 0x5f, 0x49, 0x4e, 0x46, 0x4f, 0x10, 0x04, 0x2a, 0xc3, 0x01, 0x0a, 0x0f,
	0x44, 0x65, 0x6e, 0x79, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12,
	0x21, 0x0a, 0x1d, 0x44, 0x45, 0x4e, 0x59, 0x5f, 0x41, 0x43, 0x43, 0x45, 0x53, 0x53, 0x5f, 0x53,
	0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44,
	0x10, 0x00, 0x12, 0x1c, 0x0a, 0x18, 0x44, 0x45, 0x4e, 0x59, 0x5f, 0x41, 0x43, 0x43, 0x45, 0x53,
	0x53, 0x5f, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x44, 0x45, 0x4e, 0x49, 0x45, 0x44, 0x10, 0x01,
	0x12, 0x20, 0x0a, 0x1c, 0x44, 0x45, 0x4e, 0x59, 0x5f, 0x41, 0x43, 0x43, 0x45, 0x53, 0x53, 0x5f,
	0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x4e, 0x4f, 0x54, 0x5f, 0x44, 0x45, 0x4e, 0x49, 0x45, 0x44,
	0x10, 0x02, 0x12, 0x29, 0x0a, 0x25, 0x44, 0x45, 0x4e, 0x59, 0x5f, 0x41, 0x43, 0x43, 0x45, 0x53,
	0x53, 0x5f, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x4b, 0x4e, 0x4f, 0x57, 0x4e, 0x5f,
	0x43, 0x4f, 0x4e, 0x44, 0x49, 0x54, 0x49, 0x4f, 0x4e, 0x41, 0x4c, 0x10, 0x03, 0x12, 0x22, 0x0a,
	0x1e, 0x44, 0x45, 0x4e, 0x59, 0x5f, 0x41, 0x43, 0x43, 0x45, 0x53, 0x53, 0x5f, 0x53, 0x54, 0x41,
	0x54, 0x45, 0x5f, 0x55, 0x4e, 0x4b, 0x4e, 0x4f, 0x57, 0x4e, 0x5f, 0x49, 0x4e, 0x46, 0x4f, 0x10,
	0x04, 0x2a, 0xb1, 0x01, 0x0a, 0x1c, 0x52, 0x6f, 0x6c, 0x65, 0x50, 0x65, 0x72, 0x6d, 0x69, 0x73,
	0x73, 0x69, 0x6f, 0x6e, 0x49, 0x6e, 0x63, 0x6c, 0x75, 0x73, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x61,
	0x74, 0x65, 0x12, 0x2f, 0x0a, 0x2b, 0x52, 0x4f, 0x4c, 0x45, 0x5f, 0x50, 0x45, 0x52, 0x4d, 0x49,
	0x53, 0x53, 0x49, 0x4f, 0x4e, 0x5f, 0x49, 0x4e, 0x43, 0x4c, 0x55, 0x53, 0x49, 0x4f, 0x4e, 0x5f,
	0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45,
	0x44, 0x10, 0x00, 0x12, 0x1c, 0x0a, 0x18, 0x52, 0x4f, 0x4c, 0x45, 0x5f, 0x50, 0x45, 0x52, 0x4d,
	0x49, 0x53, 0x53, 0x49, 0x4f, 0x4e, 0x5f, 0x49, 0x4e, 0x43, 0x4c, 0x55, 0x44, 0x45, 0x44, 0x10,
	0x01, 0x12, 0x20, 0x0a, 0x1c, 0x52, 0x4f, 0x4c, 0x45, 0x5f, 0x50, 0x45, 0x52, 0x4d, 0x49, 0x53,
	0x53, 0x49, 0x4f, 0x4e, 0x5f, 0x4e, 0x4f, 0x54, 0x5f, 0x49, 0x4e, 0x43, 0x4c, 0x55, 0x44, 0x45,
	0x44, 0x10, 0x02, 0x12, 0x20, 0x0a, 0x1c, 0x52, 0x4f, 0x4c, 0x45, 0x5f, 0x50, 0x45, 0x52, 0x4d,
	0x49, 0x53, 0x53, 0x49, 0x4f, 0x4e, 0x5f, 0x55, 0x4e, 0x4b, 0x4e, 0x4f, 0x57, 0x4e, 0x5f, 0x49,
	0x4e, 0x46, 0x4f, 0x10, 0x03, 0x2a, 0x97, 0x01, 0x0a, 0x1e, 0x50, 0x65, 0x72, 0x6d, 0x69, 0x73,
	0x73, 0x69, 0x6f, 0x6e, 0x50, 0x61, 0x74, 0x74, 0x65, 0x72, 0x6e, 0x4d, 0x61, 0x74, 0x63, 0x68,
	0x69, 0x6e, 0x67, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x31, 0x0a, 0x2d, 0x50, 0x45, 0x52, 0x4d,
	0x49, 0x53, 0x53, 0x49, 0x4f, 0x4e, 0x5f, 0x50, 0x41, 0x54, 0x54, 0x45, 0x52, 0x4e, 0x5f, 0x4d,
	0x41, 0x54, 0x43, 0x48, 0x49, 0x4e, 0x47, 0x5f, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e,
	0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x1e, 0x0a, 0x1a, 0x50,
	0x45, 0x52, 0x4d, 0x49, 0x53, 0x53, 0x49, 0x4f, 0x4e, 0x5f, 0x50, 0x41, 0x54, 0x54, 0x45, 0x52,
	0x4e, 0x5f, 0x4d, 0x41, 0x54, 0x43, 0x48, 0x45, 0x44, 0x10, 0x01, 0x12, 0x22, 0x0a, 0x1e, 0x50,
	0x45, 0x52, 0x4d, 0x49, 0x53, 0x53, 0x49, 0x4f, 0x4e, 0x5f, 0x50, 0x41, 0x54, 0x54, 0x45, 0x52,
	0x4e, 0x5f, 0x4e, 0x4f, 0x54, 0x5f, 0x4d, 0x41, 0x54, 0x43, 0x48, 0x45, 0x44, 0x10, 0x02, 0x2a,
	0xb9, 0x01, 0x0a, 0x17, 0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x73, 0x68, 0x69, 0x70, 0x4d, 0x61,
	0x74, 0x63, 0x68, 0x69, 0x6e, 0x67, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x29, 0x0a, 0x25, 0x4d,
	0x45, 0x4d, 0x42, 0x45, 0x52, 0x53, 0x48, 0x49, 0x50, 0x5f, 0x4d, 0x41, 0x54, 0x43, 0x48, 0x49,
	0x4e, 0x47, 0x5f, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49,
	0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x16, 0x0a, 0x12, 0x4d, 0x45, 0x4d, 0x42, 0x45, 0x52,
	0x53, 0x48, 0x49, 0x50, 0x5f, 0x4d, 0x41, 0x54, 0x43, 0x48, 0x45, 0x44, 0x10, 0x01, 0x12, 0x1a,
	0x0a, 0x16, 0x4d, 0x45, 0x4d, 0x42, 0x45, 0x52, 0x53, 0x48, 0x49, 0x50, 0x5f, 0x4e, 0x4f, 0x54,
	0x5f, 0x4d, 0x41, 0x54, 0x43, 0x48, 0x45, 0x44, 0x10, 0x02, 0x12, 0x1b, 0x0a, 0x17, 0x4d, 0x45,
	0x4d, 0x42, 0x45, 0x52, 0x53, 0x48, 0x49, 0x50, 0x5f, 0x55, 0x4e, 0x4b, 0x4e, 0x4f, 0x57, 0x4e,
	0x5f, 0x49, 0x4e, 0x46, 0x4f, 0x10, 0x03, 0x12, 0x22, 0x0a, 0x1e, 0x4d, 0x45, 0x4d, 0x42, 0x45,
	0x52, 0x53, 0x48, 0x49, 0x50, 0x5f, 0x55, 0x4e, 0x4b, 0x4e, 0x4f, 0x57, 0x4e, 0x5f, 0x55, 0x4e,
	0x53, 0x55, 0x50, 0x50, 0x4f, 0x52, 0x54, 0x45, 0x44, 0x10, 0x04, 0x2a, 0x77, 0x0a, 0x12, 0x48,
	0x65, 0x75, 0x72, 0x69, 0x73, 0x74, 0x69, 0x63, 0x52, 0x65, 0x6c, 0x65, 0x76, 0x61, 0x6e, 0x63,
	0x65, 0x12, 0x23, 0x0a, 0x1f, 0x48, 0x45, 0x55, 0x52, 0x49, 0x53, 0x54, 0x49, 0x43, 0x5f, 0x52,
	0x45, 0x4c, 0x45, 0x56, 0x41, 0x4e, 0x43, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49,
	0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x1e, 0x0a, 0x1a, 0x48, 0x45, 0x55, 0x52, 0x49, 0x53,
	0x54, 0x49, 0x43, 0x5f, 0x52, 0x45, 0x4c, 0x45, 0x56, 0x41, 0x4e, 0x43, 0x45, 0x5f, 0x4e, 0x4f,
	0x52, 0x4d, 0x41, 0x4c, 0x10, 0x01, 0x12, 0x1c, 0x0a, 0x18, 0x48, 0x45, 0x55, 0x52, 0x49, 0x53,
	0x54, 0x49, 0x43, 0x5f, 0x52, 0x45, 0x4c, 0x45, 0x56, 0x41, 0x4e, 0x43, 0x45, 0x5f, 0x48, 0x49,
	0x47, 0x48, 0x10, 0x02, 0x32, 0xbb, 0x02, 0x0a, 0x14, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x54,
	0x72, 0x6f, 0x75, 0x62, 0x6c, 0x65, 0x73, 0x68, 0x6f, 0x6f, 0x74, 0x65, 0x72, 0x12, 0xc9, 0x01,
	0x0a, 0x15, 0x54, 0x72, 0x6f, 0x75, 0x62, 0x6c, 0x65, 0x73, 0x68, 0x6f, 0x6f, 0x74, 0x49, 0x61,
	0x6d, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12, 0x46, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x74, 0x72, 0x6f,
	0x75, 0x62, 0x6c, 0x65, 0x73, 0x68, 0x6f, 0x6f, 0x74, 0x65, 0x72, 0x2e, 0x69, 0x61, 0x6d, 0x2e,
	0x76, 0x33, 0x2e, 0x54, 0x72, 0x6f, 0x75, 0x62, 0x6c, 0x65, 0x73, 0x68, 0x6f, 0x6f, 0x74, 0x49,
	0x61, 0x6d, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x47, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x70,
	0x6f, 0x6c, 0x69, 0x63, 0x79, 0x74, 0x72, 0x6f, 0x75, 0x62, 0x6c, 0x65, 0x73, 0x68, 0x6f, 0x6f,
	0x74, 0x65, 0x72, 0x2e, 0x69, 0x61, 0x6d, 0x2e, 0x76, 0x33, 0x2e, 0x54, 0x72, 0x6f, 0x75, 0x62,
	0x6c, 0x65, 0x73, 0x68, 0x6f, 0x6f, 0x74, 0x49, 0x61, 0x6d, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x1f, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x19,
	0x3a, 0x01, 0x2a, 0x22, 0x14, 0x2f, 0x76, 0x33, 0x2f, 0x69, 0x61, 0x6d, 0x3a, 0x74, 0x72, 0x6f,
	0x75, 0x62, 0x6c, 0x65, 0x73, 0x68, 0x6f, 0x6f, 0x74, 0x1a, 0x57, 0xca, 0x41, 0x23, 0x70, 0x6f,
	0x6c, 0x69, 0x63, 0x79, 0x74, 0x72, 0x6f, 0x75, 0x62, 0x6c, 0x65, 0x73, 0x68, 0x6f, 0x6f, 0x74,
	0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0xd2, 0x41, 0x2e, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61,
	0x75, 0x74, 0x68, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2d, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f,
	0x72, 0x6d, 0x42, 0x8d, 0x02, 0x0a, 0x2c, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x74, 0x72,
	0x6f, 0x75, 0x62, 0x6c, 0x65, 0x73, 0x68, 0x6f, 0x6f, 0x74, 0x65, 0x72, 0x2e, 0x69, 0x61, 0x6d,
	0x2e, 0x76, 0x33, 0x42, 0x13, 0x54, 0x72, 0x6f, 0x75, 0x62, 0x6c, 0x65, 0x73, 0x68, 0x6f, 0x6f,
	0x74, 0x65, 0x72, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x3e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f,
	0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x74, 0x72, 0x6f, 0x75, 0x62, 0x6c, 0x65, 0x73, 0x68, 0x6f,
	0x6f, 0x74, 0x65, 0x72, 0x2f, 0x69, 0x61, 0x6d, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x33, 0x2f, 0x69,
	0x61, 0x6d, 0x70, 0x62, 0x3b, 0x69, 0x61, 0x6d, 0x70, 0x62, 0xf8, 0x01, 0x01, 0xaa, 0x02, 0x28,
	0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x50, 0x6f, 0x6c,
	0x69, 0x63, 0x79, 0x54, 0x72, 0x6f, 0x75, 0x62, 0x6c, 0x65, 0x73, 0x68, 0x6f, 0x6f, 0x74, 0x65,
	0x72, 0x2e, 0x49, 0x61, 0x6d, 0x2e, 0x56, 0x33, 0xca, 0x02, 0x28, 0x47, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x54, 0x72,
	0x6f, 0x75, 0x62, 0x6c, 0x65, 0x73, 0x68, 0x6f, 0x6f, 0x74, 0x65, 0x72, 0x5c, 0x49, 0x61, 0x6d,
	0x5c, 0x56, 0x33, 0xea, 0x02, 0x2c, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43, 0x6c,
	0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x54, 0x72, 0x6f, 0x75, 0x62,
	0x6c, 0x65, 0x73, 0x68, 0x6f, 0x6f, 0x74, 0x65, 0x72, 0x3a, 0x3a, 0x49, 0x61, 0x6d, 0x3a, 0x3a,
	0x56, 0x33, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_policytroubleshooter_iam_v3_troubleshooter_proto_rawDescOnce sync.Once
	file_google_cloud_policytroubleshooter_iam_v3_troubleshooter_proto_rawDescData = file_google_cloud_policytroubleshooter_iam_v3_troubleshooter_proto_rawDesc
)

func file_google_cloud_policytroubleshooter_iam_v3_troubleshooter_proto_rawDescGZIP() []byte {
	file_google_cloud_policytroubleshooter_iam_v3_troubleshooter_proto_rawDescOnce.Do(func() {
		file_google_cloud_policytroubleshooter_iam_v3_troubleshooter_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_policytroubleshooter_iam_v3_troubleshooter_proto_rawDescData)
	})
	return file_google_cloud_policytroubleshooter_iam_v3_troubleshooter_proto_rawDescData
}

var file_google_cloud_policytroubleshooter_iam_v3_troubleshooter_proto_enumTypes = make([]protoimpl.EnumInfo, 7)
var file_google_cloud_policytroubleshooter_iam_v3_troubleshooter_proto_msgTypes = make([]protoimpl.MessageInfo, 25)
var file_google_cloud_policytroubleshooter_iam_v3_troubleshooter_proto_goTypes = []interface{}{
	(AllowAccessState)(0),                                    // 0: google.cloud.policytroubleshooter.iam.v3.AllowAccessState
	(DenyAccessState)(0),                                     // 1: google.cloud.policytroubleshooter.iam.v3.DenyAccessState
	(RolePermissionInclusionState)(0),                        // 2: google.cloud.policytroubleshooter.iam.v3.RolePermissionInclusionState
	(PermissionPatternMatchingState)(0),                      // 3: google.cloud.policytroubleshooter.iam.v3.PermissionPatternMatchingState
	(MembershipMatchingState)(0),                             // 4: google.cloud.policytroubleshooter.iam.v3.MembershipMatchingState
	(HeuristicRelevance)(0),                                  // 5: google.cloud.policytroubleshooter.iam.v3.HeuristicRelevance
	(TroubleshootIamPolicyResponse_OverallAccessState)(0),    // 6: google.cloud.policytroubleshooter.iam.v3.TroubleshootIamPolicyResponse.OverallAccessState
	(*TroubleshootIamPolicyRequest)(nil),                     // 7: google.cloud.policytroubleshooter.iam.v3.TroubleshootIamPolicyRequest
	(*TroubleshootIamPolicyResponse)(nil),                    // 8: google.cloud.policytroubleshooter.iam.v3.TroubleshootIamPolicyResponse
	(*AccessTuple)(nil),                                      // 9: google.cloud.policytroubleshooter.iam.v3.AccessTuple
	(*ConditionContext)(nil),                                 // 10: google.cloud.policytroubleshooter.iam.v3.ConditionContext
	(*AllowPolicyExplanation)(nil),                           // 11: google.cloud.policytroubleshooter.iam.v3.AllowPolicyExplanation
	(*ExplainedAllowPolicy)(nil),                             // 12: google.cloud.policytroubleshooter.iam.v3.ExplainedAllowPolicy
	(*AllowBindingExplanation)(nil),                          // 13: google.cloud.policytroubleshooter.iam.v3.AllowBindingExplanation
	(*DenyPolicyExplanation)(nil),                            // 14: google.cloud.policytroubleshooter.iam.v3.DenyPolicyExplanation
	(*ExplainedDenyResource)(nil),                            // 15: google.cloud.policytroubleshooter.iam.v3.ExplainedDenyResource
	(*ExplainedDenyPolicy)(nil),                              // 16: google.cloud.policytroubleshooter.iam.v3.ExplainedDenyPolicy
	(*DenyRuleExplanation)(nil),                              // 17: google.cloud.policytroubleshooter.iam.v3.DenyRuleExplanation
	(*ConditionExplanation)(nil),                             // 18: google.cloud.policytroubleshooter.iam.v3.ConditionExplanation
	(*ConditionContext_Resource)(nil),                        // 19: google.cloud.policytroubleshooter.iam.v3.ConditionContext.Resource
	(*ConditionContext_Peer)(nil),                            // 20: google.cloud.policytroubleshooter.iam.v3.ConditionContext.Peer
	(*ConditionContext_Request)(nil),                         // 21: google.cloud.policytroubleshooter.iam.v3.ConditionContext.Request
	(*ConditionContext_EffectiveTag)(nil),                    // 22: google.cloud.policytroubleshooter.iam.v3.ConditionContext.EffectiveTag
	(*AllowBindingExplanation_AnnotatedAllowMembership)(nil), // 23: google.cloud.policytroubleshooter.iam.v3.AllowBindingExplanation.AnnotatedAllowMembership
	nil, // 24: google.cloud.policytroubleshooter.iam.v3.AllowBindingExplanation.MembershipsEntry
	(*DenyRuleExplanation_AnnotatedPermissionMatching)(nil),    // 25: google.cloud.policytroubleshooter.iam.v3.DenyRuleExplanation.AnnotatedPermissionMatching
	(*DenyRuleExplanation_AnnotatedDenyPrincipalMatching)(nil), // 26: google.cloud.policytroubleshooter.iam.v3.DenyRuleExplanation.AnnotatedDenyPrincipalMatching
	nil, // 27: google.cloud.policytroubleshooter.iam.v3.DenyRuleExplanation.DeniedPermissionsEntry
	nil, // 28: google.cloud.policytroubleshooter.iam.v3.DenyRuleExplanation.ExceptionPermissionsEntry
	nil, // 29: google.cloud.policytroubleshooter.iam.v3.DenyRuleExplanation.DeniedPrincipalsEntry
	nil, // 30: google.cloud.policytroubleshooter.iam.v3.DenyRuleExplanation.ExceptionPrincipalsEntry
	(*ConditionExplanation_EvaluationState)(nil), // 31: google.cloud.policytroubleshooter.iam.v3.ConditionExplanation.EvaluationState
	(*iampb.Policy)(nil),                         // 32: google.iam.v1.Policy
	(*expr.Expr)(nil),                            // 33: google.type.Expr
	(*iampb1.Policy)(nil),                        // 34: google.iam.v2.Policy
	(*structpb.Value)(nil),                       // 35: google.protobuf.Value
	(*status.Status)(nil),                        // 36: google.rpc.Status
	(*timestamppb.Timestamp)(nil),                // 37: google.protobuf.Timestamp
}
var file_google_cloud_policytroubleshooter_iam_v3_troubleshooter_proto_depIdxs = []int32{
	9,  // 0: google.cloud.policytroubleshooter.iam.v3.TroubleshootIamPolicyRequest.access_tuple:type_name -> google.cloud.policytroubleshooter.iam.v3.AccessTuple
	6,  // 1: google.cloud.policytroubleshooter.iam.v3.TroubleshootIamPolicyResponse.overall_access_state:type_name -> google.cloud.policytroubleshooter.iam.v3.TroubleshootIamPolicyResponse.OverallAccessState
	9,  // 2: google.cloud.policytroubleshooter.iam.v3.TroubleshootIamPolicyResponse.access_tuple:type_name -> google.cloud.policytroubleshooter.iam.v3.AccessTuple
	11, // 3: google.cloud.policytroubleshooter.iam.v3.TroubleshootIamPolicyResponse.allow_policy_explanation:type_name -> google.cloud.policytroubleshooter.iam.v3.AllowPolicyExplanation
	14, // 4: google.cloud.policytroubleshooter.iam.v3.TroubleshootIamPolicyResponse.deny_policy_explanation:type_name -> google.cloud.policytroubleshooter.iam.v3.DenyPolicyExplanation
	10, // 5: google.cloud.policytroubleshooter.iam.v3.AccessTuple.condition_context:type_name -> google.cloud.policytroubleshooter.iam.v3.ConditionContext
	19, // 6: google.cloud.policytroubleshooter.iam.v3.ConditionContext.resource:type_name -> google.cloud.policytroubleshooter.iam.v3.ConditionContext.Resource
	20, // 7: google.cloud.policytroubleshooter.iam.v3.ConditionContext.destination:type_name -> google.cloud.policytroubleshooter.iam.v3.ConditionContext.Peer
	21, // 8: google.cloud.policytroubleshooter.iam.v3.ConditionContext.request:type_name -> google.cloud.policytroubleshooter.iam.v3.ConditionContext.Request
	22, // 9: google.cloud.policytroubleshooter.iam.v3.ConditionContext.effective_tags:type_name -> google.cloud.policytroubleshooter.iam.v3.ConditionContext.EffectiveTag
	0,  // 10: google.cloud.policytroubleshooter.iam.v3.AllowPolicyExplanation.allow_access_state:type_name -> google.cloud.policytroubleshooter.iam.v3.AllowAccessState
	12, // 11: google.cloud.policytroubleshooter.iam.v3.AllowPolicyExplanation.explained_policies:type_name -> google.cloud.policytroubleshooter.iam.v3.ExplainedAllowPolicy
	5,  // 12: google.cloud.policytroubleshooter.iam.v3.AllowPolicyExplanation.relevance:type_name -> google.cloud.policytroubleshooter.iam.v3.HeuristicRelevance
	0,  // 13: google.cloud.policytroubleshooter.iam.v3.ExplainedAllowPolicy.allow_access_state:type_name -> google.cloud.policytroubleshooter.iam.v3.AllowAccessState
	13, // 14: google.cloud.policytroubleshooter.iam.v3.ExplainedAllowPolicy.binding_explanations:type_name -> google.cloud.policytroubleshooter.iam.v3.AllowBindingExplanation
	5,  // 15: google.cloud.policytroubleshooter.iam.v3.ExplainedAllowPolicy.relevance:type_name -> google.cloud.policytroubleshooter.iam.v3.HeuristicRelevance
	32, // 16: google.cloud.policytroubleshooter.iam.v3.ExplainedAllowPolicy.policy:type_name -> google.iam.v1.Policy
	0,  // 17: google.cloud.policytroubleshooter.iam.v3.AllowBindingExplanation.allow_access_state:type_name -> google.cloud.policytroubleshooter.iam.v3.AllowAccessState
	2,  // 18: google.cloud.policytroubleshooter.iam.v3.AllowBindingExplanation.role_permission:type_name -> google.cloud.policytroubleshooter.iam.v3.RolePermissionInclusionState
	5,  // 19: google.cloud.policytroubleshooter.iam.v3.AllowBindingExplanation.role_permission_relevance:type_name -> google.cloud.policytroubleshooter.iam.v3.HeuristicRelevance
	23, // 20: google.cloud.policytroubleshooter.iam.v3.AllowBindingExplanation.combined_membership:type_name -> google.cloud.policytroubleshooter.iam.v3.AllowBindingExplanation.AnnotatedAllowMembership
	24, // 21: google.cloud.policytroubleshooter.iam.v3.AllowBindingExplanation.memberships:type_name -> google.cloud.policytroubleshooter.iam.v3.AllowBindingExplanation.MembershipsEntry
	5,  // 22: google.cloud.policytroubleshooter.iam.v3.AllowBindingExplanation.relevance:type_name -> google.cloud.policytroubleshooter.iam.v3.HeuristicRelevance
	33, // 23: google.cloud.policytroubleshooter.iam.v3.AllowBindingExplanation.condition:type_name -> google.type.Expr
	18, // 24: google.cloud.policytroubleshooter.iam.v3.AllowBindingExplanation.condition_explanation:type_name -> google.cloud.policytroubleshooter.iam.v3.ConditionExplanation
	1,  // 25: google.cloud.policytroubleshooter.iam.v3.DenyPolicyExplanation.deny_access_state:type_name -> google.cloud.policytroubleshooter.iam.v3.DenyAccessState
	15, // 26: google.cloud.policytroubleshooter.iam.v3.DenyPolicyExplanation.explained_resources:type_name -> google.cloud.policytroubleshooter.iam.v3.ExplainedDenyResource
	5,  // 27: google.cloud.policytroubleshooter.iam.v3.DenyPolicyExplanation.relevance:type_name -> google.cloud.policytroubleshooter.iam.v3.HeuristicRelevance
	1,  // 28: google.cloud.policytroubleshooter.iam.v3.ExplainedDenyResource.deny_access_state:type_name -> google.cloud.policytroubleshooter.iam.v3.DenyAccessState
	16, // 29: google.cloud.policytroubleshooter.iam.v3.ExplainedDenyResource.explained_policies:type_name -> google.cloud.policytroubleshooter.iam.v3.ExplainedDenyPolicy
	5,  // 30: google.cloud.policytroubleshooter.iam.v3.ExplainedDenyResource.relevance:type_name -> google.cloud.policytroubleshooter.iam.v3.HeuristicRelevance
	1,  // 31: google.cloud.policytroubleshooter.iam.v3.ExplainedDenyPolicy.deny_access_state:type_name -> google.cloud.policytroubleshooter.iam.v3.DenyAccessState
	34, // 32: google.cloud.policytroubleshooter.iam.v3.ExplainedDenyPolicy.policy:type_name -> google.iam.v2.Policy
	17, // 33: google.cloud.policytroubleshooter.iam.v3.ExplainedDenyPolicy.rule_explanations:type_name -> google.cloud.policytroubleshooter.iam.v3.DenyRuleExplanation
	5,  // 34: google.cloud.policytroubleshooter.iam.v3.ExplainedDenyPolicy.relevance:type_name -> google.cloud.policytroubleshooter.iam.v3.HeuristicRelevance
	1,  // 35: google.cloud.policytroubleshooter.iam.v3.DenyRuleExplanation.deny_access_state:type_name -> google.cloud.policytroubleshooter.iam.v3.DenyAccessState
	25, // 36: google.cloud.policytroubleshooter.iam.v3.DenyRuleExplanation.combined_denied_permission:type_name -> google.cloud.policytroubleshooter.iam.v3.DenyRuleExplanation.AnnotatedPermissionMatching
	27, // 37: google.cloud.policytroubleshooter.iam.v3.DenyRuleExplanation.denied_permissions:type_name -> google.cloud.policytroubleshooter.iam.v3.DenyRuleExplanation.DeniedPermissionsEntry
	25, // 38: google.cloud.policytroubleshooter.iam.v3.DenyRuleExplanation.combined_exception_permission:type_name -> google.cloud.policytroubleshooter.iam.v3.DenyRuleExplanation.AnnotatedPermissionMatching
	28, // 39: google.cloud.policytroubleshooter.iam.v3.DenyRuleExplanation.exception_permissions:type_name -> google.cloud.policytroubleshooter.iam.v3.DenyRuleExplanation.ExceptionPermissionsEntry
	26, // 40: google.cloud.policytroubleshooter.iam.v3.DenyRuleExplanation.combined_denied_principal:type_name -> google.cloud.policytroubleshooter.iam.v3.DenyRuleExplanation.AnnotatedDenyPrincipalMatching
	29, // 41: google.cloud.policytroubleshooter.iam.v3.DenyRuleExplanation.denied_principals:type_name -> google.cloud.policytroubleshooter.iam.v3.DenyRuleExplanation.DeniedPrincipalsEntry
	26, // 42: google.cloud.policytroubleshooter.iam.v3.DenyRuleExplanation.combined_exception_principal:type_name -> google.cloud.policytroubleshooter.iam.v3.DenyRuleExplanation.AnnotatedDenyPrincipalMatching
	30, // 43: google.cloud.policytroubleshooter.iam.v3.DenyRuleExplanation.exception_principals:type_name -> google.cloud.policytroubleshooter.iam.v3.DenyRuleExplanation.ExceptionPrincipalsEntry
	5,  // 44: google.cloud.policytroubleshooter.iam.v3.DenyRuleExplanation.relevance:type_name -> google.cloud.policytroubleshooter.iam.v3.HeuristicRelevance
	33, // 45: google.cloud.policytroubleshooter.iam.v3.DenyRuleExplanation.condition:type_name -> google.type.Expr
	18, // 46: google.cloud.policytroubleshooter.iam.v3.DenyRuleExplanation.condition_explanation:type_name -> google.cloud.policytroubleshooter.iam.v3.ConditionExplanation
	35, // 47: google.cloud.policytroubleshooter.iam.v3.ConditionExplanation.value:type_name -> google.protobuf.Value
	36, // 48: google.cloud.policytroubleshooter.iam.v3.ConditionExplanation.errors:type_name -> google.rpc.Status
	31, // 49: google.cloud.policytroubleshooter.iam.v3.ConditionExplanation.evaluation_states:type_name -> google.cloud.policytroubleshooter.iam.v3.ConditionExplanation.EvaluationState
	37, // 50: google.cloud.policytroubleshooter.iam.v3.ConditionContext.Request.receive_time:type_name -> google.protobuf.Timestamp
	4,  // 51: google.cloud.policytroubleshooter.iam.v3.AllowBindingExplanation.AnnotatedAllowMembership.membership:type_name -> google.cloud.policytroubleshooter.iam.v3.MembershipMatchingState
	5,  // 52: google.cloud.policytroubleshooter.iam.v3.AllowBindingExplanation.AnnotatedAllowMembership.relevance:type_name -> google.cloud.policytroubleshooter.iam.v3.HeuristicRelevance
	23, // 53: google.cloud.policytroubleshooter.iam.v3.AllowBindingExplanation.MembershipsEntry.value:type_name -> google.cloud.policytroubleshooter.iam.v3.AllowBindingExplanation.AnnotatedAllowMembership
	3,  // 54: google.cloud.policytroubleshooter.iam.v3.DenyRuleExplanation.AnnotatedPermissionMatching.permission_matching_state:type_name -> google.cloud.policytroubleshooter.iam.v3.PermissionPatternMatchingState
	5,  // 55: google.cloud.policytroubleshooter.iam.v3.DenyRuleExplanation.AnnotatedPermissionMatching.relevance:type_name -> google.cloud.policytroubleshooter.iam.v3.HeuristicRelevance
	4,  // 56: google.cloud.policytroubleshooter.iam.v3.DenyRuleExplanation.AnnotatedDenyPrincipalMatching.membership:type_name -> google.cloud.policytroubleshooter.iam.v3.MembershipMatchingState
	5,  // 57: google.cloud.policytroubleshooter.iam.v3.DenyRuleExplanation.AnnotatedDenyPrincipalMatching.relevance:type_name -> google.cloud.policytroubleshooter.iam.v3.HeuristicRelevance
	25, // 58: google.cloud.policytroubleshooter.iam.v3.DenyRuleExplanation.DeniedPermissionsEntry.value:type_name -> google.cloud.policytroubleshooter.iam.v3.DenyRuleExplanation.AnnotatedPermissionMatching
	25, // 59: google.cloud.policytroubleshooter.iam.v3.DenyRuleExplanation.ExceptionPermissionsEntry.value:type_name -> google.cloud.policytroubleshooter.iam.v3.DenyRuleExplanation.AnnotatedPermissionMatching
	26, // 60: google.cloud.policytroubleshooter.iam.v3.DenyRuleExplanation.DeniedPrincipalsEntry.value:type_name -> google.cloud.policytroubleshooter.iam.v3.DenyRuleExplanation.AnnotatedDenyPrincipalMatching
	26, // 61: google.cloud.policytroubleshooter.iam.v3.DenyRuleExplanation.ExceptionPrincipalsEntry.value:type_name -> google.cloud.policytroubleshooter.iam.v3.DenyRuleExplanation.AnnotatedDenyPrincipalMatching
	35, // 62: google.cloud.policytroubleshooter.iam.v3.ConditionExplanation.EvaluationState.value:type_name -> google.protobuf.Value
	36, // 63: google.cloud.policytroubleshooter.iam.v3.ConditionExplanation.EvaluationState.errors:type_name -> google.rpc.Status
	7,  // 64: google.cloud.policytroubleshooter.iam.v3.PolicyTroubleshooter.TroubleshootIamPolicy:input_type -> google.cloud.policytroubleshooter.iam.v3.TroubleshootIamPolicyRequest
	8,  // 65: google.cloud.policytroubleshooter.iam.v3.PolicyTroubleshooter.TroubleshootIamPolicy:output_type -> google.cloud.policytroubleshooter.iam.v3.TroubleshootIamPolicyResponse
	65, // [65:66] is the sub-list for method output_type
	64, // [64:65] is the sub-list for method input_type
	64, // [64:64] is the sub-list for extension type_name
	64, // [64:64] is the sub-list for extension extendee
	0,  // [0:64] is the sub-list for field type_name
}

func init() { file_google_cloud_policytroubleshooter_iam_v3_troubleshooter_proto_init() }
func file_google_cloud_policytroubleshooter_iam_v3_troubleshooter_proto_init() {
	if File_google_cloud_policytroubleshooter_iam_v3_troubleshooter_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_policytroubleshooter_iam_v3_troubleshooter_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TroubleshootIamPolicyRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_policytroubleshooter_iam_v3_troubleshooter_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TroubleshootIamPolicyResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_policytroubleshooter_iam_v3_troubleshooter_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AccessTuple); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_policytroubleshooter_iam_v3_troubleshooter_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ConditionContext); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_policytroubleshooter_iam_v3_troubleshooter_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AllowPolicyExplanation); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_policytroubleshooter_iam_v3_troubleshooter_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ExplainedAllowPolicy); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_policytroubleshooter_iam_v3_troubleshooter_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AllowBindingExplanation); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_policytroubleshooter_iam_v3_troubleshooter_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DenyPolicyExplanation); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_policytroubleshooter_iam_v3_troubleshooter_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ExplainedDenyResource); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_policytroubleshooter_iam_v3_troubleshooter_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ExplainedDenyPolicy); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_policytroubleshooter_iam_v3_troubleshooter_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DenyRuleExplanation); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_policytroubleshooter_iam_v3_troubleshooter_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ConditionExplanation); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_policytroubleshooter_iam_v3_troubleshooter_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ConditionContext_Resource); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_policytroubleshooter_iam_v3_troubleshooter_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ConditionContext_Peer); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_policytroubleshooter_iam_v3_troubleshooter_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ConditionContext_Request); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_policytroubleshooter_iam_v3_troubleshooter_proto_msgTypes[15].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ConditionContext_EffectiveTag); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_policytroubleshooter_iam_v3_troubleshooter_proto_msgTypes[16].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AllowBindingExplanation_AnnotatedAllowMembership); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_policytroubleshooter_iam_v3_troubleshooter_proto_msgTypes[18].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DenyRuleExplanation_AnnotatedPermissionMatching); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_policytroubleshooter_iam_v3_troubleshooter_proto_msgTypes[19].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DenyRuleExplanation_AnnotatedDenyPrincipalMatching); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_policytroubleshooter_iam_v3_troubleshooter_proto_msgTypes[24].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ConditionExplanation_EvaluationState); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_policytroubleshooter_iam_v3_troubleshooter_proto_rawDesc,
			NumEnums:      7,
			NumMessages:   25,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_cloud_policytroubleshooter_iam_v3_troubleshooter_proto_goTypes,
		DependencyIndexes: file_google_cloud_policytroubleshooter_iam_v3_troubleshooter_proto_depIdxs,
		EnumInfos:         file_google_cloud_policytroubleshooter_iam_v3_troubleshooter_proto_enumTypes,
		MessageInfos:      file_google_cloud_policytroubleshooter_iam_v3_troubleshooter_proto_msgTypes,
	}.Build()
	File_google_cloud_policytroubleshooter_iam_v3_troubleshooter_proto = out.File
	file_google_cloud_policytroubleshooter_iam_v3_troubleshooter_proto_rawDesc = nil
	file_google_cloud_policytroubleshooter_iam_v3_troubleshooter_proto_goTypes = nil
	file_google_cloud_policytroubleshooter_iam_v3_troubleshooter_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// PolicyTroubleshooterClient is the client API for PolicyTroubleshooter service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type PolicyTroubleshooterClient interface {
	// Checks whether a principal has a specific permission for a specific
	// resource, and explains why the principal does or doesn't have that
	// permission.
	TroubleshootIamPolicy(ctx context.Context, in *TroubleshootIamPolicyRequest, opts ...grpc.CallOption) (*TroubleshootIamPolicyResponse, error)
}

type policyTroubleshooterClient struct {
	cc grpc.ClientConnInterface
}

func NewPolicyTroubleshooterClient(cc grpc.ClientConnInterface) PolicyTroubleshooterClient {
	return &policyTroubleshooterClient{cc}
}

func (c *policyTroubleshooterClient) TroubleshootIamPolicy(ctx context.Context, in *TroubleshootIamPolicyRequest, opts ...grpc.CallOption) (*TroubleshootIamPolicyResponse, error) {
	out := new(TroubleshootIamPolicyResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.policytroubleshooter.iam.v3.PolicyTroubleshooter/TroubleshootIamPolicy", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// PolicyTroubleshooterServer is the server API for PolicyTroubleshooter service.
type PolicyTroubleshooterServer interface {
	// Checks whether a principal has a specific permission for a specific
	// resource, and explains why the principal does or doesn't have that
	// permission.
	TroubleshootIamPolicy(context.Context, *TroubleshootIamPolicyRequest) (*TroubleshootIamPolicyResponse, error)
}

// UnimplementedPolicyTroubleshooterServer can be embedded to have forward compatible implementations.
type UnimplementedPolicyTroubleshooterServer struct {
}

func (*UnimplementedPolicyTroubleshooterServer) TroubleshootIamPolicy(context.Context, *TroubleshootIamPolicyRequest) (*TroubleshootIamPolicyResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method TroubleshootIamPolicy not implemented")
}

func RegisterPolicyTroubleshooterServer(s *grpc.Server, srv PolicyTroubleshooterServer) {
	s.RegisterService(&_PolicyTroubleshooter_serviceDesc, srv)
}

func _PolicyTroubleshooter_TroubleshootIamPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(TroubleshootIamPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PolicyTroubleshooterServer).TroubleshootIamPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.policytroubleshooter.iam.v3.PolicyTroubleshooter/TroubleshootIamPolicy",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PolicyTroubleshooterServer).TroubleshootIamPolicy(ctx, req.(*TroubleshootIamPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _PolicyTroubleshooter_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.policytroubleshooter.iam.v3.PolicyTroubleshooter",
	HandlerType: (*PolicyTroubleshooterServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "TroubleshootIamPolicy",
			Handler:    _PolicyTroubleshooter_TroubleshootIamPolicy_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/policytroubleshooter/iam/v3/troubleshooter.proto",
}
