// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.32.0
// 	protoc        v4.23.2
// source: google/cloud/gkemulticloud/v1/aws_service.proto

package gkemulticloudpb

import (
	context "context"
	reflect "reflect"
	sync "sync"

	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	_ "google.golang.org/protobuf/types/known/emptypb"
	fieldmaskpb "google.golang.org/protobuf/types/known/fieldmaskpb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Request message for `AwsClusters.CreateAwsCluster` method.
type CreateAwsClusterRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent location where this
	// [AwsCluster][google.cloud.gkemulticloud.v1.AwsCluster] resource will be
	// created.
	//
	// Location names are formatted as `projects/<project-id>/locations/<region>`.
	//
	// See [Resource Names](https://cloud.google.com/apis/design/resource_names)
	// for more details on Google Cloud resource names.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The specification of the
	// [AwsCluster][google.cloud.gkemulticloud.v1.AwsCluster] to create.
	AwsCluster *AwsCluster `protobuf:"bytes,2,opt,name=aws_cluster,json=awsCluster,proto3" json:"aws_cluster,omitempty"`
	// Required. A client provided ID the resource. Must be unique within the
	// parent resource.
	//
	// The provided ID will be part of the
	// [AwsCluster][google.cloud.gkemulticloud.v1.AwsCluster] resource name
	// formatted as
	// `projects/<project-id>/locations/<region>/awsClusters/<cluster-id>`.
	//
	// Valid characters are `/[a-z][0-9]-/`. Cannot be longer than 63 characters.
	AwsClusterId string `protobuf:"bytes,3,opt,name=aws_cluster_id,json=awsClusterId,proto3" json:"aws_cluster_id,omitempty"`
	// If set, only validate the request, but do not actually create the cluster.
	ValidateOnly bool `protobuf:"varint,4,opt,name=validate_only,json=validateOnly,proto3" json:"validate_only,omitempty"`
}

func (x *CreateAwsClusterRequest) Reset() {
	*x = CreateAwsClusterRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_gkemulticloud_v1_aws_service_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateAwsClusterRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateAwsClusterRequest) ProtoMessage() {}

func (x *CreateAwsClusterRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkemulticloud_v1_aws_service_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateAwsClusterRequest.ProtoReflect.Descriptor instead.
func (*CreateAwsClusterRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkemulticloud_v1_aws_service_proto_rawDescGZIP(), []int{0}
}

func (x *CreateAwsClusterRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateAwsClusterRequest) GetAwsCluster() *AwsCluster {
	if x != nil {
		return x.AwsCluster
	}
	return nil
}

func (x *CreateAwsClusterRequest) GetAwsClusterId() string {
	if x != nil {
		return x.AwsClusterId
	}
	return ""
}

func (x *CreateAwsClusterRequest) GetValidateOnly() bool {
	if x != nil {
		return x.ValidateOnly
	}
	return false
}

// Request message for `AwsClusters.UpdateAwsCluster` method.
type UpdateAwsClusterRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The [AwsCluster][google.cloud.gkemulticloud.v1.AwsCluster]
	// resource to update.
	AwsCluster *AwsCluster `protobuf:"bytes,1,opt,name=aws_cluster,json=awsCluster,proto3" json:"aws_cluster,omitempty"`
	// If set, only validate the request, but do not actually update the cluster.
	ValidateOnly bool `protobuf:"varint,2,opt,name=validate_only,json=validateOnly,proto3" json:"validate_only,omitempty"`
	// Required. Mask of fields to update. At least one path must be supplied in
	// this field. The elements of the repeated paths field can only include these
	// fields from [AwsCluster][google.cloud.gkemulticloud.v1.AwsCluster]:
	//
	//   - `description`.
	//   - `annotations`.
	//   - `control_plane.version`.
	//   - `authorization.admin_users`.
	//   - `authorization.admin_groups`.
	//   - `binary_authorization.evaluation_mode`.
	//   - `control_plane.aws_services_authentication.role_arn`.
	//   - `control_plane.aws_services_authentication.role_session_name`.
	//   - `control_plane.config_encryption.kms_key_arn`.
	//   - `control_plane.instance_type`.
	//   - `control_plane.security_group_ids`.
	//   - `control_plane.proxy_config`.
	//   - `control_plane.proxy_config.secret_arn`.
	//   - `control_plane.proxy_config.secret_version`.
	//   - `control_plane.root_volume.size_gib`.
	//   - `control_plane.root_volume.volume_type`.
	//   - `control_plane.root_volume.iops`.
	//   - `control_plane.root_volume.throughput`.
	//   - `control_plane.root_volume.kms_key_arn`.
	//   - `control_plane.ssh_config`.
	//   - `control_plane.ssh_config.ec2_key_pair`.
	//   - `control_plane.instance_placement.tenancy`.
	//   - `control_plane.iam_instance_profile`.
	//   - `logging_config.component_config.enable_components`.
	//   - `control_plane.tags`.
	//   - `monitoring_config.managed_prometheus_config.enabled`.
	//   - `networking.per_node_pool_sg_rules_disabled`.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,4,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateAwsClusterRequest) Reset() {
	*x = UpdateAwsClusterRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_gkemulticloud_v1_aws_service_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateAwsClusterRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateAwsClusterRequest) ProtoMessage() {}

func (x *UpdateAwsClusterRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkemulticloud_v1_aws_service_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateAwsClusterRequest.ProtoReflect.Descriptor instead.
func (*UpdateAwsClusterRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkemulticloud_v1_aws_service_proto_rawDescGZIP(), []int{1}
}

func (x *UpdateAwsClusterRequest) GetAwsCluster() *AwsCluster {
	if x != nil {
		return x.AwsCluster
	}
	return nil
}

func (x *UpdateAwsClusterRequest) GetValidateOnly() bool {
	if x != nil {
		return x.ValidateOnly
	}
	return false
}

func (x *UpdateAwsClusterRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// Request message for `AwsClusters.GetAwsCluster` method.
type GetAwsClusterRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the
	// [AwsCluster][google.cloud.gkemulticloud.v1.AwsCluster] resource to
	// describe.
	//
	// `AwsCluster` names are formatted as
	// `projects/<project-id>/locations/<region>/awsClusters/<cluster-id>`.
	//
	// See [Resource Names](https://cloud.google.com/apis/design/resource_names)
	// for more details on Google Cloud Platform resource names.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetAwsClusterRequest) Reset() {
	*x = GetAwsClusterRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_gkemulticloud_v1_aws_service_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetAwsClusterRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetAwsClusterRequest) ProtoMessage() {}

func (x *GetAwsClusterRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkemulticloud_v1_aws_service_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetAwsClusterRequest.ProtoReflect.Descriptor instead.
func (*GetAwsClusterRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkemulticloud_v1_aws_service_proto_rawDescGZIP(), []int{2}
}

func (x *GetAwsClusterRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for `AwsClusters.ListAwsClusters` method.
type ListAwsClustersRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent location which owns this collection of
	// [AwsCluster][google.cloud.gkemulticloud.v1.AwsCluster] resources.
	//
	// Location names are formatted as `projects/<project-id>/locations/<region>`.
	//
	// See [Resource Names](https://cloud.google.com/apis/design/resource_names)
	// for more details on Google Cloud Platform resource names.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The maximum number of items to return.
	//
	// If not specified, a default value of 50 will be used by the service.
	// Regardless of the pageSize value, the response can include a partial list
	// and a caller should only rely on response's
	// [nextPageToken][google.cloud.gkemulticloud.v1.ListAwsClustersResponse.next_page_token]
	// to determine if there are more instances left to be queried.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// The `nextPageToken` value returned from a previous
	// [awsClusters.list][google.cloud.gkemulticloud.v1.AwsClusters.ListAwsClusters]
	// request, if any.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListAwsClustersRequest) Reset() {
	*x = ListAwsClustersRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_gkemulticloud_v1_aws_service_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListAwsClustersRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListAwsClustersRequest) ProtoMessage() {}

func (x *ListAwsClustersRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkemulticloud_v1_aws_service_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListAwsClustersRequest.ProtoReflect.Descriptor instead.
func (*ListAwsClustersRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkemulticloud_v1_aws_service_proto_rawDescGZIP(), []int{3}
}

func (x *ListAwsClustersRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListAwsClustersRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListAwsClustersRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// Response message for `AwsClusters.ListAwsClusters` method.
type ListAwsClustersResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A list of [AwsCluster][google.cloud.gkemulticloud.v1.AwsCluster] resources
	// in the specified Google Cloud Platform project and region region.
	AwsClusters []*AwsCluster `protobuf:"bytes,1,rep,name=aws_clusters,json=awsClusters,proto3" json:"aws_clusters,omitempty"`
	// Token to retrieve the next page of results, or empty if there are no more
	// results in the list.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListAwsClustersResponse) Reset() {
	*x = ListAwsClustersResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_gkemulticloud_v1_aws_service_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListAwsClustersResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListAwsClustersResponse) ProtoMessage() {}

func (x *ListAwsClustersResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkemulticloud_v1_aws_service_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListAwsClustersResponse.ProtoReflect.Descriptor instead.
func (*ListAwsClustersResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkemulticloud_v1_aws_service_proto_rawDescGZIP(), []int{4}
}

func (x *ListAwsClustersResponse) GetAwsClusters() []*AwsCluster {
	if x != nil {
		return x.AwsClusters
	}
	return nil
}

func (x *ListAwsClustersResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request message for `AwsClusters.DeleteAwsCluster` method.
type DeleteAwsClusterRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name the
	// [AwsCluster][google.cloud.gkemulticloud.v1.AwsCluster] to delete.
	//
	// `AwsCluster` names are formatted as
	// `projects/<project-id>/locations/<region>/awsClusters/<cluster-id>`.
	//
	// See [Resource Names](https://cloud.google.com/apis/design/resource_names)
	// for more details on Google Cloud Platform resource names.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// If set, only validate the request, but do not actually delete the resource.
	ValidateOnly bool `protobuf:"varint,2,opt,name=validate_only,json=validateOnly,proto3" json:"validate_only,omitempty"`
	// If set to true, and the
	// [AwsCluster][google.cloud.gkemulticloud.v1.AwsCluster] resource is not
	// found, the request will succeed but no action will be taken on the server
	// and a completed [Operation][google.longrunning.Operation] will be returned.
	//
	// Useful for idempotent deletion.
	AllowMissing bool `protobuf:"varint,3,opt,name=allow_missing,json=allowMissing,proto3" json:"allow_missing,omitempty"`
	// Optional. If set to true, the deletion of
	// [AwsCluster][google.cloud.gkemulticloud.v1.AwsCluster] resource will
	// succeed even if errors occur during deleting in cluster resources. Using
	// this parameter may result in orphaned resources in the cluster.
	IgnoreErrors bool `protobuf:"varint,5,opt,name=ignore_errors,json=ignoreErrors,proto3" json:"ignore_errors,omitempty"`
	// The current etag of the
	// [AwsCluster][google.cloud.gkemulticloud.v1.AwsCluster].
	//
	// Allows clients to perform deletions through optimistic concurrency control.
	//
	// If the provided etag does not match the current etag of the cluster,
	// the request will fail and an ABORTED error will be returned.
	Etag string `protobuf:"bytes,4,opt,name=etag,proto3" json:"etag,omitempty"`
}

func (x *DeleteAwsClusterRequest) Reset() {
	*x = DeleteAwsClusterRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_gkemulticloud_v1_aws_service_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteAwsClusterRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteAwsClusterRequest) ProtoMessage() {}

func (x *DeleteAwsClusterRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkemulticloud_v1_aws_service_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteAwsClusterRequest.ProtoReflect.Descriptor instead.
func (*DeleteAwsClusterRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkemulticloud_v1_aws_service_proto_rawDescGZIP(), []int{5}
}

func (x *DeleteAwsClusterRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *DeleteAwsClusterRequest) GetValidateOnly() bool {
	if x != nil {
		return x.ValidateOnly
	}
	return false
}

func (x *DeleteAwsClusterRequest) GetAllowMissing() bool {
	if x != nil {
		return x.AllowMissing
	}
	return false
}

func (x *DeleteAwsClusterRequest) GetIgnoreErrors() bool {
	if x != nil {
		return x.IgnoreErrors
	}
	return false
}

func (x *DeleteAwsClusterRequest) GetEtag() string {
	if x != nil {
		return x.Etag
	}
	return ""
}

// Response message for `AwsClusters.CreateAwsNodePool` method.
type CreateAwsNodePoolRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The [AwsCluster][google.cloud.gkemulticloud.v1.AwsCluster]
	// resource where this node pool will be created.
	//
	// `AwsCluster` names are formatted as
	// `projects/<project-id>/locations/<region>/awsClusters/<cluster-id>`.
	//
	// See [Resource Names](https://cloud.google.com/apis/design/resource_names)
	// for more details on Google Cloud resource names.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The specification of the
	// [AwsNodePool][google.cloud.gkemulticloud.v1.AwsNodePool] to create.
	AwsNodePool *AwsNodePool `protobuf:"bytes,2,opt,name=aws_node_pool,json=awsNodePool,proto3" json:"aws_node_pool,omitempty"`
	// Required. A client provided ID the resource. Must be unique within the
	// parent resource.
	//
	// The provided ID will be part of the
	// [AwsNodePool][google.cloud.gkemulticloud.v1.AwsNodePool] resource name
	// formatted as
	// `projects/<project-id>/locations/<region>/awsClusters/<cluster-id>/awsNodePools/<node-pool-id>`.
	//
	// Valid characters are `/[a-z][0-9]-/`. Cannot be longer than 63 characters.
	AwsNodePoolId string `protobuf:"bytes,3,opt,name=aws_node_pool_id,json=awsNodePoolId,proto3" json:"aws_node_pool_id,omitempty"`
	// If set, only validate the request, but do not actually create the node
	// pool.
	ValidateOnly bool `protobuf:"varint,4,opt,name=validate_only,json=validateOnly,proto3" json:"validate_only,omitempty"`
}

func (x *CreateAwsNodePoolRequest) Reset() {
	*x = CreateAwsNodePoolRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_gkemulticloud_v1_aws_service_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateAwsNodePoolRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateAwsNodePoolRequest) ProtoMessage() {}

func (x *CreateAwsNodePoolRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkemulticloud_v1_aws_service_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateAwsNodePoolRequest.ProtoReflect.Descriptor instead.
func (*CreateAwsNodePoolRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkemulticloud_v1_aws_service_proto_rawDescGZIP(), []int{6}
}

func (x *CreateAwsNodePoolRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateAwsNodePoolRequest) GetAwsNodePool() *AwsNodePool {
	if x != nil {
		return x.AwsNodePool
	}
	return nil
}

func (x *CreateAwsNodePoolRequest) GetAwsNodePoolId() string {
	if x != nil {
		return x.AwsNodePoolId
	}
	return ""
}

func (x *CreateAwsNodePoolRequest) GetValidateOnly() bool {
	if x != nil {
		return x.ValidateOnly
	}
	return false
}

// Request message for `AwsClusters.UpdateAwsNodePool` method.
type UpdateAwsNodePoolRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The [AwsNodePool][google.cloud.gkemulticloud.v1.AwsNodePool]
	// resource to update.
	AwsNodePool *AwsNodePool `protobuf:"bytes,1,opt,name=aws_node_pool,json=awsNodePool,proto3" json:"aws_node_pool,omitempty"`
	// If set, only validate the request, but don't actually update the node pool.
	ValidateOnly bool `protobuf:"varint,2,opt,name=validate_only,json=validateOnly,proto3" json:"validate_only,omitempty"`
	// Required. Mask of fields to update. At least one path must be supplied in
	// this field. The elements of the repeated paths field can only include these
	// fields from [AwsNodePool][google.cloud.gkemulticloud.v1.AwsNodePool]:
	//
	//   - `annotations`.
	//   - `version`.
	//   - `autoscaling.min_node_count`.
	//   - `autoscaling.max_node_count`.
	//   - `config.config_encryption.kms_key_arn`.
	//   - `config.security_group_ids`.
	//   - `config.root_volume.iops`.
	//   - `config.root_volume.throughput`.
	//   - `config.root_volume.kms_key_arn`.
	//   - `config.root_volume.volume_type`.
	//   - `config.root_volume.size_gib`.
	//   - `config.proxy_config`.
	//   - `config.proxy_config.secret_arn`.
	//   - `config.proxy_config.secret_version`.
	//   - `config.ssh_config`.
	//   - `config.ssh_config.ec2_key_pair`.
	//   - `config.instance_placement.tenancy`.
	//   - `config.iam_instance_profile`.
	//   - `config.labels`.
	//   - `config.tags`.
	//   - `config.autoscaling_metrics_collection`.
	//   - `config.autoscaling_metrics_collection.granularity`.
	//   - `config.autoscaling_metrics_collection.metrics`.
	//   - `config.instance_type`.
	//   - `management.auto_repair`.
	//   - `management`.
	//   - `update_settings`.
	//   - `update_settings.surge_settings`.
	//   - `update_settings.surge_settings.max_surge`.
	//   - `update_settings.surge_settings.max_unavailable`.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,3,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateAwsNodePoolRequest) Reset() {
	*x = UpdateAwsNodePoolRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_gkemulticloud_v1_aws_service_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateAwsNodePoolRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateAwsNodePoolRequest) ProtoMessage() {}

func (x *UpdateAwsNodePoolRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkemulticloud_v1_aws_service_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateAwsNodePoolRequest.ProtoReflect.Descriptor instead.
func (*UpdateAwsNodePoolRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkemulticloud_v1_aws_service_proto_rawDescGZIP(), []int{7}
}

func (x *UpdateAwsNodePoolRequest) GetAwsNodePool() *AwsNodePool {
	if x != nil {
		return x.AwsNodePool
	}
	return nil
}

func (x *UpdateAwsNodePoolRequest) GetValidateOnly() bool {
	if x != nil {
		return x.ValidateOnly
	}
	return false
}

func (x *UpdateAwsNodePoolRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// Request message for `AwsClusters.RollbackAwsNodePoolUpdate` method.
type RollbackAwsNodePoolUpdateRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the
	// [AwsNodePool][google.cloud.gkemulticloud.v1.AwsNodePool] resource to
	// rollback.
	//
	// `AwsNodePool` names are formatted as
	// `projects/<project-id>/locations/<region>/awsClusters/<cluster-id>/awsNodePools/<node-pool-id>`.
	//
	// See [Resource Names](https://cloud.google.com/apis/design/resource_names)
	// for more details on Google Cloud resource names.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. Option for rollback to ignore the PodDisruptionBudget when
	// draining the node pool nodes. Default value is false.
	RespectPdb bool `protobuf:"varint,2,opt,name=respect_pdb,json=respectPdb,proto3" json:"respect_pdb,omitempty"`
}

func (x *RollbackAwsNodePoolUpdateRequest) Reset() {
	*x = RollbackAwsNodePoolUpdateRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_gkemulticloud_v1_aws_service_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RollbackAwsNodePoolUpdateRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RollbackAwsNodePoolUpdateRequest) ProtoMessage() {}

func (x *RollbackAwsNodePoolUpdateRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkemulticloud_v1_aws_service_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RollbackAwsNodePoolUpdateRequest.ProtoReflect.Descriptor instead.
func (*RollbackAwsNodePoolUpdateRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkemulticloud_v1_aws_service_proto_rawDescGZIP(), []int{8}
}

func (x *RollbackAwsNodePoolUpdateRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *RollbackAwsNodePoolUpdateRequest) GetRespectPdb() bool {
	if x != nil {
		return x.RespectPdb
	}
	return false
}

// Request message for `AwsClusters.GetAwsNodePool` method.
type GetAwsNodePoolRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the
	// [AwsNodePool][google.cloud.gkemulticloud.v1.AwsNodePool] resource to
	// describe.
	//
	// `AwsNodePool` names are formatted as
	// `projects/<project-id>/locations/<region>/awsClusters/<cluster-id>/awsNodePools/<node-pool-id>`.
	//
	// See [Resource Names](https://cloud.google.com/apis/design/resource_names)
	// for more details on Google Cloud resource names.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetAwsNodePoolRequest) Reset() {
	*x = GetAwsNodePoolRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_gkemulticloud_v1_aws_service_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetAwsNodePoolRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetAwsNodePoolRequest) ProtoMessage() {}

func (x *GetAwsNodePoolRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkemulticloud_v1_aws_service_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetAwsNodePoolRequest.ProtoReflect.Descriptor instead.
func (*GetAwsNodePoolRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkemulticloud_v1_aws_service_proto_rawDescGZIP(), []int{9}
}

func (x *GetAwsNodePoolRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for `AwsClusters.ListAwsNodePools` method.
type ListAwsNodePoolsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent `AwsCluster` which owns this collection of
	// [AwsNodePool][google.cloud.gkemulticloud.v1.AwsNodePool] resources.
	//
	// `AwsCluster` names are formatted as
	// `projects/<project-id>/locations/<region>/awsClusters/<cluster-id>`.
	//
	// See [Resource Names](https://cloud.google.com/apis/design/resource_names)
	// for more details on Google Cloud resource names.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The maximum number of items to return.
	//
	// If not specified, a default value of 50 will be used by the service.
	// Regardless of the pageSize value, the response can include a partial list
	// and a caller should only rely on response's
	// [nextPageToken][google.cloud.gkemulticloud.v1.ListAwsNodePoolsResponse.next_page_token]
	// to determine if there are more instances left to be queried.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// The `nextPageToken` value returned from a previous
	// [awsNodePools.list][google.cloud.gkemulticloud.v1.AwsClusters.ListAwsNodePools]
	// request, if any.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListAwsNodePoolsRequest) Reset() {
	*x = ListAwsNodePoolsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_gkemulticloud_v1_aws_service_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListAwsNodePoolsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListAwsNodePoolsRequest) ProtoMessage() {}

func (x *ListAwsNodePoolsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkemulticloud_v1_aws_service_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListAwsNodePoolsRequest.ProtoReflect.Descriptor instead.
func (*ListAwsNodePoolsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkemulticloud_v1_aws_service_proto_rawDescGZIP(), []int{10}
}

func (x *ListAwsNodePoolsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListAwsNodePoolsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListAwsNodePoolsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// Response message for `AwsClusters.ListAwsNodePools` method.
type ListAwsNodePoolsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A list of [AwsNodePool][google.cloud.gkemulticloud.v1.AwsNodePool]
	// resources in the specified `AwsCluster`.
	AwsNodePools []*AwsNodePool `protobuf:"bytes,1,rep,name=aws_node_pools,json=awsNodePools,proto3" json:"aws_node_pools,omitempty"`
	// Token to retrieve the next page of results, or empty if there are no more
	// results in the list.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListAwsNodePoolsResponse) Reset() {
	*x = ListAwsNodePoolsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_gkemulticloud_v1_aws_service_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListAwsNodePoolsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListAwsNodePoolsResponse) ProtoMessage() {}

func (x *ListAwsNodePoolsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkemulticloud_v1_aws_service_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListAwsNodePoolsResponse.ProtoReflect.Descriptor instead.
func (*ListAwsNodePoolsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkemulticloud_v1_aws_service_proto_rawDescGZIP(), []int{11}
}

func (x *ListAwsNodePoolsResponse) GetAwsNodePools() []*AwsNodePool {
	if x != nil {
		return x.AwsNodePools
	}
	return nil
}

func (x *ListAwsNodePoolsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request message for `AwsClusters.DeleteAwsNodePool` method.
type DeleteAwsNodePoolRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name the
	// [AwsNodePool][google.cloud.gkemulticloud.v1.AwsNodePool] to delete.
	//
	// `AwsNodePool` names are formatted as
	// `projects/<project-id>/locations/<region>/awsClusters/<cluster-id>/awsNodePools/<node-pool-id>`.
	//
	// See [Resource Names](https://cloud.google.com/apis/design/resource_names)
	// for more details on Google Cloud resource names.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// If set, only validate the request, but do not actually delete the node
	// pool.
	ValidateOnly bool `protobuf:"varint,2,opt,name=validate_only,json=validateOnly,proto3" json:"validate_only,omitempty"`
	// If set to true, and the
	// [AwsNodePool][google.cloud.gkemulticloud.v1.AwsNodePool] resource is not
	// found, the request will succeed but no action will be taken on the server
	// and a completed [Operation][google.longrunning.Operation] will be returned.
	//
	// Useful for idempotent deletion.
	AllowMissing bool `protobuf:"varint,3,opt,name=allow_missing,json=allowMissing,proto3" json:"allow_missing,omitempty"`
	// Optional. If set to true, the deletion of
	// [AwsNodePool][google.cloud.gkemulticloud.v1.AwsNodePool] resource will
	// succeed even if errors occur during deleting in node pool resources. Using
	// this parameter may result in orphaned resources in the node pool.
	IgnoreErrors bool `protobuf:"varint,5,opt,name=ignore_errors,json=ignoreErrors,proto3" json:"ignore_errors,omitempty"`
	// The current ETag of the
	// [AwsNodePool][google.cloud.gkemulticloud.v1.AwsNodePool].
	//
	// Allows clients to perform deletions through optimistic concurrency control.
	//
	// If the provided ETag does not match the current etag of the node pool,
	// the request will fail and an ABORTED error will be returned.
	Etag string `protobuf:"bytes,4,opt,name=etag,proto3" json:"etag,omitempty"`
}

func (x *DeleteAwsNodePoolRequest) Reset() {
	*x = DeleteAwsNodePoolRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_gkemulticloud_v1_aws_service_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteAwsNodePoolRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteAwsNodePoolRequest) ProtoMessage() {}

func (x *DeleteAwsNodePoolRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkemulticloud_v1_aws_service_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteAwsNodePoolRequest.ProtoReflect.Descriptor instead.
func (*DeleteAwsNodePoolRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkemulticloud_v1_aws_service_proto_rawDescGZIP(), []int{12}
}

func (x *DeleteAwsNodePoolRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *DeleteAwsNodePoolRequest) GetValidateOnly() bool {
	if x != nil {
		return x.ValidateOnly
	}
	return false
}

func (x *DeleteAwsNodePoolRequest) GetAllowMissing() bool {
	if x != nil {
		return x.AllowMissing
	}
	return false
}

func (x *DeleteAwsNodePoolRequest) GetIgnoreErrors() bool {
	if x != nil {
		return x.IgnoreErrors
	}
	return false
}

func (x *DeleteAwsNodePoolRequest) GetEtag() string {
	if x != nil {
		return x.Etag
	}
	return ""
}

// GetAwsOpenIdConfigRequest gets the OIDC discovery document for the
// cluster. See the OpenID Connect Discovery 1.0 specification for details.
type GetAwsOpenIdConfigRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The AwsCluster, which owns the OIDC discovery document.
	// Format:
	// projects/{project}/locations/{location}/awsClusters/{cluster}
	AwsCluster string `protobuf:"bytes,1,opt,name=aws_cluster,json=awsCluster,proto3" json:"aws_cluster,omitempty"`
}

func (x *GetAwsOpenIdConfigRequest) Reset() {
	*x = GetAwsOpenIdConfigRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_gkemulticloud_v1_aws_service_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetAwsOpenIdConfigRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetAwsOpenIdConfigRequest) ProtoMessage() {}

func (x *GetAwsOpenIdConfigRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkemulticloud_v1_aws_service_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetAwsOpenIdConfigRequest.ProtoReflect.Descriptor instead.
func (*GetAwsOpenIdConfigRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkemulticloud_v1_aws_service_proto_rawDescGZIP(), []int{13}
}

func (x *GetAwsOpenIdConfigRequest) GetAwsCluster() string {
	if x != nil {
		return x.AwsCluster
	}
	return ""
}

// GetAwsJsonWebKeysRequest gets the public component of the keys used by the
// cluster to sign token requests. This will be the jwks_uri for the discover
// document returned by getOpenIDConfig. See the OpenID Connect
// Discovery 1.0 specification for details.
type GetAwsJsonWebKeysRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The AwsCluster, which owns the JsonWebKeys.
	// Format:
	// projects/{project}/locations/{location}/awsClusters/{cluster}
	AwsCluster string `protobuf:"bytes,1,opt,name=aws_cluster,json=awsCluster,proto3" json:"aws_cluster,omitempty"`
}

func (x *GetAwsJsonWebKeysRequest) Reset() {
	*x = GetAwsJsonWebKeysRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_gkemulticloud_v1_aws_service_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetAwsJsonWebKeysRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetAwsJsonWebKeysRequest) ProtoMessage() {}

func (x *GetAwsJsonWebKeysRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkemulticloud_v1_aws_service_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetAwsJsonWebKeysRequest.ProtoReflect.Descriptor instead.
func (*GetAwsJsonWebKeysRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkemulticloud_v1_aws_service_proto_rawDescGZIP(), []int{14}
}

func (x *GetAwsJsonWebKeysRequest) GetAwsCluster() string {
	if x != nil {
		return x.AwsCluster
	}
	return ""
}

// GetAwsServerConfigRequest gets the server config of GKE cluster on AWS.
type GetAwsServerConfigRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the
	// [AwsServerConfig][google.cloud.gkemulticloud.v1.AwsServerConfig] resource
	// to describe.
	//
	// `AwsServerConfig` names are formatted as
	// `projects/<project-id>/locations/<region>/awsServerConfig`.
	//
	// See [Resource Names](https://cloud.google.com/apis/design/resource_names)
	// for more details on Google Cloud resource names.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetAwsServerConfigRequest) Reset() {
	*x = GetAwsServerConfigRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_gkemulticloud_v1_aws_service_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetAwsServerConfigRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetAwsServerConfigRequest) ProtoMessage() {}

func (x *GetAwsServerConfigRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkemulticloud_v1_aws_service_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetAwsServerConfigRequest.ProtoReflect.Descriptor instead.
func (*GetAwsServerConfigRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkemulticloud_v1_aws_service_proto_rawDescGZIP(), []int{15}
}

func (x *GetAwsServerConfigRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for `AwsClusters.GenerateAwsAccessToken` method.
type GenerateAwsAccessTokenRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the
	// [AwsCluster][google.cloud.gkemulticloud.v1.AwsCluster] resource to
	// authenticate to.
	//
	// `AwsCluster` names are formatted as
	// `projects/<project-id>/locations/<region>/awsClusters/<cluster-id>`.
	//
	// See [Resource Names](https://cloud.google.com/apis/design/resource_names)
	// for more details on Google Cloud resource names.
	AwsCluster string `protobuf:"bytes,1,opt,name=aws_cluster,json=awsCluster,proto3" json:"aws_cluster,omitempty"`
}

func (x *GenerateAwsAccessTokenRequest) Reset() {
	*x = GenerateAwsAccessTokenRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_gkemulticloud_v1_aws_service_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GenerateAwsAccessTokenRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GenerateAwsAccessTokenRequest) ProtoMessage() {}

func (x *GenerateAwsAccessTokenRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkemulticloud_v1_aws_service_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GenerateAwsAccessTokenRequest.ProtoReflect.Descriptor instead.
func (*GenerateAwsAccessTokenRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkemulticloud_v1_aws_service_proto_rawDescGZIP(), []int{16}
}

func (x *GenerateAwsAccessTokenRequest) GetAwsCluster() string {
	if x != nil {
		return x.AwsCluster
	}
	return ""
}

// Response message for `AwsClusters.GenerateAwsAccessToken` method.
type GenerateAwsAccessTokenResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Access token to authenticate to k8s api-server.
	AccessToken string `protobuf:"bytes,1,opt,name=access_token,json=accessToken,proto3" json:"access_token,omitempty"`
	// Output only. Timestamp at which the token will expire.
	ExpirationTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=expiration_time,json=expirationTime,proto3" json:"expiration_time,omitempty"`
}

func (x *GenerateAwsAccessTokenResponse) Reset() {
	*x = GenerateAwsAccessTokenResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_gkemulticloud_v1_aws_service_proto_msgTypes[17]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GenerateAwsAccessTokenResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GenerateAwsAccessTokenResponse) ProtoMessage() {}

func (x *GenerateAwsAccessTokenResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkemulticloud_v1_aws_service_proto_msgTypes[17]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GenerateAwsAccessTokenResponse.ProtoReflect.Descriptor instead.
func (*GenerateAwsAccessTokenResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkemulticloud_v1_aws_service_proto_rawDescGZIP(), []int{17}
}

func (x *GenerateAwsAccessTokenResponse) GetAccessToken() string {
	if x != nil {
		return x.AccessToken
	}
	return ""
}

func (x *GenerateAwsAccessTokenResponse) GetExpirationTime() *timestamppb.Timestamp {
	if x != nil {
		return x.ExpirationTime
	}
	return nil
}

type GenerateAwsClusterAgentTokenRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required.
	AwsCluster string `protobuf:"bytes,1,opt,name=aws_cluster,json=awsCluster,proto3" json:"aws_cluster,omitempty"`
	// Required.
	SubjectToken string `protobuf:"bytes,2,opt,name=subject_token,json=subjectToken,proto3" json:"subject_token,omitempty"`
	// Required.
	SubjectTokenType string `protobuf:"bytes,3,opt,name=subject_token_type,json=subjectTokenType,proto3" json:"subject_token_type,omitempty"`
	// Required.
	Version string `protobuf:"bytes,4,opt,name=version,proto3" json:"version,omitempty"`
	// Optional.
	NodePoolId string `protobuf:"bytes,5,opt,name=node_pool_id,json=nodePoolId,proto3" json:"node_pool_id,omitempty"`
	// Optional.
	GrantType string `protobuf:"bytes,6,opt,name=grant_type,json=grantType,proto3" json:"grant_type,omitempty"`
	// Optional.
	Audience string `protobuf:"bytes,7,opt,name=audience,proto3" json:"audience,omitempty"`
	// Optional.
	Scope string `protobuf:"bytes,8,opt,name=scope,proto3" json:"scope,omitempty"`
	// Optional.
	RequestedTokenType string `protobuf:"bytes,9,opt,name=requested_token_type,json=requestedTokenType,proto3" json:"requested_token_type,omitempty"`
	// Optional.
	Options string `protobuf:"bytes,10,opt,name=options,proto3" json:"options,omitempty"`
}

func (x *GenerateAwsClusterAgentTokenRequest) Reset() {
	*x = GenerateAwsClusterAgentTokenRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_gkemulticloud_v1_aws_service_proto_msgTypes[18]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GenerateAwsClusterAgentTokenRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GenerateAwsClusterAgentTokenRequest) ProtoMessage() {}

func (x *GenerateAwsClusterAgentTokenRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkemulticloud_v1_aws_service_proto_msgTypes[18]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GenerateAwsClusterAgentTokenRequest.ProtoReflect.Descriptor instead.
func (*GenerateAwsClusterAgentTokenRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkemulticloud_v1_aws_service_proto_rawDescGZIP(), []int{18}
}

func (x *GenerateAwsClusterAgentTokenRequest) GetAwsCluster() string {
	if x != nil {
		return x.AwsCluster
	}
	return ""
}

func (x *GenerateAwsClusterAgentTokenRequest) GetSubjectToken() string {
	if x != nil {
		return x.SubjectToken
	}
	return ""
}

func (x *GenerateAwsClusterAgentTokenRequest) GetSubjectTokenType() string {
	if x != nil {
		return x.SubjectTokenType
	}
	return ""
}

func (x *GenerateAwsClusterAgentTokenRequest) GetVersion() string {
	if x != nil {
		return x.Version
	}
	return ""
}

func (x *GenerateAwsClusterAgentTokenRequest) GetNodePoolId() string {
	if x != nil {
		return x.NodePoolId
	}
	return ""
}

func (x *GenerateAwsClusterAgentTokenRequest) GetGrantType() string {
	if x != nil {
		return x.GrantType
	}
	return ""
}

func (x *GenerateAwsClusterAgentTokenRequest) GetAudience() string {
	if x != nil {
		return x.Audience
	}
	return ""
}

func (x *GenerateAwsClusterAgentTokenRequest) GetScope() string {
	if x != nil {
		return x.Scope
	}
	return ""
}

func (x *GenerateAwsClusterAgentTokenRequest) GetRequestedTokenType() string {
	if x != nil {
		return x.RequestedTokenType
	}
	return ""
}

func (x *GenerateAwsClusterAgentTokenRequest) GetOptions() string {
	if x != nil {
		return x.Options
	}
	return ""
}

type GenerateAwsClusterAgentTokenResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	AccessToken string `protobuf:"bytes,1,opt,name=access_token,json=accessToken,proto3" json:"access_token,omitempty"`
	ExpiresIn   int32  `protobuf:"varint,2,opt,name=expires_in,json=expiresIn,proto3" json:"expires_in,omitempty"`
	TokenType   string `protobuf:"bytes,3,opt,name=token_type,json=tokenType,proto3" json:"token_type,omitempty"`
}

func (x *GenerateAwsClusterAgentTokenResponse) Reset() {
	*x = GenerateAwsClusterAgentTokenResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_gkemulticloud_v1_aws_service_proto_msgTypes[19]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GenerateAwsClusterAgentTokenResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GenerateAwsClusterAgentTokenResponse) ProtoMessage() {}

func (x *GenerateAwsClusterAgentTokenResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkemulticloud_v1_aws_service_proto_msgTypes[19]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GenerateAwsClusterAgentTokenResponse.ProtoReflect.Descriptor instead.
func (*GenerateAwsClusterAgentTokenResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkemulticloud_v1_aws_service_proto_rawDescGZIP(), []int{19}
}

func (x *GenerateAwsClusterAgentTokenResponse) GetAccessToken() string {
	if x != nil {
		return x.AccessToken
	}
	return ""
}

func (x *GenerateAwsClusterAgentTokenResponse) GetExpiresIn() int32 {
	if x != nil {
		return x.ExpiresIn
	}
	return 0
}

func (x *GenerateAwsClusterAgentTokenResponse) GetTokenType() string {
	if x != nil {
		return x.TokenType
	}
	return ""
}

var File_google_cloud_gkemulticloud_v1_aws_service_proto protoreflect.FileDescriptor

var file_google_cloud_gkemulticloud_v1_aws_service_proto_rawDesc = []byte{
	0x0a, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x67,
	0x6b, 0x65, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x76, 0x31, 0x2f,
	0x61, 0x77, 0x73, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x12, 0x1d, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x67, 0x6b, 0x65, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x31,
	0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e,
	0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x63, 0x6c, 0x69, 0x65, 0x6e,
	0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69,
	0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x31, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2f, 0x67, 0x6b, 0x65, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f,
	0x76, 0x31, 0x2f, 0x61, 0x77, 0x73, 0x5f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x34, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x67, 0x6b, 0x65, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2f, 0x76, 0x31, 0x2f, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x5f, 0x72, 0x65, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x23, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67,
	0x2f, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x1b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2f, 0x65, 0x6d, 0x70, 0x74, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x20,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f,
	0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x22, 0x83, 0x02, 0x0a, 0x17, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x41, 0x77, 0x73, 0x43,
	0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x47, 0x0a,
	0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2f, 0xe0,
	0x41, 0x02, 0xfa, 0x41, 0x29, 0x12, 0x27, 0x67, 0x6b, 0x65, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x41, 0x77, 0x73, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x52, 0x06,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x4f, 0x0a, 0x0b, 0x61, 0x77, 0x73, 0x5f, 0x63, 0x6c,
	0x75, 0x73, 0x74, 0x65, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x6d, 0x75,
	0x6c, 0x74, 0x69, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x77, 0x73, 0x43,
	0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x61, 0x77, 0x73,
	0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x12, 0x29, 0x0a, 0x0e, 0x61, 0x77, 0x73, 0x5f, 0x63,
	0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x02, 0x52, 0x0c, 0x61, 0x77, 0x73, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72,
	0x49, 0x64, 0x12, 0x23, 0x0a, 0x0d, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6f,
	0x6e, 0x6c, 0x79, 0x18, 0x04, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0c, 0x76, 0x61, 0x6c, 0x69, 0x64,
	0x61, 0x74, 0x65, 0x4f, 0x6e, 0x6c, 0x79, 0x22, 0xd1, 0x01, 0x0a, 0x17, 0x55, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x41, 0x77, 0x73, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x4f, 0x0a, 0x0b, 0x61, 0x77, 0x73, 0x5f, 0x63, 0x6c, 0x75, 0x73, 0x74,
	0x65, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x6d, 0x75, 0x6c, 0x74, 0x69,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x77, 0x73, 0x43, 0x6c, 0x75, 0x73,
	0x74, 0x65, 0x72, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x61, 0x77, 0x73, 0x43, 0x6c, 0x75,
	0x73, 0x74, 0x65, 0x72, 0x12, 0x23, 0x0a, 0x0d, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65,
	0x5f, 0x6f, 0x6e, 0x6c, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0c, 0x76, 0x61, 0x6c,
	0x69, 0x64, 0x61, 0x74, 0x65, 0x4f, 0x6e, 0x6c, 0x79, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52,
	0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x22, 0x5b, 0x0a, 0x14, 0x47,
	0x65, 0x74, 0x41, 0x77, 0x73, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x43, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x2f, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x29, 0x0a, 0x27, 0x67, 0x6b, 0x65, 0x6d, 0x75,
	0x6c, 0x74, 0x69, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41, 0x77, 0x73, 0x43, 0x6c, 0x75, 0x73, 0x74,
	0x65, 0x72, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x9d, 0x01, 0x0a, 0x16, 0x4c, 0x69, 0x73,
	0x74, 0x41, 0x77, 0x73, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x73, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x47, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x2f, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x29, 0x12, 0x27, 0x67, 0x6b, 0x65,
	0x6d, 0x75, 0x6c, 0x74, 0x69, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41, 0x77, 0x73, 0x43, 0x6c, 0x75,
	0x73, 0x74, 0x65, 0x72, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09,
	0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52,
	0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67,
	0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70,
	0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x8f, 0x01, 0x0a, 0x17, 0x4c, 0x69, 0x73,
	0x74, 0x41, 0x77, 0x73, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x73, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x12, 0x4c, 0x0a, 0x0c, 0x61, 0x77, 0x73, 0x5f, 0x63, 0x6c, 0x75, 0x73,
	0x74, 0x65, 0x72, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x6d, 0x75, 0x6c,
	0x74, 0x69, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x77, 0x73, 0x43, 0x6c,
	0x75, 0x73, 0x74, 0x65, 0x72, 0x52, 0x0b, 0x61, 0x77, 0x73, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65,
	0x72, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f,
	0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78,
	0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0xe6, 0x01, 0x0a, 0x17, 0x44,
	0x65, 0x6c, 0x65, 0x74, 0x65, 0x41, 0x77, 0x73, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x43, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x2f, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x29, 0x0a, 0x27, 0x67, 0x6b,
	0x65, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41, 0x77, 0x73, 0x43, 0x6c,
	0x75, 0x73, 0x74, 0x65, 0x72, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x23, 0x0a, 0x0d, 0x76,
	0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6f, 0x6e, 0x6c, 0x79, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x08, 0x52, 0x0c, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x4f, 0x6e, 0x6c, 0x79,
	0x12, 0x23, 0x0a, 0x0d, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x5f, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6e,
	0x67, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0c, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x4d, 0x69,
	0x73, 0x73, 0x69, 0x6e, 0x67, 0x12, 0x28, 0x0a, 0x0d, 0x69, 0x67, 0x6e, 0x6f, 0x72, 0x65, 0x5f,
	0x65, 0x72, 0x72, 0x6f, 0x72, 0x73, 0x18, 0x05, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x0c, 0x69, 0x67, 0x6e, 0x6f, 0x72, 0x65, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x73, 0x12,
	0x12, 0x0a, 0x04, 0x65, 0x74, 0x61, 0x67, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x65,
	0x74, 0x61, 0x67, 0x22, 0x8c, 0x02, 0x0a, 0x18, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x41, 0x77,
	0x73, 0x4e, 0x6f, 0x64, 0x65, 0x50, 0x6f, 0x6f, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x48, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x30, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2a, 0x12, 0x28, 0x67, 0x6b, 0x65, 0x6d, 0x75, 0x6c,
	0x74, 0x69, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41, 0x77, 0x73, 0x4e, 0x6f, 0x64, 0x65, 0x50, 0x6f,
	0x6f, 0x6c, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x53, 0x0a, 0x0d, 0x61, 0x77,
	0x73, 0x5f, 0x6e, 0x6f, 0x64, 0x65, 0x5f, 0x70, 0x6f, 0x6f, 0x6c, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x67, 0x6b, 0x65, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76,
	0x31, 0x2e, 0x41, 0x77, 0x73, 0x4e, 0x6f, 0x64, 0x65, 0x50, 0x6f, 0x6f, 0x6c, 0x42, 0x03, 0xe0,
	0x41, 0x02, 0x52, 0x0b, 0x61, 0x77, 0x73, 0x4e, 0x6f, 0x64, 0x65, 0x50, 0x6f, 0x6f, 0x6c, 0x12,
	0x2c, 0x0a, 0x10, 0x61, 0x77, 0x73, 0x5f, 0x6e, 0x6f, 0x64, 0x65, 0x5f, 0x70, 0x6f, 0x6f, 0x6c,
	0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0d,
	0x61, 0x77, 0x73, 0x4e, 0x6f, 0x64, 0x65, 0x50, 0x6f, 0x6f, 0x6c, 0x49, 0x64, 0x12, 0x23, 0x0a,
	0x0d, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6f, 0x6e, 0x6c, 0x79, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x08, 0x52, 0x0c, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x4f, 0x6e,
	0x6c, 0x79, 0x22, 0xd6, 0x01, 0x0a, 0x18, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x41, 0x77, 0x73,
	0x4e, 0x6f, 0x64, 0x65, 0x50, 0x6f, 0x6f, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x53, 0x0a, 0x0d, 0x61, 0x77, 0x73, 0x5f, 0x6e, 0x6f, 0x64, 0x65, 0x5f, 0x70, 0x6f, 0x6f, 0x6c,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x77, 0x73, 0x4e, 0x6f, 0x64, 0x65, 0x50, 0x6f,
	0x6f, 0x6c, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0b, 0x61, 0x77, 0x73, 0x4e, 0x6f, 0x64, 0x65,
	0x50, 0x6f, 0x6f, 0x6c, 0x12, 0x23, 0x0a, 0x0d, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65,
	0x5f, 0x6f, 0x6e, 0x6c, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0c, 0x76, 0x61, 0x6c,
	0x69, 0x64, 0x61, 0x74, 0x65, 0x4f, 0x6e, 0x6c, 0x79, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52,
	0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x22, 0x8e, 0x01, 0x0a, 0x20,
	0x52, 0x6f, 0x6c, 0x6c, 0x62, 0x61, 0x63, 0x6b, 0x41, 0x77, 0x73, 0x4e, 0x6f, 0x64, 0x65, 0x50,
	0x6f, 0x6f, 0x6c, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x44, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x30,
	0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2a, 0x0a, 0x28, 0x67, 0x6b, 0x65, 0x6d, 0x75, 0x6c, 0x74, 0x69,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41, 0x77, 0x73, 0x4e, 0x6f, 0x64, 0x65, 0x50, 0x6f, 0x6f, 0x6c,
	0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x24, 0x0a, 0x0b, 0x72, 0x65, 0x73, 0x70, 0x65, 0x63,
	0x74, 0x5f, 0x70, 0x64, 0x62, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x0a, 0x72, 0x65, 0x73, 0x70, 0x65, 0x63, 0x74, 0x50, 0x64, 0x62, 0x22, 0x5d, 0x0a, 0x15,
	0x47, 0x65, 0x74, 0x41, 0x77, 0x73, 0x4e, 0x6f, 0x64, 0x65, 0x50, 0x6f, 0x6f, 0x6c, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x44, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x30, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2a, 0x0a, 0x28, 0x67, 0x6b, 0x65,
	0x6d, 0x75, 0x6c, 0x74, 0x69, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41, 0x77, 0x73, 0x4e, 0x6f, 0x64,
	0x65, 0x50, 0x6f, 0x6f, 0x6c, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x9f, 0x01, 0x0a, 0x17,
	0x4c, 0x69, 0x73, 0x74, 0x41, 0x77, 0x73, 0x4e, 0x6f, 0x64, 0x65, 0x50, 0x6f, 0x6f, 0x6c, 0x73,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x48, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x30, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2a, 0x12,
	0x28, 0x67, 0x6b, 0x65, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41, 0x77,
	0x73, 0x4e, 0x6f, 0x64, 0x65, 0x50, 0x6f, 0x6f, 0x6c, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d,
	0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x94, 0x01,
	0x0a, 0x18, 0x4c, 0x69, 0x73, 0x74, 0x41, 0x77, 0x73, 0x4e, 0x6f, 0x64, 0x65, 0x50, 0x6f, 0x6f,
	0x6c, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x50, 0x0a, 0x0e, 0x61, 0x77,
	0x73, 0x5f, 0x6e, 0x6f, 0x64, 0x65, 0x5f, 0x70, 0x6f, 0x6f, 0x6c, 0x73, 0x18, 0x01, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x67, 0x6b, 0x65, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x76, 0x31, 0x2e, 0x41, 0x77, 0x73, 0x4e, 0x6f, 0x64, 0x65, 0x50, 0x6f, 0x6f, 0x6c, 0x52, 0x0c,
	0x61, 0x77, 0x73, 0x4e, 0x6f, 0x64, 0x65, 0x50, 0x6f, 0x6f, 0x6c, 0x73, 0x12, 0x26, 0x0a, 0x0f,
	0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54,
	0x6f, 0x6b, 0x65, 0x6e, 0x22, 0xe8, 0x01, 0x0a, 0x18, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x41,
	0x77, 0x73, 0x4e, 0x6f, 0x64, 0x65, 0x50, 0x6f, 0x6f, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x44, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x30, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2a, 0x0a, 0x28, 0x67, 0x6b, 0x65, 0x6d, 0x75, 0x6c, 0x74,
	0x69, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41, 0x77, 0x73, 0x4e, 0x6f, 0x64, 0x65, 0x50, 0x6f, 0x6f,
	0x6c, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x23, 0x0a, 0x0d, 0x76, 0x61, 0x6c, 0x69, 0x64,
	0x61, 0x74, 0x65, 0x5f, 0x6f, 0x6e, 0x6c, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0c,
	0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x4f, 0x6e, 0x6c, 0x79, 0x12, 0x23, 0x0a, 0x0d,
	0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x5f, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6e, 0x67, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x08, 0x52, 0x0c, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x4d, 0x69, 0x73, 0x73, 0x69, 0x6e,
	0x67, 0x12, 0x28, 0x0a, 0x0d, 0x69, 0x67, 0x6e, 0x6f, 0x72, 0x65, 0x5f, 0x65, 0x72, 0x72, 0x6f,
	0x72, 0x73, 0x18, 0x05, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0c, 0x69,
	0x67, 0x6e, 0x6f, 0x72, 0x65, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x73, 0x12, 0x12, 0x0a, 0x04, 0x65,
	0x74, 0x61, 0x67, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x65, 0x74, 0x61, 0x67, 0x22,
	0x6d, 0x0a, 0x19, 0x47, 0x65, 0x74, 0x41, 0x77, 0x73, 0x4f, 0x70, 0x65, 0x6e, 0x49, 0x64, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x50, 0x0a, 0x0b,
	0x61, 0x77, 0x73, 0x5f, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x2f, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x29, 0x0a, 0x27, 0x67, 0x6b, 0x65, 0x6d, 0x75,
	0x6c, 0x74, 0x69, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41, 0x77, 0x73, 0x43, 0x6c, 0x75, 0x73, 0x74,
	0x65, 0x72, 0x52, 0x0a, 0x61, 0x77, 0x73, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x22, 0x6c,
	0x0a, 0x18, 0x47, 0x65, 0x74, 0x41, 0x77, 0x73, 0x4a, 0x73, 0x6f, 0x6e, 0x57, 0x65, 0x62, 0x4b,
	0x65, 0x79, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x50, 0x0a, 0x0b, 0x61, 0x77,
	0x73, 0x5f, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x2f, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x29, 0x0a, 0x27, 0x67, 0x6b, 0x65, 0x6d, 0x75, 0x6c, 0x74,
	0x69, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41, 0x77, 0x73, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72,
	0x52, 0x0a, 0x61, 0x77, 0x73, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x22, 0x65, 0x0a, 0x19,
	0x47, 0x65, 0x74, 0x41, 0x77, 0x73, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x48, 0x0a, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x34, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2e, 0x0a,
	0x2c, 0x67, 0x6b, 0x65, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41, 0x77,
	0x73, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x22, 0x71, 0x0a, 0x1d, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x41,
	0x77, 0x73, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x50, 0x0a, 0x0b, 0x61, 0x77, 0x73, 0x5f, 0x63, 0x6c, 0x75, 0x73,
	0x74, 0x65, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2f, 0xe0, 0x41, 0x02, 0xfa, 0x41,
	0x29, 0x0a, 0x27, 0x67, 0x6b, 0x65, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x41, 0x77, 0x73, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x52, 0x0a, 0x61, 0x77, 0x73, 0x43,
	0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x22, 0x92, 0x01, 0x0a, 0x1e, 0x47, 0x65, 0x6e, 0x65, 0x72,
	0x61, 0x74, 0x65, 0x41, 0x77, 0x73, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x54, 0x6f, 0x6b, 0x65,
	0x6e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x26, 0x0a, 0x0c, 0x61, 0x63, 0x63,
	0x65, 0x73, 0x73, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x0b, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x54, 0x6f, 0x6b, 0x65,
	0x6e, 0x12, 0x48, 0x0a, 0x0f, 0x65, 0x78, 0x70, 0x69, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f,
	0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d,
	0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0e, 0x65, 0x78, 0x70,
	0x69, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x69, 0x6d, 0x65, 0x22, 0xd0, 0x03, 0x0a, 0x23,
	0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x41, 0x77, 0x73, 0x43, 0x6c, 0x75, 0x73, 0x74,
	0x65, 0x72, 0x41, 0x67, 0x65, 0x6e, 0x74, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x50, 0x0a, 0x0b, 0x61, 0x77, 0x73, 0x5f, 0x63, 0x6c, 0x75, 0x73, 0x74,
	0x65, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2f, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x29,
	0x0a, 0x27, 0x67, 0x6b, 0x65, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41,
	0x77, 0x73, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x52, 0x0a, 0x61, 0x77, 0x73, 0x43, 0x6c,
	0x75, 0x73, 0x74, 0x65, 0x72, 0x12, 0x28, 0x0a, 0x0d, 0x73, 0x75, 0x62, 0x6a, 0x65, 0x63, 0x74,
	0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x02, 0x52, 0x0c, 0x73, 0x75, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12,
	0x31, 0x0a, 0x12, 0x73, 0x75, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e,
	0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02,
	0x52, 0x10, 0x73, 0x75, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x54, 0x79,
	0x70, 0x65, 0x12, 0x1d, 0x0a, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f,
	0x6e, 0x12, 0x25, 0x0a, 0x0c, 0x6e, 0x6f, 0x64, 0x65, 0x5f, 0x70, 0x6f, 0x6f, 0x6c, 0x5f, 0x69,
	0x64, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0a, 0x6e, 0x6f,
	0x64, 0x65, 0x50, 0x6f, 0x6f, 0x6c, 0x49, 0x64, 0x12, 0x22, 0x0a, 0x0a, 0x67, 0x72, 0x61, 0x6e,
	0x74, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x09, 0x67, 0x72, 0x61, 0x6e, 0x74, 0x54, 0x79, 0x70, 0x65, 0x12, 0x1f, 0x0a, 0x08,
	0x61, 0x75, 0x64, 0x69, 0x65, 0x6e, 0x63, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x52, 0x08, 0x61, 0x75, 0x64, 0x69, 0x65, 0x6e, 0x63, 0x65, 0x12, 0x19, 0x0a,
	0x05, 0x73, 0x63, 0x6f, 0x70, 0x65, 0x18, 0x08, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x05, 0x73, 0x63, 0x6f, 0x70, 0x65, 0x12, 0x35, 0x0a, 0x14, 0x72, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x65, 0x64, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x5f, 0x74, 0x79, 0x70, 0x65,
	0x18, 0x09, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x12, 0x72, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x65, 0x64, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x54, 0x79, 0x70, 0x65, 0x12,
	0x1d, 0x0a, 0x07, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x07, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x22, 0x87,
	0x01, 0x0a, 0x24, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x41, 0x77, 0x73, 0x43, 0x6c,
	0x75, 0x73, 0x74, 0x65, 0x72, 0x41, 0x67, 0x65, 0x6e, 0x74, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x21, 0x0a, 0x0c, 0x61, 0x63, 0x63, 0x65, 0x73,
	0x73, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x61,
	0x63, 0x63, 0x65, 0x73, 0x73, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x1d, 0x0a, 0x0a, 0x65, 0x78,
	0x70, 0x69, 0x72, 0x65, 0x73, 0x5f, 0x69, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x09,
	0x65, 0x78, 0x70, 0x69, 0x72, 0x65, 0x73, 0x49, 0x6e, 0x12, 0x1d, 0x0a, 0x0a, 0x74, 0x6f, 0x6b,
	0x65, 0x6e, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x74,
	0x6f, 0x6b, 0x65, 0x6e, 0x54, 0x79, 0x70, 0x65, 0x32, 0xa9, 0x1d, 0x0a, 0x0b, 0x41, 0x77, 0x73,
	0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x73, 0x12, 0xf6, 0x01, 0x0a, 0x10, 0x43, 0x72, 0x65,
	0x61, 0x74, 0x65, 0x41, 0x77, 0x73, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x12, 0x36, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65,
	0x6d, 0x75, 0x6c, 0x74, 0x69, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x72,
	0x65, 0x61, 0x74, 0x65, 0x41, 0x77, 0x73, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c,
	0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x22, 0x8a, 0x01, 0xca, 0x41, 0x1f, 0x0a, 0x0a, 0x41, 0x77, 0x73, 0x43,
	0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x21, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x2c, 0x61, 0x77, 0x73, 0x5f, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x2c, 0x61,
	0x77, 0x73, 0x5f, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x82, 0xd3, 0xe4,
	0x93, 0x02, 0x3e, 0x3a, 0x0b, 0x61, 0x77, 0x73, 0x5f, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72,
	0x22, 0x2f, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x61, 0x77, 0x73, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72,
	0x73, 0x12, 0xf8, 0x01, 0x0a, 0x10, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x41, 0x77, 0x73, 0x43,
	0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x12, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x76, 0x31, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x41, 0x77, 0x73,
	0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e,
	0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x8c, 0x01,
	0xca, 0x41, 0x1f, 0x0a, 0x0a, 0x41, 0x77, 0x73, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x12,
	0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61,
	0x74, 0x61, 0xda, 0x41, 0x17, 0x61, 0x77, 0x73, 0x5f, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72,
	0x2c, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x82, 0xd3, 0xe4, 0x93,
	0x02, 0x4a, 0x3a, 0x0b, 0x61, 0x77, 0x73, 0x5f, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x32,
	0x3b, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x61, 0x77, 0x73, 0x5f, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65,
	0x72, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f,
	0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x61, 0x77,
	0x73, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xaf, 0x01, 0x0a,
	0x0d, 0x47, 0x65, 0x74, 0x41, 0x77, 0x73, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x12, 0x33,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b,
	0x65, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x31, 0x2e, 0x47,
	0x65, 0x74, 0x41, 0x77, 0x73, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x76, 0x31, 0x2e, 0x41, 0x77, 0x73, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x22, 0x3e,
	0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x31, 0x12, 0x2f, 0x2f,
	0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f,
	0x61, 0x77, 0x73, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xc2,
	0x01, 0x0a, 0x0f, 0x4c, 0x69, 0x73, 0x74, 0x41, 0x77, 0x73, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65,
	0x72, 0x73, 0x12, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x67, 0x6b, 0x65, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x41, 0x77, 0x73, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65,
	0x72, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x6d, 0x75, 0x6c, 0x74,
	0x69, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x41, 0x77,
	0x73, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x22, 0x40, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93,
	0x02, 0x31, 0x12, 0x2f, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x61, 0x77, 0x73, 0x43, 0x6c, 0x75, 0x73, 0x74,
	0x65, 0x72, 0x73, 0x12, 0xd6, 0x01, 0x0a, 0x10, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x41, 0x77,
	0x73, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x12, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x6d, 0x75, 0x6c, 0x74, 0x69,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x41,
	0x77, 0x73, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75,
	0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22,
	0x6b, 0xca, 0x41, 0x2a, 0x0a, 0x15, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x12, 0x11, 0x4f, 0x70, 0x65,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x31, 0x2a, 0x2f, 0x2f, 0x76, 0x31,
	0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f,
	0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x61, 0x77,
	0x73, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0x87, 0x02, 0x0a,
	0x1c, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x41, 0x77, 0x73, 0x43, 0x6c, 0x75, 0x73,
	0x74, 0x65, 0x72, 0x41, 0x67, 0x65, 0x6e, 0x74, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x42, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65,
	0x6d, 0x75, 0x6c, 0x74, 0x69, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65,
	0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x41, 0x77, 0x73, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72,
	0x41, 0x67, 0x65, 0x6e, 0x74, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x43, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x67, 0x6b, 0x65, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76,
	0x31, 0x2e, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x41, 0x77, 0x73, 0x43, 0x6c, 0x75,
	0x73, 0x74, 0x65, 0x72, 0x41, 0x67, 0x65, 0x6e, 0x74, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x5e, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x58, 0x3a, 0x01,
	0x2a, 0x22, 0x53, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x61, 0x77, 0x73, 0x5f, 0x63, 0x6c, 0x75, 0x73,
	0x74, 0x65, 0x72, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x61, 0x77, 0x73, 0x43, 0x6c,
	0x75, 0x73, 0x74, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61,
	0x74, 0x65, 0x41, 0x77, 0x73, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x41, 0x67, 0x65, 0x6e,
	0x74, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0xec, 0x01, 0x0a, 0x16, 0x47, 0x65, 0x6e, 0x65, 0x72,
	0x61, 0x74, 0x65, 0x41, 0x77, 0x73, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x54, 0x6f, 0x6b, 0x65,
	0x6e, 0x12, 0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x67, 0x6b, 0x65, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76,
	0x31, 0x2e, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x41, 0x77, 0x73, 0x41, 0x63, 0x63,
	0x65, 0x73, 0x73, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67,
	0x6b, 0x65, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x31, 0x2e,
	0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x41, 0x77, 0x73, 0x41, 0x63, 0x63, 0x65, 0x73,
	0x73, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x55,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0x4f, 0x12, 0x4d, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x61, 0x77, 0x73,
	0x5f, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f,
	0x61, 0x77, 0x73, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x67,
	0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x41, 0x77, 0x73, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73,
	0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x8e, 0x02, 0x0a, 0x11, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65,
	0x41, 0x77, 0x73, 0x4e, 0x6f, 0x64, 0x65, 0x50, 0x6f, 0x6f, 0x6c, 0x12, 0x37, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x6d, 0x75,
	0x6c, 0x74, 0x69, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x61,
	0x74, 0x65, 0x41, 0x77, 0x73, 0x4e, 0x6f, 0x64, 0x65, 0x50, 0x6f, 0x6f, 0x6c, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f,
	0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x22, 0xa0, 0x01, 0xca, 0x41, 0x20, 0x0a, 0x0b, 0x41, 0x77, 0x73, 0x4e, 0x6f,
	0x64, 0x65, 0x50, 0x6f, 0x6f, 0x6c, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x25, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x2c, 0x61, 0x77, 0x73, 0x5f, 0x6e, 0x6f, 0x64, 0x65, 0x5f, 0x70, 0x6f, 0x6f, 0x6c,
	0x2c, 0x61, 0x77, 0x73, 0x5f, 0x6e, 0x6f, 0x64, 0x65, 0x5f, 0x70, 0x6f, 0x6f, 0x6c, 0x5f, 0x69,
	0x64, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x4f, 0x3a, 0x0d, 0x61, 0x77, 0x73, 0x5f, 0x6e, 0x6f, 0x64,
	0x65, 0x5f, 0x70, 0x6f, 0x6f, 0x6c, 0x22, 0x3e, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x61, 0x77, 0x73, 0x43, 0x6c,
	0x75, 0x73, 0x74, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x61, 0x77, 0x73, 0x4e, 0x6f, 0x64,
	0x65, 0x50, 0x6f, 0x6f, 0x6c, 0x73, 0x12, 0x90, 0x02, 0x0a, 0x11, 0x55, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x41, 0x77, 0x73, 0x4e, 0x6f, 0x64, 0x65, 0x50, 0x6f, 0x6f, 0x6c, 0x12, 0x37, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x6d,
	0x75, 0x6c, 0x74, 0x69, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x31, 0x2e, 0x55, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x41, 0x77, 0x73, 0x4e, 0x6f, 0x64, 0x65, 0x50, 0x6f, 0x6f, 0x6c, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c,
	0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x22, 0xa2, 0x01, 0xca, 0x41, 0x20, 0x0a, 0x0b, 0x41, 0x77, 0x73, 0x4e,
	0x6f, 0x64, 0x65, 0x50, 0x6f, 0x6f, 0x6c, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x19, 0x61, 0x77, 0x73,
	0x5f, 0x6e, 0x6f, 0x64, 0x65, 0x5f, 0x70, 0x6f, 0x6f, 0x6c, 0x2c, 0x75, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x5d, 0x3a, 0x0d, 0x61, 0x77,
	0x73, 0x5f, 0x6e, 0x6f, 0x64, 0x65, 0x5f, 0x70, 0x6f, 0x6f, 0x6c, 0x32, 0x4c, 0x2f, 0x76, 0x31,
	0x2f, 0x7b, 0x61, 0x77, 0x73, 0x5f, 0x6e, 0x6f, 0x64, 0x65, 0x5f, 0x70, 0x6f, 0x6f, 0x6c, 0x2e,
	0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x61, 0x77, 0x73, 0x43,
	0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x2f, 0x61, 0x77, 0x73, 0x4e, 0x6f, 0x64,
	0x65, 0x50, 0x6f, 0x6f, 0x6c, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xf9, 0x01, 0x0a, 0x19, 0x52, 0x6f,
	0x6c, 0x6c, 0x62, 0x61, 0x63, 0x6b, 0x41, 0x77, 0x73, 0x4e, 0x6f, 0x64, 0x65, 0x50, 0x6f, 0x6f,
	0x6c, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x12, 0x3f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x6f, 0x6c, 0x6c, 0x62, 0x61, 0x63, 0x6b,
	0x41, 0x77, 0x73, 0x4e, 0x6f, 0x64, 0x65, 0x50, 0x6f, 0x6f, 0x6c, 0x55, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70,
	0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x7c, 0xca, 0x41, 0x20, 0x0a, 0x0b, 0x41, 0x77,
	0x73, 0x4e, 0x6f, 0x64, 0x65, 0x50, 0x6f, 0x6f, 0x6c, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x4c, 0x3a, 0x01, 0x2a, 0x22, 0x47, 0x2f, 0x76,
	0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73,
	0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x61,
	0x77, 0x73, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x2f, 0x61, 0x77, 0x73,
	0x4e, 0x6f, 0x64, 0x65, 0x50, 0x6f, 0x6f, 0x6c, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x72, 0x6f, 0x6c,
	0x6c, 0x62, 0x61, 0x63, 0x6b, 0x12, 0xc1, 0x01, 0x0a, 0x0e, 0x47, 0x65, 0x74, 0x41, 0x77, 0x73,
	0x4e, 0x6f, 0x64, 0x65, 0x50, 0x6f, 0x6f, 0x6c, 0x12, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x6d, 0x75, 0x6c, 0x74, 0x69,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x41, 0x77, 0x73, 0x4e,
	0x6f, 0x64, 0x65, 0x50, 0x6f, 0x6f, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b,
	0x65, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x31, 0x2e, 0x41,
	0x77, 0x73, 0x4e, 0x6f, 0x64, 0x65, 0x50, 0x6f, 0x6f, 0x6c, 0x22, 0x4d, 0xda, 0x41, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x40, 0x12, 0x3e, 0x2f, 0x76, 0x31, 0x2f, 0x7b,
	0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x61, 0x77, 0x73, 0x43,
	0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x2f, 0x61, 0x77, 0x73, 0x4e, 0x6f, 0x64,
	0x65, 0x50, 0x6f, 0x6f, 0x6c, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xd4, 0x01, 0x0a, 0x10, 0x4c, 0x69,
	0x73, 0x74, 0x41, 0x77, 0x73, 0x4e, 0x6f, 0x64, 0x65, 0x50, 0x6f, 0x6f, 0x6c, 0x73, 0x12, 0x36,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b,
	0x65, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x31, 0x2e, 0x4c,
	0x69, 0x73, 0x74, 0x41, 0x77, 0x73, 0x4e, 0x6f, 0x64, 0x65, 0x50, 0x6f, 0x6f, 0x6c, 0x73, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x41, 0x77, 0x73, 0x4e, 0x6f,
	0x64, 0x65, 0x50, 0x6f, 0x6f, 0x6c, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22,
	0x4f, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x40,
	0x12, 0x3e, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x61, 0x77, 0x73, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x73,
	0x2f, 0x2a, 0x7d, 0x2f, 0x61, 0x77, 0x73, 0x4e, 0x6f, 0x64, 0x65, 0x50, 0x6f, 0x6f, 0x6c, 0x73,
	0x12, 0xe7, 0x01, 0x0a, 0x11, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x41, 0x77, 0x73, 0x4e, 0x6f,
	0x64, 0x65, 0x50, 0x6f, 0x6f, 0x6c, 0x12, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x41, 0x77, 0x73,
	0x4e, 0x6f, 0x64, 0x65, 0x50, 0x6f, 0x6f, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e,
	0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x7a,
	0xca, 0x41, 0x2a, 0x0a, 0x15, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x40, 0x2a, 0x3e, 0x2f, 0x76, 0x31, 0x2f,
	0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a,
	0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x61, 0x77, 0x73,
	0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x2f, 0x61, 0x77, 0x73, 0x4e, 0x6f,
	0x64, 0x65, 0x50, 0x6f, 0x6f, 0x6c, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xdf, 0x01, 0x0a, 0x12, 0x47,
	0x65, 0x74, 0x41, 0x77, 0x73, 0x4f, 0x70, 0x65, 0x6e, 0x49, 0x64, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x12, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x67, 0x6b, 0x65, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76,
	0x31, 0x2e, 0x47, 0x65, 0x74, 0x41, 0x77, 0x73, 0x4f, 0x70, 0x65, 0x6e, 0x49, 0x64, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2e, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x6d, 0x75,
	0x6c, 0x74, 0x69, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x77, 0x73, 0x4f,
	0x70, 0x65, 0x6e, 0x49, 0x64, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x22, 0x5f, 0x82, 0xd3, 0xe4,
	0x93, 0x02, 0x59, 0x12, 0x57, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x61, 0x77, 0x73, 0x5f, 0x63, 0x6c,
	0x75, 0x73, 0x74, 0x65, 0x72, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a,
	0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x61, 0x77, 0x73,
	0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x2e, 0x77, 0x65, 0x6c,
	0x6c, 0x2d, 0x6b, 0x6e, 0x6f, 0x77, 0x6e, 0x2f, 0x6f, 0x70, 0x65, 0x6e, 0x69, 0x64, 0x2d, 0x63,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0xc0, 0x01, 0x0a,
	0x11, 0x47, 0x65, 0x74, 0x41, 0x77, 0x73, 0x4a, 0x73, 0x6f, 0x6e, 0x57, 0x65, 0x62, 0x4b, 0x65,
	0x79, 0x73, 0x12, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x67, 0x6b, 0x65, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x41, 0x77, 0x73, 0x4a, 0x73, 0x6f, 0x6e, 0x57, 0x65, 0x62,
	0x4b, 0x65, 0x79, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2d, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x6d, 0x75,
	0x6c, 0x74, 0x69, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x77, 0x73, 0x4a,
	0x73, 0x6f, 0x6e, 0x57, 0x65, 0x62, 0x4b, 0x65, 0x79, 0x73, 0x22, 0x43, 0x82, 0xd3, 0xe4, 0x93,
	0x02, 0x3d, 0x12, 0x3b, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x61, 0x77, 0x73, 0x5f, 0x63, 0x6c, 0x75,
	0x73, 0x74, 0x65, 0x72, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x61, 0x77, 0x73, 0x43,
	0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x6a, 0x77, 0x6b, 0x73, 0x12,
	0xc0, 0x01, 0x0a, 0x12, 0x47, 0x65, 0x74, 0x41, 0x77, 0x73, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x41, 0x77, 0x73, 0x53, 0x65, 0x72,
	0x76, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x67, 0x6b, 0x65, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x31,
	0x2e, 0x41, 0x77, 0x73, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x22, 0x40, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x33, 0x12,
	0x31, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x2a, 0x2f, 0x61, 0x77, 0x73, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x7d, 0x1a, 0x50, 0xca, 0x41, 0x1c, 0x67, 0x6b, 0x65, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0xd2, 0x41, 0x2e, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77,
	0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2d, 0x70, 0x6c, 0x61, 0x74,
	0x66, 0x6f, 0x72, 0x6d, 0x42, 0xe2, 0x01, 0x0a, 0x21, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x6d, 0x75, 0x6c,
	0x74, 0x69, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x31, 0x42, 0x0f, 0x41, 0x77, 0x73, 0x53,
	0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x47, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x67, 0x6f, 0x2f, 0x67, 0x6b, 0x65, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2f, 0x61, 0x70, 0x69, 0x76, 0x31, 0x2f, 0x67, 0x6b, 0x65, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x70, 0x62, 0x3b, 0x67, 0x6b, 0x65, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x70, 0x62, 0xaa, 0x02, 0x1d, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x47, 0x6b, 0x65, 0x4d, 0x75, 0x6c, 0x74, 0x69, 0x43, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x56, 0x31, 0xca, 0x02, 0x1d, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c,
	0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x47, 0x6b, 0x65, 0x4d, 0x75, 0x6c, 0x74, 0x69, 0x43, 0x6c,
	0x6f, 0x75, 0x64, 0x5c, 0x56, 0x31, 0xea, 0x02, 0x20, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a,
	0x3a, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x47, 0x6b, 0x65, 0x4d, 0x75, 0x6c, 0x74, 0x69,
	0x43, 0x6c, 0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x56, 0x31, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x33,
}

var (
	file_google_cloud_gkemulticloud_v1_aws_service_proto_rawDescOnce sync.Once
	file_google_cloud_gkemulticloud_v1_aws_service_proto_rawDescData = file_google_cloud_gkemulticloud_v1_aws_service_proto_rawDesc
)

func file_google_cloud_gkemulticloud_v1_aws_service_proto_rawDescGZIP() []byte {
	file_google_cloud_gkemulticloud_v1_aws_service_proto_rawDescOnce.Do(func() {
		file_google_cloud_gkemulticloud_v1_aws_service_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_gkemulticloud_v1_aws_service_proto_rawDescData)
	})
	return file_google_cloud_gkemulticloud_v1_aws_service_proto_rawDescData
}

var file_google_cloud_gkemulticloud_v1_aws_service_proto_msgTypes = make([]protoimpl.MessageInfo, 20)
var file_google_cloud_gkemulticloud_v1_aws_service_proto_goTypes = []interface{}{
	(*CreateAwsClusterRequest)(nil),              // 0: google.cloud.gkemulticloud.v1.CreateAwsClusterRequest
	(*UpdateAwsClusterRequest)(nil),              // 1: google.cloud.gkemulticloud.v1.UpdateAwsClusterRequest
	(*GetAwsClusterRequest)(nil),                 // 2: google.cloud.gkemulticloud.v1.GetAwsClusterRequest
	(*ListAwsClustersRequest)(nil),               // 3: google.cloud.gkemulticloud.v1.ListAwsClustersRequest
	(*ListAwsClustersResponse)(nil),              // 4: google.cloud.gkemulticloud.v1.ListAwsClustersResponse
	(*DeleteAwsClusterRequest)(nil),              // 5: google.cloud.gkemulticloud.v1.DeleteAwsClusterRequest
	(*CreateAwsNodePoolRequest)(nil),             // 6: google.cloud.gkemulticloud.v1.CreateAwsNodePoolRequest
	(*UpdateAwsNodePoolRequest)(nil),             // 7: google.cloud.gkemulticloud.v1.UpdateAwsNodePoolRequest
	(*RollbackAwsNodePoolUpdateRequest)(nil),     // 8: google.cloud.gkemulticloud.v1.RollbackAwsNodePoolUpdateRequest
	(*GetAwsNodePoolRequest)(nil),                // 9: google.cloud.gkemulticloud.v1.GetAwsNodePoolRequest
	(*ListAwsNodePoolsRequest)(nil),              // 10: google.cloud.gkemulticloud.v1.ListAwsNodePoolsRequest
	(*ListAwsNodePoolsResponse)(nil),             // 11: google.cloud.gkemulticloud.v1.ListAwsNodePoolsResponse
	(*DeleteAwsNodePoolRequest)(nil),             // 12: google.cloud.gkemulticloud.v1.DeleteAwsNodePoolRequest
	(*GetAwsOpenIdConfigRequest)(nil),            // 13: google.cloud.gkemulticloud.v1.GetAwsOpenIdConfigRequest
	(*GetAwsJsonWebKeysRequest)(nil),             // 14: google.cloud.gkemulticloud.v1.GetAwsJsonWebKeysRequest
	(*GetAwsServerConfigRequest)(nil),            // 15: google.cloud.gkemulticloud.v1.GetAwsServerConfigRequest
	(*GenerateAwsAccessTokenRequest)(nil),        // 16: google.cloud.gkemulticloud.v1.GenerateAwsAccessTokenRequest
	(*GenerateAwsAccessTokenResponse)(nil),       // 17: google.cloud.gkemulticloud.v1.GenerateAwsAccessTokenResponse
	(*GenerateAwsClusterAgentTokenRequest)(nil),  // 18: google.cloud.gkemulticloud.v1.GenerateAwsClusterAgentTokenRequest
	(*GenerateAwsClusterAgentTokenResponse)(nil), // 19: google.cloud.gkemulticloud.v1.GenerateAwsClusterAgentTokenResponse
	(*AwsCluster)(nil),                           // 20: google.cloud.gkemulticloud.v1.AwsCluster
	(*fieldmaskpb.FieldMask)(nil),                // 21: google.protobuf.FieldMask
	(*AwsNodePool)(nil),                          // 22: google.cloud.gkemulticloud.v1.AwsNodePool
	(*timestamppb.Timestamp)(nil),                // 23: google.protobuf.Timestamp
	(*longrunningpb.Operation)(nil),              // 24: google.longrunning.Operation
	(*AwsOpenIdConfig)(nil),                      // 25: google.cloud.gkemulticloud.v1.AwsOpenIdConfig
	(*AwsJsonWebKeys)(nil),                       // 26: google.cloud.gkemulticloud.v1.AwsJsonWebKeys
	(*AwsServerConfig)(nil),                      // 27: google.cloud.gkemulticloud.v1.AwsServerConfig
}
var file_google_cloud_gkemulticloud_v1_aws_service_proto_depIdxs = []int32{
	20, // 0: google.cloud.gkemulticloud.v1.CreateAwsClusterRequest.aws_cluster:type_name -> google.cloud.gkemulticloud.v1.AwsCluster
	20, // 1: google.cloud.gkemulticloud.v1.UpdateAwsClusterRequest.aws_cluster:type_name -> google.cloud.gkemulticloud.v1.AwsCluster
	21, // 2: google.cloud.gkemulticloud.v1.UpdateAwsClusterRequest.update_mask:type_name -> google.protobuf.FieldMask
	20, // 3: google.cloud.gkemulticloud.v1.ListAwsClustersResponse.aws_clusters:type_name -> google.cloud.gkemulticloud.v1.AwsCluster
	22, // 4: google.cloud.gkemulticloud.v1.CreateAwsNodePoolRequest.aws_node_pool:type_name -> google.cloud.gkemulticloud.v1.AwsNodePool
	22, // 5: google.cloud.gkemulticloud.v1.UpdateAwsNodePoolRequest.aws_node_pool:type_name -> google.cloud.gkemulticloud.v1.AwsNodePool
	21, // 6: google.cloud.gkemulticloud.v1.UpdateAwsNodePoolRequest.update_mask:type_name -> google.protobuf.FieldMask
	22, // 7: google.cloud.gkemulticloud.v1.ListAwsNodePoolsResponse.aws_node_pools:type_name -> google.cloud.gkemulticloud.v1.AwsNodePool
	23, // 8: google.cloud.gkemulticloud.v1.GenerateAwsAccessTokenResponse.expiration_time:type_name -> google.protobuf.Timestamp
	0,  // 9: google.cloud.gkemulticloud.v1.AwsClusters.CreateAwsCluster:input_type -> google.cloud.gkemulticloud.v1.CreateAwsClusterRequest
	1,  // 10: google.cloud.gkemulticloud.v1.AwsClusters.UpdateAwsCluster:input_type -> google.cloud.gkemulticloud.v1.UpdateAwsClusterRequest
	2,  // 11: google.cloud.gkemulticloud.v1.AwsClusters.GetAwsCluster:input_type -> google.cloud.gkemulticloud.v1.GetAwsClusterRequest
	3,  // 12: google.cloud.gkemulticloud.v1.AwsClusters.ListAwsClusters:input_type -> google.cloud.gkemulticloud.v1.ListAwsClustersRequest
	5,  // 13: google.cloud.gkemulticloud.v1.AwsClusters.DeleteAwsCluster:input_type -> google.cloud.gkemulticloud.v1.DeleteAwsClusterRequest
	18, // 14: google.cloud.gkemulticloud.v1.AwsClusters.GenerateAwsClusterAgentToken:input_type -> google.cloud.gkemulticloud.v1.GenerateAwsClusterAgentTokenRequest
	16, // 15: google.cloud.gkemulticloud.v1.AwsClusters.GenerateAwsAccessToken:input_type -> google.cloud.gkemulticloud.v1.GenerateAwsAccessTokenRequest
	6,  // 16: google.cloud.gkemulticloud.v1.AwsClusters.CreateAwsNodePool:input_type -> google.cloud.gkemulticloud.v1.CreateAwsNodePoolRequest
	7,  // 17: google.cloud.gkemulticloud.v1.AwsClusters.UpdateAwsNodePool:input_type -> google.cloud.gkemulticloud.v1.UpdateAwsNodePoolRequest
	8,  // 18: google.cloud.gkemulticloud.v1.AwsClusters.RollbackAwsNodePoolUpdate:input_type -> google.cloud.gkemulticloud.v1.RollbackAwsNodePoolUpdateRequest
	9,  // 19: google.cloud.gkemulticloud.v1.AwsClusters.GetAwsNodePool:input_type -> google.cloud.gkemulticloud.v1.GetAwsNodePoolRequest
	10, // 20: google.cloud.gkemulticloud.v1.AwsClusters.ListAwsNodePools:input_type -> google.cloud.gkemulticloud.v1.ListAwsNodePoolsRequest
	12, // 21: google.cloud.gkemulticloud.v1.AwsClusters.DeleteAwsNodePool:input_type -> google.cloud.gkemulticloud.v1.DeleteAwsNodePoolRequest
	13, // 22: google.cloud.gkemulticloud.v1.AwsClusters.GetAwsOpenIdConfig:input_type -> google.cloud.gkemulticloud.v1.GetAwsOpenIdConfigRequest
	14, // 23: google.cloud.gkemulticloud.v1.AwsClusters.GetAwsJsonWebKeys:input_type -> google.cloud.gkemulticloud.v1.GetAwsJsonWebKeysRequest
	15, // 24: google.cloud.gkemulticloud.v1.AwsClusters.GetAwsServerConfig:input_type -> google.cloud.gkemulticloud.v1.GetAwsServerConfigRequest
	24, // 25: google.cloud.gkemulticloud.v1.AwsClusters.CreateAwsCluster:output_type -> google.longrunning.Operation
	24, // 26: google.cloud.gkemulticloud.v1.AwsClusters.UpdateAwsCluster:output_type -> google.longrunning.Operation
	20, // 27: google.cloud.gkemulticloud.v1.AwsClusters.GetAwsCluster:output_type -> google.cloud.gkemulticloud.v1.AwsCluster
	4,  // 28: google.cloud.gkemulticloud.v1.AwsClusters.ListAwsClusters:output_type -> google.cloud.gkemulticloud.v1.ListAwsClustersResponse
	24, // 29: google.cloud.gkemulticloud.v1.AwsClusters.DeleteAwsCluster:output_type -> google.longrunning.Operation
	19, // 30: google.cloud.gkemulticloud.v1.AwsClusters.GenerateAwsClusterAgentToken:output_type -> google.cloud.gkemulticloud.v1.GenerateAwsClusterAgentTokenResponse
	17, // 31: google.cloud.gkemulticloud.v1.AwsClusters.GenerateAwsAccessToken:output_type -> google.cloud.gkemulticloud.v1.GenerateAwsAccessTokenResponse
	24, // 32: google.cloud.gkemulticloud.v1.AwsClusters.CreateAwsNodePool:output_type -> google.longrunning.Operation
	24, // 33: google.cloud.gkemulticloud.v1.AwsClusters.UpdateAwsNodePool:output_type -> google.longrunning.Operation
	24, // 34: google.cloud.gkemulticloud.v1.AwsClusters.RollbackAwsNodePoolUpdate:output_type -> google.longrunning.Operation
	22, // 35: google.cloud.gkemulticloud.v1.AwsClusters.GetAwsNodePool:output_type -> google.cloud.gkemulticloud.v1.AwsNodePool
	11, // 36: google.cloud.gkemulticloud.v1.AwsClusters.ListAwsNodePools:output_type -> google.cloud.gkemulticloud.v1.ListAwsNodePoolsResponse
	24, // 37: google.cloud.gkemulticloud.v1.AwsClusters.DeleteAwsNodePool:output_type -> google.longrunning.Operation
	25, // 38: google.cloud.gkemulticloud.v1.AwsClusters.GetAwsOpenIdConfig:output_type -> google.cloud.gkemulticloud.v1.AwsOpenIdConfig
	26, // 39: google.cloud.gkemulticloud.v1.AwsClusters.GetAwsJsonWebKeys:output_type -> google.cloud.gkemulticloud.v1.AwsJsonWebKeys
	27, // 40: google.cloud.gkemulticloud.v1.AwsClusters.GetAwsServerConfig:output_type -> google.cloud.gkemulticloud.v1.AwsServerConfig
	25, // [25:41] is the sub-list for method output_type
	9,  // [9:25] is the sub-list for method input_type
	9,  // [9:9] is the sub-list for extension type_name
	9,  // [9:9] is the sub-list for extension extendee
	0,  // [0:9] is the sub-list for field type_name
}

func init() { file_google_cloud_gkemulticloud_v1_aws_service_proto_init() }
func file_google_cloud_gkemulticloud_v1_aws_service_proto_init() {
	if File_google_cloud_gkemulticloud_v1_aws_service_proto != nil {
		return
	}
	file_google_cloud_gkemulticloud_v1_aws_resources_proto_init()
	file_google_cloud_gkemulticloud_v1_common_resources_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_gkemulticloud_v1_aws_service_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateAwsClusterRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_gkemulticloud_v1_aws_service_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateAwsClusterRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_gkemulticloud_v1_aws_service_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetAwsClusterRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_gkemulticloud_v1_aws_service_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListAwsClustersRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_gkemulticloud_v1_aws_service_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListAwsClustersResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_gkemulticloud_v1_aws_service_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteAwsClusterRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_gkemulticloud_v1_aws_service_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateAwsNodePoolRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_gkemulticloud_v1_aws_service_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateAwsNodePoolRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_gkemulticloud_v1_aws_service_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RollbackAwsNodePoolUpdateRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_gkemulticloud_v1_aws_service_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetAwsNodePoolRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_gkemulticloud_v1_aws_service_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListAwsNodePoolsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_gkemulticloud_v1_aws_service_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListAwsNodePoolsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_gkemulticloud_v1_aws_service_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteAwsNodePoolRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_gkemulticloud_v1_aws_service_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetAwsOpenIdConfigRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_gkemulticloud_v1_aws_service_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetAwsJsonWebKeysRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_gkemulticloud_v1_aws_service_proto_msgTypes[15].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetAwsServerConfigRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_gkemulticloud_v1_aws_service_proto_msgTypes[16].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GenerateAwsAccessTokenRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_gkemulticloud_v1_aws_service_proto_msgTypes[17].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GenerateAwsAccessTokenResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_gkemulticloud_v1_aws_service_proto_msgTypes[18].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GenerateAwsClusterAgentTokenRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_gkemulticloud_v1_aws_service_proto_msgTypes[19].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GenerateAwsClusterAgentTokenResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_gkemulticloud_v1_aws_service_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   20,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_cloud_gkemulticloud_v1_aws_service_proto_goTypes,
		DependencyIndexes: file_google_cloud_gkemulticloud_v1_aws_service_proto_depIdxs,
		MessageInfos:      file_google_cloud_gkemulticloud_v1_aws_service_proto_msgTypes,
	}.Build()
	File_google_cloud_gkemulticloud_v1_aws_service_proto = out.File
	file_google_cloud_gkemulticloud_v1_aws_service_proto_rawDesc = nil
	file_google_cloud_gkemulticloud_v1_aws_service_proto_goTypes = nil
	file_google_cloud_gkemulticloud_v1_aws_service_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// AwsClustersClient is the client API for AwsClusters service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type AwsClustersClient interface {
	// Creates a new [AwsCluster][google.cloud.gkemulticloud.v1.AwsCluster]
	// resource on a given Google Cloud Platform project and region.
	//
	// If successful, the response contains a newly created
	// [Operation][google.longrunning.Operation] resource that can be
	// described to track the status of the operation.
	CreateAwsCluster(ctx context.Context, in *CreateAwsClusterRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Updates an [AwsCluster][google.cloud.gkemulticloud.v1.AwsCluster].
	UpdateAwsCluster(ctx context.Context, in *UpdateAwsClusterRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Describes a specific [AwsCluster][google.cloud.gkemulticloud.v1.AwsCluster]
	// resource.
	GetAwsCluster(ctx context.Context, in *GetAwsClusterRequest, opts ...grpc.CallOption) (*AwsCluster, error)
	// Lists all [AwsCluster][google.cloud.gkemulticloud.v1.AwsCluster] resources
	// on a given Google Cloud project and region.
	ListAwsClusters(ctx context.Context, in *ListAwsClustersRequest, opts ...grpc.CallOption) (*ListAwsClustersResponse, error)
	// Deletes a specific [AwsCluster][google.cloud.gkemulticloud.v1.AwsCluster]
	// resource.
	//
	// Fails if the cluster has one or more associated
	// [AwsNodePool][google.cloud.gkemulticloud.v1.AwsNodePool] resources.
	//
	// If successful, the response contains a newly created
	// [Operation][google.longrunning.Operation] resource that can be
	// described to track the status of the operation.
	DeleteAwsCluster(ctx context.Context, in *DeleteAwsClusterRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Generates an access token for a cluster agent.
	GenerateAwsClusterAgentToken(ctx context.Context, in *GenerateAwsClusterAgentTokenRequest, opts ...grpc.CallOption) (*GenerateAwsClusterAgentTokenResponse, error)
	// Generates a short-lived access token to authenticate to a given
	// [AwsCluster][google.cloud.gkemulticloud.v1.AwsCluster] resource.
	GenerateAwsAccessToken(ctx context.Context, in *GenerateAwsAccessTokenRequest, opts ...grpc.CallOption) (*GenerateAwsAccessTokenResponse, error)
	// Creates a new [AwsNodePool][google.cloud.gkemulticloud.v1.AwsNodePool],
	// attached to a given [AwsCluster][google.cloud.gkemulticloud.v1.AwsCluster].
	//
	// If successful, the response contains a newly created
	// [Operation][google.longrunning.Operation] resource that can be
	// described to track the status of the operation.
	CreateAwsNodePool(ctx context.Context, in *CreateAwsNodePoolRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Updates an [AwsNodePool][google.cloud.gkemulticloud.v1.AwsNodePool].
	UpdateAwsNodePool(ctx context.Context, in *UpdateAwsNodePoolRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Rolls back a previously aborted or failed
	// [AwsNodePool][google.cloud.gkemulticloud.v1.AwsNodePool] update request.
	// Makes no changes if the last update request successfully finished.
	// If an update request is in progress, you cannot rollback the update.
	// You must first cancel or let it finish unsuccessfully before you can
	// rollback.
	RollbackAwsNodePoolUpdate(ctx context.Context, in *RollbackAwsNodePoolUpdateRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Describes a specific
	// [AwsNodePool][google.cloud.gkemulticloud.v1.AwsNodePool] resource.
	GetAwsNodePool(ctx context.Context, in *GetAwsNodePoolRequest, opts ...grpc.CallOption) (*AwsNodePool, error)
	// Lists all [AwsNodePool][google.cloud.gkemulticloud.v1.AwsNodePool]
	// resources on a given
	// [AwsCluster][google.cloud.gkemulticloud.v1.AwsCluster].
	ListAwsNodePools(ctx context.Context, in *ListAwsNodePoolsRequest, opts ...grpc.CallOption) (*ListAwsNodePoolsResponse, error)
	// Deletes a specific [AwsNodePool][google.cloud.gkemulticloud.v1.AwsNodePool]
	// resource.
	//
	// If successful, the response contains a newly created
	// [Operation][google.longrunning.Operation] resource that can be
	// described to track the status of the operation.
	DeleteAwsNodePool(ctx context.Context, in *DeleteAwsNodePoolRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Gets the OIDC discovery document for the cluster.
	// See the
	// [OpenID Connect Discovery 1.0
	// specification](https://openid.net/specs/openid-connect-discovery-1_0.html)
	// for details.
	GetAwsOpenIdConfig(ctx context.Context, in *GetAwsOpenIdConfigRequest, opts ...grpc.CallOption) (*AwsOpenIdConfig, error)
	// Gets the public component of the cluster signing keys in
	// JSON Web Key format.
	GetAwsJsonWebKeys(ctx context.Context, in *GetAwsJsonWebKeysRequest, opts ...grpc.CallOption) (*AwsJsonWebKeys, error)
	// Returns information, such as supported AWS regions and Kubernetes
	// versions, on a given Google Cloud location.
	GetAwsServerConfig(ctx context.Context, in *GetAwsServerConfigRequest, opts ...grpc.CallOption) (*AwsServerConfig, error)
}

type awsClustersClient struct {
	cc grpc.ClientConnInterface
}

func NewAwsClustersClient(cc grpc.ClientConnInterface) AwsClustersClient {
	return &awsClustersClient{cc}
}

func (c *awsClustersClient) CreateAwsCluster(ctx context.Context, in *CreateAwsClusterRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.gkemulticloud.v1.AwsClusters/CreateAwsCluster", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *awsClustersClient) UpdateAwsCluster(ctx context.Context, in *UpdateAwsClusterRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.gkemulticloud.v1.AwsClusters/UpdateAwsCluster", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *awsClustersClient) GetAwsCluster(ctx context.Context, in *GetAwsClusterRequest, opts ...grpc.CallOption) (*AwsCluster, error) {
	out := new(AwsCluster)
	err := c.cc.Invoke(ctx, "/google.cloud.gkemulticloud.v1.AwsClusters/GetAwsCluster", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *awsClustersClient) ListAwsClusters(ctx context.Context, in *ListAwsClustersRequest, opts ...grpc.CallOption) (*ListAwsClustersResponse, error) {
	out := new(ListAwsClustersResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.gkemulticloud.v1.AwsClusters/ListAwsClusters", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *awsClustersClient) DeleteAwsCluster(ctx context.Context, in *DeleteAwsClusterRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.gkemulticloud.v1.AwsClusters/DeleteAwsCluster", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *awsClustersClient) GenerateAwsClusterAgentToken(ctx context.Context, in *GenerateAwsClusterAgentTokenRequest, opts ...grpc.CallOption) (*GenerateAwsClusterAgentTokenResponse, error) {
	out := new(GenerateAwsClusterAgentTokenResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.gkemulticloud.v1.AwsClusters/GenerateAwsClusterAgentToken", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *awsClustersClient) GenerateAwsAccessToken(ctx context.Context, in *GenerateAwsAccessTokenRequest, opts ...grpc.CallOption) (*GenerateAwsAccessTokenResponse, error) {
	out := new(GenerateAwsAccessTokenResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.gkemulticloud.v1.AwsClusters/GenerateAwsAccessToken", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *awsClustersClient) CreateAwsNodePool(ctx context.Context, in *CreateAwsNodePoolRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.gkemulticloud.v1.AwsClusters/CreateAwsNodePool", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *awsClustersClient) UpdateAwsNodePool(ctx context.Context, in *UpdateAwsNodePoolRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.gkemulticloud.v1.AwsClusters/UpdateAwsNodePool", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *awsClustersClient) RollbackAwsNodePoolUpdate(ctx context.Context, in *RollbackAwsNodePoolUpdateRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.gkemulticloud.v1.AwsClusters/RollbackAwsNodePoolUpdate", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *awsClustersClient) GetAwsNodePool(ctx context.Context, in *GetAwsNodePoolRequest, opts ...grpc.CallOption) (*AwsNodePool, error) {
	out := new(AwsNodePool)
	err := c.cc.Invoke(ctx, "/google.cloud.gkemulticloud.v1.AwsClusters/GetAwsNodePool", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *awsClustersClient) ListAwsNodePools(ctx context.Context, in *ListAwsNodePoolsRequest, opts ...grpc.CallOption) (*ListAwsNodePoolsResponse, error) {
	out := new(ListAwsNodePoolsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.gkemulticloud.v1.AwsClusters/ListAwsNodePools", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *awsClustersClient) DeleteAwsNodePool(ctx context.Context, in *DeleteAwsNodePoolRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.gkemulticloud.v1.AwsClusters/DeleteAwsNodePool", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *awsClustersClient) GetAwsOpenIdConfig(ctx context.Context, in *GetAwsOpenIdConfigRequest, opts ...grpc.CallOption) (*AwsOpenIdConfig, error) {
	out := new(AwsOpenIdConfig)
	err := c.cc.Invoke(ctx, "/google.cloud.gkemulticloud.v1.AwsClusters/GetAwsOpenIdConfig", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *awsClustersClient) GetAwsJsonWebKeys(ctx context.Context, in *GetAwsJsonWebKeysRequest, opts ...grpc.CallOption) (*AwsJsonWebKeys, error) {
	out := new(AwsJsonWebKeys)
	err := c.cc.Invoke(ctx, "/google.cloud.gkemulticloud.v1.AwsClusters/GetAwsJsonWebKeys", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *awsClustersClient) GetAwsServerConfig(ctx context.Context, in *GetAwsServerConfigRequest, opts ...grpc.CallOption) (*AwsServerConfig, error) {
	out := new(AwsServerConfig)
	err := c.cc.Invoke(ctx, "/google.cloud.gkemulticloud.v1.AwsClusters/GetAwsServerConfig", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// AwsClustersServer is the server API for AwsClusters service.
type AwsClustersServer interface {
	// Creates a new [AwsCluster][google.cloud.gkemulticloud.v1.AwsCluster]
	// resource on a given Google Cloud Platform project and region.
	//
	// If successful, the response contains a newly created
	// [Operation][google.longrunning.Operation] resource that can be
	// described to track the status of the operation.
	CreateAwsCluster(context.Context, *CreateAwsClusterRequest) (*longrunningpb.Operation, error)
	// Updates an [AwsCluster][google.cloud.gkemulticloud.v1.AwsCluster].
	UpdateAwsCluster(context.Context, *UpdateAwsClusterRequest) (*longrunningpb.Operation, error)
	// Describes a specific [AwsCluster][google.cloud.gkemulticloud.v1.AwsCluster]
	// resource.
	GetAwsCluster(context.Context, *GetAwsClusterRequest) (*AwsCluster, error)
	// Lists all [AwsCluster][google.cloud.gkemulticloud.v1.AwsCluster] resources
	// on a given Google Cloud project and region.
	ListAwsClusters(context.Context, *ListAwsClustersRequest) (*ListAwsClustersResponse, error)
	// Deletes a specific [AwsCluster][google.cloud.gkemulticloud.v1.AwsCluster]
	// resource.
	//
	// Fails if the cluster has one or more associated
	// [AwsNodePool][google.cloud.gkemulticloud.v1.AwsNodePool] resources.
	//
	// If successful, the response contains a newly created
	// [Operation][google.longrunning.Operation] resource that can be
	// described to track the status of the operation.
	DeleteAwsCluster(context.Context, *DeleteAwsClusterRequest) (*longrunningpb.Operation, error)
	// Generates an access token for a cluster agent.
	GenerateAwsClusterAgentToken(context.Context, *GenerateAwsClusterAgentTokenRequest) (*GenerateAwsClusterAgentTokenResponse, error)
	// Generates a short-lived access token to authenticate to a given
	// [AwsCluster][google.cloud.gkemulticloud.v1.AwsCluster] resource.
	GenerateAwsAccessToken(context.Context, *GenerateAwsAccessTokenRequest) (*GenerateAwsAccessTokenResponse, error)
	// Creates a new [AwsNodePool][google.cloud.gkemulticloud.v1.AwsNodePool],
	// attached to a given [AwsCluster][google.cloud.gkemulticloud.v1.AwsCluster].
	//
	// If successful, the response contains a newly created
	// [Operation][google.longrunning.Operation] resource that can be
	// described to track the status of the operation.
	CreateAwsNodePool(context.Context, *CreateAwsNodePoolRequest) (*longrunningpb.Operation, error)
	// Updates an [AwsNodePool][google.cloud.gkemulticloud.v1.AwsNodePool].
	UpdateAwsNodePool(context.Context, *UpdateAwsNodePoolRequest) (*longrunningpb.Operation, error)
	// Rolls back a previously aborted or failed
	// [AwsNodePool][google.cloud.gkemulticloud.v1.AwsNodePool] update request.
	// Makes no changes if the last update request successfully finished.
	// If an update request is in progress, you cannot rollback the update.
	// You must first cancel or let it finish unsuccessfully before you can
	// rollback.
	RollbackAwsNodePoolUpdate(context.Context, *RollbackAwsNodePoolUpdateRequest) (*longrunningpb.Operation, error)
	// Describes a specific
	// [AwsNodePool][google.cloud.gkemulticloud.v1.AwsNodePool] resource.
	GetAwsNodePool(context.Context, *GetAwsNodePoolRequest) (*AwsNodePool, error)
	// Lists all [AwsNodePool][google.cloud.gkemulticloud.v1.AwsNodePool]
	// resources on a given
	// [AwsCluster][google.cloud.gkemulticloud.v1.AwsCluster].
	ListAwsNodePools(context.Context, *ListAwsNodePoolsRequest) (*ListAwsNodePoolsResponse, error)
	// Deletes a specific [AwsNodePool][google.cloud.gkemulticloud.v1.AwsNodePool]
	// resource.
	//
	// If successful, the response contains a newly created
	// [Operation][google.longrunning.Operation] resource that can be
	// described to track the status of the operation.
	DeleteAwsNodePool(context.Context, *DeleteAwsNodePoolRequest) (*longrunningpb.Operation, error)
	// Gets the OIDC discovery document for the cluster.
	// See the
	// [OpenID Connect Discovery 1.0
	// specification](https://openid.net/specs/openid-connect-discovery-1_0.html)
	// for details.
	GetAwsOpenIdConfig(context.Context, *GetAwsOpenIdConfigRequest) (*AwsOpenIdConfig, error)
	// Gets the public component of the cluster signing keys in
	// JSON Web Key format.
	GetAwsJsonWebKeys(context.Context, *GetAwsJsonWebKeysRequest) (*AwsJsonWebKeys, error)
	// Returns information, such as supported AWS regions and Kubernetes
	// versions, on a given Google Cloud location.
	GetAwsServerConfig(context.Context, *GetAwsServerConfigRequest) (*AwsServerConfig, error)
}

// UnimplementedAwsClustersServer can be embedded to have forward compatible implementations.
type UnimplementedAwsClustersServer struct {
}

func (*UnimplementedAwsClustersServer) CreateAwsCluster(context.Context, *CreateAwsClusterRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateAwsCluster not implemented")
}
func (*UnimplementedAwsClustersServer) UpdateAwsCluster(context.Context, *UpdateAwsClusterRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateAwsCluster not implemented")
}
func (*UnimplementedAwsClustersServer) GetAwsCluster(context.Context, *GetAwsClusterRequest) (*AwsCluster, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetAwsCluster not implemented")
}
func (*UnimplementedAwsClustersServer) ListAwsClusters(context.Context, *ListAwsClustersRequest) (*ListAwsClustersResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListAwsClusters not implemented")
}
func (*UnimplementedAwsClustersServer) DeleteAwsCluster(context.Context, *DeleteAwsClusterRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteAwsCluster not implemented")
}
func (*UnimplementedAwsClustersServer) GenerateAwsClusterAgentToken(context.Context, *GenerateAwsClusterAgentTokenRequest) (*GenerateAwsClusterAgentTokenResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GenerateAwsClusterAgentToken not implemented")
}
func (*UnimplementedAwsClustersServer) GenerateAwsAccessToken(context.Context, *GenerateAwsAccessTokenRequest) (*GenerateAwsAccessTokenResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GenerateAwsAccessToken not implemented")
}
func (*UnimplementedAwsClustersServer) CreateAwsNodePool(context.Context, *CreateAwsNodePoolRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateAwsNodePool not implemented")
}
func (*UnimplementedAwsClustersServer) UpdateAwsNodePool(context.Context, *UpdateAwsNodePoolRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateAwsNodePool not implemented")
}
func (*UnimplementedAwsClustersServer) RollbackAwsNodePoolUpdate(context.Context, *RollbackAwsNodePoolUpdateRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RollbackAwsNodePoolUpdate not implemented")
}
func (*UnimplementedAwsClustersServer) GetAwsNodePool(context.Context, *GetAwsNodePoolRequest) (*AwsNodePool, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetAwsNodePool not implemented")
}
func (*UnimplementedAwsClustersServer) ListAwsNodePools(context.Context, *ListAwsNodePoolsRequest) (*ListAwsNodePoolsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListAwsNodePools not implemented")
}
func (*UnimplementedAwsClustersServer) DeleteAwsNodePool(context.Context, *DeleteAwsNodePoolRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteAwsNodePool not implemented")
}
func (*UnimplementedAwsClustersServer) GetAwsOpenIdConfig(context.Context, *GetAwsOpenIdConfigRequest) (*AwsOpenIdConfig, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetAwsOpenIdConfig not implemented")
}
func (*UnimplementedAwsClustersServer) GetAwsJsonWebKeys(context.Context, *GetAwsJsonWebKeysRequest) (*AwsJsonWebKeys, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetAwsJsonWebKeys not implemented")
}
func (*UnimplementedAwsClustersServer) GetAwsServerConfig(context.Context, *GetAwsServerConfigRequest) (*AwsServerConfig, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetAwsServerConfig not implemented")
}

func RegisterAwsClustersServer(s *grpc.Server, srv AwsClustersServer) {
	s.RegisterService(&_AwsClusters_serviceDesc, srv)
}

func _AwsClusters_CreateAwsCluster_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateAwsClusterRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AwsClustersServer).CreateAwsCluster(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.gkemulticloud.v1.AwsClusters/CreateAwsCluster",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AwsClustersServer).CreateAwsCluster(ctx, req.(*CreateAwsClusterRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AwsClusters_UpdateAwsCluster_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateAwsClusterRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AwsClustersServer).UpdateAwsCluster(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.gkemulticloud.v1.AwsClusters/UpdateAwsCluster",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AwsClustersServer).UpdateAwsCluster(ctx, req.(*UpdateAwsClusterRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AwsClusters_GetAwsCluster_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetAwsClusterRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AwsClustersServer).GetAwsCluster(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.gkemulticloud.v1.AwsClusters/GetAwsCluster",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AwsClustersServer).GetAwsCluster(ctx, req.(*GetAwsClusterRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AwsClusters_ListAwsClusters_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListAwsClustersRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AwsClustersServer).ListAwsClusters(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.gkemulticloud.v1.AwsClusters/ListAwsClusters",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AwsClustersServer).ListAwsClusters(ctx, req.(*ListAwsClustersRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AwsClusters_DeleteAwsCluster_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteAwsClusterRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AwsClustersServer).DeleteAwsCluster(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.gkemulticloud.v1.AwsClusters/DeleteAwsCluster",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AwsClustersServer).DeleteAwsCluster(ctx, req.(*DeleteAwsClusterRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AwsClusters_GenerateAwsClusterAgentToken_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GenerateAwsClusterAgentTokenRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AwsClustersServer).GenerateAwsClusterAgentToken(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.gkemulticloud.v1.AwsClusters/GenerateAwsClusterAgentToken",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AwsClustersServer).GenerateAwsClusterAgentToken(ctx, req.(*GenerateAwsClusterAgentTokenRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AwsClusters_GenerateAwsAccessToken_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GenerateAwsAccessTokenRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AwsClustersServer).GenerateAwsAccessToken(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.gkemulticloud.v1.AwsClusters/GenerateAwsAccessToken",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AwsClustersServer).GenerateAwsAccessToken(ctx, req.(*GenerateAwsAccessTokenRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AwsClusters_CreateAwsNodePool_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateAwsNodePoolRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AwsClustersServer).CreateAwsNodePool(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.gkemulticloud.v1.AwsClusters/CreateAwsNodePool",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AwsClustersServer).CreateAwsNodePool(ctx, req.(*CreateAwsNodePoolRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AwsClusters_UpdateAwsNodePool_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateAwsNodePoolRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AwsClustersServer).UpdateAwsNodePool(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.gkemulticloud.v1.AwsClusters/UpdateAwsNodePool",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AwsClustersServer).UpdateAwsNodePool(ctx, req.(*UpdateAwsNodePoolRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AwsClusters_RollbackAwsNodePoolUpdate_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RollbackAwsNodePoolUpdateRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AwsClustersServer).RollbackAwsNodePoolUpdate(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.gkemulticloud.v1.AwsClusters/RollbackAwsNodePoolUpdate",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AwsClustersServer).RollbackAwsNodePoolUpdate(ctx, req.(*RollbackAwsNodePoolUpdateRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AwsClusters_GetAwsNodePool_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetAwsNodePoolRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AwsClustersServer).GetAwsNodePool(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.gkemulticloud.v1.AwsClusters/GetAwsNodePool",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AwsClustersServer).GetAwsNodePool(ctx, req.(*GetAwsNodePoolRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AwsClusters_ListAwsNodePools_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListAwsNodePoolsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AwsClustersServer).ListAwsNodePools(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.gkemulticloud.v1.AwsClusters/ListAwsNodePools",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AwsClustersServer).ListAwsNodePools(ctx, req.(*ListAwsNodePoolsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AwsClusters_DeleteAwsNodePool_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteAwsNodePoolRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AwsClustersServer).DeleteAwsNodePool(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.gkemulticloud.v1.AwsClusters/DeleteAwsNodePool",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AwsClustersServer).DeleteAwsNodePool(ctx, req.(*DeleteAwsNodePoolRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AwsClusters_GetAwsOpenIdConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetAwsOpenIdConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AwsClustersServer).GetAwsOpenIdConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.gkemulticloud.v1.AwsClusters/GetAwsOpenIdConfig",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AwsClustersServer).GetAwsOpenIdConfig(ctx, req.(*GetAwsOpenIdConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AwsClusters_GetAwsJsonWebKeys_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetAwsJsonWebKeysRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AwsClustersServer).GetAwsJsonWebKeys(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.gkemulticloud.v1.AwsClusters/GetAwsJsonWebKeys",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AwsClustersServer).GetAwsJsonWebKeys(ctx, req.(*GetAwsJsonWebKeysRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AwsClusters_GetAwsServerConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetAwsServerConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AwsClustersServer).GetAwsServerConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.gkemulticloud.v1.AwsClusters/GetAwsServerConfig",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AwsClustersServer).GetAwsServerConfig(ctx, req.(*GetAwsServerConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _AwsClusters_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.gkemulticloud.v1.AwsClusters",
	HandlerType: (*AwsClustersServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CreateAwsCluster",
			Handler:    _AwsClusters_CreateAwsCluster_Handler,
		},
		{
			MethodName: "UpdateAwsCluster",
			Handler:    _AwsClusters_UpdateAwsCluster_Handler,
		},
		{
			MethodName: "GetAwsCluster",
			Handler:    _AwsClusters_GetAwsCluster_Handler,
		},
		{
			MethodName: "ListAwsClusters",
			Handler:    _AwsClusters_ListAwsClusters_Handler,
		},
		{
			MethodName: "DeleteAwsCluster",
			Handler:    _AwsClusters_DeleteAwsCluster_Handler,
		},
		{
			MethodName: "GenerateAwsClusterAgentToken",
			Handler:    _AwsClusters_GenerateAwsClusterAgentToken_Handler,
		},
		{
			MethodName: "GenerateAwsAccessToken",
			Handler:    _AwsClusters_GenerateAwsAccessToken_Handler,
		},
		{
			MethodName: "CreateAwsNodePool",
			Handler:    _AwsClusters_CreateAwsNodePool_Handler,
		},
		{
			MethodName: "UpdateAwsNodePool",
			Handler:    _AwsClusters_UpdateAwsNodePool_Handler,
		},
		{
			MethodName: "RollbackAwsNodePoolUpdate",
			Handler:    _AwsClusters_RollbackAwsNodePoolUpdate_Handler,
		},
		{
			MethodName: "GetAwsNodePool",
			Handler:    _AwsClusters_GetAwsNodePool_Handler,
		},
		{
			MethodName: "ListAwsNodePools",
			Handler:    _AwsClusters_ListAwsNodePools_Handler,
		},
		{
			MethodName: "DeleteAwsNodePool",
			Handler:    _AwsClusters_DeleteAwsNodePool_Handler,
		},
		{
			MethodName: "GetAwsOpenIdConfig",
			Handler:    _AwsClusters_GetAwsOpenIdConfig_Handler,
		},
		{
			MethodName: "GetAwsJsonWebKeys",
			Handler:    _AwsClusters_GetAwsJsonWebKeys_Handler,
		},
		{
			MethodName: "GetAwsServerConfig",
			Handler:    _AwsClusters_GetAwsServerConfig_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/gkemulticloud/v1/aws_service.proto",
}
