// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.32.0
// 	protoc        v4.23.2
// source: google/maps/places/v1/places_service.proto

package placespb

import (
	context "context"
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	viewport "google.golang.org/genproto/googleapis/geo/type/viewport"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// How results will be ranked in the response.
type SearchNearbyRequest_RankPreference int32

const (
	// RankPreference value not set. Will use rank by POPULARITY by default.
	SearchNearbyRequest_RANK_PREFERENCE_UNSPECIFIED SearchNearbyRequest_RankPreference = 0
	// Ranks results by distance.
	SearchNearbyRequest_DISTANCE SearchNearbyRequest_RankPreference = 1
	// Ranks results by popularity.
	SearchNearbyRequest_POPULARITY SearchNearbyRequest_RankPreference = 2
)

// Enum value maps for SearchNearbyRequest_RankPreference.
var (
	SearchNearbyRequest_RankPreference_name = map[int32]string{
		0: "RANK_PREFERENCE_UNSPECIFIED",
		1: "DISTANCE",
		2: "POPULARITY",
	}
	SearchNearbyRequest_RankPreference_value = map[string]int32{
		"RANK_PREFERENCE_UNSPECIFIED": 0,
		"DISTANCE":                    1,
		"POPULARITY":                  2,
	}
)

func (x SearchNearbyRequest_RankPreference) Enum() *SearchNearbyRequest_RankPreference {
	p := new(SearchNearbyRequest_RankPreference)
	*p = x
	return p
}

func (x SearchNearbyRequest_RankPreference) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SearchNearbyRequest_RankPreference) Descriptor() protoreflect.EnumDescriptor {
	return file_google_maps_places_v1_places_service_proto_enumTypes[0].Descriptor()
}

func (SearchNearbyRequest_RankPreference) Type() protoreflect.EnumType {
	return &file_google_maps_places_v1_places_service_proto_enumTypes[0]
}

func (x SearchNearbyRequest_RankPreference) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use SearchNearbyRequest_RankPreference.Descriptor instead.
func (SearchNearbyRequest_RankPreference) EnumDescriptor() ([]byte, []int) {
	return file_google_maps_places_v1_places_service_proto_rawDescGZIP(), []int{0, 0}
}

// How results will be ranked in the response.
type SearchTextRequest_RankPreference int32

const (
	// RankPreference value not set. Will default to DISTANCE.
	SearchTextRequest_RANK_PREFERENCE_UNSPECIFIED SearchTextRequest_RankPreference = 0
	// Ranks results by distance.
	SearchTextRequest_DISTANCE SearchTextRequest_RankPreference = 1
	// Ranks results by relevance. Sort order determined by normal ranking
	// stack.
	SearchTextRequest_RELEVANCE SearchTextRequest_RankPreference = 2
)

// Enum value maps for SearchTextRequest_RankPreference.
var (
	SearchTextRequest_RankPreference_name = map[int32]string{
		0: "RANK_PREFERENCE_UNSPECIFIED",
		1: "DISTANCE",
		2: "RELEVANCE",
	}
	SearchTextRequest_RankPreference_value = map[string]int32{
		"RANK_PREFERENCE_UNSPECIFIED": 0,
		"DISTANCE":                    1,
		"RELEVANCE":                   2,
	}
)

func (x SearchTextRequest_RankPreference) Enum() *SearchTextRequest_RankPreference {
	p := new(SearchTextRequest_RankPreference)
	*p = x
	return p
}

func (x SearchTextRequest_RankPreference) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SearchTextRequest_RankPreference) Descriptor() protoreflect.EnumDescriptor {
	return file_google_maps_places_v1_places_service_proto_enumTypes[1].Descriptor()
}

func (SearchTextRequest_RankPreference) Type() protoreflect.EnumType {
	return &file_google_maps_places_v1_places_service_proto_enumTypes[1]
}

func (x SearchTextRequest_RankPreference) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use SearchTextRequest_RankPreference.Descriptor instead.
func (SearchTextRequest_RankPreference) EnumDescriptor() ([]byte, []int) {
	return file_google_maps_places_v1_places_service_proto_rawDescGZIP(), []int{2, 0}
}

// Request proto for Search Nearby.
type SearchNearbyRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Place details will be displayed with the preferred language if available.
	// If the language code is unspecified or unrecognized, place details of any
	// language may be returned, with a preference for English if such details
	// exist.
	//
	// Current list of supported languages:
	// https://developers.google.com/maps/faq#languagesupport.
	LanguageCode string `protobuf:"bytes,1,opt,name=language_code,json=languageCode,proto3" json:"language_code,omitempty"`
	// The Unicode country/region code (CLDR) of the location where the
	// request is coming from. This parameter is used to display the place
	// details, like region-specific place name, if available. The parameter can
	// affect results based on applicable law.
	//
	// For more information, see
	// https://www.unicode.org/cldr/charts/latest/supplemental/territory_language_information.html.
	//
	// Note that 3-digit region codes are not currently supported.
	RegionCode string `protobuf:"bytes,2,opt,name=region_code,json=regionCode,proto3" json:"region_code,omitempty"`
	// Included Place type (eg, "restaurant" or "gas_station") from
	// https://developers.google.com/maps/documentation/places/web-service/place-types.
	//
	// Up to 50 types from [Table
	// A](https://developers.google.com/maps/documentation/places/web-service/place-types#table-a)
	// may be specified.
	//
	// If there are any conflicting types, i.e. a type appears in both
	// included_types and excluded_types, an INVALID_ARGUMENT error is
	// returned.
	//
	// If a Place type is specified with multiple type restrictions, only places
	// that satisfy all of the restrictions are returned. For example, if we
	// have {included_types = ["restaurant"], excluded_primary_types =
	// ["restaurant"]}, the returned places provide "restaurant"
	// related services but do not operate primarily as "restaurants".
	IncludedTypes []string `protobuf:"bytes,3,rep,name=included_types,json=includedTypes,proto3" json:"included_types,omitempty"`
	// Excluded Place type (eg, "restaurant" or "gas_station") from
	// https://developers.google.com/maps/documentation/places/web-service/place-types.
	//
	// Up to 50 types from [Table
	// A](https://developers.google.com/maps/documentation/places/web-service/place-types#table-a)
	// may be specified.
	//
	// If the client provides both included_types (e.g. restaurant) and
	// excluded_types (e.g. cafe), then the response should include places that
	// are restaurant but not cafe. The response includes places that match at
	// least one of the included_types and none of the excluded_types.
	//
	// If there are any conflicting types, i.e. a type appears in both
	// included_types and excluded_types, an INVALID_ARGUMENT error is returned.
	//
	// If a Place type is specified with multiple type restrictions, only places
	// that satisfy all of the restrictions are returned. For example, if we
	// have {included_types = ["restaurant"], excluded_primary_types =
	// ["restaurant"]}, the returned places provide "restaurant"
	// related services but do not operate primarily as "restaurants".
	ExcludedTypes []string `protobuf:"bytes,4,rep,name=excluded_types,json=excludedTypes,proto3" json:"excluded_types,omitempty"`
	// Included primary Place type (e.g. "restaurant" or "gas_station") from
	// https://developers.google.com/maps/documentation/places/web-service/place-types.
	// A place can only have a single primary type from the supported types table
	// associated with it.
	//
	// Up to 50 types from [Table
	// A](https://developers.google.com/maps/documentation/places/web-service/place-types#table-a)
	// may be specified.
	//
	// If there are any conflicting primary types, i.e. a type appears in both
	// included_primary_types and excluded_primary_types, an INVALID_ARGUMENT
	// error is returned.
	//
	// If a Place type is specified with multiple type restrictions, only places
	// that satisfy all of the restrictions are returned. For example, if we
	// have {included_types = ["restaurant"], excluded_primary_types =
	// ["restaurant"]}, the returned places provide "restaurant"
	// related services but do not operate primarily as "restaurants".
	IncludedPrimaryTypes []string `protobuf:"bytes,5,rep,name=included_primary_types,json=includedPrimaryTypes,proto3" json:"included_primary_types,omitempty"`
	// Excluded primary Place type (e.g. "restaurant" or "gas_station") from
	// https://developers.google.com/maps/documentation/places/web-service/place-types.
	//
	// Up to 50 types from [Table
	// A](https://developers.google.com/maps/documentation/places/web-service/place-types#table-a)
	// may be specified.
	//
	// If there are any conflicting primary types, i.e. a type appears in both
	// included_primary_types and excluded_primary_types, an INVALID_ARGUMENT
	// error is returned.
	//
	// If a Place type is specified with multiple type restrictions, only places
	// that satisfy all of the restrictions are returned. For example, if we
	// have {included_types = ["restaurant"], excluded_primary_types =
	// ["restaurant"]}, the returned places provide "restaurant"
	// related services but do not operate primarily as "restaurants".
	ExcludedPrimaryTypes []string `protobuf:"bytes,6,rep,name=excluded_primary_types,json=excludedPrimaryTypes,proto3" json:"excluded_primary_types,omitempty"`
	// Maximum number of results to return. It must be between 1 and 20 (default),
	// inclusively. If the number is unset, it falls back to the upper limit. If
	// the number is set to negative or exceeds the upper limit, an
	// INVALID_ARGUMENT error is returned.
	MaxResultCount int32 `protobuf:"varint,7,opt,name=max_result_count,json=maxResultCount,proto3" json:"max_result_count,omitempty"`
	// Required. The region to search.
	LocationRestriction *SearchNearbyRequest_LocationRestriction `protobuf:"bytes,8,opt,name=location_restriction,json=locationRestriction,proto3" json:"location_restriction,omitempty"`
	// How results will be ranked in the response.
	RankPreference SearchNearbyRequest_RankPreference `protobuf:"varint,9,opt,name=rank_preference,json=rankPreference,proto3,enum=google.maps.places.v1.SearchNearbyRequest_RankPreference" json:"rank_preference,omitempty"`
}

func (x *SearchNearbyRequest) Reset() {
	*x = SearchNearbyRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_maps_places_v1_places_service_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SearchNearbyRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SearchNearbyRequest) ProtoMessage() {}

func (x *SearchNearbyRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_maps_places_v1_places_service_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SearchNearbyRequest.ProtoReflect.Descriptor instead.
func (*SearchNearbyRequest) Descriptor() ([]byte, []int) {
	return file_google_maps_places_v1_places_service_proto_rawDescGZIP(), []int{0}
}

func (x *SearchNearbyRequest) GetLanguageCode() string {
	if x != nil {
		return x.LanguageCode
	}
	return ""
}

func (x *SearchNearbyRequest) GetRegionCode() string {
	if x != nil {
		return x.RegionCode
	}
	return ""
}

func (x *SearchNearbyRequest) GetIncludedTypes() []string {
	if x != nil {
		return x.IncludedTypes
	}
	return nil
}

func (x *SearchNearbyRequest) GetExcludedTypes() []string {
	if x != nil {
		return x.ExcludedTypes
	}
	return nil
}

func (x *SearchNearbyRequest) GetIncludedPrimaryTypes() []string {
	if x != nil {
		return x.IncludedPrimaryTypes
	}
	return nil
}

func (x *SearchNearbyRequest) GetExcludedPrimaryTypes() []string {
	if x != nil {
		return x.ExcludedPrimaryTypes
	}
	return nil
}

func (x *SearchNearbyRequest) GetMaxResultCount() int32 {
	if x != nil {
		return x.MaxResultCount
	}
	return 0
}

func (x *SearchNearbyRequest) GetLocationRestriction() *SearchNearbyRequest_LocationRestriction {
	if x != nil {
		return x.LocationRestriction
	}
	return nil
}

func (x *SearchNearbyRequest) GetRankPreference() SearchNearbyRequest_RankPreference {
	if x != nil {
		return x.RankPreference
	}
	return SearchNearbyRequest_RANK_PREFERENCE_UNSPECIFIED
}

// Response proto for Search Nearby.
type SearchNearbyResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A list of places that meets user's requirements like places
	// types, number of places and specific location restriction.
	Places []*Place `protobuf:"bytes,1,rep,name=places,proto3" json:"places,omitempty"`
}

func (x *SearchNearbyResponse) Reset() {
	*x = SearchNearbyResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_maps_places_v1_places_service_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SearchNearbyResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SearchNearbyResponse) ProtoMessage() {}

func (x *SearchNearbyResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_maps_places_v1_places_service_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SearchNearbyResponse.ProtoReflect.Descriptor instead.
func (*SearchNearbyResponse) Descriptor() ([]byte, []int) {
	return file_google_maps_places_v1_places_service_proto_rawDescGZIP(), []int{1}
}

func (x *SearchNearbyResponse) GetPlaces() []*Place {
	if x != nil {
		return x.Places
	}
	return nil
}

// Request proto for SearchText.
type SearchTextRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The text query for textual search.
	TextQuery string `protobuf:"bytes,1,opt,name=text_query,json=textQuery,proto3" json:"text_query,omitempty"`
	// Place details will be displayed with the preferred language if available.
	// If the language code is unspecified or unrecognized, place details of any
	// language may be returned, with a preference for English if such details
	// exist.
	//
	// Current list of supported languages:
	// https://developers.google.com/maps/faq#languagesupport.
	LanguageCode string `protobuf:"bytes,2,opt,name=language_code,json=languageCode,proto3" json:"language_code,omitempty"`
	// The Unicode country/region code (CLDR) of the location where the
	// request is coming from. This parameter is used to display the place
	// details, like region-specific place name, if available. The parameter can
	// affect results based on applicable law.
	//
	// For more information, see
	// https://www.unicode.org/cldr/charts/latest/supplemental/territory_language_information.html.
	//
	// Note that 3-digit region codes are not currently supported.
	RegionCode string `protobuf:"bytes,3,opt,name=region_code,json=regionCode,proto3" json:"region_code,omitempty"`
	// How results will be ranked in the response.
	RankPreference SearchTextRequest_RankPreference `protobuf:"varint,4,opt,name=rank_preference,json=rankPreference,proto3,enum=google.maps.places.v1.SearchTextRequest_RankPreference" json:"rank_preference,omitempty"`
	// The requested place type. Full list of types supported:
	// https://developers.google.com/maps/documentation/places/web-service/place-types.
	// Only support one included type.
	IncludedType string `protobuf:"bytes,6,opt,name=included_type,json=includedType,proto3" json:"included_type,omitempty"`
	// Used to restrict the search to places that are currently open.  The default
	// is false.
	OpenNow bool `protobuf:"varint,7,opt,name=open_now,json=openNow,proto3" json:"open_now,omitempty"`
	// Filter out results whose average user rating is strictly less than this
	// limit. A valid value must be a float between 0 and 5 (inclusively) at a
	// 0.5 cadence i.e. [0, 0.5, 1.0, ... , 5.0] inclusively. The input rating
	// will round up to the nearest 0.5(ceiling). For instance, a rating of 0.6
	// will eliminate all results with a less than 1.0 rating.
	MinRating float64 `protobuf:"fixed64,9,opt,name=min_rating,json=minRating,proto3" json:"min_rating,omitempty"`
	// Maximum number of results to return. It must be between 1 and 20,
	// inclusively. The default is 20.  If the number is unset, it falls back to
	// the upper limit. If the number is set to negative or exceeds the upper
	// limit, an INVALID_ARGUMENT error is returned.
	MaxResultCount int32 `protobuf:"varint,10,opt,name=max_result_count,json=maxResultCount,proto3" json:"max_result_count,omitempty"`
	// Used to restrict the search to places that are marked as certain price
	// levels. Users can choose any combinations of price levels. Default to
	// select all price levels.
	PriceLevels []PriceLevel `protobuf:"varint,11,rep,packed,name=price_levels,json=priceLevels,proto3,enum=google.maps.places.v1.PriceLevel" json:"price_levels,omitempty"`
	// Used to set strict type filtering for included_type. If set to true, only
	// results of the same type will be returned. Default to false.
	StrictTypeFiltering bool `protobuf:"varint,12,opt,name=strict_type_filtering,json=strictTypeFiltering,proto3" json:"strict_type_filtering,omitempty"`
	// The region to search. This location serves as a bias which means results
	// around given location might be returned. Cannot be set along with
	// location_restriction.
	LocationBias *SearchTextRequest_LocationBias `protobuf:"bytes,13,opt,name=location_bias,json=locationBias,proto3" json:"location_bias,omitempty"`
	// The region to search. This location serves as a restriction which means
	// results outside given location will not be returned. Cannot be set along
	// with location_bias.
	LocationRestriction *SearchTextRequest_LocationRestriction `protobuf:"bytes,14,opt,name=location_restriction,json=locationRestriction,proto3" json:"location_restriction,omitempty"`
}

func (x *SearchTextRequest) Reset() {
	*x = SearchTextRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_maps_places_v1_places_service_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SearchTextRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SearchTextRequest) ProtoMessage() {}

func (x *SearchTextRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_maps_places_v1_places_service_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SearchTextRequest.ProtoReflect.Descriptor instead.
func (*SearchTextRequest) Descriptor() ([]byte, []int) {
	return file_google_maps_places_v1_places_service_proto_rawDescGZIP(), []int{2}
}

func (x *SearchTextRequest) GetTextQuery() string {
	if x != nil {
		return x.TextQuery
	}
	return ""
}

func (x *SearchTextRequest) GetLanguageCode() string {
	if x != nil {
		return x.LanguageCode
	}
	return ""
}

func (x *SearchTextRequest) GetRegionCode() string {
	if x != nil {
		return x.RegionCode
	}
	return ""
}

func (x *SearchTextRequest) GetRankPreference() SearchTextRequest_RankPreference {
	if x != nil {
		return x.RankPreference
	}
	return SearchTextRequest_RANK_PREFERENCE_UNSPECIFIED
}

func (x *SearchTextRequest) GetIncludedType() string {
	if x != nil {
		return x.IncludedType
	}
	return ""
}

func (x *SearchTextRequest) GetOpenNow() bool {
	if x != nil {
		return x.OpenNow
	}
	return false
}

func (x *SearchTextRequest) GetMinRating() float64 {
	if x != nil {
		return x.MinRating
	}
	return 0
}

func (x *SearchTextRequest) GetMaxResultCount() int32 {
	if x != nil {
		return x.MaxResultCount
	}
	return 0
}

func (x *SearchTextRequest) GetPriceLevels() []PriceLevel {
	if x != nil {
		return x.PriceLevels
	}
	return nil
}

func (x *SearchTextRequest) GetStrictTypeFiltering() bool {
	if x != nil {
		return x.StrictTypeFiltering
	}
	return false
}

func (x *SearchTextRequest) GetLocationBias() *SearchTextRequest_LocationBias {
	if x != nil {
		return x.LocationBias
	}
	return nil
}

func (x *SearchTextRequest) GetLocationRestriction() *SearchTextRequest_LocationRestriction {
	if x != nil {
		return x.LocationRestriction
	}
	return nil
}

// Response proto for SearchText.
type SearchTextResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A list of places that meet the user's text search criteria.
	Places []*Place `protobuf:"bytes,1,rep,name=places,proto3" json:"places,omitempty"`
}

func (x *SearchTextResponse) Reset() {
	*x = SearchTextResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_maps_places_v1_places_service_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SearchTextResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SearchTextResponse) ProtoMessage() {}

func (x *SearchTextResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_maps_places_v1_places_service_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SearchTextResponse.ProtoReflect.Descriptor instead.
func (*SearchTextResponse) Descriptor() ([]byte, []int) {
	return file_google_maps_places_v1_places_service_proto_rawDescGZIP(), []int{3}
}

func (x *SearchTextResponse) GetPlaces() []*Place {
	if x != nil {
		return x.Places
	}
	return nil
}

// Request for fetching a photo of a place using a photo resource name.
type GetPhotoMediaRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of a photo media in the format:
	// `places/{place_id}/photos/{photo_reference}/media`.
	//
	// The resource name of a photo as returned in a Place object's `photos.name`
	// field comes with the format
	// `places/{place_id}/photos/{photo_reference}`. You need to append `/media`
	// at the end of the photo resource to get the photo media resource name.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. Specifies the maximum desired width, in pixels, of the image. If
	// the image is smaller than the values specified, the original image will be
	// returned. If the image is larger in either dimension, it will be scaled to
	// match the smaller of the two dimensions, restricted to its original aspect
	// ratio. Both the max_height_px and max_width_px properties accept an integer
	// between 1 and 4800, inclusively. If the value is not within the allowed
	// range, an INVALID_ARGUMENT error will be returned.
	//
	// At least one of max_height_px or max_width_px needs to be specified. If
	// neither max_height_px nor max_width_px is specified, an INVALID_ARGUMENT
	// error will be returned.
	MaxWidthPx int32 `protobuf:"varint,2,opt,name=max_width_px,json=maxWidthPx,proto3" json:"max_width_px,omitempty"`
	// Optional. Specifies the maximum desired height, in pixels, of the image. If
	// the image is smaller than the values specified, the original image will be
	// returned. If the image is larger in either dimension, it will be scaled to
	// match the smaller of the two dimensions, restricted to its original aspect
	// ratio. Both the max_height_px and max_width_px properties accept an integer
	// between 1 and 4800, inclusively. If the value is not within the allowed
	// range, an INVALID_ARGUMENT error will be returned.
	//
	// At least one of max_height_px or max_width_px needs to be specified. If
	// neither max_height_px nor max_width_px is specified, an INVALID_ARGUMENT
	// error will be returned.
	MaxHeightPx int32 `protobuf:"varint,3,opt,name=max_height_px,json=maxHeightPx,proto3" json:"max_height_px,omitempty"`
	// Optional. If set, skip the default HTTP redirect behavior and render a text
	// format (for example, in JSON format for HTTP use case) response. If not
	// set, an HTTP redirect will be issued to redirect the call to the image
	// media. This option is ignored for non-HTTP requests.
	SkipHttpRedirect bool `protobuf:"varint,4,opt,name=skip_http_redirect,json=skipHttpRedirect,proto3" json:"skip_http_redirect,omitempty"`
}

func (x *GetPhotoMediaRequest) Reset() {
	*x = GetPhotoMediaRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_maps_places_v1_places_service_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetPhotoMediaRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetPhotoMediaRequest) ProtoMessage() {}

func (x *GetPhotoMediaRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_maps_places_v1_places_service_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetPhotoMediaRequest.ProtoReflect.Descriptor instead.
func (*GetPhotoMediaRequest) Descriptor() ([]byte, []int) {
	return file_google_maps_places_v1_places_service_proto_rawDescGZIP(), []int{4}
}

func (x *GetPhotoMediaRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *GetPhotoMediaRequest) GetMaxWidthPx() int32 {
	if x != nil {
		return x.MaxWidthPx
	}
	return 0
}

func (x *GetPhotoMediaRequest) GetMaxHeightPx() int32 {
	if x != nil {
		return x.MaxHeightPx
	}
	return 0
}

func (x *GetPhotoMediaRequest) GetSkipHttpRedirect() bool {
	if x != nil {
		return x.SkipHttpRedirect
	}
	return false
}

// A photo media from Places API.
type PhotoMedia struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The resource name of a photo media in the format:
	// `places/{place_id}/photos/{photo_reference}/media`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// A short-lived uri that can be used to render the photo.
	PhotoUri string `protobuf:"bytes,2,opt,name=photo_uri,json=photoUri,proto3" json:"photo_uri,omitempty"`
}

func (x *PhotoMedia) Reset() {
	*x = PhotoMedia{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_maps_places_v1_places_service_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PhotoMedia) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PhotoMedia) ProtoMessage() {}

func (x *PhotoMedia) ProtoReflect() protoreflect.Message {
	mi := &file_google_maps_places_v1_places_service_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PhotoMedia.ProtoReflect.Descriptor instead.
func (*PhotoMedia) Descriptor() ([]byte, []int) {
	return file_google_maps_places_v1_places_service_proto_rawDescGZIP(), []int{5}
}

func (x *PhotoMedia) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *PhotoMedia) GetPhotoUri() string {
	if x != nil {
		return x.PhotoUri
	}
	return ""
}

// Request for fetching a Place with a place id (in a name) string.
type GetPlaceRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. A place ID returned in a Place (with "places/" prefix), or
	// equivalently the name in the same Place. Format:
	// `places/{place_id}`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. Place details will be displayed with the preferred language if
	// available.
	//
	// Current list of supported languages:
	// https://developers.google.com/maps/faq#languagesupport.
	LanguageCode string `protobuf:"bytes,2,opt,name=language_code,json=languageCode,proto3" json:"language_code,omitempty"`
	// Optional. The Unicode country/region code (CLDR) of the location where the
	// request is coming from. This parameter is used to display the place
	// details, like region-specific place name, if available. The parameter can
	// affect results based on applicable law.
	// For more information, see
	// https://www.unicode.org/cldr/charts/latest/supplemental/territory_language_information.html.
	//
	// Note that 3-digit region codes are not currently supported.
	RegionCode string `protobuf:"bytes,3,opt,name=region_code,json=regionCode,proto3" json:"region_code,omitempty"`
}

func (x *GetPlaceRequest) Reset() {
	*x = GetPlaceRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_maps_places_v1_places_service_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetPlaceRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetPlaceRequest) ProtoMessage() {}

func (x *GetPlaceRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_maps_places_v1_places_service_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetPlaceRequest.ProtoReflect.Descriptor instead.
func (*GetPlaceRequest) Descriptor() ([]byte, []int) {
	return file_google_maps_places_v1_places_service_proto_rawDescGZIP(), []int{6}
}

func (x *GetPlaceRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *GetPlaceRequest) GetLanguageCode() string {
	if x != nil {
		return x.LanguageCode
	}
	return ""
}

func (x *GetPlaceRequest) GetRegionCode() string {
	if x != nil {
		return x.RegionCode
	}
	return ""
}

// The region to search.
type SearchNearbyRequest_LocationRestriction struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to Type:
	//
	//	*SearchNearbyRequest_LocationRestriction_Circle
	Type isSearchNearbyRequest_LocationRestriction_Type `protobuf_oneof:"type"`
}

func (x *SearchNearbyRequest_LocationRestriction) Reset() {
	*x = SearchNearbyRequest_LocationRestriction{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_maps_places_v1_places_service_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SearchNearbyRequest_LocationRestriction) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SearchNearbyRequest_LocationRestriction) ProtoMessage() {}

func (x *SearchNearbyRequest_LocationRestriction) ProtoReflect() protoreflect.Message {
	mi := &file_google_maps_places_v1_places_service_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SearchNearbyRequest_LocationRestriction.ProtoReflect.Descriptor instead.
func (*SearchNearbyRequest_LocationRestriction) Descriptor() ([]byte, []int) {
	return file_google_maps_places_v1_places_service_proto_rawDescGZIP(), []int{0, 0}
}

func (m *SearchNearbyRequest_LocationRestriction) GetType() isSearchNearbyRequest_LocationRestriction_Type {
	if m != nil {
		return m.Type
	}
	return nil
}

func (x *SearchNearbyRequest_LocationRestriction) GetCircle() *Circle {
	if x, ok := x.GetType().(*SearchNearbyRequest_LocationRestriction_Circle); ok {
		return x.Circle
	}
	return nil
}

type isSearchNearbyRequest_LocationRestriction_Type interface {
	isSearchNearbyRequest_LocationRestriction_Type()
}

type SearchNearbyRequest_LocationRestriction_Circle struct {
	// A circle defined by center point and radius.
	Circle *Circle `protobuf:"bytes,2,opt,name=circle,proto3,oneof"`
}

func (*SearchNearbyRequest_LocationRestriction_Circle) isSearchNearbyRequest_LocationRestriction_Type() {
}

// The region to search. This location serves as a bias which means results
// around given location might be returned.
type SearchTextRequest_LocationBias struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to Type:
	//
	//	*SearchTextRequest_LocationBias_Rectangle
	//	*SearchTextRequest_LocationBias_Circle
	Type isSearchTextRequest_LocationBias_Type `protobuf_oneof:"type"`
}

func (x *SearchTextRequest_LocationBias) Reset() {
	*x = SearchTextRequest_LocationBias{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_maps_places_v1_places_service_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SearchTextRequest_LocationBias) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SearchTextRequest_LocationBias) ProtoMessage() {}

func (x *SearchTextRequest_LocationBias) ProtoReflect() protoreflect.Message {
	mi := &file_google_maps_places_v1_places_service_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SearchTextRequest_LocationBias.ProtoReflect.Descriptor instead.
func (*SearchTextRequest_LocationBias) Descriptor() ([]byte, []int) {
	return file_google_maps_places_v1_places_service_proto_rawDescGZIP(), []int{2, 0}
}

func (m *SearchTextRequest_LocationBias) GetType() isSearchTextRequest_LocationBias_Type {
	if m != nil {
		return m.Type
	}
	return nil
}

func (x *SearchTextRequest_LocationBias) GetRectangle() *viewport.Viewport {
	if x, ok := x.GetType().(*SearchTextRequest_LocationBias_Rectangle); ok {
		return x.Rectangle
	}
	return nil
}

func (x *SearchTextRequest_LocationBias) GetCircle() *Circle {
	if x, ok := x.GetType().(*SearchTextRequest_LocationBias_Circle); ok {
		return x.Circle
	}
	return nil
}

type isSearchTextRequest_LocationBias_Type interface {
	isSearchTextRequest_LocationBias_Type()
}

type SearchTextRequest_LocationBias_Rectangle struct {
	// A rectangle box defined by northeast and southwest corner.
	// `rectangle.high()` must be the northeast point of the rectangle
	// viewport. `rectangle.low()` must be the southwest point of the
	// rectangle viewport. `rectangle.low().latitude()` cannot be greater than
	// `rectangle.high().latitude()`. This will result in an empty latitude
	// range. A rectangle viewport cannot be wider than 180 degrees.
	Rectangle *viewport.Viewport `protobuf:"bytes,1,opt,name=rectangle,proto3,oneof"`
}

type SearchTextRequest_LocationBias_Circle struct {
	// A circle defined by center point and radius.
	Circle *Circle `protobuf:"bytes,2,opt,name=circle,proto3,oneof"`
}

func (*SearchTextRequest_LocationBias_Rectangle) isSearchTextRequest_LocationBias_Type() {}

func (*SearchTextRequest_LocationBias_Circle) isSearchTextRequest_LocationBias_Type() {}

// The region to search. This location serves as a restriction which means
// results outside given location will not be returned.
type SearchTextRequest_LocationRestriction struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to Type:
	//
	//	*SearchTextRequest_LocationRestriction_Rectangle
	Type isSearchTextRequest_LocationRestriction_Type `protobuf_oneof:"type"`
}

func (x *SearchTextRequest_LocationRestriction) Reset() {
	*x = SearchTextRequest_LocationRestriction{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_maps_places_v1_places_service_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SearchTextRequest_LocationRestriction) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SearchTextRequest_LocationRestriction) ProtoMessage() {}

func (x *SearchTextRequest_LocationRestriction) ProtoReflect() protoreflect.Message {
	mi := &file_google_maps_places_v1_places_service_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SearchTextRequest_LocationRestriction.ProtoReflect.Descriptor instead.
func (*SearchTextRequest_LocationRestriction) Descriptor() ([]byte, []int) {
	return file_google_maps_places_v1_places_service_proto_rawDescGZIP(), []int{2, 1}
}

func (m *SearchTextRequest_LocationRestriction) GetType() isSearchTextRequest_LocationRestriction_Type {
	if m != nil {
		return m.Type
	}
	return nil
}

func (x *SearchTextRequest_LocationRestriction) GetRectangle() *viewport.Viewport {
	if x, ok := x.GetType().(*SearchTextRequest_LocationRestriction_Rectangle); ok {
		return x.Rectangle
	}
	return nil
}

type isSearchTextRequest_LocationRestriction_Type interface {
	isSearchTextRequest_LocationRestriction_Type()
}

type SearchTextRequest_LocationRestriction_Rectangle struct {
	// A rectangle box defined by northeast and southwest corner.
	// `rectangle.high()` must be the northeast point of the rectangle
	// viewport. `rectangle.low()` must be the southwest point of the
	// rectangle viewport. `rectangle.low().latitude()` cannot be greater than
	// `rectangle.high().latitude()`. This will result in an empty latitude
	// range. A rectangle viewport cannot be wider than 180 degrees.
	Rectangle *viewport.Viewport `protobuf:"bytes,1,opt,name=rectangle,proto3,oneof"`
}

func (*SearchTextRequest_LocationRestriction_Rectangle) isSearchTextRequest_LocationRestriction_Type() {
}

var File_google_maps_places_v1_places_service_proto protoreflect.FileDescriptor

var file_google_maps_places_v1_places_service_proto_rawDesc = []byte{
	0x0a, 0x2a, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x6d, 0x61, 0x70, 0x73, 0x2f, 0x70, 0x6c,
	0x61, 0x63, 0x65, 0x73, 0x2f, 0x76, 0x31, 0x2f, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x73, 0x5f, 0x73,
	0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x15, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6d, 0x61, 0x70, 0x73, 0x2e, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x73,
	0x2e, 0x76, 0x31, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f,
	0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x63, 0x6c,
	0x69, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68,
	0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x67,
	0x65, 0x6f, 0x2f, 0x74, 0x79, 0x70, 0x65, 0x2f, 0x76, 0x69, 0x65, 0x77, 0x70, 0x6f, 0x72, 0x74,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x24, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x6d,
	0x61, 0x70, 0x73, 0x2f, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x73, 0x2f, 0x76, 0x31, 0x2f, 0x67, 0x65,
	0x6f, 0x6d, 0x65, 0x74, 0x72, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x21, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x6d, 0x61, 0x70, 0x73, 0x2f, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x73,
	0x2f, 0x76, 0x31, 0x2f, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22,
	0xc4, 0x05, 0x0a, 0x13, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x4e, 0x65, 0x61, 0x72, 0x62, 0x79,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x23, 0x0a, 0x0d, 0x6c, 0x61, 0x6e, 0x67, 0x75,
	0x61, 0x67, 0x65, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c,
	0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x43, 0x6f, 0x64, 0x65, 0x12, 0x1f, 0x0a, 0x0b,
	0x72, 0x65, 0x67, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x0a, 0x72, 0x65, 0x67, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x64, 0x65, 0x12, 0x25, 0x0a,
	0x0e, 0x69, 0x6e, 0x63, 0x6c, 0x75, 0x64, 0x65, 0x64, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x73, 0x18,
	0x03, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0d, 0x69, 0x6e, 0x63, 0x6c, 0x75, 0x64, 0x65, 0x64, 0x54,
	0x79, 0x70, 0x65, 0x73, 0x12, 0x25, 0x0a, 0x0e, 0x65, 0x78, 0x63, 0x6c, 0x75, 0x64, 0x65, 0x64,
	0x5f, 0x74, 0x79, 0x70, 0x65, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0d, 0x65, 0x78,
	0x63, 0x6c, 0x75, 0x64, 0x65, 0x64, 0x54, 0x79, 0x70, 0x65, 0x73, 0x12, 0x34, 0x0a, 0x16, 0x69,
	0x6e, 0x63, 0x6c, 0x75, 0x64, 0x65, 0x64, 0x5f, 0x70, 0x72, 0x69, 0x6d, 0x61, 0x72, 0x79, 0x5f,
	0x74, 0x79, 0x70, 0x65, 0x73, 0x18, 0x05, 0x20, 0x03, 0x28, 0x09, 0x52, 0x14, 0x69, 0x6e, 0x63,
	0x6c, 0x75, 0x64, 0x65, 0x64, 0x50, 0x72, 0x69, 0x6d, 0x61, 0x72, 0x79, 0x54, 0x79, 0x70, 0x65,
	0x73, 0x12, 0x34, 0x0a, 0x16, 0x65, 0x78, 0x63, 0x6c, 0x75, 0x64, 0x65, 0x64, 0x5f, 0x70, 0x72,
	0x69, 0x6d, 0x61, 0x72, 0x79, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x73, 0x18, 0x06, 0x20, 0x03, 0x28,
	0x09, 0x52, 0x14, 0x65, 0x78, 0x63, 0x6c, 0x75, 0x64, 0x65, 0x64, 0x50, 0x72, 0x69, 0x6d, 0x61,
	0x72, 0x79, 0x54, 0x79, 0x70, 0x65, 0x73, 0x12, 0x28, 0x0a, 0x10, 0x6d, 0x61, 0x78, 0x5f, 0x72,
	0x65, 0x73, 0x75, 0x6c, 0x74, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x07, 0x20, 0x01, 0x28,
	0x05, 0x52, 0x0e, 0x6d, 0x61, 0x78, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x43, 0x6f, 0x75, 0x6e,
	0x74, 0x12, 0x76, 0x0a, 0x14, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x72, 0x65,
	0x73, 0x74, 0x72, 0x69, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6d, 0x61, 0x70, 0x73, 0x2e, 0x70, 0x6c,
	0x61, 0x63, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x4e, 0x65,
	0x61, 0x72, 0x62, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x4c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x74, 0x72, 0x69, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x42,
	0x03, 0xe0, 0x41, 0x02, 0x52, 0x13, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65,
	0x73, 0x74, 0x72, 0x69, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x62, 0x0a, 0x0f, 0x72, 0x61, 0x6e,
	0x6b, 0x5f, 0x70, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x18, 0x09, 0x20, 0x01,
	0x28, 0x0e, 0x32, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6d, 0x61, 0x70, 0x73,
	0x2e, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65, 0x61, 0x72, 0x63,
	0x68, 0x4e, 0x65, 0x61, 0x72, 0x62, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x52,
	0x61, 0x6e, 0x6b, 0x50, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x52, 0x0e, 0x72,
	0x61, 0x6e, 0x6b, 0x50, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x1a, 0x56, 0x0a,
	0x13, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x74, 0x72, 0x69, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x12, 0x37, 0x0a, 0x06, 0x63, 0x69, 0x72, 0x63, 0x6c, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6d, 0x61,
	0x70, 0x73, 0x2e, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x69, 0x72,
	0x63, 0x6c, 0x65, 0x48, 0x00, 0x52, 0x06, 0x63, 0x69, 0x72, 0x63, 0x6c, 0x65, 0x42, 0x06, 0x0a,
	0x04, 0x74, 0x79, 0x70, 0x65, 0x22, 0x4f, 0x0a, 0x0e, 0x52, 0x61, 0x6e, 0x6b, 0x50, 0x72, 0x65,
	0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x12, 0x1f, 0x0a, 0x1b, 0x52, 0x41, 0x4e, 0x4b, 0x5f,
	0x50, 0x52, 0x45, 0x46, 0x45, 0x52, 0x45, 0x4e, 0x43, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45,
	0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0c, 0x0a, 0x08, 0x44, 0x49, 0x53, 0x54,
	0x41, 0x4e, 0x43, 0x45, 0x10, 0x01, 0x12, 0x0e, 0x0a, 0x0a, 0x50, 0x4f, 0x50, 0x55, 0x4c, 0x41,
	0x52, 0x49, 0x54, 0x59, 0x10, 0x02, 0x22, 0x4c, 0x0a, 0x14, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68,
	0x4e, 0x65, 0x61, 0x72, 0x62, 0x79, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x34,
	0x0a, 0x06, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1c,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6d, 0x61, 0x70, 0x73, 0x2e, 0x70, 0x6c, 0x61,
	0x63, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x6c, 0x61, 0x63, 0x65, 0x52, 0x06, 0x70, 0x6c,
	0x61, 0x63, 0x65, 0x73, 0x22, 0xe6, 0x07, 0x0a, 0x11, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x54,
	0x65, 0x78, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x22, 0x0a, 0x0a, 0x74, 0x65,
	0x78, 0x74, 0x5f, 0x71, 0x75, 0x65, 0x72, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x02, 0x52, 0x09, 0x74, 0x65, 0x78, 0x74, 0x51, 0x75, 0x65, 0x72, 0x79, 0x12, 0x23,
	0x0a, 0x0d, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x43,
	0x6f, 0x64, 0x65, 0x12, 0x1f, 0x0a, 0x0b, 0x72, 0x65, 0x67, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x6f,
	0x64, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x72, 0x65, 0x67, 0x69, 0x6f, 0x6e,
	0x43, 0x6f, 0x64, 0x65, 0x12, 0x60, 0x0a, 0x0f, 0x72, 0x61, 0x6e, 0x6b, 0x5f, 0x70, 0x72, 0x65,
	0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x37, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6d, 0x61, 0x70, 0x73, 0x2e, 0x70, 0x6c, 0x61, 0x63,
	0x65, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x54, 0x65, 0x78, 0x74,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x52, 0x61, 0x6e, 0x6b, 0x50, 0x72, 0x65, 0x66,
	0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x52, 0x0e, 0x72, 0x61, 0x6e, 0x6b, 0x50, 0x72, 0x65, 0x66,
	0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x12, 0x23, 0x0a, 0x0d, 0x69, 0x6e, 0x63, 0x6c, 0x75, 0x64,
	0x65, 0x64, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x69,
	0x6e, 0x63, 0x6c, 0x75, 0x64, 0x65, 0x64, 0x54, 0x79, 0x70, 0x65, 0x12, 0x19, 0x0a, 0x08, 0x6f,
	0x70, 0x65, 0x6e, 0x5f, 0x6e, 0x6f, 0x77, 0x18, 0x07, 0x20, 0x01, 0x28, 0x08, 0x52, 0x07, 0x6f,
	0x70, 0x65, 0x6e, 0x4e, 0x6f, 0x77, 0x12, 0x1d, 0x0a, 0x0a, 0x6d, 0x69, 0x6e, 0x5f, 0x72, 0x61,
	0x74, 0x69, 0x6e, 0x67, 0x18, 0x09, 0x20, 0x01, 0x28, 0x01, 0x52, 0x09, 0x6d, 0x69, 0x6e, 0x52,
	0x61, 0x74, 0x69, 0x6e, 0x67, 0x12, 0x28, 0x0a, 0x10, 0x6d, 0x61, 0x78, 0x5f, 0x72, 0x65, 0x73,
	0x75, 0x6c, 0x74, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x05, 0x52,
	0x0e, 0x6d, 0x61, 0x78, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12,
	0x44, 0x0a, 0x0c, 0x70, 0x72, 0x69, 0x63, 0x65, 0x5f, 0x6c, 0x65, 0x76, 0x65, 0x6c, 0x73, 0x18,
	0x0b, 0x20, 0x03, 0x28, 0x0e, 0x32, 0x21, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6d,
	0x61, 0x70, 0x73, 0x2e, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x72,
	0x69, 0x63, 0x65, 0x4c, 0x65, 0x76, 0x65, 0x6c, 0x52, 0x0b, 0x70, 0x72, 0x69, 0x63, 0x65, 0x4c,
	0x65, 0x76, 0x65, 0x6c, 0x73, 0x12, 0x32, 0x0a, 0x15, 0x73, 0x74, 0x72, 0x69, 0x63, 0x74, 0x5f,
	0x74, 0x79, 0x70, 0x65, 0x5f, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x67, 0x18, 0x0c,
	0x20, 0x01, 0x28, 0x08, 0x52, 0x13, 0x73, 0x74, 0x72, 0x69, 0x63, 0x74, 0x54, 0x79, 0x70, 0x65,
	0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x67, 0x12, 0x5a, 0x0a, 0x0d, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x62, 0x69, 0x61, 0x73, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6d, 0x61, 0x70, 0x73, 0x2e, 0x70,
	0x6c, 0x61, 0x63, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x54,
	0x65, 0x78, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x4c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x42, 0x69, 0x61, 0x73, 0x52, 0x0c, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x42, 0x69, 0x61, 0x73, 0x12, 0x6f, 0x0a, 0x14, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x5f, 0x72, 0x65, 0x73, 0x74, 0x72, 0x69, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x0e, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6d, 0x61, 0x70,
	0x73, 0x2e, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65, 0x61, 0x72,
	0x63, 0x68, 0x54, 0x65, 0x78, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x4c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x74, 0x72, 0x69, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x52, 0x13, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x74, 0x72,
	0x69, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x1a, 0x8a, 0x01, 0x0a, 0x0c, 0x4c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x42, 0x69, 0x61, 0x73, 0x12, 0x39, 0x0a, 0x09, 0x72, 0x65, 0x63, 0x74, 0x61,
	0x6e, 0x67, 0x6c, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x67, 0x65, 0x6f, 0x2e, 0x74, 0x79, 0x70, 0x65, 0x2e, 0x56, 0x69, 0x65,
	0x77, 0x70, 0x6f, 0x72, 0x74, 0x48, 0x00, 0x52, 0x09, 0x72, 0x65, 0x63, 0x74, 0x61, 0x6e, 0x67,
	0x6c, 0x65, 0x12, 0x37, 0x0a, 0x06, 0x63, 0x69, 0x72, 0x63, 0x6c, 0x65, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6d, 0x61, 0x70, 0x73,
	0x2e, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x69, 0x72, 0x63, 0x6c,
	0x65, 0x48, 0x00, 0x52, 0x06, 0x63, 0x69, 0x72, 0x63, 0x6c, 0x65, 0x42, 0x06, 0x0a, 0x04, 0x74,
	0x79, 0x70, 0x65, 0x1a, 0x58, 0x0a, 0x13, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52,
	0x65, 0x73, 0x74, 0x72, 0x69, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x39, 0x0a, 0x09, 0x72, 0x65,
	0x63, 0x74, 0x61, 0x6e, 0x67, 0x6c, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x65, 0x6f, 0x2e, 0x74, 0x79, 0x70, 0x65, 0x2e,
	0x56, 0x69, 0x65, 0x77, 0x70, 0x6f, 0x72, 0x74, 0x48, 0x00, 0x52, 0x09, 0x72, 0x65, 0x63, 0x74,
	0x61, 0x6e, 0x67, 0x6c, 0x65, 0x42, 0x06, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x22, 0x4e, 0x0a,
	0x0e, 0x52, 0x61, 0x6e, 0x6b, 0x50, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x12,
	0x1f, 0x0a, 0x1b, 0x52, 0x41, 0x4e, 0x4b, 0x5f, 0x50, 0x52, 0x45, 0x46, 0x45, 0x52, 0x45, 0x4e,
	0x43, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00,
	0x12, 0x0c, 0x0a, 0x08, 0x44, 0x49, 0x53, 0x54, 0x41, 0x4e, 0x43, 0x45, 0x10, 0x01, 0x12, 0x0d,
	0x0a, 0x09, 0x52, 0x45, 0x4c, 0x45, 0x56, 0x41, 0x4e, 0x43, 0x45, 0x10, 0x02, 0x22, 0x4a, 0x0a,
	0x12, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x54, 0x65, 0x78, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x12, 0x34, 0x0a, 0x06, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x73, 0x18, 0x01, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6d, 0x61, 0x70,
	0x73, 0x2e, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x6c, 0x61, 0x63,
	0x65, 0x52, 0x06, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x73, 0x22, 0xd7, 0x01, 0x0a, 0x14, 0x47, 0x65,
	0x74, 0x50, 0x68, 0x6f, 0x74, 0x6f, 0x4d, 0x65, 0x64, 0x69, 0x61, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x3c, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x28, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x22, 0x0a, 0x20, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x73,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x50, 0x68, 0x6f, 0x74, 0x6f, 0x4d, 0x65, 0x64, 0x69, 0x61, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x12, 0x25, 0x0a, 0x0c, 0x6d, 0x61, 0x78, 0x5f, 0x77, 0x69, 0x64, 0x74, 0x68, 0x5f, 0x70, 0x78,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0a, 0x6d, 0x61, 0x78,
	0x57, 0x69, 0x64, 0x74, 0x68, 0x50, 0x78, 0x12, 0x27, 0x0a, 0x0d, 0x6d, 0x61, 0x78, 0x5f, 0x68,
	0x65, 0x69, 0x67, 0x68, 0x74, 0x5f, 0x70, 0x78, 0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x52, 0x0b, 0x6d, 0x61, 0x78, 0x48, 0x65, 0x69, 0x67, 0x68, 0x74, 0x50, 0x78,
	0x12, 0x31, 0x0a, 0x12, 0x73, 0x6b, 0x69, 0x70, 0x5f, 0x68, 0x74, 0x74, 0x70, 0x5f, 0x72, 0x65,
	0x64, 0x69, 0x72, 0x65, 0x63, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x10, 0x73, 0x6b, 0x69, 0x70, 0x48, 0x74, 0x74, 0x70, 0x52, 0x65, 0x64, 0x69, 0x72,
	0x65, 0x63, 0x74, 0x22, 0xaf, 0x01, 0x0a, 0x0a, 0x50, 0x68, 0x6f, 0x74, 0x6f, 0x4d, 0x65, 0x64,
	0x69, 0x61, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x68, 0x6f, 0x74, 0x6f, 0x5f,
	0x75, 0x72, 0x69, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x70, 0x68, 0x6f, 0x74, 0x6f,
	0x55, 0x72, 0x69, 0x3a, 0x70, 0xea, 0x41, 0x6d, 0x0a, 0x20, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x73,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x50, 0x68, 0x6f, 0x74, 0x6f, 0x4d, 0x65, 0x64, 0x69, 0x61, 0x12, 0x30, 0x70, 0x6c, 0x61, 0x63,
	0x65, 0x73, 0x2f, 0x7b, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x5f, 0x69, 0x64, 0x7d, 0x2f, 0x70, 0x68,
	0x6f, 0x74, 0x6f, 0x73, 0x2f, 0x7b, 0x70, 0x68, 0x6f, 0x74, 0x6f, 0x5f, 0x72, 0x65, 0x66, 0x65,
	0x72, 0x65, 0x6e, 0x63, 0x65, 0x7d, 0x2f, 0x6d, 0x65, 0x64, 0x69, 0x61, 0x2a, 0x0b, 0x70, 0x68,
	0x6f, 0x74, 0x6f, 0x4d, 0x65, 0x64, 0x69, 0x61, 0x73, 0x32, 0x0a, 0x70, 0x68, 0x6f, 0x74, 0x6f,
	0x4d, 0x65, 0x64, 0x69, 0x61, 0x22, 0x9a, 0x01, 0x0a, 0x0f, 0x47, 0x65, 0x74, 0x50, 0x6c, 0x61,
	0x63, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x37, 0x0a, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x23, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x1d, 0x0a,
	0x1b, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50, 0x6c, 0x61, 0x63, 0x65, 0x52, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x12, 0x28, 0x0a, 0x0d, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x5f, 0x63,
	0x6f, 0x64, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0c,
	0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x43, 0x6f, 0x64, 0x65, 0x12, 0x24, 0x0a, 0x0b,
	0x72, 0x65, 0x67, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0a, 0x72, 0x65, 0x67, 0x69, 0x6f, 0x6e, 0x43, 0x6f,
	0x64, 0x65, 0x32, 0xc1, 0x04, 0x0a, 0x06, 0x50, 0x6c, 0x61, 0x63, 0x65, 0x73, 0x12, 0x8b, 0x01,
	0x0a, 0x0c, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x4e, 0x65, 0x61, 0x72, 0x62, 0x79, 0x12, 0x2a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6d, 0x61, 0x70, 0x73, 0x2e, 0x70, 0x6c, 0x61,
	0x63, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x4e, 0x65, 0x61,
	0x72, 0x62, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2b, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x6d, 0x61, 0x70, 0x73, 0x2e, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x73, 0x2e,
	0x76, 0x31, 0x2e, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x4e, 0x65, 0x61, 0x72, 0x62, 0x79, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x22, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x1c, 0x3a,
	0x01, 0x2a, 0x22, 0x17, 0x2f, 0x76, 0x31, 0x2f, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x73, 0x3a, 0x73,
	0x65, 0x61, 0x72, 0x63, 0x68, 0x4e, 0x65, 0x61, 0x72, 0x62, 0x79, 0x12, 0x83, 0x01, 0x0a, 0x0a,
	0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x54, 0x65, 0x78, 0x74, 0x12, 0x28, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x6d, 0x61, 0x70, 0x73, 0x2e, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x73, 0x2e,
	0x76, 0x31, 0x2e, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x54, 0x65, 0x78, 0x74, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6d, 0x61,
	0x70, 0x73, 0x2e, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65, 0x61,
	0x72, 0x63, 0x68, 0x54, 0x65, 0x78, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22,
	0x20, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x1a, 0x3a, 0x01, 0x2a, 0x22, 0x15, 0x2f, 0x76, 0x31, 0x2f,
	0x70, 0x6c, 0x61, 0x63, 0x65, 0x73, 0x3a, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x54, 0x65, 0x78,
	0x74, 0x12, 0x92, 0x01, 0x0a, 0x0d, 0x47, 0x65, 0x74, 0x50, 0x68, 0x6f, 0x74, 0x6f, 0x4d, 0x65,
	0x64, 0x69, 0x61, 0x12, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6d, 0x61, 0x70,
	0x73, 0x2e, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x50,
	0x68, 0x6f, 0x74, 0x6f, 0x4d, 0x65, 0x64, 0x69, 0x61, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x21, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6d, 0x61, 0x70, 0x73, 0x2e, 0x70,
	0x6c, 0x61, 0x63, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x68, 0x6f, 0x74, 0x6f, 0x4d, 0x65,
	0x64, 0x69, 0x61, 0x22, 0x31, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93,
	0x02, 0x24, 0x12, 0x22, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x6c,
	0x61, 0x63, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x70, 0x68, 0x6f, 0x74, 0x6f, 0x73, 0x2f, 0x2a, 0x2f,
	0x6d, 0x65, 0x64, 0x69, 0x61, 0x7d, 0x12, 0x74, 0x0a, 0x08, 0x47, 0x65, 0x74, 0x50, 0x6c, 0x61,
	0x63, 0x65, 0x12, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6d, 0x61, 0x70, 0x73,
	0x2e, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x50, 0x6c,
	0x61, 0x63, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1c, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x6d, 0x61, 0x70, 0x73, 0x2e, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x73, 0x2e,
	0x76, 0x31, 0x2e, 0x50, 0x6c, 0x61, 0x63, 0x65, 0x22, 0x22, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x15, 0x12, 0x13, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61,
	0x6d, 0x65, 0x3d, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x1a, 0x18, 0xca, 0x41,
	0x15, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x42, 0xa6, 0x01, 0x0a, 0x19, 0x63, 0x6f, 0x6d, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6d, 0x61, 0x70, 0x73, 0x2e, 0x70, 0x6c, 0x61, 0x63, 0x65,
	0x73, 0x2e, 0x76, 0x31, 0x42, 0x12, 0x50, 0x6c, 0x61, 0x63, 0x65, 0x73, 0x53, 0x65, 0x72, 0x76,
	0x69, 0x63, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x37, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f,
	0x6d, 0x61, 0x70, 0x73, 0x2f, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x73, 0x2f, 0x61, 0x70, 0x69, 0x76,
	0x31, 0x2f, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x73, 0x70, 0x62, 0x3b, 0x70, 0x6c, 0x61, 0x63, 0x65,
	0x73, 0x70, 0x62, 0xf8, 0x01, 0x01, 0xa2, 0x02, 0x06, 0x47, 0x4d, 0x50, 0x53, 0x56, 0x31, 0xaa,
	0x02, 0x15, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x4d, 0x61, 0x70, 0x73, 0x2e, 0x50, 0x6c,
	0x61, 0x63, 0x65, 0x73, 0x2e, 0x56, 0x31, 0xca, 0x02, 0x15, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x5c, 0x4d, 0x61, 0x70, 0x73, 0x5c, 0x50, 0x6c, 0x61, 0x63, 0x65, 0x73, 0x5c, 0x56, 0x31, 0x62,
	0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_maps_places_v1_places_service_proto_rawDescOnce sync.Once
	file_google_maps_places_v1_places_service_proto_rawDescData = file_google_maps_places_v1_places_service_proto_rawDesc
)

func file_google_maps_places_v1_places_service_proto_rawDescGZIP() []byte {
	file_google_maps_places_v1_places_service_proto_rawDescOnce.Do(func() {
		file_google_maps_places_v1_places_service_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_maps_places_v1_places_service_proto_rawDescData)
	})
	return file_google_maps_places_v1_places_service_proto_rawDescData
}

var file_google_maps_places_v1_places_service_proto_enumTypes = make([]protoimpl.EnumInfo, 2)
var file_google_maps_places_v1_places_service_proto_msgTypes = make([]protoimpl.MessageInfo, 10)
var file_google_maps_places_v1_places_service_proto_goTypes = []interface{}{
	(SearchNearbyRequest_RankPreference)(0),         // 0: google.maps.places.v1.SearchNearbyRequest.RankPreference
	(SearchTextRequest_RankPreference)(0),           // 1: google.maps.places.v1.SearchTextRequest.RankPreference
	(*SearchNearbyRequest)(nil),                     // 2: google.maps.places.v1.SearchNearbyRequest
	(*SearchNearbyResponse)(nil),                    // 3: google.maps.places.v1.SearchNearbyResponse
	(*SearchTextRequest)(nil),                       // 4: google.maps.places.v1.SearchTextRequest
	(*SearchTextResponse)(nil),                      // 5: google.maps.places.v1.SearchTextResponse
	(*GetPhotoMediaRequest)(nil),                    // 6: google.maps.places.v1.GetPhotoMediaRequest
	(*PhotoMedia)(nil),                              // 7: google.maps.places.v1.PhotoMedia
	(*GetPlaceRequest)(nil),                         // 8: google.maps.places.v1.GetPlaceRequest
	(*SearchNearbyRequest_LocationRestriction)(nil), // 9: google.maps.places.v1.SearchNearbyRequest.LocationRestriction
	(*SearchTextRequest_LocationBias)(nil),          // 10: google.maps.places.v1.SearchTextRequest.LocationBias
	(*SearchTextRequest_LocationRestriction)(nil),   // 11: google.maps.places.v1.SearchTextRequest.LocationRestriction
	(*Place)(nil),                                   // 12: google.maps.places.v1.Place
	(PriceLevel)(0),                                 // 13: google.maps.places.v1.PriceLevel
	(*Circle)(nil),                                  // 14: google.maps.places.v1.Circle
	(*viewport.Viewport)(nil),                       // 15: google.geo.type.Viewport
}
var file_google_maps_places_v1_places_service_proto_depIdxs = []int32{
	9,  // 0: google.maps.places.v1.SearchNearbyRequest.location_restriction:type_name -> google.maps.places.v1.SearchNearbyRequest.LocationRestriction
	0,  // 1: google.maps.places.v1.SearchNearbyRequest.rank_preference:type_name -> google.maps.places.v1.SearchNearbyRequest.RankPreference
	12, // 2: google.maps.places.v1.SearchNearbyResponse.places:type_name -> google.maps.places.v1.Place
	1,  // 3: google.maps.places.v1.SearchTextRequest.rank_preference:type_name -> google.maps.places.v1.SearchTextRequest.RankPreference
	13, // 4: google.maps.places.v1.SearchTextRequest.price_levels:type_name -> google.maps.places.v1.PriceLevel
	10, // 5: google.maps.places.v1.SearchTextRequest.location_bias:type_name -> google.maps.places.v1.SearchTextRequest.LocationBias
	11, // 6: google.maps.places.v1.SearchTextRequest.location_restriction:type_name -> google.maps.places.v1.SearchTextRequest.LocationRestriction
	12, // 7: google.maps.places.v1.SearchTextResponse.places:type_name -> google.maps.places.v1.Place
	14, // 8: google.maps.places.v1.SearchNearbyRequest.LocationRestriction.circle:type_name -> google.maps.places.v1.Circle
	15, // 9: google.maps.places.v1.SearchTextRequest.LocationBias.rectangle:type_name -> google.geo.type.Viewport
	14, // 10: google.maps.places.v1.SearchTextRequest.LocationBias.circle:type_name -> google.maps.places.v1.Circle
	15, // 11: google.maps.places.v1.SearchTextRequest.LocationRestriction.rectangle:type_name -> google.geo.type.Viewport
	2,  // 12: google.maps.places.v1.Places.SearchNearby:input_type -> google.maps.places.v1.SearchNearbyRequest
	4,  // 13: google.maps.places.v1.Places.SearchText:input_type -> google.maps.places.v1.SearchTextRequest
	6,  // 14: google.maps.places.v1.Places.GetPhotoMedia:input_type -> google.maps.places.v1.GetPhotoMediaRequest
	8,  // 15: google.maps.places.v1.Places.GetPlace:input_type -> google.maps.places.v1.GetPlaceRequest
	3,  // 16: google.maps.places.v1.Places.SearchNearby:output_type -> google.maps.places.v1.SearchNearbyResponse
	5,  // 17: google.maps.places.v1.Places.SearchText:output_type -> google.maps.places.v1.SearchTextResponse
	7,  // 18: google.maps.places.v1.Places.GetPhotoMedia:output_type -> google.maps.places.v1.PhotoMedia
	12, // 19: google.maps.places.v1.Places.GetPlace:output_type -> google.maps.places.v1.Place
	16, // [16:20] is the sub-list for method output_type
	12, // [12:16] is the sub-list for method input_type
	12, // [12:12] is the sub-list for extension type_name
	12, // [12:12] is the sub-list for extension extendee
	0,  // [0:12] is the sub-list for field type_name
}

func init() { file_google_maps_places_v1_places_service_proto_init() }
func file_google_maps_places_v1_places_service_proto_init() {
	if File_google_maps_places_v1_places_service_proto != nil {
		return
	}
	file_google_maps_places_v1_geometry_proto_init()
	file_google_maps_places_v1_place_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_google_maps_places_v1_places_service_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SearchNearbyRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_maps_places_v1_places_service_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SearchNearbyResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_maps_places_v1_places_service_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SearchTextRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_maps_places_v1_places_service_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SearchTextResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_maps_places_v1_places_service_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetPhotoMediaRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_maps_places_v1_places_service_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PhotoMedia); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_maps_places_v1_places_service_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetPlaceRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_maps_places_v1_places_service_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SearchNearbyRequest_LocationRestriction); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_maps_places_v1_places_service_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SearchTextRequest_LocationBias); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_maps_places_v1_places_service_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SearchTextRequest_LocationRestriction); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_maps_places_v1_places_service_proto_msgTypes[7].OneofWrappers = []interface{}{
		(*SearchNearbyRequest_LocationRestriction_Circle)(nil),
	}
	file_google_maps_places_v1_places_service_proto_msgTypes[8].OneofWrappers = []interface{}{
		(*SearchTextRequest_LocationBias_Rectangle)(nil),
		(*SearchTextRequest_LocationBias_Circle)(nil),
	}
	file_google_maps_places_v1_places_service_proto_msgTypes[9].OneofWrappers = []interface{}{
		(*SearchTextRequest_LocationRestriction_Rectangle)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_maps_places_v1_places_service_proto_rawDesc,
			NumEnums:      2,
			NumMessages:   10,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_maps_places_v1_places_service_proto_goTypes,
		DependencyIndexes: file_google_maps_places_v1_places_service_proto_depIdxs,
		EnumInfos:         file_google_maps_places_v1_places_service_proto_enumTypes,
		MessageInfos:      file_google_maps_places_v1_places_service_proto_msgTypes,
	}.Build()
	File_google_maps_places_v1_places_service_proto = out.File
	file_google_maps_places_v1_places_service_proto_rawDesc = nil
	file_google_maps_places_v1_places_service_proto_goTypes = nil
	file_google_maps_places_v1_places_service_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// PlacesClient is the client API for Places service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type PlacesClient interface {
	// Search for places near locations.
	SearchNearby(ctx context.Context, in *SearchNearbyRequest, opts ...grpc.CallOption) (*SearchNearbyResponse, error)
	// Text query based place search.
	SearchText(ctx context.Context, in *SearchTextRequest, opts ...grpc.CallOption) (*SearchTextResponse, error)
	// Get a photo media with a photo reference string.
	GetPhotoMedia(ctx context.Context, in *GetPhotoMediaRequest, opts ...grpc.CallOption) (*PhotoMedia, error)
	// Get place details with a place id (in a name) string.
	GetPlace(ctx context.Context, in *GetPlaceRequest, opts ...grpc.CallOption) (*Place, error)
}

type placesClient struct {
	cc grpc.ClientConnInterface
}

func NewPlacesClient(cc grpc.ClientConnInterface) PlacesClient {
	return &placesClient{cc}
}

func (c *placesClient) SearchNearby(ctx context.Context, in *SearchNearbyRequest, opts ...grpc.CallOption) (*SearchNearbyResponse, error) {
	out := new(SearchNearbyResponse)
	err := c.cc.Invoke(ctx, "/google.maps.places.v1.Places/SearchNearby", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *placesClient) SearchText(ctx context.Context, in *SearchTextRequest, opts ...grpc.CallOption) (*SearchTextResponse, error) {
	out := new(SearchTextResponse)
	err := c.cc.Invoke(ctx, "/google.maps.places.v1.Places/SearchText", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *placesClient) GetPhotoMedia(ctx context.Context, in *GetPhotoMediaRequest, opts ...grpc.CallOption) (*PhotoMedia, error) {
	out := new(PhotoMedia)
	err := c.cc.Invoke(ctx, "/google.maps.places.v1.Places/GetPhotoMedia", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *placesClient) GetPlace(ctx context.Context, in *GetPlaceRequest, opts ...grpc.CallOption) (*Place, error) {
	out := new(Place)
	err := c.cc.Invoke(ctx, "/google.maps.places.v1.Places/GetPlace", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// PlacesServer is the server API for Places service.
type PlacesServer interface {
	// Search for places near locations.
	SearchNearby(context.Context, *SearchNearbyRequest) (*SearchNearbyResponse, error)
	// Text query based place search.
	SearchText(context.Context, *SearchTextRequest) (*SearchTextResponse, error)
	// Get a photo media with a photo reference string.
	GetPhotoMedia(context.Context, *GetPhotoMediaRequest) (*PhotoMedia, error)
	// Get place details with a place id (in a name) string.
	GetPlace(context.Context, *GetPlaceRequest) (*Place, error)
}

// UnimplementedPlacesServer can be embedded to have forward compatible implementations.
type UnimplementedPlacesServer struct {
}

func (*UnimplementedPlacesServer) SearchNearby(context.Context, *SearchNearbyRequest) (*SearchNearbyResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SearchNearby not implemented")
}
func (*UnimplementedPlacesServer) SearchText(context.Context, *SearchTextRequest) (*SearchTextResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SearchText not implemented")
}
func (*UnimplementedPlacesServer) GetPhotoMedia(context.Context, *GetPhotoMediaRequest) (*PhotoMedia, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetPhotoMedia not implemented")
}
func (*UnimplementedPlacesServer) GetPlace(context.Context, *GetPlaceRequest) (*Place, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetPlace not implemented")
}

func RegisterPlacesServer(s *grpc.Server, srv PlacesServer) {
	s.RegisterService(&_Places_serviceDesc, srv)
}

func _Places_SearchNearby_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SearchNearbyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PlacesServer).SearchNearby(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.maps.places.v1.Places/SearchNearby",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PlacesServer).SearchNearby(ctx, req.(*SearchNearbyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Places_SearchText_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SearchTextRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PlacesServer).SearchText(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.maps.places.v1.Places/SearchText",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PlacesServer).SearchText(ctx, req.(*SearchTextRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Places_GetPhotoMedia_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetPhotoMediaRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PlacesServer).GetPhotoMedia(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.maps.places.v1.Places/GetPhotoMedia",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PlacesServer).GetPhotoMedia(ctx, req.(*GetPhotoMediaRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Places_GetPlace_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetPlaceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PlacesServer).GetPlace(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.maps.places.v1.Places/GetPlace",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PlacesServer).GetPlace(ctx, req.(*GetPlaceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _Places_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.maps.places.v1.Places",
	HandlerType: (*PlacesServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "SearchNearby",
			Handler:    _Places_SearchNearby_Handler,
		},
		{
			MethodName: "SearchText",
			Handler:    _Places_SearchText_Handler,
		},
		{
			MethodName: "GetPhotoMedia",
			Handler:    _Places_GetPhotoMedia_Handler,
		},
		{
			MethodName: "GetPlace",
			Handler:    _Places_GetPlace_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/maps/places/v1/places_service.proto",
}
