// Copyright 2021 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.32.0
// 	protoc        v4.23.2
// source: google/cloud/osconfig/v1/os_policy_assignments.proto

package osconfigpb

import (
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	durationpb "google.golang.org/protobuf/types/known/durationpb"
	fieldmaskpb "google.golang.org/protobuf/types/known/fieldmaskpb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// OS policy assignment rollout state
type OSPolicyAssignment_RolloutState int32

const (
	// Invalid value
	OSPolicyAssignment_ROLLOUT_STATE_UNSPECIFIED OSPolicyAssignment_RolloutState = 0
	// The rollout is in progress.
	OSPolicyAssignment_IN_PROGRESS OSPolicyAssignment_RolloutState = 1
	// The rollout is being cancelled.
	OSPolicyAssignment_CANCELLING OSPolicyAssignment_RolloutState = 2
	// The rollout is cancelled.
	OSPolicyAssignment_CANCELLED OSPolicyAssignment_RolloutState = 3
	// The rollout has completed successfully.
	OSPolicyAssignment_SUCCEEDED OSPolicyAssignment_RolloutState = 4
)

// Enum value maps for OSPolicyAssignment_RolloutState.
var (
	OSPolicyAssignment_RolloutState_name = map[int32]string{
		0: "ROLLOUT_STATE_UNSPECIFIED",
		1: "IN_PROGRESS",
		2: "CANCELLING",
		3: "CANCELLED",
		4: "SUCCEEDED",
	}
	OSPolicyAssignment_RolloutState_value = map[string]int32{
		"ROLLOUT_STATE_UNSPECIFIED": 0,
		"IN_PROGRESS":               1,
		"CANCELLING":                2,
		"CANCELLED":                 3,
		"SUCCEEDED":                 4,
	}
)

func (x OSPolicyAssignment_RolloutState) Enum() *OSPolicyAssignment_RolloutState {
	p := new(OSPolicyAssignment_RolloutState)
	*p = x
	return p
}

func (x OSPolicyAssignment_RolloutState) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (OSPolicyAssignment_RolloutState) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_osconfig_v1_os_policy_assignments_proto_enumTypes[0].Descriptor()
}

func (OSPolicyAssignment_RolloutState) Type() protoreflect.EnumType {
	return &file_google_cloud_osconfig_v1_os_policy_assignments_proto_enumTypes[0]
}

func (x OSPolicyAssignment_RolloutState) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use OSPolicyAssignment_RolloutState.Descriptor instead.
func (OSPolicyAssignment_RolloutState) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_osconfig_v1_os_policy_assignments_proto_rawDescGZIP(), []int{0, 0}
}

// The OS policy assignment API method.
type OSPolicyAssignmentOperationMetadata_APIMethod int32

const (
	// Invalid value
	OSPolicyAssignmentOperationMetadata_API_METHOD_UNSPECIFIED OSPolicyAssignmentOperationMetadata_APIMethod = 0
	// Create OS policy assignment API method
	OSPolicyAssignmentOperationMetadata_CREATE OSPolicyAssignmentOperationMetadata_APIMethod = 1
	// Update OS policy assignment API method
	OSPolicyAssignmentOperationMetadata_UPDATE OSPolicyAssignmentOperationMetadata_APIMethod = 2
	// Delete OS policy assignment API method
	OSPolicyAssignmentOperationMetadata_DELETE OSPolicyAssignmentOperationMetadata_APIMethod = 3
)

// Enum value maps for OSPolicyAssignmentOperationMetadata_APIMethod.
var (
	OSPolicyAssignmentOperationMetadata_APIMethod_name = map[int32]string{
		0: "API_METHOD_UNSPECIFIED",
		1: "CREATE",
		2: "UPDATE",
		3: "DELETE",
	}
	OSPolicyAssignmentOperationMetadata_APIMethod_value = map[string]int32{
		"API_METHOD_UNSPECIFIED": 0,
		"CREATE":                 1,
		"UPDATE":                 2,
		"DELETE":                 3,
	}
)

func (x OSPolicyAssignmentOperationMetadata_APIMethod) Enum() *OSPolicyAssignmentOperationMetadata_APIMethod {
	p := new(OSPolicyAssignmentOperationMetadata_APIMethod)
	*p = x
	return p
}

func (x OSPolicyAssignmentOperationMetadata_APIMethod) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (OSPolicyAssignmentOperationMetadata_APIMethod) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_osconfig_v1_os_policy_assignments_proto_enumTypes[1].Descriptor()
}

func (OSPolicyAssignmentOperationMetadata_APIMethod) Type() protoreflect.EnumType {
	return &file_google_cloud_osconfig_v1_os_policy_assignments_proto_enumTypes[1]
}

func (x OSPolicyAssignmentOperationMetadata_APIMethod) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use OSPolicyAssignmentOperationMetadata_APIMethod.Descriptor instead.
func (OSPolicyAssignmentOperationMetadata_APIMethod) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_osconfig_v1_os_policy_assignments_proto_rawDescGZIP(), []int{1, 0}
}

// State of the rollout
type OSPolicyAssignmentOperationMetadata_RolloutState int32

const (
	// Invalid value
	OSPolicyAssignmentOperationMetadata_ROLLOUT_STATE_UNSPECIFIED OSPolicyAssignmentOperationMetadata_RolloutState = 0
	// The rollout is in progress.
	OSPolicyAssignmentOperationMetadata_IN_PROGRESS OSPolicyAssignmentOperationMetadata_RolloutState = 1
	// The rollout is being cancelled.
	OSPolicyAssignmentOperationMetadata_CANCELLING OSPolicyAssignmentOperationMetadata_RolloutState = 2
	// The rollout is cancelled.
	OSPolicyAssignmentOperationMetadata_CANCELLED OSPolicyAssignmentOperationMetadata_RolloutState = 3
	// The rollout has completed successfully.
	OSPolicyAssignmentOperationMetadata_SUCCEEDED OSPolicyAssignmentOperationMetadata_RolloutState = 4
)

// Enum value maps for OSPolicyAssignmentOperationMetadata_RolloutState.
var (
	OSPolicyAssignmentOperationMetadata_RolloutState_name = map[int32]string{
		0: "ROLLOUT_STATE_UNSPECIFIED",
		1: "IN_PROGRESS",
		2: "CANCELLING",
		3: "CANCELLED",
		4: "SUCCEEDED",
	}
	OSPolicyAssignmentOperationMetadata_RolloutState_value = map[string]int32{
		"ROLLOUT_STATE_UNSPECIFIED": 0,
		"IN_PROGRESS":               1,
		"CANCELLING":                2,
		"CANCELLED":                 3,
		"SUCCEEDED":                 4,
	}
)

func (x OSPolicyAssignmentOperationMetadata_RolloutState) Enum() *OSPolicyAssignmentOperationMetadata_RolloutState {
	p := new(OSPolicyAssignmentOperationMetadata_RolloutState)
	*p = x
	return p
}

func (x OSPolicyAssignmentOperationMetadata_RolloutState) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (OSPolicyAssignmentOperationMetadata_RolloutState) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_osconfig_v1_os_policy_assignments_proto_enumTypes[2].Descriptor()
}

func (OSPolicyAssignmentOperationMetadata_RolloutState) Type() protoreflect.EnumType {
	return &file_google_cloud_osconfig_v1_os_policy_assignments_proto_enumTypes[2]
}

func (x OSPolicyAssignmentOperationMetadata_RolloutState) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use OSPolicyAssignmentOperationMetadata_RolloutState.Descriptor instead.
func (OSPolicyAssignmentOperationMetadata_RolloutState) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_osconfig_v1_os_policy_assignments_proto_rawDescGZIP(), []int{1, 1}
}

// OS policy assignment is an API resource that is used to
// apply a set of OS policies to a dynamically targeted group of Compute Engine
// VM instances.
//
// An OS policy is used to define the desired state configuration for a
// Compute Engine VM instance through a set of configuration resources that
// provide capabilities such as installing or removing software packages, or
// executing a script.
//
// For more information, see [OS policy and OS policy
// assignment](https://cloud.google.com/compute/docs/os-configuration-management/working-with-os-policies).
type OSPolicyAssignment struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Resource name.
	//
	// Format:
	// `projects/{project_number}/locations/{location}/osPolicyAssignments/{os_policy_assignment_id}`
	//
	// This field is ignored when you create an OS policy assignment.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// OS policy assignment description.
	// Length of the description is limited to 1024 characters.
	Description string `protobuf:"bytes,2,opt,name=description,proto3" json:"description,omitempty"`
	// Required. List of OS policies to be applied to the VMs.
	OsPolicies []*OSPolicy `protobuf:"bytes,3,rep,name=os_policies,json=osPolicies,proto3" json:"os_policies,omitempty"`
	// Required. Filter to select VMs.
	InstanceFilter *OSPolicyAssignment_InstanceFilter `protobuf:"bytes,4,opt,name=instance_filter,json=instanceFilter,proto3" json:"instance_filter,omitempty"`
	// Required. Rollout to deploy the OS policy assignment.
	// A rollout is triggered in the following situations:
	// 1) OSPolicyAssignment is created.
	// 2) OSPolicyAssignment is updated and the update contains changes to one of
	// the following fields:
	//   - instance_filter
	//   - os_policies
	//
	// 3) OSPolicyAssignment is deleted.
	Rollout *OSPolicyAssignment_Rollout `protobuf:"bytes,5,opt,name=rollout,proto3" json:"rollout,omitempty"`
	// Output only. The assignment revision ID
	// A new revision is committed whenever a rollout is triggered for a OS policy
	// assignment
	RevisionId string `protobuf:"bytes,6,opt,name=revision_id,json=revisionId,proto3" json:"revision_id,omitempty"`
	// Output only. The timestamp that the revision was created.
	RevisionCreateTime *timestamppb.Timestamp `protobuf:"bytes,7,opt,name=revision_create_time,json=revisionCreateTime,proto3" json:"revision_create_time,omitempty"`
	// The etag for this OS policy assignment.
	// If this is provided on update, it must match the server's etag.
	Etag string `protobuf:"bytes,8,opt,name=etag,proto3" json:"etag,omitempty"`
	// Output only. OS policy assignment rollout state
	RolloutState OSPolicyAssignment_RolloutState `protobuf:"varint,9,opt,name=rollout_state,json=rolloutState,proto3,enum=google.cloud.osconfig.v1.OSPolicyAssignment_RolloutState" json:"rollout_state,omitempty"`
	// Output only. Indicates that this revision has been successfully rolled out
	// in this zone and new VMs will be assigned OS policies from this revision.
	//
	// For a given OS policy assignment, there is only one revision with a value
	// of `true` for this field.
	Baseline bool `protobuf:"varint,10,opt,name=baseline,proto3" json:"baseline,omitempty"`
	// Output only. Indicates that this revision deletes the OS policy assignment.
	Deleted bool `protobuf:"varint,11,opt,name=deleted,proto3" json:"deleted,omitempty"`
	// Output only. Indicates that reconciliation is in progress for the revision.
	// This value is `true` when the `rollout_state` is one of:
	// * IN_PROGRESS
	// * CANCELLING
	Reconciling bool `protobuf:"varint,12,opt,name=reconciling,proto3" json:"reconciling,omitempty"`
	// Output only. Server generated unique id for the OS policy assignment
	// resource.
	Uid string `protobuf:"bytes,13,opt,name=uid,proto3" json:"uid,omitempty"`
}

func (x *OSPolicyAssignment) Reset() {
	*x = OSPolicyAssignment{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_osconfig_v1_os_policy_assignments_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *OSPolicyAssignment) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OSPolicyAssignment) ProtoMessage() {}

func (x *OSPolicyAssignment) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_osconfig_v1_os_policy_assignments_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OSPolicyAssignment.ProtoReflect.Descriptor instead.
func (*OSPolicyAssignment) Descriptor() ([]byte, []int) {
	return file_google_cloud_osconfig_v1_os_policy_assignments_proto_rawDescGZIP(), []int{0}
}

func (x *OSPolicyAssignment) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *OSPolicyAssignment) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *OSPolicyAssignment) GetOsPolicies() []*OSPolicy {
	if x != nil {
		return x.OsPolicies
	}
	return nil
}

func (x *OSPolicyAssignment) GetInstanceFilter() *OSPolicyAssignment_InstanceFilter {
	if x != nil {
		return x.InstanceFilter
	}
	return nil
}

func (x *OSPolicyAssignment) GetRollout() *OSPolicyAssignment_Rollout {
	if x != nil {
		return x.Rollout
	}
	return nil
}

func (x *OSPolicyAssignment) GetRevisionId() string {
	if x != nil {
		return x.RevisionId
	}
	return ""
}

func (x *OSPolicyAssignment) GetRevisionCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.RevisionCreateTime
	}
	return nil
}

func (x *OSPolicyAssignment) GetEtag() string {
	if x != nil {
		return x.Etag
	}
	return ""
}

func (x *OSPolicyAssignment) GetRolloutState() OSPolicyAssignment_RolloutState {
	if x != nil {
		return x.RolloutState
	}
	return OSPolicyAssignment_ROLLOUT_STATE_UNSPECIFIED
}

func (x *OSPolicyAssignment) GetBaseline() bool {
	if x != nil {
		return x.Baseline
	}
	return false
}

func (x *OSPolicyAssignment) GetDeleted() bool {
	if x != nil {
		return x.Deleted
	}
	return false
}

func (x *OSPolicyAssignment) GetReconciling() bool {
	if x != nil {
		return x.Reconciling
	}
	return false
}

func (x *OSPolicyAssignment) GetUid() string {
	if x != nil {
		return x.Uid
	}
	return ""
}

// OS policy assignment operation metadata provided by OS policy assignment API
// methods that return long running operations.
type OSPolicyAssignmentOperationMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Reference to the `OSPolicyAssignment` API resource.
	//
	// Format:
	// `projects/{project_number}/locations/{location}/osPolicyAssignments/{os_policy_assignment_id@revision_id}`
	OsPolicyAssignment string `protobuf:"bytes,1,opt,name=os_policy_assignment,json=osPolicyAssignment,proto3" json:"os_policy_assignment,omitempty"`
	// The OS policy assignment API method.
	ApiMethod OSPolicyAssignmentOperationMetadata_APIMethod `protobuf:"varint,2,opt,name=api_method,json=apiMethod,proto3,enum=google.cloud.osconfig.v1.OSPolicyAssignmentOperationMetadata_APIMethod" json:"api_method,omitempty"`
	// State of the rollout
	RolloutState OSPolicyAssignmentOperationMetadata_RolloutState `protobuf:"varint,3,opt,name=rollout_state,json=rolloutState,proto3,enum=google.cloud.osconfig.v1.OSPolicyAssignmentOperationMetadata_RolloutState" json:"rollout_state,omitempty"`
	// Rollout start time
	RolloutStartTime *timestamppb.Timestamp `protobuf:"bytes,4,opt,name=rollout_start_time,json=rolloutStartTime,proto3" json:"rollout_start_time,omitempty"`
	// Rollout update time
	RolloutUpdateTime *timestamppb.Timestamp `protobuf:"bytes,5,opt,name=rollout_update_time,json=rolloutUpdateTime,proto3" json:"rollout_update_time,omitempty"`
}

func (x *OSPolicyAssignmentOperationMetadata) Reset() {
	*x = OSPolicyAssignmentOperationMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_osconfig_v1_os_policy_assignments_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *OSPolicyAssignmentOperationMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OSPolicyAssignmentOperationMetadata) ProtoMessage() {}

func (x *OSPolicyAssignmentOperationMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_osconfig_v1_os_policy_assignments_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OSPolicyAssignmentOperationMetadata.ProtoReflect.Descriptor instead.
func (*OSPolicyAssignmentOperationMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_osconfig_v1_os_policy_assignments_proto_rawDescGZIP(), []int{1}
}

func (x *OSPolicyAssignmentOperationMetadata) GetOsPolicyAssignment() string {
	if x != nil {
		return x.OsPolicyAssignment
	}
	return ""
}

func (x *OSPolicyAssignmentOperationMetadata) GetApiMethod() OSPolicyAssignmentOperationMetadata_APIMethod {
	if x != nil {
		return x.ApiMethod
	}
	return OSPolicyAssignmentOperationMetadata_API_METHOD_UNSPECIFIED
}

func (x *OSPolicyAssignmentOperationMetadata) GetRolloutState() OSPolicyAssignmentOperationMetadata_RolloutState {
	if x != nil {
		return x.RolloutState
	}
	return OSPolicyAssignmentOperationMetadata_ROLLOUT_STATE_UNSPECIFIED
}

func (x *OSPolicyAssignmentOperationMetadata) GetRolloutStartTime() *timestamppb.Timestamp {
	if x != nil {
		return x.RolloutStartTime
	}
	return nil
}

func (x *OSPolicyAssignmentOperationMetadata) GetRolloutUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.RolloutUpdateTime
	}
	return nil
}

// A request message to create an OS policy assignment
type CreateOSPolicyAssignmentRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent resource name in the form:
	// projects/{project}/locations/{location}
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The OS policy assignment to be created.
	OsPolicyAssignment *OSPolicyAssignment `protobuf:"bytes,2,opt,name=os_policy_assignment,json=osPolicyAssignment,proto3" json:"os_policy_assignment,omitempty"`
	// Required. The logical name of the OS policy assignment in the project
	// with the following restrictions:
	//
	// * Must contain only lowercase letters, numbers, and hyphens.
	// * Must start with a letter.
	// * Must be between 1-63 characters.
	// * Must end with a number or a letter.
	// * Must be unique within the project.
	OsPolicyAssignmentId string `protobuf:"bytes,3,opt,name=os_policy_assignment_id,json=osPolicyAssignmentId,proto3" json:"os_policy_assignment_id,omitempty"`
}

func (x *CreateOSPolicyAssignmentRequest) Reset() {
	*x = CreateOSPolicyAssignmentRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_osconfig_v1_os_policy_assignments_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateOSPolicyAssignmentRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateOSPolicyAssignmentRequest) ProtoMessage() {}

func (x *CreateOSPolicyAssignmentRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_osconfig_v1_os_policy_assignments_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateOSPolicyAssignmentRequest.ProtoReflect.Descriptor instead.
func (*CreateOSPolicyAssignmentRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_osconfig_v1_os_policy_assignments_proto_rawDescGZIP(), []int{2}
}

func (x *CreateOSPolicyAssignmentRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateOSPolicyAssignmentRequest) GetOsPolicyAssignment() *OSPolicyAssignment {
	if x != nil {
		return x.OsPolicyAssignment
	}
	return nil
}

func (x *CreateOSPolicyAssignmentRequest) GetOsPolicyAssignmentId() string {
	if x != nil {
		return x.OsPolicyAssignmentId
	}
	return ""
}

// A request message to update an OS policy assignment
type UpdateOSPolicyAssignmentRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The updated OS policy assignment.
	OsPolicyAssignment *OSPolicyAssignment `protobuf:"bytes,1,opt,name=os_policy_assignment,json=osPolicyAssignment,proto3" json:"os_policy_assignment,omitempty"`
	// Optional. Field mask that controls which fields of the assignment should be
	// updated.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateOSPolicyAssignmentRequest) Reset() {
	*x = UpdateOSPolicyAssignmentRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_osconfig_v1_os_policy_assignments_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateOSPolicyAssignmentRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateOSPolicyAssignmentRequest) ProtoMessage() {}

func (x *UpdateOSPolicyAssignmentRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_osconfig_v1_os_policy_assignments_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateOSPolicyAssignmentRequest.ProtoReflect.Descriptor instead.
func (*UpdateOSPolicyAssignmentRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_osconfig_v1_os_policy_assignments_proto_rawDescGZIP(), []int{3}
}

func (x *UpdateOSPolicyAssignmentRequest) GetOsPolicyAssignment() *OSPolicyAssignment {
	if x != nil {
		return x.OsPolicyAssignment
	}
	return nil
}

func (x *UpdateOSPolicyAssignmentRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// A request message to get an OS policy assignment
type GetOSPolicyAssignmentRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of OS policy assignment.
	//
	// Format:
	// `projects/{project}/locations/{location}/osPolicyAssignments/{os_policy_assignment}@{revisionId}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetOSPolicyAssignmentRequest) Reset() {
	*x = GetOSPolicyAssignmentRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_osconfig_v1_os_policy_assignments_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetOSPolicyAssignmentRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetOSPolicyAssignmentRequest) ProtoMessage() {}

func (x *GetOSPolicyAssignmentRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_osconfig_v1_os_policy_assignments_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetOSPolicyAssignmentRequest.ProtoReflect.Descriptor instead.
func (*GetOSPolicyAssignmentRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_osconfig_v1_os_policy_assignments_proto_rawDescGZIP(), []int{4}
}

func (x *GetOSPolicyAssignmentRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// A request message to list OS policy assignments for a parent resource
type ListOSPolicyAssignmentsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent resource name.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The maximum number of assignments to return.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// A pagination token returned from a previous call to
	// `ListOSPolicyAssignments` that indicates where this listing should continue
	// from.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListOSPolicyAssignmentsRequest) Reset() {
	*x = ListOSPolicyAssignmentsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_osconfig_v1_os_policy_assignments_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListOSPolicyAssignmentsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListOSPolicyAssignmentsRequest) ProtoMessage() {}

func (x *ListOSPolicyAssignmentsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_osconfig_v1_os_policy_assignments_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListOSPolicyAssignmentsRequest.ProtoReflect.Descriptor instead.
func (*ListOSPolicyAssignmentsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_osconfig_v1_os_policy_assignments_proto_rawDescGZIP(), []int{5}
}

func (x *ListOSPolicyAssignmentsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListOSPolicyAssignmentsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListOSPolicyAssignmentsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// A response message for listing all assignments under given parent.
type ListOSPolicyAssignmentsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of assignments
	OsPolicyAssignments []*OSPolicyAssignment `protobuf:"bytes,1,rep,name=os_policy_assignments,json=osPolicyAssignments,proto3" json:"os_policy_assignments,omitempty"`
	// The pagination token to retrieve the next page of OS policy assignments.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListOSPolicyAssignmentsResponse) Reset() {
	*x = ListOSPolicyAssignmentsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_osconfig_v1_os_policy_assignments_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListOSPolicyAssignmentsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListOSPolicyAssignmentsResponse) ProtoMessage() {}

func (x *ListOSPolicyAssignmentsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_osconfig_v1_os_policy_assignments_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListOSPolicyAssignmentsResponse.ProtoReflect.Descriptor instead.
func (*ListOSPolicyAssignmentsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_osconfig_v1_os_policy_assignments_proto_rawDescGZIP(), []int{6}
}

func (x *ListOSPolicyAssignmentsResponse) GetOsPolicyAssignments() []*OSPolicyAssignment {
	if x != nil {
		return x.OsPolicyAssignments
	}
	return nil
}

func (x *ListOSPolicyAssignmentsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// A request message to list revisions for a OS policy assignment
type ListOSPolicyAssignmentRevisionsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the OS policy assignment to list revisions for.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The maximum number of revisions to return.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// A pagination token returned from a previous call to
	// `ListOSPolicyAssignmentRevisions` that indicates where this listing should
	// continue from.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListOSPolicyAssignmentRevisionsRequest) Reset() {
	*x = ListOSPolicyAssignmentRevisionsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_osconfig_v1_os_policy_assignments_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListOSPolicyAssignmentRevisionsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListOSPolicyAssignmentRevisionsRequest) ProtoMessage() {}

func (x *ListOSPolicyAssignmentRevisionsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_osconfig_v1_os_policy_assignments_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListOSPolicyAssignmentRevisionsRequest.ProtoReflect.Descriptor instead.
func (*ListOSPolicyAssignmentRevisionsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_osconfig_v1_os_policy_assignments_proto_rawDescGZIP(), []int{7}
}

func (x *ListOSPolicyAssignmentRevisionsRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *ListOSPolicyAssignmentRevisionsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListOSPolicyAssignmentRevisionsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// A response message for listing all revisions for a OS policy assignment.
type ListOSPolicyAssignmentRevisionsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The OS policy assignment revisions
	OsPolicyAssignments []*OSPolicyAssignment `protobuf:"bytes,1,rep,name=os_policy_assignments,json=osPolicyAssignments,proto3" json:"os_policy_assignments,omitempty"`
	// The pagination token to retrieve the next page of OS policy assignment
	// revisions.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListOSPolicyAssignmentRevisionsResponse) Reset() {
	*x = ListOSPolicyAssignmentRevisionsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_osconfig_v1_os_policy_assignments_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListOSPolicyAssignmentRevisionsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListOSPolicyAssignmentRevisionsResponse) ProtoMessage() {}

func (x *ListOSPolicyAssignmentRevisionsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_osconfig_v1_os_policy_assignments_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListOSPolicyAssignmentRevisionsResponse.ProtoReflect.Descriptor instead.
func (*ListOSPolicyAssignmentRevisionsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_osconfig_v1_os_policy_assignments_proto_rawDescGZIP(), []int{8}
}

func (x *ListOSPolicyAssignmentRevisionsResponse) GetOsPolicyAssignments() []*OSPolicyAssignment {
	if x != nil {
		return x.OsPolicyAssignments
	}
	return nil
}

func (x *ListOSPolicyAssignmentRevisionsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// A request message for deleting a OS policy assignment.
type DeleteOSPolicyAssignmentRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the OS policy assignment to be deleted
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteOSPolicyAssignmentRequest) Reset() {
	*x = DeleteOSPolicyAssignmentRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_osconfig_v1_os_policy_assignments_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteOSPolicyAssignmentRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteOSPolicyAssignmentRequest) ProtoMessage() {}

func (x *DeleteOSPolicyAssignmentRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_osconfig_v1_os_policy_assignments_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteOSPolicyAssignmentRequest.ProtoReflect.Descriptor instead.
func (*DeleteOSPolicyAssignmentRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_osconfig_v1_os_policy_assignments_proto_rawDescGZIP(), []int{9}
}

func (x *DeleteOSPolicyAssignmentRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Message representing label set.
//   - A label is a key value pair set for a VM.
//   - A LabelSet is a set of labels.
//   - Labels within a LabelSet are ANDed. In other words, a LabelSet is
//     applicable for a VM only if it matches all the labels in the
//     LabelSet.
//   - Example: A LabelSet with 2 labels: `env=prod` and `type=webserver` will
//     only be applicable for those VMs with both labels
//     present.
type OSPolicyAssignment_LabelSet struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Labels are identified by key/value pairs in this map.
	// A VM should contain all the key/value pairs specified in this
	// map to be selected.
	Labels map[string]string `protobuf:"bytes,1,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (x *OSPolicyAssignment_LabelSet) Reset() {
	*x = OSPolicyAssignment_LabelSet{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_osconfig_v1_os_policy_assignments_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *OSPolicyAssignment_LabelSet) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OSPolicyAssignment_LabelSet) ProtoMessage() {}

func (x *OSPolicyAssignment_LabelSet) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_osconfig_v1_os_policy_assignments_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OSPolicyAssignment_LabelSet.ProtoReflect.Descriptor instead.
func (*OSPolicyAssignment_LabelSet) Descriptor() ([]byte, []int) {
	return file_google_cloud_osconfig_v1_os_policy_assignments_proto_rawDescGZIP(), []int{0, 0}
}

func (x *OSPolicyAssignment_LabelSet) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

// Filters to select target VMs for an assignment.
//
// If more than one filter criteria is specified below, a VM will be selected
// if and only if it satisfies all of them.
type OSPolicyAssignment_InstanceFilter struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Target all VMs in the project. If true, no other criteria is
	// permitted.
	All bool `protobuf:"varint,1,opt,name=all,proto3" json:"all,omitempty"`
	// List of label sets used for VM inclusion.
	//
	// If the list has more than one `LabelSet`, the VM is included if any
	// of the label sets are applicable for the VM.
	InclusionLabels []*OSPolicyAssignment_LabelSet `protobuf:"bytes,2,rep,name=inclusion_labels,json=inclusionLabels,proto3" json:"inclusion_labels,omitempty"`
	// List of label sets used for VM exclusion.
	//
	// If the list has more than one label set, the VM is excluded if any
	// of the label sets are applicable for the VM.
	ExclusionLabels []*OSPolicyAssignment_LabelSet `protobuf:"bytes,3,rep,name=exclusion_labels,json=exclusionLabels,proto3" json:"exclusion_labels,omitempty"`
	// List of inventories to select VMs.
	//
	// A VM is selected if its inventory data matches at least one of the
	// following inventories.
	Inventories []*OSPolicyAssignment_InstanceFilter_Inventory `protobuf:"bytes,4,rep,name=inventories,proto3" json:"inventories,omitempty"`
}

func (x *OSPolicyAssignment_InstanceFilter) Reset() {
	*x = OSPolicyAssignment_InstanceFilter{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_osconfig_v1_os_policy_assignments_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *OSPolicyAssignment_InstanceFilter) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OSPolicyAssignment_InstanceFilter) ProtoMessage() {}

func (x *OSPolicyAssignment_InstanceFilter) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_osconfig_v1_os_policy_assignments_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OSPolicyAssignment_InstanceFilter.ProtoReflect.Descriptor instead.
func (*OSPolicyAssignment_InstanceFilter) Descriptor() ([]byte, []int) {
	return file_google_cloud_osconfig_v1_os_policy_assignments_proto_rawDescGZIP(), []int{0, 1}
}

func (x *OSPolicyAssignment_InstanceFilter) GetAll() bool {
	if x != nil {
		return x.All
	}
	return false
}

func (x *OSPolicyAssignment_InstanceFilter) GetInclusionLabels() []*OSPolicyAssignment_LabelSet {
	if x != nil {
		return x.InclusionLabels
	}
	return nil
}

func (x *OSPolicyAssignment_InstanceFilter) GetExclusionLabels() []*OSPolicyAssignment_LabelSet {
	if x != nil {
		return x.ExclusionLabels
	}
	return nil
}

func (x *OSPolicyAssignment_InstanceFilter) GetInventories() []*OSPolicyAssignment_InstanceFilter_Inventory {
	if x != nil {
		return x.Inventories
	}
	return nil
}

// Message to configure the rollout at the zonal level for the OS policy
// assignment.
type OSPolicyAssignment_Rollout struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The maximum number (or percentage) of VMs per zone to disrupt
	// at any given moment.
	DisruptionBudget *FixedOrPercent `protobuf:"bytes,1,opt,name=disruption_budget,json=disruptionBudget,proto3" json:"disruption_budget,omitempty"`
	// Required. This determines the minimum duration of time to wait after the
	// configuration changes are applied through the current rollout. A
	// VM continues to count towards the `disruption_budget` at least
	// until this duration of time has passed after configuration changes are
	// applied.
	MinWaitDuration *durationpb.Duration `protobuf:"bytes,2,opt,name=min_wait_duration,json=minWaitDuration,proto3" json:"min_wait_duration,omitempty"`
}

func (x *OSPolicyAssignment_Rollout) Reset() {
	*x = OSPolicyAssignment_Rollout{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_osconfig_v1_os_policy_assignments_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *OSPolicyAssignment_Rollout) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OSPolicyAssignment_Rollout) ProtoMessage() {}

func (x *OSPolicyAssignment_Rollout) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_osconfig_v1_os_policy_assignments_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OSPolicyAssignment_Rollout.ProtoReflect.Descriptor instead.
func (*OSPolicyAssignment_Rollout) Descriptor() ([]byte, []int) {
	return file_google_cloud_osconfig_v1_os_policy_assignments_proto_rawDescGZIP(), []int{0, 2}
}

func (x *OSPolicyAssignment_Rollout) GetDisruptionBudget() *FixedOrPercent {
	if x != nil {
		return x.DisruptionBudget
	}
	return nil
}

func (x *OSPolicyAssignment_Rollout) GetMinWaitDuration() *durationpb.Duration {
	if x != nil {
		return x.MinWaitDuration
	}
	return nil
}

// VM inventory details.
type OSPolicyAssignment_InstanceFilter_Inventory struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The OS short name
	OsShortName string `protobuf:"bytes,1,opt,name=os_short_name,json=osShortName,proto3" json:"os_short_name,omitempty"`
	// The OS version
	//
	// Prefix matches are supported if asterisk(*) is provided as the
	// last character. For example, to match all versions with a major
	// version of `7`, specify the following value for this field `7.*`
	//
	// An empty string matches all OS versions.
	OsVersion string `protobuf:"bytes,2,opt,name=os_version,json=osVersion,proto3" json:"os_version,omitempty"`
}

func (x *OSPolicyAssignment_InstanceFilter_Inventory) Reset() {
	*x = OSPolicyAssignment_InstanceFilter_Inventory{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_osconfig_v1_os_policy_assignments_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *OSPolicyAssignment_InstanceFilter_Inventory) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OSPolicyAssignment_InstanceFilter_Inventory) ProtoMessage() {}

func (x *OSPolicyAssignment_InstanceFilter_Inventory) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_osconfig_v1_os_policy_assignments_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OSPolicyAssignment_InstanceFilter_Inventory.ProtoReflect.Descriptor instead.
func (*OSPolicyAssignment_InstanceFilter_Inventory) Descriptor() ([]byte, []int) {
	return file_google_cloud_osconfig_v1_os_policy_assignments_proto_rawDescGZIP(), []int{0, 1, 0}
}

func (x *OSPolicyAssignment_InstanceFilter_Inventory) GetOsShortName() string {
	if x != nil {
		return x.OsShortName
	}
	return ""
}

func (x *OSPolicyAssignment_InstanceFilter_Inventory) GetOsVersion() string {
	if x != nil {
		return x.OsVersion
	}
	return ""
}

var File_google_cloud_osconfig_v1_os_policy_assignments_proto protoreflect.FileDescriptor

var file_google_cloud_osconfig_v1_os_policy_assignments_proto_rawDesc = []byte{
	0x0a, 0x34, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x6f,
	0x73, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2f, 0x76, 0x31, 0x2f, 0x6f, 0x73, 0x5f, 0x70, 0x6f,
	0x6c, 0x69, 0x63, 0x79, 0x5f, 0x61, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x73,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x18, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x73, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x76, 0x31,
	0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65,
	0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x28, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x6f, 0x73, 0x63, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x2f, 0x76, 0x31, 0x2f, 0x6f, 0x73, 0x5f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x6f, 0x73, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2f, 0x76, 0x31,
	0x2f, 0x6f, 0x73, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x5f, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x20, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x6d, 0x61,
	0x73, 0x6b, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74,
	0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xb7, 0x0d, 0x0a, 0x12, 0x4f, 0x53,
	0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x41, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x6d, 0x65, 0x6e, 0x74,
	0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x12, 0x20, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74,
	0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72,
	0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x48, 0x0a, 0x0b, 0x6f, 0x73, 0x5f, 0x70, 0x6f, 0x6c,
	0x69, 0x63, 0x69, 0x65, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x22, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x73, 0x63, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x4f, 0x53, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x42,
	0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x6f, 0x73, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x69, 0x65, 0x73,
	0x12, 0x69, 0x0a, 0x0f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x66, 0x69, 0x6c,
	0x74, 0x65, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x73, 0x63, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x2e, 0x76, 0x31, 0x2e, 0x4f, 0x53, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x41, 0x73, 0x73,
	0x69, 0x67, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65,
	0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0e, 0x69, 0x6e, 0x73,
	0x74, 0x61, 0x6e, 0x63, 0x65, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x53, 0x0a, 0x07, 0x72,
	0x6f, 0x6c, 0x6c, 0x6f, 0x75, 0x74, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x34, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x73, 0x63, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x4f, 0x53, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79,
	0x41, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x52, 0x6f, 0x6c, 0x6c, 0x6f,
	0x75, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x07, 0x72, 0x6f, 0x6c, 0x6c, 0x6f, 0x75, 0x74,
	0x12, 0x24, 0x0a, 0x0b, 0x72, 0x65, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x18,
	0x06, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x72, 0x65, 0x76, 0x69,
	0x73, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x12, 0x51, 0x0a, 0x14, 0x72, 0x65, 0x76, 0x69, 0x73, 0x69,
	0x6f, 0x6e, 0x5f, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x07,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x12, 0x72, 0x65, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x43,
	0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x65, 0x74, 0x61,
	0x67, 0x18, 0x08, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x65, 0x74, 0x61, 0x67, 0x12, 0x63, 0x0a,
	0x0d, 0x72, 0x6f, 0x6c, 0x6c, 0x6f, 0x75, 0x74, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x09,
	0x20, 0x01, 0x28, 0x0e, 0x32, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x73, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x76, 0x31, 0x2e,
	0x4f, 0x53, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x41, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x6d, 0x65,
	0x6e, 0x74, 0x2e, 0x52, 0x6f, 0x6c, 0x6c, 0x6f, 0x75, 0x74, 0x53, 0x74, 0x61, 0x74, 0x65, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x0c, 0x72, 0x6f, 0x6c, 0x6c, 0x6f, 0x75, 0x74, 0x53, 0x74, 0x61,
	0x74, 0x65, 0x12, 0x1f, 0x0a, 0x08, 0x62, 0x61, 0x73, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x18, 0x0a,
	0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x08, 0x62, 0x61, 0x73, 0x65, 0x6c,
	0x69, 0x6e, 0x65, 0x12, 0x1d, 0x0a, 0x07, 0x64, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x64, 0x18, 0x0b,
	0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x07, 0x64, 0x65, 0x6c, 0x65, 0x74,
	0x65, 0x64, 0x12, 0x25, 0x0a, 0x0b, 0x72, 0x65, 0x63, 0x6f, 0x6e, 0x63, 0x69, 0x6c, 0x69, 0x6e,
	0x67, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0b, 0x72, 0x65,
	0x63, 0x6f, 0x6e, 0x63, 0x69, 0x6c, 0x69, 0x6e, 0x67, 0x12, 0x15, 0x0a, 0x03, 0x75, 0x69, 0x64,
	0x18, 0x0d, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x03, 0x75, 0x69, 0x64,
	0x1a, 0xa0, 0x01, 0x0a, 0x08, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x53, 0x65, 0x74, 0x12, 0x59, 0x0a,
	0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x41, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x73, 0x63,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x4f, 0x53, 0x50, 0x6f, 0x6c, 0x69, 0x63,
	0x79, 0x41, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x4c, 0x61, 0x62, 0x65,
	0x6c, 0x53, 0x65, 0x74, 0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79,
	0x52, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x1a, 0x39, 0x0a, 0x0b, 0x4c, 0x61, 0x62, 0x65,
	0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c,
	0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a,
	0x02, 0x38, 0x01, 0x1a, 0xa4, 0x03, 0x0a, 0x0e, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65,
	0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x10, 0x0a, 0x03, 0x61, 0x6c, 0x6c, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x08, 0x52, 0x03, 0x61, 0x6c, 0x6c, 0x12, 0x60, 0x0a, 0x10, 0x69, 0x6e, 0x63, 0x6c,
	0x75, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x18, 0x02, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x6f, 0x73, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x4f, 0x53,
	0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x41, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x6d, 0x65, 0x6e, 0x74,
	0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x53, 0x65, 0x74, 0x52, 0x0f, 0x69, 0x6e, 0x63, 0x6c, 0x75,
	0x73, 0x69, 0x6f, 0x6e, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x12, 0x60, 0x0a, 0x10, 0x65, 0x78,
	0x63, 0x6c, 0x75, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x18, 0x03,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x73, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x76, 0x31, 0x2e,
	0x4f, 0x53, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x41, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x6d, 0x65,
	0x6e, 0x74, 0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x53, 0x65, 0x74, 0x52, 0x0f, 0x65, 0x78, 0x63,
	0x6c, 0x75, 0x73, 0x69, 0x6f, 0x6e, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x12, 0x67, 0x0a, 0x0b,
	0x69, 0x6e, 0x76, 0x65, 0x6e, 0x74, 0x6f, 0x72, 0x69, 0x65, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x45, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x6f, 0x73, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x4f, 0x53, 0x50,
	0x6f, 0x6c, 0x69, 0x63, 0x79, 0x41, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x2e,
	0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x2e, 0x49,
	0x6e, 0x76, 0x65, 0x6e, 0x74, 0x6f, 0x72, 0x79, 0x52, 0x0b, 0x69, 0x6e, 0x76, 0x65, 0x6e, 0x74,
	0x6f, 0x72, 0x69, 0x65, 0x73, 0x1a, 0x53, 0x0a, 0x09, 0x49, 0x6e, 0x76, 0x65, 0x6e, 0x74, 0x6f,
	0x72, 0x79, 0x12, 0x27, 0x0a, 0x0d, 0x6f, 0x73, 0x5f, 0x73, 0x68, 0x6f, 0x72, 0x74, 0x5f, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0b,
	0x6f, 0x73, 0x53, 0x68, 0x6f, 0x72, 0x74, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x6f,
	0x73, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x09, 0x6f, 0x73, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x1a, 0xb1, 0x01, 0x0a, 0x07, 0x52,
	0x6f, 0x6c, 0x6c, 0x6f, 0x75, 0x74, 0x12, 0x5a, 0x0a, 0x11, 0x64, 0x69, 0x73, 0x72, 0x75, 0x70,
	0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x62, 0x75, 0x64, 0x67, 0x65, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x6f, 0x73, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x46, 0x69, 0x78,
	0x65, 0x64, 0x4f, 0x72, 0x50, 0x65, 0x72, 0x63, 0x65, 0x6e, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x02,
	0x52, 0x10, 0x64, 0x69, 0x73, 0x72, 0x75, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x75, 0x64, 0x67,
	0x65, 0x74, 0x12, 0x4a, 0x0a, 0x11, 0x6d, 0x69, 0x6e, 0x5f, 0x77, 0x61, 0x69, 0x74, 0x5f, 0x64,
	0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0f, 0x6d,
	0x69, 0x6e, 0x57, 0x61, 0x69, 0x74, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x6c,
	0x0a, 0x0c, 0x52, 0x6f, 0x6c, 0x6c, 0x6f, 0x75, 0x74, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x1d,
	0x0a, 0x19, 0x52, 0x4f, 0x4c, 0x4c, 0x4f, 0x55, 0x54, 0x5f, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f,
	0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0f, 0x0a,
	0x0b, 0x49, 0x4e, 0x5f, 0x50, 0x52, 0x4f, 0x47, 0x52, 0x45, 0x53, 0x53, 0x10, 0x01, 0x12, 0x0e,
	0x0a, 0x0a, 0x43, 0x41, 0x4e, 0x43, 0x45, 0x4c, 0x4c, 0x49, 0x4e, 0x47, 0x10, 0x02, 0x12, 0x0d,
	0x0a, 0x09, 0x43, 0x41, 0x4e, 0x43, 0x45, 0x4c, 0x4c, 0x45, 0x44, 0x10, 0x03, 0x12, 0x0d, 0x0a,
	0x09, 0x53, 0x55, 0x43, 0x43, 0x45, 0x45, 0x44, 0x45, 0x44, 0x10, 0x04, 0x3a, 0x84, 0x01, 0xea,
	0x41, 0x80, 0x01, 0x0a, 0x2a, 0x6f, 0x73, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4f, 0x53, 0x50,
	0x6f, 0x6c, 0x69, 0x63, 0x79, 0x41, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x12,
	0x52, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x6f, 0x73, 0x50, 0x6f, 0x6c, 0x69, 0x63,
	0x79, 0x41, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x7b, 0x6f, 0x73,
	0x5f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x5f, 0x61, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x6d, 0x65,
	0x6e, 0x74, 0x7d, 0x22, 0xb2, 0x05, 0x0a, 0x23, 0x4f, 0x53, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79,
	0x41, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x61, 0x0a, 0x14, 0x6f,
	0x73, 0x5f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x5f, 0x61, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x6d,
	0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2f, 0xfa, 0x41, 0x2c, 0x0a, 0x2a,
	0x6f, 0x73, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4f, 0x53, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79,
	0x41, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x12, 0x6f, 0x73, 0x50, 0x6f,
	0x6c, 0x69, 0x63, 0x79, 0x41, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x66,
	0x0a, 0x0a, 0x61, 0x70, 0x69, 0x5f, 0x6d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0e, 0x32, 0x47, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x6f, 0x73, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x4f, 0x53,
	0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x41, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x6d, 0x65, 0x6e, 0x74,
	0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74,
	0x61, 0x2e, 0x41, 0x50, 0x49, 0x4d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x52, 0x09, 0x61, 0x70, 0x69,
	0x4d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x12, 0x6f, 0x0a, 0x0d, 0x72, 0x6f, 0x6c, 0x6c, 0x6f, 0x75,
	0x74, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x4a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x73, 0x63,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x4f, 0x53, 0x50, 0x6f, 0x6c, 0x69, 0x63,
	0x79, 0x41, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x4f, 0x70, 0x65, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x52, 0x6f, 0x6c,
	0x6c, 0x6f, 0x75, 0x74, 0x53, 0x74, 0x61, 0x74, 0x65, 0x52, 0x0c, 0x72, 0x6f, 0x6c, 0x6c, 0x6f,
	0x75, 0x74, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x48, 0x0a, 0x12, 0x72, 0x6f, 0x6c, 0x6c, 0x6f,
	0x75, 0x74, 0x5f, 0x73, 0x74, 0x61, 0x72, 0x74, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52,
	0x10, 0x72, 0x6f, 0x6c, 0x6c, 0x6f, 0x75, 0x74, 0x53, 0x74, 0x61, 0x72, 0x74, 0x54, 0x69, 0x6d,
	0x65, 0x12, 0x4a, 0x0a, 0x13, 0x72, 0x6f, 0x6c, 0x6c, 0x6f, 0x75, 0x74, 0x5f, 0x75, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x11, 0x72, 0x6f, 0x6c, 0x6c,
	0x6f, 0x75, 0x74, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x22, 0x4b, 0x0a,
	0x09, 0x41, 0x50, 0x49, 0x4d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x12, 0x1a, 0x0a, 0x16, 0x41, 0x50,
	0x49, 0x5f, 0x4d, 0x45, 0x54, 0x48, 0x4f, 0x44, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49,
	0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0a, 0x0a, 0x06, 0x43, 0x52, 0x45, 0x41, 0x54, 0x45,
	0x10, 0x01, 0x12, 0x0a, 0x0a, 0x06, 0x55, 0x50, 0x44, 0x41, 0x54, 0x45, 0x10, 0x02, 0x12, 0x0a,
	0x0a, 0x06, 0x44, 0x45, 0x4c, 0x45, 0x54, 0x45, 0x10, 0x03, 0x22, 0x6c, 0x0a, 0x0c, 0x52, 0x6f,
	0x6c, 0x6c, 0x6f, 0x75, 0x74, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x1d, 0x0a, 0x19, 0x52, 0x4f,
	0x4c, 0x4c, 0x4f, 0x55, 0x54, 0x5f, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50,
	0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0f, 0x0a, 0x0b, 0x49, 0x4e, 0x5f,
	0x50, 0x52, 0x4f, 0x47, 0x52, 0x45, 0x53, 0x53, 0x10, 0x01, 0x12, 0x0e, 0x0a, 0x0a, 0x43, 0x41,
	0x4e, 0x43, 0x45, 0x4c, 0x4c, 0x49, 0x4e, 0x47, 0x10, 0x02, 0x12, 0x0d, 0x0a, 0x09, 0x43, 0x41,
	0x4e, 0x43, 0x45, 0x4c, 0x4c, 0x45, 0x44, 0x10, 0x03, 0x12, 0x0d, 0x0a, 0x09, 0x53, 0x55, 0x43,
	0x43, 0x45, 0x45, 0x44, 0x45, 0x44, 0x10, 0x04, 0x22, 0x85, 0x02, 0x0a, 0x1f, 0x43, 0x72, 0x65,
	0x61, 0x74, 0x65, 0x4f, 0x53, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x41, 0x73, 0x73, 0x69, 0x67,
	0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x41, 0x0a, 0x06,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x29, 0xe0, 0x41,
	0x02, 0xfa, 0x41, 0x23, 0x0a, 0x21, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12,
	0x63, 0x0a, 0x14, 0x6f, 0x73, 0x5f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x5f, 0x61, 0x73, 0x73,
	0x69, 0x67, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2c, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x73, 0x63,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x4f, 0x53, 0x50, 0x6f, 0x6c, 0x69, 0x63,
	0x79, 0x41, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x02,
	0x52, 0x12, 0x6f, 0x73, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x41, 0x73, 0x73, 0x69, 0x67, 0x6e,
	0x6d, 0x65, 0x6e, 0x74, 0x12, 0x3a, 0x0a, 0x17, 0x6f, 0x73, 0x5f, 0x70, 0x6f, 0x6c, 0x69, 0x63,
	0x79, 0x5f, 0x61, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x69, 0x64, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x14, 0x6f, 0x73, 0x50, 0x6f,
	0x6c, 0x69, 0x63, 0x79, 0x41, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x49, 0x64,
	0x22, 0xc8, 0x01, 0x0a, 0x1f, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4f, 0x53, 0x50, 0x6f, 0x6c,
	0x69, 0x63, 0x79, 0x41, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x63, 0x0a, 0x14, 0x6f, 0x73, 0x5f, 0x70, 0x6f, 0x6c, 0x69, 0x63,
	0x79, 0x5f, 0x61, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x6f, 0x73, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x4f, 0x53,
	0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x41, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x6d, 0x65, 0x6e, 0x74,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x12, 0x6f, 0x73, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x41,
	0x73, 0x73, 0x69, 0x67, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52,
	0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x22, 0x66, 0x0a, 0x1c, 0x47,
	0x65, 0x74, 0x4f, 0x53, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x41, 0x73, 0x73, 0x69, 0x67, 0x6e,
	0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x46, 0x0a, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x32, 0xe0, 0x41, 0x02, 0xfa, 0x41,
	0x2c, 0x0a, 0x2a, 0x6f, 0x73, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4f, 0x53, 0x50, 0x6f, 0x6c,
	0x69, 0x63, 0x79, 0x41, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x22, 0x9f, 0x01, 0x0a, 0x1e, 0x4c, 0x69, 0x73, 0x74, 0x4f, 0x53, 0x50, 0x6f,
	0x6c, 0x69, 0x63, 0x79, 0x41, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x41, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x29, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x23, 0x0a, 0x21,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67,
	0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61,
	0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74,
	0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65,
	0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0xab, 0x01, 0x0a, 0x1f, 0x4c, 0x69, 0x73, 0x74, 0x4f, 0x53,
	0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x41, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x6d, 0x65, 0x6e, 0x74,
	0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x60, 0x0a, 0x15, 0x6f, 0x73, 0x5f,
	0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x5f, 0x61, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x6d, 0x65, 0x6e,
	0x74, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x73, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x2e, 0x76, 0x31, 0x2e, 0x4f, 0x53, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x41, 0x73, 0x73, 0x69,
	0x67, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x13, 0x6f, 0x73, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79,
	0x41, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e,
	0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f,
	0x6b, 0x65, 0x6e, 0x22, 0xac, 0x01, 0x0a, 0x26, 0x4c, 0x69, 0x73, 0x74, 0x4f, 0x53, 0x50, 0x6f,
	0x6c, 0x69, 0x63, 0x79, 0x41, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65,
	0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x46,
	0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x32, 0xe0, 0x41,
	0x02, 0xfa, 0x41, 0x2c, 0x0a, 0x2a, 0x6f, 0x73, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4f, 0x53,
	0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x41, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x6d, 0x65, 0x6e, 0x74,
	0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73,
	0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53,
	0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65,
	0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b,
	0x65, 0x6e, 0x22, 0xb3, 0x01, 0x0a, 0x27, 0x4c, 0x69, 0x73, 0x74, 0x4f, 0x53, 0x50, 0x6f, 0x6c,
	0x69, 0x63, 0x79, 0x41, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x76,
	0x69, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x60,
	0x0a, 0x15, 0x6f, 0x73, 0x5f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x5f, 0x61, 0x73, 0x73, 0x69,
	0x67, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2c, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x73, 0x63,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x4f, 0x53, 0x50, 0x6f, 0x6c, 0x69, 0x63,
	0x79, 0x41, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x13, 0x6f, 0x73, 0x50,
	0x6f, 0x6c, 0x69, 0x63, 0x79, 0x41, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x73,
	0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f,
	0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50,
	0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x69, 0x0a, 0x1f, 0x44, 0x65, 0x6c, 0x65,
	0x74, 0x65, 0x4f, 0x53, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x41, 0x73, 0x73, 0x69, 0x67, 0x6e,
	0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x46, 0x0a, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x32, 0xe0, 0x41, 0x02, 0xfa, 0x41,
	0x2c, 0x0a, 0x2a, 0x6f, 0x73, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4f, 0x53, 0x50, 0x6f, 0x6c,
	0x69, 0x63, 0x79, 0x41, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x42, 0xc8, 0x01, 0x0a, 0x1c, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x73, 0x63, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x2e, 0x76, 0x31, 0x42, 0x18, 0x4f, 0x73, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x41, 0x73,
	0x73, 0x69, 0x67, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01,
	0x5a, 0x38, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x6f, 0x73, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2f, 0x61,
	0x70, 0x69, 0x76, 0x31, 0x2f, 0x6f, 0x73, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x70, 0x62, 0x3b,
	0x6f, 0x73, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x70, 0x62, 0xaa, 0x02, 0x18, 0x47, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x4f, 0x73, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x2e, 0x56, 0x31, 0xca, 0x02, 0x18, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43,
	0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x4f, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x5c, 0x56, 0x31,
	0xea, 0x02, 0x1b, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43, 0x6c, 0x6f, 0x75, 0x64,
	0x3a, 0x3a, 0x4f, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x3a, 0x3a, 0x56, 0x31, 0x62, 0x06,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_osconfig_v1_os_policy_assignments_proto_rawDescOnce sync.Once
	file_google_cloud_osconfig_v1_os_policy_assignments_proto_rawDescData = file_google_cloud_osconfig_v1_os_policy_assignments_proto_rawDesc
)

func file_google_cloud_osconfig_v1_os_policy_assignments_proto_rawDescGZIP() []byte {
	file_google_cloud_osconfig_v1_os_policy_assignments_proto_rawDescOnce.Do(func() {
		file_google_cloud_osconfig_v1_os_policy_assignments_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_osconfig_v1_os_policy_assignments_proto_rawDescData)
	})
	return file_google_cloud_osconfig_v1_os_policy_assignments_proto_rawDescData
}

var file_google_cloud_osconfig_v1_os_policy_assignments_proto_enumTypes = make([]protoimpl.EnumInfo, 3)
var file_google_cloud_osconfig_v1_os_policy_assignments_proto_msgTypes = make([]protoimpl.MessageInfo, 15)
var file_google_cloud_osconfig_v1_os_policy_assignments_proto_goTypes = []interface{}{
	(OSPolicyAssignment_RolloutState)(0),                  // 0: google.cloud.osconfig.v1.OSPolicyAssignment.RolloutState
	(OSPolicyAssignmentOperationMetadata_APIMethod)(0),    // 1: google.cloud.osconfig.v1.OSPolicyAssignmentOperationMetadata.APIMethod
	(OSPolicyAssignmentOperationMetadata_RolloutState)(0), // 2: google.cloud.osconfig.v1.OSPolicyAssignmentOperationMetadata.RolloutState
	(*OSPolicyAssignment)(nil),                            // 3: google.cloud.osconfig.v1.OSPolicyAssignment
	(*OSPolicyAssignmentOperationMetadata)(nil),           // 4: google.cloud.osconfig.v1.OSPolicyAssignmentOperationMetadata
	(*CreateOSPolicyAssignmentRequest)(nil),               // 5: google.cloud.osconfig.v1.CreateOSPolicyAssignmentRequest
	(*UpdateOSPolicyAssignmentRequest)(nil),               // 6: google.cloud.osconfig.v1.UpdateOSPolicyAssignmentRequest
	(*GetOSPolicyAssignmentRequest)(nil),                  // 7: google.cloud.osconfig.v1.GetOSPolicyAssignmentRequest
	(*ListOSPolicyAssignmentsRequest)(nil),                // 8: google.cloud.osconfig.v1.ListOSPolicyAssignmentsRequest
	(*ListOSPolicyAssignmentsResponse)(nil),               // 9: google.cloud.osconfig.v1.ListOSPolicyAssignmentsResponse
	(*ListOSPolicyAssignmentRevisionsRequest)(nil),        // 10: google.cloud.osconfig.v1.ListOSPolicyAssignmentRevisionsRequest
	(*ListOSPolicyAssignmentRevisionsResponse)(nil),       // 11: google.cloud.osconfig.v1.ListOSPolicyAssignmentRevisionsResponse
	(*DeleteOSPolicyAssignmentRequest)(nil),               // 12: google.cloud.osconfig.v1.DeleteOSPolicyAssignmentRequest
	(*OSPolicyAssignment_LabelSet)(nil),                   // 13: google.cloud.osconfig.v1.OSPolicyAssignment.LabelSet
	(*OSPolicyAssignment_InstanceFilter)(nil),             // 14: google.cloud.osconfig.v1.OSPolicyAssignment.InstanceFilter
	(*OSPolicyAssignment_Rollout)(nil),                    // 15: google.cloud.osconfig.v1.OSPolicyAssignment.Rollout
	nil,                                                   // 16: google.cloud.osconfig.v1.OSPolicyAssignment.LabelSet.LabelsEntry
	(*OSPolicyAssignment_InstanceFilter_Inventory)(nil),   // 17: google.cloud.osconfig.v1.OSPolicyAssignment.InstanceFilter.Inventory
	(*OSPolicy)(nil),                                      // 18: google.cloud.osconfig.v1.OSPolicy
	(*timestamppb.Timestamp)(nil),                         // 19: google.protobuf.Timestamp
	(*fieldmaskpb.FieldMask)(nil),                         // 20: google.protobuf.FieldMask
	(*FixedOrPercent)(nil),                                // 21: google.cloud.osconfig.v1.FixedOrPercent
	(*durationpb.Duration)(nil),                           // 22: google.protobuf.Duration
}
var file_google_cloud_osconfig_v1_os_policy_assignments_proto_depIdxs = []int32{
	18, // 0: google.cloud.osconfig.v1.OSPolicyAssignment.os_policies:type_name -> google.cloud.osconfig.v1.OSPolicy
	14, // 1: google.cloud.osconfig.v1.OSPolicyAssignment.instance_filter:type_name -> google.cloud.osconfig.v1.OSPolicyAssignment.InstanceFilter
	15, // 2: google.cloud.osconfig.v1.OSPolicyAssignment.rollout:type_name -> google.cloud.osconfig.v1.OSPolicyAssignment.Rollout
	19, // 3: google.cloud.osconfig.v1.OSPolicyAssignment.revision_create_time:type_name -> google.protobuf.Timestamp
	0,  // 4: google.cloud.osconfig.v1.OSPolicyAssignment.rollout_state:type_name -> google.cloud.osconfig.v1.OSPolicyAssignment.RolloutState
	1,  // 5: google.cloud.osconfig.v1.OSPolicyAssignmentOperationMetadata.api_method:type_name -> google.cloud.osconfig.v1.OSPolicyAssignmentOperationMetadata.APIMethod
	2,  // 6: google.cloud.osconfig.v1.OSPolicyAssignmentOperationMetadata.rollout_state:type_name -> google.cloud.osconfig.v1.OSPolicyAssignmentOperationMetadata.RolloutState
	19, // 7: google.cloud.osconfig.v1.OSPolicyAssignmentOperationMetadata.rollout_start_time:type_name -> google.protobuf.Timestamp
	19, // 8: google.cloud.osconfig.v1.OSPolicyAssignmentOperationMetadata.rollout_update_time:type_name -> google.protobuf.Timestamp
	3,  // 9: google.cloud.osconfig.v1.CreateOSPolicyAssignmentRequest.os_policy_assignment:type_name -> google.cloud.osconfig.v1.OSPolicyAssignment
	3,  // 10: google.cloud.osconfig.v1.UpdateOSPolicyAssignmentRequest.os_policy_assignment:type_name -> google.cloud.osconfig.v1.OSPolicyAssignment
	20, // 11: google.cloud.osconfig.v1.UpdateOSPolicyAssignmentRequest.update_mask:type_name -> google.protobuf.FieldMask
	3,  // 12: google.cloud.osconfig.v1.ListOSPolicyAssignmentsResponse.os_policy_assignments:type_name -> google.cloud.osconfig.v1.OSPolicyAssignment
	3,  // 13: google.cloud.osconfig.v1.ListOSPolicyAssignmentRevisionsResponse.os_policy_assignments:type_name -> google.cloud.osconfig.v1.OSPolicyAssignment
	16, // 14: google.cloud.osconfig.v1.OSPolicyAssignment.LabelSet.labels:type_name -> google.cloud.osconfig.v1.OSPolicyAssignment.LabelSet.LabelsEntry
	13, // 15: google.cloud.osconfig.v1.OSPolicyAssignment.InstanceFilter.inclusion_labels:type_name -> google.cloud.osconfig.v1.OSPolicyAssignment.LabelSet
	13, // 16: google.cloud.osconfig.v1.OSPolicyAssignment.InstanceFilter.exclusion_labels:type_name -> google.cloud.osconfig.v1.OSPolicyAssignment.LabelSet
	17, // 17: google.cloud.osconfig.v1.OSPolicyAssignment.InstanceFilter.inventories:type_name -> google.cloud.osconfig.v1.OSPolicyAssignment.InstanceFilter.Inventory
	21, // 18: google.cloud.osconfig.v1.OSPolicyAssignment.Rollout.disruption_budget:type_name -> google.cloud.osconfig.v1.FixedOrPercent
	22, // 19: google.cloud.osconfig.v1.OSPolicyAssignment.Rollout.min_wait_duration:type_name -> google.protobuf.Duration
	20, // [20:20] is the sub-list for method output_type
	20, // [20:20] is the sub-list for method input_type
	20, // [20:20] is the sub-list for extension type_name
	20, // [20:20] is the sub-list for extension extendee
	0,  // [0:20] is the sub-list for field type_name
}

func init() { file_google_cloud_osconfig_v1_os_policy_assignments_proto_init() }
func file_google_cloud_osconfig_v1_os_policy_assignments_proto_init() {
	if File_google_cloud_osconfig_v1_os_policy_assignments_proto != nil {
		return
	}
	file_google_cloud_osconfig_v1_os_policy_proto_init()
	file_google_cloud_osconfig_v1_osconfig_common_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_osconfig_v1_os_policy_assignments_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*OSPolicyAssignment); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_osconfig_v1_os_policy_assignments_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*OSPolicyAssignmentOperationMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_osconfig_v1_os_policy_assignments_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateOSPolicyAssignmentRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_osconfig_v1_os_policy_assignments_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateOSPolicyAssignmentRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_osconfig_v1_os_policy_assignments_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetOSPolicyAssignmentRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_osconfig_v1_os_policy_assignments_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListOSPolicyAssignmentsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_osconfig_v1_os_policy_assignments_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListOSPolicyAssignmentsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_osconfig_v1_os_policy_assignments_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListOSPolicyAssignmentRevisionsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_osconfig_v1_os_policy_assignments_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListOSPolicyAssignmentRevisionsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_osconfig_v1_os_policy_assignments_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteOSPolicyAssignmentRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_osconfig_v1_os_policy_assignments_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*OSPolicyAssignment_LabelSet); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_osconfig_v1_os_policy_assignments_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*OSPolicyAssignment_InstanceFilter); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_osconfig_v1_os_policy_assignments_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*OSPolicyAssignment_Rollout); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_osconfig_v1_os_policy_assignments_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*OSPolicyAssignment_InstanceFilter_Inventory); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_osconfig_v1_os_policy_assignments_proto_rawDesc,
			NumEnums:      3,
			NumMessages:   15,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_osconfig_v1_os_policy_assignments_proto_goTypes,
		DependencyIndexes: file_google_cloud_osconfig_v1_os_policy_assignments_proto_depIdxs,
		EnumInfos:         file_google_cloud_osconfig_v1_os_policy_assignments_proto_enumTypes,
		MessageInfos:      file_google_cloud_osconfig_v1_os_policy_assignments_proto_msgTypes,
	}.Build()
	File_google_cloud_osconfig_v1_os_policy_assignments_proto = out.File
	file_google_cloud_osconfig_v1_os_policy_assignments_proto_rawDesc = nil
	file_google_cloud_osconfig_v1_os_policy_assignments_proto_goTypes = nil
	file_google_cloud_osconfig_v1_os_policy_assignments_proto_depIdxs = nil
}
