#![no_std]

#[derive(Debug)]
pub struct UnknownLocale;

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod POSIX {
    pub mod LC_ADDRESS {
        /// `None`
        pub const COUNTRY_AB3: Option<&str> = None;
        /// `None`
        pub const COUNTRY_ABTWO: Option<&str> = None;
        /// `None`
        pub const COUNTRY_CAR: Option<&str> = None;
        /// `None`
        pub const COUNTRY_ISBN: Option<&str> = None;
        /// `None`
        pub const COUNTRY_NAME: Option<&str> = None;
        /// `None`
        pub const COUNTRY_NUM: Option<i64> = None;
        /// `None`
        pub const COUNTRY_POST: Option<&str> = None;
        /// `None`
        pub const LANG_AB: Option<&str> = None;
        /// `None`
        pub const LANG_LIB: Option<&str> = None;
        /// `None`
        pub const LANG_NAME: Option<&str> = None;
        /// `None`
        pub const LANG_TERM: Option<&str> = None;
        /// `None`
        pub const POSTAL_FMT: Option<&str> = None;
    }
    pub mod LC_IDENTIFICATION {
        /// `None`
        pub const ABBREVIATION: Option<&str> = None;
        /// `None`
        pub const ADDRESS: Option<&str> = None;
        /// `None`
        pub const CATEGORY: Option<&[&[&str]]> = None;
        /// `None`
        pub const CONTACT: Option<&str> = None;
        /// `None`
        pub const DATE: Option<&str> = None;
        /// `None`
        pub const EMAIL: Option<&str> = None;
        /// `None`
        pub const FAX: Option<&str> = None;
        /// `None`
        pub const LANGUAGE: Option<&str> = None;
        /// `None`
        pub const REVISION: Option<&str> = None;
        /// `None`
        pub const SOURCE: Option<&str> = None;
        /// `None`
        pub const TEL: Option<&str> = None;
        /// `None`
        pub const TERRITORY: Option<&str> = None;
        /// `None`
        pub const TITLE: Option<&str> = None;
    }
    pub mod LC_MESSAGES {
        /// `"^[nN]"`
        pub const NOEXPR: &str = "^[nN]";
        /// `Some("No")`
        pub const NOSTR: Option<&str> = Some("No");
        /// `"^[yY]"`
        pub const YESEXPR: &str = "^[yY]";
        /// `Some("Yes")`
        pub const YESSTR: Option<&str> = Some("Yes");
    }
    pub mod LC_MONETARY {
        /// `""`
        pub const CURRENCY_SYMBOL: &str = "";
        /// `-1`
        pub const FRAC_DIGITS: i64 = -1;
        /// `""`
        pub const INT_CURR_SYMBOL: &str = "";
        /// `-1`
        pub const INT_FRAC_DIGITS: i64 = -1;
        /// `None`
        pub const INT_N_CS_PRECEDES: Option<i64> = None;
        /// `None`
        pub const INT_N_SEP_BY_SPACE: Option<i64> = None;
        /// `None`
        pub const INT_N_SIGN_POSN: Option<i64> = None;
        /// `None`
        pub const INT_P_CS_PRECEDES: Option<i64> = None;
        /// `None`
        pub const INT_P_SEP_BY_SPACE: Option<i64> = None;
        /// `None`
        pub const INT_P_SIGN_POSN: Option<i64> = None;
        /// `"."`
        pub const MON_DECIMAL_POINT: &str = ".";
        /// `&[-1]`
        pub const MON_GROUPING: &[i64] = &[-1];
        /// `""`
        pub const MON_THOUSANDS_SEP: &str = "";
        /// `""`
        pub const NEGATIVE_SIGN: &str = "";
        /// `-1`
        pub const N_CS_PRECEDES: i64 = -1;
        /// `-1`
        pub const N_SEP_BY_SPACE: i64 = -1;
        /// `-1`
        pub const N_SIGN_POSN: i64 = -1;
        /// `""`
        pub const POSITIVE_SIGN: &str = "";
        /// `-1`
        pub const P_CS_PRECEDES: i64 = -1;
        /// `-1`
        pub const P_SEP_BY_SPACE: i64 = -1;
        /// `-1`
        pub const P_SIGN_POSN: i64 = -1;
    }
    pub mod LC_NUMERIC {
        /// `"."`
        pub const DECIMAL_POINT: &str = ".";
        /// `&[-1]`
        pub const GROUPING: &[i64] = &[-1];
        /// `""`
        pub const THOUSANDS_SEP: &str = "";
    }
    pub mod LC_TELEPHONE {
        /// `None`
        pub const INT_PREFIX: Option<&str> = None;
        /// `None`
        pub const INT_SELECT: Option<&str> = None;
        /// `None`
        pub const TEL_DOM_FMT: Option<&str> = None;
        /// `None`
        pub const TEL_INT_FMT: Option<&str> = None;
    }
    pub mod LC_TIME {
        /// `&["Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"]`
        pub const ABDAY: &[&str] = &["Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"];
        /// `&["Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"]`
        pub const ABMON: &[&str] = &["Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"];
        /// `None`
        pub const AB_ALT_MON: Option<&[&str]> = None;
        /// `None`
        pub const ALT_DIGITS: Option<&[&str]> = None;
        /// `None`
        pub const ALT_MON: Option<&[&str]> = None;
        /// `&["AM", "PM"]`
        pub const AM_PM: &[&str] = &["AM", "PM"];
        /// `None`
        pub const CAL_DIRECTION: Option<i64> = None;
        /// `Some("%a %b %e %H:%M:%S %Z %Y")`
        pub const DATE_FMT: Option<&str> = Some("%a %b %e %H:%M:%S %Z %Y");
        /// `&["Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"]`
        pub const DAY: &[&str] = &["Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"];
        /// `"%m/%d/%y"`
        pub const D_FMT: &str = "%m/%d/%y";
        /// `"%a %b %e %H:%M:%S %Y"`
        pub const D_T_FMT: &str = "%a %b %e %H:%M:%S %Y";
        /// `None`
        pub const ERA: Option<&[&str]> = None;
        /// `None`
        pub const ERA_D_FMT: Option<&str> = None;
        /// `None`
        pub const ERA_D_T_FMT: Option<&str> = None;
        /// `None`
        pub const ERA_T_FMT: Option<&str> = None;
        /// `None`
        pub const FIRST_WEEKDAY: Option<i64> = None;
        /// `None`
        pub const FIRST_WORKDAY: Option<i64> = None;
        /// `&["January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"]`
        pub const MON: &[&str] = &["January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"];
        /// `"%H:%M:%S"`
        pub const T_FMT: &str = "%H:%M:%S";
        /// `"%I:%M:%S %p"`
        pub const T_FMT_AMPM: &str = "%I:%M:%S %p";
        /// `None`
        pub const WEEK: Option<&[i64]> = None;
    }
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod aa_DJ {
    pub mod LC_ADDRESS {
        /// `Some("DJI")`
        pub const COUNTRY_AB3: Option<&str> = Some("DJI");
        /// `Some("DJ")`
        pub const COUNTRY_ABTWO: Option<&str> = Some("DJ");
        /// `Some("DJI")`
        pub const COUNTRY_CAR: Option<&str> = Some("DJI");
        /// `None`
        pub const COUNTRY_ISBN: Option<&str> = None;
        /// `Some("Yabuuti")`
        pub const COUNTRY_NAME: Option<&str> = Some("Yabuuti");
        /// `Some(262)`
        pub const COUNTRY_NUM: Option<i64> = Some(262);
        /// `Some("DJI")`
        pub const COUNTRY_POST: Option<&str> = Some("DJI");
        /// `Some("aa")`
        pub const LANG_AB: Option<&str> = Some("aa");
        /// `Some("aar")`
        pub const LANG_LIB: Option<&str> = Some("aar");
        /// `Some("Qafar")`
        pub const LANG_NAME: Option<&str> = Some("Qafar");
        /// `Some("aar")`
        pub const LANG_TERM: Option<&str> = Some("aar");
        /// `Some("%z%c%T%s%b%e%r")`
        pub const POSTAL_FMT: Option<&str> = Some("%z%c%T%s%b%e%r");
    }
    pub mod LC_IDENTIFICATION {
        /// `None`
        pub const ABBREVIATION: Option<&str> = None;
        /// `Some("7802 Solomon Seal Dr., Springfield, VA 22152, USA")`
        pub const ADDRESS: Option<&str> = Some("7802 Solomon Seal Dr., Springfield, VA 22152, USA");
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_TIME"],
        /// ]
        /// ```
        pub const CATEGORY: Option<&[&[&str]]> = Some(&[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_MEASUREMENT"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_TELEPHONE"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_TIME"],
        ]);
        /// `Some("")`
        pub const CONTACT: Option<&str> = Some("");
        /// `Some("2003-07-05")`
        pub const DATE: Option<&str> = Some("2003-07-05");
        /// `Some("locales@geez.org")`
        pub const EMAIL: Option<&str> = Some("locales@geez.org");
        /// `Some("")`
        pub const FAX: Option<&str> = Some("");
        /// `Some("Afar")`
        pub const LANGUAGE: Option<&str> = Some("Afar");
        /// `Some("0.20")`
        pub const REVISION: Option<&str> = Some("0.20");
        /// `Some("Ge'ez Frontier Foundation")`
        pub const SOURCE: Option<&str> = Some("Ge'ez Frontier Foundation");
        /// `Some("")`
        pub const TEL: Option<&str> = Some("");
        /// `Some("Djibouti")`
        pub const TERRITORY: Option<&str> = Some("Djibouti");
        /// `Some("Afar language locale for Djibouti (Cadu/Laaqo Dialects).")`
        pub const TITLE: Option<&str> = Some("Afar language locale for Djibouti (Cadu/Laaqo Dialects).");
    }
    pub use super::aa_ET::LC_MESSAGES;
    pub mod LC_MONETARY {
        /// `"Fdj"`
        pub const CURRENCY_SYMBOL: &str = "Fdj";
        /// `2`
        pub const FRAC_DIGITS: i64 = 2;
        /// `"DJF "`
        pub const INT_CURR_SYMBOL: &str = "DJF ";
        /// `2`
        pub const INT_FRAC_DIGITS: i64 = 2;
        /// `None`
        pub const INT_N_CS_PRECEDES: Option<i64> = None;
        /// `None`
        pub const INT_N_SEP_BY_SPACE: Option<i64> = None;
        /// `None`
        pub const INT_N_SIGN_POSN: Option<i64> = None;
        /// `None`
        pub const INT_P_CS_PRECEDES: Option<i64> = None;
        /// `None`
        pub const INT_P_SEP_BY_SPACE: Option<i64> = None;
        /// `None`
        pub const INT_P_SIGN_POSN: Option<i64> = None;
        /// `"."`
        pub const MON_DECIMAL_POINT: &str = ".";
        /// `&[3, 3]`
        pub const MON_GROUPING: &[i64] = &[3, 3];
        /// `"\u{202f}"`
        pub const MON_THOUSANDS_SEP: &str = "\u{202f}";
        /// `"-"`
        pub const NEGATIVE_SIGN: &str = "-";
        /// `1`
        pub const N_CS_PRECEDES: i64 = 1;
        /// `0`
        pub const N_SEP_BY_SPACE: i64 = 0;
        /// `1`
        pub const N_SIGN_POSN: i64 = 1;
        /// `""`
        pub const POSITIVE_SIGN: &str = "";
        /// `1`
        pub const P_CS_PRECEDES: i64 = 1;
        /// `0`
        pub const P_SEP_BY_SPACE: i64 = 0;
        /// `1`
        pub const P_SIGN_POSN: i64 = 1;
    }
    pub mod LC_NUMERIC {
        /// `"."`
        pub const DECIMAL_POINT: &str = ".";
        /// `&[0, 0]`
        pub const GROUPING: &[i64] = &[0, 0];
        /// `""`
        pub const THOUSANDS_SEP: &str = "";
    }
    pub mod LC_TELEPHONE {
        /// `Some("253")`
        pub const INT_PREFIX: Option<&str> = Some("253");
        /// `Some("00")`
        pub const INT_SELECT: Option<&str> = Some("00");
        /// `Some("%a-%l")`
        pub const TEL_DOM_FMT: Option<&str> = Some("%a-%l");
        /// `Some("+%c %a %l")`
        pub const TEL_INT_FMT: Option<&str> = Some("+%c %a %l");
    }
    pub mod LC_TIME {
        /// `&["Aca", "Etl", "Tal", "Arb", "Kam", "Gum", "Sab"]`
        pub const ABDAY: &[&str] = &["Aca", "Etl", "Tal", "Arb", "Kam", "Gum", "Sab"];
        /// `&["Qun", "Nah", "Cig", "Agd", "Cax", "Qas", "Qad", "Leq", "Way", "Dit", "Xim", "Kax"]`
        pub const ABMON: &[&str] = &["Qun", "Nah", "Cig", "Agd", "Cax", "Qas", "Qad", "Leq", "Way", "Dit", "Xim", "Kax"];
        /// `None`
        pub const AB_ALT_MON: Option<&[&str]> = None;
        /// `None`
        pub const ALT_DIGITS: Option<&[&str]> = None;
        /// `None`
        pub const ALT_MON: Option<&[&str]> = None;
        /// `&["saaku", "carra"]`
        pub const AM_PM: &[&str] = &["saaku", "carra"];
        /// `None`
        pub const CAL_DIRECTION: Option<i64> = None;
        /// `Some("%a %b %e %r %Z %Y")`
        pub const DATE_FMT: Option<&str> = Some("%a %b %e %r %Z %Y");
        /// `&["Acaada", "Etleeni", "Talaata", "Arbaqa", "Kamiisi", "Gumqata", "Sabti"]`
        pub const DAY: &[&str] = &["Acaada", "Etleeni", "Talaata", "Arbaqa", "Kamiisi", "Gumqata", "Sabti"];
        /// `"%d.%m.%Y"`
        pub const D_FMT: &str = "%d.%m.%Y";
        /// `"%a %d %b %Y %l:%M:%S %p %Z"`
        pub const D_T_FMT: &str = "%a %d %b %Y %l:%M:%S %p %Z";
        /// `None`
        pub const ERA: Option<&[&str]> = None;
        /// `None`
        pub const ERA_D_FMT: Option<&str> = None;
        /// `None`
        pub const ERA_D_T_FMT: Option<&str> = None;
        /// `None`
        pub const ERA_T_FMT: Option<&str> = None;
        /// `Some(7)`
        pub const FIRST_WEEKDAY: Option<i64> = Some(7);
        /// `None`
        pub const FIRST_WORKDAY: Option<i64> = None;
        /// `&["Qunxa Garablu", "Naharsi Kudo", "Ciggilta Kudo", "Agda Baxis", "Caxah Alsa", "Qasa Dirri", "Qado Dirri", "Leqeeni", "Waysu", "Diteli", "Ximoli", "Kaxxa Garablu"]`
        pub const MON: &[&str] = &["Qunxa Garablu", "Naharsi Kudo", "Ciggilta Kudo", "Agda Baxis", "Caxah Alsa", "Qasa Dirri", "Qado Dirri", "Leqeeni", "Waysu", "Diteli", "Ximoli", "Kaxxa Garablu"];
        /// `"%l:%M:%S %p"`
        pub const T_FMT: &str = "%l:%M:%S %p";
        /// `"%l:%M:%S %p"`
        pub const T_FMT_AMPM: &str = "%l:%M:%S %p";
        /// `Some(&[7, 19971130, 1])`
        pub const WEEK: Option<&[i64]> = Some(&[7, 19971130, 1]);
    }
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod aa_ER {
    pub mod LC_ADDRESS {
        /// `Some("ERI")`
        pub const COUNTRY_AB3: Option<&str> = Some("ERI");
        /// `Some("ER")`
        pub const COUNTRY_ABTWO: Option<&str> = Some("ER");
        /// `Some("ER")`
        pub const COUNTRY_CAR: Option<&str> = Some("ER");
        /// `None`
        pub const COUNTRY_ISBN: Option<&str> = None;
        /// `Some("Eretria")`
        pub const COUNTRY_NAME: Option<&str> = Some("Eretria");
        /// `Some(232)`
        pub const COUNTRY_NUM: Option<i64> = Some(232);
        /// `Some("ERI")`
        pub const COUNTRY_POST: Option<&str> = Some("ERI");
        /// `Some("aa")`
        pub const LANG_AB: Option<&str> = Some("aa");
        /// `Some("aar")`
        pub const LANG_LIB: Option<&str> = Some("aar");
        /// `Some("Qafar")`
        pub const LANG_NAME: Option<&str> = Some("Qafar");
        /// `Some("aar")`
        pub const LANG_TERM: Option<&str> = Some("aar");
        /// `Some("%z%c%T%s%b%e%r")`
        pub const POSTAL_FMT: Option<&str> = Some("%z%c%T%s%b%e%r");
    }
    pub mod LC_IDENTIFICATION {
        /// `None`
        pub const ABBREVIATION: Option<&str> = None;
        /// `Some("7802 Solomon Seal Dr., Springfield, VA 22152, USA")`
        pub const ADDRESS: Option<&str> = Some("7802 Solomon Seal Dr., Springfield, VA 22152, USA");
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_TIME"],
        /// ]
        /// ```
        pub const CATEGORY: Option<&[&[&str]]> = Some(&[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_MEASUREMENT"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_TELEPHONE"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_TIME"],
        ]);
        /// `Some("")`
        pub const CONTACT: Option<&str> = Some("");
        /// `Some("2003-07-05")`
        pub const DATE: Option<&str> = Some("2003-07-05");
        /// `Some("locales@geez.org")`
        pub const EMAIL: Option<&str> = Some("locales@geez.org");
        /// `Some("")`
        pub const FAX: Option<&str> = Some("");
        /// `Some("Afar")`
        pub const LANGUAGE: Option<&str> = Some("Afar");
        /// `Some("0.20")`
        pub const REVISION: Option<&str> = Some("0.20");
        /// `Some("Ge'ez Frontier Foundation")`
        pub const SOURCE: Option<&str> = Some("Ge'ez Frontier Foundation");
        /// `Some("")`
        pub const TEL: Option<&str> = Some("");
        /// `Some("Eritrea")`
        pub const TERRITORY: Option<&str> = Some("Eritrea");
        /// `Some("Afar language locale for Eritrea (Cadu/Laaqo Dialects).")`
        pub const TITLE: Option<&str> = Some("Afar language locale for Eritrea (Cadu/Laaqo Dialects).");
    }
    pub use super::aa_ET::LC_MESSAGES;
    pub use super::ti_ER::LC_MONETARY;
    pub use super::ti_ER::LC_NUMERIC;
    pub use super::ti_ER::LC_TELEPHONE;
    pub mod LC_TIME {
        /// `&["Aca", "Etl", "Tal", "Arb", "Kam", "Gum", "Sab"]`
        pub const ABDAY: &[&str] = &["Aca", "Etl", "Tal", "Arb", "Kam", "Gum", "Sab"];
        /// `&["Qun", "Nah", "Cig", "Agd", "Cax", "Qas", "Qad", "Leq", "Way", "Dit", "Xim", "Kax"]`
        pub const ABMON: &[&str] = &["Qun", "Nah", "Cig", "Agd", "Cax", "Qas", "Qad", "Leq", "Way", "Dit", "Xim", "Kax"];
        /// `None`
        pub const AB_ALT_MON: Option<&[&str]> = None;
        /// `None`
        pub const ALT_DIGITS: Option<&[&str]> = None;
        /// `None`
        pub const ALT_MON: Option<&[&str]> = None;
        /// `&["saaku", "carra"]`
        pub const AM_PM: &[&str] = &["saaku", "carra"];
        /// `None`
        pub const CAL_DIRECTION: Option<i64> = None;
        /// `Some("%A, %B %e, %r %Z %Y")`
        pub const DATE_FMT: Option<&str> = Some("%A, %B %e, %r %Z %Y");
        /// `&["Acaada", "Etleeni", "Talaata", "Arbaqa", "Kamiisi", "Gumqata", "Sabti"]`
        pub const DAY: &[&str] = &["Acaada", "Etleeni", "Talaata", "Arbaqa", "Kamiisi", "Gumqata", "Sabti"];
        /// `"%d/%m/%Y"`
        pub const D_FMT: &str = "%d/%m/%Y";
        /// `"%A, %B %e, %Y %l:%M:%S %p %Z"`
        pub const D_T_FMT: &str = "%A, %B %e, %Y %l:%M:%S %p %Z";
        /// `None`
        pub const ERA: Option<&[&str]> = None;
        /// `None`
        pub const ERA_D_FMT: Option<&str> = None;
        /// `None`
        pub const ERA_D_T_FMT: Option<&str> = None;
        /// `None`
        pub const ERA_T_FMT: Option<&str> = None;
        /// `Some(2)`
        pub const FIRST_WEEKDAY: Option<i64> = Some(2);
        /// `None`
        pub const FIRST_WORKDAY: Option<i64> = None;
        /// `&["Qunxa Garablu", "Naharsi Kudo", "Ciggilta Kudo", "Agda Baxis", "Caxah Alsa", "Qasa Dirri", "Qado Dirri", "Liiqen", "Waysu", "Diteli", "Ximoli", "Kaxxa Garablu"]`
        pub const MON: &[&str] = &["Qunxa Garablu", "Naharsi Kudo", "Ciggilta Kudo", "Agda Baxis", "Caxah Alsa", "Qasa Dirri", "Qado Dirri", "Liiqen", "Waysu", "Diteli", "Ximoli", "Kaxxa Garablu"];
        /// `"%l:%M:%S %p"`
        pub const T_FMT: &str = "%l:%M:%S %p";
        /// `"%l:%M:%S %p"`
        pub const T_FMT_AMPM: &str = "%l:%M:%S %p";
        /// `Some(&[7, 19971130, 1])`
        pub const WEEK: Option<&[i64]> = Some(&[7, 19971130, 1]);
    }
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod aa_ER_saaho {
    pub use super::aa_ER::LC_ADDRESS;
    pub mod LC_IDENTIFICATION {
        /// `None`
        pub const ABBREVIATION: Option<&str> = None;
        /// `Some("7802 Solomon Seal Dr., Springfield, VA 22152, USA")`
        pub const ADDRESS: Option<&str> = Some("7802 Solomon Seal Dr., Springfield, VA 22152, USA");
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_TIME"],
        /// ]
        /// ```
        pub const CATEGORY: Option<&[&[&str]]> = Some(&[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_MEASUREMENT"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_TELEPHONE"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_TIME"],
        ]);
        /// `Some("")`
        pub const CONTACT: Option<&str> = Some("");
        /// `Some("2003-07-05")`
        pub const DATE: Option<&str> = Some("2003-07-05");
        /// `Some("locales@geez.org")`
        pub const EMAIL: Option<&str> = Some("locales@geez.org");
        /// `Some("")`
        pub const FAX: Option<&str> = Some("");
        /// `Some("Afar")`
        pub const LANGUAGE: Option<&str> = Some("Afar");
        /// `Some("0.20")`
        pub const REVISION: Option<&str> = Some("0.20");
        /// `Some("Ge'ez Frontier Foundation")`
        pub const SOURCE: Option<&str> = Some("Ge'ez Frontier Foundation");
        /// `Some("")`
        pub const TEL: Option<&str> = Some("");
        /// `Some("Eritrea")`
        pub const TERRITORY: Option<&str> = Some("Eritrea");
        /// `Some("Afar language locale for Eritrea (Saaho Dialect).")`
        pub const TITLE: Option<&str> = Some("Afar language locale for Eritrea (Saaho Dialect).");
    }
    pub use super::aa_ET::LC_MESSAGES;
    pub use super::aa_ER::LC_MONETARY;
    pub use super::aa_ER::LC_NUMERIC;
    pub use super::aa_ER::LC_TELEPHONE;
    pub mod LC_TIME {
        /// `&["Nab", "San", "Sal", "Rab", "Cam", "Jum", "Qun"]`
        pub const ABDAY: &[&str] = &["Nab", "San", "Sal", "Rab", "Cam", "Jum", "Qun"];
        /// `&["Qun", "Nah", "Cig", "Agd", "Cax", "Qas", "Qad", "Leq", "Way", "Dit", "Xim", "Kax"]`
        pub const ABMON: &[&str] = &["Qun", "Nah", "Cig", "Agd", "Cax", "Qas", "Qad", "Leq", "Way", "Dit", "Xim", "Kax"];
        /// `None`
        pub const AB_ALT_MON: Option<&[&str]> = None;
        /// `None`
        pub const ALT_DIGITS: Option<&[&str]> = None;
        /// `None`
        pub const ALT_MON: Option<&[&str]> = None;
        /// `&["saaku", "carra"]`
        pub const AM_PM: &[&str] = &["saaku", "carra"];
        /// `None`
        pub const CAL_DIRECTION: Option<i64> = None;
        /// `Some("%A, %B %e, %r %Z %Y")`
        pub const DATE_FMT: Option<&str> = Some("%A, %B %e, %r %Z %Y");
        /// `&["Naba Sambat", "Sani", "Salus", "Rabuq", "Camus", "Jumqata", "Qunxa Sambat"]`
        pub const DAY: &[&str] = &["Naba Sambat", "Sani", "Salus", "Rabuq", "Camus", "Jumqata", "Qunxa Sambat"];
        /// `"%d/%m/%Y"`
        pub const D_FMT: &str = "%d/%m/%Y";
        /// `"%A, %B %e, %Y %l:%M:%S %p %Z"`
        pub const D_T_FMT: &str = "%A, %B %e, %Y %l:%M:%S %p %Z";
        /// `None`
        pub const ERA: Option<&[&str]> = None;
        /// `None`
        pub const ERA_D_FMT: Option<&str> = None;
        /// `None`
        pub const ERA_D_T_FMT: Option<&str> = None;
        /// `None`
        pub const ERA_T_FMT: Option<&str> = None;
        /// `Some(2)`
        pub const FIRST_WEEKDAY: Option<i64> = Some(2);
        /// `None`
        pub const FIRST_WORKDAY: Option<i64> = None;
        /// `&["Qunxa Garablu", "Naharsi Kudo", "Ciggilta Kudo", "Agda Baxis", "Caxah Alsa", "Qasa Dirri", "Qado Dirri", "Liiqen", "Waysu", "Diteli", "Ximoli", "Kaxxa Garablu"]`
        pub const MON: &[&str] = &["Qunxa Garablu", "Naharsi Kudo", "Ciggilta Kudo", "Agda Baxis", "Caxah Alsa", "Qasa Dirri", "Qado Dirri", "Liiqen", "Waysu", "Diteli", "Ximoli", "Kaxxa Garablu"];
        /// `"%l:%M:%S %p"`
        pub const T_FMT: &str = "%l:%M:%S %p";
        /// `"%l:%M:%S %p"`
        pub const T_FMT_AMPM: &str = "%l:%M:%S %p";
        /// `Some(&[7, 19971130, 1])`
        pub const WEEK: Option<&[i64]> = Some(&[7, 19971130, 1]);
    }
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod aa_ET {
    pub mod LC_ADDRESS {
        /// `Some("ETH")`
        pub const COUNTRY_AB3: Option<&str> = Some("ETH");
        /// `Some("ET")`
        pub const COUNTRY_ABTWO: Option<&str> = Some("ET");
        /// `Some("ETH")`
        pub const COUNTRY_CAR: Option<&str> = Some("ETH");
        /// `None`
        pub const COUNTRY_ISBN: Option<&str> = None;
        /// `Some("Otobbia")`
        pub const COUNTRY_NAME: Option<&str> = Some("Otobbia");
        /// `Some(231)`
        pub const COUNTRY_NUM: Option<i64> = Some(231);
        /// `Some("ETH")`
        pub const COUNTRY_POST: Option<&str> = Some("ETH");
        /// `Some("aa")`
        pub const LANG_AB: Option<&str> = Some("aa");
        /// `Some("aar")`
        pub const LANG_LIB: Option<&str> = Some("aar");
        /// `Some("Qafar")`
        pub const LANG_NAME: Option<&str> = Some("Qafar");
        /// `Some("aar")`
        pub const LANG_TERM: Option<&str> = Some("aar");
        /// `Some("%z%c%T%s%b%e%r")`
        pub const POSTAL_FMT: Option<&str> = Some("%z%c%T%s%b%e%r");
    }
    pub mod LC_IDENTIFICATION {
        /// `None`
        pub const ABBREVIATION: Option<&str> = None;
        /// `Some("7802 Solomon Seal Dr., Springfield, VA 22152, USA")`
        pub const ADDRESS: Option<&str> = Some("7802 Solomon Seal Dr., Springfield, VA 22152, USA");
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_TIME"],
        /// ]
        /// ```
        pub const CATEGORY: Option<&[&[&str]]> = Some(&[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_MEASUREMENT"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_TELEPHONE"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_TIME"],
        ]);
        /// `Some("")`
        pub const CONTACT: Option<&str> = Some("");
        /// `Some("2003-07-05")`
        pub const DATE: Option<&str> = Some("2003-07-05");
        /// `Some("locales@geez.org")`
        pub const EMAIL: Option<&str> = Some("locales@geez.org");
        /// `Some("")`
        pub const FAX: Option<&str> = Some("");
        /// `Some("Afar")`
        pub const LANGUAGE: Option<&str> = Some("Afar");
        /// `Some("0.20")`
        pub const REVISION: Option<&str> = Some("0.20");
        /// `Some("Ge'ez Frontier Foundation")`
        pub const SOURCE: Option<&str> = Some("Ge'ez Frontier Foundation");
        /// `Some("")`
        pub const TEL: Option<&str> = Some("");
        /// `Some("Ethiopia")`
        pub const TERRITORY: Option<&str> = Some("Ethiopia");
        /// `Some("Afar language locale for Ethiopia (Cadu/Carra Dialects).")`
        pub const TITLE: Option<&str> = Some("Afar language locale for Ethiopia (Cadu/Carra Dialects).");
    }
    pub mod LC_MESSAGES {
        /// `"^[-0mnMN]"`
        pub const NOEXPR: &str = "^[-0mnMN]";
        /// `Some("Maleey")`
        pub const NOSTR: Option<&str> = Some("Maleey");
        /// `"^[+1yY]"`
        pub const YESEXPR: &str = "^[+1yY]";
        /// `Some("Yeey")`
        pub const YESSTR: Option<&str> = Some("Yeey");
    }
    pub use super::ti_ET::LC_MONETARY;
    pub use super::ti_ET::LC_NUMERIC;
    pub use super::ti_ET::LC_TELEPHONE;
    pub mod LC_TIME {
        /// `&["Aca", "Etl", "Tal", "Arb", "Kam", "Gum", "Sab"]`
        pub const ABDAY: &[&str] = &["Aca", "Etl", "Tal", "Arb", "Kam", "Gum", "Sab"];
        /// `&["Qun", "Nah", "Cig", "Agd", "Cax", "Qas", "Qad", "Leq", "Way", "Dit", "Xim", "Kax"]`
        pub const ABMON: &[&str] = &["Qun", "Nah", "Cig", "Agd", "Cax", "Qas", "Qad", "Leq", "Way", "Dit", "Xim", "Kax"];
        /// `None`
        pub const AB_ALT_MON: Option<&[&str]> = None;
        /// `None`
        pub const ALT_DIGITS: Option<&[&str]> = None;
        /// `None`
        pub const ALT_MON: Option<&[&str]> = None;
        /// `&["saaku", "carra"]`
        pub const AM_PM: &[&str] = &["saaku", "carra"];
        /// `None`
        pub const CAL_DIRECTION: Option<i64> = None;
        /// `Some("%A, %B %e, %r %Z %Y")`
        pub const DATE_FMT: Option<&str> = Some("%A, %B %e, %r %Z %Y");
        /// `&["Acaada", "Etleeni", "Talaata", "Arbaqa", "Kamiisi", "Gumqata", "Sabti"]`
        pub const DAY: &[&str] = &["Acaada", "Etleeni", "Talaata", "Arbaqa", "Kamiisi", "Gumqata", "Sabti"];
        /// `"%d/%m/%Y"`
        pub const D_FMT: &str = "%d/%m/%Y";
        /// `"%A, %B %e, %Y %l:%M:%S %p %Z"`
        pub const D_T_FMT: &str = "%A, %B %e, %Y %l:%M:%S %p %Z";
        /// `None`
        pub const ERA: Option<&[&str]> = None;
        /// `None`
        pub const ERA_D_FMT: Option<&str> = None;
        /// `None`
        pub const ERA_D_T_FMT: Option<&str> = None;
        /// `None`
        pub const ERA_T_FMT: Option<&str> = None;
        /// `None`
        pub const FIRST_WEEKDAY: Option<i64> = None;
        /// `None`
        pub const FIRST_WORKDAY: Option<i64> = None;
        /// `&["Qunxa Garablu", "Naharsi Kudo", "Ciggilta Kudo", "Agda Baxis", "Caxah Alsa", "Qasa Dirri", "Qado Dirri", "Liiqen", "Waysu", "Diteli", "Ximoli", "Kaxxa Garablu"]`
        pub const MON: &[&str] = &["Qunxa Garablu", "Naharsi Kudo", "Ciggilta Kudo", "Agda Baxis", "Caxah Alsa", "Qasa Dirri", "Qado Dirri", "Liiqen", "Waysu", "Diteli", "Ximoli", "Kaxxa Garablu"];
        /// `"%l:%M:%S %p"`
        pub const T_FMT: &str = "%l:%M:%S %p";
        /// `"%l:%M:%S %p"`
        pub const T_FMT_AMPM: &str = "%l:%M:%S %p";
        /// `Some(&[7, 19971130, 1])`
        pub const WEEK: Option<&[i64]> = Some(&[7, 19971130, 1]);
    }
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod af_ZA {
    pub mod LC_ADDRESS {
        /// `Some("ZAF")`
        pub const COUNTRY_AB3: Option<&str> = Some("ZAF");
        /// `Some("ZA")`
        pub const COUNTRY_ABTWO: Option<&str> = Some("ZA");
        /// `Some("ZA")`
        pub const COUNTRY_CAR: Option<&str> = Some("ZA");
        /// `Some("0")`
        pub const COUNTRY_ISBN: Option<&str> = Some("0");
        /// `Some("Suid-Afrika")`
        pub const COUNTRY_NAME: Option<&str> = Some("Suid-Afrika");
        /// `Some(710)`
        pub const COUNTRY_NUM: Option<i64> = Some(710);
        /// `Some("ZA")`
        pub const COUNTRY_POST: Option<&str> = Some("ZA");
        /// `Some("af")`
        pub const LANG_AB: Option<&str> = Some("af");
        /// `Some("afr")`
        pub const LANG_LIB: Option<&str> = Some("afr");
        /// `Some("Afrikaans")`
        pub const LANG_NAME: Option<&str> = Some("Afrikaans");
        /// `Some("afr")`
        pub const LANG_TERM: Option<&str> = Some("afr");
        /// `Some("%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%c%N")`
        pub const POSTAL_FMT: Option<&str> = Some("%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%c%N");
    }
    pub mod LC_IDENTIFICATION {
        /// `None`
        pub const ABBREVIATION: Option<&str> = None;
        /// `Some("Box 28364, Sunnyside, 0132, South Africa")`
        pub const ADDRESS: Option<&str> = Some("Box 28364, Sunnyside, 0132, South Africa");
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        /// ]
        /// ```
        pub const CATEGORY: Option<&[&[&str]]> = Some(&[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_TELEPHONE"],
            &["i18n:2012", "LC_MEASUREMENT"],
        ]);
        /// `Some("Dwayne Bailey")`
        pub const CONTACT: Option<&str> = Some("Dwayne Bailey");
        /// `Some("2005-10-13")`
        pub const DATE: Option<&str> = Some("2005-10-13");
        /// `Some("dwayne@translate.org.za")`
        pub const EMAIL: Option<&str> = Some("dwayne@translate.org.za");
        /// `Some("")`
        pub const FAX: Option<&str> = Some("");
        /// `Some("Afrikaans")`
        pub const LANGUAGE: Option<&str> = Some("Afrikaans");
        /// `Some("1.2.1")`
        pub const REVISION: Option<&str> = Some("1.2.1");
        /// `Some("Zuza Software Foundation (Translate.org.za)")`
        pub const SOURCE: Option<&str> = Some("Zuza Software Foundation (Translate.org.za)");
        /// `Some("")`
        pub const TEL: Option<&str> = Some("");
        /// `Some("South Africa")`
        pub const TERRITORY: Option<&str> = Some("South Africa");
        /// `Some("Afrikaans locale for South Africa")`
        pub const TITLE: Option<&str> = Some("Afrikaans locale for South Africa");
    }
    pub mod LC_MESSAGES {
        /// `"^[-0nN]"`
        pub const NOEXPR: &str = "^[-0nN]";
        /// `Some("nee")`
        pub const NOSTR: Option<&str> = Some("nee");
        /// `"^[+1jJyY]"`
        pub const YESEXPR: &str = "^[+1jJyY]";
        /// `Some("ja")`
        pub const YESSTR: Option<&str> = Some("ja");
    }
    pub use super::en_ZA::LC_MONETARY;
    pub use super::en_ZA::LC_NUMERIC;
    pub use super::en_ZA::LC_TELEPHONE;
    pub mod LC_TIME {
        /// `&["So", "Ma", "Di", "Wo", "Do", "Vr", "Sa"]`
        pub const ABDAY: &[&str] = &["So", "Ma", "Di", "Wo", "Do", "Vr", "Sa"];
        /// `&["Jan", "Feb", "Mrt", "Apr", "Mei", "Jun", "Jul", "Aug", "Sep", "Okt", "Nov", "Des"]`
        pub const ABMON: &[&str] = &["Jan", "Feb", "Mrt", "Apr", "Mei", "Jun", "Jul", "Aug", "Sep", "Okt", "Nov", "Des"];
        /// `None`
        pub const AB_ALT_MON: Option<&[&str]> = None;
        /// `None`
        pub const ALT_DIGITS: Option<&[&str]> = None;
        /// `None`
        pub const ALT_MON: Option<&[&str]> = None;
        /// `&["VM", "NM"]`
        pub const AM_PM: &[&str] = &["VM", "NM"];
        /// `None`
        pub const CAL_DIRECTION: Option<i64> = None;
        /// `None`
        pub const DATE_FMT: Option<&str> = None;
        /// `&["Sondag", "Maandag", "Dinsdag", "Woensdag", "Donderdag", "Vrydag", "Saterdag"]`
        pub const DAY: &[&str] = &["Sondag", "Maandag", "Dinsdag", "Woensdag", "Donderdag", "Vrydag", "Saterdag"];
        /// `"%d/%m/%Y"`
        pub const D_FMT: &str = "%d/%m/%Y";
        /// `"%a %d %b %Y %T %Z"`
        pub const D_T_FMT: &str = "%a %d %b %Y %T %Z";
        /// `None`
        pub const ERA: Option<&[&str]> = None;
        /// `None`
        pub const ERA_D_FMT: Option<&str> = None;
        /// `None`
        pub const ERA_D_T_FMT: Option<&str> = None;
        /// `None`
        pub const ERA_T_FMT: Option<&str> = None;
        /// `None`
        pub const FIRST_WEEKDAY: Option<i64> = None;
        /// `None`
        pub const FIRST_WORKDAY: Option<i64> = None;
        /// `&["Januarie", "Februarie", "Maart", "April", "Mei", "Junie", "Julie", "Augustus", "September", "Oktober", "November", "Desember"]`
        pub const MON: &[&str] = &["Januarie", "Februarie", "Maart", "April", "Mei", "Junie", "Julie", "Augustus", "September", "Oktober", "November", "Desember"];
        /// `"%T"`
        pub const T_FMT: &str = "%T";
        /// `"%l:%M:%S %p"`
        pub const T_FMT_AMPM: &str = "%l:%M:%S %p";
        /// `Some(&[7, 19971130, 1])`
        pub const WEEK: Option<&[i64]> = Some(&[7, 19971130, 1]);
    }
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod agr_PE {
    pub mod LC_ADDRESS {
        /// `Some("PER")`
        pub const COUNTRY_AB3: Option<&str> = Some("PER");
        /// `Some("PE")`
        pub const COUNTRY_ABTWO: Option<&str> = Some("PE");
        /// `Some("PE")`
        pub const COUNTRY_CAR: Option<&str> = Some("PE");
        /// `None`
        pub const COUNTRY_ISBN: Option<&str> = None;
        /// `Some("Perú")`
        pub const COUNTRY_NAME: Option<&str> = Some("Perú");
        /// `Some(604)`
        pub const COUNTRY_NUM: Option<i64> = Some(604);
        /// `None`
        pub const COUNTRY_POST: Option<&str> = None;
        /// `Some("")`
        pub const LANG_AB: Option<&str> = Some("");
        /// `Some("agr")`
        pub const LANG_LIB: Option<&str> = Some("agr");
        /// `Some("Awajún")`
        pub const LANG_NAME: Option<&str> = Some("Awajún");
        /// `Some("")`
        pub const LANG_TERM: Option<&str> = Some("");
        /// `Some("%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%c%N")`
        pub const POSTAL_FMT: Option<&str> = Some("%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%c%N");
    }
    pub mod LC_IDENTIFICATION {
        /// `None`
        pub const ABBREVIATION: Option<&str> = None;
        /// `Some("")`
        pub const ADDRESS: Option<&str> = Some("");
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        /// ]
        /// ```
        pub const CATEGORY: Option<&[&[&str]]> = Some(&[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_MEASUREMENT"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_TELEPHONE"],
        ]);
        /// `Some("")`
        pub const CONTACT: Option<&str> = Some("");
        /// `Some("2016-08-20")`
        pub const DATE: Option<&str> = Some("2016-08-20");
        /// `Some("libc-alpha@sourceware.org")`
        pub const EMAIL: Option<&str> = Some("libc-alpha@sourceware.org");
        /// `Some("")`
        pub const FAX: Option<&str> = Some("");
        /// `Some("Aguaruna")`
        pub const LANGUAGE: Option<&str> = Some("Aguaruna");
        /// `Some("1.0")`
        pub const REVISION: Option<&str> = Some("1.0");
        /// `Some("somosazucar.org")`
        pub const SOURCE: Option<&str> = Some("somosazucar.org");
        /// `Some("")`
        pub const TEL: Option<&str> = Some("");
        /// `Some("Peru")`
        pub const TERRITORY: Option<&str> = Some("Peru");
        /// `Some("Awajún (agr) locale for Peru")`
        pub const TITLE: Option<&str> = Some("Awajún (agr) locale for Peru");
    }
    pub mod LC_MESSAGES {
        /// `"^[-0aAnN]"`
        pub const NOEXPR: &str = "^[-0aAnN]";
        /// `Some("atsa")`
        pub const NOSTR: Option<&str> = Some("atsa");
        /// `"^[+1eEsSyY]"`
        pub const YESEXPR: &str = "^[+1eEsSyY]";
        /// `Some("ehe")`
        pub const YESSTR: Option<&str> = Some("ehe");
    }
    pub use super::es_PE::LC_MONETARY;
    pub use super::es_PE::LC_NUMERIC;
    pub use super::es_PE::LC_TELEPHONE;
    pub mod LC_TIME {
        /// `&["Tun", "Ach", "Kug", "Sak", "Shim", "Im", "Bat"]`
        pub const ABDAY: &[&str] = &["Tun", "Ach", "Kug", "Sak", "Shim", "Im", "Bat"];
        /// `&["Pet", "Kup", "Uya", "Tay", "Keg", "Teg", "Kun", "Yag", "Dait", "Ipam", "Shin", "Sak"]`
        pub const ABMON: &[&str] = &["Pet", "Kup", "Uya", "Tay", "Keg", "Teg", "Kun", "Yag", "Dait", "Ipam", "Shin", "Sak"];
        /// `None`
        pub const AB_ALT_MON: Option<&[&str]> = None;
        /// `None`
        pub const ALT_DIGITS: Option<&[&str]> = None;
        /// `None`
        pub const ALT_MON: Option<&[&str]> = None;
        /// `&["VM", "NM"]`
        pub const AM_PM: &[&str] = &["VM", "NM"];
        /// `None`
        pub const CAL_DIRECTION: Option<i64> = None;
        /// `Some("%a %b %e %H:%M:%S %Z %Y")`
        pub const DATE_FMT: Option<&str> = Some("%a %b %e %H:%M:%S %Z %Y");
        /// `&["Tuntuamtin", "Achutin", "Kugkuktin", "Saketin", "Shimpitin", "Imaptin", "Bataetin"]`
        pub const DAY: &[&str] = &["Tuntuamtin", "Achutin", "Kugkuktin", "Saketin", "Shimpitin", "Imaptin", "Bataetin"];
        /// `"%d/%m/%y"`
        pub const D_FMT: &str = "%d/%m/%y";
        /// `"%a %d %b %Y %T %Z"`
        pub const D_T_FMT: &str = "%a %d %b %Y %T %Z";
        /// `None`
        pub const ERA: Option<&[&str]> = None;
        /// `None`
        pub const ERA_D_FMT: Option<&str> = None;
        /// `None`
        pub const ERA_D_T_FMT: Option<&str> = None;
        /// `None`
        pub const ERA_T_FMT: Option<&str> = None;
        /// `Some(1)`
        pub const FIRST_WEEKDAY: Option<i64> = Some(1);
        /// `Some(2)`
        pub const FIRST_WORKDAY: Option<i64> = Some(2);
        /// `&["Petsatin", "Kupitin", "Uyaitin", "Tayutin", "Kegketin", "Tegmatin", "Kuntutin", "Yagkujutin", "Daiktatin", "Ipamtatin", "Shinutin", "Sakamtin"]`
        pub const MON: &[&str] = &["Petsatin", "Kupitin", "Uyaitin", "Tayutin", "Kegketin", "Tegmatin", "Kuntutin", "Yagkujutin", "Daiktatin", "Ipamtatin", "Shinutin", "Sakamtin"];
        /// `"%T"`
        pub const T_FMT: &str = "%T";
        /// `"%I:%M:%S %p"`
        pub const T_FMT_AMPM: &str = "%I:%M:%S %p";
        /// `Some(&[7, 19971130, 7])`
        pub const WEEK: Option<&[i64]> = Some(&[7, 19971130, 7]);
    }
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod ak_GH {
    pub mod LC_ADDRESS {
        /// `Some("GHA")`
        pub const COUNTRY_AB3: Option<&str> = Some("GHA");
        /// `Some("GH")`
        pub const COUNTRY_ABTWO: Option<&str> = Some("GH");
        /// `Some("GH")`
        pub const COUNTRY_CAR: Option<&str> = Some("GH");
        /// `Some("9964")`
        pub const COUNTRY_ISBN: Option<&str> = Some("9964");
        /// `Some("Gaana")`
        pub const COUNTRY_NAME: Option<&str> = Some("Gaana");
        /// `Some(288)`
        pub const COUNTRY_NUM: Option<i64> = Some(288);
        /// `Some("GH")`
        pub const COUNTRY_POST: Option<&str> = Some("GH");
        /// `Some("ak")`
        pub const LANG_AB: Option<&str> = Some("ak");
        /// `None`
        pub const LANG_LIB: Option<&str> = None;
        /// `Some("Akan")`
        pub const LANG_NAME: Option<&str> = Some("Akan");
        /// `Some("aka")`
        pub const LANG_TERM: Option<&str> = Some("aka");
        /// `Some("%a%N%f%N%d%N%b%N%h %s %e %r%N%T, %S %z%N%c%N")`
        pub const POSTAL_FMT: Option<&str> = Some("%a%N%f%N%d%N%b%N%h %s %e %r%N%T, %S %z%N%c%N");
    }
    pub mod LC_IDENTIFICATION {
        /// `None`
        pub const ABBREVIATION: Option<&str> = None;
        /// `Some("")`
        pub const ADDRESS: Option<&str> = Some("");
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        /// ]
        /// ```
        pub const CATEGORY: Option<&[&[&str]]> = Some(&[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_MEASUREMENT"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_TELEPHONE"],
        ]);
        /// `Some("sugarlabs.org")`
        pub const CONTACT: Option<&str> = Some("sugarlabs.org");
        /// `Some("2013-08-24")`
        pub const DATE: Option<&str> = Some("2013-08-24");
        /// `Some("libc-alpha@sourceware.org")`
        pub const EMAIL: Option<&str> = Some("libc-alpha@sourceware.org");
        /// `Some("")`
        pub const FAX: Option<&str> = Some("");
        /// `Some("Akan")`
        pub const LANGUAGE: Option<&str> = Some("Akan");
        /// `Some("1.0")`
        pub const REVISION: Option<&str> = Some("1.0");
        /// `Some("Sugar Labs / OLPC")`
        pub const SOURCE: Option<&str> = Some("Sugar Labs / OLPC");
        /// `Some("")`
        pub const TEL: Option<&str> = Some("");
        /// `Some("Ghana")`
        pub const TERRITORY: Option<&str> = Some("Ghana");
        /// `Some("Akan locale for Ghana")`
        pub const TITLE: Option<&str> = Some("Akan locale for Ghana");
    }
    pub mod LC_MESSAGES {
        /// `"^[-0dDnN]"`
        pub const NOEXPR: &str = "^[-0dDnN]";
        /// `Some("Daabi")`
        pub const NOSTR: Option<&str> = Some("Daabi");
        /// `"^[+1yY]"`
        pub const YESEXPR: &str = "^[+1yY]";
        /// `Some("Yiw")`
        pub const YESSTR: Option<&str> = Some("Yiw");
    }
    pub mod LC_MONETARY {
        /// `"GH₵"`
        pub const CURRENCY_SYMBOL: &str = "GH₵";
        /// `2`
        pub const FRAC_DIGITS: i64 = 2;
        /// `"GHS "`
        pub const INT_CURR_SYMBOL: &str = "GHS ";
        /// `2`
        pub const INT_FRAC_DIGITS: i64 = 2;
        /// `None`
        pub const INT_N_CS_PRECEDES: Option<i64> = None;
        /// `None`
        pub const INT_N_SEP_BY_SPACE: Option<i64> = None;
        /// `None`
        pub const INT_N_SIGN_POSN: Option<i64> = None;
        /// `None`
        pub const INT_P_CS_PRECEDES: Option<i64> = None;
        /// `None`
        pub const INT_P_SEP_BY_SPACE: Option<i64> = None;
        /// `None`
        pub const INT_P_SIGN_POSN: Option<i64> = None;
        /// `"."`
        pub const MON_DECIMAL_POINT: &str = ".";
        /// `&[3]`
        pub const MON_GROUPING: &[i64] = &[3];
        /// `","`
        pub const MON_THOUSANDS_SEP: &str = ",";
        /// `"-"`
        pub const NEGATIVE_SIGN: &str = "-";
        /// `0`
        pub const N_CS_PRECEDES: i64 = 0;
        /// `1`
        pub const N_SEP_BY_SPACE: i64 = 1;
        /// `1`
        pub const N_SIGN_POSN: i64 = 1;
        /// `""`
        pub const POSITIVE_SIGN: &str = "";
        /// `0`
        pub const P_CS_PRECEDES: i64 = 0;
        /// `1`
        pub const P_SEP_BY_SPACE: i64 = 1;
        /// `1`
        pub const P_SIGN_POSN: i64 = 1;
    }
    pub mod LC_NUMERIC {
        /// `"."`
        pub const DECIMAL_POINT: &str = ".";
        /// `&[3]`
        pub const GROUPING: &[i64] = &[3];
        /// `","`
        pub const THOUSANDS_SEP: &str = ",";
    }
    pub mod LC_TELEPHONE {
        /// `Some("233")`
        pub const INT_PREFIX: Option<&str> = Some("233");
        /// `Some("00")`
        pub const INT_SELECT: Option<&str> = Some("00");
        /// `Some("%a %l")`
        pub const TEL_DOM_FMT: Option<&str> = Some("%a %l");
        /// `Some("+%c %a %l")`
        pub const TEL_INT_FMT: Option<&str> = Some("+%c %a %l");
    }
    pub mod LC_TIME {
        /// `&["Kwe", "Dwo", "Ben", "Wuk", "Yaw", "Fia", "Mem"]`
        pub const ABDAY: &[&str] = &["Kwe", "Dwo", "Ben", "Wuk", "Yaw", "Fia", "Mem"];
        /// `&["S-Ɔ", "K-Ɔ", "E-Ɔ", "E-O", "E-K", "O-A", "A-K", "D-Ɔ", "F-Ɛ", "Ɔ-A", "Ɔ-O", "M-Ɔ"]`
        pub const ABMON: &[&str] = &["S-Ɔ", "K-Ɔ", "E-Ɔ", "E-O", "E-K", "O-A", "A-K", "D-Ɔ", "F-Ɛ", "Ɔ-A", "Ɔ-O", "M-Ɔ"];
        /// `None`
        pub const AB_ALT_MON: Option<&[&str]> = None;
        /// `None`
        pub const ALT_DIGITS: Option<&[&str]> = None;
        /// `None`
        pub const ALT_MON: Option<&[&str]> = None;
        /// `&["AN", "EW"]`
        pub const AM_PM: &[&str] = &["AN", "EW"];
        /// `None`
        pub const CAL_DIRECTION: Option<i64> = None;
        /// `None`
        pub const DATE_FMT: Option<&str> = None;
        /// `&["Kwesida", "Dwowda", "Benada", "Wukuda", "Yawda", "Fida", "Memeneda"]`
        pub const DAY: &[&str] = &["Kwesida", "Dwowda", "Benada", "Wukuda", "Yawda", "Fida", "Memeneda"];
        /// `"%Y/%m/%d"`
        pub const D_FMT: &str = "%Y/%m/%d";
        /// `"%a %d %b %Y %T %Z"`
        pub const D_T_FMT: &str = "%a %d %b %Y %T %Z";
        /// `None`
        pub const ERA: Option<&[&str]> = None;
        /// `None`
        pub const ERA_D_FMT: Option<&str> = None;
        /// `None`
        pub const ERA_D_T_FMT: Option<&str> = None;
        /// `None`
        pub const ERA_T_FMT: Option<&str> = None;
        /// `Some(2)`
        pub const FIRST_WEEKDAY: Option<i64> = Some(2);
        /// `None`
        pub const FIRST_WORKDAY: Option<i64> = None;
        /// `&["Sanda-Ɔpɛpɔn", "Kwakwar-Ɔgyefuo", "Ebɔw-Ɔbenem", "Ebɔbira-Oforisuo", "Esusow Aketseaba-Kɔtɔnimba", "Obirade-Ayɛwohomumu", "Ayɛwoho-Kitawonsa", "Difuu-Ɔsandaa", "Fankwa-Ɛbɔ", "Ɔbɛsɛ-Ahinime", "Ɔberɛfɛw-Obubuo", "Mumu-Ɔpɛnimba"]`
        pub const MON: &[&str] = &["Sanda-Ɔpɛpɔn", "Kwakwar-Ɔgyefuo", "Ebɔw-Ɔbenem", "Ebɔbira-Oforisuo", "Esusow Aketseaba-Kɔtɔnimba", "Obirade-Ayɛwohomumu", "Ayɛwoho-Kitawonsa", "Difuu-Ɔsandaa", "Fankwa-Ɛbɔ", "Ɔbɛsɛ-Ahinime", "Ɔberɛfɛw-Obubuo", "Mumu-Ɔpɛnimba"];
        /// `"%I:%M:%S %p"`
        pub const T_FMT: &str = "%I:%M:%S %p";
        /// `"%I:%M:%S %p"`
        pub const T_FMT_AMPM: &str = "%I:%M:%S %p";
        /// `Some(&[7, 19971130, 1])`
        pub const WEEK: Option<&[i64]> = Some(&[7, 19971130, 1]);
    }
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod am_ET {
    pub mod LC_ADDRESS {
        /// `Some("ETH")`
        pub const COUNTRY_AB3: Option<&str> = Some("ETH");
        /// `Some("ET")`
        pub const COUNTRY_ABTWO: Option<&str> = Some("ET");
        /// `Some("ETH")`
        pub const COUNTRY_CAR: Option<&str> = Some("ETH");
        /// `None`
        pub const COUNTRY_ISBN: Option<&str> = None;
        /// `Some("ኢትዮጵያ")`
        pub const COUNTRY_NAME: Option<&str> = Some("ኢትዮጵያ");
        /// `Some(231)`
        pub const COUNTRY_NUM: Option<i64> = Some(231);
        /// `Some("ETH")`
        pub const COUNTRY_POST: Option<&str> = Some("ETH");
        /// `Some("am")`
        pub const LANG_AB: Option<&str> = Some("am");
        /// `Some("amh")`
        pub const LANG_LIB: Option<&str> = Some("amh");
        /// `Some("አማርኛ")`
        pub const LANG_NAME: Option<&str> = Some("አማርኛ");
        /// `Some("amh")`
        pub const LANG_TERM: Option<&str> = Some("amh");
        /// `Some("%z%c%T%s%b%e%r")`
        pub const POSTAL_FMT: Option<&str> = Some("%z%c%T%s%b%e%r");
    }
    pub mod LC_IDENTIFICATION {
        /// `None`
        pub const ABBREVIATION: Option<&str> = None;
        /// `Some("7802 Solomon Seal Dr., Springfield, VA 22152, USA")`
        pub const ADDRESS: Option<&str> = Some("7802 Solomon Seal Dr., Springfield, VA 22152, USA");
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_TIME"],
        /// ]
        /// ```
        pub const CATEGORY: Option<&[&[&str]]> = Some(&[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_MEASUREMENT"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_TELEPHONE"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_TIME"],
        ]);
        /// `Some("")`
        pub const CONTACT: Option<&str> = Some("");
        /// `Some("2003-07-05")`
        pub const DATE: Option<&str> = Some("2003-07-05");
        /// `Some("locales@geez.org")`
        pub const EMAIL: Option<&str> = Some("locales@geez.org");
        /// `Some("")`
        pub const FAX: Option<&str> = Some("");
        /// `Some("Amharic")`
        pub const LANGUAGE: Option<&str> = Some("Amharic");
        /// `Some("0.20")`
        pub const REVISION: Option<&str> = Some("0.20");
        /// `Some("Ge'ez Frontier Foundation")`
        pub const SOURCE: Option<&str> = Some("Ge'ez Frontier Foundation");
        /// `Some("")`
        pub const TEL: Option<&str> = Some("");
        /// `Some("Ethiopia")`
        pub const TERRITORY: Option<&str> = Some("Ethiopia");
        /// `Some("Amharic language locale for Ethiopia.")`
        pub const TITLE: Option<&str> = Some("Amharic language locale for Ethiopia.");
    }
    pub mod LC_MESSAGES {
        /// `"^([-0nNይ]|አይ)"`
        pub const NOEXPR: &str = "^([-0nNይ]|አይ)";
        /// `Some("አይ")`
        pub const NOSTR: Option<&str> = Some("አይ");
        /// `"^([+1yYዎ]|አዎን)"`
        pub const YESEXPR: &str = "^([+1yYዎ]|አዎን)";
        /// `Some("አዎን")`
        pub const YESSTR: Option<&str> = Some("አዎን");
    }
    pub use super::ti_ET::LC_MONETARY;
    pub use super::ti_ET::LC_NUMERIC;
    pub use super::ti_ET::LC_TELEPHONE;
    pub mod LC_TIME {
        /// `&["እሑድ", "ሰኞ ", "ማክሰ", "ረቡዕ", "ሐሙስ", "ዓርብ", "ቅዳሜ"]`
        pub const ABDAY: &[&str] = &["እሑድ", "ሰኞ ", "ማክሰ", "ረቡዕ", "ሐሙስ", "ዓርብ", "ቅዳሜ"];
        /// `&["ጃንዩ", "ፌብሩ", "ማርች", "ኤፕረ", "ሜይ ", "ጁን ", "ጁላይ", "ኦገስ", "ሴፕቴ", "ኦክተ", "ኖቬም", "ዲሴም"]`
        pub const ABMON: &[&str] = &["ጃንዩ", "ፌብሩ", "ማርች", "ኤፕረ", "ሜይ ", "ጁን ", "ጁላይ", "ኦገስ", "ሴፕቴ", "ኦክተ", "ኖቬም", "ዲሴም"];
        /// `None`
        pub const AB_ALT_MON: Option<&[&str]> = None;
        /// `None`
        pub const ALT_DIGITS: Option<&[&str]> = None;
        /// `None`
        pub const ALT_MON: Option<&[&str]> = None;
        /// `&["ጡዋት", "ከሰዓት"]`
        pub const AM_PM: &[&str] = &["ጡዋት", "ከሰዓት"];
        /// `None`
        pub const CAL_DIRECTION: Option<i64> = None;
        /// `Some("%A፣ %B %e ቀን %r %Z %Y ዓ/ም")`
        pub const DATE_FMT: Option<&str> = Some("%A፣ %B %e ቀን %r %Z %Y ዓ/ም");
        /// `&["እሑድ", "ሰኞ", "ማክሰኞ", "ረቡዕ", "ሐሙስ", "ዓርብ", "ቅዳሜ"]`
        pub const DAY: &[&str] = &["እሑድ", "ሰኞ", "ማክሰኞ", "ረቡዕ", "ሐሙስ", "ዓርብ", "ቅዳሜ"];
        /// `"%d/%m/%Y"`
        pub const D_FMT: &str = "%d/%m/%Y";
        /// `"%A፣ %B %e ቀን %Y %l:%M:%S %p %Z"`
        pub const D_T_FMT: &str = "%A፣ %B %e ቀን %Y %l:%M:%S %p %Z";
        /// `None`
        pub const ERA: Option<&[&str]> = None;
        /// `None`
        pub const ERA_D_FMT: Option<&str> = None;
        /// `None`
        pub const ERA_D_T_FMT: Option<&str> = None;
        /// `None`
        pub const ERA_T_FMT: Option<&str> = None;
        /// `None`
        pub const FIRST_WEEKDAY: Option<i64> = None;
        /// `None`
        pub const FIRST_WORKDAY: Option<i64> = None;
        /// `&["ጃንዩወሪ", "ፌብሩወሪ", "ማርች", "ኤፕሪል", "ሜይ", "ጁን", "ጁላይ", "ኦገስት", "ሴፕቴምበር", "ኦክቶበር", "ኖቬምበር", "ዲሴምበር"]`
        pub const MON: &[&str] = &["ጃንዩወሪ", "ፌብሩወሪ", "ማርች", "ኤፕሪል", "ሜይ", "ጁን", "ጁላይ", "ኦገስት", "ሴፕቴምበር", "ኦክቶበር", "ኖቬምበር", "ዲሴምበር"];
        /// `"%l:%M:%S %p"`
        pub const T_FMT: &str = "%l:%M:%S %p";
        /// `"%l:%M:%S %p"`
        pub const T_FMT_AMPM: &str = "%l:%M:%S %p";
        /// `Some(&[7, 19971130, 1])`
        pub const WEEK: Option<&[i64]> = Some(&[7, 19971130, 1]);
    }
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod an_ES {
    pub mod LC_ADDRESS {
        /// `Some("ESP")`
        pub const COUNTRY_AB3: Option<&str> = Some("ESP");
        /// `Some("ES")`
        pub const COUNTRY_ABTWO: Option<&str> = Some("ES");
        /// `Some("E")`
        pub const COUNTRY_CAR: Option<&str> = Some("E");
        /// `Some("978-84")`
        pub const COUNTRY_ISBN: Option<&str> = Some("978-84");
        /// `Some("Espanya")`
        pub const COUNTRY_NAME: Option<&str> = Some("Espanya");
        /// `Some(724)`
        pub const COUNTRY_NUM: Option<i64> = Some(724);
        /// `Some("E")`
        pub const COUNTRY_POST: Option<&str> = Some("E");
        /// `Some("an")`
        pub const LANG_AB: Option<&str> = Some("an");
        /// `Some("arg")`
        pub const LANG_LIB: Option<&str> = Some("arg");
        /// `Some("aragonés")`
        pub const LANG_NAME: Option<&str> = Some("aragonés");
        /// `Some("arg")`
        pub const LANG_TERM: Option<&str> = Some("arg");
        /// `Some("%a%N%f%N%d%N%b%N%s %h %e %r%N%z %T, %S%N%c%N")`
        pub const POSTAL_FMT: Option<&str> = Some("%a%N%f%N%d%N%b%N%s %h %e %r%N%z %T, %S%N%c%N");
    }
    pub mod LC_IDENTIFICATION {
        /// `None`
        pub const ABBREVIATION: Option<&str> = None;
        /// `Some("")`
        pub const ADDRESS: Option<&str> = Some("");
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        /// ]
        /// ```
        pub const CATEGORY: Option<&[&[&str]]> = Some(&[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_TELEPHONE"],
            &["i18n:2012", "LC_MEASUREMENT"],
        ]);
        /// `Some("Jordi Mallach Pérez, Juan Pablo Martínez")`
        pub const CONTACT: Option<&str> = Some("Jordi Mallach Pérez, Juan Pablo Martínez");
        /// `Some("2018-02-05")`
        pub const DATE: Option<&str> = Some("2018-02-05");
        /// `Some("bug-glibc-locales@gnu.org, softaragones@softaragones.org")`
        pub const EMAIL: Option<&str> = Some("bug-glibc-locales@gnu.org, softaragones@softaragones.org");
        /// `Some("")`
        pub const FAX: Option<&str> = Some("");
        /// `Some("Aragonese")`
        pub const LANGUAGE: Option<&str> = Some("Aragonese");
        /// `Some("1.2")`
        pub const REVISION: Option<&str> = Some("1.2");
        /// `Some("Softaragones")`
        pub const SOURCE: Option<&str> = Some("Softaragones");
        /// `Some("")`
        pub const TEL: Option<&str> = Some("");
        /// `Some("Spain")`
        pub const TERRITORY: Option<&str> = Some("Spain");
        /// `Some("Aragonese locale for Spain")`
        pub const TITLE: Option<&str> = Some("Aragonese locale for Spain");
    }
    pub mod LC_MESSAGES {
        /// `"^[-0nN]"`
        pub const NOEXPR: &str = "^[-0nN]";
        /// `Some("no")`
        pub const NOSTR: Option<&str> = Some("no");
        /// `"^[+1sSyY]"`
        pub const YESEXPR: &str = "^[+1sSyY]";
        /// `Some("sí")`
        pub const YESSTR: Option<&str> = Some("sí");
    }
    pub use super::es_ES::LC_MONETARY;
    pub use super::es_ES::LC_NUMERIC;
    pub use super::es_ES::LC_TELEPHONE;
    pub mod LC_TIME {
        /// `&["dom", "lun", "mar", "mie", "chu", "vie", "sab"]`
        pub const ABDAY: &[&str] = &["dom", "lun", "mar", "mie", "chu", "vie", "sab"];
        /// `&["chi", "feb", "mar", "abr", "may", "chn", "chl", "ago", "set", "oct", "nov", "avi"]`
        pub const ABMON: &[&str] = &["chi", "feb", "mar", "abr", "may", "chn", "chl", "ago", "set", "oct", "nov", "avi"];
        /// `None`
        pub const AB_ALT_MON: Option<&[&str]> = None;
        /// `None`
        pub const ALT_DIGITS: Option<&[&str]> = None;
        /// `None`
        pub const ALT_MON: Option<&[&str]> = None;
        /// `&["", ""]`
        pub const AM_PM: &[&str] = &["", ""];
        /// `None`
        pub const CAL_DIRECTION: Option<i64> = None;
        /// `None`
        pub const DATE_FMT: Option<&str> = None;
        /// `&["domingo", "luns", "martes", "mierques", "chueves", "viernes", "sabado"]`
        pub const DAY: &[&str] = &["domingo", "luns", "martes", "mierques", "chueves", "viernes", "sabado"];
        /// `"%d/%m/%Y"`
        pub const D_FMT: &str = "%d/%m/%Y";
        /// `"%a %d %b %Y %T %Z"`
        pub const D_T_FMT: &str = "%a %d %b %Y %T %Z";
        /// `None`
        pub const ERA: Option<&[&str]> = None;
        /// `None`
        pub const ERA_D_FMT: Option<&str> = None;
        /// `None`
        pub const ERA_D_T_FMT: Option<&str> = None;
        /// `None`
        pub const ERA_T_FMT: Option<&str> = None;
        /// `Some(2)`
        pub const FIRST_WEEKDAY: Option<i64> = Some(2);
        /// `None`
        pub const FIRST_WORKDAY: Option<i64> = None;
        /// `&["chinero", "febrero", "marzo", "abril", "mayo", "chunyo", "chuliol", "agosto", "setiembre", "octubre", "noviembre", "aviento"]`
        pub const MON: &[&str] = &["chinero", "febrero", "marzo", "abril", "mayo", "chunyo", "chuliol", "agosto", "setiembre", "octubre", "noviembre", "aviento"];
        /// `"%T"`
        pub const T_FMT: &str = "%T";
        /// `""`
        pub const T_FMT_AMPM: &str = "";
        /// `Some(&[7, 19971130, 4])`
        pub const WEEK: Option<&[i64]> = Some(&[7, 19971130, 4]);
    }
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod anp_IN {
    pub mod LC_ADDRESS {
        /// `Some("IND")`
        pub const COUNTRY_AB3: Option<&str> = Some("IND");
        /// `Some("IN")`
        pub const COUNTRY_ABTWO: Option<&str> = Some("IN");
        /// `Some("IND")`
        pub const COUNTRY_CAR: Option<&str> = Some("IND");
        /// `None`
        pub const COUNTRY_ISBN: Option<&str> = None;
        /// `Some("भारत")`
        pub const COUNTRY_NAME: Option<&str> = Some("भारत");
        /// `Some(356)`
        pub const COUNTRY_NUM: Option<i64> = Some(356);
        /// `None`
        pub const COUNTRY_POST: Option<&str> = None;
        /// `None`
        pub const LANG_AB: Option<&str> = None;
        /// `Some("anp")`
        pub const LANG_LIB: Option<&str> = Some("anp");
        /// `Some("अ\u{902}गिका")`
        pub const LANG_NAME: Option<&str> = Some("अ\u{902}गिका");
        /// `Some("anp")`
        pub const LANG_TERM: Option<&str> = Some("anp");
        /// `Some("%z%c%T%s%b%e%r")`
        pub const POSTAL_FMT: Option<&str> = Some("%z%c%T%s%b%e%r");
    }
    pub mod LC_IDENTIFICATION {
        /// `None`
        pub const ABBREVIATION: Option<&str> = None;
        /// `Some("")`
        pub const ADDRESS: Option<&str> = Some("");
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        /// ]
        /// ```
        pub const CATEGORY: Option<&[&[&str]]> = Some(&[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_TELEPHONE"],
            &["i18n:2012", "LC_MEASUREMENT"],
        ]);
        /// `Some("")`
        pub const CONTACT: Option<&str> = Some("");
        /// `Some("2013-10-24")`
        pub const DATE: Option<&str> = Some("2013-10-24");
        /// `Some("bhashaghar@googlegroups.com")`
        pub const EMAIL: Option<&str> = Some("bhashaghar@googlegroups.com");
        /// `Some("")`
        pub const FAX: Option<&str> = Some("");
        /// `Some("Angika")`
        pub const LANGUAGE: Option<&str> = Some("Angika");
        /// `Some("1.0")`
        pub const REVISION: Option<&str> = Some("1.0");
        /// `Some("")`
        pub const SOURCE: Option<&str> = Some("");
        /// `Some("")`
        pub const TEL: Option<&str> = Some("");
        /// `Some("India")`
        pub const TERRITORY: Option<&str> = Some("India");
        /// `Some("Angika language locale for India")`
        pub const TITLE: Option<&str> = Some("Angika language locale for India");
    }
    pub mod LC_MESSAGES {
        /// `"^[-0नइnN]"`
        pub const NOEXPR: &str = "^[-0नइnN]";
        /// `Some("नही\u{902}")`
        pub const NOSTR: Option<&str> = Some("नही\u{902}");
        /// `"^[+1हवyY]"`
        pub const YESEXPR: &str = "^[+1हवyY]";
        /// `Some("हा\u{901}")`
        pub const YESSTR: Option<&str> = Some("हा\u{901}");
    }
    pub use super::hi_IN::LC_MONETARY;
    pub use super::hi_IN::LC_NUMERIC;
    pub use super::hi_IN::LC_TELEPHONE;
    pub mod LC_TIME {
        /// `&["रवि", "सोम", "म\u{902}गल", "ब\u{941}ध", "ब\u{943}हस\u{94d}पति", "श\u{941}क\u{94d}र", "शनि"]`
        pub const ABDAY: &[&str] = &["रवि", "सोम", "म\u{902}गल", "ब\u{941}ध", "ब\u{943}हस\u{94d}पति", "श\u{941}क\u{94d}र", "शनि"];
        /// `&["जनवरी", "फरवरी", "मार\u{94d}च", "अप\u{94d}र\u{948}ल", "मई", "ज\u{942}न", "ज\u{941}लाई", "अगस\u{94d}त", "सित\u{902}बर", "अक\u{94d}ट\u{942}बर", "नव\u{902}बर", "दिस\u{902}बर"]`
        pub const ABMON: &[&str] = &["जनवरी", "फरवरी", "मार\u{94d}च", "अप\u{94d}र\u{948}ल", "मई", "ज\u{942}न", "ज\u{941}लाई", "अगस\u{94d}त", "सित\u{902}बर", "अक\u{94d}ट\u{942}बर", "नव\u{902}बर", "दिस\u{902}बर"];
        /// `None`
        pub const AB_ALT_MON: Option<&[&str]> = None;
        /// `None`
        pub const ALT_DIGITS: Option<&[&str]> = None;
        /// `None`
        pub const ALT_MON: Option<&[&str]> = None;
        /// `&["प\u{942}र\u{94d}वाह\u{94d}न", "अपराह\u{94d}न"]`
        pub const AM_PM: &[&str] = &["प\u{942}र\u{94d}वाह\u{94d}न", "अपराह\u{94d}न"];
        /// `None`
        pub const CAL_DIRECTION: Option<i64> = None;
        /// `None`
        pub const DATE_FMT: Option<&str> = None;
        /// `&["रविवार", "सोमवार", "म\u{902}गलवार", "ब\u{941}धवार", "ब\u{943}हस\u{94d}पतिवार", "श\u{941}क\u{94d}रवार", "शनिवार"]`
        pub const DAY: &[&str] = &["रविवार", "सोमवार", "म\u{902}गलवार", "ब\u{941}धवार", "ब\u{943}हस\u{94d}पतिवार", "श\u{941}क\u{94d}रवार", "शनिवार"];
        /// `"%-d/%-m/%y"`
        pub const D_FMT: &str = "%-d/%-m/%y";
        /// `"%A %d %b %Y %I:%M:%S %p %Z"`
        pub const D_T_FMT: &str = "%A %d %b %Y %I:%M:%S %p %Z";
        /// `None`
        pub const ERA: Option<&[&str]> = None;
        /// `None`
        pub const ERA_D_FMT: Option<&str> = None;
        /// `None`
        pub const ERA_D_T_FMT: Option<&str> = None;
        /// `None`
        pub const ERA_T_FMT: Option<&str> = None;
        /// `None`
        pub const FIRST_WEEKDAY: Option<i64> = None;
        /// `None`
        pub const FIRST_WORKDAY: Option<i64> = None;
        /// `&["जनवरी", "फरवरी", "मार\u{94d}च", "अप\u{94d}र\u{948}ल", "मई", "ज\u{942}न", "ज\u{941}लाई", "अगस\u{94d}त", "सित\u{902}बर", "अक\u{94d}ट\u{942}बर", "नव\u{902}बर", "दिस\u{902}बर"]`
        pub const MON: &[&str] = &["जनवरी", "फरवरी", "मार\u{94d}च", "अप\u{94d}र\u{948}ल", "मई", "ज\u{942}न", "ज\u{941}लाई", "अगस\u{94d}त", "सित\u{902}बर", "अक\u{94d}ट\u{942}बर", "नव\u{902}बर", "दिस\u{902}बर"];
        /// `"%I:%M:%S %p %Z"`
        pub const T_FMT: &str = "%I:%M:%S %p %Z";
        /// `"%I:%M:%S %p %Z"`
        pub const T_FMT_AMPM: &str = "%I:%M:%S %p %Z";
        /// `Some(&[7, 19971130, 1])`
        pub const WEEK: Option<&[i64]> = Some(&[7, 19971130, 1]);
    }
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod ar_AE {
    pub mod LC_ADDRESS {
        /// `Some("ARE")`
        pub const COUNTRY_AB3: Option<&str> = Some("ARE");
        /// `Some("AE")`
        pub const COUNTRY_ABTWO: Option<&str> = Some("AE");
        /// `Some("UAE")`
        pub const COUNTRY_CAR: Option<&str> = Some("UAE");
        /// `None`
        pub const COUNTRY_ISBN: Option<&str> = None;
        /// `Some("الإمارات العربية المتحدة")`
        pub const COUNTRY_NAME: Option<&str> = Some("الإمارات العربية المتحدة");
        /// `Some(784)`
        pub const COUNTRY_NUM: Option<i64> = Some(784);
        /// `None`
        pub const COUNTRY_POST: Option<&str> = None;
        /// `Some("ar")`
        pub const LANG_AB: Option<&str> = Some("ar");
        /// `Some("ara")`
        pub const LANG_LIB: Option<&str> = Some("ara");
        /// `Some("العربية")`
        pub const LANG_NAME: Option<&str> = Some("العربية");
        /// `Some("ara")`
        pub const LANG_TERM: Option<&str> = Some("ara");
        /// `Some("%z%c%T%s%b%e%r")`
        pub const POSTAL_FMT: Option<&str> = Some("%z%c%T%s%b%e%r");
    }
    pub mod LC_IDENTIFICATION {
        /// `None`
        pub const ABBREVIATION: Option<&str> = None;
        /// `Some("1623-14, Shimotsuruma, Yamato-shi, Kanagawa-ken, 242-8502, Japan")`
        pub const ADDRESS: Option<&str> = Some("1623-14, Shimotsuruma, Yamato-shi, Kanagawa-ken, 242-8502, Japan");
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        /// ]
        /// ```
        pub const CATEGORY: Option<&[&[&str]]> = Some(&[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_TELEPHONE"],
            &["i18n:2012", "LC_MEASUREMENT"],
        ]);
        /// `Some("")`
        pub const CONTACT: Option<&str> = Some("");
        /// `Some("2000-07-20")`
        pub const DATE: Option<&str> = Some("2000-07-20");
        /// `Some("bug-glibc-locales@gnu.org")`
        pub const EMAIL: Option<&str> = Some("bug-glibc-locales@gnu.org");
        /// `Some("")`
        pub const FAX: Option<&str> = Some("");
        /// `Some("Arabic")`
        pub const LANGUAGE: Option<&str> = Some("Arabic");
        /// `Some("1.0")`
        pub const REVISION: Option<&str> = Some("1.0");
        /// `Some("IBM Globalization Center of Competency, Yamato Software Laboratory")`
        pub const SOURCE: Option<&str> = Some("IBM Globalization Center of Competency, Yamato Software Laboratory");
        /// `Some("")`
        pub const TEL: Option<&str> = Some("");
        /// `Some("United Arab Emirates")`
        pub const TERRITORY: Option<&str> = Some("United Arab Emirates");
        /// `Some("Arabic language locale for United Arab Emirates")`
        pub const TITLE: Option<&str> = Some("Arabic language locale for United Arab Emirates");
    }
    pub use super::ar_EG::LC_MESSAGES;
    pub mod LC_MONETARY {
        /// `"د.إ."`
        pub const CURRENCY_SYMBOL: &str = "د.إ.";
        /// `3`
        pub const FRAC_DIGITS: i64 = 3;
        /// `"AED "`
        pub const INT_CURR_SYMBOL: &str = "AED ";
        /// `3`
        pub const INT_FRAC_DIGITS: i64 = 3;
        /// `None`
        pub const INT_N_CS_PRECEDES: Option<i64> = None;
        /// `None`
        pub const INT_N_SEP_BY_SPACE: Option<i64> = None;
        /// `None`
        pub const INT_N_SIGN_POSN: Option<i64> = None;
        /// `None`
        pub const INT_P_CS_PRECEDES: Option<i64> = None;
        /// `None`
        pub const INT_P_SEP_BY_SPACE: Option<i64> = None;
        /// `None`
        pub const INT_P_SIGN_POSN: Option<i64> = None;
        /// `"."`
        pub const MON_DECIMAL_POINT: &str = ".";
        /// `&[3]`
        pub const MON_GROUPING: &[i64] = &[3];
        /// `","`
        pub const MON_THOUSANDS_SEP: &str = ",";
        /// `"-"`
        pub const NEGATIVE_SIGN: &str = "-";
        /// `1`
        pub const N_CS_PRECEDES: i64 = 1;
        /// `1`
        pub const N_SEP_BY_SPACE: i64 = 1;
        /// `2`
        pub const N_SIGN_POSN: i64 = 2;
        /// `""`
        pub const POSITIVE_SIGN: &str = "";
        /// `1`
        pub const P_CS_PRECEDES: i64 = 1;
        /// `1`
        pub const P_SEP_BY_SPACE: i64 = 1;
        /// `1`
        pub const P_SIGN_POSN: i64 = 1;
    }
    pub mod LC_NUMERIC {
        /// `"."`
        pub const DECIMAL_POINT: &str = ".";
        /// `&[3]`
        pub const GROUPING: &[i64] = &[3];
        /// `","`
        pub const THOUSANDS_SEP: &str = ",";
    }
    pub mod LC_TELEPHONE {
        /// `Some("971")`
        pub const INT_PREFIX: Option<&str> = Some("971");
        /// `Some("00")`
        pub const INT_SELECT: Option<&str> = Some("00");
        /// `None`
        pub const TEL_DOM_FMT: Option<&str> = None;
        /// `Some("+%c ;%a ;%l")`
        pub const TEL_INT_FMT: Option<&str> = Some("+%c ;%a ;%l");
    }
    pub mod LC_TIME {
        /// `&["ح", "ن", "ث", "ر", "خ", "ج", "س"]`
        pub const ABDAY: &[&str] = &["ح", "ن", "ث", "ر", "خ", "ج", "س"];
        /// `&["ينا", "فبر", "مار", "أبر", "ماي", "يون", "يول", "أغس", "سبت", "أكت", "نوف", "ديس"]`
        pub const ABMON: &[&str] = &["ينا", "فبر", "مار", "أبر", "ماي", "يون", "يول", "أغس", "سبت", "أكت", "نوف", "ديس"];
        /// `None`
        pub const AB_ALT_MON: Option<&[&str]> = None;
        /// `None`
        pub const ALT_DIGITS: Option<&[&str]> = None;
        /// `None`
        pub const ALT_MON: Option<&[&str]> = None;
        /// `&["ص", "م"]`
        pub const AM_PM: &[&str] = &["ص", "م"];
        /// `None`
        pub const CAL_DIRECTION: Option<i64> = None;
        /// `None`
        pub const DATE_FMT: Option<&str> = None;
        /// `&["الأحد", "الاثنين", "الثلاثاء", "الأربعاء", "الخميس", "الجمعة", "السبت "]`
        pub const DAY: &[&str] = &["الأحد", "الاثنين", "الثلاثاء", "الأربعاء", "الخميس", "الجمعة", "السبت "];
        /// `"%d %b, %Y"`
        pub const D_FMT: &str = "%d %b, %Y";
        /// `"%d %b, %Y %Z %I:%M:%S %p"`
        pub const D_T_FMT: &str = "%d %b, %Y %Z %I:%M:%S %p";
        /// `None`
        pub const ERA: Option<&[&str]> = None;
        /// `None`
        pub const ERA_D_FMT: Option<&str> = None;
        /// `None`
        pub const ERA_D_T_FMT: Option<&str> = None;
        /// `None`
        pub const ERA_T_FMT: Option<&str> = None;
        /// `Some(7)`
        pub const FIRST_WEEKDAY: Option<i64> = Some(7);
        /// `Some(1)`
        pub const FIRST_WORKDAY: Option<i64> = Some(1);
        /// `&["يناير", "فبراير", "مارس", "أبريل", "مايو", "يونيو", "يوليو", "أغسطس", "سبتمبر", "أكتوبر", "نوفمبر", "ديسمبر"]`
        pub const MON: &[&str] = &["يناير", "فبراير", "مارس", "أبريل", "مايو", "يونيو", "يوليو", "أغسطس", "سبتمبر", "أكتوبر", "نوفمبر", "ديسمبر"];
        /// `"%Z %I:%M:%S %p"`
        pub const T_FMT: &str = "%Z %I:%M:%S %p";
        /// `"%Z %I:%M:%S %p"`
        pub const T_FMT_AMPM: &str = "%Z %I:%M:%S %p";
        /// `Some(&[7, 19971130, 1])`
        pub const WEEK: Option<&[i64]> = Some(&[7, 19971130, 1]);
    }
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod ar_BH {
    pub mod LC_ADDRESS {
        /// `Some("BHR")`
        pub const COUNTRY_AB3: Option<&str> = Some("BHR");
        /// `Some("BH")`
        pub const COUNTRY_ABTWO: Option<&str> = Some("BH");
        /// `Some("BRN")`
        pub const COUNTRY_CAR: Option<&str> = Some("BRN");
        /// `None`
        pub const COUNTRY_ISBN: Option<&str> = None;
        /// `Some("البحرين")`
        pub const COUNTRY_NAME: Option<&str> = Some("البحرين");
        /// `Some(48)`
        pub const COUNTRY_NUM: Option<i64> = Some(48);
        /// `None`
        pub const COUNTRY_POST: Option<&str> = None;
        /// `Some("ar")`
        pub const LANG_AB: Option<&str> = Some("ar");
        /// `Some("ara")`
        pub const LANG_LIB: Option<&str> = Some("ara");
        /// `Some("العربية")`
        pub const LANG_NAME: Option<&str> = Some("العربية");
        /// `Some("ara")`
        pub const LANG_TERM: Option<&str> = Some("ara");
        /// `Some("%z%c%T%s%b%e%r")`
        pub const POSTAL_FMT: Option<&str> = Some("%z%c%T%s%b%e%r");
    }
    pub mod LC_IDENTIFICATION {
        /// `None`
        pub const ABBREVIATION: Option<&str> = None;
        /// `Some("1623-14, Shimotsuruma, Yamato-shi, Kanagawa-ken, 242-8502, Japan")`
        pub const ADDRESS: Option<&str> = Some("1623-14, Shimotsuruma, Yamato-shi, Kanagawa-ken, 242-8502, Japan");
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        /// ]
        /// ```
        pub const CATEGORY: Option<&[&[&str]]> = Some(&[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_TELEPHONE"],
            &["i18n:2012", "LC_MEASUREMENT"],
        ]);
        /// `Some("")`
        pub const CONTACT: Option<&str> = Some("");
        /// `Some("2000-07-20")`
        pub const DATE: Option<&str> = Some("2000-07-20");
        /// `Some("bug-glibc-locales@gnu.org")`
        pub const EMAIL: Option<&str> = Some("bug-glibc-locales@gnu.org");
        /// `Some("")`
        pub const FAX: Option<&str> = Some("");
        /// `Some("Arabic")`
        pub const LANGUAGE: Option<&str> = Some("Arabic");
        /// `Some("1.0")`
        pub const REVISION: Option<&str> = Some("1.0");
        /// `Some("IBM Globalization Center of Competency, Yamato Software Laboratory")`
        pub const SOURCE: Option<&str> = Some("IBM Globalization Center of Competency, Yamato Software Laboratory");
        /// `Some("")`
        pub const TEL: Option<&str> = Some("");
        /// `Some("Bahrain")`
        pub const TERRITORY: Option<&str> = Some("Bahrain");
        /// `Some("Arabic language locale for Bahrain")`
        pub const TITLE: Option<&str> = Some("Arabic language locale for Bahrain");
    }
    pub use super::ar_EG::LC_MESSAGES;
    pub mod LC_MONETARY {
        /// `"د.ب."`
        pub const CURRENCY_SYMBOL: &str = "د.ب.";
        /// `3`
        pub const FRAC_DIGITS: i64 = 3;
        /// `"BHD "`
        pub const INT_CURR_SYMBOL: &str = "BHD ";
        /// `3`
        pub const INT_FRAC_DIGITS: i64 = 3;
        /// `None`
        pub const INT_N_CS_PRECEDES: Option<i64> = None;
        /// `None`
        pub const INT_N_SEP_BY_SPACE: Option<i64> = None;
        /// `None`
        pub const INT_N_SIGN_POSN: Option<i64> = None;
        /// `None`
        pub const INT_P_CS_PRECEDES: Option<i64> = None;
        /// `None`
        pub const INT_P_SEP_BY_SPACE: Option<i64> = None;
        /// `None`
        pub const INT_P_SIGN_POSN: Option<i64> = None;
        /// `"."`
        pub const MON_DECIMAL_POINT: &str = ".";
        /// `&[3]`
        pub const MON_GROUPING: &[i64] = &[3];
        /// `","`
        pub const MON_THOUSANDS_SEP: &str = ",";
        /// `"-"`
        pub const NEGATIVE_SIGN: &str = "-";
        /// `1`
        pub const N_CS_PRECEDES: i64 = 1;
        /// `1`
        pub const N_SEP_BY_SPACE: i64 = 1;
        /// `2`
        pub const N_SIGN_POSN: i64 = 2;
        /// `""`
        pub const POSITIVE_SIGN: &str = "";
        /// `1`
        pub const P_CS_PRECEDES: i64 = 1;
        /// `1`
        pub const P_SEP_BY_SPACE: i64 = 1;
        /// `1`
        pub const P_SIGN_POSN: i64 = 1;
    }
    pub mod LC_NUMERIC {
        /// `"."`
        pub const DECIMAL_POINT: &str = ".";
        /// `&[3]`
        pub const GROUPING: &[i64] = &[3];
        /// `","`
        pub const THOUSANDS_SEP: &str = ",";
    }
    pub mod LC_TELEPHONE {
        /// `Some("973")`
        pub const INT_PREFIX: Option<&str> = Some("973");
        /// `Some("00")`
        pub const INT_SELECT: Option<&str> = Some("00");
        /// `None`
        pub const TEL_DOM_FMT: Option<&str> = None;
        /// `Some("+%c ;%a ;%l")`
        pub const TEL_INT_FMT: Option<&str> = Some("+%c ;%a ;%l");
    }
    pub mod LC_TIME {
        /// `&["ح", "ن", "ث", "ر", "خ", "ج", "س"]`
        pub const ABDAY: &[&str] = &["ح", "ن", "ث", "ر", "خ", "ج", "س"];
        /// `&["ينا", "فبر", "مار", "أبر", "ماي", "يون", "يول", "أغس", "سبت", "أكت", "نوف", "ديس"]`
        pub const ABMON: &[&str] = &["ينا", "فبر", "مار", "أبر", "ماي", "يون", "يول", "أغس", "سبت", "أكت", "نوف", "ديس"];
        /// `None`
        pub const AB_ALT_MON: Option<&[&str]> = None;
        /// `None`
        pub const ALT_DIGITS: Option<&[&str]> = None;
        /// `None`
        pub const ALT_MON: Option<&[&str]> = None;
        /// `&["ص", "م"]`
        pub const AM_PM: &[&str] = &["ص", "م"];
        /// `None`
        pub const CAL_DIRECTION: Option<i64> = None;
        /// `None`
        pub const DATE_FMT: Option<&str> = None;
        /// `&["الأحد", "الاثنين", "الثلاثاء", "الأربعاء", "الخميس", "الجمعة", "السبت"]`
        pub const DAY: &[&str] = &["الأحد", "الاثنين", "الثلاثاء", "الأربعاء", "الخميس", "الجمعة", "السبت"];
        /// `"%d %b, %Y"`
        pub const D_FMT: &str = "%d %b, %Y";
        /// `"%d %b, %Y %Z %I:%M:%S %p"`
        pub const D_T_FMT: &str = "%d %b, %Y %Z %I:%M:%S %p";
        /// `None`
        pub const ERA: Option<&[&str]> = None;
        /// `None`
        pub const ERA_D_FMT: Option<&str> = None;
        /// `None`
        pub const ERA_D_T_FMT: Option<&str> = None;
        /// `None`
        pub const ERA_T_FMT: Option<&str> = None;
        /// `Some(7)`
        pub const FIRST_WEEKDAY: Option<i64> = Some(7);
        /// `Some(1)`
        pub const FIRST_WORKDAY: Option<i64> = Some(1);
        /// `&["يناير", "فبراير", "مارس", "أبريل", "مايو", "يونيو", "يوليو", "أغسطس", "سبتمبر", "أكتوبر", "نوفمبر", "ديسمبر"]`
        pub const MON: &[&str] = &["يناير", "فبراير", "مارس", "أبريل", "مايو", "يونيو", "يوليو", "أغسطس", "سبتمبر", "أكتوبر", "نوفمبر", "ديسمبر"];
        /// `"%Z %I:%M:%S %p"`
        pub const T_FMT: &str = "%Z %I:%M:%S %p";
        /// `"%Z %I:%M:%S %p"`
        pub const T_FMT_AMPM: &str = "%Z %I:%M:%S %p";
        /// `Some(&[7, 19971130, 1])`
        pub const WEEK: Option<&[i64]> = Some(&[7, 19971130, 1]);
    }
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod ar_DZ {
    pub mod LC_ADDRESS {
        /// `Some("DZA")`
        pub const COUNTRY_AB3: Option<&str> = Some("DZA");
        /// `Some("DZ")`
        pub const COUNTRY_ABTWO: Option<&str> = Some("DZ");
        /// `Some("DZ")`
        pub const COUNTRY_CAR: Option<&str> = Some("DZ");
        /// `None`
        pub const COUNTRY_ISBN: Option<&str> = None;
        /// `Some("الجزائر")`
        pub const COUNTRY_NAME: Option<&str> = Some("الجزائر");
        /// `Some(12)`
        pub const COUNTRY_NUM: Option<i64> = Some(12);
        /// `None`
        pub const COUNTRY_POST: Option<&str> = None;
        /// `Some("ar")`
        pub const LANG_AB: Option<&str> = Some("ar");
        /// `Some("ara")`
        pub const LANG_LIB: Option<&str> = Some("ara");
        /// `Some("العربية")`
        pub const LANG_NAME: Option<&str> = Some("العربية");
        /// `Some("ara")`
        pub const LANG_TERM: Option<&str> = Some("ara");
        /// `Some("%z%c%T%s%b%e%r")`
        pub const POSTAL_FMT: Option<&str> = Some("%z%c%T%s%b%e%r");
    }
    pub mod LC_IDENTIFICATION {
        /// `None`
        pub const ABBREVIATION: Option<&str> = None;
        /// `Some("1623-14, Shimotsuruma, Yamato-shi, Kanagawa-ken, 242-8502, Japan")`
        pub const ADDRESS: Option<&str> = Some("1623-14, Shimotsuruma, Yamato-shi, Kanagawa-ken, 242-8502, Japan");
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        /// ]
        /// ```
        pub const CATEGORY: Option<&[&[&str]]> = Some(&[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_TELEPHONE"],
            &["i18n:2012", "LC_MEASUREMENT"],
        ]);
        /// `Some("")`
        pub const CONTACT: Option<&str> = Some("");
        /// `Some("2000-07-20")`
        pub const DATE: Option<&str> = Some("2000-07-20");
        /// `Some("bug-glibc-locales@gnu.org")`
        pub const EMAIL: Option<&str> = Some("bug-glibc-locales@gnu.org");
        /// `Some("")`
        pub const FAX: Option<&str> = Some("");
        /// `Some("Arabic")`
        pub const LANGUAGE: Option<&str> = Some("Arabic");
        /// `Some("1.0")`
        pub const REVISION: Option<&str> = Some("1.0");
        /// `Some("IBM Globalization Center of Competency, Yamato Software Laboratory")`
        pub const SOURCE: Option<&str> = Some("IBM Globalization Center of Competency, Yamato Software Laboratory");
        /// `Some("")`
        pub const TEL: Option<&str> = Some("");
        /// `Some("Algeria")`
        pub const TERRITORY: Option<&str> = Some("Algeria");
        /// `Some("Arabic language locale for Algeria")`
        pub const TITLE: Option<&str> = Some("Arabic language locale for Algeria");
    }
    pub use super::ar_EG::LC_MESSAGES;
    pub mod LC_MONETARY {
        /// `"د.ج."`
        pub const CURRENCY_SYMBOL: &str = "د.ج.";
        /// `3`
        pub const FRAC_DIGITS: i64 = 3;
        /// `"DZD "`
        pub const INT_CURR_SYMBOL: &str = "DZD ";
        /// `3`
        pub const INT_FRAC_DIGITS: i64 = 3;
        /// `None`
        pub const INT_N_CS_PRECEDES: Option<i64> = None;
        /// `None`
        pub const INT_N_SEP_BY_SPACE: Option<i64> = None;
        /// `None`
        pub const INT_N_SIGN_POSN: Option<i64> = None;
        /// `None`
        pub const INT_P_CS_PRECEDES: Option<i64> = None;
        /// `None`
        pub const INT_P_SEP_BY_SPACE: Option<i64> = None;
        /// `None`
        pub const INT_P_SIGN_POSN: Option<i64> = None;
        /// `"."`
        pub const MON_DECIMAL_POINT: &str = ".";
        /// `&[3]`
        pub const MON_GROUPING: &[i64] = &[3];
        /// `","`
        pub const MON_THOUSANDS_SEP: &str = ",";
        /// `"-"`
        pub const NEGATIVE_SIGN: &str = "-";
        /// `1`
        pub const N_CS_PRECEDES: i64 = 1;
        /// `1`
        pub const N_SEP_BY_SPACE: i64 = 1;
        /// `2`
        pub const N_SIGN_POSN: i64 = 2;
        /// `""`
        pub const POSITIVE_SIGN: &str = "";
        /// `1`
        pub const P_CS_PRECEDES: i64 = 1;
        /// `1`
        pub const P_SEP_BY_SPACE: i64 = 1;
        /// `1`
        pub const P_SIGN_POSN: i64 = 1;
    }
    pub mod LC_NUMERIC {
        /// `"."`
        pub const DECIMAL_POINT: &str = ".";
        /// `&[3]`
        pub const GROUPING: &[i64] = &[3];
        /// `","`
        pub const THOUSANDS_SEP: &str = ",";
    }
    pub mod LC_TELEPHONE {
        /// `Some("213")`
        pub const INT_PREFIX: Option<&str> = Some("213");
        /// `Some("00")`
        pub const INT_SELECT: Option<&str> = Some("00");
        /// `None`
        pub const TEL_DOM_FMT: Option<&str> = None;
        /// `Some("+%c ;%a ;%l")`
        pub const TEL_INT_FMT: Option<&str> = Some("+%c ;%a ;%l");
    }
    pub mod LC_TIME {
        /// `&["ح", "ن", "ث", "ر", "خ", "ج", "س"]`
        pub const ABDAY: &[&str] = &["ح", "ن", "ث", "ر", "خ", "ج", "س"];
        /// `&["جانفي", "فيفري", "مارس", "أفريل", "ماي", "جوان", "جويلية", "أوت", "سبتمبر", "أكتوبر", "نوفمبر", "ديسمبر"]`
        pub const ABMON: &[&str] = &["جانفي", "فيفري", "مارس", "أفريل", "ماي", "جوان", "جويلية", "أوت", "سبتمبر", "أكتوبر", "نوفمبر", "ديسمبر"];
        /// `None`
        pub const AB_ALT_MON: Option<&[&str]> = None;
        /// `None`
        pub const ALT_DIGITS: Option<&[&str]> = None;
        /// `None`
        pub const ALT_MON: Option<&[&str]> = None;
        /// `&["ص", "م"]`
        pub const AM_PM: &[&str] = &["ص", "م"];
        /// `None`
        pub const CAL_DIRECTION: Option<i64> = None;
        /// `None`
        pub const DATE_FMT: Option<&str> = None;
        /// `&["الأحد", "الاثنين", "الثلاثاء", "الأربعاء", "الخميس", "الجمعة", "السبت"]`
        pub const DAY: &[&str] = &["الأحد", "الاثنين", "الثلاثاء", "الأربعاء", "الخميس", "الجمعة", "السبت"];
        /// `"%d %b, %Y"`
        pub const D_FMT: &str = "%d %b, %Y";
        /// `"%d %b, %Y %Z %I:%M:%S %p"`
        pub const D_T_FMT: &str = "%d %b, %Y %Z %I:%M:%S %p";
        /// `None`
        pub const ERA: Option<&[&str]> = None;
        /// `None`
        pub const ERA_D_FMT: Option<&str> = None;
        /// `None`
        pub const ERA_D_T_FMT: Option<&str> = None;
        /// `None`
        pub const ERA_T_FMT: Option<&str> = None;
        /// `Some(7)`
        pub const FIRST_WEEKDAY: Option<i64> = Some(7);
        /// `Some(1)`
        pub const FIRST_WORKDAY: Option<i64> = Some(1);
        /// `&["جانفي", "فيفري", "مارس", "أفريل", "ماي", "جوان", "جويلية", "أوت", "سبتمبر", "أكتوبر", "نوفمبر", "ديسمبر"]`
        pub const MON: &[&str] = &["جانفي", "فيفري", "مارس", "أفريل", "ماي", "جوان", "جويلية", "أوت", "سبتمبر", "أكتوبر", "نوفمبر", "ديسمبر"];
        /// `"%Z %I:%M:%S %p"`
        pub const T_FMT: &str = "%Z %I:%M:%S %p";
        /// `"%Z %I:%M:%S %p"`
        pub const T_FMT_AMPM: &str = "%Z %I:%M:%S %p";
        /// `Some(&[7, 19971130, 1])`
        pub const WEEK: Option<&[i64]> = Some(&[7, 19971130, 1]);
    }
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod ar_EG {
    pub mod LC_ADDRESS {
        /// `Some("EGY")`
        pub const COUNTRY_AB3: Option<&str> = Some("EGY");
        /// `Some("EG")`
        pub const COUNTRY_ABTWO: Option<&str> = Some("EG");
        /// `Some("ET")`
        pub const COUNTRY_CAR: Option<&str> = Some("ET");
        /// `None`
        pub const COUNTRY_ISBN: Option<&str> = None;
        /// `Some("مصر")`
        pub const COUNTRY_NAME: Option<&str> = Some("مصر");
        /// `Some(818)`
        pub const COUNTRY_NUM: Option<i64> = Some(818);
        /// `None`
        pub const COUNTRY_POST: Option<&str> = None;
        /// `Some("ar")`
        pub const LANG_AB: Option<&str> = Some("ar");
        /// `Some("ara")`
        pub const LANG_LIB: Option<&str> = Some("ara");
        /// `Some("العربية")`
        pub const LANG_NAME: Option<&str> = Some("العربية");
        /// `Some("ara")`
        pub const LANG_TERM: Option<&str> = Some("ara");
        /// `Some("%z%c%T%s%b%e%r")`
        pub const POSTAL_FMT: Option<&str> = Some("%z%c%T%s%b%e%r");
    }
    pub mod LC_IDENTIFICATION {
        /// `None`
        pub const ABBREVIATION: Option<&str> = None;
        /// `Some("1623-14, Shimotsuruma, Yamato-shi, Kanagawa-ken, 242-8502, Japan")`
        pub const ADDRESS: Option<&str> = Some("1623-14, Shimotsuruma, Yamato-shi, Kanagawa-ken, 242-8502, Japan");
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        /// ]
        /// ```
        pub const CATEGORY: Option<&[&[&str]]> = Some(&[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_TELEPHONE"],
            &["i18n:2012", "LC_MEASUREMENT"],
        ]);
        /// `Some("")`
        pub const CONTACT: Option<&str> = Some("");
        /// `Some("2000-07-20")`
        pub const DATE: Option<&str> = Some("2000-07-20");
        /// `Some("bug-glibc-locales@gnu.org")`
        pub const EMAIL: Option<&str> = Some("bug-glibc-locales@gnu.org");
        /// `Some("")`
        pub const FAX: Option<&str> = Some("");
        /// `Some("Arabic")`
        pub const LANGUAGE: Option<&str> = Some("Arabic");
        /// `Some("1.0")`
        pub const REVISION: Option<&str> = Some("1.0");
        /// `Some("IBM Globalization Center of Competency, Yamato Software Laboratory")`
        pub const SOURCE: Option<&str> = Some("IBM Globalization Center of Competency, Yamato Software Laboratory");
        /// `Some("")`
        pub const TEL: Option<&str> = Some("");
        /// `Some("Egypt")`
        pub const TERRITORY: Option<&str> = Some("Egypt");
        /// `Some("Arabic language locale for Egypt")`
        pub const TITLE: Option<&str> = Some("Arabic language locale for Egypt");
    }
    pub mod LC_MESSAGES {
        /// `"^[-0لnN]"`
        pub const NOEXPR: &str = "^[-0لnN]";
        /// `Some("لا")`
        pub const NOSTR: Option<&str> = Some("لا");
        /// `"^[+1نyY]"`
        pub const YESEXPR: &str = "^[+1نyY]";
        /// `Some("نعم")`
        pub const YESSTR: Option<&str> = Some("نعم");
    }
    pub mod LC_MONETARY {
        /// `"ج.م."`
        pub const CURRENCY_SYMBOL: &str = "ج.م.";
        /// `3`
        pub const FRAC_DIGITS: i64 = 3;
        /// `"EGP "`
        pub const INT_CURR_SYMBOL: &str = "EGP ";
        /// `3`
        pub const INT_FRAC_DIGITS: i64 = 3;
        /// `None`
        pub const INT_N_CS_PRECEDES: Option<i64> = None;
        /// `None`
        pub const INT_N_SEP_BY_SPACE: Option<i64> = None;
        /// `None`
        pub const INT_N_SIGN_POSN: Option<i64> = None;
        /// `None`
        pub const INT_P_CS_PRECEDES: Option<i64> = None;
        /// `None`
        pub const INT_P_SEP_BY_SPACE: Option<i64> = None;
        /// `None`
        pub const INT_P_SIGN_POSN: Option<i64> = None;
        /// `"."`
        pub const MON_DECIMAL_POINT: &str = ".";
        /// `&[3]`
        pub const MON_GROUPING: &[i64] = &[3];
        /// `","`
        pub const MON_THOUSANDS_SEP: &str = ",";
        /// `"-"`
        pub const NEGATIVE_SIGN: &str = "-";
        /// `1`
        pub const N_CS_PRECEDES: i64 = 1;
        /// `1`
        pub const N_SEP_BY_SPACE: i64 = 1;
        /// `2`
        pub const N_SIGN_POSN: i64 = 2;
        /// `""`
        pub const POSITIVE_SIGN: &str = "";
        /// `1`
        pub const P_CS_PRECEDES: i64 = 1;
        /// `1`
        pub const P_SEP_BY_SPACE: i64 = 1;
        /// `1`
        pub const P_SIGN_POSN: i64 = 1;
    }
    pub mod LC_NUMERIC {
        /// `"."`
        pub const DECIMAL_POINT: &str = ".";
        /// `&[3]`
        pub const GROUPING: &[i64] = &[3];
        /// `","`
        pub const THOUSANDS_SEP: &str = ",";
    }
    pub mod LC_TELEPHONE {
        /// `Some("20")`
        pub const INT_PREFIX: Option<&str> = Some("20");
        /// `Some("00")`
        pub const INT_SELECT: Option<&str> = Some("00");
        /// `None`
        pub const TEL_DOM_FMT: Option<&str> = None;
        /// `Some("+%c ;%a ;%l")`
        pub const TEL_INT_FMT: Option<&str> = Some("+%c ;%a ;%l");
    }
    pub mod LC_TIME {
        /// `&["ح", "ن", "ث", "ر", "خ", "ج", "س"]`
        pub const ABDAY: &[&str] = &["ح", "ن", "ث", "ر", "خ", "ج", "س"];
        /// `&["ينا", "فبر", "مار", "أبر", "ماي", "يون", "يول", "أغس", "سبت", "أكت", "نوف", "ديس"]`
        pub const ABMON: &[&str] = &["ينا", "فبر", "مار", "أبر", "ماي", "يون", "يول", "أغس", "سبت", "أكت", "نوف", "ديس"];
        /// `None`
        pub const AB_ALT_MON: Option<&[&str]> = None;
        /// `None`
        pub const ALT_DIGITS: Option<&[&str]> = None;
        /// `None`
        pub const ALT_MON: Option<&[&str]> = None;
        /// `&["ص", "م"]`
        pub const AM_PM: &[&str] = &["ص", "م"];
        /// `None`
        pub const CAL_DIRECTION: Option<i64> = None;
        /// `None`
        pub const DATE_FMT: Option<&str> = None;
        /// `&["الأحد", "الاثنين", "الثلاثاء", "الأربعاء", "الخميس", "الجمعة", "السبت"]`
        pub const DAY: &[&str] = &["الأحد", "الاثنين", "الثلاثاء", "الأربعاء", "الخميس", "الجمعة", "السبت"];
        /// `"%d %b, %Y"`
        pub const D_FMT: &str = "%d %b, %Y";
        /// `"%d %b, %Y %Z %I:%M:%S %p"`
        pub const D_T_FMT: &str = "%d %b, %Y %Z %I:%M:%S %p";
        /// `None`
        pub const ERA: Option<&[&str]> = None;
        /// `None`
        pub const ERA_D_FMT: Option<&str> = None;
        /// `None`
        pub const ERA_D_T_FMT: Option<&str> = None;
        /// `None`
        pub const ERA_T_FMT: Option<&str> = None;
        /// `Some(7)`
        pub const FIRST_WEEKDAY: Option<i64> = Some(7);
        /// `Some(1)`
        pub const FIRST_WORKDAY: Option<i64> = Some(1);
        /// `&["يناير", "فبراير", "مارس", "أبريل", "مايو", "يونيو", "يوليو", "أغسطس", "سبتمبر", "أكتوبر", "نوفمبر", "ديسمبر"]`
        pub const MON: &[&str] = &["يناير", "فبراير", "مارس", "أبريل", "مايو", "يونيو", "يوليو", "أغسطس", "سبتمبر", "أكتوبر", "نوفمبر", "ديسمبر"];
        /// `"%Z %I:%M:%S %p"`
        pub const T_FMT: &str = "%Z %I:%M:%S %p";
        /// `"%Z %I:%M:%S %p"`
        pub const T_FMT_AMPM: &str = "%Z %I:%M:%S %p";
        /// `Some(&[7, 19971130, 1])`
        pub const WEEK: Option<&[i64]> = Some(&[7, 19971130, 1]);
    }
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod ar_IN {
    pub mod LC_ADDRESS {
        /// `Some("IND")`
        pub const COUNTRY_AB3: Option<&str> = Some("IND");
        /// `Some("IN")`
        pub const COUNTRY_ABTWO: Option<&str> = Some("IN");
        /// `Some("IND")`
        pub const COUNTRY_CAR: Option<&str> = Some("IND");
        /// `None`
        pub const COUNTRY_ISBN: Option<&str> = None;
        /// `Some("الهند")`
        pub const COUNTRY_NAME: Option<&str> = Some("الهند");
        /// `Some(356)`
        pub const COUNTRY_NUM: Option<i64> = Some(356);
        /// `None`
        pub const COUNTRY_POST: Option<&str> = None;
        /// `Some("ar")`
        pub const LANG_AB: Option<&str> = Some("ar");
        /// `Some("ara")`
        pub const LANG_LIB: Option<&str> = Some("ara");
        /// `Some("العربية")`
        pub const LANG_NAME: Option<&str> = Some("العربية");
        /// `Some("ara")`
        pub const LANG_TERM: Option<&str> = Some("ara");
        /// `Some("%z%c%T%s%b%e%r")`
        pub const POSTAL_FMT: Option<&str> = Some("%z%c%T%s%b%e%r");
    }
    pub mod LC_IDENTIFICATION {
        /// `None`
        pub const ABBREVIATION: Option<&str> = None;
        /// `Some("1623-14, Shimotsuruma, Yamato-shi, Kanagawa-ken, 242-8502, Japan")`
        pub const ADDRESS: Option<&str> = Some("1623-14, Shimotsuruma, Yamato-shi, Kanagawa-ken, 242-8502, Japan");
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        /// ]
        /// ```
        pub const CATEGORY: Option<&[&[&str]]> = Some(&[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_TELEPHONE"],
            &["i18n:2012", "LC_MEASUREMENT"],
        ]);
        /// `Some("")`
        pub const CONTACT: Option<&str> = Some("");
        /// `Some("2000,October,27 (XML source:2000,July,20)")`
        pub const DATE: Option<&str> = Some("2000,October,27 (XML source:2000,July,20)");
        /// `Some("bug-glibc-locales@gnu.org")`
        pub const EMAIL: Option<&str> = Some("bug-glibc-locales@gnu.org");
        /// `Some("")`
        pub const FAX: Option<&str> = Some("");
        /// `Some("Arabic")`
        pub const LANGUAGE: Option<&str> = Some("Arabic");
        /// `Some("1.0")`
        pub const REVISION: Option<&str> = Some("1.0");
        /// `Some("IBM Globalization Center of Competency, Yamato Software Laboratory")`
        pub const SOURCE: Option<&str> = Some("IBM Globalization Center of Competency, Yamato Software Laboratory");
        /// `Some("")`
        pub const TEL: Option<&str> = Some("");
        /// `Some("India")`
        pub const TERRITORY: Option<&str> = Some("India");
        /// `Some("Arabic language locale for India")`
        pub const TITLE: Option<&str> = Some("Arabic language locale for India");
    }
    pub use super::ar_EG::LC_MESSAGES;
    pub use super::hi_IN::LC_MONETARY;
    pub use super::hi_IN::LC_NUMERIC;
    pub use super::hi_IN::LC_TELEPHONE;
    pub mod LC_TIME {
        /// `&["ح", "ن", "ث", "ر", "خ", "ج", "س"]`
        pub const ABDAY: &[&str] = &["ح", "ن", "ث", "ر", "خ", "ج", "س"];
        /// `&["ينا", "فبر", "مار", "أبر", "ماي", "يون", "يول", "أغس", "سبت", "أكت", "نوف", "ديس"]`
        pub const ABMON: &[&str] = &["ينا", "فبر", "مار", "أبر", "ماي", "يون", "يول", "أغس", "سبت", "أكت", "نوف", "ديس"];
        /// `None`
        pub const AB_ALT_MON: Option<&[&str]> = None;
        /// `None`
        pub const ALT_DIGITS: Option<&[&str]> = None;
        /// `None`
        pub const ALT_MON: Option<&[&str]> = None;
        /// `&["ص", "م"]`
        pub const AM_PM: &[&str] = &["ص", "م"];
        /// `None`
        pub const CAL_DIRECTION: Option<i64> = None;
        /// `None`
        pub const DATE_FMT: Option<&str> = None;
        /// `&["الأحد", "الاثنين", "الثلاثاء", "الأربعاء", "الخميس", "الجمعة", "السبت"]`
        pub const DAY: &[&str] = &["الأحد", "الاثنين", "الثلاثاء", "الأربعاء", "الخميس", "الجمعة", "السبت"];
        /// `"%-d/%-m/%y"`
        pub const D_FMT: &str = "%-d/%-m/%y";
        /// `"%A %d %B %Y %I:%M:%S %p %Z"`
        pub const D_T_FMT: &str = "%A %d %B %Y %I:%M:%S %p %Z";
        /// `None`
        pub const ERA: Option<&[&str]> = None;
        /// `None`
        pub const ERA_D_FMT: Option<&str> = None;
        /// `None`
        pub const ERA_D_T_FMT: Option<&str> = None;
        /// `None`
        pub const ERA_T_FMT: Option<&str> = None;
        /// `None`
        pub const FIRST_WEEKDAY: Option<i64> = None;
        /// `None`
        pub const FIRST_WORKDAY: Option<i64> = None;
        /// `&["يناير", "فبراير", "مارس", "أبريل", "مايو", "يونيو", "يوليو", "أغسطس", "سبتمبر", "أكتوبر", "نوفمبر", "ديسمبر"]`
        pub const MON: &[&str] = &["يناير", "فبراير", "مارس", "أبريل", "مايو", "يونيو", "يوليو", "أغسطس", "سبتمبر", "أكتوبر", "نوفمبر", "ديسمبر"];
        /// `"%I:%M:%S %p %Z"`
        pub const T_FMT: &str = "%I:%M:%S %p %Z";
        /// `"%I:%M:%S %p %Z"`
        pub const T_FMT_AMPM: &str = "%I:%M:%S %p %Z";
        /// `Some(&[7, 19971130, 1])`
        pub const WEEK: Option<&[i64]> = Some(&[7, 19971130, 1]);
    }
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod ar_IQ {
    pub mod LC_ADDRESS {
        /// `Some("IRQ")`
        pub const COUNTRY_AB3: Option<&str> = Some("IRQ");
        /// `Some("IQ")`
        pub const COUNTRY_ABTWO: Option<&str> = Some("IQ");
        /// `Some("IRQ")`
        pub const COUNTRY_CAR: Option<&str> = Some("IRQ");
        /// `None`
        pub const COUNTRY_ISBN: Option<&str> = None;
        /// `Some("العراق")`
        pub const COUNTRY_NAME: Option<&str> = Some("العراق");
        /// `Some(368)`
        pub const COUNTRY_NUM: Option<i64> = Some(368);
        /// `None`
        pub const COUNTRY_POST: Option<&str> = None;
        /// `Some("ar")`
        pub const LANG_AB: Option<&str> = Some("ar");
        /// `Some("ara")`
        pub const LANG_LIB: Option<&str> = Some("ara");
        /// `Some("العربية")`
        pub const LANG_NAME: Option<&str> = Some("العربية");
        /// `Some("ara")`
        pub const LANG_TERM: Option<&str> = Some("ara");
        /// `Some("%z%c%T%s%b%e%r")`
        pub const POSTAL_FMT: Option<&str> = Some("%z%c%T%s%b%e%r");
    }
    pub mod LC_IDENTIFICATION {
        /// `None`
        pub const ABBREVIATION: Option<&str> = None;
        /// `Some("1623-14, Shimotsuruma, Yamato-shi, Kanagawa-ken, 242-8502, Japan")`
        pub const ADDRESS: Option<&str> = Some("1623-14, Shimotsuruma, Yamato-shi, Kanagawa-ken, 242-8502, Japan");
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        /// ]
        /// ```
        pub const CATEGORY: Option<&[&[&str]]> = Some(&[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_TELEPHONE"],
            &["i18n:2012", "LC_MEASUREMENT"],
        ]);
        /// `Some("")`
        pub const CONTACT: Option<&str> = Some("");
        /// `Some("2000-07-20")`
        pub const DATE: Option<&str> = Some("2000-07-20");
        /// `Some("bug-glibc-locales@gnu.org")`
        pub const EMAIL: Option<&str> = Some("bug-glibc-locales@gnu.org");
        /// `Some("")`
        pub const FAX: Option<&str> = Some("");
        /// `Some("Arabic")`
        pub const LANGUAGE: Option<&str> = Some("Arabic");
        /// `Some("1.0")`
        pub const REVISION: Option<&str> = Some("1.0");
        /// `Some("IBM Globalization Center of Competency, Yamato Software Laboratory")`
        pub const SOURCE: Option<&str> = Some("IBM Globalization Center of Competency, Yamato Software Laboratory");
        /// `Some("")`
        pub const TEL: Option<&str> = Some("");
        /// `Some("Iraq")`
        pub const TERRITORY: Option<&str> = Some("Iraq");
        /// `Some("Arabic language locale for Iraq")`
        pub const TITLE: Option<&str> = Some("Arabic language locale for Iraq");
    }
    pub use super::ar_EG::LC_MESSAGES;
    pub mod LC_MONETARY {
        /// `"د.ع."`
        pub const CURRENCY_SYMBOL: &str = "د.ع.";
        /// `3`
        pub const FRAC_DIGITS: i64 = 3;
        /// `"IQD "`
        pub const INT_CURR_SYMBOL: &str = "IQD ";
        /// `3`
        pub const INT_FRAC_DIGITS: i64 = 3;
        /// `None`
        pub const INT_N_CS_PRECEDES: Option<i64> = None;
        /// `None`
        pub const INT_N_SEP_BY_SPACE: Option<i64> = None;
        /// `None`
        pub const INT_N_SIGN_POSN: Option<i64> = None;
        /// `None`
        pub const INT_P_CS_PRECEDES: Option<i64> = None;
        /// `None`
        pub const INT_P_SEP_BY_SPACE: Option<i64> = None;
        /// `None`
        pub const INT_P_SIGN_POSN: Option<i64> = None;
        /// `"."`
        pub const MON_DECIMAL_POINT: &str = ".";
        /// `&[3]`
        pub const MON_GROUPING: &[i64] = &[3];
        /// `","`
        pub const MON_THOUSANDS_SEP: &str = ",";
        /// `"-"`
        pub const NEGATIVE_SIGN: &str = "-";
        /// `1`
        pub const N_CS_PRECEDES: i64 = 1;
        /// `1`
        pub const N_SEP_BY_SPACE: i64 = 1;
        /// `2`
        pub const N_SIGN_POSN: i64 = 2;
        /// `""`
        pub const POSITIVE_SIGN: &str = "";
        /// `1`
        pub const P_CS_PRECEDES: i64 = 1;
        /// `1`
        pub const P_SEP_BY_SPACE: i64 = 1;
        /// `1`
        pub const P_SIGN_POSN: i64 = 1;
    }
    pub mod LC_NUMERIC {
        /// `"."`
        pub const DECIMAL_POINT: &str = ".";
        /// `&[3]`
        pub const GROUPING: &[i64] = &[3];
        /// `","`
        pub const THOUSANDS_SEP: &str = ",";
    }
    pub mod LC_TELEPHONE {
        /// `Some("964")`
        pub const INT_PREFIX: Option<&str> = Some("964");
        /// `Some("00")`
        pub const INT_SELECT: Option<&str> = Some("00");
        /// `None`
        pub const TEL_DOM_FMT: Option<&str> = None;
        /// `Some("+%c ;%a ;%l")`
        pub const TEL_INT_FMT: Option<&str> = Some("+%c ;%a ;%l");
    }
    pub mod LC_TIME {
        /// `&["ح", "ن", "ث", "ر", "خ", "ج", "س"]`
        pub const ABDAY: &[&str] = &["ح", "ن", "ث", "ر", "خ", "ج", "س"];
        /// `&["كانون الثاني", "شباط", "آذار", "نيسان", "أيار", "حزيران", "تموز", "آب", "أيلول", "تشرين الأول", "تشرين الثاني", "كانون الأول"]`
        pub const ABMON: &[&str] = &["كانون الثاني", "شباط", "آذار", "نيسان", "أيار", "حزيران", "تموز", "آب", "أيلول", "تشرين الأول", "تشرين الثاني", "كانون الأول"];
        /// `None`
        pub const AB_ALT_MON: Option<&[&str]> = None;
        /// `None`
        pub const ALT_DIGITS: Option<&[&str]> = None;
        /// `None`
        pub const ALT_MON: Option<&[&str]> = None;
        /// `&["ص", "م"]`
        pub const AM_PM: &[&str] = &["ص", "م"];
        /// `None`
        pub const CAL_DIRECTION: Option<i64> = None;
        /// `None`
        pub const DATE_FMT: Option<&str> = None;
        /// `&["الأحد", "الاثنين", "الثلاثاء", "الأربعاء", "الخميس", "الجمعة", "السبت"]`
        pub const DAY: &[&str] = &["الأحد", "الاثنين", "الثلاثاء", "الأربعاء", "الخميس", "الجمعة", "السبت"];
        /// `"%d %b, %Y"`
        pub const D_FMT: &str = "%d %b, %Y";
        /// `"%d %b, %Y %Z %I:%M:%S %p"`
        pub const D_T_FMT: &str = "%d %b, %Y %Z %I:%M:%S %p";
        /// `None`
        pub const ERA: Option<&[&str]> = None;
        /// `None`
        pub const ERA_D_FMT: Option<&str> = None;
        /// `None`
        pub const ERA_D_T_FMT: Option<&str> = None;
        /// `None`
        pub const ERA_T_FMT: Option<&str> = None;
        /// `Some(7)`
        pub const FIRST_WEEKDAY: Option<i64> = Some(7);
        /// `Some(1)`
        pub const FIRST_WORKDAY: Option<i64> = Some(1);
        /// `&["كانون الثاني", "شباط", "آذار", "نيسان", "أيار", "حزيران", "تموز", "آب", "أيلول", "تشرين الأول", "تشرين الثاني", "كانون الأول"]`
        pub const MON: &[&str] = &["كانون الثاني", "شباط", "آذار", "نيسان", "أيار", "حزيران", "تموز", "آب", "أيلول", "تشرين الأول", "تشرين الثاني", "كانون الأول"];
        /// `"%Z %I:%M:%S %p"`
        pub const T_FMT: &str = "%Z %I:%M:%S %p";
        /// `"%Z %I:%M:%S %p"`
        pub const T_FMT_AMPM: &str = "%Z %I:%M:%S %p";
        /// `Some(&[7, 19971130, 1])`
        pub const WEEK: Option<&[i64]> = Some(&[7, 19971130, 1]);
    }
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod ar_JO {
    pub mod LC_ADDRESS {
        /// `Some("JOR")`
        pub const COUNTRY_AB3: Option<&str> = Some("JOR");
        /// `Some("JO")`
        pub const COUNTRY_ABTWO: Option<&str> = Some("JO");
        /// `Some("HKJ")`
        pub const COUNTRY_CAR: Option<&str> = Some("HKJ");
        /// `None`
        pub const COUNTRY_ISBN: Option<&str> = None;
        /// `Some("الأردن")`
        pub const COUNTRY_NAME: Option<&str> = Some("الأردن");
        /// `Some(400)`
        pub const COUNTRY_NUM: Option<i64> = Some(400);
        /// `None`
        pub const COUNTRY_POST: Option<&str> = None;
        /// `Some("ar")`
        pub const LANG_AB: Option<&str> = Some("ar");
        /// `Some("ara")`
        pub const LANG_LIB: Option<&str> = Some("ara");
        /// `Some("العربية")`
        pub const LANG_NAME: Option<&str> = Some("العربية");
        /// `Some("ara")`
        pub const LANG_TERM: Option<&str> = Some("ara");
        /// `Some("%z%c%T%s%b%e%r")`
        pub const POSTAL_FMT: Option<&str> = Some("%z%c%T%s%b%e%r");
    }
    pub mod LC_IDENTIFICATION {
        /// `None`
        pub const ABBREVIATION: Option<&str> = None;
        /// `Some("1623-14, Shimotsuruma, Yamato-shi, Kanagawa-ken, 242-8502, Japan")`
        pub const ADDRESS: Option<&str> = Some("1623-14, Shimotsuruma, Yamato-shi, Kanagawa-ken, 242-8502, Japan");
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        /// ]
        /// ```
        pub const CATEGORY: Option<&[&[&str]]> = Some(&[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_TELEPHONE"],
            &["i18n:2012", "LC_MEASUREMENT"],
        ]);
        /// `Some("")`
        pub const CONTACT: Option<&str> = Some("");
        /// `Some("2000-07-20")`
        pub const DATE: Option<&str> = Some("2000-07-20");
        /// `Some("bug-glibc-locales@gnu.org")`
        pub const EMAIL: Option<&str> = Some("bug-glibc-locales@gnu.org");
        /// `Some("")`
        pub const FAX: Option<&str> = Some("");
        /// `Some("Arabic")`
        pub const LANGUAGE: Option<&str> = Some("Arabic");
        /// `Some("1.0")`
        pub const REVISION: Option<&str> = Some("1.0");
        /// `Some("IBM Globalization Center of Competency, Yamato Software Laboratory")`
        pub const SOURCE: Option<&str> = Some("IBM Globalization Center of Competency, Yamato Software Laboratory");
        /// `Some("")`
        pub const TEL: Option<&str> = Some("");
        /// `Some("Jordan")`
        pub const TERRITORY: Option<&str> = Some("Jordan");
        /// `Some("Arabic language locale for Jordan")`
        pub const TITLE: Option<&str> = Some("Arabic language locale for Jordan");
    }
    pub use super::ar_EG::LC_MESSAGES;
    pub mod LC_MONETARY {
        /// `"د.أ."`
        pub const CURRENCY_SYMBOL: &str = "د.أ.";
        /// `3`
        pub const FRAC_DIGITS: i64 = 3;
        /// `"JOD "`
        pub const INT_CURR_SYMBOL: &str = "JOD ";
        /// `3`
        pub const INT_FRAC_DIGITS: i64 = 3;
        /// `None`
        pub const INT_N_CS_PRECEDES: Option<i64> = None;
        /// `None`
        pub const INT_N_SEP_BY_SPACE: Option<i64> = None;
        /// `None`
        pub const INT_N_SIGN_POSN: Option<i64> = None;
        /// `None`
        pub const INT_P_CS_PRECEDES: Option<i64> = None;
        /// `None`
        pub const INT_P_SEP_BY_SPACE: Option<i64> = None;
        /// `None`
        pub const INT_P_SIGN_POSN: Option<i64> = None;
        /// `"."`
        pub const MON_DECIMAL_POINT: &str = ".";
        /// `&[3]`
        pub const MON_GROUPING: &[i64] = &[3];
        /// `","`
        pub const MON_THOUSANDS_SEP: &str = ",";
        /// `"-"`
        pub const NEGATIVE_SIGN: &str = "-";
        /// `1`
        pub const N_CS_PRECEDES: i64 = 1;
        /// `1`
        pub const N_SEP_BY_SPACE: i64 = 1;
        /// `2`
        pub const N_SIGN_POSN: i64 = 2;
        /// `""`
        pub const POSITIVE_SIGN: &str = "";
        /// `1`
        pub const P_CS_PRECEDES: i64 = 1;
        /// `1`
        pub const P_SEP_BY_SPACE: i64 = 1;
        /// `1`
        pub const P_SIGN_POSN: i64 = 1;
    }
    pub mod LC_NUMERIC {
        /// `"."`
        pub const DECIMAL_POINT: &str = ".";
        /// `&[3]`
        pub const GROUPING: &[i64] = &[3];
        /// `","`
        pub const THOUSANDS_SEP: &str = ",";
    }
    pub mod LC_TELEPHONE {
        /// `Some("962")`
        pub const INT_PREFIX: Option<&str> = Some("962");
        /// `Some("00")`
        pub const INT_SELECT: Option<&str> = Some("00");
        /// `None`
        pub const TEL_DOM_FMT: Option<&str> = None;
        /// `Some("+%c ;%a ;%l")`
        pub const TEL_INT_FMT: Option<&str> = Some("+%c ;%a ;%l");
    }
    pub mod LC_TIME {
        /// `&["ح", "ن", "ث", "ر", "خ", "ج", "س"]`
        pub const ABDAY: &[&str] = &["ح", "ن", "ث", "ر", "خ", "ج", "س"];
        /// `&["كانون الثاني", "شباط", "آذار", "نيسان", "أيار", "حزيران", "تموز", "آب", "أيلول", "تشرين الأول", "تشرين الثاني", "كانون الأول"]`
        pub const ABMON: &[&str] = &["كانون الثاني", "شباط", "آذار", "نيسان", "أيار", "حزيران", "تموز", "آب", "أيلول", "تشرين الأول", "تشرين الثاني", "كانون الأول"];
        /// `None`
        pub const AB_ALT_MON: Option<&[&str]> = None;
        /// `None`
        pub const ALT_DIGITS: Option<&[&str]> = None;
        /// `None`
        pub const ALT_MON: Option<&[&str]> = None;
        /// `&["ص", "م"]`
        pub const AM_PM: &[&str] = &["ص", "م"];
        /// `None`
        pub const CAL_DIRECTION: Option<i64> = None;
        /// `None`
        pub const DATE_FMT: Option<&str> = None;
        /// `&["الأحد", "الاثنين", "الثلاثاء", "الأربعاء", "الخميس", "الجمعة", "السبت"]`
        pub const DAY: &[&str] = &["الأحد", "الاثنين", "الثلاثاء", "الأربعاء", "الخميس", "الجمعة", "السبت"];
        /// `"%d %b, %Y"`
        pub const D_FMT: &str = "%d %b, %Y";
        /// `"%d %b, %Y %Z %I:%M:%S %p"`
        pub const D_T_FMT: &str = "%d %b, %Y %Z %I:%M:%S %p";
        /// `None`
        pub const ERA: Option<&[&str]> = None;
        /// `None`
        pub const ERA_D_FMT: Option<&str> = None;
        /// `None`
        pub const ERA_D_T_FMT: Option<&str> = None;
        /// `None`
        pub const ERA_T_FMT: Option<&str> = None;
        /// `Some(7)`
        pub const FIRST_WEEKDAY: Option<i64> = Some(7);
        /// `Some(1)`
        pub const FIRST_WORKDAY: Option<i64> = Some(1);
        /// `&["كانون الثاني", "شباط", "آذار", "نيسان", "أيار", "حزيران", "تموز", "آب", "أيلول", "تشرين الأول", "تشرين الثاني", "كانون الأول"]`
        pub const MON: &[&str] = &["كانون الثاني", "شباط", "آذار", "نيسان", "أيار", "حزيران", "تموز", "آب", "أيلول", "تشرين الأول", "تشرين الثاني", "كانون الأول"];
        /// `"%Z %I:%M:%S %p"`
        pub const T_FMT: &str = "%Z %I:%M:%S %p";
        /// `"%Z %I:%M:%S %p"`
        pub const T_FMT_AMPM: &str = "%Z %I:%M:%S %p";
        /// `Some(&[7, 19971130, 1])`
        pub const WEEK: Option<&[i64]> = Some(&[7, 19971130, 1]);
    }
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod ar_KW {
    pub mod LC_ADDRESS {
        /// `Some("KWT")`
        pub const COUNTRY_AB3: Option<&str> = Some("KWT");
        /// `Some("KW")`
        pub const COUNTRY_ABTWO: Option<&str> = Some("KW");
        /// `Some("KWT")`
        pub const COUNTRY_CAR: Option<&str> = Some("KWT");
        /// `None`
        pub const COUNTRY_ISBN: Option<&str> = None;
        /// `Some("الكويت")`
        pub const COUNTRY_NAME: Option<&str> = Some("الكويت");
        /// `Some(414)`
        pub const COUNTRY_NUM: Option<i64> = Some(414);
        /// `None`
        pub const COUNTRY_POST: Option<&str> = None;
        /// `Some("ar")`
        pub const LANG_AB: Option<&str> = Some("ar");
        /// `Some("ara")`
        pub const LANG_LIB: Option<&str> = Some("ara");
        /// `Some("العربية")`
        pub const LANG_NAME: Option<&str> = Some("العربية");
        /// `Some("ara")`
        pub const LANG_TERM: Option<&str> = Some("ara");
        /// `Some("%z%c%T%s%b%e%r")`
        pub const POSTAL_FMT: Option<&str> = Some("%z%c%T%s%b%e%r");
    }
    pub mod LC_IDENTIFICATION {
        /// `None`
        pub const ABBREVIATION: Option<&str> = None;
        /// `Some("1623-14, Shimotsuruma, Yamato-shi, Kanagawa-ken, 242-8502, Japan")`
        pub const ADDRESS: Option<&str> = Some("1623-14, Shimotsuruma, Yamato-shi, Kanagawa-ken, 242-8502, Japan");
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        /// ]
        /// ```
        pub const CATEGORY: Option<&[&[&str]]> = Some(&[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_TELEPHONE"],
            &["i18n:2012", "LC_MEASUREMENT"],
        ]);
        /// `Some("")`
        pub const CONTACT: Option<&str> = Some("");
        /// `Some("2000-07-20")`
        pub const DATE: Option<&str> = Some("2000-07-20");
        /// `Some("bug-glibc-locales@gnu.org")`
        pub const EMAIL: Option<&str> = Some("bug-glibc-locales@gnu.org");
        /// `Some("")`
        pub const FAX: Option<&str> = Some("");
        /// `Some("Arabic")`
        pub const LANGUAGE: Option<&str> = Some("Arabic");
        /// `Some("1.0")`
        pub const REVISION: Option<&str> = Some("1.0");
        /// `Some("IBM Globalization Center of Competency, Yamato Software Laboratory")`
        pub const SOURCE: Option<&str> = Some("IBM Globalization Center of Competency, Yamato Software Laboratory");
        /// `Some("")`
        pub const TEL: Option<&str> = Some("");
        /// `Some("Kuwait")`
        pub const TERRITORY: Option<&str> = Some("Kuwait");
        /// `Some("Arabic language locale for Kuwait")`
        pub const TITLE: Option<&str> = Some("Arabic language locale for Kuwait");
    }
    pub use super::ar_EG::LC_MESSAGES;
    pub mod LC_MONETARY {
        /// `"د.ك."`
        pub const CURRENCY_SYMBOL: &str = "د.ك.";
        /// `3`
        pub const FRAC_DIGITS: i64 = 3;
        /// `"KWD "`
        pub const INT_CURR_SYMBOL: &str = "KWD ";
        /// `3`
        pub const INT_FRAC_DIGITS: i64 = 3;
        /// `None`
        pub const INT_N_CS_PRECEDES: Option<i64> = None;
        /// `None`
        pub const INT_N_SEP_BY_SPACE: Option<i64> = None;
        /// `None`
        pub const INT_N_SIGN_POSN: Option<i64> = None;
        /// `None`
        pub const INT_P_CS_PRECEDES: Option<i64> = None;
        /// `None`
        pub const INT_P_SEP_BY_SPACE: Option<i64> = None;
        /// `None`
        pub const INT_P_SIGN_POSN: Option<i64> = None;
        /// `"."`
        pub const MON_DECIMAL_POINT: &str = ".";
        /// `&[3]`
        pub const MON_GROUPING: &[i64] = &[3];
        /// `","`
        pub const MON_THOUSANDS_SEP: &str = ",";
        /// `"-"`
        pub const NEGATIVE_SIGN: &str = "-";
        /// `1`
        pub const N_CS_PRECEDES: i64 = 1;
        /// `1`
        pub const N_SEP_BY_SPACE: i64 = 1;
        /// `2`
        pub const N_SIGN_POSN: i64 = 2;
        /// `""`
        pub const POSITIVE_SIGN: &str = "";
        /// `1`
        pub const P_CS_PRECEDES: i64 = 1;
        /// `1`
        pub const P_SEP_BY_SPACE: i64 = 1;
        /// `1`
        pub const P_SIGN_POSN: i64 = 1;
    }
    pub mod LC_NUMERIC {
        /// `"."`
        pub const DECIMAL_POINT: &str = ".";
        /// `&[3]`
        pub const GROUPING: &[i64] = &[3];
        /// `","`
        pub const THOUSANDS_SEP: &str = ",";
    }
    pub mod LC_TELEPHONE {
        /// `Some("965")`
        pub const INT_PREFIX: Option<&str> = Some("965");
        /// `Some("00")`
        pub const INT_SELECT: Option<&str> = Some("00");
        /// `None`
        pub const TEL_DOM_FMT: Option<&str> = None;
        /// `Some("+%c ;%a ;%l")`
        pub const TEL_INT_FMT: Option<&str> = Some("+%c ;%a ;%l");
    }
    pub mod LC_TIME {
        /// `&["ح", "ن", "ث", "ر", "خ", "ج", "س"]`
        pub const ABDAY: &[&str] = &["ح", "ن", "ث", "ر", "خ", "ج", "س"];
        /// `&["ينا", "فبر", "مار", "أبر", "ماي", "يون", "يول", "أغس", "سبت", "أكت", "نوف", "ديس"]`
        pub const ABMON: &[&str] = &["ينا", "فبر", "مار", "أبر", "ماي", "يون", "يول", "أغس", "سبت", "أكت", "نوف", "ديس"];
        /// `None`
        pub const AB_ALT_MON: Option<&[&str]> = None;
        /// `None`
        pub const ALT_DIGITS: Option<&[&str]> = None;
        /// `None`
        pub const ALT_MON: Option<&[&str]> = None;
        /// `&["ص", "م"]`
        pub const AM_PM: &[&str] = &["ص", "م"];
        /// `None`
        pub const CAL_DIRECTION: Option<i64> = None;
        /// `None`
        pub const DATE_FMT: Option<&str> = None;
        /// `&["الأحد", "الاثنين", "الثلاثاء", "الأربعاء", "الخميس", "الجمعة", "السبت"]`
        pub const DAY: &[&str] = &["الأحد", "الاثنين", "الثلاثاء", "الأربعاء", "الخميس", "الجمعة", "السبت"];
        /// `"%d %b, %Y"`
        pub const D_FMT: &str = "%d %b, %Y";
        /// `"%d %b, %Y %Z %I:%M:%S %p"`
        pub const D_T_FMT: &str = "%d %b, %Y %Z %I:%M:%S %p";
        /// `None`
        pub const ERA: Option<&[&str]> = None;
        /// `None`
        pub const ERA_D_FMT: Option<&str> = None;
        /// `None`
        pub const ERA_D_T_FMT: Option<&str> = None;
        /// `None`
        pub const ERA_T_FMT: Option<&str> = None;
        /// `Some(7)`
        pub const FIRST_WEEKDAY: Option<i64> = Some(7);
        /// `Some(1)`
        pub const FIRST_WORKDAY: Option<i64> = Some(1);
        /// `&["يناير", "فبراير", "مارس", "أبريل", "مايو", "يونيو", "يوليو", "أغسطس", "سبتمبر", "أكتوبر", "نوفمبر", "ديسمبر"]`
        pub const MON: &[&str] = &["يناير", "فبراير", "مارس", "أبريل", "مايو", "يونيو", "يوليو", "أغسطس", "سبتمبر", "أكتوبر", "نوفمبر", "ديسمبر"];
        /// `"%Z %I:%M:%S %p"`
        pub const T_FMT: &str = "%Z %I:%M:%S %p";
        /// `"%Z %I:%M:%S %p"`
        pub const T_FMT_AMPM: &str = "%Z %I:%M:%S %p";
        /// `Some(&[7, 19971130, 1])`
        pub const WEEK: Option<&[i64]> = Some(&[7, 19971130, 1]);
    }
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod ar_LB {
    pub mod LC_ADDRESS {
        /// `Some("LBN")`
        pub const COUNTRY_AB3: Option<&str> = Some("LBN");
        /// `Some("LB")`
        pub const COUNTRY_ABTWO: Option<&str> = Some("LB");
        /// `Some("RL")`
        pub const COUNTRY_CAR: Option<&str> = Some("RL");
        /// `None`
        pub const COUNTRY_ISBN: Option<&str> = None;
        /// `Some("لبنان")`
        pub const COUNTRY_NAME: Option<&str> = Some("لبنان");
        /// `Some(422)`
        pub const COUNTRY_NUM: Option<i64> = Some(422);
        /// `None`
        pub const COUNTRY_POST: Option<&str> = None;
        /// `Some("ar")`
        pub const LANG_AB: Option<&str> = Some("ar");
        /// `Some("ara")`
        pub const LANG_LIB: Option<&str> = Some("ara");
        /// `Some("العربية")`
        pub const LANG_NAME: Option<&str> = Some("العربية");
        /// `Some("ara")`
        pub const LANG_TERM: Option<&str> = Some("ara");
        /// `Some("%z%c%T%s%b%e%r")`
        pub const POSTAL_FMT: Option<&str> = Some("%z%c%T%s%b%e%r");
    }
    pub mod LC_IDENTIFICATION {
        /// `None`
        pub const ABBREVIATION: Option<&str> = None;
        /// `Some("1623-14, Shimotsuruma, Yamato-shi, Kanagawa-ken, 242-8502, Japan")`
        pub const ADDRESS: Option<&str> = Some("1623-14, Shimotsuruma, Yamato-shi, Kanagawa-ken, 242-8502, Japan");
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        /// ]
        /// ```
        pub const CATEGORY: Option<&[&[&str]]> = Some(&[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_TELEPHONE"],
            &["i18n:2012", "LC_MEASUREMENT"],
        ]);
        /// `Some("")`
        pub const CONTACT: Option<&str> = Some("");
        /// `Some("2000-07-20")`
        pub const DATE: Option<&str> = Some("2000-07-20");
        /// `Some("bug-glibc-locales@gnu.org")`
        pub const EMAIL: Option<&str> = Some("bug-glibc-locales@gnu.org");
        /// `Some("")`
        pub const FAX: Option<&str> = Some("");
        /// `Some("Arabic")`
        pub const LANGUAGE: Option<&str> = Some("Arabic");
        /// `Some("1.0")`
        pub const REVISION: Option<&str> = Some("1.0");
        /// `Some("IBM Globalization Center of Competency, Yamato Software Laboratory")`
        pub const SOURCE: Option<&str> = Some("IBM Globalization Center of Competency, Yamato Software Laboratory");
        /// `Some("")`
        pub const TEL: Option<&str> = Some("");
        /// `Some("Lebanon")`
        pub const TERRITORY: Option<&str> = Some("Lebanon");
        /// `Some("Arabic language locale for Lebanon")`
        pub const TITLE: Option<&str> = Some("Arabic language locale for Lebanon");
    }
    pub use super::ar_EG::LC_MESSAGES;
    pub mod LC_MONETARY {
        /// `"ل.ل."`
        pub const CURRENCY_SYMBOL: &str = "ل.ل.";
        /// `3`
        pub const FRAC_DIGITS: i64 = 3;
        /// `"LBP "`
        pub const INT_CURR_SYMBOL: &str = "LBP ";
        /// `3`
        pub const INT_FRAC_DIGITS: i64 = 3;
        /// `None`
        pub const INT_N_CS_PRECEDES: Option<i64> = None;
        /// `None`
        pub const INT_N_SEP_BY_SPACE: Option<i64> = None;
        /// `None`
        pub const INT_N_SIGN_POSN: Option<i64> = None;
        /// `None`
        pub const INT_P_CS_PRECEDES: Option<i64> = None;
        /// `None`
        pub const INT_P_SEP_BY_SPACE: Option<i64> = None;
        /// `None`
        pub const INT_P_SIGN_POSN: Option<i64> = None;
        /// `"."`
        pub const MON_DECIMAL_POINT: &str = ".";
        /// `&[3]`
        pub const MON_GROUPING: &[i64] = &[3];
        /// `","`
        pub const MON_THOUSANDS_SEP: &str = ",";
        /// `"-"`
        pub const NEGATIVE_SIGN: &str = "-";
        /// `1`
        pub const N_CS_PRECEDES: i64 = 1;
        /// `1`
        pub const N_SEP_BY_SPACE: i64 = 1;
        /// `2`
        pub const N_SIGN_POSN: i64 = 2;
        /// `""`
        pub const POSITIVE_SIGN: &str = "";
        /// `1`
        pub const P_CS_PRECEDES: i64 = 1;
        /// `1`
        pub const P_SEP_BY_SPACE: i64 = 1;
        /// `1`
        pub const P_SIGN_POSN: i64 = 1;
    }
    pub mod LC_NUMERIC {
        /// `"."`
        pub const DECIMAL_POINT: &str = ".";
        /// `&[3]`
        pub const GROUPING: &[i64] = &[3];
        /// `","`
        pub const THOUSANDS_SEP: &str = ",";
    }
    pub mod LC_TELEPHONE {
        /// `Some("961")`
        pub const INT_PREFIX: Option<&str> = Some("961");
        /// `Some("00")`
        pub const INT_SELECT: Option<&str> = Some("00");
        /// `None`
        pub const TEL_DOM_FMT: Option<&str> = None;
        /// `Some("+%c ;%a ;%l")`
        pub const TEL_INT_FMT: Option<&str> = Some("+%c ;%a ;%l");
    }
    pub mod LC_TIME {
        /// `&["ح", "ن", "ث", "ر", "خ", "ج", "س"]`
        pub const ABDAY: &[&str] = &["ح", "ن", "ث", "ر", "خ", "ج", "س"];
        /// `&["كانون الثاني", "شباط", "آذار", "نيسان", "أيار", "حزيران", "تموز", "آب", "أيلول", "تشرين الأول", "تشرين الثاني", "كانون الأول"]`
        pub const ABMON: &[&str] = &["كانون الثاني", "شباط", "آذار", "نيسان", "أيار", "حزيران", "تموز", "آب", "أيلول", "تشرين الأول", "تشرين الثاني", "كانون الأول"];
        /// `None`
        pub const AB_ALT_MON: Option<&[&str]> = None;
        /// `None`
        pub const ALT_DIGITS: Option<&[&str]> = None;
        /// `None`
        pub const ALT_MON: Option<&[&str]> = None;
        /// `&["ص", "م"]`
        pub const AM_PM: &[&str] = &["ص", "م"];
        /// `None`
        pub const CAL_DIRECTION: Option<i64> = None;
        /// `None`
        pub const DATE_FMT: Option<&str> = None;
        /// `&["الأحد", "الاثنين", "الثلاثاء", "الأربعاء", "الخميس", "الجمعة", "السبت"]`
        pub const DAY: &[&str] = &["الأحد", "الاثنين", "الثلاثاء", "الأربعاء", "الخميس", "الجمعة", "السبت"];
        /// `"%d %b, %Y"`
        pub const D_FMT: &str = "%d %b, %Y";
        /// `"%d %b, %Y %Z %I:%M:%S %p"`
        pub const D_T_FMT: &str = "%d %b, %Y %Z %I:%M:%S %p";
        /// `None`
        pub const ERA: Option<&[&str]> = None;
        /// `None`
        pub const ERA_D_FMT: Option<&str> = None;
        /// `None`
        pub const ERA_D_T_FMT: Option<&str> = None;
        /// `None`
        pub const ERA_T_FMT: Option<&str> = None;
        /// `Some(2)`
        pub const FIRST_WEEKDAY: Option<i64> = Some(2);
        /// `None`
        pub const FIRST_WORKDAY: Option<i64> = None;
        /// `&["كانون الثاني", "شباط", "آذار", "نيسان", "أيار", "حزيران", "تموز", "آب", "أيلول", "تشرين الأول", "تشرين الثاني", "كانون الأول"]`
        pub const MON: &[&str] = &["كانون الثاني", "شباط", "آذار", "نيسان", "أيار", "حزيران", "تموز", "آب", "أيلول", "تشرين الأول", "تشرين الثاني", "كانون الأول"];
        /// `"%Z %I:%M:%S %p"`
        pub const T_FMT: &str = "%Z %I:%M:%S %p";
        /// `"%Z %I:%M:%S %p"`
        pub const T_FMT_AMPM: &str = "%Z %I:%M:%S %p";
        /// `Some(&[7, 19971130, 1])`
        pub const WEEK: Option<&[i64]> = Some(&[7, 19971130, 1]);
    }
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod ar_LY {
    pub mod LC_ADDRESS {
        /// `Some("LBY")`
        pub const COUNTRY_AB3: Option<&str> = Some("LBY");
        /// `Some("LY")`
        pub const COUNTRY_ABTWO: Option<&str> = Some("LY");
        /// `Some("LAR")`
        pub const COUNTRY_CAR: Option<&str> = Some("LAR");
        /// `None`
        pub const COUNTRY_ISBN: Option<&str> = None;
        /// `Some("ليبيا")`
        pub const COUNTRY_NAME: Option<&str> = Some("ليبيا");
        /// `Some(434)`
        pub const COUNTRY_NUM: Option<i64> = Some(434);
        /// `None`
        pub const COUNTRY_POST: Option<&str> = None;
        /// `Some("ar")`
        pub const LANG_AB: Option<&str> = Some("ar");
        /// `Some("ara")`
        pub const LANG_LIB: Option<&str> = Some("ara");
        /// `Some("العربية")`
        pub const LANG_NAME: Option<&str> = Some("العربية");
        /// `Some("ara")`
        pub const LANG_TERM: Option<&str> = Some("ara");
        /// `Some("%z%c%T%s%b%e%r")`
        pub const POSTAL_FMT: Option<&str> = Some("%z%c%T%s%b%e%r");
    }
    pub mod LC_IDENTIFICATION {
        /// `None`
        pub const ABBREVIATION: Option<&str> = None;
        /// `Some("1623-14, Shimotsuruma, Yamato-shi, Kanagawa-ken, 242-8502, Japan")`
        pub const ADDRESS: Option<&str> = Some("1623-14, Shimotsuruma, Yamato-shi, Kanagawa-ken, 242-8502, Japan");
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        /// ]
        /// ```
        pub const CATEGORY: Option<&[&[&str]]> = Some(&[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_TELEPHONE"],
            &["i18n:2012", "LC_MEASUREMENT"],
        ]);
        /// `Some("")`
        pub const CONTACT: Option<&str> = Some("");
        /// `Some("2000-07-20")`
        pub const DATE: Option<&str> = Some("2000-07-20");
        /// `Some("bug-glibc-locales@gnu.org")`
        pub const EMAIL: Option<&str> = Some("bug-glibc-locales@gnu.org");
        /// `Some("")`
        pub const FAX: Option<&str> = Some("");
        /// `Some("Arabic")`
        pub const LANGUAGE: Option<&str> = Some("Arabic");
        /// `Some("1.0")`
        pub const REVISION: Option<&str> = Some("1.0");
        /// `Some("IBM Globalization Center of Competency, Yamato Software Laboratory")`
        pub const SOURCE: Option<&str> = Some("IBM Globalization Center of Competency, Yamato Software Laboratory");
        /// `Some("")`
        pub const TEL: Option<&str> = Some("");
        /// `Some("Libya")`
        pub const TERRITORY: Option<&str> = Some("Libya");
        /// `Some("Arabic language locale for Libyan Arab Jamahiriya")`
        pub const TITLE: Option<&str> = Some("Arabic language locale for Libyan Arab Jamahiriya");
    }
    pub use super::ar_EG::LC_MESSAGES;
    pub mod LC_MONETARY {
        /// `"د.ل."`
        pub const CURRENCY_SYMBOL: &str = "د.ل.";
        /// `3`
        pub const FRAC_DIGITS: i64 = 3;
        /// `"LYD "`
        pub const INT_CURR_SYMBOL: &str = "LYD ";
        /// `3`
        pub const INT_FRAC_DIGITS: i64 = 3;
        /// `None`
        pub const INT_N_CS_PRECEDES: Option<i64> = None;
        /// `None`
        pub const INT_N_SEP_BY_SPACE: Option<i64> = None;
        /// `None`
        pub const INT_N_SIGN_POSN: Option<i64> = None;
        /// `None`
        pub const INT_P_CS_PRECEDES: Option<i64> = None;
        /// `None`
        pub const INT_P_SEP_BY_SPACE: Option<i64> = None;
        /// `None`
        pub const INT_P_SIGN_POSN: Option<i64> = None;
        /// `"."`
        pub const MON_DECIMAL_POINT: &str = ".";
        /// `&[3]`
        pub const MON_GROUPING: &[i64] = &[3];
        /// `","`
        pub const MON_THOUSANDS_SEP: &str = ",";
        /// `"-"`
        pub const NEGATIVE_SIGN: &str = "-";
        /// `1`
        pub const N_CS_PRECEDES: i64 = 1;
        /// `1`
        pub const N_SEP_BY_SPACE: i64 = 1;
        /// `2`
        pub const N_SIGN_POSN: i64 = 2;
        /// `""`
        pub const POSITIVE_SIGN: &str = "";
        /// `1`
        pub const P_CS_PRECEDES: i64 = 1;
        /// `1`
        pub const P_SEP_BY_SPACE: i64 = 1;
        /// `1`
        pub const P_SIGN_POSN: i64 = 1;
    }
    pub mod LC_NUMERIC {
        /// `"."`
        pub const DECIMAL_POINT: &str = ".";
        /// `&[3]`
        pub const GROUPING: &[i64] = &[3];
        /// `","`
        pub const THOUSANDS_SEP: &str = ",";
    }
    pub mod LC_TELEPHONE {
        /// `Some("218")`
        pub const INT_PREFIX: Option<&str> = Some("218");
        /// `Some("00")`
        pub const INT_SELECT: Option<&str> = Some("00");
        /// `None`
        pub const TEL_DOM_FMT: Option<&str> = None;
        /// `Some("+%c ;%a ;%l")`
        pub const TEL_INT_FMT: Option<&str> = Some("+%c ;%a ;%l");
    }
    pub mod LC_TIME {
        /// `&["ح", "ن", "ث", "ر", "خ", "ج", "س"]`
        pub const ABDAY: &[&str] = &["ح", "ن", "ث", "ر", "خ", "ج", "س"];
        /// `&["ينا", "فبر", "مار", "أبر", "ماي", "يون", "يول", "أغس", "سبت", "أكت", "نوف", "ديس"]`
        pub const ABMON: &[&str] = &["ينا", "فبر", "مار", "أبر", "ماي", "يون", "يول", "أغس", "سبت", "أكت", "نوف", "ديس"];
        /// `None`
        pub const AB_ALT_MON: Option<&[&str]> = None;
        /// `None`
        pub const ALT_DIGITS: Option<&[&str]> = None;
        /// `None`
        pub const ALT_MON: Option<&[&str]> = None;
        /// `&["ص", "م"]`
        pub const AM_PM: &[&str] = &["ص", "م"];
        /// `None`
        pub const CAL_DIRECTION: Option<i64> = None;
        /// `None`
        pub const DATE_FMT: Option<&str> = None;
        /// `&["الأحد", "الاثنين", "الثلاثاء", "الأربعاء", "الخميس", "الجمعة", "السبت"]`
        pub const DAY: &[&str] = &["الأحد", "الاثنين", "الثلاثاء", "الأربعاء", "الخميس", "الجمعة", "السبت"];
        /// `"%d %b, %Y"`
        pub const D_FMT: &str = "%d %b, %Y";
        /// `"%d %b, %Y %Z %I:%M:%S %p"`
        pub const D_T_FMT: &str = "%d %b, %Y %Z %I:%M:%S %p";
        /// `None`
        pub const ERA: Option<&[&str]> = None;
        /// `None`
        pub const ERA_D_FMT: Option<&str> = None;
        /// `None`
        pub const ERA_D_T_FMT: Option<&str> = None;
        /// `None`
        pub const ERA_T_FMT: Option<&str> = None;
        /// `Some(7)`
        pub const FIRST_WEEKDAY: Option<i64> = Some(7);
        /// `Some(1)`
        pub const FIRST_WORKDAY: Option<i64> = Some(1);
        /// `&["يناير", "فبراير", "مارس", "أبريل", "مايو", "يونيو", "يوليو", "أغسطس", "سبتمبر", "أكتوبر", "نوفمبر", "ديسمبر"]`
        pub const MON: &[&str] = &["يناير", "فبراير", "مارس", "أبريل", "مايو", "يونيو", "يوليو", "أغسطس", "سبتمبر", "أكتوبر", "نوفمبر", "ديسمبر"];
        /// `"%Z %I:%M:%S %p"`
        pub const T_FMT: &str = "%Z %I:%M:%S %p";
        /// `"%Z %I:%M:%S %p"`
        pub const T_FMT_AMPM: &str = "%Z %I:%M:%S %p";
        /// `Some(&[7, 19971130, 1])`
        pub const WEEK: Option<&[i64]> = Some(&[7, 19971130, 1]);
    }
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod ar_MA {
    pub mod LC_ADDRESS {
        /// `Some("MAR")`
        pub const COUNTRY_AB3: Option<&str> = Some("MAR");
        /// `Some("MA")`
        pub const COUNTRY_ABTWO: Option<&str> = Some("MA");
        /// `Some("MA")`
        pub const COUNTRY_CAR: Option<&str> = Some("MA");
        /// `None`
        pub const COUNTRY_ISBN: Option<&str> = None;
        /// `Some("المغرب")`
        pub const COUNTRY_NAME: Option<&str> = Some("المغرب");
        /// `Some(504)`
        pub const COUNTRY_NUM: Option<i64> = Some(504);
        /// `None`
        pub const COUNTRY_POST: Option<&str> = None;
        /// `Some("ar")`
        pub const LANG_AB: Option<&str> = Some("ar");
        /// `Some("ara")`
        pub const LANG_LIB: Option<&str> = Some("ara");
        /// `Some("العربية")`
        pub const LANG_NAME: Option<&str> = Some("العربية");
        /// `Some("ara")`
        pub const LANG_TERM: Option<&str> = Some("ara");
        /// `Some("%z%c%T%s%b%e%r")`
        pub const POSTAL_FMT: Option<&str> = Some("%z%c%T%s%b%e%r");
    }
    pub mod LC_IDENTIFICATION {
        /// `None`
        pub const ABBREVIATION: Option<&str> = None;
        /// `Some("1623-14, Shimotsuruma, Yamato-shi, Kanagawa-ken, 242-8502, Japan")`
        pub const ADDRESS: Option<&str> = Some("1623-14, Shimotsuruma, Yamato-shi, Kanagawa-ken, 242-8502, Japan");
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        /// ]
        /// ```
        pub const CATEGORY: Option<&[&[&str]]> = Some(&[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_TELEPHONE"],
            &["i18n:2012", "LC_MEASUREMENT"],
        ]);
        /// `Some("")`
        pub const CONTACT: Option<&str> = Some("");
        /// `Some("2000-07-20")`
        pub const DATE: Option<&str> = Some("2000-07-20");
        /// `Some("bug-glibc-locales@gnu.org")`
        pub const EMAIL: Option<&str> = Some("bug-glibc-locales@gnu.org");
        /// `Some("")`
        pub const FAX: Option<&str> = Some("");
        /// `Some("Arabic")`
        pub const LANGUAGE: Option<&str> = Some("Arabic");
        /// `Some("1.0")`
        pub const REVISION: Option<&str> = Some("1.0");
        /// `Some("IBM Globalization Center of Competency, Yamato Software Laboratory")`
        pub const SOURCE: Option<&str> = Some("IBM Globalization Center of Competency, Yamato Software Laboratory");
        /// `Some("")`
        pub const TEL: Option<&str> = Some("");
        /// `Some("Morocco")`
        pub const TERRITORY: Option<&str> = Some("Morocco");
        /// `Some("Arabic language locale for Morocco")`
        pub const TITLE: Option<&str> = Some("Arabic language locale for Morocco");
    }
    pub use super::ar_EG::LC_MESSAGES;
    pub mod LC_MONETARY {
        /// `"د.م."`
        pub const CURRENCY_SYMBOL: &str = "د.م.";
        /// `3`
        pub const FRAC_DIGITS: i64 = 3;
        /// `"MAD "`
        pub const INT_CURR_SYMBOL: &str = "MAD ";
        /// `3`
        pub const INT_FRAC_DIGITS: i64 = 3;
        /// `None`
        pub const INT_N_CS_PRECEDES: Option<i64> = None;
        /// `None`
        pub const INT_N_SEP_BY_SPACE: Option<i64> = None;
        /// `None`
        pub const INT_N_SIGN_POSN: Option<i64> = None;
        /// `None`
        pub const INT_P_CS_PRECEDES: Option<i64> = None;
        /// `None`
        pub const INT_P_SEP_BY_SPACE: Option<i64> = None;
        /// `None`
        pub const INT_P_SIGN_POSN: Option<i64> = None;
        /// `"."`
        pub const MON_DECIMAL_POINT: &str = ".";
        /// `&[3]`
        pub const MON_GROUPING: &[i64] = &[3];
        /// `","`
        pub const MON_THOUSANDS_SEP: &str = ",";
        /// `"-"`
        pub const NEGATIVE_SIGN: &str = "-";
        /// `1`
        pub const N_CS_PRECEDES: i64 = 1;
        /// `1`
        pub const N_SEP_BY_SPACE: i64 = 1;
        /// `2`
        pub const N_SIGN_POSN: i64 = 2;
        /// `""`
        pub const POSITIVE_SIGN: &str = "";
        /// `1`
        pub const P_CS_PRECEDES: i64 = 1;
        /// `1`
        pub const P_SEP_BY_SPACE: i64 = 1;
        /// `1`
        pub const P_SIGN_POSN: i64 = 1;
    }
    pub mod LC_NUMERIC {
        /// `"."`
        pub const DECIMAL_POINT: &str = ".";
        /// `&[3]`
        pub const GROUPING: &[i64] = &[3];
        /// `","`
        pub const THOUSANDS_SEP: &str = ",";
    }
    pub mod LC_TELEPHONE {
        /// `Some("212")`
        pub const INT_PREFIX: Option<&str> = Some("212");
        /// `Some("00")`
        pub const INT_SELECT: Option<&str> = Some("00");
        /// `None`
        pub const TEL_DOM_FMT: Option<&str> = None;
        /// `Some("+%c ;%a ;%l")`
        pub const TEL_INT_FMT: Option<&str> = Some("+%c ;%a ;%l");
    }
    pub mod LC_TIME {
        /// `&["ح", "ن", "ث", "ر", "خ", "ج", "س"]`
        pub const ABDAY: &[&str] = &["ح", "ن", "ث", "ر", "خ", "ج", "س"];
        /// `&["يناير", "فبراير", "مارس", "أبريل", "ماي", "يونيو", "يوليوز", "غشت", "شتنبر", "أكتوبر", "نونبر", "دجنبر"]`
        pub const ABMON: &[&str] = &["يناير", "فبراير", "مارس", "أبريل", "ماي", "يونيو", "يوليوز", "غشت", "شتنبر", "أكتوبر", "نونبر", "دجنبر"];
        /// `None`
        pub const AB_ALT_MON: Option<&[&str]> = None;
        /// `None`
        pub const ALT_DIGITS: Option<&[&str]> = None;
        /// `None`
        pub const ALT_MON: Option<&[&str]> = None;
        /// `&["ص", "م"]`
        pub const AM_PM: &[&str] = &["ص", "م"];
        /// `None`
        pub const CAL_DIRECTION: Option<i64> = None;
        /// `None`
        pub const DATE_FMT: Option<&str> = None;
        /// `&["الأحد", "الاثنين", "الثلاثاء", "الأربعاء", "الخميس", "الجمعة", "السبت"]`
        pub const DAY: &[&str] = &["الأحد", "الاثنين", "الثلاثاء", "الأربعاء", "الخميس", "الجمعة", "السبت"];
        /// `"%d %b, %Y"`
        pub const D_FMT: &str = "%d %b, %Y";
        /// `"%d %b, %Y %Z %H:%M:%S"`
        pub const D_T_FMT: &str = "%d %b, %Y %Z %H:%M:%S";
        /// `None`
        pub const ERA: Option<&[&str]> = None;
        /// `None`
        pub const ERA_D_FMT: Option<&str> = None;
        /// `None`
        pub const ERA_D_T_FMT: Option<&str> = None;
        /// `None`
        pub const ERA_T_FMT: Option<&str> = None;
        /// `Some(7)`
        pub const FIRST_WEEKDAY: Option<i64> = Some(7);
        /// `Some(1)`
        pub const FIRST_WORKDAY: Option<i64> = Some(1);
        /// `&["يناير", "فبراير", "مارس", "أبريل", "ماي", "يونيو", "يوليوز", "غشت", "شتنبر", "أكتوبر", "نونبر", "دجنبر"]`
        pub const MON: &[&str] = &["يناير", "فبراير", "مارس", "أبريل", "ماي", "يونيو", "يوليوز", "غشت", "شتنبر", "أكتوبر", "نونبر", "دجنبر"];
        /// `"%Z %H:%M:%S"`
        pub const T_FMT: &str = "%Z %H:%M:%S";
        /// `"%l:%M:%S %p"`
        pub const T_FMT_AMPM: &str = "%l:%M:%S %p";
        /// `Some(&[7, 19971130, 1])`
        pub const WEEK: Option<&[i64]> = Some(&[7, 19971130, 1]);
    }
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod ar_OM {
    pub mod LC_ADDRESS {
        /// `Some("OMN")`
        pub const COUNTRY_AB3: Option<&str> = Some("OMN");
        /// `Some("OM")`
        pub const COUNTRY_ABTWO: Option<&str> = Some("OM");
        /// `Some("OM")`
        pub const COUNTRY_CAR: Option<&str> = Some("OM");
        /// `None`
        pub const COUNTRY_ISBN: Option<&str> = None;
        /// `Some("ع\u{64f}مان")`
        pub const COUNTRY_NAME: Option<&str> = Some("ع\u{64f}مان");
        /// `Some(512)`
        pub const COUNTRY_NUM: Option<i64> = Some(512);
        /// `None`
        pub const COUNTRY_POST: Option<&str> = None;
        /// `Some("ar")`
        pub const LANG_AB: Option<&str> = Some("ar");
        /// `Some("ara")`
        pub const LANG_LIB: Option<&str> = Some("ara");
        /// `Some("العربية")`
        pub const LANG_NAME: Option<&str> = Some("العربية");
        /// `Some("ara")`
        pub const LANG_TERM: Option<&str> = Some("ara");
        /// `Some("%z%c%T%s%b%e%r")`
        pub const POSTAL_FMT: Option<&str> = Some("%z%c%T%s%b%e%r");
    }
    pub mod LC_IDENTIFICATION {
        /// `None`
        pub const ABBREVIATION: Option<&str> = None;
        /// `Some("1623-14, Shimotsuruma, Yamato-shi, Kanagawa-ken, 242-8502, Japan")`
        pub const ADDRESS: Option<&str> = Some("1623-14, Shimotsuruma, Yamato-shi, Kanagawa-ken, 242-8502, Japan");
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        /// ]
        /// ```
        pub const CATEGORY: Option<&[&[&str]]> = Some(&[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_TELEPHONE"],
            &["i18n:2012", "LC_MEASUREMENT"],
        ]);
        /// `Some("")`
        pub const CONTACT: Option<&str> = Some("");
        /// `Some("2000-07-20")`
        pub const DATE: Option<&str> = Some("2000-07-20");
        /// `Some("bug-glibc-locales@gnu.org")`
        pub const EMAIL: Option<&str> = Some("bug-glibc-locales@gnu.org");
        /// `Some("")`
        pub const FAX: Option<&str> = Some("");
        /// `Some("Arabic")`
        pub const LANGUAGE: Option<&str> = Some("Arabic");
        /// `Some("1.0")`
        pub const REVISION: Option<&str> = Some("1.0");
        /// `Some("IBM Globalization Center of Competency, Yamato Software Laboratory")`
        pub const SOURCE: Option<&str> = Some("IBM Globalization Center of Competency, Yamato Software Laboratory");
        /// `Some("")`
        pub const TEL: Option<&str> = Some("");
        /// `Some("Oman")`
        pub const TERRITORY: Option<&str> = Some("Oman");
        /// `Some("Arabic language locale for Oman")`
        pub const TITLE: Option<&str> = Some("Arabic language locale for Oman");
    }
    pub use super::ar_EG::LC_MESSAGES;
    pub mod LC_MONETARY {
        /// `"ر.ع."`
        pub const CURRENCY_SYMBOL: &str = "ر.ع.";
        /// `3`
        pub const FRAC_DIGITS: i64 = 3;
        /// `"OMR "`
        pub const INT_CURR_SYMBOL: &str = "OMR ";
        /// `3`
        pub const INT_FRAC_DIGITS: i64 = 3;
        /// `None`
        pub const INT_N_CS_PRECEDES: Option<i64> = None;
        /// `None`
        pub const INT_N_SEP_BY_SPACE: Option<i64> = None;
        /// `None`
        pub const INT_N_SIGN_POSN: Option<i64> = None;
        /// `None`
        pub const INT_P_CS_PRECEDES: Option<i64> = None;
        /// `None`
        pub const INT_P_SEP_BY_SPACE: Option<i64> = None;
        /// `None`
        pub const INT_P_SIGN_POSN: Option<i64> = None;
        /// `"."`
        pub const MON_DECIMAL_POINT: &str = ".";
        /// `&[3]`
        pub const MON_GROUPING: &[i64] = &[3];
        /// `","`
        pub const MON_THOUSANDS_SEP: &str = ",";
        /// `"-"`
        pub const NEGATIVE_SIGN: &str = "-";
        /// `1`
        pub const N_CS_PRECEDES: i64 = 1;
        /// `1`
        pub const N_SEP_BY_SPACE: i64 = 1;
        /// `2`
        pub const N_SIGN_POSN: i64 = 2;
        /// `""`
        pub const POSITIVE_SIGN: &str = "";
        /// `1`
        pub const P_CS_PRECEDES: i64 = 1;
        /// `1`
        pub const P_SEP_BY_SPACE: i64 = 1;
        /// `1`
        pub const P_SIGN_POSN: i64 = 1;
    }
    pub mod LC_NUMERIC {
        /// `"."`
        pub const DECIMAL_POINT: &str = ".";
        /// `&[3]`
        pub const GROUPING: &[i64] = &[3];
        /// `","`
        pub const THOUSANDS_SEP: &str = ",";
    }
    pub mod LC_TELEPHONE {
        /// `Some("968")`
        pub const INT_PREFIX: Option<&str> = Some("968");
        /// `Some("00")`
        pub const INT_SELECT: Option<&str> = Some("00");
        /// `None`
        pub const TEL_DOM_FMT: Option<&str> = None;
        /// `Some("+%c ;%a ;%l")`
        pub const TEL_INT_FMT: Option<&str> = Some("+%c ;%a ;%l");
    }
    pub mod LC_TIME {
        /// `&["ح", "ن", "ث", "ر", "خ", "ج", "س"]`
        pub const ABDAY: &[&str] = &["ح", "ن", "ث", "ر", "خ", "ج", "س"];
        /// `&["ينا", "فبر", "مار", "أبر", "ماي", "يون", "يول", "أغس", "سبت", "أكت", "نوف", "ديس"]`
        pub const ABMON: &[&str] = &["ينا", "فبر", "مار", "أبر", "ماي", "يون", "يول", "أغس", "سبت", "أكت", "نوف", "ديس"];
        /// `None`
        pub const AB_ALT_MON: Option<&[&str]> = None;
        /// `None`
        pub const ALT_DIGITS: Option<&[&str]> = None;
        /// `None`
        pub const ALT_MON: Option<&[&str]> = None;
        /// `&["ص", "م"]`
        pub const AM_PM: &[&str] = &["ص", "م"];
        /// `None`
        pub const CAL_DIRECTION: Option<i64> = None;
        /// `None`
        pub const DATE_FMT: Option<&str> = None;
        /// `&["الأحد", "الاثنين", "الثلاثاء", "الأربعاء", "الخميس", "الجمعة", "السبت"]`
        pub const DAY: &[&str] = &["الأحد", "الاثنين", "الثلاثاء", "الأربعاء", "الخميس", "الجمعة", "السبت"];
        /// `"%d %b, %Y"`
        pub const D_FMT: &str = "%d %b, %Y";
        /// `"%d %b, %Y %Z %I:%M:%S %p"`
        pub const D_T_FMT: &str = "%d %b, %Y %Z %I:%M:%S %p";
        /// `None`
        pub const ERA: Option<&[&str]> = None;
        /// `None`
        pub const ERA_D_FMT: Option<&str> = None;
        /// `None`
        pub const ERA_D_T_FMT: Option<&str> = None;
        /// `None`
        pub const ERA_T_FMT: Option<&str> = None;
        /// `Some(7)`
        pub const FIRST_WEEKDAY: Option<i64> = Some(7);
        /// `Some(1)`
        pub const FIRST_WORKDAY: Option<i64> = Some(1);
        /// `&["يناير", "فبراير", "مارس", "أبريل", "مايو", "يونيو", "يوليو", "أغسطس", "سبتمبر", "أكتوبر", "نوفمبر", "ديسمبر"]`
        pub const MON: &[&str] = &["يناير", "فبراير", "مارس", "أبريل", "مايو", "يونيو", "يوليو", "أغسطس", "سبتمبر", "أكتوبر", "نوفمبر", "ديسمبر"];
        /// `"%Z %I:%M:%S %p"`
        pub const T_FMT: &str = "%Z %I:%M:%S %p";
        /// `"%Z %I:%M:%S %p"`
        pub const T_FMT_AMPM: &str = "%Z %I:%M:%S %p";
        /// `Some(&[7, 19971130, 1])`
        pub const WEEK: Option<&[i64]> = Some(&[7, 19971130, 1]);
    }
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod ar_QA {
    pub mod LC_ADDRESS {
        /// `Some("QAT")`
        pub const COUNTRY_AB3: Option<&str> = Some("QAT");
        /// `Some("QA")`
        pub const COUNTRY_ABTWO: Option<&str> = Some("QA");
        /// `Some("Q")`
        pub const COUNTRY_CAR: Option<&str> = Some("Q");
        /// `None`
        pub const COUNTRY_ISBN: Option<&str> = None;
        /// `Some("قطر")`
        pub const COUNTRY_NAME: Option<&str> = Some("قطر");
        /// `Some(634)`
        pub const COUNTRY_NUM: Option<i64> = Some(634);
        /// `None`
        pub const COUNTRY_POST: Option<&str> = None;
        /// `Some("ar")`
        pub const LANG_AB: Option<&str> = Some("ar");
        /// `Some("ara")`
        pub const LANG_LIB: Option<&str> = Some("ara");
        /// `Some("العربية")`
        pub const LANG_NAME: Option<&str> = Some("العربية");
        /// `Some("ara")`
        pub const LANG_TERM: Option<&str> = Some("ara");
        /// `Some("%z%c%T%s%b%e%r")`
        pub const POSTAL_FMT: Option<&str> = Some("%z%c%T%s%b%e%r");
    }
    pub mod LC_IDENTIFICATION {
        /// `None`
        pub const ABBREVIATION: Option<&str> = None;
        /// `Some("1623-14, Shimotsuruma, Yamato-shi, Kanagawa-ken, 242-8502, Japan")`
        pub const ADDRESS: Option<&str> = Some("1623-14, Shimotsuruma, Yamato-shi, Kanagawa-ken, 242-8502, Japan");
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        /// ]
        /// ```
        pub const CATEGORY: Option<&[&[&str]]> = Some(&[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_TELEPHONE"],
            &["i18n:2012", "LC_MEASUREMENT"],
        ]);
        /// `Some("")`
        pub const CONTACT: Option<&str> = Some("");
        /// `Some("2000-07-20")`
        pub const DATE: Option<&str> = Some("2000-07-20");
        /// `Some("bug-glibc-locales@gnu.org")`
        pub const EMAIL: Option<&str> = Some("bug-glibc-locales@gnu.org");
        /// `Some("")`
        pub const FAX: Option<&str> = Some("");
        /// `Some("Arabic")`
        pub const LANGUAGE: Option<&str> = Some("Arabic");
        /// `Some("1.0")`
        pub const REVISION: Option<&str> = Some("1.0");
        /// `Some("IBM Globalization Center of Competency, Yamato Software Laboratory")`
        pub const SOURCE: Option<&str> = Some("IBM Globalization Center of Competency, Yamato Software Laboratory");
        /// `Some("")`
        pub const TEL: Option<&str> = Some("");
        /// `Some("Qatar")`
        pub const TERRITORY: Option<&str> = Some("Qatar");
        /// `Some("Arabic language locale for Qatar")`
        pub const TITLE: Option<&str> = Some("Arabic language locale for Qatar");
    }
    pub use super::ar_EG::LC_MESSAGES;
    pub mod LC_MONETARY {
        /// `"ر.ق."`
        pub const CURRENCY_SYMBOL: &str = "ر.ق.";
        /// `3`
        pub const FRAC_DIGITS: i64 = 3;
        /// `"QAR "`
        pub const INT_CURR_SYMBOL: &str = "QAR ";
        /// `3`
        pub const INT_FRAC_DIGITS: i64 = 3;
        /// `None`
        pub const INT_N_CS_PRECEDES: Option<i64> = None;
        /// `None`
        pub const INT_N_SEP_BY_SPACE: Option<i64> = None;
        /// `None`
        pub const INT_N_SIGN_POSN: Option<i64> = None;
        /// `None`
        pub const INT_P_CS_PRECEDES: Option<i64> = None;
        /// `None`
        pub const INT_P_SEP_BY_SPACE: Option<i64> = None;
        /// `None`
        pub const INT_P_SIGN_POSN: Option<i64> = None;
        /// `"."`
        pub const MON_DECIMAL_POINT: &str = ".";
        /// `&[3]`
        pub const MON_GROUPING: &[i64] = &[3];
        /// `","`
        pub const MON_THOUSANDS_SEP: &str = ",";
        /// `"-"`
        pub const NEGATIVE_SIGN: &str = "-";
        /// `1`
        pub const N_CS_PRECEDES: i64 = 1;
        /// `1`
        pub const N_SEP_BY_SPACE: i64 = 1;
        /// `2`
        pub const N_SIGN_POSN: i64 = 2;
        /// `""`
        pub const POSITIVE_SIGN: &str = "";
        /// `1`
        pub const P_CS_PRECEDES: i64 = 1;
        /// `1`
        pub const P_SEP_BY_SPACE: i64 = 1;
        /// `1`
        pub const P_SIGN_POSN: i64 = 1;
    }
    pub mod LC_NUMERIC {
        /// `"."`
        pub const DECIMAL_POINT: &str = ".";
        /// `&[3]`
        pub const GROUPING: &[i64] = &[3];
        /// `","`
        pub const THOUSANDS_SEP: &str = ",";
    }
    pub mod LC_TELEPHONE {
        /// `Some("974")`
        pub const INT_PREFIX: Option<&str> = Some("974");
        /// `Some("00")`
        pub const INT_SELECT: Option<&str> = Some("00");
        /// `None`
        pub const TEL_DOM_FMT: Option<&str> = None;
        /// `Some("+%c ;%a ;%l")`
        pub const TEL_INT_FMT: Option<&str> = Some("+%c ;%a ;%l");
    }
    pub mod LC_TIME {
        /// `&["ح", "ن", "ث", "ر", "خ", "ج", "س"]`
        pub const ABDAY: &[&str] = &["ح", "ن", "ث", "ر", "خ", "ج", "س"];
        /// `&["ينا", "فبر", "مار", "أبر", "ماي", "يون", "يول", "أغس", "سبت", "أكت", "نوف", "ديس"]`
        pub const ABMON: &[&str] = &["ينا", "فبر", "مار", "أبر", "ماي", "يون", "يول", "أغس", "سبت", "أكت", "نوف", "ديس"];
        /// `None`
        pub const AB_ALT_MON: Option<&[&str]> = None;
        /// `None`
        pub const ALT_DIGITS: Option<&[&str]> = None;
        /// `None`
        pub const ALT_MON: Option<&[&str]> = None;
        /// `&["ص", "م"]`
        pub const AM_PM: &[&str] = &["ص", "م"];
        /// `None`
        pub const CAL_DIRECTION: Option<i64> = None;
        /// `None`
        pub const DATE_FMT: Option<&str> = None;
        /// `&["الأحد", "الاثنين", "الثلاثاء", "الأربعاء", "الخميس", "الجمعة", "السبت"]`
        pub const DAY: &[&str] = &["الأحد", "الاثنين", "الثلاثاء", "الأربعاء", "الخميس", "الجمعة", "السبت"];
        /// `"%d %b, %Y"`
        pub const D_FMT: &str = "%d %b, %Y";
        /// `"%d %b, %Y %Z %I:%M:%S %p"`
        pub const D_T_FMT: &str = "%d %b, %Y %Z %I:%M:%S %p";
        /// `None`
        pub const ERA: Option<&[&str]> = None;
        /// `None`
        pub const ERA_D_FMT: Option<&str> = None;
        /// `None`
        pub const ERA_D_T_FMT: Option<&str> = None;
        /// `None`
        pub const ERA_T_FMT: Option<&str> = None;
        /// `Some(7)`
        pub const FIRST_WEEKDAY: Option<i64> = Some(7);
        /// `Some(1)`
        pub const FIRST_WORKDAY: Option<i64> = Some(1);
        /// `&["يناير", "فبراير", "مارس", "أبريل", "مايو", "يونيو", "يوليو", "أغسطس", "سبتمبر", "أكتوبر", "نوفمبر", "ديسمبر"]`
        pub const MON: &[&str] = &["يناير", "فبراير", "مارس", "أبريل", "مايو", "يونيو", "يوليو", "أغسطس", "سبتمبر", "أكتوبر", "نوفمبر", "ديسمبر"];
        /// `"%Z %I:%M:%S %p"`
        pub const T_FMT: &str = "%Z %I:%M:%S %p";
        /// `"%Z %I:%M:%S %p"`
        pub const T_FMT_AMPM: &str = "%Z %I:%M:%S %p";
        /// `Some(&[7, 19971130, 1])`
        pub const WEEK: Option<&[i64]> = Some(&[7, 19971130, 1]);
    }
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod ar_SA {
    pub mod LC_ADDRESS {
        /// `Some("SAU")`
        pub const COUNTRY_AB3: Option<&str> = Some("SAU");
        /// `Some("SA")`
        pub const COUNTRY_ABTWO: Option<&str> = Some("SA");
        /// `Some("KSA")`
        pub const COUNTRY_CAR: Option<&str> = Some("KSA");
        /// `None`
        pub const COUNTRY_ISBN: Option<&str> = None;
        /// `Some("المملكة العربية السعودية")`
        pub const COUNTRY_NAME: Option<&str> = Some("المملكة العربية السعودية");
        /// `Some(682)`
        pub const COUNTRY_NUM: Option<i64> = Some(682);
        /// `None`
        pub const COUNTRY_POST: Option<&str> = None;
        /// `Some("ar")`
        pub const LANG_AB: Option<&str> = Some("ar");
        /// `Some("ara")`
        pub const LANG_LIB: Option<&str> = Some("ara");
        /// `Some("العربية")`
        pub const LANG_NAME: Option<&str> = Some("العربية");
        /// `Some("ara")`
        pub const LANG_TERM: Option<&str> = Some("ara");
        /// `Some("%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%c%N")`
        pub const POSTAL_FMT: Option<&str> = Some("%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%c%N");
    }
    pub mod LC_IDENTIFICATION {
        /// `None`
        pub const ABBREVIATION: Option<&str> = None;
        /// `Some("")`
        pub const ADDRESS: Option<&str> = Some("");
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        /// ]
        /// ```
        pub const CATEGORY: Option<&[&[&str]]> = Some(&[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_TELEPHONE"],
            &["i18n:2012", "LC_MEASUREMENT"],
        ]);
        /// `Some("")`
        pub const CONTACT: Option<&str> = Some("");
        /// `Some("2000-06-29")`
        pub const DATE: Option<&str> = Some("2000-06-29");
        /// `Some("bug-glibc-locales@gnu.org")`
        pub const EMAIL: Option<&str> = Some("bug-glibc-locales@gnu.org");
        /// `Some("")`
        pub const FAX: Option<&str> = Some("");
        /// `Some("Arabic")`
        pub const LANGUAGE: Option<&str> = Some("Arabic");
        /// `Some("1.0")`
        pub const REVISION: Option<&str> = Some("1.0");
        /// `Some("")`
        pub const SOURCE: Option<&str> = Some("");
        /// `Some("")`
        pub const TEL: Option<&str> = Some("");
        /// `Some("Saudi Arabia")`
        pub const TERRITORY: Option<&str> = Some("Saudi Arabia");
        /// `Some("Arabic locale for Saudi Arabia")`
        pub const TITLE: Option<&str> = Some("Arabic locale for Saudi Arabia");
    }
    pub use super::ar_EG::LC_MESSAGES;
    pub mod LC_MONETARY {
        /// `"ر.س"`
        pub const CURRENCY_SYMBOL: &str = "ر.س";
        /// `2`
        pub const FRAC_DIGITS: i64 = 2;
        /// `"SAR "`
        pub const INT_CURR_SYMBOL: &str = "SAR ";
        /// `2`
        pub const INT_FRAC_DIGITS: i64 = 2;
        /// `None`
        pub const INT_N_CS_PRECEDES: Option<i64> = None;
        /// `None`
        pub const INT_N_SEP_BY_SPACE: Option<i64> = None;
        /// `None`
        pub const INT_N_SIGN_POSN: Option<i64> = None;
        /// `None`
        pub const INT_P_CS_PRECEDES: Option<i64> = None;
        /// `None`
        pub const INT_P_SEP_BY_SPACE: Option<i64> = None;
        /// `None`
        pub const INT_P_SIGN_POSN: Option<i64> = None;
        /// `"."`
        pub const MON_DECIMAL_POINT: &str = ".";
        /// `&[-1]`
        pub const MON_GROUPING: &[i64] = &[-1];
        /// `""`
        pub const MON_THOUSANDS_SEP: &str = "";
        /// `"-"`
        pub const NEGATIVE_SIGN: &str = "-";
        /// `0`
        pub const N_CS_PRECEDES: i64 = 0;
        /// `1`
        pub const N_SEP_BY_SPACE: i64 = 1;
        /// `1`
        pub const N_SIGN_POSN: i64 = 1;
        /// `""`
        pub const POSITIVE_SIGN: &str = "";
        /// `0`
        pub const P_CS_PRECEDES: i64 = 0;
        /// `1`
        pub const P_SEP_BY_SPACE: i64 = 1;
        /// `1`
        pub const P_SIGN_POSN: i64 = 1;
    }
    pub mod LC_NUMERIC {
        /// `"."`
        pub const DECIMAL_POINT: &str = ".";
        /// `&[-1]`
        pub const GROUPING: &[i64] = &[-1];
        /// `""`
        pub const THOUSANDS_SEP: &str = "";
    }
    pub mod LC_TELEPHONE {
        /// `Some("966")`
        pub const INT_PREFIX: Option<&str> = Some("966");
        /// `Some("00")`
        pub const INT_SELECT: Option<&str> = Some("00");
        /// `None`
        pub const TEL_DOM_FMT: Option<&str> = None;
        /// `Some("+%c %a %l")`
        pub const TEL_INT_FMT: Option<&str> = Some("+%c %a %l");
    }
    pub mod LC_TIME {
        /// `&["ح", "ن", "ث", "ر", "خ", "ج", "س"]`
        pub const ABDAY: &[&str] = &["ح", "ن", "ث", "ر", "خ", "ج", "س"];
        /// `&["يناير", "فبراير", "مارس", "أبريل", "مايو", "يونيو", "يوليو", "أغسطس", "سبتمبر", "أكتوبر", "نوفمبر", "ديسمبر"]`
        pub const ABMON: &[&str] = &["يناير", "فبراير", "مارس", "أبريل", "مايو", "يونيو", "يوليو", "أغسطس", "سبتمبر", "أكتوبر", "نوفمبر", "ديسمبر"];
        /// `None`
        pub const AB_ALT_MON: Option<&[&str]> = None;
        /// `None`
        pub const ALT_DIGITS: Option<&[&str]> = None;
        /// `None`
        pub const ALT_MON: Option<&[&str]> = None;
        /// `&["", ""]`
        pub const AM_PM: &[&str] = &["", ""];
        /// `None`
        pub const CAL_DIRECTION: Option<i64> = None;
        /// `None`
        pub const DATE_FMT: Option<&str> = None;
        /// `&["الأحد", "الإثنين", "الثلاثاء", "الأربعاء", "الخميس", "الجمعـة", "السبت"]`
        pub const DAY: &[&str] = &["الأحد", "الإثنين", "الثلاثاء", "الأربعاء", "الخميس", "الجمعـة", "السبت"];
        /// `"%A %e %B %Y"`
        pub const D_FMT: &str = "%A %e %B %Y";
        /// `"%A %e %B %Y  %k:%M:%S"`
        pub const D_T_FMT: &str = "%A %e %B %Y  %k:%M:%S";
        /// `None`
        pub const ERA: Option<&[&str]> = None;
        /// `Some("")`
        pub const ERA_D_FMT: Option<&str> = Some("");
        /// `None`
        pub const ERA_D_T_FMT: Option<&str> = None;
        /// `None`
        pub const ERA_T_FMT: Option<&str> = None;
        /// `None`
        pub const FIRST_WEEKDAY: Option<i64> = None;
        /// `Some(1)`
        pub const FIRST_WORKDAY: Option<i64> = Some(1);
        /// `&["يناير", "فبراير", "مارس", "أبريل", "مايو", "يونيو", "يوليو", "أغسطس", "سبتمبر", "أكتوبر", "نوفمبر", "ديسمبر"]`
        pub const MON: &[&str] = &["يناير", "فبراير", "مارس", "أبريل", "مايو", "يونيو", "يوليو", "أغسطس", "سبتمبر", "أكتوبر", "نوفمبر", "ديسمبر"];
        /// `"%k:%M:%S"`
        pub const T_FMT: &str = "%k:%M:%S";
        /// `"%k:%M:%S"`
        pub const T_FMT_AMPM: &str = "%k:%M:%S";
        /// `Some(&[7, 19971130, 1])`
        pub const WEEK: Option<&[i64]> = Some(&[7, 19971130, 1]);
    }
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod ar_SD {
    pub mod LC_ADDRESS {
        /// `Some("SDN")`
        pub const COUNTRY_AB3: Option<&str> = Some("SDN");
        /// `Some("SD")`
        pub const COUNTRY_ABTWO: Option<&str> = Some("SD");
        /// `Some("SUD")`
        pub const COUNTRY_CAR: Option<&str> = Some("SUD");
        /// `None`
        pub const COUNTRY_ISBN: Option<&str> = None;
        /// `Some("السودان")`
        pub const COUNTRY_NAME: Option<&str> = Some("السودان");
        /// `Some(729)`
        pub const COUNTRY_NUM: Option<i64> = Some(729);
        /// `None`
        pub const COUNTRY_POST: Option<&str> = None;
        /// `Some("ar")`
        pub const LANG_AB: Option<&str> = Some("ar");
        /// `Some("ara")`
        pub const LANG_LIB: Option<&str> = Some("ara");
        /// `Some("العربية")`
        pub const LANG_NAME: Option<&str> = Some("العربية");
        /// `Some("ara")`
        pub const LANG_TERM: Option<&str> = Some("ara");
        /// `Some("%z%c%T%s%b%e%r")`
        pub const POSTAL_FMT: Option<&str> = Some("%z%c%T%s%b%e%r");
    }
    pub mod LC_IDENTIFICATION {
        /// `None`
        pub const ABBREVIATION: Option<&str> = None;
        /// `Some("1623-14, Shimotsuruma, Yamato-shi, Kanagawa-ken, 242-8502, Japan")`
        pub const ADDRESS: Option<&str> = Some("1623-14, Shimotsuruma, Yamato-shi, Kanagawa-ken, 242-8502, Japan");
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        /// ]
        /// ```
        pub const CATEGORY: Option<&[&[&str]]> = Some(&[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_TELEPHONE"],
            &["i18n:2012", "LC_MEASUREMENT"],
        ]);
        /// `Some("")`
        pub const CONTACT: Option<&str> = Some("");
        /// `Some("2000-07-20")`
        pub const DATE: Option<&str> = Some("2000-07-20");
        /// `Some("bug-glibc-locales@gnu.org")`
        pub const EMAIL: Option<&str> = Some("bug-glibc-locales@gnu.org");
        /// `Some("")`
        pub const FAX: Option<&str> = Some("");
        /// `Some("Arabic")`
        pub const LANGUAGE: Option<&str> = Some("Arabic");
        /// `Some("1.1")`
        pub const REVISION: Option<&str> = Some("1.1");
        /// `Some("IBM Globalization Center of Competency, Yamato Software Laboratory")`
        pub const SOURCE: Option<&str> = Some("IBM Globalization Center of Competency, Yamato Software Laboratory");
        /// `Some("")`
        pub const TEL: Option<&str> = Some("");
        /// `Some("Sudan")`
        pub const TERRITORY: Option<&str> = Some("Sudan");
        /// `Some("Arabic language locale for Sudan")`
        pub const TITLE: Option<&str> = Some("Arabic language locale for Sudan");
    }
    pub use super::ar_EG::LC_MESSAGES;
    pub mod LC_MONETARY {
        /// `"ج.س."`
        pub const CURRENCY_SYMBOL: &str = "ج.س.";
        /// `3`
        pub const FRAC_DIGITS: i64 = 3;
        /// `"SDG "`
        pub const INT_CURR_SYMBOL: &str = "SDG ";
        /// `3`
        pub const INT_FRAC_DIGITS: i64 = 3;
        /// `None`
        pub const INT_N_CS_PRECEDES: Option<i64> = None;
        /// `None`
        pub const INT_N_SEP_BY_SPACE: Option<i64> = None;
        /// `None`
        pub const INT_N_SIGN_POSN: Option<i64> = None;
        /// `None`
        pub const INT_P_CS_PRECEDES: Option<i64> = None;
        /// `None`
        pub const INT_P_SEP_BY_SPACE: Option<i64> = None;
        /// `None`
        pub const INT_P_SIGN_POSN: Option<i64> = None;
        /// `"."`
        pub const MON_DECIMAL_POINT: &str = ".";
        /// `&[3]`
        pub const MON_GROUPING: &[i64] = &[3];
        /// `","`
        pub const MON_THOUSANDS_SEP: &str = ",";
        /// `"-"`
        pub const NEGATIVE_SIGN: &str = "-";
        /// `1`
        pub const N_CS_PRECEDES: i64 = 1;
        /// `1`
        pub const N_SEP_BY_SPACE: i64 = 1;
        /// `2`
        pub const N_SIGN_POSN: i64 = 2;
        /// `""`
        pub const POSITIVE_SIGN: &str = "";
        /// `1`
        pub const P_CS_PRECEDES: i64 = 1;
        /// `1`
        pub const P_SEP_BY_SPACE: i64 = 1;
        /// `1`
        pub const P_SIGN_POSN: i64 = 1;
    }
    pub mod LC_NUMERIC {
        /// `"."`
        pub const DECIMAL_POINT: &str = ".";
        /// `&[3]`
        pub const GROUPING: &[i64] = &[3];
        /// `","`
        pub const THOUSANDS_SEP: &str = ",";
    }
    pub mod LC_TELEPHONE {
        /// `Some("249")`
        pub const INT_PREFIX: Option<&str> = Some("249");
        /// `Some("00")`
        pub const INT_SELECT: Option<&str> = Some("00");
        /// `None`
        pub const TEL_DOM_FMT: Option<&str> = None;
        /// `Some("+%c ;%a ;%l")`
        pub const TEL_INT_FMT: Option<&str> = Some("+%c ;%a ;%l");
    }
    pub mod LC_TIME {
        /// `&["ح", "ن", "ث", "ر", "خ", "ج", "س"]`
        pub const ABDAY: &[&str] = &["ح", "ن", "ث", "ر", "خ", "ج", "س"];
        /// `&["ينا", "فبر", "مار", "أبر", "ماي", "يون", "يول", "أغس", "سبت", "أكت", "نوف", "ديس"]`
        pub const ABMON: &[&str] = &["ينا", "فبر", "مار", "أبر", "ماي", "يون", "يول", "أغس", "سبت", "أكت", "نوف", "ديس"];
        /// `None`
        pub const AB_ALT_MON: Option<&[&str]> = None;
        /// `None`
        pub const ALT_DIGITS: Option<&[&str]> = None;
        /// `None`
        pub const ALT_MON: Option<&[&str]> = None;
        /// `&["ص", "م"]`
        pub const AM_PM: &[&str] = &["ص", "م"];
        /// `None`
        pub const CAL_DIRECTION: Option<i64> = None;
        /// `None`
        pub const DATE_FMT: Option<&str> = None;
        /// `&["الأحد", "الاثنين", "الثلاثاء", "الأربعاء", "الخميس", "الجمعة", "السبت"]`
        pub const DAY: &[&str] = &["الأحد", "الاثنين", "الثلاثاء", "الأربعاء", "الخميس", "الجمعة", "السبت"];
        /// `"%d %b, %Y"`
        pub const D_FMT: &str = "%d %b, %Y";
        /// `"%d %b, %Y %Z %I:%M:%S %p"`
        pub const D_T_FMT: &str = "%d %b, %Y %Z %I:%M:%S %p";
        /// `None`
        pub const ERA: Option<&[&str]> = None;
        /// `None`
        pub const ERA_D_FMT: Option<&str> = None;
        /// `None`
        pub const ERA_D_T_FMT: Option<&str> = None;
        /// `None`
        pub const ERA_T_FMT: Option<&str> = None;
        /// `Some(7)`
        pub const FIRST_WEEKDAY: Option<i64> = Some(7);
        /// `Some(1)`
        pub const FIRST_WORKDAY: Option<i64> = Some(1);
        /// `&["يناير", "فبراير", "مارس", "أبريل", "مايو", "يونيو", "يوليو", "أغسطس", "سبتمبر", "أكتوبر", "نوفمبر", "ديسمبر"]`
        pub const MON: &[&str] = &["يناير", "فبراير", "مارس", "أبريل", "مايو", "يونيو", "يوليو", "أغسطس", "سبتمبر", "أكتوبر", "نوفمبر", "ديسمبر"];
        /// `"%Z %I:%M:%S %p"`
        pub const T_FMT: &str = "%Z %I:%M:%S %p";
        /// `"%Z %I:%M:%S %p"`
        pub const T_FMT_AMPM: &str = "%Z %I:%M:%S %p";
        /// `Some(&[7, 19971130, 1])`
        pub const WEEK: Option<&[i64]> = Some(&[7, 19971130, 1]);
    }
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod ar_SS {
    pub mod LC_ADDRESS {
        /// `Some("SSD")`
        pub const COUNTRY_AB3: Option<&str> = Some("SSD");
        /// `Some("SS")`
        pub const COUNTRY_ABTWO: Option<&str> = Some("SS");
        /// `Some("SUD")`
        pub const COUNTRY_CAR: Option<&str> = Some("SUD");
        /// `None`
        pub const COUNTRY_ISBN: Option<&str> = None;
        /// `Some("جنوب السودان")`
        pub const COUNTRY_NAME: Option<&str> = Some("جنوب السودان");
        /// `Some(728)`
        pub const COUNTRY_NUM: Option<i64> = Some(728);
        /// `None`
        pub const COUNTRY_POST: Option<&str> = None;
        /// `Some("ar")`
        pub const LANG_AB: Option<&str> = Some("ar");
        /// `Some("ara")`
        pub const LANG_LIB: Option<&str> = Some("ara");
        /// `Some("العربية")`
        pub const LANG_NAME: Option<&str> = Some("العربية");
        /// `Some("ara")`
        pub const LANG_TERM: Option<&str> = Some("ara");
        /// `Some("%z%c%T%s%b%e%r")`
        pub const POSTAL_FMT: Option<&str> = Some("%z%c%T%s%b%e%r");
    }
    pub mod LC_IDENTIFICATION {
        /// `None`
        pub const ABBREVIATION: Option<&str> = None;
        /// `Some("1623-14, Shimotsuruma, Yamato-shi, Kanagawa-ken, 242-8502, Japan")`
        pub const ADDRESS: Option<&str> = Some("1623-14, Shimotsuruma, Yamato-shi, Kanagawa-ken, 242-8502, Japan");
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        /// ]
        /// ```
        pub const CATEGORY: Option<&[&[&str]]> = Some(&[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_TELEPHONE"],
            &["i18n:2012", "LC_MEASUREMENT"],
        ]);
        /// `Some("")`
        pub const CONTACT: Option<&str> = Some("");
        /// `Some("2000-07-20")`
        pub const DATE: Option<&str> = Some("2000-07-20");
        /// `Some("bug-glibc-locales@gnu.org")`
        pub const EMAIL: Option<&str> = Some("bug-glibc-locales@gnu.org");
        /// `Some("")`
        pub const FAX: Option<&str> = Some("");
        /// `Some("Arabic")`
        pub const LANGUAGE: Option<&str> = Some("Arabic");
        /// `Some("1.1")`
        pub const REVISION: Option<&str> = Some("1.1");
        /// `Some("IBM Globalization Center of Competency, Yamato Software Laboratory")`
        pub const SOURCE: Option<&str> = Some("IBM Globalization Center of Competency, Yamato Software Laboratory");
        /// `Some("")`
        pub const TEL: Option<&str> = Some("");
        /// `Some("South Sudan")`
        pub const TERRITORY: Option<&str> = Some("South Sudan");
        /// `Some("Arabic language locale for South Sudan")`
        pub const TITLE: Option<&str> = Some("Arabic language locale for South Sudan");
    }
    pub use super::ar_EG::LC_MESSAGES;
    pub mod LC_MONETARY {
        /// `"£"`
        pub const CURRENCY_SYMBOL: &str = "£";
        /// `3`
        pub const FRAC_DIGITS: i64 = 3;
        /// `"SSP "`
        pub const INT_CURR_SYMBOL: &str = "SSP ";
        /// `3`
        pub const INT_FRAC_DIGITS: i64 = 3;
        /// `None`
        pub const INT_N_CS_PRECEDES: Option<i64> = None;
        /// `None`
        pub const INT_N_SEP_BY_SPACE: Option<i64> = None;
        /// `None`
        pub const INT_N_SIGN_POSN: Option<i64> = None;
        /// `None`
        pub const INT_P_CS_PRECEDES: Option<i64> = None;
        /// `None`
        pub const INT_P_SEP_BY_SPACE: Option<i64> = None;
        /// `None`
        pub const INT_P_SIGN_POSN: Option<i64> = None;
        /// `"."`
        pub const MON_DECIMAL_POINT: &str = ".";
        /// `&[3]`
        pub const MON_GROUPING: &[i64] = &[3];
        /// `","`
        pub const MON_THOUSANDS_SEP: &str = ",";
        /// `"-"`
        pub const NEGATIVE_SIGN: &str = "-";
        /// `1`
        pub const N_CS_PRECEDES: i64 = 1;
        /// `1`
        pub const N_SEP_BY_SPACE: i64 = 1;
        /// `2`
        pub const N_SIGN_POSN: i64 = 2;
        /// `""`
        pub const POSITIVE_SIGN: &str = "";
        /// `1`
        pub const P_CS_PRECEDES: i64 = 1;
        /// `1`
        pub const P_SEP_BY_SPACE: i64 = 1;
        /// `1`
        pub const P_SIGN_POSN: i64 = 1;
    }
    pub mod LC_NUMERIC {
        /// `"."`
        pub const DECIMAL_POINT: &str = ".";
        /// `&[3]`
        pub const GROUPING: &[i64] = &[3];
        /// `","`
        pub const THOUSANDS_SEP: &str = ",";
    }
    pub mod LC_TELEPHONE {
        /// `Some("211")`
        pub const INT_PREFIX: Option<&str> = Some("211");
        /// `Some("00")`
        pub const INT_SELECT: Option<&str> = Some("00");
        /// `None`
        pub const TEL_DOM_FMT: Option<&str> = None;
        /// `Some("+%c ;%a ;%l")`
        pub const TEL_INT_FMT: Option<&str> = Some("+%c ;%a ;%l");
    }
    pub mod LC_TIME {
        /// `&["ح", "ن", "ث", "ر", "خ", "ج", "س"]`
        pub const ABDAY: &[&str] = &["ح", "ن", "ث", "ر", "خ", "ج", "س"];
        /// `&["ينا", "فبر", "مار", "أبر", "ماي", "يون", "يول", "أغس", "سبت", "أكت", "نوف", "ديس"]`
        pub const ABMON: &[&str] = &["ينا", "فبر", "مار", "أبر", "ماي", "يون", "يول", "أغس", "سبت", "أكت", "نوف", "ديس"];
        /// `None`
        pub const AB_ALT_MON: Option<&[&str]> = None;
        /// `None`
        pub const ALT_DIGITS: Option<&[&str]> = None;
        /// `None`
        pub const ALT_MON: Option<&[&str]> = None;
        /// `&["ص", "م"]`
        pub const AM_PM: &[&str] = &["ص", "م"];
        /// `None`
        pub const CAL_DIRECTION: Option<i64> = None;
        /// `None`
        pub const DATE_FMT: Option<&str> = None;
        /// `&["الأحد", "الاثنين", "الثلاثاء", "الأربعاء", "الخميس", "الجمعة", "السبت"]`
        pub const DAY: &[&str] = &["الأحد", "الاثنين", "الثلاثاء", "الأربعاء", "الخميس", "الجمعة", "السبت"];
        /// `"%d %b, %Y"`
        pub const D_FMT: &str = "%d %b, %Y";
        /// `"%d %b, %Y %Z %I:%M:%S %p"`
        pub const D_T_FMT: &str = "%d %b, %Y %Z %I:%M:%S %p";
        /// `None`
        pub const ERA: Option<&[&str]> = None;
        /// `None`
        pub const ERA_D_FMT: Option<&str> = None;
        /// `None`
        pub const ERA_D_T_FMT: Option<&str> = None;
        /// `None`
        pub const ERA_T_FMT: Option<&str> = None;
        /// `Some(2)`
        pub const FIRST_WEEKDAY: Option<i64> = Some(2);
        /// `None`
        pub const FIRST_WORKDAY: Option<i64> = None;
        /// `&["يناير", "فبراير", "مارس", "أبريل", "مايو", "يونيو", "يوليو", "أغسطس", "سبتمبر", "أكتوبر", "نوفمبر", "ديسمبر"]`
        pub const MON: &[&str] = &["يناير", "فبراير", "مارس", "أبريل", "مايو", "يونيو", "يوليو", "أغسطس", "سبتمبر", "أكتوبر", "نوفمبر", "ديسمبر"];
        /// `"%Z %I:%M:%S %p"`
        pub const T_FMT: &str = "%Z %I:%M:%S %p";
        /// `"%Z %I:%M:%S %p"`
        pub const T_FMT_AMPM: &str = "%Z %I:%M:%S %p";
        /// `Some(&[7, 19971130, 1])`
        pub const WEEK: Option<&[i64]> = Some(&[7, 19971130, 1]);
    }
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod ar_SY {
    pub mod LC_ADDRESS {
        /// `Some("SYR")`
        pub const COUNTRY_AB3: Option<&str> = Some("SYR");
        /// `Some("SY")`
        pub const COUNTRY_ABTWO: Option<&str> = Some("SY");
        /// `Some("SYR")`
        pub const COUNTRY_CAR: Option<&str> = Some("SYR");
        /// `None`
        pub const COUNTRY_ISBN: Option<&str> = None;
        /// `Some("سوريا")`
        pub const COUNTRY_NAME: Option<&str> = Some("سوريا");
        /// `Some(760)`
        pub const COUNTRY_NUM: Option<i64> = Some(760);
        /// `None`
        pub const COUNTRY_POST: Option<&str> = None;
        /// `Some("ar")`
        pub const LANG_AB: Option<&str> = Some("ar");
        /// `Some("ara")`
        pub const LANG_LIB: Option<&str> = Some("ara");
        /// `Some("العربية")`
        pub const LANG_NAME: Option<&str> = Some("العربية");
        /// `Some("ara")`
        pub const LANG_TERM: Option<&str> = Some("ara");
        /// `Some("%z%c%T%s%b%e%r")`
        pub const POSTAL_FMT: Option<&str> = Some("%z%c%T%s%b%e%r");
    }
    pub mod LC_IDENTIFICATION {
        /// `None`
        pub const ABBREVIATION: Option<&str> = None;
        /// `Some("1623-14, Shimotsuruma, Yamato-shi, Kanagawa-ken, 242-8502, Japan")`
        pub const ADDRESS: Option<&str> = Some("1623-14, Shimotsuruma, Yamato-shi, Kanagawa-ken, 242-8502, Japan");
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        /// ]
        /// ```
        pub const CATEGORY: Option<&[&[&str]]> = Some(&[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_TELEPHONE"],
            &["i18n:2012", "LC_MEASUREMENT"],
        ]);
        /// `Some("")`
        pub const CONTACT: Option<&str> = Some("");
        /// `Some("2000-07-20")`
        pub const DATE: Option<&str> = Some("2000-07-20");
        /// `Some("bug-glibc-locales@gnu.org")`
        pub const EMAIL: Option<&str> = Some("bug-glibc-locales@gnu.org");
        /// `Some("")`
        pub const FAX: Option<&str> = Some("");
        /// `Some("Arabic")`
        pub const LANGUAGE: Option<&str> = Some("Arabic");
        /// `Some("1.0")`
        pub const REVISION: Option<&str> = Some("1.0");
        /// `Some("IBM Globalization Center of Competency, Yamato Software Laboratory")`
        pub const SOURCE: Option<&str> = Some("IBM Globalization Center of Competency, Yamato Software Laboratory");
        /// `Some("")`
        pub const TEL: Option<&str> = Some("");
        /// `Some("Syria")`
        pub const TERRITORY: Option<&str> = Some("Syria");
        /// `Some("Arabic language locale for Syrian Arab Republic")`
        pub const TITLE: Option<&str> = Some("Arabic language locale for Syrian Arab Republic");
    }
    pub use super::ar_EG::LC_MESSAGES;
    pub mod LC_MONETARY {
        /// `"ل.س."`
        pub const CURRENCY_SYMBOL: &str = "ل.س.";
        /// `3`
        pub const FRAC_DIGITS: i64 = 3;
        /// `"SYP "`
        pub const INT_CURR_SYMBOL: &str = "SYP ";
        /// `3`
        pub const INT_FRAC_DIGITS: i64 = 3;
        /// `None`
        pub const INT_N_CS_PRECEDES: Option<i64> = None;
        /// `None`
        pub const INT_N_SEP_BY_SPACE: Option<i64> = None;
        /// `None`
        pub const INT_N_SIGN_POSN: Option<i64> = None;
        /// `None`
        pub const INT_P_CS_PRECEDES: Option<i64> = None;
        /// `None`
        pub const INT_P_SEP_BY_SPACE: Option<i64> = None;
        /// `None`
        pub const INT_P_SIGN_POSN: Option<i64> = None;
        /// `"."`
        pub const MON_DECIMAL_POINT: &str = ".";
        /// `&[3]`
        pub const MON_GROUPING: &[i64] = &[3];
        /// `","`
        pub const MON_THOUSANDS_SEP: &str = ",";
        /// `"-"`
        pub const NEGATIVE_SIGN: &str = "-";
        /// `1`
        pub const N_CS_PRECEDES: i64 = 1;
        /// `1`
        pub const N_SEP_BY_SPACE: i64 = 1;
        /// `2`
        pub const N_SIGN_POSN: i64 = 2;
        /// `""`
        pub const POSITIVE_SIGN: &str = "";
        /// `1`
        pub const P_CS_PRECEDES: i64 = 1;
        /// `1`
        pub const P_SEP_BY_SPACE: i64 = 1;
        /// `1`
        pub const P_SIGN_POSN: i64 = 1;
    }
    pub mod LC_NUMERIC {
        /// `"."`
        pub const DECIMAL_POINT: &str = ".";
        /// `&[3]`
        pub const GROUPING: &[i64] = &[3];
        /// `","`
        pub const THOUSANDS_SEP: &str = ",";
    }
    pub mod LC_TELEPHONE {
        /// `Some("963")`
        pub const INT_PREFIX: Option<&str> = Some("963");
        /// `Some("00")`
        pub const INT_SELECT: Option<&str> = Some("00");
        /// `None`
        pub const TEL_DOM_FMT: Option<&str> = None;
        /// `Some("+%c ;%a ;%l")`
        pub const TEL_INT_FMT: Option<&str> = Some("+%c ;%a ;%l");
    }
    pub mod LC_TIME {
        /// `&["ح", "ن", "ث", "ر", "خ", "ج", "س"]`
        pub const ABDAY: &[&str] = &["ح", "ن", "ث", "ر", "خ", "ج", "س"];
        /// `&["كانون الثاني", "شباط", "آذار", "نيسان", "أيار", "حزيران", "تموز", "آب", "أيلول", "تشرين الأول", "تشرين الثاني", "كانون الأول"]`
        pub const ABMON: &[&str] = &["كانون الثاني", "شباط", "آذار", "نيسان", "أيار", "حزيران", "تموز", "آب", "أيلول", "تشرين الأول", "تشرين الثاني", "كانون الأول"];
        /// `None`
        pub const AB_ALT_MON: Option<&[&str]> = None;
        /// `None`
        pub const ALT_DIGITS: Option<&[&str]> = None;
        /// `None`
        pub const ALT_MON: Option<&[&str]> = None;
        /// `&["ص", "م"]`
        pub const AM_PM: &[&str] = &["ص", "م"];
        /// `None`
        pub const CAL_DIRECTION: Option<i64> = None;
        /// `None`
        pub const DATE_FMT: Option<&str> = None;
        /// `&["الأحد", "الاثنين", "الثلاثاء", "الأربعاء", "الخميس", "الجمعة", "السبت"]`
        pub const DAY: &[&str] = &["الأحد", "الاثنين", "الثلاثاء", "الأربعاء", "الخميس", "الجمعة", "السبت"];
        /// `"%d %b, %Y"`
        pub const D_FMT: &str = "%d %b, %Y";
        /// `"%d %b, %Y %Z %I:%M:%S %p"`
        pub const D_T_FMT: &str = "%d %b, %Y %Z %I:%M:%S %p";
        /// `None`
        pub const ERA: Option<&[&str]> = None;
        /// `None`
        pub const ERA_D_FMT: Option<&str> = None;
        /// `None`
        pub const ERA_D_T_FMT: Option<&str> = None;
        /// `None`
        pub const ERA_T_FMT: Option<&str> = None;
        /// `Some(7)`
        pub const FIRST_WEEKDAY: Option<i64> = Some(7);
        /// `Some(1)`
        pub const FIRST_WORKDAY: Option<i64> = Some(1);
        /// `&["كانون الثاني", "شباط", "آذار", "نيسان", "أيار", "حزيران", "تموز", "آب", "أيلول", "تشرين الأول", "تشرين الثاني", "كانون الأول"]`
        pub const MON: &[&str] = &["كانون الثاني", "شباط", "آذار", "نيسان", "أيار", "حزيران", "تموز", "آب", "أيلول", "تشرين الأول", "تشرين الثاني", "كانون الأول"];
        /// `"%Z %I:%M:%S %p"`
        pub const T_FMT: &str = "%Z %I:%M:%S %p";
        /// `"%Z %I:%M:%S %p"`
        pub const T_FMT_AMPM: &str = "%Z %I:%M:%S %p";
        /// `Some(&[7, 19971130, 1])`
        pub const WEEK: Option<&[i64]> = Some(&[7, 19971130, 1]);
    }
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod ar_TN {
    pub mod LC_ADDRESS {
        /// `Some("TUN")`
        pub const COUNTRY_AB3: Option<&str> = Some("TUN");
        /// `Some("TN")`
        pub const COUNTRY_ABTWO: Option<&str> = Some("TN");
        /// `Some("TN")`
        pub const COUNTRY_CAR: Option<&str> = Some("TN");
        /// `None`
        pub const COUNTRY_ISBN: Option<&str> = None;
        /// `Some("تونس")`
        pub const COUNTRY_NAME: Option<&str> = Some("تونس");
        /// `Some(788)`
        pub const COUNTRY_NUM: Option<i64> = Some(788);
        /// `None`
        pub const COUNTRY_POST: Option<&str> = None;
        /// `Some("ar")`
        pub const LANG_AB: Option<&str> = Some("ar");
        /// `Some("ara")`
        pub const LANG_LIB: Option<&str> = Some("ara");
        /// `Some("العربية")`
        pub const LANG_NAME: Option<&str> = Some("العربية");
        /// `Some("ara")`
        pub const LANG_TERM: Option<&str> = Some("ara");
        /// `Some("%z%c%T%s%b%e%r")`
        pub const POSTAL_FMT: Option<&str> = Some("%z%c%T%s%b%e%r");
    }
    pub mod LC_IDENTIFICATION {
        /// `None`
        pub const ABBREVIATION: Option<&str> = None;
        /// `Some("1623-14, Shimotsuruma, Yamato-shi, Kanagawa-ken, 242-8502, Japan")`
        pub const ADDRESS: Option<&str> = Some("1623-14, Shimotsuruma, Yamato-shi, Kanagawa-ken, 242-8502, Japan");
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        /// ]
        /// ```
        pub const CATEGORY: Option<&[&[&str]]> = Some(&[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_TELEPHONE"],
            &["i18n:2012", "LC_MEASUREMENT"],
        ]);
        /// `Some("")`
        pub const CONTACT: Option<&str> = Some("");
        /// `Some("2000-07-20")`
        pub const DATE: Option<&str> = Some("2000-07-20");
        /// `Some("bug-glibc-locales@gnu.org")`
        pub const EMAIL: Option<&str> = Some("bug-glibc-locales@gnu.org");
        /// `Some("")`
        pub const FAX: Option<&str> = Some("");
        /// `Some("Arabic")`
        pub const LANGUAGE: Option<&str> = Some("Arabic");
        /// `Some("1.0")`
        pub const REVISION: Option<&str> = Some("1.0");
        /// `Some("IBM Globalization Center of Competency, Yamato Software Laboratory")`
        pub const SOURCE: Option<&str> = Some("IBM Globalization Center of Competency, Yamato Software Laboratory");
        /// `Some("")`
        pub const TEL: Option<&str> = Some("");
        /// `Some("Tunisia")`
        pub const TERRITORY: Option<&str> = Some("Tunisia");
        /// `Some("Arabic language locale for Tunisia")`
        pub const TITLE: Option<&str> = Some("Arabic language locale for Tunisia");
    }
    pub use super::ar_EG::LC_MESSAGES;
    pub mod LC_MONETARY {
        /// `"د.ت."`
        pub const CURRENCY_SYMBOL: &str = "د.ت.";
        /// `3`
        pub const FRAC_DIGITS: i64 = 3;
        /// `"TND "`
        pub const INT_CURR_SYMBOL: &str = "TND ";
        /// `3`
        pub const INT_FRAC_DIGITS: i64 = 3;
        /// `None`
        pub const INT_N_CS_PRECEDES: Option<i64> = None;
        /// `None`
        pub const INT_N_SEP_BY_SPACE: Option<i64> = None;
        /// `None`
        pub const INT_N_SIGN_POSN: Option<i64> = None;
        /// `None`
        pub const INT_P_CS_PRECEDES: Option<i64> = None;
        /// `None`
        pub const INT_P_SEP_BY_SPACE: Option<i64> = None;
        /// `None`
        pub const INT_P_SIGN_POSN: Option<i64> = None;
        /// `"."`
        pub const MON_DECIMAL_POINT: &str = ".";
        /// `&[3]`
        pub const MON_GROUPING: &[i64] = &[3];
        /// `","`
        pub const MON_THOUSANDS_SEP: &str = ",";
        /// `"-"`
        pub const NEGATIVE_SIGN: &str = "-";
        /// `1`
        pub const N_CS_PRECEDES: i64 = 1;
        /// `1`
        pub const N_SEP_BY_SPACE: i64 = 1;
        /// `2`
        pub const N_SIGN_POSN: i64 = 2;
        /// `""`
        pub const POSITIVE_SIGN: &str = "";
        /// `1`
        pub const P_CS_PRECEDES: i64 = 1;
        /// `1`
        pub const P_SEP_BY_SPACE: i64 = 1;
        /// `1`
        pub const P_SIGN_POSN: i64 = 1;
    }
    pub mod LC_NUMERIC {
        /// `"."`
        pub const DECIMAL_POINT: &str = ".";
        /// `&[3]`
        pub const GROUPING: &[i64] = &[3];
        /// `","`
        pub const THOUSANDS_SEP: &str = ",";
    }
    pub mod LC_TELEPHONE {
        /// `Some("216")`
        pub const INT_PREFIX: Option<&str> = Some("216");
        /// `Some("00")`
        pub const INT_SELECT: Option<&str> = Some("00");
        /// `None`
        pub const TEL_DOM_FMT: Option<&str> = None;
        /// `Some("+%c ;%a ;%l")`
        pub const TEL_INT_FMT: Option<&str> = Some("+%c ;%a ;%l");
    }
    pub mod LC_TIME {
        /// `&["ح", "ن", "ث", "ر", "خ", "ج", "س"]`
        pub const ABDAY: &[&str] = &["ح", "ن", "ث", "ر", "خ", "ج", "س"];
        /// `&["جانفي", "فيفري", "مارس", "أفريل", "ماي", "جوان", "جويلية", "أوت", "سبتمبر", "أكتوبر", "نوفمبر", "ديسمبر"]`
        pub const ABMON: &[&str] = &["جانفي", "فيفري", "مارس", "أفريل", "ماي", "جوان", "جويلية", "أوت", "سبتمبر", "أكتوبر", "نوفمبر", "ديسمبر"];
        /// `None`
        pub const AB_ALT_MON: Option<&[&str]> = None;
        /// `None`
        pub const ALT_DIGITS: Option<&[&str]> = None;
        /// `None`
        pub const ALT_MON: Option<&[&str]> = None;
        /// `&["ص", "م"]`
        pub const AM_PM: &[&str] = &["ص", "م"];
        /// `None`
        pub const CAL_DIRECTION: Option<i64> = None;
        /// `None`
        pub const DATE_FMT: Option<&str> = None;
        /// `&["الأحد", "الاثنين", "الثلاثاء", "الأربعاء", "الخميس", "الجمعة", "السبت"]`
        pub const DAY: &[&str] = &["الأحد", "الاثنين", "الثلاثاء", "الأربعاء", "الخميس", "الجمعة", "السبت"];
        /// `"%d %b, %Y"`
        pub const D_FMT: &str = "%d %b, %Y";
        /// `"%d %b, %Y %Z %I:%M:%S %p"`
        pub const D_T_FMT: &str = "%d %b, %Y %Z %I:%M:%S %p";
        /// `None`
        pub const ERA: Option<&[&str]> = None;
        /// `None`
        pub const ERA_D_FMT: Option<&str> = None;
        /// `None`
        pub const ERA_D_T_FMT: Option<&str> = None;
        /// `None`
        pub const ERA_T_FMT: Option<&str> = None;
        /// `None`
        pub const FIRST_WEEKDAY: Option<i64> = None;
        /// `Some(1)`
        pub const FIRST_WORKDAY: Option<i64> = Some(1);
        /// `&["جانفي", "فيفري", "مارس", "أفريل", "ماي", "جوان", "جويلية", "أوت", "سبتمبر", "أكتوبر", "نوفمبر", "ديسمبر"]`
        pub const MON: &[&str] = &["جانفي", "فيفري", "مارس", "أفريل", "ماي", "جوان", "جويلية", "أوت", "سبتمبر", "أكتوبر", "نوفمبر", "ديسمبر"];
        /// `"%Z %I:%M:%S %p"`
        pub const T_FMT: &str = "%Z %I:%M:%S %p";
        /// `"%Z %I:%M:%S %p"`
        pub const T_FMT_AMPM: &str = "%Z %I:%M:%S %p";
        /// `Some(&[7, 19971130, 1])`
        pub const WEEK: Option<&[i64]> = Some(&[7, 19971130, 1]);
    }
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod ar_YE {
    pub mod LC_ADDRESS {
        /// `Some("YEM")`
        pub const COUNTRY_AB3: Option<&str> = Some("YEM");
        /// `Some("YE")`
        pub const COUNTRY_ABTWO: Option<&str> = Some("YE");
        /// `Some("YAR")`
        pub const COUNTRY_CAR: Option<&str> = Some("YAR");
        /// `None`
        pub const COUNTRY_ISBN: Option<&str> = None;
        /// `Some("اليمن")`
        pub const COUNTRY_NAME: Option<&str> = Some("اليمن");
        /// `Some(887)`
        pub const COUNTRY_NUM: Option<i64> = Some(887);
        /// `None`
        pub const COUNTRY_POST: Option<&str> = None;
        /// `Some("ar")`
        pub const LANG_AB: Option<&str> = Some("ar");
        /// `Some("ara")`
        pub const LANG_LIB: Option<&str> = Some("ara");
        /// `Some("العربية")`
        pub const LANG_NAME: Option<&str> = Some("العربية");
        /// `Some("ara")`
        pub const LANG_TERM: Option<&str> = Some("ara");
        /// `Some("%z%c%T%s%b%e%r")`
        pub const POSTAL_FMT: Option<&str> = Some("%z%c%T%s%b%e%r");
    }
    pub mod LC_IDENTIFICATION {
        /// `None`
        pub const ABBREVIATION: Option<&str> = None;
        /// `Some("1623-14, Shimotsuruma, Yamato-shi, Kanagawa-ken, 242-8502, Japan")`
        pub const ADDRESS: Option<&str> = Some("1623-14, Shimotsuruma, Yamato-shi, Kanagawa-ken, 242-8502, Japan");
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        /// ]
        /// ```
        pub const CATEGORY: Option<&[&[&str]]> = Some(&[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_TELEPHONE"],
            &["i18n:2012", "LC_MEASUREMENT"],
        ]);
        /// `Some("")`
        pub const CONTACT: Option<&str> = Some("");
        /// `Some("2000-07-20")`
        pub const DATE: Option<&str> = Some("2000-07-20");
        /// `Some("bug-glibc-locales@gnu.org")`
        pub const EMAIL: Option<&str> = Some("bug-glibc-locales@gnu.org");
        /// `Some("")`
        pub const FAX: Option<&str> = Some("");
        /// `Some("Arabic")`
        pub const LANGUAGE: Option<&str> = Some("Arabic");
        /// `Some("1.0")`
        pub const REVISION: Option<&str> = Some("1.0");
        /// `Some("IBM Globalization Center of Competency, Yamato Software Laboratory")`
        pub const SOURCE: Option<&str> = Some("IBM Globalization Center of Competency, Yamato Software Laboratory");
        /// `Some("")`
        pub const TEL: Option<&str> = Some("");
        /// `Some("Yemen")`
        pub const TERRITORY: Option<&str> = Some("Yemen");
        /// `Some("Arabic language locale for Yemen")`
        pub const TITLE: Option<&str> = Some("Arabic language locale for Yemen");
    }
    pub use super::ar_EG::LC_MESSAGES;
    pub mod LC_MONETARY {
        /// `"ر.ي."`
        pub const CURRENCY_SYMBOL: &str = "ر.ي.";
        /// `3`
        pub const FRAC_DIGITS: i64 = 3;
        /// `"YER "`
        pub const INT_CURR_SYMBOL: &str = "YER ";
        /// `3`
        pub const INT_FRAC_DIGITS: i64 = 3;
        /// `None`
        pub const INT_N_CS_PRECEDES: Option<i64> = None;
        /// `None`
        pub const INT_N_SEP_BY_SPACE: Option<i64> = None;
        /// `None`
        pub const INT_N_SIGN_POSN: Option<i64> = None;
        /// `None`
        pub const INT_P_CS_PRECEDES: Option<i64> = None;
        /// `None`
        pub const INT_P_SEP_BY_SPACE: Option<i64> = None;
        /// `None`
        pub const INT_P_SIGN_POSN: Option<i64> = None;
        /// `"."`
        pub const MON_DECIMAL_POINT: &str = ".";
        /// `&[3]`
        pub const MON_GROUPING: &[i64] = &[3];
        /// `","`
        pub const MON_THOUSANDS_SEP: &str = ",";
        /// `"-"`
        pub const NEGATIVE_SIGN: &str = "-";
        /// `1`
        pub const N_CS_PRECEDES: i64 = 1;
        /// `1`
        pub const N_SEP_BY_SPACE: i64 = 1;
        /// `2`
        pub const N_SIGN_POSN: i64 = 2;
        /// `""`
        pub const POSITIVE_SIGN: &str = "";
        /// `1`
        pub const P_CS_PRECEDES: i64 = 1;
        /// `1`
        pub const P_SEP_BY_SPACE: i64 = 1;
        /// `1`
        pub const P_SIGN_POSN: i64 = 1;
    }
    pub mod LC_NUMERIC {
        /// `"."`
        pub const DECIMAL_POINT: &str = ".";
        /// `&[3]`
        pub const GROUPING: &[i64] = &[3];
        /// `","`
        pub const THOUSANDS_SEP: &str = ",";
    }
    pub mod LC_TELEPHONE {
        /// `Some("967")`
        pub const INT_PREFIX: Option<&str> = Some("967");
        /// `Some("00")`
        pub const INT_SELECT: Option<&str> = Some("00");
        /// `None`
        pub const TEL_DOM_FMT: Option<&str> = None;
        /// `Some("+%c ;%a ;%l")`
        pub const TEL_INT_FMT: Option<&str> = Some("+%c ;%a ;%l");
    }
    pub mod LC_TIME {
        /// `&["ح", "ن", "ث", "ر", "خ", "ج", "س"]`
        pub const ABDAY: &[&str] = &["ح", "ن", "ث", "ر", "خ", "ج", "س"];
        /// `&["ينا", "فبر", "مار", "أبر", "ماي", "يون", "يول", "أغس", "سبت", "أكت", "نوف", "ديس"]`
        pub const ABMON: &[&str] = &["ينا", "فبر", "مار", "أبر", "ماي", "يون", "يول", "أغس", "سبت", "أكت", "نوف", "ديس"];
        /// `None`
        pub const AB_ALT_MON: Option<&[&str]> = None;
        /// `None`
        pub const ALT_DIGITS: Option<&[&str]> = None;
        /// `None`
        pub const ALT_MON: Option<&[&str]> = None;
        /// `&["ص", "م"]`
        pub const AM_PM: &[&str] = &["ص", "م"];
        /// `None`
        pub const CAL_DIRECTION: Option<i64> = None;
        /// `None`
        pub const DATE_FMT: Option<&str> = None;
        /// `&["الأحد", "الاثنين", "الثلاثاء", "الأربعاء", "الخميس", "الجمعة", "السبت"]`
        pub const DAY: &[&str] = &["الأحد", "الاثنين", "الثلاثاء", "الأربعاء", "الخميس", "الجمعة", "السبت"];
        /// `"%d %b, %Y"`
        pub const D_FMT: &str = "%d %b, %Y";
        /// `"%d %b, %Y %Z %I:%M:%S %p"`
        pub const D_T_FMT: &str = "%d %b, %Y %Z %I:%M:%S %p";
        /// `None`
        pub const ERA: Option<&[&str]> = None;
        /// `None`
        pub const ERA_D_FMT: Option<&str> = None;
        /// `None`
        pub const ERA_D_T_FMT: Option<&str> = None;
        /// `None`
        pub const ERA_T_FMT: Option<&str> = None;
        /// `None`
        pub const FIRST_WEEKDAY: Option<i64> = None;
        /// `Some(1)`
        pub const FIRST_WORKDAY: Option<i64> = Some(1);
        /// `&["يناير", "فبراير", "مارس", "أبريل", "مايو", "يونيو", "يوليو", "أغسطس", "سبتمبر", "أكتوبر", "نوفمبر", "ديسمبر"]`
        pub const MON: &[&str] = &["يناير", "فبراير", "مارس", "أبريل", "مايو", "يونيو", "يوليو", "أغسطس", "سبتمبر", "أكتوبر", "نوفمبر", "ديسمبر"];
        /// `"%Z %I:%M:%S %p"`
        pub const T_FMT: &str = "%Z %I:%M:%S %p";
        /// `"%Z %I:%M:%S %p"`
        pub const T_FMT_AMPM: &str = "%Z %I:%M:%S %p";
        /// `Some(&[7, 19971130, 1])`
        pub const WEEK: Option<&[i64]> = Some(&[7, 19971130, 1]);
    }
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod as_IN {
    pub mod LC_ADDRESS {
        /// `None`
        pub const COUNTRY_AB3: Option<&str> = None;
        /// `None`
        pub const COUNTRY_ABTWO: Option<&str> = None;
        /// `Some("IND")`
        pub const COUNTRY_CAR: Option<&str> = Some("IND");
        /// `None`
        pub const COUNTRY_ISBN: Option<&str> = None;
        /// `Some("ভ\u{9be}ৰত")`
        pub const COUNTRY_NAME: Option<&str> = Some("ভ\u{9be}ৰত");
        /// `Some(356)`
        pub const COUNTRY_NUM: Option<i64> = Some(356);
        /// `None`
        pub const COUNTRY_POST: Option<&str> = None;
        /// `Some("as")`
        pub const LANG_AB: Option<&str> = Some("as");
        /// `Some("asm")`
        pub const LANG_LIB: Option<&str> = Some("asm");
        /// `Some("অসমীয\u{9bc}\u{9be}")`
        pub const LANG_NAME: Option<&str> = Some("অসমীয\u{9bc}\u{9be}");
        /// `Some("asm")`
        pub const LANG_TERM: Option<&str> = Some("asm");
        /// `Some("%z%c%T%s%b%e%r")`
        pub const POSTAL_FMT: Option<&str> = Some("%z%c%T%s%b%e%r");
    }
    pub mod LC_IDENTIFICATION {
        /// `None`
        pub const ABBREVIATION: Option<&str> = None;
        /// `Some("")`
        pub const ADDRESS: Option<&str> = Some("");
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        /// ]
        /// ```
        pub const CATEGORY: Option<&[&[&str]]> = Some(&[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_TELEPHONE"],
            &["i18n:2012", "LC_MEASUREMENT"],
        ]);
        /// `Some("")`
        pub const CONTACT: Option<&str> = Some("");
        /// `Some("2006-05-25")`
        pub const DATE: Option<&str> = Some("2006-05-25");
        /// `Some("bug-glibc@gnu.org")`
        pub const EMAIL: Option<&str> = Some("bug-glibc@gnu.org");
        /// `Some("")`
        pub const FAX: Option<&str> = Some("");
        /// `Some("Assamese")`
        pub const LANGUAGE: Option<&str> = Some("Assamese");
        /// `Some("1.0")`
        pub const REVISION: Option<&str> = Some("1.0");
        /// `Some("Amitakhya Phukan, Red Hat")`
        pub const SOURCE: Option<&str> = Some("Amitakhya Phukan, Red Hat");
        /// `Some("")`
        pub const TEL: Option<&str> = Some("");
        /// `Some("India")`
        pub const TERRITORY: Option<&str> = Some("India");
        /// `Some("Assamese language locale for India")`
        pub const TITLE: Option<&str> = Some("Assamese language locale for India");
    }
    pub mod LC_MESSAGES {
        /// `"^[-0nNন]"`
        pub const NOEXPR: &str = "^[-0nNন]";
        /// `Some("নহয়")`
        pub const NOSTR: Option<&str> = Some("নহয়");
        /// `"^[+1yYহ]"`
        pub const YESEXPR: &str = "^[+1yYহ]";
        /// `Some("হয়")`
        pub const YESSTR: Option<&str> = Some("হয়");
    }
    pub use super::hi_IN::LC_MONETARY;
    pub use super::en_IN::LC_NUMERIC;
    pub mod LC_TELEPHONE {
        /// `Some("91")`
        pub const INT_PREFIX: Option<&str> = Some("91");
        /// `Some("00")`
        pub const INT_SELECT: Option<&str> = Some("00");
        /// `None`
        pub const TEL_DOM_FMT: Option<&str> = None;
        /// `Some("+%c ;%a ;%l")`
        pub const TEL_INT_FMT: Option<&str> = Some("+%c ;%a ;%l");
    }
    pub mod LC_TIME {
        /// `&["দেও", "সোম", "মঙ\u{9cd}গল", "ব\u{9c1}ধ", "ব\u{9c3}হষ\u{9cd}পতি", "শ\u{9c1}ক\u{9cd}ৰ", "শনি"]`
        pub const ABDAY: &[&str] = &["দেও", "সোম", "মঙ\u{9cd}গল", "ব\u{9c1}ধ", "ব\u{9c3}হষ\u{9cd}পতি", "শ\u{9c1}ক\u{9cd}ৰ", "শনি"];
        /// `&["জ\u{9be}ন\u{9c1}", "ফেব\u{9cd}ৰ\u{9c1}", "ম\u{9be}ৰ\u{9cd}চ", "এপ\u{9cd}ৰিল", "মে", "জ\u{9c1}ন", "জ\u{9c1}ল\u{9be}ই", "আগ", "সেপ\u{9cd}ট", "অক\u{9cd}টো", "নভে", "ডিসে"]`
        pub const ABMON: &[&str] = &["জ\u{9be}ন\u{9c1}", "ফেব\u{9cd}ৰ\u{9c1}", "ম\u{9be}ৰ\u{9cd}চ", "এপ\u{9cd}ৰিল", "মে", "জ\u{9c1}ন", "জ\u{9c1}ল\u{9be}ই", "আগ", "সেপ\u{9cd}ট", "অক\u{9cd}টো", "নভে", "ডিসে"];
        /// `None`
        pub const AB_ALT_MON: Option<&[&str]> = None;
        /// `None`
        pub const ALT_DIGITS: Option<&[&str]> = None;
        /// `None`
        pub const ALT_MON: Option<&[&str]> = None;
        /// `&["প\u{9c2}ৰ\u{9cd}ব\u{9cd}ব\u{9be}হ\u{9cd}ন", "অপৰ\u{9be}হ\u{9cd}ন"]`
        pub const AM_PM: &[&str] = &["প\u{9c2}ৰ\u{9cd}ব\u{9cd}ব\u{9be}হ\u{9cd}ন", "অপৰ\u{9be}হ\u{9cd}ন"];
        /// `None`
        pub const CAL_DIRECTION: Option<i64> = None;
        /// `None`
        pub const DATE_FMT: Option<&str> = None;
        /// `&["দেওব\u{9be}ৰ", "সোমব\u{9be}ৰ", "মঙ\u{9cd}গলব\u{9be}ৰ", "ব\u{9c1}ধব\u{9be}ৰ", "ব\u{9c3}হষ\u{9cd}পতিব\u{9be}ৰ", "শ\u{9c1}ক\u{9cd}ৰব\u{9be}ৰ", "শনিব\u{9be}ৰ"]`
        pub const DAY: &[&str] = &["দেওব\u{9be}ৰ", "সোমব\u{9be}ৰ", "মঙ\u{9cd}গলব\u{9be}ৰ", "ব\u{9c1}ধব\u{9be}ৰ", "ব\u{9c3}হষ\u{9cd}পতিব\u{9be}ৰ", "শ\u{9c1}ক\u{9cd}ৰব\u{9be}ৰ", "শনিব\u{9be}ৰ"];
        /// `"%e-%m-%Y"`
        pub const D_FMT: &str = "%e-%m-%Y";
        /// `"%e %B, %Y %I.%M.%S %p %Z"`
        pub const D_T_FMT: &str = "%e %B, %Y %I.%M.%S %p %Z";
        /// `None`
        pub const ERA: Option<&[&str]> = None;
        /// `None`
        pub const ERA_D_FMT: Option<&str> = None;
        /// `None`
        pub const ERA_D_T_FMT: Option<&str> = None;
        /// `None`
        pub const ERA_T_FMT: Option<&str> = None;
        /// `None`
        pub const FIRST_WEEKDAY: Option<i64> = None;
        /// `None`
        pub const FIRST_WORKDAY: Option<i64> = None;
        /// `&["জ\u{9be}ন\u{9c1}ৱ\u{9be}ৰী", "ফেব\u{9cd}ৰ\u{9c1}ৱ\u{9be}ৰী", "ম\u{9be}ৰ\u{9cd}চ", "এপ\u{9cd}ৰিল", "মে", "জ\u{9c1}ন", "জ\u{9c1}ল\u{9be}ই", "আগষ\u{9cd}ট", "ছেপ\u{9cd}তেম\u{9cd}বৰ", "অক\u{9cd}টোবৰ", "নৱেম\u{9cd}বৰ", "ডিচেম\u{9cd}বৰ"]`
        pub const MON: &[&str] = &["জ\u{9be}ন\u{9c1}ৱ\u{9be}ৰী", "ফেব\u{9cd}ৰ\u{9c1}ৱ\u{9be}ৰী", "ম\u{9be}ৰ\u{9cd}চ", "এপ\u{9cd}ৰিল", "মে", "জ\u{9c1}ন", "জ\u{9c1}ল\u{9be}ই", "আগষ\u{9cd}ট", "ছেপ\u{9cd}তেম\u{9cd}বৰ", "অক\u{9cd}টোবৰ", "নৱেম\u{9cd}বৰ", "ডিচেম\u{9cd}বৰ"];
        /// `"%I.%M.%S %p"`
        pub const T_FMT: &str = "%I.%M.%S %p";
        /// `"%I.%M.%S %p"`
        pub const T_FMT_AMPM: &str = "%I.%M.%S %p";
        /// `Some(&[7, 19971130, 1])`
        pub const WEEK: Option<&[i64]> = Some(&[7, 19971130, 1]);
    }
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod ast_ES {
    pub mod LC_ADDRESS {
        /// `Some("ESP")`
        pub const COUNTRY_AB3: Option<&str> = Some("ESP");
        /// `Some("ES")`
        pub const COUNTRY_ABTWO: Option<&str> = Some("ES");
        /// `Some("E")`
        pub const COUNTRY_CAR: Option<&str> = Some("E");
        /// `None`
        pub const COUNTRY_ISBN: Option<&str> = None;
        /// `Some("España")`
        pub const COUNTRY_NAME: Option<&str> = Some("España");
        /// `Some(724)`
        pub const COUNTRY_NUM: Option<i64> = Some(724);
        /// `None`
        pub const COUNTRY_POST: Option<&str> = None;
        /// `None`
        pub const LANG_AB: Option<&str> = None;
        /// `Some("ast")`
        pub const LANG_LIB: Option<&str> = Some("ast");
        /// `Some("asturianu")`
        pub const LANG_NAME: Option<&str> = Some("asturianu");
        /// `Some("ast")`
        pub const LANG_TERM: Option<&str> = Some("ast");
        /// `Some("%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%c%N")`
        pub const POSTAL_FMT: Option<&str> = Some("%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%c%N");
    }
    pub mod LC_IDENTIFICATION {
        /// `None`
        pub const ABBREVIATION: Option<&str> = None;
        /// `Some("")`
        pub const ADDRESS: Option<&str> = Some("");
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        /// ]
        /// ```
        pub const CATEGORY: Option<&[&[&str]]> = Some(&[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_TELEPHONE"],
            &["i18n:2012", "LC_MEASUREMENT"],
        ]);
        /// `Some("Jordi Mallach")`
        pub const CONTACT: Option<&str> = Some("Jordi Mallach");
        /// `Some("2005-08-26")`
        pub const DATE: Option<&str> = Some("2005-08-26");
        /// `Some("jordi@gnu.org")`
        pub const EMAIL: Option<&str> = Some("jordi@gnu.org");
        /// `Some("")`
        pub const FAX: Option<&str> = Some("");
        /// `Some("Asturian")`
        pub const LANGUAGE: Option<&str> = Some("Asturian");
        /// `Some("1.0")`
        pub const REVISION: Option<&str> = Some("1.0");
        /// `Some("")`
        pub const SOURCE: Option<&str> = Some("");
        /// `Some("")`
        pub const TEL: Option<&str> = Some("");
        /// `Some("Spain")`
        pub const TERRITORY: Option<&str> = Some("Spain");
        /// `Some("Asturian locale for Spain")`
        pub const TITLE: Option<&str> = Some("Asturian locale for Spain");
    }
    pub mod LC_MESSAGES {
        /// `"^[-0nN]"`
        pub const NOEXPR: &str = "^[-0nN]";
        /// `Some("non")`
        pub const NOSTR: Option<&str> = Some("non");
        /// `"^[+1sSyY]"`
        pub const YESEXPR: &str = "^[+1sSyY]";
        /// `Some("sí")`
        pub const YESSTR: Option<&str> = Some("sí");
    }
    pub use super::es_ES::LC_MONETARY;
    pub use super::es_ES::LC_NUMERIC;
    pub use super::es_ES::LC_TELEPHONE;
    pub mod LC_TIME {
        /// `&["dom", "llu", "mar", "mié", "xue", "vie", "sáb"]`
        pub const ABDAY: &[&str] = &["dom", "llu", "mar", "mié", "xue", "vie", "sáb"];
        /// `&["xin", "feb", "mar", "abr", "may", "xun", "xnt", "ago", "set", "och", "pay", "avi"]`
        pub const ABMON: &[&str] = &["xin", "feb", "mar", "abr", "may", "xun", "xnt", "ago", "set", "och", "pay", "avi"];
        /// `None`
        pub const AB_ALT_MON: Option<&[&str]> = None;
        /// `None`
        pub const ALT_DIGITS: Option<&[&str]> = None;
        /// `Some(&["xineru", "febreru", "marzu", "abril", "mayu", "xunu", "xunetu", "agostu", "setiembre", "ochobre", "payares", "avientu"])`
        pub const ALT_MON: Option<&[&str]> = Some(&["xineru", "febreru", "marzu", "abril", "mayu", "xunu", "xunetu", "agostu", "setiembre", "ochobre", "payares", "avientu"]);
        /// `&["", ""]`
        pub const AM_PM: &[&str] = &["", ""];
        /// `None`
        pub const CAL_DIRECTION: Option<i64> = None;
        /// `None`
        pub const DATE_FMT: Option<&str> = None;
        /// `&["domingu", "llunes", "martes", "miércoles", "xueves", "vienres", "sábadu"]`
        pub const DAY: &[&str] = &["domingu", "llunes", "martes", "miércoles", "xueves", "vienres", "sábadu"];
        /// `"%d/%m/%y"`
        pub const D_FMT: &str = "%d/%m/%y";
        /// `"%a %d %b %Y %T %Z"`
        pub const D_T_FMT: &str = "%a %d %b %Y %T %Z";
        /// `None`
        pub const ERA: Option<&[&str]> = None;
        /// `None`
        pub const ERA_D_FMT: Option<&str> = None;
        /// `None`
        pub const ERA_D_T_FMT: Option<&str> = None;
        /// `None`
        pub const ERA_T_FMT: Option<&str> = None;
        /// `Some(2)`
        pub const FIRST_WEEKDAY: Option<i64> = Some(2);
        /// `None`
        pub const FIRST_WORKDAY: Option<i64> = None;
        /// `&["de xineru", "de febreru", "de marzu", "d’abril", "de mayu", "de xunu", "de xunetu", "d’agostu", "de setiembre", "d’ochobre", "de payares", "d’avientu"]`
        pub const MON: &[&str] = &["de xineru", "de febreru", "de marzu", "d’abril", "de mayu", "de xunu", "de xunetu", "d’agostu", "de setiembre", "d’ochobre", "de payares", "d’avientu"];
        /// `"%T"`
        pub const T_FMT: &str = "%T";
        /// `""`
        pub const T_FMT_AMPM: &str = "";
        /// `Some(&[7, 19971130, 4])`
        pub const WEEK: Option<&[i64]> = Some(&[7, 19971130, 4]);
    }
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod ayc_PE {
    pub mod LC_ADDRESS {
        /// `Some("PER")`
        pub const COUNTRY_AB3: Option<&str> = Some("PER");
        /// `Some("PE")`
        pub const COUNTRY_ABTWO: Option<&str> = Some("PE");
        /// `Some("PE")`
        pub const COUNTRY_CAR: Option<&str> = Some("PE");
        /// `None`
        pub const COUNTRY_ISBN: Option<&str> = None;
        /// `Some("Piruw")`
        pub const COUNTRY_NAME: Option<&str> = Some("Piruw");
        /// `Some(604)`
        pub const COUNTRY_NUM: Option<i64> = Some(604);
        /// `None`
        pub const COUNTRY_POST: Option<&str> = None;
        /// `Some("ay")`
        pub const LANG_AB: Option<&str> = Some("ay");
        /// `Some("ayc")`
        pub const LANG_LIB: Option<&str> = Some("ayc");
        /// `Some("Aymar aru")`
        pub const LANG_NAME: Option<&str> = Some("Aymar aru");
        /// `Some("ayc")`
        pub const LANG_TERM: Option<&str> = Some("ayc");
        /// `Some("%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%c%N")`
        pub const POSTAL_FMT: Option<&str> = Some("%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%c%N");
    }
    pub mod LC_IDENTIFICATION {
        /// `None`
        pub const ABBREVIATION: Option<&str> = None;
        /// `Some("")`
        pub const ADDRESS: Option<&str> = Some("");
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        /// ]
        /// ```
        pub const CATEGORY: Option<&[&[&str]]> = Some(&[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_MEASUREMENT"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_TELEPHONE"],
        ]);
        /// `Some("")`
        pub const CONTACT: Option<&str> = Some("");
        /// `Some("2011-11-13")`
        pub const DATE: Option<&str> = Some("2011-11-13");
        /// `Some("libc-alpha@sourceware.org")`
        pub const EMAIL: Option<&str> = Some("libc-alpha@sourceware.org");
        /// `Some("")`
        pub const FAX: Option<&str> = Some("");
        /// `Some("Aymara")`
        pub const LANGUAGE: Option<&str> = Some("Aymara");
        /// `Some("1.1")`
        pub const REVISION: Option<&str> = Some("1.1");
        /// `Some("runasimipi.org")`
        pub const SOURCE: Option<&str> = Some("runasimipi.org");
        /// `Some("")`
        pub const TEL: Option<&str> = Some("");
        /// `Some("Peru")`
        pub const TERRITORY: Option<&str> = Some("Peru");
        /// `Some("Aymara (ayc) locale for Peru")`
        pub const TITLE: Option<&str> = Some("Aymara (ayc) locale for Peru");
    }
    pub mod LC_MESSAGES {
        /// `"^[-0jJnN]"`
        pub const NOEXPR: &str = "^[-0jJnN]";
        /// `Some("Janiwa")`
        pub const NOSTR: Option<&str> = Some("Janiwa");
        /// `"^[+1uUsSyY]"`
        pub const YESEXPR: &str = "^[+1uUsSyY]";
        /// `Some("Ukhamawa")`
        pub const YESSTR: Option<&str> = Some("Ukhamawa");
    }
    pub use super::es_PE::LC_MONETARY;
    pub use super::es_PE::LC_NUMERIC;
    pub use super::es_PE::LC_TELEPHONE;
    pub mod LC_TIME {
        /// `&["tum", "lun", "mar", "mir", "juy", "wir", "saw"]`
        pub const ABDAY: &[&str] = &["tum", "lun", "mar", "mir", "juy", "wir", "saw"];
        /// `&["ini", "phi", "mar", "awr", "may", "jun", "jul", "awu", "sit", "ukt", "nuw", "ris"]`
        pub const ABMON: &[&str] = &["ini", "phi", "mar", "awr", "may", "jun", "jul", "awu", "sit", "ukt", "nuw", "ris"];
        /// `None`
        pub const AB_ALT_MON: Option<&[&str]> = None;
        /// `None`
        pub const ALT_DIGITS: Option<&[&str]> = None;
        /// `None`
        pub const ALT_MON: Option<&[&str]> = None;
        /// `&["VM", "NM"]`
        pub const AM_PM: &[&str] = &["VM", "NM"];
        /// `None`
        pub const CAL_DIRECTION: Option<i64> = None;
        /// `None`
        pub const DATE_FMT: Option<&str> = None;
        /// `&["tuminku", "lunisa", "martisa", "mirkulisa", "juywisa", "wirnisa", "sawäru"]`
        pub const DAY: &[&str] = &["tuminku", "lunisa", "martisa", "mirkulisa", "juywisa", "wirnisa", "sawäru"];
        /// `"%d/%m/%y"`
        pub const D_FMT: &str = "%d/%m/%y";
        /// `"%a %d %b %Y %T %Z"`
        pub const D_T_FMT: &str = "%a %d %b %Y %T %Z";
        /// `None`
        pub const ERA: Option<&[&str]> = None;
        /// `None`
        pub const ERA_D_FMT: Option<&str> = None;
        /// `None`
        pub const ERA_D_T_FMT: Option<&str> = None;
        /// `None`
        pub const ERA_T_FMT: Option<&str> = None;
        /// `None`
        pub const FIRST_WEEKDAY: Option<i64> = None;
        /// `None`
        pub const FIRST_WORKDAY: Option<i64> = None;
        /// `&["inïru", "phiwriru", "marsu", "awrila", "mayu", "junyu", "julyu", "awustu", "sitimri", "uktuwri", "nuwimri", "risimri"]`
        pub const MON: &[&str] = &["inïru", "phiwriru", "marsu", "awrila", "mayu", "junyu", "julyu", "awustu", "sitimri", "uktuwri", "nuwimri", "risimri"];
        /// `"%T"`
        pub const T_FMT: &str = "%T";
        /// `"%I:%M:%S %p"`
        pub const T_FMT_AMPM: &str = "%I:%M:%S %p";
        /// `Some(&[7, 19971130, 1])`
        pub const WEEK: Option<&[i64]> = Some(&[7, 19971130, 1]);
    }
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod az_AZ {
    pub mod LC_ADDRESS {
        /// `Some("AZE")`
        pub const COUNTRY_AB3: Option<&str> = Some("AZE");
        /// `Some("AZ")`
        pub const COUNTRY_ABTWO: Option<&str> = Some("AZ");
        /// `Some("AZ")`
        pub const COUNTRY_CAR: Option<&str> = Some("AZ");
        /// `None`
        pub const COUNTRY_ISBN: Option<&str> = None;
        /// `Some("Azərbaycan")`
        pub const COUNTRY_NAME: Option<&str> = Some("Azərbaycan");
        /// `Some(31)`
        pub const COUNTRY_NUM: Option<i64> = Some(31);
        /// `None`
        pub const COUNTRY_POST: Option<&str> = None;
        /// `Some("az")`
        pub const LANG_AB: Option<&str> = Some("az");
        /// `Some("aze")`
        pub const LANG_LIB: Option<&str> = Some("aze");
        /// `Some("azərbaycan")`
        pub const LANG_NAME: Option<&str> = Some("azərbaycan");
        /// `Some("aze")`
        pub const LANG_TERM: Option<&str> = Some("aze");
        /// `Some("???")`
        pub const POSTAL_FMT: Option<&str> = Some("???");
    }
    pub mod LC_IDENTIFICATION {
        /// `None`
        pub const ABBREVIATION: Option<&str> = None;
        /// `Some("")`
        pub const ADDRESS: Option<&str> = Some("");
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        /// ]
        /// ```
        pub const CATEGORY: Option<&[&[&str]]> = Some(&[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_TELEPHONE"],
            &["i18n:2012", "LC_MEASUREMENT"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_MESSAGES"],
        ]);
        /// `Some("Pablo Saratxaga")`
        pub const CONTACT: Option<&str> = Some("Pablo Saratxaga");
        /// `Some("2001-01-26")`
        pub const DATE: Option<&str> = Some("2001-01-26");
        /// `Some("pablo@mandrakesoft.com")`
        pub const EMAIL: Option<&str> = Some("pablo@mandrakesoft.com");
        /// `Some("")`
        pub const FAX: Option<&str> = Some("");
        /// `Some("Azerbaijani")`
        pub const LANGUAGE: Option<&str> = Some("Azerbaijani");
        /// `Some("0.4")`
        pub const REVISION: Option<&str> = Some("0.4");
        /// `Some("")`
        pub const SOURCE: Option<&str> = Some("");
        /// `Some("")`
        pub const TEL: Option<&str> = Some("");
        /// `Some("Azerbaijan")`
        pub const TERRITORY: Option<&str> = Some("Azerbaijan");
        /// `Some("Azeri language locale for Azerbaijan (latin)")`
        pub const TITLE: Option<&str> = Some("Azeri language locale for Azerbaijan (latin)");
    }
    pub mod LC_MESSAGES {
        /// `"^[-0YyNn]"`
        pub const NOEXPR: &str = "^[-0YyNn]";
        /// `Some("yox")`
        pub const NOSTR: Option<&str> = Some("yox");
        /// `"^[+1bBhH]"`
        pub const YESEXPR: &str = "^[+1bBhH]";
        /// `Some("hə")`
        pub const YESSTR: Option<&str> = Some("hə");
    }
    pub mod LC_MONETARY {
        /// `"₼"`
        pub const CURRENCY_SYMBOL: &str = "₼";
        /// `2`
        pub const FRAC_DIGITS: i64 = 2;
        /// `"AZN "`
        pub const INT_CURR_SYMBOL: &str = "AZN ";
        /// `2`
        pub const INT_FRAC_DIGITS: i64 = 2;
        /// `None`
        pub const INT_N_CS_PRECEDES: Option<i64> = None;
        /// `None`
        pub const INT_N_SEP_BY_SPACE: Option<i64> = None;
        /// `None`
        pub const INT_N_SIGN_POSN: Option<i64> = None;
        /// `None`
        pub const INT_P_CS_PRECEDES: Option<i64> = None;
        /// `None`
        pub const INT_P_SEP_BY_SPACE: Option<i64> = None;
        /// `None`
        pub const INT_P_SIGN_POSN: Option<i64> = None;
        /// `"."`
        pub const MON_DECIMAL_POINT: &str = ".";
        /// `&[3, 3]`
        pub const MON_GROUPING: &[i64] = &[3, 3];
        /// `"\u{202f}"`
        pub const MON_THOUSANDS_SEP: &str = "\u{202f}";
        /// `"-"`
        pub const NEGATIVE_SIGN: &str = "-";
        /// `0`
        pub const N_CS_PRECEDES: i64 = 0;
        /// `1`
        pub const N_SEP_BY_SPACE: i64 = 1;
        /// `1`
        pub const N_SIGN_POSN: i64 = 1;
        /// `""`
        pub const POSITIVE_SIGN: &str = "";
        /// `0`
        pub const P_CS_PRECEDES: i64 = 0;
        /// `1`
        pub const P_SEP_BY_SPACE: i64 = 1;
        /// `1`
        pub const P_SIGN_POSN: i64 = 1;
    }
    pub mod LC_NUMERIC {
        /// `","`
        pub const DECIMAL_POINT: &str = ",";
        /// `&[3, 3]`
        pub const GROUPING: &[i64] = &[3, 3];
        /// `"."`
        pub const THOUSANDS_SEP: &str = ".";
    }
    pub mod LC_TELEPHONE {
        /// `Some("994")`
        pub const INT_PREFIX: Option<&str> = Some("994");
        /// `Some("00")`
        pub const INT_SELECT: Option<&str> = Some("00");
        /// `None`
        pub const TEL_DOM_FMT: Option<&str> = None;
        /// `Some("+%c %a %l")`
        pub const TEL_INT_FMT: Option<&str> = Some("+%c %a %l");
    }
    pub mod LC_TIME {
        /// `&["baz", "ber", "çax", "çər", "cax", "cüm", "şnb"]`
        pub const ABDAY: &[&str] = &["baz", "ber", "çax", "çər", "cax", "cüm", "şnb"];
        /// `&["Yan", "Fev", "Mar", "Apr", "May", "İyn", "İyl", "Avq", "Sen", "Okt", "Noy", "Dek"]`
        pub const ABMON: &[&str] = &["Yan", "Fev", "Mar", "Apr", "May", "İyn", "İyl", "Avq", "Sen", "Okt", "Noy", "Dek"];
        /// `None`
        pub const AB_ALT_MON: Option<&[&str]> = None;
        /// `None`
        pub const ALT_DIGITS: Option<&[&str]> = None;
        /// `None`
        pub const ALT_MON: Option<&[&str]> = None;
        /// `&["", ""]`
        pub const AM_PM: &[&str] = &["", ""];
        /// `None`
        pub const CAL_DIRECTION: Option<i64> = None;
        /// `None`
        pub const DATE_FMT: Option<&str> = None;
        /// `&["bazar günü", "bazar ertəsi", "çərşənbə axşamı", "çərşənbə", "cümə axşamı", "cümə", "şənbə"]`
        pub const DAY: &[&str] = &["bazar günü", "bazar ertəsi", "çərşənbə axşamı", "çərşənbə", "cümə axşamı", "cümə", "şənbə"];
        /// `"%d.%m.%Y"`
        pub const D_FMT: &str = "%d.%m.%Y";
        /// `"%A, %d %B %Y %T"`
        pub const D_T_FMT: &str = "%A, %d %B %Y %T";
        /// `None`
        pub const ERA: Option<&[&str]> = None;
        /// `None`
        pub const ERA_D_FMT: Option<&str> = None;
        /// `None`
        pub const ERA_D_T_FMT: Option<&str> = None;
        /// `None`
        pub const ERA_T_FMT: Option<&str> = None;
        /// `Some(2)`
        pub const FIRST_WEEKDAY: Option<i64> = Some(2);
        /// `None`
        pub const FIRST_WORKDAY: Option<i64> = None;
        /// `&["yanvar", "fevral", "mart", "aprel", "may", "iyun", "iyul", "avqust", "sentyabr", "oktyabr", "noyabr", "dekabr"]`
        pub const MON: &[&str] = &["yanvar", "fevral", "mart", "aprel", "may", "iyun", "iyul", "avqust", "sentyabr", "oktyabr", "noyabr", "dekabr"];
        /// `"%T"`
        pub const T_FMT: &str = "%T";
        /// `""`
        pub const T_FMT_AMPM: &str = "";
        /// `Some(&[7, 19971130, 1])`
        pub const WEEK: Option<&[i64]> = Some(&[7, 19971130, 1]);
    }
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod az_IR {
    pub mod LC_ADDRESS {
        /// `Some("IRN")`
        pub const COUNTRY_AB3: Option<&str> = Some("IRN");
        /// `Some("IR")`
        pub const COUNTRY_ABTWO: Option<&str> = Some("IR");
        /// `Some("IR")`
        pub const COUNTRY_CAR: Option<&str> = Some("IR");
        /// `Some("964")`
        pub const COUNTRY_ISBN: Option<&str> = Some("964");
        /// `Some("ایران")`
        pub const COUNTRY_NAME: Option<&str> = Some("ایران");
        /// `Some(364)`
        pub const COUNTRY_NUM: Option<i64> = Some(364);
        /// `None`
        pub const COUNTRY_POST: Option<&str> = None;
        /// `Some("az")`
        pub const LANG_AB: Option<&str> = Some("az");
        /// `Some("aze")`
        pub const LANG_LIB: Option<&str> = Some("aze");
        /// `Some("تۆرکجه")`
        pub const LANG_NAME: Option<&str> = Some("تۆرکجه");
        /// `Some("azb")`
        pub const LANG_TERM: Option<&str> = Some("azb");
        /// `Some("%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%c%N")`
        pub const POSTAL_FMT: Option<&str> = Some("%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%c%N");
    }
    pub mod LC_IDENTIFICATION {
        /// `None`
        pub const ABBREVIATION: Option<&str> = None;
        /// `Some("")`
        pub const ADDRESS: Option<&str> = Some("");
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        /// ]
        /// ```
        pub const CATEGORY: Option<&[&[&str]]> = Some(&[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_TELEPHONE"],
            &["i18n:2012", "LC_MEASUREMENT"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_MESSAGES"],
        ]);
        /// `Some("Mousa Moradi")`
        pub const CONTACT: Option<&str> = Some("Mousa Moradi");
        /// `Some("2014-05-01")`
        pub const DATE: Option<&str> = Some("2014-05-01");
        /// `Some("mousamk@gmail.com")`
        pub const EMAIL: Option<&str> = Some("mousamk@gmail.com");
        /// `Some("")`
        pub const FAX: Option<&str> = Some("");
        /// `Some("South Azerbaijani")`
        pub const LANGUAGE: Option<&str> = Some("South Azerbaijani");
        /// `Some("0.2")`
        pub const REVISION: Option<&str> = Some("0.2");
        /// `Some("")`
        pub const SOURCE: Option<&str> = Some("");
        /// `Some("(+98) 914 492 1058")`
        pub const TEL: Option<&str> = Some("(+98) 914 492 1058");
        /// `Some("Iran")`
        pub const TERRITORY: Option<&str> = Some("Iran");
        /// `Some("South Azerbaijani language locale for Iran")`
        pub const TITLE: Option<&str> = Some("South Azerbaijani language locale for Iran");
    }
    pub mod LC_MESSAGES {
        /// `"^[-0nNیخ]"`
        pub const NOEXPR: &str = "^[-0nNیخ]";
        /// `Some("یو\u{652}خ")`
        pub const NOSTR: Option<&str> = Some("یو\u{652}خ");
        /// `"^[+1yYهب]"`
        pub const YESEXPR: &str = "^[+1yYهب]";
        /// `Some("هن")`
        pub const YESSTR: Option<&str> = Some("هن");
    }
    pub use super::fa_IR::LC_MONETARY;
    pub use super::fa_IR::LC_NUMERIC;
    pub use super::fa_IR::LC_TELEPHONE;
    pub mod LC_TIME {
        /// `&["یکشنبه", "دوشنبه", "سه\u{200c}شنبه", "چارشنبه", "جۆمعه آخشامی", "جۆمعه", "شنبه"]`
        pub const ABDAY: &[&str] = &["یکشنبه", "دوشنبه", "سه\u{200c}شنبه", "چارشنبه", "جۆمعه آخشامی", "جۆمعه", "شنبه"];
        /// `&["ژانویه", "فوریه", "مارس", "آوریل", "مئی", "ژوئن", "جولای", "آقۇست", "سپتامبر", "او\u{652}کتو\u{652}بر", "نو\u{652}وامبر", "دسامبر"]`
        pub const ABMON: &[&str] = &["ژانویه", "فوریه", "مارس", "آوریل", "مئی", "ژوئن", "جولای", "آقۇست", "سپتامبر", "او\u{652}کتو\u{652}بر", "نو\u{652}وامبر", "دسامبر"];
        /// `None`
        pub const AB_ALT_MON: Option<&[&str]> = None;
        /// `Some(&["۰۰", "۰۱", "۰۲", "۰۳", "۰۴", "۰۵", "۰۶", "۰۷", "۰۸", "۰۹", "۱۰", "۱۱", "۱۲", "۱۳", "۱۴", "۱۵", "۱۶", "۱۷", "۱۸", "۱۹", "۲۰", "۲۱", "۲۲", "۲۳", "۲۴", "۲۵", "۲۶", "۲۷", "۲۸", "۲۹", "۳۰", "۳۱", "۳۲", "۳۳", "۳۴", "۳۵", "۳۶", "۳۷", "۳۸", "۳۹", "۴۰", "۴۱", "۴۲", "۴۳", "۴۴", "۴۵", "۴۶", "۴۷", "۴۸", "۴۹", "۵۰", "۵۱", "۵۲", "۵۳", "۵۴", "۵۵", "۵۶", "۵۷", "۵۸", "۵۹", "۶۰", "۶۱", "۶۲", "۶۳", "۶۴", "۶۵", "۶۶", "۶۷", "۶۸", "۶۹", "۷۰", "۷۱", "۷۲", "۷۳", "۷۴", "۷۵", "۷۶", "۷۷", "۷۸", "۷۹", "۸۰", "۸۱", "۸۲", "۸۳", "۸۴", "۸۵", "۸۶", "۸۷", "۸۸", "۸۹", "۹۰", "۹۱", "۹۲", "۹۳", "۹۴", "۹۵", "۹۶", "۹۷", "۹۸", "۹۹"])`
        pub const ALT_DIGITS: Option<&[&str]> = Some(&["۰۰", "۰۱", "۰۲", "۰۳", "۰۴", "۰۵", "۰۶", "۰۷", "۰۸", "۰۹", "۱۰", "۱۱", "۱۲", "۱۳", "۱۴", "۱۵", "۱۶", "۱۷", "۱۸", "۱۹", "۲۰", "۲۱", "۲۲", "۲۳", "۲۴", "۲۵", "۲۶", "۲۷", "۲۸", "۲۹", "۳۰", "۳۱", "۳۲", "۳۳", "۳۴", "۳۵", "۳۶", "۳۷", "۳۸", "۳۹", "۴۰", "۴۱", "۴۲", "۴۳", "۴۴", "۴۵", "۴۶", "۴۷", "۴۸", "۴۹", "۵۰", "۵۱", "۵۲", "۵۳", "۵۴", "۵۵", "۵۶", "۵۷", "۵۸", "۵۹", "۶۰", "۶۱", "۶۲", "۶۳", "۶۴", "۶۵", "۶۶", "۶۷", "۶۸", "۶۹", "۷۰", "۷۱", "۷۲", "۷۳", "۷۴", "۷۵", "۷۶", "۷۷", "۷۸", "۷۹", "۸۰", "۸۱", "۸۲", "۸۳", "۸۴", "۸۵", "۸۶", "۸۷", "۸۸", "۸۹", "۹۰", "۹۱", "۹۲", "۹۳", "۹۴", "۹۵", "۹۶", "۹۷", "۹۸", "۹۹"]);
        /// `None`
        pub const ALT_MON: Option<&[&str]> = None;
        /// `&["", ""]`
        pub const AM_PM: &[&str] = &["", ""];
        /// `Some(3)`
        pub const CAL_DIRECTION: Option<i64> = Some(3);
        /// `Some("\u{202b}%A %Oe %B %Oy، ساعات %OH:%OM:%OS (%Z)\u{202c}")`
        pub const DATE_FMT: Option<&str> = Some("\u{202b}%A %Oe %B %Oy، ساعات %OH:%OM:%OS (%Z)\u{202c}");
        /// `&["یکشنبه", "دوشنبه", "سه\u{200c}شنبه", "چارشنبه", "جۆمعه آخشامی", "جۆمعه", "شنبه"]`
        pub const DAY: &[&str] = &["یکشنبه", "دوشنبه", "سه\u{200c}شنبه", "چارشنبه", "جۆمعه آخشامی", "جۆمعه", "شنبه"];
        /// `"%Oy/%Om/%Od"`
        pub const D_FMT: &str = "%Oy/%Om/%Od";
        /// `"\u{202b}%A %Oe %B %Oy، %OH:%OM:%OS\u{202c}"`
        pub const D_T_FMT: &str = "\u{202b}%A %Oe %B %Oy، %OH:%OM:%OS\u{202c}";
        /// `None`
        pub const ERA: Option<&[&str]> = None;
        /// `None`
        pub const ERA_D_FMT: Option<&str> = None;
        /// `None`
        pub const ERA_D_T_FMT: Option<&str> = None;
        /// `None`
        pub const ERA_T_FMT: Option<&str> = None;
        /// `Some(7)`
        pub const FIRST_WEEKDAY: Option<i64> = Some(7);
        /// `Some(7)`
        pub const FIRST_WORKDAY: Option<i64> = Some(7);
        /// `&["ژانویه", "فوریه", "مارس", "آوریل", "مئی", "ژوئن", "جولای", "آقۇست", "سپتامبر", "او\u{652}کتو\u{652}بر", "نو\u{652}وامبر", "دسامبر"]`
        pub const MON: &[&str] = &["ژانویه", "فوریه", "مارس", "آوریل", "مئی", "ژوئن", "جولای", "آقۇست", "سپتامبر", "او\u{652}کتو\u{652}بر", "نو\u{652}وامبر", "دسامبر"];
        /// `"%OH:%OM:%OS"`
        pub const T_FMT: &str = "%OH:%OM:%OS";
        /// `""`
        pub const T_FMT_AMPM: &str = "";
        /// `None`
        pub const WEEK: Option<&[i64]> = None;
    }
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod be_BY {
    pub mod LC_ADDRESS {
        /// `Some("BLR")`
        pub const COUNTRY_AB3: Option<&str> = Some("BLR");
        /// `Some("BY")`
        pub const COUNTRY_ABTWO: Option<&str> = Some("BY");
        /// `Some("BY")`
        pub const COUNTRY_CAR: Option<&str> = Some("BY");
        /// `None`
        pub const COUNTRY_ISBN: Option<&str> = None;
        /// `Some("Беларусь")`
        pub const COUNTRY_NAME: Option<&str> = Some("Беларусь");
        /// `Some(112)`
        pub const COUNTRY_NUM: Option<i64> = Some(112);
        /// `None`
        pub const COUNTRY_POST: Option<&str> = None;
        /// `Some("be")`
        pub const LANG_AB: Option<&str> = Some("be");
        /// `Some("bel")`
        pub const LANG_LIB: Option<&str> = Some("bel");
        /// `Some("беларуская")`
        pub const LANG_NAME: Option<&str> = Some("беларуская");
        /// `Some("bel")`
        pub const LANG_TERM: Option<&str> = Some("bel");
        /// `Some("%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%c%N")`
        pub const POSTAL_FMT: Option<&str> = Some("%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%c%N");
    }
    pub mod LC_IDENTIFICATION {
        /// `None`
        pub const ABBREVIATION: Option<&str> = None;
        /// `Some("")`
        pub const ADDRESS: Option<&str> = Some("");
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        /// ]
        /// ```
        pub const CATEGORY: Option<&[&[&str]]> = Some(&[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_TELEPHONE"],
            &["i18n:2012", "LC_MEASUREMENT"],
        ]);
        /// `Some("")`
        pub const CONTACT: Option<&str> = Some("");
        /// `Some("2000-06-29")`
        pub const DATE: Option<&str> = Some("2000-06-29");
        /// `Some("bug-glibc-locales@gnu.org")`
        pub const EMAIL: Option<&str> = Some("bug-glibc-locales@gnu.org");
        /// `Some("")`
        pub const FAX: Option<&str> = Some("");
        /// `Some("Belarusian")`
        pub const LANGUAGE: Option<&str> = Some("Belarusian");
        /// `Some("1.0")`
        pub const REVISION: Option<&str> = Some("1.0");
        /// `Some("")`
        pub const SOURCE: Option<&str> = Some("");
        /// `Some("")`
        pub const TEL: Option<&str> = Some("");
        /// `Some("Belarus")`
        pub const TERRITORY: Option<&str> = Some("Belarus");
        /// `Some("Belarusian locale for Belarus")`
        pub const TITLE: Option<&str> = Some("Belarusian locale for Belarus");
    }
    pub mod LC_MESSAGES {
        /// `"^[-0nNНн]"`
        pub const NOEXPR: &str = "^[-0nNНн]";
        /// `Some("не")`
        pub const NOSTR: Option<&str> = Some("не");
        /// `"^[+1yYТт]"`
        pub const YESEXPR: &str = "^[+1yYТт]";
        /// `Some("так")`
        pub const YESSTR: Option<&str> = Some("так");
    }
    pub mod LC_MONETARY {
        /// `"руб"`
        pub const CURRENCY_SYMBOL: &str = "руб";
        /// `2`
        pub const FRAC_DIGITS: i64 = 2;
        /// `"BYR "`
        pub const INT_CURR_SYMBOL: &str = "BYR ";
        /// `2`
        pub const INT_FRAC_DIGITS: i64 = 2;
        /// `None`
        pub const INT_N_CS_PRECEDES: Option<i64> = None;
        /// `None`
        pub const INT_N_SEP_BY_SPACE: Option<i64> = None;
        /// `None`
        pub const INT_N_SIGN_POSN: Option<i64> = None;
        /// `None`
        pub const INT_P_CS_PRECEDES: Option<i64> = None;
        /// `None`
        pub const INT_P_SEP_BY_SPACE: Option<i64> = None;
        /// `None`
        pub const INT_P_SIGN_POSN: Option<i64> = None;
        /// `"."`
        pub const MON_DECIMAL_POINT: &str = ".";
        /// `&[3, 3]`
        pub const MON_GROUPING: &[i64] = &[3, 3];
        /// `"\u{202f}"`
        pub const MON_THOUSANDS_SEP: &str = "\u{202f}";
        /// `"-"`
        pub const NEGATIVE_SIGN: &str = "-";
        /// `0`
        pub const N_CS_PRECEDES: i64 = 0;
        /// `1`
        pub const N_SEP_BY_SPACE: i64 = 1;
        /// `1`
        pub const N_SIGN_POSN: i64 = 1;
        /// `""`
        pub const POSITIVE_SIGN: &str = "";
        /// `0`
        pub const P_CS_PRECEDES: i64 = 0;
        /// `1`
        pub const P_SEP_BY_SPACE: i64 = 1;
        /// `1`
        pub const P_SIGN_POSN: i64 = 1;
    }
    pub mod LC_NUMERIC {
        /// `","`
        pub const DECIMAL_POINT: &str = ",";
        /// `&[3, 3]`
        pub const GROUPING: &[i64] = &[3, 3];
        /// `"."`
        pub const THOUSANDS_SEP: &str = ".";
    }
    pub mod LC_TELEPHONE {
        /// `Some("375")`
        pub const INT_PREFIX: Option<&str> = Some("375");
        /// `Some("8~10")`
        pub const INT_SELECT: Option<&str> = Some("8~10");
        /// `None`
        pub const TEL_DOM_FMT: Option<&str> = None;
        /// `Some("+%c %a %l")`
        pub const TEL_INT_FMT: Option<&str> = Some("+%c %a %l");
    }
    pub mod LC_TIME {
        /// `&["Няд", "Пан", "Аўт", "Срд", "Чцв", "Пят", "Суб"]`
        pub const ABDAY: &[&str] = &["Няд", "Пан", "Аўт", "Срд", "Чцв", "Пят", "Суб"];
        /// `&["сту", "лют", "сак", "кра", "мая", "чэр", "ліп", "жні", "вер", "кас", "ліс", "сне"]`
        pub const ABMON: &[&str] = &["сту", "лют", "сак", "кра", "мая", "чэр", "ліп", "жні", "вер", "кас", "ліс", "сне"];
        /// `Some(&["сту", "лют", "сак", "кра", "май", "чэр", "ліп", "жні", "вер", "кас", "ліс", "сне"])`
        pub const AB_ALT_MON: Option<&[&str]> = Some(&["сту", "лют", "сак", "кра", "май", "чэр", "ліп", "жні", "вер", "кас", "ліс", "сне"]);
        /// `None`
        pub const ALT_DIGITS: Option<&[&str]> = None;
        /// `Some(&["студзень", "люты", "сакавік", "красавік", "май", "чэрвень", "ліпень", "жнівень", "верасень", "кастрычнік", "лістапад", "снежань"])`
        pub const ALT_MON: Option<&[&str]> = Some(&["студзень", "люты", "сакавік", "красавік", "май", "чэрвень", "ліпень", "жнівень", "верасень", "кастрычнік", "лістапад", "снежань"]);
        /// `&["", ""]`
        pub const AM_PM: &[&str] = &["", ""];
        /// `None`
        pub const CAL_DIRECTION: Option<i64> = None;
        /// `None`
        pub const DATE_FMT: Option<&str> = None;
        /// `&["Нядзеля", "Панядзелак", "Аўторак", "Серада", "Чацвер", "Пятніца", "Субота"]`
        pub const DAY: &[&str] = &["Нядзеля", "Панядзелак", "Аўторак", "Серада", "Чацвер", "Пятніца", "Субота"];
        /// `"%d.%m.%Y"`
        pub const D_FMT: &str = "%d.%m.%Y";
        /// `"%a %d %b %Y %T"`
        pub const D_T_FMT: &str = "%a %d %b %Y %T";
        /// `None`
        pub const ERA: Option<&[&str]> = None;
        /// `None`
        pub const ERA_D_FMT: Option<&str> = None;
        /// `None`
        pub const ERA_D_T_FMT: Option<&str> = None;
        /// `None`
        pub const ERA_T_FMT: Option<&str> = None;
        /// `Some(2)`
        pub const FIRST_WEEKDAY: Option<i64> = Some(2);
        /// `None`
        pub const FIRST_WORKDAY: Option<i64> = None;
        /// `&["студзеня", "лютага", "сакавіка", "красавіка", "мая", "чэрвеня", "ліпеня", "жніўня", "верасня", "кастрычніка", "лістапада", "снежня"]`
        pub const MON: &[&str] = &["студзеня", "лютага", "сакавіка", "красавіка", "мая", "чэрвеня", "ліпеня", "жніўня", "верасня", "кастрычніка", "лістапада", "снежня"];
        /// `"%T"`
        pub const T_FMT: &str = "%T";
        /// `""`
        pub const T_FMT_AMPM: &str = "";
        /// `Some(&[7, 19971130, 1])`
        pub const WEEK: Option<&[i64]> = Some(&[7, 19971130, 1]);
    }
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod be_BY_latin {
    pub mod LC_ADDRESS {
        /// `Some("BLR")`
        pub const COUNTRY_AB3: Option<&str> = Some("BLR");
        /// `Some("BY")`
        pub const COUNTRY_ABTWO: Option<&str> = Some("BY");
        /// `Some("BY")`
        pub const COUNTRY_CAR: Option<&str> = Some("BY");
        /// `None`
        pub const COUNTRY_ISBN: Option<&str> = None;
        /// `Some("Biełaruś")`
        pub const COUNTRY_NAME: Option<&str> = Some("Biełaruś");
        /// `Some(112)`
        pub const COUNTRY_NUM: Option<i64> = Some(112);
        /// `None`
        pub const COUNTRY_POST: Option<&str> = None;
        /// `Some("be")`
        pub const LANG_AB: Option<&str> = Some("be");
        /// `Some("bel")`
        pub const LANG_LIB: Option<&str> = Some("bel");
        /// `Some("biełaruskaja")`
        pub const LANG_NAME: Option<&str> = Some("biełaruskaja");
        /// `Some("bel")`
        pub const LANG_TERM: Option<&str> = Some("bel");
        /// `Some("%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%c%N")`
        pub const POSTAL_FMT: Option<&str> = Some("%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%c%N");
    }
    pub mod LC_IDENTIFICATION {
        /// `None`
        pub const ABBREVIATION: Option<&str> = None;
        /// `Some("")`
        pub const ADDRESS: Option<&str> = Some("");
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        /// ]
        /// ```
        pub const CATEGORY: Option<&[&[&str]]> = Some(&[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_TELEPHONE"],
            &["i18n:2012", "LC_MEASUREMENT"],
        ]);
        /// `Some("")`
        pub const CONTACT: Option<&str> = Some("");
        /// `Some("2005-09-15")`
        pub const DATE: Option<&str> = Some("2005-09-15");
        /// `Some("bug-glibc-locales@gnu.org")`
        pub const EMAIL: Option<&str> = Some("bug-glibc-locales@gnu.org");
        /// `Some("")`
        pub const FAX: Option<&str> = Some("");
        /// `Some("Belarusian")`
        pub const LANGUAGE: Option<&str> = Some("Belarusian");
        /// `Some("1.0")`
        pub const REVISION: Option<&str> = Some("1.0");
        /// `Some("")`
        pub const SOURCE: Option<&str> = Some("");
        /// `Some("")`
        pub const TEL: Option<&str> = Some("");
        /// `Some("Belarus")`
        pub const TERRITORY: Option<&str> = Some("Belarus");
        /// `Some("Belarusian Latin-Script locale for Belarus")`
        pub const TITLE: Option<&str> = Some("Belarusian Latin-Script locale for Belarus");
    }
    pub mod LC_MESSAGES {
        /// `"^[-0Nn]"`
        pub const NOEXPR: &str = "^[-0Nn]";
        /// `None`
        pub const NOSTR: Option<&str> = None;
        /// `"^[+1TtYy]"`
        pub const YESEXPR: &str = "^[+1TtYy]";
        /// `None`
        pub const YESSTR: Option<&str> = None;
    }
    pub mod LC_MONETARY {
        /// `"Rub"`
        pub const CURRENCY_SYMBOL: &str = "Rub";
        /// `2`
        pub const FRAC_DIGITS: i64 = 2;
        /// `"BYR "`
        pub const INT_CURR_SYMBOL: &str = "BYR ";
        /// `2`
        pub const INT_FRAC_DIGITS: i64 = 2;
        /// `None`
        pub const INT_N_CS_PRECEDES: Option<i64> = None;
        /// `None`
        pub const INT_N_SEP_BY_SPACE: Option<i64> = None;
        /// `None`
        pub const INT_N_SIGN_POSN: Option<i64> = None;
        /// `None`
        pub const INT_P_CS_PRECEDES: Option<i64> = None;
        /// `None`
        pub const INT_P_SEP_BY_SPACE: Option<i64> = None;
        /// `None`
        pub const INT_P_SIGN_POSN: Option<i64> = None;
        /// `"."`
        pub const MON_DECIMAL_POINT: &str = ".";
        /// `&[3, 3]`
        pub const MON_GROUPING: &[i64] = &[3, 3];
        /// `"\u{202f}"`
        pub const MON_THOUSANDS_SEP: &str = "\u{202f}";
        /// `"-"`
        pub const NEGATIVE_SIGN: &str = "-";
        /// `0`
        pub const N_CS_PRECEDES: i64 = 0;
        /// `1`
        pub const N_SEP_BY_SPACE: i64 = 1;
        /// `1`
        pub const N_SIGN_POSN: i64 = 1;
        /// `""`
        pub const POSITIVE_SIGN: &str = "";
        /// `0`
        pub const P_CS_PRECEDES: i64 = 0;
        /// `1`
        pub const P_SEP_BY_SPACE: i64 = 1;
        /// `1`
        pub const P_SIGN_POSN: i64 = 1;
    }
    pub use super::be_BY::LC_NUMERIC;
    pub use super::be_BY::LC_TELEPHONE;
    pub mod LC_TIME {
        /// `&["Nia", "Pan", "Aŭt", "Sie", "Čać", "Pia", "Sub"]`
        pub const ABDAY: &[&str] = &["Nia", "Pan", "Aŭt", "Sie", "Čać", "Pia", "Sub"];
        /// `&["Stu", "Lut", "Sak", "Kra", "Maj", "Čer", "Lip", "Žni", "Vie", "Kas", "Lis", "Śni"]`
        pub const ABMON: &[&str] = &["Stu", "Lut", "Sak", "Kra", "Maj", "Čer", "Lip", "Žni", "Vie", "Kas", "Lis", "Śni"];
        /// `None`
        pub const AB_ALT_MON: Option<&[&str]> = None;
        /// `None`
        pub const ALT_DIGITS: Option<&[&str]> = None;
        /// `Some(&["Studzień", "Luty", "Sakavik", "Krasavik", "Maj", "Červień", "Lipień", "Žnivień", "Vierasień", "Kastryčnik", "Listapad", "Śniežań"])`
        pub const ALT_MON: Option<&[&str]> = Some(&["Studzień", "Luty", "Sakavik", "Krasavik", "Maj", "Červień", "Lipień", "Žnivień", "Vierasień", "Kastryčnik", "Listapad", "Śniežań"]);
        /// `&["", ""]`
        pub const AM_PM: &[&str] = &["", ""];
        /// `None`
        pub const CAL_DIRECTION: Option<i64> = None;
        /// `None`
        pub const DATE_FMT: Option<&str> = None;
        /// `&["Niadziela", "Paniadziełak", "Aŭtorak", "Sierada", "Čaćvier", "Piatnica", "Subota"]`
        pub const DAY: &[&str] = &["Niadziela", "Paniadziełak", "Aŭtorak", "Sierada", "Čaćvier", "Piatnica", "Subota"];
        /// `"%d.%m.%Y"`
        pub const D_FMT: &str = "%d.%m.%Y";
        /// `"%a %d %b %Y %T"`
        pub const D_T_FMT: &str = "%a %d %b %Y %T";
        /// `None`
        pub const ERA: Option<&[&str]> = None;
        /// `None`
        pub const ERA_D_FMT: Option<&str> = None;
        /// `None`
        pub const ERA_D_T_FMT: Option<&str> = None;
        /// `None`
        pub const ERA_T_FMT: Option<&str> = None;
        /// `Some(2)`
        pub const FIRST_WEEKDAY: Option<i64> = Some(2);
        /// `None`
        pub const FIRST_WORKDAY: Option<i64> = None;
        /// `&["studzienia", "lutaha", "sakavika", "krasavika", "maja", "červienia", "lipienia", "žniŭnia", "vieraśnia", "kastryčnika", "listapada", "śniežnia"]`
        pub const MON: &[&str] = &["studzienia", "lutaha", "sakavika", "krasavika", "maja", "červienia", "lipienia", "žniŭnia", "vieraśnia", "kastryčnika", "listapada", "śniežnia"];
        /// `"%T"`
        pub const T_FMT: &str = "%T";
        /// `""`
        pub const T_FMT_AMPM: &str = "";
        /// `Some(&[7, 19971130, 1])`
        pub const WEEK: Option<&[i64]> = Some(&[7, 19971130, 1]);
    }
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod bem_ZM {
    pub mod LC_ADDRESS {
        /// `Some("ZMB")`
        pub const COUNTRY_AB3: Option<&str> = Some("ZMB");
        /// `Some("ZM")`
        pub const COUNTRY_ABTWO: Option<&str> = Some("ZM");
        /// `Some("Z")`
        pub const COUNTRY_CAR: Option<&str> = Some("Z");
        /// `None`
        pub const COUNTRY_ISBN: Option<&str> = None;
        /// `Some("Zambia")`
        pub const COUNTRY_NAME: Option<&str> = Some("Zambia");
        /// `Some(894)`
        pub const COUNTRY_NUM: Option<i64> = Some(894);
        /// `Some("ZM")`
        pub const COUNTRY_POST: Option<&str> = Some("ZM");
        /// `None`
        pub const LANG_AB: Option<&str> = None;
        /// `Some("bem")`
        pub const LANG_LIB: Option<&str> = Some("bem");
        /// `Some("Ichibemba")`
        pub const LANG_NAME: Option<&str> = Some("Ichibemba");
        /// `Some("bem")`
        pub const LANG_TERM: Option<&str> = Some("bem");
        /// `Some("%a%N%f%N%e %h%N%b %s%N%z%N%T%N%c%N")`
        pub const POSTAL_FMT: Option<&str> = Some("%a%N%f%N%e %h%N%b %s%N%z%N%T%N%c%N");
    }
    pub mod LC_IDENTIFICATION {
        /// `None`
        pub const ABBREVIATION: Option<&str> = None;
        /// `None`
        pub const ADDRESS: Option<&str> = None;
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        /// ]
        /// ```
        pub const CATEGORY: Option<&[&[&str]]> = Some(&[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_MEASUREMENT"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_TELEPHONE"],
        ]);
        /// `Some("Martin Benjamin")`
        pub const CONTACT: Option<&str> = Some("Martin Benjamin");
        /// `Some("2011-04-18")`
        pub const DATE: Option<&str> = Some("2011-04-18");
        /// `Some("locales@africanlocalization.net")`
        pub const EMAIL: Option<&str> = Some("locales@africanlocalization.net");
        /// `None`
        pub const FAX: Option<&str> = None;
        /// `Some("Bemba")`
        pub const LANGUAGE: Option<&str> = Some("Bemba");
        /// `Some("1.0")`
        pub const REVISION: Option<&str> = Some("1.0");
        /// `Some("ANLoc")`
        pub const SOURCE: Option<&str> = Some("ANLoc");
        /// `None`
        pub const TEL: Option<&str> = None;
        /// `Some("Zambia")`
        pub const TERRITORY: Option<&str> = Some("Zambia");
        /// `Some("Bemba locale for Zambia")`
        pub const TITLE: Option<&str> = Some("Bemba locale for Zambia");
    }
    pub mod LC_MESSAGES {
        /// `"^[-0nNaA]"`
        pub const NOEXPR: &str = "^[-0nNaA]";
        /// `Some("Awe")`
        pub const NOSTR: Option<&str> = Some("Awe");
        /// `"^[+1yYeE]"`
        pub const YESEXPR: &str = "^[+1yYeE]";
        /// `Some("Ee")`
        pub const YESSTR: Option<&str> = Some("Ee");
    }
    pub mod LC_MONETARY {
        /// `"K"`
        pub const CURRENCY_SYMBOL: &str = "K";
        /// `2`
        pub const FRAC_DIGITS: i64 = 2;
        /// `"ZMW "`
        pub const INT_CURR_SYMBOL: &str = "ZMW ";
        /// `2`
        pub const INT_FRAC_DIGITS: i64 = 2;
        /// `None`
        pub const INT_N_CS_PRECEDES: Option<i64> = None;
        /// `None`
        pub const INT_N_SEP_BY_SPACE: Option<i64> = None;
        /// `None`
        pub const INT_N_SIGN_POSN: Option<i64> = None;
        /// `None`
        pub const INT_P_CS_PRECEDES: Option<i64> = None;
        /// `None`
        pub const INT_P_SEP_BY_SPACE: Option<i64> = None;
        /// `None`
        pub const INT_P_SIGN_POSN: Option<i64> = None;
        /// `"."`
        pub const MON_DECIMAL_POINT: &str = ".";
        /// `&[3]`
        pub const MON_GROUPING: &[i64] = &[3];
        /// `","`
        pub const MON_THOUSANDS_SEP: &str = ",";
        /// `"-"`
        pub const NEGATIVE_SIGN: &str = "-";
        /// `1`
        pub const N_CS_PRECEDES: i64 = 1;
        /// `0`
        pub const N_SEP_BY_SPACE: i64 = 0;
        /// `1`
        pub const N_SIGN_POSN: i64 = 1;
        /// `""`
        pub const POSITIVE_SIGN: &str = "";
        /// `1`
        pub const P_CS_PRECEDES: i64 = 1;
        /// `0`
        pub const P_SEP_BY_SPACE: i64 = 0;
        /// `1`
        pub const P_SIGN_POSN: i64 = 1;
    }
    pub mod LC_NUMERIC {
        /// `"."`
        pub const DECIMAL_POINT: &str = ".";
        /// `&[3]`
        pub const GROUPING: &[i64] = &[3];
        /// `","`
        pub const THOUSANDS_SEP: &str = ",";
    }
    pub mod LC_TELEPHONE {
        /// `Some("260")`
        pub const INT_PREFIX: Option<&str> = Some("260");
        /// `Some("00")`
        pub const INT_SELECT: Option<&str> = Some("00");
        /// `Some("%A %l")`
        pub const TEL_DOM_FMT: Option<&str> = Some("%A %l");
        /// `Some("+%c %A %l")`
        pub const TEL_INT_FMT: Option<&str> = Some("+%c %A %l");
    }
    pub mod LC_TIME {
        /// `&["Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"]`
        pub const ABDAY: &[&str] = &["Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"];
        /// `&["Jan", "Feb", "Mac", "Epr", "Mei", "Jun", "Jul", "Oga", "Sep", "Okt", "Nov", "Dis"]`
        pub const ABMON: &[&str] = &["Jan", "Feb", "Mac", "Epr", "Mei", "Jun", "Jul", "Oga", "Sep", "Okt", "Nov", "Dis"];
        /// `None`
        pub const AB_ALT_MON: Option<&[&str]> = None;
        /// `None`
        pub const ALT_DIGITS: Option<&[&str]> = None;
        /// `None`
        pub const ALT_MON: Option<&[&str]> = None;
        /// `&["uluchelo", "akasuba"]`
        pub const AM_PM: &[&str] = &["uluchelo", "akasuba"];
        /// `None`
        pub const CAL_DIRECTION: Option<i64> = None;
        /// `None`
        pub const DATE_FMT: Option<&str> = None;
        /// `&["Pa Mulungu", "Palichimo", "Palichibuli", "Palichitatu", "Palichine", "Palichisano", "Pachibelushi"]`
        pub const DAY: &[&str] = &["Pa Mulungu", "Palichimo", "Palichibuli", "Palichitatu", "Palichine", "Palichisano", "Pachibelushi"];
        /// `"%m/%d/%Y"`
        pub const D_FMT: &str = "%m/%d/%Y";
        /// `"%a %d %b %Y %R %Z"`
        pub const D_T_FMT: &str = "%a %d %b %Y %R %Z";
        /// `None`
        pub const ERA: Option<&[&str]> = None;
        /// `None`
        pub const ERA_D_FMT: Option<&str> = None;
        /// `None`
        pub const ERA_D_T_FMT: Option<&str> = None;
        /// `None`
        pub const ERA_T_FMT: Option<&str> = None;
        /// `Some(2)`
        pub const FIRST_WEEKDAY: Option<i64> = Some(2);
        /// `None`
        pub const FIRST_WORKDAY: Option<i64> = None;
        /// `&["Januari", "Februari", "Machi", "Epreo", "Mei", "Juni", "Julai", "Ogasti", "Septemba", "Oktoba", "Novemba", "Disemba"]`
        pub const MON: &[&str] = &["Januari", "Februari", "Machi", "Epreo", "Mei", "Juni", "Julai", "Ogasti", "Septemba", "Oktoba", "Novemba", "Disemba"];
        /// `"%T"`
        pub const T_FMT: &str = "%T";
        /// `"%I:%M:%S %p"`
        pub const T_FMT_AMPM: &str = "%I:%M:%S %p";
        /// `Some(&[7, 19971130, 1])`
        pub const WEEK: Option<&[i64]> = Some(&[7, 19971130, 1]);
    }
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod ber_DZ {
    pub mod LC_ADDRESS {
        /// `Some("DZA")`
        pub const COUNTRY_AB3: Option<&str> = Some("DZA");
        /// `Some("DZ")`
        pub const COUNTRY_ABTWO: Option<&str> = Some("DZ");
        /// `Some("DZ")`
        pub const COUNTRY_CAR: Option<&str> = Some("DZ");
        /// `None`
        pub const COUNTRY_ISBN: Option<&str> = None;
        /// `Some("Lezzayer")`
        pub const COUNTRY_NAME: Option<&str> = Some("Lezzayer");
        /// `Some(12)`
        pub const COUNTRY_NUM: Option<i64> = Some(12);
        /// `None`
        pub const COUNTRY_POST: Option<&str> = None;
        /// `None`
        pub const LANG_AB: Option<&str> = None;
        /// `Some("ber")`
        pub const LANG_LIB: Option<&str> = Some("ber");
        /// `Some("Tamaziɣt")`
        pub const LANG_NAME: Option<&str> = Some("Tamaziɣt");
        /// `Some("ber")`
        pub const LANG_TERM: Option<&str> = Some("ber");
        /// `Some("%z%c%T%s%b%e%r")`
        pub const POSTAL_FMT: Option<&str> = Some("%z%c%T%s%b%e%r");
    }
    pub mod LC_IDENTIFICATION {
        /// `None`
        pub const ABBREVIATION: Option<&str> = None;
        /// `Some("")`
        pub const ADDRESS: Option<&str> = Some("");
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        /// ]
        /// ```
        pub const CATEGORY: Option<&[&[&str]]> = Some(&[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_TELEPHONE"],
            &["i18n:2012", "LC_MEASUREMENT"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_MESSAGES"],
        ]);
        /// `Some("Pablo Saratxaga")`
        pub const CONTACT: Option<&str> = Some("Pablo Saratxaga");
        /// `Some("2002-04-16")`
        pub const DATE: Option<&str> = Some("2002-04-16");
        /// `Some("pablo@mandrakesoft.com")`
        pub const EMAIL: Option<&str> = Some("pablo@mandrakesoft.com");
        /// `Some("")`
        pub const FAX: Option<&str> = Some("");
        /// `Some("Berber")`
        pub const LANGUAGE: Option<&str> = Some("Berber");
        /// `Some("0.1")`
        pub const REVISION: Option<&str> = Some("0.1");
        /// `Some("")`
        pub const SOURCE: Option<&str> = Some("");
        /// `Some("")`
        pub const TEL: Option<&str> = Some("");
        /// `Some("Algeria")`
        pub const TERRITORY: Option<&str> = Some("Algeria");
        /// `Some("Berber language locale for Algeria (latin)")`
        pub const TITLE: Option<&str> = Some("Berber language locale for Algeria (latin)");
    }
    pub use super::kab_DZ::LC_MESSAGES;
    pub mod LC_MONETARY {
        /// `"د.ج."`
        pub const CURRENCY_SYMBOL: &str = "د.ج.";
        /// `3`
        pub const FRAC_DIGITS: i64 = 3;
        /// `"DZD "`
        pub const INT_CURR_SYMBOL: &str = "DZD ";
        /// `3`
        pub const INT_FRAC_DIGITS: i64 = 3;
        /// `None`
        pub const INT_N_CS_PRECEDES: Option<i64> = None;
        /// `None`
        pub const INT_N_SEP_BY_SPACE: Option<i64> = None;
        /// `None`
        pub const INT_N_SIGN_POSN: Option<i64> = None;
        /// `None`
        pub const INT_P_CS_PRECEDES: Option<i64> = None;
        /// `None`
        pub const INT_P_SEP_BY_SPACE: Option<i64> = None;
        /// `None`
        pub const INT_P_SIGN_POSN: Option<i64> = None;
        /// `"."`
        pub const MON_DECIMAL_POINT: &str = ".";
        /// `&[3]`
        pub const MON_GROUPING: &[i64] = &[3];
        /// `","`
        pub const MON_THOUSANDS_SEP: &str = ",";
        /// `"-"`
        pub const NEGATIVE_SIGN: &str = "-";
        /// `1`
        pub const N_CS_PRECEDES: i64 = 1;
        /// `1`
        pub const N_SEP_BY_SPACE: i64 = 1;
        /// `2`
        pub const N_SIGN_POSN: i64 = 2;
        /// `""`
        pub const POSITIVE_SIGN: &str = "";
        /// `1`
        pub const P_CS_PRECEDES: i64 = 1;
        /// `1`
        pub const P_SEP_BY_SPACE: i64 = 1;
        /// `1`
        pub const P_SIGN_POSN: i64 = 1;
    }
    pub mod LC_NUMERIC {
        /// `"."`
        pub const DECIMAL_POINT: &str = ".";
        /// `&[3]`
        pub const GROUPING: &[i64] = &[3];
        /// `","`
        pub const THOUSANDS_SEP: &str = ",";
    }
    pub mod LC_TELEPHONE {
        /// `Some("213")`
        pub const INT_PREFIX: Option<&str> = Some("213");
        /// `Some("00")`
        pub const INT_SELECT: Option<&str> = Some("00");
        /// `None`
        pub const TEL_DOM_FMT: Option<&str> = None;
        /// `Some("+%c ;%a ;%l")`
        pub const TEL_INT_FMT: Option<&str> = Some("+%c ;%a ;%l");
    }
    pub mod LC_TIME {
        /// `&["baz", "bir", "iki", "üçü", "dör", "beş", "alt"]`
        pub const ABDAY: &[&str] = &["baz", "bir", "iki", "üçü", "dör", "beş", "alt"];
        /// `&["Yan", "Fev", "Mar", "Apr", "May", "İyn", "İyl", "Avq", "Sen", "Okt", "Noy", "Dek"]`
        pub const ABMON: &[&str] = &["Yan", "Fev", "Mar", "Apr", "May", "İyn", "İyl", "Avq", "Sen", "Okt", "Noy", "Dek"];
        /// `None`
        pub const AB_ALT_MON: Option<&[&str]> = None;
        /// `None`
        pub const ALT_DIGITS: Option<&[&str]> = None;
        /// `None`
        pub const ALT_MON: Option<&[&str]> = None;
        /// `&["", ""]`
        pub const AM_PM: &[&str] = &["", ""];
        /// `None`
        pub const CAL_DIRECTION: Option<i64> = None;
        /// `None`
        pub const DATE_FMT: Option<&str> = None;
        /// `&["bazar günü", "birinci gün", "ikinci gün", "üçüncü gün", "dördüncü gün", "beşinci gün", "altıncı gün"]`
        pub const DAY: &[&str] = &["bazar günü", "birinci gün", "ikinci gün", "üçüncü gün", "dördüncü gün", "beşinci gün", "altıncı gün"];
        /// `"%d.%m.%Y"`
        pub const D_FMT: &str = "%d.%m.%Y";
        /// `"%A, %d %B %Y %T"`
        pub const D_T_FMT: &str = "%A, %d %B %Y %T";
        /// `None`
        pub const ERA: Option<&[&str]> = None;
        /// `None`
        pub const ERA_D_FMT: Option<&str> = None;
        /// `None`
        pub const ERA_D_T_FMT: Option<&str> = None;
        /// `None`
        pub const ERA_T_FMT: Option<&str> = None;
        /// `Some(7)`
        pub const FIRST_WEEKDAY: Option<i64> = Some(7);
        /// `Some(1)`
        pub const FIRST_WORKDAY: Option<i64> = Some(1);
        /// `&["yanvar", "fevral", "mart", "aprel", "may", "iyun", "iyul", "avqust", "sentyabr", "oktyabr", "noyabr", "dekabr"]`
        pub const MON: &[&str] = &["yanvar", "fevral", "mart", "aprel", "may", "iyun", "iyul", "avqust", "sentyabr", "oktyabr", "noyabr", "dekabr"];
        /// `"%T"`
        pub const T_FMT: &str = "%T";
        /// `""`
        pub const T_FMT_AMPM: &str = "";
        /// `Some(&[7, 19971130, 1])`
        pub const WEEK: Option<&[i64]> = Some(&[7, 19971130, 1]);
    }
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod ber_MA {
    pub mod LC_ADDRESS {
        /// `Some("MAR")`
        pub const COUNTRY_AB3: Option<&str> = Some("MAR");
        /// `Some("MA")`
        pub const COUNTRY_ABTWO: Option<&str> = Some("MA");
        /// `Some("MA")`
        pub const COUNTRY_CAR: Option<&str> = Some("MA");
        /// `None`
        pub const COUNTRY_ISBN: Option<&str> = None;
        /// `Some("ⵜⴰⴳⵍⴷⵉⵜ ⵏ ⵍⵎⵖⵔⵉⴱ")`
        pub const COUNTRY_NAME: Option<&str> = Some("ⵜⴰⴳⵍⴷⵉⵜ ⵏ ⵍⵎⵖⵔⵉⴱ");
        /// `Some(504)`
        pub const COUNTRY_NUM: Option<i64> = Some(504);
        /// `None`
        pub const COUNTRY_POST: Option<&str> = None;
        /// `None`
        pub const LANG_AB: Option<&str> = None;
        /// `Some("ber")`
        pub const LANG_LIB: Option<&str> = Some("ber");
        /// `Some("ⵜⴰⵎⴰⵣⵉⵖⵜ")`
        pub const LANG_NAME: Option<&str> = Some("ⵜⴰⵎⴰⵣⵉⵖⵜ");
        /// `Some("ber")`
        pub const LANG_TERM: Option<&str> = Some("ber");
        /// `Some("%z%c%T%s%b%e%r")`
        pub const POSTAL_FMT: Option<&str> = Some("%z%c%T%s%b%e%r");
    }
    pub mod LC_IDENTIFICATION {
        /// `None`
        pub const ABBREVIATION: Option<&str> = None;
        /// `Some("")`
        pub const ADDRESS: Option<&str> = Some("");
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        /// ]
        /// ```
        pub const CATEGORY: Option<&[&[&str]]> = Some(&[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_TELEPHONE"],
            &["i18n:2012", "LC_MEASUREMENT"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_MESSAGES"],
        ]);
        /// `Some("Pablo Saratxaga")`
        pub const CONTACT: Option<&str> = Some("Pablo Saratxaga");
        /// `Some("2002-06-26")`
        pub const DATE: Option<&str> = Some("2002-06-26");
        /// `Some("pablo@mandrakesoft.com")`
        pub const EMAIL: Option<&str> = Some("pablo@mandrakesoft.com");
        /// `Some("")`
        pub const FAX: Option<&str> = Some("");
        /// `Some("Berber")`
        pub const LANGUAGE: Option<&str> = Some("Berber");
        /// `Some("0.1")`
        pub const REVISION: Option<&str> = Some("0.1");
        /// `Some("")`
        pub const SOURCE: Option<&str> = Some("");
        /// `Some("")`
        pub const TEL: Option<&str> = Some("");
        /// `Some("Morocco")`
        pub const TERRITORY: Option<&str> = Some("Morocco");
        /// `Some("Berber language locale for Morocco (tifinagh)")`
        pub const TITLE: Option<&str> = Some("Berber language locale for Morocco (tifinagh)");
    }
    pub mod LC_MESSAGES {
        /// `"^[-0YyNn]"`
        pub const NOEXPR: &str = "^[-0YyNn]";
        /// `Some("yox")`
        pub const NOSTR: Option<&str> = Some("yox");
        /// `"^[+1Bb]"`
        pub const YESEXPR: &str = "^[+1Bb]";
        /// `Some("bəli")`
        pub const YESSTR: Option<&str> = Some("bəli");
    }
    pub mod LC_MONETARY {
        /// `"ⴷ.ⵎ."`
        pub const CURRENCY_SYMBOL: &str = "ⴷ.ⵎ.";
        /// `3`
        pub const FRAC_DIGITS: i64 = 3;
        /// `"MAD "`
        pub const INT_CURR_SYMBOL: &str = "MAD ";
        /// `3`
        pub const INT_FRAC_DIGITS: i64 = 3;
        /// `None`
        pub const INT_N_CS_PRECEDES: Option<i64> = None;
        /// `None`
        pub const INT_N_SEP_BY_SPACE: Option<i64> = None;
        /// `None`
        pub const INT_N_SIGN_POSN: Option<i64> = None;
        /// `None`
        pub const INT_P_CS_PRECEDES: Option<i64> = None;
        /// `None`
        pub const INT_P_SEP_BY_SPACE: Option<i64> = None;
        /// `None`
        pub const INT_P_SIGN_POSN: Option<i64> = None;
        /// `"."`
        pub const MON_DECIMAL_POINT: &str = ".";
        /// `&[3]`
        pub const MON_GROUPING: &[i64] = &[3];
        /// `","`
        pub const MON_THOUSANDS_SEP: &str = ",";
        /// `"-"`
        pub const NEGATIVE_SIGN: &str = "-";
        /// `1`
        pub const N_CS_PRECEDES: i64 = 1;
        /// `1`
        pub const N_SEP_BY_SPACE: i64 = 1;
        /// `2`
        pub const N_SIGN_POSN: i64 = 2;
        /// `""`
        pub const POSITIVE_SIGN: &str = "";
        /// `1`
        pub const P_CS_PRECEDES: i64 = 1;
        /// `1`
        pub const P_SEP_BY_SPACE: i64 = 1;
        /// `1`
        pub const P_SIGN_POSN: i64 = 1;
    }
    pub mod LC_NUMERIC {
        /// `"."`
        pub const DECIMAL_POINT: &str = ".";
        /// `&[3]`
        pub const GROUPING: &[i64] = &[3];
        /// `","`
        pub const THOUSANDS_SEP: &str = ",";
    }
    pub mod LC_TELEPHONE {
        /// `Some("212")`
        pub const INT_PREFIX: Option<&str> = Some("212");
        /// `Some("00")`
        pub const INT_SELECT: Option<&str> = Some("00");
        /// `None`
        pub const TEL_DOM_FMT: Option<&str> = None;
        /// `Some("+%c ;%a ;%l")`
        pub const TEL_INT_FMT: Option<&str> = Some("+%c ;%a ;%l");
    }
    pub mod LC_TIME {
        /// `&["baz", "bir", "iki", "üçü", "dör", "beş", "alt"]`
        pub const ABDAY: &[&str] = &["baz", "bir", "iki", "üçü", "dör", "beş", "alt"];
        /// `&["Yan", "Fev", "Mar", "Apr", "May", "İyn", "İyl", "Avq", "Sen", "Okt", "Noy", "Dek"]`
        pub const ABMON: &[&str] = &["Yan", "Fev", "Mar", "Apr", "May", "İyn", "İyl", "Avq", "Sen", "Okt", "Noy", "Dek"];
        /// `None`
        pub const AB_ALT_MON: Option<&[&str]> = None;
        /// `None`
        pub const ALT_DIGITS: Option<&[&str]> = None;
        /// `None`
        pub const ALT_MON: Option<&[&str]> = None;
        /// `&["", ""]`
        pub const AM_PM: &[&str] = &["", ""];
        /// `None`
        pub const CAL_DIRECTION: Option<i64> = None;
        /// `None`
        pub const DATE_FMT: Option<&str> = None;
        /// `&["bazar günü", "birinci gün", "ikinci gün", "üçüncü gün", "dördüncü gün", "beşinci gün", "altıncı gün"]`
        pub const DAY: &[&str] = &["bazar günü", "birinci gün", "ikinci gün", "üçüncü gün", "dördüncü gün", "beşinci gün", "altıncı gün"];
        /// `"%d.%m.%Y"`
        pub const D_FMT: &str = "%d.%m.%Y";
        /// `"%A, %d %B %Y %T"`
        pub const D_T_FMT: &str = "%A, %d %B %Y %T";
        /// `None`
        pub const ERA: Option<&[&str]> = None;
        /// `None`
        pub const ERA_D_FMT: Option<&str> = None;
        /// `None`
        pub const ERA_D_T_FMT: Option<&str> = None;
        /// `None`
        pub const ERA_T_FMT: Option<&str> = None;
        /// `Some(7)`
        pub const FIRST_WEEKDAY: Option<i64> = Some(7);
        /// `Some(1)`
        pub const FIRST_WORKDAY: Option<i64> = Some(1);
        /// `&["yanvar", "fevral", "mart", "aprel", "may", "iyun", "iyul", "avqust", "sentyabr", "oktyabr", "noyabr", "dekabr"]`
        pub const MON: &[&str] = &["yanvar", "fevral", "mart", "aprel", "may", "iyun", "iyul", "avqust", "sentyabr", "oktyabr", "noyabr", "dekabr"];
        /// `"%T"`
        pub const T_FMT: &str = "%T";
        /// `""`
        pub const T_FMT_AMPM: &str = "";
        /// `Some(&[7, 19971130, 1])`
        pub const WEEK: Option<&[i64]> = Some(&[7, 19971130, 1]);
    }
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod bg_BG {
    pub mod LC_ADDRESS {
        /// `Some("BGR")`
        pub const COUNTRY_AB3: Option<&str> = Some("BGR");
        /// `Some("BG")`
        pub const COUNTRY_ABTWO: Option<&str> = Some("BG");
        /// `Some("BG")`
        pub const COUNTRY_CAR: Option<&str> = Some("BG");
        /// `Some("954")`
        pub const COUNTRY_ISBN: Option<&str> = Some("954");
        /// `Some("България")`
        pub const COUNTRY_NAME: Option<&str> = Some("България");
        /// `Some(100)`
        pub const COUNTRY_NUM: Option<i64> = Some(100);
        /// `Some("BG")`
        pub const COUNTRY_POST: Option<&str> = Some("BG");
        /// `Some("bg")`
        pub const LANG_AB: Option<&str> = Some("bg");
        /// `Some("bul")`
        pub const LANG_LIB: Option<&str> = Some("bul");
        /// `Some("български")`
        pub const LANG_NAME: Option<&str> = Some("български");
        /// `Some("bul")`
        pub const LANG_TERM: Option<&str> = Some("bul");
        /// `Some("%f%N%a%N%d%N%b%N%sN%h, %e, %r%N%z %T%N%c%N")`
        pub const POSTAL_FMT: Option<&str> = Some("%f%N%a%N%d%N%b%N%sN%h, %e, %r%N%z %T%N%c%N");
    }
    pub mod LC_IDENTIFICATION {
        /// `None`
        pub const ABBREVIATION: Option<&str> = None;
        /// `Some("develop@linux.zonebg.com")`
        pub const ADDRESS: Option<&str> = Some("develop@linux.zonebg.com");
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        /// ]
        /// ```
        pub const CATEGORY: Option<&[&[&str]]> = Some(&[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_TELEPHONE"],
            &["i18n:2012", "LC_MEASUREMENT"],
        ]);
        /// `Some("Delyan Toshev")`
        pub const CONTACT: Option<&str> = Some("Delyan Toshev");
        /// `Some("2002-09-10")`
        pub const DATE: Option<&str> = Some("2002-09-10");
        /// `Some("delyant@yahoo.com")`
        pub const EMAIL: Option<&str> = Some("delyant@yahoo.com");
        /// `Some("")`
        pub const FAX: Option<&str> = Some("");
        /// `Some("Bulgarian")`
        pub const LANGUAGE: Option<&str> = Some("Bulgarian");
        /// `Some("2.0.1")`
        pub const REVISION: Option<&str> = Some("2.0.1");
        /// `Some("Linux Society Bulgaria")`
        pub const SOURCE: Option<&str> = Some("Linux Society Bulgaria");
        /// `Some("")`
        pub const TEL: Option<&str> = Some("");
        /// `Some("Bulgaria")`
        pub const TERRITORY: Option<&str> = Some("Bulgaria");
        /// `Some("Bulgarian locale for Bulgaria")`
        pub const TITLE: Option<&str> = Some("Bulgarian locale for Bulgaria");
    }
    pub mod LC_MESSAGES {
        /// `"^[-0nNkKНн]"`
        pub const NOEXPR: &str = "^[-0nNkKНн]";
        /// `Some("не")`
        pub const NOSTR: Option<&str> = Some("не");
        /// `"^[+1yYdDoOДд]"`
        pub const YESEXPR: &str = "^[+1yYdDoOДд]";
        /// `Some("да")`
        pub const YESSTR: Option<&str> = Some("да");
    }
    pub mod LC_MONETARY {
        /// `"лв."`
        pub const CURRENCY_SYMBOL: &str = "лв.";
        /// `2`
        pub const FRAC_DIGITS: i64 = 2;
        /// `"BGN "`
        pub const INT_CURR_SYMBOL: &str = "BGN ";
        /// `2`
        pub const INT_FRAC_DIGITS: i64 = 2;
        /// `None`
        pub const INT_N_CS_PRECEDES: Option<i64> = None;
        /// `None`
        pub const INT_N_SEP_BY_SPACE: Option<i64> = None;
        /// `None`
        pub const INT_N_SIGN_POSN: Option<i64> = None;
        /// `None`
        pub const INT_P_CS_PRECEDES: Option<i64> = None;
        /// `None`
        pub const INT_P_SEP_BY_SPACE: Option<i64> = None;
        /// `None`
        pub const INT_P_SIGN_POSN: Option<i64> = None;
        /// `","`
        pub const MON_DECIMAL_POINT: &str = ",";
        /// `&[3, 3]`
        pub const MON_GROUPING: &[i64] = &[3, 3];
        /// `"\u{202f}"`
        pub const MON_THOUSANDS_SEP: &str = "\u{202f}";
        /// `"-"`
        pub const NEGATIVE_SIGN: &str = "-";
        /// `0`
        pub const N_CS_PRECEDES: i64 = 0;
        /// `1`
        pub const N_SEP_BY_SPACE: i64 = 1;
        /// `1`
        pub const N_SIGN_POSN: i64 = 1;
        /// `""`
        pub const POSITIVE_SIGN: &str = "";
        /// `0`
        pub const P_CS_PRECEDES: i64 = 0;
        /// `1`
        pub const P_SEP_BY_SPACE: i64 = 1;
        /// `1`
        pub const P_SIGN_POSN: i64 = 1;
    }
    pub mod LC_NUMERIC {
        /// `","`
        pub const DECIMAL_POINT: &str = ",";
        /// `&[3, 3]`
        pub const GROUPING: &[i64] = &[3, 3];
        /// `""`
        pub const THOUSANDS_SEP: &str = "";
    }
    pub mod LC_TELEPHONE {
        /// `Some("359")`
        pub const INT_PREFIX: Option<&str> = Some("359");
        /// `Some("00")`
        pub const INT_SELECT: Option<&str> = Some("00");
        /// `Some("(0%a) %l")`
        pub const TEL_DOM_FMT: Option<&str> = Some("(0%a) %l");
        /// `Some("(+%c %a) %l")`
        pub const TEL_INT_FMT: Option<&str> = Some("(+%c %a) %l");
    }
    pub mod LC_TIME {
        /// `&["нд", "пн", "вт", "ср", "чт", "пт", "сб"]`
        pub const ABDAY: &[&str] = &["нд", "пн", "вт", "ср", "чт", "пт", "сб"];
        /// `&["яну", "фев", "мар", "апр", "май", "юни", "юли", "авг", "сеп", "окт", "ное", "дек"]`
        pub const ABMON: &[&str] = &["яну", "фев", "мар", "апр", "май", "юни", "юли", "авг", "сеп", "окт", "ное", "дек"];
        /// `None`
        pub const AB_ALT_MON: Option<&[&str]> = None;
        /// `None`
        pub const ALT_DIGITS: Option<&[&str]> = None;
        /// `None`
        pub const ALT_MON: Option<&[&str]> = None;
        /// `&["", ""]`
        pub const AM_PM: &[&str] = &["", ""];
        /// `None`
        pub const CAL_DIRECTION: Option<i64> = None;
        /// `None`
        pub const DATE_FMT: Option<&str> = None;
        /// `&["неделя", "понеделник", "вторник", "сряда", "четвъртък", "петък", "събота"]`
        pub const DAY: &[&str] = &["неделя", "понеделник", "вторник", "сряда", "четвъртък", "петък", "събота"];
        /// `"%e.%m.%Y"`
        pub const D_FMT: &str = "%e.%m.%Y";
        /// `"%e.%m.%Y (%a) %k:%M:%S %Z"`
        pub const D_T_FMT: &str = "%e.%m.%Y (%a) %k:%M:%S %Z";
        /// `None`
        pub const ERA: Option<&[&str]> = None;
        /// `None`
        pub const ERA_D_FMT: Option<&str> = None;
        /// `None`
        pub const ERA_D_T_FMT: Option<&str> = None;
        /// `None`
        pub const ERA_T_FMT: Option<&str> = None;
        /// `Some(2)`
        pub const FIRST_WEEKDAY: Option<i64> = Some(2);
        /// `None`
        pub const FIRST_WORKDAY: Option<i64> = None;
        /// `&["януари", "февруари", "март", "април", "май", "юни", "юли", "август", "септември", "октомври", "ноември", "декември"]`
        pub const MON: &[&str] = &["януари", "февруари", "март", "април", "май", "юни", "юли", "август", "септември", "октомври", "ноември", "декември"];
        /// `"%k:%M:%S"`
        pub const T_FMT: &str = "%k:%M:%S";
        /// `""`
        pub const T_FMT_AMPM: &str = "";
        /// `Some(&[7, 19971130, 4])`
        pub const WEEK: Option<&[i64]> = Some(&[7, 19971130, 4]);
    }
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod bhb_IN {
    pub mod LC_ADDRESS {
        /// `Some("IND")`
        pub const COUNTRY_AB3: Option<&str> = Some("IND");
        /// `Some("IN")`
        pub const COUNTRY_ABTWO: Option<&str> = Some("IN");
        /// `Some("IND")`
        pub const COUNTRY_CAR: Option<&str> = Some("IND");
        /// `None`
        pub const COUNTRY_ISBN: Option<&str> = None;
        /// `Some("भारत")`
        pub const COUNTRY_NAME: Option<&str> = Some("भारत");
        /// `Some(356)`
        pub const COUNTRY_NUM: Option<i64> = Some(356);
        /// `None`
        pub const COUNTRY_POST: Option<&str> = None;
        /// `Some("")`
        pub const LANG_AB: Option<&str> = Some("");
        /// `Some("bhb")`
        pub const LANG_LIB: Option<&str> = Some("bhb");
        /// `Some("भीली")`
        pub const LANG_NAME: Option<&str> = Some("भीली");
        /// `Some("bhb")`
        pub const LANG_TERM: Option<&str> = Some("bhb");
        /// `Some("%z%c%T%s%b%e%r")`
        pub const POSTAL_FMT: Option<&str> = Some("%z%c%T%s%b%e%r");
    }
    pub mod LC_IDENTIFICATION {
        /// `None`
        pub const ABBREVIATION: Option<&str> = None;
        /// `Some("")`
        pub const ADDRESS: Option<&str> = Some("");
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        /// ]
        /// ```
        pub const CATEGORY: Option<&[&[&str]]> = Some(&[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_TELEPHONE"],
            &["i18n:2012", "LC_MEASUREMENT"],
        ]);
        /// `Some("")`
        pub const CONTACT: Option<&str> = Some("");
        /// `Some("2014-09-30")`
        pub const DATE: Option<&str> = Some("2014-09-30");
        /// `Some("alexey.merzlyakov@samsung.com")`
        pub const EMAIL: Option<&str> = Some("alexey.merzlyakov@samsung.com");
        /// `Some("")`
        pub const FAX: Option<&str> = Some("");
        /// `Some("Bhili")`
        pub const LANGUAGE: Option<&str> = Some("Bhili");
        /// `Some("0.1")`
        pub const REVISION: Option<&str> = Some("0.1");
        /// `Some("Samsung Electronics Co., Ltd.")`
        pub const SOURCE: Option<&str> = Some("Samsung Electronics Co., Ltd.");
        /// `Some("")`
        pub const TEL: Option<&str> = Some("");
        /// `Some("India")`
        pub const TERRITORY: Option<&str> = Some("India");
        /// `Some("Bhili(devanagari) language locale for India")`
        pub const TITLE: Option<&str> = Some("Bhili(devanagari) language locale for India");
    }
    pub mod LC_MESSAGES {
        /// `"^[-0nN]"`
        pub const NOEXPR: &str = "^[-0nN]";
        /// `None`
        pub const NOSTR: Option<&str> = None;
        /// `"^[+1yY]"`
        pub const YESEXPR: &str = "^[+1yY]";
        /// `None`
        pub const YESSTR: Option<&str> = None;
    }
    pub use super::hi_IN::LC_MONETARY;
    pub use super::hi_IN::LC_NUMERIC;
    pub use super::hi_IN::LC_TELEPHONE;
    pub mod LC_TIME {
        /// `&["Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"]`
        pub const ABDAY: &[&str] = &["Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"];
        /// `&["Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"]`
        pub const ABMON: &[&str] = &["Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"];
        /// `None`
        pub const AB_ALT_MON: Option<&[&str]> = None;
        /// `None`
        pub const ALT_DIGITS: Option<&[&str]> = None;
        /// `None`
        pub const ALT_MON: Option<&[&str]> = None;
        /// `&["AM", "PM"]`
        pub const AM_PM: &[&str] = &["AM", "PM"];
        /// `None`
        pub const CAL_DIRECTION: Option<i64> = None;
        /// `None`
        pub const DATE_FMT: Option<&str> = None;
        /// `&["Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"]`
        pub const DAY: &[&str] = &["Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"];
        /// `"%-d/%-m/%y"`
        pub const D_FMT: &str = "%-d/%-m/%y";
        /// `"%A %d %b %Y %I:%M:%S %p %Z"`
        pub const D_T_FMT: &str = "%A %d %b %Y %I:%M:%S %p %Z";
        /// `None`
        pub const ERA: Option<&[&str]> = None;
        /// `None`
        pub const ERA_D_FMT: Option<&str> = None;
        /// `None`
        pub const ERA_D_T_FMT: Option<&str> = None;
        /// `None`
        pub const ERA_T_FMT: Option<&str> = None;
        /// `None`
        pub const FIRST_WEEKDAY: Option<i64> = None;
        /// `None`
        pub const FIRST_WORKDAY: Option<i64> = None;
        /// `&["January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"]`
        pub const MON: &[&str] = &["January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"];
        /// `"%I:%M:%S %p %Z"`
        pub const T_FMT: &str = "%I:%M:%S %p %Z";
        /// `"%I:%M:%S %p %Z"`
        pub const T_FMT_AMPM: &str = "%I:%M:%S %p %Z";
        /// `Some(&[7, 19971130, 1])`
        pub const WEEK: Option<&[i64]> = Some(&[7, 19971130, 1]);
    }
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod bho_IN {
    pub mod LC_ADDRESS {
        /// `Some("IND")`
        pub const COUNTRY_AB3: Option<&str> = Some("IND");
        /// `Some("IN")`
        pub const COUNTRY_ABTWO: Option<&str> = Some("IN");
        /// `Some("IND")`
        pub const COUNTRY_CAR: Option<&str> = Some("IND");
        /// `None`
        pub const COUNTRY_ISBN: Option<&str> = None;
        /// `Some("भारत")`
        pub const COUNTRY_NAME: Option<&str> = Some("भारत");
        /// `Some(356)`
        pub const COUNTRY_NUM: Option<i64> = Some(356);
        /// `None`
        pub const COUNTRY_POST: Option<&str> = None;
        /// `None`
        pub const LANG_AB: Option<&str> = None;
        /// `Some("bho")`
        pub const LANG_LIB: Option<&str> = Some("bho");
        /// `Some("भोजप\u{941}री")`
        pub const LANG_NAME: Option<&str> = Some("भोजप\u{941}री");
        /// `Some("bho")`
        pub const LANG_TERM: Option<&str> = Some("bho");
        /// `Some("%z%c%T%s%b%e%r")`
        pub const POSTAL_FMT: Option<&str> = Some("%z%c%T%s%b%e%r");
    }
    pub mod LC_IDENTIFICATION {
        /// `None`
        pub const ABBREVIATION: Option<&str> = None;
        /// `Some("")`
        pub const ADDRESS: Option<&str> = Some("");
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        /// ]
        /// ```
        pub const CATEGORY: Option<&[&[&str]]> = Some(&[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_TELEPHONE"],
            &["i18n:2012", "LC_MEASUREMENT"],
        ]);
        /// `Some("")`
        pub const CONTACT: Option<&str> = Some("");
        /// `Some("2011-12-20")`
        pub const DATE: Option<&str> = Some("2011-12-20");
        /// `Some("bhashaghar@googlegroups.com")`
        pub const EMAIL: Option<&str> = Some("bhashaghar@googlegroups.com");
        /// `Some("")`
        pub const FAX: Option<&str> = Some("");
        /// `Some("Bhojpuri")`
        pub const LANGUAGE: Option<&str> = Some("Bhojpuri");
        /// `Some("0.1")`
        pub const REVISION: Option<&str> = Some("0.1");
        /// `Some("")`
        pub const SOURCE: Option<&str> = Some("");
        /// `Some("")`
        pub const TEL: Option<&str> = Some("");
        /// `Some("India")`
        pub const TERRITORY: Option<&str> = Some("India");
        /// `Some("Bhojpuri language locale for India")`
        pub const TITLE: Option<&str> = Some("Bhojpuri language locale for India");
    }
    pub use super::hi_IN::LC_MESSAGES;
    pub use super::hi_IN::LC_MONETARY;
    pub use super::hi_IN::LC_NUMERIC;
    pub use super::hi_IN::LC_TELEPHONE;
    pub mod LC_TIME {
        /// `&["रवि", "सोम", "म\u{902}गल", "ब\u{941}ध", "ग\u{941}र\u{941}", "श\u{941}क\u{94d}र", "शनि"]`
        pub const ABDAY: &[&str] = &["रवि", "सोम", "म\u{902}गल", "ब\u{941}ध", "ग\u{941}र\u{941}", "श\u{941}क\u{94d}र", "शनि"];
        /// `&["जनवरी", "फरवरी", "मार\u{94d}च", "अप\u{94d}र\u{948}ल", "मई", "ज\u{942}न", "ज\u{941}लाई", "अगस\u{94d}त", "सितम\u{94d}बर", "अक\u{94d}ट\u{942}बर", "नवम\u{94d}बर", "दिसम\u{94d}बर"]`
        pub const ABMON: &[&str] = &["जनवरी", "फरवरी", "मार\u{94d}च", "अप\u{94d}र\u{948}ल", "मई", "ज\u{942}न", "ज\u{941}लाई", "अगस\u{94d}त", "सितम\u{94d}बर", "अक\u{94d}ट\u{942}बर", "नवम\u{94d}बर", "दिसम\u{94d}बर"];
        /// `None`
        pub const AB_ALT_MON: Option<&[&str]> = None;
        /// `None`
        pub const ALT_DIGITS: Option<&[&str]> = None;
        /// `None`
        pub const ALT_MON: Option<&[&str]> = None;
        /// `&["प\u{942}र\u{94d}वाह\u{94d}न", "अपराह\u{94d}न"]`
        pub const AM_PM: &[&str] = &["प\u{942}र\u{94d}वाह\u{94d}न", "अपराह\u{94d}न"];
        /// `None`
        pub const CAL_DIRECTION: Option<i64> = None;
        /// `None`
        pub const DATE_FMT: Option<&str> = None;
        /// `&["रविवार", "सोमवार", "म\u{902}गलवार", "ब\u{941}धवार", "ग\u{941}र\u{941}वार", "श\u{941}क\u{94d}रवार", "शनिवार"]`
        pub const DAY: &[&str] = &["रविवार", "सोमवार", "म\u{902}गलवार", "ब\u{941}धवार", "ग\u{941}र\u{941}वार", "श\u{941}क\u{94d}रवार", "शनिवार"];
        /// `"%-d/%-m/%y"`
        pub const D_FMT: &str = "%-d/%-m/%y";
        /// `"%A %d %b %Y %I:%M:%S %p %Z"`
        pub const D_T_FMT: &str = "%A %d %b %Y %I:%M:%S %p %Z";
        /// `None`
        pub const ERA: Option<&[&str]> = None;
        /// `None`
        pub const ERA_D_FMT: Option<&str> = None;
        /// `None`
        pub const ERA_D_T_FMT: Option<&str> = None;
        /// `None`
        pub const ERA_T_FMT: Option<&str> = None;
        /// `None`
        pub const FIRST_WEEKDAY: Option<i64> = None;
        /// `None`
        pub const FIRST_WORKDAY: Option<i64> = None;
        /// `&["जनवरी", "फरवरी", "मार\u{94d}च", "अप\u{94d}र\u{948}ल", "मई", "ज\u{942}न", "ज\u{941}लाई", "अगस\u{94d}त", "सितम\u{94d}बर", "अक\u{94d}ट\u{942}बर", "नवम\u{94d}बर", "दिसम\u{94d}बर"]`
        pub const MON: &[&str] = &["जनवरी", "फरवरी", "मार\u{94d}च", "अप\u{94d}र\u{948}ल", "मई", "ज\u{942}न", "ज\u{941}लाई", "अगस\u{94d}त", "सितम\u{94d}बर", "अक\u{94d}ट\u{942}बर", "नवम\u{94d}बर", "दिसम\u{94d}बर"];
        /// `"%I:%M:%S %p %Z"`
        pub const T_FMT: &str = "%I:%M:%S %p %Z";
        /// `"%I:%M:%S %p %Z"`
        pub const T_FMT_AMPM: &str = "%I:%M:%S %p %Z";
        /// `Some(&[7, 19971130, 1])`
        pub const WEEK: Option<&[i64]> = Some(&[7, 19971130, 1]);
    }
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod bho_NP {
    pub mod LC_ADDRESS {
        /// `Some("NPL")`
        pub const COUNTRY_AB3: Option<&str> = Some("NPL");
        /// `Some("NP")`
        pub const COUNTRY_ABTWO: Option<&str> = Some("NP");
        /// `Some("NEP")`
        pub const COUNTRY_CAR: Option<&str> = Some("NEP");
        /// `None`
        pub const COUNTRY_ISBN: Option<&str> = None;
        /// `Some("न\u{947}पाल")`
        pub const COUNTRY_NAME: Option<&str> = Some("न\u{947}पाल");
        /// `Some(524)`
        pub const COUNTRY_NUM: Option<i64> = Some(524);
        /// `None`
        pub const COUNTRY_POST: Option<&str> = None;
        /// `None`
        pub const LANG_AB: Option<&str> = None;
        /// `Some("bho")`
        pub const LANG_LIB: Option<&str> = Some("bho");
        /// `Some("भोजप\u{941}री")`
        pub const LANG_NAME: Option<&str> = Some("भोजप\u{941}री");
        /// `Some("bho")`
        pub const LANG_TERM: Option<&str> = Some("bho");
        /// `Some("%f%N%h%s%N%T")`
        pub const POSTAL_FMT: Option<&str> = Some("%f%N%h%s%N%T");
    }
    pub mod LC_IDENTIFICATION {
        /// `None`
        pub const ABBREVIATION: Option<&str> = None;
        /// `Some("")`
        pub const ADDRESS: Option<&str> = Some("");
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        /// ]
        /// ```
        pub const CATEGORY: Option<&[&[&str]]> = Some(&[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_TELEPHONE"],
            &["i18n:2012", "LC_MEASUREMENT"],
        ]);
        /// `Some("")`
        pub const CONTACT: Option<&str> = Some("");
        /// `Some("2017-07-24")`
        pub const DATE: Option<&str> = Some("2017-07-24");
        /// `Some("akhilesh.k@samusng.com")`
        pub const EMAIL: Option<&str> = Some("akhilesh.k@samusng.com");
        /// `Some("")`
        pub const FAX: Option<&str> = Some("");
        /// `Some("Bhojpuri")`
        pub const LANGUAGE: Option<&str> = Some("Bhojpuri");
        /// `Some("0.1")`
        pub const REVISION: Option<&str> = Some("0.1");
        /// `Some("Samsung Electronics Co., Ltd.")`
        pub const SOURCE: Option<&str> = Some("Samsung Electronics Co., Ltd.");
        /// `Some("")`
        pub const TEL: Option<&str> = Some("");
        /// `Some("Nepal")`
        pub const TERRITORY: Option<&str> = Some("Nepal");
        /// `Some("Bhojpuri language locale for Nepal")`
        pub const TITLE: Option<&str> = Some("Bhojpuri language locale for Nepal");
    }
    pub use super::bho_IN::LC_MESSAGES;
    pub use super::ne_NP::LC_MONETARY;
    pub use super::ne_NP::LC_NUMERIC;
    pub use super::ne_NP::LC_TELEPHONE;
    pub use super::bho_IN::LC_TIME;
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod bi_VU {
    pub mod LC_ADDRESS {
        /// `Some("VUT")`
        pub const COUNTRY_AB3: Option<&str> = Some("VUT");
        /// `Some("VU")`
        pub const COUNTRY_ABTWO: Option<&str> = Some("VU");
        /// `Some("VU")`
        pub const COUNTRY_CAR: Option<&str> = Some("VU");
        /// `None`
        pub const COUNTRY_ISBN: Option<&str> = None;
        /// `Some("Vanuatu")`
        pub const COUNTRY_NAME: Option<&str> = Some("Vanuatu");
        /// `Some(548)`
        pub const COUNTRY_NUM: Option<i64> = Some(548);
        /// `None`
        pub const COUNTRY_POST: Option<&str> = None;
        /// `Some("bi")`
        pub const LANG_AB: Option<&str> = Some("bi");
        /// `Some("bis")`
        pub const LANG_LIB: Option<&str> = Some("bis");
        /// `Some("Bislama")`
        pub const LANG_NAME: Option<&str> = Some("Bislama");
        /// `Some("bis")`
        pub const LANG_TERM: Option<&str> = Some("bis");
        /// `Some("%a%b%s%c")`
        pub const POSTAL_FMT: Option<&str> = Some("%a%b%s%c");
    }
    pub mod LC_IDENTIFICATION {
        /// `None`
        pub const ABBREVIATION: Option<&str> = None;
        /// `Some("")`
        pub const ADDRESS: Option<&str> = Some("");
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        /// ]
        /// ```
        pub const CATEGORY: Option<&[&[&str]]> = Some(&[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_MEASUREMENT"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_TELEPHONE"],
        ]);
        /// `Some("")`
        pub const CONTACT: Option<&str> = Some("");
        /// `Some("2017-07-13")`
        pub const DATE: Option<&str> = Some("2017-07-13");
        /// `Some("akhilesh.k@samsung.com & maninder1.s@samsung.com")`
        pub const EMAIL: Option<&str> = Some("akhilesh.k@samsung.com & maninder1.s@samsung.com");
        /// `Some("")`
        pub const FAX: Option<&str> = Some("");
        /// `Some("Bislama")`
        pub const LANGUAGE: Option<&str> = Some("Bislama");
        /// `Some("0.1")`
        pub const REVISION: Option<&str> = Some("0.1");
        /// `Some("Samsung Electronics Co., Ltd.")`
        pub const SOURCE: Option<&str> = Some("Samsung Electronics Co., Ltd.");
        /// `Some("")`
        pub const TEL: Option<&str> = Some("");
        /// `Some("Vanuatu")`
        pub const TERRITORY: Option<&str> = Some("Vanuatu");
        /// `Some("Bislama language locale for Vanuatu")`
        pub const TITLE: Option<&str> = Some("Bislama language locale for Vanuatu");
    }
    pub mod LC_MESSAGES {
        /// `"^[-0nN]"`
        pub const NOEXPR: &str = "^[-0nN]";
        /// `Some("No")`
        pub const NOSTR: Option<&str> = Some("No");
        /// `"^[+1yY]"`
        pub const YESEXPR: &str = "^[+1yY]";
        /// `Some("Yes")`
        pub const YESSTR: Option<&str> = Some("Yes");
    }
    pub mod LC_MONETARY {
        /// `"VT"`
        pub const CURRENCY_SYMBOL: &str = "VT";
        /// `2`
        pub const FRAC_DIGITS: i64 = 2;
        /// `"VUV "`
        pub const INT_CURR_SYMBOL: &str = "VUV ";
        /// `2`
        pub const INT_FRAC_DIGITS: i64 = 2;
        /// `None`
        pub const INT_N_CS_PRECEDES: Option<i64> = None;
        /// `Some(1)`
        pub const INT_N_SEP_BY_SPACE: Option<i64> = Some(1);
        /// `None`
        pub const INT_N_SIGN_POSN: Option<i64> = None;
        /// `None`
        pub const INT_P_CS_PRECEDES: Option<i64> = None;
        /// `Some(1)`
        pub const INT_P_SEP_BY_SPACE: Option<i64> = Some(1);
        /// `None`
        pub const INT_P_SIGN_POSN: Option<i64> = None;
        /// `"."`
        pub const MON_DECIMAL_POINT: &str = ".";
        /// `&[3]`
        pub const MON_GROUPING: &[i64] = &[3];
        /// `","`
        pub const MON_THOUSANDS_SEP: &str = ",";
        /// `"-"`
        pub const NEGATIVE_SIGN: &str = "-";
        /// `1`
        pub const N_CS_PRECEDES: i64 = 1;
        /// `0`
        pub const N_SEP_BY_SPACE: i64 = 0;
        /// `1`
        pub const N_SIGN_POSN: i64 = 1;
        /// `""`
        pub const POSITIVE_SIGN: &str = "";
        /// `1`
        pub const P_CS_PRECEDES: i64 = 1;
        /// `0`
        pub const P_SEP_BY_SPACE: i64 = 0;
        /// `1`
        pub const P_SIGN_POSN: i64 = 1;
    }
    pub mod LC_NUMERIC {
        /// `"."`
        pub const DECIMAL_POINT: &str = ".";
        /// `&[3]`
        pub const GROUPING: &[i64] = &[3];
        /// `","`
        pub const THOUSANDS_SEP: &str = ",";
    }
    pub mod LC_TELEPHONE {
        /// `Some("678")`
        pub const INT_PREFIX: Option<&str> = Some("678");
        /// `Some("00")`
        pub const INT_SELECT: Option<&str> = Some("00");
        /// `None`
        pub const TEL_DOM_FMT: Option<&str> = None;
        /// `Some("+%c %l")`
        pub const TEL_INT_FMT: Option<&str> = Some("+%c %l");
    }
    pub mod LC_TIME {
        /// `&["San", "Man", "Tus", "Wen", "Tas", "Fra", "Sar"]`
        pub const ABDAY: &[&str] = &["San", "Man", "Tus", "Wen", "Tas", "Fra", "Sar"];
        /// `&["Jan", "Feb", "Maj", "Epr", "Mei", "Jun", "Jul", "Ogs", "Sep", "Okt", "Nov", "Dis"]`
        pub const ABMON: &[&str] = &["Jan", "Feb", "Maj", "Epr", "Mei", "Jun", "Jul", "Ogs", "Sep", "Okt", "Nov", "Dis"];
        /// `None`
        pub const AB_ALT_MON: Option<&[&str]> = None;
        /// `None`
        pub const ALT_DIGITS: Option<&[&str]> = None;
        /// `None`
        pub const ALT_MON: Option<&[&str]> = None;
        /// `&["AM", "PM"]`
        pub const AM_PM: &[&str] = &["AM", "PM"];
        /// `None`
        pub const CAL_DIRECTION: Option<i64> = None;
        /// `None`
        pub const DATE_FMT: Option<&str> = None;
        /// `&["Sande", "Mande", "Tusde", "Wenesde", "Tosde", "Fraede", "Sarere"]`
        pub const DAY: &[&str] = &["Sande", "Mande", "Tusde", "Wenesde", "Tosde", "Fraede", "Sarere"];
        /// `"%A %d %b %Y"`
        pub const D_FMT: &str = "%A %d %b %Y";
        /// `"%A %d %b %Y %I:%M:%S %p %Z"`
        pub const D_T_FMT: &str = "%A %d %b %Y %I:%M:%S %p %Z";
        /// `None`
        pub const ERA: Option<&[&str]> = None;
        /// `None`
        pub const ERA_D_FMT: Option<&str> = None;
        /// `None`
        pub const ERA_D_T_FMT: Option<&str> = None;
        /// `None`
        pub const ERA_T_FMT: Option<&str> = None;
        /// `None`
        pub const FIRST_WEEKDAY: Option<i64> = None;
        /// `None`
        pub const FIRST_WORKDAY: Option<i64> = None;
        /// `&["Jenuware", "Febwari", "Maj", "Epril", "Mei", "Jun", "Julae", "Ogis", "Septemba", "Oktoba", "Novemba", "Disemba"]`
        pub const MON: &[&str] = &["Jenuware", "Febwari", "Maj", "Epril", "Mei", "Jun", "Julae", "Ogis", "Septemba", "Oktoba", "Novemba", "Disemba"];
        /// `"%I:%M:%S %p %Z"`
        pub const T_FMT: &str = "%I:%M:%S %p %Z";
        /// `"%I:%M:%S %p %Z"`
        pub const T_FMT_AMPM: &str = "%I:%M:%S %p %Z";
        /// `None`
        pub const WEEK: Option<&[i64]> = None;
    }
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod bn_BD {
    pub mod LC_ADDRESS {
        /// `Some("BGD")`
        pub const COUNTRY_AB3: Option<&str> = Some("BGD");
        /// `Some("BD")`
        pub const COUNTRY_ABTWO: Option<&str> = Some("BD");
        /// `Some("BD")`
        pub const COUNTRY_CAR: Option<&str> = Some("BD");
        /// `None`
        pub const COUNTRY_ISBN: Option<&str> = None;
        /// `Some("ব\u{9be}ংল\u{9be}দেশ")`
        pub const COUNTRY_NAME: Option<&str> = Some("ব\u{9be}ংল\u{9be}দেশ");
        /// `Some(50)`
        pub const COUNTRY_NUM: Option<i64> = Some(50);
        /// `None`
        pub const COUNTRY_POST: Option<&str> = None;
        /// `Some("bn")`
        pub const LANG_AB: Option<&str> = Some("bn");
        /// `Some("ben")`
        pub const LANG_LIB: Option<&str> = Some("ben");
        /// `Some("ব\u{9be}ংল\u{9be}")`
        pub const LANG_NAME: Option<&str> = Some("ব\u{9be}ংল\u{9be}");
        /// `Some("ben")`
        pub const LANG_TERM: Option<&str> = Some("ben");
        /// `Some("%a%N%f%N%d%N%b%N%h %s %e %r%N%T %z%N%c%N")`
        pub const POSTAL_FMT: Option<&str> = Some("%a%N%f%N%d%N%b%N%h %s %e %r%N%T %z%N%c%N");
    }
    pub mod LC_IDENTIFICATION {
        /// `None`
        pub const ABBREVIATION: Option<&str> = None;
        /// `Some("Dhaka, Bangladesh")`
        pub const ADDRESS: Option<&str> = Some("Dhaka, Bangladesh");
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_NAME"],
        /// ]
        /// ```
        pub const CATEGORY: Option<&[&[&str]]> = Some(&[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_MEASUREMENT"],
            &["i18n:2012", "LC_TELEPHONE"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_NAME"],
        ]);
        /// `Some("Taneem Ahmed, Jamil Ahmed")`
        pub const CONTACT: Option<&str> = Some("Taneem Ahmed, Jamil Ahmed");
        /// `Some("2007-01-10")`
        pub const DATE: Option<&str> = Some("2007-01-10");
        /// `Some("taneem@bengalinux.org, jamil@bengalinux.org")`
        pub const EMAIL: Option<&str> = Some("taneem@bengalinux.org, jamil@bengalinux.org");
        /// `Some("")`
        pub const FAX: Option<&str> = Some("");
        /// `Some("Bangla")`
        pub const LANGUAGE: Option<&str> = Some("Bangla");
        /// `Some("0.5")`
        pub const REVISION: Option<&str> = Some("0.5");
        /// `Some("Ankur Group, http://www.ankurbangla.org, http://www.bengalinux.org")`
        pub const SOURCE: Option<&str> = Some("Ankur Group, http://www.ankurbangla.org, http://www.bengalinux.org");
        /// `Some("")`
        pub const TEL: Option<&str> = Some("");
        /// `Some("Bangladesh")`
        pub const TERRITORY: Option<&str> = Some("Bangladesh");
        /// `Some("Bangla language locale for Bangladesh")`
        pub const TITLE: Option<&str> = Some("Bangla language locale for Bangladesh");
    }
    pub mod LC_MESSAGES {
        /// `"^[-0nNন]"`
        pub const NOEXPR: &str = "^[-0nNন]";
        /// `Some("ন\u{9be}")`
        pub const NOSTR: Option<&str> = Some("ন\u{9be}");
        /// `"^[+1yYহ]"`
        pub const YESEXPR: &str = "^[+1yYহ]";
        /// `Some("হ\u{9cd}য\u{9be}\u{981}")`
        pub const YESSTR: Option<&str> = Some("হ\u{9cd}য\u{9be}\u{981}");
    }
    pub mod LC_MONETARY {
        /// `"৳"`
        pub const CURRENCY_SYMBOL: &str = "৳";
        /// `2`
        pub const FRAC_DIGITS: i64 = 2;
        /// `"BDT "`
        pub const INT_CURR_SYMBOL: &str = "BDT ";
        /// `2`
        pub const INT_FRAC_DIGITS: i64 = 2;
        /// `None`
        pub const INT_N_CS_PRECEDES: Option<i64> = None;
        /// `None`
        pub const INT_N_SEP_BY_SPACE: Option<i64> = None;
        /// `None`
        pub const INT_N_SIGN_POSN: Option<i64> = None;
        /// `None`
        pub const INT_P_CS_PRECEDES: Option<i64> = None;
        /// `None`
        pub const INT_P_SEP_BY_SPACE: Option<i64> = None;
        /// `None`
        pub const INT_P_SIGN_POSN: Option<i64> = None;
        /// `"."`
        pub const MON_DECIMAL_POINT: &str = ".";
        /// `&[3, 2]`
        pub const MON_GROUPING: &[i64] = &[3, 2];
        /// `","`
        pub const MON_THOUSANDS_SEP: &str = ",";
        /// `"-"`
        pub const NEGATIVE_SIGN: &str = "-";
        /// `1`
        pub const N_CS_PRECEDES: i64 = 1;
        /// `1`
        pub const N_SEP_BY_SPACE: i64 = 1;
        /// `1`
        pub const N_SIGN_POSN: i64 = 1;
        /// `""`
        pub const POSITIVE_SIGN: &str = "";
        /// `1`
        pub const P_CS_PRECEDES: i64 = 1;
        /// `1`
        pub const P_SEP_BY_SPACE: i64 = 1;
        /// `1`
        pub const P_SIGN_POSN: i64 = 1;
    }
    pub mod LC_NUMERIC {
        /// `"."`
        pub const DECIMAL_POINT: &str = ".";
        /// `&[3, 2]`
        pub const GROUPING: &[i64] = &[3, 2];
        /// `","`
        pub const THOUSANDS_SEP: &str = ",";
    }
    pub mod LC_TELEPHONE {
        /// `Some("880")`
        pub const INT_PREFIX: Option<&str> = Some("880");
        /// `Some("00")`
        pub const INT_SELECT: Option<&str> = Some("00");
        /// `Some("%a %l")`
        pub const TEL_DOM_FMT: Option<&str> = Some("%a %l");
        /// `Some("+%c %a %l")`
        pub const TEL_INT_FMT: Option<&str> = Some("+%c %a %l");
    }
    pub mod LC_TIME {
        /// `&["রবি", "সোম", "মঙ\u{9cd}গল", "ব\u{9c1}ধ", "ব\u{9c3}হঃ", "শ\u{9c1}ক\u{9cd}র", "শনি"]`
        pub const ABDAY: &[&str] = &["রবি", "সোম", "মঙ\u{9cd}গল", "ব\u{9c1}ধ", "ব\u{9c3}হঃ", "শ\u{9c1}ক\u{9cd}র", "শনি"];
        /// `&["জ\u{9be}ন\u{9c1}", "ফেব", "ম\u{9be}র\u{9cd}চ", "এপ\u{9cd}রিল", "মে", "জ\u{9c1}ন", "জ\u{9c1}ল\u{9be}ই", "আগস\u{9cd}ট", "সেপ\u{9cd}টেম\u{9cd}বর", "অক\u{9cd}টোবর", "নভেম\u{9cd}বর", "ডিসেম\u{9cd}বর"]`
        pub const ABMON: &[&str] = &["জ\u{9be}ন\u{9c1}", "ফেব", "ম\u{9be}র\u{9cd}চ", "এপ\u{9cd}রিল", "মে", "জ\u{9c1}ন", "জ\u{9c1}ল\u{9be}ই", "আগস\u{9cd}ট", "সেপ\u{9cd}টেম\u{9cd}বর", "অক\u{9cd}টোবর", "নভেম\u{9cd}বর", "ডিসেম\u{9cd}বর"];
        /// `None`
        pub const AB_ALT_MON: Option<&[&str]> = None;
        /// `None`
        pub const ALT_DIGITS: Option<&[&str]> = None;
        /// `None`
        pub const ALT_MON: Option<&[&str]> = None;
        /// `&["প\u{9c2}র\u{9cd}ব\u{9be}হ\u{9cd}ণ", "অপর\u{9be}হ\u{9cd}ণ"]`
        pub const AM_PM: &[&str] = &["প\u{9c2}র\u{9cd}ব\u{9be}হ\u{9cd}ণ", "অপর\u{9be}হ\u{9cd}ণ"];
        /// `None`
        pub const CAL_DIRECTION: Option<i64> = None;
        /// `None`
        pub const DATE_FMT: Option<&str> = None;
        /// `&["রবিব\u{9be}র", "সোমব\u{9be}র", "মঙ\u{9cd}গলব\u{9be}র", "ব\u{9c1}ধব\u{9be}র", "ব\u{9c3}হস\u{9cd}পতিব\u{9be}র", "শ\u{9c1}ক\u{9cd}রব\u{9be}র", "শনিব\u{9be}র"]`
        pub const DAY: &[&str] = &["রবিব\u{9be}র", "সোমব\u{9be}র", "মঙ\u{9cd}গলব\u{9be}র", "ব\u{9c1}ধব\u{9be}র", "ব\u{9c3}হস\u{9cd}পতিব\u{9be}র", "শ\u{9c1}ক\u{9cd}রব\u{9be}র", "শনিব\u{9be}র"];
        /// `"%-d/%-m/%y"`
        pub const D_FMT: &str = "%-d/%-m/%y";
        /// `"%A %d %b %Y %I:%M:%S %p %Z"`
        pub const D_T_FMT: &str = "%A %d %b %Y %I:%M:%S %p %Z";
        /// `None`
        pub const ERA: Option<&[&str]> = None;
        /// `None`
        pub const ERA_D_FMT: Option<&str> = None;
        /// `None`
        pub const ERA_D_T_FMT: Option<&str> = None;
        /// `None`
        pub const ERA_T_FMT: Option<&str> = None;
        /// `Some(6)`
        pub const FIRST_WEEKDAY: Option<i64> = Some(6);
        /// `None`
        pub const FIRST_WORKDAY: Option<i64> = None;
        /// `&["জ\u{9be}ন\u{9c1}য\u{9bc}\u{9be}রী", "ফেব\u{9cd}র\u{9c1}য\u{9bc}\u{9be}রী", "ম\u{9be}র\u{9cd}চ", "এপ\u{9cd}রিল", "মে", "জ\u{9c1}ন", "জ\u{9c1}ল\u{9be}ই", "আগস\u{9cd}ট", "সেপ\u{9cd}টেম\u{9cd}বর", "অক\u{9cd}টোবর", "নভেম\u{9cd}বর", "ডিসেম\u{9cd}বর"]`
        pub const MON: &[&str] = &["জ\u{9be}ন\u{9c1}য\u{9bc}\u{9be}রী", "ফেব\u{9cd}র\u{9c1}য\u{9bc}\u{9be}রী", "ম\u{9be}র\u{9cd}চ", "এপ\u{9cd}রিল", "মে", "জ\u{9c1}ন", "জ\u{9c1}ল\u{9be}ই", "আগস\u{9cd}ট", "সেপ\u{9cd}টেম\u{9cd}বর", "অক\u{9cd}টোবর", "নভেম\u{9cd}বর", "ডিসেম\u{9cd}বর"];
        /// `"%I:%M:%S %p %Z"`
        pub const T_FMT: &str = "%I:%M:%S %p %Z";
        /// `"%I:%M:%S %p %Z"`
        pub const T_FMT_AMPM: &str = "%I:%M:%S %p %Z";
        /// `Some(&[7, 19971130, 1])`
        pub const WEEK: Option<&[i64]> = Some(&[7, 19971130, 1]);
    }
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod bn_IN {
    pub mod LC_ADDRESS {
        /// `Some("IND")`
        pub const COUNTRY_AB3: Option<&str> = Some("IND");
        /// `Some("IN")`
        pub const COUNTRY_ABTWO: Option<&str> = Some("IN");
        /// `Some("IND")`
        pub const COUNTRY_CAR: Option<&str> = Some("IND");
        /// `None`
        pub const COUNTRY_ISBN: Option<&str> = None;
        /// `Some("ভ\u{9be}রত")`
        pub const COUNTRY_NAME: Option<&str> = Some("ভ\u{9be}রত");
        /// `Some(356)`
        pub const COUNTRY_NUM: Option<i64> = Some(356);
        /// `None`
        pub const COUNTRY_POST: Option<&str> = None;
        /// `Some("bn")`
        pub const LANG_AB: Option<&str> = Some("bn");
        /// `Some("ben")`
        pub const LANG_LIB: Option<&str> = Some("ben");
        /// `Some("ব\u{9be}ংল\u{9be}")`
        pub const LANG_NAME: Option<&str> = Some("ব\u{9be}ংল\u{9be}");
        /// `Some("ben")`
        pub const LANG_TERM: Option<&str> = Some("ben");
        /// `Some("%z%c%T%s%b%e%r")`
        pub const POSTAL_FMT: Option<&str> = Some("%z%c%T%s%b%e%r");
    }
    pub mod LC_IDENTIFICATION {
        /// `None`
        pub const ABBREVIATION: Option<&str> = None;
        /// `Some("1623-14, Shimotsuruma, Yamato-shi, Kanagawa-ken, 242-8502, Japan")`
        pub const ADDRESS: Option<&str> = Some("1623-14, Shimotsuruma, Yamato-shi, Kanagawa-ken, 242-8502, Japan");
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        /// ]
        /// ```
        pub const CATEGORY: Option<&[&[&str]]> = Some(&[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_TELEPHONE"],
            &["i18n:2012", "LC_MEASUREMENT"],
        ]);
        /// `None`
        pub const CONTACT: Option<&str> = None;
        /// `Some("2006-05-29")`
        pub const DATE: Option<&str> = Some("2006-05-29");
        /// `Some("bug-glibc-locales@gnu.org")`
        pub const EMAIL: Option<&str> = Some("bug-glibc-locales@gnu.org");
        /// `Some("")`
        pub const FAX: Option<&str> = Some("");
        /// `Some("Bangla")`
        pub const LANGUAGE: Option<&str> = Some("Bangla");
        /// `Some("1.0")`
        pub const REVISION: Option<&str> = Some("1.0");
        /// `Some("IBM Globalization Center of Competency, Yamato Software Laboratory")`
        pub const SOURCE: Option<&str> = Some("IBM Globalization Center of Competency, Yamato Software Laboratory");
        /// `Some("")`
        pub const TEL: Option<&str> = Some("");
        /// `Some("India")`
        pub const TERRITORY: Option<&str> = Some("India");
        /// `Some("Bangla language locale for India")`
        pub const TITLE: Option<&str> = Some("Bangla language locale for India");
    }
    pub use super::bn_BD::LC_MESSAGES;
    pub use super::hi_IN::LC_MONETARY;
    pub mod LC_NUMERIC {
        /// `"."`
        pub const DECIMAL_POINT: &str = ".";
        /// `&[3, 2]`
        pub const GROUPING: &[i64] = &[3, 2];
        /// `","`
        pub const THOUSANDS_SEP: &str = ",";
    }
    pub use super::hi_IN::LC_TELEPHONE;
    pub mod LC_TIME {
        /// `&["রবি", "সোম", "মঙ\u{9cd}গল", "ব\u{9c1}ধ", "ব\u{9c3}হস\u{9cd}পতি", "শ\u{9c1}ক\u{9cd}র", "শনি"]`
        pub const ABDAY: &[&str] = &["রবি", "সোম", "মঙ\u{9cd}গল", "ব\u{9c1}ধ", "ব\u{9c3}হস\u{9cd}পতি", "শ\u{9c1}ক\u{9cd}র", "শনি"];
        /// `&["জ\u{9be}ন\u{9c1}", "ফেব", "ম\u{9be}র\u{9cd}চ", "এপ\u{9cd}রিল", "মে", "জ\u{9c1}ন", "জ\u{9c1}ল\u{9be}ই", "আগস\u{9cd}ট", "সেপ\u{9cd}টেম\u{9cd}বর", "অক\u{9cd}টোবর", "নভেম\u{9cd}বর", "ডিসেম\u{9cd}বর"]`
        pub const ABMON: &[&str] = &["জ\u{9be}ন\u{9c1}", "ফেব", "ম\u{9be}র\u{9cd}চ", "এপ\u{9cd}রিল", "মে", "জ\u{9c1}ন", "জ\u{9c1}ল\u{9be}ই", "আগস\u{9cd}ট", "সেপ\u{9cd}টেম\u{9cd}বর", "অক\u{9cd}টোবর", "নভেম\u{9cd}বর", "ডিসেম\u{9cd}বর"];
        /// `None`
        pub const AB_ALT_MON: Option<&[&str]> = None;
        /// `None`
        pub const ALT_DIGITS: Option<&[&str]> = None;
        /// `None`
        pub const ALT_MON: Option<&[&str]> = None;
        /// `&["প\u{9c2}র\u{9cd}ব\u{9be}হ\u{9cd}ণ", "অপর\u{9be}হ\u{9cd}ণ"]`
        pub const AM_PM: &[&str] = &["প\u{9c2}র\u{9cd}ব\u{9be}হ\u{9cd}ণ", "অপর\u{9be}হ\u{9cd}ণ"];
        /// `None`
        pub const CAL_DIRECTION: Option<i64> = None;
        /// `None`
        pub const DATE_FMT: Option<&str> = None;
        /// `&["রবিব\u{9be}র", "সোমব\u{9be}র", "মঙ\u{9cd}গলব\u{9be}র", "ব\u{9c1}ধব\u{9be}র", "ব\u{9c3}হস\u{9cd}পতিব\u{9be}র", "শ\u{9c1}ক\u{9cd}রব\u{9be}র", "শনিব\u{9be}র"]`
        pub const DAY: &[&str] = &["রবিব\u{9be}র", "সোমব\u{9be}র", "মঙ\u{9cd}গলব\u{9be}র", "ব\u{9c1}ধব\u{9be}র", "ব\u{9c3}হস\u{9cd}পতিব\u{9be}র", "শ\u{9c1}ক\u{9cd}রব\u{9be}র", "শনিব\u{9be}র"];
        /// `"%-d/%-m/%y"`
        pub const D_FMT: &str = "%-d/%-m/%y";
        /// `"%A %d %b %Y %I:%M:%S %p %Z"`
        pub const D_T_FMT: &str = "%A %d %b %Y %I:%M:%S %p %Z";
        /// `None`
        pub const ERA: Option<&[&str]> = None;
        /// `None`
        pub const ERA_D_FMT: Option<&str> = None;
        /// `None`
        pub const ERA_D_T_FMT: Option<&str> = None;
        /// `None`
        pub const ERA_T_FMT: Option<&str> = None;
        /// `None`
        pub const FIRST_WEEKDAY: Option<i64> = None;
        /// `None`
        pub const FIRST_WORKDAY: Option<i64> = None;
        /// `&["জ\u{9be}ন\u{9c1}য\u{9bc}\u{9be}রী", "ফেব\u{9cd}র\u{9c1}য\u{9bc}\u{9be}রী", "ম\u{9be}র\u{9cd}চ", "এপ\u{9cd}রিল", "মে", "জ\u{9c1}ন", "জ\u{9c1}ল\u{9be}ই", "আগস\u{9cd}ট", "সেপ\u{9cd}টেম\u{9cd}বর", "অক\u{9cd}টোবর", "নভেম\u{9cd}বর", "ডিসেম\u{9cd}বর"]`
        pub const MON: &[&str] = &["জ\u{9be}ন\u{9c1}য\u{9bc}\u{9be}রী", "ফেব\u{9cd}র\u{9c1}য\u{9bc}\u{9be}রী", "ম\u{9be}র\u{9cd}চ", "এপ\u{9cd}রিল", "মে", "জ\u{9c1}ন", "জ\u{9c1}ল\u{9be}ই", "আগস\u{9cd}ট", "সেপ\u{9cd}টেম\u{9cd}বর", "অক\u{9cd}টোবর", "নভেম\u{9cd}বর", "ডিসেম\u{9cd}বর"];
        /// `"%I:%M:%S %p %Z"`
        pub const T_FMT: &str = "%I:%M:%S %p %Z";
        /// `"%I:%M:%S %p %Z"`
        pub const T_FMT_AMPM: &str = "%I:%M:%S %p %Z";
        /// `Some(&[7, 19971130, 1])`
        pub const WEEK: Option<&[i64]> = Some(&[7, 19971130, 1]);
    }
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod bo_CN {
    pub mod LC_ADDRESS {
        /// `Some("CHN")`
        pub const COUNTRY_AB3: Option<&str> = Some("CHN");
        /// `Some("CN")`
        pub const COUNTRY_ABTWO: Option<&str> = Some("CN");
        /// `Some("CHN")`
        pub const COUNTRY_CAR: Option<&str> = Some("CHN");
        /// `Some("7")`
        pub const COUNTRY_ISBN: Option<&str> = Some("7");
        /// `Some("ར\u{f92}\u{fb1}་ནག")`
        pub const COUNTRY_NAME: Option<&str> = Some("ར\u{f92}\u{fb1}་ནག");
        /// `Some(156)`
        pub const COUNTRY_NUM: Option<i64> = Some(156);
        /// `None`
        pub const COUNTRY_POST: Option<&str> = None;
        /// `Some("bo")`
        pub const LANG_AB: Option<&str> = Some("bo");
        /// `Some("tib")`
        pub const LANG_LIB: Option<&str> = Some("tib");
        /// `Some("བ\u{f7c}ད་ས\u{f90}ད་")`
        pub const LANG_NAME: Option<&str> = Some("བ\u{f7c}ད་ས\u{f90}ད་");
        /// `Some("bod")`
        pub const LANG_TERM: Option<&str> = Some("bod");
        /// `Some("%c%N%T%N%s %h %e %r%N%b%N%d%N%f%N%a%N")`
        pub const POSTAL_FMT: Option<&str> = Some("%c%N%T%N%s %h %e %r%N%b%N%d%N%f%N%a%N");
    }
    pub mod LC_IDENTIFICATION {
        /// `None`
        pub const ABBREVIATION: Option<&str> = None;
        /// `Some("")`
        pub const ADDRESS: Option<&str> = Some("");
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        /// ]
        /// ```
        pub const CATEGORY: Option<&[&[&str]]> = Some(&[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_TELEPHONE"],
            &["i18n:2012", "LC_MEASUREMENT"],
        ]);
        /// `Some("")`
        pub const CONTACT: Option<&str> = Some("");
        /// `Some("2007-11-06")`
        pub const DATE: Option<&str> = Some("2007-11-06");
        /// `Some("bug-glibc@gnu.org")`
        pub const EMAIL: Option<&str> = Some("bug-glibc@gnu.org");
        /// `Some("")`
        pub const FAX: Option<&str> = Some("");
        /// `Some("Tibetan")`
        pub const LANGUAGE: Option<&str> = Some("Tibetan");
        /// `Some("0.1")`
        pub const REVISION: Option<&str> = Some("0.1");
        /// `Some("")`
        pub const SOURCE: Option<&str> = Some("");
        /// `Some("")`
        pub const TEL: Option<&str> = Some("");
        /// `Some("China")`
        pub const TERRITORY: Option<&str> = Some("China");
        /// `Some("Tibetan language locale for P.R. of China")`
        pub const TITLE: Option<&str> = Some("Tibetan language locale for P.R. of China");
    }
    pub mod LC_MESSAGES {
        /// `"^[-0nNམ]"`
        pub const NOEXPR: &str = "^[-0nNམ]";
        /// `Some("མ\u{f72}ན།")`
        pub const NOSTR: Option<&str> = Some("མ\u{f72}ན།");
        /// `"^[+1yYཨ]"`
        pub const YESEXPR: &str = "^[+1yYཨ]";
        /// `Some("ཡ\u{f72}ན།")`
        pub const YESSTR: Option<&str> = Some("ཡ\u{f72}ན།");
    }
    pub use super::zh_CN::LC_MONETARY;
    pub use super::zh_CN::LC_NUMERIC;
    pub use super::zh_CN::LC_TELEPHONE;
    pub mod LC_TIME {
        /// `&["ཉ\u{f72}་", "ཟ\u{fb3}་", "མ\u{f72}ར་", "ལ\u{fb7}ག་", "པ\u{f74}ར་", "སངས་", "ས\u{fa4}\u{f7a}ན་"]`
        pub const ABDAY: &[&str] = &["ཉ\u{f72}་", "ཟ\u{fb3}་", "མ\u{f72}ར་", "ལ\u{fb7}ག་", "པ\u{f74}ར་", "སངས་", "ས\u{fa4}\u{f7a}ན་"];
        /// `&["ཟ\u{fb3}་༡", "ཟ\u{fb3}་༢", "ཟ\u{fb3}་༣", "ཟ\u{fb3}་༤", "ཟ\u{fb3}་༥", "ཟ\u{fb3}་༦", "ཟ\u{fb3}་༧", "ཟ\u{fb3}་༨", "ཟ\u{fb3}་༩", "ཟ\u{fb3}་༡༠", "ཟ\u{fb3}་༡༡", "ཟ\u{fb3}་༡༢"]`
        pub const ABMON: &[&str] = &["ཟ\u{fb3}་༡", "ཟ\u{fb3}་༢", "ཟ\u{fb3}་༣", "ཟ\u{fb3}་༤", "ཟ\u{fb3}་༥", "ཟ\u{fb3}་༦", "ཟ\u{fb3}་༧", "ཟ\u{fb3}་༨", "ཟ\u{fb3}་༩", "ཟ\u{fb3}་༡༠", "ཟ\u{fb3}་༡༡", "ཟ\u{fb3}་༡༢"];
        /// `None`
        pub const AB_ALT_MON: Option<&[&str]> = None;
        /// `None`
        pub const ALT_DIGITS: Option<&[&str]> = None;
        /// `None`
        pub const ALT_MON: Option<&[&str]> = None;
        /// `&["ངས་ཆ", "ཕ\u{fb1}\u{f72}་ཆ"]`
        pub const AM_PM: &[&str] = &["ངས་ཆ", "ཕ\u{fb1}\u{f72}་ཆ"];
        /// `None`
        pub const CAL_DIRECTION: Option<i64> = None;
        /// `None`
        pub const DATE_FMT: Option<&str> = None;
        /// `&["གཟའ་ཉ\u{f72}་མ་", "གཟའ་ཟ\u{fb3}་བ་", "གཟའ་མ\u{f72}ག་དམར་", "གཟའ་ལ\u{fb7}ག་ཕ་", "གཟའ་པ\u{f74}ར་བ\u{f74}་", "གཟའ་པ་སངས་", "གཟའ་ས\u{fa4}\u{f7a}ན་ཕ་"]`
        pub const DAY: &[&str] = &["གཟའ་ཉ\u{f72}་མ་", "གཟའ་ཟ\u{fb3}་བ་", "གཟའ་མ\u{f72}ག་དམར་", "གཟའ་ལ\u{fb7}ག་ཕ་", "གཟའ་པ\u{f74}ར་བ\u{f74}་", "གཟའ་པ་སངས་", "གཟའ་ས\u{fa4}\u{f7a}ན་ཕ་"];
        /// `"པས\u{fb1}\u{f72}་ལ\u{f7c}%yཟལ%mཚ\u{f7a}ས%d"`
        pub const D_FMT: &str = "པས\u{fb1}\u{f72}་ལ\u{f7c}%yཟལ%mཚ\u{f7a}ས%d";
        /// `"པས\u{fb1}\u{f72}་ལ\u{f7c}%yཟལ%mཚ\u{f7a}ས%dཆ\u{f74}་ཚ\u{f7c}ད%Hཀསར་མ%Mཀསར་ཆ%S"`
        pub const D_T_FMT: &str = "པས\u{fb1}\u{f72}་ལ\u{f7c}%yཟལ%mཚ\u{f7a}ས%dཆ\u{f74}་ཚ\u{f7c}ད%Hཀསར་མ%Mཀསར་ཆ%S";
        /// `None`
        pub const ERA: Option<&[&str]> = None;
        /// `None`
        pub const ERA_D_FMT: Option<&str> = None;
        /// `None`
        pub const ERA_D_T_FMT: Option<&str> = None;
        /// `None`
        pub const ERA_T_FMT: Option<&str> = None;
        /// `Some(2)`
        pub const FIRST_WEEKDAY: Option<i64> = Some(2);
        /// `None`
        pub const FIRST_WORKDAY: Option<i64> = None;
        /// `&["ཟ\u{fb3}་བ་དང་པ་", "ཟ\u{fb3}་བ་གཉ\u{f72}ས་པ་", "ཟ\u{fb3}་བ་གས\u{f74}མ་པ་", "ཟ\u{fb3}་བ་བཞ\u{f72}་པ་", "ཟ\u{fb3}་བ་ལ\u{f94}་ཕ་", "ཟ\u{fb3}་བ་ད\u{fb2}\u{f74}ག་པ་", "ཟ\u{fb3}་བ་བད\u{f74}ནཔ་", "ཟ\u{fb3}་བ་བར\u{f92}\u{fb1}ད་པ་", "ཟ\u{fb3}་བ་དག\u{f74}་པ་", "ཟ\u{fb3}་བ་བཅ\u{f74}་པ་", "ཟ\u{fb3}་བ་བཅ\u{f74}་གཅ\u{f72}ག་པ་", "ཟ\u{fb3}་བ་བཅ\u{f74}་གཉ\u{f72}ས་པ་"]`
        pub const MON: &[&str] = &["ཟ\u{fb3}་བ་དང་པ་", "ཟ\u{fb3}་བ་གཉ\u{f72}ས་པ་", "ཟ\u{fb3}་བ་གས\u{f74}མ་པ་", "ཟ\u{fb3}་བ་བཞ\u{f72}་པ་", "ཟ\u{fb3}་བ་ལ\u{f94}་ཕ་", "ཟ\u{fb3}་བ་ད\u{fb2}\u{f74}ག་པ་", "ཟ\u{fb3}་བ་བད\u{f74}ནཔ་", "ཟ\u{fb3}་བ་བར\u{f92}\u{fb1}ད་པ་", "ཟ\u{fb3}་བ་དག\u{f74}་པ་", "ཟ\u{fb3}་བ་བཅ\u{f74}་པ་", "ཟ\u{fb3}་བ་བཅ\u{f74}་གཅ\u{f72}ག་པ་", "ཟ\u{fb3}་བ་བཅ\u{f74}་གཉ\u{f72}ས་པ་"];
        /// `"ཆ\u{f74}་ཚ\u{f7c}ད%Hཀསར་མ%Mཀསར་ཆ%S"`
        pub const T_FMT: &str = "ཆ\u{f74}་ཚ\u{f7c}ད%Hཀསར་མ%Mཀསར་ཆ%S";
        /// `"ཆ\u{f74}་ཚ\u{f7c}ད%Iཀསར་མ%Mཀསར་ཆ%S %p"`
        pub const T_FMT_AMPM: &str = "ཆ\u{f74}་ཚ\u{f7c}ད%Iཀསར་མ%Mཀསར་ཆ%S %p";
        /// `Some(&[7, 19971130, 1])`
        pub const WEEK: Option<&[i64]> = Some(&[7, 19971130, 1]);
    }
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod bo_IN {
    pub mod LC_ADDRESS {
        /// `Some("IND")`
        pub const COUNTRY_AB3: Option<&str> = Some("IND");
        /// `Some("IN")`
        pub const COUNTRY_ABTWO: Option<&str> = Some("IN");
        /// `Some("IND")`
        pub const COUNTRY_CAR: Option<&str> = Some("IND");
        /// `None`
        pub const COUNTRY_ISBN: Option<&str> = None;
        /// `Some("ར\u{f92}\u{fb1}་གར་")`
        pub const COUNTRY_NAME: Option<&str> = Some("ར\u{f92}\u{fb1}་གར་");
        /// `Some(356)`
        pub const COUNTRY_NUM: Option<i64> = Some(356);
        /// `None`
        pub const COUNTRY_POST: Option<&str> = None;
        /// `Some("bo")`
        pub const LANG_AB: Option<&str> = Some("bo");
        /// `Some("tib")`
        pub const LANG_LIB: Option<&str> = Some("tib");
        /// `Some("བ\u{f7c}ད་ས\u{f90}ད་")`
        pub const LANG_NAME: Option<&str> = Some("བ\u{f7c}ད་ས\u{f90}ད་");
        /// `Some("bod")`
        pub const LANG_TERM: Option<&str> = Some("bod");
        /// `Some("%z%c%T%s%b%e%r")`
        pub const POSTAL_FMT: Option<&str> = Some("%z%c%T%s%b%e%r");
    }
    pub mod LC_IDENTIFICATION {
        /// `None`
        pub const ABBREVIATION: Option<&str> = None;
        /// `Some("")`
        pub const ADDRESS: Option<&str> = Some("");
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        /// ]
        /// ```
        pub const CATEGORY: Option<&[&[&str]]> = Some(&[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_TELEPHONE"],
            &["i18n:2012", "LC_MEASUREMENT"],
        ]);
        /// `Some("")`
        pub const CONTACT: Option<&str> = Some("");
        /// `Some("2007-11-06")`
        pub const DATE: Option<&str> = Some("2007-11-06");
        /// `Some("bug-glibc@gnu.org")`
        pub const EMAIL: Option<&str> = Some("bug-glibc@gnu.org");
        /// `Some("")`
        pub const FAX: Option<&str> = Some("");
        /// `Some("Tibetan")`
        pub const LANGUAGE: Option<&str> = Some("Tibetan");
        /// `Some("0.1")`
        pub const REVISION: Option<&str> = Some("0.1");
        /// `Some("")`
        pub const SOURCE: Option<&str> = Some("");
        /// `Some("")`
        pub const TEL: Option<&str> = Some("");
        /// `Some("India")`
        pub const TERRITORY: Option<&str> = Some("India");
        /// `Some("Tibetan language locale for India")`
        pub const TITLE: Option<&str> = Some("Tibetan language locale for India");
    }
    pub use super::bo_CN::LC_MESSAGES;
    pub use super::hi_IN::LC_MONETARY;
    pub use super::bo_CN::LC_NUMERIC;
    pub use super::hi_IN::LC_TELEPHONE;
    pub use super::bo_CN::LC_TIME;
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod br_FR {
    pub mod LC_ADDRESS {
        /// `Some("FRA")`
        pub const COUNTRY_AB3: Option<&str> = Some("FRA");
        /// `Some("FR")`
        pub const COUNTRY_ABTWO: Option<&str> = Some("FR");
        /// `Some("F")`
        pub const COUNTRY_CAR: Option<&str> = Some("F");
        /// `Some("979-10")`
        pub const COUNTRY_ISBN: Option<&str> = Some("979-10");
        /// `Some("Frañs")`
        pub const COUNTRY_NAME: Option<&str> = Some("Frañs");
        /// `Some(250)`
        pub const COUNTRY_NUM: Option<i64> = Some(250);
        /// `None`
        pub const COUNTRY_POST: Option<&str> = None;
        /// `Some("br")`
        pub const LANG_AB: Option<&str> = Some("br");
        /// `Some("bre")`
        pub const LANG_LIB: Option<&str> = Some("bre");
        /// `Some("brezhoneg")`
        pub const LANG_NAME: Option<&str> = Some("brezhoneg");
        /// `Some("bre")`
        pub const LANG_TERM: Option<&str> = Some("bre");
        /// `Some("%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%c%N")`
        pub const POSTAL_FMT: Option<&str> = Some("%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%c%N");
    }
    pub mod LC_IDENTIFICATION {
        /// `None`
        pub const ABBREVIATION: Option<&str> = None;
        /// `Some("")`
        pub const ADDRESS: Option<&str> = Some("");
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        /// ]
        /// ```
        pub const CATEGORY: Option<&[&[&str]]> = Some(&[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_TELEPHONE"],
            &["i18n:2012", "LC_MEASUREMENT"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_MESSAGES"],
        ]);
        /// `Some("Thierry Vignaud")`
        pub const CONTACT: Option<&str> = Some("Thierry Vignaud");
        /// `Some("2001-01-28")`
        pub const DATE: Option<&str> = Some("2001-01-28");
        /// `Some("thierry.vignaud@gmail.com")`
        pub const EMAIL: Option<&str> = Some("thierry.vignaud@gmail.com");
        /// `Some("")`
        pub const FAX: Option<&str> = Some("");
        /// `Some("Breton")`
        pub const LANGUAGE: Option<&str> = Some("Breton");
        /// `Some("0.54")`
        pub const REVISION: Option<&str> = Some("0.54");
        /// `Some("Denise.Peden@enst-bretagne.fr (Denise Derrien-Peden)")`
        pub const SOURCE: Option<&str> = Some("Denise.Peden@enst-bretagne.fr (Denise Derrien-Peden)");
        /// `Some("")`
        pub const TEL: Option<&str> = Some("");
        /// `Some("France")`
        pub const TERRITORY: Option<&str> = Some("France");
        /// `Some("Breton language locale for France")`
        pub const TITLE: Option<&str> = Some("Breton language locale for France");
    }
    pub mod LC_MESSAGES {
        /// `"^[-0kKnN]"`
        pub const NOEXPR: &str = "^[-0kKnN]";
        /// `Some("ket")`
        pub const NOSTR: Option<&str> = Some("ket");
        /// `"^[+1oOyY]"`
        pub const YESEXPR: &str = "^[+1oOyY]";
        /// `Some("ya")`
        pub const YESSTR: Option<&str> = Some("ya");
    }
    pub use super::fr_FR::LC_MONETARY;
    pub use super::fr_FR::LC_NUMERIC;
    pub use super::fr_FR::LC_TELEPHONE;
    pub mod LC_TIME {
        /// `&["sul", "lun", "meu", "mer", "yao", "gwe", "sad"]`
        pub const ABDAY: &[&str] = &["sul", "lun", "meu", "mer", "yao", "gwe", "sad"];
        /// `&["Gen ", "Cʼhw", "Meu ", "Ebr ", "Mae ", "Mezh", "Gou ", "Eos ", "Gwe ", "Her ", "Du  ", "Ker "]`
        pub const ABMON: &[&str] = &["Gen ", "Cʼhw", "Meu ", "Ebr ", "Mae ", "Mezh", "Gou ", "Eos ", "Gwe ", "Her ", "Du  ", "Ker "];
        /// `None`
        pub const AB_ALT_MON: Option<&[&str]> = None;
        /// `None`
        pub const ALT_DIGITS: Option<&[&str]> = None;
        /// `None`
        pub const ALT_MON: Option<&[&str]> = None;
        /// `&[" ", " "]`
        pub const AM_PM: &[&str] = &[" ", " "];
        /// `None`
        pub const CAL_DIRECTION: Option<i64> = None;
        /// `None`
        pub const DATE_FMT: Option<&str> = None;
        /// `&["sul", "lun", "meurzh", "mercʼher", "yaou", "gwener", "sadorn"]`
        pub const DAY: &[&str] = &["sul", "lun", "meurzh", "mercʼher", "yaou", "gwener", "sadorn"];
        /// `"%d.%m.%Y"`
        pub const D_FMT: &str = "%d.%m.%Y";
        /// `"Dʼar %A %d a viz %B %Y"`
        pub const D_T_FMT: &str = "Dʼar %A %d a viz %B %Y";
        /// `None`
        pub const ERA: Option<&[&str]> = None;
        /// `None`
        pub const ERA_D_FMT: Option<&str> = None;
        /// `None`
        pub const ERA_D_T_FMT: Option<&str> = None;
        /// `None`
        pub const ERA_T_FMT: Option<&str> = None;
        /// `Some(2)`
        pub const FIRST_WEEKDAY: Option<i64> = Some(2);
        /// `None`
        pub const FIRST_WORKDAY: Option<i64> = None;
        /// `&["Genver", "Cʼhwevrer", "Meurzh", "Ebrel", "Mae", "Mezheven", "Gouere", "Eost", "Gwengolo", "Here", "Du", "Kerzu"]`
        pub const MON: &[&str] = &["Genver", "Cʼhwevrer", "Meurzh", "Ebrel", "Mae", "Mezheven", "Gouere", "Eost", "Gwengolo", "Here", "Du", "Kerzu"];
        /// `"%T"`
        pub const T_FMT: &str = "%T";
        /// `"%Ie%M:%S %p"`
        pub const T_FMT_AMPM: &str = "%Ie%M:%S %p";
        /// `Some(&[7, 19971130, 4])`
        pub const WEEK: Option<&[i64]> = Some(&[7, 19971130, 4]);
    }
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod br_FR_euro {
    pub use super::br_FR::LC_ADDRESS;
    pub mod LC_IDENTIFICATION {
        /// `None`
        pub const ABBREVIATION: Option<&str> = None;
        /// `Some("https://www.gnu.org/software/libc/")`
        pub const ADDRESS: Option<&str> = Some("https://www.gnu.org/software/libc/");
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        /// ]
        /// ```
        pub const CATEGORY: Option<&[&[&str]]> = Some(&[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_TELEPHONE"],
            &["i18n:2012", "LC_MEASUREMENT"],
        ]);
        /// `None`
        pub const CONTACT: Option<&str> = None;
        /// `Some("2002-02-28")`
        pub const DATE: Option<&str> = Some("2002-02-28");
        /// `Some("bug-glibc-locales@gnu.org")`
        pub const EMAIL: Option<&str> = Some("bug-glibc-locales@gnu.org");
        /// `Some("")`
        pub const FAX: Option<&str> = Some("");
        /// `Some("Breton")`
        pub const LANGUAGE: Option<&str> = Some("Breton");
        /// `Some("1.0")`
        pub const REVISION: Option<&str> = Some("1.0");
        /// `Some("Free Software Foundation, Inc.")`
        pub const SOURCE: Option<&str> = Some("Free Software Foundation, Inc.");
        /// `Some("")`
        pub const TEL: Option<&str> = Some("");
        /// `Some("France")`
        pub const TERRITORY: Option<&str> = Some("France");
        /// `Some("Breton locale for France with Euro")`
        pub const TITLE: Option<&str> = Some("Breton locale for France with Euro");
    }
    pub use super::br_FR::LC_MESSAGES;
    pub use super::br_FR::LC_MONETARY;
    pub use super::br_FR::LC_NUMERIC;
    pub use super::br_FR::LC_TELEPHONE;
    pub use super::br_FR::LC_TIME;
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod brx_IN {
    pub mod LC_ADDRESS {
        /// `Some("IND")`
        pub const COUNTRY_AB3: Option<&str> = Some("IND");
        /// `Some("IN")`
        pub const COUNTRY_ABTWO: Option<&str> = Some("IN");
        /// `Some("IND")`
        pub const COUNTRY_CAR: Option<&str> = Some("IND");
        /// `None`
        pub const COUNTRY_ISBN: Option<&str> = None;
        /// `Some("भारत")`
        pub const COUNTRY_NAME: Option<&str> = Some("भारत");
        /// `Some(356)`
        pub const COUNTRY_NUM: Option<i64> = Some(356);
        /// `None`
        pub const COUNTRY_POST: Option<&str> = None;
        /// `None`
        pub const LANG_AB: Option<&str> = None;
        /// `Some("brx")`
        pub const LANG_LIB: Option<&str> = Some("brx");
        /// `Some("बड\u{93c}ो")`
        pub const LANG_NAME: Option<&str> = Some("बड\u{93c}ो");
        /// `Some("brx")`
        pub const LANG_TERM: Option<&str> = Some("brx");
        /// `Some("%z%c%T%s%b%e%r")`
        pub const POSTAL_FMT: Option<&str> = Some("%z%c%T%s%b%e%r");
    }
    pub mod LC_IDENTIFICATION {
        /// `None`
        pub const ABBREVIATION: Option<&str> = None;
        /// `Some("Level 1, Tower X, Cybercity, Magarpatta City, Hadapsar, Pune-411013 ")`
        pub const ADDRESS: Option<&str> = Some("Level 1, Tower X, Cybercity, Magarpatta City, Hadapsar, Pune-411013 ");
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        /// ]
        /// ```
        pub const CATEGORY: Option<&[&[&str]]> = Some(&[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_TELEPHONE"],
            &["i18n:2012", "LC_MEASUREMENT"],
        ]);
        /// `Some("")`
        pub const CONTACT: Option<&str> = Some("");
        /// `Some("2011-10-17")`
        pub const DATE: Option<&str> = Some("2011-10-17");
        /// `Some("bug-glibc-locales@gnu.org")`
        pub const EMAIL: Option<&str> = Some("bug-glibc-locales@gnu.org");
        /// `Some("")`
        pub const FAX: Option<&str> = Some("");
        /// `Some("Bodo")`
        pub const LANGUAGE: Option<&str> = Some("Bodo");
        /// `Some("1.0")`
        pub const REVISION: Option<&str> = Some("1.0");
        /// `Some("Red Hat Pune")`
        pub const SOURCE: Option<&str> = Some("Red Hat Pune");
        /// `Some("")`
        pub const TEL: Option<&str> = Some("");
        /// `Some("India")`
        pub const TERRITORY: Option<&str> = Some("India");
        /// `Some("Bodo language locale for India")`
        pub const TITLE: Option<&str> = Some("Bodo language locale for India");
    }
    pub mod LC_MESSAGES {
        /// `"^[-0nNन]"`
        pub const NOEXPR: &str = "^[-0nNन]";
        /// `Some("नही\u{902}")`
        pub const NOSTR: Option<&str> = Some("नही\u{902}");
        /// `"^[+1yYह]"`
        pub const YESEXPR: &str = "^[+1yYह]";
        /// `Some("हा\u{901}")`
        pub const YESSTR: Option<&str> = Some("हा\u{901}");
    }
    pub use super::hi_IN::LC_MONETARY;
    pub use super::hi_IN::LC_NUMERIC;
    pub use super::hi_IN::LC_TELEPHONE;
    pub mod LC_TIME {
        /// `&["रबि", "सम", "म\u{902}गल", "ब\u{941}द", "बिसथि", "स\u{941}ख\u{941}र", "स\u{941}नि"]`
        pub const ABDAY: &[&str] = &["रबि", "सम", "म\u{902}गल", "ब\u{941}द", "बिसथि", "स\u{941}ख\u{941}र", "स\u{941}नि"];
        /// `&["जान\u{941}वारी", "फ\u{947}ब\u{94d}र\u{941}वारी", "मार\u{94d}स", "एप\u{94d}रिल", "म\u{947}", "ज\u{941}न", "ज\u{941}लाइ", "आगस\u{94d}थ", "स\u{947}बथ\u{947}ज\u{94d}ब\u{93c}र", "अखथबर", "नब\u{947}ज\u{94d}ब\u{93c}र", "दिस\u{947}ज\u{94d}ब\u{93c}र"]`
        pub const ABMON: &[&str] = &["जान\u{941}वारी", "फ\u{947}ब\u{94d}र\u{941}वारी", "मार\u{94d}स", "एप\u{94d}रिल", "म\u{947}", "ज\u{941}न", "ज\u{941}लाइ", "आगस\u{94d}थ", "स\u{947}बथ\u{947}ज\u{94d}ब\u{93c}र", "अखथबर", "नब\u{947}ज\u{94d}ब\u{93c}र", "दिस\u{947}ज\u{94d}ब\u{93c}र"];
        /// `None`
        pub const AB_ALT_MON: Option<&[&str]> = None;
        /// `None`
        pub const ALT_DIGITS: Option<&[&str]> = None;
        /// `None`
        pub const ALT_MON: Option<&[&str]> = None;
        /// `&["फ\u{941}\u{902}.", "ब\u{947}लास\u{947}."]`
        pub const AM_PM: &[&str] = &["फ\u{941}\u{902}.", "ब\u{947}लास\u{947}."];
        /// `None`
        pub const CAL_DIRECTION: Option<i64> = None;
        /// `None`
        pub const DATE_FMT: Option<&str> = None;
        /// `&["रबिबार", "सोबार", "म\u{902}गलबार", "ब\u{941}दबार", "बिसथिबार", "स\u{941}ख\u{941}रबार", "स\u{941}निबार"]`
        pub const DAY: &[&str] = &["रबिबार", "सोबार", "म\u{902}गलबार", "ब\u{941}दबार", "बिसथिबार", "स\u{941}ख\u{941}रबार", "स\u{941}निबार"];
        /// `"%-m/%-d/%y"`
        pub const D_FMT: &str = "%-m/%-d/%y";
        /// `"%A %d %b %Y %I:%M:%S %p %Z"`
        pub const D_T_FMT: &str = "%A %d %b %Y %I:%M:%S %p %Z";
        /// `None`
        pub const ERA: Option<&[&str]> = None;
        /// `None`
        pub const ERA_D_FMT: Option<&str> = None;
        /// `None`
        pub const ERA_D_T_FMT: Option<&str> = None;
        /// `None`
        pub const ERA_T_FMT: Option<&str> = None;
        /// `None`
        pub const FIRST_WEEKDAY: Option<i64> = None;
        /// `None`
        pub const FIRST_WORKDAY: Option<i64> = None;
        /// `&["जान\u{941}वारी", "फ\u{947}ब\u{94d}र\u{941}वारी", "मार\u{94d}स", "एफ\u{94d}रिल", "म\u{947}", "ज\u{941}न", "ज\u{941}लाइ", "आगस\u{94d}थ", "स\u{947}बथ\u{947}ज\u{94d}ब\u{93c}र", "अखथबर", "नब\u{947}ज\u{94d}ब\u{93c}र", "दिस\u{947}ज\u{94d}ब\u{93c}र"]`
        pub const MON: &[&str] = &["जान\u{941}वारी", "फ\u{947}ब\u{94d}र\u{941}वारी", "मार\u{94d}स", "एफ\u{94d}रिल", "म\u{947}", "ज\u{941}न", "ज\u{941}लाइ", "आगस\u{94d}थ", "स\u{947}बथ\u{947}ज\u{94d}ब\u{93c}र", "अखथबर", "नब\u{947}ज\u{94d}ब\u{93c}र", "दिस\u{947}ज\u{94d}ब\u{93c}र"];
        /// `"%I:%M:%S %p %Z"`
        pub const T_FMT: &str = "%I:%M:%S %p %Z";
        /// `"%I:%M:%S %p %Z"`
        pub const T_FMT_AMPM: &str = "%I:%M:%S %p %Z";
        /// `Some(&[7, 19971130, 1])`
        pub const WEEK: Option<&[i64]> = Some(&[7, 19971130, 1]);
    }
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod bs_BA {
    pub mod LC_ADDRESS {
        /// `Some("BIH")`
        pub const COUNTRY_AB3: Option<&str> = Some("BIH");
        /// `Some("BA")`
        pub const COUNTRY_ABTWO: Option<&str> = Some("BA");
        /// `Some("BIH")`
        pub const COUNTRY_CAR: Option<&str> = Some("BIH");
        /// `None`
        pub const COUNTRY_ISBN: Option<&str> = None;
        /// `Some("Bosna i Hercegovina")`
        pub const COUNTRY_NAME: Option<&str> = Some("Bosna i Hercegovina");
        /// `Some(70)`
        pub const COUNTRY_NUM: Option<i64> = Some(70);
        /// `None`
        pub const COUNTRY_POST: Option<&str> = None;
        /// `Some("bs")`
        pub const LANG_AB: Option<&str> = Some("bs");
        /// `Some("bos")`
        pub const LANG_LIB: Option<&str> = Some("bos");
        /// `Some("bosanski")`
        pub const LANG_NAME: Option<&str> = Some("bosanski");
        /// `Some("bos")`
        pub const LANG_TERM: Option<&str> = Some("bos");
        /// `Some("%a%N%f%N%d%N%b%N%h %s %e %r%N%T %z%N%c%N")`
        pub const POSTAL_FMT: Option<&str> = Some("%a%N%f%N%d%N%b%N%h %s %e %r%N%T %z%N%c%N");
    }
    pub mod LC_IDENTIFICATION {
        /// `None`
        pub const ABBREVIATION: Option<&str> = None;
        /// `Some("")`
        pub const ADDRESS: Option<&str> = Some("");
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        /// ]
        /// ```
        pub const CATEGORY: Option<&[&[&str]]> = Some(&[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_TELEPHONE"],
            &["i18n:2012", "LC_MEASUREMENT"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_MESSAGES"],
        ]);
        /// `Some("Tomislav Vujec")`
        pub const CONTACT: Option<&str> = Some("Tomislav Vujec");
        /// `Some("2004-01-09")`
        pub const DATE: Option<&str> = Some("2004-01-09");
        /// `Some("tvujec@carnet.hr")`
        pub const EMAIL: Option<&str> = Some("tvujec@carnet.hr");
        /// `Some("")`
        pub const FAX: Option<&str> = Some("");
        /// `Some("Bosnian")`
        pub const LANGUAGE: Option<&str> = Some("Bosnian");
        /// `Some("0.4")`
        pub const REVISION: Option<&str> = Some("0.4");
        /// `Some("adapted from Croatian locale")`
        pub const SOURCE: Option<&str> = Some("adapted from Croatian locale");
        /// `Some("")`
        pub const TEL: Option<&str> = Some("");
        /// `Some("Bosnia & Herzegovina")`
        pub const TERRITORY: Option<&str> = Some("Bosnia & Herzegovina");
        /// `Some("Bosnian language locale for Bosnia and Herzegowina")`
        pub const TITLE: Option<&str> = Some("Bosnian language locale for Bosnia and Herzegowina");
    }
    pub mod LC_MESSAGES {
        /// `"^[-0nN]"`
        pub const NOEXPR: &str = "^[-0nN]";
        /// `Some("ne")`
        pub const NOSTR: Option<&str> = Some("ne");
        /// `"^[+1dDyY]"`
        pub const YESEXPR: &str = "^[+1dDyY]";
        /// `Some("da")`
        pub const YESSTR: Option<&str> = Some("da");
    }
    pub mod LC_MONETARY {
        /// `"KM"`
        pub const CURRENCY_SYMBOL: &str = "KM";
        /// `2`
        pub const FRAC_DIGITS: i64 = 2;
        /// `"BAM "`
        pub const INT_CURR_SYMBOL: &str = "BAM ";
        /// `2`
        pub const INT_FRAC_DIGITS: i64 = 2;
        /// `None`
        pub const INT_N_CS_PRECEDES: Option<i64> = None;
        /// `None`
        pub const INT_N_SEP_BY_SPACE: Option<i64> = None;
        /// `None`
        pub const INT_N_SIGN_POSN: Option<i64> = None;
        /// `None`
        pub const INT_P_CS_PRECEDES: Option<i64> = None;
        /// `None`
        pub const INT_P_SEP_BY_SPACE: Option<i64> = None;
        /// `None`
        pub const INT_P_SIGN_POSN: Option<i64> = None;
        /// `","`
        pub const MON_DECIMAL_POINT: &str = ",";
        /// `&[3, 3]`
        pub const MON_GROUPING: &[i64] = &[3, 3];
        /// `"\u{202f}"`
        pub const MON_THOUSANDS_SEP: &str = "\u{202f}";
        /// `"-"`
        pub const NEGATIVE_SIGN: &str = "-";
        /// `1`
        pub const N_CS_PRECEDES: i64 = 1;
        /// `1`
        pub const N_SEP_BY_SPACE: i64 = 1;
        /// `1`
        pub const N_SIGN_POSN: i64 = 1;
        /// `""`
        pub const POSITIVE_SIGN: &str = "";
        /// `1`
        pub const P_CS_PRECEDES: i64 = 1;
        /// `1`
        pub const P_SEP_BY_SPACE: i64 = 1;
        /// `1`
        pub const P_SIGN_POSN: i64 = 1;
    }
    pub mod LC_NUMERIC {
        /// `","`
        pub const DECIMAL_POINT: &str = ",";
        /// `&[0, 0]`
        pub const GROUPING: &[i64] = &[0, 0];
        /// `""`
        pub const THOUSANDS_SEP: &str = "";
    }
    pub mod LC_TELEPHONE {
        /// `Some("387")`
        pub const INT_PREFIX: Option<&str> = Some("387");
        /// `Some("00")`
        pub const INT_SELECT: Option<&str> = Some("00");
        /// `None`
        pub const TEL_DOM_FMT: Option<&str> = None;
        /// `Some("+%c %a %l")`
        pub const TEL_INT_FMT: Option<&str> = Some("+%c %a %l");
    }
    pub mod LC_TIME {
        /// `&["Ned", "Pon", "Uto", "Sri", "Čet", "Pet", "Sub"]`
        pub const ABDAY: &[&str] = &["Ned", "Pon", "Uto", "Sri", "Čet", "Pet", "Sub"];
        /// `&["Jan", "Feb", "Mar", "Apr", "Maj", "Jun", "Jul", "Aug", "Sep", "Okt", "Nov", "Dec"]`
        pub const ABMON: &[&str] = &["Jan", "Feb", "Mar", "Apr", "Maj", "Jun", "Jul", "Aug", "Sep", "Okt", "Nov", "Dec"];
        /// `None`
        pub const AB_ALT_MON: Option<&[&str]> = None;
        /// `None`
        pub const ALT_DIGITS: Option<&[&str]> = None;
        /// `None`
        pub const ALT_MON: Option<&[&str]> = None;
        /// `&["", ""]`
        pub const AM_PM: &[&str] = &["", ""];
        /// `None`
        pub const CAL_DIRECTION: Option<i64> = None;
        /// `None`
        pub const DATE_FMT: Option<&str> = None;
        /// `&["Nedjelja", "Ponedjeljak", "Utorak", "Srijeda", "Četvrtak", "Petak", "Subota"]`
        pub const DAY: &[&str] = &["Nedjelja", "Ponedjeljak", "Utorak", "Srijeda", "Četvrtak", "Petak", "Subota"];
        /// `"%d.%m.%Y"`
        pub const D_FMT: &str = "%d.%m.%Y";
        /// `"%a %d %b %Y %T"`
        pub const D_T_FMT: &str = "%a %d %b %Y %T";
        /// `None`
        pub const ERA: Option<&[&str]> = None;
        /// `None`
        pub const ERA_D_FMT: Option<&str> = None;
        /// `None`
        pub const ERA_D_T_FMT: Option<&str> = None;
        /// `None`
        pub const ERA_T_FMT: Option<&str> = None;
        /// `Some(2)`
        pub const FIRST_WEEKDAY: Option<i64> = Some(2);
        /// `None`
        pub const FIRST_WORKDAY: Option<i64> = None;
        /// `&["Januar", "Februar", "Mart", "April", "Maj", "Juni", "Juli", "August", "Septembar", "Oktobar", "Novembar", "Decembar"]`
        pub const MON: &[&str] = &["Januar", "Februar", "Mart", "April", "Maj", "Juni", "Juli", "August", "Septembar", "Oktobar", "Novembar", "Decembar"];
        /// `"%T"`
        pub const T_FMT: &str = "%T";
        /// `""`
        pub const T_FMT_AMPM: &str = "";
        /// `Some(&[7, 19971130, 1])`
        pub const WEEK: Option<&[i64]> = Some(&[7, 19971130, 1]);
    }
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod byn_ER {
    pub mod LC_ADDRESS {
        /// `Some("ERI")`
        pub const COUNTRY_AB3: Option<&str> = Some("ERI");
        /// `Some("ER")`
        pub const COUNTRY_ABTWO: Option<&str> = Some("ER");
        /// `Some("ER")`
        pub const COUNTRY_CAR: Option<&str> = Some("ER");
        /// `None`
        pub const COUNTRY_ISBN: Option<&str> = None;
        /// `Some("ኤርትራ")`
        pub const COUNTRY_NAME: Option<&str> = Some("ኤርትራ");
        /// `Some(232)`
        pub const COUNTRY_NUM: Option<i64> = Some(232);
        /// `Some("ERI")`
        pub const COUNTRY_POST: Option<&str> = Some("ERI");
        /// `Some("")`
        pub const LANG_AB: Option<&str> = Some("");
        /// `Some("byn")`
        pub const LANG_LIB: Option<&str> = Some("byn");
        /// `Some("ብሊን")`
        pub const LANG_NAME: Option<&str> = Some("ብሊን");
        /// `Some("byn")`
        pub const LANG_TERM: Option<&str> = Some("byn");
        /// `Some("%z%c%T%s%b%e%r")`
        pub const POSTAL_FMT: Option<&str> = Some("%z%c%T%s%b%e%r");
    }
    pub mod LC_IDENTIFICATION {
        /// `None`
        pub const ABBREVIATION: Option<&str> = None;
        /// `Some("7802 Solomon Seal Dr., Springfield, VA 22152, USA")`
        pub const ADDRESS: Option<&str> = Some("7802 Solomon Seal Dr., Springfield, VA 22152, USA");
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_TIME"],
        /// ]
        /// ```
        pub const CATEGORY: Option<&[&[&str]]> = Some(&[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_MEASUREMENT"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_TELEPHONE"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_TIME"],
        ]);
        /// `Some("")`
        pub const CONTACT: Option<&str> = Some("");
        /// `Some("2003-11-01")`
        pub const DATE: Option<&str> = Some("2003-11-01");
        /// `Some("locales@geez.org")`
        pub const EMAIL: Option<&str> = Some("locales@geez.org");
        /// `Some("")`
        pub const FAX: Option<&str> = Some("");
        /// `Some("Blin")`
        pub const LANGUAGE: Option<&str> = Some("Blin");
        /// `Some("0.21")`
        pub const REVISION: Option<&str> = Some("0.21");
        /// `Some("Ge'ez Frontier Foundation")`
        pub const SOURCE: Option<&str> = Some("Ge'ez Frontier Foundation");
        /// `Some("")`
        pub const TEL: Option<&str> = Some("");
        /// `Some("Eritrea")`
        pub const TERRITORY: Option<&str> = Some("Eritrea");
        /// `Some("Blin language locale for Eritrea")`
        pub const TITLE: Option<&str> = Some("Blin language locale for Eritrea");
    }
    pub use super::ti_ER::LC_MESSAGES;
    pub use super::ti_ER::LC_MONETARY;
    pub use super::ti_ER::LC_NUMERIC;
    pub use super::ti_ER::LC_TELEPHONE;
    pub mod LC_TIME {
        /// `&["ሰ/ቅ", "ሰኑ", "ሰሊጝ", "ለጓ", "ኣምድ", "ኣርብ", "ሰ/ሽ"]`
        pub const ABDAY: &[&str] = &["ሰ/ቅ", "ሰኑ", "ሰሊጝ", "ለጓ", "ኣምድ", "ኣርብ", "ሰ/ሽ"];
        /// `&["ልደት", "ካብኽ", "ክብላ", "ፋጅኺ", "ክቢቅ", "ም/ት", "ኰር", "ማርያ", "ያኸኒ", "መተሉ", "ም/ም", "ተሕሳ"]`
        pub const ABMON: &[&str] = &["ልደት", "ካብኽ", "ክብላ", "ፋጅኺ", "ክቢቅ", "ም/ት", "ኰር", "ማርያ", "ያኸኒ", "መተሉ", "ም/ም", "ተሕሳ"];
        /// `None`
        pub const AB_ALT_MON: Option<&[&str]> = None;
        /// `None`
        pub const ALT_DIGITS: Option<&[&str]> = None;
        /// `None`
        pub const ALT_MON: Option<&[&str]> = None;
        /// `&["ፋዱስ ጃብ", "ፋዱስ ደምቢ"]`
        pub const AM_PM: &[&str] = &["ፋዱስ ጃብ", "ፋዱስ ደምቢ"];
        /// `None`
        pub const CAL_DIRECTION: Option<i64> = None;
        /// `Some("%A፡ %B %e ግርጋ %r %Z %Y ኣድ")`
        pub const DATE_FMT: Option<&str> = Some("%A፡ %B %e ግርጋ %r %Z %Y ኣድ");
        /// `&["ሰንበር ቅዳዅ", "ሰኑ", "ሰሊጝ", "ለጓ ወሪ ለብዋ", "ኣምድ", "ኣርብ", "ሰንበር ሽጓዅ"]`
        pub const DAY: &[&str] = &["ሰንበር ቅዳዅ", "ሰኑ", "ሰሊጝ", "ለጓ ወሪ ለብዋ", "ኣምድ", "ኣርብ", "ሰንበር ሽጓዅ"];
        /// `"%d/%m/%Y"`
        pub const D_FMT: &str = "%d/%m/%Y";
        /// `"%A፡ %B %e ግርጋ %Y %l:%M:%S %p %Z"`
        pub const D_T_FMT: &str = "%A፡ %B %e ግርጋ %Y %l:%M:%S %p %Z";
        /// `None`
        pub const ERA: Option<&[&str]> = None;
        /// `None`
        pub const ERA_D_FMT: Option<&str> = None;
        /// `None`
        pub const ERA_D_T_FMT: Option<&str> = None;
        /// `None`
        pub const ERA_T_FMT: Option<&str> = None;
        /// `Some(2)`
        pub const FIRST_WEEKDAY: Option<i64> = Some(2);
        /// `None`
        pub const FIRST_WORKDAY: Option<i64> = None;
        /// `&["ልደትሪ", "ካብኽብቲ", "ክብላ", "ፋጅኺሪ", "ክቢቅሪ", "ምኪኤል ትጓ\u{305}ኒሪ", "ኰርኩ", "ማርያም ትሪ", "ያኸኒ መሳቅለሪ", "መተሉ", "ምኪኤል መሽወሪ", "ተሕሳስሪ"]`
        pub const MON: &[&str] = &["ልደትሪ", "ካብኽብቲ", "ክብላ", "ፋጅኺሪ", "ክቢቅሪ", "ምኪኤል ትጓ\u{305}ኒሪ", "ኰርኩ", "ማርያም ትሪ", "ያኸኒ መሳቅለሪ", "መተሉ", "ምኪኤል መሽወሪ", "ተሕሳስሪ"];
        /// `"%l:%M:%S %p"`
        pub const T_FMT: &str = "%l:%M:%S %p";
        /// `"%l:%M:%S %p"`
        pub const T_FMT_AMPM: &str = "%l:%M:%S %p";
        /// `Some(&[7, 19971130, 1])`
        pub const WEEK: Option<&[i64]> = Some(&[7, 19971130, 1]);
    }
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod ca_AD {
    pub mod LC_ADDRESS {
        /// `Some("AND")`
        pub const COUNTRY_AB3: Option<&str> = Some("AND");
        /// `Some("AD")`
        pub const COUNTRY_ABTWO: Option<&str> = Some("AD");
        /// `Some("AND")`
        pub const COUNTRY_CAR: Option<&str> = Some("AND");
        /// `None`
        pub const COUNTRY_ISBN: Option<&str> = None;
        /// `Some("Andorra")`
        pub const COUNTRY_NAME: Option<&str> = Some("Andorra");
        /// `Some(20)`
        pub const COUNTRY_NUM: Option<i64> = Some(20);
        /// `None`
        pub const COUNTRY_POST: Option<&str> = None;
        /// `Some("ca")`
        pub const LANG_AB: Option<&str> = Some("ca");
        /// `Some("cat")`
        pub const LANG_LIB: Option<&str> = Some("cat");
        /// `Some("català")`
        pub const LANG_NAME: Option<&str> = Some("català");
        /// `Some("cat")`
        pub const LANG_TERM: Option<&str> = Some("cat");
        /// `Some("%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%c%N")`
        pub const POSTAL_FMT: Option<&str> = Some("%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%c%N");
    }
    pub mod LC_IDENTIFICATION {
        /// `None`
        pub const ABBREVIATION: Option<&str> = None;
        /// `Some("")`
        pub const ADDRESS: Option<&str> = Some("");
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        /// ]
        /// ```
        pub const CATEGORY: Option<&[&[&str]]> = Some(&[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_TELEPHONE"],
            &["i18n:2012", "LC_MEASUREMENT"],
        ]);
        /// `Some("")`
        pub const CONTACT: Option<&str> = Some("");
        /// `Some("2006-01-16")`
        pub const DATE: Option<&str> = Some("2006-01-16");
        /// `Some("")`
        pub const EMAIL: Option<&str> = Some("");
        /// `Some("")`
        pub const FAX: Option<&str> = Some("");
        /// `Some("Catalan")`
        pub const LANGUAGE: Option<&str> = Some("Catalan");
        /// `Some("1.0")`
        pub const REVISION: Option<&str> = Some("1.0");
        /// `Some("Robert Millan")`
        pub const SOURCE: Option<&str> = Some("Robert Millan");
        /// `Some("")`
        pub const TEL: Option<&str> = Some("");
        /// `Some("Andorra")`
        pub const TERRITORY: Option<&str> = Some("Andorra");
        /// `Some("Catalan locale for Andorra ")`
        pub const TITLE: Option<&str> = Some("Catalan locale for Andorra ");
    }
    pub use super::ca_ES::LC_MESSAGES;
    pub use super::ca_ES::LC_MONETARY;
    pub use super::ca_ES::LC_NUMERIC;
    pub mod LC_TELEPHONE {
        /// `Some("376")`
        pub const INT_PREFIX: Option<&str> = Some("376");
        /// `Some("00")`
        pub const INT_SELECT: Option<&str> = Some("00");
        /// `None`
        pub const TEL_DOM_FMT: Option<&str> = None;
        /// `Some("+%c %a %l")`
        pub const TEL_INT_FMT: Option<&str> = Some("+%c %a %l");
    }
    pub use super::ca_ES::LC_TIME;
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod ca_ES {
    pub mod LC_ADDRESS {
        /// `Some("ESP")`
        pub const COUNTRY_AB3: Option<&str> = Some("ESP");
        /// `Some("ES")`
        pub const COUNTRY_ABTWO: Option<&str> = Some("ES");
        /// `Some("E")`
        pub const COUNTRY_CAR: Option<&str> = Some("E");
        /// `None`
        pub const COUNTRY_ISBN: Option<&str> = None;
        /// `Some("Espanya")`
        pub const COUNTRY_NAME: Option<&str> = Some("Espanya");
        /// `Some(724)`
        pub const COUNTRY_NUM: Option<i64> = Some(724);
        /// `None`
        pub const COUNTRY_POST: Option<&str> = None;
        /// `Some("ca")`
        pub const LANG_AB: Option<&str> = Some("ca");
        /// `Some("cat")`
        pub const LANG_LIB: Option<&str> = Some("cat");
        /// `Some("català")`
        pub const LANG_NAME: Option<&str> = Some("català");
        /// `Some("cat")`
        pub const LANG_TERM: Option<&str> = Some("cat");
        /// `Some("%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%c%N")`
        pub const POSTAL_FMT: Option<&str> = Some("%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%c%N");
    }
    pub mod LC_IDENTIFICATION {
        /// `None`
        pub const ABBREVIATION: Option<&str> = None;
        /// `Some("")`
        pub const ADDRESS: Option<&str> = Some("");
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        /// ]
        /// ```
        pub const CATEGORY: Option<&[&[&str]]> = Some(&[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_TELEPHONE"],
            &["i18n:2012", "LC_MEASUREMENT"],
        ]);
        /// `Some("")`
        pub const CONTACT: Option<&str> = Some("");
        /// `Some("2000-06-29")`
        pub const DATE: Option<&str> = Some("2000-06-29");
        /// `Some("bug-glibc-locales@gnu.org")`
        pub const EMAIL: Option<&str> = Some("bug-glibc-locales@gnu.org");
        /// `Some("")`
        pub const FAX: Option<&str> = Some("");
        /// `Some("Catalan")`
        pub const LANGUAGE: Option<&str> = Some("Catalan");
        /// `Some("1.0")`
        pub const REVISION: Option<&str> = Some("1.0");
        /// `Some("RAP")`
        pub const SOURCE: Option<&str> = Some("RAP");
        /// `Some("")`
        pub const TEL: Option<&str> = Some("");
        /// `Some("Spain")`
        pub const TERRITORY: Option<&str> = Some("Spain");
        /// `Some("Catalan locale for Spain")`
        pub const TITLE: Option<&str> = Some("Catalan locale for Spain");
    }
    pub mod LC_MESSAGES {
        /// `"^[-0nN]"`
        pub const NOEXPR: &str = "^[-0nN]";
        /// `Some("no")`
        pub const NOSTR: Option<&str> = Some("no");
        /// `"^[+1sSyY]"`
        pub const YESEXPR: &str = "^[+1sSyY]";
        /// `Some("sí")`
        pub const YESSTR: Option<&str> = Some("sí");
    }
    pub mod LC_MONETARY {
        /// `"€"`
        pub const CURRENCY_SYMBOL: &str = "€";
        /// `2`
        pub const FRAC_DIGITS: i64 = 2;
        /// `"EUR "`
        pub const INT_CURR_SYMBOL: &str = "EUR ";
        /// `2`
        pub const INT_FRAC_DIGITS: i64 = 2;
        /// `None`
        pub const INT_N_CS_PRECEDES: Option<i64> = None;
        /// `None`
        pub const INT_N_SEP_BY_SPACE: Option<i64> = None;
        /// `None`
        pub const INT_N_SIGN_POSN: Option<i64> = None;
        /// `None`
        pub const INT_P_CS_PRECEDES: Option<i64> = None;
        /// `None`
        pub const INT_P_SEP_BY_SPACE: Option<i64> = None;
        /// `None`
        pub const INT_P_SIGN_POSN: Option<i64> = None;
        /// `","`
        pub const MON_DECIMAL_POINT: &str = ",";
        /// `&[3, 3]`
        pub const MON_GROUPING: &[i64] = &[3, 3];
        /// `"."`
        pub const MON_THOUSANDS_SEP: &str = ".";
        /// `"-"`
        pub const NEGATIVE_SIGN: &str = "-";
        /// `0`
        pub const N_CS_PRECEDES: i64 = 0;
        /// `1`
        pub const N_SEP_BY_SPACE: i64 = 1;
        /// `1`
        pub const N_SIGN_POSN: i64 = 1;
        /// `""`
        pub const POSITIVE_SIGN: &str = "";
        /// `0`
        pub const P_CS_PRECEDES: i64 = 0;
        /// `1`
        pub const P_SEP_BY_SPACE: i64 = 1;
        /// `1`
        pub const P_SIGN_POSN: i64 = 1;
    }
    pub mod LC_NUMERIC {
        /// `","`
        pub const DECIMAL_POINT: &str = ",";
        /// `&[3, 3]`
        pub const GROUPING: &[i64] = &[3, 3];
        /// `"."`
        pub const THOUSANDS_SEP: &str = ".";
    }
    pub mod LC_TELEPHONE {
        /// `Some("34")`
        pub const INT_PREFIX: Option<&str> = Some("34");
        /// `Some("00")`
        pub const INT_SELECT: Option<&str> = Some("00");
        /// `None`
        pub const TEL_DOM_FMT: Option<&str> = None;
        /// `Some("+%c %a %l")`
        pub const TEL_INT_FMT: Option<&str> = Some("+%c %a %l");
    }
    pub mod LC_TIME {
        /// `&["dg.", "dl.", "dt.", "dc.", "dj.", "dv.", "ds."]`
        pub const ABDAY: &[&str] = &["dg.", "dl.", "dt.", "dc.", "dj.", "dv.", "ds."];
        /// `&["de gen.", "de febr.", "de març", "d’abr.", "de maig", "de juny", "de jul.", "d’ag.", "de set.", "d’oct.", "de nov.", "de des."]`
        pub const ABMON: &[&str] = &["de gen.", "de febr.", "de març", "d’abr.", "de maig", "de juny", "de jul.", "d’ag.", "de set.", "d’oct.", "de nov.", "de des."];
        /// `Some(&["gen.", "febr.", "març", "abr.", "maig", "juny", "jul.", "ag.", "set.", "oct.", "nov.", "des."])`
        pub const AB_ALT_MON: Option<&[&str]> = Some(&["gen.", "febr.", "març", "abr.", "maig", "juny", "jul.", "ag.", "set.", "oct.", "nov.", "des."]);
        /// `None`
        pub const ALT_DIGITS: Option<&[&str]> = None;
        /// `Some(&["gener", "febrer", "març", "abril", "maig", "juny", "juliol", "agost", "setembre", "octubre", "novembre", "desembre"])`
        pub const ALT_MON: Option<&[&str]> = Some(&["gener", "febrer", "març", "abril", "maig", "juny", "juliol", "agost", "setembre", "octubre", "novembre", "desembre"]);
        /// `&["a. m.", "p. m."]`
        pub const AM_PM: &[&str] = &["a. m.", "p. m."];
        /// `None`
        pub const CAL_DIRECTION: Option<i64> = None;
        /// `None`
        pub const DATE_FMT: Option<&str> = None;
        /// `&["diumenge", "dilluns", "dimarts", "dimecres", "dijous", "divendres", "dissabte"]`
        pub const DAY: &[&str] = &["diumenge", "dilluns", "dimarts", "dimecres", "dijous", "divendres", "dissabte"];
        /// `"%-d/%-m/%y"`
        pub const D_FMT: &str = "%-d/%-m/%y";
        /// `"%A, %-d %B de %Y, %T %Z"`
        pub const D_T_FMT: &str = "%A, %-d %B de %Y, %T %Z";
        /// `None`
        pub const ERA: Option<&[&str]> = None;
        /// `None`
        pub const ERA_D_FMT: Option<&str> = None;
        /// `None`
        pub const ERA_D_T_FMT: Option<&str> = None;
        /// `None`
        pub const ERA_T_FMT: Option<&str> = None;
        /// `Some(2)`
        pub const FIRST_WEEKDAY: Option<i64> = Some(2);
        /// `None`
        pub const FIRST_WORKDAY: Option<i64> = None;
        /// `&["de gener", "de febrer", "de març", "d’abril", "de maig", "de juny", "de juliol", "d’agost", "de setembre", "d’octubre", "de novembre", "de desembre"]`
        pub const MON: &[&str] = &["de gener", "de febrer", "de març", "d’abril", "de maig", "de juny", "de juliol", "d’agost", "de setembre", "d’octubre", "de novembre", "de desembre"];
        /// `"%T"`
        pub const T_FMT: &str = "%T";
        /// `"%l:%M:%S %p"`
        pub const T_FMT_AMPM: &str = "%l:%M:%S %p";
        /// `Some(&[7, 19971130, 4])`
        pub const WEEK: Option<&[i64]> = Some(&[7, 19971130, 4]);
    }
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod ca_ES_euro {
    pub use super::ca_ES::LC_ADDRESS;
    pub mod LC_IDENTIFICATION {
        /// `None`
        pub const ABBREVIATION: Option<&str> = None;
        /// `Some("https://www.gnu.org/software/libc/")`
        pub const ADDRESS: Option<&str> = Some("https://www.gnu.org/software/libc/");
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        /// ]
        /// ```
        pub const CATEGORY: Option<&[&[&str]]> = Some(&[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_TELEPHONE"],
            &["i18n:2012", "LC_MEASUREMENT"],
        ]);
        /// `Some("")`
        pub const CONTACT: Option<&str> = Some("");
        /// `Some("2000-08-20")`
        pub const DATE: Option<&str> = Some("2000-08-20");
        /// `Some("bug-glibc-locales@gnu.org")`
        pub const EMAIL: Option<&str> = Some("bug-glibc-locales@gnu.org");
        /// `Some("")`
        pub const FAX: Option<&str> = Some("");
        /// `Some("Catalan")`
        pub const LANGUAGE: Option<&str> = Some("Catalan");
        /// `Some("1.0")`
        pub const REVISION: Option<&str> = Some("1.0");
        /// `Some("Free Software Foundation, Inc.")`
        pub const SOURCE: Option<&str> = Some("Free Software Foundation, Inc.");
        /// `Some("")`
        pub const TEL: Option<&str> = Some("");
        /// `Some("Spain")`
        pub const TERRITORY: Option<&str> = Some("Spain");
        /// `Some("Catalan locale for Catalonia with Euro")`
        pub const TITLE: Option<&str> = Some("Catalan locale for Catalonia with Euro");
    }
    pub use super::ca_ES::LC_MESSAGES;
    pub use super::ca_ES::LC_MONETARY;
    pub use super::ca_ES::LC_NUMERIC;
    pub use super::ca_ES::LC_TELEPHONE;
    pub use super::ca_ES::LC_TIME;
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod ca_ES_valencia {
    pub use super::ca_ES::LC_ADDRESS;
    pub mod LC_IDENTIFICATION {
        /// `None`
        pub const ABBREVIATION: Option<&str> = None;
        /// `Some("")`
        pub const ADDRESS: Option<&str> = Some("");
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        /// ]
        /// ```
        pub const CATEGORY: Option<&[&[&str]]> = Some(&[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_TELEPHONE"],
            &["i18n:2012", "LC_MEASUREMENT"],
        ]);
        /// `Some("Jordi Mallach")`
        pub const CONTACT: Option<&str> = Some("Jordi Mallach");
        /// `Some("2006-04-06")`
        pub const DATE: Option<&str> = Some("2006-04-06");
        /// `Some("jordi@gnu.org")`
        pub const EMAIL: Option<&str> = Some("jordi@gnu.org");
        /// `Some("")`
        pub const FAX: Option<&str> = Some("");
        /// `Some("Catalan")`
        pub const LANGUAGE: Option<&str> = Some("Catalan");
        /// `Some("1.0")`
        pub const REVISION: Option<&str> = Some("1.0");
        /// `Some("")`
        pub const SOURCE: Option<&str> = Some("");
        /// `Some("")`
        pub const TEL: Option<&str> = Some("");
        /// `Some("Spain")`
        pub const TERRITORY: Option<&str> = Some("Spain");
        /// `Some("Valencian (southern Catalan) locale for Spain with Euro")`
        pub const TITLE: Option<&str> = Some("Valencian (southern Catalan) locale for Spain with Euro");
    }
    pub use super::ca_ES::LC_MESSAGES;
    pub use super::ca_ES::LC_MONETARY;
    pub use super::ca_ES::LC_NUMERIC;
    pub use super::ca_ES::LC_TELEPHONE;
    pub use super::ca_ES::LC_TIME;
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod ca_FR {
    pub mod LC_ADDRESS {
        /// `Some("FRA")`
        pub const COUNTRY_AB3: Option<&str> = Some("FRA");
        /// `Some("FR")`
        pub const COUNTRY_ABTWO: Option<&str> = Some("FR");
        /// `Some("F")`
        pub const COUNTRY_CAR: Option<&str> = Some("F");
        /// `Some("979-10")`
        pub const COUNTRY_ISBN: Option<&str> = Some("979-10");
        /// `Some("França")`
        pub const COUNTRY_NAME: Option<&str> = Some("França");
        /// `Some(250)`
        pub const COUNTRY_NUM: Option<i64> = Some(250);
        /// `None`
        pub const COUNTRY_POST: Option<&str> = None;
        /// `Some("ca")`
        pub const LANG_AB: Option<&str> = Some("ca");
        /// `Some("cat")`
        pub const LANG_LIB: Option<&str> = Some("cat");
        /// `Some("català")`
        pub const LANG_NAME: Option<&str> = Some("català");
        /// `Some("cat")`
        pub const LANG_TERM: Option<&str> = Some("cat");
        /// `Some("%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%c%N")`
        pub const POSTAL_FMT: Option<&str> = Some("%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%c%N");
    }
    pub mod LC_IDENTIFICATION {
        /// `None`
        pub const ABBREVIATION: Option<&str> = None;
        /// `Some("")`
        pub const ADDRESS: Option<&str> = Some("");
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        /// ]
        /// ```
        pub const CATEGORY: Option<&[&[&str]]> = Some(&[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_TELEPHONE"],
            &["i18n:2012", "LC_MEASUREMENT"],
        ]);
        /// `Some("")`
        pub const CONTACT: Option<&str> = Some("");
        /// `Some("2006-01-16")`
        pub const DATE: Option<&str> = Some("2006-01-16");
        /// `Some("")`
        pub const EMAIL: Option<&str> = Some("");
        /// `Some("")`
        pub const FAX: Option<&str> = Some("");
        /// `Some("Catalan")`
        pub const LANGUAGE: Option<&str> = Some("Catalan");
        /// `Some("1.0")`
        pub const REVISION: Option<&str> = Some("1.0");
        /// `Some("Robert Millan")`
        pub const SOURCE: Option<&str> = Some("Robert Millan");
        /// `Some("")`
        pub const TEL: Option<&str> = Some("");
        /// `Some("France")`
        pub const TERRITORY: Option<&str> = Some("France");
        /// `Some("Catalan locale for France ")`
        pub const TITLE: Option<&str> = Some("Catalan locale for France ");
    }
    pub use super::ca_ES::LC_MESSAGES;
    pub use super::ca_ES::LC_MONETARY;
    pub use super::ca_ES::LC_NUMERIC;
    pub use super::fr_FR::LC_TELEPHONE;
    pub use super::ca_ES::LC_TIME;
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod ca_IT {
    pub mod LC_ADDRESS {
        /// `Some("ITA")`
        pub const COUNTRY_AB3: Option<&str> = Some("ITA");
        /// `Some("IT")`
        pub const COUNTRY_ABTWO: Option<&str> = Some("IT");
        /// `Some("I")`
        pub const COUNTRY_CAR: Option<&str> = Some("I");
        /// `Some("978-88,979-12")`
        pub const COUNTRY_ISBN: Option<&str> = Some("978-88,979-12");
        /// `Some("Itàlia")`
        pub const COUNTRY_NAME: Option<&str> = Some("Itàlia");
        /// `Some(380)`
        pub const COUNTRY_NUM: Option<i64> = Some(380);
        /// `None`
        pub const COUNTRY_POST: Option<&str> = None;
        /// `Some("ca")`
        pub const LANG_AB: Option<&str> = Some("ca");
        /// `Some("cat")`
        pub const LANG_LIB: Option<&str> = Some("cat");
        /// `Some("català")`
        pub const LANG_NAME: Option<&str> = Some("català");
        /// `Some("cat")`
        pub const LANG_TERM: Option<&str> = Some("cat");
        /// `Some("%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%c%N")`
        pub const POSTAL_FMT: Option<&str> = Some("%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%c%N");
    }
    pub mod LC_IDENTIFICATION {
        /// `None`
        pub const ABBREVIATION: Option<&str> = None;
        /// `Some("")`
        pub const ADDRESS: Option<&str> = Some("");
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        /// ]
        /// ```
        pub const CATEGORY: Option<&[&[&str]]> = Some(&[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_TELEPHONE"],
            &["i18n:2012", "LC_MEASUREMENT"],
        ]);
        /// `Some("")`
        pub const CONTACT: Option<&str> = Some("");
        /// `Some("2006-01-16")`
        pub const DATE: Option<&str> = Some("2006-01-16");
        /// `Some("")`
        pub const EMAIL: Option<&str> = Some("");
        /// `Some("")`
        pub const FAX: Option<&str> = Some("");
        /// `Some("Catalan")`
        pub const LANGUAGE: Option<&str> = Some("Catalan");
        /// `Some("1.0")`
        pub const REVISION: Option<&str> = Some("1.0");
        /// `Some("Robert Millan")`
        pub const SOURCE: Option<&str> = Some("Robert Millan");
        /// `Some("")`
        pub const TEL: Option<&str> = Some("");
        /// `Some("Italy")`
        pub const TERRITORY: Option<&str> = Some("Italy");
        /// `Some("Catalan locale for Italy (L'Alguer) ")`
        pub const TITLE: Option<&str> = Some("Catalan locale for Italy (L'Alguer) ");
    }
    pub use super::ca_ES::LC_MESSAGES;
    pub use super::ca_ES::LC_MONETARY;
    pub use super::ca_ES::LC_NUMERIC;
    pub use super::it_IT::LC_TELEPHONE;
    pub use super::ca_ES::LC_TIME;
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod ce_RU {
    pub mod LC_ADDRESS {
        /// `Some("RUS")`
        pub const COUNTRY_AB3: Option<&str> = Some("RUS");
        /// `Some("RU")`
        pub const COUNTRY_ABTWO: Option<&str> = Some("RU");
        /// `Some("RUS")`
        pub const COUNTRY_CAR: Option<&str> = Some("RUS");
        /// `None`
        pub const COUNTRY_ISBN: Option<&str> = None;
        /// `Some("Росси")`
        pub const COUNTRY_NAME: Option<&str> = Some("Росси");
        /// `Some(643)`
        pub const COUNTRY_NUM: Option<i64> = Some(643);
        /// `None`
        pub const COUNTRY_POST: Option<&str> = None;
        /// `Some("ce")`
        pub const LANG_AB: Option<&str> = Some("ce");
        /// `None`
        pub const LANG_LIB: Option<&str> = None;
        /// `Some("нохчийн")`
        pub const LANG_NAME: Option<&str> = Some("нохчийн");
        /// `Some("che")`
        pub const LANG_TERM: Option<&str> = Some("che");
        /// `Some("%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%c%N")`
        pub const POSTAL_FMT: Option<&str> = Some("%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%c%N");
    }
    pub mod LC_IDENTIFICATION {
        /// `None`
        pub const ABBREVIATION: Option<&str> = None;
        /// `Some("364024, ChR, Grozny, pr-kt of M. Esambayev, 13")`
        pub const ADDRESS: Option<&str> = Some("364024, ChR, Grozny, pr-kt of M. Esambayev, 13");
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        /// ]
        /// ```
        pub const CATEGORY: Option<&[&[&str]]> = Some(&[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_MEASUREMENT"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_TELEPHONE"],
        ]);
        /// `None`
        pub const CONTACT: Option<&str> = None;
        /// `Some("2014-08-25")`
        pub const DATE: Option<&str> = Some("2014-08-25");
        /// `None`
        pub const EMAIL: Option<&str> = None;
        /// `None`
        pub const FAX: Option<&str> = None;
        /// `Some("Chechen")`
        pub const LANGUAGE: Option<&str> = Some("Chechen");
        /// `Some("1.0")`
        pub const REVISION: Option<&str> = Some("1.0");
        /// `Some("ANCHR")`
        pub const SOURCE: Option<&str> = Some("ANCHR");
        /// `None`
        pub const TEL: Option<&str> = None;
        /// `Some("Russia")`
        pub const TERRITORY: Option<&str> = Some("Russia");
        /// `Some("Chechen locale for RUSSIAN FEDERATION")`
        pub const TITLE: Option<&str> = Some("Chechen locale for RUSSIAN FEDERATION");
    }
    pub mod LC_MESSAGES {
        /// `"^[-0nNМм]"`
        pub const NOEXPR: &str = "^[-0nNМм]";
        /// `None`
        pub const NOSTR: Option<&str> = None;
        /// `"^[+1yYДд]"`
        pub const YESEXPR: &str = "^[+1yYДд]";
        /// `None`
        pub const YESSTR: Option<&str> = None;
    }
    pub mod LC_MONETARY {
        /// `"₽"`
        pub const CURRENCY_SYMBOL: &str = "₽";
        /// `2`
        pub const FRAC_DIGITS: i64 = 2;
        /// `"RUB "`
        pub const INT_CURR_SYMBOL: &str = "RUB ";
        /// `2`
        pub const INT_FRAC_DIGITS: i64 = 2;
        /// `None`
        pub const INT_N_CS_PRECEDES: Option<i64> = None;
        /// `None`
        pub const INT_N_SEP_BY_SPACE: Option<i64> = None;
        /// `None`
        pub const INT_N_SIGN_POSN: Option<i64> = None;
        /// `None`
        pub const INT_P_CS_PRECEDES: Option<i64> = None;
        /// `None`
        pub const INT_P_SEP_BY_SPACE: Option<i64> = None;
        /// `None`
        pub const INT_P_SIGN_POSN: Option<i64> = None;
        /// `"."`
        pub const MON_DECIMAL_POINT: &str = ".";
        /// `&[3, 3]`
        pub const MON_GROUPING: &[i64] = &[3, 3];
        /// `"\u{202f}"`
        pub const MON_THOUSANDS_SEP: &str = "\u{202f}";
        /// `"-"`
        pub const NEGATIVE_SIGN: &str = "-";
        /// `0`
        pub const N_CS_PRECEDES: i64 = 0;
        /// `1`
        pub const N_SEP_BY_SPACE: i64 = 1;
        /// `1`
        pub const N_SIGN_POSN: i64 = 1;
        /// `""`
        pub const POSITIVE_SIGN: &str = "";
        /// `0`
        pub const P_CS_PRECEDES: i64 = 0;
        /// `1`
        pub const P_SEP_BY_SPACE: i64 = 1;
        /// `1`
        pub const P_SIGN_POSN: i64 = 1;
    }
    pub use super::ru_RU::LC_NUMERIC;
    pub mod LC_TELEPHONE {
        /// `Some("7")`
        pub const INT_PREFIX: Option<&str> = Some("7");
        /// `Some("0~10")`
        pub const INT_SELECT: Option<&str> = Some("0~10");
        /// `None`
        pub const TEL_DOM_FMT: Option<&str> = None;
        /// `Some("+%c %a %l")`
        pub const TEL_INT_FMT: Option<&str> = Some("+%c %a %l");
    }
    pub mod LC_TIME {
        /// `&["КӀ", "Ор", "Ши", "Кх", "Еа", "ПӀ", "Шо"]`
        pub const ABDAY: &[&str] = &["КӀ", "Ор", "Ши", "Кх", "Еа", "ПӀ", "Шо"];
        /// `&["янв", "фев", "мар", "апр", "май", "июн", "июл", "авг", "сен", "окт", "ноя", "дек"]`
        pub const ABMON: &[&str] = &["янв", "фев", "мар", "апр", "май", "июн", "июл", "авг", "сен", "окт", "ноя", "дек"];
        /// `None`
        pub const AB_ALT_MON: Option<&[&str]> = None;
        /// `None`
        pub const ALT_DIGITS: Option<&[&str]> = None;
        /// `None`
        pub const ALT_MON: Option<&[&str]> = None;
        /// `&["", ""]`
        pub const AM_PM: &[&str] = &["", ""];
        /// `None`
        pub const CAL_DIRECTION: Option<i64> = None;
        /// `None`
        pub const DATE_FMT: Option<&str> = None;
        /// `&["КӀиранан де", "Оршотан де", "Шинарин де", "Кхаарин де", "Еарин де", "ПӀераскан де", "Шот де"]`
        pub const DAY: &[&str] = &["КӀиранан де", "Оршотан де", "Шинарин де", "Кхаарин де", "Еарин де", "ПӀераскан де", "Шот де"];
        /// `"%Y.%d.%m"`
        pub const D_FMT: &str = "%Y.%d.%m";
        /// `"%Y %d %b %a %T"`
        pub const D_T_FMT: &str = "%Y %d %b %a %T";
        /// `None`
        pub const ERA: Option<&[&str]> = None;
        /// `None`
        pub const ERA_D_FMT: Option<&str> = None;
        /// `None`
        pub const ERA_D_T_FMT: Option<&str> = None;
        /// `None`
        pub const ERA_T_FMT: Option<&str> = None;
        /// `Some(2)`
        pub const FIRST_WEEKDAY: Option<i64> = Some(2);
        /// `None`
        pub const FIRST_WORKDAY: Option<i64> = None;
        /// `&["Январь", "Февраль", "Март", "Апрель", "Май", "Июнь", "Июль", "Август", "Сентябрь", "Октябрь", "Ноябрь", "Декабрь"]`
        pub const MON: &[&str] = &["Январь", "Февраль", "Март", "Апрель", "Май", "Июнь", "Июль", "Август", "Сентябрь", "Октябрь", "Ноябрь", "Декабрь"];
        /// `"%T"`
        pub const T_FMT: &str = "%T";
        /// `""`
        pub const T_FMT_AMPM: &str = "";
        /// `Some(&[7, 19971130, 1])`
        pub const WEEK: Option<&[i64]> = Some(&[7, 19971130, 1]);
    }
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod chr_US {
    pub mod LC_ADDRESS {
        /// `Some("USA")`
        pub const COUNTRY_AB3: Option<&str> = Some("USA");
        /// `Some("US")`
        pub const COUNTRY_ABTWO: Option<&str> = Some("US");
        /// `Some("USA")`
        pub const COUNTRY_CAR: Option<&str> = Some("USA");
        /// `Some("0")`
        pub const COUNTRY_ISBN: Option<&str> = Some("0");
        /// `Some("ᏌᏊ ᎢᏳᎾᎵᏍᏔᏅ ᏍᎦᏚᎩ")`
        pub const COUNTRY_NAME: Option<&str> = Some("ᏌᏊ ᎢᏳᎾᎵᏍᏔᏅ ᏍᎦᏚᎩ");
        /// `Some(840)`
        pub const COUNTRY_NUM: Option<i64> = Some(840);
        /// `Some("USA")`
        pub const COUNTRY_POST: Option<&str> = Some("USA");
        /// `Some("")`
        pub const LANG_AB: Option<&str> = Some("");
        /// `Some("chr")`
        pub const LANG_LIB: Option<&str> = Some("chr");
        /// `Some("ᏣᎳᎩ")`
        pub const LANG_NAME: Option<&str> = Some("ᏣᎳᎩ");
        /// `Some("chr")`
        pub const LANG_TERM: Option<&str> = Some("chr");
        /// `Some("%a%N%f%N%d%N%b%N%h %s %e %r%N%T, %S %z%N%c%N")`
        pub const POSTAL_FMT: Option<&str> = Some("%a%N%f%N%d%N%b%N%h %s %e %r%N%T, %S %z%N%c%N");
    }
    pub mod LC_IDENTIFICATION {
        /// `None`
        pub const ABBREVIATION: Option<&str> = None;
        /// `Some("http://cldr.unicode.org/index/process")`
        pub const ADDRESS: Option<&str> = Some("http://cldr.unicode.org/index/process");
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        /// ]
        /// ```
        pub const CATEGORY: Option<&[&[&str]]> = Some(&[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_TELEPHONE"],
            &["i18n:2012", "LC_MEASUREMENT"],
        ]);
        /// `Some("Joseph Erb")`
        pub const CONTACT: Option<&str> = Some("Joseph Erb");
        /// `Some("2010-10-20")`
        pub const DATE: Option<&str> = Some("2010-10-20");
        /// `Some("josepherb7@gmail.com")`
        pub const EMAIL: Option<&str> = Some("josepherb7@gmail.com");
        /// `Some("")`
        pub const FAX: Option<&str> = Some("");
        /// `Some("Cherokee")`
        pub const LANGUAGE: Option<&str> = Some("Cherokee");
        /// `Some("1.0")`
        pub const REVISION: Option<&str> = Some("1.0");
        /// `Some("Cherokee Nation")`
        pub const SOURCE: Option<&str> = Some("Cherokee Nation");
        /// `Some("")`
        pub const TEL: Option<&str> = Some("");
        /// `Some("United States")`
        pub const TERRITORY: Option<&str> = Some("United States");
        /// `Some("Cherokee language locale for United States")`
        pub const TITLE: Option<&str> = Some("Cherokee language locale for United States");
    }
    pub mod LC_MESSAGES {
        /// `"^([-0nN]|ᎥᏝ)"`
        pub const NOEXPR: &str = "^([-0nN]|ᎥᏝ)";
        /// `Some("ᎥᏝ")`
        pub const NOSTR: Option<&str> = Some("ᎥᏝ");
        /// `"^([+1yY]|ᎥᎥ)"`
        pub const YESEXPR: &str = "^([+1yY]|ᎥᎥ)";
        /// `Some("ᎥᎥ")`
        pub const YESSTR: Option<&str> = Some("ᎥᎥ");
    }
    pub use super::en_US::LC_MONETARY;
    pub use super::en_US::LC_NUMERIC;
    pub use super::en_US::LC_TELEPHONE;
    pub mod LC_TIME {
        /// `&["ᏆᏍᎬ", "ᏉᏅᎯ", "ᏔᎵᏁ", "ᏦᎢᏁ", "ᏅᎩᏁ", "ᏧᎾᎩ", "ᏈᏕᎾ"]`
        pub const ABDAY: &[&str] = &["ᏆᏍᎬ", "ᏉᏅᎯ", "ᏔᎵᏁ", "ᏦᎢᏁ", "ᏅᎩᏁ", "ᏧᎾᎩ", "ᏈᏕᎾ"];
        /// `&["ᎤᏃ", "ᎧᎦ", "ᎠᏅ", "ᎧᏬ", "ᎠᏂ", "ᏕᎭ", "ᎫᏰ", "ᎦᎶ", "ᏚᎵ", "ᏚᏂ", "ᏅᏓ", "ᎥᏍ"]`
        pub const ABMON: &[&str] = &["ᎤᏃ", "ᎧᎦ", "ᎠᏅ", "ᎧᏬ", "ᎠᏂ", "ᏕᎭ", "ᎫᏰ", "ᎦᎶ", "ᏚᎵ", "ᏚᏂ", "ᏅᏓ", "ᎥᏍ"];
        /// `None`
        pub const AB_ALT_MON: Option<&[&str]> = None;
        /// `None`
        pub const ALT_DIGITS: Option<&[&str]> = None;
        /// `None`
        pub const ALT_MON: Option<&[&str]> = None;
        /// `&["ᏌᎾᎴ", "ᏒᎯᏱᎢᏗᏢ"]`
        pub const AM_PM: &[&str] = &["ᏌᎾᎴ", "ᏒᎯᏱᎢᏗᏢ"];
        /// `None`
        pub const CAL_DIRECTION: Option<i64> = None;
        /// `None`
        pub const DATE_FMT: Option<&str> = None;
        /// `&["ᎤᎾᏙᏓᏆᏍᎬ", "ᎤᎾᏙᏓᏉᏅᎯ", "ᏔᎵᏁᎢᎦ", "ᏦᎢᏁᎢᎦ", "ᏅᎩᏁᎢᎦ", "ᏧᎾᎩᎶᏍᏗ", "ᎤᎾᏙᏓᏈᏕᎾ"]`
        pub const DAY: &[&str] = &["ᎤᎾᏙᏓᏆᏍᎬ", "ᎤᎾᏙᏓᏉᏅᎯ", "ᏔᎵᏁᎢᎦ", "ᏦᎢᏁᎢᎦ", "ᏅᎩᏁᎢᎦ", "ᏧᎾᎩᎶᏍᏗ", "ᎤᎾᏙᏓᏈᏕᎾ"];
        /// `"%m/%d/%Y"`
        pub const D_FMT: &str = "%m/%d/%Y";
        /// `"%a %d %b %Y %I:%M:%S %p %Z"`
        pub const D_T_FMT: &str = "%a %d %b %Y %I:%M:%S %p %Z";
        /// `None`
        pub const ERA: Option<&[&str]> = None;
        /// `None`
        pub const ERA_D_FMT: Option<&str> = None;
        /// `None`
        pub const ERA_D_T_FMT: Option<&str> = None;
        /// `None`
        pub const ERA_T_FMT: Option<&str> = None;
        /// `None`
        pub const FIRST_WEEKDAY: Option<i64> = None;
        /// `None`
        pub const FIRST_WORKDAY: Option<i64> = None;
        /// `&["ᎤᏃᎸᏔᏅ", "ᎧᎦᎵ", "ᎠᏅᏱ", "ᎧᏬᏂ", "ᎠᏂᏍᎬᏘ", "ᏕᎭᎷᏱ", "ᎫᏰᏉᏂ", "ᎦᎶᏂ", "ᏚᎵᏍᏗ", "ᏚᏂᏅᏗ", "ᏅᏓᏕᏆ", "ᎥᏍᎩᏱ"]`
        pub const MON: &[&str] = &["ᎤᏃᎸᏔᏅ", "ᎧᎦᎵ", "ᎠᏅᏱ", "ᎧᏬᏂ", "ᎠᏂᏍᎬᏘ", "ᏕᎭᎷᏱ", "ᎫᏰᏉᏂ", "ᎦᎶᏂ", "ᏚᎵᏍᏗ", "ᏚᏂᏅᏗ", "ᏅᏓᏕᏆ", "ᎥᏍᎩᏱ"];
        /// `"%I:%M:%S %p"`
        pub const T_FMT: &str = "%I:%M:%S %p";
        /// `"%I:%M:%S %p"`
        pub const T_FMT_AMPM: &str = "%I:%M:%S %p";
        /// `Some(&[7, 19971130, 1])`
        pub const WEEK: Option<&[i64]> = Some(&[7, 19971130, 1]);
    }
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod cmn_TW {
    pub mod LC_ADDRESS {
        /// `Some("TWN")`
        pub const COUNTRY_AB3: Option<&str> = Some("TWN");
        /// `Some("TW")`
        pub const COUNTRY_ABTWO: Option<&str> = Some("TW");
        /// `Some("RC")`
        pub const COUNTRY_CAR: Option<&str> = Some("RC");
        /// `Some("957")`
        pub const COUNTRY_ISBN: Option<&str> = Some("957");
        /// `Some("中華民國")`
        pub const COUNTRY_NAME: Option<&str> = Some("中華民國");
        /// `Some(158)`
        pub const COUNTRY_NUM: Option<i64> = Some(158);
        /// `Some("TW")`
        pub const COUNTRY_POST: Option<&str> = Some("TW");
        /// `None`
        pub const LANG_AB: Option<&str> = None;
        /// `Some("cmn")`
        pub const LANG_LIB: Option<&str> = Some("cmn");
        /// `Some("漢語官話")`
        pub const LANG_NAME: Option<&str> = Some("漢語官話");
        /// `Some("cmn")`
        pub const LANG_TERM: Option<&str> = Some("cmn");
        /// `Some("%c%N%T%N%s %h %e %r%N%b%N%d%N%f%N%a%N")`
        pub const POSTAL_FMT: Option<&str> = Some("%c%N%T%N%s %h %e %r%N%b%N%d%N%f%N%a%N");
    }
    pub mod LC_IDENTIFICATION {
        /// `None`
        pub const ABBREVIATION: Option<&str> = None;
        /// `Some("")`
        pub const ADDRESS: Option<&str> = Some("");
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        /// ]
        /// ```
        pub const CATEGORY: Option<&[&[&str]]> = Some(&[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_MEASUREMENT"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_TELEPHONE"],
        ]);
        /// `Some("")`
        pub const CONTACT: Option<&str> = Some("");
        /// `Some("2017-07-20")`
        pub const DATE: Option<&str> = Some("2017-07-20");
        /// `Some("bug-glibc-locales@gnu.org")`
        pub const EMAIL: Option<&str> = Some("bug-glibc-locales@gnu.org");
        /// `Some("")`
        pub const FAX: Option<&str> = Some("");
        /// `Some("Mandarin Chinese")`
        pub const LANGUAGE: Option<&str> = Some("Mandarin Chinese");
        /// `Some("0.2")`
        pub const REVISION: Option<&str> = Some("0.2");
        /// `Some("")`
        pub const SOURCE: Option<&str> = Some("");
        /// `Some("")`
        pub const TEL: Option<&str> = Some("");
        /// `Some("Taiwan")`
        pub const TERRITORY: Option<&str> = Some("Taiwan");
        /// `Some("Mandarin Chinese locale for the Republic of China")`
        pub const TITLE: Option<&str> = Some("Mandarin Chinese locale for the Republic of China");
    }
    pub mod LC_MESSAGES {
        /// `"^[-0nNｎＮ不否]"`
        pub const NOEXPR: &str = "^[-0nNｎＮ不否]";
        /// `Some("不是")`
        pub const NOSTR: Option<&str> = Some("不是");
        /// `"^[+1yYｙＹ是]"`
        pub const YESEXPR: &str = "^[+1yYｙＹ是]";
        /// `Some("是")`
        pub const YESSTR: Option<&str> = Some("是");
    }
    pub mod LC_MONETARY {
        /// `"NT$"`
        pub const CURRENCY_SYMBOL: &str = "NT$";
        /// `2`
        pub const FRAC_DIGITS: i64 = 2;
        /// `"TWD "`
        pub const INT_CURR_SYMBOL: &str = "TWD ";
        /// `2`
        pub const INT_FRAC_DIGITS: i64 = 2;
        /// `Some(1)`
        pub const INT_N_CS_PRECEDES: Option<i64> = Some(1);
        /// `Some(0)`
        pub const INT_N_SEP_BY_SPACE: Option<i64> = Some(0);
        /// `Some(1)`
        pub const INT_N_SIGN_POSN: Option<i64> = Some(1);
        /// `Some(1)`
        pub const INT_P_CS_PRECEDES: Option<i64> = Some(1);
        /// `Some(0)`
        pub const INT_P_SEP_BY_SPACE: Option<i64> = Some(0);
        /// `Some(1)`
        pub const INT_P_SIGN_POSN: Option<i64> = Some(1);
        /// `"."`
        pub const MON_DECIMAL_POINT: &str = ".";
        /// `&[4]`
        pub const MON_GROUPING: &[i64] = &[4];
        /// `","`
        pub const MON_THOUSANDS_SEP: &str = ",";
        /// `"-"`
        pub const NEGATIVE_SIGN: &str = "-";
        /// `1`
        pub const N_CS_PRECEDES: i64 = 1;
        /// `0`
        pub const N_SEP_BY_SPACE: i64 = 0;
        /// `1`
        pub const N_SIGN_POSN: i64 = 1;
        /// `""`
        pub const POSITIVE_SIGN: &str = "";
        /// `1`
        pub const P_CS_PRECEDES: i64 = 1;
        /// `0`
        pub const P_SEP_BY_SPACE: i64 = 0;
        /// `1`
        pub const P_SIGN_POSN: i64 = 1;
    }
    pub mod LC_NUMERIC {
        /// `"."`
        pub const DECIMAL_POINT: &str = ".";
        /// `&[4]`
        pub const GROUPING: &[i64] = &[4];
        /// `","`
        pub const THOUSANDS_SEP: &str = ",";
    }
    pub mod LC_TELEPHONE {
        /// `Some("886")`
        pub const INT_PREFIX: Option<&str> = Some("886");
        /// `Some("00")`
        pub const INT_SELECT: Option<&str> = Some("00");
        /// `Some("%A-%l")`
        pub const TEL_DOM_FMT: Option<&str> = Some("%A-%l");
        /// `Some("+%c-%a-%l")`
        pub const TEL_INT_FMT: Option<&str> = Some("+%c-%a-%l");
    }
    pub mod LC_TIME {
        /// `&["日", "一", "二", "三", "四", "五", "六"]`
        pub const ABDAY: &[&str] = &["日", "一", "二", "三", "四", "五", "六"];
        /// `&[" 1月", " 2月", " 3月", " 4月", " 5月", " 6月", " 7月", " 8月", " 9月", "10月", "11月", "12月"]`
        pub const ABMON: &[&str] = &[" 1月", " 2月", " 3月", " 4月", " 5月", " 6月", " 7月", " 8月", " 9月", "10月", "11月", "12月"];
        /// `None`
        pub const AB_ALT_MON: Option<&[&str]> = None;
        /// `None`
        pub const ALT_DIGITS: Option<&[&str]> = None;
        /// `None`
        pub const ALT_MON: Option<&[&str]> = None;
        /// `&["上午", "下午"]`
        pub const AM_PM: &[&str] = &["上午", "下午"];
        /// `None`
        pub const CAL_DIRECTION: Option<i64> = None;
        /// `Some("%Y年 %b %-d號 %A %H:%M:%S %Z")`
        pub const DATE_FMT: Option<&str> = Some("%Y年 %b %-d號 %A %H:%M:%S %Z");
        /// `&["星期日", "星期一", "星期二", "星期三", "星期四", "星期五", "星期六"]`
        pub const DAY: &[&str] = &["星期日", "星期一", "星期二", "星期三", "星期四", "星期五", "星期六"];
        /// `"%Y年%m月%d號"`
        pub const D_FMT: &str = "%Y年%m月%d號";
        /// `"%Y年%m月%d號 (%A) %H點%M分%S秒"`
        pub const D_T_FMT: &str = "%Y年%m月%d號 (%A) %H點%M分%S秒";
        /// `Some(&["+:2:1913/01/01:+*:民國:%EC%Ey年", "+:1:1912/01/01:1912/12/31:民國:%EC元年", "+:1:1911/12/31:-*:民前:%EC%Ey年"])`
        pub const ERA: Option<&[&str]> = Some(&["+:2:1913/01/01:+*:民國:%EC%Ey年", "+:1:1912/01/01:1912/12/31:民國:%EC元年", "+:1:1911/12/31:-*:民前:%EC%Ey年"]);
        /// `None`
        pub const ERA_D_FMT: Option<&str> = None;
        /// `None`
        pub const ERA_D_T_FMT: Option<&str> = None;
        /// `None`
        pub const ERA_T_FMT: Option<&str> = None;
        /// `None`
        pub const FIRST_WEEKDAY: Option<i64> = None;
        /// `None`
        pub const FIRST_WORKDAY: Option<i64> = None;
        /// `&["一月", "二月", "三月", "四月", "五月", "六月", "七月", "八月", "九月", "十月", "十一月", "十二月"]`
        pub const MON: &[&str] = &["一月", "二月", "三月", "四月", "五月", "六月", "七月", "八月", "九月", "十月", "十一月", "十二月"];
        /// `"%H點%M分%S秒"`
        pub const T_FMT: &str = "%H點%M分%S秒";
        /// `"%p %I點%M分%S秒"`
        pub const T_FMT_AMPM: &str = "%p %I點%M分%S秒";
        /// `None`
        pub const WEEK: Option<&[i64]> = None;
    }
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod crh_UA {
    pub mod LC_ADDRESS {
        /// `Some("UKR")`
        pub const COUNTRY_AB3: Option<&str> = Some("UKR");
        /// `Some("UA")`
        pub const COUNTRY_ABTWO: Option<&str> = Some("UA");
        /// `Some("UA")`
        pub const COUNTRY_CAR: Option<&str> = Some("UA");
        /// `None`
        pub const COUNTRY_ISBN: Option<&str> = None;
        /// `None`
        pub const COUNTRY_NAME: Option<&str> = None;
        /// `Some(804)`
        pub const COUNTRY_NUM: Option<i64> = Some(804);
        /// `None`
        pub const COUNTRY_POST: Option<&str> = None;
        /// `None`
        pub const LANG_AB: Option<&str> = None;
        /// `Some("crh")`
        pub const LANG_LIB: Option<&str> = Some("crh");
        /// `Some("qırımtatar tili")`
        pub const LANG_NAME: Option<&str> = Some("qırımtatar tili");
        /// `Some("crh")`
        pub const LANG_TERM: Option<&str> = Some("crh");
        /// `Some("%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%c%N")`
        pub const POSTAL_FMT: Option<&str> = Some("%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%c%N");
    }
    pub mod LC_IDENTIFICATION {
        /// `None`
        pub const ABBREVIATION: Option<&str> = None;
        /// `Some("")`
        pub const ADDRESS: Option<&str> = Some("");
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_NAME"],
        /// ]
        /// ```
        pub const CATEGORY: Option<&[&[&str]]> = Some(&[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_TELEPHONE"],
            &["i18n:2012", "LC_MEASUREMENT"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_NAME"],
        ]);
        /// `Some("Reşat SABIQ")`
        pub const CONTACT: Option<&str> = Some("Reşat SABIQ");
        /// `Some("2009-08-16")`
        pub const DATE: Option<&str> = Some("2009-08-16");
        /// `Some("tilde.birlik@gmail.com")`
        pub const EMAIL: Option<&str> = Some("tilde.birlik@gmail.com");
        /// `Some("")`
        pub const FAX: Option<&str> = Some("");
        /// `Some("Crimean Tatar")`
        pub const LANGUAGE: Option<&str> = Some("Crimean Tatar");
        /// `Some("0.4")`
        pub const REVISION: Option<&str> = Some("0.4");
        /// `Some("")`
        pub const SOURCE: Option<&str> = Some("");
        /// `Some("")`
        pub const TEL: Option<&str> = Some("");
        /// `Some("Ukraine")`
        pub const TERRITORY: Option<&str> = Some("Ukraine");
        /// `Some("Crimean Tatar (Crimean Turkish) language locale for Ukraine")`
        pub const TITLE: Option<&str> = Some("Crimean Tatar (Crimean Turkish) language locale for Ukraine");
    }
    pub mod LC_MESSAGES {
        /// `"^[-0nNhH]"`
        pub const NOEXPR: &str = "^[-0nNhH]";
        /// `Some("hayır")`
        pub const NOSTR: Option<&str> = Some("hayır");
        /// `"^[+1yYeE]"`
        pub const YESEXPR: &str = "^[+1yYeE]";
        /// `Some("ebet")`
        pub const YESSTR: Option<&str> = Some("ebet");
    }
    pub mod LC_MONETARY {
        /// `"₴"`
        pub const CURRENCY_SYMBOL: &str = "₴";
        /// `2`
        pub const FRAC_DIGITS: i64 = 2;
        /// `"UAH "`
        pub const INT_CURR_SYMBOL: &str = "UAH ";
        /// `2`
        pub const INT_FRAC_DIGITS: i64 = 2;
        /// `None`
        pub const INT_N_CS_PRECEDES: Option<i64> = None;
        /// `None`
        pub const INT_N_SEP_BY_SPACE: Option<i64> = None;
        /// `None`
        pub const INT_N_SIGN_POSN: Option<i64> = None;
        /// `None`
        pub const INT_P_CS_PRECEDES: Option<i64> = None;
        /// `None`
        pub const INT_P_SEP_BY_SPACE: Option<i64> = None;
        /// `None`
        pub const INT_P_SIGN_POSN: Option<i64> = None;
        /// `"."`
        pub const MON_DECIMAL_POINT: &str = ".";
        /// `&[3, 3]`
        pub const MON_GROUPING: &[i64] = &[3, 3];
        /// `"\u{202f}"`
        pub const MON_THOUSANDS_SEP: &str = "\u{202f}";
        /// `"-"`
        pub const NEGATIVE_SIGN: &str = "-";
        /// `0`
        pub const N_CS_PRECEDES: i64 = 0;
        /// `1`
        pub const N_SEP_BY_SPACE: i64 = 1;
        /// `1`
        pub const N_SIGN_POSN: i64 = 1;
        /// `""`
        pub const POSITIVE_SIGN: &str = "";
        /// `0`
        pub const P_CS_PRECEDES: i64 = 0;
        /// `1`
        pub const P_SEP_BY_SPACE: i64 = 1;
        /// `1`
        pub const P_SIGN_POSN: i64 = 1;
    }
    pub mod LC_NUMERIC {
        /// `","`
        pub const DECIMAL_POINT: &str = ",";
        /// `&[3, 3]`
        pub const GROUPING: &[i64] = &[3, 3];
        /// `"."`
        pub const THOUSANDS_SEP: &str = ".";
    }
    pub mod LC_TELEPHONE {
        /// `Some("380")`
        pub const INT_PREFIX: Option<&str> = Some("380");
        /// `Some("00")`
        pub const INT_SELECT: Option<&str> = Some("00");
        /// `None`
        pub const TEL_DOM_FMT: Option<&str> = None;
        /// `Some("+%c %a %l")`
        pub const TEL_INT_FMT: Option<&str> = Some("+%c %a %l");
    }
    pub mod LC_TIME {
        /// `&["Baz", "Ber", "Sal", "Çar", "Caq", "Cum", "Cer"]`
        pub const ABDAY: &[&str] = &["Baz", "Ber", "Sal", "Çar", "Caq", "Cum", "Cer"];
        /// `&["Yan", "Fev", "Mar", "Apr", "May", "İyn", "İyl", "Avg", "Sen", "Okt", "Noy", "Dek"]`
        pub const ABMON: &[&str] = &["Yan", "Fev", "Mar", "Apr", "May", "İyn", "İyl", "Avg", "Sen", "Okt", "Noy", "Dek"];
        /// `None`
        pub const AB_ALT_MON: Option<&[&str]> = None;
        /// `None`
        pub const ALT_DIGITS: Option<&[&str]> = None;
        /// `None`
        pub const ALT_MON: Option<&[&str]> = None;
        /// `&["ÜE", "ÜS"]`
        pub const AM_PM: &[&str] = &["ÜE", "ÜS"];
        /// `None`
        pub const CAL_DIRECTION: Option<i64> = None;
        /// `None`
        pub const DATE_FMT: Option<&str> = None;
        /// `&["Bazar", "Bazarertesi", "Salı", "Çarşembe", "Cumaaqşamı", "Cuma", "Cumaertesi"]`
        pub const DAY: &[&str] = &["Bazar", "Bazarertesi", "Salı", "Çarşembe", "Cumaaqşamı", "Cuma", "Cumaertesi"];
        /// `"%d.%m.%Y"`
        pub const D_FMT: &str = "%d.%m.%Y";
        /// `"%a %d %b %Y %T"`
        pub const D_T_FMT: &str = "%a %d %b %Y %T";
        /// `None`
        pub const ERA: Option<&[&str]> = None;
        /// `None`
        pub const ERA_D_FMT: Option<&str> = None;
        /// `None`
        pub const ERA_D_T_FMT: Option<&str> = None;
        /// `None`
        pub const ERA_T_FMT: Option<&str> = None;
        /// `Some(2)`
        pub const FIRST_WEEKDAY: Option<i64> = Some(2);
        /// `None`
        pub const FIRST_WORKDAY: Option<i64> = None;
        /// `&["Yanvar", "Fevral", "Mart", "Aprel", "Mayıs", "İyun", "İyul", "Avgust", "Sentâbr", "Oktâbr", "Noyabr", "Dekabr"]`
        pub const MON: &[&str] = &["Yanvar", "Fevral", "Mart", "Aprel", "Mayıs", "İyun", "İyul", "Avgust", "Sentâbr", "Oktâbr", "Noyabr", "Dekabr"];
        /// `"%T"`
        pub const T_FMT: &str = "%T";
        /// `"%I:%M:%S %p"`
        pub const T_FMT_AMPM: &str = "%I:%M:%S %p";
        /// `Some(&[7, 19971130, 1])`
        pub const WEEK: Option<&[i64]> = Some(&[7, 19971130, 1]);
    }
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod cs_CZ {
    pub mod LC_ADDRESS {
        /// `Some("CZE")`
        pub const COUNTRY_AB3: Option<&str> = Some("CZE");
        /// `Some("CZ")`
        pub const COUNTRY_ABTWO: Option<&str> = Some("CZ");
        /// `Some("CZ")`
        pub const COUNTRY_CAR: Option<&str> = Some("CZ");
        /// `None`
        pub const COUNTRY_ISBN: Option<&str> = None;
        /// `Some("Česká republika")`
        pub const COUNTRY_NAME: Option<&str> = Some("Česká republika");
        /// `Some(203)`
        pub const COUNTRY_NUM: Option<i64> = Some(203);
        /// `Some("CZ")`
        pub const COUNTRY_POST: Option<&str> = Some("CZ");
        /// `Some("cs")`
        pub const LANG_AB: Option<&str> = Some("cs");
        /// `Some("cze")`
        pub const LANG_LIB: Option<&str> = Some("cze");
        /// `Some("čeština")`
        pub const LANG_NAME: Option<&str> = Some("čeština");
        /// `Some("ces")`
        pub const LANG_TERM: Option<&str> = Some("ces");
        /// `Some("%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%c%N")`
        pub const POSTAL_FMT: Option<&str> = Some("%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%c%N");
    }
    pub mod LC_IDENTIFICATION {
        /// `None`
        pub const ABBREVIATION: Option<&str> = None;
        /// `Some("https://www.gnu.org/software/libc/")`
        pub const ADDRESS: Option<&str> = Some("https://www.gnu.org/software/libc/");
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        /// ]
        /// ```
        pub const CATEGORY: Option<&[&[&str]]> = Some(&[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_TELEPHONE"],
            &["i18n:2012", "LC_MEASUREMENT"],
        ]);
        /// `Some("")`
        pub const CONTACT: Option<&str> = Some("");
        /// `Some("2000-06-28")`
        pub const DATE: Option<&str> = Some("2000-06-28");
        /// `Some("bug-glibc-locales@gnu.org")`
        pub const EMAIL: Option<&str> = Some("bug-glibc-locales@gnu.org");
        /// `Some("")`
        pub const FAX: Option<&str> = Some("");
        /// `Some("Czech")`
        pub const LANGUAGE: Option<&str> = Some("Czech");
        /// `Some("1.0")`
        pub const REVISION: Option<&str> = Some("1.0");
        /// `Some("Free Software Foundation, Inc.")`
        pub const SOURCE: Option<&str> = Some("Free Software Foundation, Inc.");
        /// `Some("")`
        pub const TEL: Option<&str> = Some("");
        /// `Some("Czech Republic")`
        pub const TERRITORY: Option<&str> = Some("Czech Republic");
        /// `Some("Czech locale for the Czech Republic")`
        pub const TITLE: Option<&str> = Some("Czech locale for the Czech Republic");
    }
    pub mod LC_MESSAGES {
        /// `"^[-0nN]"`
        pub const NOEXPR: &str = "^[-0nN]";
        /// `Some("ne")`
        pub const NOSTR: Option<&str> = Some("ne");
        /// `"^[+1aAyY]"`
        pub const YESEXPR: &str = "^[+1aAyY]";
        /// `Some("ano")`
        pub const YESSTR: Option<&str> = Some("ano");
    }
    pub mod LC_MONETARY {
        /// `"Kč"`
        pub const CURRENCY_SYMBOL: &str = "Kč";
        /// `2`
        pub const FRAC_DIGITS: i64 = 2;
        /// `"CZK "`
        pub const INT_CURR_SYMBOL: &str = "CZK ";
        /// `2`
        pub const INT_FRAC_DIGITS: i64 = 2;
        /// `None`
        pub const INT_N_CS_PRECEDES: Option<i64> = None;
        /// `None`
        pub const INT_N_SEP_BY_SPACE: Option<i64> = None;
        /// `None`
        pub const INT_N_SIGN_POSN: Option<i64> = None;
        /// `None`
        pub const INT_P_CS_PRECEDES: Option<i64> = None;
        /// `None`
        pub const INT_P_SEP_BY_SPACE: Option<i64> = None;
        /// `None`
        pub const INT_P_SIGN_POSN: Option<i64> = None;
        /// `","`
        pub const MON_DECIMAL_POINT: &str = ",";
        /// `&[3, 3]`
        pub const MON_GROUPING: &[i64] = &[3, 3];
        /// `"\u{202f}"`
        pub const MON_THOUSANDS_SEP: &str = "\u{202f}";
        /// `"-"`
        pub const NEGATIVE_SIGN: &str = "-";
        /// `0`
        pub const N_CS_PRECEDES: i64 = 0;
        /// `1`
        pub const N_SEP_BY_SPACE: i64 = 1;
        /// `1`
        pub const N_SIGN_POSN: i64 = 1;
        /// `""`
        pub const POSITIVE_SIGN: &str = "";
        /// `0`
        pub const P_CS_PRECEDES: i64 = 0;
        /// `1`
        pub const P_SEP_BY_SPACE: i64 = 1;
        /// `1`
        pub const P_SIGN_POSN: i64 = 1;
    }
    pub mod LC_NUMERIC {
        /// `","`
        pub const DECIMAL_POINT: &str = ",";
        /// `&[3, 3]`
        pub const GROUPING: &[i64] = &[3, 3];
        /// `"\u{202f}"`
        pub const THOUSANDS_SEP: &str = "\u{202f}";
    }
    pub mod LC_TELEPHONE {
        /// `Some("420")`
        pub const INT_PREFIX: Option<&str> = Some("420");
        /// `Some("00")`
        pub const INT_SELECT: Option<&str> = Some("00");
        /// `Some("(0%a) %l")`
        pub const TEL_DOM_FMT: Option<&str> = Some("(0%a) %l");
        /// `Some("+%c %a %l")`
        pub const TEL_INT_FMT: Option<&str> = Some("+%c %a %l");
    }
    pub mod LC_TIME {
        /// `&["Ne", "Po", "Út", "St", "Čt", "Pá", "So"]`
        pub const ABDAY: &[&str] = &["Ne", "Po", "Út", "St", "Čt", "Pá", "So"];
        /// `&["led", "úno", "bře", "dub", "kvě", "čen", "čec", "srp", "zář", "říj", "lis", "pro"]`
        pub const ABMON: &[&str] = &["led", "úno", "bře", "dub", "kvě", "čen", "čec", "srp", "zář", "říj", "lis", "pro"];
        /// `None`
        pub const AB_ALT_MON: Option<&[&str]> = None;
        /// `None`
        pub const ALT_DIGITS: Option<&[&str]> = None;
        /// `Some(&["leden", "únor", "březen", "duben", "květen", "červen", "červenec", "srpen", "září", "říjen", "listopad", "prosinec"])`
        pub const ALT_MON: Option<&[&str]> = Some(&["leden", "únor", "březen", "duben", "květen", "červen", "červenec", "srpen", "září", "říjen", "listopad", "prosinec"]);
        /// `&["", ""]`
        pub const AM_PM: &[&str] = &["", ""];
        /// `None`
        pub const CAL_DIRECTION: Option<i64> = None;
        /// `None`
        pub const DATE_FMT: Option<&str> = None;
        /// `&["Neděle", "Pondělí", "Úterý", "Středa", "Čtvrtek", "Pátek", "Sobota"]`
        pub const DAY: &[&str] = &["Neděle", "Pondělí", "Úterý", "Středa", "Čtvrtek", "Pátek", "Sobota"];
        /// `"%-d.%-m.%Y"`
        pub const D_FMT: &str = "%-d.%-m.%Y";
        /// `"%a\u{a0}%-d.\u{a0}%B\u{a0}%Y,\u{a0}%H:%M:%S\u{a0}%Z"`
        pub const D_T_FMT: &str = "%a\u{a0}%-d.\u{a0}%B\u{a0}%Y,\u{a0}%H:%M:%S\u{a0}%Z";
        /// `None`
        pub const ERA: Option<&[&str]> = None;
        /// `None`
        pub const ERA_D_FMT: Option<&str> = None;
        /// `None`
        pub const ERA_D_T_FMT: Option<&str> = None;
        /// `None`
        pub const ERA_T_FMT: Option<&str> = None;
        /// `Some(2)`
        pub const FIRST_WEEKDAY: Option<i64> = Some(2);
        /// `None`
        pub const FIRST_WORKDAY: Option<i64> = None;
        /// `&["ledna", "února", "března", "dubna", "května", "června", "července", "srpna", "září", "října", "listopadu", "prosince"]`
        pub const MON: &[&str] = &["ledna", "února", "března", "dubna", "května", "června", "července", "srpna", "září", "října", "listopadu", "prosince"];
        /// `"%H:%M:%S"`
        pub const T_FMT: &str = "%H:%M:%S";
        /// `""`
        pub const T_FMT_AMPM: &str = "";
        /// `Some(&[7, 19971130, 4])`
        pub const WEEK: Option<&[i64]> = Some(&[7, 19971130, 4]);
    }
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod csb_PL {
    pub mod LC_ADDRESS {
        /// `Some("POL")`
        pub const COUNTRY_AB3: Option<&str> = Some("POL");
        /// `Some("PL")`
        pub const COUNTRY_ABTWO: Option<&str> = Some("PL");
        /// `Some("PL")`
        pub const COUNTRY_CAR: Option<&str> = Some("PL");
        /// `None`
        pub const COUNTRY_ISBN: Option<&str> = None;
        /// `Some("Pòlskô")`
        pub const COUNTRY_NAME: Option<&str> = Some("Pòlskô");
        /// `Some(616)`
        pub const COUNTRY_NUM: Option<i64> = Some(616);
        /// `None`
        pub const COUNTRY_POST: Option<&str> = None;
        /// `None`
        pub const LANG_AB: Option<&str> = None;
        /// `Some("csb")`
        pub const LANG_LIB: Option<&str> = Some("csb");
        /// `Some("kaszëbsczi jãzëk")`
        pub const LANG_NAME: Option<&str> = Some("kaszëbsczi jãzëk");
        /// `Some("csb")`
        pub const LANG_TERM: Option<&str> = Some("csb");
        /// `Some("%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%c%N")`
        pub const POSTAL_FMT: Option<&str> = Some("%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%c%N");
    }
    pub mod LC_IDENTIFICATION {
        /// `None`
        pub const ABBREVIATION: Option<&str> = None;
        /// `Some("")`
        pub const ADDRESS: Option<&str> = Some("");
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        /// ]
        /// ```
        pub const CATEGORY: Option<&[&[&str]]> = Some(&[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_TELEPHONE"],
            &["i18n:2012", "LC_MEASUREMENT"],
        ]);
        /// `Some("Michal Ostrowski")`
        pub const CONTACT: Option<&str> = Some("Michal Ostrowski");
        /// `Some("2006-07-25")`
        pub const DATE: Option<&str> = Some("2006-07-25");
        /// `Some("bug-glibc-locales@gnu.org")`
        pub const EMAIL: Option<&str> = Some("bug-glibc-locales@gnu.org");
        /// `Some("")`
        pub const FAX: Option<&str> = Some("");
        /// `Some("Kashubian")`
        pub const LANGUAGE: Option<&str> = Some("Kashubian");
        /// `Some("1.0")`
        pub const REVISION: Option<&str> = Some("1.0");
        /// `Some("csb_PL locale")`
        pub const SOURCE: Option<&str> = Some("csb_PL locale");
        /// `Some("")`
        pub const TEL: Option<&str> = Some("");
        /// `Some("Poland")`
        pub const TERRITORY: Option<&str> = Some("Poland");
        /// `Some("Kashubian locale for Poland")`
        pub const TITLE: Option<&str> = Some("Kashubian locale for Poland");
    }
    pub mod LC_MESSAGES {
        /// `"^[-0nN]"`
        pub const NOEXPR: &str = "^[-0nN]";
        /// `Some("nié")`
        pub const NOSTR: Option<&str> = Some("nié");
        /// `"^[+1JjTtYy]"`
        pub const YESEXPR: &str = "^[+1JjTtYy]";
        /// `Some("jo")`
        pub const YESSTR: Option<&str> = Some("jo");
    }
    pub use super::pl_PL::LC_MONETARY;
    pub use super::pl_PL::LC_NUMERIC;
    pub use super::pl_PL::LC_TELEPHONE;
    pub mod LC_TIME {
        /// `&["nie", "pòn", "wtó", "str", "czw", "pią", "sob"]`
        pub const ABDAY: &[&str] = &["nie", "pòn", "wtó", "str", "czw", "pią", "sob"];
        /// `&["stë", "gro", "str", "łżë", "maj", "cze", "lëp", "zél", "séw", "ruj", "lës", "gòd"]`
        pub const ABMON: &[&str] = &["stë", "gro", "str", "łżë", "maj", "cze", "lëp", "zél", "séw", "ruj", "lës", "gòd"];
        /// `Some(&["stë", "gro", "str", "łżë", "môj", "cze", "lëp", "zél", "séw", "ruj", "lës", "gòd"])`
        pub const AB_ALT_MON: Option<&[&str]> = Some(&["stë", "gro", "str", "łżë", "môj", "cze", "lëp", "zél", "séw", "ruj", "lës", "gòd"]);
        /// `None`
        pub const ALT_DIGITS: Option<&[&str]> = None;
        /// `Some(&["stëcznik", "gromicznik", "strëmiannik", "łżëkwiat", "môj", "czerwińc", "lëpińc", "zélnik", "séwnik", "rujan", "lëstopadnik", "gòdnik"])`
        pub const ALT_MON: Option<&[&str]> = Some(&["stëcznik", "gromicznik", "strëmiannik", "łżëkwiat", "môj", "czerwińc", "lëpińc", "zélnik", "séwnik", "rujan", "lëstopadnik", "gòdnik"]);
        /// `&["", ""]`
        pub const AM_PM: &[&str] = &["", ""];
        /// `None`
        pub const CAL_DIRECTION: Option<i64> = None;
        /// `None`
        pub const DATE_FMT: Option<&str> = None;
        /// `&["niedzela", "pòniedzôłk", "wtórk", "strzoda", "czwiôrtk", "piątk", "sobòta"]`
        pub const DAY: &[&str] = &["niedzela", "pòniedzôłk", "wtórk", "strzoda", "czwiôrtk", "piątk", "sobòta"];
        /// `"%Y-%m-%d"`
        pub const D_FMT: &str = "%Y-%m-%d";
        /// `"%a %d %b %Y %T %Z"`
        pub const D_T_FMT: &str = "%a %d %b %Y %T %Z";
        /// `None`
        pub const ERA: Option<&[&str]> = None;
        /// `None`
        pub const ERA_D_FMT: Option<&str> = None;
        /// `None`
        pub const ERA_D_T_FMT: Option<&str> = None;
        /// `None`
        pub const ERA_T_FMT: Option<&str> = None;
        /// `Some(2)`
        pub const FIRST_WEEKDAY: Option<i64> = Some(2);
        /// `None`
        pub const FIRST_WORKDAY: Option<i64> = None;
        /// `&["stëcznika", "gromicznika", "strëmiannika", "łżëkwiata", "maja", "czerwińca", "lëpińca", "zélnika", "séwnika", "rujana", "lëstopadnika", "gòdnika"]`
        pub const MON: &[&str] = &["stëcznika", "gromicznika", "strëmiannika", "łżëkwiata", "maja", "czerwińca", "lëpińca", "zélnika", "séwnika", "rujana", "lëstopadnika", "gòdnika"];
        /// `"%T"`
        pub const T_FMT: &str = "%T";
        /// `""`
        pub const T_FMT_AMPM: &str = "";
        /// `Some(&[7, 19971130, 4])`
        pub const WEEK: Option<&[i64]> = Some(&[7, 19971130, 4]);
    }
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod cv_RU {
    pub mod LC_ADDRESS {
        /// `Some("RUS")`
        pub const COUNTRY_AB3: Option<&str> = Some("RUS");
        /// `Some("RU")`
        pub const COUNTRY_ABTWO: Option<&str> = Some("RU");
        /// `Some("RUS")`
        pub const COUNTRY_CAR: Option<&str> = Some("RUS");
        /// `None`
        pub const COUNTRY_ISBN: Option<&str> = None;
        /// `None`
        pub const COUNTRY_NAME: Option<&str> = None;
        /// `Some(643)`
        pub const COUNTRY_NUM: Option<i64> = Some(643);
        /// `None`
        pub const COUNTRY_POST: Option<&str> = None;
        /// `Some("cv")`
        pub const LANG_AB: Option<&str> = Some("cv");
        /// `Some("chv")`
        pub const LANG_LIB: Option<&str> = Some("chv");
        /// `Some("Чӑвашла")`
        pub const LANG_NAME: Option<&str> = Some("Чӑвашла");
        /// `Some("chv")`
        pub const LANG_TERM: Option<&str> = Some("chv");
        /// `Some("%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%c%N")`
        pub const POSTAL_FMT: Option<&str> = Some("%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%c%N");
    }
    pub mod LC_IDENTIFICATION {
        /// `None`
        pub const ABBREVIATION: Option<&str> = None;
        /// `Some("Sankt Jorgens Alle 8, DK-1615 Kobenhavn V, Danmark")`
        pub const ADDRESS: Option<&str> = Some("Sankt Jorgens Alle 8, DK-1615 Kobenhavn V, Danmark");
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        /// ]
        /// ```
        pub const CATEGORY: Option<&[&[&str]]> = Some(&[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_TELEPHONE"],
            &["i18n:2012", "LC_MEASUREMENT"],
        ]);
        /// `Some("")`
        pub const CONTACT: Option<&str> = Some("");
        /// `Some("2000-06-29")`
        pub const DATE: Option<&str> = Some("2000-06-29");
        /// `Some("bug-glibc-locales@gnu.org")`
        pub const EMAIL: Option<&str> = Some("bug-glibc-locales@gnu.org");
        /// `Some("")`
        pub const FAX: Option<&str> = Some("");
        /// `Some("Chuvash")`
        pub const LANGUAGE: Option<&str> = Some("Chuvash");
        /// `Some("1.0")`
        pub const REVISION: Option<&str> = Some("1.0");
        /// `Some("RAP")`
        pub const SOURCE: Option<&str> = Some("RAP");
        /// `Some("")`
        pub const TEL: Option<&str> = Some("");
        /// `Some("Russia")`
        pub const TERRITORY: Option<&str> = Some("Russia");
        /// `Some("Chuvash locale for Russia")`
        pub const TITLE: Option<&str> = Some("Chuvash locale for Russia");
    }
    pub mod LC_MESSAGES {
        /// `"^[-0nN]"`
        pub const NOEXPR: &str = "^[-0nN]";
        /// `None`
        pub const NOSTR: Option<&str> = None;
        /// `"^[+1yY]"`
        pub const YESEXPR: &str = "^[+1yY]";
        /// `None`
        pub const YESSTR: Option<&str> = None;
    }
    pub mod LC_MONETARY {
        /// `"₽"`
        pub const CURRENCY_SYMBOL: &str = "₽";
        /// `2`
        pub const FRAC_DIGITS: i64 = 2;
        /// `"RUB "`
        pub const INT_CURR_SYMBOL: &str = "RUB ";
        /// `2`
        pub const INT_FRAC_DIGITS: i64 = 2;
        /// `None`
        pub const INT_N_CS_PRECEDES: Option<i64> = None;
        /// `None`
        pub const INT_N_SEP_BY_SPACE: Option<i64> = None;
        /// `None`
        pub const INT_N_SIGN_POSN: Option<i64> = None;
        /// `None`
        pub const INT_P_CS_PRECEDES: Option<i64> = None;
        /// `None`
        pub const INT_P_SEP_BY_SPACE: Option<i64> = None;
        /// `None`
        pub const INT_P_SIGN_POSN: Option<i64> = None;
        /// `"."`
        pub const MON_DECIMAL_POINT: &str = ".";
        /// `&[3, 3]`
        pub const MON_GROUPING: &[i64] = &[3, 3];
        /// `"\u{202f}"`
        pub const MON_THOUSANDS_SEP: &str = "\u{202f}";
        /// `"-"`
        pub const NEGATIVE_SIGN: &str = "-";
        /// `0`
        pub const N_CS_PRECEDES: i64 = 0;
        /// `1`
        pub const N_SEP_BY_SPACE: i64 = 1;
        /// `1`
        pub const N_SIGN_POSN: i64 = 1;
        /// `""`
        pub const POSITIVE_SIGN: &str = "";
        /// `0`
        pub const P_CS_PRECEDES: i64 = 0;
        /// `1`
        pub const P_SEP_BY_SPACE: i64 = 1;
        /// `1`
        pub const P_SIGN_POSN: i64 = 1;
    }
    pub use super::ru_RU::LC_NUMERIC;
    pub use super::ru_RU::LC_TELEPHONE;
    pub mod LC_TIME {
        /// `&["vr", "tn", "yt", "jn", "kş", "er", "šm"]`
        pub const ABDAY: &[&str] = &["vr", "tn", "yt", "jn", "kş", "er", "šm"];
        /// `&["KĂR", "NAR", "PUŠ", "AKA", "ŞU", "ŞĔR", "UTĂ", "ŞUR", "AVĂ", "JUP", "CÜK", "RAŠ"]`
        pub const ABMON: &[&str] = &["KĂR", "NAR", "PUŠ", "AKA", "ŞU", "ŞĔR", "UTĂ", "ŞUR", "AVĂ", "JUP", "CÜK", "RAŠ"];
        /// `None`
        pub const AB_ALT_MON: Option<&[&str]> = None;
        /// `None`
        pub const ALT_DIGITS: Option<&[&str]> = None;
        /// `None`
        pub const ALT_MON: Option<&[&str]> = None;
        /// `&["", ""]`
        pub const AM_PM: &[&str] = &["", ""];
        /// `None`
        pub const CAL_DIRECTION: Option<i64> = None;
        /// `None`
        pub const DATE_FMT: Option<&str> = None;
        /// `&["vyrsarnikun", "tuntikun", "ytlarikun", "junkun", "kĕşnernikun", "ernekun", "šămatkun"]`
        pub const DAY: &[&str] = &["vyrsarnikun", "tuntikun", "ytlarikun", "junkun", "kĕşnernikun", "ernekun", "šămatkun"];
        /// `"%d.%m.%Y"`
        pub const D_FMT: &str = "%d.%m.%Y";
        /// `"%a %d %b %Y %T"`
        pub const D_T_FMT: &str = "%a %d %b %Y %T";
        /// `None`
        pub const ERA: Option<&[&str]> = None;
        /// `None`
        pub const ERA_D_FMT: Option<&str> = None;
        /// `None`
        pub const ERA_D_T_FMT: Option<&str> = None;
        /// `None`
        pub const ERA_T_FMT: Option<&str> = None;
        /// `Some(2)`
        pub const FIRST_WEEKDAY: Option<i64> = Some(2);
        /// `None`
        pub const FIRST_WORKDAY: Option<i64> = None;
        /// `&["kărlac", "narăs", "puš", "aka", "şu", "şĕrtme", "ută", "şurla", "avăn", "jupa", "cük", "raštav"]`
        pub const MON: &[&str] = &["kărlac", "narăs", "puš", "aka", "şu", "şĕrtme", "ută", "şurla", "avăn", "jupa", "cük", "raštav"];
        /// `"%T"`
        pub const T_FMT: &str = "%T";
        /// `""`
        pub const T_FMT_AMPM: &str = "";
        /// `Some(&[7, 19971130, 1])`
        pub const WEEK: Option<&[i64]> = Some(&[7, 19971130, 1]);
    }
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod cy_GB {
    pub mod LC_ADDRESS {
        /// `Some("GBR")`
        pub const COUNTRY_AB3: Option<&str> = Some("GBR");
        /// `Some("GB")`
        pub const COUNTRY_ABTWO: Option<&str> = Some("GB");
        /// `Some("GB")`
        pub const COUNTRY_CAR: Option<&str> = Some("GB");
        /// `Some("0")`
        pub const COUNTRY_ISBN: Option<&str> = Some("0");
        /// `Some("Y Deyrnas Unedig")`
        pub const COUNTRY_NAME: Option<&str> = Some("Y Deyrnas Unedig");
        /// `Some(826)`
        pub const COUNTRY_NUM: Option<i64> = Some(826);
        /// `Some("GB")`
        pub const COUNTRY_POST: Option<&str> = Some("GB");
        /// `Some("cy")`
        pub const LANG_AB: Option<&str> = Some("cy");
        /// `Some("wel")`
        pub const LANG_LIB: Option<&str> = Some("wel");
        /// `Some("Cymraeg")`
        pub const LANG_NAME: Option<&str> = Some("Cymraeg");
        /// `Some("cym")`
        pub const LANG_TERM: Option<&str> = Some("cym");
        /// `Some("%d%N%f%N%d%N%b%N%s %h 5e %r%N%C%z %T%N%c%N")`
        pub const POSTAL_FMT: Option<&str> = Some("%d%N%f%N%d%N%b%N%s %h 5e %r%N%C%z %T%N%c%N");
    }
    pub mod LC_IDENTIFICATION {
        /// `None`
        pub const ABBREVIATION: Option<&str> = None;
        /// `Some("")`
        pub const ADDRESS: Option<&str> = Some("");
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_MONETARY"],
        /// ]
        /// ```
        pub const CATEGORY: Option<&[&[&str]]> = Some(&[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_TELEPHONE"],
            &["i18n:2012", "LC_MEASUREMENT"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_MONETARY"],
        ]);
        /// `Some("Pablo Saratxaga")`
        pub const CONTACT: Option<&str> = Some("Pablo Saratxaga");
        /// `Some("2004-09-27")`
        pub const DATE: Option<&str> = Some("2004-09-27");
        /// `Some("pablo@mandrakesoft.com")`
        pub const EMAIL: Option<&str> = Some("pablo@mandrakesoft.com");
        /// `Some("")`
        pub const FAX: Option<&str> = Some("");
        /// `Some("Welsh")`
        pub const LANGUAGE: Option<&str> = Some("Welsh");
        /// `Some("0.9")`
        pub const REVISION: Option<&str> = Some("0.9");
        /// `Some("thanks to Dafydd Tomos (dafydd@imaginet.co.uk)")`
        pub const SOURCE: Option<&str> = Some("thanks to Dafydd Tomos (dafydd@imaginet.co.uk)");
        /// `Some("")`
        pub const TEL: Option<&str> = Some("");
        /// `Some("United Kingdom")`
        pub const TERRITORY: Option<&str> = Some("United Kingdom");
        /// `Some("Welsh language locale for Great Britain")`
        pub const TITLE: Option<&str> = Some("Welsh language locale for Great Britain");
    }
    pub mod LC_MESSAGES {
        /// `"^[-0nN]"`
        pub const NOEXPR: &str = "^[-0nN]";
        /// `Some("na")`
        pub const NOSTR: Option<&str> = Some("na");
        /// `"^[+1iItTyY]"`
        pub const YESEXPR: &str = "^[+1iItTyY]";
        /// `Some("ie")`
        pub const YESSTR: Option<&str> = Some("ie");
    }
    pub use super::en_GB::LC_MONETARY;
    pub use super::en_GB::LC_NUMERIC;
    pub use super::en_GB::LC_TELEPHONE;
    pub mod LC_TIME {
        /// `&["Sul", "Llu", "Maw", "Mer", "Iau", "Gwe", "Sad"]`
        pub const ABDAY: &[&str] = &["Sul", "Llu", "Maw", "Mer", "Iau", "Gwe", "Sad"];
        /// `&["Ion", "Chw", "Maw", "Ebr", "Mai", "Meh", "Gor", "Aws", "Med", "Hyd", "Tach", "Rha"]`
        pub const ABMON: &[&str] = &["Ion", "Chw", "Maw", "Ebr", "Mai", "Meh", "Gor", "Aws", "Med", "Hyd", "Tach", "Rha"];
        /// `None`
        pub const AB_ALT_MON: Option<&[&str]> = None;
        /// `None`
        pub const ALT_DIGITS: Option<&[&str]> = None;
        /// `None`
        pub const ALT_MON: Option<&[&str]> = None;
        /// `&["am", "pm"]`
        pub const AM_PM: &[&str] = &["am", "pm"];
        /// `None`
        pub const CAL_DIRECTION: Option<i64> = None;
        /// `Some("%a %e %b %H:%M:%S %Z %Y")`
        pub const DATE_FMT: Option<&str> = Some("%a %e %b %H:%M:%S %Z %Y");
        /// `&["Sul", "Llun", "Mawrth", "Mercher", "Iau", "Gwener", "Sadwrn"]`
        pub const DAY: &[&str] = &["Sul", "Llun", "Mawrth", "Mercher", "Iau", "Gwener", "Sadwrn"];
        /// `"%d.%m.%y"`
        pub const D_FMT: &str = "%d.%m.%y";
        /// `"Dydd %A %d mis %B %Y %T %Z"`
        pub const D_T_FMT: &str = "Dydd %A %d mis %B %Y %T %Z";
        /// `None`
        pub const ERA: Option<&[&str]> = None;
        /// `None`
        pub const ERA_D_FMT: Option<&str> = None;
        /// `None`
        pub const ERA_D_T_FMT: Option<&str> = None;
        /// `None`
        pub const ERA_T_FMT: Option<&str> = None;
        /// `Some(2)`
        pub const FIRST_WEEKDAY: Option<i64> = Some(2);
        /// `None`
        pub const FIRST_WORKDAY: Option<i64> = None;
        /// `&["Ionawr", "Chwefror", "Mawrth", "Ebrill", "Mai", "Mehefin", "Gorffennaf", "Awst", "Medi", "Hydref", "Tachwedd", "Rhagfyr"]`
        pub const MON: &[&str] = &["Ionawr", "Chwefror", "Mawrth", "Ebrill", "Mai", "Mehefin", "Gorffennaf", "Awst", "Medi", "Hydref", "Tachwedd", "Rhagfyr"];
        /// `"%T"`
        pub const T_FMT: &str = "%T";
        /// `"%l:%M:%S %P %Z"`
        pub const T_FMT_AMPM: &str = "%l:%M:%S %P %Z";
        /// `Some(&[7, 19971130, 4])`
        pub const WEEK: Option<&[i64]> = Some(&[7, 19971130, 4]);
    }
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod da_DK {
    pub mod LC_ADDRESS {
        /// `Some("DNK")`
        pub const COUNTRY_AB3: Option<&str> = Some("DNK");
        /// `Some("DK")`
        pub const COUNTRY_ABTWO: Option<&str> = Some("DK");
        /// `Some("DK")`
        pub const COUNTRY_CAR: Option<&str> = Some("DK");
        /// `None`
        pub const COUNTRY_ISBN: Option<&str> = None;
        /// `Some("Danmark")`
        pub const COUNTRY_NAME: Option<&str> = Some("Danmark");
        /// `Some(208)`
        pub const COUNTRY_NUM: Option<i64> = Some(208);
        /// `None`
        pub const COUNTRY_POST: Option<&str> = None;
        /// `Some("da")`
        pub const LANG_AB: Option<&str> = Some("da");
        /// `Some("dan")`
        pub const LANG_LIB: Option<&str> = Some("dan");
        /// `Some("dansk")`
        pub const LANG_NAME: Option<&str> = Some("dansk");
        /// `Some("dan")`
        pub const LANG_TERM: Option<&str> = Some("dan");
        /// `Some("%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%c%N")`
        pub const POSTAL_FMT: Option<&str> = Some("%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%c%N");
    }
    pub mod LC_IDENTIFICATION {
        /// `None`
        pub const ABBREVIATION: Option<&str> = None;
        /// `Some("Kollegievej 6, DK-2920 Charlottenlund, Danmark")`
        pub const ADDRESS: Option<&str> = Some("Kollegievej 6, DK-2920 Charlottenlund, Danmark");
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        /// ]
        /// ```
        pub const CATEGORY: Option<&[&[&str]]> = Some(&[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_TELEPHONE"],
            &["i18n:2012", "LC_MEASUREMENT"],
        ]);
        /// `Some("")`
        pub const CONTACT: Option<&str> = Some("");
        /// `Some("2000-06-29")`
        pub const DATE: Option<&str> = Some("2000-06-29");
        /// `Some("bug-glibc-locales@gnu.org")`
        pub const EMAIL: Option<&str> = Some("bug-glibc-locales@gnu.org");
        /// `Some("")`
        pub const FAX: Option<&str> = Some("");
        /// `Some("Danish")`
        pub const LANGUAGE: Option<&str> = Some("Danish");
        /// `Some("1.0")`
        pub const REVISION: Option<&str> = Some("1.0");
        /// `Some("Danish Standards Association")`
        pub const SOURCE: Option<&str> = Some("Danish Standards Association");
        /// `Some("")`
        pub const TEL: Option<&str> = Some("");
        /// `Some("Denmark")`
        pub const TERRITORY: Option<&str> = Some("Denmark");
        /// `Some("Danish locale for Denmark")`
        pub const TITLE: Option<&str> = Some("Danish locale for Denmark");
    }
    pub mod LC_MESSAGES {
        /// `"^[-0Nn]"`
        pub const NOEXPR: &str = "^[-0Nn]";
        /// `Some("nej")`
        pub const NOSTR: Option<&str> = Some("nej");
        /// `"^[+1JjYy]"`
        pub const YESEXPR: &str = "^[+1JjYy]";
        /// `Some("ja")`
        pub const YESSTR: Option<&str> = Some("ja");
    }
    pub mod LC_MONETARY {
        /// `"kr."`
        pub const CURRENCY_SYMBOL: &str = "kr.";
        /// `2`
        pub const FRAC_DIGITS: i64 = 2;
        /// `"DKK "`
        pub const INT_CURR_SYMBOL: &str = "DKK ";
        /// `2`
        pub const INT_FRAC_DIGITS: i64 = 2;
        /// `None`
        pub const INT_N_CS_PRECEDES: Option<i64> = None;
        /// `None`
        pub const INT_N_SEP_BY_SPACE: Option<i64> = None;
        /// `None`
        pub const INT_N_SIGN_POSN: Option<i64> = None;
        /// `None`
        pub const INT_P_CS_PRECEDES: Option<i64> = None;
        /// `None`
        pub const INT_P_SEP_BY_SPACE: Option<i64> = None;
        /// `None`
        pub const INT_P_SIGN_POSN: Option<i64> = None;
        /// `","`
        pub const MON_DECIMAL_POINT: &str = ",";
        /// `&[3, 3]`
        pub const MON_GROUPING: &[i64] = &[3, 3];
        /// `"."`
        pub const MON_THOUSANDS_SEP: &str = ".";
        /// `"-"`
        pub const NEGATIVE_SIGN: &str = "-";
        /// `1`
        pub const N_CS_PRECEDES: i64 = 1;
        /// `2`
        pub const N_SEP_BY_SPACE: i64 = 2;
        /// `4`
        pub const N_SIGN_POSN: i64 = 4;
        /// `""`
        pub const POSITIVE_SIGN: &str = "";
        /// `1`
        pub const P_CS_PRECEDES: i64 = 1;
        /// `2`
        pub const P_SEP_BY_SPACE: i64 = 2;
        /// `4`
        pub const P_SIGN_POSN: i64 = 4;
    }
    pub mod LC_NUMERIC {
        /// `","`
        pub const DECIMAL_POINT: &str = ",";
        /// `&[3, 3]`
        pub const GROUPING: &[i64] = &[3, 3];
        /// `"."`
        pub const THOUSANDS_SEP: &str = ".";
    }
    pub mod LC_TELEPHONE {
        /// `Some("45")`
        pub const INT_PREFIX: Option<&str> = Some("45");
        /// `Some("00")`
        pub const INT_SELECT: Option<&str> = Some("00");
        /// `None`
        pub const TEL_DOM_FMT: Option<&str> = None;
        /// `Some("+%c %a %l")`
        pub const TEL_INT_FMT: Option<&str> = Some("+%c %a %l");
    }
    pub mod LC_TIME {
        /// `&["søn", "man", "tir", "ons", "tor", "fre", "lør"]`
        pub const ABDAY: &[&str] = &["søn", "man", "tir", "ons", "tor", "fre", "lør"];
        /// `&["jan", "feb", "mar", "apr", "maj", "jun", "jul", "aug", "sep", "okt", "nov", "dec"]`
        pub const ABMON: &[&str] = &["jan", "feb", "mar", "apr", "maj", "jun", "jul", "aug", "sep", "okt", "nov", "dec"];
        /// `None`
        pub const AB_ALT_MON: Option<&[&str]> = None;
        /// `None`
        pub const ALT_DIGITS: Option<&[&str]> = None;
        /// `None`
        pub const ALT_MON: Option<&[&str]> = None;
        /// `&["", ""]`
        pub const AM_PM: &[&str] = &["", ""];
        /// `None`
        pub const CAL_DIRECTION: Option<i64> = None;
        /// `Some("%a %e %b %H:%M:%S %Z %Y")`
        pub const DATE_FMT: Option<&str> = Some("%a %e %b %H:%M:%S %Z %Y");
        /// `&["søndag", "mandag", "tirsdag", "onsdag", "torsdag", "fredag", "lørdag"]`
        pub const DAY: &[&str] = &["søndag", "mandag", "tirsdag", "onsdag", "torsdag", "fredag", "lørdag"];
        /// `"%d-%m-%Y"`
        pub const D_FMT: &str = "%d-%m-%Y";
        /// `"%a %d %b %Y %T %Z"`
        pub const D_T_FMT: &str = "%a %d %b %Y %T %Z";
        /// `None`
        pub const ERA: Option<&[&str]> = None;
        /// `None`
        pub const ERA_D_FMT: Option<&str> = None;
        /// `None`
        pub const ERA_D_T_FMT: Option<&str> = None;
        /// `None`
        pub const ERA_T_FMT: Option<&str> = None;
        /// `Some(2)`
        pub const FIRST_WEEKDAY: Option<i64> = Some(2);
        /// `None`
        pub const FIRST_WORKDAY: Option<i64> = None;
        /// `&["januar", "februar", "marts", "april", "maj", "juni", "juli", "august", "september", "oktober", "november", "december"]`
        pub const MON: &[&str] = &["januar", "februar", "marts", "april", "maj", "juni", "juli", "august", "september", "oktober", "november", "december"];
        /// `"%T"`
        pub const T_FMT: &str = "%T";
        /// `""`
        pub const T_FMT_AMPM: &str = "";
        /// `Some(&[7, 19971130, 4])`
        pub const WEEK: Option<&[i64]> = Some(&[7, 19971130, 4]);
    }
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod de_AT {
    pub mod LC_ADDRESS {
        /// `Some("AUT")`
        pub const COUNTRY_AB3: Option<&str> = Some("AUT");
        /// `Some("AT")`
        pub const COUNTRY_ABTWO: Option<&str> = Some("AT");
        /// `Some("A")`
        pub const COUNTRY_CAR: Option<&str> = Some("A");
        /// `None`
        pub const COUNTRY_ISBN: Option<&str> = None;
        /// `Some("Österreich")`
        pub const COUNTRY_NAME: Option<&str> = Some("Österreich");
        /// `Some(40)`
        pub const COUNTRY_NUM: Option<i64> = Some(40);
        /// `None`
        pub const COUNTRY_POST: Option<&str> = None;
        /// `Some("de")`
        pub const LANG_AB: Option<&str> = Some("de");
        /// `Some("ger")`
        pub const LANG_LIB: Option<&str> = Some("ger");
        /// `Some("Deutsch")`
        pub const LANG_NAME: Option<&str> = Some("Deutsch");
        /// `Some("deu")`
        pub const LANG_TERM: Option<&str> = Some("deu");
        /// `Some("%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%c%N")`
        pub const POSTAL_FMT: Option<&str> = Some("%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%c%N");
    }
    pub mod LC_IDENTIFICATION {
        /// `None`
        pub const ABBREVIATION: Option<&str> = None;
        /// `Some("Postfach 130, A-1021 Wien")`
        pub const ADDRESS: Option<&str> = Some("Postfach 130, A-1021 Wien");
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        /// ]
        /// ```
        pub const CATEGORY: Option<&[&[&str]]> = Some(&[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_TELEPHONE"],
            &["i18n:2012", "LC_MEASUREMENT"],
        ]);
        /// `Some("Gerhard Budin")`
        pub const CONTACT: Option<&str> = Some("Gerhard Budin");
        /// `Some("2000-06-28")`
        pub const DATE: Option<&str> = Some("2000-06-28");
        /// `Some("bug-glibc-locales@gnu.org")`
        pub const EMAIL: Option<&str> = Some("bug-glibc-locales@gnu.org");
        /// `Some("")`
        pub const FAX: Option<&str> = Some("");
        /// `Some("Austrian German")`
        pub const LANGUAGE: Option<&str> = Some("Austrian German");
        /// `Some("1.0")`
        pub const REVISION: Option<&str> = Some("1.0");
        /// `Some("O:sterreiches Normungsinstitut")`
        pub const SOURCE: Option<&str> = Some("O:sterreiches Normungsinstitut");
        /// `Some("")`
        pub const TEL: Option<&str> = Some("");
        /// `Some("Austria")`
        pub const TERRITORY: Option<&str> = Some("Austria");
        /// `Some("German locale for Austria")`
        pub const TITLE: Option<&str> = Some("German locale for Austria");
    }
    pub use super::de_DE::LC_MESSAGES;
    pub mod LC_MONETARY {
        /// `"€"`
        pub const CURRENCY_SYMBOL: &str = "€";
        /// `2`
        pub const FRAC_DIGITS: i64 = 2;
        /// `"EUR "`
        pub const INT_CURR_SYMBOL: &str = "EUR ";
        /// `2`
        pub const INT_FRAC_DIGITS: i64 = 2;
        /// `None`
        pub const INT_N_CS_PRECEDES: Option<i64> = None;
        /// `None`
        pub const INT_N_SEP_BY_SPACE: Option<i64> = None;
        /// `None`
        pub const INT_N_SIGN_POSN: Option<i64> = None;
        /// `None`
        pub const INT_P_CS_PRECEDES: Option<i64> = None;
        /// `None`
        pub const INT_P_SEP_BY_SPACE: Option<i64> = None;
        /// `None`
        pub const INT_P_SIGN_POSN: Option<i64> = None;
        /// `","`
        pub const MON_DECIMAL_POINT: &str = ",";
        /// `&[3, 3]`
        pub const MON_GROUPING: &[i64] = &[3, 3];
        /// `"\u{202f}"`
        pub const MON_THOUSANDS_SEP: &str = "\u{202f}";
        /// `"-"`
        pub const NEGATIVE_SIGN: &str = "-";
        /// `1`
        pub const N_CS_PRECEDES: i64 = 1;
        /// `1`
        pub const N_SEP_BY_SPACE: i64 = 1;
        /// `1`
        pub const N_SIGN_POSN: i64 = 1;
        /// `""`
        pub const POSITIVE_SIGN: &str = "";
        /// `1`
        pub const P_CS_PRECEDES: i64 = 1;
        /// `1`
        pub const P_SEP_BY_SPACE: i64 = 1;
        /// `1`
        pub const P_SIGN_POSN: i64 = 1;
    }
    pub use super::de_DE::LC_NUMERIC;
    pub mod LC_TELEPHONE {
        /// `Some("43")`
        pub const INT_PREFIX: Option<&str> = Some("43");
        /// `Some("00")`
        pub const INT_SELECT: Option<&str> = Some("00");
        /// `Some("%a %l")`
        pub const TEL_DOM_FMT: Option<&str> = Some("%a %l");
        /// `Some("+%c %a %l")`
        pub const TEL_INT_FMT: Option<&str> = Some("+%c %a %l");
    }
    pub mod LC_TIME {
        /// `&["So", "Mo", "Di", "Mi", "Do", "Fr", "Sa"]`
        pub const ABDAY: &[&str] = &["So", "Mo", "Di", "Mi", "Do", "Fr", "Sa"];
        /// `&["Jän", "Feb", "Mär", "Apr", "Mai", "Jun", "Jul", "Aug", "Sep", "Okt", "Nov", "Dez"]`
        pub const ABMON: &[&str] = &["Jän", "Feb", "Mär", "Apr", "Mai", "Jun", "Jul", "Aug", "Sep", "Okt", "Nov", "Dez"];
        /// `None`
        pub const AB_ALT_MON: Option<&[&str]> = None;
        /// `None`
        pub const ALT_DIGITS: Option<&[&str]> = None;
        /// `None`
        pub const ALT_MON: Option<&[&str]> = None;
        /// `&["", ""]`
        pub const AM_PM: &[&str] = &["", ""];
        /// `None`
        pub const CAL_DIRECTION: Option<i64> = None;
        /// `None`
        pub const DATE_FMT: Option<&str> = None;
        /// `&["Sonntag", "Montag", "Dienstag", "Mittwoch", "Donnerstag", "Freitag", "Samstag"]`
        pub const DAY: &[&str] = &["Sonntag", "Montag", "Dienstag", "Mittwoch", "Donnerstag", "Freitag", "Samstag"];
        /// `"%Y-%m-%d"`
        pub const D_FMT: &str = "%Y-%m-%d";
        /// `"%a %d %b %Y %T %Z"`
        pub const D_T_FMT: &str = "%a %d %b %Y %T %Z";
        /// `None`
        pub const ERA: Option<&[&str]> = None;
        /// `None`
        pub const ERA_D_FMT: Option<&str> = None;
        /// `None`
        pub const ERA_D_T_FMT: Option<&str> = None;
        /// `None`
        pub const ERA_T_FMT: Option<&str> = None;
        /// `Some(2)`
        pub const FIRST_WEEKDAY: Option<i64> = Some(2);
        /// `None`
        pub const FIRST_WORKDAY: Option<i64> = None;
        /// `&["Jänner", "Februar", "März", "April", "Mai", "Juni", "Juli", "August", "September", "Oktober", "November", "Dezember"]`
        pub const MON: &[&str] = &["Jänner", "Februar", "März", "April", "Mai", "Juni", "Juli", "August", "September", "Oktober", "November", "Dezember"];
        /// `"%T"`
        pub const T_FMT: &str = "%T";
        /// `""`
        pub const T_FMT_AMPM: &str = "";
        /// `Some(&[7, 19971130, 4])`
        pub const WEEK: Option<&[i64]> = Some(&[7, 19971130, 4]);
    }
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod de_AT_euro {
    pub use super::de_AT::LC_ADDRESS;
    pub mod LC_IDENTIFICATION {
        /// `None`
        pub const ABBREVIATION: Option<&str> = None;
        /// `Some("Postfach 130, A-1021 Wien")`
        pub const ADDRESS: Option<&str> = Some("Postfach 130, A-1021 Wien");
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        /// ]
        /// ```
        pub const CATEGORY: Option<&[&[&str]]> = Some(&[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_TELEPHONE"],
            &["i18n:2012", "LC_MEASUREMENT"],
        ]);
        /// `Some("Gerhard Budin")`
        pub const CONTACT: Option<&str> = Some("Gerhard Budin");
        /// `Some("2000-08-20")`
        pub const DATE: Option<&str> = Some("2000-08-20");
        /// `Some("bug-glibc-locales@gnu.org")`
        pub const EMAIL: Option<&str> = Some("bug-glibc-locales@gnu.org");
        /// `Some("")`
        pub const FAX: Option<&str> = Some("");
        /// `Some("German")`
        pub const LANGUAGE: Option<&str> = Some("German");
        /// `Some("1.0")`
        pub const REVISION: Option<&str> = Some("1.0");
        /// `Some("O:sterreiches Normungsinstitut")`
        pub const SOURCE: Option<&str> = Some("O:sterreiches Normungsinstitut");
        /// `Some("")`
        pub const TEL: Option<&str> = Some("");
        /// `Some("Austria")`
        pub const TERRITORY: Option<&str> = Some("Austria");
        /// `Some("German locale for Austria with Euro")`
        pub const TITLE: Option<&str> = Some("German locale for Austria with Euro");
    }
    pub use super::de_AT::LC_MESSAGES;
    pub use super::de_AT::LC_MONETARY;
    pub use super::de_AT::LC_NUMERIC;
    pub use super::de_AT::LC_TELEPHONE;
    pub use super::de_AT::LC_TIME;
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod de_BE {
    pub mod LC_ADDRESS {
        /// `Some("BEL")`
        pub const COUNTRY_AB3: Option<&str> = Some("BEL");
        /// `Some("BE")`
        pub const COUNTRY_ABTWO: Option<&str> = Some("BE");
        /// `Some("B")`
        pub const COUNTRY_CAR: Option<&str> = Some("B");
        /// `None`
        pub const COUNTRY_ISBN: Option<&str> = None;
        /// `Some("Belgien")`
        pub const COUNTRY_NAME: Option<&str> = Some("Belgien");
        /// `Some(56)`
        pub const COUNTRY_NUM: Option<i64> = Some(56);
        /// `None`
        pub const COUNTRY_POST: Option<&str> = None;
        /// `Some("de")`
        pub const LANG_AB: Option<&str> = Some("de");
        /// `Some("ger")`
        pub const LANG_LIB: Option<&str> = Some("ger");
        /// `Some("Deutsch")`
        pub const LANG_NAME: Option<&str> = Some("Deutsch");
        /// `Some("deu")`
        pub const LANG_TERM: Option<&str> = Some("deu");
        /// `Some("%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%c%N")`
        pub const POSTAL_FMT: Option<&str> = Some("%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%c%N");
    }
    pub mod LC_IDENTIFICATION {
        /// `None`
        pub const ABBREVIATION: Option<&str> = None;
        /// `Some("Sankt Jørgens Alle 8, DK-1615 København V, Danmark")`
        pub const ADDRESS: Option<&str> = Some("Sankt Jørgens Alle 8, DK-1615 København V, Danmark");
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        /// ]
        /// ```
        pub const CATEGORY: Option<&[&[&str]]> = Some(&[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_TELEPHONE"],
            &["i18n:2012", "LC_MEASUREMENT"],
        ]);
        /// `Some("")`
        pub const CONTACT: Option<&str> = Some("");
        /// `Some("2000-06-29")`
        pub const DATE: Option<&str> = Some("2000-06-29");
        /// `Some("bug-glibc-locales@gnu.org")`
        pub const EMAIL: Option<&str> = Some("bug-glibc-locales@gnu.org");
        /// `Some("")`
        pub const FAX: Option<&str> = Some("");
        /// `Some("German")`
        pub const LANGUAGE: Option<&str> = Some("German");
        /// `Some("1.0")`
        pub const REVISION: Option<&str> = Some("1.0");
        /// `Some("RAP")`
        pub const SOURCE: Option<&str> = Some("RAP");
        /// `Some("")`
        pub const TEL: Option<&str> = Some("");
        /// `Some("Belgium")`
        pub const TERRITORY: Option<&str> = Some("Belgium");
        /// `Some("German locale for Belgium")`
        pub const TITLE: Option<&str> = Some("German locale for Belgium");
    }
    pub use super::de_DE::LC_MESSAGES;
    pub mod LC_MONETARY {
        /// `"€"`
        pub const CURRENCY_SYMBOL: &str = "€";
        /// `2`
        pub const FRAC_DIGITS: i64 = 2;
        /// `"EUR "`
        pub const INT_CURR_SYMBOL: &str = "EUR ";
        /// `2`
        pub const INT_FRAC_DIGITS: i64 = 2;
        /// `None`
        pub const INT_N_CS_PRECEDES: Option<i64> = None;
        /// `None`
        pub const INT_N_SEP_BY_SPACE: Option<i64> = None;
        /// `None`
        pub const INT_N_SIGN_POSN: Option<i64> = None;
        /// `None`
        pub const INT_P_CS_PRECEDES: Option<i64> = None;
        /// `None`
        pub const INT_P_SEP_BY_SPACE: Option<i64> = None;
        /// `None`
        pub const INT_P_SIGN_POSN: Option<i64> = None;
        /// `","`
        pub const MON_DECIMAL_POINT: &str = ",";
        /// `&[3, 3]`
        pub const MON_GROUPING: &[i64] = &[3, 3];
        /// `"."`
        pub const MON_THOUSANDS_SEP: &str = ".";
        /// `"-"`
        pub const NEGATIVE_SIGN: &str = "-";
        /// `1`
        pub const N_CS_PRECEDES: i64 = 1;
        /// `1`
        pub const N_SEP_BY_SPACE: i64 = 1;
        /// `4`
        pub const N_SIGN_POSN: i64 = 4;
        /// `""`
        pub const POSITIVE_SIGN: &str = "";
        /// `1`
        pub const P_CS_PRECEDES: i64 = 1;
        /// `1`
        pub const P_SEP_BY_SPACE: i64 = 1;
        /// `4`
        pub const P_SIGN_POSN: i64 = 4;
    }
    pub use super::de_DE::LC_NUMERIC;
    pub use super::fr_BE::LC_TELEPHONE;
    pub mod LC_TIME {
        /// `&["So", "Mo", "Di", "Mi", "Do", "Fr", "Sa"]`
        pub const ABDAY: &[&str] = &["So", "Mo", "Di", "Mi", "Do", "Fr", "Sa"];
        /// `&["Jan", "Feb", "Mär", "Apr", "Mai", "Jun", "Jul", "Aug", "Sep", "Okt", "Nov", "Dez"]`
        pub const ABMON: &[&str] = &["Jan", "Feb", "Mär", "Apr", "Mai", "Jun", "Jul", "Aug", "Sep", "Okt", "Nov", "Dez"];
        /// `None`
        pub const AB_ALT_MON: Option<&[&str]> = None;
        /// `None`
        pub const ALT_DIGITS: Option<&[&str]> = None;
        /// `None`
        pub const ALT_MON: Option<&[&str]> = None;
        /// `&["", ""]`
        pub const AM_PM: &[&str] = &["", ""];
        /// `None`
        pub const CAL_DIRECTION: Option<i64> = None;
        /// `None`
        pub const DATE_FMT: Option<&str> = None;
        /// `&["Sonntag", "Montag", "Dienstag", "Mittwoch", "Donnerstag", "Freitag", "Samstag"]`
        pub const DAY: &[&str] = &["Sonntag", "Montag", "Dienstag", "Mittwoch", "Donnerstag", "Freitag", "Samstag"];
        /// `"%Y-%m-%d"`
        pub const D_FMT: &str = "%Y-%m-%d";
        /// `"%a %d %b %Y %T %Z"`
        pub const D_T_FMT: &str = "%a %d %b %Y %T %Z";
        /// `None`
        pub const ERA: Option<&[&str]> = None;
        /// `None`
        pub const ERA_D_FMT: Option<&str> = None;
        /// `None`
        pub const ERA_D_T_FMT: Option<&str> = None;
        /// `None`
        pub const ERA_T_FMT: Option<&str> = None;
        /// `Some(2)`
        pub const FIRST_WEEKDAY: Option<i64> = Some(2);
        /// `None`
        pub const FIRST_WORKDAY: Option<i64> = None;
        /// `&["Januar", "Februar", "März", "April", "Mai", "Juni", "Juli", "August", "September", "Oktober", "November", "Dezember"]`
        pub const MON: &[&str] = &["Januar", "Februar", "März", "April", "Mai", "Juni", "Juli", "August", "September", "Oktober", "November", "Dezember"];
        /// `"%T"`
        pub const T_FMT: &str = "%T";
        /// `""`
        pub const T_FMT_AMPM: &str = "";
        /// `Some(&[7, 19971130, 4])`
        pub const WEEK: Option<&[i64]> = Some(&[7, 19971130, 4]);
    }
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod de_BE_euro {
    pub use super::de_BE::LC_ADDRESS;
    pub mod LC_IDENTIFICATION {
        /// `None`
        pub const ABBREVIATION: Option<&str> = None;
        /// `Some("https://www.gnu.org/software/libc/")`
        pub const ADDRESS: Option<&str> = Some("https://www.gnu.org/software/libc/");
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        /// ]
        /// ```
        pub const CATEGORY: Option<&[&[&str]]> = Some(&[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_TELEPHONE"],
            &["i18n:2012", "LC_MEASUREMENT"],
        ]);
        /// `Some("")`
        pub const CONTACT: Option<&str> = Some("");
        /// `Some("2000-08-21")`
        pub const DATE: Option<&str> = Some("2000-08-21");
        /// `Some("bug-glibc-locales@gnu.org")`
        pub const EMAIL: Option<&str> = Some("bug-glibc-locales@gnu.org");
        /// `Some("")`
        pub const FAX: Option<&str> = Some("");
        /// `Some("German")`
        pub const LANGUAGE: Option<&str> = Some("German");
        /// `Some("1.0")`
        pub const REVISION: Option<&str> = Some("1.0");
        /// `Some("Free Software Foundation, Inc.")`
        pub const SOURCE: Option<&str> = Some("Free Software Foundation, Inc.");
        /// `Some("")`
        pub const TEL: Option<&str> = Some("");
        /// `Some("Belgium")`
        pub const TERRITORY: Option<&str> = Some("Belgium");
        /// `Some("German locale for Belgium with Euro")`
        pub const TITLE: Option<&str> = Some("German locale for Belgium with Euro");
    }
    pub use super::de_BE::LC_MESSAGES;
    pub use super::de_BE::LC_MONETARY;
    pub use super::de_BE::LC_NUMERIC;
    pub use super::de_BE::LC_TELEPHONE;
    pub use super::de_BE::LC_TIME;
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod de_CH {
    pub mod LC_ADDRESS {
        /// `Some("CHE")`
        pub const COUNTRY_AB3: Option<&str> = Some("CHE");
        /// `Some("CH")`
        pub const COUNTRY_ABTWO: Option<&str> = Some("CH");
        /// `Some("CH")`
        pub const COUNTRY_CAR: Option<&str> = Some("CH");
        /// `None`
        pub const COUNTRY_ISBN: Option<&str> = None;
        /// `Some("Schweiz")`
        pub const COUNTRY_NAME: Option<&str> = Some("Schweiz");
        /// `Some(756)`
        pub const COUNTRY_NUM: Option<i64> = Some(756);
        /// `None`
        pub const COUNTRY_POST: Option<&str> = None;
        /// `Some("de")`
        pub const LANG_AB: Option<&str> = Some("de");
        /// `Some("ger")`
        pub const LANG_LIB: Option<&str> = Some("ger");
        /// `Some("Deutsch")`
        pub const LANG_NAME: Option<&str> = Some("Deutsch");
        /// `Some("deu")`
        pub const LANG_TERM: Option<&str> = Some("deu");
        /// `Some("%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%c%N")`
        pub const POSTAL_FMT: Option<&str> = Some("%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%c%N");
    }
    pub mod LC_IDENTIFICATION {
        /// `None`
        pub const ABBREVIATION: Option<&str> = None;
        /// `Some("Sankt Jørgens Alle 8, DK-1615 København V, Danmark")`
        pub const ADDRESS: Option<&str> = Some("Sankt Jørgens Alle 8, DK-1615 København V, Danmark");
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        /// ]
        /// ```
        pub const CATEGORY: Option<&[&[&str]]> = Some(&[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_TELEPHONE"],
            &["i18n:2012", "LC_MEASUREMENT"],
        ]);
        /// `Some("")`
        pub const CONTACT: Option<&str> = Some("");
        /// `Some("2007-09-23")`
        pub const DATE: Option<&str> = Some("2007-09-23");
        /// `Some("bug-glibc-locales@gnu.org")`
        pub const EMAIL: Option<&str> = Some("bug-glibc-locales@gnu.org");
        /// `Some("")`
        pub const FAX: Option<&str> = Some("");
        /// `Some("Swiss High German")`
        pub const LANGUAGE: Option<&str> = Some("Swiss High German");
        /// `Some("1.0")`
        pub const REVISION: Option<&str> = Some("1.0");
        /// `Some("RAP")`
        pub const SOURCE: Option<&str> = Some("RAP");
        /// `Some("")`
        pub const TEL: Option<&str> = Some("");
        /// `Some("Switzerland")`
        pub const TERRITORY: Option<&str> = Some("Switzerland");
        /// `Some("German locale for Switzerland")`
        pub const TITLE: Option<&str> = Some("German locale for Switzerland");
    }
    pub use super::de_DE::LC_MESSAGES;
    pub mod LC_MONETARY {
        /// `"CHF"`
        pub const CURRENCY_SYMBOL: &str = "CHF";
        /// `2`
        pub const FRAC_DIGITS: i64 = 2;
        /// `"CHF "`
        pub const INT_CURR_SYMBOL: &str = "CHF ";
        /// `2`
        pub const INT_FRAC_DIGITS: i64 = 2;
        /// `None`
        pub const INT_N_CS_PRECEDES: Option<i64> = None;
        /// `None`
        pub const INT_N_SEP_BY_SPACE: Option<i64> = None;
        /// `None`
        pub const INT_N_SIGN_POSN: Option<i64> = None;
        /// `None`
        pub const INT_P_CS_PRECEDES: Option<i64> = None;
        /// `None`
        pub const INT_P_SEP_BY_SPACE: Option<i64> = None;
        /// `None`
        pub const INT_P_SIGN_POSN: Option<i64> = None;
        /// `"."`
        pub const MON_DECIMAL_POINT: &str = ".";
        /// `&[3, 3]`
        pub const MON_GROUPING: &[i64] = &[3, 3];
        /// `"’"`
        pub const MON_THOUSANDS_SEP: &str = "’";
        /// `"-"`
        pub const NEGATIVE_SIGN: &str = "-";
        /// `1`
        pub const N_CS_PRECEDES: i64 = 1;
        /// `1`
        pub const N_SEP_BY_SPACE: i64 = 1;
        /// `4`
        pub const N_SIGN_POSN: i64 = 4;
        /// `""`
        pub const POSITIVE_SIGN: &str = "";
        /// `1`
        pub const P_CS_PRECEDES: i64 = 1;
        /// `1`
        pub const P_SEP_BY_SPACE: i64 = 1;
        /// `4`
        pub const P_SIGN_POSN: i64 = 4;
    }
    pub mod LC_NUMERIC {
        /// `"."`
        pub const DECIMAL_POINT: &str = ".";
        /// `&[3, 3]`
        pub const GROUPING: &[i64] = &[3, 3];
        /// `"’"`
        pub const THOUSANDS_SEP: &str = "’";
    }
    pub mod LC_TELEPHONE {
        /// `Some("41")`
        pub const INT_PREFIX: Option<&str> = Some("41");
        /// `Some("00")`
        pub const INT_SELECT: Option<&str> = Some("00");
        /// `None`
        pub const TEL_DOM_FMT: Option<&str> = None;
        /// `Some("+%c %a %l")`
        pub const TEL_INT_FMT: Option<&str> = Some("+%c %a %l");
    }
    pub mod LC_TIME {
        /// `&["So", "Mo", "Di", "Mi", "Do", "Fr", "Sa"]`
        pub const ABDAY: &[&str] = &["So", "Mo", "Di", "Mi", "Do", "Fr", "Sa"];
        /// `&["Jan", "Feb", "Mär", "Apr", "Mai", "Jun", "Jul", "Aug", "Sep", "Okt", "Nov", "Dez"]`
        pub const ABMON: &[&str] = &["Jan", "Feb", "Mär", "Apr", "Mai", "Jun", "Jul", "Aug", "Sep", "Okt", "Nov", "Dez"];
        /// `None`
        pub const AB_ALT_MON: Option<&[&str]> = None;
        /// `None`
        pub const ALT_DIGITS: Option<&[&str]> = None;
        /// `None`
        pub const ALT_MON: Option<&[&str]> = None;
        /// `&["", ""]`
        pub const AM_PM: &[&str] = &["", ""];
        /// `None`
        pub const CAL_DIRECTION: Option<i64> = None;
        /// `None`
        pub const DATE_FMT: Option<&str> = None;
        /// `&["Sonntag", "Montag", "Dienstag", "Mittwoch", "Donnerstag", "Freitag", "Samstag"]`
        pub const DAY: &[&str] = &["Sonntag", "Montag", "Dienstag", "Mittwoch", "Donnerstag", "Freitag", "Samstag"];
        /// `"%d.%m.%Y"`
        pub const D_FMT: &str = "%d.%m.%Y";
        /// `"%a %d %b %Y %T %Z"`
        pub const D_T_FMT: &str = "%a %d %b %Y %T %Z";
        /// `None`
        pub const ERA: Option<&[&str]> = None;
        /// `None`
        pub const ERA_D_FMT: Option<&str> = None;
        /// `None`
        pub const ERA_D_T_FMT: Option<&str> = None;
        /// `None`
        pub const ERA_T_FMT: Option<&str> = None;
        /// `Some(2)`
        pub const FIRST_WEEKDAY: Option<i64> = Some(2);
        /// `None`
        pub const FIRST_WORKDAY: Option<i64> = None;
        /// `&["Januar", "Februar", "März", "April", "Mai", "Juni", "Juli", "August", "September", "Oktober", "November", "Dezember"]`
        pub const MON: &[&str] = &["Januar", "Februar", "März", "April", "Mai", "Juni", "Juli", "August", "September", "Oktober", "November", "Dezember"];
        /// `"%T"`
        pub const T_FMT: &str = "%T";
        /// `""`
        pub const T_FMT_AMPM: &str = "";
        /// `Some(&[7, 19971130, 4])`
        pub const WEEK: Option<&[i64]> = Some(&[7, 19971130, 4]);
    }
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod de_DE {
    pub mod LC_ADDRESS {
        /// `Some("DEU")`
        pub const COUNTRY_AB3: Option<&str> = Some("DEU");
        /// `Some("DE")`
        pub const COUNTRY_ABTWO: Option<&str> = Some("DE");
        /// `Some("D")`
        pub const COUNTRY_CAR: Option<&str> = Some("D");
        /// `Some("3")`
        pub const COUNTRY_ISBN: Option<&str> = Some("3");
        /// `Some("Deutschland")`
        pub const COUNTRY_NAME: Option<&str> = Some("Deutschland");
        /// `Some(276)`
        pub const COUNTRY_NUM: Option<i64> = Some(276);
        /// `Some("D")`
        pub const COUNTRY_POST: Option<&str> = Some("D");
        /// `Some("de")`
        pub const LANG_AB: Option<&str> = Some("de");
        /// `Some("ger")`
        pub const LANG_LIB: Option<&str> = Some("ger");
        /// `Some("Deutsch")`
        pub const LANG_NAME: Option<&str> = Some("Deutsch");
        /// `Some("deu")`
        pub const LANG_TERM: Option<&str> = Some("deu");
        /// `Some("%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%c%N")`
        pub const POSTAL_FMT: Option<&str> = Some("%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%c%N");
    }
    pub mod LC_IDENTIFICATION {
        /// `None`
        pub const ABBREVIATION: Option<&str> = None;
        /// `Some("https://www.gnu.org/software/libc/")`
        pub const ADDRESS: Option<&str> = Some("https://www.gnu.org/software/libc/");
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        /// ]
        /// ```
        pub const CATEGORY: Option<&[&[&str]]> = Some(&[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_TELEPHONE"],
            &["i18n:2012", "LC_MEASUREMENT"],
        ]);
        /// `Some("")`
        pub const CONTACT: Option<&str> = Some("");
        /// `Some("2000-06-24")`
        pub const DATE: Option<&str> = Some("2000-06-24");
        /// `Some("bug-glibc-locales@gnu.org")`
        pub const EMAIL: Option<&str> = Some("bug-glibc-locales@gnu.org");
        /// `Some("")`
        pub const FAX: Option<&str> = Some("");
        /// `Some("German")`
        pub const LANGUAGE: Option<&str> = Some("German");
        /// `Some("1.0")`
        pub const REVISION: Option<&str> = Some("1.0");
        /// `Some("Free Software Foundation, Inc.")`
        pub const SOURCE: Option<&str> = Some("Free Software Foundation, Inc.");
        /// `Some("")`
        pub const TEL: Option<&str> = Some("");
        /// `Some("Germany")`
        pub const TERRITORY: Option<&str> = Some("Germany");
        /// `Some("German locale for Germany")`
        pub const TITLE: Option<&str> = Some("German locale for Germany");
    }
    pub mod LC_MESSAGES {
        /// `"^[-0nN]"`
        pub const NOEXPR: &str = "^[-0nN]";
        /// `Some("nein")`
        pub const NOSTR: Option<&str> = Some("nein");
        /// `"^[+1jJyY]"`
        pub const YESEXPR: &str = "^[+1jJyY]";
        /// `Some("ja")`
        pub const YESSTR: Option<&str> = Some("ja");
    }
    pub mod LC_MONETARY {
        /// `"€"`
        pub const CURRENCY_SYMBOL: &str = "€";
        /// `2`
        pub const FRAC_DIGITS: i64 = 2;
        /// `"EUR "`
        pub const INT_CURR_SYMBOL: &str = "EUR ";
        /// `2`
        pub const INT_FRAC_DIGITS: i64 = 2;
        /// `None`
        pub const INT_N_CS_PRECEDES: Option<i64> = None;
        /// `None`
        pub const INT_N_SEP_BY_SPACE: Option<i64> = None;
        /// `None`
        pub const INT_N_SIGN_POSN: Option<i64> = None;
        /// `None`
        pub const INT_P_CS_PRECEDES: Option<i64> = None;
        /// `None`
        pub const INT_P_SEP_BY_SPACE: Option<i64> = None;
        /// `None`
        pub const INT_P_SIGN_POSN: Option<i64> = None;
        /// `","`
        pub const MON_DECIMAL_POINT: &str = ",";
        /// `&[3, 3]`
        pub const MON_GROUPING: &[i64] = &[3, 3];
        /// `"."`
        pub const MON_THOUSANDS_SEP: &str = ".";
        /// `"-"`
        pub const NEGATIVE_SIGN: &str = "-";
        /// `0`
        pub const N_CS_PRECEDES: i64 = 0;
        /// `1`
        pub const N_SEP_BY_SPACE: i64 = 1;
        /// `1`
        pub const N_SIGN_POSN: i64 = 1;
        /// `""`
        pub const POSITIVE_SIGN: &str = "";
        /// `0`
        pub const P_CS_PRECEDES: i64 = 0;
        /// `1`
        pub const P_SEP_BY_SPACE: i64 = 1;
        /// `1`
        pub const P_SIGN_POSN: i64 = 1;
    }
    pub mod LC_NUMERIC {
        /// `","`
        pub const DECIMAL_POINT: &str = ",";
        /// `&[3, 3]`
        pub const GROUPING: &[i64] = &[3, 3];
        /// `"."`
        pub const THOUSANDS_SEP: &str = ".";
    }
    pub mod LC_TELEPHONE {
        /// `Some("49")`
        pub const INT_PREFIX: Option<&str> = Some("49");
        /// `Some("00")`
        pub const INT_SELECT: Option<&str> = Some("00");
        /// `Some("%A %l")`
        pub const TEL_DOM_FMT: Option<&str> = Some("%A %l");
        /// `Some("+%c %a %l")`
        pub const TEL_INT_FMT: Option<&str> = Some("+%c %a %l");
    }
    pub mod LC_TIME {
        /// `&["So", "Mo", "Di", "Mi", "Do", "Fr", "Sa"]`
        pub const ABDAY: &[&str] = &["So", "Mo", "Di", "Mi", "Do", "Fr", "Sa"];
        /// `&["Jan", "Feb", "Mär", "Apr", "Mai", "Jun", "Jul", "Aug", "Sep", "Okt", "Nov", "Dez"]`
        pub const ABMON: &[&str] = &["Jan", "Feb", "Mär", "Apr", "Mai", "Jun", "Jul", "Aug", "Sep", "Okt", "Nov", "Dez"];
        /// `None`
        pub const AB_ALT_MON: Option<&[&str]> = None;
        /// `None`
        pub const ALT_DIGITS: Option<&[&str]> = None;
        /// `None`
        pub const ALT_MON: Option<&[&str]> = None;
        /// `&["", ""]`
        pub const AM_PM: &[&str] = &["", ""];
        /// `None`
        pub const CAL_DIRECTION: Option<i64> = None;
        /// `Some("%a %-d. %b %H:%M:%S %Z %Y")`
        pub const DATE_FMT: Option<&str> = Some("%a %-d. %b %H:%M:%S %Z %Y");
        /// `&["Sonntag", "Montag", "Dienstag", "Mittwoch", "Donnerstag", "Freitag", "Samstag"]`
        pub const DAY: &[&str] = &["Sonntag", "Montag", "Dienstag", "Mittwoch", "Donnerstag", "Freitag", "Samstag"];
        /// `"%d.%m.%Y"`
        pub const D_FMT: &str = "%d.%m.%Y";
        /// `"%a %d %b %Y %T %Z"`
        pub const D_T_FMT: &str = "%a %d %b %Y %T %Z";
        /// `None`
        pub const ERA: Option<&[&str]> = None;
        /// `None`
        pub const ERA_D_FMT: Option<&str> = None;
        /// `None`
        pub const ERA_D_T_FMT: Option<&str> = None;
        /// `None`
        pub const ERA_T_FMT: Option<&str> = None;
        /// `Some(2)`
        pub const FIRST_WEEKDAY: Option<i64> = Some(2);
        /// `None`
        pub const FIRST_WORKDAY: Option<i64> = None;
        /// `&["Januar", "Februar", "März", "April", "Mai", "Juni", "Juli", "August", "September", "Oktober", "November", "Dezember"]`
        pub const MON: &[&str] = &["Januar", "Februar", "März", "April", "Mai", "Juni", "Juli", "August", "September", "Oktober", "November", "Dezember"];
        /// `"%T"`
        pub const T_FMT: &str = "%T";
        /// `""`
        pub const T_FMT_AMPM: &str = "";
        /// `Some(&[7, 19971130, 4])`
        pub const WEEK: Option<&[i64]> = Some(&[7, 19971130, 4]);
    }
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod de_DE_euro {
    pub use super::de_DE::LC_ADDRESS;
    pub mod LC_IDENTIFICATION {
        /// `None`
        pub const ABBREVIATION: Option<&str> = None;
        /// `Some("https://www.gnu.org/software/libc/")`
        pub const ADDRESS: Option<&str> = Some("https://www.gnu.org/software/libc/");
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        /// ]
        /// ```
        pub const CATEGORY: Option<&[&[&str]]> = Some(&[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_TELEPHONE"],
            &["i18n:2012", "LC_MEASUREMENT"],
        ]);
        /// `Some("")`
        pub const CONTACT: Option<&str> = Some("");
        /// `Some("2000-06-24")`
        pub const DATE: Option<&str> = Some("2000-06-24");
        /// `Some("bug-glibc-locales@gnu.org")`
        pub const EMAIL: Option<&str> = Some("bug-glibc-locales@gnu.org");
        /// `Some("")`
        pub const FAX: Option<&str> = Some("");
        /// `Some("German")`
        pub const LANGUAGE: Option<&str> = Some("German");
        /// `Some("1.0")`
        pub const REVISION: Option<&str> = Some("1.0");
        /// `Some("Free Software Foundation, Inc.")`
        pub const SOURCE: Option<&str> = Some("Free Software Foundation, Inc.");
        /// `Some("")`
        pub const TEL: Option<&str> = Some("");
        /// `Some("Germany")`
        pub const TERRITORY: Option<&str> = Some("Germany");
        /// `Some("German locale for Germany with Euro")`
        pub const TITLE: Option<&str> = Some("German locale for Germany with Euro");
    }
    pub use super::de_DE::LC_MESSAGES;
    pub use super::de_DE::LC_MONETARY;
    pub use super::de_DE::LC_NUMERIC;
    pub use super::de_DE::LC_TELEPHONE;
    pub use super::de_DE::LC_TIME;
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod de_IT {
    pub mod LC_ADDRESS {
        /// `Some("ITA")`
        pub const COUNTRY_AB3: Option<&str> = Some("ITA");
        /// `Some("IT")`
        pub const COUNTRY_ABTWO: Option<&str> = Some("IT");
        /// `Some("I")`
        pub const COUNTRY_CAR: Option<&str> = Some("I");
        /// `Some("978-88,979-12")`
        pub const COUNTRY_ISBN: Option<&str> = Some("978-88,979-12");
        /// `Some("Italien")`
        pub const COUNTRY_NAME: Option<&str> = Some("Italien");
        /// `Some(380)`
        pub const COUNTRY_NUM: Option<i64> = Some(380);
        /// `None`
        pub const COUNTRY_POST: Option<&str> = None;
        /// `Some("de")`
        pub const LANG_AB: Option<&str> = Some("de");
        /// `Some("ger")`
        pub const LANG_LIB: Option<&str> = Some("ger");
        /// `Some("Deutsch")`
        pub const LANG_NAME: Option<&str> = Some("Deutsch");
        /// `Some("deu")`
        pub const LANG_TERM: Option<&str> = Some("deu");
        /// `Some("%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%c%N")`
        pub const POSTAL_FMT: Option<&str> = Some("%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%c%N");
    }
    pub mod LC_IDENTIFICATION {
        /// `None`
        pub const ABBREVIATION: Option<&str> = None;
        /// `Some("I-39100 Bolzano/Bozen")`
        pub const ADDRESS: Option<&str> = Some("I-39100 Bolzano/Bozen");
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        /// ]
        /// ```
        pub const CATEGORY: Option<&[&[&str]]> = Some(&[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_TELEPHONE"],
            &["i18n:2012", "LC_MEASUREMENT"],
        ]);
        /// `Some("Matthias Dieter Wallno:fer")`
        pub const CONTACT: Option<&str> = Some("Matthias Dieter Wallno:fer");
        /// `Some("2000-06-28")`
        pub const DATE: Option<&str> = Some("2000-06-28");
        /// `Some("libc-locales@sourceware.org")`
        pub const EMAIL: Option<&str> = Some("libc-locales@sourceware.org");
        /// `Some("")`
        pub const FAX: Option<&str> = Some("");
        /// `Some("German")`
        pub const LANGUAGE: Option<&str> = Some("German");
        /// `Some("1.0")`
        pub const REVISION: Option<&str> = Some("1.0");
        /// `Some("")`
        pub const SOURCE: Option<&str> = Some("");
        /// `Some("")`
        pub const TEL: Option<&str> = Some("");
        /// `Some("Italy")`
        pub const TERRITORY: Option<&str> = Some("Italy");
        /// `Some("German language locale for Italy")`
        pub const TITLE: Option<&str> = Some("German language locale for Italy");
    }
    pub use super::de_DE::LC_MESSAGES;
    pub use super::it_IT::LC_MONETARY;
    pub use super::de_DE::LC_NUMERIC;
    pub use super::it_IT::LC_TELEPHONE;
    pub mod LC_TIME {
        /// `&["So", "Mo", "Di", "Mi", "Do", "Fr", "Sa"]`
        pub const ABDAY: &[&str] = &["So", "Mo", "Di", "Mi", "Do", "Fr", "Sa"];
        /// `&["Jän", "Feb", "Mär", "Apr", "Mai", "Jun", "Jul", "Aug", "Sep", "Okt", "Nov", "Dez"]`
        pub const ABMON: &[&str] = &["Jän", "Feb", "Mär", "Apr", "Mai", "Jun", "Jul", "Aug", "Sep", "Okt", "Nov", "Dez"];
        /// `None`
        pub const AB_ALT_MON: Option<&[&str]> = None;
        /// `None`
        pub const ALT_DIGITS: Option<&[&str]> = None;
        /// `None`
        pub const ALT_MON: Option<&[&str]> = None;
        /// `&["", ""]`
        pub const AM_PM: &[&str] = &["", ""];
        /// `None`
        pub const CAL_DIRECTION: Option<i64> = None;
        /// `Some("%a %-d. %b %H:%M:%S %Z %Y")`
        pub const DATE_FMT: Option<&str> = Some("%a %-d. %b %H:%M:%S %Z %Y");
        /// `&["Sonntag", "Montag", "Dienstag", "Mittwoch", "Donnerstag", "Freitag", "Samstag"]`
        pub const DAY: &[&str] = &["Sonntag", "Montag", "Dienstag", "Mittwoch", "Donnerstag", "Freitag", "Samstag"];
        /// `"%d.%m.%Y"`
        pub const D_FMT: &str = "%d.%m.%Y";
        /// `"%a %d %b %Y %T %Z"`
        pub const D_T_FMT: &str = "%a %d %b %Y %T %Z";
        /// `None`
        pub const ERA: Option<&[&str]> = None;
        /// `None`
        pub const ERA_D_FMT: Option<&str> = None;
        /// `None`
        pub const ERA_D_T_FMT: Option<&str> = None;
        /// `None`
        pub const ERA_T_FMT: Option<&str> = None;
        /// `Some(2)`
        pub const FIRST_WEEKDAY: Option<i64> = Some(2);
        /// `None`
        pub const FIRST_WORKDAY: Option<i64> = None;
        /// `&["Jänner", "Februar", "März", "April", "Mai", "Juni", "Juli", "August", "September", "Oktober", "November", "Dezember"]`
        pub const MON: &[&str] = &["Jänner", "Februar", "März", "April", "Mai", "Juni", "Juli", "August", "September", "Oktober", "November", "Dezember"];
        /// `"%T"`
        pub const T_FMT: &str = "%T";
        /// `""`
        pub const T_FMT_AMPM: &str = "";
        /// `Some(&[7, 19971130, 4])`
        pub const WEEK: Option<&[i64]> = Some(&[7, 19971130, 4]);
    }
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod de_LI {
    pub mod LC_ADDRESS {
        /// `Some("LIE")`
        pub const COUNTRY_AB3: Option<&str> = Some("LIE");
        /// `Some("LI")`
        pub const COUNTRY_ABTWO: Option<&str> = Some("LI");
        /// `Some("FL")`
        pub const COUNTRY_CAR: Option<&str> = Some("FL");
        /// `None`
        pub const COUNTRY_ISBN: Option<&str> = None;
        /// `Some("Liechtenstein")`
        pub const COUNTRY_NAME: Option<&str> = Some("Liechtenstein");
        /// `Some(438)`
        pub const COUNTRY_NUM: Option<i64> = Some(438);
        /// `Some("LI")`
        pub const COUNTRY_POST: Option<&str> = Some("LI");
        /// `Some("de")`
        pub const LANG_AB: Option<&str> = Some("de");
        /// `Some("ger")`
        pub const LANG_LIB: Option<&str> = Some("ger");
        /// `Some("Deutsch")`
        pub const LANG_NAME: Option<&str> = Some("Deutsch");
        /// `Some("deu")`
        pub const LANG_TERM: Option<&str> = Some("deu");
        /// `Some("%f%N%a%N%d%N%b%N%s %h %e %r%N%%z %T%N%c%N")`
        pub const POSTAL_FMT: Option<&str> = Some("%f%N%a%N%d%N%b%N%s %h %e %r%N%%z %T%N%c%N");
    }
    pub mod LC_IDENTIFICATION {
        /// `None`
        pub const ABBREVIATION: Option<&str> = None;
        /// `Some("")`
        pub const ADDRESS: Option<&str> = Some("");
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        /// ]
        /// ```
        pub const CATEGORY: Option<&[&[&str]]> = Some(&[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_TELEPHONE"],
        ]);
        /// `Some("")`
        pub const CONTACT: Option<&str> = Some("");
        /// `Some("2007-11-27")`
        pub const DATE: Option<&str> = Some("2007-11-27");
        /// `Some("bug-glibc-locales@gnu.org")`
        pub const EMAIL: Option<&str> = Some("bug-glibc-locales@gnu.org");
        /// `Some("")`
        pub const FAX: Option<&str> = Some("");
        /// `Some("German")`
        pub const LANGUAGE: Option<&str> = Some("German");
        /// `Some("1.0")`
        pub const REVISION: Option<&str> = Some("1.0");
        /// `Some("")`
        pub const SOURCE: Option<&str> = Some("");
        /// `Some("")`
        pub const TEL: Option<&str> = Some("");
        /// `Some("Liechtenstein")`
        pub const TERRITORY: Option<&str> = Some("Liechtenstein");
        /// `Some("German locale for Liechtenstein")`
        pub const TITLE: Option<&str> = Some("German locale for Liechtenstein");
    }
    pub use super::de_CH::LC_MESSAGES;
    pub use super::de_CH::LC_MONETARY;
    pub use super::de_CH::LC_NUMERIC;
    pub mod LC_TELEPHONE {
        /// `Some("423")`
        pub const INT_PREFIX: Option<&str> = Some("423");
        /// `Some("00")`
        pub const INT_SELECT: Option<&str> = Some("00");
        /// `None`
        pub const TEL_DOM_FMT: Option<&str> = None;
        /// `Some("+%c %a %l")`
        pub const TEL_INT_FMT: Option<&str> = Some("+%c %a %l");
    }
    pub use super::de_CH::LC_TIME;
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod de_LU {
    pub mod LC_ADDRESS {
        /// `Some("LUX")`
        pub const COUNTRY_AB3: Option<&str> = Some("LUX");
        /// `Some("LU")`
        pub const COUNTRY_ABTWO: Option<&str> = Some("LU");
        /// `Some("L")`
        pub const COUNTRY_CAR: Option<&str> = Some("L");
        /// `None`
        pub const COUNTRY_ISBN: Option<&str> = None;
        /// `Some("Luxemburg")`
        pub const COUNTRY_NAME: Option<&str> = Some("Luxemburg");
        /// `Some(442)`
        pub const COUNTRY_NUM: Option<i64> = Some(442);
        /// `None`
        pub const COUNTRY_POST: Option<&str> = None;
        /// `Some("de")`
        pub const LANG_AB: Option<&str> = Some("de");
        /// `Some("ger")`
        pub const LANG_LIB: Option<&str> = Some("ger");
        /// `Some("Deutsch")`
        pub const LANG_NAME: Option<&str> = Some("Deutsch");
        /// `Some("deu")`
        pub const LANG_TERM: Option<&str> = Some("deu");
        /// `Some("%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%c%N")`
        pub const POSTAL_FMT: Option<&str> = Some("%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%c%N");
    }
    pub mod LC_IDENTIFICATION {
        /// `None`
        pub const ABBREVIATION: Option<&str> = None;
        /// `Some("Sankt Jørgens Alle 8, DK-1615 København V, Danmark")`
        pub const ADDRESS: Option<&str> = Some("Sankt Jørgens Alle 8, DK-1615 København V, Danmark");
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        /// ]
        /// ```
        pub const CATEGORY: Option<&[&[&str]]> = Some(&[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_TELEPHONE"],
            &["i18n:2012", "LC_MEASUREMENT"],
        ]);
        /// `Some("")`
        pub const CONTACT: Option<&str> = Some("");
        /// `Some("2000-06-29")`
        pub const DATE: Option<&str> = Some("2000-06-29");
        /// `Some("bug-glibc-locales@gnu.org")`
        pub const EMAIL: Option<&str> = Some("bug-glibc-locales@gnu.org");
        /// `Some("")`
        pub const FAX: Option<&str> = Some("");
        /// `Some("German")`
        pub const LANGUAGE: Option<&str> = Some("German");
        /// `Some("1.0")`
        pub const REVISION: Option<&str> = Some("1.0");
        /// `Some("RAP")`
        pub const SOURCE: Option<&str> = Some("RAP");
        /// `Some("")`
        pub const TEL: Option<&str> = Some("");
        /// `Some("Luxembourg")`
        pub const TERRITORY: Option<&str> = Some("Luxembourg");
        /// `Some("German locale for Luxemburg")`
        pub const TITLE: Option<&str> = Some("German locale for Luxemburg");
    }
    pub use super::de_DE::LC_MESSAGES;
    pub mod LC_MONETARY {
        /// `"€"`
        pub const CURRENCY_SYMBOL: &str = "€";
        /// `2`
        pub const FRAC_DIGITS: i64 = 2;
        /// `"EUR "`
        pub const INT_CURR_SYMBOL: &str = "EUR ";
        /// `2`
        pub const INT_FRAC_DIGITS: i64 = 2;
        /// `None`
        pub const INT_N_CS_PRECEDES: Option<i64> = None;
        /// `None`
        pub const INT_N_SEP_BY_SPACE: Option<i64> = None;
        /// `None`
        pub const INT_N_SIGN_POSN: Option<i64> = None;
        /// `None`
        pub const INT_P_CS_PRECEDES: Option<i64> = None;
        /// `None`
        pub const INT_P_SEP_BY_SPACE: Option<i64> = None;
        /// `None`
        pub const INT_P_SIGN_POSN: Option<i64> = None;
        /// `","`
        pub const MON_DECIMAL_POINT: &str = ",";
        /// `&[3, 3]`
        pub const MON_GROUPING: &[i64] = &[3, 3];
        /// `"."`
        pub const MON_THOUSANDS_SEP: &str = ".";
        /// `"-"`
        pub const NEGATIVE_SIGN: &str = "-";
        /// `1`
        pub const N_CS_PRECEDES: i64 = 1;
        /// `1`
        pub const N_SEP_BY_SPACE: i64 = 1;
        /// `4`
        pub const N_SIGN_POSN: i64 = 4;
        /// `""`
        pub const POSITIVE_SIGN: &str = "";
        /// `1`
        pub const P_CS_PRECEDES: i64 = 1;
        /// `1`
        pub const P_SEP_BY_SPACE: i64 = 1;
        /// `4`
        pub const P_SIGN_POSN: i64 = 4;
    }
    pub use super::de_DE::LC_NUMERIC;
    pub mod LC_TELEPHONE {
        /// `Some("352")`
        pub const INT_PREFIX: Option<&str> = Some("352");
        /// `Some("00")`
        pub const INT_SELECT: Option<&str> = Some("00");
        /// `None`
        pub const TEL_DOM_FMT: Option<&str> = None;
        /// `Some("+%c %a %l")`
        pub const TEL_INT_FMT: Option<&str> = Some("+%c %a %l");
    }
    pub mod LC_TIME {
        /// `&["So", "Mo", "Di", "Mi", "Do", "Fr", "Sa"]`
        pub const ABDAY: &[&str] = &["So", "Mo", "Di", "Mi", "Do", "Fr", "Sa"];
        /// `&["Jan", "Feb", "Mär", "Apr", "Mai", "Jun", "Jul", "Aug", "Sep", "Okt", "Nov", "Dez"]`
        pub const ABMON: &[&str] = &["Jan", "Feb", "Mär", "Apr", "Mai", "Jun", "Jul", "Aug", "Sep", "Okt", "Nov", "Dez"];
        /// `None`
        pub const AB_ALT_MON: Option<&[&str]> = None;
        /// `None`
        pub const ALT_DIGITS: Option<&[&str]> = None;
        /// `None`
        pub const ALT_MON: Option<&[&str]> = None;
        /// `&["", ""]`
        pub const AM_PM: &[&str] = &["", ""];
        /// `None`
        pub const CAL_DIRECTION: Option<i64> = None;
        /// `None`
        pub const DATE_FMT: Option<&str> = None;
        /// `&["Sonntag", "Montag", "Dienstag", "Mittwoch", "Donnerstag", "Freitag", "Samstag"]`
        pub const DAY: &[&str] = &["Sonntag", "Montag", "Dienstag", "Mittwoch", "Donnerstag", "Freitag", "Samstag"];
        /// `"%Y-%m-%d"`
        pub const D_FMT: &str = "%Y-%m-%d";
        /// `"%a %d %b %Y %T %Z"`
        pub const D_T_FMT: &str = "%a %d %b %Y %T %Z";
        /// `None`
        pub const ERA: Option<&[&str]> = None;
        /// `None`
        pub const ERA_D_FMT: Option<&str> = None;
        /// `None`
        pub const ERA_D_T_FMT: Option<&str> = None;
        /// `None`
        pub const ERA_T_FMT: Option<&str> = None;
        /// `Some(2)`
        pub const FIRST_WEEKDAY: Option<i64> = Some(2);
        /// `None`
        pub const FIRST_WORKDAY: Option<i64> = None;
        /// `&["Januar", "Februar", "März", "April", "Mai", "Juni", "Juli", "August", "September", "Oktober", "November", "Dezember"]`
        pub const MON: &[&str] = &["Januar", "Februar", "März", "April", "Mai", "Juni", "Juli", "August", "September", "Oktober", "November", "Dezember"];
        /// `"%T"`
        pub const T_FMT: &str = "%T";
        /// `""`
        pub const T_FMT_AMPM: &str = "";
        /// `Some(&[7, 19971130, 4])`
        pub const WEEK: Option<&[i64]> = Some(&[7, 19971130, 4]);
    }
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod de_LU_euro {
    pub use super::de_LU::LC_ADDRESS;
    pub mod LC_IDENTIFICATION {
        /// `None`
        pub const ABBREVIATION: Option<&str> = None;
        /// `Some("https://www.gnu.org/software/libc/")`
        pub const ADDRESS: Option<&str> = Some("https://www.gnu.org/software/libc/");
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        /// ]
        /// ```
        pub const CATEGORY: Option<&[&[&str]]> = Some(&[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_TELEPHONE"],
            &["i18n:2012", "LC_MEASUREMENT"],
        ]);
        /// `Some("")`
        pub const CONTACT: Option<&str> = Some("");
        /// `Some("2000-08-20")`
        pub const DATE: Option<&str> = Some("2000-08-20");
        /// `Some("bug-glibc-locales@gnu.org")`
        pub const EMAIL: Option<&str> = Some("bug-glibc-locales@gnu.org");
        /// `Some("")`
        pub const FAX: Option<&str> = Some("");
        /// `Some("German")`
        pub const LANGUAGE: Option<&str> = Some("German");
        /// `Some("1.0")`
        pub const REVISION: Option<&str> = Some("1.0");
        /// `Some("Free Software Foundation, Inc.")`
        pub const SOURCE: Option<&str> = Some("Free Software Foundation, Inc.");
        /// `Some("")`
        pub const TEL: Option<&str> = Some("");
        /// `Some("Luxembourg")`
        pub const TERRITORY: Option<&str> = Some("Luxembourg");
        /// `Some("German locale for Luxemburg with Euro")`
        pub const TITLE: Option<&str> = Some("German locale for Luxemburg with Euro");
    }
    pub use super::de_DE::LC_MESSAGES;
    pub use super::de_LU::LC_MONETARY;
    pub use super::de_DE::LC_NUMERIC;
    pub use super::de_LU::LC_TELEPHONE;
    pub use super::de_LU::LC_TIME;
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod doi_IN {
    pub mod LC_ADDRESS {
        /// `Some("IND")`
        pub const COUNTRY_AB3: Option<&str> = Some("IND");
        /// `Some("IN")`
        pub const COUNTRY_ABTWO: Option<&str> = Some("IN");
        /// `Some("IND")`
        pub const COUNTRY_CAR: Option<&str> = Some("IND");
        /// `None`
        pub const COUNTRY_ISBN: Option<&str> = None;
        /// `Some("भारत")`
        pub const COUNTRY_NAME: Option<&str> = Some("भारत");
        /// `Some(356)`
        pub const COUNTRY_NUM: Option<i64> = Some(356);
        /// `None`
        pub const COUNTRY_POST: Option<&str> = None;
        /// `None`
        pub const LANG_AB: Option<&str> = None;
        /// `Some("doi")`
        pub const LANG_LIB: Option<&str> = Some("doi");
        /// `Some("डोगरी")`
        pub const LANG_NAME: Option<&str> = Some("डोगरी");
        /// `Some("doi")`
        pub const LANG_TERM: Option<&str> = Some("doi");
        /// `Some("%z%c%T%s%b%e%r")`
        pub const POSTAL_FMT: Option<&str> = Some("%z%c%T%s%b%e%r");
    }
    pub mod LC_IDENTIFICATION {
        /// `None`
        pub const ABBREVIATION: Option<&str> = None;
        /// `Some("Level 1, Tower X, Cybercity, Magarpatta City, Hadapsar, Pune-411013 ")`
        pub const ADDRESS: Option<&str> = Some("Level 1, Tower X, Cybercity, Magarpatta City, Hadapsar, Pune-411013 ");
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        /// ]
        /// ```
        pub const CATEGORY: Option<&[&[&str]]> = Some(&[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_TELEPHONE"],
            &["i18n:2012", "LC_MEASUREMENT"],
        ]);
        /// `Some("")`
        pub const CONTACT: Option<&str> = Some("");
        /// `Some("2012-02-16")`
        pub const DATE: Option<&str> = Some("2012-02-16");
        /// `Some("libc-alpha@sourceware.org")`
        pub const EMAIL: Option<&str> = Some("libc-alpha@sourceware.org");
        /// `Some("")`
        pub const FAX: Option<&str> = Some("");
        /// `Some("Dogri")`
        pub const LANGUAGE: Option<&str> = Some("Dogri");
        /// `Some("1.0")`
        pub const REVISION: Option<&str> = Some("1.0");
        /// `Some("Red Hat Pune")`
        pub const SOURCE: Option<&str> = Some("Red Hat Pune");
        /// `Some("")`
        pub const TEL: Option<&str> = Some("");
        /// `Some("India")`
        pub const TERRITORY: Option<&str> = Some("India");
        /// `Some("Dogri language locale for India")`
        pub const TITLE: Option<&str> = Some("Dogri language locale for India");
    }
    pub mod LC_MESSAGES {
        /// `"^[-0nNन]"`
        pub const NOEXPR: &str = "^[-0nNन]";
        /// `Some("ना")`
        pub const NOSTR: Option<&str> = Some("ना");
        /// `"^[+1yYऑ]"`
        pub const YESEXPR: &str = "^[+1yYऑ]";
        /// `Some("ऑह")`
        pub const YESSTR: Option<&str> = Some("ऑह");
    }
    pub use super::hi_IN::LC_MONETARY;
    pub use super::hi_IN::LC_NUMERIC;
    pub use super::hi_IN::LC_TELEPHONE;
    pub mod LC_TIME {
        /// `&["ऐत", "सोम", "म\u{902}गल", "ब\u{941}ध", "बीर", "श\u{941}क\u{94d}कर", "श\u{94d}नीचर"]`
        pub const ABDAY: &[&str] = &["ऐत", "सोम", "म\u{902}गल", "ब\u{941}ध", "बीर", "श\u{941}क\u{94d}कर", "श\u{94d}नीचर"];
        /// `&["जनवरी", "फरवरी", "मार\u{94d}च", "एप\u{94d}र\u{948}ल", "म\u{947}ई", "ज\u{942}न", "ज\u{942}ल\u{948}", "अगस\u{94d}त", "सित\u{902}बर", "अक\u{94d}त\u{942}बर", "नव\u{902}बर", "दिस\u{902}बर"]`
        pub const ABMON: &[&str] = &["जनवरी", "फरवरी", "मार\u{94d}च", "एप\u{94d}र\u{948}ल", "म\u{947}ई", "ज\u{942}न", "ज\u{942}ल\u{948}", "अगस\u{94d}त", "सित\u{902}बर", "अक\u{94d}त\u{942}बर", "नव\u{902}बर", "दिस\u{902}बर"];
        /// `None`
        pub const AB_ALT_MON: Option<&[&str]> = None;
        /// `None`
        pub const ALT_DIGITS: Option<&[&str]> = None;
        /// `None`
        pub const ALT_MON: Option<&[&str]> = None;
        /// `&["सञ\u{902}", "सब\u{947}र"]`
        pub const AM_PM: &[&str] = &["सञ\u{902}", "सब\u{947}र"];
        /// `None`
        pub const CAL_DIRECTION: Option<i64> = None;
        /// `None`
        pub const DATE_FMT: Option<&str> = None;
        /// `&["ऐतबार", "सोमबार", "म\u{902}गलबर", "ब\u{941}धबार", "बीरबार", "श\u{941}क\u{94d}करबार", "श\u{94d}नीचरबार"]`
        pub const DAY: &[&str] = &["ऐतबार", "सोमबार", "म\u{902}गलबर", "ब\u{941}धबार", "बीरबार", "श\u{941}क\u{94d}करबार", "श\u{94d}नीचरबार"];
        /// `"%-d/%-m/%y"`
        pub const D_FMT: &str = "%-d/%-m/%y";
        /// `"%A %d %b %Y %I:%M:%S %p %Z"`
        pub const D_T_FMT: &str = "%A %d %b %Y %I:%M:%S %p %Z";
        /// `None`
        pub const ERA: Option<&[&str]> = None;
        /// `None`
        pub const ERA_D_FMT: Option<&str> = None;
        /// `None`
        pub const ERA_D_T_FMT: Option<&str> = None;
        /// `None`
        pub const ERA_T_FMT: Option<&str> = None;
        /// `None`
        pub const FIRST_WEEKDAY: Option<i64> = None;
        /// `None`
        pub const FIRST_WORKDAY: Option<i64> = None;
        /// `&["जनवरी", "फरवरी", "मार\u{94d}च", "एप\u{94d}र\u{948}ल", "म\u{947}ई", "ज\u{942}न", "ज\u{942}ल\u{948}", "अगस\u{94d}त", "सित\u{902}बर", "अक\u{94d}त\u{942}बर", "नव\u{902}बर", "दिस\u{902}बर"]`
        pub const MON: &[&str] = &["जनवरी", "फरवरी", "मार\u{94d}च", "एप\u{94d}र\u{948}ल", "म\u{947}ई", "ज\u{942}न", "ज\u{942}ल\u{948}", "अगस\u{94d}त", "सित\u{902}बर", "अक\u{94d}त\u{942}बर", "नव\u{902}बर", "दिस\u{902}बर"];
        /// `"%I:%M:%S %p %Z"`
        pub const T_FMT: &str = "%I:%M:%S %p %Z";
        /// `"%I:%M:%S %p %Z"`
        pub const T_FMT_AMPM: &str = "%I:%M:%S %p %Z";
        /// `Some(&[7, 19971130, 1])`
        pub const WEEK: Option<&[i64]> = Some(&[7, 19971130, 1]);
    }
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod dsb_DE {
    pub mod LC_ADDRESS {
        /// `Some("DEU")`
        pub const COUNTRY_AB3: Option<&str> = Some("DEU");
        /// `Some("DE")`
        pub const COUNTRY_ABTWO: Option<&str> = Some("DE");
        /// `Some("D")`
        pub const COUNTRY_CAR: Option<&str> = Some("D");
        /// `Some("3")`
        pub const COUNTRY_ISBN: Option<&str> = Some("3");
        /// `Some("Nimska")`
        pub const COUNTRY_NAME: Option<&str> = Some("Nimska");
        /// `Some(276)`
        pub const COUNTRY_NUM: Option<i64> = Some(276);
        /// `Some("D")`
        pub const COUNTRY_POST: Option<&str> = Some("D");
        /// `Some("")`
        pub const LANG_AB: Option<&str> = Some("");
        /// `Some("dsb")`
        pub const LANG_LIB: Option<&str> = Some("dsb");
        /// `Some("dolnoserbšćina")`
        pub const LANG_NAME: Option<&str> = Some("dolnoserbšćina");
        /// `Some("dsb")`
        pub const LANG_TERM: Option<&str> = Some("dsb");
        /// `Some("%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%c%N")`
        pub const POSTAL_FMT: Option<&str> = Some("%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%c%N");
    }
    pub mod LC_IDENTIFICATION {
        /// `None`
        pub const ABBREVIATION: Option<&str> = None;
        /// `Some("")`
        pub const ADDRESS: Option<&str> = Some("");
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        /// ]
        /// ```
        pub const CATEGORY: Option<&[&[&str]]> = Some(&[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_TELEPHONE"],
            &["i18n:2012", "LC_MEASUREMENT"],
        ]);
        /// `Some("")`
        pub const CONTACT: Option<&str> = Some("");
        /// `Some("")`
        pub const DATE: Option<&str> = Some("");
        /// `Some("bug-glibc-locales@gnu.org")`
        pub const EMAIL: Option<&str> = Some("bug-glibc-locales@gnu.org");
        /// `Some("")`
        pub const FAX: Option<&str> = Some("");
        /// `Some("Lower Sorbian")`
        pub const LANGUAGE: Option<&str> = Some("Lower Sorbian");
        /// `Some("0.1")`
        pub const REVISION: Option<&str> = Some("0.1");
        /// `Some("Information from Michael Wolf")`
        pub const SOURCE: Option<&str> = Some("Information from Michael Wolf");
        /// `Some("")`
        pub const TEL: Option<&str> = Some("");
        /// `Some("Germany")`
        pub const TERRITORY: Option<&str> = Some("Germany");
        /// `Some("Lower Sorbian locale for Germany")`
        pub const TITLE: Option<&str> = Some("Lower Sorbian locale for Germany");
    }
    pub mod LC_MESSAGES {
        /// `"^[-0nN]"`
        pub const NOEXPR: &str = "^[-0nN]";
        /// `Some("ně")`
        pub const NOSTR: Option<&str> = Some("ně");
        /// `"^[+1jJhHyY]"`
        pub const YESEXPR: &str = "^[+1jJhHyY]";
        /// `Some("jo")`
        pub const YESSTR: Option<&str> = Some("jo");
    }
    pub use super::de_DE::LC_MONETARY;
    pub use super::de_DE::LC_NUMERIC;
    pub use super::de_DE::LC_TELEPHONE;
    pub mod LC_TIME {
        /// `&["Nj", "Pó", "Wa", "Sr", "St", "Pě", "So"]`
        pub const ABDAY: &[&str] = &["Nj", "Pó", "Wa", "Sr", "St", "Pě", "So"];
        /// `&["Jan", "Feb", "Měr", "Apr", "Maj", "Jun", "Jul", "Awg", "Sep", "Okt", "Now", "Dec"]`
        pub const ABMON: &[&str] = &["Jan", "Feb", "Měr", "Apr", "Maj", "Jun", "Jul", "Awg", "Sep", "Okt", "Now", "Dec"];
        /// `None`
        pub const AB_ALT_MON: Option<&[&str]> = None;
        /// `None`
        pub const ALT_DIGITS: Option<&[&str]> = None;
        /// `Some(&["Januar", "Februar", "Měrc", "Apryl", "Maj", "Junij", "Julij", "Awgust", "September", "Oktober", "Nowember", "December"])`
        pub const ALT_MON: Option<&[&str]> = Some(&["Januar", "Februar", "Měrc", "Apryl", "Maj", "Junij", "Julij", "Awgust", "September", "Oktober", "Nowember", "December"]);
        /// `&["", ""]`
        pub const AM_PM: &[&str] = &["", ""];
        /// `None`
        pub const CAL_DIRECTION: Option<i64> = None;
        /// `None`
        pub const DATE_FMT: Option<&str> = None;
        /// `&["Njeźela", "Pónjeźele", "Wałtora", "Srjoda", "Stwórtk", "Pětk", "Sobota"]`
        pub const DAY: &[&str] = &["Njeźela", "Pónjeźele", "Wałtora", "Srjoda", "Stwórtk", "Pětk", "Sobota"];
        /// `"%d.%m.%Y"`
        pub const D_FMT: &str = "%d.%m.%Y";
        /// `"%a %d %b %Y %T %Z"`
        pub const D_T_FMT: &str = "%a %d %b %Y %T %Z";
        /// `None`
        pub const ERA: Option<&[&str]> = None;
        /// `None`
        pub const ERA_D_FMT: Option<&str> = None;
        /// `None`
        pub const ERA_D_T_FMT: Option<&str> = None;
        /// `None`
        pub const ERA_T_FMT: Option<&str> = None;
        /// `Some(2)`
        pub const FIRST_WEEKDAY: Option<i64> = Some(2);
        /// `None`
        pub const FIRST_WORKDAY: Option<i64> = None;
        /// `&["januara", "februara", "měrca", "apryla", "maja", "junija", "julija", "awgusta", "septembra", "oktobra", "nowembra", "decembra"]`
        pub const MON: &[&str] = &["januara", "februara", "měrca", "apryla", "maja", "junija", "julija", "awgusta", "septembra", "oktobra", "nowembra", "decembra"];
        /// `"%T"`
        pub const T_FMT: &str = "%T";
        /// `""`
        pub const T_FMT_AMPM: &str = "";
        /// `Some(&[7, 19971130, 4])`
        pub const WEEK: Option<&[i64]> = Some(&[7, 19971130, 4]);
    }
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod dv_MV {
    pub mod LC_ADDRESS {
        /// `Some("MDV")`
        pub const COUNTRY_AB3: Option<&str> = Some("MDV");
        /// `Some("MV")`
        pub const COUNTRY_ABTWO: Option<&str> = Some("MV");
        /// `Some("MV")`
        pub const COUNTRY_CAR: Option<&str> = Some("MV");
        /// `None`
        pub const COUNTRY_ISBN: Option<&str> = None;
        /// `Some("ދ\u{7a8}ވ\u{7ac}ހ\u{7a8}ރ\u{7a7}އ\u{7b0}ޖ\u{7ac}")`
        pub const COUNTRY_NAME: Option<&str> = Some("ދ\u{7a8}ވ\u{7ac}ހ\u{7a8}ރ\u{7a7}އ\u{7b0}ޖ\u{7ac}");
        /// `Some(462)`
        pub const COUNTRY_NUM: Option<i64> = Some(462);
        /// `None`
        pub const COUNTRY_POST: Option<&str> = None;
        /// `Some("dv")`
        pub const LANG_AB: Option<&str> = Some("dv");
        /// `Some("div")`
        pub const LANG_LIB: Option<&str> = Some("div");
        /// `Some("ދ\u{7a8}ވ\u{7ac}ހ\u{7a8}")`
        pub const LANG_NAME: Option<&str> = Some("ދ\u{7a8}ވ\u{7ac}ހ\u{7a8}");
        /// `Some("div")`
        pub const LANG_TERM: Option<&str> = Some("div");
        /// `Some("%f%N%a%N%d%N%b%N%s %h %e %r%N%%z %T%N%c%N")`
        pub const POSTAL_FMT: Option<&str> = Some("%f%N%a%N%d%N%b%N%s %h %e %r%N%%z %T%N%c%N");
    }
    pub mod LC_IDENTIFICATION {
        /// `None`
        pub const ABBREVIATION: Option<&str> = None;
        /// `Some("")`
        pub const ADDRESS: Option<&str> = Some("");
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        /// ]
        /// ```
        pub const CATEGORY: Option<&[&[&str]]> = Some(&[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_TELEPHONE"],
            &["i18n:2012", "LC_MEASUREMENT"],
        ]);
        /// `Some("")`
        pub const CONTACT: Option<&str> = Some("");
        /// `Some("2006-05-13")`
        pub const DATE: Option<&str> = Some("2006-05-13");
        /// `Some("sofwath@hotmail.com")`
        pub const EMAIL: Option<&str> = Some("sofwath@hotmail.com");
        /// `Some("")`
        pub const FAX: Option<&str> = Some("");
        /// `Some("Divehi")`
        pub const LANGUAGE: Option<&str> = Some("Divehi");
        /// `Some("0.1")`
        pub const REVISION: Option<&str> = Some("0.1");
        /// `Some("")`
        pub const SOURCE: Option<&str> = Some("");
        /// `Some("")`
        pub const TEL: Option<&str> = Some("");
        /// `Some("Maldives")`
        pub const TERRITORY: Option<&str> = Some("Maldives");
        /// `Some("Dhivehi Language Locale for Maldives")`
        pub const TITLE: Option<&str> = Some("Dhivehi Language Locale for Maldives");
    }
    pub mod LC_MESSAGES {
        /// `"^[-0nN]"`
        pub const NOEXPR: &str = "^[-0nN]";
        /// `None`
        pub const NOSTR: Option<&str> = None;
        /// `"^[+1yY]"`
        pub const YESEXPR: &str = "^[+1yY]";
        /// `None`
        pub const YESSTR: Option<&str> = None;
    }
    pub mod LC_MONETARY {
        /// `"ރ."`
        pub const CURRENCY_SYMBOL: &str = "ރ.";
        /// `2`
        pub const FRAC_DIGITS: i64 = 2;
        /// `"MVR "`
        pub const INT_CURR_SYMBOL: &str = "MVR ";
        /// `2`
        pub const INT_FRAC_DIGITS: i64 = 2;
        /// `None`
        pub const INT_N_CS_PRECEDES: Option<i64> = None;
        /// `None`
        pub const INT_N_SEP_BY_SPACE: Option<i64> = None;
        /// `None`
        pub const INT_N_SIGN_POSN: Option<i64> = None;
        /// `None`
        pub const INT_P_CS_PRECEDES: Option<i64> = None;
        /// `None`
        pub const INT_P_SEP_BY_SPACE: Option<i64> = None;
        /// `None`
        pub const INT_P_SIGN_POSN: Option<i64> = None;
        /// `"."`
        pub const MON_DECIMAL_POINT: &str = ".";
        /// `&[3, 3]`
        pub const MON_GROUPING: &[i64] = &[3, 3];
        /// `","`
        pub const MON_THOUSANDS_SEP: &str = ",";
        /// `"-"`
        pub const NEGATIVE_SIGN: &str = "-";
        /// `1`
        pub const N_CS_PRECEDES: i64 = 1;
        /// `0`
        pub const N_SEP_BY_SPACE: i64 = 0;
        /// `1`
        pub const N_SIGN_POSN: i64 = 1;
        /// `""`
        pub const POSITIVE_SIGN: &str = "";
        /// `1`
        pub const P_CS_PRECEDES: i64 = 1;
        /// `1`
        pub const P_SEP_BY_SPACE: i64 = 1;
        /// `2`
        pub const P_SIGN_POSN: i64 = 2;
    }
    pub mod LC_NUMERIC {
        /// `"."`
        pub const DECIMAL_POINT: &str = ".";
        /// `&[3, 3]`
        pub const GROUPING: &[i64] = &[3, 3];
        /// `","`
        pub const THOUSANDS_SEP: &str = ",";
    }
    pub mod LC_TELEPHONE {
        /// `Some("960")`
        pub const INT_PREFIX: Option<&str> = Some("960");
        /// `Some("00")`
        pub const INT_SELECT: Option<&str> = Some("00");
        /// `Some("%a %l")`
        pub const TEL_DOM_FMT: Option<&str> = Some("%a %l");
        /// `Some("+%c %a %l")`
        pub const TEL_INT_FMT: Option<&str> = Some("+%c %a %l");
    }
    pub mod LC_TIME {
        /// `&["އ\u{7a7}ދ\u{7a9}އ\u{7b0}ތ\u{7a6}", "ހ\u{7af}މ\u{7a6}", "އ\u{7a6}ނ\u{7b0}ގ\u{7a7}ރ\u{7a6}", "ބ\u{7aa}ދ\u{7a6}", "ބ\u{7aa}ރ\u{7a7}ސ\u{7b0}ފ\u{7a6}ތ\u{7a8}", "ހ\u{7aa}ކ\u{7aa}ރ\u{7aa}", "ހ\u{7ae}ނ\u{7a8}ހ\u{7a8}ރ\u{7aa}"]`
        pub const ABDAY: &[&str] = &["އ\u{7a7}ދ\u{7a9}އ\u{7b0}ތ\u{7a6}", "ހ\u{7af}މ\u{7a6}", "އ\u{7a6}ނ\u{7b0}ގ\u{7a7}ރ\u{7a6}", "ބ\u{7aa}ދ\u{7a6}", "ބ\u{7aa}ރ\u{7a7}ސ\u{7b0}ފ\u{7a6}ތ\u{7a8}", "ހ\u{7aa}ކ\u{7aa}ރ\u{7aa}", "ހ\u{7ae}ނ\u{7a8}ހ\u{7a8}ރ\u{7aa}"];
        /// `&["ޖ\u{7ac}ނ\u{7aa}އ\u{7a6}ރ\u{7a9}", "ފ\u{7ac}ބ\u{7b0}ރ\u{7aa}އ\u{7a6}ރ\u{7a9}", "މ\u{7a7}ރޗ\u{7b0}", "އ\u{7ac}ޕ\u{7b0}ރ\u{7a9}ލ\u{7b0}", "މ\u{7ac}އ\u{7a8}", "ޖ\u{7ab}ނ\u{7b0}", "ޖ\u{7aa}ލ\u{7a6}އ\u{7a8}", "އ\u{7ae}ގ\u{7a6}ސ\u{7b0}ޓ\u{7b0}", "ސ\u{7ac}ޕ\u{7b0}ޓ\u{7ac}ނ\u{7b0}ބ\u{7a6}ރ", "އ\u{7ae}ކ\u{7b0}ޓ\u{7ab}ބ\u{7a6}ރ", "ނ\u{7ae}ވ\u{7ac}ނ\u{7b0}ބ\u{7a6}ރ", "ޑ\u{7a8}ސ\u{7ac}ނ\u{7b0}ބ\u{7a6}ރ"]`
        pub const ABMON: &[&str] = &["ޖ\u{7ac}ނ\u{7aa}އ\u{7a6}ރ\u{7a9}", "ފ\u{7ac}ބ\u{7b0}ރ\u{7aa}އ\u{7a6}ރ\u{7a9}", "މ\u{7a7}ރޗ\u{7b0}", "އ\u{7ac}ޕ\u{7b0}ރ\u{7a9}ލ\u{7b0}", "މ\u{7ac}އ\u{7a8}", "ޖ\u{7ab}ނ\u{7b0}", "ޖ\u{7aa}ލ\u{7a6}އ\u{7a8}", "އ\u{7ae}ގ\u{7a6}ސ\u{7b0}ޓ\u{7b0}", "ސ\u{7ac}ޕ\u{7b0}ޓ\u{7ac}ނ\u{7b0}ބ\u{7a6}ރ", "އ\u{7ae}ކ\u{7b0}ޓ\u{7ab}ބ\u{7a6}ރ", "ނ\u{7ae}ވ\u{7ac}ނ\u{7b0}ބ\u{7a6}ރ", "ޑ\u{7a8}ސ\u{7ac}ނ\u{7b0}ބ\u{7a6}ރ"];
        /// `None`
        pub const AB_ALT_MON: Option<&[&str]> = None;
        /// `None`
        pub const ALT_DIGITS: Option<&[&str]> = None;
        /// `None`
        pub const ALT_MON: Option<&[&str]> = None;
        /// `&["މކ", "މފ"]`
        pub const AM_PM: &[&str] = &["މކ", "މފ"];
        /// `Some(3)`
        pub const CAL_DIRECTION: Option<i64> = Some(3);
        /// `None`
        pub const DATE_FMT: Option<&str> = None;
        /// `&["އ\u{7a7}ދ\u{7a9}އ\u{7b0}ތ\u{7a6}", "ހ\u{7af}މ\u{7a6}", "އ\u{7a6}ނ\u{7b0}ގ\u{7a7}ރ\u{7a6}", "ބ\u{7aa}ދ\u{7a6}", "ބ\u{7aa}ރ\u{7a7}ސ\u{7b0}ފ\u{7a6}ތ\u{7a8}", "ހ\u{7aa}ކ\u{7aa}ރ\u{7aa}", "ހ\u{7ae}ނ\u{7a8}ހ\u{7a8}ރ\u{7aa}"]`
        pub const DAY: &[&str] = &["އ\u{7a7}ދ\u{7a9}އ\u{7b0}ތ\u{7a6}", "ހ\u{7af}މ\u{7a6}", "އ\u{7a6}ނ\u{7b0}ގ\u{7a7}ރ\u{7a6}", "ބ\u{7aa}ދ\u{7a6}", "ބ\u{7aa}ރ\u{7a7}ސ\u{7b0}ފ\u{7a6}ތ\u{7a8}", "ހ\u{7aa}ކ\u{7aa}ރ\u{7aa}", "ހ\u{7ae}ނ\u{7a8}ހ\u{7a8}ރ\u{7aa}"];
        /// `"%d/%m/%Y"`
        pub const D_FMT: &str = "%d/%m/%Y";
        /// `"%Z %H:%M:%S %Y %b %d %a"`
        pub const D_T_FMT: &str = "%Z %H:%M:%S %Y %b %d %a";
        /// `None`
        pub const ERA: Option<&[&str]> = None;
        /// `None`
        pub const ERA_D_FMT: Option<&str> = None;
        /// `None`
        pub const ERA_D_T_FMT: Option<&str> = None;
        /// `None`
        pub const ERA_T_FMT: Option<&str> = None;
        /// `Some(6)`
        pub const FIRST_WEEKDAY: Option<i64> = Some(6);
        /// `None`
        pub const FIRST_WORKDAY: Option<i64> = None;
        /// `&["ޖ\u{7ac}ނ\u{7aa}އ\u{7a6}ރ\u{7a9}", "ފ\u{7ac}ބ\u{7b0}ރ\u{7aa}އ\u{7a6}ރ\u{7a9}", "މ\u{7a7}ރޗ\u{7b0}", "އ\u{7ac}ޕ\u{7b0}ރ\u{7a9}ލ\u{7b0}", "މ\u{7ac}އ\u{7a8}", "ޖ\u{7ab}ނ\u{7b0}", "ޖ\u{7aa}ލ\u{7a6}އ\u{7a8}", "އ\u{7ae}ގ\u{7a6}ސ\u{7b0}ޓ\u{7b0}", "ސ\u{7ac}ޕ\u{7b0}ޓ\u{7ac}ނ\u{7b0}ބ\u{7a6}ރ", "އ\u{7ae}ކ\u{7b0}ޓ\u{7ab}ބ\u{7a6}ރ", "ނ\u{7ae}ވ\u{7ac}ނ\u{7b0}ބ\u{7a6}ރ", "ޑ\u{7a8}ސ\u{7ac}ނ\u{7b0}ބ\u{7a6}ރ"]`
        pub const MON: &[&str] = &["ޖ\u{7ac}ނ\u{7aa}އ\u{7a6}ރ\u{7a9}", "ފ\u{7ac}ބ\u{7b0}ރ\u{7aa}އ\u{7a6}ރ\u{7a9}", "މ\u{7a7}ރޗ\u{7b0}", "އ\u{7ac}ޕ\u{7b0}ރ\u{7a9}ލ\u{7b0}", "މ\u{7ac}އ\u{7a8}", "ޖ\u{7ab}ނ\u{7b0}", "ޖ\u{7aa}ލ\u{7a6}އ\u{7a8}", "އ\u{7ae}ގ\u{7a6}ސ\u{7b0}ޓ\u{7b0}", "ސ\u{7ac}ޕ\u{7b0}ޓ\u{7ac}ނ\u{7b0}ބ\u{7a6}ރ", "އ\u{7ae}ކ\u{7b0}ޓ\u{7ab}ބ\u{7a6}ރ", "ނ\u{7ae}ވ\u{7ac}ނ\u{7b0}ބ\u{7a6}ރ", "ޑ\u{7a8}ސ\u{7ac}ނ\u{7b0}ބ\u{7a6}ރ"];
        /// `"%H:%M:%S"`
        pub const T_FMT: &str = "%H:%M:%S";
        /// `"%P %I:%M:%S"`
        pub const T_FMT_AMPM: &str = "%P %I:%M:%S";
        /// `Some(&[7, 19971130, 1])`
        pub const WEEK: Option<&[i64]> = Some(&[7, 19971130, 1]);
    }
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod dz_BT {
    pub mod LC_ADDRESS {
        /// `Some("BTN")`
        pub const COUNTRY_AB3: Option<&str> = Some("BTN");
        /// `Some("BT")`
        pub const COUNTRY_ABTWO: Option<&str> = Some("BT");
        /// `Some("BHT")`
        pub const COUNTRY_CAR: Option<&str> = Some("BHT");
        /// `None`
        pub const COUNTRY_ISBN: Option<&str> = None;
        /// `Some("འབ\u{fb2}\u{f74}ག")`
        pub const COUNTRY_NAME: Option<&str> = Some("འབ\u{fb2}\u{f74}ག");
        /// `Some(64)`
        pub const COUNTRY_NUM: Option<i64> = Some(64);
        /// `None`
        pub const COUNTRY_POST: Option<&str> = None;
        /// `Some("dz")`
        pub const LANG_AB: Option<&str> = Some("dz");
        /// `Some("dzo")`
        pub const LANG_LIB: Option<&str> = Some("dzo");
        /// `Some("ར\u{fab}\u{f7c}ང་ཁ")`
        pub const LANG_NAME: Option<&str> = Some("ར\u{fab}\u{f7c}ང་ཁ");
        /// `Some("dzo")`
        pub const LANG_TERM: Option<&str> = Some("dzo");
        /// `Some("%f%N%a%N%d%N%r%t%e%t%b%N%h%t%s%N%T%N%S%N%z%c%N")`
        pub const POSTAL_FMT: Option<&str> = Some("%f%N%a%N%d%N%r%t%e%t%b%N%h%t%s%N%T%N%S%N%z%c%N");
    }
    pub mod LC_IDENTIFICATION {
        /// `None`
        pub const ABBREVIATION: Option<&str> = None;
        /// `Some("Kanglung, Bhutan")`
        pub const ADDRESS: Option<&str> = Some("Kanglung, Bhutan");
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        /// ]
        /// ```
        pub const CATEGORY: Option<&[&[&str]]> = Some(&[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_TELEPHONE"],
            &["i18n:2012", "LC_MEASUREMENT"],
        ]);
        /// `Some("")`
        pub const CONTACT: Option<&str> = Some("");
        /// `Some("2004-09-03")`
        pub const DATE: Option<&str> = Some("2004-09-03");
        /// `Some("bug-glibc@gnu.org")`
        pub const EMAIL: Option<&str> = Some("bug-glibc@gnu.org");
        /// `Some("")`
        pub const FAX: Option<&str> = Some("");
        /// `Some("Dzongkha")`
        pub const LANGUAGE: Option<&str> = Some("Dzongkha");
        /// `Some("0.3")`
        pub const REVISION: Option<&str> = Some("0.3");
        /// `Some("Sherubtse College")`
        pub const SOURCE: Option<&str> = Some("Sherubtse College");
        /// `Some("")`
        pub const TEL: Option<&str> = Some("");
        /// `Some("Bhutan")`
        pub const TERRITORY: Option<&str> = Some("Bhutan");
        /// `Some("Dzongkha language locale for Bhutan")`
        pub const TITLE: Option<&str> = Some("Dzongkha language locale for Bhutan");
    }
    pub mod LC_MESSAGES {
        /// `"^[-0nNམ]"`
        pub const NOEXPR: &str = "^[-0nNམ]";
        /// `Some("མ\u{f7a}ན་")`
        pub const NOSTR: Option<&str> = Some("མ\u{f7a}ན་");
        /// `"^[+1yYཨ]"`
        pub const YESEXPR: &str = "^[+1yYཨ]";
        /// `Some("ཨ\u{f72}ན་")`
        pub const YESSTR: Option<&str> = Some("ཨ\u{f72}ན་");
    }
    pub mod LC_MONETARY {
        /// `"Nu."`
        pub const CURRENCY_SYMBOL: &str = "Nu.";
        /// `3`
        pub const FRAC_DIGITS: i64 = 3;
        /// `"BTN "`
        pub const INT_CURR_SYMBOL: &str = "BTN ";
        /// `3`
        pub const INT_FRAC_DIGITS: i64 = 3;
        /// `None`
        pub const INT_N_CS_PRECEDES: Option<i64> = None;
        /// `None`
        pub const INT_N_SEP_BY_SPACE: Option<i64> = None;
        /// `None`
        pub const INT_N_SIGN_POSN: Option<i64> = None;
        /// `None`
        pub const INT_P_CS_PRECEDES: Option<i64> = None;
        /// `None`
        pub const INT_P_SEP_BY_SPACE: Option<i64> = None;
        /// `None`
        pub const INT_P_SIGN_POSN: Option<i64> = None;
        /// `"."`
        pub const MON_DECIMAL_POINT: &str = ".";
        /// `&[3, 2]`
        pub const MON_GROUPING: &[i64] = &[3, 2];
        /// `","`
        pub const MON_THOUSANDS_SEP: &str = ",";
        /// `"-"`
        pub const NEGATIVE_SIGN: &str = "-";
        /// `1`
        pub const N_CS_PRECEDES: i64 = 1;
        /// `1`
        pub const N_SEP_BY_SPACE: i64 = 1;
        /// `4`
        pub const N_SIGN_POSN: i64 = 4;
        /// `""`
        pub const POSITIVE_SIGN: &str = "";
        /// `1`
        pub const P_CS_PRECEDES: i64 = 1;
        /// `1`
        pub const P_SEP_BY_SPACE: i64 = 1;
        /// `4`
        pub const P_SIGN_POSN: i64 = 4;
    }
    pub mod LC_NUMERIC {
        /// `"."`
        pub const DECIMAL_POINT: &str = ".";
        /// `&[3, 2]`
        pub const GROUPING: &[i64] = &[3, 2];
        /// `","`
        pub const THOUSANDS_SEP: &str = ",";
    }
    pub mod LC_TELEPHONE {
        /// `Some("975")`
        pub const INT_PREFIX: Option<&str> = Some("975");
        /// `Some("00")`
        pub const INT_SELECT: Option<&str> = Some("00");
        /// `None`
        pub const TEL_DOM_FMT: Option<&str> = None;
        /// `Some("+%c %a %l")`
        pub const TEL_INT_FMT: Option<&str> = Some("+%c %a %l");
    }
    pub mod LC_TIME {
        /// `&["ཟ\u{fb3}་", "མ\u{f72}ར་", "ལ\u{fb7}ག་", "པ\u{f74}ར་", "སངས་", "ས\u{fa4}\u{f7a}ན་", "ཉ\u{f72}་"]`
        pub const ABDAY: &[&str] = &["ཟ\u{fb3}་", "མ\u{f72}ར་", "ལ\u{fb7}ག་", "པ\u{f74}ར་", "སངས་", "ས\u{fa4}\u{f7a}ན་", "ཉ\u{f72}་"];
        /// `&["ཟ\u{fb3}་༡", "ཟ\u{fb3}་༢", "ཟ\u{fb3}་༣", "ཟ\u{fb3}་༤", "ཟ\u{fb3}་༥", "ཟ\u{fb3}་༦", "ཟ\u{fb3}་༧", "ཟ\u{fb3}་༨", "ཟ\u{fb3}་༩", "ཟ\u{fb3}་༡༠", "ཟ\u{fb3}་༡༡", "ཟ\u{fb3}་༡༢"]`
        pub const ABMON: &[&str] = &["ཟ\u{fb3}་༡", "ཟ\u{fb3}་༢", "ཟ\u{fb3}་༣", "ཟ\u{fb3}་༤", "ཟ\u{fb3}་༥", "ཟ\u{fb3}་༦", "ཟ\u{fb3}་༧", "ཟ\u{fb3}་༨", "ཟ\u{fb3}་༩", "ཟ\u{fb3}་༡༠", "ཟ\u{fb3}་༡༡", "ཟ\u{fb3}་༡༢"];
        /// `None`
        pub const AB_ALT_MON: Option<&[&str]> = None;
        /// `None`
        pub const ALT_DIGITS: Option<&[&str]> = None;
        /// `None`
        pub const ALT_MON: Option<&[&str]> = None;
        /// `&["ངས་ཆ", "ཕ\u{fb1}\u{f72}་ཆ"]`
        pub const AM_PM: &[&str] = &["ངས་ཆ", "ཕ\u{fb1}\u{f72}་ཆ"];
        /// `None`
        pub const CAL_DIRECTION: Option<i64> = None;
        /// `None`
        pub const DATE_FMT: Option<&str> = None;
        /// `&["གཟའ་ཟ\u{fb3}་བ་", "གཟའ་མ\u{f72}ག་དམར་", "གཟའ་ལ\u{fb7}ག་ཕ་", "གཟའ་པ\u{f74}ར་བ\u{f74}་", "གཟའ་པ་སངས་", "གཟའ་ས\u{fa4}\u{f7a}ན་ཕ་", "གཟའ་ཉ\u{f72}་མ་"]`
        pub const DAY: &[&str] = &["གཟའ་ཟ\u{fb3}་བ་", "གཟའ་མ\u{f72}ག་དམར་", "གཟའ་ལ\u{fb7}ག་ཕ་", "གཟའ་པ\u{f74}ར་བ\u{f74}་", "གཟའ་པ་སངས་", "གཟའ་ས\u{fa4}\u{f7a}ན་ཕ་", "གཟའ་ཉ\u{f72}་མ་"];
        /// `"པས\u{fb1}\u{f72}་ལ\u{f7c}%yཟལ%mཚ\u{f7a}ས%d"`
        pub const D_FMT: &str = "པས\u{fb1}\u{f72}་ལ\u{f7c}%yཟལ%mཚ\u{f7a}ས%d";
        /// `"པས\u{fb1}\u{f72}་ལ\u{f7c}%yཟལ%mཚ\u{f7a}ས%dཆ\u{f74}་ཚ\u{f7c}ད%Hཀསར་མ%Mཀསར་ཆ%S"`
        pub const D_T_FMT: &str = "པས\u{fb1}\u{f72}་ལ\u{f7c}%yཟལ%mཚ\u{f7a}ས%dཆ\u{f74}་ཚ\u{f7c}ད%Hཀསར་མ%Mཀསར་ཆ%S";
        /// `None`
        pub const ERA: Option<&[&str]> = None;
        /// `None`
        pub const ERA_D_FMT: Option<&str> = None;
        /// `None`
        pub const ERA_D_T_FMT: Option<&str> = None;
        /// `None`
        pub const ERA_T_FMT: Option<&str> = None;
        /// `None`
        pub const FIRST_WEEKDAY: Option<i64> = None;
        /// `None`
        pub const FIRST_WORKDAY: Option<i64> = None;
        /// `&["ཟ\u{fb3}་བ་དང་པ་", "ཟ\u{fb3}་བ་གཉ\u{f72}ས་པ་", "ཟ\u{fb3}་བ་གས\u{f74}མ་པ་", "ཟ\u{fb3}་བ་བཞ\u{f72}་པ་", "ཟ\u{fb3}་བ་ལ\u{f94}་ཕ་", "ཟ\u{fb3}་བ་ད\u{fb2}\u{f74}ག་པ་", "ཟ\u{fb3}་བ་བད\u{f74}ནཔ་", "ཟ\u{fb3}་བ་བར\u{f92}\u{fb1}ད་པ་", "ཟ\u{fb3}་བ་དག\u{f74}་པ་", "ཟ\u{fb3}་བ་བཅ\u{f74}་པ་", "ཟ\u{fb3}་བ་བཅ\u{f74}་གཅ\u{f72}ག་པ་", "ཟ\u{fb3}་བ་བཅ\u{f74}་གཉ\u{f72}ས་པ་"]`
        pub const MON: &[&str] = &["ཟ\u{fb3}་བ་དང་པ་", "ཟ\u{fb3}་བ་གཉ\u{f72}ས་པ་", "ཟ\u{fb3}་བ་གས\u{f74}མ་པ་", "ཟ\u{fb3}་བ་བཞ\u{f72}་པ་", "ཟ\u{fb3}་བ་ལ\u{f94}་ཕ་", "ཟ\u{fb3}་བ་ད\u{fb2}\u{f74}ག་པ་", "ཟ\u{fb3}་བ་བད\u{f74}ནཔ་", "ཟ\u{fb3}་བ་བར\u{f92}\u{fb1}ད་པ་", "ཟ\u{fb3}་བ་དག\u{f74}་པ་", "ཟ\u{fb3}་བ་བཅ\u{f74}་པ་", "ཟ\u{fb3}་བ་བཅ\u{f74}་གཅ\u{f72}ག་པ་", "ཟ\u{fb3}་བ་བཅ\u{f74}་གཉ\u{f72}ས་པ་"];
        /// `"ཆ\u{f74}་ཚ\u{f7c}ད%Hཀསར་མ%Mཀསར་ཆ%S"`
        pub const T_FMT: &str = "ཆ\u{f74}་ཚ\u{f7c}ད%Hཀསར་མ%Mཀསར་ཆ%S";
        /// `"ཆ\u{f74}་ཚ\u{f7c}ད%Iཀསར་མ%Mཀསར་ཆ%S %p"`
        pub const T_FMT_AMPM: &str = "ཆ\u{f74}་ཚ\u{f7c}ད%Iཀསར་མ%Mཀསར་ཆ%S %p";
        /// `Some(&[7, 19971130, 1])`
        pub const WEEK: Option<&[i64]> = Some(&[7, 19971130, 1]);
    }
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod el_CY {
    pub mod LC_ADDRESS {
        /// `Some("CYP")`
        pub const COUNTRY_AB3: Option<&str> = Some("CYP");
        /// `Some("CY")`
        pub const COUNTRY_ABTWO: Option<&str> = Some("CY");
        /// `Some("CY")`
        pub const COUNTRY_CAR: Option<&str> = Some("CY");
        /// `None`
        pub const COUNTRY_ISBN: Option<&str> = None;
        /// `Some("Κύπρος")`
        pub const COUNTRY_NAME: Option<&str> = Some("Κύπρος");
        /// `Some(196)`
        pub const COUNTRY_NUM: Option<i64> = Some(196);
        /// `None`
        pub const COUNTRY_POST: Option<&str> = None;
        /// `Some("el")`
        pub const LANG_AB: Option<&str> = Some("el");
        /// `Some("gre")`
        pub const LANG_LIB: Option<&str> = Some("gre");
        /// `Some("Ελληνικά")`
        pub const LANG_NAME: Option<&str> = Some("Ελληνικά");
        /// `Some("ell")`
        pub const LANG_TERM: Option<&str> = Some("ell");
        /// `Some("%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%c%N")`
        pub const POSTAL_FMT: Option<&str> = Some("%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%c%N");
    }
    pub mod LC_IDENTIFICATION {
        /// `None`
        pub const ABBREVIATION: Option<&str> = None;
        /// `Some("Konstantinos Margaritis, M. Asias 50, Nafplion 21100, Greece")`
        pub const ADDRESS: Option<&str> = Some("Konstantinos Margaritis, M. Asias 50, Nafplion 21100, Greece");
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        /// ]
        /// ```
        pub const CATEGORY: Option<&[&[&str]]> = Some(&[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_TELEPHONE"],
            &["i18n:2012", "LC_MEASUREMENT"],
        ]);
        /// `Some("")`
        pub const CONTACT: Option<&str> = Some("");
        /// `Some("2004-10-20")`
        pub const DATE: Option<&str> = Some("2004-10-20");
        /// `Some("bug-glibc@gnu.org")`
        pub const EMAIL: Option<&str> = Some("bug-glibc@gnu.org");
        /// `Some("")`
        pub const FAX: Option<&str> = Some("");
        /// `Some("Greek")`
        pub const LANGUAGE: Option<&str> = Some("Greek");
        /// `Some("1.0")`
        pub const REVISION: Option<&str> = Some("1.0");
        /// `Some("Greek Debian Translation Team")`
        pub const SOURCE: Option<&str> = Some("Greek Debian Translation Team");
        /// `Some("")`
        pub const TEL: Option<&str> = Some("");
        /// `Some("Cyprus")`
        pub const TERRITORY: Option<&str> = Some("Cyprus");
        /// `Some("Greek locale for Cyprus")`
        pub const TITLE: Option<&str> = Some("Greek locale for Cyprus");
    }
    pub use super::el_GR::LC_MESSAGES;
    pub use super::el_GR::LC_MONETARY;
    pub mod LC_NUMERIC {
        /// `","`
        pub const DECIMAL_POINT: &str = ",";
        /// `&[0, 0]`
        pub const GROUPING: &[i64] = &[0, 0];
        /// `"."`
        pub const THOUSANDS_SEP: &str = ".";
    }
    pub mod LC_TELEPHONE {
        /// `Some("357")`
        pub const INT_PREFIX: Option<&str> = Some("357");
        /// `Some("00")`
        pub const INT_SELECT: Option<&str> = Some("00");
        /// `None`
        pub const TEL_DOM_FMT: Option<&str> = None;
        /// `Some("+%c %a %l")`
        pub const TEL_INT_FMT: Option<&str> = Some("+%c %a %l");
    }
    pub mod LC_TIME {
        /// `&["Κυρ", "Δευ", "Τρι", "Τετ", "Πεμ", "Παρ", "Σαβ"]`
        pub const ABDAY: &[&str] = &["Κυρ", "Δευ", "Τρι", "Τετ", "Πεμ", "Παρ", "Σαβ"];
        /// `&["Ιαν", "Φεβ", "Μαρ", "Απρ", "Μαΐ", "Ιουν", "Ιουλ", "Αυγ", "Σεπ", "Οκτ", "Νοε", "Δεκ"]`
        pub const ABMON: &[&str] = &["Ιαν", "Φεβ", "Μαρ", "Απρ", "Μαΐ", "Ιουν", "Ιουλ", "Αυγ", "Σεπ", "Οκτ", "Νοε", "Δεκ"];
        /// `Some(&["Ιαν", "Φεβ", "Μάρ", "Απρ", "Μάι", "Ιούν", "Ιούλ", "Αύγ", "Σεπ", "Οκτ", "Νοέ", "Δεκ"])`
        pub const AB_ALT_MON: Option<&[&str]> = Some(&["Ιαν", "Φεβ", "Μάρ", "Απρ", "Μάι", "Ιούν", "Ιούλ", "Αύγ", "Σεπ", "Οκτ", "Νοέ", "Δεκ"]);
        /// `None`
        pub const ALT_DIGITS: Option<&[&str]> = None;
        /// `Some(&["Ιανουάριος", "Φεβρουάριος", "Μάρτιος", "Απρίλιος", "Μάιος", "Ιούνιος", "Ιούλιος", "Αύγουστος", "Σεπτέμβριος", "Οκτώβριος", "Νοέμβριος", "Δεκέμβριος"])`
        pub const ALT_MON: Option<&[&str]> = Some(&["Ιανουάριος", "Φεβρουάριος", "Μάρτιος", "Απρίλιος", "Μάιος", "Ιούνιος", "Ιούλιος", "Αύγουστος", "Σεπτέμβριος", "Οκτώβριος", "Νοέμβριος", "Δεκέμβριος"]);
        /// `&["πμ", "μμ"]`
        pub const AM_PM: &[&str] = &["πμ", "μμ"];
        /// `None`
        pub const CAL_DIRECTION: Option<i64> = None;
        /// `Some("%a %d %b %Y %r %Z")`
        pub const DATE_FMT: Option<&str> = Some("%a %d %b %Y %r %Z");
        /// `&["Κυριακή", "Δευτέρα", "Τρίτη", "Τετάρτη", "Πέμπτη", "Παρασκευή", "Σάββατο"]`
        pub const DAY: &[&str] = &["Κυριακή", "Δευτέρα", "Τρίτη", "Τετάρτη", "Πέμπτη", "Παρασκευή", "Σάββατο"];
        /// `"%d/%m/%Y"`
        pub const D_FMT: &str = "%d/%m/%Y";
        /// `"%a %d %b %Y %I:%M:%S %p %Z"`
        pub const D_T_FMT: &str = "%a %d %b %Y %I:%M:%S %p %Z";
        /// `None`
        pub const ERA: Option<&[&str]> = None;
        /// `None`
        pub const ERA_D_FMT: Option<&str> = None;
        /// `None`
        pub const ERA_D_T_FMT: Option<&str> = None;
        /// `None`
        pub const ERA_T_FMT: Option<&str> = None;
        /// `Some(2)`
        pub const FIRST_WEEKDAY: Option<i64> = Some(2);
        /// `None`
        pub const FIRST_WORKDAY: Option<i64> = None;
        /// `&["Ιανουαρίου", "Φεβρουαρίου", "Μαρτίου", "Απριλίου", "Μαΐου", "Ιουνίου", "Ιουλίου", "Αυγούστου", "Σεπτεμβρίου", "Οκτωβρίου", "Νοεμβρίου", "Δεκεμβρίου"]`
        pub const MON: &[&str] = &["Ιανουαρίου", "Φεβρουαρίου", "Μαρτίου", "Απριλίου", "Μαΐου", "Ιουνίου", "Ιουλίου", "Αυγούστου", "Σεπτεμβρίου", "Οκτωβρίου", "Νοεμβρίου", "Δεκεμβρίου"];
        /// `"%I:%M:%S %p"`
        pub const T_FMT: &str = "%I:%M:%S %p";
        /// `"%I:%M:%S %p"`
        pub const T_FMT_AMPM: &str = "%I:%M:%S %p";
        /// `Some(&[7, 19971130, 1])`
        pub const WEEK: Option<&[i64]> = Some(&[7, 19971130, 1]);
    }
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod el_GR {
    pub mod LC_ADDRESS {
        /// `Some("GRC")`
        pub const COUNTRY_AB3: Option<&str> = Some("GRC");
        /// `Some("GR")`
        pub const COUNTRY_ABTWO: Option<&str> = Some("GR");
        /// `Some("GR")`
        pub const COUNTRY_CAR: Option<&str> = Some("GR");
        /// `None`
        pub const COUNTRY_ISBN: Option<&str> = None;
        /// `Some("Ελλάδα")`
        pub const COUNTRY_NAME: Option<&str> = Some("Ελλάδα");
        /// `Some(300)`
        pub const COUNTRY_NUM: Option<i64> = Some(300);
        /// `None`
        pub const COUNTRY_POST: Option<&str> = None;
        /// `Some("el")`
        pub const LANG_AB: Option<&str> = Some("el");
        /// `Some("gre")`
        pub const LANG_LIB: Option<&str> = Some("gre");
        /// `Some("Ελληνικά")`
        pub const LANG_NAME: Option<&str> = Some("Ελληνικά");
        /// `Some("ell")`
        pub const LANG_TERM: Option<&str> = Some("ell");
        /// `Some("%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%c%N")`
        pub const POSTAL_FMT: Option<&str> = Some("%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%c%N");
    }
    pub mod LC_IDENTIFICATION {
        /// `None`
        pub const ABBREVIATION: Option<&str> = None;
        /// `Some("Sankt Jorgens Alle 8, DK-1615 Kobenhavn V, Danmark")`
        pub const ADDRESS: Option<&str> = Some("Sankt Jorgens Alle 8, DK-1615 Kobenhavn V, Danmark");
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        /// ]
        /// ```
        pub const CATEGORY: Option<&[&[&str]]> = Some(&[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_TELEPHONE"],
            &["i18n:2012", "LC_MEASUREMENT"],
        ]);
        /// `Some("")`
        pub const CONTACT: Option<&str> = Some("");
        /// `Some("2000-06-29")`
        pub const DATE: Option<&str> = Some("2000-06-29");
        /// `Some("bug-glibc-locales@gnu.org")`
        pub const EMAIL: Option<&str> = Some("bug-glibc-locales@gnu.org");
        /// `Some("")`
        pub const FAX: Option<&str> = Some("");
        /// `Some("Greek")`
        pub const LANGUAGE: Option<&str> = Some("Greek");
        /// `Some("1.0")`
        pub const REVISION: Option<&str> = Some("1.0");
        /// `Some("RAP")`
        pub const SOURCE: Option<&str> = Some("RAP");
        /// `Some("")`
        pub const TEL: Option<&str> = Some("");
        /// `Some("Greece")`
        pub const TERRITORY: Option<&str> = Some("Greece");
        /// `Some("Greek locale for Greece")`
        pub const TITLE: Option<&str> = Some("Greek locale for Greece");
    }
    pub mod LC_MESSAGES {
        /// `"^[-0nNοΟόΌ]"`
        pub const NOEXPR: &str = "^[-0nNοΟόΌ]";
        /// `Some("όχι")`
        pub const NOSTR: Option<&str> = Some("όχι");
        /// `"^[+1yYνΝ]"`
        pub const YESEXPR: &str = "^[+1yYνΝ]";
        /// `Some("ναι")`
        pub const YESSTR: Option<&str> = Some("ναι");
    }
    pub mod LC_MONETARY {
        /// `"€"`
        pub const CURRENCY_SYMBOL: &str = "€";
        /// `2`
        pub const FRAC_DIGITS: i64 = 2;
        /// `"EUR "`
        pub const INT_CURR_SYMBOL: &str = "EUR ";
        /// `2`
        pub const INT_FRAC_DIGITS: i64 = 2;
        /// `None`
        pub const INT_N_CS_PRECEDES: Option<i64> = None;
        /// `None`
        pub const INT_N_SEP_BY_SPACE: Option<i64> = None;
        /// `None`
        pub const INT_N_SIGN_POSN: Option<i64> = None;
        /// `None`
        pub const INT_P_CS_PRECEDES: Option<i64> = None;
        /// `None`
        pub const INT_P_SEP_BY_SPACE: Option<i64> = None;
        /// `None`
        pub const INT_P_SIGN_POSN: Option<i64> = None;
        /// `","`
        pub const MON_DECIMAL_POINT: &str = ",";
        /// `&[3]`
        pub const MON_GROUPING: &[i64] = &[3];
        /// `"."`
        pub const MON_THOUSANDS_SEP: &str = ".";
        /// `"-"`
        pub const NEGATIVE_SIGN: &str = "-";
        /// `0`
        pub const N_CS_PRECEDES: i64 = 0;
        /// `0`
        pub const N_SEP_BY_SPACE: i64 = 0;
        /// `1`
        pub const N_SIGN_POSN: i64 = 1;
        /// `""`
        pub const POSITIVE_SIGN: &str = "";
        /// `0`
        pub const P_CS_PRECEDES: i64 = 0;
        /// `0`
        pub const P_SEP_BY_SPACE: i64 = 0;
        /// `1`
        pub const P_SIGN_POSN: i64 = 1;
    }
    pub mod LC_NUMERIC {
        /// `","`
        pub const DECIMAL_POINT: &str = ",";
        /// `&[0, 0]`
        pub const GROUPING: &[i64] = &[0, 0];
        /// `"."`
        pub const THOUSANDS_SEP: &str = ".";
    }
    pub mod LC_TELEPHONE {
        /// `Some("30")`
        pub const INT_PREFIX: Option<&str> = Some("30");
        /// `Some("00")`
        pub const INT_SELECT: Option<&str> = Some("00");
        /// `None`
        pub const TEL_DOM_FMT: Option<&str> = None;
        /// `Some("+%c %a %l")`
        pub const TEL_INT_FMT: Option<&str> = Some("+%c %a %l");
    }
    pub mod LC_TIME {
        /// `&["Κυρ", "Δευ", "Τρι", "Τετ", "Πεμ", "Παρ", "Σαβ"]`
        pub const ABDAY: &[&str] = &["Κυρ", "Δευ", "Τρι", "Τετ", "Πεμ", "Παρ", "Σαβ"];
        /// `&["Ιαν", "Φεβ", "Μαρ", "Απρ", "Μαΐ", "Ιουν", "Ιουλ", "Αυγ", "Σεπ", "Οκτ", "Νοε", "Δεκ"]`
        pub const ABMON: &[&str] = &["Ιαν", "Φεβ", "Μαρ", "Απρ", "Μαΐ", "Ιουν", "Ιουλ", "Αυγ", "Σεπ", "Οκτ", "Νοε", "Δεκ"];
        /// `Some(&["Ιαν", "Φεβ", "Μάρ", "Απρ", "Μάι", "Ιούν", "Ιούλ", "Αύγ", "Σεπ", "Οκτ", "Νοέ", "Δεκ"])`
        pub const AB_ALT_MON: Option<&[&str]> = Some(&["Ιαν", "Φεβ", "Μάρ", "Απρ", "Μάι", "Ιούν", "Ιούλ", "Αύγ", "Σεπ", "Οκτ", "Νοέ", "Δεκ"]);
        /// `None`
        pub const ALT_DIGITS: Option<&[&str]> = None;
        /// `Some(&["Ιανουάριος", "Φεβρουάριος", "Μάρτιος", "Απρίλιος", "Μάιος", "Ιούνιος", "Ιούλιος", "Αύγουστος", "Σεπτέμβριος", "Οκτώβριος", "Νοέμβριος", "Δεκέμβριος"])`
        pub const ALT_MON: Option<&[&str]> = Some(&["Ιανουάριος", "Φεβρουάριος", "Μάρτιος", "Απρίλιος", "Μάιος", "Ιούνιος", "Ιούλιος", "Αύγουστος", "Σεπτέμβριος", "Οκτώβριος", "Νοέμβριος", "Δεκέμβριος"]);
        /// `&["πμ", "μμ"]`
        pub const AM_PM: &[&str] = &["πμ", "μμ"];
        /// `None`
        pub const CAL_DIRECTION: Option<i64> = None;
        /// `Some("%a %d %b %Y %r %Z")`
        pub const DATE_FMT: Option<&str> = Some("%a %d %b %Y %r %Z");
        /// `&["Κυριακή", "Δευτέρα", "Τρίτη", "Τετάρτη", "Πέμπτη", "Παρασκευή", "Σάββατο"]`
        pub const DAY: &[&str] = &["Κυριακή", "Δευτέρα", "Τρίτη", "Τετάρτη", "Πέμπτη", "Παρασκευή", "Σάββατο"];
        /// `"%d/%m/%Y"`
        pub const D_FMT: &str = "%d/%m/%Y";
        /// `"%a %d %b %Y %I:%M:%S %p %Z"`
        pub const D_T_FMT: &str = "%a %d %b %Y %I:%M:%S %p %Z";
        /// `None`
        pub const ERA: Option<&[&str]> = None;
        /// `None`
        pub const ERA_D_FMT: Option<&str> = None;
        /// `None`
        pub const ERA_D_T_FMT: Option<&str> = None;
        /// `None`
        pub const ERA_T_FMT: Option<&str> = None;
        /// `Some(2)`
        pub const FIRST_WEEKDAY: Option<i64> = Some(2);
        /// `None`
        pub const FIRST_WORKDAY: Option<i64> = None;
        /// `&["Ιανουαρίου", "Φεβρουαρίου", "Μαρτίου", "Απριλίου", "Μαΐου", "Ιουνίου", "Ιουλίου", "Αυγούστου", "Σεπτεμβρίου", "Οκτωβρίου", "Νοεμβρίου", "Δεκεμβρίου"]`
        pub const MON: &[&str] = &["Ιανουαρίου", "Φεβρουαρίου", "Μαρτίου", "Απριλίου", "Μαΐου", "Ιουνίου", "Ιουλίου", "Αυγούστου", "Σεπτεμβρίου", "Οκτωβρίου", "Νοεμβρίου", "Δεκεμβρίου"];
        /// `"%I:%M:%S %p"`
        pub const T_FMT: &str = "%I:%M:%S %p";
        /// `"%I:%M:%S %p"`
        pub const T_FMT_AMPM: &str = "%I:%M:%S %p";
        /// `Some(&[7, 19971130, 4])`
        pub const WEEK: Option<&[i64]> = Some(&[7, 19971130, 4]);
    }
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod el_GR_euro {
    pub use super::el_GR::LC_ADDRESS;
    pub mod LC_IDENTIFICATION {
        /// `None`
        pub const ABBREVIATION: Option<&str> = None;
        /// `Some("https://www.gnu.org/software/libc/")`
        pub const ADDRESS: Option<&str> = Some("https://www.gnu.org/software/libc/");
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        /// ]
        /// ```
        pub const CATEGORY: Option<&[&[&str]]> = Some(&[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_TELEPHONE"],
            &["i18n:2012", "LC_MEASUREMENT"],
        ]);
        /// `Some("")`
        pub const CONTACT: Option<&str> = Some("");
        /// `Some("2000-06-24")`
        pub const DATE: Option<&str> = Some("2000-06-24");
        /// `Some("bug-glibc-locales@gnu.org")`
        pub const EMAIL: Option<&str> = Some("bug-glibc-locales@gnu.org");
        /// `Some("")`
        pub const FAX: Option<&str> = Some("");
        /// `Some("Greek")`
        pub const LANGUAGE: Option<&str> = Some("Greek");
        /// `Some("1.0")`
        pub const REVISION: Option<&str> = Some("1.0");
        /// `Some("Free Software Foundation, Inc.")`
        pub const SOURCE: Option<&str> = Some("Free Software Foundation, Inc.");
        /// `Some("")`
        pub const TEL: Option<&str> = Some("");
        /// `Some("Greece")`
        pub const TERRITORY: Option<&str> = Some("Greece");
        /// `Some("Greek locale for Greece with Euro")`
        pub const TITLE: Option<&str> = Some("Greek locale for Greece with Euro");
    }
    pub use super::el_GR::LC_MESSAGES;
    pub use super::el_GR::LC_MONETARY;
    pub use super::el_GR::LC_NUMERIC;
    pub use super::el_GR::LC_TELEPHONE;
    pub use super::el_GR::LC_TIME;
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod en_AG {
    pub mod LC_ADDRESS {
        /// `Some("ATG")`
        pub const COUNTRY_AB3: Option<&str> = Some("ATG");
        /// `Some("AG")`
        pub const COUNTRY_ABTWO: Option<&str> = Some("AG");
        /// `Some("AG")`
        pub const COUNTRY_CAR: Option<&str> = Some("AG");
        /// `None`
        pub const COUNTRY_ISBN: Option<&str> = None;
        /// `Some("Antigua & Barbuda")`
        pub const COUNTRY_NAME: Option<&str> = Some("Antigua & Barbuda");
        /// `Some(28)`
        pub const COUNTRY_NUM: Option<i64> = Some(28);
        /// `None`
        pub const COUNTRY_POST: Option<&str> = None;
        /// `Some("en")`
        pub const LANG_AB: Option<&str> = Some("en");
        /// `Some("eng")`
        pub const LANG_LIB: Option<&str> = Some("eng");
        /// `Some("English")`
        pub const LANG_NAME: Option<&str> = Some("English");
        /// `Some("eng")`
        pub const LANG_TERM: Option<&str> = Some("eng");
        /// `Some("%f%N%a%N%d%N%b%N%s %h %e %r%N%%z %T%N%c%N")`
        pub const POSTAL_FMT: Option<&str> = Some("%f%N%a%N%d%N%b%N%s %h %e %r%N%%z %T%N%c%N");
    }
    pub mod LC_IDENTIFICATION {
        /// `None`
        pub const ABBREVIATION: Option<&str> = None;
        /// `Some("https://www.gnu.org/software/libc/")`
        pub const ADDRESS: Option<&str> = Some("https://www.gnu.org/software/libc/");
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        /// ]
        /// ```
        pub const CATEGORY: Option<&[&[&str]]> = Some(&[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_TELEPHONE"],
            &["i18n:2012", "LC_MEASUREMENT"],
        ]);
        /// `Some("")`
        pub const CONTACT: Option<&str> = Some("");
        /// `Some("2008-09-16")`
        pub const DATE: Option<&str> = Some("2008-09-16");
        /// `Some("bug-glibc-locales@gnu.org")`
        pub const EMAIL: Option<&str> = Some("bug-glibc-locales@gnu.org");
        /// `Some("")`
        pub const FAX: Option<&str> = Some("");
        /// `Some("English")`
        pub const LANGUAGE: Option<&str> = Some("English");
        /// `Some("1.0")`
        pub const REVISION: Option<&str> = Some("1.0");
        /// `Some("Free Software Foundation, Inc.")`
        pub const SOURCE: Option<&str> = Some("Free Software Foundation, Inc.");
        /// `Some("")`
        pub const TEL: Option<&str> = Some("");
        /// `Some("Antigua & Barbuda")`
        pub const TERRITORY: Option<&str> = Some("Antigua & Barbuda");
        /// `Some("English language locale for Antigua and Barbuda")`
        pub const TITLE: Option<&str> = Some("English language locale for Antigua and Barbuda");
    }
    pub use super::en_GB::LC_MESSAGES;
    pub mod LC_MONETARY {
        /// `"$"`
        pub const CURRENCY_SYMBOL: &str = "$";
        /// `2`
        pub const FRAC_DIGITS: i64 = 2;
        /// `"XCD "`
        pub const INT_CURR_SYMBOL: &str = "XCD ";
        /// `2`
        pub const INT_FRAC_DIGITS: i64 = 2;
        /// `None`
        pub const INT_N_CS_PRECEDES: Option<i64> = None;
        /// `None`
        pub const INT_N_SEP_BY_SPACE: Option<i64> = None;
        /// `None`
        pub const INT_N_SIGN_POSN: Option<i64> = None;
        /// `None`
        pub const INT_P_CS_PRECEDES: Option<i64> = None;
        /// `None`
        pub const INT_P_SEP_BY_SPACE: Option<i64> = None;
        /// `None`
        pub const INT_P_SIGN_POSN: Option<i64> = None;
        /// `"."`
        pub const MON_DECIMAL_POINT: &str = ".";
        /// `&[3, 3]`
        pub const MON_GROUPING: &[i64] = &[3, 3];
        /// `","`
        pub const MON_THOUSANDS_SEP: &str = ",";
        /// `"-"`
        pub const NEGATIVE_SIGN: &str = "-";
        /// `1`
        pub const N_CS_PRECEDES: i64 = 1;
        /// `0`
        pub const N_SEP_BY_SPACE: i64 = 0;
        /// `1`
        pub const N_SIGN_POSN: i64 = 1;
        /// `""`
        pub const POSITIVE_SIGN: &str = "";
        /// `1`
        pub const P_CS_PRECEDES: i64 = 1;
        /// `0`
        pub const P_SEP_BY_SPACE: i64 = 0;
        /// `1`
        pub const P_SIGN_POSN: i64 = 1;
    }
    pub use super::en_GB::LC_NUMERIC;
    pub mod LC_TELEPHONE {
        /// `Some("1")`
        pub const INT_PREFIX: Option<&str> = Some("1");
        /// `Some("011")`
        pub const INT_SELECT: Option<&str> = Some("011");
        /// `None`
        pub const TEL_DOM_FMT: Option<&str> = None;
        /// `Some("+%c %a %l")`
        pub const TEL_INT_FMT: Option<&str> = Some("+%c %a %l");
    }
    pub mod LC_TIME {
        /// `&["Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"]`
        pub const ABDAY: &[&str] = &["Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"];
        /// `&["Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"]`
        pub const ABMON: &[&str] = &["Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"];
        /// `None`
        pub const AB_ALT_MON: Option<&[&str]> = None;
        /// `None`
        pub const ALT_DIGITS: Option<&[&str]> = None;
        /// `None`
        pub const ALT_MON: Option<&[&str]> = None;
        /// `&["am", "pm"]`
        pub const AM_PM: &[&str] = &["am", "pm"];
        /// `None`
        pub const CAL_DIRECTION: Option<i64> = None;
        /// `Some("%a %e %b %H:%M:%S %Z %Y")`
        pub const DATE_FMT: Option<&str> = Some("%a %e %b %H:%M:%S %Z %Y");
        /// `&["Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"]`
        pub const DAY: &[&str] = &["Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"];
        /// `"%d/%m/%y"`
        pub const D_FMT: &str = "%d/%m/%y";
        /// `"%a %d %b %Y %T %Z"`
        pub const D_T_FMT: &str = "%a %d %b %Y %T %Z";
        /// `None`
        pub const ERA: Option<&[&str]> = None;
        /// `None`
        pub const ERA_D_FMT: Option<&str> = None;
        /// `None`
        pub const ERA_D_T_FMT: Option<&str> = None;
        /// `None`
        pub const ERA_T_FMT: Option<&str> = None;
        /// `None`
        pub const FIRST_WEEKDAY: Option<i64> = None;
        /// `None`
        pub const FIRST_WORKDAY: Option<i64> = None;
        /// `&["January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"]`
        pub const MON: &[&str] = &["January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"];
        /// `"%T"`
        pub const T_FMT: &str = "%T";
        /// `"%l:%M:%S %P %Z"`
        pub const T_FMT_AMPM: &str = "%l:%M:%S %P %Z";
        /// `Some(&[7, 19971130, 1])`
        pub const WEEK: Option<&[i64]> = Some(&[7, 19971130, 1]);
    }
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod en_AU {
    pub mod LC_ADDRESS {
        /// `Some("AUS")`
        pub const COUNTRY_AB3: Option<&str> = Some("AUS");
        /// `Some("AU")`
        pub const COUNTRY_ABTWO: Option<&str> = Some("AU");
        /// `Some("AUS")`
        pub const COUNTRY_CAR: Option<&str> = Some("AUS");
        /// `None`
        pub const COUNTRY_ISBN: Option<&str> = None;
        /// `Some("Australia")`
        pub const COUNTRY_NAME: Option<&str> = Some("Australia");
        /// `Some(36)`
        pub const COUNTRY_NUM: Option<i64> = Some(36);
        /// `None`
        pub const COUNTRY_POST: Option<&str> = None;
        /// `Some("en")`
        pub const LANG_AB: Option<&str> = Some("en");
        /// `Some("eng")`
        pub const LANG_LIB: Option<&str> = Some("eng");
        /// `Some("English")`
        pub const LANG_NAME: Option<&str> = Some("English");
        /// `Some("eng")`
        pub const LANG_TERM: Option<&str> = Some("eng");
        /// `Some("%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%c%N")`
        pub const POSTAL_FMT: Option<&str> = Some("%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%c%N");
    }
    pub mod LC_IDENTIFICATION {
        /// `None`
        pub const ABBREVIATION: Option<&str> = None;
        /// `Some("Sankt Jørgens Alle 8, DK-1615 København V, Danmark")`
        pub const ADDRESS: Option<&str> = Some("Sankt Jørgens Alle 8, DK-1615 København V, Danmark");
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        /// ]
        /// ```
        pub const CATEGORY: Option<&[&[&str]]> = Some(&[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_TELEPHONE"],
            &["i18n:2012", "LC_MEASUREMENT"],
        ]);
        /// `Some("")`
        pub const CONTACT: Option<&str> = Some("");
        /// `Some("2000-06-29")`
        pub const DATE: Option<&str> = Some("2000-06-29");
        /// `Some("bug-glibc-locales@gnu.org")`
        pub const EMAIL: Option<&str> = Some("bug-glibc-locales@gnu.org");
        /// `Some("")`
        pub const FAX: Option<&str> = Some("");
        /// `Some("Australian English")`
        pub const LANGUAGE: Option<&str> = Some("Australian English");
        /// `Some("1.0")`
        pub const REVISION: Option<&str> = Some("1.0");
        /// `Some("RAP")`
        pub const SOURCE: Option<&str> = Some("RAP");
        /// `Some("")`
        pub const TEL: Option<&str> = Some("");
        /// `Some("Australia")`
        pub const TERRITORY: Option<&str> = Some("Australia");
        /// `Some("English locale for Australia")`
        pub const TITLE: Option<&str> = Some("English locale for Australia");
    }
    pub use super::en_US::LC_MESSAGES;
    pub mod LC_MONETARY {
        /// `"$"`
        pub const CURRENCY_SYMBOL: &str = "$";
        /// `2`
        pub const FRAC_DIGITS: i64 = 2;
        /// `"AUD "`
        pub const INT_CURR_SYMBOL: &str = "AUD ";
        /// `2`
        pub const INT_FRAC_DIGITS: i64 = 2;
        /// `None`
        pub const INT_N_CS_PRECEDES: Option<i64> = None;
        /// `None`
        pub const INT_N_SEP_BY_SPACE: Option<i64> = None;
        /// `None`
        pub const INT_N_SIGN_POSN: Option<i64> = None;
        /// `None`
        pub const INT_P_CS_PRECEDES: Option<i64> = None;
        /// `None`
        pub const INT_P_SEP_BY_SPACE: Option<i64> = None;
        /// `None`
        pub const INT_P_SIGN_POSN: Option<i64> = None;
        /// `"."`
        pub const MON_DECIMAL_POINT: &str = ".";
        /// `&[3, 3]`
        pub const MON_GROUPING: &[i64] = &[3, 3];
        /// `","`
        pub const MON_THOUSANDS_SEP: &str = ",";
        /// `"-"`
        pub const NEGATIVE_SIGN: &str = "-";
        /// `1`
        pub const N_CS_PRECEDES: i64 = 1;
        /// `0`
        pub const N_SEP_BY_SPACE: i64 = 0;
        /// `1`
        pub const N_SIGN_POSN: i64 = 1;
        /// `""`
        pub const POSITIVE_SIGN: &str = "";
        /// `1`
        pub const P_CS_PRECEDES: i64 = 1;
        /// `0`
        pub const P_SEP_BY_SPACE: i64 = 0;
        /// `1`
        pub const P_SIGN_POSN: i64 = 1;
    }
    pub mod LC_NUMERIC {
        /// `"."`
        pub const DECIMAL_POINT: &str = ".";
        /// `&[3, 3]`
        pub const GROUPING: &[i64] = &[3, 3];
        /// `","`
        pub const THOUSANDS_SEP: &str = ",";
    }
    pub mod LC_TELEPHONE {
        /// `Some("61")`
        pub const INT_PREFIX: Option<&str> = Some("61");
        /// `Some("0011")`
        pub const INT_SELECT: Option<&str> = Some("0011");
        /// `None`
        pub const TEL_DOM_FMT: Option<&str> = None;
        /// `Some("+%c %a %l")`
        pub const TEL_INT_FMT: Option<&str> = Some("+%c %a %l");
    }
    pub mod LC_TIME {
        /// `&["Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"]`
        pub const ABDAY: &[&str] = &["Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"];
        /// `&["Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"]`
        pub const ABMON: &[&str] = &["Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"];
        /// `None`
        pub const AB_ALT_MON: Option<&[&str]> = None;
        /// `None`
        pub const ALT_DIGITS: Option<&[&str]> = None;
        /// `None`
        pub const ALT_MON: Option<&[&str]> = None;
        /// `&["AM", "PM"]`
        pub const AM_PM: &[&str] = &["AM", "PM"];
        /// `None`
        pub const CAL_DIRECTION: Option<i64> = None;
        /// `None`
        pub const DATE_FMT: Option<&str> = None;
        /// `&["Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"]`
        pub const DAY: &[&str] = &["Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"];
        /// `"%d/%m/%y"`
        pub const D_FMT: &str = "%d/%m/%y";
        /// `"%a %d %b %Y %T %Z"`
        pub const D_T_FMT: &str = "%a %d %b %Y %T %Z";
        /// `None`
        pub const ERA: Option<&[&str]> = None;
        /// `None`
        pub const ERA_D_FMT: Option<&str> = None;
        /// `None`
        pub const ERA_D_T_FMT: Option<&str> = None;
        /// `None`
        pub const ERA_T_FMT: Option<&str> = None;
        /// `None`
        pub const FIRST_WEEKDAY: Option<i64> = None;
        /// `None`
        pub const FIRST_WORKDAY: Option<i64> = None;
        /// `&["January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"]`
        pub const MON: &[&str] = &["January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"];
        /// `"%T"`
        pub const T_FMT: &str = "%T";
        /// `"%I:%M:%S %p"`
        pub const T_FMT_AMPM: &str = "%I:%M:%S %p";
        /// `Some(&[7, 19971130, 1])`
        pub const WEEK: Option<&[i64]> = Some(&[7, 19971130, 1]);
    }
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod en_BW {
    pub mod LC_ADDRESS {
        /// `Some("BWA")`
        pub const COUNTRY_AB3: Option<&str> = Some("BWA");
        /// `Some("BW")`
        pub const COUNTRY_ABTWO: Option<&str> = Some("BW");
        /// `Some("BW")`
        pub const COUNTRY_CAR: Option<&str> = Some("BW");
        /// `None`
        pub const COUNTRY_ISBN: Option<&str> = None;
        /// `Some("Botswana")`
        pub const COUNTRY_NAME: Option<&str> = Some("Botswana");
        /// `Some(72)`
        pub const COUNTRY_NUM: Option<i64> = Some(72);
        /// `None`
        pub const COUNTRY_POST: Option<&str> = None;
        /// `Some("en")`
        pub const LANG_AB: Option<&str> = Some("en");
        /// `Some("eng")`
        pub const LANG_LIB: Option<&str> = Some("eng");
        /// `Some("English")`
        pub const LANG_NAME: Option<&str> = Some("English");
        /// `Some("eng")`
        pub const LANG_TERM: Option<&str> = Some("eng");
        /// `Some("%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%c%N")`
        pub const POSTAL_FMT: Option<&str> = Some("%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%c%N");
    }
    pub mod LC_IDENTIFICATION {
        /// `None`
        pub const ABBREVIATION: Option<&str> = None;
        /// `Some("")`
        pub const ADDRESS: Option<&str> = Some("");
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        /// ]
        /// ```
        pub const CATEGORY: Option<&[&[&str]]> = Some(&[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_TELEPHONE"],
            &["i18n:2012", "LC_MEASUREMENT"],
        ]);
        /// `Some("")`
        pub const CONTACT: Option<&str> = Some("");
        /// `Some("2000-06-29")`
        pub const DATE: Option<&str> = Some("2000-06-29");
        /// `Some("bug-glibc-locales@gnu.org")`
        pub const EMAIL: Option<&str> = Some("bug-glibc-locales@gnu.org");
        /// `Some("")`
        pub const FAX: Option<&str> = Some("");
        /// `Some("English")`
        pub const LANGUAGE: Option<&str> = Some("English");
        /// `Some("1.0")`
        pub const REVISION: Option<&str> = Some("1.0");
        /// `Some("RAP")`
        pub const SOURCE: Option<&str> = Some("RAP");
        /// `Some("")`
        pub const TEL: Option<&str> = Some("");
        /// `Some("Botswana")`
        pub const TERRITORY: Option<&str> = Some("Botswana");
        /// `Some("English locale for Botswana")`
        pub const TITLE: Option<&str> = Some("English locale for Botswana");
    }
    pub use super::en_ZA::LC_MESSAGES;
    pub mod LC_MONETARY {
        /// `"P"`
        pub const CURRENCY_SYMBOL: &str = "P";
        /// `2`
        pub const FRAC_DIGITS: i64 = 2;
        /// `"BWP "`
        pub const INT_CURR_SYMBOL: &str = "BWP ";
        /// `2`
        pub const INT_FRAC_DIGITS: i64 = 2;
        /// `None`
        pub const INT_N_CS_PRECEDES: Option<i64> = None;
        /// `None`
        pub const INT_N_SEP_BY_SPACE: Option<i64> = None;
        /// `None`
        pub const INT_N_SIGN_POSN: Option<i64> = None;
        /// `None`
        pub const INT_P_CS_PRECEDES: Option<i64> = None;
        /// `None`
        pub const INT_P_SEP_BY_SPACE: Option<i64> = None;
        /// `None`
        pub const INT_P_SIGN_POSN: Option<i64> = None;
        /// `"."`
        pub const MON_DECIMAL_POINT: &str = ".";
        /// `&[3, 3]`
        pub const MON_GROUPING: &[i64] = &[3, 3];
        /// `","`
        pub const MON_THOUSANDS_SEP: &str = ",";
        /// `"-"`
        pub const NEGATIVE_SIGN: &str = "-";
        /// `1`
        pub const N_CS_PRECEDES: i64 = 1;
        /// `0`
        pub const N_SEP_BY_SPACE: i64 = 0;
        /// `1`
        pub const N_SIGN_POSN: i64 = 1;
        /// `""`
        pub const POSITIVE_SIGN: &str = "";
        /// `1`
        pub const P_CS_PRECEDES: i64 = 1;
        /// `0`
        pub const P_SEP_BY_SPACE: i64 = 0;
        /// `1`
        pub const P_SIGN_POSN: i64 = 1;
    }
    pub use super::en_ZA::LC_NUMERIC;
    pub mod LC_TELEPHONE {
        /// `Some("267")`
        pub const INT_PREFIX: Option<&str> = Some("267");
        /// `Some("00")`
        pub const INT_SELECT: Option<&str> = Some("00");
        /// `None`
        pub const TEL_DOM_FMT: Option<&str> = None;
        /// `Some("+%c %a %l")`
        pub const TEL_INT_FMT: Option<&str> = Some("+%c %a %l");
    }
    pub use super::en_ZA::LC_TIME;
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod en_CA {
    pub mod LC_ADDRESS {
        /// `Some("CAN")`
        pub const COUNTRY_AB3: Option<&str> = Some("CAN");
        /// `Some("CA")`
        pub const COUNTRY_ABTWO: Option<&str> = Some("CA");
        /// `Some("CDN")`
        pub const COUNTRY_CAR: Option<&str> = Some("CDN");
        /// `None`
        pub const COUNTRY_ISBN: Option<&str> = None;
        /// `Some("Canada")`
        pub const COUNTRY_NAME: Option<&str> = Some("Canada");
        /// `Some(124)`
        pub const COUNTRY_NUM: Option<i64> = Some(124);
        /// `None`
        pub const COUNTRY_POST: Option<&str> = None;
        /// `Some("en")`
        pub const LANG_AB: Option<&str> = Some("en");
        /// `Some("eng")`
        pub const LANG_LIB: Option<&str> = Some("eng");
        /// `Some("English")`
        pub const LANG_NAME: Option<&str> = Some("English");
        /// `Some("eng")`
        pub const LANG_TERM: Option<&str> = Some("eng");
        /// `Some("%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%c%N")`
        pub const POSTAL_FMT: Option<&str> = Some("%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%c%N");
    }
    pub mod LC_IDENTIFICATION {
        /// `None`
        pub const ABBREVIATION: Option<&str> = None;
        /// `Some("Sankt Jørgens Alle 8, DK-1615 København V, Danmark")`
        pub const ADDRESS: Option<&str> = Some("Sankt Jørgens Alle 8, DK-1615 København V, Danmark");
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        /// ]
        /// ```
        pub const CATEGORY: Option<&[&[&str]]> = Some(&[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_TELEPHONE"],
            &["i18n:2012", "LC_MEASUREMENT"],
        ]);
        /// `Some("")`
        pub const CONTACT: Option<&str> = Some("");
        /// `Some("2000-06-29")`
        pub const DATE: Option<&str> = Some("2000-06-29");
        /// `Some("bug-glibc-locales@gnu.org")`
        pub const EMAIL: Option<&str> = Some("bug-glibc-locales@gnu.org");
        /// `Some("")`
        pub const FAX: Option<&str> = Some("");
        /// `Some("Canadian English")`
        pub const LANGUAGE: Option<&str> = Some("Canadian English");
        /// `Some("1.0")`
        pub const REVISION: Option<&str> = Some("1.0");
        /// `Some("RAP")`
        pub const SOURCE: Option<&str> = Some("RAP");
        /// `Some("")`
        pub const TEL: Option<&str> = Some("");
        /// `Some("Canada")`
        pub const TERRITORY: Option<&str> = Some("Canada");
        /// `Some("English locale for Canada")`
        pub const TITLE: Option<&str> = Some("English locale for Canada");
    }
    pub mod LC_MESSAGES {
        /// `"^[-0nN]"`
        pub const NOEXPR: &str = "^[-0nN]";
        /// `Some("no")`
        pub const NOSTR: Option<&str> = Some("no");
        /// `"^[+1yYoO]"`
        pub const YESEXPR: &str = "^[+1yYoO]";
        /// `Some("yes")`
        pub const YESSTR: Option<&str> = Some("yes");
    }
    pub mod LC_MONETARY {
        /// `"$"`
        pub const CURRENCY_SYMBOL: &str = "$";
        /// `2`
        pub const FRAC_DIGITS: i64 = 2;
        /// `"CAD "`
        pub const INT_CURR_SYMBOL: &str = "CAD ";
        /// `2`
        pub const INT_FRAC_DIGITS: i64 = 2;
        /// `None`
        pub const INT_N_CS_PRECEDES: Option<i64> = None;
        /// `None`
        pub const INT_N_SEP_BY_SPACE: Option<i64> = None;
        /// `None`
        pub const INT_N_SIGN_POSN: Option<i64> = None;
        /// `None`
        pub const INT_P_CS_PRECEDES: Option<i64> = None;
        /// `None`
        pub const INT_P_SEP_BY_SPACE: Option<i64> = None;
        /// `None`
        pub const INT_P_SIGN_POSN: Option<i64> = None;
        /// `"."`
        pub const MON_DECIMAL_POINT: &str = ".";
        /// `&[3, 3]`
        pub const MON_GROUPING: &[i64] = &[3, 3];
        /// `","`
        pub const MON_THOUSANDS_SEP: &str = ",";
        /// `"-"`
        pub const NEGATIVE_SIGN: &str = "-";
        /// `1`
        pub const N_CS_PRECEDES: i64 = 1;
        /// `0`
        pub const N_SEP_BY_SPACE: i64 = 0;
        /// `1`
        pub const N_SIGN_POSN: i64 = 1;
        /// `""`
        pub const POSITIVE_SIGN: &str = "";
        /// `1`
        pub const P_CS_PRECEDES: i64 = 1;
        /// `0`
        pub const P_SEP_BY_SPACE: i64 = 0;
        /// `1`
        pub const P_SIGN_POSN: i64 = 1;
    }
    pub mod LC_NUMERIC {
        /// `"."`
        pub const DECIMAL_POINT: &str = ".";
        /// `&[3, 3]`
        pub const GROUPING: &[i64] = &[3, 3];
        /// `","`
        pub const THOUSANDS_SEP: &str = ",";
    }
    pub mod LC_TELEPHONE {
        /// `Some("1")`
        pub const INT_PREFIX: Option<&str> = Some("1");
        /// `Some("011")`
        pub const INT_SELECT: Option<&str> = Some("011");
        /// `None`
        pub const TEL_DOM_FMT: Option<&str> = None;
        /// `Some("+%c %a %l")`
        pub const TEL_INT_FMT: Option<&str> = Some("+%c %a %l");
    }
    pub mod LC_TIME {
        /// `&["Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"]`
        pub const ABDAY: &[&str] = &["Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"];
        /// `&["Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"]`
        pub const ABMON: &[&str] = &["Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"];
        /// `None`
        pub const AB_ALT_MON: Option<&[&str]> = None;
        /// `None`
        pub const ALT_DIGITS: Option<&[&str]> = None;
        /// `None`
        pub const ALT_MON: Option<&[&str]> = None;
        /// `&["AM", "PM"]`
        pub const AM_PM: &[&str] = &["AM", "PM"];
        /// `None`
        pub const CAL_DIRECTION: Option<i64> = None;
        /// `None`
        pub const DATE_FMT: Option<&str> = None;
        /// `&["Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"]`
        pub const DAY: &[&str] = &["Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"];
        /// `"%Y-%m-%d"`
        pub const D_FMT: &str = "%Y-%m-%d";
        /// `"%a %d %b %Y %I:%M:%S %p %Z"`
        pub const D_T_FMT: &str = "%a %d %b %Y %I:%M:%S %p %Z";
        /// `None`
        pub const ERA: Option<&[&str]> = None;
        /// `None`
        pub const ERA_D_FMT: Option<&str> = None;
        /// `None`
        pub const ERA_D_T_FMT: Option<&str> = None;
        /// `None`
        pub const ERA_T_FMT: Option<&str> = None;
        /// `None`
        pub const FIRST_WEEKDAY: Option<i64> = None;
        /// `None`
        pub const FIRST_WORKDAY: Option<i64> = None;
        /// `&["January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"]`
        pub const MON: &[&str] = &["January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"];
        /// `"%I:%M:%S %p"`
        pub const T_FMT: &str = "%I:%M:%S %p";
        /// `"%I:%M:%S %p"`
        pub const T_FMT_AMPM: &str = "%I:%M:%S %p";
        /// `Some(&[7, 19971130, 1])`
        pub const WEEK: Option<&[i64]> = Some(&[7, 19971130, 1]);
    }
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod en_DK {
    pub mod LC_ADDRESS {
        /// `Some("DNK")`
        pub const COUNTRY_AB3: Option<&str> = Some("DNK");
        /// `Some("DK")`
        pub const COUNTRY_ABTWO: Option<&str> = Some("DK");
        /// `Some("DK")`
        pub const COUNTRY_CAR: Option<&str> = Some("DK");
        /// `None`
        pub const COUNTRY_ISBN: Option<&str> = None;
        /// `Some("Denmark")`
        pub const COUNTRY_NAME: Option<&str> = Some("Denmark");
        /// `Some(208)`
        pub const COUNTRY_NUM: Option<i64> = Some(208);
        /// `None`
        pub const COUNTRY_POST: Option<&str> = None;
        /// `Some("en")`
        pub const LANG_AB: Option<&str> = Some("en");
        /// `Some("eng")`
        pub const LANG_LIB: Option<&str> = Some("eng");
        /// `Some("English")`
        pub const LANG_NAME: Option<&str> = Some("English");
        /// `Some("eng")`
        pub const LANG_TERM: Option<&str> = Some("eng");
        /// `Some("%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%c%N")`
        pub const POSTAL_FMT: Option<&str> = Some("%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%c%N");
    }
    pub mod LC_IDENTIFICATION {
        /// `None`
        pub const ABBREVIATION: Option<&str> = None;
        /// `Some("Kollegievej 6, DK-2920 Charlottenlund, Danmark")`
        pub const ADDRESS: Option<&str> = Some("Kollegievej 6, DK-2920 Charlottenlund, Danmark");
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        /// ]
        /// ```
        pub const CATEGORY: Option<&[&[&str]]> = Some(&[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_TELEPHONE"],
            &["i18n:2012", "LC_MEASUREMENT"],
        ]);
        /// `Some("")`
        pub const CONTACT: Option<&str> = Some("");
        /// `Some("2000-06-29")`
        pub const DATE: Option<&str> = Some("2000-06-29");
        /// `Some("bug-glibc-locales@gnu.org")`
        pub const EMAIL: Option<&str> = Some("bug-glibc-locales@gnu.org");
        /// `Some("")`
        pub const FAX: Option<&str> = Some("");
        /// `Some("English")`
        pub const LANGUAGE: Option<&str> = Some("English");
        /// `Some("1.0")`
        pub const REVISION: Option<&str> = Some("1.0");
        /// `Some("Danish Standards Association")`
        pub const SOURCE: Option<&str> = Some("Danish Standards Association");
        /// `Some("")`
        pub const TEL: Option<&str> = Some("");
        /// `Some("Denmark")`
        pub const TERRITORY: Option<&str> = Some("Denmark");
        /// `Some("English locale for Denmark")`
        pub const TITLE: Option<&str> = Some("English locale for Denmark");
    }
    pub mod LC_MESSAGES {
        /// `"^[-0nN]"`
        pub const NOEXPR: &str = "^[-0nN]";
        /// `Some("no")`
        pub const NOSTR: Option<&str> = Some("no");
        /// `"^[+1yYjJsSoO]"`
        pub const YESEXPR: &str = "^[+1yYjJsSoO]";
        /// `Some("yes")`
        pub const YESSTR: Option<&str> = Some("yes");
    }
    pub mod LC_MONETARY {
        /// `"kr."`
        pub const CURRENCY_SYMBOL: &str = "kr.";
        /// `2`
        pub const FRAC_DIGITS: i64 = 2;
        /// `"DKK "`
        pub const INT_CURR_SYMBOL: &str = "DKK ";
        /// `2`
        pub const INT_FRAC_DIGITS: i64 = 2;
        /// `None`
        pub const INT_N_CS_PRECEDES: Option<i64> = None;
        /// `None`
        pub const INT_N_SEP_BY_SPACE: Option<i64> = None;
        /// `None`
        pub const INT_N_SIGN_POSN: Option<i64> = None;
        /// `None`
        pub const INT_P_CS_PRECEDES: Option<i64> = None;
        /// `None`
        pub const INT_P_SEP_BY_SPACE: Option<i64> = None;
        /// `None`
        pub const INT_P_SIGN_POSN: Option<i64> = None;
        /// `","`
        pub const MON_DECIMAL_POINT: &str = ",";
        /// `&[3, 3]`
        pub const MON_GROUPING: &[i64] = &[3, 3];
        /// `"."`
        pub const MON_THOUSANDS_SEP: &str = ".";
        /// `"-"`
        pub const NEGATIVE_SIGN: &str = "-";
        /// `1`
        pub const N_CS_PRECEDES: i64 = 1;
        /// `0`
        pub const N_SEP_BY_SPACE: i64 = 0;
        /// `1`
        pub const N_SIGN_POSN: i64 = 1;
        /// `""`
        pub const POSITIVE_SIGN: &str = "";
        /// `1`
        pub const P_CS_PRECEDES: i64 = 1;
        /// `0`
        pub const P_SEP_BY_SPACE: i64 = 0;
        /// `1`
        pub const P_SIGN_POSN: i64 = 1;
    }
    pub mod LC_NUMERIC {
        /// `","`
        pub const DECIMAL_POINT: &str = ",";
        /// `&[3, 3]`
        pub const GROUPING: &[i64] = &[3, 3];
        /// `"."`
        pub const THOUSANDS_SEP: &str = ".";
    }
    pub use super::da_DK::LC_TELEPHONE;
    pub mod LC_TIME {
        /// `&["Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"]`
        pub const ABDAY: &[&str] = &["Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"];
        /// `&["Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"]`
        pub const ABMON: &[&str] = &["Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"];
        /// `None`
        pub const AB_ALT_MON: Option<&[&str]> = None;
        /// `None`
        pub const ALT_DIGITS: Option<&[&str]> = None;
        /// `None`
        pub const ALT_MON: Option<&[&str]> = None;
        /// `&["", ""]`
        pub const AM_PM: &[&str] = &["", ""];
        /// `None`
        pub const CAL_DIRECTION: Option<i64> = None;
        /// `None`
        pub const DATE_FMT: Option<&str> = None;
        /// `&["Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"]`
        pub const DAY: &[&str] = &["Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"];
        /// `"%Y-%m-%d"`
        pub const D_FMT: &str = "%Y-%m-%d";
        /// `"%Y-%m-%dT%T %Z"`
        pub const D_T_FMT: &str = "%Y-%m-%dT%T %Z";
        /// `None`
        pub const ERA: Option<&[&str]> = None;
        /// `None`
        pub const ERA_D_FMT: Option<&str> = None;
        /// `None`
        pub const ERA_D_T_FMT: Option<&str> = None;
        /// `None`
        pub const ERA_T_FMT: Option<&str> = None;
        /// `Some(2)`
        pub const FIRST_WEEKDAY: Option<i64> = Some(2);
        /// `None`
        pub const FIRST_WORKDAY: Option<i64> = None;
        /// `&["January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"]`
        pub const MON: &[&str] = &["January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"];
        /// `"%T"`
        pub const T_FMT: &str = "%T";
        /// `""`
        pub const T_FMT_AMPM: &str = "";
        /// `Some(&[7, 19971130, 4])`
        pub const WEEK: Option<&[i64]> = Some(&[7, 19971130, 4]);
    }
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod en_GB {
    pub mod LC_ADDRESS {
        /// `Some("GBR")`
        pub const COUNTRY_AB3: Option<&str> = Some("GBR");
        /// `Some("GB")`
        pub const COUNTRY_ABTWO: Option<&str> = Some("GB");
        /// `Some("GB")`
        pub const COUNTRY_CAR: Option<&str> = Some("GB");
        /// `None`
        pub const COUNTRY_ISBN: Option<&str> = None;
        /// `Some("United Kingdom")`
        pub const COUNTRY_NAME: Option<&str> = Some("United Kingdom");
        /// `Some(826)`
        pub const COUNTRY_NUM: Option<i64> = Some(826);
        /// `None`
        pub const COUNTRY_POST: Option<&str> = None;
        /// `Some("en")`
        pub const LANG_AB: Option<&str> = Some("en");
        /// `Some("eng")`
        pub const LANG_LIB: Option<&str> = Some("eng");
        /// `Some("English")`
        pub const LANG_NAME: Option<&str> = Some("English");
        /// `Some("eng")`
        pub const LANG_TERM: Option<&str> = Some("eng");
        /// `Some("%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%c%N")`
        pub const POSTAL_FMT: Option<&str> = Some("%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%c%N");
    }
    pub mod LC_IDENTIFICATION {
        /// `None`
        pub const ABBREVIATION: Option<&str> = None;
        /// `Some("Sankt Jørgens Alle 8, DK-1615 København V, Danmark")`
        pub const ADDRESS: Option<&str> = Some("Sankt Jørgens Alle 8, DK-1615 København V, Danmark");
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        /// ]
        /// ```
        pub const CATEGORY: Option<&[&[&str]]> = Some(&[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_TELEPHONE"],
            &["i18n:2012", "LC_MEASUREMENT"],
        ]);
        /// `Some("Keld Simonsen")`
        pub const CONTACT: Option<&str> = Some("Keld Simonsen");
        /// `Some("2000-06-28")`
        pub const DATE: Option<&str> = Some("2000-06-28");
        /// `Some("bug-glibc-locales@gnu.org")`
        pub const EMAIL: Option<&str> = Some("bug-glibc-locales@gnu.org");
        /// `Some("")`
        pub const FAX: Option<&str> = Some("");
        /// `Some("British English")`
        pub const LANGUAGE: Option<&str> = Some("British English");
        /// `Some("1.0")`
        pub const REVISION: Option<&str> = Some("1.0");
        /// `Some("RAP")`
        pub const SOURCE: Option<&str> = Some("RAP");
        /// `Some("")`
        pub const TEL: Option<&str> = Some("");
        /// `Some("United Kingdom")`
        pub const TERRITORY: Option<&str> = Some("United Kingdom");
        /// `Some("English locale for Britain")`
        pub const TITLE: Option<&str> = Some("English locale for Britain");
    }
    pub use super::en_US::LC_MESSAGES;
    pub mod LC_MONETARY {
        /// `"£"`
        pub const CURRENCY_SYMBOL: &str = "£";
        /// `2`
        pub const FRAC_DIGITS: i64 = 2;
        /// `"GBP "`
        pub const INT_CURR_SYMBOL: &str = "GBP ";
        /// `2`
        pub const INT_FRAC_DIGITS: i64 = 2;
        /// `None`
        pub const INT_N_CS_PRECEDES: Option<i64> = None;
        /// `None`
        pub const INT_N_SEP_BY_SPACE: Option<i64> = None;
        /// `None`
        pub const INT_N_SIGN_POSN: Option<i64> = None;
        /// `None`
        pub const INT_P_CS_PRECEDES: Option<i64> = None;
        /// `None`
        pub const INT_P_SEP_BY_SPACE: Option<i64> = None;
        /// `None`
        pub const INT_P_SIGN_POSN: Option<i64> = None;
        /// `"."`
        pub const MON_DECIMAL_POINT: &str = ".";
        /// `&[3, 3]`
        pub const MON_GROUPING: &[i64] = &[3, 3];
        /// `","`
        pub const MON_THOUSANDS_SEP: &str = ",";
        /// `"-"`
        pub const NEGATIVE_SIGN: &str = "-";
        /// `1`
        pub const N_CS_PRECEDES: i64 = 1;
        /// `0`
        pub const N_SEP_BY_SPACE: i64 = 0;
        /// `1`
        pub const N_SIGN_POSN: i64 = 1;
        /// `""`
        pub const POSITIVE_SIGN: &str = "";
        /// `1`
        pub const P_CS_PRECEDES: i64 = 1;
        /// `0`
        pub const P_SEP_BY_SPACE: i64 = 0;
        /// `1`
        pub const P_SIGN_POSN: i64 = 1;
    }
    pub mod LC_NUMERIC {
        /// `"."`
        pub const DECIMAL_POINT: &str = ".";
        /// `&[3, 3]`
        pub const GROUPING: &[i64] = &[3, 3];
        /// `","`
        pub const THOUSANDS_SEP: &str = ",";
    }
    pub mod LC_TELEPHONE {
        /// `Some("44")`
        pub const INT_PREFIX: Option<&str> = Some("44");
        /// `Some("00")`
        pub const INT_SELECT: Option<&str> = Some("00");
        /// `Some("%A %l")`
        pub const TEL_DOM_FMT: Option<&str> = Some("%A %l");
        /// `Some("+%c %a %l")`
        pub const TEL_INT_FMT: Option<&str> = Some("+%c %a %l");
    }
    pub mod LC_TIME {
        /// `&["Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"]`
        pub const ABDAY: &[&str] = &["Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"];
        /// `&["Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"]`
        pub const ABMON: &[&str] = &["Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"];
        /// `None`
        pub const AB_ALT_MON: Option<&[&str]> = None;
        /// `None`
        pub const ALT_DIGITS: Option<&[&str]> = None;
        /// `None`
        pub const ALT_MON: Option<&[&str]> = None;
        /// `&["am", "pm"]`
        pub const AM_PM: &[&str] = &["am", "pm"];
        /// `None`
        pub const CAL_DIRECTION: Option<i64> = None;
        /// `Some("%a %e %b %H:%M:%S %Z %Y")`
        pub const DATE_FMT: Option<&str> = Some("%a %e %b %H:%M:%S %Z %Y");
        /// `&["Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"]`
        pub const DAY: &[&str] = &["Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"];
        /// `"%d/%m/%y"`
        pub const D_FMT: &str = "%d/%m/%y";
        /// `"%a %d %b %Y %T %Z"`
        pub const D_T_FMT: &str = "%a %d %b %Y %T %Z";
        /// `None`
        pub const ERA: Option<&[&str]> = None;
        /// `None`
        pub const ERA_D_FMT: Option<&str> = None;
        /// `None`
        pub const ERA_D_T_FMT: Option<&str> = None;
        /// `None`
        pub const ERA_T_FMT: Option<&str> = None;
        /// `Some(2)`
        pub const FIRST_WEEKDAY: Option<i64> = Some(2);
        /// `None`
        pub const FIRST_WORKDAY: Option<i64> = None;
        /// `&["January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"]`
        pub const MON: &[&str] = &["January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"];
        /// `"%T"`
        pub const T_FMT: &str = "%T";
        /// `"%l:%M:%S %P %Z"`
        pub const T_FMT_AMPM: &str = "%l:%M:%S %P %Z";
        /// `Some(&[7, 19971130, 4])`
        pub const WEEK: Option<&[i64]> = Some(&[7, 19971130, 4]);
    }
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod en_HK {
    pub mod LC_ADDRESS {
        /// `Some("HKG")`
        pub const COUNTRY_AB3: Option<&str> = Some("HKG");
        /// `Some("HK")`
        pub const COUNTRY_ABTWO: Option<&str> = Some("HK");
        /// `Some("HK")`
        pub const COUNTRY_CAR: Option<&str> = Some("HK");
        /// `None`
        pub const COUNTRY_ISBN: Option<&str> = None;
        /// `Some("Hong Kong SAR China")`
        pub const COUNTRY_NAME: Option<&str> = Some("Hong Kong SAR China");
        /// `Some(344)`
        pub const COUNTRY_NUM: Option<i64> = Some(344);
        /// `None`
        pub const COUNTRY_POST: Option<&str> = None;
        /// `Some("en")`
        pub const LANG_AB: Option<&str> = Some("en");
        /// `Some("eng")`
        pub const LANG_LIB: Option<&str> = Some("eng");
        /// `Some("English")`
        pub const LANG_NAME: Option<&str> = Some("English");
        /// `Some("eng")`
        pub const LANG_TERM: Option<&str> = Some("eng");
        /// `Some("%z%c%T%s%b%e%r")`
        pub const POSTAL_FMT: Option<&str> = Some("%z%c%T%s%b%e%r");
    }
    pub mod LC_IDENTIFICATION {
        /// `None`
        pub const ABBREVIATION: Option<&str> = None;
        /// `Some("1623-14, Shimotsuruma, Yamato-shi, Kanagawa-ken, 242-8502, Japan")`
        pub const ADDRESS: Option<&str> = Some("1623-14, Shimotsuruma, Yamato-shi, Kanagawa-ken, 242-8502, Japan");
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        /// ]
        /// ```
        pub const CATEGORY: Option<&[&[&str]]> = Some(&[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_TELEPHONE"],
            &["i18n:2012", "LC_MEASUREMENT"],
        ]);
        /// `Some("")`
        pub const CONTACT: Option<&str> = Some("");
        /// `Some("2000,October,27 (XML source:2000,July,20)")`
        pub const DATE: Option<&str> = Some("2000,October,27 (XML source:2000,July,20)");
        /// `Some("bug-glibc-locales@gnu.org")`
        pub const EMAIL: Option<&str> = Some("bug-glibc-locales@gnu.org");
        /// `Some("")`
        pub const FAX: Option<&str> = Some("");
        /// `Some("English")`
        pub const LANGUAGE: Option<&str> = Some("English");
        /// `Some("1.0")`
        pub const REVISION: Option<&str> = Some("1.0");
        /// `Some("IBM Globalization Center of Competency, Yamato Software Laboratory")`
        pub const SOURCE: Option<&str> = Some("IBM Globalization Center of Competency, Yamato Software Laboratory");
        /// `Some("")`
        pub const TEL: Option<&str> = Some("");
        /// `Some("Hong Kong SAR China")`
        pub const TERRITORY: Option<&str> = Some("Hong Kong SAR China");
        /// `Some("English locale for Hong Kong")`
        pub const TITLE: Option<&str> = Some("English locale for Hong Kong");
    }
    pub use super::en_US::LC_MESSAGES;
    pub mod LC_MONETARY {
        /// `"HK$"`
        pub const CURRENCY_SYMBOL: &str = "HK$";
        /// `2`
        pub const FRAC_DIGITS: i64 = 2;
        /// `"HKD "`
        pub const INT_CURR_SYMBOL: &str = "HKD ";
        /// `2`
        pub const INT_FRAC_DIGITS: i64 = 2;
        /// `None`
        pub const INT_N_CS_PRECEDES: Option<i64> = None;
        /// `None`
        pub const INT_N_SEP_BY_SPACE: Option<i64> = None;
        /// `None`
        pub const INT_N_SIGN_POSN: Option<i64> = None;
        /// `None`
        pub const INT_P_CS_PRECEDES: Option<i64> = None;
        /// `None`
        pub const INT_P_SEP_BY_SPACE: Option<i64> = None;
        /// `None`
        pub const INT_P_SIGN_POSN: Option<i64> = None;
        /// `"."`
        pub const MON_DECIMAL_POINT: &str = ".";
        /// `&[3]`
        pub const MON_GROUPING: &[i64] = &[3];
        /// `","`
        pub const MON_THOUSANDS_SEP: &str = ",";
        /// `"-"`
        pub const NEGATIVE_SIGN: &str = "-";
        /// `1`
        pub const N_CS_PRECEDES: i64 = 1;
        /// `0`
        pub const N_SEP_BY_SPACE: i64 = 0;
        /// `0`
        pub const N_SIGN_POSN: i64 = 0;
        /// `""`
        pub const POSITIVE_SIGN: &str = "";
        /// `1`
        pub const P_CS_PRECEDES: i64 = 1;
        /// `0`
        pub const P_SEP_BY_SPACE: i64 = 0;
        /// `1`
        pub const P_SIGN_POSN: i64 = 1;
    }
    pub mod LC_NUMERIC {
        /// `"."`
        pub const DECIMAL_POINT: &str = ".";
        /// `&[3]`
        pub const GROUPING: &[i64] = &[3];
        /// `","`
        pub const THOUSANDS_SEP: &str = ",";
    }
    pub mod LC_TELEPHONE {
        /// `Some("852")`
        pub const INT_PREFIX: Option<&str> = Some("852");
        /// `Some("001")`
        pub const INT_SELECT: Option<&str> = Some("001");
        /// `None`
        pub const TEL_DOM_FMT: Option<&str> = None;
        /// `Some("+%c ;%a ;%l")`
        pub const TEL_INT_FMT: Option<&str> = Some("+%c ;%a ;%l");
    }
    pub mod LC_TIME {
        /// `&["Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"]`
        pub const ABDAY: &[&str] = &["Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"];
        /// `&["Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"]`
        pub const ABMON: &[&str] = &["Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"];
        /// `None`
        pub const AB_ALT_MON: Option<&[&str]> = None;
        /// `None`
        pub const ALT_DIGITS: Option<&[&str]> = None;
        /// `None`
        pub const ALT_MON: Option<&[&str]> = None;
        /// `&["AM", "PM"]`
        pub const AM_PM: &[&str] = &["AM", "PM"];
        /// `None`
        pub const CAL_DIRECTION: Option<i64> = None;
        /// `None`
        pub const DATE_FMT: Option<&str> = None;
        /// `&["Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"]`
        pub const DAY: &[&str] = &["Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"];
        /// `"%A, %B %d, %Y"`
        pub const D_FMT: &str = "%A, %B %d, %Y";
        /// `"%A, %B %d, %Y %p%I:%M:%S %Z"`
        pub const D_T_FMT: &str = "%A, %B %d, %Y %p%I:%M:%S %Z";
        /// `None`
        pub const ERA: Option<&[&str]> = None;
        /// `None`
        pub const ERA_D_FMT: Option<&str> = None;
        /// `None`
        pub const ERA_D_T_FMT: Option<&str> = None;
        /// `None`
        pub const ERA_T_FMT: Option<&str> = None;
        /// `None`
        pub const FIRST_WEEKDAY: Option<i64> = None;
        /// `None`
        pub const FIRST_WORKDAY: Option<i64> = None;
        /// `&["January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"]`
        pub const MON: &[&str] = &["January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"];
        /// `"%I:%M:%S %p %Z"`
        pub const T_FMT: &str = "%I:%M:%S %p %Z";
        /// `"%I:%M:%S %p %Z"`
        pub const T_FMT_AMPM: &str = "%I:%M:%S %p %Z";
        /// `Some(&[7, 19971130, 1])`
        pub const WEEK: Option<&[i64]> = Some(&[7, 19971130, 1]);
    }
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod en_IE {
    pub mod LC_ADDRESS {
        /// `Some("IRL")`
        pub const COUNTRY_AB3: Option<&str> = Some("IRL");
        /// `Some("IE")`
        pub const COUNTRY_ABTWO: Option<&str> = Some("IE");
        /// `Some("IRL")`
        pub const COUNTRY_CAR: Option<&str> = Some("IRL");
        /// `None`
        pub const COUNTRY_ISBN: Option<&str> = None;
        /// `Some("Ireland")`
        pub const COUNTRY_NAME: Option<&str> = Some("Ireland");
        /// `Some(372)`
        pub const COUNTRY_NUM: Option<i64> = Some(372);
        /// `None`
        pub const COUNTRY_POST: Option<&str> = None;
        /// `Some("en")`
        pub const LANG_AB: Option<&str> = Some("en");
        /// `Some("eng")`
        pub const LANG_LIB: Option<&str> = Some("eng");
        /// `Some("English")`
        pub const LANG_NAME: Option<&str> = Some("English");
        /// `Some("eng")`
        pub const LANG_TERM: Option<&str> = Some("eng");
        /// `Some("%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%c%N")`
        pub const POSTAL_FMT: Option<&str> = Some("%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%c%N");
    }
    pub mod LC_IDENTIFICATION {
        /// `None`
        pub const ABBREVIATION: Option<&str> = None;
        /// `Some("Sankt Jørgens Alle 8, DK-1615 København V, Danmark")`
        pub const ADDRESS: Option<&str> = Some("Sankt Jørgens Alle 8, DK-1615 København V, Danmark");
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        /// ]
        /// ```
        pub const CATEGORY: Option<&[&[&str]]> = Some(&[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_TELEPHONE"],
            &["i18n:2012", "LC_MEASUREMENT"],
        ]);
        /// `Some("")`
        pub const CONTACT: Option<&str> = Some("");
        /// `Some("2000-06-29")`
        pub const DATE: Option<&str> = Some("2000-06-29");
        /// `Some("bug-glibc-locales@gnu.org")`
        pub const EMAIL: Option<&str> = Some("bug-glibc-locales@gnu.org");
        /// `Some("")`
        pub const FAX: Option<&str> = Some("");
        /// `Some("English")`
        pub const LANGUAGE: Option<&str> = Some("English");
        /// `Some("1.0")`
        pub const REVISION: Option<&str> = Some("1.0");
        /// `Some("RAP")`
        pub const SOURCE: Option<&str> = Some("RAP");
        /// `Some("")`
        pub const TEL: Option<&str> = Some("");
        /// `Some("Ireland")`
        pub const TERRITORY: Option<&str> = Some("Ireland");
        /// `Some("English locale for Ireland")`
        pub const TITLE: Option<&str> = Some("English locale for Ireland");
    }
    pub use super::en_GB::LC_MESSAGES;
    pub mod LC_MONETARY {
        /// `"€"`
        pub const CURRENCY_SYMBOL: &str = "€";
        /// `2`
        pub const FRAC_DIGITS: i64 = 2;
        /// `"EUR "`
        pub const INT_CURR_SYMBOL: &str = "EUR ";
        /// `2`
        pub const INT_FRAC_DIGITS: i64 = 2;
        /// `None`
        pub const INT_N_CS_PRECEDES: Option<i64> = None;
        /// `None`
        pub const INT_N_SEP_BY_SPACE: Option<i64> = None;
        /// `None`
        pub const INT_N_SIGN_POSN: Option<i64> = None;
        /// `None`
        pub const INT_P_CS_PRECEDES: Option<i64> = None;
        /// `None`
        pub const INT_P_SEP_BY_SPACE: Option<i64> = None;
        /// `None`
        pub const INT_P_SIGN_POSN: Option<i64> = None;
        /// `"."`
        pub const MON_DECIMAL_POINT: &str = ".";
        /// `&[3, 3]`
        pub const MON_GROUPING: &[i64] = &[3, 3];
        /// `","`
        pub const MON_THOUSANDS_SEP: &str = ",";
        /// `"-"`
        pub const NEGATIVE_SIGN: &str = "-";
        /// `1`
        pub const N_CS_PRECEDES: i64 = 1;
        /// `0`
        pub const N_SEP_BY_SPACE: i64 = 0;
        /// `1`
        pub const N_SIGN_POSN: i64 = 1;
        /// `""`
        pub const POSITIVE_SIGN: &str = "";
        /// `1`
        pub const P_CS_PRECEDES: i64 = 1;
        /// `0`
        pub const P_SEP_BY_SPACE: i64 = 0;
        /// `1`
        pub const P_SIGN_POSN: i64 = 1;
    }
    pub use super::en_GB::LC_NUMERIC;
    pub mod LC_TELEPHONE {
        /// `Some("353")`
        pub const INT_PREFIX: Option<&str> = Some("353");
        /// `Some("00")`
        pub const INT_SELECT: Option<&str> = Some("00");
        /// `None`
        pub const TEL_DOM_FMT: Option<&str> = None;
        /// `Some("+%c %a %l")`
        pub const TEL_INT_FMT: Option<&str> = Some("+%c %a %l");
    }
    pub mod LC_TIME {
        /// `&["Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"]`
        pub const ABDAY: &[&str] = &["Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"];
        /// `&["Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"]`
        pub const ABMON: &[&str] = &["Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"];
        /// `None`
        pub const AB_ALT_MON: Option<&[&str]> = None;
        /// `None`
        pub const ALT_DIGITS: Option<&[&str]> = None;
        /// `None`
        pub const ALT_MON: Option<&[&str]> = None;
        /// `&["", ""]`
        pub const AM_PM: &[&str] = &["", ""];
        /// `None`
        pub const CAL_DIRECTION: Option<i64> = None;
        /// `None`
        pub const DATE_FMT: Option<&str> = None;
        /// `&["Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"]`
        pub const DAY: &[&str] = &["Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"];
        /// `"%d/%m/%y"`
        pub const D_FMT: &str = "%d/%m/%y";
        /// `"%a %d %b %Y %T %Z"`
        pub const D_T_FMT: &str = "%a %d %b %Y %T %Z";
        /// `None`
        pub const ERA: Option<&[&str]> = None;
        /// `None`
        pub const ERA_D_FMT: Option<&str> = None;
        /// `None`
        pub const ERA_D_T_FMT: Option<&str> = None;
        /// `None`
        pub const ERA_T_FMT: Option<&str> = None;
        /// `Some(2)`
        pub const FIRST_WEEKDAY: Option<i64> = Some(2);
        /// `None`
        pub const FIRST_WORKDAY: Option<i64> = None;
        /// `&["January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"]`
        pub const MON: &[&str] = &["January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"];
        /// `"%T"`
        pub const T_FMT: &str = "%T";
        /// `""`
        pub const T_FMT_AMPM: &str = "";
        /// `Some(&[7, 19971130, 4])`
        pub const WEEK: Option<&[i64]> = Some(&[7, 19971130, 4]);
    }
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod en_IE_euro {
    pub use super::en_IE::LC_ADDRESS;
    pub mod LC_IDENTIFICATION {
        /// `None`
        pub const ABBREVIATION: Option<&str> = None;
        /// `Some("https://www.gnu.org/software/libc/")`
        pub const ADDRESS: Option<&str> = Some("https://www.gnu.org/software/libc/");
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        /// ]
        /// ```
        pub const CATEGORY: Option<&[&[&str]]> = Some(&[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_TELEPHONE"],
            &["i18n:2012", "LC_MEASUREMENT"],
        ]);
        /// `Some("")`
        pub const CONTACT: Option<&str> = Some("");
        /// `Some("2000-08-20")`
        pub const DATE: Option<&str> = Some("2000-08-20");
        /// `Some("bug-glibc-locales@gnu.org")`
        pub const EMAIL: Option<&str> = Some("bug-glibc-locales@gnu.org");
        /// `Some("")`
        pub const FAX: Option<&str> = Some("");
        /// `Some("English")`
        pub const LANGUAGE: Option<&str> = Some("English");
        /// `Some("1.0")`
        pub const REVISION: Option<&str> = Some("1.0");
        /// `Some("Free Software Foundation, Inc.")`
        pub const SOURCE: Option<&str> = Some("Free Software Foundation, Inc.");
        /// `Some("")`
        pub const TEL: Option<&str> = Some("");
        /// `Some("Ireland")`
        pub const TERRITORY: Option<&str> = Some("Ireland");
        /// `Some("English locale for Ireland with Euro")`
        pub const TITLE: Option<&str> = Some("English locale for Ireland with Euro");
    }
    pub use super::en_IE::LC_MESSAGES;
    pub use super::en_IE::LC_MONETARY;
    pub use super::en_GB::LC_NUMERIC;
    pub use super::en_IE::LC_TELEPHONE;
    pub use super::en_IE::LC_TIME;
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod en_IL {
    pub mod LC_ADDRESS {
        /// `Some("ISR")`
        pub const COUNTRY_AB3: Option<&str> = Some("ISR");
        /// `Some("IL")`
        pub const COUNTRY_ABTWO: Option<&str> = Some("IL");
        /// `Some("IL")`
        pub const COUNTRY_CAR: Option<&str> = Some("IL");
        /// `None`
        pub const COUNTRY_ISBN: Option<&str> = None;
        /// `Some("Israel")`
        pub const COUNTRY_NAME: Option<&str> = Some("Israel");
        /// `Some(376)`
        pub const COUNTRY_NUM: Option<i64> = Some(376);
        /// `Some("ISR")`
        pub const COUNTRY_POST: Option<&str> = Some("ISR");
        /// `Some("en")`
        pub const LANG_AB: Option<&str> = Some("en");
        /// `Some("eng")`
        pub const LANG_LIB: Option<&str> = Some("eng");
        /// `Some("English")`
        pub const LANG_NAME: Option<&str> = Some("English");
        /// `Some("eng")`
        pub const LANG_TERM: Option<&str> = Some("eng");
        /// `Some("%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%c%N")`
        pub const POSTAL_FMT: Option<&str> = Some("%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%c%N");
    }
    pub mod LC_IDENTIFICATION {
        /// `None`
        pub const ABBREVIATION: Option<&str> = None;
        /// `Some("https://www.gnu.org/software/libc/")`
        pub const ADDRESS: Option<&str> = Some("https://www.gnu.org/software/libc/");
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        /// ]
        /// ```
        pub const CATEGORY: Option<&[&[&str]]> = Some(&[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_TELEPHONE"],
            &["i18n:2012", "LC_MEASUREMENT"],
        ]);
        /// `Some("")`
        pub const CONTACT: Option<&str> = Some("");
        /// `Some("2016-04-19")`
        pub const DATE: Option<&str> = Some("2016-04-19");
        /// `Some("bug-glibc-locales@gnu.org")`
        pub const EMAIL: Option<&str> = Some("bug-glibc-locales@gnu.org");
        /// `Some("")`
        pub const FAX: Option<&str> = Some("");
        /// `Some("English")`
        pub const LANGUAGE: Option<&str> = Some("English");
        /// `Some("1.1")`
        pub const REVISION: Option<&str> = Some("1.1");
        /// `Some("Free Software Foundation, Inc.")`
        pub const SOURCE: Option<&str> = Some("Free Software Foundation, Inc.");
        /// `Some("")`
        pub const TEL: Option<&str> = Some("");
        /// `Some("Israel")`
        pub const TERRITORY: Option<&str> = Some("Israel");
        /// `Some("English locale for Israel")`
        pub const TITLE: Option<&str> = Some("English locale for Israel");
    }
    pub use super::en_US::LC_MESSAGES;
    pub use super::he_IL::LC_MONETARY;
    pub use super::he_IL::LC_NUMERIC;
    pub use super::he_IL::LC_TELEPHONE;
    pub mod LC_TIME {
        /// `&["Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"]`
        pub const ABDAY: &[&str] = &["Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"];
        /// `&["Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"]`
        pub const ABMON: &[&str] = &["Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"];
        /// `None`
        pub const AB_ALT_MON: Option<&[&str]> = None;
        /// `None`
        pub const ALT_DIGITS: Option<&[&str]> = None;
        /// `None`
        pub const ALT_MON: Option<&[&str]> = None;
        /// `&["", ""]`
        pub const AM_PM: &[&str] = &["", ""];
        /// `None`
        pub const CAL_DIRECTION: Option<i64> = None;
        /// `None`
        pub const DATE_FMT: Option<&str> = None;
        /// `&["Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"]`
        pub const DAY: &[&str] = &["Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"];
        /// `"%d/%m/%y"`
        pub const D_FMT: &str = "%d/%m/%y";
        /// `"%a %d %b %Y %T %Z"`
        pub const D_T_FMT: &str = "%a %d %b %Y %T %Z";
        /// `None`
        pub const ERA: Option<&[&str]> = None;
        /// `None`
        pub const ERA_D_FMT: Option<&str> = None;
        /// `None`
        pub const ERA_D_T_FMT: Option<&str> = None;
        /// `None`
        pub const ERA_T_FMT: Option<&str> = None;
        /// `None`
        pub const FIRST_WEEKDAY: Option<i64> = None;
        /// `Some(1)`
        pub const FIRST_WORKDAY: Option<i64> = Some(1);
        /// `&["January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"]`
        pub const MON: &[&str] = &["January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"];
        /// `"%T"`
        pub const T_FMT: &str = "%T";
        /// `""`
        pub const T_FMT_AMPM: &str = "";
        /// `Some(&[7, 19971130, 1])`
        pub const WEEK: Option<&[i64]> = Some(&[7, 19971130, 1]);
    }
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod en_IN {
    pub mod LC_ADDRESS {
        /// `Some("IND")`
        pub const COUNTRY_AB3: Option<&str> = Some("IND");
        /// `Some("IN")`
        pub const COUNTRY_ABTWO: Option<&str> = Some("IN");
        /// `Some("IND")`
        pub const COUNTRY_CAR: Option<&str> = Some("IND");
        /// `None`
        pub const COUNTRY_ISBN: Option<&str> = None;
        /// `Some("India")`
        pub const COUNTRY_NAME: Option<&str> = Some("India");
        /// `Some(356)`
        pub const COUNTRY_NUM: Option<i64> = Some(356);
        /// `None`
        pub const COUNTRY_POST: Option<&str> = None;
        /// `Some("en")`
        pub const LANG_AB: Option<&str> = Some("en");
        /// `Some("eng")`
        pub const LANG_LIB: Option<&str> = Some("eng");
        /// `Some("English")`
        pub const LANG_NAME: Option<&str> = Some("English");
        /// `Some("eng")`
        pub const LANG_TERM: Option<&str> = Some("eng");
        /// `Some("%z%c%T%s%b%e%r")`
        pub const POSTAL_FMT: Option<&str> = Some("%z%c%T%s%b%e%r");
    }
    pub mod LC_IDENTIFICATION {
        /// `None`
        pub const ABBREVIATION: Option<&str> = None;
        /// `Some("1623-14, Shimotsuruma, Yamato-shi, Kanagawa-ken, 242-8502, Japan")`
        pub const ADDRESS: Option<&str> = Some("1623-14, Shimotsuruma, Yamato-shi, Kanagawa-ken, 242-8502, Japan");
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        /// ]
        /// ```
        pub const CATEGORY: Option<&[&[&str]]> = Some(&[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_TELEPHONE"],
            &["i18n:2012", "LC_MEASUREMENT"],
        ]);
        /// `Some("")`
        pub const CONTACT: Option<&str> = Some("");
        /// `Some("2000,October,27 (XML source:2000,July,20)")`
        pub const DATE: Option<&str> = Some("2000,October,27 (XML source:2000,July,20)");
        /// `Some("bug-glibc-locales@gnu.org")`
        pub const EMAIL: Option<&str> = Some("bug-glibc-locales@gnu.org");
        /// `Some("")`
        pub const FAX: Option<&str> = Some("");
        /// `Some("English")`
        pub const LANGUAGE: Option<&str> = Some("English");
        /// `Some("1.0")`
        pub const REVISION: Option<&str> = Some("1.0");
        /// `Some("IBM Globalization Center of Competency, Yamato Software Laboratory")`
        pub const SOURCE: Option<&str> = Some("IBM Globalization Center of Competency, Yamato Software Laboratory");
        /// `Some("")`
        pub const TEL: Option<&str> = Some("");
        /// `Some("India")`
        pub const TERRITORY: Option<&str> = Some("India");
        /// `Some("English language locale for India")`
        pub const TITLE: Option<&str> = Some("English language locale for India");
    }
    pub use super::en_US::LC_MESSAGES;
    pub use super::hi_IN::LC_MONETARY;
    pub mod LC_NUMERIC {
        /// `"."`
        pub const DECIMAL_POINT: &str = ".";
        /// `&[3, 2]`
        pub const GROUPING: &[i64] = &[3, 2];
        /// `","`
        pub const THOUSANDS_SEP: &str = ",";
    }
    pub use super::hi_IN::LC_TELEPHONE;
    pub mod LC_TIME {
        /// `&["Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"]`
        pub const ABDAY: &[&str] = &["Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"];
        /// `&["Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"]`
        pub const ABMON: &[&str] = &["Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"];
        /// `None`
        pub const AB_ALT_MON: Option<&[&str]> = None;
        /// `None`
        pub const ALT_DIGITS: Option<&[&str]> = None;
        /// `None`
        pub const ALT_MON: Option<&[&str]> = None;
        /// `&["AM", "PM"]`
        pub const AM_PM: &[&str] = &["AM", "PM"];
        /// `None`
        pub const CAL_DIRECTION: Option<i64> = None;
        /// `None`
        pub const DATE_FMT: Option<&str> = None;
        /// `&["Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"]`
        pub const DAY: &[&str] = &["Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"];
        /// `"%d/%m/%y"`
        pub const D_FMT: &str = "%d/%m/%y";
        /// `"%A %d %B %Y %I:%M:%S %p %Z"`
        pub const D_T_FMT: &str = "%A %d %B %Y %I:%M:%S %p %Z";
        /// `None`
        pub const ERA: Option<&[&str]> = None;
        /// `None`
        pub const ERA_D_FMT: Option<&str> = None;
        /// `None`
        pub const ERA_D_T_FMT: Option<&str> = None;
        /// `None`
        pub const ERA_T_FMT: Option<&str> = None;
        /// `None`
        pub const FIRST_WEEKDAY: Option<i64> = None;
        /// `None`
        pub const FIRST_WORKDAY: Option<i64> = None;
        /// `&["January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"]`
        pub const MON: &[&str] = &["January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"];
        /// `"%I:%M:%S %p %Z"`
        pub const T_FMT: &str = "%I:%M:%S %p %Z";
        /// `"%I:%M:%S %p %Z"`
        pub const T_FMT_AMPM: &str = "%I:%M:%S %p %Z";
        /// `Some(&[7, 19971130, 1])`
        pub const WEEK: Option<&[i64]> = Some(&[7, 19971130, 1]);
    }
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod en_NG {
    pub mod LC_ADDRESS {
        /// `Some("NGA")`
        pub const COUNTRY_AB3: Option<&str> = Some("NGA");
        /// `Some("NG")`
        pub const COUNTRY_ABTWO: Option<&str> = Some("NG");
        /// `Some("WAN")`
        pub const COUNTRY_CAR: Option<&str> = Some("WAN");
        /// `Some("978")`
        pub const COUNTRY_ISBN: Option<&str> = Some("978");
        /// `Some("Nigeria")`
        pub const COUNTRY_NAME: Option<&str> = Some("Nigeria");
        /// `Some(566)`
        pub const COUNTRY_NUM: Option<i64> = Some(566);
        /// `None`
        pub const COUNTRY_POST: Option<&str> = None;
        /// `Some("en")`
        pub const LANG_AB: Option<&str> = Some("en");
        /// `Some("eng")`
        pub const LANG_LIB: Option<&str> = Some("eng");
        /// `Some("English")`
        pub const LANG_NAME: Option<&str> = Some("English");
        /// `Some("eng")`
        pub const LANG_TERM: Option<&str> = Some("eng");
        /// `Some("%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%c%N")`
        pub const POSTAL_FMT: Option<&str> = Some("%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%c%N");
    }
    pub mod LC_IDENTIFICATION {
        /// `None`
        pub const ABBREVIATION: Option<&str> = None;
        /// `Some("")`
        pub const ADDRESS: Option<&str> = Some("");
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        /// ]
        /// ```
        pub const CATEGORY: Option<&[&[&str]]> = Some(&[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_MEASUREMENT"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_TELEPHONE"],
        ]);
        /// `Some("")`
        pub const CONTACT: Option<&str> = Some("");
        /// `Some("2006-02-01")`
        pub const DATE: Option<&str> = Some("2006-02-01");
        /// `Some("")`
        pub const EMAIL: Option<&str> = Some("");
        /// `Some("")`
        pub const FAX: Option<&str> = Some("");
        /// `Some("English")`
        pub const LANGUAGE: Option<&str> = Some("English");
        /// `Some("0.2")`
        pub const REVISION: Option<&str> = Some("0.2");
        /// `Some("")`
        pub const SOURCE: Option<&str> = Some("");
        /// `Some("")`
        pub const TEL: Option<&str> = Some("");
        /// `Some("Nigeria")`
        pub const TERRITORY: Option<&str> = Some("Nigeria");
        /// `Some("English locale for Nigeria")`
        pub const TITLE: Option<&str> = Some("English locale for Nigeria");
    }
    pub use super::en_US::LC_MESSAGES;
    pub mod LC_MONETARY {
        /// `"₦"`
        pub const CURRENCY_SYMBOL: &str = "₦";
        /// `2`
        pub const FRAC_DIGITS: i64 = 2;
        /// `"NGN "`
        pub const INT_CURR_SYMBOL: &str = "NGN ";
        /// `2`
        pub const INT_FRAC_DIGITS: i64 = 2;
        /// `None`
        pub const INT_N_CS_PRECEDES: Option<i64> = None;
        /// `None`
        pub const INT_N_SEP_BY_SPACE: Option<i64> = None;
        /// `None`
        pub const INT_N_SIGN_POSN: Option<i64> = None;
        /// `None`
        pub const INT_P_CS_PRECEDES: Option<i64> = None;
        /// `None`
        pub const INT_P_SEP_BY_SPACE: Option<i64> = None;
        /// `None`
        pub const INT_P_SIGN_POSN: Option<i64> = None;
        /// `"."`
        pub const MON_DECIMAL_POINT: &str = ".";
        /// `&[3, 3]`
        pub const MON_GROUPING: &[i64] = &[3, 3];
        /// `","`
        pub const MON_THOUSANDS_SEP: &str = ",";
        /// `"-"`
        pub const NEGATIVE_SIGN: &str = "-";
        /// `1`
        pub const N_CS_PRECEDES: i64 = 1;
        /// `0`
        pub const N_SEP_BY_SPACE: i64 = 0;
        /// `1`
        pub const N_SIGN_POSN: i64 = 1;
        /// `""`
        pub const POSITIVE_SIGN: &str = "";
        /// `1`
        pub const P_CS_PRECEDES: i64 = 1;
        /// `0`
        pub const P_SEP_BY_SPACE: i64 = 0;
        /// `1`
        pub const P_SIGN_POSN: i64 = 1;
    }
    pub mod LC_NUMERIC {
        /// `"."`
        pub const DECIMAL_POINT: &str = ".";
        /// `&[3, 3]`
        pub const GROUPING: &[i64] = &[3, 3];
        /// `","`
        pub const THOUSANDS_SEP: &str = ",";
    }
    pub mod LC_TELEPHONE {
        /// `Some("234")`
        pub const INT_PREFIX: Option<&str> = Some("234");
        /// `Some("009")`
        pub const INT_SELECT: Option<&str> = Some("009");
        /// `Some("(%A) %l")`
        pub const TEL_DOM_FMT: Option<&str> = Some("(%A) %l");
        /// `Some("+%c %a %l")`
        pub const TEL_INT_FMT: Option<&str> = Some("+%c %a %l");
    }
    pub mod LC_TIME {
        /// `&["Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"]`
        pub const ABDAY: &[&str] = &["Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"];
        /// `&["Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"]`
        pub const ABMON: &[&str] = &["Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"];
        /// `None`
        pub const AB_ALT_MON: Option<&[&str]> = None;
        /// `None`
        pub const ALT_DIGITS: Option<&[&str]> = None;
        /// `None`
        pub const ALT_MON: Option<&[&str]> = None;
        /// `&["", ""]`
        pub const AM_PM: &[&str] = &["", ""];
        /// `None`
        pub const CAL_DIRECTION: Option<i64> = None;
        /// `None`
        pub const DATE_FMT: Option<&str> = None;
        /// `&["Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"]`
        pub const DAY: &[&str] = &["Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"];
        /// `"%d/%m/%Y"`
        pub const D_FMT: &str = "%d/%m/%Y";
        /// `"%a %d %b %Y %T %Z"`
        pub const D_T_FMT: &str = "%a %d %b %Y %T %Z";
        /// `None`
        pub const ERA: Option<&[&str]> = None;
        /// `None`
        pub const ERA_D_FMT: Option<&str> = None;
        /// `None`
        pub const ERA_D_T_FMT: Option<&str> = None;
        /// `None`
        pub const ERA_T_FMT: Option<&str> = None;
        /// `Some(2)`
        pub const FIRST_WEEKDAY: Option<i64> = Some(2);
        /// `None`
        pub const FIRST_WORKDAY: Option<i64> = None;
        /// `&["January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"]`
        pub const MON: &[&str] = &["January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"];
        /// `"%T"`
        pub const T_FMT: &str = "%T";
        /// `""`
        pub const T_FMT_AMPM: &str = "";
        /// `Some(&[7, 19971130, 1])`
        pub const WEEK: Option<&[i64]> = Some(&[7, 19971130, 1]);
    }
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod en_NZ {
    pub mod LC_ADDRESS {
        /// `Some("NZL")`
        pub const COUNTRY_AB3: Option<&str> = Some("NZL");
        /// `Some("NZ")`
        pub const COUNTRY_ABTWO: Option<&str> = Some("NZ");
        /// `Some("NZ")`
        pub const COUNTRY_CAR: Option<&str> = Some("NZ");
        /// `None`
        pub const COUNTRY_ISBN: Option<&str> = None;
        /// `Some("New Zealand")`
        pub const COUNTRY_NAME: Option<&str> = Some("New Zealand");
        /// `Some(554)`
        pub const COUNTRY_NUM: Option<i64> = Some(554);
        /// `None`
        pub const COUNTRY_POST: Option<&str> = None;
        /// `Some("en")`
        pub const LANG_AB: Option<&str> = Some("en");
        /// `Some("eng")`
        pub const LANG_LIB: Option<&str> = Some("eng");
        /// `Some("English")`
        pub const LANG_NAME: Option<&str> = Some("English");
        /// `Some("eng")`
        pub const LANG_TERM: Option<&str> = Some("eng");
        /// `Some("%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%c%N")`
        pub const POSTAL_FMT: Option<&str> = Some("%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%c%N");
    }
    pub mod LC_IDENTIFICATION {
        /// `None`
        pub const ABBREVIATION: Option<&str> = None;
        /// `Some("Sankt Jørgens Alle 8, DK-1615 København V, Danmark")`
        pub const ADDRESS: Option<&str> = Some("Sankt Jørgens Alle 8, DK-1615 København V, Danmark");
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        /// ]
        /// ```
        pub const CATEGORY: Option<&[&[&str]]> = Some(&[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_TELEPHONE"],
            &["i18n:2012", "LC_MEASUREMENT"],
        ]);
        /// `Some("")`
        pub const CONTACT: Option<&str> = Some("");
        /// `Some("2000-06-29")`
        pub const DATE: Option<&str> = Some("2000-06-29");
        /// `Some("bug-glibc-locales@gnu.org")`
        pub const EMAIL: Option<&str> = Some("bug-glibc-locales@gnu.org");
        /// `Some("")`
        pub const FAX: Option<&str> = Some("");
        /// `Some("English")`
        pub const LANGUAGE: Option<&str> = Some("English");
        /// `Some("1.0")`
        pub const REVISION: Option<&str> = Some("1.0");
        /// `Some("RAP")`
        pub const SOURCE: Option<&str> = Some("RAP");
        /// `Some("")`
        pub const TEL: Option<&str> = Some("");
        /// `Some("New Zealand")`
        pub const TERRITORY: Option<&str> = Some("New Zealand");
        /// `Some("English locale for New Zealand")`
        pub const TITLE: Option<&str> = Some("English locale for New Zealand");
    }
    pub use super::en_US::LC_MESSAGES;
    pub mod LC_MONETARY {
        /// `"$"`
        pub const CURRENCY_SYMBOL: &str = "$";
        /// `2`
        pub const FRAC_DIGITS: i64 = 2;
        /// `"NZD "`
        pub const INT_CURR_SYMBOL: &str = "NZD ";
        /// `2`
        pub const INT_FRAC_DIGITS: i64 = 2;
        /// `None`
        pub const INT_N_CS_PRECEDES: Option<i64> = None;
        /// `None`
        pub const INT_N_SEP_BY_SPACE: Option<i64> = None;
        /// `None`
        pub const INT_N_SIGN_POSN: Option<i64> = None;
        /// `None`
        pub const INT_P_CS_PRECEDES: Option<i64> = None;
        /// `None`
        pub const INT_P_SEP_BY_SPACE: Option<i64> = None;
        /// `None`
        pub const INT_P_SIGN_POSN: Option<i64> = None;
        /// `"."`
        pub const MON_DECIMAL_POINT: &str = ".";
        /// `&[3, 3]`
        pub const MON_GROUPING: &[i64] = &[3, 3];
        /// `","`
        pub const MON_THOUSANDS_SEP: &str = ",";
        /// `"-"`
        pub const NEGATIVE_SIGN: &str = "-";
        /// `1`
        pub const N_CS_PRECEDES: i64 = 1;
        /// `0`
        pub const N_SEP_BY_SPACE: i64 = 0;
        /// `1`
        pub const N_SIGN_POSN: i64 = 1;
        /// `""`
        pub const POSITIVE_SIGN: &str = "";
        /// `1`
        pub const P_CS_PRECEDES: i64 = 1;
        /// `0`
        pub const P_SEP_BY_SPACE: i64 = 0;
        /// `1`
        pub const P_SIGN_POSN: i64 = 1;
    }
    pub mod LC_NUMERIC {
        /// `"."`
        pub const DECIMAL_POINT: &str = ".";
        /// `&[3, 3]`
        pub const GROUPING: &[i64] = &[3, 3];
        /// `","`
        pub const THOUSANDS_SEP: &str = ",";
    }
    pub mod LC_TELEPHONE {
        /// `Some("64")`
        pub const INT_PREFIX: Option<&str> = Some("64");
        /// `Some("00")`
        pub const INT_SELECT: Option<&str> = Some("00");
        /// `None`
        pub const TEL_DOM_FMT: Option<&str> = None;
        /// `Some("+%c %a %l")`
        pub const TEL_INT_FMT: Option<&str> = Some("+%c %a %l");
    }
    pub mod LC_TIME {
        /// `&["Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"]`
        pub const ABDAY: &[&str] = &["Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"];
        /// `&["Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"]`
        pub const ABMON: &[&str] = &["Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"];
        /// `None`
        pub const AB_ALT_MON: Option<&[&str]> = None;
        /// `None`
        pub const ALT_DIGITS: Option<&[&str]> = None;
        /// `None`
        pub const ALT_MON: Option<&[&str]> = None;
        /// `&["AM", "PM"]`
        pub const AM_PM: &[&str] = &["AM", "PM"];
        /// `None`
        pub const CAL_DIRECTION: Option<i64> = None;
        /// `None`
        pub const DATE_FMT: Option<&str> = None;
        /// `&["Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"]`
        pub const DAY: &[&str] = &["Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"];
        /// `"%d/%m/%y"`
        pub const D_FMT: &str = "%d/%m/%y";
        /// `"%a %d %b %Y %T %Z"`
        pub const D_T_FMT: &str = "%a %d %b %Y %T %Z";
        /// `None`
        pub const ERA: Option<&[&str]> = None;
        /// `None`
        pub const ERA_D_FMT: Option<&str> = None;
        /// `None`
        pub const ERA_D_T_FMT: Option<&str> = None;
        /// `None`
        pub const ERA_T_FMT: Option<&str> = None;
        /// `None`
        pub const FIRST_WEEKDAY: Option<i64> = None;
        /// `None`
        pub const FIRST_WORKDAY: Option<i64> = None;
        /// `&["January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"]`
        pub const MON: &[&str] = &["January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"];
        /// `"%T"`
        pub const T_FMT: &str = "%T";
        /// `"%I:%M:%S %p"`
        pub const T_FMT_AMPM: &str = "%I:%M:%S %p";
        /// `Some(&[7, 19971130, 1])`
        pub const WEEK: Option<&[i64]> = Some(&[7, 19971130, 1]);
    }
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod en_PH {
    pub mod LC_ADDRESS {
        /// `Some("PHL")`
        pub const COUNTRY_AB3: Option<&str> = Some("PHL");
        /// `Some("PH")`
        pub const COUNTRY_ABTWO: Option<&str> = Some("PH");
        /// `Some("RP")`
        pub const COUNTRY_CAR: Option<&str> = Some("RP");
        /// `None`
        pub const COUNTRY_ISBN: Option<&str> = None;
        /// `Some("Philippines")`
        pub const COUNTRY_NAME: Option<&str> = Some("Philippines");
        /// `Some(608)`
        pub const COUNTRY_NUM: Option<i64> = Some(608);
        /// `None`
        pub const COUNTRY_POST: Option<&str> = None;
        /// `Some("en")`
        pub const LANG_AB: Option<&str> = Some("en");
        /// `Some("eng")`
        pub const LANG_LIB: Option<&str> = Some("eng");
        /// `Some("English")`
        pub const LANG_NAME: Option<&str> = Some("English");
        /// `Some("eng")`
        pub const LANG_TERM: Option<&str> = Some("eng");
        /// `Some("%z%c%T%s%b%e%r")`
        pub const POSTAL_FMT: Option<&str> = Some("%z%c%T%s%b%e%r");
    }
    pub mod LC_IDENTIFICATION {
        /// `None`
        pub const ABBREVIATION: Option<&str> = None;
        /// `Some("1623-14, Shimotsuruma, Yamato-shi, Kanagawa-ken, 242-8502, Japan")`
        pub const ADDRESS: Option<&str> = Some("1623-14, Shimotsuruma, Yamato-shi, Kanagawa-ken, 242-8502, Japan");
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        /// ]
        /// ```
        pub const CATEGORY: Option<&[&[&str]]> = Some(&[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_TELEPHONE"],
            &["i18n:2012", "LC_MEASUREMENT"],
        ]);
        /// `Some("")`
        pub const CONTACT: Option<&str> = Some("");
        /// `Some("2000,October,27 (XML source:2000,July,20)")`
        pub const DATE: Option<&str> = Some("2000,October,27 (XML source:2000,July,20)");
        /// `Some("bug-glibc-locales@gnu.org")`
        pub const EMAIL: Option<&str> = Some("bug-glibc-locales@gnu.org");
        /// `Some("")`
        pub const FAX: Option<&str> = Some("");
        /// `Some("English")`
        pub const LANGUAGE: Option<&str> = Some("English");
        /// `Some("1.0")`
        pub const REVISION: Option<&str> = Some("1.0");
        /// `Some("IBM Globalization Center of Competency, Yamato Software Laboratory")`
        pub const SOURCE: Option<&str> = Some("IBM Globalization Center of Competency, Yamato Software Laboratory");
        /// `Some("")`
        pub const TEL: Option<&str> = Some("");
        /// `Some("Philippines")`
        pub const TERRITORY: Option<&str> = Some("Philippines");
        /// `Some("English language locale for Philippines")`
        pub const TITLE: Option<&str> = Some("English language locale for Philippines");
    }
    pub use super::en_US::LC_MESSAGES;
    pub mod LC_MONETARY {
        /// `"₱"`
        pub const CURRENCY_SYMBOL: &str = "₱";
        /// `2`
        pub const FRAC_DIGITS: i64 = 2;
        /// `"PHP "`
        pub const INT_CURR_SYMBOL: &str = "PHP ";
        /// `2`
        pub const INT_FRAC_DIGITS: i64 = 2;
        /// `None`
        pub const INT_N_CS_PRECEDES: Option<i64> = None;
        /// `None`
        pub const INT_N_SEP_BY_SPACE: Option<i64> = None;
        /// `None`
        pub const INT_N_SIGN_POSN: Option<i64> = None;
        /// `None`
        pub const INT_P_CS_PRECEDES: Option<i64> = None;
        /// `None`
        pub const INT_P_SEP_BY_SPACE: Option<i64> = None;
        /// `None`
        pub const INT_P_SIGN_POSN: Option<i64> = None;
        /// `"."`
        pub const MON_DECIMAL_POINT: &str = ".";
        /// `&[3]`
        pub const MON_GROUPING: &[i64] = &[3];
        /// `","`
        pub const MON_THOUSANDS_SEP: &str = ",";
        /// `"-"`
        pub const NEGATIVE_SIGN: &str = "-";
        /// `1`
        pub const N_CS_PRECEDES: i64 = 1;
        /// `0`
        pub const N_SEP_BY_SPACE: i64 = 0;
        /// `0`
        pub const N_SIGN_POSN: i64 = 0;
        /// `""`
        pub const POSITIVE_SIGN: &str = "";
        /// `1`
        pub const P_CS_PRECEDES: i64 = 1;
        /// `0`
        pub const P_SEP_BY_SPACE: i64 = 0;
        /// `1`
        pub const P_SIGN_POSN: i64 = 1;
    }
    pub mod LC_NUMERIC {
        /// `"."`
        pub const DECIMAL_POINT: &str = ".";
        /// `&[3]`
        pub const GROUPING: &[i64] = &[3];
        /// `","`
        pub const THOUSANDS_SEP: &str = ",";
    }
    pub mod LC_TELEPHONE {
        /// `Some("63")`
        pub const INT_PREFIX: Option<&str> = Some("63");
        /// `Some("00")`
        pub const INT_SELECT: Option<&str> = Some("00");
        /// `None`
        pub const TEL_DOM_FMT: Option<&str> = None;
        /// `Some("+%c ;%a ;%l")`
        pub const TEL_INT_FMT: Option<&str> = Some("+%c ;%a ;%l");
    }
    pub mod LC_TIME {
        /// `&["Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"]`
        pub const ABDAY: &[&str] = &["Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"];
        /// `&["Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"]`
        pub const ABMON: &[&str] = &["Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"];
        /// `None`
        pub const AB_ALT_MON: Option<&[&str]> = None;
        /// `None`
        pub const ALT_DIGITS: Option<&[&str]> = None;
        /// `None`
        pub const ALT_MON: Option<&[&str]> = None;
        /// `&["AM", "PM"]`
        pub const AM_PM: &[&str] = &["AM", "PM"];
        /// `None`
        pub const CAL_DIRECTION: Option<i64> = None;
        /// `None`
        pub const DATE_FMT: Option<&str> = None;
        /// `&["Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"]`
        pub const DAY: &[&str] = &["Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"];
        /// `"%A, %d %B, %Y"`
        pub const D_FMT: &str = "%A, %d %B, %Y";
        /// `"%A, %d %B, %Y %I:%M:%S %p %Z"`
        pub const D_T_FMT: &str = "%A, %d %B, %Y %I:%M:%S %p %Z";
        /// `None`
        pub const ERA: Option<&[&str]> = None;
        /// `None`
        pub const ERA_D_FMT: Option<&str> = None;
        /// `None`
        pub const ERA_D_T_FMT: Option<&str> = None;
        /// `None`
        pub const ERA_T_FMT: Option<&str> = None;
        /// `None`
        pub const FIRST_WEEKDAY: Option<i64> = None;
        /// `None`
        pub const FIRST_WORKDAY: Option<i64> = None;
        /// `&["January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"]`
        pub const MON: &[&str] = &["January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"];
        /// `"%I:%M:%S %p %Z"`
        pub const T_FMT: &str = "%I:%M:%S %p %Z";
        /// `"%I:%M:%S %p %Z"`
        pub const T_FMT_AMPM: &str = "%I:%M:%S %p %Z";
        /// `Some(&[7, 19971130, 1])`
        pub const WEEK: Option<&[i64]> = Some(&[7, 19971130, 1]);
    }
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod en_SC {
    pub mod LC_ADDRESS {
        /// `Some("SYC")`
        pub const COUNTRY_AB3: Option<&str> = Some("SYC");
        /// `Some("SC")`
        pub const COUNTRY_ABTWO: Option<&str> = Some("SC");
        /// `Some("SY")`
        pub const COUNTRY_CAR: Option<&str> = Some("SY");
        /// `Some("978-99931")`
        pub const COUNTRY_ISBN: Option<&str> = Some("978-99931");
        /// `Some("Seychelles")`
        pub const COUNTRY_NAME: Option<&str> = Some("Seychelles");
        /// `Some(690)`
        pub const COUNTRY_NUM: Option<i64> = Some(690);
        /// `None`
        pub const COUNTRY_POST: Option<&str> = None;
        /// `Some("en")`
        pub const LANG_AB: Option<&str> = Some("en");
        /// `Some("eng")`
        pub const LANG_LIB: Option<&str> = Some("eng");
        /// `Some("English")`
        pub const LANG_NAME: Option<&str> = Some("English");
        /// `Some("eng")`
        pub const LANG_TERM: Option<&str> = Some("eng");
        /// `Some("%f%N%h%s%N%T")`
        pub const POSTAL_FMT: Option<&str> = Some("%f%N%h%s%N%T");
    }
    pub mod LC_IDENTIFICATION {
        /// `None`
        pub const ABBREVIATION: Option<&str> = None;
        /// `Some("")`
        pub const ADDRESS: Option<&str> = Some("");
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        /// ]
        /// ```
        pub const CATEGORY: Option<&[&[&str]]> = Some(&[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_TELEPHONE"],
            &["i18n:2012", "LC_MEASUREMENT"],
        ]);
        /// `Some("")`
        pub const CONTACT: Option<&str> = Some("");
        /// `Some("2017-07-24")`
        pub const DATE: Option<&str> = Some("2017-07-24");
        /// `Some("akhilesh.k@samsung.com")`
        pub const EMAIL: Option<&str> = Some("akhilesh.k@samsung.com");
        /// `Some("")`
        pub const FAX: Option<&str> = Some("");
        /// `Some("English")`
        pub const LANGUAGE: Option<&str> = Some("English");
        /// `Some("1.0")`
        pub const REVISION: Option<&str> = Some("1.0");
        /// `Some("Samsung Electronics Co., Ltd.")`
        pub const SOURCE: Option<&str> = Some("Samsung Electronics Co., Ltd.");
        /// `Some("")`
        pub const TEL: Option<&str> = Some("");
        /// `Some("Seychelles")`
        pub const TERRITORY: Option<&str> = Some("Seychelles");
        /// `Some("English locale for the Seychelles")`
        pub const TITLE: Option<&str> = Some("English locale for the Seychelles");
    }
    pub use super::en_GB::LC_MESSAGES;
    pub mod LC_MONETARY {
        /// `"SR"`
        pub const CURRENCY_SYMBOL: &str = "SR";
        /// `2`
        pub const FRAC_DIGITS: i64 = 2;
        /// `"SCR "`
        pub const INT_CURR_SYMBOL: &str = "SCR ";
        /// `2`
        pub const INT_FRAC_DIGITS: i64 = 2;
        /// `None`
        pub const INT_N_CS_PRECEDES: Option<i64> = None;
        /// `Some(1)`
        pub const INT_N_SEP_BY_SPACE: Option<i64> = Some(1);
        /// `None`
        pub const INT_N_SIGN_POSN: Option<i64> = None;
        /// `None`
        pub const INT_P_CS_PRECEDES: Option<i64> = None;
        /// `Some(1)`
        pub const INT_P_SEP_BY_SPACE: Option<i64> = Some(1);
        /// `None`
        pub const INT_P_SIGN_POSN: Option<i64> = None;
        /// `"."`
        pub const MON_DECIMAL_POINT: &str = ".";
        /// `&[3, 3]`
        pub const MON_GROUPING: &[i64] = &[3, 3];
        /// `","`
        pub const MON_THOUSANDS_SEP: &str = ",";
        /// `"-"`
        pub const NEGATIVE_SIGN: &str = "-";
        /// `1`
        pub const N_CS_PRECEDES: i64 = 1;
        /// `0`
        pub const N_SEP_BY_SPACE: i64 = 0;
        /// `1`
        pub const N_SIGN_POSN: i64 = 1;
        /// `""`
        pub const POSITIVE_SIGN: &str = "";
        /// `1`
        pub const P_CS_PRECEDES: i64 = 1;
        /// `0`
        pub const P_SEP_BY_SPACE: i64 = 0;
        /// `1`
        pub const P_SIGN_POSN: i64 = 1;
    }
    pub use super::en_GB::LC_NUMERIC;
    pub mod LC_TELEPHONE {
        /// `Some("248")`
        pub const INT_PREFIX: Option<&str> = Some("248");
        /// `Some("00")`
        pub const INT_SELECT: Option<&str> = Some("00");
        /// `None`
        pub const TEL_DOM_FMT: Option<&str> = None;
        /// `Some("+%c %l")`
        pub const TEL_INT_FMT: Option<&str> = Some("+%c %l");
    }
    pub use super::en_GB::LC_TIME;
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod en_SG {
    pub mod LC_ADDRESS {
        /// `Some("SGP")`
        pub const COUNTRY_AB3: Option<&str> = Some("SGP");
        /// `Some("SG")`
        pub const COUNTRY_ABTWO: Option<&str> = Some("SG");
        /// `Some("SGP")`
        pub const COUNTRY_CAR: Option<&str> = Some("SGP");
        /// `None`
        pub const COUNTRY_ISBN: Option<&str> = None;
        /// `Some("Singapore")`
        pub const COUNTRY_NAME: Option<&str> = Some("Singapore");
        /// `Some(702)`
        pub const COUNTRY_NUM: Option<i64> = Some(702);
        /// `None`
        pub const COUNTRY_POST: Option<&str> = None;
        /// `Some("en")`
        pub const LANG_AB: Option<&str> = Some("en");
        /// `Some("eng")`
        pub const LANG_LIB: Option<&str> = Some("eng");
        /// `Some("English")`
        pub const LANG_NAME: Option<&str> = Some("English");
        /// `Some("eng")`
        pub const LANG_TERM: Option<&str> = Some("eng");
        /// `Some("%z%c%T%s%b%e%r")`
        pub const POSTAL_FMT: Option<&str> = Some("%z%c%T%s%b%e%r");
    }
    pub mod LC_IDENTIFICATION {
        /// `None`
        pub const ABBREVIATION: Option<&str> = None;
        /// `Some("1623-14, Shimotsuruma, Yamato-shi, Kanagawa-ken, 242-8502, Japan")`
        pub const ADDRESS: Option<&str> = Some("1623-14, Shimotsuruma, Yamato-shi, Kanagawa-ken, 242-8502, Japan");
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        /// ]
        /// ```
        pub const CATEGORY: Option<&[&[&str]]> = Some(&[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_TELEPHONE"],
            &["i18n:2012", "LC_MEASUREMENT"],
        ]);
        /// `Some("")`
        pub const CONTACT: Option<&str> = Some("");
        /// `Some("2000,October,27 (XML source:2000,July,20)")`
        pub const DATE: Option<&str> = Some("2000,October,27 (XML source:2000,July,20)");
        /// `Some("bug-glibc-locales@gnu.org")`
        pub const EMAIL: Option<&str> = Some("bug-glibc-locales@gnu.org");
        /// `Some("")`
        pub const FAX: Option<&str> = Some("");
        /// `Some("English")`
        pub const LANGUAGE: Option<&str> = Some("English");
        /// `Some("1.0")`
        pub const REVISION: Option<&str> = Some("1.0");
        /// `Some("IBM Globalization Center of Competency, Yamato Software Laboratory")`
        pub const SOURCE: Option<&str> = Some("IBM Globalization Center of Competency, Yamato Software Laboratory");
        /// `Some("")`
        pub const TEL: Option<&str> = Some("");
        /// `Some("Singapore")`
        pub const TERRITORY: Option<&str> = Some("Singapore");
        /// `Some("English language locale for Singapore")`
        pub const TITLE: Option<&str> = Some("English language locale for Singapore");
    }
    pub use super::en_US::LC_MESSAGES;
    pub mod LC_MONETARY {
        /// `"$"`
        pub const CURRENCY_SYMBOL: &str = "$";
        /// `2`
        pub const FRAC_DIGITS: i64 = 2;
        /// `"SGD "`
        pub const INT_CURR_SYMBOL: &str = "SGD ";
        /// `2`
        pub const INT_FRAC_DIGITS: i64 = 2;
        /// `None`
        pub const INT_N_CS_PRECEDES: Option<i64> = None;
        /// `None`
        pub const INT_N_SEP_BY_SPACE: Option<i64> = None;
        /// `None`
        pub const INT_N_SIGN_POSN: Option<i64> = None;
        /// `None`
        pub const INT_P_CS_PRECEDES: Option<i64> = None;
        /// `None`
        pub const INT_P_SEP_BY_SPACE: Option<i64> = None;
        /// `None`
        pub const INT_P_SIGN_POSN: Option<i64> = None;
        /// `"."`
        pub const MON_DECIMAL_POINT: &str = ".";
        /// `&[3]`
        pub const MON_GROUPING: &[i64] = &[3];
        /// `","`
        pub const MON_THOUSANDS_SEP: &str = ",";
        /// `"-"`
        pub const NEGATIVE_SIGN: &str = "-";
        /// `1`
        pub const N_CS_PRECEDES: i64 = 1;
        /// `0`
        pub const N_SEP_BY_SPACE: i64 = 0;
        /// `0`
        pub const N_SIGN_POSN: i64 = 0;
        /// `""`
        pub const POSITIVE_SIGN: &str = "";
        /// `1`
        pub const P_CS_PRECEDES: i64 = 1;
        /// `0`
        pub const P_SEP_BY_SPACE: i64 = 0;
        /// `1`
        pub const P_SIGN_POSN: i64 = 1;
    }
    pub mod LC_NUMERIC {
        /// `"."`
        pub const DECIMAL_POINT: &str = ".";
        /// `&[3]`
        pub const GROUPING: &[i64] = &[3];
        /// `","`
        pub const THOUSANDS_SEP: &str = ",";
    }
    pub mod LC_TELEPHONE {
        /// `Some("65")`
        pub const INT_PREFIX: Option<&str> = Some("65");
        /// `Some("001")`
        pub const INT_SELECT: Option<&str> = Some("001");
        /// `None`
        pub const TEL_DOM_FMT: Option<&str> = None;
        /// `Some("+%c ;%a ;%l")`
        pub const TEL_INT_FMT: Option<&str> = Some("+%c ;%a ;%l");
    }
    pub mod LC_TIME {
        /// `&["Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"]`
        pub const ABDAY: &[&str] = &["Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"];
        /// `&["Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"]`
        pub const ABMON: &[&str] = &["Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"];
        /// `None`
        pub const AB_ALT_MON: Option<&[&str]> = None;
        /// `None`
        pub const ALT_DIGITS: Option<&[&str]> = None;
        /// `None`
        pub const ALT_MON: Option<&[&str]> = None;
        /// `&["AM", "PM"]`
        pub const AM_PM: &[&str] = &["AM", "PM"];
        /// `None`
        pub const CAL_DIRECTION: Option<i64> = None;
        /// `None`
        pub const DATE_FMT: Option<&str> = None;
        /// `&["Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"]`
        pub const DAY: &[&str] = &["Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"];
        /// `"%d/%m/%Y"`
        pub const D_FMT: &str = "%d/%m/%Y";
        /// `"%a %d %b %Y %I:%M:%S %p"`
        pub const D_T_FMT: &str = "%a %d %b %Y %I:%M:%S %p";
        /// `None`
        pub const ERA: Option<&[&str]> = None;
        /// `None`
        pub const ERA_D_FMT: Option<&str> = None;
        /// `None`
        pub const ERA_D_T_FMT: Option<&str> = None;
        /// `None`
        pub const ERA_T_FMT: Option<&str> = None;
        /// `None`
        pub const FIRST_WEEKDAY: Option<i64> = None;
        /// `None`
        pub const FIRST_WORKDAY: Option<i64> = None;
        /// `&["January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"]`
        pub const MON: &[&str] = &["January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"];
        /// `"%T"`
        pub const T_FMT: &str = "%T";
        /// `"%I:%M:%S %p"`
        pub const T_FMT_AMPM: &str = "%I:%M:%S %p";
        /// `Some(&[7, 19971130, 1])`
        pub const WEEK: Option<&[i64]> = Some(&[7, 19971130, 1]);
    }
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod en_US {
    pub mod LC_ADDRESS {
        /// `Some("USA")`
        pub const COUNTRY_AB3: Option<&str> = Some("USA");
        /// `Some("US")`
        pub const COUNTRY_ABTWO: Option<&str> = Some("US");
        /// `Some("USA")`
        pub const COUNTRY_CAR: Option<&str> = Some("USA");
        /// `Some("0")`
        pub const COUNTRY_ISBN: Option<&str> = Some("0");
        /// `Some("United States")`
        pub const COUNTRY_NAME: Option<&str> = Some("United States");
        /// `Some(840)`
        pub const COUNTRY_NUM: Option<i64> = Some(840);
        /// `Some("USA")`
        pub const COUNTRY_POST: Option<&str> = Some("USA");
        /// `Some("en")`
        pub const LANG_AB: Option<&str> = Some("en");
        /// `Some("eng")`
        pub const LANG_LIB: Option<&str> = Some("eng");
        /// `Some("English")`
        pub const LANG_NAME: Option<&str> = Some("English");
        /// `Some("eng")`
        pub const LANG_TERM: Option<&str> = Some("eng");
        /// `Some("%a%N%f%N%d%N%b%N%h %s %e %r%N%T, %S %z%N%c%N")`
        pub const POSTAL_FMT: Option<&str> = Some("%a%N%f%N%d%N%b%N%h %s %e %r%N%T, %S %z%N%c%N");
    }
    pub mod LC_IDENTIFICATION {
        /// `None`
        pub const ABBREVIATION: Option<&str> = None;
        /// `Some("https://www.gnu.org/software/libc/")`
        pub const ADDRESS: Option<&str> = Some("https://www.gnu.org/software/libc/");
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        /// ]
        /// ```
        pub const CATEGORY: Option<&[&[&str]]> = Some(&[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_TELEPHONE"],
            &["i18n:2012", "LC_MEASUREMENT"],
        ]);
        /// `Some("")`
        pub const CONTACT: Option<&str> = Some("");
        /// `Some("2000-06-24")`
        pub const DATE: Option<&str> = Some("2000-06-24");
        /// `Some("bug-glibc-locales@gnu.org")`
        pub const EMAIL: Option<&str> = Some("bug-glibc-locales@gnu.org");
        /// `Some("")`
        pub const FAX: Option<&str> = Some("");
        /// `Some("American English")`
        pub const LANGUAGE: Option<&str> = Some("American English");
        /// `Some("1.0")`
        pub const REVISION: Option<&str> = Some("1.0");
        /// `Some("Free Software Foundation, Inc.")`
        pub const SOURCE: Option<&str> = Some("Free Software Foundation, Inc.");
        /// `Some("")`
        pub const TEL: Option<&str> = Some("");
        /// `Some("United States")`
        pub const TERRITORY: Option<&str> = Some("United States");
        /// `Some("English locale for the USA")`
        pub const TITLE: Option<&str> = Some("English locale for the USA");
    }
    pub mod LC_MESSAGES {
        /// `"^[-0nN]"`
        pub const NOEXPR: &str = "^[-0nN]";
        /// `Some("no")`
        pub const NOSTR: Option<&str> = Some("no");
        /// `"^[+1yY]"`
        pub const YESEXPR: &str = "^[+1yY]";
        /// `Some("yes")`
        pub const YESSTR: Option<&str> = Some("yes");
    }
    pub mod LC_MONETARY {
        /// `"$"`
        pub const CURRENCY_SYMBOL: &str = "$";
        /// `2`
        pub const FRAC_DIGITS: i64 = 2;
        /// `"USD "`
        pub const INT_CURR_SYMBOL: &str = "USD ";
        /// `2`
        pub const INT_FRAC_DIGITS: i64 = 2;
        /// `None`
        pub const INT_N_CS_PRECEDES: Option<i64> = None;
        /// `Some(1)`
        pub const INT_N_SEP_BY_SPACE: Option<i64> = Some(1);
        /// `None`
        pub const INT_N_SIGN_POSN: Option<i64> = None;
        /// `None`
        pub const INT_P_CS_PRECEDES: Option<i64> = None;
        /// `Some(1)`
        pub const INT_P_SEP_BY_SPACE: Option<i64> = Some(1);
        /// `None`
        pub const INT_P_SIGN_POSN: Option<i64> = None;
        /// `"."`
        pub const MON_DECIMAL_POINT: &str = ".";
        /// `&[3, 3]`
        pub const MON_GROUPING: &[i64] = &[3, 3];
        /// `","`
        pub const MON_THOUSANDS_SEP: &str = ",";
        /// `"-"`
        pub const NEGATIVE_SIGN: &str = "-";
        /// `1`
        pub const N_CS_PRECEDES: i64 = 1;
        /// `0`
        pub const N_SEP_BY_SPACE: i64 = 0;
        /// `1`
        pub const N_SIGN_POSN: i64 = 1;
        /// `""`
        pub const POSITIVE_SIGN: &str = "";
        /// `1`
        pub const P_CS_PRECEDES: i64 = 1;
        /// `0`
        pub const P_SEP_BY_SPACE: i64 = 0;
        /// `1`
        pub const P_SIGN_POSN: i64 = 1;
    }
    pub mod LC_NUMERIC {
        /// `"."`
        pub const DECIMAL_POINT: &str = ".";
        /// `&[3, 3]`
        pub const GROUPING: &[i64] = &[3, 3];
        /// `","`
        pub const THOUSANDS_SEP: &str = ",";
    }
    pub mod LC_TELEPHONE {
        /// `Some("1")`
        pub const INT_PREFIX: Option<&str> = Some("1");
        /// `Some("11")`
        pub const INT_SELECT: Option<&str> = Some("11");
        /// `Some("(%a) %l")`
        pub const TEL_DOM_FMT: Option<&str> = Some("(%a) %l");
        /// `Some("+%c (%a) %l")`
        pub const TEL_INT_FMT: Option<&str> = Some("+%c (%a) %l");
    }
    pub mod LC_TIME {
        /// `&["Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"]`
        pub const ABDAY: &[&str] = &["Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"];
        /// `&["Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"]`
        pub const ABMON: &[&str] = &["Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"];
        /// `None`
        pub const AB_ALT_MON: Option<&[&str]> = None;
        /// `None`
        pub const ALT_DIGITS: Option<&[&str]> = None;
        /// `None`
        pub const ALT_MON: Option<&[&str]> = None;
        /// `&["AM", "PM"]`
        pub const AM_PM: &[&str] = &["AM", "PM"];
        /// `None`
        pub const CAL_DIRECTION: Option<i64> = None;
        /// `Some("%a %d %b %Y %r %Z")`
        pub const DATE_FMT: Option<&str> = Some("%a %d %b %Y %r %Z");
        /// `&["Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"]`
        pub const DAY: &[&str] = &["Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"];
        /// `"%m/%d/%Y"`
        pub const D_FMT: &str = "%m/%d/%Y";
        /// `"%a %d %b %Y %I:%M:%S %p %Z"`
        pub const D_T_FMT: &str = "%a %d %b %Y %I:%M:%S %p %Z";
        /// `None`
        pub const ERA: Option<&[&str]> = None;
        /// `None`
        pub const ERA_D_FMT: Option<&str> = None;
        /// `None`
        pub const ERA_D_T_FMT: Option<&str> = None;
        /// `None`
        pub const ERA_T_FMT: Option<&str> = None;
        /// `None`
        pub const FIRST_WEEKDAY: Option<i64> = None;
        /// `None`
        pub const FIRST_WORKDAY: Option<i64> = None;
        /// `&["January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"]`
        pub const MON: &[&str] = &["January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"];
        /// `"%I:%M:%S %p"`
        pub const T_FMT: &str = "%I:%M:%S %p";
        /// `"%I:%M:%S %p"`
        pub const T_FMT_AMPM: &str = "%I:%M:%S %p";
        /// `Some(&[7, 19971130, 1])`
        pub const WEEK: Option<&[i64]> = Some(&[7, 19971130, 1]);
    }
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod en_ZA {
    pub mod LC_ADDRESS {
        /// `Some("ZAF")`
        pub const COUNTRY_AB3: Option<&str> = Some("ZAF");
        /// `Some("ZA")`
        pub const COUNTRY_ABTWO: Option<&str> = Some("ZA");
        /// `Some("ZA")`
        pub const COUNTRY_CAR: Option<&str> = Some("ZA");
        /// `Some("0")`
        pub const COUNTRY_ISBN: Option<&str> = Some("0");
        /// `Some("South Africa")`
        pub const COUNTRY_NAME: Option<&str> = Some("South Africa");
        /// `Some(710)`
        pub const COUNTRY_NUM: Option<i64> = Some(710);
        /// `Some("ZA")`
        pub const COUNTRY_POST: Option<&str> = Some("ZA");
        /// `Some("en")`
        pub const LANG_AB: Option<&str> = Some("en");
        /// `Some("eng")`
        pub const LANG_LIB: Option<&str> = Some("eng");
        /// `Some("English")`
        pub const LANG_NAME: Option<&str> = Some("English");
        /// `Some("eng")`
        pub const LANG_TERM: Option<&str> = Some("eng");
        /// `Some("%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%c%N")`
        pub const POSTAL_FMT: Option<&str> = Some("%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%c%N");
    }
    pub mod LC_IDENTIFICATION {
        /// `Some("Translate.org.za")`
        pub const ABBREVIATION: Option<&str> = Some("Translate.org.za");
        /// `Some("Box 28364, Sunnyside, 0132, South Africa")`
        pub const ADDRESS: Option<&str> = Some("Box 28364, Sunnyside, 0132, South Africa");
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        /// ]
        /// ```
        pub const CATEGORY: Option<&[&[&str]]> = Some(&[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_MEASUREMENT"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_TELEPHONE"],
        ]);
        /// `Some("Dwayne Bailey")`
        pub const CONTACT: Option<&str> = Some("Dwayne Bailey");
        /// `Some("2007-04-19")`
        pub const DATE: Option<&str> = Some("2007-04-19");
        /// `Some("dwayne@translate.org.za")`
        pub const EMAIL: Option<&str> = Some("dwayne@translate.org.za");
        /// `Some("")`
        pub const FAX: Option<&str> = Some("");
        /// `Some("English")`
        pub const LANGUAGE: Option<&str> = Some("English");
        /// `Some("1.3")`
        pub const REVISION: Option<&str> = Some("1.3");
        /// `Some("Zuza Software Foundation (Translate.org.za)")`
        pub const SOURCE: Option<&str> = Some("Zuza Software Foundation (Translate.org.za)");
        /// `Some("")`
        pub const TEL: Option<&str> = Some("");
        /// `Some("South Africa")`
        pub const TERRITORY: Option<&str> = Some("South Africa");
        /// `Some("English locale for South Africa")`
        pub const TITLE: Option<&str> = Some("English locale for South Africa");
    }
    pub use super::en_US::LC_MESSAGES;
    pub mod LC_MONETARY {
        /// `"R"`
        pub const CURRENCY_SYMBOL: &str = "R";
        /// `2`
        pub const FRAC_DIGITS: i64 = 2;
        /// `"ZAR "`
        pub const INT_CURR_SYMBOL: &str = "ZAR ";
        /// `2`
        pub const INT_FRAC_DIGITS: i64 = 2;
        /// `None`
        pub const INT_N_CS_PRECEDES: Option<i64> = None;
        /// `None`
        pub const INT_N_SEP_BY_SPACE: Option<i64> = None;
        /// `None`
        pub const INT_N_SIGN_POSN: Option<i64> = None;
        /// `None`
        pub const INT_P_CS_PRECEDES: Option<i64> = None;
        /// `None`
        pub const INT_P_SEP_BY_SPACE: Option<i64> = None;
        /// `None`
        pub const INT_P_SIGN_POSN: Option<i64> = None;
        /// `"."`
        pub const MON_DECIMAL_POINT: &str = ".";
        /// `&[3, 3]`
        pub const MON_GROUPING: &[i64] = &[3, 3];
        /// `","`
        pub const MON_THOUSANDS_SEP: &str = ",";
        /// `"-"`
        pub const NEGATIVE_SIGN: &str = "-";
        /// `1`
        pub const N_CS_PRECEDES: i64 = 1;
        /// `0`
        pub const N_SEP_BY_SPACE: i64 = 0;
        /// `1`
        pub const N_SIGN_POSN: i64 = 1;
        /// `""`
        pub const POSITIVE_SIGN: &str = "";
        /// `1`
        pub const P_CS_PRECEDES: i64 = 1;
        /// `0`
        pub const P_SEP_BY_SPACE: i64 = 0;
        /// `1`
        pub const P_SIGN_POSN: i64 = 1;
    }
    pub mod LC_NUMERIC {
        /// `"."`
        pub const DECIMAL_POINT: &str = ".";
        /// `&[3, 3]`
        pub const GROUPING: &[i64] = &[3, 3];
        /// `","`
        pub const THOUSANDS_SEP: &str = ",";
    }
    pub mod LC_TELEPHONE {
        /// `Some("27")`
        pub const INT_PREFIX: Option<&str> = Some("27");
        /// `Some("00")`
        pub const INT_SELECT: Option<&str> = Some("00");
        /// `Some("(%A) %l")`
        pub const TEL_DOM_FMT: Option<&str> = Some("(%A) %l");
        /// `Some("+%c %a %l")`
        pub const TEL_INT_FMT: Option<&str> = Some("+%c %a %l");
    }
    pub mod LC_TIME {
        /// `&["Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"]`
        pub const ABDAY: &[&str] = &["Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"];
        /// `&["Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"]`
        pub const ABMON: &[&str] = &["Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"];
        /// `None`
        pub const AB_ALT_MON: Option<&[&str]> = None;
        /// `None`
        pub const ALT_DIGITS: Option<&[&str]> = None;
        /// `None`
        pub const ALT_MON: Option<&[&str]> = None;
        /// `&["", ""]`
        pub const AM_PM: &[&str] = &["", ""];
        /// `None`
        pub const CAL_DIRECTION: Option<i64> = None;
        /// `None`
        pub const DATE_FMT: Option<&str> = None;
        /// `&["Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"]`
        pub const DAY: &[&str] = &["Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"];
        /// `"%d/%m/%Y"`
        pub const D_FMT: &str = "%d/%m/%Y";
        /// `"%a %d %b %Y %T %Z"`
        pub const D_T_FMT: &str = "%a %d %b %Y %T %Z";
        /// `None`
        pub const ERA: Option<&[&str]> = None;
        /// `None`
        pub const ERA_D_FMT: Option<&str> = None;
        /// `None`
        pub const ERA_D_T_FMT: Option<&str> = None;
        /// `None`
        pub const ERA_T_FMT: Option<&str> = None;
        /// `None`
        pub const FIRST_WEEKDAY: Option<i64> = None;
        /// `None`
        pub const FIRST_WORKDAY: Option<i64> = None;
        /// `&["January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"]`
        pub const MON: &[&str] = &["January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"];
        /// `"%T"`
        pub const T_FMT: &str = "%T";
        /// `""`
        pub const T_FMT_AMPM: &str = "";
        /// `Some(&[7, 19971130, 1])`
        pub const WEEK: Option<&[i64]> = Some(&[7, 19971130, 1]);
    }
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod en_ZM {
    pub mod LC_ADDRESS {
        /// `Some("ZMB")`
        pub const COUNTRY_AB3: Option<&str> = Some("ZMB");
        /// `Some("ZM")`
        pub const COUNTRY_ABTWO: Option<&str> = Some("ZM");
        /// `Some("Z")`
        pub const COUNTRY_CAR: Option<&str> = Some("Z");
        /// `None`
        pub const COUNTRY_ISBN: Option<&str> = None;
        /// `Some("Zambia")`
        pub const COUNTRY_NAME: Option<&str> = Some("Zambia");
        /// `Some(894)`
        pub const COUNTRY_NUM: Option<i64> = Some(894);
        /// `Some("ZM")`
        pub const COUNTRY_POST: Option<&str> = Some("ZM");
        /// `Some("en")`
        pub const LANG_AB: Option<&str> = Some("en");
        /// `Some("eng")`
        pub const LANG_LIB: Option<&str> = Some("eng");
        /// `Some("English")`
        pub const LANG_NAME: Option<&str> = Some("English");
        /// `Some("eng")`
        pub const LANG_TERM: Option<&str> = Some("eng");
        /// `Some("%a%N%f%N%e %h%N%b %s%N%z%N%T%N%c%N")`
        pub const POSTAL_FMT: Option<&str> = Some("%a%N%f%N%e %h%N%b %s%N%z%N%T%N%c%N");
    }
    pub mod LC_IDENTIFICATION {
        /// `None`
        pub const ABBREVIATION: Option<&str> = None;
        /// `None`
        pub const ADDRESS: Option<&str> = None;
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        /// ]
        /// ```
        pub const CATEGORY: Option<&[&[&str]]> = Some(&[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_MEASUREMENT"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_TELEPHONE"],
        ]);
        /// `Some("Martin Benjamin")`
        pub const CONTACT: Option<&str> = Some("Martin Benjamin");
        /// `Some("2011-04-18")`
        pub const DATE: Option<&str> = Some("2011-04-18");
        /// `Some("locales@africanlocalization.net")`
        pub const EMAIL: Option<&str> = Some("locales@africanlocalization.net");
        /// `None`
        pub const FAX: Option<&str> = None;
        /// `Some("English")`
        pub const LANGUAGE: Option<&str> = Some("English");
        /// `Some("1.0")`
        pub const REVISION: Option<&str> = Some("1.0");
        /// `Some("ANLoc")`
        pub const SOURCE: Option<&str> = Some("ANLoc");
        /// `None`
        pub const TEL: Option<&str> = None;
        /// `Some("Zambia")`
        pub const TERRITORY: Option<&str> = Some("Zambia");
        /// `Some("English locale for Zambia")`
        pub const TITLE: Option<&str> = Some("English locale for Zambia");
    }
    pub use super::bem_ZM::LC_MESSAGES;
    pub use super::bem_ZM::LC_MONETARY;
    pub use super::en_GB::LC_NUMERIC;
    pub use super::bem_ZM::LC_TELEPHONE;
    pub mod LC_TIME {
        /// `&["Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"]`
        pub const ABDAY: &[&str] = &["Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"];
        /// `&["Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"]`
        pub const ABMON: &[&str] = &["Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"];
        /// `None`
        pub const AB_ALT_MON: Option<&[&str]> = None;
        /// `None`
        pub const ALT_DIGITS: Option<&[&str]> = None;
        /// `None`
        pub const ALT_MON: Option<&[&str]> = None;
        /// `&["am", "pm"]`
        pub const AM_PM: &[&str] = &["am", "pm"];
        /// `None`
        pub const CAL_DIRECTION: Option<i64> = None;
        /// `Some("%a %e %b %H:%M:%S %Z %Y")`
        pub const DATE_FMT: Option<&str> = Some("%a %e %b %H:%M:%S %Z %Y");
        /// `&["Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"]`
        pub const DAY: &[&str] = &["Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"];
        /// `"%d/%m/%y"`
        pub const D_FMT: &str = "%d/%m/%y";
        /// `"%a %d %b %Y %T %Z"`
        pub const D_T_FMT: &str = "%a %d %b %Y %T %Z";
        /// `None`
        pub const ERA: Option<&[&str]> = None;
        /// `None`
        pub const ERA_D_FMT: Option<&str> = None;
        /// `None`
        pub const ERA_D_T_FMT: Option<&str> = None;
        /// `None`
        pub const ERA_T_FMT: Option<&str> = None;
        /// `Some(2)`
        pub const FIRST_WEEKDAY: Option<i64> = Some(2);
        /// `None`
        pub const FIRST_WORKDAY: Option<i64> = None;
        /// `&["January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"]`
        pub const MON: &[&str] = &["January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"];
        /// `"%T"`
        pub const T_FMT: &str = "%T";
        /// `"%l:%M:%S %P %Z"`
        pub const T_FMT_AMPM: &str = "%l:%M:%S %P %Z";
        /// `Some(&[7, 19971130, 1])`
        pub const WEEK: Option<&[i64]> = Some(&[7, 19971130, 1]);
    }
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod en_ZW {
    pub mod LC_ADDRESS {
        /// `Some("ZWE")`
        pub const COUNTRY_AB3: Option<&str> = Some("ZWE");
        /// `Some("ZW")`
        pub const COUNTRY_ABTWO: Option<&str> = Some("ZW");
        /// `Some("ZW")`
        pub const COUNTRY_CAR: Option<&str> = Some("ZW");
        /// `None`
        pub const COUNTRY_ISBN: Option<&str> = None;
        /// `Some("Zimbabwe")`
        pub const COUNTRY_NAME: Option<&str> = Some("Zimbabwe");
        /// `Some(716)`
        pub const COUNTRY_NUM: Option<i64> = Some(716);
        /// `None`
        pub const COUNTRY_POST: Option<&str> = None;
        /// `Some("en")`
        pub const LANG_AB: Option<&str> = Some("en");
        /// `Some("eng")`
        pub const LANG_LIB: Option<&str> = Some("eng");
        /// `Some("English")`
        pub const LANG_NAME: Option<&str> = Some("English");
        /// `Some("eng")`
        pub const LANG_TERM: Option<&str> = Some("eng");
        /// `Some("%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%c%N")`
        pub const POSTAL_FMT: Option<&str> = Some("%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%c%N");
    }
    pub mod LC_IDENTIFICATION {
        /// `None`
        pub const ABBREVIATION: Option<&str> = None;
        /// `Some("")`
        pub const ADDRESS: Option<&str> = Some("");
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        /// ]
        /// ```
        pub const CATEGORY: Option<&[&[&str]]> = Some(&[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_TELEPHONE"],
            &["i18n:2012", "LC_MEASUREMENT"],
        ]);
        /// `Some("")`
        pub const CONTACT: Option<&str> = Some("");
        /// `Some("2000-06-29")`
        pub const DATE: Option<&str> = Some("2000-06-29");
        /// `Some("bug-glibc-locales@gnu.org")`
        pub const EMAIL: Option<&str> = Some("bug-glibc-locales@gnu.org");
        /// `Some("")`
        pub const FAX: Option<&str> = Some("");
        /// `Some("English")`
        pub const LANGUAGE: Option<&str> = Some("English");
        /// `Some("1.0")`
        pub const REVISION: Option<&str> = Some("1.0");
        /// `Some("RAP")`
        pub const SOURCE: Option<&str> = Some("RAP");
        /// `Some("")`
        pub const TEL: Option<&str> = Some("");
        /// `Some("Zimbabwe")`
        pub const TERRITORY: Option<&str> = Some("Zimbabwe");
        /// `Some("English locale for Zimbabwe")`
        pub const TITLE: Option<&str> = Some("English locale for Zimbabwe");
    }
    pub use super::en_ZA::LC_MESSAGES;
    pub mod LC_MONETARY {
        /// `"$"`
        pub const CURRENCY_SYMBOL: &str = "$";
        /// `2`
        pub const FRAC_DIGITS: i64 = 2;
        /// `"USD "`
        pub const INT_CURR_SYMBOL: &str = "USD ";
        /// `2`
        pub const INT_FRAC_DIGITS: i64 = 2;
        /// `None`
        pub const INT_N_CS_PRECEDES: Option<i64> = None;
        /// `None`
        pub const INT_N_SEP_BY_SPACE: Option<i64> = None;
        /// `None`
        pub const INT_N_SIGN_POSN: Option<i64> = None;
        /// `None`
        pub const INT_P_CS_PRECEDES: Option<i64> = None;
        /// `None`
        pub const INT_P_SEP_BY_SPACE: Option<i64> = None;
        /// `None`
        pub const INT_P_SIGN_POSN: Option<i64> = None;
        /// `"."`
        pub const MON_DECIMAL_POINT: &str = ".";
        /// `&[3, 3]`
        pub const MON_GROUPING: &[i64] = &[3, 3];
        /// `","`
        pub const MON_THOUSANDS_SEP: &str = ",";
        /// `"-"`
        pub const NEGATIVE_SIGN: &str = "-";
        /// `1`
        pub const N_CS_PRECEDES: i64 = 1;
        /// `0`
        pub const N_SEP_BY_SPACE: i64 = 0;
        /// `1`
        pub const N_SIGN_POSN: i64 = 1;
        /// `""`
        pub const POSITIVE_SIGN: &str = "";
        /// `1`
        pub const P_CS_PRECEDES: i64 = 1;
        /// `0`
        pub const P_SEP_BY_SPACE: i64 = 0;
        /// `1`
        pub const P_SIGN_POSN: i64 = 1;
    }
    pub use super::en_ZA::LC_NUMERIC;
    pub mod LC_TELEPHONE {
        /// `Some("263")`
        pub const INT_PREFIX: Option<&str> = Some("263");
        /// `Some("00")`
        pub const INT_SELECT: Option<&str> = Some("00");
        /// `None`
        pub const TEL_DOM_FMT: Option<&str> = None;
        /// `Some("+%c %a %l")`
        pub const TEL_INT_FMT: Option<&str> = Some("+%c %a %l");
    }
    pub use super::en_ZA::LC_TIME;
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod eo {
    pub mod LC_ADDRESS {
        /// `None`
        pub const COUNTRY_AB3: Option<&str> = None;
        /// `None`
        pub const COUNTRY_ABTWO: Option<&str> = None;
        /// `None`
        pub const COUNTRY_CAR: Option<&str> = None;
        /// `None`
        pub const COUNTRY_ISBN: Option<&str> = None;
        /// `None`
        pub const COUNTRY_NAME: Option<&str> = None;
        /// `None`
        pub const COUNTRY_NUM: Option<i64> = None;
        /// `None`
        pub const COUNTRY_POST: Option<&str> = None;
        /// `Some("eo")`
        pub const LANG_AB: Option<&str> = Some("eo");
        /// `None`
        pub const LANG_LIB: Option<&str> = None;
        /// `Some("esperanto")`
        pub const LANG_NAME: Option<&str> = Some("esperanto");
        /// `Some("epo")`
        pub const LANG_TERM: Option<&str> = Some("epo");
        /// `Some("%f%N%a%N%d%N%b%N%s %h %e %r%N%%z %T%N%c%N")`
        pub const POSTAL_FMT: Option<&str> = Some("%f%N%a%N%d%N%b%N%s %h %e %r%N%%z %T%N%c%N");
    }
    pub mod LC_IDENTIFICATION {
        /// `None`
        pub const ABBREVIATION: Option<&str> = None;
        /// `Some("")`
        pub const ADDRESS: Option<&str> = Some("");
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        /// ]
        /// ```
        pub const CATEGORY: Option<&[&[&str]]> = Some(&[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_TELEPHONE"],
            &["i18n:2012", "LC_MEASUREMENT"],
        ]);
        /// `Some("")`
        pub const CONTACT: Option<&str> = Some("");
        /// `Some("2016-06-10")`
        pub const DATE: Option<&str> = Some("2016-06-10");
        /// `Some("debian-esperanto@lists.debian.org")`
        pub const EMAIL: Option<&str> = Some("debian-esperanto@lists.debian.org");
        /// `Some("")`
        pub const FAX: Option<&str> = Some("");
        /// `Some("Esperanto")`
        pub const LANGUAGE: Option<&str> = Some("Esperanto");
        /// `Some("draft")`
        pub const REVISION: Option<&str> = Some("draft");
        /// `Some("")`
        pub const SOURCE: Option<&str> = Some("");
        /// `Some("")`
        pub const TEL: Option<&str> = Some("");
        /// `Some("")`
        pub const TERRITORY: Option<&str> = Some("");
        /// `Some("Esperanto language locale")`
        pub const TITLE: Option<&str> = Some("Esperanto language locale");
    }
    pub mod LC_MESSAGES {
        /// `"^[-0nN]"`
        pub const NOEXPR: &str = "^[-0nN]";
        /// `Some("Ne")`
        pub const NOSTR: Option<&str> = Some("Ne");
        /// `"^[+1JjYy]"`
        pub const YESEXPR: &str = "^[+1JjYy]";
        /// `Some("Jes")`
        pub const YESSTR: Option<&str> = Some("Jes");
    }
    pub mod LC_MONETARY {
        /// `"¤"`
        pub const CURRENCY_SYMBOL: &str = "¤";
        /// `2`
        pub const FRAC_DIGITS: i64 = 2;
        /// `"XDR "`
        pub const INT_CURR_SYMBOL: &str = "XDR ";
        /// `2`
        pub const INT_FRAC_DIGITS: i64 = 2;
        /// `None`
        pub const INT_N_CS_PRECEDES: Option<i64> = None;
        /// `None`
        pub const INT_N_SEP_BY_SPACE: Option<i64> = None;
        /// `None`
        pub const INT_N_SIGN_POSN: Option<i64> = None;
        /// `None`
        pub const INT_P_CS_PRECEDES: Option<i64> = None;
        /// `None`
        pub const INT_P_SEP_BY_SPACE: Option<i64> = None;
        /// `None`
        pub const INT_P_SIGN_POSN: Option<i64> = None;
        /// `","`
        pub const MON_DECIMAL_POINT: &str = ",";
        /// `&[3, 3]`
        pub const MON_GROUPING: &[i64] = &[3, 3];
        /// `"\u{202f}"`
        pub const MON_THOUSANDS_SEP: &str = "\u{202f}";
        /// `"-"`
        pub const NEGATIVE_SIGN: &str = "-";
        /// `1`
        pub const N_CS_PRECEDES: i64 = 1;
        /// `1`
        pub const N_SEP_BY_SPACE: i64 = 1;
        /// `1`
        pub const N_SIGN_POSN: i64 = 1;
        /// `""`
        pub const POSITIVE_SIGN: &str = "";
        /// `1`
        pub const P_CS_PRECEDES: i64 = 1;
        /// `1`
        pub const P_SEP_BY_SPACE: i64 = 1;
        /// `1`
        pub const P_SIGN_POSN: i64 = 1;
    }
    pub mod LC_NUMERIC {
        /// `","`
        pub const DECIMAL_POINT: &str = ",";
        /// `&[0, 0]`
        pub const GROUPING: &[i64] = &[0, 0];
        /// `""`
        pub const THOUSANDS_SEP: &str = "";
    }
    pub mod LC_TELEPHONE {
        /// `None`
        pub const INT_PREFIX: Option<&str> = None;
        /// `Some("00")`
        pub const INT_SELECT: Option<&str> = Some("00");
        /// `None`
        pub const TEL_DOM_FMT: Option<&str> = None;
        /// `Some("+%c %a%t%l")`
        pub const TEL_INT_FMT: Option<&str> = Some("+%c %a%t%l");
    }
    pub mod LC_TIME {
        /// `&["dim", "lun", "mar", "mer", "ĵaŭ", "ven", "sab"]`
        pub const ABDAY: &[&str] = &["dim", "lun", "mar", "mer", "ĵaŭ", "ven", "sab"];
        /// `&["Jan", "Feb", "Mar", "Apr", "Maj", "Jun", "Jul", "Aŭg", "Sep", "Okt", "Nov", "Dec"]`
        pub const ABMON: &[&str] = &["Jan", "Feb", "Mar", "Apr", "Maj", "Jun", "Jul", "Aŭg", "Sep", "Okt", "Nov", "Dec"];
        /// `None`
        pub const AB_ALT_MON: Option<&[&str]> = None;
        /// `None`
        pub const ALT_DIGITS: Option<&[&str]> = None;
        /// `None`
        pub const ALT_MON: Option<&[&str]> = None;
        /// `&["", ""]`
        pub const AM_PM: &[&str] = &["", ""];
        /// `None`
        pub const CAL_DIRECTION: Option<i64> = None;
        /// `None`
        pub const DATE_FMT: Option<&str> = None;
        /// `&["dimanĉo", "lundo", "mardo", "merkredo", "ĵaŭdo", "vendredo", "sabato"]`
        pub const DAY: &[&str] = &["dimanĉo", "lundo", "mardo", "merkredo", "ĵaŭdo", "vendredo", "sabato"];
        /// `"%Y-%m-%d"`
        pub const D_FMT: &str = "%Y-%m-%d";
        /// `"%a %d %b %Y %T %z"`
        pub const D_T_FMT: &str = "%a %d %b %Y %T %z";
        /// `None`
        pub const ERA: Option<&[&str]> = None;
        /// `None`
        pub const ERA_D_FMT: Option<&str> = None;
        /// `None`
        pub const ERA_D_T_FMT: Option<&str> = None;
        /// `None`
        pub const ERA_T_FMT: Option<&str> = None;
        /// `None`
        pub const FIRST_WEEKDAY: Option<i64> = None;
        /// `None`
        pub const FIRST_WORKDAY: Option<i64> = None;
        /// `&["Januaro", "Februaro", "Marto", "Aprilo", "Majo", "Junio", "Julio", "Aŭgusto", "Septembro", "Oktobro", "Novembro", "Decembro"]`
        pub const MON: &[&str] = &["Januaro", "Februaro", "Marto", "Aprilo", "Majo", "Junio", "Julio", "Aŭgusto", "Septembro", "Oktobro", "Novembro", "Decembro"];
        /// `"%T"`
        pub const T_FMT: &str = "%T";
        /// `""`
        pub const T_FMT_AMPM: &str = "";
        /// `Some(&[7, 19971130, 1])`
        pub const WEEK: Option<&[i64]> = Some(&[7, 19971130, 1]);
    }
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod es_AR {
    pub mod LC_ADDRESS {
        /// `Some("ARG")`
        pub const COUNTRY_AB3: Option<&str> = Some("ARG");
        /// `Some("AR")`
        pub const COUNTRY_ABTWO: Option<&str> = Some("AR");
        /// `Some("RA")`
        pub const COUNTRY_CAR: Option<&str> = Some("RA");
        /// `None`
        pub const COUNTRY_ISBN: Option<&str> = None;
        /// `Some("Argentina")`
        pub const COUNTRY_NAME: Option<&str> = Some("Argentina");
        /// `Some(32)`
        pub const COUNTRY_NUM: Option<i64> = Some(32);
        /// `None`
        pub const COUNTRY_POST: Option<&str> = None;
        /// `Some("es")`
        pub const LANG_AB: Option<&str> = Some("es");
        /// `Some("spa")`
        pub const LANG_LIB: Option<&str> = Some("spa");
        /// `Some("español")`
        pub const LANG_NAME: Option<&str> = Some("español");
        /// `Some("spa")`
        pub const LANG_TERM: Option<&str> = Some("spa");
        /// `Some("%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%c%N")`
        pub const POSTAL_FMT: Option<&str> = Some("%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%c%N");
    }
    pub mod LC_IDENTIFICATION {
        /// `None`
        pub const ABBREVIATION: Option<&str> = None;
        /// `Some("Sankt Jørgens Alle 8, DK-1615 København V, Danmark")`
        pub const ADDRESS: Option<&str> = Some("Sankt Jørgens Alle 8, DK-1615 København V, Danmark");
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        /// ]
        /// ```
        pub const CATEGORY: Option<&[&[&str]]> = Some(&[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_TELEPHONE"],
            &["i18n:2012", "LC_MEASUREMENT"],
        ]);
        /// `Some("")`
        pub const CONTACT: Option<&str> = Some("");
        /// `Some("2000-06-29")`
        pub const DATE: Option<&str> = Some("2000-06-29");
        /// `Some("bug-glibc-locales@gnu.org")`
        pub const EMAIL: Option<&str> = Some("bug-glibc-locales@gnu.org");
        /// `Some("")`
        pub const FAX: Option<&str> = Some("");
        /// `Some("Spanish")`
        pub const LANGUAGE: Option<&str> = Some("Spanish");
        /// `Some("1.0")`
        pub const REVISION: Option<&str> = Some("1.0");
        /// `Some("RAP")`
        pub const SOURCE: Option<&str> = Some("RAP");
        /// `Some("")`
        pub const TEL: Option<&str> = Some("");
        /// `Some("Argentina")`
        pub const TERRITORY: Option<&str> = Some("Argentina");
        /// `Some("Spanish locale for Argentina")`
        pub const TITLE: Option<&str> = Some("Spanish locale for Argentina");
    }
    pub use super::es_ES::LC_MESSAGES;
    pub mod LC_MONETARY {
        /// `"$"`
        pub const CURRENCY_SYMBOL: &str = "$";
        /// `2`
        pub const FRAC_DIGITS: i64 = 2;
        /// `"ARS "`
        pub const INT_CURR_SYMBOL: &str = "ARS ";
        /// `2`
        pub const INT_FRAC_DIGITS: i64 = 2;
        /// `None`
        pub const INT_N_CS_PRECEDES: Option<i64> = None;
        /// `None`
        pub const INT_N_SEP_BY_SPACE: Option<i64> = None;
        /// `None`
        pub const INT_N_SIGN_POSN: Option<i64> = None;
        /// `None`
        pub const INT_P_CS_PRECEDES: Option<i64> = None;
        /// `None`
        pub const INT_P_SEP_BY_SPACE: Option<i64> = None;
        /// `None`
        pub const INT_P_SIGN_POSN: Option<i64> = None;
        /// `","`
        pub const MON_DECIMAL_POINT: &str = ",";
        /// `&[3, 3]`
        pub const MON_GROUPING: &[i64] = &[3, 3];
        /// `"."`
        pub const MON_THOUSANDS_SEP: &str = ".";
        /// `"-"`
        pub const NEGATIVE_SIGN: &str = "-";
        /// `1`
        pub const N_CS_PRECEDES: i64 = 1;
        /// `1`
        pub const N_SEP_BY_SPACE: i64 = 1;
        /// `1`
        pub const N_SIGN_POSN: i64 = 1;
        /// `""`
        pub const POSITIVE_SIGN: &str = "";
        /// `1`
        pub const P_CS_PRECEDES: i64 = 1;
        /// `1`
        pub const P_SEP_BY_SPACE: i64 = 1;
        /// `1`
        pub const P_SIGN_POSN: i64 = 1;
    }
    pub mod LC_NUMERIC {
        /// `","`
        pub const DECIMAL_POINT: &str = ",";
        /// `&[3, 3]`
        pub const GROUPING: &[i64] = &[3, 3];
        /// `"."`
        pub const THOUSANDS_SEP: &str = ".";
    }
    pub mod LC_TELEPHONE {
        /// `Some("54")`
        pub const INT_PREFIX: Option<&str> = Some("54");
        /// `Some("00")`
        pub const INT_SELECT: Option<&str> = Some("00");
        /// `None`
        pub const TEL_DOM_FMT: Option<&str> = None;
        /// `Some("+%c %a %l")`
        pub const TEL_INT_FMT: Option<&str> = Some("+%c %a %l");
    }
    pub mod LC_TIME {
        /// `&["dom", "lun", "mar", "mié", "jue", "vie", "sáb"]`
        pub const ABDAY: &[&str] = &["dom", "lun", "mar", "mié", "jue", "vie", "sáb"];
        /// `&["ene", "feb", "mar", "abr", "may", "jun", "jul", "ago", "sep", "oct", "nov", "dic"]`
        pub const ABMON: &[&str] = &["ene", "feb", "mar", "abr", "may", "jun", "jul", "ago", "sep", "oct", "nov", "dic"];
        /// `None`
        pub const AB_ALT_MON: Option<&[&str]> = None;
        /// `None`
        pub const ALT_DIGITS: Option<&[&str]> = None;
        /// `None`
        pub const ALT_MON: Option<&[&str]> = None;
        /// `&["", ""]`
        pub const AM_PM: &[&str] = &["", ""];
        /// `None`
        pub const CAL_DIRECTION: Option<i64> = None;
        /// `None`
        pub const DATE_FMT: Option<&str> = None;
        /// `&["domingo", "lunes", "martes", "miércoles", "jueves", "viernes", "sábado"]`
        pub const DAY: &[&str] = &["domingo", "lunes", "martes", "miércoles", "jueves", "viernes", "sábado"];
        /// `"%d/%m/%y"`
        pub const D_FMT: &str = "%d/%m/%y";
        /// `"%a %d %b %Y %T %Z"`
        pub const D_T_FMT: &str = "%a %d %b %Y %T %Z";
        /// `None`
        pub const ERA: Option<&[&str]> = None;
        /// `None`
        pub const ERA_D_FMT: Option<&str> = None;
        /// `None`
        pub const ERA_D_T_FMT: Option<&str> = None;
        /// `None`
        pub const ERA_T_FMT: Option<&str> = None;
        /// `None`
        pub const FIRST_WEEKDAY: Option<i64> = None;
        /// `None`
        pub const FIRST_WORKDAY: Option<i64> = None;
        /// `&["enero", "febrero", "marzo", "abril", "mayo", "junio", "julio", "agosto", "septiembre", "octubre", "noviembre", "diciembre"]`
        pub const MON: &[&str] = &["enero", "febrero", "marzo", "abril", "mayo", "junio", "julio", "agosto", "septiembre", "octubre", "noviembre", "diciembre"];
        /// `"%T"`
        pub const T_FMT: &str = "%T";
        /// `""`
        pub const T_FMT_AMPM: &str = "";
        /// `Some(&[7, 19971130, 1])`
        pub const WEEK: Option<&[i64]> = Some(&[7, 19971130, 1]);
    }
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod es_BO {
    pub mod LC_ADDRESS {
        /// `Some("BOL")`
        pub const COUNTRY_AB3: Option<&str> = Some("BOL");
        /// `Some("BO")`
        pub const COUNTRY_ABTWO: Option<&str> = Some("BO");
        /// `Some("BOL")`
        pub const COUNTRY_CAR: Option<&str> = Some("BOL");
        /// `None`
        pub const COUNTRY_ISBN: Option<&str> = None;
        /// `Some("Bolivia")`
        pub const COUNTRY_NAME: Option<&str> = Some("Bolivia");
        /// `Some(68)`
        pub const COUNTRY_NUM: Option<i64> = Some(68);
        /// `None`
        pub const COUNTRY_POST: Option<&str> = None;
        /// `Some("es")`
        pub const LANG_AB: Option<&str> = Some("es");
        /// `Some("spa")`
        pub const LANG_LIB: Option<&str> = Some("spa");
        /// `Some("español")`
        pub const LANG_NAME: Option<&str> = Some("español");
        /// `Some("spa")`
        pub const LANG_TERM: Option<&str> = Some("spa");
        /// `Some("%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%c%N")`
        pub const POSTAL_FMT: Option<&str> = Some("%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%c%N");
    }
    pub mod LC_IDENTIFICATION {
        /// `None`
        pub const ABBREVIATION: Option<&str> = None;
        /// `Some("Sankt Jørgens Alle 8, DK-1615 København V, Danmark")`
        pub const ADDRESS: Option<&str> = Some("Sankt Jørgens Alle 8, DK-1615 København V, Danmark");
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        /// ]
        /// ```
        pub const CATEGORY: Option<&[&[&str]]> = Some(&[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_TELEPHONE"],
            &["i18n:2012", "LC_MEASUREMENT"],
        ]);
        /// `Some("")`
        pub const CONTACT: Option<&str> = Some("");
        /// `Some("2000-06-29")`
        pub const DATE: Option<&str> = Some("2000-06-29");
        /// `Some("bug-glibc-locales@gnu.org")`
        pub const EMAIL: Option<&str> = Some("bug-glibc-locales@gnu.org");
        /// `Some("")`
        pub const FAX: Option<&str> = Some("");
        /// `Some("Spanish")`
        pub const LANGUAGE: Option<&str> = Some("Spanish");
        /// `Some("1.0")`
        pub const REVISION: Option<&str> = Some("1.0");
        /// `Some("RAP")`
        pub const SOURCE: Option<&str> = Some("RAP");
        /// `Some("")`
        pub const TEL: Option<&str> = Some("");
        /// `Some("Bolivia")`
        pub const TERRITORY: Option<&str> = Some("Bolivia");
        /// `Some("Spanish locale for Bolivia")`
        pub const TITLE: Option<&str> = Some("Spanish locale for Bolivia");
    }
    pub use super::es_ES::LC_MESSAGES;
    pub mod LC_MONETARY {
        /// `"Bs"`
        pub const CURRENCY_SYMBOL: &str = "Bs";
        /// `2`
        pub const FRAC_DIGITS: i64 = 2;
        /// `"BOB "`
        pub const INT_CURR_SYMBOL: &str = "BOB ";
        /// `2`
        pub const INT_FRAC_DIGITS: i64 = 2;
        /// `None`
        pub const INT_N_CS_PRECEDES: Option<i64> = None;
        /// `None`
        pub const INT_N_SEP_BY_SPACE: Option<i64> = None;
        /// `None`
        pub const INT_N_SIGN_POSN: Option<i64> = None;
        /// `None`
        pub const INT_P_CS_PRECEDES: Option<i64> = None;
        /// `None`
        pub const INT_P_SEP_BY_SPACE: Option<i64> = None;
        /// `None`
        pub const INT_P_SIGN_POSN: Option<i64> = None;
        /// `","`
        pub const MON_DECIMAL_POINT: &str = ",";
        /// `&[3, 3]`
        pub const MON_GROUPING: &[i64] = &[3, 3];
        /// `"."`
        pub const MON_THOUSANDS_SEP: &str = ".";
        /// `"-"`
        pub const NEGATIVE_SIGN: &str = "-";
        /// `1`
        pub const N_CS_PRECEDES: i64 = 1;
        /// `1`
        pub const N_SEP_BY_SPACE: i64 = 1;
        /// `1`
        pub const N_SIGN_POSN: i64 = 1;
        /// `""`
        pub const POSITIVE_SIGN: &str = "";
        /// `1`
        pub const P_CS_PRECEDES: i64 = 1;
        /// `1`
        pub const P_SEP_BY_SPACE: i64 = 1;
        /// `1`
        pub const P_SIGN_POSN: i64 = 1;
    }
    pub use super::es_ES::LC_NUMERIC;
    pub mod LC_TELEPHONE {
        /// `Some("591")`
        pub const INT_PREFIX: Option<&str> = Some("591");
        /// `Some("00")`
        pub const INT_SELECT: Option<&str> = Some("00");
        /// `None`
        pub const TEL_DOM_FMT: Option<&str> = None;
        /// `Some("+%c %a %l")`
        pub const TEL_INT_FMT: Option<&str> = Some("+%c %a %l");
    }
    pub mod LC_TIME {
        /// `&["dom", "lun", "mar", "mié", "jue", "vie", "sáb"]`
        pub const ABDAY: &[&str] = &["dom", "lun", "mar", "mié", "jue", "vie", "sáb"];
        /// `&["ene", "feb", "mar", "abr", "may", "jun", "jul", "ago", "sep", "oct", "nov", "dic"]`
        pub const ABMON: &[&str] = &["ene", "feb", "mar", "abr", "may", "jun", "jul", "ago", "sep", "oct", "nov", "dic"];
        /// `None`
        pub const AB_ALT_MON: Option<&[&str]> = None;
        /// `None`
        pub const ALT_DIGITS: Option<&[&str]> = None;
        /// `None`
        pub const ALT_MON: Option<&[&str]> = None;
        /// `&["", ""]`
        pub const AM_PM: &[&str] = &["", ""];
        /// `None`
        pub const CAL_DIRECTION: Option<i64> = None;
        /// `None`
        pub const DATE_FMT: Option<&str> = None;
        /// `&["domingo", "lunes", "martes", "miércoles", "jueves", "viernes", "sábado"]`
        pub const DAY: &[&str] = &["domingo", "lunes", "martes", "miércoles", "jueves", "viernes", "sábado"];
        /// `"%d/%m/%y"`
        pub const D_FMT: &str = "%d/%m/%y";
        /// `"%a %d %b %Y %T %Z"`
        pub const D_T_FMT: &str = "%a %d %b %Y %T %Z";
        /// `None`
        pub const ERA: Option<&[&str]> = None;
        /// `None`
        pub const ERA_D_FMT: Option<&str> = None;
        /// `None`
        pub const ERA_D_T_FMT: Option<&str> = None;
        /// `None`
        pub const ERA_T_FMT: Option<&str> = None;
        /// `Some(2)`
        pub const FIRST_WEEKDAY: Option<i64> = Some(2);
        /// `None`
        pub const FIRST_WORKDAY: Option<i64> = None;
        /// `&["enero", "febrero", "marzo", "abril", "mayo", "junio", "julio", "agosto", "septiembre", "octubre", "noviembre", "diciembre"]`
        pub const MON: &[&str] = &["enero", "febrero", "marzo", "abril", "mayo", "junio", "julio", "agosto", "septiembre", "octubre", "noviembre", "diciembre"];
        /// `"%T"`
        pub const T_FMT: &str = "%T";
        /// `""`
        pub const T_FMT_AMPM: &str = "";
        /// `Some(&[7, 19971130, 1])`
        pub const WEEK: Option<&[i64]> = Some(&[7, 19971130, 1]);
    }
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod es_CL {
    pub mod LC_ADDRESS {
        /// `Some("CHL")`
        pub const COUNTRY_AB3: Option<&str> = Some("CHL");
        /// `Some("CL")`
        pub const COUNTRY_ABTWO: Option<&str> = Some("CL");
        /// `Some("RCH")`
        pub const COUNTRY_CAR: Option<&str> = Some("RCH");
        /// `None`
        pub const COUNTRY_ISBN: Option<&str> = None;
        /// `Some("Chile")`
        pub const COUNTRY_NAME: Option<&str> = Some("Chile");
        /// `Some(152)`
        pub const COUNTRY_NUM: Option<i64> = Some(152);
        /// `None`
        pub const COUNTRY_POST: Option<&str> = None;
        /// `Some("es")`
        pub const LANG_AB: Option<&str> = Some("es");
        /// `Some("spa")`
        pub const LANG_LIB: Option<&str> = Some("spa");
        /// `Some("español")`
        pub const LANG_NAME: Option<&str> = Some("español");
        /// `Some("spa")`
        pub const LANG_TERM: Option<&str> = Some("spa");
        /// `Some("%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%c%N")`
        pub const POSTAL_FMT: Option<&str> = Some("%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%c%N");
    }
    pub mod LC_IDENTIFICATION {
        /// `None`
        pub const ABBREVIATION: Option<&str> = None;
        /// `Some("Sankt Jørgens Alle 8, DK-1615 København V, Danmark")`
        pub const ADDRESS: Option<&str> = Some("Sankt Jørgens Alle 8, DK-1615 København V, Danmark");
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        /// ]
        /// ```
        pub const CATEGORY: Option<&[&[&str]]> = Some(&[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_TELEPHONE"],
            &["i18n:2012", "LC_MEASUREMENT"],
        ]);
        /// `Some("")`
        pub const CONTACT: Option<&str> = Some("");
        /// `Some("2000-06-29")`
        pub const DATE: Option<&str> = Some("2000-06-29");
        /// `Some("bug-glibc-locales@gnu.org")`
        pub const EMAIL: Option<&str> = Some("bug-glibc-locales@gnu.org");
        /// `Some("")`
        pub const FAX: Option<&str> = Some("");
        /// `Some("Spanish")`
        pub const LANGUAGE: Option<&str> = Some("Spanish");
        /// `Some("1.0")`
        pub const REVISION: Option<&str> = Some("1.0");
        /// `Some("RAP")`
        pub const SOURCE: Option<&str> = Some("RAP");
        /// `Some("")`
        pub const TEL: Option<&str> = Some("");
        /// `Some("Chile")`
        pub const TERRITORY: Option<&str> = Some("Chile");
        /// `Some("Spanish locale for Chile")`
        pub const TITLE: Option<&str> = Some("Spanish locale for Chile");
    }
    pub use super::es_ES::LC_MESSAGES;
    pub mod LC_MONETARY {
        /// `"$"`
        pub const CURRENCY_SYMBOL: &str = "$";
        /// `2`
        pub const FRAC_DIGITS: i64 = 2;
        /// `"CLP "`
        pub const INT_CURR_SYMBOL: &str = "CLP ";
        /// `2`
        pub const INT_FRAC_DIGITS: i64 = 2;
        /// `None`
        pub const INT_N_CS_PRECEDES: Option<i64> = None;
        /// `None`
        pub const INT_N_SEP_BY_SPACE: Option<i64> = None;
        /// `None`
        pub const INT_N_SIGN_POSN: Option<i64> = None;
        /// `None`
        pub const INT_P_CS_PRECEDES: Option<i64> = None;
        /// `None`
        pub const INT_P_SEP_BY_SPACE: Option<i64> = None;
        /// `None`
        pub const INT_P_SIGN_POSN: Option<i64> = None;
        /// `","`
        pub const MON_DECIMAL_POINT: &str = ",";
        /// `&[3, 3]`
        pub const MON_GROUPING: &[i64] = &[3, 3];
        /// `"."`
        pub const MON_THOUSANDS_SEP: &str = ".";
        /// `"-"`
        pub const NEGATIVE_SIGN: &str = "-";
        /// `1`
        pub const N_CS_PRECEDES: i64 = 1;
        /// `1`
        pub const N_SEP_BY_SPACE: i64 = 1;
        /// `1`
        pub const N_SIGN_POSN: i64 = 1;
        /// `""`
        pub const POSITIVE_SIGN: &str = "";
        /// `1`
        pub const P_CS_PRECEDES: i64 = 1;
        /// `1`
        pub const P_SEP_BY_SPACE: i64 = 1;
        /// `1`
        pub const P_SIGN_POSN: i64 = 1;
    }
    pub use super::es_ES::LC_NUMERIC;
    pub mod LC_TELEPHONE {
        /// `Some("56")`
        pub const INT_PREFIX: Option<&str> = Some("56");
        /// `Some("00")`
        pub const INT_SELECT: Option<&str> = Some("00");
        /// `None`
        pub const TEL_DOM_FMT: Option<&str> = None;
        /// `Some("+%c %a %l")`
        pub const TEL_INT_FMT: Option<&str> = Some("+%c %a %l");
    }
    pub use super::es_BO::LC_TIME;
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod es_CO {
    pub mod LC_ADDRESS {
        /// `Some("COL")`
        pub const COUNTRY_AB3: Option<&str> = Some("COL");
        /// `Some("CO")`
        pub const COUNTRY_ABTWO: Option<&str> = Some("CO");
        /// `Some("CO")`
        pub const COUNTRY_CAR: Option<&str> = Some("CO");
        /// `None`
        pub const COUNTRY_ISBN: Option<&str> = None;
        /// `Some("Colombia")`
        pub const COUNTRY_NAME: Option<&str> = Some("Colombia");
        /// `Some(170)`
        pub const COUNTRY_NUM: Option<i64> = Some(170);
        /// `None`
        pub const COUNTRY_POST: Option<&str> = None;
        /// `Some("es")`
        pub const LANG_AB: Option<&str> = Some("es");
        /// `Some("spa")`
        pub const LANG_LIB: Option<&str> = Some("spa");
        /// `Some("español")`
        pub const LANG_NAME: Option<&str> = Some("español");
        /// `Some("spa")`
        pub const LANG_TERM: Option<&str> = Some("spa");
        /// `Some("%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%c%N")`
        pub const POSTAL_FMT: Option<&str> = Some("%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%c%N");
    }
    pub mod LC_IDENTIFICATION {
        /// `None`
        pub const ABBREVIATION: Option<&str> = None;
        /// `Some("Sankt Jørgens Alle 8, DK-1615 København V, Danmark")`
        pub const ADDRESS: Option<&str> = Some("Sankt Jørgens Alle 8, DK-1615 København V, Danmark");
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        /// ]
        /// ```
        pub const CATEGORY: Option<&[&[&str]]> = Some(&[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_TELEPHONE"],
            &["i18n:2012", "LC_MEASUREMENT"],
        ]);
        /// `Some("")`
        pub const CONTACT: Option<&str> = Some("");
        /// `Some("2000-06-29")`
        pub const DATE: Option<&str> = Some("2000-06-29");
        /// `Some("bug-glibc-locales@gnu.org")`
        pub const EMAIL: Option<&str> = Some("bug-glibc-locales@gnu.org");
        /// `Some("")`
        pub const FAX: Option<&str> = Some("");
        /// `Some("Spanish")`
        pub const LANGUAGE: Option<&str> = Some("Spanish");
        /// `Some("1.0")`
        pub const REVISION: Option<&str> = Some("1.0");
        /// `Some("RAP")`
        pub const SOURCE: Option<&str> = Some("RAP");
        /// `Some("")`
        pub const TEL: Option<&str> = Some("");
        /// `Some("Colombia")`
        pub const TERRITORY: Option<&str> = Some("Colombia");
        /// `Some("Spanish locale for Colombia")`
        pub const TITLE: Option<&str> = Some("Spanish locale for Colombia");
    }
    pub use super::es_ES::LC_MESSAGES;
    pub mod LC_MONETARY {
        /// `"$"`
        pub const CURRENCY_SYMBOL: &str = "$";
        /// `2`
        pub const FRAC_DIGITS: i64 = 2;
        /// `"COP "`
        pub const INT_CURR_SYMBOL: &str = "COP ";
        /// `2`
        pub const INT_FRAC_DIGITS: i64 = 2;
        /// `None`
        pub const INT_N_CS_PRECEDES: Option<i64> = None;
        /// `None`
        pub const INT_N_SEP_BY_SPACE: Option<i64> = None;
        /// `None`
        pub const INT_N_SIGN_POSN: Option<i64> = None;
        /// `None`
        pub const INT_P_CS_PRECEDES: Option<i64> = None;
        /// `None`
        pub const INT_P_SEP_BY_SPACE: Option<i64> = None;
        /// `None`
        pub const INT_P_SIGN_POSN: Option<i64> = None;
        /// `","`
        pub const MON_DECIMAL_POINT: &str = ",";
        /// `&[3, 3]`
        pub const MON_GROUPING: &[i64] = &[3, 3];
        /// `"."`
        pub const MON_THOUSANDS_SEP: &str = ".";
        /// `"-"`
        pub const NEGATIVE_SIGN: &str = "-";
        /// `1`
        pub const N_CS_PRECEDES: i64 = 1;
        /// `1`
        pub const N_SEP_BY_SPACE: i64 = 1;
        /// `1`
        pub const N_SIGN_POSN: i64 = 1;
        /// `""`
        pub const POSITIVE_SIGN: &str = "";
        /// `1`
        pub const P_CS_PRECEDES: i64 = 1;
        /// `1`
        pub const P_SEP_BY_SPACE: i64 = 1;
        /// `1`
        pub const P_SIGN_POSN: i64 = 1;
    }
    pub use super::es_ES::LC_NUMERIC;
    pub mod LC_TELEPHONE {
        /// `Some("57")`
        pub const INT_PREFIX: Option<&str> = Some("57");
        /// `Some("009")`
        pub const INT_SELECT: Option<&str> = Some("009");
        /// `None`
        pub const TEL_DOM_FMT: Option<&str> = None;
        /// `Some("+%c %a %l")`
        pub const TEL_INT_FMT: Option<&str> = Some("+%c %a %l");
    }
    pub mod LC_TIME {
        /// `&["dom", "lun", "mar", "mié", "jue", "vie", "sáb"]`
        pub const ABDAY: &[&str] = &["dom", "lun", "mar", "mié", "jue", "vie", "sáb"];
        /// `&["ene", "feb", "mar", "abr", "may", "jun", "jul", "ago", "sep", "oct", "nov", "dic"]`
        pub const ABMON: &[&str] = &["ene", "feb", "mar", "abr", "may", "jun", "jul", "ago", "sep", "oct", "nov", "dic"];
        /// `None`
        pub const AB_ALT_MON: Option<&[&str]> = None;
        /// `None`
        pub const ALT_DIGITS: Option<&[&str]> = None;
        /// `None`
        pub const ALT_MON: Option<&[&str]> = None;
        /// `&["AM", "PM"]`
        pub const AM_PM: &[&str] = &["AM", "PM"];
        /// `None`
        pub const CAL_DIRECTION: Option<i64> = None;
        /// `None`
        pub const DATE_FMT: Option<&str> = None;
        /// `&["domingo", "lunes", "martes", "miércoles", "jueves", "viernes", "sábado"]`
        pub const DAY: &[&str] = &["domingo", "lunes", "martes", "miércoles", "jueves", "viernes", "sábado"];
        /// `"%d/%m/%y"`
        pub const D_FMT: &str = "%d/%m/%y";
        /// `"%a %d %b %Y %T %Z"`
        pub const D_T_FMT: &str = "%a %d %b %Y %T %Z";
        /// `None`
        pub const ERA: Option<&[&str]> = None;
        /// `None`
        pub const ERA_D_FMT: Option<&str> = None;
        /// `None`
        pub const ERA_D_T_FMT: Option<&str> = None;
        /// `None`
        pub const ERA_T_FMT: Option<&str> = None;
        /// `None`
        pub const FIRST_WEEKDAY: Option<i64> = None;
        /// `None`
        pub const FIRST_WORKDAY: Option<i64> = None;
        /// `&["enero", "febrero", "marzo", "abril", "mayo", "junio", "julio", "agosto", "septiembre", "octubre", "noviembre", "diciembre"]`
        pub const MON: &[&str] = &["enero", "febrero", "marzo", "abril", "mayo", "junio", "julio", "agosto", "septiembre", "octubre", "noviembre", "diciembre"];
        /// `"%T"`
        pub const T_FMT: &str = "%T";
        /// `"%I:%M:%S %p"`
        pub const T_FMT_AMPM: &str = "%I:%M:%S %p";
        /// `Some(&[7, 19971130, 1])`
        pub const WEEK: Option<&[i64]> = Some(&[7, 19971130, 1]);
    }
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod es_CR {
    pub mod LC_ADDRESS {
        /// `Some("CRI")`
        pub const COUNTRY_AB3: Option<&str> = Some("CRI");
        /// `Some("CR")`
        pub const COUNTRY_ABTWO: Option<&str> = Some("CR");
        /// `Some("CR")`
        pub const COUNTRY_CAR: Option<&str> = Some("CR");
        /// `Some("9930,9977,9968")`
        pub const COUNTRY_ISBN: Option<&str> = Some("9930,9977,9968");
        /// `Some("Costa Rica")`
        pub const COUNTRY_NAME: Option<&str> = Some("Costa Rica");
        /// `Some(188)`
        pub const COUNTRY_NUM: Option<i64> = Some(188);
        /// `Some("CR")`
        pub const COUNTRY_POST: Option<&str> = Some("CR");
        /// `Some("es")`
        pub const LANG_AB: Option<&str> = Some("es");
        /// `Some("spa")`
        pub const LANG_LIB: Option<&str> = Some("spa");
        /// `Some("español")`
        pub const LANG_NAME: Option<&str> = Some("español");
        /// `Some("spa")`
        pub const LANG_TERM: Option<&str> = Some("spa");
        /// `Some("%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%c%N")`
        pub const POSTAL_FMT: Option<&str> = Some("%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%c%N");
    }
    pub mod LC_IDENTIFICATION {
        /// `None`
        pub const ABBREVIATION: Option<&str> = None;
        /// `Some("https://www.gnu.org/software/libc/")`
        pub const ADDRESS: Option<&str> = Some("https://www.gnu.org/software/libc/");
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        /// ]
        /// ```
        pub const CATEGORY: Option<&[&[&str]]> = Some(&[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_TELEPHONE"],
            &["i18n:2012", "LC_MEASUREMENT"],
        ]);
        /// `Some("")`
        pub const CONTACT: Option<&str> = Some("");
        /// `Some("2009-12-23")`
        pub const DATE: Option<&str> = Some("2009-12-23");
        /// `Some("bug-glibc-locales@gnu.org")`
        pub const EMAIL: Option<&str> = Some("bug-glibc-locales@gnu.org");
        /// `Some("")`
        pub const FAX: Option<&str> = Some("");
        /// `Some("Spanish")`
        pub const LANGUAGE: Option<&str> = Some("Spanish");
        /// `Some("1.1")`
        pub const REVISION: Option<&str> = Some("1.1");
        /// `Some("Free Software Foundation, Inc.")`
        pub const SOURCE: Option<&str> = Some("Free Software Foundation, Inc.");
        /// `Some("")`
        pub const TEL: Option<&str> = Some("");
        /// `Some("Costa Rica")`
        pub const TERRITORY: Option<&str> = Some("Costa Rica");
        /// `Some("Spanish locale for Costa Rica")`
        pub const TITLE: Option<&str> = Some("Spanish locale for Costa Rica");
    }
    pub use super::es_ES::LC_MESSAGES;
    pub mod LC_MONETARY {
        /// `"₡"`
        pub const CURRENCY_SYMBOL: &str = "₡";
        /// `2`
        pub const FRAC_DIGITS: i64 = 2;
        /// `"CRC "`
        pub const INT_CURR_SYMBOL: &str = "CRC ";
        /// `2`
        pub const INT_FRAC_DIGITS: i64 = 2;
        /// `None`
        pub const INT_N_CS_PRECEDES: Option<i64> = None;
        /// `None`
        pub const INT_N_SEP_BY_SPACE: Option<i64> = None;
        /// `None`
        pub const INT_N_SIGN_POSN: Option<i64> = None;
        /// `None`
        pub const INT_P_CS_PRECEDES: Option<i64> = None;
        /// `None`
        pub const INT_P_SEP_BY_SPACE: Option<i64> = None;
        /// `None`
        pub const INT_P_SIGN_POSN: Option<i64> = None;
        /// `","`
        pub const MON_DECIMAL_POINT: &str = ",";
        /// `&[3, 3]`
        pub const MON_GROUPING: &[i64] = &[3, 3];
        /// `"\u{202f}"`
        pub const MON_THOUSANDS_SEP: &str = "\u{202f}";
        /// `"-"`
        pub const NEGATIVE_SIGN: &str = "-";
        /// `1`
        pub const N_CS_PRECEDES: i64 = 1;
        /// `1`
        pub const N_SEP_BY_SPACE: i64 = 1;
        /// `1`
        pub const N_SIGN_POSN: i64 = 1;
        /// `""`
        pub const POSITIVE_SIGN: &str = "";
        /// `1`
        pub const P_CS_PRECEDES: i64 = 1;
        /// `1`
        pub const P_SEP_BY_SPACE: i64 = 1;
        /// `1`
        pub const P_SIGN_POSN: i64 = 1;
    }
    pub mod LC_NUMERIC {
        /// `","`
        pub const DECIMAL_POINT: &str = ",";
        /// `&[3, 3]`
        pub const GROUPING: &[i64] = &[3, 3];
        /// `"\u{202f}"`
        pub const THOUSANDS_SEP: &str = "\u{202f}";
    }
    pub mod LC_TELEPHONE {
        /// `Some("506")`
        pub const INT_PREFIX: Option<&str> = Some("506");
        /// `Some("00")`
        pub const INT_SELECT: Option<&str> = Some("00");
        /// `Some("%l")`
        pub const TEL_DOM_FMT: Option<&str> = Some("%l");
        /// `Some("+%c %a %l")`
        pub const TEL_INT_FMT: Option<&str> = Some("+%c %a %l");
    }
    pub mod LC_TIME {
        /// `&["dom", "lun", "mar", "mié", "jue", "vie", "sáb"]`
        pub const ABDAY: &[&str] = &["dom", "lun", "mar", "mié", "jue", "vie", "sáb"];
        /// `&["ene", "feb", "mar", "abr", "may", "jun", "jul", "ago", "sep", "oct", "nov", "dic"]`
        pub const ABMON: &[&str] = &["ene", "feb", "mar", "abr", "may", "jun", "jul", "ago", "sep", "oct", "nov", "dic"];
        /// `None`
        pub const AB_ALT_MON: Option<&[&str]> = None;
        /// `None`
        pub const ALT_DIGITS: Option<&[&str]> = None;
        /// `None`
        pub const ALT_MON: Option<&[&str]> = None;
        /// `&["a.m.", "p.m."]`
        pub const AM_PM: &[&str] = &["a.m.", "p.m."];
        /// `None`
        pub const CAL_DIRECTION: Option<i64> = None;
        /// `Some("%a %e %b %H:%M:%S %Z %Y")`
        pub const DATE_FMT: Option<&str> = Some("%a %e %b %H:%M:%S %Z %Y");
        /// `&["domingo", "lunes", "martes", "miércoles", "jueves", "viernes", "sábado"]`
        pub const DAY: &[&str] = &["domingo", "lunes", "martes", "miércoles", "jueves", "viernes", "sábado"];
        /// `"%d/%m/%Y"`
        pub const D_FMT: &str = "%d/%m/%Y";
        /// `"%a %d %b %Y %T %Z"`
        pub const D_T_FMT: &str = "%a %d %b %Y %T %Z";
        /// `None`
        pub const ERA: Option<&[&str]> = None;
        /// `None`
        pub const ERA_D_FMT: Option<&str> = None;
        /// `None`
        pub const ERA_D_T_FMT: Option<&str> = None;
        /// `None`
        pub const ERA_T_FMT: Option<&str> = None;
        /// `Some(2)`
        pub const FIRST_WEEKDAY: Option<i64> = Some(2);
        /// `None`
        pub const FIRST_WORKDAY: Option<i64> = None;
        /// `&["enero", "febrero", "marzo", "abril", "mayo", "junio", "julio", "agosto", "septiembre", "octubre", "noviembre", "diciembre"]`
        pub const MON: &[&str] = &["enero", "febrero", "marzo", "abril", "mayo", "junio", "julio", "agosto", "septiembre", "octubre", "noviembre", "diciembre"];
        /// `"%T"`
        pub const T_FMT: &str = "%T";
        /// `"%I:%M:%S %p"`
        pub const T_FMT_AMPM: &str = "%I:%M:%S %p";
        /// `Some(&[7, 19971130, 1])`
        pub const WEEK: Option<&[i64]> = Some(&[7, 19971130, 1]);
    }
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod es_CU {
    pub mod LC_ADDRESS {
        /// `Some("CUB")`
        pub const COUNTRY_AB3: Option<&str> = Some("CUB");
        /// `Some("CU")`
        pub const COUNTRY_ABTWO: Option<&str> = Some("CU");
        /// `Some("C")`
        pub const COUNTRY_CAR: Option<&str> = Some("C");
        /// `None`
        pub const COUNTRY_ISBN: Option<&str> = None;
        /// `Some("Cuba")`
        pub const COUNTRY_NAME: Option<&str> = Some("Cuba");
        /// `Some(192)`
        pub const COUNTRY_NUM: Option<i64> = Some(192);
        /// `None`
        pub const COUNTRY_POST: Option<&str> = None;
        /// `Some("es")`
        pub const LANG_AB: Option<&str> = Some("es");
        /// `Some("spa")`
        pub const LANG_LIB: Option<&str> = Some("spa");
        /// `Some("español")`
        pub const LANG_NAME: Option<&str> = Some("español");
        /// `Some("spa")`
        pub const LANG_TERM: Option<&str> = Some("spa");
        /// `Some("%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%c%N")`
        pub const POSTAL_FMT: Option<&str> = Some("%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%c%N");
    }
    pub mod LC_IDENTIFICATION {
        /// `None`
        pub const ABBREVIATION: Option<&str> = None;
        /// `Some("San Antonio de los Baøos Highway, Kilometer 1 1/2, University of Informatic Sciences ")`
        pub const ADDRESS: Option<&str> = Some("San Antonio de los Baøos Highway, Kilometer 1 1/2, University of Informatic Sciences ");
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        /// ]
        /// ```
        pub const CATEGORY: Option<&[&[&str]]> = Some(&[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_TELEPHONE"],
            &["i18n:2012", "LC_MEASUREMENT"],
        ]);
        /// `Some("")`
        pub const CONTACT: Option<&str> = Some("");
        /// `Some("2011-10-19")`
        pub const DATE: Option<&str> = Some("2011-10-19");
        /// `Some("bug-glibc-locales@gnu.org")`
        pub const EMAIL: Option<&str> = Some("bug-glibc-locales@gnu.org");
        /// `Some("")`
        pub const FAX: Option<&str> = Some("");
        /// `Some("Spanish")`
        pub const LANGUAGE: Option<&str> = Some("Spanish");
        /// `Some("0.1")`
        pub const REVISION: Option<&str> = Some("0.1");
        /// `Some("")`
        pub const SOURCE: Option<&str> = Some("");
        /// `Some("")`
        pub const TEL: Option<&str> = Some("");
        /// `Some("Cuba")`
        pub const TERRITORY: Option<&str> = Some("Cuba");
        /// `Some("Spanish locale for Cuba")`
        pub const TITLE: Option<&str> = Some("Spanish locale for Cuba");
    }
    pub use super::es_ES::LC_MESSAGES;
    pub mod LC_MONETARY {
        /// `"$"`
        pub const CURRENCY_SYMBOL: &str = "$";
        /// `2`
        pub const FRAC_DIGITS: i64 = 2;
        /// `"CUP "`
        pub const INT_CURR_SYMBOL: &str = "CUP ";
        /// `2`
        pub const INT_FRAC_DIGITS: i64 = 2;
        /// `None`
        pub const INT_N_CS_PRECEDES: Option<i64> = None;
        /// `None`
        pub const INT_N_SEP_BY_SPACE: Option<i64> = None;
        /// `None`
        pub const INT_N_SIGN_POSN: Option<i64> = None;
        /// `None`
        pub const INT_P_CS_PRECEDES: Option<i64> = None;
        /// `None`
        pub const INT_P_SEP_BY_SPACE: Option<i64> = None;
        /// `None`
        pub const INT_P_SIGN_POSN: Option<i64> = None;
        /// `","`
        pub const MON_DECIMAL_POINT: &str = ",";
        /// `&[3, 3]`
        pub const MON_GROUPING: &[i64] = &[3, 3];
        /// `"."`
        pub const MON_THOUSANDS_SEP: &str = ".";
        /// `"-"`
        pub const NEGATIVE_SIGN: &str = "-";
        /// `0`
        pub const N_CS_PRECEDES: i64 = 0;
        /// `1`
        pub const N_SEP_BY_SPACE: i64 = 1;
        /// `1`
        pub const N_SIGN_POSN: i64 = 1;
        /// `""`
        pub const POSITIVE_SIGN: &str = "";
        /// `0`
        pub const P_CS_PRECEDES: i64 = 0;
        /// `1`
        pub const P_SEP_BY_SPACE: i64 = 1;
        /// `1`
        pub const P_SIGN_POSN: i64 = 1;
    }
    pub mod LC_NUMERIC {
        /// `","`
        pub const DECIMAL_POINT: &str = ",";
        /// `&[0, 0]`
        pub const GROUPING: &[i64] = &[0, 0];
        /// `"."`
        pub const THOUSANDS_SEP: &str = ".";
    }
    pub mod LC_TELEPHONE {
        /// `Some("53")`
        pub const INT_PREFIX: Option<&str> = Some("53");
        /// `Some("119")`
        pub const INT_SELECT: Option<&str> = Some("119");
        /// `None`
        pub const TEL_DOM_FMT: Option<&str> = None;
        /// `Some("+%c %a %l")`
        pub const TEL_INT_FMT: Option<&str> = Some("+%c %a %l");
    }
    pub use super::es_BO::LC_TIME;
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod es_DO {
    pub mod LC_ADDRESS {
        /// `Some("DOM")`
        pub const COUNTRY_AB3: Option<&str> = Some("DOM");
        /// `Some("DO")`
        pub const COUNTRY_ABTWO: Option<&str> = Some("DO");
        /// `Some("DOM")`
        pub const COUNTRY_CAR: Option<&str> = Some("DOM");
        /// `None`
        pub const COUNTRY_ISBN: Option<&str> = None;
        /// `Some("República Dominicana")`
        pub const COUNTRY_NAME: Option<&str> = Some("República Dominicana");
        /// `Some(214)`
        pub const COUNTRY_NUM: Option<i64> = Some(214);
        /// `None`
        pub const COUNTRY_POST: Option<&str> = None;
        /// `Some("es")`
        pub const LANG_AB: Option<&str> = Some("es");
        /// `Some("spa")`
        pub const LANG_LIB: Option<&str> = Some("spa");
        /// `Some("español")`
        pub const LANG_NAME: Option<&str> = Some("español");
        /// `Some("spa")`
        pub const LANG_TERM: Option<&str> = Some("spa");
        /// `Some("%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%c%N")`
        pub const POSTAL_FMT: Option<&str> = Some("%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%c%N");
    }
    pub mod LC_IDENTIFICATION {
        /// `None`
        pub const ABBREVIATION: Option<&str> = None;
        /// `Some("Sankt Jørgens Alle 8, DK-1615 København V, Danmark")`
        pub const ADDRESS: Option<&str> = Some("Sankt Jørgens Alle 8, DK-1615 København V, Danmark");
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        /// ]
        /// ```
        pub const CATEGORY: Option<&[&[&str]]> = Some(&[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_TELEPHONE"],
            &["i18n:2012", "LC_MEASUREMENT"],
        ]);
        /// `Some("")`
        pub const CONTACT: Option<&str> = Some("");
        /// `Some("2000-06-29")`
        pub const DATE: Option<&str> = Some("2000-06-29");
        /// `Some("bug-glibc-locales@gnu.org")`
        pub const EMAIL: Option<&str> = Some("bug-glibc-locales@gnu.org");
        /// `Some("")`
        pub const FAX: Option<&str> = Some("");
        /// `Some("Spanish")`
        pub const LANGUAGE: Option<&str> = Some("Spanish");
        /// `Some("1.0")`
        pub const REVISION: Option<&str> = Some("1.0");
        /// `Some("RAP")`
        pub const SOURCE: Option<&str> = Some("RAP");
        /// `Some("")`
        pub const TEL: Option<&str> = Some("");
        /// `Some("Dominican Republic")`
        pub const TERRITORY: Option<&str> = Some("Dominican Republic");
        /// `Some("Spanish locale for Dominican Republic")`
        pub const TITLE: Option<&str> = Some("Spanish locale for Dominican Republic");
    }
    pub use super::es_ES::LC_MESSAGES;
    pub mod LC_MONETARY {
        /// `"RD$"`
        pub const CURRENCY_SYMBOL: &str = "RD$";
        /// `2`
        pub const FRAC_DIGITS: i64 = 2;
        /// `"DOP "`
        pub const INT_CURR_SYMBOL: &str = "DOP ";
        /// `2`
        pub const INT_FRAC_DIGITS: i64 = 2;
        /// `None`
        pub const INT_N_CS_PRECEDES: Option<i64> = None;
        /// `None`
        pub const INT_N_SEP_BY_SPACE: Option<i64> = None;
        /// `None`
        pub const INT_N_SIGN_POSN: Option<i64> = None;
        /// `None`
        pub const INT_P_CS_PRECEDES: Option<i64> = None;
        /// `None`
        pub const INT_P_SEP_BY_SPACE: Option<i64> = None;
        /// `None`
        pub const INT_P_SIGN_POSN: Option<i64> = None;
        /// `"."`
        pub const MON_DECIMAL_POINT: &str = ".";
        /// `&[3, 3]`
        pub const MON_GROUPING: &[i64] = &[3, 3];
        /// `","`
        pub const MON_THOUSANDS_SEP: &str = ",";
        /// `"-"`
        pub const NEGATIVE_SIGN: &str = "-";
        /// `1`
        pub const N_CS_PRECEDES: i64 = 1;
        /// `1`
        pub const N_SEP_BY_SPACE: i64 = 1;
        /// `1`
        pub const N_SIGN_POSN: i64 = 1;
        /// `""`
        pub const POSITIVE_SIGN: &str = "";
        /// `1`
        pub const P_CS_PRECEDES: i64 = 1;
        /// `1`
        pub const P_SEP_BY_SPACE: i64 = 1;
        /// `1`
        pub const P_SIGN_POSN: i64 = 1;
    }
    pub mod LC_NUMERIC {
        /// `"."`
        pub const DECIMAL_POINT: &str = ".";
        /// `&[3, 3]`
        pub const GROUPING: &[i64] = &[3, 3];
        /// `","`
        pub const THOUSANDS_SEP: &str = ",";
    }
    pub mod LC_TELEPHONE {
        /// `Some("1")`
        pub const INT_PREFIX: Option<&str> = Some("1");
        /// `Some("011")`
        pub const INT_SELECT: Option<&str> = Some("011");
        /// `None`
        pub const TEL_DOM_FMT: Option<&str> = None;
        /// `Some("+%c %a %l")`
        pub const TEL_INT_FMT: Option<&str> = Some("+%c %a %l");
    }
    pub mod LC_TIME {
        /// `&["dom", "lun", "mar", "mié", "jue", "vie", "sáb"]`
        pub const ABDAY: &[&str] = &["dom", "lun", "mar", "mié", "jue", "vie", "sáb"];
        /// `&["ene", "feb", "mar", "abr", "may", "jun", "jul", "ago", "sep", "oct", "nov", "dic"]`
        pub const ABMON: &[&str] = &["ene", "feb", "mar", "abr", "may", "jun", "jul", "ago", "sep", "oct", "nov", "dic"];
        /// `None`
        pub const AB_ALT_MON: Option<&[&str]> = None;
        /// `None`
        pub const ALT_DIGITS: Option<&[&str]> = None;
        /// `None`
        pub const ALT_MON: Option<&[&str]> = None;
        /// `&["", ""]`
        pub const AM_PM: &[&str] = &["", ""];
        /// `None`
        pub const CAL_DIRECTION: Option<i64> = None;
        /// `None`
        pub const DATE_FMT: Option<&str> = None;
        /// `&["domingo", "lunes", "martes", "miércoles", "jueves", "viernes", "sábado"]`
        pub const DAY: &[&str] = &["domingo", "lunes", "martes", "miércoles", "jueves", "viernes", "sábado"];
        /// `"%d/%m/%y"`
        pub const D_FMT: &str = "%d/%m/%y";
        /// `"%a %d %b %Y %T %Z"`
        pub const D_T_FMT: &str = "%a %d %b %Y %T %Z";
        /// `None`
        pub const ERA: Option<&[&str]> = None;
        /// `None`
        pub const ERA_D_FMT: Option<&str> = None;
        /// `None`
        pub const ERA_D_T_FMT: Option<&str> = None;
        /// `None`
        pub const ERA_T_FMT: Option<&str> = None;
        /// `None`
        pub const FIRST_WEEKDAY: Option<i64> = None;
        /// `None`
        pub const FIRST_WORKDAY: Option<i64> = None;
        /// `&["enero", "febrero", "marzo", "abril", "mayo", "junio", "julio", "agosto", "septiembre", "octubre", "noviembre", "diciembre"]`
        pub const MON: &[&str] = &["enero", "febrero", "marzo", "abril", "mayo", "junio", "julio", "agosto", "septiembre", "octubre", "noviembre", "diciembre"];
        /// `"%T"`
        pub const T_FMT: &str = "%T";
        /// `""`
        pub const T_FMT_AMPM: &str = "";
        /// `Some(&[7, 19971130, 1])`
        pub const WEEK: Option<&[i64]> = Some(&[7, 19971130, 1]);
    }
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod es_EC {
    pub mod LC_ADDRESS {
        /// `Some("ECU")`
        pub const COUNTRY_AB3: Option<&str> = Some("ECU");
        /// `Some("EC")`
        pub const COUNTRY_ABTWO: Option<&str> = Some("EC");
        /// `Some("EC")`
        pub const COUNTRY_CAR: Option<&str> = Some("EC");
        /// `None`
        pub const COUNTRY_ISBN: Option<&str> = None;
        /// `Some("Ecuador")`
        pub const COUNTRY_NAME: Option<&str> = Some("Ecuador");
        /// `Some(218)`
        pub const COUNTRY_NUM: Option<i64> = Some(218);
        /// `None`
        pub const COUNTRY_POST: Option<&str> = None;
        /// `Some("es")`
        pub const LANG_AB: Option<&str> = Some("es");
        /// `Some("spa")`
        pub const LANG_LIB: Option<&str> = Some("spa");
        /// `Some("español")`
        pub const LANG_NAME: Option<&str> = Some("español");
        /// `Some("spa")`
        pub const LANG_TERM: Option<&str> = Some("spa");
        /// `Some("%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%c%N")`
        pub const POSTAL_FMT: Option<&str> = Some("%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%c%N");
    }
    pub mod LC_IDENTIFICATION {
        /// `None`
        pub const ABBREVIATION: Option<&str> = None;
        /// `Some("Sankt Jørgens Alle 8, DK-1615 København V, Danmark")`
        pub const ADDRESS: Option<&str> = Some("Sankt Jørgens Alle 8, DK-1615 København V, Danmark");
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        /// ]
        /// ```
        pub const CATEGORY: Option<&[&[&str]]> = Some(&[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_TELEPHONE"],
            &["i18n:2012", "LC_MEASUREMENT"],
        ]);
        /// `Some("")`
        pub const CONTACT: Option<&str> = Some("");
        /// `Some("2000-06-29")`
        pub const DATE: Option<&str> = Some("2000-06-29");
        /// `Some("bug-glibc-locales@gnu.org")`
        pub const EMAIL: Option<&str> = Some("bug-glibc-locales@gnu.org");
        /// `Some("")`
        pub const FAX: Option<&str> = Some("");
        /// `Some("Spanish")`
        pub const LANGUAGE: Option<&str> = Some("Spanish");
        /// `Some("1.0")`
        pub const REVISION: Option<&str> = Some("1.0");
        /// `Some("RAP")`
        pub const SOURCE: Option<&str> = Some("RAP");
        /// `Some("")`
        pub const TEL: Option<&str> = Some("");
        /// `Some("Ecuador")`
        pub const TERRITORY: Option<&str> = Some("Ecuador");
        /// `Some("Spanish locale for Ecuador")`
        pub const TITLE: Option<&str> = Some("Spanish locale for Ecuador");
    }
    pub use super::es_ES::LC_MESSAGES;
    pub mod LC_MONETARY {
        /// `"$"`
        pub const CURRENCY_SYMBOL: &str = "$";
        /// `2`
        pub const FRAC_DIGITS: i64 = 2;
        /// `"USD "`
        pub const INT_CURR_SYMBOL: &str = "USD ";
        /// `2`
        pub const INT_FRAC_DIGITS: i64 = 2;
        /// `None`
        pub const INT_N_CS_PRECEDES: Option<i64> = None;
        /// `None`
        pub const INT_N_SEP_BY_SPACE: Option<i64> = None;
        /// `None`
        pub const INT_N_SIGN_POSN: Option<i64> = None;
        /// `None`
        pub const INT_P_CS_PRECEDES: Option<i64> = None;
        /// `None`
        pub const INT_P_SEP_BY_SPACE: Option<i64> = None;
        /// `None`
        pub const INT_P_SIGN_POSN: Option<i64> = None;
        /// `","`
        pub const MON_DECIMAL_POINT: &str = ",";
        /// `&[3, 3]`
        pub const MON_GROUPING: &[i64] = &[3, 3];
        /// `"."`
        pub const MON_THOUSANDS_SEP: &str = ".";
        /// `"-"`
        pub const NEGATIVE_SIGN: &str = "-";
        /// `1`
        pub const N_CS_PRECEDES: i64 = 1;
        /// `1`
        pub const N_SEP_BY_SPACE: i64 = 1;
        /// `1`
        pub const N_SIGN_POSN: i64 = 1;
        /// `""`
        pub const POSITIVE_SIGN: &str = "";
        /// `1`
        pub const P_CS_PRECEDES: i64 = 1;
        /// `1`
        pub const P_SEP_BY_SPACE: i64 = 1;
        /// `1`
        pub const P_SIGN_POSN: i64 = 1;
    }
    pub use super::es_ES::LC_NUMERIC;
    pub mod LC_TELEPHONE {
        /// `Some("593")`
        pub const INT_PREFIX: Option<&str> = Some("593");
        /// `Some("00")`
        pub const INT_SELECT: Option<&str> = Some("00");
        /// `None`
        pub const TEL_DOM_FMT: Option<&str> = None;
        /// `Some("+%c %a %l")`
        pub const TEL_INT_FMT: Option<&str> = Some("+%c %a %l");
    }
    pub use super::es_BO::LC_TIME;
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod es_ES {
    pub mod LC_ADDRESS {
        /// `Some("ESP")`
        pub const COUNTRY_AB3: Option<&str> = Some("ESP");
        /// `Some("ES")`
        pub const COUNTRY_ABTWO: Option<&str> = Some("ES");
        /// `Some("E")`
        pub const COUNTRY_CAR: Option<&str> = Some("E");
        /// `None`
        pub const COUNTRY_ISBN: Option<&str> = None;
        /// `Some("España")`
        pub const COUNTRY_NAME: Option<&str> = Some("España");
        /// `Some(724)`
        pub const COUNTRY_NUM: Option<i64> = Some(724);
        /// `None`
        pub const COUNTRY_POST: Option<&str> = None;
        /// `Some("es")`
        pub const LANG_AB: Option<&str> = Some("es");
        /// `Some("spa")`
        pub const LANG_LIB: Option<&str> = Some("spa");
        /// `Some("español")`
        pub const LANG_NAME: Option<&str> = Some("español");
        /// `Some("spa")`
        pub const LANG_TERM: Option<&str> = Some("spa");
        /// `Some("%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%c%N")`
        pub const POSTAL_FMT: Option<&str> = Some("%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%c%N");
    }
    pub mod LC_IDENTIFICATION {
        /// `None`
        pub const ABBREVIATION: Option<&str> = None;
        /// `Some("Sankt Jørgens Alle 8, DK-1615 København V, Danmark")`
        pub const ADDRESS: Option<&str> = Some("Sankt Jørgens Alle 8, DK-1615 København V, Danmark");
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        /// ]
        /// ```
        pub const CATEGORY: Option<&[&[&str]]> = Some(&[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_TELEPHONE"],
            &["i18n:2012", "LC_MEASUREMENT"],
        ]);
        /// `Some("")`
        pub const CONTACT: Option<&str> = Some("");
        /// `Some("2000-06-29")`
        pub const DATE: Option<&str> = Some("2000-06-29");
        /// `Some("bug-glibc-locales@gnu.org")`
        pub const EMAIL: Option<&str> = Some("bug-glibc-locales@gnu.org");
        /// `Some("")`
        pub const FAX: Option<&str> = Some("");
        /// `Some("European Spanish")`
        pub const LANGUAGE: Option<&str> = Some("European Spanish");
        /// `Some("1.0")`
        pub const REVISION: Option<&str> = Some("1.0");
        /// `Some("RAP")`
        pub const SOURCE: Option<&str> = Some("RAP");
        /// `Some("")`
        pub const TEL: Option<&str> = Some("");
        /// `Some("Spain")`
        pub const TERRITORY: Option<&str> = Some("Spain");
        /// `Some("Spanish locale for Spain")`
        pub const TITLE: Option<&str> = Some("Spanish locale for Spain");
    }
    pub mod LC_MESSAGES {
        /// `"^[-0nN]"`
        pub const NOEXPR: &str = "^[-0nN]";
        /// `Some("no")`
        pub const NOSTR: Option<&str> = Some("no");
        /// `"^[+1sSyY]"`
        pub const YESEXPR: &str = "^[+1sSyY]";
        /// `Some("sí")`
        pub const YESSTR: Option<&str> = Some("sí");
    }
    pub mod LC_MONETARY {
        /// `"€"`
        pub const CURRENCY_SYMBOL: &str = "€";
        /// `2`
        pub const FRAC_DIGITS: i64 = 2;
        /// `"EUR "`
        pub const INT_CURR_SYMBOL: &str = "EUR ";
        /// `2`
        pub const INT_FRAC_DIGITS: i64 = 2;
        /// `None`
        pub const INT_N_CS_PRECEDES: Option<i64> = None;
        /// `None`
        pub const INT_N_SEP_BY_SPACE: Option<i64> = None;
        /// `None`
        pub const INT_N_SIGN_POSN: Option<i64> = None;
        /// `None`
        pub const INT_P_CS_PRECEDES: Option<i64> = None;
        /// `None`
        pub const INT_P_SEP_BY_SPACE: Option<i64> = None;
        /// `None`
        pub const INT_P_SIGN_POSN: Option<i64> = None;
        /// `","`
        pub const MON_DECIMAL_POINT: &str = ",";
        /// `&[3, 3]`
        pub const MON_GROUPING: &[i64] = &[3, 3];
        /// `"."`
        pub const MON_THOUSANDS_SEP: &str = ".";
        /// `"-"`
        pub const NEGATIVE_SIGN: &str = "-";
        /// `0`
        pub const N_CS_PRECEDES: i64 = 0;
        /// `1`
        pub const N_SEP_BY_SPACE: i64 = 1;
        /// `1`
        pub const N_SIGN_POSN: i64 = 1;
        /// `""`
        pub const POSITIVE_SIGN: &str = "";
        /// `0`
        pub const P_CS_PRECEDES: i64 = 0;
        /// `1`
        pub const P_SEP_BY_SPACE: i64 = 1;
        /// `1`
        pub const P_SIGN_POSN: i64 = 1;
    }
    pub mod LC_NUMERIC {
        /// `","`
        pub const DECIMAL_POINT: &str = ",";
        /// `&[3, 3]`
        pub const GROUPING: &[i64] = &[3, 3];
        /// `"."`
        pub const THOUSANDS_SEP: &str = ".";
    }
    pub mod LC_TELEPHONE {
        /// `Some("34")`
        pub const INT_PREFIX: Option<&str> = Some("34");
        /// `Some("00")`
        pub const INT_SELECT: Option<&str> = Some("00");
        /// `None`
        pub const TEL_DOM_FMT: Option<&str> = None;
        /// `Some("+%c %a %l")`
        pub const TEL_INT_FMT: Option<&str> = Some("+%c %a %l");
    }
    pub mod LC_TIME {
        /// `&["dom", "lun", "mar", "mié", "jue", "vie", "sáb"]`
        pub const ABDAY: &[&str] = &["dom", "lun", "mar", "mié", "jue", "vie", "sáb"];
        /// `&["ene", "feb", "mar", "abr", "may", "jun", "jul", "ago", "sep", "oct", "nov", "dic"]`
        pub const ABMON: &[&str] = &["ene", "feb", "mar", "abr", "may", "jun", "jul", "ago", "sep", "oct", "nov", "dic"];
        /// `None`
        pub const AB_ALT_MON: Option<&[&str]> = None;
        /// `None`
        pub const ALT_DIGITS: Option<&[&str]> = None;
        /// `None`
        pub const ALT_MON: Option<&[&str]> = None;
        /// `&["", ""]`
        pub const AM_PM: &[&str] = &["", ""];
        /// `None`
        pub const CAL_DIRECTION: Option<i64> = None;
        /// `None`
        pub const DATE_FMT: Option<&str> = None;
        /// `&["domingo", "lunes", "martes", "miércoles", "jueves", "viernes", "sábado"]`
        pub const DAY: &[&str] = &["domingo", "lunes", "martes", "miércoles", "jueves", "viernes", "sábado"];
        /// `"%d/%m/%y"`
        pub const D_FMT: &str = "%d/%m/%y";
        /// `"%a %d %b %Y %T %Z"`
        pub const D_T_FMT: &str = "%a %d %b %Y %T %Z";
        /// `None`
        pub const ERA: Option<&[&str]> = None;
        /// `None`
        pub const ERA_D_FMT: Option<&str> = None;
        /// `None`
        pub const ERA_D_T_FMT: Option<&str> = None;
        /// `None`
        pub const ERA_T_FMT: Option<&str> = None;
        /// `Some(2)`
        pub const FIRST_WEEKDAY: Option<i64> = Some(2);
        /// `None`
        pub const FIRST_WORKDAY: Option<i64> = None;
        /// `&["enero", "febrero", "marzo", "abril", "mayo", "junio", "julio", "agosto", "septiembre", "octubre", "noviembre", "diciembre"]`
        pub const MON: &[&str] = &["enero", "febrero", "marzo", "abril", "mayo", "junio", "julio", "agosto", "septiembre", "octubre", "noviembre", "diciembre"];
        /// `"%T"`
        pub const T_FMT: &str = "%T";
        /// `""`
        pub const T_FMT_AMPM: &str = "";
        /// `Some(&[7, 19971130, 4])`
        pub const WEEK: Option<&[i64]> = Some(&[7, 19971130, 4]);
    }
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod es_ES_euro {
    pub use super::es_ES::LC_ADDRESS;
    pub mod LC_IDENTIFICATION {
        /// `None`
        pub const ABBREVIATION: Option<&str> = None;
        /// `Some("https://www.gnu.org/software/libc/")`
        pub const ADDRESS: Option<&str> = Some("https://www.gnu.org/software/libc/");
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        /// ]
        /// ```
        pub const CATEGORY: Option<&[&[&str]]> = Some(&[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_TELEPHONE"],
            &["i18n:2012", "LC_MEASUREMENT"],
        ]);
        /// `Some("")`
        pub const CONTACT: Option<&str> = Some("");
        /// `Some("2000-06-29")`
        pub const DATE: Option<&str> = Some("2000-06-29");
        /// `Some("bug-glibc-locales@gnu.org")`
        pub const EMAIL: Option<&str> = Some("bug-glibc-locales@gnu.org");
        /// `Some("")`
        pub const FAX: Option<&str> = Some("");
        /// `Some("Spanish")`
        pub const LANGUAGE: Option<&str> = Some("Spanish");
        /// `None`
        pub const REVISION: Option<&str> = None;
        /// `Some("Free Software Foundation, Inc.")`
        pub const SOURCE: Option<&str> = Some("Free Software Foundation, Inc.");
        /// `Some("")`
        pub const TEL: Option<&str> = Some("");
        /// `Some("Spain")`
        pub const TERRITORY: Option<&str> = Some("Spain");
        /// `Some("Spanish locale for Spain with Euro")`
        pub const TITLE: Option<&str> = Some("Spanish locale for Spain with Euro");
    }
    pub use super::es_ES::LC_MESSAGES;
    pub use super::es_ES::LC_MONETARY;
    pub use super::es_ES::LC_NUMERIC;
    pub use super::es_ES::LC_TELEPHONE;
    pub use super::es_ES::LC_TIME;
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod es_GT {
    pub mod LC_ADDRESS {
        /// `Some("GTM")`
        pub const COUNTRY_AB3: Option<&str> = Some("GTM");
        /// `Some("GT")`
        pub const COUNTRY_ABTWO: Option<&str> = Some("GT");
        /// `Some("GCA")`
        pub const COUNTRY_CAR: Option<&str> = Some("GCA");
        /// `None`
        pub const COUNTRY_ISBN: Option<&str> = None;
        /// `Some("Guatemala")`
        pub const COUNTRY_NAME: Option<&str> = Some("Guatemala");
        /// `Some(320)`
        pub const COUNTRY_NUM: Option<i64> = Some(320);
        /// `None`
        pub const COUNTRY_POST: Option<&str> = None;
        /// `Some("es")`
        pub const LANG_AB: Option<&str> = Some("es");
        /// `Some("spa")`
        pub const LANG_LIB: Option<&str> = Some("spa");
        /// `Some("español")`
        pub const LANG_NAME: Option<&str> = Some("español");
        /// `Some("spa")`
        pub const LANG_TERM: Option<&str> = Some("spa");
        /// `Some("%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%c%N")`
        pub const POSTAL_FMT: Option<&str> = Some("%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%c%N");
    }
    pub mod LC_IDENTIFICATION {
        /// `None`
        pub const ABBREVIATION: Option<&str> = None;
        /// `Some("Sankt Jørgens Alle 8, DK-1615 København V, Danmark")`
        pub const ADDRESS: Option<&str> = Some("Sankt Jørgens Alle 8, DK-1615 København V, Danmark");
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        /// ]
        /// ```
        pub const CATEGORY: Option<&[&[&str]]> = Some(&[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_TELEPHONE"],
            &["i18n:2012", "LC_MEASUREMENT"],
        ]);
        /// `Some("")`
        pub const CONTACT: Option<&str> = Some("");
        /// `Some("2000-06-29")`
        pub const DATE: Option<&str> = Some("2000-06-29");
        /// `Some("bug-glibc-locales@gnu.org")`
        pub const EMAIL: Option<&str> = Some("bug-glibc-locales@gnu.org");
        /// `Some("")`
        pub const FAX: Option<&str> = Some("");
        /// `Some("Spanish")`
        pub const LANGUAGE: Option<&str> = Some("Spanish");
        /// `Some("1.0")`
        pub const REVISION: Option<&str> = Some("1.0");
        /// `Some("RAP")`
        pub const SOURCE: Option<&str> = Some("RAP");
        /// `Some("")`
        pub const TEL: Option<&str> = Some("");
        /// `Some("Guatemala")`
        pub const TERRITORY: Option<&str> = Some("Guatemala");
        /// `Some("Spanish locale for Guatemala")`
        pub const TITLE: Option<&str> = Some("Spanish locale for Guatemala");
    }
    pub use super::es_ES::LC_MESSAGES;
    pub mod LC_MONETARY {
        /// `"Q"`
        pub const CURRENCY_SYMBOL: &str = "Q";
        /// `2`
        pub const FRAC_DIGITS: i64 = 2;
        /// `"GTQ "`
        pub const INT_CURR_SYMBOL: &str = "GTQ ";
        /// `2`
        pub const INT_FRAC_DIGITS: i64 = 2;
        /// `None`
        pub const INT_N_CS_PRECEDES: Option<i64> = None;
        /// `None`
        pub const INT_N_SEP_BY_SPACE: Option<i64> = None;
        /// `None`
        pub const INT_N_SIGN_POSN: Option<i64> = None;
        /// `None`
        pub const INT_P_CS_PRECEDES: Option<i64> = None;
        /// `None`
        pub const INT_P_SEP_BY_SPACE: Option<i64> = None;
        /// `None`
        pub const INT_P_SIGN_POSN: Option<i64> = None;
        /// `"."`
        pub const MON_DECIMAL_POINT: &str = ".";
        /// `&[3, 3]`
        pub const MON_GROUPING: &[i64] = &[3, 3];
        /// `","`
        pub const MON_THOUSANDS_SEP: &str = ",";
        /// `"-"`
        pub const NEGATIVE_SIGN: &str = "-";
        /// `1`
        pub const N_CS_PRECEDES: i64 = 1;
        /// `1`
        pub const N_SEP_BY_SPACE: i64 = 1;
        /// `1`
        pub const N_SIGN_POSN: i64 = 1;
        /// `""`
        pub const POSITIVE_SIGN: &str = "";
        /// `1`
        pub const P_CS_PRECEDES: i64 = 1;
        /// `1`
        pub const P_SEP_BY_SPACE: i64 = 1;
        /// `1`
        pub const P_SIGN_POSN: i64 = 1;
    }
    pub mod LC_NUMERIC {
        /// `"."`
        pub const DECIMAL_POINT: &str = ".";
        /// `&[3, 3]`
        pub const GROUPING: &[i64] = &[3, 3];
        /// `","`
        pub const THOUSANDS_SEP: &str = ",";
    }
    pub mod LC_TELEPHONE {
        /// `Some("502")`
        pub const INT_PREFIX: Option<&str> = Some("502");
        /// `Some("00")`
        pub const INT_SELECT: Option<&str> = Some("00");
        /// `None`
        pub const TEL_DOM_FMT: Option<&str> = None;
        /// `Some("+%c %a %l")`
        pub const TEL_INT_FMT: Option<&str> = Some("+%c %a %l");
    }
    pub mod LC_TIME {
        /// `&["dom", "lun", "mar", "mié", "jue", "vie", "sáb"]`
        pub const ABDAY: &[&str] = &["dom", "lun", "mar", "mié", "jue", "vie", "sáb"];
        /// `&["ene", "feb", "mar", "abr", "may", "jun", "jul", "ago", "sep", "oct", "nov", "dic"]`
        pub const ABMON: &[&str] = &["ene", "feb", "mar", "abr", "may", "jun", "jul", "ago", "sep", "oct", "nov", "dic"];
        /// `None`
        pub const AB_ALT_MON: Option<&[&str]> = None;
        /// `None`
        pub const ALT_DIGITS: Option<&[&str]> = None;
        /// `None`
        pub const ALT_MON: Option<&[&str]> = None;
        /// `&["", ""]`
        pub const AM_PM: &[&str] = &["", ""];
        /// `None`
        pub const CAL_DIRECTION: Option<i64> = None;
        /// `None`
        pub const DATE_FMT: Option<&str> = None;
        /// `&["domingo", "lunes", "martes", "miércoles", "jueves", "viernes", "sábado"]`
        pub const DAY: &[&str] = &["domingo", "lunes", "martes", "miércoles", "jueves", "viernes", "sábado"];
        /// `"%d/%m/%y"`
        pub const D_FMT: &str = "%d/%m/%y";
        /// `"%a %d %b %Y %T %Z"`
        pub const D_T_FMT: &str = "%a %d %b %Y %T %Z";
        /// `None`
        pub const ERA: Option<&[&str]> = None;
        /// `None`
        pub const ERA_D_FMT: Option<&str> = None;
        /// `None`
        pub const ERA_D_T_FMT: Option<&str> = None;
        /// `None`
        pub const ERA_T_FMT: Option<&str> = None;
        /// `None`
        pub const FIRST_WEEKDAY: Option<i64> = None;
        /// `None`
        pub const FIRST_WORKDAY: Option<i64> = None;
        /// `&["enero", "febrero", "marzo", "abril", "mayo", "junio", "julio", "agosto", "septiembre", "octubre", "noviembre", "diciembre"]`
        pub const MON: &[&str] = &["enero", "febrero", "marzo", "abril", "mayo", "junio", "julio", "agosto", "septiembre", "octubre", "noviembre", "diciembre"];
        /// `"%T"`
        pub const T_FMT: &str = "%T";
        /// `""`
        pub const T_FMT_AMPM: &str = "";
        /// `Some(&[7, 19971130, 1])`
        pub const WEEK: Option<&[i64]> = Some(&[7, 19971130, 1]);
    }
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod es_HN {
    pub mod LC_ADDRESS {
        /// `Some("HND")`
        pub const COUNTRY_AB3: Option<&str> = Some("HND");
        /// `Some("HN")`
        pub const COUNTRY_ABTWO: Option<&str> = Some("HN");
        /// `Some("HN")`
        pub const COUNTRY_CAR: Option<&str> = Some("HN");
        /// `None`
        pub const COUNTRY_ISBN: Option<&str> = None;
        /// `Some("Honduras")`
        pub const COUNTRY_NAME: Option<&str> = Some("Honduras");
        /// `Some(340)`
        pub const COUNTRY_NUM: Option<i64> = Some(340);
        /// `None`
        pub const COUNTRY_POST: Option<&str> = None;
        /// `Some("es")`
        pub const LANG_AB: Option<&str> = Some("es");
        /// `Some("spa")`
        pub const LANG_LIB: Option<&str> = Some("spa");
        /// `Some("español")`
        pub const LANG_NAME: Option<&str> = Some("español");
        /// `Some("spa")`
        pub const LANG_TERM: Option<&str> = Some("spa");
        /// `Some("%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%c%N")`
        pub const POSTAL_FMT: Option<&str> = Some("%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%c%N");
    }
    pub mod LC_IDENTIFICATION {
        /// `None`
        pub const ABBREVIATION: Option<&str> = None;
        /// `Some("Sankt Jørgens Alle 8, DK-1615 København V, Danmark")`
        pub const ADDRESS: Option<&str> = Some("Sankt Jørgens Alle 8, DK-1615 København V, Danmark");
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        /// ]
        /// ```
        pub const CATEGORY: Option<&[&[&str]]> = Some(&[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_TELEPHONE"],
            &["i18n:2012", "LC_MEASUREMENT"],
        ]);
        /// `Some("")`
        pub const CONTACT: Option<&str> = Some("");
        /// `Some("2000-06-29")`
        pub const DATE: Option<&str> = Some("2000-06-29");
        /// `Some("bug-glibc-locales@gnu.org")`
        pub const EMAIL: Option<&str> = Some("bug-glibc-locales@gnu.org");
        /// `Some("")`
        pub const FAX: Option<&str> = Some("");
        /// `Some("Spanish")`
        pub const LANGUAGE: Option<&str> = Some("Spanish");
        /// `Some("1.0")`
        pub const REVISION: Option<&str> = Some("1.0");
        /// `Some("RAP")`
        pub const SOURCE: Option<&str> = Some("RAP");
        /// `Some("")`
        pub const TEL: Option<&str> = Some("");
        /// `Some("Honduras")`
        pub const TERRITORY: Option<&str> = Some("Honduras");
        /// `Some("Spanish locale for Honduras")`
        pub const TITLE: Option<&str> = Some("Spanish locale for Honduras");
    }
    pub use super::es_ES::LC_MESSAGES;
    pub mod LC_MONETARY {
        /// `"L"`
        pub const CURRENCY_SYMBOL: &str = "L";
        /// `2`
        pub const FRAC_DIGITS: i64 = 2;
        /// `"HNL "`
        pub const INT_CURR_SYMBOL: &str = "HNL ";
        /// `2`
        pub const INT_FRAC_DIGITS: i64 = 2;
        /// `None`
        pub const INT_N_CS_PRECEDES: Option<i64> = None;
        /// `None`
        pub const INT_N_SEP_BY_SPACE: Option<i64> = None;
        /// `None`
        pub const INT_N_SIGN_POSN: Option<i64> = None;
        /// `None`
        pub const INT_P_CS_PRECEDES: Option<i64> = None;
        /// `None`
        pub const INT_P_SEP_BY_SPACE: Option<i64> = None;
        /// `None`
        pub const INT_P_SIGN_POSN: Option<i64> = None;
        /// `"."`
        pub const MON_DECIMAL_POINT: &str = ".";
        /// `&[3, 3]`
        pub const MON_GROUPING: &[i64] = &[3, 3];
        /// `","`
        pub const MON_THOUSANDS_SEP: &str = ",";
        /// `"-"`
        pub const NEGATIVE_SIGN: &str = "-";
        /// `1`
        pub const N_CS_PRECEDES: i64 = 1;
        /// `1`
        pub const N_SEP_BY_SPACE: i64 = 1;
        /// `1`
        pub const N_SIGN_POSN: i64 = 1;
        /// `""`
        pub const POSITIVE_SIGN: &str = "";
        /// `1`
        pub const P_CS_PRECEDES: i64 = 1;
        /// `1`
        pub const P_SEP_BY_SPACE: i64 = 1;
        /// `1`
        pub const P_SIGN_POSN: i64 = 1;
    }
    pub mod LC_NUMERIC {
        /// `"."`
        pub const DECIMAL_POINT: &str = ".";
        /// `&[3, 3]`
        pub const GROUPING: &[i64] = &[3, 3];
        /// `","`
        pub const THOUSANDS_SEP: &str = ",";
    }
    pub mod LC_TELEPHONE {
        /// `Some("504")`
        pub const INT_PREFIX: Option<&str> = Some("504");
        /// `Some("00")`
        pub const INT_SELECT: Option<&str> = Some("00");
        /// `None`
        pub const TEL_DOM_FMT: Option<&str> = None;
        /// `Some("+%c %a %l")`
        pub const TEL_INT_FMT: Option<&str> = Some("+%c %a %l");
    }
    pub mod LC_TIME {
        /// `&["dom", "lun", "mar", "mié", "jue", "vie", "sáb"]`
        pub const ABDAY: &[&str] = &["dom", "lun", "mar", "mié", "jue", "vie", "sáb"];
        /// `&["ene", "feb", "mar", "abr", "may", "jun", "jul", "ago", "sep", "oct", "nov", "dic"]`
        pub const ABMON: &[&str] = &["ene", "feb", "mar", "abr", "may", "jun", "jul", "ago", "sep", "oct", "nov", "dic"];
        /// `None`
        pub const AB_ALT_MON: Option<&[&str]> = None;
        /// `None`
        pub const ALT_DIGITS: Option<&[&str]> = None;
        /// `None`
        pub const ALT_MON: Option<&[&str]> = None;
        /// `&["", ""]`
        pub const AM_PM: &[&str] = &["", ""];
        /// `None`
        pub const CAL_DIRECTION: Option<i64> = None;
        /// `None`
        pub const DATE_FMT: Option<&str> = None;
        /// `&["domingo", "lunes", "martes", "miércoles", "jueves", "viernes", "sábado"]`
        pub const DAY: &[&str] = &["domingo", "lunes", "martes", "miércoles", "jueves", "viernes", "sábado"];
        /// `"%d/%m/%y"`
        pub const D_FMT: &str = "%d/%m/%y";
        /// `"%a %d %b %Y %T %Z"`
        pub const D_T_FMT: &str = "%a %d %b %Y %T %Z";
        /// `None`
        pub const ERA: Option<&[&str]> = None;
        /// `None`
        pub const ERA_D_FMT: Option<&str> = None;
        /// `None`
        pub const ERA_D_T_FMT: Option<&str> = None;
        /// `None`
        pub const ERA_T_FMT: Option<&str> = None;
        /// `None`
        pub const FIRST_WEEKDAY: Option<i64> = None;
        /// `None`
        pub const FIRST_WORKDAY: Option<i64> = None;
        /// `&["enero", "febrero", "marzo", "abril", "mayo", "junio", "julio", "agosto", "septiembre", "octubre", "noviembre", "diciembre"]`
        pub const MON: &[&str] = &["enero", "febrero", "marzo", "abril", "mayo", "junio", "julio", "agosto", "septiembre", "octubre", "noviembre", "diciembre"];
        /// `"%T"`
        pub const T_FMT: &str = "%T";
        /// `""`
        pub const T_FMT_AMPM: &str = "";
        /// `Some(&[7, 19971130, 1])`
        pub const WEEK: Option<&[i64]> = Some(&[7, 19971130, 1]);
    }
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod es_MX {
    pub mod LC_ADDRESS {
        /// `Some("MEX")`
        pub const COUNTRY_AB3: Option<&str> = Some("MEX");
        /// `Some("MX")`
        pub const COUNTRY_ABTWO: Option<&str> = Some("MX");
        /// `Some("MEX")`
        pub const COUNTRY_CAR: Option<&str> = Some("MEX");
        /// `None`
        pub const COUNTRY_ISBN: Option<&str> = None;
        /// `Some("México")`
        pub const COUNTRY_NAME: Option<&str> = Some("México");
        /// `Some(484)`
        pub const COUNTRY_NUM: Option<i64> = Some(484);
        /// `None`
        pub const COUNTRY_POST: Option<&str> = None;
        /// `Some("es")`
        pub const LANG_AB: Option<&str> = Some("es");
        /// `Some("spa")`
        pub const LANG_LIB: Option<&str> = Some("spa");
        /// `Some("español")`
        pub const LANG_NAME: Option<&str> = Some("español");
        /// `Some("spa")`
        pub const LANG_TERM: Option<&str> = Some("spa");
        /// `Some("%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%c%N")`
        pub const POSTAL_FMT: Option<&str> = Some("%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%c%N");
    }
    pub mod LC_IDENTIFICATION {
        /// `None`
        pub const ABBREVIATION: Option<&str> = None;
        /// `Some("Sankt Jørgens Alle 8, DK-1615 København V, Danmark")`
        pub const ADDRESS: Option<&str> = Some("Sankt Jørgens Alle 8, DK-1615 København V, Danmark");
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        /// ]
        /// ```
        pub const CATEGORY: Option<&[&[&str]]> = Some(&[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_TELEPHONE"],
            &["i18n:2012", "LC_MEASUREMENT"],
        ]);
        /// `Some("")`
        pub const CONTACT: Option<&str> = Some("");
        /// `Some("2000-06-29")`
        pub const DATE: Option<&str> = Some("2000-06-29");
        /// `Some("bug-glibc-locales@gnu.org")`
        pub const EMAIL: Option<&str> = Some("bug-glibc-locales@gnu.org");
        /// `Some("")`
        pub const FAX: Option<&str> = Some("");
        /// `Some("Mexican Spanish")`
        pub const LANGUAGE: Option<&str> = Some("Mexican Spanish");
        /// `Some("1.0")`
        pub const REVISION: Option<&str> = Some("1.0");
        /// `Some("RAP")`
        pub const SOURCE: Option<&str> = Some("RAP");
        /// `Some("")`
        pub const TEL: Option<&str> = Some("");
        /// `Some("Mexico")`
        pub const TERRITORY: Option<&str> = Some("Mexico");
        /// `Some("Spanish locale for Mexico")`
        pub const TITLE: Option<&str> = Some("Spanish locale for Mexico");
    }
    pub use super::es_ES::LC_MESSAGES;
    pub mod LC_MONETARY {
        /// `"$"`
        pub const CURRENCY_SYMBOL: &str = "$";
        /// `2`
        pub const FRAC_DIGITS: i64 = 2;
        /// `"MXN "`
        pub const INT_CURR_SYMBOL: &str = "MXN ";
        /// `2`
        pub const INT_FRAC_DIGITS: i64 = 2;
        /// `None`
        pub const INT_N_CS_PRECEDES: Option<i64> = None;
        /// `None`
        pub const INT_N_SEP_BY_SPACE: Option<i64> = None;
        /// `None`
        pub const INT_N_SIGN_POSN: Option<i64> = None;
        /// `None`
        pub const INT_P_CS_PRECEDES: Option<i64> = None;
        /// `None`
        pub const INT_P_SEP_BY_SPACE: Option<i64> = None;
        /// `None`
        pub const INT_P_SIGN_POSN: Option<i64> = None;
        /// `"."`
        pub const MON_DECIMAL_POINT: &str = ".";
        /// `&[3, 3]`
        pub const MON_GROUPING: &[i64] = &[3, 3];
        /// `","`
        pub const MON_THOUSANDS_SEP: &str = ",";
        /// `"-"`
        pub const NEGATIVE_SIGN: &str = "-";
        /// `1`
        pub const N_CS_PRECEDES: i64 = 1;
        /// `1`
        pub const N_SEP_BY_SPACE: i64 = 1;
        /// `1`
        pub const N_SIGN_POSN: i64 = 1;
        /// `""`
        pub const POSITIVE_SIGN: &str = "";
        /// `1`
        pub const P_CS_PRECEDES: i64 = 1;
        /// `1`
        pub const P_SEP_BY_SPACE: i64 = 1;
        /// `1`
        pub const P_SIGN_POSN: i64 = 1;
    }
    pub mod LC_NUMERIC {
        /// `"."`
        pub const DECIMAL_POINT: &str = ".";
        /// `&[3, 3]`
        pub const GROUPING: &[i64] = &[3, 3];
        /// `"\u{202f}"`
        pub const THOUSANDS_SEP: &str = "\u{202f}";
    }
    pub mod LC_TELEPHONE {
        /// `Some("52")`
        pub const INT_PREFIX: Option<&str> = Some("52");
        /// `Some("00")`
        pub const INT_SELECT: Option<&str> = Some("00");
        /// `None`
        pub const TEL_DOM_FMT: Option<&str> = None;
        /// `Some("+%c %a %l")`
        pub const TEL_INT_FMT: Option<&str> = Some("+%c %a %l");
    }
    pub mod LC_TIME {
        /// `&["dom", "lun", "mar", "mié", "jue", "vie", "sáb"]`
        pub const ABDAY: &[&str] = &["dom", "lun", "mar", "mié", "jue", "vie", "sáb"];
        /// `&["ene", "feb", "mar", "abr", "may", "jun", "jul", "ago", "sep", "oct", "nov", "dic"]`
        pub const ABMON: &[&str] = &["ene", "feb", "mar", "abr", "may", "jun", "jul", "ago", "sep", "oct", "nov", "dic"];
        /// `None`
        pub const AB_ALT_MON: Option<&[&str]> = None;
        /// `None`
        pub const ALT_DIGITS: Option<&[&str]> = None;
        /// `None`
        pub const ALT_MON: Option<&[&str]> = None;
        /// `&["", ""]`
        pub const AM_PM: &[&str] = &["", ""];
        /// `None`
        pub const CAL_DIRECTION: Option<i64> = None;
        /// `None`
        pub const DATE_FMT: Option<&str> = None;
        /// `&["domingo", "lunes", "martes", "miércoles", "jueves", "viernes", "sábado"]`
        pub const DAY: &[&str] = &["domingo", "lunes", "martes", "miércoles", "jueves", "viernes", "sábado"];
        /// `"%d/%m/%y"`
        pub const D_FMT: &str = "%d/%m/%y";
        /// `"%a %d %b %Y %T %Z"`
        pub const D_T_FMT: &str = "%a %d %b %Y %T %Z";
        /// `None`
        pub const ERA: Option<&[&str]> = None;
        /// `None`
        pub const ERA_D_FMT: Option<&str> = None;
        /// `None`
        pub const ERA_D_T_FMT: Option<&str> = None;
        /// `None`
        pub const ERA_T_FMT: Option<&str> = None;
        /// `None`
        pub const FIRST_WEEKDAY: Option<i64> = None;
        /// `None`
        pub const FIRST_WORKDAY: Option<i64> = None;
        /// `&["enero", "febrero", "marzo", "abril", "mayo", "junio", "julio", "agosto", "septiembre", "octubre", "noviembre", "diciembre"]`
        pub const MON: &[&str] = &["enero", "febrero", "marzo", "abril", "mayo", "junio", "julio", "agosto", "septiembre", "octubre", "noviembre", "diciembre"];
        /// `"%T"`
        pub const T_FMT: &str = "%T";
        /// `""`
        pub const T_FMT_AMPM: &str = "";
        /// `Some(&[7, 19971130, 1])`
        pub const WEEK: Option<&[i64]> = Some(&[7, 19971130, 1]);
    }
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod es_NI {
    pub mod LC_ADDRESS {
        /// `Some("NIC")`
        pub const COUNTRY_AB3: Option<&str> = Some("NIC");
        /// `Some("NI")`
        pub const COUNTRY_ABTWO: Option<&str> = Some("NI");
        /// `Some("NIC")`
        pub const COUNTRY_CAR: Option<&str> = Some("NIC");
        /// `None`
        pub const COUNTRY_ISBN: Option<&str> = None;
        /// `Some("Nicaragua")`
        pub const COUNTRY_NAME: Option<&str> = Some("Nicaragua");
        /// `Some(558)`
        pub const COUNTRY_NUM: Option<i64> = Some(558);
        /// `None`
        pub const COUNTRY_POST: Option<&str> = None;
        /// `Some("es")`
        pub const LANG_AB: Option<&str> = Some("es");
        /// `Some("spa")`
        pub const LANG_LIB: Option<&str> = Some("spa");
        /// `Some("español")`
        pub const LANG_NAME: Option<&str> = Some("español");
        /// `Some("spa")`
        pub const LANG_TERM: Option<&str> = Some("spa");
        /// `Some("%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%c%N")`
        pub const POSTAL_FMT: Option<&str> = Some("%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%c%N");
    }
    pub mod LC_IDENTIFICATION {
        /// `None`
        pub const ABBREVIATION: Option<&str> = None;
        /// `Some("https://www.gnu.org/software/libc/")`
        pub const ADDRESS: Option<&str> = Some("https://www.gnu.org/software/libc/");
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        /// ]
        /// ```
        pub const CATEGORY: Option<&[&[&str]]> = Some(&[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_TELEPHONE"],
            &["i18n:2012", "LC_MEASUREMENT"],
        ]);
        /// `Some("")`
        pub const CONTACT: Option<&str> = Some("");
        /// `Some("2000-08-21")`
        pub const DATE: Option<&str> = Some("2000-08-21");
        /// `Some("bug-glibc-locales@gnu.org")`
        pub const EMAIL: Option<&str> = Some("bug-glibc-locales@gnu.org");
        /// `Some("")`
        pub const FAX: Option<&str> = Some("");
        /// `Some("Spanish")`
        pub const LANGUAGE: Option<&str> = Some("Spanish");
        /// `Some("1.0")`
        pub const REVISION: Option<&str> = Some("1.0");
        /// `Some("Free Software Foundation, Inc.")`
        pub const SOURCE: Option<&str> = Some("Free Software Foundation, Inc.");
        /// `Some("")`
        pub const TEL: Option<&str> = Some("");
        /// `Some("Nicaragua")`
        pub const TERRITORY: Option<&str> = Some("Nicaragua");
        /// `Some("Spanish locale for Nicaragua")`
        pub const TITLE: Option<&str> = Some("Spanish locale for Nicaragua");
    }
    pub use super::es_ES::LC_MESSAGES;
    pub mod LC_MONETARY {
        /// `"C$"`
        pub const CURRENCY_SYMBOL: &str = "C$";
        /// `2`
        pub const FRAC_DIGITS: i64 = 2;
        /// `"NIO "`
        pub const INT_CURR_SYMBOL: &str = "NIO ";
        /// `2`
        pub const INT_FRAC_DIGITS: i64 = 2;
        /// `None`
        pub const INT_N_CS_PRECEDES: Option<i64> = None;
        /// `None`
        pub const INT_N_SEP_BY_SPACE: Option<i64> = None;
        /// `None`
        pub const INT_N_SIGN_POSN: Option<i64> = None;
        /// `None`
        pub const INT_P_CS_PRECEDES: Option<i64> = None;
        /// `None`
        pub const INT_P_SEP_BY_SPACE: Option<i64> = None;
        /// `None`
        pub const INT_P_SIGN_POSN: Option<i64> = None;
        /// `"."`
        pub const MON_DECIMAL_POINT: &str = ".";
        /// `&[3, 3]`
        pub const MON_GROUPING: &[i64] = &[3, 3];
        /// `","`
        pub const MON_THOUSANDS_SEP: &str = ",";
        /// `"-"`
        pub const NEGATIVE_SIGN: &str = "-";
        /// `1`
        pub const N_CS_PRECEDES: i64 = 1;
        /// `1`
        pub const N_SEP_BY_SPACE: i64 = 1;
        /// `1`
        pub const N_SIGN_POSN: i64 = 1;
        /// `""`
        pub const POSITIVE_SIGN: &str = "";
        /// `1`
        pub const P_CS_PRECEDES: i64 = 1;
        /// `1`
        pub const P_SEP_BY_SPACE: i64 = 1;
        /// `1`
        pub const P_SIGN_POSN: i64 = 1;
    }
    pub mod LC_NUMERIC {
        /// `"."`
        pub const DECIMAL_POINT: &str = ".";
        /// `&[3, 3]`
        pub const GROUPING: &[i64] = &[3, 3];
        /// `","`
        pub const THOUSANDS_SEP: &str = ",";
    }
    pub mod LC_TELEPHONE {
        /// `Some("505")`
        pub const INT_PREFIX: Option<&str> = Some("505");
        /// `Some("00")`
        pub const INT_SELECT: Option<&str> = Some("00");
        /// `None`
        pub const TEL_DOM_FMT: Option<&str> = None;
        /// `Some("+%c %a %l")`
        pub const TEL_INT_FMT: Option<&str> = Some("+%c %a %l");
    }
    pub mod LC_TIME {
        /// `&["dom", "lun", "mar", "mié", "jue", "vie", "sáb"]`
        pub const ABDAY: &[&str] = &["dom", "lun", "mar", "mié", "jue", "vie", "sáb"];
        /// `&["ene", "feb", "mar", "abr", "may", "jun", "jul", "ago", "sep", "oct", "nov", "dic"]`
        pub const ABMON: &[&str] = &["ene", "feb", "mar", "abr", "may", "jun", "jul", "ago", "sep", "oct", "nov", "dic"];
        /// `None`
        pub const AB_ALT_MON: Option<&[&str]> = None;
        /// `None`
        pub const ALT_DIGITS: Option<&[&str]> = None;
        /// `None`
        pub const ALT_MON: Option<&[&str]> = None;
        /// `&["AM", "PM"]`
        pub const AM_PM: &[&str] = &["AM", "PM"];
        /// `None`
        pub const CAL_DIRECTION: Option<i64> = None;
        /// `None`
        pub const DATE_FMT: Option<&str> = None;
        /// `&["domingo", "lunes", "martes", "miércoles", "jueves", "viernes", "sábado"]`
        pub const DAY: &[&str] = &["domingo", "lunes", "martes", "miércoles", "jueves", "viernes", "sábado"];
        /// `"%d/%m/%y"`
        pub const D_FMT: &str = "%d/%m/%y";
        /// `"%a %d %b %Y %T %Z"`
        pub const D_T_FMT: &str = "%a %d %b %Y %T %Z";
        /// `None`
        pub const ERA: Option<&[&str]> = None;
        /// `None`
        pub const ERA_D_FMT: Option<&str> = None;
        /// `None`
        pub const ERA_D_T_FMT: Option<&str> = None;
        /// `None`
        pub const ERA_T_FMT: Option<&str> = None;
        /// `None`
        pub const FIRST_WEEKDAY: Option<i64> = None;
        /// `None`
        pub const FIRST_WORKDAY: Option<i64> = None;
        /// `&["enero", "febrero", "marzo", "abril", "mayo", "junio", "julio", "agosto", "septiembre", "octubre", "noviembre", "diciembre"]`
        pub const MON: &[&str] = &["enero", "febrero", "marzo", "abril", "mayo", "junio", "julio", "agosto", "septiembre", "octubre", "noviembre", "diciembre"];
        /// `"%T"`
        pub const T_FMT: &str = "%T";
        /// `"%I:%M:%S %p"`
        pub const T_FMT_AMPM: &str = "%I:%M:%S %p";
        /// `Some(&[7, 19971130, 1])`
        pub const WEEK: Option<&[i64]> = Some(&[7, 19971130, 1]);
    }
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod es_PA {
    pub mod LC_ADDRESS {
        /// `Some("PAN")`
        pub const COUNTRY_AB3: Option<&str> = Some("PAN");
        /// `Some("PA")`
        pub const COUNTRY_ABTWO: Option<&str> = Some("PA");
        /// `Some("PA")`
        pub const COUNTRY_CAR: Option<&str> = Some("PA");
        /// `None`
        pub const COUNTRY_ISBN: Option<&str> = None;
        /// `Some("Panamá")`
        pub const COUNTRY_NAME: Option<&str> = Some("Panamá");
        /// `Some(591)`
        pub const COUNTRY_NUM: Option<i64> = Some(591);
        /// `None`
        pub const COUNTRY_POST: Option<&str> = None;
        /// `Some("es")`
        pub const LANG_AB: Option<&str> = Some("es");
        /// `Some("spa")`
        pub const LANG_LIB: Option<&str> = Some("spa");
        /// `Some("español")`
        pub const LANG_NAME: Option<&str> = Some("español");
        /// `Some("spa")`
        pub const LANG_TERM: Option<&str> = Some("spa");
        /// `Some("%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%c%N")`
        pub const POSTAL_FMT: Option<&str> = Some("%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%c%N");
    }
    pub mod LC_IDENTIFICATION {
        /// `None`
        pub const ABBREVIATION: Option<&str> = None;
        /// `Some("Sankt Jørgens Alle 8, DK-1615 København V, Danmark")`
        pub const ADDRESS: Option<&str> = Some("Sankt Jørgens Alle 8, DK-1615 København V, Danmark");
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        /// ]
        /// ```
        pub const CATEGORY: Option<&[&[&str]]> = Some(&[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_TELEPHONE"],
            &["i18n:2012", "LC_MEASUREMENT"],
        ]);
        /// `Some("")`
        pub const CONTACT: Option<&str> = Some("");
        /// `Some("2000-06-29")`
        pub const DATE: Option<&str> = Some("2000-06-29");
        /// `Some("bug-glibc-locales@gnu.org")`
        pub const EMAIL: Option<&str> = Some("bug-glibc-locales@gnu.org");
        /// `Some("")`
        pub const FAX: Option<&str> = Some("");
        /// `Some("Spanish")`
        pub const LANGUAGE: Option<&str> = Some("Spanish");
        /// `Some("1.0")`
        pub const REVISION: Option<&str> = Some("1.0");
        /// `Some("RAP")`
        pub const SOURCE: Option<&str> = Some("RAP");
        /// `Some("")`
        pub const TEL: Option<&str> = Some("");
        /// `Some("Panama")`
        pub const TERRITORY: Option<&str> = Some("Panama");
        /// `Some("Spanish locale for Panama")`
        pub const TITLE: Option<&str> = Some("Spanish locale for Panama");
    }
    pub use super::es_ES::LC_MESSAGES;
    pub mod LC_MONETARY {
        /// `"B/."`
        pub const CURRENCY_SYMBOL: &str = "B/.";
        /// `2`
        pub const FRAC_DIGITS: i64 = 2;
        /// `"PAB "`
        pub const INT_CURR_SYMBOL: &str = "PAB ";
        /// `2`
        pub const INT_FRAC_DIGITS: i64 = 2;
        /// `None`
        pub const INT_N_CS_PRECEDES: Option<i64> = None;
        /// `None`
        pub const INT_N_SEP_BY_SPACE: Option<i64> = None;
        /// `None`
        pub const INT_N_SIGN_POSN: Option<i64> = None;
        /// `None`
        pub const INT_P_CS_PRECEDES: Option<i64> = None;
        /// `None`
        pub const INT_P_SEP_BY_SPACE: Option<i64> = None;
        /// `None`
        pub const INT_P_SIGN_POSN: Option<i64> = None;
        /// `"."`
        pub const MON_DECIMAL_POINT: &str = ".";
        /// `&[3, 3]`
        pub const MON_GROUPING: &[i64] = &[3, 3];
        /// `","`
        pub const MON_THOUSANDS_SEP: &str = ",";
        /// `"-"`
        pub const NEGATIVE_SIGN: &str = "-";
        /// `1`
        pub const N_CS_PRECEDES: i64 = 1;
        /// `1`
        pub const N_SEP_BY_SPACE: i64 = 1;
        /// `1`
        pub const N_SIGN_POSN: i64 = 1;
        /// `""`
        pub const POSITIVE_SIGN: &str = "";
        /// `1`
        pub const P_CS_PRECEDES: i64 = 1;
        /// `1`
        pub const P_SEP_BY_SPACE: i64 = 1;
        /// `1`
        pub const P_SIGN_POSN: i64 = 1;
    }
    pub mod LC_NUMERIC {
        /// `"."`
        pub const DECIMAL_POINT: &str = ".";
        /// `&[3, 3]`
        pub const GROUPING: &[i64] = &[3, 3];
        /// `","`
        pub const THOUSANDS_SEP: &str = ",";
    }
    pub mod LC_TELEPHONE {
        /// `Some("507")`
        pub const INT_PREFIX: Option<&str> = Some("507");
        /// `Some("00")`
        pub const INT_SELECT: Option<&str> = Some("00");
        /// `None`
        pub const TEL_DOM_FMT: Option<&str> = None;
        /// `Some("+%c %a %l")`
        pub const TEL_INT_FMT: Option<&str> = Some("+%c %a %l");
    }
    pub mod LC_TIME {
        /// `&["dom", "lun", "mar", "mié", "jue", "vie", "sáb"]`
        pub const ABDAY: &[&str] = &["dom", "lun", "mar", "mié", "jue", "vie", "sáb"];
        /// `&["ene", "feb", "mar", "abr", "may", "jun", "jul", "ago", "sep", "oct", "nov", "dic"]`
        pub const ABMON: &[&str] = &["ene", "feb", "mar", "abr", "may", "jun", "jul", "ago", "sep", "oct", "nov", "dic"];
        /// `None`
        pub const AB_ALT_MON: Option<&[&str]> = None;
        /// `None`
        pub const ALT_DIGITS: Option<&[&str]> = None;
        /// `None`
        pub const ALT_MON: Option<&[&str]> = None;
        /// `&["", ""]`
        pub const AM_PM: &[&str] = &["", ""];
        /// `None`
        pub const CAL_DIRECTION: Option<i64> = None;
        /// `None`
        pub const DATE_FMT: Option<&str> = None;
        /// `&["domingo", "lunes", "martes", "miércoles", "jueves", "viernes", "sábado"]`
        pub const DAY: &[&str] = &["domingo", "lunes", "martes", "miércoles", "jueves", "viernes", "sábado"];
        /// `"%d/%m/%y"`
        pub const D_FMT: &str = "%d/%m/%y";
        /// `"%a %d %b %Y %T %Z"`
        pub const D_T_FMT: &str = "%a %d %b %Y %T %Z";
        /// `None`
        pub const ERA: Option<&[&str]> = None;
        /// `None`
        pub const ERA_D_FMT: Option<&str> = None;
        /// `None`
        pub const ERA_D_T_FMT: Option<&str> = None;
        /// `None`
        pub const ERA_T_FMT: Option<&str> = None;
        /// `None`
        pub const FIRST_WEEKDAY: Option<i64> = None;
        /// `None`
        pub const FIRST_WORKDAY: Option<i64> = None;
        /// `&["enero", "febrero", "marzo", "abril", "mayo", "junio", "julio", "agosto", "septiembre", "octubre", "noviembre", "diciembre"]`
        pub const MON: &[&str] = &["enero", "febrero", "marzo", "abril", "mayo", "junio", "julio", "agosto", "septiembre", "octubre", "noviembre", "diciembre"];
        /// `"%T"`
        pub const T_FMT: &str = "%T";
        /// `""`
        pub const T_FMT_AMPM: &str = "";
        /// `Some(&[7, 19971130, 1])`
        pub const WEEK: Option<&[i64]> = Some(&[7, 19971130, 1]);
    }
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod es_PE {
    pub mod LC_ADDRESS {
        /// `Some("PER")`
        pub const COUNTRY_AB3: Option<&str> = Some("PER");
        /// `Some("PE")`
        pub const COUNTRY_ABTWO: Option<&str> = Some("PE");
        /// `Some("PE")`
        pub const COUNTRY_CAR: Option<&str> = Some("PE");
        /// `None`
        pub const COUNTRY_ISBN: Option<&str> = None;
        /// `Some("Perú")`
        pub const COUNTRY_NAME: Option<&str> = Some("Perú");
        /// `Some(604)`
        pub const COUNTRY_NUM: Option<i64> = Some(604);
        /// `None`
        pub const COUNTRY_POST: Option<&str> = None;
        /// `Some("es")`
        pub const LANG_AB: Option<&str> = Some("es");
        /// `Some("spa")`
        pub const LANG_LIB: Option<&str> = Some("spa");
        /// `Some("español")`
        pub const LANG_NAME: Option<&str> = Some("español");
        /// `Some("spa")`
        pub const LANG_TERM: Option<&str> = Some("spa");
        /// `Some("%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%c%N")`
        pub const POSTAL_FMT: Option<&str> = Some("%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%c%N");
    }
    pub mod LC_IDENTIFICATION {
        /// `None`
        pub const ABBREVIATION: Option<&str> = None;
        /// `Some("Sankt Jørgens Alle 8, DK-1615 København V, Danmark")`
        pub const ADDRESS: Option<&str> = Some("Sankt Jørgens Alle 8, DK-1615 København V, Danmark");
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        /// ]
        /// ```
        pub const CATEGORY: Option<&[&[&str]]> = Some(&[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_TELEPHONE"],
            &["i18n:2012", "LC_MEASUREMENT"],
        ]);
        /// `Some("")`
        pub const CONTACT: Option<&str> = Some("");
        /// `Some("2000-06-29")`
        pub const DATE: Option<&str> = Some("2000-06-29");
        /// `Some("bug-glibc-locales@gnu.org")`
        pub const EMAIL: Option<&str> = Some("bug-glibc-locales@gnu.org");
        /// `Some("")`
        pub const FAX: Option<&str> = Some("");
        /// `Some("Spanish")`
        pub const LANGUAGE: Option<&str> = Some("Spanish");
        /// `Some("1.0")`
        pub const REVISION: Option<&str> = Some("1.0");
        /// `Some("RAP")`
        pub const SOURCE: Option<&str> = Some("RAP");
        /// `Some("")`
        pub const TEL: Option<&str> = Some("");
        /// `Some("Peru")`
        pub const TERRITORY: Option<&str> = Some("Peru");
        /// `Some("Spanish locale for Peru")`
        pub const TITLE: Option<&str> = Some("Spanish locale for Peru");
    }
    pub use super::es_ES::LC_MESSAGES;
    pub mod LC_MONETARY {
        /// `"S/"`
        pub const CURRENCY_SYMBOL: &str = "S/";
        /// `2`
        pub const FRAC_DIGITS: i64 = 2;
        /// `"PEN "`
        pub const INT_CURR_SYMBOL: &str = "PEN ";
        /// `2`
        pub const INT_FRAC_DIGITS: i64 = 2;
        /// `None`
        pub const INT_N_CS_PRECEDES: Option<i64> = None;
        /// `None`
        pub const INT_N_SEP_BY_SPACE: Option<i64> = None;
        /// `None`
        pub const INT_N_SIGN_POSN: Option<i64> = None;
        /// `None`
        pub const INT_P_CS_PRECEDES: Option<i64> = None;
        /// `None`
        pub const INT_P_SEP_BY_SPACE: Option<i64> = None;
        /// `None`
        pub const INT_P_SIGN_POSN: Option<i64> = None;
        /// `"."`
        pub const MON_DECIMAL_POINT: &str = ".";
        /// `&[3, 3]`
        pub const MON_GROUPING: &[i64] = &[3, 3];
        /// `","`
        pub const MON_THOUSANDS_SEP: &str = ",";
        /// `"-"`
        pub const NEGATIVE_SIGN: &str = "-";
        /// `1`
        pub const N_CS_PRECEDES: i64 = 1;
        /// `1`
        pub const N_SEP_BY_SPACE: i64 = 1;
        /// `1`
        pub const N_SIGN_POSN: i64 = 1;
        /// `""`
        pub const POSITIVE_SIGN: &str = "";
        /// `1`
        pub const P_CS_PRECEDES: i64 = 1;
        /// `1`
        pub const P_SEP_BY_SPACE: i64 = 1;
        /// `1`
        pub const P_SIGN_POSN: i64 = 1;
    }
    pub use super::es_ES::LC_NUMERIC;
    pub mod LC_TELEPHONE {
        /// `Some("51")`
        pub const INT_PREFIX: Option<&str> = Some("51");
        /// `Some("00")`
        pub const INT_SELECT: Option<&str> = Some("00");
        /// `None`
        pub const TEL_DOM_FMT: Option<&str> = None;
        /// `Some("+%c %a %l")`
        pub const TEL_INT_FMT: Option<&str> = Some("+%c %a %l");
    }
    pub mod LC_TIME {
        /// `&["dom", "lun", "mar", "mié", "jue", "vie", "sáb"]`
        pub const ABDAY: &[&str] = &["dom", "lun", "mar", "mié", "jue", "vie", "sáb"];
        /// `&["ene", "feb", "mar", "abr", "may", "jun", "jul", "ago", "set", "oct", "nov", "dic"]`
        pub const ABMON: &[&str] = &["ene", "feb", "mar", "abr", "may", "jun", "jul", "ago", "set", "oct", "nov", "dic"];
        /// `None`
        pub const AB_ALT_MON: Option<&[&str]> = None;
        /// `None`
        pub const ALT_DIGITS: Option<&[&str]> = None;
        /// `None`
        pub const ALT_MON: Option<&[&str]> = None;
        /// `&["AM", "PM"]`
        pub const AM_PM: &[&str] = &["AM", "PM"];
        /// `None`
        pub const CAL_DIRECTION: Option<i64> = None;
        /// `None`
        pub const DATE_FMT: Option<&str> = None;
        /// `&["domingo", "lunes", "martes", "miércoles", "jueves", "viernes", "sábado"]`
        pub const DAY: &[&str] = &["domingo", "lunes", "martes", "miércoles", "jueves", "viernes", "sábado"];
        /// `"%d/%m/%y"`
        pub const D_FMT: &str = "%d/%m/%y";
        /// `"%a %d %b %Y %T %Z"`
        pub const D_T_FMT: &str = "%a %d %b %Y %T %Z";
        /// `None`
        pub const ERA: Option<&[&str]> = None;
        /// `None`
        pub const ERA_D_FMT: Option<&str> = None;
        /// `None`
        pub const ERA_D_T_FMT: Option<&str> = None;
        /// `None`
        pub const ERA_T_FMT: Option<&str> = None;
        /// `None`
        pub const FIRST_WEEKDAY: Option<i64> = None;
        /// `None`
        pub const FIRST_WORKDAY: Option<i64> = None;
        /// `&["enero", "febrero", "marzo", "abril", "mayo", "junio", "julio", "agosto", "setiembre", "octubre", "noviembre", "diciembre"]`
        pub const MON: &[&str] = &["enero", "febrero", "marzo", "abril", "mayo", "junio", "julio", "agosto", "setiembre", "octubre", "noviembre", "diciembre"];
        /// `"%T"`
        pub const T_FMT: &str = "%T";
        /// `"%I:%M:%S %p"`
        pub const T_FMT_AMPM: &str = "%I:%M:%S %p";
        /// `Some(&[7, 19971130, 1])`
        pub const WEEK: Option<&[i64]> = Some(&[7, 19971130, 1]);
    }
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod es_PR {
    pub mod LC_ADDRESS {
        /// `Some("PRI")`
        pub const COUNTRY_AB3: Option<&str> = Some("PRI");
        /// `Some("PR")`
        pub const COUNTRY_ABTWO: Option<&str> = Some("PR");
        /// `Some("PR")`
        pub const COUNTRY_CAR: Option<&str> = Some("PR");
        /// `None`
        pub const COUNTRY_ISBN: Option<&str> = None;
        /// `Some("Puerto Rico")`
        pub const COUNTRY_NAME: Option<&str> = Some("Puerto Rico");
        /// `Some(630)`
        pub const COUNTRY_NUM: Option<i64> = Some(630);
        /// `None`
        pub const COUNTRY_POST: Option<&str> = None;
        /// `Some("es")`
        pub const LANG_AB: Option<&str> = Some("es");
        /// `Some("spa")`
        pub const LANG_LIB: Option<&str> = Some("spa");
        /// `Some("español")`
        pub const LANG_NAME: Option<&str> = Some("español");
        /// `Some("spa")`
        pub const LANG_TERM: Option<&str> = Some("spa");
        /// `Some("%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%c%N")`
        pub const POSTAL_FMT: Option<&str> = Some("%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%c%N");
    }
    pub mod LC_IDENTIFICATION {
        /// `None`
        pub const ABBREVIATION: Option<&str> = None;
        /// `Some("https://www.gnu.org/software/libc/")`
        pub const ADDRESS: Option<&str> = Some("https://www.gnu.org/software/libc/");
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        /// ]
        /// ```
        pub const CATEGORY: Option<&[&[&str]]> = Some(&[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_TELEPHONE"],
            &["i18n:2012", "LC_MEASUREMENT"],
        ]);
        /// `Some("")`
        pub const CONTACT: Option<&str> = Some("");
        /// `Some("2000-08-21")`
        pub const DATE: Option<&str> = Some("2000-08-21");
        /// `Some("bug-glibc-locales@gnu.org")`
        pub const EMAIL: Option<&str> = Some("bug-glibc-locales@gnu.org");
        /// `Some("")`
        pub const FAX: Option<&str> = Some("");
        /// `Some("Spanish")`
        pub const LANGUAGE: Option<&str> = Some("Spanish");
        /// `Some("1.0")`
        pub const REVISION: Option<&str> = Some("1.0");
        /// `Some("Free Software Foundation, Inc.")`
        pub const SOURCE: Option<&str> = Some("Free Software Foundation, Inc.");
        /// `Some("")`
        pub const TEL: Option<&str> = Some("");
        /// `Some("Puerto Rico")`
        pub const TERRITORY: Option<&str> = Some("Puerto Rico");
        /// `Some("Spanish locale for Puerto Rico")`
        pub const TITLE: Option<&str> = Some("Spanish locale for Puerto Rico");
    }
    pub use super::es_ES::LC_MESSAGES;
    pub mod LC_MONETARY {
        /// `"$"`
        pub const CURRENCY_SYMBOL: &str = "$";
        /// `2`
        pub const FRAC_DIGITS: i64 = 2;
        /// `"USD "`
        pub const INT_CURR_SYMBOL: &str = "USD ";
        /// `2`
        pub const INT_FRAC_DIGITS: i64 = 2;
        /// `None`
        pub const INT_N_CS_PRECEDES: Option<i64> = None;
        /// `None`
        pub const INT_N_SEP_BY_SPACE: Option<i64> = None;
        /// `None`
        pub const INT_N_SIGN_POSN: Option<i64> = None;
        /// `None`
        pub const INT_P_CS_PRECEDES: Option<i64> = None;
        /// `None`
        pub const INT_P_SEP_BY_SPACE: Option<i64> = None;
        /// `None`
        pub const INT_P_SIGN_POSN: Option<i64> = None;
        /// `"."`
        pub const MON_DECIMAL_POINT: &str = ".";
        /// `&[3, 3]`
        pub const MON_GROUPING: &[i64] = &[3, 3];
        /// `","`
        pub const MON_THOUSANDS_SEP: &str = ",";
        /// `"-"`
        pub const NEGATIVE_SIGN: &str = "-";
        /// `1`
        pub const N_CS_PRECEDES: i64 = 1;
        /// `1`
        pub const N_SEP_BY_SPACE: i64 = 1;
        /// `1`
        pub const N_SIGN_POSN: i64 = 1;
        /// `""`
        pub const POSITIVE_SIGN: &str = "";
        /// `1`
        pub const P_CS_PRECEDES: i64 = 1;
        /// `1`
        pub const P_SEP_BY_SPACE: i64 = 1;
        /// `1`
        pub const P_SIGN_POSN: i64 = 1;
    }
    pub mod LC_NUMERIC {
        /// `"."`
        pub const DECIMAL_POINT: &str = ".";
        /// `&[3, 3]`
        pub const GROUPING: &[i64] = &[3, 3];
        /// `","`
        pub const THOUSANDS_SEP: &str = ",";
    }
    pub mod LC_TELEPHONE {
        /// `Some("1")`
        pub const INT_PREFIX: Option<&str> = Some("1");
        /// `Some("011")`
        pub const INT_SELECT: Option<&str> = Some("011");
        /// `None`
        pub const TEL_DOM_FMT: Option<&str> = None;
        /// `Some("+%c %a %l")`
        pub const TEL_INT_FMT: Option<&str> = Some("+%c %a %l");
    }
    pub mod LC_TIME {
        /// `&["dom", "lun", "mar", "mié", "jue", "vie", "sáb"]`
        pub const ABDAY: &[&str] = &["dom", "lun", "mar", "mié", "jue", "vie", "sáb"];
        /// `&["ene", "feb", "mar", "abr", "may", "jun", "jul", "ago", "sep", "oct", "nov", "dic"]`
        pub const ABMON: &[&str] = &["ene", "feb", "mar", "abr", "may", "jun", "jul", "ago", "sep", "oct", "nov", "dic"];
        /// `None`
        pub const AB_ALT_MON: Option<&[&str]> = None;
        /// `None`
        pub const ALT_DIGITS: Option<&[&str]> = None;
        /// `None`
        pub const ALT_MON: Option<&[&str]> = None;
        /// `&["", ""]`
        pub const AM_PM: &[&str] = &["", ""];
        /// `None`
        pub const CAL_DIRECTION: Option<i64> = None;
        /// `None`
        pub const DATE_FMT: Option<&str> = None;
        /// `&["domingo", "lunes", "martes", "miércoles", "jueves", "viernes", "sábado"]`
        pub const DAY: &[&str] = &["domingo", "lunes", "martes", "miércoles", "jueves", "viernes", "sábado"];
        /// `"%d/%m/%y"`
        pub const D_FMT: &str = "%d/%m/%y";
        /// `"%a %d %b %Y %T %Z"`
        pub const D_T_FMT: &str = "%a %d %b %Y %T %Z";
        /// `None`
        pub const ERA: Option<&[&str]> = None;
        /// `None`
        pub const ERA_D_FMT: Option<&str> = None;
        /// `None`
        pub const ERA_D_T_FMT: Option<&str> = None;
        /// `None`
        pub const ERA_T_FMT: Option<&str> = None;
        /// `None`
        pub const FIRST_WEEKDAY: Option<i64> = None;
        /// `None`
        pub const FIRST_WORKDAY: Option<i64> = None;
        /// `&["enero", "febrero", "marzo", "abril", "mayo", "junio", "julio", "agosto", "septiembre", "octubre", "noviembre", "diciembre"]`
        pub const MON: &[&str] = &["enero", "febrero", "marzo", "abril", "mayo", "junio", "julio", "agosto", "septiembre", "octubre", "noviembre", "diciembre"];
        /// `"%T"`
        pub const T_FMT: &str = "%T";
        /// `""`
        pub const T_FMT_AMPM: &str = "";
        /// `Some(&[7, 19971130, 1])`
        pub const WEEK: Option<&[i64]> = Some(&[7, 19971130, 1]);
    }
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod es_PY {
    pub mod LC_ADDRESS {
        /// `Some("PRY")`
        pub const COUNTRY_AB3: Option<&str> = Some("PRY");
        /// `Some("PY")`
        pub const COUNTRY_ABTWO: Option<&str> = Some("PY");
        /// `Some("PY")`
        pub const COUNTRY_CAR: Option<&str> = Some("PY");
        /// `None`
        pub const COUNTRY_ISBN: Option<&str> = None;
        /// `Some("Paraguay")`
        pub const COUNTRY_NAME: Option<&str> = Some("Paraguay");
        /// `Some(600)`
        pub const COUNTRY_NUM: Option<i64> = Some(600);
        /// `None`
        pub const COUNTRY_POST: Option<&str> = None;
        /// `Some("es")`
        pub const LANG_AB: Option<&str> = Some("es");
        /// `Some("spa")`
        pub const LANG_LIB: Option<&str> = Some("spa");
        /// `Some("español")`
        pub const LANG_NAME: Option<&str> = Some("español");
        /// `Some("spa")`
        pub const LANG_TERM: Option<&str> = Some("spa");
        /// `Some("%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%c%N")`
        pub const POSTAL_FMT: Option<&str> = Some("%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%c%N");
    }
    pub mod LC_IDENTIFICATION {
        /// `None`
        pub const ABBREVIATION: Option<&str> = None;
        /// `Some("Sankt Jørgens Alle 8, DK-1615 København V, Danmark")`
        pub const ADDRESS: Option<&str> = Some("Sankt Jørgens Alle 8, DK-1615 København V, Danmark");
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        /// ]
        /// ```
        pub const CATEGORY: Option<&[&[&str]]> = Some(&[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_TELEPHONE"],
            &["i18n:2012", "LC_MEASUREMENT"],
        ]);
        /// `Some("")`
        pub const CONTACT: Option<&str> = Some("");
        /// `Some("2000-06-29")`
        pub const DATE: Option<&str> = Some("2000-06-29");
        /// `Some("bug-glibc-locales@gnu.org")`
        pub const EMAIL: Option<&str> = Some("bug-glibc-locales@gnu.org");
        /// `Some("")`
        pub const FAX: Option<&str> = Some("");
        /// `Some("Spanish")`
        pub const LANGUAGE: Option<&str> = Some("Spanish");
        /// `Some("1.0")`
        pub const REVISION: Option<&str> = Some("1.0");
        /// `Some("RAP")`
        pub const SOURCE: Option<&str> = Some("RAP");
        /// `Some("")`
        pub const TEL: Option<&str> = Some("");
        /// `Some("Paraguay")`
        pub const TERRITORY: Option<&str> = Some("Paraguay");
        /// `Some("Spanish locale for Paraguay")`
        pub const TITLE: Option<&str> = Some("Spanish locale for Paraguay");
    }
    pub use super::es_ES::LC_MESSAGES;
    pub mod LC_MONETARY {
        /// `"Gs."`
        pub const CURRENCY_SYMBOL: &str = "Gs.";
        /// `2`
        pub const FRAC_DIGITS: i64 = 2;
        /// `"PYG "`
        pub const INT_CURR_SYMBOL: &str = "PYG ";
        /// `2`
        pub const INT_FRAC_DIGITS: i64 = 2;
        /// `None`
        pub const INT_N_CS_PRECEDES: Option<i64> = None;
        /// `None`
        pub const INT_N_SEP_BY_SPACE: Option<i64> = None;
        /// `None`
        pub const INT_N_SIGN_POSN: Option<i64> = None;
        /// `None`
        pub const INT_P_CS_PRECEDES: Option<i64> = None;
        /// `None`
        pub const INT_P_SEP_BY_SPACE: Option<i64> = None;
        /// `None`
        pub const INT_P_SIGN_POSN: Option<i64> = None;
        /// `","`
        pub const MON_DECIMAL_POINT: &str = ",";
        /// `&[3, 3]`
        pub const MON_GROUPING: &[i64] = &[3, 3];
        /// `"."`
        pub const MON_THOUSANDS_SEP: &str = ".";
        /// `"-"`
        pub const NEGATIVE_SIGN: &str = "-";
        /// `1`
        pub const N_CS_PRECEDES: i64 = 1;
        /// `1`
        pub const N_SEP_BY_SPACE: i64 = 1;
        /// `1`
        pub const N_SIGN_POSN: i64 = 1;
        /// `""`
        pub const POSITIVE_SIGN: &str = "";
        /// `1`
        pub const P_CS_PRECEDES: i64 = 1;
        /// `1`
        pub const P_SEP_BY_SPACE: i64 = 1;
        /// `1`
        pub const P_SIGN_POSN: i64 = 1;
    }
    pub use super::es_ES::LC_NUMERIC;
    pub mod LC_TELEPHONE {
        /// `Some("595")`
        pub const INT_PREFIX: Option<&str> = Some("595");
        /// `Some("00")`
        pub const INT_SELECT: Option<&str> = Some("00");
        /// `None`
        pub const TEL_DOM_FMT: Option<&str> = None;
        /// `Some("+%c %a %l")`
        pub const TEL_INT_FMT: Option<&str> = Some("+%c %a %l");
    }
    pub mod LC_TIME {
        /// `&["dom", "lun", "mar", "mié", "jue", "vie", "sáb"]`
        pub const ABDAY: &[&str] = &["dom", "lun", "mar", "mié", "jue", "vie", "sáb"];
        /// `&["ene", "feb", "mar", "abr", "may", "jun", "jul", "ago", "sep", "oct", "nov", "dic"]`
        pub const ABMON: &[&str] = &["ene", "feb", "mar", "abr", "may", "jun", "jul", "ago", "sep", "oct", "nov", "dic"];
        /// `None`
        pub const AB_ALT_MON: Option<&[&str]> = None;
        /// `None`
        pub const ALT_DIGITS: Option<&[&str]> = None;
        /// `None`
        pub const ALT_MON: Option<&[&str]> = None;
        /// `&["", ""]`
        pub const AM_PM: &[&str] = &["", ""];
        /// `None`
        pub const CAL_DIRECTION: Option<i64> = None;
        /// `None`
        pub const DATE_FMT: Option<&str> = None;
        /// `&["domingo", "lunes", "martes", "miércoles", "jueves", "viernes", "sábado"]`
        pub const DAY: &[&str] = &["domingo", "lunes", "martes", "miércoles", "jueves", "viernes", "sábado"];
        /// `"%d/%m/%y"`
        pub const D_FMT: &str = "%d/%m/%y";
        /// `"%a %d %b %Y %T %Z"`
        pub const D_T_FMT: &str = "%a %d %b %Y %T %Z";
        /// `None`
        pub const ERA: Option<&[&str]> = None;
        /// `None`
        pub const ERA_D_FMT: Option<&str> = None;
        /// `None`
        pub const ERA_D_T_FMT: Option<&str> = None;
        /// `None`
        pub const ERA_T_FMT: Option<&str> = None;
        /// `None`
        pub const FIRST_WEEKDAY: Option<i64> = None;
        /// `None`
        pub const FIRST_WORKDAY: Option<i64> = None;
        /// `&["enero", "febrero", "marzo", "abril", "mayo", "junio", "julio", "agosto", "septiembre", "octubre", "noviembre", "diciembre"]`
        pub const MON: &[&str] = &["enero", "febrero", "marzo", "abril", "mayo", "junio", "julio", "agosto", "septiembre", "octubre", "noviembre", "diciembre"];
        /// `"%T"`
        pub const T_FMT: &str = "%T";
        /// `""`
        pub const T_FMT_AMPM: &str = "";
        /// `Some(&[7, 19971130, 1])`
        pub const WEEK: Option<&[i64]> = Some(&[7, 19971130, 1]);
    }
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod es_SV {
    pub mod LC_ADDRESS {
        /// `Some("SLV")`
        pub const COUNTRY_AB3: Option<&str> = Some("SLV");
        /// `Some("SV")`
        pub const COUNTRY_ABTWO: Option<&str> = Some("SV");
        /// `Some("ES")`
        pub const COUNTRY_CAR: Option<&str> = Some("ES");
        /// `None`
        pub const COUNTRY_ISBN: Option<&str> = None;
        /// `Some("El Salvador")`
        pub const COUNTRY_NAME: Option<&str> = Some("El Salvador");
        /// `Some(222)`
        pub const COUNTRY_NUM: Option<i64> = Some(222);
        /// `None`
        pub const COUNTRY_POST: Option<&str> = None;
        /// `Some("es")`
        pub const LANG_AB: Option<&str> = Some("es");
        /// `Some("spa")`
        pub const LANG_LIB: Option<&str> = Some("spa");
        /// `Some("español")`
        pub const LANG_NAME: Option<&str> = Some("español");
        /// `Some("spa")`
        pub const LANG_TERM: Option<&str> = Some("spa");
        /// `Some("%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%c%N")`
        pub const POSTAL_FMT: Option<&str> = Some("%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%c%N");
    }
    pub mod LC_IDENTIFICATION {
        /// `None`
        pub const ABBREVIATION: Option<&str> = None;
        /// `Some("Sankt Jørgens Alle 8, DK-1615 København V, Danmark")`
        pub const ADDRESS: Option<&str> = Some("Sankt Jørgens Alle 8, DK-1615 København V, Danmark");
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        /// ]
        /// ```
        pub const CATEGORY: Option<&[&[&str]]> = Some(&[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_TELEPHONE"],
            &["i18n:2012", "LC_MEASUREMENT"],
        ]);
        /// `Some("")`
        pub const CONTACT: Option<&str> = Some("");
        /// `Some("2000-06-29")`
        pub const DATE: Option<&str> = Some("2000-06-29");
        /// `Some("bug-glibc-locales@gnu.org")`
        pub const EMAIL: Option<&str> = Some("bug-glibc-locales@gnu.org");
        /// `Some("")`
        pub const FAX: Option<&str> = Some("");
        /// `Some("Spanish")`
        pub const LANGUAGE: Option<&str> = Some("Spanish");
        /// `Some("1.0")`
        pub const REVISION: Option<&str> = Some("1.0");
        /// `Some("RAP")`
        pub const SOURCE: Option<&str> = Some("RAP");
        /// `Some("")`
        pub const TEL: Option<&str> = Some("");
        /// `Some("El Salvador")`
        pub const TERRITORY: Option<&str> = Some("El Salvador");
        /// `Some("Spanish locale for El Salvador")`
        pub const TITLE: Option<&str> = Some("Spanish locale for El Salvador");
    }
    pub use super::es_ES::LC_MESSAGES;
    pub mod LC_MONETARY {
        /// `"$"`
        pub const CURRENCY_SYMBOL: &str = "$";
        /// `2`
        pub const FRAC_DIGITS: i64 = 2;
        /// `"USD "`
        pub const INT_CURR_SYMBOL: &str = "USD ";
        /// `2`
        pub const INT_FRAC_DIGITS: i64 = 2;
        /// `None`
        pub const INT_N_CS_PRECEDES: Option<i64> = None;
        /// `None`
        pub const INT_N_SEP_BY_SPACE: Option<i64> = None;
        /// `None`
        pub const INT_N_SIGN_POSN: Option<i64> = None;
        /// `None`
        pub const INT_P_CS_PRECEDES: Option<i64> = None;
        /// `None`
        pub const INT_P_SEP_BY_SPACE: Option<i64> = None;
        /// `None`
        pub const INT_P_SIGN_POSN: Option<i64> = None;
        /// `"."`
        pub const MON_DECIMAL_POINT: &str = ".";
        /// `&[3, 3]`
        pub const MON_GROUPING: &[i64] = &[3, 3];
        /// `","`
        pub const MON_THOUSANDS_SEP: &str = ",";
        /// `"-"`
        pub const NEGATIVE_SIGN: &str = "-";
        /// `1`
        pub const N_CS_PRECEDES: i64 = 1;
        /// `1`
        pub const N_SEP_BY_SPACE: i64 = 1;
        /// `1`
        pub const N_SIGN_POSN: i64 = 1;
        /// `""`
        pub const POSITIVE_SIGN: &str = "";
        /// `1`
        pub const P_CS_PRECEDES: i64 = 1;
        /// `1`
        pub const P_SEP_BY_SPACE: i64 = 1;
        /// `1`
        pub const P_SIGN_POSN: i64 = 1;
    }
    pub mod LC_NUMERIC {
        /// `"."`
        pub const DECIMAL_POINT: &str = ".";
        /// `&[3, 3]`
        pub const GROUPING: &[i64] = &[3, 3];
        /// `","`
        pub const THOUSANDS_SEP: &str = ",";
    }
    pub mod LC_TELEPHONE {
        /// `Some("503")`
        pub const INT_PREFIX: Option<&str> = Some("503");
        /// `Some("00")`
        pub const INT_SELECT: Option<&str> = Some("00");
        /// `None`
        pub const TEL_DOM_FMT: Option<&str> = None;
        /// `Some("+%c %a %l")`
        pub const TEL_INT_FMT: Option<&str> = Some("+%c %a %l");
    }
    pub mod LC_TIME {
        /// `&["dom", "lun", "mar", "mié", "jue", "vie", "sáb"]`
        pub const ABDAY: &[&str] = &["dom", "lun", "mar", "mié", "jue", "vie", "sáb"];
        /// `&["ene", "feb", "mar", "abr", "may", "jun", "jul", "ago", "sep", "oct", "nov", "dic"]`
        pub const ABMON: &[&str] = &["ene", "feb", "mar", "abr", "may", "jun", "jul", "ago", "sep", "oct", "nov", "dic"];
        /// `None`
        pub const AB_ALT_MON: Option<&[&str]> = None;
        /// `None`
        pub const ALT_DIGITS: Option<&[&str]> = None;
        /// `None`
        pub const ALT_MON: Option<&[&str]> = None;
        /// `&["", ""]`
        pub const AM_PM: &[&str] = &["", ""];
        /// `None`
        pub const CAL_DIRECTION: Option<i64> = None;
        /// `None`
        pub const DATE_FMT: Option<&str> = None;
        /// `&["domingo", "lunes", "martes", "miércoles", "jueves", "viernes", "sábado"]`
        pub const DAY: &[&str] = &["domingo", "lunes", "martes", "miércoles", "jueves", "viernes", "sábado"];
        /// `"%d/%m/%y"`
        pub const D_FMT: &str = "%d/%m/%y";
        /// `"%a %d %b %Y %T %Z"`
        pub const D_T_FMT: &str = "%a %d %b %Y %T %Z";
        /// `None`
        pub const ERA: Option<&[&str]> = None;
        /// `None`
        pub const ERA_D_FMT: Option<&str> = None;
        /// `None`
        pub const ERA_D_T_FMT: Option<&str> = None;
        /// `None`
        pub const ERA_T_FMT: Option<&str> = None;
        /// `None`
        pub const FIRST_WEEKDAY: Option<i64> = None;
        /// `None`
        pub const FIRST_WORKDAY: Option<i64> = None;
        /// `&["enero", "febrero", "marzo", "abril", "mayo", "junio", "julio", "agosto", "septiembre", "octubre", "noviembre", "diciembre"]`
        pub const MON: &[&str] = &["enero", "febrero", "marzo", "abril", "mayo", "junio", "julio", "agosto", "septiembre", "octubre", "noviembre", "diciembre"];
        /// `"%T"`
        pub const T_FMT: &str = "%T";
        /// `""`
        pub const T_FMT_AMPM: &str = "";
        /// `Some(&[7, 19971130, 1])`
        pub const WEEK: Option<&[i64]> = Some(&[7, 19971130, 1]);
    }
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod es_US {
    pub mod LC_ADDRESS {
        /// `Some("USA")`
        pub const COUNTRY_AB3: Option<&str> = Some("USA");
        /// `Some("US")`
        pub const COUNTRY_ABTWO: Option<&str> = Some("US");
        /// `Some("USA")`
        pub const COUNTRY_CAR: Option<&str> = Some("USA");
        /// `Some("0")`
        pub const COUNTRY_ISBN: Option<&str> = Some("0");
        /// `Some("Estados Unidos")`
        pub const COUNTRY_NAME: Option<&str> = Some("Estados Unidos");
        /// `Some(840)`
        pub const COUNTRY_NUM: Option<i64> = Some(840);
        /// `Some("USA")`
        pub const COUNTRY_POST: Option<&str> = Some("USA");
        /// `Some("es")`
        pub const LANG_AB: Option<&str> = Some("es");
        /// `Some("spa")`
        pub const LANG_LIB: Option<&str> = Some("spa");
        /// `Some("español")`
        pub const LANG_NAME: Option<&str> = Some("español");
        /// `Some("spa")`
        pub const LANG_TERM: Option<&str> = Some("spa");
        /// `Some("%a%N%f%N%d%N%b%N%h %s %e %r%N%T, %S %z%N%c%N")`
        pub const POSTAL_FMT: Option<&str> = Some("%a%N%f%N%d%N%b%N%h %s %e %r%N%T, %S %z%N%c%N");
    }
    pub mod LC_IDENTIFICATION {
        /// `None`
        pub const ABBREVIATION: Option<&str> = None;
        /// `Some("Sankt Jørgens Alle 8, DK-1615 København V, Danmark")`
        pub const ADDRESS: Option<&str> = Some("Sankt Jørgens Alle 8, DK-1615 København V, Danmark");
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        /// ]
        /// ```
        pub const CATEGORY: Option<&[&[&str]]> = Some(&[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_TELEPHONE"],
            &["i18n:2012", "LC_MEASUREMENT"],
        ]);
        /// `Some("")`
        pub const CONTACT: Option<&str> = Some("");
        /// `Some("2000-06-29")`
        pub const DATE: Option<&str> = Some("2000-06-29");
        /// `Some("bug-glibc-locales@gnu.org")`
        pub const EMAIL: Option<&str> = Some("bug-glibc-locales@gnu.org");
        /// `Some("")`
        pub const FAX: Option<&str> = Some("");
        /// `Some("Spanish")`
        pub const LANGUAGE: Option<&str> = Some("Spanish");
        /// `Some("1.0")`
        pub const REVISION: Option<&str> = Some("1.0");
        /// `Some("RAP")`
        pub const SOURCE: Option<&str> = Some("RAP");
        /// `Some("")`
        pub const TEL: Option<&str> = Some("");
        /// `Some("United States")`
        pub const TERRITORY: Option<&str> = Some("United States");
        /// `Some("Spanish locale for the USA")`
        pub const TITLE: Option<&str> = Some("Spanish locale for the USA");
    }
    pub use super::es_ES::LC_MESSAGES;
    pub mod LC_MONETARY {
        /// `"$"`
        pub const CURRENCY_SYMBOL: &str = "$";
        /// `2`
        pub const FRAC_DIGITS: i64 = 2;
        /// `"USD "`
        pub const INT_CURR_SYMBOL: &str = "USD ";
        /// `2`
        pub const INT_FRAC_DIGITS: i64 = 2;
        /// `None`
        pub const INT_N_CS_PRECEDES: Option<i64> = None;
        /// `None`
        pub const INT_N_SEP_BY_SPACE: Option<i64> = None;
        /// `None`
        pub const INT_N_SIGN_POSN: Option<i64> = None;
        /// `None`
        pub const INT_P_CS_PRECEDES: Option<i64> = None;
        /// `None`
        pub const INT_P_SEP_BY_SPACE: Option<i64> = None;
        /// `None`
        pub const INT_P_SIGN_POSN: Option<i64> = None;
        /// `"."`
        pub const MON_DECIMAL_POINT: &str = ".";
        /// `&[3, 3]`
        pub const MON_GROUPING: &[i64] = &[3, 3];
        /// `","`
        pub const MON_THOUSANDS_SEP: &str = ",";
        /// `"-"`
        pub const NEGATIVE_SIGN: &str = "-";
        /// `1`
        pub const N_CS_PRECEDES: i64 = 1;
        /// `0`
        pub const N_SEP_BY_SPACE: i64 = 0;
        /// `1`
        pub const N_SIGN_POSN: i64 = 1;
        /// `""`
        pub const POSITIVE_SIGN: &str = "";
        /// `1`
        pub const P_CS_PRECEDES: i64 = 1;
        /// `0`
        pub const P_SEP_BY_SPACE: i64 = 0;
        /// `1`
        pub const P_SIGN_POSN: i64 = 1;
    }
    pub use super::en_US::LC_NUMERIC;
    pub mod LC_TELEPHONE {
        /// `Some("1")`
        pub const INT_PREFIX: Option<&str> = Some("1");
        /// `Some("11")`
        pub const INT_SELECT: Option<&str> = Some("11");
        /// `None`
        pub const TEL_DOM_FMT: Option<&str> = None;
        /// `Some("+%c %a %l")`
        pub const TEL_INT_FMT: Option<&str> = Some("+%c %a %l");
    }
    pub mod LC_TIME {
        /// `&["dom", "lun", "mar", "mié", "jue", "vie", "sáb"]`
        pub const ABDAY: &[&str] = &["dom", "lun", "mar", "mié", "jue", "vie", "sáb"];
        /// `&["ene", "feb", "mar", "abr", "may", "jun", "jul", "ago", "sep", "oct", "nov", "dic"]`
        pub const ABMON: &[&str] = &["ene", "feb", "mar", "abr", "may", "jun", "jul", "ago", "sep", "oct", "nov", "dic"];
        /// `None`
        pub const AB_ALT_MON: Option<&[&str]> = None;
        /// `None`
        pub const ALT_DIGITS: Option<&[&str]> = None;
        /// `None`
        pub const ALT_MON: Option<&[&str]> = None;
        /// `&["", ""]`
        pub const AM_PM: &[&str] = &["", ""];
        /// `None`
        pub const CAL_DIRECTION: Option<i64> = None;
        /// `None`
        pub const DATE_FMT: Option<&str> = None;
        /// `&["domingo", "lunes", "martes", "miércoles", "jueves", "viernes", "sábado"]`
        pub const DAY: &[&str] = &["domingo", "lunes", "martes", "miércoles", "jueves", "viernes", "sábado"];
        /// `"%d/%m/%y"`
        pub const D_FMT: &str = "%d/%m/%y";
        /// `"%a %d %b %Y %T %Z"`
        pub const D_T_FMT: &str = "%a %d %b %Y %T %Z";
        /// `None`
        pub const ERA: Option<&[&str]> = None;
        /// `None`
        pub const ERA_D_FMT: Option<&str> = None;
        /// `None`
        pub const ERA_D_T_FMT: Option<&str> = None;
        /// `None`
        pub const ERA_T_FMT: Option<&str> = None;
        /// `None`
        pub const FIRST_WEEKDAY: Option<i64> = None;
        /// `None`
        pub const FIRST_WORKDAY: Option<i64> = None;
        /// `&["enero", "febrero", "marzo", "abril", "mayo", "junio", "julio", "agosto", "septiembre", "octubre", "noviembre", "diciembre"]`
        pub const MON: &[&str] = &["enero", "febrero", "marzo", "abril", "mayo", "junio", "julio", "agosto", "septiembre", "octubre", "noviembre", "diciembre"];
        /// `"%T"`
        pub const T_FMT: &str = "%T";
        /// `""`
        pub const T_FMT_AMPM: &str = "";
        /// `Some(&[7, 19971130, 1])`
        pub const WEEK: Option<&[i64]> = Some(&[7, 19971130, 1]);
    }
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod es_UY {
    pub mod LC_ADDRESS {
        /// `Some("URY")`
        pub const COUNTRY_AB3: Option<&str> = Some("URY");
        /// `Some("UY")`
        pub const COUNTRY_ABTWO: Option<&str> = Some("UY");
        /// `Some("UY")`
        pub const COUNTRY_CAR: Option<&str> = Some("UY");
        /// `None`
        pub const COUNTRY_ISBN: Option<&str> = None;
        /// `Some("Uruguay")`
        pub const COUNTRY_NAME: Option<&str> = Some("Uruguay");
        /// `Some(858)`
        pub const COUNTRY_NUM: Option<i64> = Some(858);
        /// `None`
        pub const COUNTRY_POST: Option<&str> = None;
        /// `Some("es")`
        pub const LANG_AB: Option<&str> = Some("es");
        /// `Some("spa")`
        pub const LANG_LIB: Option<&str> = Some("spa");
        /// `Some("español")`
        pub const LANG_NAME: Option<&str> = Some("español");
        /// `Some("spa")`
        pub const LANG_TERM: Option<&str> = Some("spa");
        /// `Some("%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%c%N")`
        pub const POSTAL_FMT: Option<&str> = Some("%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%c%N");
    }
    pub mod LC_IDENTIFICATION {
        /// `None`
        pub const ABBREVIATION: Option<&str> = None;
        /// `Some("Sankt Jørgens Alle 8, DK-1615 København V, Danmark")`
        pub const ADDRESS: Option<&str> = Some("Sankt Jørgens Alle 8, DK-1615 København V, Danmark");
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        /// ]
        /// ```
        pub const CATEGORY: Option<&[&[&str]]> = Some(&[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_TELEPHONE"],
            &["i18n:2012", "LC_MEASUREMENT"],
        ]);
        /// `Some("")`
        pub const CONTACT: Option<&str> = Some("");
        /// `Some("2000-06-29")`
        pub const DATE: Option<&str> = Some("2000-06-29");
        /// `Some("bug-glibc-locales@gnu.org")`
        pub const EMAIL: Option<&str> = Some("bug-glibc-locales@gnu.org");
        /// `Some("")`
        pub const FAX: Option<&str> = Some("");
        /// `Some("Spanish")`
        pub const LANGUAGE: Option<&str> = Some("Spanish");
        /// `Some("1.0")`
        pub const REVISION: Option<&str> = Some("1.0");
        /// `Some("RAP")`
        pub const SOURCE: Option<&str> = Some("RAP");
        /// `Some("")`
        pub const TEL: Option<&str> = Some("");
        /// `Some("Uruguay")`
        pub const TERRITORY: Option<&str> = Some("Uruguay");
        /// `Some("Spanish locale for Uruguay")`
        pub const TITLE: Option<&str> = Some("Spanish locale for Uruguay");
    }
    pub use super::es_ES::LC_MESSAGES;
    pub mod LC_MONETARY {
        /// `"$"`
        pub const CURRENCY_SYMBOL: &str = "$";
        /// `2`
        pub const FRAC_DIGITS: i64 = 2;
        /// `"UYU "`
        pub const INT_CURR_SYMBOL: &str = "UYU ";
        /// `2`
        pub const INT_FRAC_DIGITS: i64 = 2;
        /// `None`
        pub const INT_N_CS_PRECEDES: Option<i64> = None;
        /// `None`
        pub const INT_N_SEP_BY_SPACE: Option<i64> = None;
        /// `None`
        pub const INT_N_SIGN_POSN: Option<i64> = None;
        /// `None`
        pub const INT_P_CS_PRECEDES: Option<i64> = None;
        /// `None`
        pub const INT_P_SEP_BY_SPACE: Option<i64> = None;
        /// `None`
        pub const INT_P_SIGN_POSN: Option<i64> = None;
        /// `","`
        pub const MON_DECIMAL_POINT: &str = ",";
        /// `&[3, 3]`
        pub const MON_GROUPING: &[i64] = &[3, 3];
        /// `"."`
        pub const MON_THOUSANDS_SEP: &str = ".";
        /// `"-"`
        pub const NEGATIVE_SIGN: &str = "-";
        /// `1`
        pub const N_CS_PRECEDES: i64 = 1;
        /// `1`
        pub const N_SEP_BY_SPACE: i64 = 1;
        /// `1`
        pub const N_SIGN_POSN: i64 = 1;
        /// `""`
        pub const POSITIVE_SIGN: &str = "";
        /// `1`
        pub const P_CS_PRECEDES: i64 = 1;
        /// `1`
        pub const P_SEP_BY_SPACE: i64 = 1;
        /// `1`
        pub const P_SIGN_POSN: i64 = 1;
    }
    pub use super::es_ES::LC_NUMERIC;
    pub mod LC_TELEPHONE {
        /// `Some("598")`
        pub const INT_PREFIX: Option<&str> = Some("598");
        /// `Some("00")`
        pub const INT_SELECT: Option<&str> = Some("00");
        /// `None`
        pub const TEL_DOM_FMT: Option<&str> = None;
        /// `Some("+%c %a %l")`
        pub const TEL_INT_FMT: Option<&str> = Some("+%c %a %l");
    }
    pub mod LC_TIME {
        /// `&["dom", "lun", "mar", "mié", "jue", "vie", "sáb"]`
        pub const ABDAY: &[&str] = &["dom", "lun", "mar", "mié", "jue", "vie", "sáb"];
        /// `&["ene", "feb", "mar", "abr", "may", "jun", "jul", "ago", "set", "oct", "nov", "dic"]`
        pub const ABMON: &[&str] = &["ene", "feb", "mar", "abr", "may", "jun", "jul", "ago", "set", "oct", "nov", "dic"];
        /// `None`
        pub const AB_ALT_MON: Option<&[&str]> = None;
        /// `None`
        pub const ALT_DIGITS: Option<&[&str]> = None;
        /// `None`
        pub const ALT_MON: Option<&[&str]> = None;
        /// `&["", ""]`
        pub const AM_PM: &[&str] = &["", ""];
        /// `None`
        pub const CAL_DIRECTION: Option<i64> = None;
        /// `None`
        pub const DATE_FMT: Option<&str> = None;
        /// `&["domingo", "lunes", "martes", "miércoles", "jueves", "viernes", "sábado"]`
        pub const DAY: &[&str] = &["domingo", "lunes", "martes", "miércoles", "jueves", "viernes", "sábado"];
        /// `"%d/%m/%y"`
        pub const D_FMT: &str = "%d/%m/%y";
        /// `"%a %d %b %Y %T %Z"`
        pub const D_T_FMT: &str = "%a %d %b %Y %T %Z";
        /// `None`
        pub const ERA: Option<&[&str]> = None;
        /// `None`
        pub const ERA_D_FMT: Option<&str> = None;
        /// `None`
        pub const ERA_D_T_FMT: Option<&str> = None;
        /// `None`
        pub const ERA_T_FMT: Option<&str> = None;
        /// `Some(2)`
        pub const FIRST_WEEKDAY: Option<i64> = Some(2);
        /// `None`
        pub const FIRST_WORKDAY: Option<i64> = None;
        /// `&["enero", "febrero", "marzo", "abril", "mayo", "junio", "julio", "agosto", "setiembre", "octubre", "noviembre", "diciembre"]`
        pub const MON: &[&str] = &["enero", "febrero", "marzo", "abril", "mayo", "junio", "julio", "agosto", "setiembre", "octubre", "noviembre", "diciembre"];
        /// `"%T"`
        pub const T_FMT: &str = "%T";
        /// `""`
        pub const T_FMT_AMPM: &str = "";
        /// `Some(&[7, 19971130, 1])`
        pub const WEEK: Option<&[i64]> = Some(&[7, 19971130, 1]);
    }
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod es_VE {
    pub mod LC_ADDRESS {
        /// `Some("VEN")`
        pub const COUNTRY_AB3: Option<&str> = Some("VEN");
        /// `Some("VE")`
        pub const COUNTRY_ABTWO: Option<&str> = Some("VE");
        /// `Some("YV")`
        pub const COUNTRY_CAR: Option<&str> = Some("YV");
        /// `None`
        pub const COUNTRY_ISBN: Option<&str> = None;
        /// `Some("Venezuela")`
        pub const COUNTRY_NAME: Option<&str> = Some("Venezuela");
        /// `Some(862)`
        pub const COUNTRY_NUM: Option<i64> = Some(862);
        /// `None`
        pub const COUNTRY_POST: Option<&str> = None;
        /// `Some("es")`
        pub const LANG_AB: Option<&str> = Some("es");
        /// `Some("spa")`
        pub const LANG_LIB: Option<&str> = Some("spa");
        /// `Some("español")`
        pub const LANG_NAME: Option<&str> = Some("español");
        /// `Some("spa")`
        pub const LANG_TERM: Option<&str> = Some("spa");
        /// `Some("%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%c%N")`
        pub const POSTAL_FMT: Option<&str> = Some("%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%c%N");
    }
    pub mod LC_IDENTIFICATION {
        /// `None`
        pub const ABBREVIATION: Option<&str> = None;
        /// `Some("Sankt Jørgens Alle 8, DK-1615 København V, Danmark")`
        pub const ADDRESS: Option<&str> = Some("Sankt Jørgens Alle 8, DK-1615 København V, Danmark");
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        /// ]
        /// ```
        pub const CATEGORY: Option<&[&[&str]]> = Some(&[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_TELEPHONE"],
            &["i18n:2012", "LC_MEASUREMENT"],
        ]);
        /// `Some("")`
        pub const CONTACT: Option<&str> = Some("");
        /// `Some("2000-06-29")`
        pub const DATE: Option<&str> = Some("2000-06-29");
        /// `Some("bug-glibc-locales@gnu.org")`
        pub const EMAIL: Option<&str> = Some("bug-glibc-locales@gnu.org");
        /// `Some("")`
        pub const FAX: Option<&str> = Some("");
        /// `Some("Spanish")`
        pub const LANGUAGE: Option<&str> = Some("Spanish");
        /// `Some("1.0")`
        pub const REVISION: Option<&str> = Some("1.0");
        /// `Some("RAP")`
        pub const SOURCE: Option<&str> = Some("RAP");
        /// `Some("")`
        pub const TEL: Option<&str> = Some("");
        /// `Some("Venezuela")`
        pub const TERRITORY: Option<&str> = Some("Venezuela");
        /// `Some("Spanish locale for Venezuela")`
        pub const TITLE: Option<&str> = Some("Spanish locale for Venezuela");
    }
    pub use super::es_ES::LC_MESSAGES;
    pub mod LC_MONETARY {
        /// `"Bs."`
        pub const CURRENCY_SYMBOL: &str = "Bs.";
        /// `2`
        pub const FRAC_DIGITS: i64 = 2;
        /// `"VEF "`
        pub const INT_CURR_SYMBOL: &str = "VEF ";
        /// `2`
        pub const INT_FRAC_DIGITS: i64 = 2;
        /// `None`
        pub const INT_N_CS_PRECEDES: Option<i64> = None;
        /// `None`
        pub const INT_N_SEP_BY_SPACE: Option<i64> = None;
        /// `None`
        pub const INT_N_SIGN_POSN: Option<i64> = None;
        /// `None`
        pub const INT_P_CS_PRECEDES: Option<i64> = None;
        /// `None`
        pub const INT_P_SEP_BY_SPACE: Option<i64> = None;
        /// `None`
        pub const INT_P_SIGN_POSN: Option<i64> = None;
        /// `","`
        pub const MON_DECIMAL_POINT: &str = ",";
        /// `&[3, 3]`
        pub const MON_GROUPING: &[i64] = &[3, 3];
        /// `"."`
        pub const MON_THOUSANDS_SEP: &str = ".";
        /// `"-"`
        pub const NEGATIVE_SIGN: &str = "-";
        /// `1`
        pub const N_CS_PRECEDES: i64 = 1;
        /// `1`
        pub const N_SEP_BY_SPACE: i64 = 1;
        /// `1`
        pub const N_SIGN_POSN: i64 = 1;
        /// `""`
        pub const POSITIVE_SIGN: &str = "";
        /// `1`
        pub const P_CS_PRECEDES: i64 = 1;
        /// `1`
        pub const P_SEP_BY_SPACE: i64 = 1;
        /// `1`
        pub const P_SIGN_POSN: i64 = 1;
    }
    pub use super::es_ES::LC_NUMERIC;
    pub mod LC_TELEPHONE {
        /// `Some("58")`
        pub const INT_PREFIX: Option<&str> = Some("58");
        /// `Some("00")`
        pub const INT_SELECT: Option<&str> = Some("00");
        /// `None`
        pub const TEL_DOM_FMT: Option<&str> = None;
        /// `Some("+%c %a %l")`
        pub const TEL_INT_FMT: Option<&str> = Some("+%c %a %l");
    }
    pub mod LC_TIME {
        /// `&["dom", "lun", "mar", "mié", "jue", "vie", "sáb"]`
        pub const ABDAY: &[&str] = &["dom", "lun", "mar", "mié", "jue", "vie", "sáb"];
        /// `&["ene", "feb", "mar", "abr", "may", "jun", "jul", "ago", "sep", "oct", "nov", "dic"]`
        pub const ABMON: &[&str] = &["ene", "feb", "mar", "abr", "may", "jun", "jul", "ago", "sep", "oct", "nov", "dic"];
        /// `None`
        pub const AB_ALT_MON: Option<&[&str]> = None;
        /// `None`
        pub const ALT_DIGITS: Option<&[&str]> = None;
        /// `None`
        pub const ALT_MON: Option<&[&str]> = None;
        /// `&["am", "pm"]`
        pub const AM_PM: &[&str] = &["am", "pm"];
        /// `None`
        pub const CAL_DIRECTION: Option<i64> = None;
        /// `None`
        pub const DATE_FMT: Option<&str> = None;
        /// `&["domingo", "lunes", "martes", "miércoles", "jueves", "viernes", "sábado"]`
        pub const DAY: &[&str] = &["domingo", "lunes", "martes", "miércoles", "jueves", "viernes", "sábado"];
        /// `"%d/%m/%y"`
        pub const D_FMT: &str = "%d/%m/%y";
        /// `"%a %d %b %Y %T %Z"`
        pub const D_T_FMT: &str = "%a %d %b %Y %T %Z";
        /// `None`
        pub const ERA: Option<&[&str]> = None;
        /// `None`
        pub const ERA_D_FMT: Option<&str> = None;
        /// `None`
        pub const ERA_D_T_FMT: Option<&str> = None;
        /// `None`
        pub const ERA_T_FMT: Option<&str> = None;
        /// `None`
        pub const FIRST_WEEKDAY: Option<i64> = None;
        /// `None`
        pub const FIRST_WORKDAY: Option<i64> = None;
        /// `&["enero", "febrero", "marzo", "abril", "mayo", "junio", "julio", "agosto", "septiembre", "octubre", "noviembre", "diciembre"]`
        pub const MON: &[&str] = &["enero", "febrero", "marzo", "abril", "mayo", "junio", "julio", "agosto", "septiembre", "octubre", "noviembre", "diciembre"];
        /// `"%T"`
        pub const T_FMT: &str = "%T";
        /// `"%I:%M:%S %p"`
        pub const T_FMT_AMPM: &str = "%I:%M:%S %p";
        /// `Some(&[7, 19971130, 1])`
        pub const WEEK: Option<&[i64]> = Some(&[7, 19971130, 1]);
    }
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod et_EE {
    pub mod LC_ADDRESS {
        /// `Some("EST")`
        pub const COUNTRY_AB3: Option<&str> = Some("EST");
        /// `Some("EE")`
        pub const COUNTRY_ABTWO: Option<&str> = Some("EE");
        /// `Some("EST")`
        pub const COUNTRY_CAR: Option<&str> = Some("EST");
        /// `Some("978-9949,978-9985")`
        pub const COUNTRY_ISBN: Option<&str> = Some("978-9949,978-9985");
        /// `Some("Eesti")`
        pub const COUNTRY_NAME: Option<&str> = Some("Eesti");
        /// `Some(233)`
        pub const COUNTRY_NUM: Option<i64> = Some(233);
        /// `Some("EE")`
        pub const COUNTRY_POST: Option<&str> = Some("EE");
        /// `Some("et")`
        pub const LANG_AB: Option<&str> = Some("et");
        /// `Some("est")`
        pub const LANG_LIB: Option<&str> = Some("est");
        /// `Some("eesti")`
        pub const LANG_NAME: Option<&str> = Some("eesti");
        /// `Some("est")`
        pub const LANG_TERM: Option<&str> = Some("est");
        /// `Some("%a%N%f%N%d%N%b%N%s%t%h%t%e%t%r%N%C-%z %T%N%c%N")`
        pub const POSTAL_FMT: Option<&str> = Some("%a%N%f%N%d%N%b%N%s%t%h%t%e%t%r%N%C-%z %T%N%c%N");
    }
    pub mod LC_IDENTIFICATION {
        /// `None`
        pub const ABBREVIATION: Option<&str> = None;
        /// `Some("To-nisma:gi 8, Tallinn, EE0100 Estonia")`
        pub const ADDRESS: Option<&str> = Some("To-nisma:gi 8, Tallinn, EE0100 Estonia");
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        /// ]
        /// ```
        pub const CATEGORY: Option<&[&[&str]]> = Some(&[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_TELEPHONE"],
            &["i18n:2012", "LC_MEASUREMENT"],
        ]);
        /// `Some("")`
        pub const CONTACT: Option<&str> = Some("");
        /// `Some("2000-06-29")`
        pub const DATE: Option<&str> = Some("2000-06-29");
        /// `Some("bug-glibc-locales@gnu.org")`
        pub const EMAIL: Option<&str> = Some("bug-glibc-locales@gnu.org");
        /// `Some("")`
        pub const FAX: Option<&str> = Some("");
        /// `Some("Estonian")`
        pub const LANGUAGE: Option<&str> = Some("Estonian");
        /// `Some("1.0")`
        pub const REVISION: Option<&str> = Some("1.0");
        /// `Some("Estonian Informatics Fund")`
        pub const SOURCE: Option<&str> = Some("Estonian Informatics Fund");
        /// `Some("")`
        pub const TEL: Option<&str> = Some("");
        /// `Some("Estonia")`
        pub const TERRITORY: Option<&str> = Some("Estonia");
        /// `Some("Estonian locale for Estonia")`
        pub const TITLE: Option<&str> = Some("Estonian locale for Estonia");
    }
    pub mod LC_MESSAGES {
        /// `"^[-0EeNn]"`
        pub const NOEXPR: &str = "^[-0EeNn]";
        /// `Some("ei")`
        pub const NOSTR: Option<&str> = Some("ei");
        /// `"^[+1JjYy]"`
        pub const YESEXPR: &str = "^[+1JjYy]";
        /// `Some("jah")`
        pub const YESSTR: Option<&str> = Some("jah");
    }
    pub mod LC_MONETARY {
        /// `"€"`
        pub const CURRENCY_SYMBOL: &str = "€";
        /// `2`
        pub const FRAC_DIGITS: i64 = 2;
        /// `"EUR "`
        pub const INT_CURR_SYMBOL: &str = "EUR ";
        /// `2`
        pub const INT_FRAC_DIGITS: i64 = 2;
        /// `None`
        pub const INT_N_CS_PRECEDES: Option<i64> = None;
        /// `None`
        pub const INT_N_SEP_BY_SPACE: Option<i64> = None;
        /// `None`
        pub const INT_N_SIGN_POSN: Option<i64> = None;
        /// `None`
        pub const INT_P_CS_PRECEDES: Option<i64> = None;
        /// `None`
        pub const INT_P_SEP_BY_SPACE: Option<i64> = None;
        /// `None`
        pub const INT_P_SIGN_POSN: Option<i64> = None;
        /// `","`
        pub const MON_DECIMAL_POINT: &str = ",";
        /// `&[3, 3]`
        pub const MON_GROUPING: &[i64] = &[3, 3];
        /// `"\u{202f}"`
        pub const MON_THOUSANDS_SEP: &str = "\u{202f}";
        /// `"-"`
        pub const NEGATIVE_SIGN: &str = "-";
        /// `0`
        pub const N_CS_PRECEDES: i64 = 0;
        /// `1`
        pub const N_SEP_BY_SPACE: i64 = 1;
        /// `1`
        pub const N_SIGN_POSN: i64 = 1;
        /// `""`
        pub const POSITIVE_SIGN: &str = "";
        /// `0`
        pub const P_CS_PRECEDES: i64 = 0;
        /// `1`
        pub const P_SEP_BY_SPACE: i64 = 1;
        /// `1`
        pub const P_SIGN_POSN: i64 = 1;
    }
    pub mod LC_NUMERIC {
        /// `","`
        pub const DECIMAL_POINT: &str = ",";
        /// `&[3, 3]`
        pub const GROUPING: &[i64] = &[3, 3];
        /// `"\u{202f}"`
        pub const THOUSANDS_SEP: &str = "\u{202f}";
    }
    pub mod LC_TELEPHONE {
        /// `Some("372")`
        pub const INT_PREFIX: Option<&str> = Some("372");
        /// `Some("00")`
        pub const INT_SELECT: Option<&str> = Some("00");
        /// `None`
        pub const TEL_DOM_FMT: Option<&str> = None;
        /// `Some("+%c %a %l")`
        pub const TEL_INT_FMT: Option<&str> = Some("+%c %a %l");
    }
    pub mod LC_TIME {
        /// `&["P", "E", "T", "K", "N", "R", "L"]`
        pub const ABDAY: &[&str] = &["P", "E", "T", "K", "N", "R", "L"];
        /// `&["jaan ", "veebr", "märts", "apr  ", "mai  ", "juuni", "juuli", "aug  ", "sept ", "okt  ", "nov  ", "dets "]`
        pub const ABMON: &[&str] = &["jaan ", "veebr", "märts", "apr  ", "mai  ", "juuni", "juuli", "aug  ", "sept ", "okt  ", "nov  ", "dets "];
        /// `None`
        pub const AB_ALT_MON: Option<&[&str]> = None;
        /// `None`
        pub const ALT_DIGITS: Option<&[&str]> = None;
        /// `None`
        pub const ALT_MON: Option<&[&str]> = None;
        /// `&["", ""]`
        pub const AM_PM: &[&str] = &["", ""];
        /// `None`
        pub const CAL_DIRECTION: Option<i64> = None;
        /// `None`
        pub const DATE_FMT: Option<&str> = None;
        /// `&["pühapäev", "esmaspäev", "teisipäev", "kolmapäev", "neljapäev", "reede", "laupäev"]`
        pub const DAY: &[&str] = &["pühapäev", "esmaspäev", "teisipäev", "kolmapäev", "neljapäev", "reede", "laupäev"];
        /// `"%d.%m.%Y"`
        pub const D_FMT: &str = "%d.%m.%Y";
        /// `"%a %d %b %Y %T %Z"`
        pub const D_T_FMT: &str = "%a %d %b %Y %T %Z";
        /// `None`
        pub const ERA: Option<&[&str]> = None;
        /// `None`
        pub const ERA_D_FMT: Option<&str> = None;
        /// `None`
        pub const ERA_D_T_FMT: Option<&str> = None;
        /// `None`
        pub const ERA_T_FMT: Option<&str> = None;
        /// `Some(2)`
        pub const FIRST_WEEKDAY: Option<i64> = Some(2);
        /// `None`
        pub const FIRST_WORKDAY: Option<i64> = None;
        /// `&["jaanuar", "veebruar", "märts", "aprill", "mai", "juuni", "juuli", "august", "september", "oktoober", "november", "detsember"]`
        pub const MON: &[&str] = &["jaanuar", "veebruar", "märts", "aprill", "mai", "juuni", "juuli", "august", "september", "oktoober", "november", "detsember"];
        /// `"%T"`
        pub const T_FMT: &str = "%T";
        /// `""`
        pub const T_FMT_AMPM: &str = "";
        /// `Some(&[7, 19971130, 4])`
        pub const WEEK: Option<&[i64]> = Some(&[7, 19971130, 4]);
    }
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod eu_ES {
    pub mod LC_ADDRESS {
        /// `Some("ESP")`
        pub const COUNTRY_AB3: Option<&str> = Some("ESP");
        /// `Some("ES")`
        pub const COUNTRY_ABTWO: Option<&str> = Some("ES");
        /// `Some("E")`
        pub const COUNTRY_CAR: Option<&str> = Some("E");
        /// `None`
        pub const COUNTRY_ISBN: Option<&str> = None;
        /// `Some("Espainia")`
        pub const COUNTRY_NAME: Option<&str> = Some("Espainia");
        /// `Some(724)`
        pub const COUNTRY_NUM: Option<i64> = Some(724);
        /// `None`
        pub const COUNTRY_POST: Option<&str> = None;
        /// `Some("eu")`
        pub const LANG_AB: Option<&str> = Some("eu");
        /// `Some("baq")`
        pub const LANG_LIB: Option<&str> = Some("baq");
        /// `Some("euskara")`
        pub const LANG_NAME: Option<&str> = Some("euskara");
        /// `Some("eus")`
        pub const LANG_TERM: Option<&str> = Some("eus");
        /// `Some("%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%c%N")`
        pub const POSTAL_FMT: Option<&str> = Some("%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%c%N");
    }
    pub mod LC_IDENTIFICATION {
        /// `None`
        pub const ABBREVIATION: Option<&str> = None;
        /// `Some("Sankt Jørgens Alle 8, DK-1615 København V, Danmark")`
        pub const ADDRESS: Option<&str> = Some("Sankt Jørgens Alle 8, DK-1615 København V, Danmark");
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        /// ]
        /// ```
        pub const CATEGORY: Option<&[&[&str]]> = Some(&[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_TELEPHONE"],
            &["i18n:2012", "LC_MEASUREMENT"],
        ]);
        /// `Some("")`
        pub const CONTACT: Option<&str> = Some("");
        /// `Some("2000-06-29")`
        pub const DATE: Option<&str> = Some("2000-06-29");
        /// `Some("bug-glibc-locales@gnu.org")`
        pub const EMAIL: Option<&str> = Some("bug-glibc-locales@gnu.org");
        /// `Some("")`
        pub const FAX: Option<&str> = Some("");
        /// `Some("Basque")`
        pub const LANGUAGE: Option<&str> = Some("Basque");
        /// `Some("1.0")`
        pub const REVISION: Option<&str> = Some("1.0");
        /// `Some("RAP")`
        pub const SOURCE: Option<&str> = Some("RAP");
        /// `Some("")`
        pub const TEL: Option<&str> = Some("");
        /// `Some("Spain")`
        pub const TERRITORY: Option<&str> = Some("Spain");
        /// `Some("Basque locale for Spain")`
        pub const TITLE: Option<&str> = Some("Basque locale for Spain");
    }
    pub mod LC_MESSAGES {
        /// `"^[-0eEnN]"`
        pub const NOEXPR: &str = "^[-0eEnN]";
        /// `Some("ez")`
        pub const NOSTR: Option<&str> = Some("ez");
        /// `"^[+1bBsSyY]"`
        pub const YESEXPR: &str = "^[+1bBsSyY]";
        /// `Some("bai")`
        pub const YESSTR: Option<&str> = Some("bai");
    }
    pub mod LC_MONETARY {
        /// `"€"`
        pub const CURRENCY_SYMBOL: &str = "€";
        /// `2`
        pub const FRAC_DIGITS: i64 = 2;
        /// `"EUR "`
        pub const INT_CURR_SYMBOL: &str = "EUR ";
        /// `2`
        pub const INT_FRAC_DIGITS: i64 = 2;
        /// `None`
        pub const INT_N_CS_PRECEDES: Option<i64> = None;
        /// `None`
        pub const INT_N_SEP_BY_SPACE: Option<i64> = None;
        /// `None`
        pub const INT_N_SIGN_POSN: Option<i64> = None;
        /// `None`
        pub const INT_P_CS_PRECEDES: Option<i64> = None;
        /// `None`
        pub const INT_P_SEP_BY_SPACE: Option<i64> = None;
        /// `None`
        pub const INT_P_SIGN_POSN: Option<i64> = None;
        /// `","`
        pub const MON_DECIMAL_POINT: &str = ",";
        /// `&[3, 3]`
        pub const MON_GROUPING: &[i64] = &[3, 3];
        /// `"."`
        pub const MON_THOUSANDS_SEP: &str = ".";
        /// `"-"`
        pub const NEGATIVE_SIGN: &str = "-";
        /// `1`
        pub const N_CS_PRECEDES: i64 = 1;
        /// `1`
        pub const N_SEP_BY_SPACE: i64 = 1;
        /// `1`
        pub const N_SIGN_POSN: i64 = 1;
        /// `""`
        pub const POSITIVE_SIGN: &str = "";
        /// `1`
        pub const P_CS_PRECEDES: i64 = 1;
        /// `1`
        pub const P_SEP_BY_SPACE: i64 = 1;
        /// `1`
        pub const P_SIGN_POSN: i64 = 1;
    }
    pub mod LC_NUMERIC {
        /// `","`
        pub const DECIMAL_POINT: &str = ",";
        /// `&[3, 3]`
        pub const GROUPING: &[i64] = &[3, 3];
        /// `"."`
        pub const THOUSANDS_SEP: &str = ".";
    }
    pub mod LC_TELEPHONE {
        /// `Some("34")`
        pub const INT_PREFIX: Option<&str> = Some("34");
        /// `Some("00")`
        pub const INT_SELECT: Option<&str> = Some("00");
        /// `None`
        pub const TEL_DOM_FMT: Option<&str> = None;
        /// `Some("+%c %a %l")`
        pub const TEL_INT_FMT: Option<&str> = Some("+%c %a %l");
    }
    pub mod LC_TIME {
        /// `&["ig.", "al.", "ar.", "az.", "og.", "or.", "lr."]`
        pub const ABDAY: &[&str] = &["ig.", "al.", "ar.", "az.", "og.", "or.", "lr."];
        /// `&["urt", "ots", "mar", "api", "mai", "eka", "uzt", "abu", "ira", "urr", "aza", "abe"]`
        pub const ABMON: &[&str] = &["urt", "ots", "mar", "api", "mai", "eka", "uzt", "abu", "ira", "urr", "aza", "abe"];
        /// `None`
        pub const AB_ALT_MON: Option<&[&str]> = None;
        /// `None`
        pub const ALT_DIGITS: Option<&[&str]> = None;
        /// `None`
        pub const ALT_MON: Option<&[&str]> = None;
        /// `&["", ""]`
        pub const AM_PM: &[&str] = &["", ""];
        /// `None`
        pub const CAL_DIRECTION: Option<i64> = None;
        /// `None`
        pub const DATE_FMT: Option<&str> = None;
        /// `&["igandea", "astelehena", "asteartea", "asteazkena", "osteguna", "ostirala", "larunbata"]`
        pub const DAY: &[&str] = &["igandea", "astelehena", "asteartea", "asteazkena", "osteguna", "ostirala", "larunbata"];
        /// `"%a, %Y.eko %bren %da"`
        pub const D_FMT: &str = "%a, %Y.eko %bren %da";
        /// `"%y-%m-%d %T %Z"`
        pub const D_T_FMT: &str = "%y-%m-%d %T %Z";
        /// `None`
        pub const ERA: Option<&[&str]> = None;
        /// `None`
        pub const ERA_D_FMT: Option<&str> = None;
        /// `None`
        pub const ERA_D_T_FMT: Option<&str> = None;
        /// `None`
        pub const ERA_T_FMT: Option<&str> = None;
        /// `Some(2)`
        pub const FIRST_WEEKDAY: Option<i64> = Some(2);
        /// `None`
        pub const FIRST_WORKDAY: Option<i64> = None;
        /// `&["urtarrila", "otsaila", "martxoa", "apirila", "maiatza", "ekaina", "uztaila", "abuztua", "iraila", "urria", "azaroa", "abendua"]`
        pub const MON: &[&str] = &["urtarrila", "otsaila", "martxoa", "apirila", "maiatza", "ekaina", "uztaila", "abuztua", "iraila", "urria", "azaroa", "abendua"];
        /// `"%T"`
        pub const T_FMT: &str = "%T";
        /// `""`
        pub const T_FMT_AMPM: &str = "";
        /// `Some(&[7, 19971130, 4])`
        pub const WEEK: Option<&[i64]> = Some(&[7, 19971130, 4]);
    }
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod eu_ES_euro {
    pub use super::eu_ES::LC_ADDRESS;
    pub mod LC_IDENTIFICATION {
        /// `None`
        pub const ABBREVIATION: Option<&str> = None;
        /// `Some("https://www.gnu.org/software/libc/")`
        pub const ADDRESS: Option<&str> = Some("https://www.gnu.org/software/libc/");
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        /// ]
        /// ```
        pub const CATEGORY: Option<&[&[&str]]> = Some(&[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_TELEPHONE"],
            &["i18n:2012", "LC_MEASUREMENT"],
        ]);
        /// `Some("")`
        pub const CONTACT: Option<&str> = Some("");
        /// `Some("2000-08-21")`
        pub const DATE: Option<&str> = Some("2000-08-21");
        /// `Some("bug-glibc-locales@gnu.org")`
        pub const EMAIL: Option<&str> = Some("bug-glibc-locales@gnu.org");
        /// `Some("")`
        pub const FAX: Option<&str> = Some("");
        /// `Some("Basque")`
        pub const LANGUAGE: Option<&str> = Some("Basque");
        /// `Some("1.0")`
        pub const REVISION: Option<&str> = Some("1.0");
        /// `Some("Free Software Foundation, Inc.")`
        pub const SOURCE: Option<&str> = Some("Free Software Foundation, Inc.");
        /// `Some("")`
        pub const TEL: Option<&str> = Some("");
        /// `Some("Spain")`
        pub const TERRITORY: Option<&str> = Some("Spain");
        /// `Some("Basque language locale for Spain with Euro")`
        pub const TITLE: Option<&str> = Some("Basque language locale for Spain with Euro");
    }
    pub use super::eu_ES::LC_MESSAGES;
    pub mod LC_MONETARY {
        /// `"€"`
        pub const CURRENCY_SYMBOL: &str = "€";
        /// `0`
        pub const FRAC_DIGITS: i64 = 0;
        /// `"EUR "`
        pub const INT_CURR_SYMBOL: &str = "EUR ";
        /// `0`
        pub const INT_FRAC_DIGITS: i64 = 0;
        /// `None`
        pub const INT_N_CS_PRECEDES: Option<i64> = None;
        /// `None`
        pub const INT_N_SEP_BY_SPACE: Option<i64> = None;
        /// `None`
        pub const INT_N_SIGN_POSN: Option<i64> = None;
        /// `None`
        pub const INT_P_CS_PRECEDES: Option<i64> = None;
        /// `None`
        pub const INT_P_SEP_BY_SPACE: Option<i64> = None;
        /// `None`
        pub const INT_P_SIGN_POSN: Option<i64> = None;
        /// `","`
        pub const MON_DECIMAL_POINT: &str = ",";
        /// `&[3, 3]`
        pub const MON_GROUPING: &[i64] = &[3, 3];
        /// `"."`
        pub const MON_THOUSANDS_SEP: &str = ".";
        /// `"-"`
        pub const NEGATIVE_SIGN: &str = "-";
        /// `1`
        pub const N_CS_PRECEDES: i64 = 1;
        /// `1`
        pub const N_SEP_BY_SPACE: i64 = 1;
        /// `1`
        pub const N_SIGN_POSN: i64 = 1;
        /// `""`
        pub const POSITIVE_SIGN: &str = "";
        /// `1`
        pub const P_CS_PRECEDES: i64 = 1;
        /// `1`
        pub const P_SEP_BY_SPACE: i64 = 1;
        /// `1`
        pub const P_SIGN_POSN: i64 = 1;
    }
    pub use super::eu_ES::LC_NUMERIC;
    pub use super::eu_ES::LC_TELEPHONE;
    pub use super::eu_ES::LC_TIME;
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod fa_IR {
    pub mod LC_ADDRESS {
        /// `Some("IRN")`
        pub const COUNTRY_AB3: Option<&str> = Some("IRN");
        /// `Some("IR")`
        pub const COUNTRY_ABTWO: Option<&str> = Some("IR");
        /// `Some("IR")`
        pub const COUNTRY_CAR: Option<&str> = Some("IR");
        /// `Some("964")`
        pub const COUNTRY_ISBN: Option<&str> = Some("964");
        /// `Some("ایران")`
        pub const COUNTRY_NAME: Option<&str> = Some("ایران");
        /// `Some(364)`
        pub const COUNTRY_NUM: Option<i64> = Some(364);
        /// `None`
        pub const COUNTRY_POST: Option<&str> = None;
        /// `Some("fa")`
        pub const LANG_AB: Option<&str> = Some("fa");
        /// `Some("per")`
        pub const LANG_LIB: Option<&str> = Some("per");
        /// `Some("فارسی")`
        pub const LANG_NAME: Option<&str> = Some("فارسی");
        /// `Some("fas")`
        pub const LANG_TERM: Option<&str> = Some("fas");
        /// `Some("%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%c%N")`
        pub const POSTAL_FMT: Option<&str> = Some("%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%c%N");
    }
    pub mod LC_IDENTIFICATION {
        /// `None`
        pub const ABBREVIATION: Option<&str> = None;
        /// `Some("5, Shahid Ghasemi Habibollah, Azadi Ave, Tehran, Iran")`
        pub const ADDRESS: Option<&str> = Some("5, Shahid Ghasemi Habibollah, Azadi Ave, Tehran, Iran");
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        /// ]
        /// ```
        pub const CATEGORY: Option<&[&[&str]]> = Some(&[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_TELEPHONE"],
            &["i18n:2012", "LC_MEASUREMENT"],
        ]);
        /// `Some("Roozbeh Pournader")`
        pub const CONTACT: Option<&str> = Some("Roozbeh Pournader");
        /// `Some("2005-04-06")`
        pub const DATE: Option<&str> = Some("2005-04-06");
        /// `Some("roozbeh@farsiweb.info")`
        pub const EMAIL: Option<&str> = Some("roozbeh@farsiweb.info");
        /// `Some("")`
        pub const FAX: Option<&str> = Some("");
        /// `Some("Persian")`
        pub const LANGUAGE: Option<&str> = Some("Persian");
        /// `Some("3.0")`
        pub const REVISION: Option<&str> = Some("3.0");
        /// `Some("Sharif FarsiWeb, Inc.")`
        pub const SOURCE: Option<&str> = Some("Sharif FarsiWeb, Inc.");
        /// `Some("")`
        pub const TEL: Option<&str> = Some("");
        /// `Some("Iran")`
        pub const TERRITORY: Option<&str> = Some("Iran");
        /// `Some("Persian locale for Iran")`
        pub const TITLE: Option<&str> = Some("Persian locale for Iran");
    }
    pub mod LC_MESSAGES {
        /// `"^[-0nNخنok]"`
        pub const NOEXPR: &str = "^[-0nNخنok]";
        /// `Some("نه")`
        pub const NOSTR: Option<&str> = Some("نه");
        /// `"^[+1yYآبHf]"`
        pub const YESEXPR: &str = "^[+1yYآبHf]";
        /// `Some("بله")`
        pub const YESSTR: Option<&str> = Some("بله");
    }
    pub mod LC_MONETARY {
        /// `"ریال"`
        pub const CURRENCY_SYMBOL: &str = "ریال";
        /// `0`
        pub const FRAC_DIGITS: i64 = 0;
        /// `"IRR "`
        pub const INT_CURR_SYMBOL: &str = "IRR ";
        /// `0`
        pub const INT_FRAC_DIGITS: i64 = 0;
        /// `Some(0)`
        pub const INT_N_CS_PRECEDES: Option<i64> = Some(0);
        /// `Some(1)`
        pub const INT_N_SEP_BY_SPACE: Option<i64> = Some(1);
        /// `Some(1)`
        pub const INT_N_SIGN_POSN: Option<i64> = Some(1);
        /// `Some(0)`
        pub const INT_P_CS_PRECEDES: Option<i64> = Some(0);
        /// `Some(1)`
        pub const INT_P_SEP_BY_SPACE: Option<i64> = Some(1);
        /// `Some(1)`
        pub const INT_P_SIGN_POSN: Option<i64> = Some(1);
        /// `"٫"`
        pub const MON_DECIMAL_POINT: &str = "٫";
        /// `&[3]`
        pub const MON_GROUPING: &[i64] = &[3];
        /// `"٬"`
        pub const MON_THOUSANDS_SEP: &str = "٬";
        /// `"-"`
        pub const NEGATIVE_SIGN: &str = "-";
        /// `0`
        pub const N_CS_PRECEDES: i64 = 0;
        /// `1`
        pub const N_SEP_BY_SPACE: i64 = 1;
        /// `1`
        pub const N_SIGN_POSN: i64 = 1;
        /// `""`
        pub const POSITIVE_SIGN: &str = "";
        /// `0`
        pub const P_CS_PRECEDES: i64 = 0;
        /// `1`
        pub const P_SEP_BY_SPACE: i64 = 1;
        /// `1`
        pub const P_SIGN_POSN: i64 = 1;
    }
    pub mod LC_NUMERIC {
        /// `"."`
        pub const DECIMAL_POINT: &str = ".";
        /// `&[3]`
        pub const GROUPING: &[i64] = &[3];
        /// `","`
        pub const THOUSANDS_SEP: &str = ",";
    }
    pub mod LC_TELEPHONE {
        /// `Some("98")`
        pub const INT_PREFIX: Option<&str> = Some("98");
        /// `Some("00")`
        pub const INT_SELECT: Option<&str> = Some("00");
        /// `Some("\u{202a}%A‒%l\u{202c}")`
        pub const TEL_DOM_FMT: Option<&str> = Some("\u{202a}%A‒%l\u{202c}");
        /// `Some("\u{202a}+%c %a %l\u{202c}")`
        pub const TEL_INT_FMT: Option<&str> = Some("\u{202a}+%c %a %l\u{202c}");
    }
    pub mod LC_TIME {
        /// `&["یکشنبه", "دوشنبه", "سه\u{200c}شنبه", "چهارشنبه", "پنجشنبه", "جمعه", "شنبه"]`
        pub const ABDAY: &[&str] = &["یکشنبه", "دوشنبه", "سه\u{200c}شنبه", "چهارشنبه", "پنجشنبه", "جمعه", "شنبه"];
        /// `&["ژانویه", "فوریه", "مارس", "آوریل", "مه", "ژوئن", "ژوئیه", "اوت", "سپتامبر", "اكتبر", "نوامبر", "دسامبر"]`
        pub const ABMON: &[&str] = &["ژانویه", "فوریه", "مارس", "آوریل", "مه", "ژوئن", "ژوئیه", "اوت", "سپتامبر", "اكتبر", "نوامبر", "دسامبر"];
        /// `None`
        pub const AB_ALT_MON: Option<&[&str]> = None;
        /// `Some(&["۰۰", "۰۱", "۰۲", "۰۳", "۰۴", "۰۵", "۰۶", "۰۷", "۰۸", "۰۹", "۱۰", "۱۱", "۱۲", "۱۳", "۱۴", "۱۵", "۱۶", "۱۷", "۱۸", "۱۹", "۲۰", "۲۱", "۲۲", "۲۳", "۲۴", "۲۵", "۲۶", "۲۷", "۲۸", "۲۹", "۳۰", "۳۱", "۳۲", "۳۳", "۳۴", "۳۵", "۳۶", "۳۷", "۳۸", "۳۹", "۴۰", "۴۱", "۴۲", "۴۳", "۴۴", "۴۵", "۴۶", "۴۷", "۴۸", "۴۹", "۵۰", "۵۱", "۵۲", "۵۳", "۵۴", "۵۵", "۵۶", "۵۷", "۵۸", "۵۹", "۶۰", "۶۱", "۶۲", "۶۳", "۶۴", "۶۵", "۶۶", "۶۷", "۶۸", "۶۹", "۷۰", "۷۱", "۷۲", "۷۳", "۷۴", "۷۵", "۷۶", "۷۷", "۷۸", "۷۹", "۸۰", "۸۱", "۸۲", "۸۳", "۸۴", "۸۵", "۸۶", "۸۷", "۸۸", "۸۹", "۹۰", "۹۱", "۹۲", "۹۳", "۹۴", "۹۵", "۹۶", "۹۷", "۹۸", "۹۹"])`
        pub const ALT_DIGITS: Option<&[&str]> = Some(&["۰۰", "۰۱", "۰۲", "۰۳", "۰۴", "۰۵", "۰۶", "۰۷", "۰۸", "۰۹", "۱۰", "۱۱", "۱۲", "۱۳", "۱۴", "۱۵", "۱۶", "۱۷", "۱۸", "۱۹", "۲۰", "۲۱", "۲۲", "۲۳", "۲۴", "۲۵", "۲۶", "۲۷", "۲۸", "۲۹", "۳۰", "۳۱", "۳۲", "۳۳", "۳۴", "۳۵", "۳۶", "۳۷", "۳۸", "۳۹", "۴۰", "۴۱", "۴۲", "۴۳", "۴۴", "۴۵", "۴۶", "۴۷", "۴۸", "۴۹", "۵۰", "۵۱", "۵۲", "۵۳", "۵۴", "۵۵", "۵۶", "۵۷", "۵۸", "۵۹", "۶۰", "۶۱", "۶۲", "۶۳", "۶۴", "۶۵", "۶۶", "۶۷", "۶۸", "۶۹", "۷۰", "۷۱", "۷۲", "۷۳", "۷۴", "۷۵", "۷۶", "۷۷", "۷۸", "۷۹", "۸۰", "۸۱", "۸۲", "۸۳", "۸۴", "۸۵", "۸۶", "۸۷", "۸۸", "۸۹", "۹۰", "۹۱", "۹۲", "۹۳", "۹۴", "۹۵", "۹۶", "۹۷", "۹۸", "۹۹"]);
        /// `None`
        pub const ALT_MON: Option<&[&str]> = None;
        /// `&["", ""]`
        pub const AM_PM: &[&str] = &["", ""];
        /// `Some(3)`
        pub const CAL_DIRECTION: Option<i64> = Some(3);
        /// `Some("\u{202b}%A %Oe %B %Oy، ساعت %OH:%OM:%OS (%Z)\u{202c}")`
        pub const DATE_FMT: Option<&str> = Some("\u{202b}%A %Oe %B %Oy، ساعت %OH:%OM:%OS (%Z)\u{202c}");
        /// `&["یکشنبه", "دوشنبه", "سه\u{200c}شنبه", "چهارشنبه", "پنجشنبه", "جمعه", "شنبه"]`
        pub const DAY: &[&str] = &["یکشنبه", "دوشنبه", "سه\u{200c}شنبه", "چهارشنبه", "پنجشنبه", "جمعه", "شنبه"];
        /// `"%Oy/%Om/%Od"`
        pub const D_FMT: &str = "%Oy/%Om/%Od";
        /// `"\u{202b}%A %Oe %B %Oy، %OH:%OM:%OS\u{202c}"`
        pub const D_T_FMT: &str = "\u{202b}%A %Oe %B %Oy، %OH:%OM:%OS\u{202c}";
        /// `None`
        pub const ERA: Option<&[&str]> = None;
        /// `None`
        pub const ERA_D_FMT: Option<&str> = None;
        /// `None`
        pub const ERA_D_T_FMT: Option<&str> = None;
        /// `None`
        pub const ERA_T_FMT: Option<&str> = None;
        /// `Some(7)`
        pub const FIRST_WEEKDAY: Option<i64> = Some(7);
        /// `Some(7)`
        pub const FIRST_WORKDAY: Option<i64> = Some(7);
        /// `&["ژانویه", "فوریه", "مارس", "آوریل", "مه", "ژوئن", "ژوئیه", "اوت", "سپتامبر", "اكتبر", "نوامبر", "دسامبر"]`
        pub const MON: &[&str] = &["ژانویه", "فوریه", "مارس", "آوریل", "مه", "ژوئن", "ژوئیه", "اوت", "سپتامبر", "اكتبر", "نوامبر", "دسامبر"];
        /// `"%OH:%OM:%OS"`
        pub const T_FMT: &str = "%OH:%OM:%OS";
        /// `""`
        pub const T_FMT_AMPM: &str = "";
        /// `Some(&[7, 19971130, 1])`
        pub const WEEK: Option<&[i64]> = Some(&[7, 19971130, 1]);
    }
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod ff_SN {
    pub mod LC_ADDRESS {
        /// `Some("SEN")`
        pub const COUNTRY_AB3: Option<&str> = Some("SEN");
        /// `Some("SN")`
        pub const COUNTRY_ABTWO: Option<&str> = Some("SN");
        /// `Some("SN")`
        pub const COUNTRY_CAR: Option<&str> = Some("SN");
        /// `None`
        pub const COUNTRY_ISBN: Option<&str> = None;
        /// `Some("Senegaal")`
        pub const COUNTRY_NAME: Option<&str> = Some("Senegaal");
        /// `Some(686)`
        pub const COUNTRY_NUM: Option<i64> = Some(686);
        /// `Some("SN")`
        pub const COUNTRY_POST: Option<&str> = Some("SN");
        /// `Some("ff")`
        pub const LANG_AB: Option<&str> = Some("ff");
        /// `Some("ful")`
        pub const LANG_LIB: Option<&str> = Some("ful");
        /// `Some("Pulaar")`
        pub const LANG_NAME: Option<&str> = Some("Pulaar");
        /// `Some("ful")`
        pub const LANG_TERM: Option<&str> = Some("ful");
        /// `Some("%a%N%f%N%d%N%b%N%h %s %e %r%N%T, %S %z%N%c%N")`
        pub const POSTAL_FMT: Option<&str> = Some("%a%N%f%N%d%N%b%N%h %s %e %r%N%T, %S %z%N%c%N");
    }
    pub mod LC_IDENTIFICATION {
        /// `None`
        pub const ABBREVIATION: Option<&str> = None;
        /// `None`
        pub const ADDRESS: Option<&str> = None;
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        /// ]
        /// ```
        pub const CATEGORY: Option<&[&[&str]]> = Some(&[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_MEASUREMENT"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_TELEPHONE"],
        ]);
        /// `Some("Ibrahima Sarr")`
        pub const CONTACT: Option<&str> = Some("Ibrahima Sarr");
        /// `Some("2011-03-28")`
        pub const DATE: Option<&str> = Some("2011-03-28");
        /// `Some("admin@pulaar-fulfulde.org")`
        pub const EMAIL: Option<&str> = Some("admin@pulaar-fulfulde.org");
        /// `None`
        pub const FAX: Option<&str> = None;
        /// `Some("Fulah")`
        pub const LANGUAGE: Option<&str> = Some("Fulah");
        /// `Some("1.0")`
        pub const REVISION: Option<&str> = Some("1.0");
        /// `Some("Pular-Fulfulde.org")`
        pub const SOURCE: Option<&str> = Some("Pular-Fulfulde.org");
        /// `None`
        pub const TEL: Option<&str> = None;
        /// `Some("Senegal")`
        pub const TERRITORY: Option<&str> = Some("Senegal");
        /// `Some("Fulah locale for Senegal")`
        pub const TITLE: Option<&str> = Some("Fulah locale for Senegal");
    }
    pub mod LC_MESSAGES {
        /// `"^[-0nNaA]"`
        pub const NOEXPR: &str = "^[-0nNaA]";
        /// `Some("Alaa")`
        pub const NOSTR: Option<&str> = Some("Alaa");
        /// `"^[+1yYeE]"`
        pub const YESEXPR: &str = "^[+1yYeE]";
        /// `Some("Eey")`
        pub const YESSTR: Option<&str> = Some("Eey");
    }
    pub mod LC_MONETARY {
        /// `"CFA"`
        pub const CURRENCY_SYMBOL: &str = "CFA";
        /// `2`
        pub const FRAC_DIGITS: i64 = 2;
        /// `"XOF "`
        pub const INT_CURR_SYMBOL: &str = "XOF ";
        /// `2`
        pub const INT_FRAC_DIGITS: i64 = 2;
        /// `None`
        pub const INT_N_CS_PRECEDES: Option<i64> = None;
        /// `None`
        pub const INT_N_SEP_BY_SPACE: Option<i64> = None;
        /// `None`
        pub const INT_N_SIGN_POSN: Option<i64> = None;
        /// `None`
        pub const INT_P_CS_PRECEDES: Option<i64> = None;
        /// `None`
        pub const INT_P_SEP_BY_SPACE: Option<i64> = None;
        /// `None`
        pub const INT_P_SIGN_POSN: Option<i64> = None;
        /// `"."`
        pub const MON_DECIMAL_POINT: &str = ".";
        /// `&[3]`
        pub const MON_GROUPING: &[i64] = &[3];
        /// `","`
        pub const MON_THOUSANDS_SEP: &str = ",";
        /// `"-"`
        pub const NEGATIVE_SIGN: &str = "-";
        /// `0`
        pub const N_CS_PRECEDES: i64 = 0;
        /// `1`
        pub const N_SEP_BY_SPACE: i64 = 1;
        /// `1`
        pub const N_SIGN_POSN: i64 = 1;
        /// `""`
        pub const POSITIVE_SIGN: &str = "";
        /// `0`
        pub const P_CS_PRECEDES: i64 = 0;
        /// `1`
        pub const P_SEP_BY_SPACE: i64 = 1;
        /// `1`
        pub const P_SIGN_POSN: i64 = 1;
    }
    pub mod LC_NUMERIC {
        /// `","`
        pub const DECIMAL_POINT: &str = ",";
        /// `&[3]`
        pub const GROUPING: &[i64] = &[3];
        /// `"."`
        pub const THOUSANDS_SEP: &str = ".";
    }
    pub mod LC_TELEPHONE {
        /// `Some("221")`
        pub const INT_PREFIX: Option<&str> = Some("221");
        /// `Some("00")`
        pub const INT_SELECT: Option<&str> = Some("00");
        /// `Some("%a %l")`
        pub const TEL_DOM_FMT: Option<&str> = Some("%a %l");
        /// `Some("%c %a %l")`
        pub const TEL_INT_FMT: Option<&str> = Some("%c %a %l");
    }
    pub mod LC_TIME {
        /// `&["dew", "aaɓ", "maw", "nje", "naa", "mwd", "hbi"]`
        pub const ABDAY: &[&str] = &["dew", "aaɓ", "maw", "nje", "naa", "mwd", "hbi"];
        /// `&["sii", "col", "mbo", "see", "duu", "kor", "mor", "juk", "slt", "yar", "jol", "bow"]`
        pub const ABMON: &[&str] = &["sii", "col", "mbo", "see", "duu", "kor", "mor", "juk", "slt", "yar", "jol", "bow"];
        /// `None`
        pub const AB_ALT_MON: Option<&[&str]> = None;
        /// `None`
        pub const ALT_DIGITS: Option<&[&str]> = None;
        /// `None`
        pub const ALT_MON: Option<&[&str]> = None;
        /// `&["subaka", "kikiiɗe"]`
        pub const AM_PM: &[&str] = &["subaka", "kikiiɗe"];
        /// `None`
        pub const CAL_DIRECTION: Option<i64> = None;
        /// `None`
        pub const DATE_FMT: Option<&str> = None;
        /// `&["dewo", "aaɓnde", "mawbaare", "njeslaare", "naasaande", "mawnde", "hoore-biir"]`
        pub const DAY: &[&str] = &["dewo", "aaɓnde", "mawbaare", "njeslaare", "naasaande", "mawnde", "hoore-biir"];
        /// `"%d/%m/%Y"`
        pub const D_FMT: &str = "%d/%m/%Y";
        /// `"%a %d %b %Y %R %Z"`
        pub const D_T_FMT: &str = "%a %d %b %Y %R %Z";
        /// `None`
        pub const ERA: Option<&[&str]> = None;
        /// `None`
        pub const ERA_D_FMT: Option<&str> = None;
        /// `None`
        pub const ERA_D_T_FMT: Option<&str> = None;
        /// `None`
        pub const ERA_T_FMT: Option<&str> = None;
        /// `Some(2)`
        pub const FIRST_WEEKDAY: Option<i64> = Some(2);
        /// `None`
        pub const FIRST_WORKDAY: Option<i64> = None;
        /// `&["siilo", "colte", "mbooy", "seeɗto", "duujal", "korse", "morso", "juko", "siilto", "yarkomaa", "jolal", "bowte"]`
        pub const MON: &[&str] = &["siilo", "colte", "mbooy", "seeɗto", "duujal", "korse", "morso", "juko", "siilto", "yarkomaa", "jolal", "bowte"];
        /// `"%R"`
        pub const T_FMT: &str = "%R";
        /// `"%l:%M:%S %p"`
        pub const T_FMT_AMPM: &str = "%l:%M:%S %p";
        /// `Some(&[7, 19971130, 1])`
        pub const WEEK: Option<&[i64]> = Some(&[7, 19971130, 1]);
    }
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod fi_FI {
    pub mod LC_ADDRESS {
        /// `Some("FIN")`
        pub const COUNTRY_AB3: Option<&str> = Some("FIN");
        /// `Some("FI")`
        pub const COUNTRY_ABTWO: Option<&str> = Some("FI");
        /// `Some("FIN")`
        pub const COUNTRY_CAR: Option<&str> = Some("FIN");
        /// `Some("952")`
        pub const COUNTRY_ISBN: Option<&str> = Some("952");
        /// `Some("Suomi")`
        pub const COUNTRY_NAME: Option<&str> = Some("Suomi");
        /// `Some(246)`
        pub const COUNTRY_NUM: Option<i64> = Some(246);
        /// `Some("FI")`
        pub const COUNTRY_POST: Option<&str> = Some("FI");
        /// `Some("fi")`
        pub const LANG_AB: Option<&str> = Some("fi");
        /// `Some("fin")`
        pub const LANG_LIB: Option<&str> = Some("fin");
        /// `Some("suomi")`
        pub const LANG_NAME: Option<&str> = Some("suomi");
        /// `Some("fin")`
        pub const LANG_TERM: Option<&str> = Some("fin");
        /// `Some("%f%N%d%N%b%N%a%N%s %h%t%e%t%r%N%z %T%N%c%N")`
        pub const POSTAL_FMT: Option<&str> = Some("%f%N%d%N%b%N%a%N%s %h%t%e%t%r%N%z %T%N%c%N");
    }
    pub mod LC_IDENTIFICATION {
        /// `None`
        pub const ABBREVIATION: Option<&str> = None;
        /// `Some("Sankt Jørgens Alle 8, DK-1615 København V, Danmark")`
        pub const ADDRESS: Option<&str> = Some("Sankt Jørgens Alle 8, DK-1615 København V, Danmark");
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        /// ]
        /// ```
        pub const CATEGORY: Option<&[&[&str]]> = Some(&[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_MEASUREMENT"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_TELEPHONE"],
        ]);
        /// `Some("")`
        pub const CONTACT: Option<&str> = Some("");
        /// `Some("2000-06-29")`
        pub const DATE: Option<&str> = Some("2000-06-29");
        /// `Some("bug-glibc-locales@gnu.org")`
        pub const EMAIL: Option<&str> = Some("bug-glibc-locales@gnu.org");
        /// `Some("")`
        pub const FAX: Option<&str> = Some("");
        /// `Some("Finnish")`
        pub const LANGUAGE: Option<&str> = Some("Finnish");
        /// `Some("1.0")`
        pub const REVISION: Option<&str> = Some("1.0");
        /// `Some("RAP")`
        pub const SOURCE: Option<&str> = Some("RAP");
        /// `Some("")`
        pub const TEL: Option<&str> = Some("");
        /// `Some("Finland")`
        pub const TERRITORY: Option<&str> = Some("Finland");
        /// `Some("Finnish locale for Finland")`
        pub const TITLE: Option<&str> = Some("Finnish locale for Finland");
    }
    pub mod LC_MESSAGES {
        /// `"^[-0EeNn]"`
        pub const NOEXPR: &str = "^[-0EeNn]";
        /// `Some("ei")`
        pub const NOSTR: Option<&str> = Some("ei");
        /// `"^[+1KkYy]"`
        pub const YESEXPR: &str = "^[+1KkYy]";
        /// `Some("kyllä")`
        pub const YESSTR: Option<&str> = Some("kyllä");
    }
    pub mod LC_MONETARY {
        /// `"€"`
        pub const CURRENCY_SYMBOL: &str = "€";
        /// `2`
        pub const FRAC_DIGITS: i64 = 2;
        /// `"EUR "`
        pub const INT_CURR_SYMBOL: &str = "EUR ";
        /// `2`
        pub const INT_FRAC_DIGITS: i64 = 2;
        /// `None`
        pub const INT_N_CS_PRECEDES: Option<i64> = None;
        /// `None`
        pub const INT_N_SEP_BY_SPACE: Option<i64> = None;
        /// `None`
        pub const INT_N_SIGN_POSN: Option<i64> = None;
        /// `None`
        pub const INT_P_CS_PRECEDES: Option<i64> = None;
        /// `None`
        pub const INT_P_SEP_BY_SPACE: Option<i64> = None;
        /// `None`
        pub const INT_P_SIGN_POSN: Option<i64> = None;
        /// `","`
        pub const MON_DECIMAL_POINT: &str = ",";
        /// `&[3, 3]`
        pub const MON_GROUPING: &[i64] = &[3, 3];
        /// `"\u{202f}"`
        pub const MON_THOUSANDS_SEP: &str = "\u{202f}";
        /// `"-"`
        pub const NEGATIVE_SIGN: &str = "-";
        /// `0`
        pub const N_CS_PRECEDES: i64 = 0;
        /// `1`
        pub const N_SEP_BY_SPACE: i64 = 1;
        /// `1`
        pub const N_SIGN_POSN: i64 = 1;
        /// `""`
        pub const POSITIVE_SIGN: &str = "";
        /// `0`
        pub const P_CS_PRECEDES: i64 = 0;
        /// `1`
        pub const P_SEP_BY_SPACE: i64 = 1;
        /// `1`
        pub const P_SIGN_POSN: i64 = 1;
    }
    pub mod LC_NUMERIC {
        /// `","`
        pub const DECIMAL_POINT: &str = ",";
        /// `&[3, 3]`
        pub const GROUPING: &[i64] = &[3, 3];
        /// `"\u{202f}"`
        pub const THOUSANDS_SEP: &str = "\u{202f}";
    }
    pub mod LC_TELEPHONE {
        /// `Some("358")`
        pub const INT_PREFIX: Option<&str> = Some("358");
        /// `Some("00")`
        pub const INT_SELECT: Option<&str> = Some("00");
        /// `Some("(%A) %l")`
        pub const TEL_DOM_FMT: Option<&str> = Some("(%A) %l");
        /// `Some("+%c %a %l")`
        pub const TEL_INT_FMT: Option<&str> = Some("+%c %a %l");
    }
    pub mod LC_TIME {
        /// `&["su", "ma", "ti", "ke", "to", "pe", "la"]`
        pub const ABDAY: &[&str] = &["su", "ma", "ti", "ke", "to", "pe", "la"];
        /// `&["tammi", "helmi", "maalis", "huhti", "touko", "kesä", "heinä", "elo", "syys", "loka", "marras", "joulu"]`
        pub const ABMON: &[&str] = &["tammi", "helmi", "maalis", "huhti", "touko", "kesä", "heinä", "elo", "syys", "loka", "marras", "joulu"];
        /// `None`
        pub const AB_ALT_MON: Option<&[&str]> = None;
        /// `None`
        pub const ALT_DIGITS: Option<&[&str]> = None;
        /// `None`
        pub const ALT_MON: Option<&[&str]> = None;
        /// `&["", ""]`
        pub const AM_PM: &[&str] = &["", ""];
        /// `None`
        pub const CAL_DIRECTION: Option<i64> = None;
        /// `Some("%a %-d.%-m.%Y %H.%M.%S %z")`
        pub const DATE_FMT: Option<&str> = Some("%a %-d.%-m.%Y %H.%M.%S %z");
        /// `&["sunnuntai", "maanantai", "tiistai", "keskiviikko", "torstai", "perjantai", "lauantai"]`
        pub const DAY: &[&str] = &["sunnuntai", "maanantai", "tiistai", "keskiviikko", "torstai", "perjantai", "lauantai"];
        /// `"%d.%m.%Y"`
        pub const D_FMT: &str = "%d.%m.%Y";
        /// `"%a %e. %Bta %Y %H.%M.%S"`
        pub const D_T_FMT: &str = "%a %e. %Bta %Y %H.%M.%S";
        /// `None`
        pub const ERA: Option<&[&str]> = None;
        /// `None`
        pub const ERA_D_FMT: Option<&str> = None;
        /// `None`
        pub const ERA_D_T_FMT: Option<&str> = None;
        /// `None`
        pub const ERA_T_FMT: Option<&str> = None;
        /// `Some(2)`
        pub const FIRST_WEEKDAY: Option<i64> = Some(2);
        /// `None`
        pub const FIRST_WORKDAY: Option<i64> = None;
        /// `&["tammikuu", "helmikuu", "maaliskuu", "huhtikuu", "toukokuu", "kesäkuu", "heinäkuu", "elokuu", "syyskuu", "lokakuu", "marraskuu", "joulukuu"]`
        pub const MON: &[&str] = &["tammikuu", "helmikuu", "maaliskuu", "huhtikuu", "toukokuu", "kesäkuu", "heinäkuu", "elokuu", "syyskuu", "lokakuu", "marraskuu", "joulukuu"];
        /// `"%H.%M.%S"`
        pub const T_FMT: &str = "%H.%M.%S";
        /// `""`
        pub const T_FMT_AMPM: &str = "";
        /// `Some(&[7, 19971130, 4])`
        pub const WEEK: Option<&[i64]> = Some(&[7, 19971130, 4]);
    }
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod fi_FI_euro {
    pub use super::fi_FI::LC_ADDRESS;
    pub mod LC_IDENTIFICATION {
        /// `None`
        pub const ABBREVIATION: Option<&str> = None;
        /// `Some("https://www.gnu.org/software/libc/")`
        pub const ADDRESS: Option<&str> = Some("https://www.gnu.org/software/libc/");
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        /// ]
        /// ```
        pub const CATEGORY: Option<&[&[&str]]> = Some(&[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_MEASUREMENT"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_TELEPHONE"],
        ]);
        /// `Some("")`
        pub const CONTACT: Option<&str> = Some("");
        /// `Some("2000-08-20")`
        pub const DATE: Option<&str> = Some("2000-08-20");
        /// `Some("bug-glibc-locales@gnu.org")`
        pub const EMAIL: Option<&str> = Some("bug-glibc-locales@gnu.org");
        /// `Some("")`
        pub const FAX: Option<&str> = Some("");
        /// `Some("Finnish")`
        pub const LANGUAGE: Option<&str> = Some("Finnish");
        /// `Some("1.0")`
        pub const REVISION: Option<&str> = Some("1.0");
        /// `Some("Free Software Foundation, Inc.")`
        pub const SOURCE: Option<&str> = Some("Free Software Foundation, Inc.");
        /// `Some("")`
        pub const TEL: Option<&str> = Some("");
        /// `Some("Finland")`
        pub const TERRITORY: Option<&str> = Some("Finland");
        /// `Some("Finnish locale for Finland with Euro")`
        pub const TITLE: Option<&str> = Some("Finnish locale for Finland with Euro");
    }
    pub use super::fi_FI::LC_MESSAGES;
    pub use super::fi_FI::LC_MONETARY;
    pub use super::fi_FI::LC_NUMERIC;
    pub use super::fi_FI::LC_TELEPHONE;
    pub use super::fi_FI::LC_TIME;
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod fil_PH {
    pub mod LC_ADDRESS {
        /// `Some("PHL")`
        pub const COUNTRY_AB3: Option<&str> = Some("PHL");
        /// `Some("PH")`
        pub const COUNTRY_ABTWO: Option<&str> = Some("PH");
        /// `Some("RP")`
        pub const COUNTRY_CAR: Option<&str> = Some("RP");
        /// `None`
        pub const COUNTRY_ISBN: Option<&str> = None;
        /// `Some("Pilipinas")`
        pub const COUNTRY_NAME: Option<&str> = Some("Pilipinas");
        /// `Some(608)`
        pub const COUNTRY_NUM: Option<i64> = Some(608);
        /// `None`
        pub const COUNTRY_POST: Option<&str> = None;
        /// `None`
        pub const LANG_AB: Option<&str> = None;
        /// `None`
        pub const LANG_LIB: Option<&str> = None;
        /// `Some("Filipino")`
        pub const LANG_NAME: Option<&str> = Some("Filipino");
        /// `Some("fil")`
        pub const LANG_TERM: Option<&str> = Some("fil");
        /// `Some("%a%N%f%N%d%N%b%N%h %s %e %r%N%T %z%N%c%N")`
        pub const POSTAL_FMT: Option<&str> = Some("%a%N%f%N%d%N%b%N%h %s %e %r%N%T %z%N%c%N");
    }
    pub mod LC_IDENTIFICATION {
        /// `None`
        pub const ABBREVIATION: Option<&str> = None;
        /// `Some("")`
        pub const ADDRESS: Option<&str> = Some("");
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_MONETARY"],
        /// ]
        /// ```
        pub const CATEGORY: Option<&[&[&str]]> = Some(&[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_TELEPHONE"],
            &["i18n:2012", "LC_MEASUREMENT"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_MONETARY"],
        ]);
        /// `Some("Rene Torres, Pablo Saratxaga")`
        pub const CONTACT: Option<&str> = Some("Rene Torres, Pablo Saratxaga");
        /// `Some("2005-02-02")`
        pub const DATE: Option<&str> = Some("2005-02-02");
        /// `Some("rgtorre@rocketmail.com, pablo@mandrakesoft.com")`
        pub const EMAIL: Option<&str> = Some("rgtorre@rocketmail.com, pablo@mandrakesoft.com");
        /// `Some("")`
        pub const FAX: Option<&str> = Some("");
        /// `Some("Filipino")`
        pub const LANGUAGE: Option<&str> = Some("Filipino");
        /// `Some("0.5")`
        pub const REVISION: Option<&str> = Some("0.5");
        /// `Some("Rene Torres")`
        pub const SOURCE: Option<&str> = Some("Rene Torres");
        /// `Some("")`
        pub const TEL: Option<&str> = Some("");
        /// `Some("Philippines")`
        pub const TERRITORY: Option<&str> = Some("Philippines");
        /// `Some("Filipino language locale for Philippines")`
        pub const TITLE: Option<&str> = Some("Filipino language locale for Philippines");
    }
    pub mod LC_MESSAGES {
        /// `"^[-0hHnN]"`
        pub const NOEXPR: &str = "^[-0hHnN]";
        /// `Some("hindi")`
        pub const NOSTR: Option<&str> = Some("hindi");
        /// `"^[+1oOyY]"`
        pub const YESEXPR: &str = "^[+1oOyY]";
        /// `Some("oo")`
        pub const YESSTR: Option<&str> = Some("oo");
    }
    pub mod LC_MONETARY {
        /// `"₱"`
        pub const CURRENCY_SYMBOL: &str = "₱";
        /// `2`
        pub const FRAC_DIGITS: i64 = 2;
        /// `"PHP "`
        pub const INT_CURR_SYMBOL: &str = "PHP ";
        /// `2`
        pub const INT_FRAC_DIGITS: i64 = 2;
        /// `None`
        pub const INT_N_CS_PRECEDES: Option<i64> = None;
        /// `None`
        pub const INT_N_SEP_BY_SPACE: Option<i64> = None;
        /// `None`
        pub const INT_N_SIGN_POSN: Option<i64> = None;
        /// `None`
        pub const INT_P_CS_PRECEDES: Option<i64> = None;
        /// `None`
        pub const INT_P_SEP_BY_SPACE: Option<i64> = None;
        /// `None`
        pub const INT_P_SIGN_POSN: Option<i64> = None;
        /// `"."`
        pub const MON_DECIMAL_POINT: &str = ".";
        /// `&[3, 3]`
        pub const MON_GROUPING: &[i64] = &[3, 3];
        /// `","`
        pub const MON_THOUSANDS_SEP: &str = ",";
        /// `"-"`
        pub const NEGATIVE_SIGN: &str = "-";
        /// `1`
        pub const N_CS_PRECEDES: i64 = 1;
        /// `1`
        pub const N_SEP_BY_SPACE: i64 = 1;
        /// `1`
        pub const N_SIGN_POSN: i64 = 1;
        /// `""`
        pub const POSITIVE_SIGN: &str = "";
        /// `1`
        pub const P_CS_PRECEDES: i64 = 1;
        /// `0`
        pub const P_SEP_BY_SPACE: i64 = 0;
        /// `1`
        pub const P_SIGN_POSN: i64 = 1;
    }
    pub use super::tl_PH::LC_NUMERIC;
    pub use super::en_PH::LC_TELEPHONE;
    pub mod LC_TIME {
        /// `&["Lin", "Lun", "Mar", "Miy", "Huw", "Biy", "Sab"]`
        pub const ABDAY: &[&str] = &["Lin", "Lun", "Mar", "Miy", "Huw", "Biy", "Sab"];
        /// `&["Ene", "Peb", "Mar", "Abr", "May", "Hun", "Hul", "Ago", "Set", "Okt", "Nob", "Dis"]`
        pub const ABMON: &[&str] = &["Ene", "Peb", "Mar", "Abr", "May", "Hun", "Hul", "Ago", "Set", "Okt", "Nob", "Dis"];
        /// `None`
        pub const AB_ALT_MON: Option<&[&str]> = None;
        /// `None`
        pub const ALT_DIGITS: Option<&[&str]> = None;
        /// `None`
        pub const ALT_MON: Option<&[&str]> = None;
        /// `&["N.U.", "N.H."]`
        pub const AM_PM: &[&str] = &["N.U.", "N.H."];
        /// `None`
        pub const CAL_DIRECTION: Option<i64> = None;
        /// `None`
        pub const DATE_FMT: Option<&str> = None;
        /// `&["Linggo", "Lunes", "Martes", "Miyerkoles", "Huwebes", "Biyernes", "Sabado"]`
        pub const DAY: &[&str] = &["Linggo", "Lunes", "Martes", "Miyerkoles", "Huwebes", "Biyernes", "Sabado"];
        /// `"%m/%d/%y"`
        pub const D_FMT: &str = "%m/%d/%y";
        /// `"%a %d %b %Y %I:%M:%S %p %Z"`
        pub const D_T_FMT: &str = "%a %d %b %Y %I:%M:%S %p %Z";
        /// `None`
        pub const ERA: Option<&[&str]> = None;
        /// `None`
        pub const ERA_D_FMT: Option<&str> = None;
        /// `None`
        pub const ERA_D_T_FMT: Option<&str> = None;
        /// `None`
        pub const ERA_T_FMT: Option<&str> = None;
        /// `None`
        pub const FIRST_WEEKDAY: Option<i64> = None;
        /// `None`
        pub const FIRST_WORKDAY: Option<i64> = None;
        /// `&["Enero", "Pebrero", "Marso", "Abril", "Mayo", "Hunyo", "Hulyo", "Agosto", "Setyembre", "Oktubre", "Nobyembre", "Disyembre"]`
        pub const MON: &[&str] = &["Enero", "Pebrero", "Marso", "Abril", "Mayo", "Hunyo", "Hulyo", "Agosto", "Setyembre", "Oktubre", "Nobyembre", "Disyembre"];
        /// `"%I:%M:%S %p"`
        pub const T_FMT: &str = "%I:%M:%S %p";
        /// `"%I:%M:%S %p"`
        pub const T_FMT_AMPM: &str = "%I:%M:%S %p";
        /// `Some(&[7, 19971130, 1])`
        pub const WEEK: Option<&[i64]> = Some(&[7, 19971130, 1]);
    }
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod fo_FO {
    pub mod LC_ADDRESS {
        /// `Some("FRO")`
        pub const COUNTRY_AB3: Option<&str> = Some("FRO");
        /// `Some("FO")`
        pub const COUNTRY_ABTWO: Option<&str> = Some("FO");
        /// `Some("FO")`
        pub const COUNTRY_CAR: Option<&str> = Some("FO");
        /// `None`
        pub const COUNTRY_ISBN: Option<&str> = None;
        /// `Some("Føroyar")`
        pub const COUNTRY_NAME: Option<&str> = Some("Føroyar");
        /// `Some(234)`
        pub const COUNTRY_NUM: Option<i64> = Some(234);
        /// `None`
        pub const COUNTRY_POST: Option<&str> = None;
        /// `Some("fo")`
        pub const LANG_AB: Option<&str> = Some("fo");
        /// `None`
        pub const LANG_LIB: Option<&str> = None;
        /// `Some("føroyskt")`
        pub const LANG_NAME: Option<&str> = Some("føroyskt");
        /// `Some("fao")`
        pub const LANG_TERM: Option<&str> = Some("fao");
        /// `Some("%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%c%N")`
        pub const POSTAL_FMT: Option<&str> = Some("%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%c%N");
    }
    pub mod LC_IDENTIFICATION {
        /// `None`
        pub const ABBREVIATION: Option<&str> = None;
        /// `Some("Kollegievej 6, DK-2920 Charlottenlund, Danmark")`
        pub const ADDRESS: Option<&str> = Some("Kollegievej 6, DK-2920 Charlottenlund, Danmark");
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        /// ]
        /// ```
        pub const CATEGORY: Option<&[&[&str]]> = Some(&[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_TELEPHONE"],
            &["i18n:2012", "LC_MEASUREMENT"],
        ]);
        /// `Some("")`
        pub const CONTACT: Option<&str> = Some("");
        /// `Some("2000-06-29")`
        pub const DATE: Option<&str> = Some("2000-06-29");
        /// `Some("bug-glibc-locales@gnu.org")`
        pub const EMAIL: Option<&str> = Some("bug-glibc-locales@gnu.org");
        /// `Some("")`
        pub const FAX: Option<&str> = Some("");
        /// `Some("Faroese")`
        pub const LANGUAGE: Option<&str> = Some("Faroese");
        /// `Some("1.0")`
        pub const REVISION: Option<&str> = Some("1.0");
        /// `Some("Danish Standards Association")`
        pub const SOURCE: Option<&str> = Some("Danish Standards Association");
        /// `Some("")`
        pub const TEL: Option<&str> = Some("");
        /// `Some("Faroe Islands")`
        pub const TERRITORY: Option<&str> = Some("Faroe Islands");
        /// `Some("Faroese locale for Faroe Islands")`
        pub const TITLE: Option<&str> = Some("Faroese locale for Faroe Islands");
    }
    pub mod LC_MESSAGES {
        /// `"^[-0Nn]"`
        pub const NOEXPR: &str = "^[-0Nn]";
        /// `Some("nei")`
        pub const NOSTR: Option<&str> = Some("nei");
        /// `"^[+1JjYy]"`
        pub const YESEXPR: &str = "^[+1JjYy]";
        /// `Some("já")`
        pub const YESSTR: Option<&str> = Some("já");
    }
    pub use super::da_DK::LC_MONETARY;
    pub use super::da_DK::LC_NUMERIC;
    pub mod LC_TELEPHONE {
        /// `Some("298")`
        pub const INT_PREFIX: Option<&str> = Some("298");
        /// `Some("00")`
        pub const INT_SELECT: Option<&str> = Some("00");
        /// `None`
        pub const TEL_DOM_FMT: Option<&str> = None;
        /// `Some("+%c %a %l")`
        pub const TEL_INT_FMT: Option<&str> = Some("+%c %a %l");
    }
    pub mod LC_TIME {
        /// `&["sun", "mán", "týs", "mik", "hós", "frí", "ley"]`
        pub const ABDAY: &[&str] = &["sun", "mán", "týs", "mik", "hós", "frí", "ley"];
        /// `&["jan", "feb", "mar", "apr", "mai", "jun", "jul", "aug", "sep", "okt", "nov", "des"]`
        pub const ABMON: &[&str] = &["jan", "feb", "mar", "apr", "mai", "jun", "jul", "aug", "sep", "okt", "nov", "des"];
        /// `None`
        pub const AB_ALT_MON: Option<&[&str]> = None;
        /// `None`
        pub const ALT_DIGITS: Option<&[&str]> = None;
        /// `None`
        pub const ALT_MON: Option<&[&str]> = None;
        /// `&["", ""]`
        pub const AM_PM: &[&str] = &["", ""];
        /// `None`
        pub const CAL_DIRECTION: Option<i64> = None;
        /// `None`
        pub const DATE_FMT: Option<&str> = None;
        /// `&["sunnudagur", "mánadagur", "týsdagur", "mikudagur", "hósdagur", "fríggjadagur", "leygardagur"]`
        pub const DAY: &[&str] = &["sunnudagur", "mánadagur", "týsdagur", "mikudagur", "hósdagur", "fríggjadagur", "leygardagur"];
        /// `"%d/%m-%Y"`
        pub const D_FMT: &str = "%d/%m-%Y";
        /// `"%a %d %b %Y %T %Z"`
        pub const D_T_FMT: &str = "%a %d %b %Y %T %Z";
        /// `None`
        pub const ERA: Option<&[&str]> = None;
        /// `None`
        pub const ERA_D_FMT: Option<&str> = None;
        /// `None`
        pub const ERA_D_T_FMT: Option<&str> = None;
        /// `None`
        pub const ERA_T_FMT: Option<&str> = None;
        /// `Some(2)`
        pub const FIRST_WEEKDAY: Option<i64> = Some(2);
        /// `None`
        pub const FIRST_WORKDAY: Option<i64> = None;
        /// `&["januar", "februar", "mars", "apríl", "mai", "juni", "juli", "august", "september", "oktober", "november", "desember"]`
        pub const MON: &[&str] = &["januar", "februar", "mars", "apríl", "mai", "juni", "juli", "august", "september", "oktober", "november", "desember"];
        /// `"%T"`
        pub const T_FMT: &str = "%T";
        /// `""`
        pub const T_FMT_AMPM: &str = "";
        /// `Some(&[7, 19971130, 4])`
        pub const WEEK: Option<&[i64]> = Some(&[7, 19971130, 4]);
    }
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod fr_BE {
    pub mod LC_ADDRESS {
        /// `Some("BEL")`
        pub const COUNTRY_AB3: Option<&str> = Some("BEL");
        /// `Some("BE")`
        pub const COUNTRY_ABTWO: Option<&str> = Some("BE");
        /// `Some("B")`
        pub const COUNTRY_CAR: Option<&str> = Some("B");
        /// `None`
        pub const COUNTRY_ISBN: Option<&str> = None;
        /// `Some("Belgique")`
        pub const COUNTRY_NAME: Option<&str> = Some("Belgique");
        /// `Some(56)`
        pub const COUNTRY_NUM: Option<i64> = Some(56);
        /// `None`
        pub const COUNTRY_POST: Option<&str> = None;
        /// `Some("fr")`
        pub const LANG_AB: Option<&str> = Some("fr");
        /// `Some("fre")`
        pub const LANG_LIB: Option<&str> = Some("fre");
        /// `Some("français")`
        pub const LANG_NAME: Option<&str> = Some("français");
        /// `Some("fra")`
        pub const LANG_TERM: Option<&str> = Some("fra");
        /// `Some("%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%c%N")`
        pub const POSTAL_FMT: Option<&str> = Some("%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%c%N");
    }
    pub mod LC_IDENTIFICATION {
        /// `None`
        pub const ABBREVIATION: Option<&str> = None;
        /// `Some("Sankt Jørgens Alle 8, DK-1615 København V, Danmark")`
        pub const ADDRESS: Option<&str> = Some("Sankt Jørgens Alle 8, DK-1615 København V, Danmark");
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        /// ]
        /// ```
        pub const CATEGORY: Option<&[&[&str]]> = Some(&[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_TELEPHONE"],
            &["i18n:2012", "LC_MEASUREMENT"],
        ]);
        /// `Some("")`
        pub const CONTACT: Option<&str> = Some("");
        /// `Some("2000-06-29")`
        pub const DATE: Option<&str> = Some("2000-06-29");
        /// `Some("bug-glibc-locales@gnu.org")`
        pub const EMAIL: Option<&str> = Some("bug-glibc-locales@gnu.org");
        /// `Some("")`
        pub const FAX: Option<&str> = Some("");
        /// `Some("French")`
        pub const LANGUAGE: Option<&str> = Some("French");
        /// `Some("1.0")`
        pub const REVISION: Option<&str> = Some("1.0");
        /// `Some("RAP")`
        pub const SOURCE: Option<&str> = Some("RAP");
        /// `Some("")`
        pub const TEL: Option<&str> = Some("");
        /// `Some("Belgium")`
        pub const TERRITORY: Option<&str> = Some("Belgium");
        /// `Some("French locale for Belgium")`
        pub const TITLE: Option<&str> = Some("French locale for Belgium");
    }
    pub mod LC_MESSAGES {
        /// `"^[-0nN]"`
        pub const NOEXPR: &str = "^[-0nN]";
        /// `Some("non")`
        pub const NOSTR: Option<&str> = Some("non");
        /// `"^[+1oOjJyY]"`
        pub const YESEXPR: &str = "^[+1oOjJyY]";
        /// `Some("oui")`
        pub const YESSTR: Option<&str> = Some("oui");
    }
    pub mod LC_MONETARY {
        /// `"€"`
        pub const CURRENCY_SYMBOL: &str = "€";
        /// `2`
        pub const FRAC_DIGITS: i64 = 2;
        /// `"EUR "`
        pub const INT_CURR_SYMBOL: &str = "EUR ";
        /// `2`
        pub const INT_FRAC_DIGITS: i64 = 2;
        /// `None`
        pub const INT_N_CS_PRECEDES: Option<i64> = None;
        /// `None`
        pub const INT_N_SEP_BY_SPACE: Option<i64> = None;
        /// `None`
        pub const INT_N_SIGN_POSN: Option<i64> = None;
        /// `None`
        pub const INT_P_CS_PRECEDES: Option<i64> = None;
        /// `None`
        pub const INT_P_SEP_BY_SPACE: Option<i64> = None;
        /// `None`
        pub const INT_P_SIGN_POSN: Option<i64> = None;
        /// `","`
        pub const MON_DECIMAL_POINT: &str = ",";
        /// `&[3, 3]`
        pub const MON_GROUPING: &[i64] = &[3, 3];
        /// `"."`
        pub const MON_THOUSANDS_SEP: &str = ".";
        /// `"-"`
        pub const NEGATIVE_SIGN: &str = "-";
        /// `0`
        pub const N_CS_PRECEDES: i64 = 0;
        /// `1`
        pub const N_SEP_BY_SPACE: i64 = 1;
        /// `1`
        pub const N_SIGN_POSN: i64 = 1;
        /// `""`
        pub const POSITIVE_SIGN: &str = "";
        /// `0`
        pub const P_CS_PRECEDES: i64 = 0;
        /// `1`
        pub const P_SEP_BY_SPACE: i64 = 1;
        /// `1`
        pub const P_SIGN_POSN: i64 = 1;
    }
    pub mod LC_NUMERIC {
        /// `","`
        pub const DECIMAL_POINT: &str = ",";
        /// `&[3, 3]`
        pub const GROUPING: &[i64] = &[3, 3];
        /// `"."`
        pub const THOUSANDS_SEP: &str = ".";
    }
    pub mod LC_TELEPHONE {
        /// `Some("32")`
        pub const INT_PREFIX: Option<&str> = Some("32");
        /// `Some("00")`
        pub const INT_SELECT: Option<&str> = Some("00");
        /// `None`
        pub const TEL_DOM_FMT: Option<&str> = None;
        /// `Some("+%c %a %l")`
        pub const TEL_INT_FMT: Option<&str> = Some("+%c %a %l");
    }
    pub mod LC_TIME {
        /// `&["dim", "lun", "mar", "mer", "jeu", "ven", "sam"]`
        pub const ABDAY: &[&str] = &["dim", "lun", "mar", "mer", "jeu", "ven", "sam"];
        /// `&["jan", "fév", "mar", "avr", "mai", "jun", "jui", "aoû", "sep", "oct", "nov", "déc"]`
        pub const ABMON: &[&str] = &["jan", "fév", "mar", "avr", "mai", "jun", "jui", "aoû", "sep", "oct", "nov", "déc"];
        /// `None`
        pub const AB_ALT_MON: Option<&[&str]> = None;
        /// `None`
        pub const ALT_DIGITS: Option<&[&str]> = None;
        /// `None`
        pub const ALT_MON: Option<&[&str]> = None;
        /// `&["", ""]`
        pub const AM_PM: &[&str] = &["", ""];
        /// `None`
        pub const CAL_DIRECTION: Option<i64> = None;
        /// `None`
        pub const DATE_FMT: Option<&str> = None;
        /// `&["dimanche", "lundi", "mardi", "mercredi", "jeudi", "vendredi", "samedi"]`
        pub const DAY: &[&str] = &["dimanche", "lundi", "mardi", "mercredi", "jeudi", "vendredi", "samedi"];
        /// `"%d/%m/%y"`
        pub const D_FMT: &str = "%d/%m/%y";
        /// `"%a %d %b %Y %T %Z"`
        pub const D_T_FMT: &str = "%a %d %b %Y %T %Z";
        /// `None`
        pub const ERA: Option<&[&str]> = None;
        /// `None`
        pub const ERA_D_FMT: Option<&str> = None;
        /// `None`
        pub const ERA_D_T_FMT: Option<&str> = None;
        /// `None`
        pub const ERA_T_FMT: Option<&str> = None;
        /// `Some(2)`
        pub const FIRST_WEEKDAY: Option<i64> = Some(2);
        /// `None`
        pub const FIRST_WORKDAY: Option<i64> = None;
        /// `&["janvier", "février", "mars", "avril", "mai", "juin", "juillet", "août", "septembre", "octobre", "novembre", "décembre"]`
        pub const MON: &[&str] = &["janvier", "février", "mars", "avril", "mai", "juin", "juillet", "août", "septembre", "octobre", "novembre", "décembre"];
        /// `"%T"`
        pub const T_FMT: &str = "%T";
        /// `""`
        pub const T_FMT_AMPM: &str = "";
        /// `Some(&[7, 19971130, 4])`
        pub const WEEK: Option<&[i64]> = Some(&[7, 19971130, 4]);
    }
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod fr_BE_euro {
    pub use super::fr_BE::LC_ADDRESS;
    pub mod LC_IDENTIFICATION {
        /// `None`
        pub const ABBREVIATION: Option<&str> = None;
        /// `Some("https://www.gnu.org/software/libc/")`
        pub const ADDRESS: Option<&str> = Some("https://www.gnu.org/software/libc/");
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        /// ]
        /// ```
        pub const CATEGORY: Option<&[&[&str]]> = Some(&[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_TELEPHONE"],
            &["i18n:2012", "LC_MEASUREMENT"],
        ]);
        /// `Some("")`
        pub const CONTACT: Option<&str> = Some("");
        /// `Some("2000-08-20")`
        pub const DATE: Option<&str> = Some("2000-08-20");
        /// `Some("bug-glibc-locales@gnu.org")`
        pub const EMAIL: Option<&str> = Some("bug-glibc-locales@gnu.org");
        /// `Some("")`
        pub const FAX: Option<&str> = Some("");
        /// `Some("French")`
        pub const LANGUAGE: Option<&str> = Some("French");
        /// `Some("1.0")`
        pub const REVISION: Option<&str> = Some("1.0");
        /// `Some("Free Software Foundation, Inc.")`
        pub const SOURCE: Option<&str> = Some("Free Software Foundation, Inc.");
        /// `Some("")`
        pub const TEL: Option<&str> = Some("");
        /// `Some("Belgium")`
        pub const TERRITORY: Option<&str> = Some("Belgium");
        /// `Some("French locale for Belgium with Euro")`
        pub const TITLE: Option<&str> = Some("French locale for Belgium with Euro");
    }
    pub use super::fr_BE::LC_MESSAGES;
    pub use super::fr_BE::LC_MONETARY;
    pub use super::fr_BE::LC_NUMERIC;
    pub use super::fr_BE::LC_TELEPHONE;
    pub use super::fr_BE::LC_TIME;
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod fr_CA {
    pub mod LC_ADDRESS {
        /// `Some("CAN")`
        pub const COUNTRY_AB3: Option<&str> = Some("CAN");
        /// `Some("CA")`
        pub const COUNTRY_ABTWO: Option<&str> = Some("CA");
        /// `Some("CDN")`
        pub const COUNTRY_CAR: Option<&str> = Some("CDN");
        /// `None`
        pub const COUNTRY_ISBN: Option<&str> = None;
        /// `Some("Canada")`
        pub const COUNTRY_NAME: Option<&str> = Some("Canada");
        /// `Some(124)`
        pub const COUNTRY_NUM: Option<i64> = Some(124);
        /// `None`
        pub const COUNTRY_POST: Option<&str> = None;
        /// `Some("fr")`
        pub const LANG_AB: Option<&str> = Some("fr");
        /// `Some("fre")`
        pub const LANG_LIB: Option<&str> = Some("fre");
        /// `Some("français")`
        pub const LANG_NAME: Option<&str> = Some("français");
        /// `Some("fra")`
        pub const LANG_TERM: Option<&str> = Some("fra");
        /// `Some("%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%c%N")`
        pub const POSTAL_FMT: Option<&str> = Some("%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%c%N");
    }
    pub mod LC_IDENTIFICATION {
        /// `None`
        pub const ABBREVIATION: Option<&str> = None;
        /// `Some("Sankt Jørgens Alle 8, DK-1615 København V, Danmark")`
        pub const ADDRESS: Option<&str> = Some("Sankt Jørgens Alle 8, DK-1615 København V, Danmark");
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        /// ]
        /// ```
        pub const CATEGORY: Option<&[&[&str]]> = Some(&[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_TELEPHONE"],
            &["i18n:2012", "LC_MEASUREMENT"],
        ]);
        /// `Some("")`
        pub const CONTACT: Option<&str> = Some("");
        /// `Some("2000-06-29")`
        pub const DATE: Option<&str> = Some("2000-06-29");
        /// `Some("bug-glibc-locales@gnu.org")`
        pub const EMAIL: Option<&str> = Some("bug-glibc-locales@gnu.org");
        /// `Some("")`
        pub const FAX: Option<&str> = Some("");
        /// `Some("Canadian French")`
        pub const LANGUAGE: Option<&str> = Some("Canadian French");
        /// `Some("1.0")`
        pub const REVISION: Option<&str> = Some("1.0");
        /// `Some("RAP")`
        pub const SOURCE: Option<&str> = Some("RAP");
        /// `Some("")`
        pub const TEL: Option<&str> = Some("");
        /// `Some("Canada")`
        pub const TERRITORY: Option<&str> = Some("Canada");
        /// `Some("French locale for Canada")`
        pub const TITLE: Option<&str> = Some("French locale for Canada");
    }
    pub use super::fr_FR::LC_MESSAGES;
    pub mod LC_MONETARY {
        /// `"$"`
        pub const CURRENCY_SYMBOL: &str = "$";
        /// `2`
        pub const FRAC_DIGITS: i64 = 2;
        /// `"CAD "`
        pub const INT_CURR_SYMBOL: &str = "CAD ";
        /// `2`
        pub const INT_FRAC_DIGITS: i64 = 2;
        /// `None`
        pub const INT_N_CS_PRECEDES: Option<i64> = None;
        /// `None`
        pub const INT_N_SEP_BY_SPACE: Option<i64> = None;
        /// `None`
        pub const INT_N_SIGN_POSN: Option<i64> = None;
        /// `None`
        pub const INT_P_CS_PRECEDES: Option<i64> = None;
        /// `None`
        pub const INT_P_SEP_BY_SPACE: Option<i64> = None;
        /// `None`
        pub const INT_P_SIGN_POSN: Option<i64> = None;
        /// `","`
        pub const MON_DECIMAL_POINT: &str = ",";
        /// `&[3, 3]`
        pub const MON_GROUPING: &[i64] = &[3, 3];
        /// `"\u{202f}"`
        pub const MON_THOUSANDS_SEP: &str = "\u{202f}";
        /// `"-"`
        pub const NEGATIVE_SIGN: &str = "-";
        /// `0`
        pub const N_CS_PRECEDES: i64 = 0;
        /// `1`
        pub const N_SEP_BY_SPACE: i64 = 1;
        /// `0`
        pub const N_SIGN_POSN: i64 = 0;
        /// `""`
        pub const POSITIVE_SIGN: &str = "";
        /// `0`
        pub const P_CS_PRECEDES: i64 = 0;
        /// `1`
        pub const P_SEP_BY_SPACE: i64 = 1;
        /// `1`
        pub const P_SIGN_POSN: i64 = 1;
    }
    pub use super::fr_FR::LC_NUMERIC;
    pub use super::en_CA::LC_TELEPHONE;
    pub mod LC_TIME {
        /// `&["dim", "lun", "mar", "mer", "jeu", "ven", "sam"]`
        pub const ABDAY: &[&str] = &["dim", "lun", "mar", "mer", "jeu", "ven", "sam"];
        /// `&["jan", "fév", "mar", "avr", "mai", "jun", "jui", "aoû", "sep", "oct", "nov", "déc"]`
        pub const ABMON: &[&str] = &["jan", "fév", "mar", "avr", "mai", "jun", "jui", "aoû", "sep", "oct", "nov", "déc"];
        /// `None`
        pub const AB_ALT_MON: Option<&[&str]> = None;
        /// `None`
        pub const ALT_DIGITS: Option<&[&str]> = None;
        /// `None`
        pub const ALT_MON: Option<&[&str]> = None;
        /// `&["", ""]`
        pub const AM_PM: &[&str] = &["", ""];
        /// `None`
        pub const CAL_DIRECTION: Option<i64> = None;
        /// `None`
        pub const DATE_FMT: Option<&str> = None;
        /// `&["dimanche", "lundi", "mardi", "mercredi", "jeudi", "vendredi", "samedi"]`
        pub const DAY: &[&str] = &["dimanche", "lundi", "mardi", "mercredi", "jeudi", "vendredi", "samedi"];
        /// `"%Y-%m-%d"`
        pub const D_FMT: &str = "%Y-%m-%d";
        /// `"%a %d %b %Y %T %Z"`
        pub const D_T_FMT: &str = "%a %d %b %Y %T %Z";
        /// `None`
        pub const ERA: Option<&[&str]> = None;
        /// `None`
        pub const ERA_D_FMT: Option<&str> = None;
        /// `None`
        pub const ERA_D_T_FMT: Option<&str> = None;
        /// `None`
        pub const ERA_T_FMT: Option<&str> = None;
        /// `None`
        pub const FIRST_WEEKDAY: Option<i64> = None;
        /// `None`
        pub const FIRST_WORKDAY: Option<i64> = None;
        /// `&["janvier", "février", "mars", "avril", "mai", "juin", "juillet", "août", "septembre", "octobre", "novembre", "décembre"]`
        pub const MON: &[&str] = &["janvier", "février", "mars", "avril", "mai", "juin", "juillet", "août", "septembre", "octobre", "novembre", "décembre"];
        /// `"%T"`
        pub const T_FMT: &str = "%T";
        /// `""`
        pub const T_FMT_AMPM: &str = "";
        /// `Some(&[7, 19971130, 1])`
        pub const WEEK: Option<&[i64]> = Some(&[7, 19971130, 1]);
    }
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod fr_CH {
    pub mod LC_ADDRESS {
        /// `Some("CHE")`
        pub const COUNTRY_AB3: Option<&str> = Some("CHE");
        /// `Some("CH")`
        pub const COUNTRY_ABTWO: Option<&str> = Some("CH");
        /// `Some("CH")`
        pub const COUNTRY_CAR: Option<&str> = Some("CH");
        /// `None`
        pub const COUNTRY_ISBN: Option<&str> = None;
        /// `Some("Suisse")`
        pub const COUNTRY_NAME: Option<&str> = Some("Suisse");
        /// `Some(756)`
        pub const COUNTRY_NUM: Option<i64> = Some(756);
        /// `None`
        pub const COUNTRY_POST: Option<&str> = None;
        /// `Some("fr")`
        pub const LANG_AB: Option<&str> = Some("fr");
        /// `Some("fre")`
        pub const LANG_LIB: Option<&str> = Some("fre");
        /// `Some("français")`
        pub const LANG_NAME: Option<&str> = Some("français");
        /// `Some("fra")`
        pub const LANG_TERM: Option<&str> = Some("fra");
        /// `Some("%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%c%N")`
        pub const POSTAL_FMT: Option<&str> = Some("%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%c%N");
    }
    pub mod LC_IDENTIFICATION {
        /// `None`
        pub const ABBREVIATION: Option<&str> = None;
        /// `Some("Sankt Jørgens Alle 8, DK-1615 København V, Danmark")`
        pub const ADDRESS: Option<&str> = Some("Sankt Jørgens Alle 8, DK-1615 København V, Danmark");
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        /// ]
        /// ```
        pub const CATEGORY: Option<&[&[&str]]> = Some(&[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_TELEPHONE"],
            &["i18n:2012", "LC_MEASUREMENT"],
        ]);
        /// `Some("")`
        pub const CONTACT: Option<&str> = Some("");
        /// `Some("2000-06-29")`
        pub const DATE: Option<&str> = Some("2000-06-29");
        /// `Some("bug-glibc-locales@gnu.org")`
        pub const EMAIL: Option<&str> = Some("bug-glibc-locales@gnu.org");
        /// `Some("")`
        pub const FAX: Option<&str> = Some("");
        /// `Some("Swiss French")`
        pub const LANGUAGE: Option<&str> = Some("Swiss French");
        /// `Some("1.0")`
        pub const REVISION: Option<&str> = Some("1.0");
        /// `Some("RAP")`
        pub const SOURCE: Option<&str> = Some("RAP");
        /// `Some("")`
        pub const TEL: Option<&str> = Some("");
        /// `Some("Switzerland")`
        pub const TERRITORY: Option<&str> = Some("Switzerland");
        /// `Some("French locale for Switzerland")`
        pub const TITLE: Option<&str> = Some("French locale for Switzerland");
    }
    pub mod LC_MESSAGES {
        /// `"^[-0nN]"`
        pub const NOEXPR: &str = "^[-0nN]";
        /// `Some("non")`
        pub const NOSTR: Option<&str> = Some("non");
        /// `"^[+1OojJsSyY]"`
        pub const YESEXPR: &str = "^[+1OojJsSyY]";
        /// `Some("oui")`
        pub const YESSTR: Option<&str> = Some("oui");
    }
    pub use super::de_CH::LC_MONETARY;
    pub use super::de_CH::LC_NUMERIC;
    pub mod LC_TELEPHONE {
        /// `Some("41")`
        pub const INT_PREFIX: Option<&str> = Some("41");
        /// `Some("00")`
        pub const INT_SELECT: Option<&str> = Some("00");
        /// `None`
        pub const TEL_DOM_FMT: Option<&str> = None;
        /// `Some("+%c %a %l")`
        pub const TEL_INT_FMT: Option<&str> = Some("+%c %a %l");
    }
    pub mod LC_TIME {
        /// `&["dim", "lun", "mar", "mer", "jeu", "ven", "sam"]`
        pub const ABDAY: &[&str] = &["dim", "lun", "mar", "mer", "jeu", "ven", "sam"];
        /// `&["jan", "fév", "mar", "avr", "mai", "jun", "jui", "aoû", "sep", "oct", "nov", "déc"]`
        pub const ABMON: &[&str] = &["jan", "fév", "mar", "avr", "mai", "jun", "jui", "aoû", "sep", "oct", "nov", "déc"];
        /// `None`
        pub const AB_ALT_MON: Option<&[&str]> = None;
        /// `None`
        pub const ALT_DIGITS: Option<&[&str]> = None;
        /// `None`
        pub const ALT_MON: Option<&[&str]> = None;
        /// `&["", ""]`
        pub const AM_PM: &[&str] = &["", ""];
        /// `None`
        pub const CAL_DIRECTION: Option<i64> = None;
        /// `None`
        pub const DATE_FMT: Option<&str> = None;
        /// `&["dimanche", "lundi", "mardi", "mercredi", "jeudi", "vendredi", "samedi"]`
        pub const DAY: &[&str] = &["dimanche", "lundi", "mardi", "mercredi", "jeudi", "vendredi", "samedi"];
        /// `"%d. %m. %y"`
        pub const D_FMT: &str = "%d. %m. %y";
        /// `"%a %d %b %Y %T %Z"`
        pub const D_T_FMT: &str = "%a %d %b %Y %T %Z";
        /// `None`
        pub const ERA: Option<&[&str]> = None;
        /// `None`
        pub const ERA_D_FMT: Option<&str> = None;
        /// `None`
        pub const ERA_D_T_FMT: Option<&str> = None;
        /// `None`
        pub const ERA_T_FMT: Option<&str> = None;
        /// `Some(2)`
        pub const FIRST_WEEKDAY: Option<i64> = Some(2);
        /// `None`
        pub const FIRST_WORKDAY: Option<i64> = None;
        /// `&["janvier", "février", "mars", "avril", "mai", "juin", "juillet", "août", "septembre", "octobre", "novembre", "décembre"]`
        pub const MON: &[&str] = &["janvier", "février", "mars", "avril", "mai", "juin", "juillet", "août", "septembre", "octobre", "novembre", "décembre"];
        /// `"%T"`
        pub const T_FMT: &str = "%T";
        /// `""`
        pub const T_FMT_AMPM: &str = "";
        /// `Some(&[7, 19971130, 4])`
        pub const WEEK: Option<&[i64]> = Some(&[7, 19971130, 4]);
    }
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod fr_FR {
    pub mod LC_ADDRESS {
        /// `Some("FRA")`
        pub const COUNTRY_AB3: Option<&str> = Some("FRA");
        /// `Some("FR")`
        pub const COUNTRY_ABTWO: Option<&str> = Some("FR");
        /// `Some("F")`
        pub const COUNTRY_CAR: Option<&str> = Some("F");
        /// `Some("979-10")`
        pub const COUNTRY_ISBN: Option<&str> = Some("979-10");
        /// `Some("France")`
        pub const COUNTRY_NAME: Option<&str> = Some("France");
        /// `Some(250)`
        pub const COUNTRY_NUM: Option<i64> = Some(250);
        /// `None`
        pub const COUNTRY_POST: Option<&str> = None;
        /// `Some("fr")`
        pub const LANG_AB: Option<&str> = Some("fr");
        /// `Some("fre")`
        pub const LANG_LIB: Option<&str> = Some("fre");
        /// `Some("français")`
        pub const LANG_NAME: Option<&str> = Some("français");
        /// `Some("fra")`
        pub const LANG_TERM: Option<&str> = Some("fra");
        /// `Some("%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%c%N")`
        pub const POSTAL_FMT: Option<&str> = Some("%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%c%N");
    }
    pub mod LC_IDENTIFICATION {
        /// `None`
        pub const ABBREVIATION: Option<&str> = None;
        /// `Some("")`
        pub const ADDRESS: Option<&str> = Some("");
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        /// ]
        /// ```
        pub const CATEGORY: Option<&[&[&str]]> = Some(&[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_TELEPHONE"],
            &["i18n:2012", "LC_MEASUREMENT"],
        ]);
        /// `Some("Traduc.org")`
        pub const CONTACT: Option<&str> = Some("Traduc.org");
        /// `Some("2008-03-15")`
        pub const DATE: Option<&str> = Some("2008-03-15");
        /// `Some("bug-glibc-locales@gnu.org")`
        pub const EMAIL: Option<&str> = Some("bug-glibc-locales@gnu.org");
        /// `Some("")`
        pub const FAX: Option<&str> = Some("");
        /// `Some("French")`
        pub const LANGUAGE: Option<&str> = Some("French");
        /// `Some("1.0")`
        pub const REVISION: Option<&str> = Some("1.0");
        /// `Some("RAP")`
        pub const SOURCE: Option<&str> = Some("RAP");
        /// `Some("")`
        pub const TEL: Option<&str> = Some("");
        /// `Some("France")`
        pub const TERRITORY: Option<&str> = Some("France");
        /// `Some("French locale for France")`
        pub const TITLE: Option<&str> = Some("French locale for France");
    }
    pub mod LC_MESSAGES {
        /// `"^[-0nN]"`
        pub const NOEXPR: &str = "^[-0nN]";
        /// `Some("non")`
        pub const NOSTR: Option<&str> = Some("non");
        /// `"^[+1oOyY]"`
        pub const YESEXPR: &str = "^[+1oOyY]";
        /// `Some("oui")`
        pub const YESSTR: Option<&str> = Some("oui");
    }
    pub mod LC_MONETARY {
        /// `"€"`
        pub const CURRENCY_SYMBOL: &str = "€";
        /// `2`
        pub const FRAC_DIGITS: i64 = 2;
        /// `"EUR "`
        pub const INT_CURR_SYMBOL: &str = "EUR ";
        /// `2`
        pub const INT_FRAC_DIGITS: i64 = 2;
        /// `None`
        pub const INT_N_CS_PRECEDES: Option<i64> = None;
        /// `None`
        pub const INT_N_SEP_BY_SPACE: Option<i64> = None;
        /// `None`
        pub const INT_N_SIGN_POSN: Option<i64> = None;
        /// `None`
        pub const INT_P_CS_PRECEDES: Option<i64> = None;
        /// `None`
        pub const INT_P_SEP_BY_SPACE: Option<i64> = None;
        /// `None`
        pub const INT_P_SIGN_POSN: Option<i64> = None;
        /// `","`
        pub const MON_DECIMAL_POINT: &str = ",";
        /// `&[3]`
        pub const MON_GROUPING: &[i64] = &[3];
        /// `"\u{202f}"`
        pub const MON_THOUSANDS_SEP: &str = "\u{202f}";
        /// `"-"`
        pub const NEGATIVE_SIGN: &str = "-";
        /// `0`
        pub const N_CS_PRECEDES: i64 = 0;
        /// `1`
        pub const N_SEP_BY_SPACE: i64 = 1;
        /// `1`
        pub const N_SIGN_POSN: i64 = 1;
        /// `""`
        pub const POSITIVE_SIGN: &str = "";
        /// `0`
        pub const P_CS_PRECEDES: i64 = 0;
        /// `1`
        pub const P_SEP_BY_SPACE: i64 = 1;
        /// `1`
        pub const P_SIGN_POSN: i64 = 1;
    }
    pub mod LC_NUMERIC {
        /// `","`
        pub const DECIMAL_POINT: &str = ",";
        /// `&[3]`
        pub const GROUPING: &[i64] = &[3];
        /// `"\u{202f}"`
        pub const THOUSANDS_SEP: &str = "\u{202f}";
    }
    pub mod LC_TELEPHONE {
        /// `Some("33")`
        pub const INT_PREFIX: Option<&str> = Some("33");
        /// `Some("00")`
        pub const INT_SELECT: Option<&str> = Some("00");
        /// `Some("%a %l")`
        pub const TEL_DOM_FMT: Option<&str> = Some("%a %l");
        /// `Some("+%c %a %l")`
        pub const TEL_INT_FMT: Option<&str> = Some("+%c %a %l");
    }
    pub mod LC_TIME {
        /// `&["dim.", "lun.", "mar.", "mer.", "jeu.", "ven.", "sam."]`
        pub const ABDAY: &[&str] = &["dim.", "lun.", "mar.", "mer.", "jeu.", "ven.", "sam."];
        /// `&["janv.", "févr.", "mars", "avril", "mai", "juin", "juil.", "août", "sept.", "oct.", "nov.", "déc."]`
        pub const ABMON: &[&str] = &["janv.", "févr.", "mars", "avril", "mai", "juin", "juil.", "août", "sept.", "oct.", "nov.", "déc."];
        /// `None`
        pub const AB_ALT_MON: Option<&[&str]> = None;
        /// `None`
        pub const ALT_DIGITS: Option<&[&str]> = None;
        /// `None`
        pub const ALT_MON: Option<&[&str]> = None;
        /// `&["", ""]`
        pub const AM_PM: &[&str] = &["", ""];
        /// `None`
        pub const CAL_DIRECTION: Option<i64> = None;
        /// `None`
        pub const DATE_FMT: Option<&str> = None;
        /// `&["dimanche", "lundi", "mardi", "mercredi", "jeudi", "vendredi", "samedi"]`
        pub const DAY: &[&str] = &["dimanche", "lundi", "mardi", "mercredi", "jeudi", "vendredi", "samedi"];
        /// `"%d/%m/%Y"`
        pub const D_FMT: &str = "%d/%m/%Y";
        /// `"%a %d %b %Y %T %Z"`
        pub const D_T_FMT: &str = "%a %d %b %Y %T %Z";
        /// `None`
        pub const ERA: Option<&[&str]> = None;
        /// `None`
        pub const ERA_D_FMT: Option<&str> = None;
        /// `None`
        pub const ERA_D_T_FMT: Option<&str> = None;
        /// `None`
        pub const ERA_T_FMT: Option<&str> = None;
        /// `Some(2)`
        pub const FIRST_WEEKDAY: Option<i64> = Some(2);
        /// `None`
        pub const FIRST_WORKDAY: Option<i64> = None;
        /// `&["janvier", "février", "mars", "avril", "mai", "juin", "juillet", "août", "septembre", "octobre", "novembre", "décembre"]`
        pub const MON: &[&str] = &["janvier", "février", "mars", "avril", "mai", "juin", "juillet", "août", "septembre", "octobre", "novembre", "décembre"];
        /// `"%T"`
        pub const T_FMT: &str = "%T";
        /// `""`
        pub const T_FMT_AMPM: &str = "";
        /// `Some(&[7, 19971130, 4])`
        pub const WEEK: Option<&[i64]> = Some(&[7, 19971130, 4]);
    }
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod fr_FR_euro {
    pub use super::fr_FR::LC_ADDRESS;
    pub mod LC_IDENTIFICATION {
        /// `None`
        pub const ABBREVIATION: Option<&str> = None;
        /// `Some("https://www.gnu.org/software/libc/")`
        pub const ADDRESS: Option<&str> = Some("https://www.gnu.org/software/libc/");
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        /// ]
        /// ```
        pub const CATEGORY: Option<&[&[&str]]> = Some(&[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_TELEPHONE"],
            &["i18n:2012", "LC_MEASUREMENT"],
        ]);
        /// `None`
        pub const CONTACT: Option<&str> = None;
        /// `Some("2000-08-20")`
        pub const DATE: Option<&str> = Some("2000-08-20");
        /// `Some("bug-glibc-locales@gnu.org")`
        pub const EMAIL: Option<&str> = Some("bug-glibc-locales@gnu.org");
        /// `Some("")`
        pub const FAX: Option<&str> = Some("");
        /// `Some("French")`
        pub const LANGUAGE: Option<&str> = Some("French");
        /// `Some("1.0")`
        pub const REVISION: Option<&str> = Some("1.0");
        /// `Some("Free Software Foundation, Inc.")`
        pub const SOURCE: Option<&str> = Some("Free Software Foundation, Inc.");
        /// `Some("")`
        pub const TEL: Option<&str> = Some("");
        /// `Some("France")`
        pub const TERRITORY: Option<&str> = Some("France");
        /// `Some("French locale for France with Euro")`
        pub const TITLE: Option<&str> = Some("French locale for France with Euro");
    }
    pub use super::fr_FR::LC_MESSAGES;
    pub use super::fr_FR::LC_MONETARY;
    pub use super::fr_FR::LC_NUMERIC;
    pub use super::fr_FR::LC_TELEPHONE;
    pub use super::fr_FR::LC_TIME;
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod fr_LU {
    pub mod LC_ADDRESS {
        /// `Some("LUX")`
        pub const COUNTRY_AB3: Option<&str> = Some("LUX");
        /// `Some("LU")`
        pub const COUNTRY_ABTWO: Option<&str> = Some("LU");
        /// `Some("L")`
        pub const COUNTRY_CAR: Option<&str> = Some("L");
        /// `None`
        pub const COUNTRY_ISBN: Option<&str> = None;
        /// `Some("Luxembourg")`
        pub const COUNTRY_NAME: Option<&str> = Some("Luxembourg");
        /// `Some(442)`
        pub const COUNTRY_NUM: Option<i64> = Some(442);
        /// `None`
        pub const COUNTRY_POST: Option<&str> = None;
        /// `Some("fr")`
        pub const LANG_AB: Option<&str> = Some("fr");
        /// `Some("fre")`
        pub const LANG_LIB: Option<&str> = Some("fre");
        /// `Some("français")`
        pub const LANG_NAME: Option<&str> = Some("français");
        /// `Some("fra")`
        pub const LANG_TERM: Option<&str> = Some("fra");
        /// `Some("%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%c%N")`
        pub const POSTAL_FMT: Option<&str> = Some("%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%c%N");
    }
    pub mod LC_IDENTIFICATION {
        /// `None`
        pub const ABBREVIATION: Option<&str> = None;
        /// `Some("Sankt Jørgens Alle 8, DK-1615 København V, Danmark")`
        pub const ADDRESS: Option<&str> = Some("Sankt Jørgens Alle 8, DK-1615 København V, Danmark");
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        /// ]
        /// ```
        pub const CATEGORY: Option<&[&[&str]]> = Some(&[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_TELEPHONE"],
            &["i18n:2012", "LC_MEASUREMENT"],
        ]);
        /// `Some("")`
        pub const CONTACT: Option<&str> = Some("");
        /// `Some("2000-06-29")`
        pub const DATE: Option<&str> = Some("2000-06-29");
        /// `Some("bug-glibc-locales@gnu.org")`
        pub const EMAIL: Option<&str> = Some("bug-glibc-locales@gnu.org");
        /// `Some("")`
        pub const FAX: Option<&str> = Some("");
        /// `Some("French")`
        pub const LANGUAGE: Option<&str> = Some("French");
        /// `Some("1.0")`
        pub const REVISION: Option<&str> = Some("1.0");
        /// `Some("RAP")`
        pub const SOURCE: Option<&str> = Some("RAP");
        /// `Some("")`
        pub const TEL: Option<&str> = Some("");
        /// `Some("Luxembourg")`
        pub const TERRITORY: Option<&str> = Some("Luxembourg");
        /// `Some("French locale for Luxemburg")`
        pub const TITLE: Option<&str> = Some("French locale for Luxemburg");
    }
    pub mod LC_MESSAGES {
        /// `"^[-0nN]"`
        pub const NOEXPR: &str = "^[-0nN]";
        /// `Some("non")`
        pub const NOSTR: Option<&str> = Some("non");
        /// `"^[+1oOyY]"`
        pub const YESEXPR: &str = "^[+1oOyY]";
        /// `Some("oui")`
        pub const YESSTR: Option<&str> = Some("oui");
    }
    pub mod LC_MONETARY {
        /// `"€"`
        pub const CURRENCY_SYMBOL: &str = "€";
        /// `2`
        pub const FRAC_DIGITS: i64 = 2;
        /// `"EUR "`
        pub const INT_CURR_SYMBOL: &str = "EUR ";
        /// `2`
        pub const INT_FRAC_DIGITS: i64 = 2;
        /// `None`
        pub const INT_N_CS_PRECEDES: Option<i64> = None;
        /// `None`
        pub const INT_N_SEP_BY_SPACE: Option<i64> = None;
        /// `None`
        pub const INT_N_SIGN_POSN: Option<i64> = None;
        /// `None`
        pub const INT_P_CS_PRECEDES: Option<i64> = None;
        /// `None`
        pub const INT_P_SEP_BY_SPACE: Option<i64> = None;
        /// `None`
        pub const INT_P_SIGN_POSN: Option<i64> = None;
        /// `","`
        pub const MON_DECIMAL_POINT: &str = ",";
        /// `&[3, 3]`
        pub const MON_GROUPING: &[i64] = &[3, 3];
        /// `"\u{202f}"`
        pub const MON_THOUSANDS_SEP: &str = "\u{202f}";
        /// `"-"`
        pub const NEGATIVE_SIGN: &str = "-";
        /// `0`
        pub const N_CS_PRECEDES: i64 = 0;
        /// `1`
        pub const N_SEP_BY_SPACE: i64 = 1;
        /// `1`
        pub const N_SIGN_POSN: i64 = 1;
        /// `""`
        pub const POSITIVE_SIGN: &str = "";
        /// `0`
        pub const P_CS_PRECEDES: i64 = 0;
        /// `1`
        pub const P_SEP_BY_SPACE: i64 = 1;
        /// `1`
        pub const P_SIGN_POSN: i64 = 1;
    }
    pub mod LC_NUMERIC {
        /// `","`
        pub const DECIMAL_POINT: &str = ",";
        /// `&[3, 3]`
        pub const GROUPING: &[i64] = &[3, 3];
        /// `"\u{202f}"`
        pub const THOUSANDS_SEP: &str = "\u{202f}";
    }
    pub mod LC_TELEPHONE {
        /// `Some("352")`
        pub const INT_PREFIX: Option<&str> = Some("352");
        /// `Some("00")`
        pub const INT_SELECT: Option<&str> = Some("00");
        /// `None`
        pub const TEL_DOM_FMT: Option<&str> = None;
        /// `Some("+%c %a %l")`
        pub const TEL_INT_FMT: Option<&str> = Some("+%c %a %l");
    }
    pub mod LC_TIME {
        /// `&["dim", "lun", "mar", "mer", "jeu", "ven", "sam"]`
        pub const ABDAY: &[&str] = &["dim", "lun", "mar", "mer", "jeu", "ven", "sam"];
        /// `&["jan", "fév", "mar", "avr", "mai", "jun", "jui", "aoû", "sep", "oct", "nov", "déc"]`
        pub const ABMON: &[&str] = &["jan", "fév", "mar", "avr", "mai", "jun", "jui", "aoû", "sep", "oct", "nov", "déc"];
        /// `None`
        pub const AB_ALT_MON: Option<&[&str]> = None;
        /// `None`
        pub const ALT_DIGITS: Option<&[&str]> = None;
        /// `None`
        pub const ALT_MON: Option<&[&str]> = None;
        /// `&["", ""]`
        pub const AM_PM: &[&str] = &["", ""];
        /// `None`
        pub const CAL_DIRECTION: Option<i64> = None;
        /// `None`
        pub const DATE_FMT: Option<&str> = None;
        /// `&["dimanche", "lundi", "mardi", "mercredi", "jeudi", "vendredi", "samedi"]`
        pub const DAY: &[&str] = &["dimanche", "lundi", "mardi", "mercredi", "jeudi", "vendredi", "samedi"];
        /// `"%d.%m.%Y"`
        pub const D_FMT: &str = "%d.%m.%Y";
        /// `"%a %d %b %Y %T %Z"`
        pub const D_T_FMT: &str = "%a %d %b %Y %T %Z";
        /// `None`
        pub const ERA: Option<&[&str]> = None;
        /// `None`
        pub const ERA_D_FMT: Option<&str> = None;
        /// `None`
        pub const ERA_D_T_FMT: Option<&str> = None;
        /// `None`
        pub const ERA_T_FMT: Option<&str> = None;
        /// `Some(2)`
        pub const FIRST_WEEKDAY: Option<i64> = Some(2);
        /// `None`
        pub const FIRST_WORKDAY: Option<i64> = None;
        /// `&["janvier", "février", "mars", "avril", "mai", "juin", "juillet", "août", "septembre", "octobre", "novembre", "décembre"]`
        pub const MON: &[&str] = &["janvier", "février", "mars", "avril", "mai", "juin", "juillet", "août", "septembre", "octobre", "novembre", "décembre"];
        /// `"%T"`
        pub const T_FMT: &str = "%T";
        /// `""`
        pub const T_FMT_AMPM: &str = "";
        /// `Some(&[7, 19971130, 4])`
        pub const WEEK: Option<&[i64]> = Some(&[7, 19971130, 4]);
    }
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod fr_LU_euro {
    pub use super::fr_LU::LC_ADDRESS;
    pub mod LC_IDENTIFICATION {
        /// `None`
        pub const ABBREVIATION: Option<&str> = None;
        /// `Some("https://www.gnu.org/software/libc/")`
        pub const ADDRESS: Option<&str> = Some("https://ww