/*-
 * Copyright (c) 2001, 2002, 2003, 2004 Lev Walkin <vlm@lionet.info>.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * $Id: ipcad.h,v 1.44 2005/07/07 05:54:52 vlm Exp $
 */
#ifndef	__IPCAD_H__
#define	__IPCAD_H__

#include "headers.h"
#include "sf_lite.h"
#include "psrc.h"
#include "psrc-bpf.h"
#include "psrc-pcap.h"
#include "psrc-ulog.h"
#include "psrc-ipq.h"
#include "psrc-file.h"
#include "psrc-divert.h"
#include "psrc-dynamic.h"

#define	IPCAD_VERSION_STRING						\
	"IP Accounting Daemon. ipcad Version " IPCAD_VERSION "\n"	\
	"Import {BPF/LIBPCAP/ULOG/LIBIPQ/DIVERT/TEE/FILE}; "		\
	"Export {console/file/RSH/NetFlow}"				\
	"\n"
#define	IPCAD_COPYRIGHT "Copyright (c) 2001, 2002, 2003, 2004 "	\
			"Lev Walkin <vlm@lionet.info>"

int reopen_packet_source_pcap(packet_source_t *psrc, int loop);
int process_packet_sources(packet_source_t *sources);

void process_packet_data(packet_source_t *ps,
	const unsigned char *packet, int caplen,
	const char *iface_in, const char *iface_out);

int if_stat(FILE *, char *iface);
void system_uptime(FILE *);	/* Print the uptime */

int block_certain_signals(sigset_t *old_set);

void usage(void);

int cfgread(const char *);

extern double self_started;

/* Hack against RedHat distribution */
#ifndef	SHUT_RDWR
#define	SHUT_RDWR	2
#endif

int ifst_preopen(void);	/* Pre-open files inaccessible after chroot() */

int display_internal_averages(FILE *, const char *ifname);

#endif	/* __IPCAD_H__ */
