/*-
 * Copyright (c) 2004 Lev Walkin <vlm@lionet.info>.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * $Id: psrc.h,v 1.11 2005/07/07 05:54:53 vlm Exp $
 */
#ifndef	__PSRC_H__
#define	__PSRC_H__

#include "headers.h"
#include "genhash.h"

typedef struct packet_source_s {

	enum {
		IFACE_UNKNOWN,
		IFACE_DYNAMIC,	/* BPF or PCAP, with dynamic name (ppp*) */
		IFACE_BPF,	/* Berkeley Packet Filter */
		IFACE_PCAP,	/* libpcap */
		IFACE_FILE,	/* PCAP file */
		IFACE_ULOG,	/* Linux iptables' ULOG */
		IFACE_IPQ,	/* Linux iptables' IPQ */
		IFACE_DIVERT,	/* BSD ipfw(8) divert(4) */
		IFACE_TEE,	/* BSD ipfw(8) tee */
	} iface_type;
		
	enum {
		PST_INVALID,	/* Not initialized */
		PST_EMBRYONIC,	/* Interface name is set */
		PST_READY,	/* Ready for operation */
		PST_FINISHED,	/* Interface has ceased to exist */
	} state;

	/*
	 * Interface properties.
	 */
	char	ifName[IFNAMSIZ];
	int	ifIndex;	/* Assigned internal (SNMP) index */
#define	IFINDEX_DIVERT_MASK	0x00010000
#define	IFINDEX_TEE_MASK	0x00020000

	unsigned int dlt;	/* Data Link Type */
	char *custom_filter;	/* pcap filter */
	enum {
		IFLAG_NONE	= 0x00,
		IFLAG_INONLY	= 0x01,	/* Incoming only */
		IFLAG_PROMISC	= 0x02,	/* Enable promiscuous mode */
		IFLAG_NF_SAMPLED= 0x04,	/* Enable NetFlow sampling mode */
		IFLAG_NF_DISABLE= 0x08,	/* Disable NetFlow */
		IFLAG_RSH_EXTRA	= 0x10,	/* Enable RSH extra info */
		IFLAG_LARGE_CAP = 0x20,	/* Large capture length (BPF/PCAP) */
		IFLAGS_STRICT	= 0x80,	/* Do not alter flags (internal) */
	} iflags;

	/*
	 * Declare source-dependent interface descriptors.
	 */

	union {
		struct {
			char *name;
			pcap_t *dev;
		} file;
#ifdef	PSRC_pcap
		struct {
			pcap_t *dev;
			pthread_mutex_t dev_mutex;
		} pcap;
#endif
#ifdef  PSRC_ulog
		struct {
			struct	sockaddr_nl	peer;
			uint32_t 		groupmask;
			char *uName;	/* ulog-specific ifName */
		} ulog;
#endif
#ifdef	PSRC_ipq
		struct {
			struct sockaddr_nl	local;
			struct sockaddr_nl	peer;
		} ipq;
#endif
#ifdef  IPPROTO_DIVERT
		struct {
			int			port;
		} divert;
#endif  /* IPPROTO_DIVERT */
		struct {
			genhash_t		*already_got;
		} dynamic;
	} iface;

	int	fd;	/* File descriptor, if applicable */
	char	*buf;
	size_t	bufsize;

	void	*(*process_ptr)(void *);  /* pointer to capture function */
	void	(*print_stats)(FILE *, struct packet_source_s *);

	/*
	 * Run-time variables.
	 */
	pthread_t 	thid;

	/*
	 * Statistics
	 */
	long long bytes_prev;    /* Bytes per previous second, estimated */
	long long bytes_cur;     /* Current bytecount */
	long long packets_prev;  /* Packets per previous second, est. */
	long long packets_cur;   /* Current packets count */

	long long bytes_lp;	/* Bytes per long period */
	long long bps_lp;	/* Bytes per second per long period */

	long long packets_lp;	/* Packets per long period */
	long long pps_lp;	/* Bytes per second per long period */

	double avg_period;	/* Averaging period, seconds */

	unsigned int sample_count;	/* NetFlow sampling-mode counter */

	/*
	 * Internal stuff.
	 */
	struct packet_source_s *next;
} packet_source_t;

packet_source_t *create_packet_source(char *ifname, int iflags, char *filter);
int init_packet_source(packet_source_t *, int retry_mode);
void destroy_packet_source(packet_source_t *ps);

const char *IFNameBySource(void *psrc);

#endif	/* __PSRC_H__ */
