/*-
 * Copyright (c) 2001 Lev Walkin <vlm@lionet.info>.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * $Id: servers.h,v 1.6 2004/03/06 05:29:39 vlm Exp $
 */
#ifndef	__SERVERS_H__
#define __SERVERS_H__

#include "headers.h"

typedef struct server_s {
	pthread_t thid;        /* Thread ID */
	char *name;            /* Thread name */
	volatile sig_atomic_t started_ok;        /* A success flag */
	void *(*server_func)(void *);	/* Server function */

	struct sockaddr_in addr;	/* Address to listen on or send to */
	int sockfd;			/* Socket file descriptor */

	char buf[4096];		/* Misc. buffer */
	size_t buf_off;		/* Buffer offset */

	struct server_s *next;	/* Next server in list */
} server;

extern server *servers_head;


int add_server(void *(*func)(void *), char *name, struct in_addr *listen_ip, int hport);
int start_servers();
void end_servers();

/* RSH server */
void *rsh_server(void *);

/* NetFlow exporter */
void *netflow_exporter(void *);

#endif	/* __SERVERS_H__ */
