/*
 *  Copyright (C) 1999 Peter Amstutz
 *
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License as
 *  published by the Free Software Foundation; either version 2 of *the
 *  License, or (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
 *  02111-1307 USA 
 */

#include <stdlib.h>
#include "../ballistics.h"
#include "../terrain.h"
#include "cluster.h"

Shellstat_bal
wepClusterExplosionInit(struct Projectilepos_bal *prjpos, void **explosioninfo)
{
    /*struct SimpleExplosion_wep *e =
      (struct SimpleExplosion_wep *)
      malloc(sizeof(struct SimpleExplosion_wep));*/
    Weapon_wep *frag = wepLookupWeapon("Cluster Fragment");
    struct Projectilelist_bal *prj;

    prjpos->y += 25;
    /*e->id = prjpos->id;
    e->wid = prjpos->wid;*/

    
    prj = balNewShotAV(prjpos->id, 0, prjpos->x, prjpos->y, 45, 185, frag);
    prj->stat = INITSHOT(prj);
    prj = balNewShotAV(prjpos->id, 0, prjpos->x, prjpos->y, 67, 155, frag);
    prj->stat = INITSHOT(prj);
    prj = balNewShotAV(prjpos->id, 0, prjpos->x, prjpos->y, 78, 200, frag);
    prj->stat = INITSHOT(prj);
    prj = balNewShotAV(prjpos->id, 0, prjpos->x, prjpos->y, 90, 155, frag);
    prj->stat = INITSHOT(prj);
    prj = balNewShotAV(prjpos->id, 0, prjpos->x, prjpos->y, 102, 185, frag);
    prj->stat = INITSHOT(prj);
    prj = balNewShotAV(prjpos->id, 0, prjpos->x, prjpos->y, 113, 170, frag);
    prj->stat = INITSHOT(prj);
    prj = balNewShotAV(prjpos->id, 0, prjpos->x, prjpos->y, 135, 170, frag);
    prj->stat = INITSHOT(prj);

    *((struct SimpleExplosion_wep **) explosioninfo) = NULL;
    return FREEING;
}


Shellstat_bal
wepFragmentExplosionInit(struct Projectilepos_bal * prjpos,
			 void **explosioninfo)
{
    struct SimpleExplosion_wep *e =
	(struct SimpleExplosion_wep *)
	malloc(sizeof(struct SimpleExplosion_wep));

    e->x = prjpos->x;
    e->y = prjpos->y;
    e->r = 0;
    e->dx = 3;
    e->max_radius = 30;
    e->id = prjpos->id;
    e->wid = prjpos->wid;

    *((struct SimpleExplosion_wep **) explosioninfo) = e;
    return EXPLODING;
}
