/*
 * Decompiled with CFR 0.152.
 */
package sun.security.ssl;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.CryptoPrimitive;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.ECPublicKeySpec;
import java.security.spec.InvalidKeySpecException;
import java.text.MessageFormat;
import java.util.EnumSet;
import java.util.Locale;
import java.util.Map;
import sun.misc.HexDumpEncoder;
import sun.security.ssl.Alert;
import sun.security.ssl.ClientHandshakeContext;
import sun.security.ssl.ConnectionContext;
import sun.security.ssl.ECDHKeyExchange;
import sun.security.ssl.HandshakeContext;
import sun.security.ssl.HandshakeOutStream;
import sun.security.ssl.HandshakeProducer;
import sun.security.ssl.JsseJce;
import sun.security.ssl.RSASignature;
import sun.security.ssl.Record;
import sun.security.ssl.SSLConsumer;
import sun.security.ssl.SSLCredentials;
import sun.security.ssl.SSLHandshake;
import sun.security.ssl.SSLLogger;
import sun.security.ssl.ServerHandshakeContext;
import sun.security.ssl.SignatureScheme;
import sun.security.ssl.SupportedGroupsExtension;
import sun.security.ssl.Utilities;
import sun.security.ssl.X509Authentication;

final class ECDHServerKeyExchange {
    static final SSLConsumer ecdheHandshakeConsumer = new ECDHServerKeyExchangeConsumer();
    static final HandshakeProducer ecdheHandshakeProducer = new ECDHServerKeyExchangeProducer();

    ECDHServerKeyExchange() {
    }

    private static final class ECDHServerKeyExchangeConsumer
    implements SSLConsumer {
        private ECDHServerKeyExchangeConsumer() {
        }

        @Override
        public void consume(ConnectionContext connectionContext, ByteBuffer byteBuffer) throws IOException {
            ClientHandshakeContext clientHandshakeContext = (ClientHandshakeContext)connectionContext;
            ECDHServerKeyExchangeMessage eCDHServerKeyExchangeMessage = new ECDHServerKeyExchangeMessage(clientHandshakeContext, byteBuffer);
            if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                SSLLogger.fine("Consuming ECDH ServerKeyExchange handshake message", eCDHServerKeyExchangeMessage);
            }
            if (clientHandshakeContext.algorithmConstraints != null && !clientHandshakeContext.algorithmConstraints.permits(EnumSet.of(CryptoPrimitive.KEY_AGREEMENT), eCDHServerKeyExchangeMessage.publicKey)) {
                throw clientHandshakeContext.conContext.fatal(Alert.INSUFFICIENT_SECURITY, "ECDH ServerKeyExchange does not comply to algorithm constraints");
            }
            clientHandshakeContext.handshakeCredentials.add(new ECDHKeyExchange.ECDHECredentials(eCDHServerKeyExchangeMessage.publicKey, eCDHServerKeyExchangeMessage.namedGroup));
        }
    }

    private static final class ECDHServerKeyExchangeProducer
    implements HandshakeProducer {
        private ECDHServerKeyExchangeProducer() {
        }

        @Override
        public byte[] produce(ConnectionContext connectionContext, SSLHandshake.HandshakeMessage handshakeMessage) throws IOException {
            ServerHandshakeContext serverHandshakeContext = (ServerHandshakeContext)connectionContext;
            ECDHServerKeyExchangeMessage eCDHServerKeyExchangeMessage = new ECDHServerKeyExchangeMessage(serverHandshakeContext);
            if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                SSLLogger.fine("Produced ECDH ServerKeyExchange handshake message", eCDHServerKeyExchangeMessage);
            }
            eCDHServerKeyExchangeMessage.write(serverHandshakeContext.handshakeOutput);
            serverHandshakeContext.handshakeOutput.flush();
            return null;
        }
    }

    private static final class ECDHServerKeyExchangeMessage
    extends SSLHandshake.HandshakeMessage {
        private static final byte CURVE_NAMED_CURVE = 3;
        private final SupportedGroupsExtension.NamedGroup namedGroup;
        private final byte[] publicPoint;
        private final byte[] paramsSignature;
        private final ECPublicKey publicKey;
        private final boolean useExplicitSigAlgorithm;
        private final SignatureScheme signatureScheme;

        ECDHServerKeyExchangeMessage(HandshakeContext handshakeContext) throws IOException {
            super(handshakeContext);
            Object object2;
            ServerHandshakeContext serverHandshakeContext = (ServerHandshakeContext)handshakeContext;
            ECDHKeyExchange.ECDHEPossession eCDHEPossession = null;
            X509Authentication.X509Possession x509Possession = null;
            for (Object object2 : serverHandshakeContext.handshakePossessions) {
                if (object2 instanceof ECDHKeyExchange.ECDHEPossession) {
                    eCDHEPossession = (ECDHKeyExchange.ECDHEPossession)object2;
                    if (x509Possession == null) continue;
                    break;
                }
                if (!(object2 instanceof X509Authentication.X509Possession)) continue;
                x509Possession = (X509Authentication.X509Possession)object2;
                if (eCDHEPossession == null) continue;
                break;
            }
            if (eCDHEPossession == null) {
                throw serverHandshakeContext.conContext.fatal(Alert.ILLEGAL_PARAMETER, "No ECDHE credentials negotiated for server key exchange");
            }
            this.publicKey = eCDHEPossession.publicKey;
            ECParameterSpec eCParameterSpec = this.publicKey.getParams();
            object2 = this.publicKey.getW();
            this.publicPoint = JsseJce.encodePoint((ECPoint)object2, eCParameterSpec.getCurve());
            this.namedGroup = SupportedGroupsExtension.NamedGroup.valueOf(eCParameterSpec);
            if (this.namedGroup == null || this.namedGroup.oid == null) {
                throw serverHandshakeContext.conContext.fatal(Alert.ILLEGAL_PARAMETER, "Unnamed EC parameter spec: " + eCParameterSpec);
            }
            if (x509Possession == null) {
                this.paramsSignature = null;
                this.signatureScheme = null;
                this.useExplicitSigAlgorithm = false;
            } else {
                Map.Entry<SignatureScheme, Signature> entry;
                this.useExplicitSigAlgorithm = serverHandshakeContext.negotiatedProtocol.useTLS12PlusSpec();
                Signature signature = null;
                if (this.useExplicitSigAlgorithm) {
                    entry = SignatureScheme.getSignerOfPreferableAlgorithm(serverHandshakeContext.peerRequestedSignatureSchemes, x509Possession, serverHandshakeContext.negotiatedProtocol);
                    if (entry == null) {
                        throw serverHandshakeContext.conContext.fatal(Alert.INTERNAL_ERROR, "No supported signature algorithm for " + x509Possession.popPrivateKey.getAlgorithm() + "  key");
                    }
                    this.signatureScheme = entry.getKey();
                    signature = entry.getValue();
                } else {
                    this.signatureScheme = null;
                    try {
                        signature = ECDHServerKeyExchangeMessage.getSignature(x509Possession.popPrivateKey.getAlgorithm(), x509Possession.popPrivateKey);
                    }
                    catch (InvalidKeyException | NoSuchAlgorithmException generalSecurityException) {
                        throw serverHandshakeContext.conContext.fatal(Alert.INTERNAL_ERROR, "Unsupported signature algorithm: " + x509Possession.popPrivateKey.getAlgorithm(), generalSecurityException);
                    }
                }
                entry = null;
                try {
                    ECDHServerKeyExchangeMessage.updateSignature(signature, serverHandshakeContext.clientHelloRandom.randomBytes, serverHandshakeContext.serverHelloRandom.randomBytes, this.namedGroup.id, this.publicPoint);
                    entry = (Map.Entry<SignatureScheme, Signature>)signature.sign();
                }
                catch (SignatureException signatureException) {
                    throw serverHandshakeContext.conContext.fatal(Alert.INTERNAL_ERROR, "Failed to sign ecdhe parameters: " + x509Possession.popPrivateKey.getAlgorithm(), signatureException);
                }
                this.paramsSignature = (byte[])entry;
            }
        }

        ECDHServerKeyExchangeMessage(HandshakeContext handshakeContext, ByteBuffer byteBuffer) throws IOException {
            super(handshakeContext);
            Signature signature;
            Object object;
            ClientHandshakeContext clientHandshakeContext = (ClientHandshakeContext)handshakeContext;
            byte by = (byte)Record.getInt8(byteBuffer);
            if (by != 3) {
                throw clientHandshakeContext.conContext.fatal(Alert.ILLEGAL_PARAMETER, "Unsupported ECCurveType: " + by);
            }
            int n = Record.getInt16(byteBuffer);
            this.namedGroup = SupportedGroupsExtension.NamedGroup.valueOf(n);
            if (this.namedGroup == null) {
                throw clientHandshakeContext.conContext.fatal(Alert.ILLEGAL_PARAMETER, "Unknown named group ID: " + n);
            }
            if (!SupportedGroupsExtension.SupportedGroups.isSupported(this.namedGroup)) {
                throw clientHandshakeContext.conContext.fatal(Alert.ILLEGAL_PARAMETER, "Unsupported named group: " + (Object)((Object)this.namedGroup));
            }
            if (this.namedGroup.oid == null) {
                throw clientHandshakeContext.conContext.fatal(Alert.ILLEGAL_PARAMETER, "Unknown named EC curve: " + (Object)((Object)this.namedGroup));
            }
            ECParameterSpec eCParameterSpec = JsseJce.getECParameterSpec(this.namedGroup.oid);
            if (eCParameterSpec == null) {
                throw clientHandshakeContext.conContext.fatal(Alert.ILLEGAL_PARAMETER, "No supported EC parameter: " + (Object)((Object)this.namedGroup));
            }
            this.publicPoint = Record.getBytes8(byteBuffer);
            if (this.publicPoint.length == 0) {
                throw clientHandshakeContext.conContext.fatal(Alert.ILLEGAL_PARAMETER, "Insufficient ECPoint data: " + (Object)((Object)this.namedGroup));
            }
            ECPublicKey eCPublicKey = null;
            try {
                object = JsseJce.decodePoint(this.publicPoint, eCParameterSpec.getCurve());
                KeyFactory keyFactory = JsseJce.getKeyFactory("EC");
                eCPublicKey = (ECPublicKey)keyFactory.generatePublic(new ECPublicKeySpec((ECPoint)object, eCParameterSpec));
            }
            catch (IOException | NoSuchAlgorithmException | InvalidKeySpecException exception) {
                throw clientHandshakeContext.conContext.fatal(Alert.ILLEGAL_PARAMETER, "Invalid ECPoint: " + (Object)((Object)this.namedGroup), exception);
            }
            this.publicKey = eCPublicKey;
            object = null;
            for (SSLCredentials sSLCredentials : clientHandshakeContext.handshakeCredentials) {
                if (!(sSLCredentials instanceof X509Authentication.X509Credentials)) continue;
                object = (X509Authentication.X509Credentials)sSLCredentials;
                break;
            }
            if (object == null) {
                if (byteBuffer.hasRemaining()) {
                    throw clientHandshakeContext.conContext.fatal(Alert.HANDSHAKE_FAILURE, "Invalid DH ServerKeyExchange: unknown extra data");
                }
                this.signatureScheme = null;
                this.paramsSignature = null;
                this.useExplicitSigAlgorithm = false;
                return;
            }
            this.useExplicitSigAlgorithm = clientHandshakeContext.negotiatedProtocol.useTLS12PlusSpec();
            if (this.useExplicitSigAlgorithm) {
                int n2 = Record.getInt16(byteBuffer);
                this.signatureScheme = SignatureScheme.valueOf(n2);
                if (this.signatureScheme == null) {
                    throw clientHandshakeContext.conContext.fatal(Alert.HANDSHAKE_FAILURE, "Invalid signature algorithm (" + n2 + ") used in ECDH ServerKeyExchange handshake message");
                }
                if (!clientHandshakeContext.localSupportedSignAlgs.contains((Object)this.signatureScheme)) {
                    throw clientHandshakeContext.conContext.fatal(Alert.HANDSHAKE_FAILURE, "Unsupported signature algorithm (" + this.signatureScheme.name + ") used in ECDH ServerKeyExchange handshake message");
                }
            } else {
                this.signatureScheme = null;
            }
            this.paramsSignature = Record.getBytes16(byteBuffer);
            if (this.useExplicitSigAlgorithm) {
                try {
                    signature = this.signatureScheme.getVerifier(((X509Authentication.X509Credentials)object).popPublicKey);
                }
                catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException generalSecurityException) {
                    throw clientHandshakeContext.conContext.fatal(Alert.INTERNAL_ERROR, "Unsupported signature algorithm: " + this.signatureScheme.name, generalSecurityException);
                }
            }
            try {
                signature = ECDHServerKeyExchangeMessage.getSignature(((X509Authentication.X509Credentials)object).popPublicKey.getAlgorithm(), ((X509Authentication.X509Credentials)object).popPublicKey);
            }
            catch (InvalidKeyException | NoSuchAlgorithmException generalSecurityException) {
                throw clientHandshakeContext.conContext.fatal(Alert.INTERNAL_ERROR, "Unsupported signature algorithm: " + ((X509Authentication.X509Credentials)object).popPublicKey.getAlgorithm(), generalSecurityException);
            }
            try {
                ECDHServerKeyExchangeMessage.updateSignature(signature, clientHandshakeContext.clientHelloRandom.randomBytes, clientHandshakeContext.serverHelloRandom.randomBytes, this.namedGroup.id, this.publicPoint);
                if (!signature.verify(this.paramsSignature)) {
                    throw clientHandshakeContext.conContext.fatal(Alert.HANDSHAKE_FAILURE, "Invalid ECDH ServerKeyExchange signature");
                }
            }
            catch (SignatureException signatureException) {
                throw clientHandshakeContext.conContext.fatal(Alert.HANDSHAKE_FAILURE, "Cannot verify ECDH ServerKeyExchange signature", signatureException);
            }
        }

        @Override
        public SSLHandshake handshakeType() {
            return SSLHandshake.SERVER_KEY_EXCHANGE;
        }

        @Override
        public int messageLength() {
            int n = 0;
            if (this.paramsSignature != null) {
                n = 2 + this.paramsSignature.length;
                if (this.useExplicitSigAlgorithm) {
                    n += SignatureScheme.sizeInRecord();
                }
            }
            return 4 + this.publicPoint.length + n;
        }

        @Override
        public void send(HandshakeOutStream handshakeOutStream) throws IOException {
            handshakeOutStream.putInt8(3);
            handshakeOutStream.putInt16(this.namedGroup.id);
            handshakeOutStream.putBytes8(this.publicPoint);
            if (this.paramsSignature != null) {
                if (this.useExplicitSigAlgorithm) {
                    handshakeOutStream.putInt16(this.signatureScheme.id);
                }
                handshakeOutStream.putBytes16(this.paramsSignature);
            }
        }

        public String toString() {
            if (this.useExplicitSigAlgorithm) {
                MessageFormat messageFormat = new MessageFormat("\"ECDH ServerKeyExchange\": '{'\n  \"parameters\": '{'\n    \"named group\": \"{0}\"\n    \"ecdh public\": '{'\n{1}\n    '}',\n  '}',\n  \"digital signature\":  '{'\n    \"signature algorithm\": \"{2}\"\n    \"signature\": '{'\n{3}\n    '}',\n  '}'\n'}'", Locale.ENGLISH);
                HexDumpEncoder hexDumpEncoder = new HexDumpEncoder();
                Object[] objectArray = new Object[]{this.namedGroup.name, Utilities.indent(hexDumpEncoder.encodeBuffer(this.publicPoint), "      "), this.signatureScheme.name, Utilities.indent(hexDumpEncoder.encodeBuffer(this.paramsSignature), "      ")};
                return messageFormat.format(objectArray);
            }
            if (this.paramsSignature != null) {
                MessageFormat messageFormat = new MessageFormat("\"ECDH ServerKeyExchange\": '{'\n  \"parameters\":  '{'\n    \"named group\": \"{0}\"\n    \"ecdh public\": '{'\n{1}\n    '}',\n  '}',\n  \"signature\": '{'\n{2}\n  '}'\n'}'", Locale.ENGLISH);
                HexDumpEncoder hexDumpEncoder = new HexDumpEncoder();
                Object[] objectArray = new Object[]{this.namedGroup.name, Utilities.indent(hexDumpEncoder.encodeBuffer(this.publicPoint), "      "), Utilities.indent(hexDumpEncoder.encodeBuffer(this.paramsSignature), "    ")};
                return messageFormat.format(objectArray);
            }
            MessageFormat messageFormat = new MessageFormat("\"ECDH ServerKeyExchange\": '{'\n  \"parameters\":  '{'\n    \"named group\": \"{0}\"\n    \"ecdh public\": '{'\n{1}\n    '}',\n  '}'\n'}'", Locale.ENGLISH);
            HexDumpEncoder hexDumpEncoder = new HexDumpEncoder();
            Object[] objectArray = new Object[]{this.namedGroup.name, Utilities.indent(hexDumpEncoder.encodeBuffer(this.publicPoint), "      ")};
            return messageFormat.format(objectArray);
        }

        private static Signature getSignature(String string, Key key) throws NoSuchAlgorithmException, InvalidKeyException {
            Signature signature = null;
            switch (string) {
                case "EC": {
                    signature = JsseJce.getSignature("SHA1withECDSA");
                    break;
                }
                case "RSA": {
                    signature = RSASignature.getInstance();
                    break;
                }
                default: {
                    throw new NoSuchAlgorithmException("neither an RSA or a EC key : " + string);
                }
            }
            if (signature != null) {
                if (key instanceof PublicKey) {
                    signature.initVerify((PublicKey)key);
                } else {
                    signature.initSign((PrivateKey)key);
                }
            }
            return signature;
        }

        private static void updateSignature(Signature signature, byte[] byArray, byte[] byArray2, int n, byte[] byArray3) throws SignatureException {
            signature.update(byArray);
            signature.update(byArray2);
            signature.update((byte)3);
            signature.update((byte)(n >> 8 & 0xFF));
            signature.update((byte)(n & 0xFF));
            signature.update((byte)byArray3.length);
            signature.update(byArray3);
        }
    }
}

