/* global things
   Copyright (C) 1998, 1999, 2000, 2001, 2002, 2003
   Wouter van Ooijen

This file is part of jal.

jal is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

jal is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with jal; see the file COPYING.  If not, write to
the Free Software Foundation, 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.  */

#include "stdhdr.h"
#include "global.h"

/* return max or min of two expressions */
#ifndef max
#define max( x, y ) ( ( ( x ) > ( y ) ) ? ( x ) : ( y ) )
#define min( x, y ) ( ( ( x ) > ( y ) ) ? ( y ) : ( x ) )
#endif

/* return absolute value */
#ifndef abs
#ifndef _MSC_VER
int abs(int x)
{
    if (x > 0)
        return x;
    else
        return -x;
}
#endif
#endif

/* bit test */
#define has( x, y ) ( ( (x) & (y) ) != 0 )

/* swap two pointers */
#define swapp( p, q ){ void *t = p; p = q; q = t; }

/* an allocated empty string */
char *empty_string = NULL;


/********** forwards **********/

#define allocate( x ) _allocate( x, __LINE__ )
void *_allocate(int size, int line);
void free_all(void);

boolean file_exists(char *s);


/********** settings, pragma's etc. **********/

/* verbosity */
boolean verbose_scanner = false;
boolean verbose_parser = false;
boolean verbose_optimizer = false;
boolean verbose_squasher = false;
boolean verbose_ralloc = false;
boolean verbose_coder = false;
boolean verbose_assembler = false;
boolean verbose_simulator = false;
boolean verbose_passes = false;
boolean verbose_malloc = false;
boolean verbose_progress = true;
boolean verbose_stack = false;

#if _DEBUG
/* checks */
boolean check_blocks = true;
boolean check_pool = false;
boolean check_asserts = true;
boolean check_stack = true;
boolean check_memory_zero = true;
#else
boolean check_blocks = false;
boolean check_pool = false;
boolean check_asserts = true;
boolean check_stack = true;
boolean check_memory_zero = false;
#endif


/* optimizations */
boolean optimize_constant_folding = true;
boolean optimize_strength_reduction = true;
boolean optimize_tree_shape = true;
boolean optimize_tail_calls = true;
boolean optimize_trivial_expressions = true;
boolean optimize_dead_code = true;
boolean optimize_bank_instructions = true;
boolean optimize_pass_in_w = true;

/* results */
boolean result_hex = true;
boolean result_asm = true;
boolean result_src = false;
boolean result_hex_code = false;
boolean result_gpsim_info = false;
FILE *src_file = NULL;

/* simulator */
boolean enable_simulator = false;

/* error catching */
int catch_line = 0;
int catch_pos = 0;
string main_source_file;
string current_source_file;

