/* jal top level file
   Copyright (C) 1998, 1999, 2000, 2001, 2002, 2003
   Wouter van Ooijen

This file is part of jal.

jal is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

jal is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with jal; see the file COPYING.  If not, write to
the Free Software Foundation, 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.  */

/* #define __DEBUG__  */   /* conditional compilation R. Hamerling */

/* JALComp.h   -  by Rob Hamerling         */
/* Compiler name and version determination */
#include "jalcomp.h"


/********** external stuff **********/
#include "stdhdr.h"


#define _djgpp_debug
#ifdef djgpp_debug
#include <crt0.h>
int _crt0_startup_flags = _CRT0_FLAG_FILL_SBRK_MEMORY;
#endif

/********** global things **********/
#include "global.h"


/* target */
#include "target.h"



/* the command line, echoed in the assembler output */
char command_line[2048] = "";


/********** statistics **********/

int scanner_total_lines = 0;
int scanner_total_files = 0;
int scanner_total_chars = 0;
int simulated_instructions = 0;
int total_code_size = 0;
int main_stack_usage;
int indirect_stack_usage;
int int_stack_usage;
int total_stack_usage;
float start_time;
float compilation_seconds;


/********** the reserved words **********/
#include "reswords.h"

/********** stack size guarding **********/
#include "stacksg.h"

/* DJGPP stack size, default is only 256k */
unsigned _stklen = stack_size;


/********** char and string functions **********/
#include "cstringf.h"

/********** show progress **********/
#include "showprog.h"

/********** lexical scanner **********/
#include "errorlh.h"

/********** lexical scanner **********/
#include "scanner.h"

/********** tree representation **********/
#include "treerep.h"

/********** tree tools **********/
#include "treetools.h"

/********** evaluate **********/
#include "eval.h"

/********** recursive-decent parser **********/
#include "parser.h"

/********** optimizer **********/
#include "optimizer.h"

/********** squasher **********/
#include "squasher.h"

/* register allocation  */
#include "regalloc.h"

/********** variables listing **********/
#include "varlist.h"

/********** code generator **********/
#include "codegen.h"

/********** assembler **********/
#include "assemble.h"

/********** simulator **********/
#include "simulator.h"

/********** compilation driver **********/
#include "compdriver.h"

/********** main **********/


/***** search path for the compiler *****/
static char jal_lib_path[256];

#define w(x){ printf( x ); printf( "\n" ); }
void give_help(void)
{
    w(" ");
    w("The jal command line can contains source files and options. An option");
    w("starts with a '-', everything else is a source file. Options are:");
    w("-t or -tN : test");
    w("-386      : run on 386-class machines (equivalent to -vz -cX)");
    w("-c$     : checks (default -cxp), $ can be a sequence of:");
    w("   a : internal Assertions            b : memory Blocks (CPU intensive)");
    w("   s : Stack use                      z : Zero all memory before use)");
    w("   p : memory Pool (awfully CPU intensive)");
    w("-o$ : optimizations (default -ox), $ can be a sequence of:");
    w("    r : strength Reduction");
    w("   b : bank opcode elimination        c : tail Call chaining");
    w("   d : Dead code removal              t : Trivial expression folding");
    w("   w : use W for parameter passing    s : tree Shape (expression shuffle)");
    w("-sXXX : add XXX to the include file search list");
    w("-v$ : verbosity (default -vXz), $ can be a sequence of:");
    w("   s : Scanner                        p : Parser");
    w("   o : Optimizer                      q : sQuasher");
    w("   r : Register allocation            c : Code generator");
    w("   a : Assembler                      t : Test (simulator)");
    w("   z : progress of the various passes");
    w("-r$ : compilation result (default -raChS), $ can be sequence of:");
    w("   a : .asm (assembly) file           c : hex Codes in the asm file");
    w("   h : .hex (hex image) file          s : .src (total source) file");

	w(" ");
    w("The default library path is : " )
	    printf("%s", jal_lib_path);
    w(" ");

	w(" ");
    w("Report bugs to:");
    w(BUG_REPORT_URL);
    w(" ");
}

#define set_if( c1, c2, x ) \
   case c1 : { x = true;  break; } \
   case c2 : { x = false; break; }

void checks_option(char *arg)
{
    boolean x_on = false;
    stack_guard;
    if (*arg == '\0')
        return;
    switch (*arg) {
        set_if('b', 'B', check_blocks)
            set_if('p', 'P', check_pool)
            set_if('a', 'A', check_asserts)
            set_if('s', 'S', check_stack)
            set_if('z', 'Z', check_memory_zero)
    case 'x':
        x_on = true;
        /* fallthrough! */
    case 'X':{
            check_blocks = x_on;
            check_pool = x_on;
            check_asserts = x_on;
            check_stack = x_on;
            check_memory_zero = x_on;
            break;
        }
    default:{
            fatal(NULL, (m, "check %c not understood", *arg));
        }
    }
    checks_option(arg + 1);
}

void optimization_option(char *arg)
{
    boolean x_on = false;
    stack_guard;
    if (*arg == '\0')
        return;
    switch (*arg) {
/*      set_if( 'f', 'F', optimize_constant_folding ) */
        set_if('r', 'R', optimize_strength_reduction)
            set_if('s', 'S', optimize_tree_shape)
            set_if('c', 'C', optimize_tail_calls)
            set_if('t', 'T', optimize_trivial_expressions)
            set_if('d', 'D', optimize_dead_code)
            set_if('b', 'B', optimize_bank_instructions)
            set_if('w', 'W', optimize_pass_in_w)
    case 'x':
        x_on = true;
        /* fallthrough! */
    case 'X':{
/*        optimize_constant_folding     = x_on; */
            optimize_strength_reduction = x_on;
            optimize_tree_shape = x_on;
            optimize_tail_calls = x_on;
            optimize_trivial_expressions = x_on;
            optimize_dead_code = x_on;
            optimize_bank_instructions = x_on;
            optimize_pass_in_w = x_on;
            break;
        }
    default:{
            fatal(NULL, (m, "optimization %c not understood", *arg));
        }
    }
    optimization_option(arg + 1);
}

void test_option(char *arg)
{
    stack_guard;

    enable_simulator = true;
    if (*arg != '\0') {
        int n = sscanf(arg, "%d", &simulation_max_steps);
        if (n != 1) {
            fatal(NULL, (m, "number of steps not understood %s", arg));
        }
    }
}

void verbosity_option(char *arg)
{
    boolean x_on = false;
    stack_guard;
    if (*arg == '\0')
        return;
    verbose_progress = false;
    switch (*arg) {
        set_if('s', 'S', verbose_scanner)
            set_if('p', 'P', verbose_parser)
            set_if('o', 'O', verbose_optimizer)
            set_if('q', 'Q', verbose_squasher)
            set_if('r', 'R', verbose_ralloc)
            set_if('c', 'C', verbose_coder)
            set_if('a', 'A', verbose_assembler)
            set_if('t', 'T', verbose_simulator)
            set_if('i', 'I', verbose_passes)
            set_if('m', 'M', verbose_malloc)
            set_if('z', 'Z', verbose_progress)
            set_if('0', '1', verbose_stack)
    case 'x':
        x_on = true;
        /* fallthrough! */
    case 'X':{
            verbose_scanner = x_on;
            verbose_parser = x_on;
            verbose_optimizer = x_on;
            verbose_squasher = x_on;
            verbose_ralloc = x_on;
            verbose_coder = x_on;
            verbose_assembler = x_on;
            verbose_simulator = x_on;
            break;
        }
    default:{
            fatal(NULL, (m, "pass %c not understood", *arg));
        }
    }
    verbosity_option(arg + 1);
}

void result_option(char *arg)
{
    boolean x_on = false;
    stack_guard;
    if (*arg == '\0')
        return;
    switch (*arg) {
        set_if('h', 'H', result_hex)
            set_if('a', 'A', result_asm)
            set_if('s', 'S', result_src)
            set_if('c', 'C', result_hex_code)
            set_if('g', 'G', result_gpsim_info)
    case 'x':
        x_on = true;
        /* fallthrough! */
    case 'X':{
            result_hex = x_on;
            result_asm = x_on;
            result_src = x_on;
            result_hex_code = x_on;
            break;
        }
    default:{
            fatal(NULL, (m, "result %c not understood", *arg));
        }
    }
    result_option(arg + 1);
}

void search_option(char *arg)
{
    stack_guard;
    add_to_searchlist(arg);
}

/* handle one option */
void one_option(char *arg)
{
    stack_guard;

    /* settings for a slow computer */
    if (string_match(arg, "386")) {
        one_option("vz");
        one_option("cX");
        return;
    }

    switch (*arg) {

        /* enabled checks */
    case 'c':{
            checks_option(&arg[1]);
            break;
        }

        /* optimization level */
    case 'o':{
            optimization_option(&arg[1]);
            break;
        }

        /* test */
    case 't':{
            test_option(&arg[1]);
            break;
        }

        /* verbosity */
    case 'v':{
            verbosity_option(&arg[1]);
            break;
        }

        /* result */
    case 'r':{
            result_option(&arg[1]);
            break;
        }

        /* search */
    case 's':{
            search_option(&arg[1]);
            break;
        }

    default:{
            fatal(NULL, (m, "option %s not understood", arg));
        }
    }
}

/* handle all arguments once */
void all_arguments(int argc, char **argv, boolean do_compile)
{
    int i;
    stack_guard;
    for (i = 1; i < argc; i++) {
        sprintf(&(command_line[string_length(command_line)]), "%s ", argv[i]
            );
        if (argv[i][0] == '-') {
            one_option(&argv[i][1]);
        } else {
            compile_one_file(argv[i], do_compile);
        }
    }
}


/* real main */
void main2(int argc, char **argv)
{
    stack_guard;
#ifdef BUILD_NATIVE_WINDOWS 
/* make it easy to install JAL on windows systems.
   default lib search path is path relive to JAL.exe 
   jal.exe
   lib\*.jal
*/
    GetModuleFileName(NULL, jal_lib_path, sizeof(jal_lib_path));

    chop_path_tail(jal_lib_path);
    sprintf(jal_lib_path,"%s\\lib",jal_lib_path);

    add_to_searchlist(jal_lib_path);
#else

#ifdef USE_DEFAULT_PATHS
    add_to_searchlist(JAL_LIB_PATH);
    strncpy(jal_lib_path,JAL_LIB_PATH, sizeof(jal_lib_path));
#endif

#endif
    /* parse the arguments */
    all_arguments(argc, argv, false);

    /* do we have any source arguments? */
    if (source_files == 0) {
        give_help();
        free_all();
        exit(-1);
    }

    /* do everything but simulation */
    prepare_compilation();
    command_line[0] = '\0';
    all_arguments(argc, argv, true);
    finish_compilation();

    /* should an error have been caught? */
    if (catch_line != 0) {
        printf(">  error expected at %d:%d\n", catch_line, catch_pos);
        free_all();
        exit(-1);
    }

    /* run a simulated test? */
    if (enable_simulator) {
        main_phase(&root_block, "simulate", simulate, false);
    }
}

/* just for stack_guard_init() */
int main(int argc, char **argv)
{
    stack_guard_init();
    empty_string = new_string("");

    printf("jal %s (%s %d.%d)\n", VERSION, compiler, compiler_version, compiler_minor);
    main2(argc, argv);
    printf("OK\n");
    free_all();
    return 0;
}
