# VTest 

# The HTTP test-program formerly known as Varnishtest

This project is the (almost) unvarnished varnishtest program, made
available as a stand-alone program because it can be used to test
all sorts of HTTP clients, servers and proxies.

If you want to join the fun, email me.

Poul-Henning

# BACKGROUND CORRESPONDENCE

`Date:    Wed, 09 Jan 2019 10:36:14 +0000`

`From:    Poul-Henning Kamp <phk@phk.freebsd.dk>`

`Subject: Re: vtest status`

Personally I am not very keen on turning vtest into a "real" project
with releases, package-building and all that, because it would cause
me a lot of work which I don't think brings enough advantages.

The problem for me is that vtc_varnish has a very incestuos
relationship with varnish internals, internals which we do not want
to turn into documented or even open APIs, and that means that
vtc_varnish and varnishd must match versions.

A stand-alone vtest-package would either need to be compiled against
a specific version of varnish, or have some way to dynamically load
vtc_varnish from from the varnish source/package it is being used
against.

But that just moves the problem to the other side of the line, where
we need to open the internals of vtest up as a documented and
versioned API...

Some day (H3?) all that work may make sense, but I don't feel we
are there yet, at least not as far as cost/benefit is concerned.

My suggestion for now, is to let vtest live as a "source code
library" on github and not build and distribute it as stand-alone
packages.

Instead it will be up to the projects which use it to import
and build in their own projects.

That way HAproxy and leave vtc_varnish out of their compilation so
varnish does not become a build-dependency (or you can conditionally
compile vtc_varnish in, if it is already there.)

And we can compile it in Varnish including vtc_varnish, and include
vtc_haproxy in similar fashion. (actually, compilation of 
vtc_haproxy does not need haproxy to be installed, does it ?)

We should still provide a Makefile in the vtest github project which
compiles as much as possible (ie: vtc_varnish if it can find varnish
installed), that will make work on the shared sources easier for
all of us.

If we decide to do things that way, maybe you should call your
compiled version something like "hatest", while we stick with
"varnishtest", so we can reserve the "vtest" name for the future
runtime-extensible all-singing-and-dancing thing ?

# HISTORY

The initial source tree is generated by running the `convert.sh`
script over a Varnish-Cache trunk tree rev 7161dcf9d9f5380ffd.

# TODO:

* Detect content of config.h as required

# NOT-TODO:

* Autocrappery

*EOF*
