/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.helpers;

import org.apache.log4j.spi.LoggingEvent;

public class BoundedFIFO {
    LoggingEvent[] buf;
    int numElements = 0;
    int first = 0;
    int next = 0;
    int maxSize;

    public LoggingEvent get() {
        if (this.numElements == 0) {
            return null;
        }
        LoggingEvent loggingEvent = this.buf[this.first];
        if (++this.first == this.maxSize) {
            this.first = 0;
        }
        --this.numElements;
        return loggingEvent;
    }

    public void put(LoggingEvent loggingEvent) {
        if (this.numElements != this.maxSize) {
            this.buf[this.next] = loggingEvent;
            if (++this.next == this.maxSize) {
                this.next = 0;
            }
            ++this.numElements;
        }
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public boolean isFull() {
        return this.numElements == this.maxSize;
    }

    public int length() {
        return this.numElements;
    }

    public boolean wasEmpty() {
        return this.numElements == 1;
    }

    public boolean wasFull() {
        return this.numElements + 1 == this.maxSize;
    }

    public BoundedFIFO(int n) {
        if (n < 1) {
            throw new IllegalArgumentException("The maxSize argument (" + n + ") is not a positive integer.");
        }
        this.maxSize = n;
        this.buf = new LoggingEvent[n];
    }
}

