/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.nt;

import java.io.PrintWriter;
import java.io.StringWriter;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.Layout;
import org.apache.log4j.Priority;
import org.apache.log4j.TTCCLayout;
import org.apache.log4j.spi.LoggingEvent;

public class NTEventLogAppender
extends AppenderSkeleton {
    private static final int FATAL = Priority.FATAL.toInt();
    private static final int ERROR = Priority.ERROR.toInt();
    private static final int WARN = Priority.WARN.toInt();
    private static final int INFO = Priority.INFO.toInt();
    private static final int DEBUG = Priority.DEBUG.toInt();
    private int _handle = 0;

    public void close() {
    }

    public void append(LoggingEvent loggingEvent) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        printWriter.print(this.layout.format(loggingEvent));
        if (loggingEvent.throwable != null) {
            loggingEvent.throwable.printStackTrace(printWriter);
        }
        printWriter.close();
        int n = loggingEvent.priority.toInt();
        if (n < FATAL || n > DEBUG) {
            n = INFO;
        }
        this.reportEvent(this._handle, stringWriter.toString(), n);
    }

    public void finalize() {
        this.deregisterEventSource(this._handle);
        this._handle = 0;
    }

    public boolean requiresLayout() {
        return true;
    }

    private native int registerEventSource(String var1, String var2);

    private native void reportEvent(int var1, String var2, int var3);

    private native void deregisterEventSource(int var1);

    static /* synthetic */ Layout access$0(NTEventLogAppender nTEventLogAppender) {
        return nTEventLogAppender.layout;
    }

    public NTEventLogAppender() {
        this(null, null, null);
    }

    public NTEventLogAppender(String string) {
        this(null, string, null);
    }

    public NTEventLogAppender(String string, String string2) {
        this(string, string2, null);
    }

    public NTEventLogAppender(Layout layout) {
        this(null, null, layout);
    }

    public NTEventLogAppender(String string, Layout layout) {
        this(null, string, layout);
    }

    public NTEventLogAppender(String string, String string2, Layout layout) {
        if (string2 == null) {
            string2 = "Log4j";
        }
        if (layout == null) {
            this.layout = new TTCCLayout();
        } else {
            this.layout = layout;
        }
        try {
            this._handle = this.registerEventSource(string, string2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this._handle = 0;
        }
    }

    static {
        System.loadLibrary("NTEventLogAppender");
    }
}

