/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.varia;

import org.apache.log4j.Priority;
import org.apache.log4j.helpers.OptionConverter;
import org.apache.log4j.spi.Filter;
import org.apache.log4j.spi.LoggingEvent;

public class PriorityMatchFilter
extends Filter {
    public static final String PRIORITY_TO_MATCH_OPTION = "PriorityToMatch";
    public static final String ACCEPT_ON_MATCH_OPTION = "AcceptOnMatch";
    boolean acceptOnMatch = true;
    Priority priorityToMatch;

    public int decide(LoggingEvent loggingEvent) {
        if (this.priorityToMatch == null) {
            return 0;
        }
        boolean bl = false;
        if (this.priorityToMatch == loggingEvent.priority) {
            bl = true;
        }
        if (this.acceptOnMatch ^ bl) {
            return -1;
        }
        return 1;
    }

    public String[] getOptionStrings() {
        return new String[]{PRIORITY_TO_MATCH_OPTION, ACCEPT_ON_MATCH_OPTION};
    }

    public void setOption(String string, String string2) {
        if (string.equalsIgnoreCase(PRIORITY_TO_MATCH_OPTION)) {
            this.priorityToMatch = Priority.toPriority(string2, null);
        } else if (string.equalsIgnoreCase(ACCEPT_ON_MATCH_OPTION)) {
            this.acceptOnMatch = OptionConverter.toBoolean(string2, this.acceptOnMatch);
        }
    }
}

