// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/ads/admob/v1/admob_api.proto

package admob

import (
	context "context"
	fmt "fmt"
	math "math"

	proto "github.com/golang/protobuf/proto"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// Request to retrieve the specified publisher account.
type GetPublisherAccountRequest struct {
	// Resource name of the publisher account to retrieve.
	// Example: accounts/pub-9876543210987654
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetPublisherAccountRequest) Reset()         { *m = GetPublisherAccountRequest{} }
func (m *GetPublisherAccountRequest) String() string { return proto.CompactTextString(m) }
func (*GetPublisherAccountRequest) ProtoMessage()    {}
func (*GetPublisherAccountRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_91b8b4130579e29e, []int{0}
}

func (m *GetPublisherAccountRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetPublisherAccountRequest.Unmarshal(m, b)
}
func (m *GetPublisherAccountRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetPublisherAccountRequest.Marshal(b, m, deterministic)
}
func (m *GetPublisherAccountRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetPublisherAccountRequest.Merge(m, src)
}
func (m *GetPublisherAccountRequest) XXX_Size() int {
	return xxx_messageInfo_GetPublisherAccountRequest.Size(m)
}
func (m *GetPublisherAccountRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetPublisherAccountRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetPublisherAccountRequest proto.InternalMessageInfo

func (m *GetPublisherAccountRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Request to retrieve the AdMob publisher account accessible with the client
// credential. Currently all credentials have access to at most 1 account.
type ListPublisherAccountsRequest struct {
	// Maximum number of accounts to return.
	PageSize int32 `protobuf:"varint,1,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// The value returned by the last `ListPublisherAccountsResponse`; indicates
	// that this is a continuation of a prior `ListPublisherAccounts` call, and
	// that the system should return the next page of data.
	PageToken            string   `protobuf:"bytes,2,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListPublisherAccountsRequest) Reset()         { *m = ListPublisherAccountsRequest{} }
func (m *ListPublisherAccountsRequest) String() string { return proto.CompactTextString(m) }
func (*ListPublisherAccountsRequest) ProtoMessage()    {}
func (*ListPublisherAccountsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_91b8b4130579e29e, []int{1}
}

func (m *ListPublisherAccountsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListPublisherAccountsRequest.Unmarshal(m, b)
}
func (m *ListPublisherAccountsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListPublisherAccountsRequest.Marshal(b, m, deterministic)
}
func (m *ListPublisherAccountsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListPublisherAccountsRequest.Merge(m, src)
}
func (m *ListPublisherAccountsRequest) XXX_Size() int {
	return xxx_messageInfo_ListPublisherAccountsRequest.Size(m)
}
func (m *ListPublisherAccountsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListPublisherAccountsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListPublisherAccountsRequest proto.InternalMessageInfo

func (m *ListPublisherAccountsRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListPublisherAccountsRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

// Response for the publisher account list request.
type ListPublisherAccountsResponse struct {
	// Publisher that the client credentials can access.
	Account []*PublisherAccount `protobuf:"bytes,1,rep,name=account,proto3" json:"account,omitempty"`
	// If not empty, indicates that there might be more accounts for the request;
	// you must pass this value in a new `ListPublisherAccountsRequest`.
	NextPageToken        string   `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListPublisherAccountsResponse) Reset()         { *m = ListPublisherAccountsResponse{} }
func (m *ListPublisherAccountsResponse) String() string { return proto.CompactTextString(m) }
func (*ListPublisherAccountsResponse) ProtoMessage()    {}
func (*ListPublisherAccountsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_91b8b4130579e29e, []int{2}
}

func (m *ListPublisherAccountsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListPublisherAccountsResponse.Unmarshal(m, b)
}
func (m *ListPublisherAccountsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListPublisherAccountsResponse.Marshal(b, m, deterministic)
}
func (m *ListPublisherAccountsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListPublisherAccountsResponse.Merge(m, src)
}
func (m *ListPublisherAccountsResponse) XXX_Size() int {
	return xxx_messageInfo_ListPublisherAccountsResponse.Size(m)
}
func (m *ListPublisherAccountsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListPublisherAccountsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListPublisherAccountsResponse proto.InternalMessageInfo

func (m *ListPublisherAccountsResponse) GetAccount() []*PublisherAccount {
	if m != nil {
		return m.Account
	}
	return nil
}

func (m *ListPublisherAccountsResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

// Request to generate an AdMob Mediation report.
type GenerateMediationReportRequest struct {
	// Resource name of the account to generate the report for.
	// Example: accounts/pub-9876543210987654
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Network report specification.
	ReportSpec           *MediationReportSpec `protobuf:"bytes,2,opt,name=report_spec,json=reportSpec,proto3" json:"report_spec,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *GenerateMediationReportRequest) Reset()         { *m = GenerateMediationReportRequest{} }
func (m *GenerateMediationReportRequest) String() string { return proto.CompactTextString(m) }
func (*GenerateMediationReportRequest) ProtoMessage()    {}
func (*GenerateMediationReportRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_91b8b4130579e29e, []int{3}
}

func (m *GenerateMediationReportRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GenerateMediationReportRequest.Unmarshal(m, b)
}
func (m *GenerateMediationReportRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GenerateMediationReportRequest.Marshal(b, m, deterministic)
}
func (m *GenerateMediationReportRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GenerateMediationReportRequest.Merge(m, src)
}
func (m *GenerateMediationReportRequest) XXX_Size() int {
	return xxx_messageInfo_GenerateMediationReportRequest.Size(m)
}
func (m *GenerateMediationReportRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GenerateMediationReportRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GenerateMediationReportRequest proto.InternalMessageInfo

func (m *GenerateMediationReportRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *GenerateMediationReportRequest) GetReportSpec() *MediationReportSpec {
	if m != nil {
		return m.ReportSpec
	}
	return nil
}

// The streaming response for the AdMob Mediation report where the first
// response contains the report header, then a stream of row responses, and
// finally a footer as the last response message.
//
// For example:
//
//     [{
//       "header": {
//         "date_range": {
//           "start_date": {"year": 2018, "month": 9, "day": 1},
//           "end_date": {"year": 2018, "month": 9, "day": 30}
//         }
//         "localization_settings": {
//           "currency_code": "USD",
//           "language_code": "en-US"
//         }
//       }
//     },
//     {
//       "row": {
//         "dimension_values": {
//           "DATE": {"value": "20180918"},
//           "APP": {
//             "value": "ca-app-pub-8123415297019784~1001342552",
//              "display_label": "My app name!"
//           }
//         },
//         "metric_values": {
//           "ESTIMATED_EARNINGS": {"decimal_value": "1324746"}
//         }
//       }
//     },
//     {
//       "footer": {"matching_row_count": 1}
//     }]
type GenerateMediationReportResponse struct {
	// Each stream response message contains one type of payload.
	//
	// Types that are valid to be assigned to Payload:
	//	*GenerateMediationReportResponse_Header
	//	*GenerateMediationReportResponse_Row
	//	*GenerateMediationReportResponse_Footer
	Payload              isGenerateMediationReportResponse_Payload `protobuf_oneof:"payload"`
	XXX_NoUnkeyedLiteral struct{}                                  `json:"-"`
	XXX_unrecognized     []byte                                    `json:"-"`
	XXX_sizecache        int32                                     `json:"-"`
}

func (m *GenerateMediationReportResponse) Reset()         { *m = GenerateMediationReportResponse{} }
func (m *GenerateMediationReportResponse) String() string { return proto.CompactTextString(m) }
func (*GenerateMediationReportResponse) ProtoMessage()    {}
func (*GenerateMediationReportResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_91b8b4130579e29e, []int{4}
}

func (m *GenerateMediationReportResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GenerateMediationReportResponse.Unmarshal(m, b)
}
func (m *GenerateMediationReportResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GenerateMediationReportResponse.Marshal(b, m, deterministic)
}
func (m *GenerateMediationReportResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GenerateMediationReportResponse.Merge(m, src)
}
func (m *GenerateMediationReportResponse) XXX_Size() int {
	return xxx_messageInfo_GenerateMediationReportResponse.Size(m)
}
func (m *GenerateMediationReportResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_GenerateMediationReportResponse.DiscardUnknown(m)
}

var xxx_messageInfo_GenerateMediationReportResponse proto.InternalMessageInfo

type isGenerateMediationReportResponse_Payload interface {
	isGenerateMediationReportResponse_Payload()
}

type GenerateMediationReportResponse_Header struct {
	Header *ReportHeader `protobuf:"bytes,1,opt,name=header,proto3,oneof"`
}

type GenerateMediationReportResponse_Row struct {
	Row *ReportRow `protobuf:"bytes,2,opt,name=row,proto3,oneof"`
}

type GenerateMediationReportResponse_Footer struct {
	Footer *ReportFooter `protobuf:"bytes,3,opt,name=footer,proto3,oneof"`
}

func (*GenerateMediationReportResponse_Header) isGenerateMediationReportResponse_Payload() {}

func (*GenerateMediationReportResponse_Row) isGenerateMediationReportResponse_Payload() {}

func (*GenerateMediationReportResponse_Footer) isGenerateMediationReportResponse_Payload() {}

func (m *GenerateMediationReportResponse) GetPayload() isGenerateMediationReportResponse_Payload {
	if m != nil {
		return m.Payload
	}
	return nil
}

func (m *GenerateMediationReportResponse) GetHeader() *ReportHeader {
	if x, ok := m.GetPayload().(*GenerateMediationReportResponse_Header); ok {
		return x.Header
	}
	return nil
}

func (m *GenerateMediationReportResponse) GetRow() *ReportRow {
	if x, ok := m.GetPayload().(*GenerateMediationReportResponse_Row); ok {
		return x.Row
	}
	return nil
}

func (m *GenerateMediationReportResponse) GetFooter() *ReportFooter {
	if x, ok := m.GetPayload().(*GenerateMediationReportResponse_Footer); ok {
		return x.Footer
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*GenerateMediationReportResponse) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*GenerateMediationReportResponse_Header)(nil),
		(*GenerateMediationReportResponse_Row)(nil),
		(*GenerateMediationReportResponse_Footer)(nil),
	}
}

// Request to generate an AdMob Network report.
type GenerateNetworkReportRequest struct {
	// Resource name of the account to generate the report for.
	// Example: accounts/pub-9876543210987654
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Network report specification.
	ReportSpec           *NetworkReportSpec `protobuf:"bytes,2,opt,name=report_spec,json=reportSpec,proto3" json:"report_spec,omitempty"`
	XXX_NoUnkeyedLiteral struct{}           `json:"-"`
	XXX_unrecognized     []byte             `json:"-"`
	XXX_sizecache        int32              `json:"-"`
}

func (m *GenerateNetworkReportRequest) Reset()         { *m = GenerateNetworkReportRequest{} }
func (m *GenerateNetworkReportRequest) String() string { return proto.CompactTextString(m) }
func (*GenerateNetworkReportRequest) ProtoMessage()    {}
func (*GenerateNetworkReportRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_91b8b4130579e29e, []int{5}
}

func (m *GenerateNetworkReportRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GenerateNetworkReportRequest.Unmarshal(m, b)
}
func (m *GenerateNetworkReportRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GenerateNetworkReportRequest.Marshal(b, m, deterministic)
}
func (m *GenerateNetworkReportRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GenerateNetworkReportRequest.Merge(m, src)
}
func (m *GenerateNetworkReportRequest) XXX_Size() int {
	return xxx_messageInfo_GenerateNetworkReportRequest.Size(m)
}
func (m *GenerateNetworkReportRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GenerateNetworkReportRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GenerateNetworkReportRequest proto.InternalMessageInfo

func (m *GenerateNetworkReportRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *GenerateNetworkReportRequest) GetReportSpec() *NetworkReportSpec {
	if m != nil {
		return m.ReportSpec
	}
	return nil
}

// The streaming response for the AdMob Network report where the first response
// contains the report header, then a stream of row responses, and finally a
// footer as the last response message.
//
// For example:
//
//     [{
//       "header": {
//         "dateRange": {
//           "startDate": {"year": 2018, "month": 9, "day": 1},
//           "endDate": {"year": 2018, "month": 9, "day": 30}
//         }
//         "localizationSettings": {
//           "currencyCode": "USD",
//           "languageCode": "en-US"
//         }
//       }
//     },
//     {
//       "row": {
//         "dimensionValues": {
//           "DATE": {"value": "20180918"},
//           "APP": {
//             "value": "ca-app-pub-8123415297019784~1001342552",
//              displayLabel: "My app name!"
//           }
//         },
//         "metricValues": {
//           "ESTIMATED_EARNINGS": {"microsValue": 6500000}
//         }
//       }
//     },
//     ...
//     {
//       "footer": {"matchingRowCount": 5}
//     }]
type GenerateNetworkReportResponse struct {
	// Each stream response message contains one type of payload.
	//
	// Types that are valid to be assigned to Payload:
	//	*GenerateNetworkReportResponse_Header
	//	*GenerateNetworkReportResponse_Row
	//	*GenerateNetworkReportResponse_Footer
	Payload              isGenerateNetworkReportResponse_Payload `protobuf_oneof:"payload"`
	XXX_NoUnkeyedLiteral struct{}                                `json:"-"`
	XXX_unrecognized     []byte                                  `json:"-"`
	XXX_sizecache        int32                                   `json:"-"`
}

func (m *GenerateNetworkReportResponse) Reset()         { *m = GenerateNetworkReportResponse{} }
func (m *GenerateNetworkReportResponse) String() string { return proto.CompactTextString(m) }
func (*GenerateNetworkReportResponse) ProtoMessage()    {}
func (*GenerateNetworkReportResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_91b8b4130579e29e, []int{6}
}

func (m *GenerateNetworkReportResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GenerateNetworkReportResponse.Unmarshal(m, b)
}
func (m *GenerateNetworkReportResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GenerateNetworkReportResponse.Marshal(b, m, deterministic)
}
func (m *GenerateNetworkReportResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GenerateNetworkReportResponse.Merge(m, src)
}
func (m *GenerateNetworkReportResponse) XXX_Size() int {
	return xxx_messageInfo_GenerateNetworkReportResponse.Size(m)
}
func (m *GenerateNetworkReportResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_GenerateNetworkReportResponse.DiscardUnknown(m)
}

var xxx_messageInfo_GenerateNetworkReportResponse proto.InternalMessageInfo

type isGenerateNetworkReportResponse_Payload interface {
	isGenerateNetworkReportResponse_Payload()
}

type GenerateNetworkReportResponse_Header struct {
	Header *ReportHeader `protobuf:"bytes,1,opt,name=header,proto3,oneof"`
}

type GenerateNetworkReportResponse_Row struct {
	Row *ReportRow `protobuf:"bytes,2,opt,name=row,proto3,oneof"`
}

type GenerateNetworkReportResponse_Footer struct {
	Footer *ReportFooter `protobuf:"bytes,3,opt,name=footer,proto3,oneof"`
}

func (*GenerateNetworkReportResponse_Header) isGenerateNetworkReportResponse_Payload() {}

func (*GenerateNetworkReportResponse_Row) isGenerateNetworkReportResponse_Payload() {}

func (*GenerateNetworkReportResponse_Footer) isGenerateNetworkReportResponse_Payload() {}

func (m *GenerateNetworkReportResponse) GetPayload() isGenerateNetworkReportResponse_Payload {
	if m != nil {
		return m.Payload
	}
	return nil
}

func (m *GenerateNetworkReportResponse) GetHeader() *ReportHeader {
	if x, ok := m.GetPayload().(*GenerateNetworkReportResponse_Header); ok {
		return x.Header
	}
	return nil
}

func (m *GenerateNetworkReportResponse) GetRow() *ReportRow {
	if x, ok := m.GetPayload().(*GenerateNetworkReportResponse_Row); ok {
		return x.Row
	}
	return nil
}

func (m *GenerateNetworkReportResponse) GetFooter() *ReportFooter {
	if x, ok := m.GetPayload().(*GenerateNetworkReportResponse_Footer); ok {
		return x.Footer
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*GenerateNetworkReportResponse) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*GenerateNetworkReportResponse_Header)(nil),
		(*GenerateNetworkReportResponse_Row)(nil),
		(*GenerateNetworkReportResponse_Footer)(nil),
	}
}

func init() {
	proto.RegisterType((*GetPublisherAccountRequest)(nil), "google.ads.admob.v1.GetPublisherAccountRequest")
	proto.RegisterType((*ListPublisherAccountsRequest)(nil), "google.ads.admob.v1.ListPublisherAccountsRequest")
	proto.RegisterType((*ListPublisherAccountsResponse)(nil), "google.ads.admob.v1.ListPublisherAccountsResponse")
	proto.RegisterType((*GenerateMediationReportRequest)(nil), "google.ads.admob.v1.GenerateMediationReportRequest")
	proto.RegisterType((*GenerateMediationReportResponse)(nil), "google.ads.admob.v1.GenerateMediationReportResponse")
	proto.RegisterType((*GenerateNetworkReportRequest)(nil), "google.ads.admob.v1.GenerateNetworkReportRequest")
	proto.RegisterType((*GenerateNetworkReportResponse)(nil), "google.ads.admob.v1.GenerateNetworkReportResponse")
}

func init() {
	proto.RegisterFile("google/ads/admob/v1/admob_api.proto", fileDescriptor_91b8b4130579e29e)
}

var fileDescriptor_91b8b4130579e29e = []byte{
	// 668 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xd4, 0x55, 0xcf, 0x4f, 0xd4, 0x40,
	0x14, 0x66, 0x40, 0x7e, 0xbd, 0x15, 0x4d, 0x06, 0x70, 0x37, 0x95, 0x45, 0xac, 0x91, 0x20, 0x87,
	0x16, 0x16, 0x4d, 0x14, 0x62, 0xcc, 0x72, 0x10, 0x4c, 0xc4, 0x90, 0xe2, 0x89, 0xcb, 0x66, 0xb6,
	0x7d, 0x96, 0x86, 0xdd, 0x99, 0x3a, 0xd3, 0x05, 0xc5, 0x18, 0x13, 0xbd, 0x78, 0xf0, 0xa6, 0xff,
	0x8d, 0x47, 0x6f, 0x26, 0x9e, 0xbc, 0x18, 0xcf, 0xfe, 0x21, 0xa6, 0xd3, 0x16, 0x77, 0xdd, 0x76,
	0x85, 0xa3, 0xb7, 0xd9, 0x79, 0xef, 0xfb, 0xde, 0xf7, 0xbe, 0x7d, 0xf3, 0x0a, 0x37, 0x7c, 0x21,
	0xfc, 0x16, 0xda, 0xcc, 0x53, 0x36, 0xf3, 0xda, 0xa2, 0x69, 0x1f, 0xad, 0x26, 0x87, 0x06, 0x0b,
	0x03, 0x2b, 0x94, 0x22, 0x12, 0x74, 0x3a, 0x49, 0xb2, 0x98, 0xa7, 0x2c, 0x1d, 0xb3, 0x8e, 0x56,
	0x8d, 0x5b, 0xc5, 0x48, 0x89, 0x4a, 0x74, 0xa4, 0x8b, 0x2a, 0xc1, 0x1b, 0x73, 0x59, 0x6a, 0x18,
	0xd8, 0x8c, 0x73, 0x11, 0xb1, 0x28, 0x10, 0x3c, 0x8b, 0x96, 0xbb, 0xa2, 0x6e, 0x2b, 0x40, 0x1e,
	0x25, 0x01, 0x73, 0x05, 0x8c, 0x2d, 0x8c, 0x76, 0x3b, 0xcd, 0x56, 0xa0, 0x0e, 0x50, 0xd6, 0x5d,
	0x57, 0x74, 0x78, 0xe4, 0xe0, 0xf3, 0x0e, 0xaa, 0x88, 0x52, 0xb8, 0xc0, 0x59, 0x1b, 0x2b, 0x64,
	0x81, 0x2c, 0x4d, 0x3a, 0xfa, 0x6c, 0xee, 0xc3, 0xdc, 0xe3, 0x40, 0xf5, 0x41, 0x54, 0x86, 0xb9,
	0x0a, 0x93, 0x21, 0xf3, 0xb1, 0xa1, 0x82, 0x93, 0x04, 0x38, 0xea, 0x4c, 0xc4, 0x17, 0x7b, 0xc1,
	0x09, 0xd2, 0x2a, 0x80, 0x0e, 0x46, 0xe2, 0x10, 0x79, 0x65, 0x58, 0xd3, 0xea, 0xf4, 0xa7, 0xf1,
	0x85, 0xf9, 0x9e, 0x40, 0xb5, 0x80, 0x5c, 0x85, 0x82, 0x2b, 0xa4, 0x0f, 0x60, 0x9c, 0x25, 0x77,
	0x15, 0xb2, 0x30, 0xb2, 0x54, 0xaa, 0xdd, 0xb4, 0x72, 0x8c, 0xb3, 0xfa, 0x1a, 0xca, 0x50, 0x74,
	0x11, 0x2e, 0x73, 0x7c, 0x11, 0x35, 0xfa, 0x64, 0x4c, 0xc5, 0xd7, 0xbb, 0xa7, 0x52, 0xde, 0x11,
	0x98, 0xdf, 0x42, 0x8e, 0x92, 0x45, 0xb8, 0x83, 0x5e, 0xa0, 0xed, 0x74, 0x30, 0x14, 0xf2, 0xd4,
	0x9d, 0x2b, 0x30, 0x16, 0x32, 0x89, 0x5a, 0x4a, 0xcc, 0x90, 0xfe, 0xa2, 0x8f, 0xa0, 0x24, 0x75,
	0x62, 0x43, 0x85, 0xe8, 0x6a, 0xfa, 0x52, 0x6d, 0x29, 0x57, 0xe7, 0x5f, 0xcc, 0x7b, 0x21, 0xba,
	0x0e, 0xc8, 0xd3, 0xb3, 0xf9, 0x93, 0xc0, 0xb5, 0x42, 0x15, 0xa9, 0x25, 0x1b, 0x30, 0x76, 0x80,
	0xcc, 0x43, 0xa9, 0x65, 0x94, 0x6a, 0xd7, 0x73, 0x2b, 0x25, 0xa0, 0x6d, 0x9d, 0xb8, 0x3d, 0xe4,
	0xa4, 0x10, 0x5a, 0x83, 0x11, 0x29, 0x8e, 0x53, 0x8d, 0xf3, 0x03, 0x90, 0x8e, 0x38, 0xde, 0x1e,
	0x72, 0xe2, 0xe4, 0xb8, 0xe0, 0x33, 0x21, 0x22, 0x94, 0x95, 0x91, 0x7f, 0x16, 0x7c, 0xa8, 0x13,
	0xe3, 0x82, 0x09, 0x64, 0x73, 0x12, 0xc6, 0x43, 0xf6, 0xb2, 0x25, 0x98, 0x67, 0xbe, 0x81, 0xb9,
	0xac, 0xb7, 0x27, 0x18, 0x1d, 0x0b, 0x79, 0x78, 0x36, 0x7f, 0xb7, 0xf2, 0xfc, 0x5d, 0xcc, 0x15,
	0xd1, 0xc3, 0xdb, 0xe7, 0xee, 0x0f, 0x02, 0xd5, 0x02, 0x05, 0xff, 0xb9, 0xb7, 0xb5, 0x6f, 0xa3,
	0x30, 0x51, 0xf7, 0x76, 0x44, 0xb3, 0x1e, 0x06, 0xf4, 0x03, 0x81, 0xe9, 0x9c, 0x57, 0x4e, 0xed,
	0x5c, 0xf2, 0xe2, 0x7d, 0x60, 0x9c, 0xed, 0xb1, 0x99, 0xd5, 0xb7, 0xdf, 0x7f, 0x7d, 0x1c, 0x2e,
	0xd3, 0xd9, 0x78, 0x5d, 0xbd, 0x8a, 0xb7, 0xc6, 0xfd, 0xf4, 0xf9, 0x29, 0x7b, 0xf9, 0x35, 0xfd,
	0x44, 0x60, 0x36, 0xf7, 0x95, 0xd3, 0xd5, 0x5c, 0xfe, 0x41, 0xeb, 0xc6, 0xa8, 0x9d, 0x07, 0x92,
	0xfc, 0xab, 0xe6, 0x8c, 0xd6, 0x77, 0x89, 0x5e, 0xd4, 0xeb, 0x34, 0x2b, 0xfe, 0x99, 0xc0, 0x6c,
	0xee, 0x34, 0x14, 0xc8, 0x1a, 0x34, 0xbb, 0x05, 0xb2, 0x06, 0x0e, 0x9b, 0x79, 0x4f, 0xcb, 0x5a,
	0x33, 0x2d, 0x6d, 0x5b, 0x32, 0xec, 0xdd, 0xc6, 0xd9, 0xbc, 0x1b, 0xb6, 0xee, 0xa7, 0x64, 0xeb,
	0x64, 0x79, 0x85, 0xd0, 0x2f, 0x04, 0xca, 0x05, 0x9b, 0x82, 0xae, 0x0d, 0x14, 0x93, 0xbf, 0xdd,
	0x8c, 0xdb, 0xe7, 0x03, 0xa5, 0x3d, 0x6c, 0xe8, 0x1e, 0xee, 0x98, 0x2b, 0x45, 0x3d, 0xb4, 0x7b,
	0x81, 0xbd, 0x5d, 0x18, 0xe5, 0xaf, 0xf5, 0x99, 0xa4, 0x56, 0x52, 0x9c, 0x85, 0x81, 0xb2, 0x5c,
	0xd1, 0xde, 0x6c, 0x42, 0xd9, 0x15, 0xed, 0x3c, 0x49, 0x9b, 0x53, 0xd9, 0x9c, 0xef, 0xc6, 0x5f,
	0xb4, 0xfd, 0xbb, 0x69, 0x8e, 0x2f, 0x5a, 0x8c, 0xfb, 0x96, 0x90, 0xbe, 0xed, 0x23, 0xd7, 0x5f,
	0x3b, 0xfb, 0x0f, 0x69, 0xcf, 0x27, 0x75, 0x43, 0x1f, 0x9a, 0x63, 0x3a, 0x69, 0xed, 0x77, 0x00,
	0x00, 0x00, 0xff, 0xff, 0xb6, 0x08, 0x66, 0x3e, 0xb0, 0x07, 0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// AdMobApiClient is the client API for AdMobApi service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type AdMobApiClient interface {
	// Gets information about the specified AdMob publisher account.
	GetPublisherAccount(ctx context.Context, in *GetPublisherAccountRequest, opts ...grpc.CallOption) (*PublisherAccount, error)
	// Lists the AdMob publisher account accessible with the client credential.
	// Currently, all credentials have access to at most one AdMob account.
	ListPublisherAccounts(ctx context.Context, in *ListPublisherAccountsRequest, opts ...grpc.CallOption) (*ListPublisherAccountsResponse, error)
	// Generates an AdMob Network report based on the provided report
	// specification.
	GenerateNetworkReport(ctx context.Context, in *GenerateNetworkReportRequest, opts ...grpc.CallOption) (AdMobApi_GenerateNetworkReportClient, error)
	// Generates an AdMob Mediation report based on the provided report
	// specification.
	GenerateMediationReport(ctx context.Context, in *GenerateMediationReportRequest, opts ...grpc.CallOption) (AdMobApi_GenerateMediationReportClient, error)
}

type adMobApiClient struct {
	cc grpc.ClientConnInterface
}

func NewAdMobApiClient(cc grpc.ClientConnInterface) AdMobApiClient {
	return &adMobApiClient{cc}
}

func (c *adMobApiClient) GetPublisherAccount(ctx context.Context, in *GetPublisherAccountRequest, opts ...grpc.CallOption) (*PublisherAccount, error) {
	out := new(PublisherAccount)
	err := c.cc.Invoke(ctx, "/google.ads.admob.v1.AdMobApi/GetPublisherAccount", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *adMobApiClient) ListPublisherAccounts(ctx context.Context, in *ListPublisherAccountsRequest, opts ...grpc.CallOption) (*ListPublisherAccountsResponse, error) {
	out := new(ListPublisherAccountsResponse)
	err := c.cc.Invoke(ctx, "/google.ads.admob.v1.AdMobApi/ListPublisherAccounts", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *adMobApiClient) GenerateNetworkReport(ctx context.Context, in *GenerateNetworkReportRequest, opts ...grpc.CallOption) (AdMobApi_GenerateNetworkReportClient, error) {
	stream, err := c.cc.NewStream(ctx, &_AdMobApi_serviceDesc.Streams[0], "/google.ads.admob.v1.AdMobApi/GenerateNetworkReport", opts...)
	if err != nil {
		return nil, err
	}
	x := &adMobApiGenerateNetworkReportClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type AdMobApi_GenerateNetworkReportClient interface {
	Recv() (*GenerateNetworkReportResponse, error)
	grpc.ClientStream
}

type adMobApiGenerateNetworkReportClient struct {
	grpc.ClientStream
}

func (x *adMobApiGenerateNetworkReportClient) Recv() (*GenerateNetworkReportResponse, error) {
	m := new(GenerateNetworkReportResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *adMobApiClient) GenerateMediationReport(ctx context.Context, in *GenerateMediationReportRequest, opts ...grpc.CallOption) (AdMobApi_GenerateMediationReportClient, error) {
	stream, err := c.cc.NewStream(ctx, &_AdMobApi_serviceDesc.Streams[1], "/google.ads.admob.v1.AdMobApi/GenerateMediationReport", opts...)
	if err != nil {
		return nil, err
	}
	x := &adMobApiGenerateMediationReportClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type AdMobApi_GenerateMediationReportClient interface {
	Recv() (*GenerateMediationReportResponse, error)
	grpc.ClientStream
}

type adMobApiGenerateMediationReportClient struct {
	grpc.ClientStream
}

func (x *adMobApiGenerateMediationReportClient) Recv() (*GenerateMediationReportResponse, error) {
	m := new(GenerateMediationReportResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

// AdMobApiServer is the server API for AdMobApi service.
type AdMobApiServer interface {
	// Gets information about the specified AdMob publisher account.
	GetPublisherAccount(context.Context, *GetPublisherAccountRequest) (*PublisherAccount, error)
	// Lists the AdMob publisher account accessible with the client credential.
	// Currently, all credentials have access to at most one AdMob account.
	ListPublisherAccounts(context.Context, *ListPublisherAccountsRequest) (*ListPublisherAccountsResponse, error)
	// Generates an AdMob Network report based on the provided report
	// specification.
	GenerateNetworkReport(*GenerateNetworkReportRequest, AdMobApi_GenerateNetworkReportServer) error
	// Generates an AdMob Mediation report based on the provided report
	// specification.
	GenerateMediationReport(*GenerateMediationReportRequest, AdMobApi_GenerateMediationReportServer) error
}

// UnimplementedAdMobApiServer can be embedded to have forward compatible implementations.
type UnimplementedAdMobApiServer struct {
}

func (*UnimplementedAdMobApiServer) GetPublisherAccount(ctx context.Context, req *GetPublisherAccountRequest) (*PublisherAccount, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetPublisherAccount not implemented")
}
func (*UnimplementedAdMobApiServer) ListPublisherAccounts(ctx context.Context, req *ListPublisherAccountsRequest) (*ListPublisherAccountsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListPublisherAccounts not implemented")
}
func (*UnimplementedAdMobApiServer) GenerateNetworkReport(req *GenerateNetworkReportRequest, srv AdMobApi_GenerateNetworkReportServer) error {
	return status.Errorf(codes.Unimplemented, "method GenerateNetworkReport not implemented")
}
func (*UnimplementedAdMobApiServer) GenerateMediationReport(req *GenerateMediationReportRequest, srv AdMobApi_GenerateMediationReportServer) error {
	return status.Errorf(codes.Unimplemented, "method GenerateMediationReport not implemented")
}

func RegisterAdMobApiServer(s *grpc.Server, srv AdMobApiServer) {
	s.RegisterService(&_AdMobApi_serviceDesc, srv)
}

func _AdMobApi_GetPublisherAccount_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetPublisherAccountRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AdMobApiServer).GetPublisherAccount(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.ads.admob.v1.AdMobApi/GetPublisherAccount",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AdMobApiServer).GetPublisherAccount(ctx, req.(*GetPublisherAccountRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AdMobApi_ListPublisherAccounts_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListPublisherAccountsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AdMobApiServer).ListPublisherAccounts(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.ads.admob.v1.AdMobApi/ListPublisherAccounts",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AdMobApiServer).ListPublisherAccounts(ctx, req.(*ListPublisherAccountsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AdMobApi_GenerateNetworkReport_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(GenerateNetworkReportRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(AdMobApiServer).GenerateNetworkReport(m, &adMobApiGenerateNetworkReportServer{stream})
}

type AdMobApi_GenerateNetworkReportServer interface {
	Send(*GenerateNetworkReportResponse) error
	grpc.ServerStream
}

type adMobApiGenerateNetworkReportServer struct {
	grpc.ServerStream
}

func (x *adMobApiGenerateNetworkReportServer) Send(m *GenerateNetworkReportResponse) error {
	return x.ServerStream.SendMsg(m)
}

func _AdMobApi_GenerateMediationReport_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(GenerateMediationReportRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(AdMobApiServer).GenerateMediationReport(m, &adMobApiGenerateMediationReportServer{stream})
}

type AdMobApi_GenerateMediationReportServer interface {
	Send(*GenerateMediationReportResponse) error
	grpc.ServerStream
}

type adMobApiGenerateMediationReportServer struct {
	grpc.ServerStream
}

func (x *adMobApiGenerateMediationReportServer) Send(m *GenerateMediationReportResponse) error {
	return x.ServerStream.SendMsg(m)
}

var _AdMobApi_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.ads.admob.v1.AdMobApi",
	HandlerType: (*AdMobApiServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "GetPublisherAccount",
			Handler:    _AdMobApi_GetPublisherAccount_Handler,
		},
		{
			MethodName: "ListPublisherAccounts",
			Handler:    _AdMobApi_ListPublisherAccounts_Handler,
		},
	},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "GenerateNetworkReport",
			Handler:       _AdMobApi_GenerateNetworkReport_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "GenerateMediationReport",
			Handler:       _AdMobApi_GenerateMediationReport_Handler,
			ServerStreams: true,
		},
	},
	Metadata: "google/ads/admob/v1/admob_api.proto",
}
