#ifndef _INPUT_H_
#define _INPUT_H_

/***************************************************************************
 *   Copyright (C) 2007 by Sergio Pistone                                  *
 *   sergio_pistone@yahoo.com.ar                                           *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifdef HAVE_CONFIG_H
	#include <config.h>
#endif

#include <string>

class Input
{
	public:
		Input( unsigned long timeLimitMS=NoLimit );
		virtual ~Input();

		bool open();
		bool close();
		bool isOpened();
		bool isClosed();

		unsigned long getTimeLimit();
		void setTimeLimit( unsigned long timeLimitMS );

		virtual unsigned long getTotalTime();
		virtual unsigned long getCurrentTime();

		virtual unsigned long getSampleRate();
		virtual unsigned int getChannels();
		virtual unsigned int getBitsPerSample();

		virtual unsigned int getBlockAlign();
		static unsigned int getBlockAlign( unsigned int channels, unsigned int bitsPerSample );

		bool getPCMChunk( unsigned char* data, unsigned long limit, unsigned long &read );

		static const unsigned long NoLimit = (unsigned long)-1;
		static const unsigned long MaxLimit = NoLimit-1;

	protected:

		virtual bool _open() = 0;
		virtual bool _close() = 0;

		virtual bool _getPCMChunk( unsigned char* data, unsigned long limit, unsigned long &read ) = 0;

		bool m_isOpened;

		unsigned long m_totalTimeMS;
		unsigned long m_currentTimeMS;

		unsigned long m_sampleRate;
		unsigned int m_channels;
		unsigned int m_bitsPerSample;

		unsigned long m_timeLimitMS;
		unsigned long long m_bytesLimit;
		unsigned long long m_bytesRead;
};

#endif
