// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/aiplatform/v1/migration_service.proto

#include "google/cloud/aiplatform/v1/internal/migration_tracing_connection.h"
#include "google/cloud/internal/opentelemetry.h"
#include "google/cloud/internal/traced_stream_range.h"
#include <memory>

namespace google {
namespace cloud {
namespace aiplatform_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

MigrationServiceTracingConnection::MigrationServiceTracingConnection(
    std::shared_ptr<aiplatform_v1::MigrationServiceConnection> child)
    : child_(std::move(child)) {}

StreamRange<google::cloud::aiplatform::v1::MigratableResource>
MigrationServiceTracingConnection::SearchMigratableResources(
    google::cloud::aiplatform::v1::SearchMigratableResourcesRequest request) {
  auto span = internal::MakeSpan(
      "aiplatform_v1::MigrationServiceConnection::SearchMigratableResources");
  internal::OTelScope scope(span);
  auto sr = child_->SearchMigratableResources(std::move(request));
  return internal::MakeTracedStreamRange<
      google::cloud::aiplatform::v1::MigratableResource>(std::move(span),
                                                         std::move(sr));
}

future<StatusOr<google::cloud::aiplatform::v1::BatchMigrateResourcesResponse>>
MigrationServiceTracingConnection::BatchMigrateResources(
    google::cloud::aiplatform::v1::BatchMigrateResourcesRequest const&
        request) {
  auto span = internal::MakeSpan(
      "aiplatform_v1::MigrationServiceConnection::BatchMigrateResources");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->BatchMigrateResources(request));
}

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

std::shared_ptr<aiplatform_v1::MigrationServiceConnection>
MakeMigrationServiceTracingConnection(
    std::shared_ptr<aiplatform_v1::MigrationServiceConnection> conn) {
#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  if (internal::TracingEnabled(conn->options())) {
    conn = std::make_shared<MigrationServiceTracingConnection>(std::move(conn));
  }
#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  return conn;
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace aiplatform_v1_internal
}  // namespace cloud
}  // namespace google
