// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/bigquery/analyticshub/v1/analyticshub.proto

#include "google/cloud/bigquery/analyticshub/v1/internal/analytics_hub_tracing_stub.h"
#include "google/cloud/internal/grpc_opentelemetry.h"

namespace google {
namespace cloud {
namespace bigquery_analyticshub_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

AnalyticsHubServiceTracingStub::AnalyticsHubServiceTracingStub(
    std::shared_ptr<AnalyticsHubServiceStub> child)
    : child_(std::move(child)), propagator_(internal::MakePropagator()) {}

StatusOr<google::cloud::bigquery::analyticshub::v1::ListDataExchangesResponse>
AnalyticsHubServiceTracingStub::ListDataExchanges(
    grpc::ClientContext& context,
    google::cloud::bigquery::analyticshub::v1::ListDataExchangesRequest const&
        request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.bigquery.analyticshub.v1.AnalyticsHubService",
      "ListDataExchanges");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->ListDataExchanges(context, request));
}

StatusOr<
    google::cloud::bigquery::analyticshub::v1::ListOrgDataExchangesResponse>
AnalyticsHubServiceTracingStub::ListOrgDataExchanges(
    grpc::ClientContext& context,
    google::cloud::bigquery::analyticshub::v1::
        ListOrgDataExchangesRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.bigquery.analyticshub.v1.AnalyticsHubService",
      "ListOrgDataExchanges");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->ListOrgDataExchanges(context, request));
}

StatusOr<google::cloud::bigquery::analyticshub::v1::DataExchange>
AnalyticsHubServiceTracingStub::GetDataExchange(
    grpc::ClientContext& context,
    google::cloud::bigquery::analyticshub::v1::GetDataExchangeRequest const&
        request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.bigquery.analyticshub.v1.AnalyticsHubService",
      "GetDataExchange");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->GetDataExchange(context, request));
}

StatusOr<google::cloud::bigquery::analyticshub::v1::DataExchange>
AnalyticsHubServiceTracingStub::CreateDataExchange(
    grpc::ClientContext& context,
    google::cloud::bigquery::analyticshub::v1::CreateDataExchangeRequest const&
        request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.bigquery.analyticshub.v1.AnalyticsHubService",
      "CreateDataExchange");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->CreateDataExchange(context, request));
}

StatusOr<google::cloud::bigquery::analyticshub::v1::DataExchange>
AnalyticsHubServiceTracingStub::UpdateDataExchange(
    grpc::ClientContext& context,
    google::cloud::bigquery::analyticshub::v1::UpdateDataExchangeRequest const&
        request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.bigquery.analyticshub.v1.AnalyticsHubService",
      "UpdateDataExchange");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->UpdateDataExchange(context, request));
}

Status AnalyticsHubServiceTracingStub::DeleteDataExchange(
    grpc::ClientContext& context,
    google::cloud::bigquery::analyticshub::v1::DeleteDataExchangeRequest const&
        request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.bigquery.analyticshub.v1.AnalyticsHubService",
      "DeleteDataExchange");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->DeleteDataExchange(context, request));
}

StatusOr<google::cloud::bigquery::analyticshub::v1::ListListingsResponse>
AnalyticsHubServiceTracingStub::ListListings(
    grpc::ClientContext& context,
    google::cloud::bigquery::analyticshub::v1::ListListingsRequest const&
        request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.bigquery.analyticshub.v1.AnalyticsHubService",
      "ListListings");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->ListListings(context, request));
}

StatusOr<google::cloud::bigquery::analyticshub::v1::Listing>
AnalyticsHubServiceTracingStub::GetListing(
    grpc::ClientContext& context,
    google::cloud::bigquery::analyticshub::v1::GetListingRequest const&
        request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.bigquery.analyticshub.v1.AnalyticsHubService",
      "GetListing");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->GetListing(context, request));
}

StatusOr<google::cloud::bigquery::analyticshub::v1::Listing>
AnalyticsHubServiceTracingStub::CreateListing(
    grpc::ClientContext& context,
    google::cloud::bigquery::analyticshub::v1::CreateListingRequest const&
        request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.bigquery.analyticshub.v1.AnalyticsHubService",
      "CreateListing");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->CreateListing(context, request));
}

StatusOr<google::cloud::bigquery::analyticshub::v1::Listing>
AnalyticsHubServiceTracingStub::UpdateListing(
    grpc::ClientContext& context,
    google::cloud::bigquery::analyticshub::v1::UpdateListingRequest const&
        request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.bigquery.analyticshub.v1.AnalyticsHubService",
      "UpdateListing");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->UpdateListing(context, request));
}

Status AnalyticsHubServiceTracingStub::DeleteListing(
    grpc::ClientContext& context,
    google::cloud::bigquery::analyticshub::v1::DeleteListingRequest const&
        request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.bigquery.analyticshub.v1.AnalyticsHubService",
      "DeleteListing");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->DeleteListing(context, request));
}

StatusOr<google::cloud::bigquery::analyticshub::v1::SubscribeListingResponse>
AnalyticsHubServiceTracingStub::SubscribeListing(
    grpc::ClientContext& context,
    google::cloud::bigquery::analyticshub::v1::SubscribeListingRequest const&
        request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.bigquery.analyticshub.v1.AnalyticsHubService",
      "SubscribeListing");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->SubscribeListing(context, request));
}

future<StatusOr<google::longrunning::Operation>>
AnalyticsHubServiceTracingStub::AsyncSubscribeDataExchange(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context, Options const& options,
    google::cloud::bigquery::analyticshub::v1::
        SubscribeDataExchangeRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.bigquery.analyticshub.v1.AnalyticsHubService",
      "SubscribeDataExchange");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f = child_->AsyncSubscribeDataExchange(cq, context, options, request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

future<StatusOr<google::longrunning::Operation>>
AnalyticsHubServiceTracingStub::AsyncRefreshSubscription(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context, Options const& options,
    google::cloud::bigquery::analyticshub::v1::RefreshSubscriptionRequest const&
        request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.bigquery.analyticshub.v1.AnalyticsHubService",
      "RefreshSubscription");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f = child_->AsyncRefreshSubscription(cq, context, options, request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

StatusOr<google::cloud::bigquery::analyticshub::v1::Subscription>
AnalyticsHubServiceTracingStub::GetSubscription(
    grpc::ClientContext& context,
    google::cloud::bigquery::analyticshub::v1::GetSubscriptionRequest const&
        request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.bigquery.analyticshub.v1.AnalyticsHubService",
      "GetSubscription");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->GetSubscription(context, request));
}

StatusOr<google::cloud::bigquery::analyticshub::v1::ListSubscriptionsResponse>
AnalyticsHubServiceTracingStub::ListSubscriptions(
    grpc::ClientContext& context,
    google::cloud::bigquery::analyticshub::v1::ListSubscriptionsRequest const&
        request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.bigquery.analyticshub.v1.AnalyticsHubService",
      "ListSubscriptions");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->ListSubscriptions(context, request));
}

StatusOr<google::cloud::bigquery::analyticshub::v1::
             ListSharedResourceSubscriptionsResponse>
AnalyticsHubServiceTracingStub::ListSharedResourceSubscriptions(
    grpc::ClientContext& context,
    google::cloud::bigquery::analyticshub::v1::
        ListSharedResourceSubscriptionsRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.bigquery.analyticshub.v1.AnalyticsHubService",
      "ListSharedResourceSubscriptions");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(
      context, *span,
      child_->ListSharedResourceSubscriptions(context, request));
}

StatusOr<google::cloud::bigquery::analyticshub::v1::RevokeSubscriptionResponse>
AnalyticsHubServiceTracingStub::RevokeSubscription(
    grpc::ClientContext& context,
    google::cloud::bigquery::analyticshub::v1::RevokeSubscriptionRequest const&
        request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.bigquery.analyticshub.v1.AnalyticsHubService",
      "RevokeSubscription");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->RevokeSubscription(context, request));
}

future<StatusOr<google::longrunning::Operation>>
AnalyticsHubServiceTracingStub::AsyncDeleteSubscription(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context, Options const& options,
    google::cloud::bigquery::analyticshub::v1::DeleteSubscriptionRequest const&
        request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.bigquery.analyticshub.v1.AnalyticsHubService",
      "DeleteSubscription");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f = child_->AsyncDeleteSubscription(cq, context, options, request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

StatusOr<google::iam::v1::Policy> AnalyticsHubServiceTracingStub::GetIamPolicy(
    grpc::ClientContext& context,
    google::iam::v1::GetIamPolicyRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.bigquery.analyticshub.v1.AnalyticsHubService",
      "GetIamPolicy");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->GetIamPolicy(context, request));
}

StatusOr<google::iam::v1::Policy> AnalyticsHubServiceTracingStub::SetIamPolicy(
    grpc::ClientContext& context,
    google::iam::v1::SetIamPolicyRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.bigquery.analyticshub.v1.AnalyticsHubService",
      "SetIamPolicy");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->SetIamPolicy(context, request));
}

StatusOr<google::iam::v1::TestIamPermissionsResponse>
AnalyticsHubServiceTracingStub::TestIamPermissions(
    grpc::ClientContext& context,
    google::iam::v1::TestIamPermissionsRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.bigquery.analyticshub.v1.AnalyticsHubService",
      "TestIamPermissions");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->TestIamPermissions(context, request));
}

future<StatusOr<google::longrunning::Operation>>
AnalyticsHubServiceTracingStub::AsyncGetOperation(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context, Options const& options,
    google::longrunning::GetOperationRequest const& request) {
  auto span =
      internal::MakeSpanGrpc("google.longrunning.Operations", "GetOperation");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f = child_->AsyncGetOperation(cq, context, options, request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

future<Status> AnalyticsHubServiceTracingStub::AsyncCancelOperation(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context, Options const& options,
    google::longrunning::CancelOperationRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.longrunning.Operations",
                                     "CancelOperation");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f = child_->AsyncCancelOperation(cq, context, options, request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

std::shared_ptr<AnalyticsHubServiceStub> MakeAnalyticsHubServiceTracingStub(
    std::shared_ptr<AnalyticsHubServiceStub> stub) {
#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  return std::make_shared<AnalyticsHubServiceTracingStub>(std::move(stub));
#else
  return stub;
#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace bigquery_analyticshub_v1_internal
}  // namespace cloud
}  // namespace google
