// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/compute/backend_services/v1/backend_services.proto

#include "google/cloud/compute/backend_services/v1/internal/backend_services_tracing_connection.h"
#include "google/cloud/internal/opentelemetry.h"
#include "google/cloud/internal/traced_stream_range.h"
#include <memory>

namespace google {
namespace cloud {
namespace compute_backend_services_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

BackendServicesTracingConnection::BackendServicesTracingConnection(
    std::shared_ptr<compute_backend_services_v1::BackendServicesConnection>
        child)
    : child_(std::move(child)) {}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
BackendServicesTracingConnection::AddSignedUrlKey(
    google::cloud::cpp::compute::backend_services::v1::
        AddSignedUrlKeyRequest const& request) {
  auto span = internal::MakeSpan(
      "compute_backend_services_v1::BackendServicesConnection::"
      "AddSignedUrlKey");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->AddSignedUrlKey(request));
}

StreamRange<std::pair<
    std::string, google::cloud::cpp::compute::v1::BackendServicesScopedList>>
BackendServicesTracingConnection::AggregatedListBackendServices(
    google::cloud::cpp::compute::backend_services::v1::
        AggregatedListBackendServicesRequest request) {
  auto span = internal::MakeSpan(
      "compute_backend_services_v1::BackendServicesConnection::"
      "AggregatedListBackendServices");
  internal::OTelScope scope(span);
  auto sr = child_->AggregatedListBackendServices(std::move(request));
  return internal::MakeTracedStreamRange<std::pair<
      std::string, google::cloud::cpp::compute::v1::BackendServicesScopedList>>(
      std::move(span), std::move(sr));
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
BackendServicesTracingConnection::DeleteBackendService(
    google::cloud::cpp::compute::backend_services::v1::
        DeleteBackendServiceRequest const& request) {
  auto span = internal::MakeSpan(
      "compute_backend_services_v1::BackendServicesConnection::"
      "DeleteBackendService");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->DeleteBackendService(request));
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
BackendServicesTracingConnection::DeleteSignedUrlKey(
    google::cloud::cpp::compute::backend_services::v1::
        DeleteSignedUrlKeyRequest const& request) {
  auto span = internal::MakeSpan(
      "compute_backend_services_v1::BackendServicesConnection::"
      "DeleteSignedUrlKey");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->DeleteSignedUrlKey(request));
}

StatusOr<google::cloud::cpp::compute::v1::BackendService>
BackendServicesTracingConnection::GetBackendService(
    google::cloud::cpp::compute::backend_services::v1::
        GetBackendServiceRequest const& request) {
  auto span = internal::MakeSpan(
      "compute_backend_services_v1::BackendServicesConnection::"
      "GetBackendService");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetBackendService(request));
}

StatusOr<google::cloud::cpp::compute::v1::BackendServiceGroupHealth>
BackendServicesTracingConnection::GetHealth(
    google::cloud::cpp::compute::backend_services::v1::GetHealthRequest const&
        request) {
  auto span = internal::MakeSpan(
      "compute_backend_services_v1::BackendServicesConnection::GetHealth");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetHealth(request));
}

StatusOr<google::cloud::cpp::compute::v1::Policy>
BackendServicesTracingConnection::GetIamPolicy(
    google::cloud::cpp::compute::backend_services::v1::
        GetIamPolicyRequest const& request) {
  auto span = internal::MakeSpan(
      "compute_backend_services_v1::BackendServicesConnection::GetIamPolicy");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetIamPolicy(request));
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
BackendServicesTracingConnection::InsertBackendService(
    google::cloud::cpp::compute::backend_services::v1::
        InsertBackendServiceRequest const& request) {
  auto span = internal::MakeSpan(
      "compute_backend_services_v1::BackendServicesConnection::"
      "InsertBackendService");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->InsertBackendService(request));
}

StreamRange<google::cloud::cpp::compute::v1::BackendService>
BackendServicesTracingConnection::ListBackendServices(
    google::cloud::cpp::compute::backend_services::v1::
        ListBackendServicesRequest request) {
  auto span = internal::MakeSpan(
      "compute_backend_services_v1::BackendServicesConnection::"
      "ListBackendServices");
  internal::OTelScope scope(span);
  auto sr = child_->ListBackendServices(std::move(request));
  return internal::MakeTracedStreamRange<
      google::cloud::cpp::compute::v1::BackendService>(std::move(span),
                                                       std::move(sr));
}

StreamRange<google::cloud::cpp::compute::v1::BackendService>
BackendServicesTracingConnection::ListUsable(
    google::cloud::cpp::compute::backend_services::v1::ListUsableRequest
        request) {
  auto span = internal::MakeSpan(
      "compute_backend_services_v1::BackendServicesConnection::ListUsable");
  internal::OTelScope scope(span);
  auto sr = child_->ListUsable(std::move(request));
  return internal::MakeTracedStreamRange<
      google::cloud::cpp::compute::v1::BackendService>(std::move(span),
                                                       std::move(sr));
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
BackendServicesTracingConnection::PatchBackendService(
    google::cloud::cpp::compute::backend_services::v1::
        PatchBackendServiceRequest const& request) {
  auto span = internal::MakeSpan(
      "compute_backend_services_v1::BackendServicesConnection::"
      "PatchBackendService");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->PatchBackendService(request));
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
BackendServicesTracingConnection::SetEdgeSecurityPolicy(
    google::cloud::cpp::compute::backend_services::v1::
        SetEdgeSecurityPolicyRequest const& request) {
  auto span = internal::MakeSpan(
      "compute_backend_services_v1::BackendServicesConnection::"
      "SetEdgeSecurityPolicy");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->SetEdgeSecurityPolicy(request));
}

StatusOr<google::cloud::cpp::compute::v1::Policy>
BackendServicesTracingConnection::SetIamPolicy(
    google::cloud::cpp::compute::backend_services::v1::
        SetIamPolicyRequest const& request) {
  auto span = internal::MakeSpan(
      "compute_backend_services_v1::BackendServicesConnection::SetIamPolicy");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->SetIamPolicy(request));
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
BackendServicesTracingConnection::SetSecurityPolicy(
    google::cloud::cpp::compute::backend_services::v1::
        SetSecurityPolicyRequest const& request) {
  auto span = internal::MakeSpan(
      "compute_backend_services_v1::BackendServicesConnection::"
      "SetSecurityPolicy");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->SetSecurityPolicy(request));
}

StatusOr<google::cloud::cpp::compute::v1::TestPermissionsResponse>
BackendServicesTracingConnection::TestIamPermissions(
    google::cloud::cpp::compute::backend_services::v1::
        TestIamPermissionsRequest const& request) {
  auto span = internal::MakeSpan(
      "compute_backend_services_v1::BackendServicesConnection::"
      "TestIamPermissions");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->TestIamPermissions(request));
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
BackendServicesTracingConnection::UpdateBackendService(
    google::cloud::cpp::compute::backend_services::v1::
        UpdateBackendServiceRequest const& request) {
  auto span = internal::MakeSpan(
      "compute_backend_services_v1::BackendServicesConnection::"
      "UpdateBackendService");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->UpdateBackendService(request));
}

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

std::shared_ptr<compute_backend_services_v1::BackendServicesConnection>
MakeBackendServicesTracingConnection(
    std::shared_ptr<compute_backend_services_v1::BackendServicesConnection>
        conn) {
#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  if (internal::TracingEnabled(conn->options())) {
    conn = std::make_shared<BackendServicesTracingConnection>(std::move(conn));
  }
#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  return conn;
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace compute_backend_services_v1_internal
}  // namespace cloud
}  // namespace google
