// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/compute/instances/v1/instances.proto

#include "google/cloud/compute/instances/v1/instances_client.h"
#include <memory>

namespace google {
namespace cloud {
namespace compute_instances_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

InstancesClient::InstancesClient(
    std::shared_ptr<InstancesConnection> connection, Options opts)
    : connection_(std::move(connection)),
      options_(
          internal::MergeOptions(std::move(opts), connection_->options())) {}
InstancesClient::~InstancesClient() = default;

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
InstancesClient::AddAccessConfig(
    std::string const& project, std::string const& zone,
    std::string const& instance, std::string const& network_interface,
    google::cloud::cpp::compute::v1::AccessConfig const& access_config_resource,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::instances::v1::AddAccessConfigRequest request;
  request.set_project(project);
  request.set_zone(zone);
  request.set_instance(instance);
  request.set_network_interface(network_interface);
  *request.mutable_access_config_resource() = access_config_resource;
  return connection_->AddAccessConfig(request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
InstancesClient::AddAccessConfig(
    google::cloud::cpp::compute::instances::v1::AddAccessConfigRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->AddAccessConfig(request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
InstancesClient::AddResourcePolicies(
    std::string const& project, std::string const& zone,
    std::string const& instance,
    google::cloud::cpp::compute::v1::InstancesAddResourcePoliciesRequest const&
        instances_add_resource_policies_request_resource,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::instances::v1::AddResourcePoliciesRequest
      request;
  request.set_project(project);
  request.set_zone(zone);
  request.set_instance(instance);
  *request.mutable_instances_add_resource_policies_request_resource() =
      instances_add_resource_policies_request_resource;
  return connection_->AddResourcePolicies(request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
InstancesClient::AddResourcePolicies(
    google::cloud::cpp::compute::instances::v1::
        AddResourcePoliciesRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->AddResourcePolicies(request);
}

StreamRange<std::pair<std::string,
                      google::cloud::cpp::compute::v1::InstancesScopedList>>
InstancesClient::AggregatedListInstances(std::string const& project,
                                         Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::instances::v1::AggregatedListInstancesRequest
      request;
  request.set_project(project);
  return connection_->AggregatedListInstances(request);
}

StreamRange<std::pair<std::string,
                      google::cloud::cpp::compute::v1::InstancesScopedList>>
InstancesClient::AggregatedListInstances(
    google::cloud::cpp::compute::instances::v1::AggregatedListInstancesRequest
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->AggregatedListInstances(std::move(request));
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
InstancesClient::AttachDisk(
    std::string const& project, std::string const& zone,
    std::string const& instance,
    google::cloud::cpp::compute::v1::AttachedDisk const& attached_disk_resource,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::instances::v1::AttachDiskRequest request;
  request.set_project(project);
  request.set_zone(zone);
  request.set_instance(instance);
  *request.mutable_attached_disk_resource() = attached_disk_resource;
  return connection_->AttachDisk(request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
InstancesClient::AttachDisk(
    google::cloud::cpp::compute::instances::v1::AttachDiskRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->AttachDisk(request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
InstancesClient::BulkInsert(
    std::string const& project, std::string const& zone,
    google::cloud::cpp::compute::v1::BulkInsertInstanceResource const&
        bulk_insert_instance_resource,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::instances::v1::BulkInsertRequest request;
  request.set_project(project);
  request.set_zone(zone);
  *request.mutable_bulk_insert_instance_resource() =
      bulk_insert_instance_resource;
  return connection_->BulkInsert(request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
InstancesClient::BulkInsert(
    google::cloud::cpp::compute::instances::v1::BulkInsertRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->BulkInsert(request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
InstancesClient::DeleteInstance(std::string const& project,
                                std::string const& zone,
                                std::string const& instance, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::instances::v1::DeleteInstanceRequest request;
  request.set_project(project);
  request.set_zone(zone);
  request.set_instance(instance);
  return connection_->DeleteInstance(request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
InstancesClient::DeleteInstance(
    google::cloud::cpp::compute::instances::v1::DeleteInstanceRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteInstance(request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
InstancesClient::DeleteAccessConfig(std::string const& project,
                                    std::string const& zone,
                                    std::string const& instance,
                                    std::string const& access_config,
                                    std::string const& network_interface,
                                    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::instances::v1::DeleteAccessConfigRequest request;
  request.set_project(project);
  request.set_zone(zone);
  request.set_instance(instance);
  request.set_access_config(access_config);
  request.set_network_interface(network_interface);
  return connection_->DeleteAccessConfig(request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
InstancesClient::DeleteAccessConfig(
    google::cloud::cpp::compute::instances::v1::DeleteAccessConfigRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteAccessConfig(request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
InstancesClient::DetachDisk(std::string const& project, std::string const& zone,
                            std::string const& instance,
                            std::string const& device_name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::instances::v1::DetachDiskRequest request;
  request.set_project(project);
  request.set_zone(zone);
  request.set_instance(instance);
  request.set_device_name(device_name);
  return connection_->DetachDisk(request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
InstancesClient::DetachDisk(
    google::cloud::cpp::compute::instances::v1::DetachDiskRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DetachDisk(request);
}

StatusOr<google::cloud::cpp::compute::v1::Instance>
InstancesClient::GetInstance(std::string const& project,
                             std::string const& zone,
                             std::string const& instance, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::instances::v1::GetInstanceRequest request;
  request.set_project(project);
  request.set_zone(zone);
  request.set_instance(instance);
  return connection_->GetInstance(request);
}

StatusOr<google::cloud::cpp::compute::v1::Instance>
InstancesClient::GetInstance(
    google::cloud::cpp::compute::instances::v1::GetInstanceRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetInstance(request);
}

StatusOr<
    google::cloud::cpp::compute::v1::InstancesGetEffectiveFirewallsResponse>
InstancesClient::GetEffectiveFirewalls(std::string const& project,
                                       std::string const& zone,
                                       std::string const& instance,
                                       std::string const& network_interface,
                                       Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::instances::v1::GetEffectiveFirewallsRequest
      request;
  request.set_project(project);
  request.set_zone(zone);
  request.set_instance(instance);
  request.set_network_interface(network_interface);
  return connection_->GetEffectiveFirewalls(request);
}

StatusOr<
    google::cloud::cpp::compute::v1::InstancesGetEffectiveFirewallsResponse>
InstancesClient::GetEffectiveFirewalls(
    google::cloud::cpp::compute::instances::v1::
        GetEffectiveFirewallsRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetEffectiveFirewalls(request);
}

StatusOr<google::cloud::cpp::compute::v1::GuestAttributes>
InstancesClient::GetGuestAttributes(std::string const& project,
                                    std::string const& zone,
                                    std::string const& instance, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::instances::v1::GetGuestAttributesRequest request;
  request.set_project(project);
  request.set_zone(zone);
  request.set_instance(instance);
  return connection_->GetGuestAttributes(request);
}

StatusOr<google::cloud::cpp::compute::v1::GuestAttributes>
InstancesClient::GetGuestAttributes(
    google::cloud::cpp::compute::instances::v1::GetGuestAttributesRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetGuestAttributes(request);
}

StatusOr<google::cloud::cpp::compute::v1::Policy> InstancesClient::GetIamPolicy(
    std::string const& project, std::string const& zone,
    std::string const& resource, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::instances::v1::GetIamPolicyRequest request;
  request.set_project(project);
  request.set_zone(zone);
  request.set_resource(resource);
  return connection_->GetIamPolicy(request);
}

StatusOr<google::cloud::cpp::compute::v1::Policy> InstancesClient::GetIamPolicy(
    google::cloud::cpp::compute::instances::v1::GetIamPolicyRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetIamPolicy(request);
}

StatusOr<google::cloud::cpp::compute::v1::Screenshot>
InstancesClient::GetScreenshot(std::string const& project,
                               std::string const& zone,
                               std::string const& instance, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::instances::v1::GetScreenshotRequest request;
  request.set_project(project);
  request.set_zone(zone);
  request.set_instance(instance);
  return connection_->GetScreenshot(request);
}

StatusOr<google::cloud::cpp::compute::v1::Screenshot>
InstancesClient::GetScreenshot(
    google::cloud::cpp::compute::instances::v1::GetScreenshotRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetScreenshot(request);
}

StatusOr<google::cloud::cpp::compute::v1::SerialPortOutput>
InstancesClient::GetSerialPortOutput(std::string const& project,
                                     std::string const& zone,
                                     std::string const& instance,
                                     Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::instances::v1::GetSerialPortOutputRequest
      request;
  request.set_project(project);
  request.set_zone(zone);
  request.set_instance(instance);
  return connection_->GetSerialPortOutput(request);
}

StatusOr<google::cloud::cpp::compute::v1::SerialPortOutput>
InstancesClient::GetSerialPortOutput(
    google::cloud::cpp::compute::instances::v1::
        GetSerialPortOutputRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetSerialPortOutput(request);
}

StatusOr<google::cloud::cpp::compute::v1::ShieldedInstanceIdentity>
InstancesClient::GetShieldedInstanceIdentity(std::string const& project,
                                             std::string const& zone,
                                             std::string const& instance,
                                             Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::instances::v1::GetShieldedInstanceIdentityRequest
      request;
  request.set_project(project);
  request.set_zone(zone);
  request.set_instance(instance);
  return connection_->GetShieldedInstanceIdentity(request);
}

StatusOr<google::cloud::cpp::compute::v1::ShieldedInstanceIdentity>
InstancesClient::GetShieldedInstanceIdentity(
    google::cloud::cpp::compute::instances::v1::
        GetShieldedInstanceIdentityRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetShieldedInstanceIdentity(request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
InstancesClient::InsertInstance(
    std::string const& project, std::string const& zone,
    google::cloud::cpp::compute::v1::Instance const& instance_resource,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::instances::v1::InsertInstanceRequest request;
  request.set_project(project);
  request.set_zone(zone);
  *request.mutable_instance_resource() = instance_resource;
  return connection_->InsertInstance(request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
InstancesClient::InsertInstance(
    google::cloud::cpp::compute::instances::v1::InsertInstanceRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->InsertInstance(request);
}

StreamRange<google::cloud::cpp::compute::v1::Instance>
InstancesClient::ListInstances(std::string const& project,
                               std::string const& zone, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::instances::v1::ListInstancesRequest request;
  request.set_project(project);
  request.set_zone(zone);
  return connection_->ListInstances(request);
}

StreamRange<google::cloud::cpp::compute::v1::Instance>
InstancesClient::ListInstances(
    google::cloud::cpp::compute::instances::v1::ListInstancesRequest request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListInstances(std::move(request));
}

StreamRange<google::cloud::cpp::compute::v1::Reference>
InstancesClient::ListReferrers(std::string const& project,
                               std::string const& zone,
                               std::string const& instance, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::instances::v1::ListReferrersRequest request;
  request.set_project(project);
  request.set_zone(zone);
  request.set_instance(instance);
  return connection_->ListReferrers(request);
}

StreamRange<google::cloud::cpp::compute::v1::Reference>
InstancesClient::ListReferrers(
    google::cloud::cpp::compute::instances::v1::ListReferrersRequest request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListReferrers(std::move(request));
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
InstancesClient::RemoveResourcePolicies(
    std::string const& project, std::string const& zone,
    std::string const& instance,
    google::cloud::cpp::compute::v1::
        InstancesRemoveResourcePoliciesRequest const&
            instances_remove_resource_policies_request_resource,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::instances::v1::RemoveResourcePoliciesRequest
      request;
  request.set_project(project);
  request.set_zone(zone);
  request.set_instance(instance);
  *request.mutable_instances_remove_resource_policies_request_resource() =
      instances_remove_resource_policies_request_resource;
  return connection_->RemoveResourcePolicies(request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
InstancesClient::RemoveResourcePolicies(
    google::cloud::cpp::compute::instances::v1::
        RemoveResourcePoliciesRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->RemoveResourcePolicies(request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
InstancesClient::Reset(std::string const& project, std::string const& zone,
                       std::string const& instance, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::instances::v1::ResetRequest request;
  request.set_project(project);
  request.set_zone(zone);
  request.set_instance(instance);
  return connection_->Reset(request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
InstancesClient::Reset(
    google::cloud::cpp::compute::instances::v1::ResetRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->Reset(request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
InstancesClient::Resume(std::string const& project, std::string const& zone,
                        std::string const& instance, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::instances::v1::ResumeRequest request;
  request.set_project(project);
  request.set_zone(zone);
  request.set_instance(instance);
  return connection_->Resume(request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
InstancesClient::Resume(
    google::cloud::cpp::compute::instances::v1::ResumeRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->Resume(request);
}

Status InstancesClient::SendDiagnosticInterrupt(std::string const& project,
                                                std::string const& zone,
                                                std::string const& instance,
                                                Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::instances::v1::SendDiagnosticInterruptRequest
      request;
  request.set_project(project);
  request.set_zone(zone);
  request.set_instance(instance);
  return connection_->SendDiagnosticInterrupt(request);
}

Status InstancesClient::SendDiagnosticInterrupt(
    google::cloud::cpp::compute::instances::v1::
        SendDiagnosticInterruptRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->SendDiagnosticInterrupt(request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
InstancesClient::SetDeletionProtection(std::string const& project,
                                       std::string const& zone,
                                       std::string const& resource,
                                       Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::instances::v1::SetDeletionProtectionRequest
      request;
  request.set_project(project);
  request.set_zone(zone);
  request.set_resource(resource);
  return connection_->SetDeletionProtection(request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
InstancesClient::SetDeletionProtection(
    google::cloud::cpp::compute::instances::v1::
        SetDeletionProtectionRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->SetDeletionProtection(request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
InstancesClient::SetDiskAutoDelete(std::string const& project,
                                   std::string const& zone,
                                   std::string const& instance,
                                   bool auto_delete,
                                   std::string const& device_name,
                                   Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::instances::v1::SetDiskAutoDeleteRequest request;
  request.set_project(project);
  request.set_zone(zone);
  request.set_instance(instance);
  request.set_auto_delete(auto_delete);
  request.set_device_name(device_name);
  return connection_->SetDiskAutoDelete(request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
InstancesClient::SetDiskAutoDelete(
    google::cloud::cpp::compute::instances::v1::SetDiskAutoDeleteRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->SetDiskAutoDelete(request);
}

StatusOr<google::cloud::cpp::compute::v1::Policy> InstancesClient::SetIamPolicy(
    std::string const& project, std::string const& zone,
    std::string const& resource,
    google::cloud::cpp::compute::v1::ZoneSetPolicyRequest const&
        zone_set_policy_request_resource,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::instances::v1::SetIamPolicyRequest request;
  request.set_project(project);
  request.set_zone(zone);
  request.set_resource(resource);
  *request.mutable_zone_set_policy_request_resource() =
      zone_set_policy_request_resource;
  return connection_->SetIamPolicy(request);
}

StatusOr<google::cloud::cpp::compute::v1::Policy> InstancesClient::SetIamPolicy(
    google::cloud::cpp::compute::instances::v1::SetIamPolicyRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->SetIamPolicy(request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
InstancesClient::SetLabels(
    std::string const& project, std::string const& zone,
    std::string const& instance,
    google::cloud::cpp::compute::v1::InstancesSetLabelsRequest const&
        instances_set_labels_request_resource,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::instances::v1::SetLabelsRequest request;
  request.set_project(project);
  request.set_zone(zone);
  request.set_instance(instance);
  *request.mutable_instances_set_labels_request_resource() =
      instances_set_labels_request_resource;
  return connection_->SetLabels(request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
InstancesClient::SetLabels(
    google::cloud::cpp::compute::instances::v1::SetLabelsRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->SetLabels(request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
InstancesClient::SetMachineResources(
    std::string const& project, std::string const& zone,
    std::string const& instance,
    google::cloud::cpp::compute::v1::InstancesSetMachineResourcesRequest const&
        instances_set_machine_resources_request_resource,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::instances::v1::SetMachineResourcesRequest
      request;
  request.set_project(project);
  request.set_zone(zone);
  request.set_instance(instance);
  *request.mutable_instances_set_machine_resources_request_resource() =
      instances_set_machine_resources_request_resource;
  return connection_->SetMachineResources(request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
InstancesClient::SetMachineResources(
    google::cloud::cpp::compute::instances::v1::
        SetMachineResourcesRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->SetMachineResources(request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
InstancesClient::SetMachineType(
    std::string const& project, std::string const& zone,
    std::string const& instance,
    google::cloud::cpp::compute::v1::InstancesSetMachineTypeRequest const&
        instances_set_machine_type_request_resource,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::instances::v1::SetMachineTypeRequest request;
  request.set_project(project);
  request.set_zone(zone);
  request.set_instance(instance);
  *request.mutable_instances_set_machine_type_request_resource() =
      instances_set_machine_type_request_resource;
  return connection_->SetMachineType(request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
InstancesClient::SetMachineType(
    google::cloud::cpp::compute::instances::v1::SetMachineTypeRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->SetMachineType(request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
InstancesClient::SetMetadata(
    std::string const& project, std::string const& zone,
    std::string const& instance,
    google::cloud::cpp::compute::v1::Metadata const& metadata_resource,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::instances::v1::SetMetadataRequest request;
  request.set_project(project);
  request.set_zone(zone);
  request.set_instance(instance);
  *request.mutable_metadata_resource() = metadata_resource;
  return connection_->SetMetadata(request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
InstancesClient::SetMetadata(
    google::cloud::cpp::compute::instances::v1::SetMetadataRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->SetMetadata(request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
InstancesClient::SetMinCpuPlatform(
    std::string const& project, std::string const& zone,
    std::string const& instance,
    google::cloud::cpp::compute::v1::InstancesSetMinCpuPlatformRequest const&
        instances_set_min_cpu_platform_request_resource,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::instances::v1::SetMinCpuPlatformRequest request;
  request.set_project(project);
  request.set_zone(zone);
  request.set_instance(instance);
  *request.mutable_instances_set_min_cpu_platform_request_resource() =
      instances_set_min_cpu_platform_request_resource;
  return connection_->SetMinCpuPlatform(request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
InstancesClient::SetMinCpuPlatform(
    google::cloud::cpp::compute::instances::v1::SetMinCpuPlatformRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->SetMinCpuPlatform(request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
InstancesClient::SetName(
    std::string const& project, std::string const& zone,
    std::string const& instance,
    google::cloud::cpp::compute::v1::InstancesSetNameRequest const&
        instances_set_name_request_resource,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::instances::v1::SetNameRequest request;
  request.set_project(project);
  request.set_zone(zone);
  request.set_instance(instance);
  *request.mutable_instances_set_name_request_resource() =
      instances_set_name_request_resource;
  return connection_->SetName(request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
InstancesClient::SetName(
    google::cloud::cpp::compute::instances::v1::SetNameRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->SetName(request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
InstancesClient::SetScheduling(
    std::string const& project, std::string const& zone,
    std::string const& instance,
    google::cloud::cpp::compute::v1::Scheduling const& scheduling_resource,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::instances::v1::SetSchedulingRequest request;
  request.set_project(project);
  request.set_zone(zone);
  request.set_instance(instance);
  *request.mutable_scheduling_resource() = scheduling_resource;
  return connection_->SetScheduling(request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
InstancesClient::SetScheduling(
    google::cloud::cpp::compute::instances::v1::SetSchedulingRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->SetScheduling(request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
InstancesClient::SetSecurityPolicy(
    std::string const& project, std::string const& zone,
    std::string const& instance,
    google::cloud::cpp::compute::v1::InstancesSetSecurityPolicyRequest const&
        instances_set_security_policy_request_resource,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::instances::v1::SetSecurityPolicyRequest request;
  request.set_project(project);
  request.set_zone(zone);
  request.set_instance(instance);
  *request.mutable_instances_set_security_policy_request_resource() =
      instances_set_security_policy_request_resource;
  return connection_->SetSecurityPolicy(request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
InstancesClient::SetSecurityPolicy(
    google::cloud::cpp::compute::instances::v1::SetSecurityPolicyRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->SetSecurityPolicy(request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
InstancesClient::SetServiceAccount(
    std::string const& project, std::string const& zone,
    std::string const& instance,
    google::cloud::cpp::compute::v1::InstancesSetServiceAccountRequest const&
        instances_set_service_account_request_resource,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::instances::v1::SetServiceAccountRequest request;
  request.set_project(project);
  request.set_zone(zone);
  request.set_instance(instance);
  *request.mutable_instances_set_service_account_request_resource() =
      instances_set_service_account_request_resource;
  return connection_->SetServiceAccount(request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
InstancesClient::SetServiceAccount(
    google::cloud::cpp::compute::instances::v1::SetServiceAccountRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->SetServiceAccount(request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
InstancesClient::SetShieldedInstanceIntegrityPolicy(
    std::string const& project, std::string const& zone,
    std::string const& instance,
    google::cloud::cpp::compute::v1::ShieldedInstanceIntegrityPolicy const&
        shielded_instance_integrity_policy_resource,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::instances::v1::
      SetShieldedInstanceIntegrityPolicyRequest request;
  request.set_project(project);
  request.set_zone(zone);
  request.set_instance(instance);
  *request.mutable_shielded_instance_integrity_policy_resource() =
      shielded_instance_integrity_policy_resource;
  return connection_->SetShieldedInstanceIntegrityPolicy(request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
InstancesClient::SetShieldedInstanceIntegrityPolicy(
    google::cloud::cpp::compute::instances::v1::
        SetShieldedInstanceIntegrityPolicyRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->SetShieldedInstanceIntegrityPolicy(request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
InstancesClient::SetTags(
    std::string const& project, std::string const& zone,
    std::string const& instance,
    google::cloud::cpp::compute::v1::Tags const& tags_resource, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::instances::v1::SetTagsRequest request;
  request.set_project(project);
  request.set_zone(zone);
  request.set_instance(instance);
  *request.mutable_tags_resource() = tags_resource;
  return connection_->SetTags(request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
InstancesClient::SetTags(
    google::cloud::cpp::compute::instances::v1::SetTagsRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->SetTags(request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
InstancesClient::SimulateMaintenanceEvent(std::string const& project,
                                          std::string const& zone,
                                          std::string const& instance,
                                          Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::instances::v1::SimulateMaintenanceEventRequest
      request;
  request.set_project(project);
  request.set_zone(zone);
  request.set_instance(instance);
  return connection_->SimulateMaintenanceEvent(request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
InstancesClient::SimulateMaintenanceEvent(
    google::cloud::cpp::compute::instances::v1::
        SimulateMaintenanceEventRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->SimulateMaintenanceEvent(request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
InstancesClient::Start(std::string const& project, std::string const& zone,
                       std::string const& instance, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::instances::v1::StartRequest request;
  request.set_project(project);
  request.set_zone(zone);
  request.set_instance(instance);
  return connection_->Start(request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
InstancesClient::Start(
    google::cloud::cpp::compute::instances::v1::StartRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->Start(request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
InstancesClient::StartWithEncryptionKey(
    std::string const& project, std::string const& zone,
    std::string const& instance,
    google::cloud::cpp::compute::v1::
        InstancesStartWithEncryptionKeyRequest const&
            instances_start_with_encryption_key_request_resource,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::instances::v1::StartWithEncryptionKeyRequest
      request;
  request.set_project(project);
  request.set_zone(zone);
  request.set_instance(instance);
  *request.mutable_instances_start_with_encryption_key_request_resource() =
      instances_start_with_encryption_key_request_resource;
  return connection_->StartWithEncryptionKey(request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
InstancesClient::StartWithEncryptionKey(
    google::cloud::cpp::compute::instances::v1::
        StartWithEncryptionKeyRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->StartWithEncryptionKey(request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
InstancesClient::Stop(std::string const& project, std::string const& zone,
                      std::string const& instance, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::instances::v1::StopRequest request;
  request.set_project(project);
  request.set_zone(zone);
  request.set_instance(instance);
  return connection_->Stop(request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
InstancesClient::Stop(
    google::cloud::cpp::compute::instances::v1::StopRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->Stop(request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
InstancesClient::Suspend(std::string const& project, std::string const& zone,
                         std::string const& instance, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::instances::v1::SuspendRequest request;
  request.set_project(project);
  request.set_zone(zone);
  request.set_instance(instance);
  return connection_->Suspend(request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
InstancesClient::Suspend(
    google::cloud::cpp::compute::instances::v1::SuspendRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->Suspend(request);
}

StatusOr<google::cloud::cpp::compute::v1::TestPermissionsResponse>
InstancesClient::TestIamPermissions(
    std::string const& project, std::string const& zone,
    std::string const& resource,
    google::cloud::cpp::compute::v1::TestPermissionsRequest const&
        test_permissions_request_resource,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::instances::v1::TestIamPermissionsRequest request;
  request.set_project(project);
  request.set_zone(zone);
  request.set_resource(resource);
  *request.mutable_test_permissions_request_resource() =
      test_permissions_request_resource;
  return connection_->TestIamPermissions(request);
}

StatusOr<google::cloud::cpp::compute::v1::TestPermissionsResponse>
InstancesClient::TestIamPermissions(
    google::cloud::cpp::compute::instances::v1::TestIamPermissionsRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->TestIamPermissions(request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
InstancesClient::UpdateInstance(
    std::string const& project, std::string const& zone,
    std::string const& instance,
    google::cloud::cpp::compute::v1::Instance const& instance_resource,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::instances::v1::UpdateInstanceRequest request;
  request.set_project(project);
  request.set_zone(zone);
  request.set_instance(instance);
  *request.mutable_instance_resource() = instance_resource;
  return connection_->UpdateInstance(request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
InstancesClient::UpdateInstance(
    google::cloud::cpp::compute::instances::v1::UpdateInstanceRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateInstance(request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
InstancesClient::UpdateAccessConfig(
    std::string const& project, std::string const& zone,
    std::string const& instance, std::string const& network_interface,
    google::cloud::cpp::compute::v1::AccessConfig const& access_config_resource,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::instances::v1::UpdateAccessConfigRequest request;
  request.set_project(project);
  request.set_zone(zone);
  request.set_instance(instance);
  request.set_network_interface(network_interface);
  *request.mutable_access_config_resource() = access_config_resource;
  return connection_->UpdateAccessConfig(request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
InstancesClient::UpdateAccessConfig(
    google::cloud::cpp::compute::instances::v1::UpdateAccessConfigRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateAccessConfig(request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
InstancesClient::UpdateDisplayDevice(
    std::string const& project, std::string const& zone,
    std::string const& instance,
    google::cloud::cpp::compute::v1::DisplayDevice const&
        display_device_resource,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::instances::v1::UpdateDisplayDeviceRequest
      request;
  request.set_project(project);
  request.set_zone(zone);
  request.set_instance(instance);
  *request.mutable_display_device_resource() = display_device_resource;
  return connection_->UpdateDisplayDevice(request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
InstancesClient::UpdateDisplayDevice(
    google::cloud::cpp::compute::instances::v1::
        UpdateDisplayDeviceRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateDisplayDevice(request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
InstancesClient::UpdateNetworkInterface(
    std::string const& project, std::string const& zone,
    std::string const& instance, std::string const& network_interface,
    google::cloud::cpp::compute::v1::NetworkInterface const&
        network_interface_resource,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::instances::v1::UpdateNetworkInterfaceRequest
      request;
  request.set_project(project);
  request.set_zone(zone);
  request.set_instance(instance);
  request.set_network_interface(network_interface);
  *request.mutable_network_interface_resource() = network_interface_resource;
  return connection_->UpdateNetworkInterface(request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
InstancesClient::UpdateNetworkInterface(
    google::cloud::cpp::compute::instances::v1::
        UpdateNetworkInterfaceRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateNetworkInterface(request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
InstancesClient::UpdateShieldedInstanceConfig(
    std::string const& project, std::string const& zone,
    std::string const& instance,
    google::cloud::cpp::compute::v1::ShieldedInstanceConfig const&
        shielded_instance_config_resource,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::instances::v1::
      UpdateShieldedInstanceConfigRequest request;
  request.set_project(project);
  request.set_zone(zone);
  request.set_instance(instance);
  *request.mutable_shielded_instance_config_resource() =
      shielded_instance_config_resource;
  return connection_->UpdateShieldedInstanceConfig(request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
InstancesClient::UpdateShieldedInstanceConfig(
    google::cloud::cpp::compute::instances::v1::
        UpdateShieldedInstanceConfigRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateShieldedInstanceConfig(request);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace compute_instances_v1
}  // namespace cloud
}  // namespace google
