// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source:
// google/cloud/compute/public_advertised_prefixes/v1/public_advertised_prefixes.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_COMPUTE_PUBLIC_ADVERTISED_PREFIXES_V1_INTERNAL_PUBLIC_ADVERTISED_PREFIXES_TRACING_CONNECTION_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_COMPUTE_PUBLIC_ADVERTISED_PREFIXES_V1_INTERNAL_PUBLIC_ADVERTISED_PREFIXES_TRACING_CONNECTION_H

#include "google/cloud/compute/public_advertised_prefixes/v1/public_advertised_prefixes_connection.h"
#include "google/cloud/version.h"
#include <memory>

namespace google {
namespace cloud {
namespace compute_public_advertised_prefixes_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

class PublicAdvertisedPrefixesTracingConnection
    : public compute_public_advertised_prefixes_v1::
          PublicAdvertisedPrefixesConnection {
 public:
  ~PublicAdvertisedPrefixesTracingConnection() override = default;

  explicit PublicAdvertisedPrefixesTracingConnection(
      std::shared_ptr<compute_public_advertised_prefixes_v1::
                          PublicAdvertisedPrefixesConnection>
          child);

  Options options() override { return child_->options(); }

  future<StatusOr<google::cloud::cpp::compute::v1::Operation>> Announce(
      google::cloud::cpp::compute::public_advertised_prefixes::v1::
          AnnounceRequest const& request) override;

  future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
  DeletePublicAdvertisedPrefix(
      google::cloud::cpp::compute::public_advertised_prefixes::v1::
          DeletePublicAdvertisedPrefixRequest const& request) override;

  StatusOr<google::cloud::cpp::compute::v1::PublicAdvertisedPrefix>
  GetPublicAdvertisedPrefix(
      google::cloud::cpp::compute::public_advertised_prefixes::v1::
          GetPublicAdvertisedPrefixRequest const& request) override;

  future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
  InsertPublicAdvertisedPrefix(
      google::cloud::cpp::compute::public_advertised_prefixes::v1::
          InsertPublicAdvertisedPrefixRequest const& request) override;

  StreamRange<google::cloud::cpp::compute::v1::PublicAdvertisedPrefix>
  ListPublicAdvertisedPrefixes(
      google::cloud::cpp::compute::public_advertised_prefixes::v1::
          ListPublicAdvertisedPrefixesRequest request) override;

  future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
  PatchPublicAdvertisedPrefix(
      google::cloud::cpp::compute::public_advertised_prefixes::v1::
          PatchPublicAdvertisedPrefixRequest const& request) override;

  future<StatusOr<google::cloud::cpp::compute::v1::Operation>> Withdraw(
      google::cloud::cpp::compute::public_advertised_prefixes::v1::
          WithdrawRequest const& request) override;

 private:
  std::shared_ptr<
      compute_public_advertised_prefixes_v1::PublicAdvertisedPrefixesConnection>
      child_;
};

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

/**
 * Conditionally applies the tracing decorator to the given connection.
 *
 * The connection is only decorated if tracing is enabled (as determined by the
 * connection's options).
 */
std::shared_ptr<
    compute_public_advertised_prefixes_v1::PublicAdvertisedPrefixesConnection>
MakePublicAdvertisedPrefixesTracingConnection(
    std::shared_ptr<compute_public_advertised_prefixes_v1::
                        PublicAdvertisedPrefixesConnection>
        conn);

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace compute_public_advertised_prefixes_v1_internal
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_COMPUTE_PUBLIC_ADVERTISED_PREFIXES_V1_INTERNAL_PUBLIC_ADVERTISED_PREFIXES_TRACING_CONNECTION_H
