// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/compute/target_pools/v1/target_pools.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_COMPUTE_TARGET_POOLS_V1_INTERNAL_TARGET_POOLS_REST_CONNECTION_IMPL_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_COMPUTE_TARGET_POOLS_V1_INTERNAL_TARGET_POOLS_REST_CONNECTION_IMPL_H

#include "google/cloud/compute/target_pools/v1/internal/target_pools_rest_stub.h"
#include "google/cloud/compute/target_pools/v1/internal/target_pools_retry_traits.h"
#include "google/cloud/compute/target_pools/v1/target_pools_connection.h"
#include "google/cloud/compute/target_pools/v1/target_pools_connection_idempotency_policy.h"
#include "google/cloud/compute/target_pools/v1/target_pools_options.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/backoff_policy.h"
#include "google/cloud/options.h"
#include "google/cloud/status_or.h"
#include "google/cloud/stream_range.h"
#include "google/cloud/version.h"
#include <google/cloud/compute/region_operations/v1/region_operations.pb.h>
#include <memory>

namespace google {
namespace cloud {
namespace compute_target_pools_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

class TargetPoolsRestConnectionImpl
    : public compute_target_pools_v1::TargetPoolsConnection {
 public:
  ~TargetPoolsRestConnectionImpl() override = default;

  TargetPoolsRestConnectionImpl(
      std::unique_ptr<google::cloud::BackgroundThreads> background,
      std::shared_ptr<compute_target_pools_v1_internal::TargetPoolsRestStub>
          stub,
      Options options);

  Options options() override { return options_; }

  future<StatusOr<google::cloud::cpp::compute::v1::Operation>> AddHealthCheck(
      google::cloud::cpp::compute::target_pools::v1::
          AddHealthCheckRequest const& request) override;

  future<StatusOr<google::cloud::cpp::compute::v1::Operation>> AddInstance(
      google::cloud::cpp::compute::target_pools::v1::AddInstanceRequest const&
          request) override;

  StreamRange<std::pair<std::string,
                        google::cloud::cpp::compute::v1::TargetPoolsScopedList>>
  AggregatedListTargetPools(
      google::cloud::cpp::compute::target_pools::v1::
          AggregatedListTargetPoolsRequest request) override;

  future<StatusOr<google::cloud::cpp::compute::v1::Operation>> DeleteTargetPool(
      google::cloud::cpp::compute::target_pools::v1::
          DeleteTargetPoolRequest const& request) override;

  StatusOr<google::cloud::cpp::compute::v1::TargetPool> GetTargetPool(
      google::cloud::cpp::compute::target_pools::v1::GetTargetPoolRequest const&
          request) override;

  StatusOr<google::cloud::cpp::compute::v1::TargetPoolInstanceHealth> GetHealth(
      google::cloud::cpp::compute::target_pools::v1::GetHealthRequest const&
          request) override;

  future<StatusOr<google::cloud::cpp::compute::v1::Operation>> InsertTargetPool(
      google::cloud::cpp::compute::target_pools::v1::
          InsertTargetPoolRequest const& request) override;

  StreamRange<google::cloud::cpp::compute::v1::TargetPool> ListTargetPools(
      google::cloud::cpp::compute::target_pools::v1::ListTargetPoolsRequest
          request) override;

  future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
  RemoveHealthCheck(google::cloud::cpp::compute::target_pools::v1::
                        RemoveHealthCheckRequest const& request) override;

  future<StatusOr<google::cloud::cpp::compute::v1::Operation>> RemoveInstance(
      google::cloud::cpp::compute::target_pools::v1::
          RemoveInstanceRequest const& request) override;

  future<StatusOr<google::cloud::cpp::compute::v1::Operation>> SetBackup(
      google::cloud::cpp::compute::target_pools::v1::SetBackupRequest const&
          request) override;

  future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
  SetSecurityPolicy(google::cloud::cpp::compute::target_pools::v1::
                        SetSecurityPolicyRequest const& request) override;

 private:
  static std::unique_ptr<compute_target_pools_v1::TargetPoolsRetryPolicy>
  retry_policy(Options const& options) {
    return options.get<compute_target_pools_v1::TargetPoolsRetryPolicyOption>()
        ->clone();
  }

  static std::unique_ptr<BackoffPolicy> backoff_policy(Options const& options) {
    return options
        .get<compute_target_pools_v1::TargetPoolsBackoffPolicyOption>()
        ->clone();
  }

  static std::unique_ptr<
      compute_target_pools_v1::TargetPoolsConnectionIdempotencyPolicy>
  idempotency_policy(Options const& options) {
    return options
        .get<compute_target_pools_v1::
                 TargetPoolsConnectionIdempotencyPolicyOption>()
        ->clone();
  }

  static std::unique_ptr<PollingPolicy> polling_policy(Options const& options) {
    return options
        .get<compute_target_pools_v1::TargetPoolsPollingPolicyOption>()
        ->clone();
  }

  std::unique_ptr<google::cloud::BackgroundThreads> background_;
  std::shared_ptr<compute_target_pools_v1_internal::TargetPoolsRestStub> stub_;
  Options options_;
};

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace compute_target_pools_v1_internal
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_COMPUTE_TARGET_POOLS_V1_INTERNAL_TARGET_POOLS_REST_CONNECTION_IMPL_H
