// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/dialogflow/cx/v3/agent.proto

#include "google/cloud/dialogflow_cx/internal/agents_tracing_stub.h"
#include "google/cloud/internal/grpc_opentelemetry.h"

namespace google {
namespace cloud {
namespace dialogflow_cx_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

AgentsTracingStub::AgentsTracingStub(std::shared_ptr<AgentsStub> child)
    : child_(std::move(child)), propagator_(internal::MakePropagator()) {}

StatusOr<google::cloud::dialogflow::cx::v3::ListAgentsResponse>
AgentsTracingStub::ListAgents(
    grpc::ClientContext& context,
    google::cloud::dialogflow::cx::v3::ListAgentsRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.dialogflow.cx.v3.Agents",
                                     "ListAgents");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->ListAgents(context, request));
}

StatusOr<google::cloud::dialogflow::cx::v3::Agent> AgentsTracingStub::GetAgent(
    grpc::ClientContext& context,
    google::cloud::dialogflow::cx::v3::GetAgentRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.dialogflow.cx.v3.Agents",
                                     "GetAgent");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span, child_->GetAgent(context, request));
}

StatusOr<google::cloud::dialogflow::cx::v3::Agent>
AgentsTracingStub::CreateAgent(
    grpc::ClientContext& context,
    google::cloud::dialogflow::cx::v3::CreateAgentRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.dialogflow.cx.v3.Agents",
                                     "CreateAgent");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->CreateAgent(context, request));
}

StatusOr<google::cloud::dialogflow::cx::v3::Agent>
AgentsTracingStub::UpdateAgent(
    grpc::ClientContext& context,
    google::cloud::dialogflow::cx::v3::UpdateAgentRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.dialogflow.cx.v3.Agents",
                                     "UpdateAgent");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->UpdateAgent(context, request));
}

Status AgentsTracingStub::DeleteAgent(
    grpc::ClientContext& context,
    google::cloud::dialogflow::cx::v3::DeleteAgentRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.dialogflow.cx.v3.Agents",
                                     "DeleteAgent");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->DeleteAgent(context, request));
}

future<StatusOr<google::longrunning::Operation>>
AgentsTracingStub::AsyncExportAgent(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context, Options const& options,
    google::cloud::dialogflow::cx::v3::ExportAgentRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.dialogflow.cx.v3.Agents",
                                     "ExportAgent");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f = child_->AsyncExportAgent(cq, context, options, request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

future<StatusOr<google::longrunning::Operation>>
AgentsTracingStub::AsyncRestoreAgent(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context, Options const& options,
    google::cloud::dialogflow::cx::v3::RestoreAgentRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.dialogflow.cx.v3.Agents",
                                     "RestoreAgent");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f = child_->AsyncRestoreAgent(cq, context, options, request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

StatusOr<google::cloud::dialogflow::cx::v3::AgentValidationResult>
AgentsTracingStub::ValidateAgent(
    grpc::ClientContext& context,
    google::cloud::dialogflow::cx::v3::ValidateAgentRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.dialogflow.cx.v3.Agents",
                                     "ValidateAgent");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->ValidateAgent(context, request));
}

StatusOr<google::cloud::dialogflow::cx::v3::AgentValidationResult>
AgentsTracingStub::GetAgentValidationResult(
    grpc::ClientContext& context,
    google::cloud::dialogflow::cx::v3::GetAgentValidationResultRequest const&
        request) {
  auto span = internal::MakeSpanGrpc("google.cloud.dialogflow.cx.v3.Agents",
                                     "GetAgentValidationResult");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->GetAgentValidationResult(context, request));
}

StatusOr<google::cloud::dialogflow::cx::v3::GenerativeSettings>
AgentsTracingStub::GetGenerativeSettings(
    grpc::ClientContext& context,
    google::cloud::dialogflow::cx::v3::GetGenerativeSettingsRequest const&
        request) {
  auto span = internal::MakeSpanGrpc("google.cloud.dialogflow.cx.v3.Agents",
                                     "GetGenerativeSettings");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->GetGenerativeSettings(context, request));
}

StatusOr<google::cloud::dialogflow::cx::v3::GenerativeSettings>
AgentsTracingStub::UpdateGenerativeSettings(
    grpc::ClientContext& context,
    google::cloud::dialogflow::cx::v3::UpdateGenerativeSettingsRequest const&
        request) {
  auto span = internal::MakeSpanGrpc("google.cloud.dialogflow.cx.v3.Agents",
                                     "UpdateGenerativeSettings");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->UpdateGenerativeSettings(context, request));
}

future<StatusOr<google::longrunning::Operation>>
AgentsTracingStub::AsyncGetOperation(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context, Options const& options,
    google::longrunning::GetOperationRequest const& request) {
  auto span =
      internal::MakeSpanGrpc("google.longrunning.Operations", "GetOperation");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f = child_->AsyncGetOperation(cq, context, options, request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

future<Status> AgentsTracingStub::AsyncCancelOperation(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context, Options const& options,
    google::longrunning::CancelOperationRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.longrunning.Operations",
                                     "CancelOperation");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f = child_->AsyncCancelOperation(cq, context, options, request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

std::shared_ptr<AgentsStub> MakeAgentsTracingStub(
    std::shared_ptr<AgentsStub> stub) {
#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  return std::make_shared<AgentsTracingStub>(std::move(stub));
#else
  return stub;
#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace dialogflow_cx_internal
}  // namespace cloud
}  // namespace google
