// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/domains/v1/domains.proto

#include "google/cloud/domains/v1/internal/domains_stub.h"
#include "google/cloud/grpc_error_delegate.h"
#include "google/cloud/status_or.h"
#include <google/cloud/domains/v1/domains.grpc.pb.h>
#include <google/longrunning/operations.grpc.pb.h>
#include <memory>

namespace google {
namespace cloud {
namespace domains_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

DomainsStub::~DomainsStub() = default;

StatusOr<google::cloud::domains::v1::SearchDomainsResponse>
DefaultDomainsStub::SearchDomains(
    grpc::ClientContext& context,
    google::cloud::domains::v1::SearchDomainsRequest const& request) {
  google::cloud::domains::v1::SearchDomainsResponse response;
  auto status = grpc_stub_->SearchDomains(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

StatusOr<google::cloud::domains::v1::RetrieveRegisterParametersResponse>
DefaultDomainsStub::RetrieveRegisterParameters(
    grpc::ClientContext& context,
    google::cloud::domains::v1::RetrieveRegisterParametersRequest const&
        request) {
  google::cloud::domains::v1::RetrieveRegisterParametersResponse response;
  auto status =
      grpc_stub_->RetrieveRegisterParameters(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

future<StatusOr<google::longrunning::Operation>>
DefaultDomainsStub::AsyncRegisterDomain(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context, Options const&,
    google::cloud::domains::v1::RegisterDomainRequest const& request) {
  return internal::MakeUnaryRpcImpl<
      google::cloud::domains::v1::RegisterDomainRequest,
      google::longrunning::Operation>(
      cq,
      [this](grpc::ClientContext* context,
             google::cloud::domains::v1::RegisterDomainRequest const& request,
             grpc::CompletionQueue* cq) {
        return grpc_stub_->AsyncRegisterDomain(context, request, cq);
      },
      request, std::move(context));
}

StatusOr<google::cloud::domains::v1::RetrieveTransferParametersResponse>
DefaultDomainsStub::RetrieveTransferParameters(
    grpc::ClientContext& context,
    google::cloud::domains::v1::RetrieveTransferParametersRequest const&
        request) {
  google::cloud::domains::v1::RetrieveTransferParametersResponse response;
  auto status =
      grpc_stub_->RetrieveTransferParameters(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

future<StatusOr<google::longrunning::Operation>>
DefaultDomainsStub::AsyncTransferDomain(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context, Options const&,
    google::cloud::domains::v1::TransferDomainRequest const& request) {
  return internal::MakeUnaryRpcImpl<
      google::cloud::domains::v1::TransferDomainRequest,
      google::longrunning::Operation>(
      cq,
      [this](grpc::ClientContext* context,
             google::cloud::domains::v1::TransferDomainRequest const& request,
             grpc::CompletionQueue* cq) {
        return grpc_stub_->AsyncTransferDomain(context, request, cq);
      },
      request, std::move(context));
}

StatusOr<google::cloud::domains::v1::ListRegistrationsResponse>
DefaultDomainsStub::ListRegistrations(
    grpc::ClientContext& context,
    google::cloud::domains::v1::ListRegistrationsRequest const& request) {
  google::cloud::domains::v1::ListRegistrationsResponse response;
  auto status = grpc_stub_->ListRegistrations(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

StatusOr<google::cloud::domains::v1::Registration>
DefaultDomainsStub::GetRegistration(
    grpc::ClientContext& context,
    google::cloud::domains::v1::GetRegistrationRequest const& request) {
  google::cloud::domains::v1::Registration response;
  auto status = grpc_stub_->GetRegistration(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

future<StatusOr<google::longrunning::Operation>>
DefaultDomainsStub::AsyncUpdateRegistration(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context, Options const&,
    google::cloud::domains::v1::UpdateRegistrationRequest const& request) {
  return internal::MakeUnaryRpcImpl<
      google::cloud::domains::v1::UpdateRegistrationRequest,
      google::longrunning::Operation>(
      cq,
      [this](
          grpc::ClientContext* context,
          google::cloud::domains::v1::UpdateRegistrationRequest const& request,
          grpc::CompletionQueue* cq) {
        return grpc_stub_->AsyncUpdateRegistration(context, request, cq);
      },
      request, std::move(context));
}

future<StatusOr<google::longrunning::Operation>>
DefaultDomainsStub::AsyncConfigureManagementSettings(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context, Options const&,
    google::cloud::domains::v1::ConfigureManagementSettingsRequest const&
        request) {
  return internal::MakeUnaryRpcImpl<
      google::cloud::domains::v1::ConfigureManagementSettingsRequest,
      google::longrunning::Operation>(
      cq,
      [this](
          grpc::ClientContext* context,
          google::cloud::domains::v1::ConfigureManagementSettingsRequest const&
              request,
          grpc::CompletionQueue* cq) {
        return grpc_stub_->AsyncConfigureManagementSettings(context, request,
                                                            cq);
      },
      request, std::move(context));
}

future<StatusOr<google::longrunning::Operation>>
DefaultDomainsStub::AsyncConfigureDnsSettings(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context, Options const&,
    google::cloud::domains::v1::ConfigureDnsSettingsRequest const& request) {
  return internal::MakeUnaryRpcImpl<
      google::cloud::domains::v1::ConfigureDnsSettingsRequest,
      google::longrunning::Operation>(
      cq,
      [this](grpc::ClientContext* context,
             google::cloud::domains::v1::ConfigureDnsSettingsRequest const&
                 request,
             grpc::CompletionQueue* cq) {
        return grpc_stub_->AsyncConfigureDnsSettings(context, request, cq);
      },
      request, std::move(context));
}

future<StatusOr<google::longrunning::Operation>>
DefaultDomainsStub::AsyncConfigureContactSettings(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context, Options const&,
    google::cloud::domains::v1::ConfigureContactSettingsRequest const&
        request) {
  return internal::MakeUnaryRpcImpl<
      google::cloud::domains::v1::ConfigureContactSettingsRequest,
      google::longrunning::Operation>(
      cq,
      [this](grpc::ClientContext* context,
             google::cloud::domains::v1::ConfigureContactSettingsRequest const&
                 request,
             grpc::CompletionQueue* cq) {
        return grpc_stub_->AsyncConfigureContactSettings(context, request, cq);
      },
      request, std::move(context));
}

future<StatusOr<google::longrunning::Operation>>
DefaultDomainsStub::AsyncExportRegistration(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context, Options const&,
    google::cloud::domains::v1::ExportRegistrationRequest const& request) {
  return internal::MakeUnaryRpcImpl<
      google::cloud::domains::v1::ExportRegistrationRequest,
      google::longrunning::Operation>(
      cq,
      [this](
          grpc::ClientContext* context,
          google::cloud::domains::v1::ExportRegistrationRequest const& request,
          grpc::CompletionQueue* cq) {
        return grpc_stub_->AsyncExportRegistration(context, request, cq);
      },
      request, std::move(context));
}

future<StatusOr<google::longrunning::Operation>>
DefaultDomainsStub::AsyncDeleteRegistration(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context, Options const&,
    google::cloud::domains::v1::DeleteRegistrationRequest const& request) {
  return internal::MakeUnaryRpcImpl<
      google::cloud::domains::v1::DeleteRegistrationRequest,
      google::longrunning::Operation>(
      cq,
      [this](
          grpc::ClientContext* context,
          google::cloud::domains::v1::DeleteRegistrationRequest const& request,
          grpc::CompletionQueue* cq) {
        return grpc_stub_->AsyncDeleteRegistration(context, request, cq);
      },
      request, std::move(context));
}

StatusOr<google::cloud::domains::v1::AuthorizationCode>
DefaultDomainsStub::RetrieveAuthorizationCode(
    grpc::ClientContext& context,
    google::cloud::domains::v1::RetrieveAuthorizationCodeRequest const&
        request) {
  google::cloud::domains::v1::AuthorizationCode response;
  auto status =
      grpc_stub_->RetrieveAuthorizationCode(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

StatusOr<google::cloud::domains::v1::AuthorizationCode>
DefaultDomainsStub::ResetAuthorizationCode(
    grpc::ClientContext& context,
    google::cloud::domains::v1::ResetAuthorizationCodeRequest const& request) {
  google::cloud::domains::v1::AuthorizationCode response;
  auto status =
      grpc_stub_->ResetAuthorizationCode(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

future<StatusOr<google::longrunning::Operation>>
DefaultDomainsStub::AsyncGetOperation(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context, Options const&,
    google::longrunning::GetOperationRequest const& request) {
  return internal::MakeUnaryRpcImpl<google::longrunning::GetOperationRequest,
                                    google::longrunning::Operation>(
      cq,
      [this](grpc::ClientContext* context,
             google::longrunning::GetOperationRequest const& request,
             grpc::CompletionQueue* cq) {
        return operations_->AsyncGetOperation(context, request, cq);
      },
      request, std::move(context));
}

future<Status> DefaultDomainsStub::AsyncCancelOperation(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context, Options const&,
    google::longrunning::CancelOperationRequest const& request) {
  return internal::MakeUnaryRpcImpl<google::longrunning::CancelOperationRequest,
                                    google::protobuf::Empty>(
             cq,
             [this](grpc::ClientContext* context,
                    google::longrunning::CancelOperationRequest const& request,
                    grpc::CompletionQueue* cq) {
               return operations_->AsyncCancelOperation(context, request, cq);
             },
             request, std::move(context))
      .then([](future<StatusOr<google::protobuf::Empty>> f) {
        return f.get().status();
      });
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace domains_v1_internal
}  // namespace cloud
}  // namespace google
