// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/functions/v2/functions.proto

#include "google/cloud/functions/v2/internal/function_connection_impl.h"
#include "google/cloud/functions/v2/internal/function_option_defaults.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/common_options.h"
#include "google/cloud/grpc_options.h"
#include "google/cloud/internal/async_long_running_operation.h"
#include "google/cloud/internal/pagination_range.h"
#include "google/cloud/internal/retry_loop.h"
#include <memory>

namespace google {
namespace cloud {
namespace functions_v2_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN
namespace {

std::unique_ptr<functions_v2::FunctionServiceRetryPolicy> retry_policy(
    Options const& options) {
  return options.get<functions_v2::FunctionServiceRetryPolicyOption>()->clone();
}

std::unique_ptr<BackoffPolicy> backoff_policy(Options const& options) {
  return options.get<functions_v2::FunctionServiceBackoffPolicyOption>()
      ->clone();
}

std::unique_ptr<functions_v2::FunctionServiceConnectionIdempotencyPolicy>
idempotency_policy(Options const& options) {
  return options
      .get<functions_v2::FunctionServiceConnectionIdempotencyPolicyOption>()
      ->clone();
}

std::unique_ptr<PollingPolicy> polling_policy(Options const& options) {
  return options.get<functions_v2::FunctionServicePollingPolicyOption>()
      ->clone();
}

}  // namespace

FunctionServiceConnectionImpl::FunctionServiceConnectionImpl(
    std::unique_ptr<google::cloud::BackgroundThreads> background,
    std::shared_ptr<functions_v2_internal::FunctionServiceStub> stub,
    Options options)
    : background_(std::move(background)),
      stub_(std::move(stub)),
      options_(internal::MergeOptions(std::move(options),
                                      FunctionServiceConnection::options())) {}

StatusOr<google::cloud::functions::v2::Function>
FunctionServiceConnectionImpl::GetFunction(
    google::cloud::functions::v2::GetFunctionRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->GetFunction(request),
      [this](grpc::ClientContext& context,
             google::cloud::functions::v2::GetFunctionRequest const& request) {
        return stub_->GetFunction(context, request);
      },
      request, __func__);
}

StreamRange<google::cloud::functions::v2::Function>
FunctionServiceConnectionImpl::ListFunctions(
    google::cloud::functions::v2::ListFunctionsRequest request) {
  request.clear_page_token();
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto idempotency = idempotency_policy(*current)->ListFunctions(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::cloud::functions::v2::Function>>(
      std::move(request),
      [idempotency, function_name, stub = stub_,
       retry = std::shared_ptr<functions_v2::FunctionServiceRetryPolicy>(
           retry_policy(*current)),
       backoff = std::shared_ptr<BackoffPolicy>(backoff_policy(*current))](
          google::cloud::functions::v2::ListFunctionsRequest const& r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](grpc::ClientContext& context,
                   google::cloud::functions::v2::ListFunctionsRequest const&
                       request) {
              return stub->ListFunctions(context, request);
            },
            r, function_name);
      },
      [](google::cloud::functions::v2::ListFunctionsResponse r) {
        std::vector<google::cloud::functions::v2::Function> result(
            r.functions().size());
        auto& messages = *r.mutable_functions();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

future<StatusOr<google::cloud::functions::v2::Function>>
FunctionServiceConnectionImpl::CreateFunction(
    google::cloud::functions::v2::CreateFunctionRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::functions::v2::Function>(
      background_->cq(), current, request,
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::cloud::functions::v2::CreateFunctionRequest const& request) {
        return stub->AsyncCreateFunction(cq, std::move(context), options,
                                         request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     Options const& options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context), options,
                                       request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context), options,
                                          request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::functions::v2::Function>,
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->CreateFunction(request),
      polling_policy(*current), __func__);
}

future<StatusOr<google::cloud::functions::v2::Function>>
FunctionServiceConnectionImpl::UpdateFunction(
    google::cloud::functions::v2::UpdateFunctionRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::functions::v2::Function>(
      background_->cq(), current, request,
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::cloud::functions::v2::UpdateFunctionRequest const& request) {
        return stub->AsyncUpdateFunction(cq, std::move(context), options,
                                         request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     Options const& options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context), options,
                                       request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context), options,
                                          request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::functions::v2::Function>,
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->UpdateFunction(request),
      polling_policy(*current), __func__);
}

future<StatusOr<google::cloud::functions::v2::OperationMetadata>>
FunctionServiceConnectionImpl::DeleteFunction(
    google::cloud::functions::v2::DeleteFunctionRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::functions::v2::OperationMetadata>(
      background_->cq(), current, request,
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::cloud::functions::v2::DeleteFunctionRequest const& request) {
        return stub->AsyncDeleteFunction(cq, std::move(context), options,
                                         request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     Options const& options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context), options,
                                       request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context), options,
                                          request);
      },
      &google::cloud::internal::ExtractLongRunningResultMetadata<
          google::cloud::functions::v2::OperationMetadata>,
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->DeleteFunction(request),
      polling_policy(*current), __func__);
}

StatusOr<google::cloud::functions::v2::GenerateUploadUrlResponse>
FunctionServiceConnectionImpl::GenerateUploadUrl(
    google::cloud::functions::v2::GenerateUploadUrlRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->GenerateUploadUrl(request),
      [this](grpc::ClientContext& context,
             google::cloud::functions::v2::GenerateUploadUrlRequest const&
                 request) {
        return stub_->GenerateUploadUrl(context, request);
      },
      request, __func__);
}

StatusOr<google::cloud::functions::v2::GenerateDownloadUrlResponse>
FunctionServiceConnectionImpl::GenerateDownloadUrl(
    google::cloud::functions::v2::GenerateDownloadUrlRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->GenerateDownloadUrl(request),
      [this](grpc::ClientContext& context,
             google::cloud::functions::v2::GenerateDownloadUrlRequest const&
                 request) {
        return stub_->GenerateDownloadUrl(context, request);
      },
      request, __func__);
}

StatusOr<google::cloud::functions::v2::ListRuntimesResponse>
FunctionServiceConnectionImpl::ListRuntimes(
    google::cloud::functions::v2::ListRuntimesRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->ListRuntimes(request),
      [this](grpc::ClientContext& context,
             google::cloud::functions::v2::ListRuntimesRequest const& request) {
        return stub_->ListRuntimes(context, request);
      },
      request, __func__);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace functions_v2_internal
}  // namespace cloud
}  // namespace google
