// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/logging/v2/logging_config.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_LOGGING_V2_CONFIG_SERVICE_V2_CLIENT_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_LOGGING_V2_CONFIG_SERVICE_V2_CLIENT_H

#include "google/cloud/logging/v2/config_service_v2_connection.h"
#include "google/cloud/future.h"
#include "google/cloud/options.h"
#include "google/cloud/polling_policy.h"
#include "google/cloud/status_or.h"
#include "google/cloud/version.h"
#include <google/longrunning/operations.grpc.pb.h>
#include <memory>

namespace google {
namespace cloud {
namespace logging_v2 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

///
/// Service for configuring sinks used to route log entries.
///
/// @par Equality
///
/// Instances of this class created via copy-construction or copy-assignment
/// always compare equal. Instances created with equal
/// `std::shared_ptr<*Connection>` objects compare equal. Objects that compare
/// equal share the same underlying resources.
///
/// @par Performance
///
/// Creating a new instance of this class is a relatively expensive operation,
/// new objects establish new connections to the service. In contrast,
/// copy-construction, move-construction, and the corresponding assignment
/// operations are relatively efficient as the copies share all underlying
/// resources.
///
/// @par Thread Safety
///
/// Concurrent access to different instances of this class, even if they compare
/// equal, is guaranteed to work. Two or more threads operating on the same
/// instance of this class is not guaranteed to work. Since copy-construction
/// and move-construction is a relatively efficient operation, consider using
/// such a copy when using this class from multiple threads.
///
class ConfigServiceV2Client {
 public:
  explicit ConfigServiceV2Client(
      std::shared_ptr<ConfigServiceV2Connection> connection, Options opts = {});
  ~ConfigServiceV2Client();

  ///@{
  /// @name Copy and move support
  ConfigServiceV2Client(ConfigServiceV2Client const&) = default;
  ConfigServiceV2Client& operator=(ConfigServiceV2Client const&) = default;
  ConfigServiceV2Client(ConfigServiceV2Client&&) = default;
  ConfigServiceV2Client& operator=(ConfigServiceV2Client&&) = default;
  ///@}

  ///@{
  /// @name Equality
  friend bool operator==(ConfigServiceV2Client const& a,
                         ConfigServiceV2Client const& b) {
    return a.connection_ == b.connection_;
  }
  friend bool operator!=(ConfigServiceV2Client const& a,
                         ConfigServiceV2Client const& b) {
    return !(a == b);
  }
  ///@}

  // clang-format off
  ///
  /// Lists log buckets.
  ///
  /// @param parent  Required. The parent resource whose buckets are to be listed:
  ///  @n
  ///      "projects/[PROJECT_ID]/locations/[LOCATION_ID]"
  ///      "organizations/[ORGANIZATION_ID]/locations/[LOCATION_ID]"
  ///      "billingAccounts/[BILLING_ACCOUNT_ID]/locations/[LOCATION_ID]"
  ///      "folders/[FOLDER_ID]/locations/[LOCATION_ID]"
  ///  @n
  ///  Note: The locations portion of the resource must be specified, but
  ///  supplying the character `-` in place of [LOCATION_ID] will return all
  ///  buckets.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.logging.v2.LogBucket], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.logging.v2.ListBucketsRequest]: @googleapis_reference_link{google/logging/v2/logging_config.proto#L1142}
  /// [google.logging.v2.LogBucket]: @googleapis_reference_link{google/logging/v2/logging_config.proto#L801}
  ///
  // clang-format on
  StreamRange<google::logging::v2::LogBucket> ListBuckets(
      std::string const& parent, Options opts = {});

  // clang-format off
  ///
  /// Lists log buckets.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.logging.v2.ListBucketsRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.logging.v2.LogBucket], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.logging.v2.ListBucketsRequest]: @googleapis_reference_link{google/logging/v2/logging_config.proto#L1142}
  /// [google.logging.v2.LogBucket]: @googleapis_reference_link{google/logging/v2/logging_config.proto#L801}
  ///
  // clang-format on
  StreamRange<google::logging::v2::LogBucket> ListBuckets(
      google::logging::v2::ListBucketsRequest request, Options opts = {});

  // clang-format off
  ///
  /// Gets a log bucket.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.logging.v2.GetBucketRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.logging.v2.LogBucket])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.logging.v2.GetBucketRequest]: @googleapis_reference_link{google/logging/v2/logging_config.proto#L1245}
  /// [google.logging.v2.LogBucket]: @googleapis_reference_link{google/logging/v2/logging_config.proto#L801}
  ///
  // clang-format on
  StatusOr<google::logging::v2::LogBucket> GetBucket(
      google::logging::v2::GetBucketRequest const& request, Options opts = {});

  // clang-format off
  ///
  /// Creates a log bucket asynchronously that can be used to store log entries.
  ///
  /// After a bucket has been created, the bucket's location cannot be changed.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.logging.v2.CreateBucketRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.logging.v2.LogBucket] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.logging.v2.CreateBucketRequest]: @googleapis_reference_link{google/logging/v2/logging_config.proto#L1184}
  /// [google.logging.v2.LogBucket]: @googleapis_reference_link{google/logging/v2/logging_config.proto#L801}
  ///
  // clang-format on
  future<StatusOr<google::logging::v2::LogBucket>> CreateBucketAsync(
      google::logging::v2::CreateBucketRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Updates a log bucket asynchronously.
  ///
  /// If the bucket has a `lifecycle_state` of `DELETE_REQUESTED`, then
  /// `FAILED_PRECONDITION` will be returned.
  ///
  /// After a bucket has been created, the bucket's location cannot be changed.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.logging.v2.UpdateBucketRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.logging.v2.LogBucket] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.logging.v2.LogBucket]: @googleapis_reference_link{google/logging/v2/logging_config.proto#L801}
  /// [google.logging.v2.UpdateBucketRequest]: @googleapis_reference_link{google/logging/v2/logging_config.proto#L1211}
  ///
  // clang-format on
  future<StatusOr<google::logging::v2::LogBucket>> UpdateBucketAsync(
      google::logging::v2::UpdateBucketRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Creates a log bucket that can be used to store log entries. After a bucket
  /// has been created, the bucket's location cannot be changed.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.logging.v2.CreateBucketRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.logging.v2.LogBucket])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.logging.v2.CreateBucketRequest]: @googleapis_reference_link{google/logging/v2/logging_config.proto#L1184}
  /// [google.logging.v2.LogBucket]: @googleapis_reference_link{google/logging/v2/logging_config.proto#L801}
  ///
  // clang-format on
  StatusOr<google::logging::v2::LogBucket> CreateBucket(
      google::logging::v2::CreateBucketRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Updates a log bucket.
  ///
  /// If the bucket has a `lifecycle_state` of `DELETE_REQUESTED`, then
  /// `FAILED_PRECONDITION` will be returned.
  ///
  /// After a bucket has been created, the bucket's location cannot be changed.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.logging.v2.UpdateBucketRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.logging.v2.LogBucket])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.logging.v2.LogBucket]: @googleapis_reference_link{google/logging/v2/logging_config.proto#L801}
  /// [google.logging.v2.UpdateBucketRequest]: @googleapis_reference_link{google/logging/v2/logging_config.proto#L1211}
  ///
  // clang-format on
  StatusOr<google::logging::v2::LogBucket> UpdateBucket(
      google::logging::v2::UpdateBucketRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Deletes a log bucket.
  ///
  /// Changes the bucket's `lifecycle_state` to the `DELETE_REQUESTED` state.
  /// After 7 days, the bucket will be purged and all log entries in the bucket
  /// will be permanently deleted.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.logging.v2.DeleteBucketRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [`Status`] object. If the request failed, the
  ///     status contains the details of the failure.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.logging.v2.DeleteBucketRequest]: @googleapis_reference_link{google/logging/v2/logging_config.proto#L1265}
  ///
  // clang-format on
  Status DeleteBucket(google::logging::v2::DeleteBucketRequest const& request,
                      Options opts = {});

  // clang-format off
  ///
  /// Undeletes a log bucket. A bucket that has been deleted can be undeleted
  /// within the grace period of 7 days.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.logging.v2.UndeleteBucketRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [`Status`] object. If the request failed, the
  ///     status contains the details of the failure.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.logging.v2.UndeleteBucketRequest]: @googleapis_reference_link{google/logging/v2/logging_config.proto#L1285}
  ///
  // clang-format on
  Status UndeleteBucket(
      google::logging::v2::UndeleteBucketRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Lists views on a log bucket.
  ///
  /// @param parent  Required. The bucket whose views are to be listed:
  ///  @n
  ///      "projects/[PROJECT_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]"
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.logging.v2.LogView], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.logging.v2.ListViewsRequest]: @googleapis_reference_link{google/logging/v2/logging_config.proto#L1305}
  /// [google.logging.v2.LogView]: @googleapis_reference_link{google/logging/v2/logging_config.proto#L879}
  ///
  // clang-format on
  StreamRange<google::logging::v2::LogView> ListViews(std::string const& parent,
                                                      Options opts = {});

  // clang-format off
  ///
  /// Lists views on a log bucket.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.logging.v2.ListViewsRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.logging.v2.LogView], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.logging.v2.ListViewsRequest]: @googleapis_reference_link{google/logging/v2/logging_config.proto#L1305}
  /// [google.logging.v2.LogView]: @googleapis_reference_link{google/logging/v2/logging_config.proto#L879}
  ///
  // clang-format on
  StreamRange<google::logging::v2::LogView> ListViews(
      google::logging::v2::ListViewsRequest request, Options opts = {});

  // clang-format off
  ///
  /// Gets a view on a log bucket.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.logging.v2.GetViewRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.logging.v2.LogView])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.logging.v2.GetViewRequest]: @googleapis_reference_link{google/logging/v2/logging_config.proto#L1382}
  /// [google.logging.v2.LogView]: @googleapis_reference_link{google/logging/v2/logging_config.proto#L879}
  ///
  // clang-format on
  StatusOr<google::logging::v2::LogView> GetView(
      google::logging::v2::GetViewRequest const& request, Options opts = {});

  // clang-format off
  ///
  /// Creates a view over log entries in a log bucket. A bucket may contain a
  /// maximum of 30 views.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.logging.v2.CreateViewRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.logging.v2.LogView])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.logging.v2.CreateViewRequest]: @googleapis_reference_link{google/logging/v2/logging_config.proto#L1336}
  /// [google.logging.v2.LogView]: @googleapis_reference_link{google/logging/v2/logging_config.proto#L879}
  ///
  // clang-format on
  StatusOr<google::logging::v2::LogView> CreateView(
      google::logging::v2::CreateViewRequest const& request, Options opts = {});

  // clang-format off
  ///
  /// Updates a view on a log bucket. This method replaces the following fields
  /// in the existing view with values from the new view: `filter`.
  /// If an `UNAVAILABLE` error is returned, this indicates that system is not in
  /// a state where it can update the view. If this occurs, please try again in a
  /// few minutes.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.logging.v2.UpdateViewRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.logging.v2.LogView])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.logging.v2.LogView]: @googleapis_reference_link{google/logging/v2/logging_config.proto#L879}
  /// [google.logging.v2.UpdateViewRequest]: @googleapis_reference_link{google/logging/v2/logging_config.proto#L1356}
  ///
  // clang-format on
  StatusOr<google::logging::v2::LogView> UpdateView(
      google::logging::v2::UpdateViewRequest const& request, Options opts = {});

  // clang-format off
  ///
  /// Deletes a view on a log bucket.
  /// If an `UNAVAILABLE` error is returned, this indicates that system is not in
  /// a state where it can delete the view. If this occurs, please try again in a
  /// few minutes.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.logging.v2.DeleteViewRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [`Status`] object. If the request failed, the
  ///     status contains the details of the failure.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.logging.v2.DeleteViewRequest]: @googleapis_reference_link{google/logging/v2/logging_config.proto#L1397}
  ///
  // clang-format on
  Status DeleteView(google::logging::v2::DeleteViewRequest const& request,
                    Options opts = {});

  // clang-format off
  ///
  /// Lists sinks.
  ///
  /// @param parent  Required. The parent resource whose sinks are to be listed:
  ///  @n
  ///      "projects/[PROJECT_ID]"
  ///      "organizations/[ORGANIZATION_ID]"
  ///      "billingAccounts/[BILLING_ACCOUNT_ID]"
  ///      "folders/[FOLDER_ID]"
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.logging.v2.LogSink], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.logging.v2.ListSinksRequest]: @googleapis_reference_link{google/logging/v2/logging_config.proto#L1412}
  /// [google.logging.v2.LogSink]: @googleapis_reference_link{google/logging/v2/logging_config.proto#L928}
  ///
  // clang-format on
  StreamRange<google::logging::v2::LogSink> ListSinks(std::string const& parent,
                                                      Options opts = {});

  // clang-format off
  ///
  /// Lists sinks.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.logging.v2.ListSinksRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.logging.v2.LogSink], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.logging.v2.ListSinksRequest]: @googleapis_reference_link{google/logging/v2/logging_config.proto#L1412}
  /// [google.logging.v2.LogSink]: @googleapis_reference_link{google/logging/v2/logging_config.proto#L928}
  ///
  // clang-format on
  StreamRange<google::logging::v2::LogSink> ListSinks(
      google::logging::v2::ListSinksRequest request, Options opts = {});

  // clang-format off
  ///
  /// Gets a sink.
  ///
  /// @param sink_name  Required. The resource name of the sink:
  ///  @n
  ///      "projects/[PROJECT_ID]/sinks/[SINK_ID]"
  ///      "organizations/[ORGANIZATION_ID]/sinks/[SINK_ID]"
  ///      "billingAccounts/[BILLING_ACCOUNT_ID]/sinks/[SINK_ID]"
  ///      "folders/[FOLDER_ID]/sinks/[SINK_ID]"
  ///  @n
  ///  For example:
  ///  @n
  ///    `"projects/my-project/sinks/my-sink"`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.logging.v2.LogSink])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.logging.v2.GetSinkRequest]: @googleapis_reference_link{google/logging/v2/logging_config.proto#L1450}
  /// [google.logging.v2.LogSink]: @googleapis_reference_link{google/logging/v2/logging_config.proto#L928}
  ///
  // clang-format on
  StatusOr<google::logging::v2::LogSink> GetSink(std::string const& sink_name,
                                                 Options opts = {});

  // clang-format off
  ///
  /// Gets a sink.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.logging.v2.GetSinkRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.logging.v2.LogSink])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.logging.v2.GetSinkRequest]: @googleapis_reference_link{google/logging/v2/logging_config.proto#L1450}
  /// [google.logging.v2.LogSink]: @googleapis_reference_link{google/logging/v2/logging_config.proto#L928}
  ///
  // clang-format on
  StatusOr<google::logging::v2::LogSink> GetSink(
      google::logging::v2::GetSinkRequest const& request, Options opts = {});

  // clang-format off
  ///
  /// Creates a sink that exports specified log entries to a destination. The
  /// export of newly-ingested log entries begins immediately, unless the sink's
  /// `writer_identity` is not permitted to write to the destination. A sink can
  /// export log entries only from the resource owning the sink.
  ///
  /// @param parent  Required. The resource in which to create the sink:
  ///  @n
  ///      "projects/[PROJECT_ID]"
  ///      "organizations/[ORGANIZATION_ID]"
  ///      "billingAccounts/[BILLING_ACCOUNT_ID]"
  ///      "folders/[FOLDER_ID]"
  ///  @n
  ///  For examples:
  ///  @n
  ///    `"projects/my-project"`
  ///    `"organizations/123456789"`
  /// @param sink  Required. The new sink, whose `name` parameter is a sink identifier that
  ///  is not already in use.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.logging.v2.LogSink])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.logging.v2.CreateSinkRequest]: @googleapis_reference_link{google/logging/v2/logging_config.proto#L1468}
  /// [google.logging.v2.LogSink]: @googleapis_reference_link{google/logging/v2/logging_config.proto#L928}
  ///
  // clang-format on
  StatusOr<google::logging::v2::LogSink> CreateSink(
      std::string const& parent, google::logging::v2::LogSink const& sink,
      Options opts = {});

  // clang-format off
  ///
  /// Creates a sink that exports specified log entries to a destination. The
  /// export of newly-ingested log entries begins immediately, unless the sink's
  /// `writer_identity` is not permitted to write to the destination. A sink can
  /// export log entries only from the resource owning the sink.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.logging.v2.CreateSinkRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.logging.v2.LogSink])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.logging.v2.CreateSinkRequest]: @googleapis_reference_link{google/logging/v2/logging_config.proto#L1468}
  /// [google.logging.v2.LogSink]: @googleapis_reference_link{google/logging/v2/logging_config.proto#L928}
  ///
  // clang-format on
  StatusOr<google::logging::v2::LogSink> CreateSink(
      google::logging::v2::CreateSinkRequest const& request, Options opts = {});

  // clang-format off
  ///
  /// Updates a sink. This method replaces the following fields in the existing
  /// sink with values from the new sink: `destination`, and `filter`.
  ///
  /// The updated sink might also have a new `writer_identity`; see the
  /// `unique_writer_identity` field.
  ///
  /// @param sink_name  Required. The full resource name of the sink to update, including the
  ///  parent resource and the sink identifier:
  ///  @n
  ///      "projects/[PROJECT_ID]/sinks/[SINK_ID]"
  ///      "organizations/[ORGANIZATION_ID]/sinks/[SINK_ID]"
  ///      "billingAccounts/[BILLING_ACCOUNT_ID]/sinks/[SINK_ID]"
  ///      "folders/[FOLDER_ID]/sinks/[SINK_ID]"
  ///  @n
  ///  For example:
  ///  @n
  ///    `"projects/my-project/sinks/my-sink"`
  /// @param sink  Required. The updated sink, whose name is the same identifier that appears
  ///  as part of `sink_name`.
  /// @param update_mask  Optional. Field mask that specifies the fields in `sink` that need
  ///  an update. A sink field will be overwritten if, and only if, it is
  ///  in the update mask. `name` and output only fields cannot be updated.
  ///  @n
  ///  An empty `updateMask` is temporarily treated as using the following mask
  ///  for backwards compatibility purposes:
  ///  @n
  ///    `destination,filter,includeChildren`
  ///  @n
  ///  At some point in the future, behavior will be removed and specifying an
  ///  empty `updateMask` will be an error.
  ///  @n
  ///  For a detailed `FieldMask` definition, see
  ///  https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#google.protobuf.FieldMask
  ///  @n
  ///  For example: `updateMask=filter`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.logging.v2.LogSink])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.logging.v2.LogSink]: @googleapis_reference_link{google/logging/v2/logging_config.proto#L928}
  /// [google.logging.v2.UpdateSinkRequest]: @googleapis_reference_link{google/logging/v2/logging_config.proto#L1507}
  ///
  // clang-format on
  StatusOr<google::logging::v2::LogSink> UpdateSink(
      std::string const& sink_name, google::logging::v2::LogSink const& sink,
      google::protobuf::FieldMask const& update_mask, Options opts = {});

  // clang-format off
  ///
  /// Updates a sink. This method replaces the following fields in the existing
  /// sink with values from the new sink: `destination`, and `filter`.
  ///
  /// The updated sink might also have a new `writer_identity`; see the
  /// `unique_writer_identity` field.
  ///
  /// @param sink_name  Required. The full resource name of the sink to update, including the
  ///  parent resource and the sink identifier:
  ///  @n
  ///      "projects/[PROJECT_ID]/sinks/[SINK_ID]"
  ///      "organizations/[ORGANIZATION_ID]/sinks/[SINK_ID]"
  ///      "billingAccounts/[BILLING_ACCOUNT_ID]/sinks/[SINK_ID]"
  ///      "folders/[FOLDER_ID]/sinks/[SINK_ID]"
  ///  @n
  ///  For example:
  ///  @n
  ///    `"projects/my-project/sinks/my-sink"`
  /// @param sink  Required. The updated sink, whose name is the same identifier that appears
  ///  as part of `sink_name`.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.logging.v2.LogSink])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.logging.v2.LogSink]: @googleapis_reference_link{google/logging/v2/logging_config.proto#L928}
  /// [google.logging.v2.UpdateSinkRequest]: @googleapis_reference_link{google/logging/v2/logging_config.proto#L1507}
  ///
  // clang-format on
  StatusOr<google::logging::v2::LogSink> UpdateSink(
      std::string const& sink_name, google::logging::v2::LogSink const& sink,
      Options opts = {});

  // clang-format off
  ///
  /// Updates a sink. This method replaces the following fields in the existing
  /// sink with values from the new sink: `destination`, and `filter`.
  ///
  /// The updated sink might also have a new `writer_identity`; see the
  /// `unique_writer_identity` field.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.logging.v2.UpdateSinkRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.logging.v2.LogSink])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.logging.v2.LogSink]: @googleapis_reference_link{google/logging/v2/logging_config.proto#L928}
  /// [google.logging.v2.UpdateSinkRequest]: @googleapis_reference_link{google/logging/v2/logging_config.proto#L1507}
  ///
  // clang-format on
  StatusOr<google::logging::v2::LogSink> UpdateSink(
      google::logging::v2::UpdateSinkRequest const& request, Options opts = {});

  // clang-format off
  ///
  /// Deletes a sink. If the sink has a unique `writer_identity`, then that
  /// service account is also deleted.
  ///
  /// @param sink_name  Required. The full resource name of the sink to delete, including the
  ///  parent resource and the sink identifier:
  ///  @n
  ///      "projects/[PROJECT_ID]/sinks/[SINK_ID]"
  ///      "organizations/[ORGANIZATION_ID]/sinks/[SINK_ID]"
  ///      "billingAccounts/[BILLING_ACCOUNT_ID]/sinks/[SINK_ID]"
  ///      "folders/[FOLDER_ID]/sinks/[SINK_ID]"
  ///  @n
  ///  For example:
  ///  @n
  ///    `"projects/my-project/sinks/my-sink"`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [`Status`] object. If the request failed, the
  ///     status contains the details of the failure.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.logging.v2.DeleteSinkRequest]: @googleapis_reference_link{google/logging/v2/logging_config.proto#L1562}
  ///
  // clang-format on
  Status DeleteSink(std::string const& sink_name, Options opts = {});

  // clang-format off
  ///
  /// Deletes a sink. If the sink has a unique `writer_identity`, then that
  /// service account is also deleted.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.logging.v2.DeleteSinkRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [`Status`] object. If the request failed, the
  ///     status contains the details of the failure.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.logging.v2.DeleteSinkRequest]: @googleapis_reference_link{google/logging/v2/logging_config.proto#L1562}
  ///
  // clang-format on
  Status DeleteSink(google::logging::v2::DeleteSinkRequest const& request,
                    Options opts = {});

  // clang-format off
  ///
  /// Asynchronously creates a linked dataset in BigQuery which makes it possible
  /// to use BigQuery to read the logs stored in the log bucket. A log bucket may
  /// currently only contain one link.
  ///
  /// @param parent  Required. The full resource name of the bucket to create a link for.
  ///  @n
  ///      "projects/[PROJECT_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]"
  ///      "organizations/[ORGANIZATION_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]"
  ///      "billingAccounts/[BILLING_ACCOUNT_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]"
  ///      "folders/[FOLDER_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]"
  /// @param link  Required. The new link.
  /// @param link_id  Required. The ID to use for the link. The link_id can have up to 100
  ///  characters. A valid link_id must only have alphanumeric characters and
  ///  underscores within it.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.logging.v2.Link] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.logging.v2.CreateLinkRequest]: @googleapis_reference_link{google/logging/v2/logging_config.proto#L1581}
  /// [google.logging.v2.Link]: @googleapis_reference_link{google/logging/v2/logging_config.proto#L1075}
  ///
  // clang-format on
  future<StatusOr<google::logging::v2::Link>> CreateLink(
      std::string const& parent, google::logging::v2::Link const& link,
      std::string const& link_id, Options opts = {});

  // clang-format off
  ///
  /// Asynchronously creates a linked dataset in BigQuery which makes it possible
  /// to use BigQuery to read the logs stored in the log bucket. A log bucket may
  /// currently only contain one link.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.logging.v2.CreateLinkRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.logging.v2.Link] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.logging.v2.CreateLinkRequest]: @googleapis_reference_link{google/logging/v2/logging_config.proto#L1581}
  /// [google.logging.v2.Link]: @googleapis_reference_link{google/logging/v2/logging_config.proto#L1075}
  ///
  // clang-format on
  future<StatusOr<google::logging::v2::Link>> CreateLink(
      google::logging::v2::CreateLinkRequest const& request, Options opts = {});

  // clang-format off
  ///
  /// Deletes a link. This will also delete the corresponding BigQuery linked
  /// dataset.
  ///
  /// @param name  Required. The full resource name of the link to delete.
  ///  @n
  ///   "projects/[PROJECT_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]/links/[LINK_ID]"
  ///    "organizations/[ORGANIZATION_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]/links/[LINK_ID]"
  ///    "billingAccounts/[BILLING_ACCOUNT_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]/links/[LINK_ID]"
  ///    "folders/[FOLDER_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]/links/[LINK_ID]"
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.logging.v2.LinkMetadata] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.logging.v2.DeleteLinkRequest]: @googleapis_reference_link{google/logging/v2/logging_config.proto#L1605}
  /// [google.logging.v2.LinkMetadata]: @googleapis_reference_link{google/logging/v2/logging_config.proto#L2227}
  ///
  // clang-format on
  future<StatusOr<google::logging::v2::LinkMetadata>> DeleteLink(
      std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Deletes a link. This will also delete the corresponding BigQuery linked
  /// dataset.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.logging.v2.DeleteLinkRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.logging.v2.LinkMetadata] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.logging.v2.DeleteLinkRequest]: @googleapis_reference_link{google/logging/v2/logging_config.proto#L1605}
  /// [google.logging.v2.LinkMetadata]: @googleapis_reference_link{google/logging/v2/logging_config.proto#L2227}
  ///
  // clang-format on
  future<StatusOr<google::logging::v2::LinkMetadata>> DeleteLink(
      google::logging::v2::DeleteLinkRequest const& request, Options opts = {});

  // clang-format off
  ///
  /// Lists links.
  ///
  /// @param parent  Required. The parent resource whose links are to be listed:
  ///  @n
  ///    "projects/[PROJECT_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]"
  ///    "organizations/[ORGANIZATION_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]"
  ///    "billingAccounts/[BILLING_ACCOUNT_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]"
  ///    "folders/[FOLDER_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]"
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.logging.v2.Link], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.logging.v2.Link]: @googleapis_reference_link{google/logging/v2/logging_config.proto#L1075}
  /// [google.logging.v2.ListLinksRequest]: @googleapis_reference_link{google/logging/v2/logging_config.proto#L1619}
  ///
  // clang-format on
  StreamRange<google::logging::v2::Link> ListLinks(std::string const& parent,
                                                   Options opts = {});

  // clang-format off
  ///
  /// Lists links.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.logging.v2.ListLinksRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.logging.v2.Link], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.logging.v2.Link]: @googleapis_reference_link{google/logging/v2/logging_config.proto#L1075}
  /// [google.logging.v2.ListLinksRequest]: @googleapis_reference_link{google/logging/v2/logging_config.proto#L1619}
  ///
  // clang-format on
  StreamRange<google::logging::v2::Link> ListLinks(
      google::logging::v2::ListLinksRequest request, Options opts = {});

  // clang-format off
  ///
  /// Gets a link.
  ///
  /// @param name  Required. The resource name of the link:
  ///  @n
  ///    "projects/[PROJECT_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]/links/[LINK_ID]"
  ///    "organizations/[ORGANIZATION_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]/links/[LINK_ID]"
  ///    "billingAccounts/[BILLING_ACCOUNT_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]/links/[LINK_ID]"
  ///    "folders/[FOLDER_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]/links/[LINK_ID]"
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.logging.v2.Link])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.logging.v2.GetLinkRequest]: @googleapis_reference_link{google/logging/v2/logging_config.proto#L1654}
  /// [google.logging.v2.Link]: @googleapis_reference_link{google/logging/v2/logging_config.proto#L1075}
  ///
  // clang-format on
  StatusOr<google::logging::v2::Link> GetLink(std::string const& name,
                                              Options opts = {});

  // clang-format off
  ///
  /// Gets a link.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.logging.v2.GetLinkRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.logging.v2.Link])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.logging.v2.GetLinkRequest]: @googleapis_reference_link{google/logging/v2/logging_config.proto#L1654}
  /// [google.logging.v2.Link]: @googleapis_reference_link{google/logging/v2/logging_config.proto#L1075}
  ///
  // clang-format on
  StatusOr<google::logging::v2::Link> GetLink(
      google::logging::v2::GetLinkRequest const& request, Options opts = {});

  // clang-format off
  ///
  /// Lists all the exclusions on the _Default sink in a parent resource.
  ///
  /// @param parent  Required. The parent resource whose exclusions are to be listed.
  ///  @n
  ///      "projects/[PROJECT_ID]"
  ///      "organizations/[ORGANIZATION_ID]"
  ///      "billingAccounts/[BILLING_ACCOUNT_ID]"
  ///      "folders/[FOLDER_ID]"
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.logging.v2.LogExclusion], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.logging.v2.ListExclusionsRequest]: @googleapis_reference_link{google/logging/v2/logging_config.proto#L1722}
  /// [google.logging.v2.LogExclusion]: @googleapis_reference_link{google/logging/v2/logging_config.proto#L1672}
  ///
  // clang-format on
  StreamRange<google::logging::v2::LogExclusion> ListExclusions(
      std::string const& parent, Options opts = {});

  // clang-format off
  ///
  /// Lists all the exclusions on the _Default sink in a parent resource.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.logging.v2.ListExclusionsRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.logging.v2.LogExclusion], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.logging.v2.ListExclusionsRequest]: @googleapis_reference_link{google/logging/v2/logging_config.proto#L1722}
  /// [google.logging.v2.LogExclusion]: @googleapis_reference_link{google/logging/v2/logging_config.proto#L1672}
  ///
  // clang-format on
  StreamRange<google::logging::v2::LogExclusion> ListExclusions(
      google::logging::v2::ListExclusionsRequest request, Options opts = {});

  // clang-format off
  ///
  /// Gets the description of an exclusion in the _Default sink.
  ///
  /// @param name  Required. The resource name of an existing exclusion:
  ///  @n
  ///      "projects/[PROJECT_ID]/exclusions/[EXCLUSION_ID]"
  ///      "organizations/[ORGANIZATION_ID]/exclusions/[EXCLUSION_ID]"
  ///      "billingAccounts/[BILLING_ACCOUNT_ID]/exclusions/[EXCLUSION_ID]"
  ///      "folders/[FOLDER_ID]/exclusions/[EXCLUSION_ID]"
  ///  @n
  ///  For example:
  ///  @n
  ///    `"projects/my-project/exclusions/my-exclusion"`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.logging.v2.LogExclusion])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.logging.v2.GetExclusionRequest]: @googleapis_reference_link{google/logging/v2/logging_config.proto#L1760}
  /// [google.logging.v2.LogExclusion]: @googleapis_reference_link{google/logging/v2/logging_config.proto#L1672}
  ///
  // clang-format on
  StatusOr<google::logging::v2::LogExclusion> GetExclusion(
      std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Gets the description of an exclusion in the _Default sink.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.logging.v2.GetExclusionRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.logging.v2.LogExclusion])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.logging.v2.GetExclusionRequest]: @googleapis_reference_link{google/logging/v2/logging_config.proto#L1760}
  /// [google.logging.v2.LogExclusion]: @googleapis_reference_link{google/logging/v2/logging_config.proto#L1672}
  ///
  // clang-format on
  StatusOr<google::logging::v2::LogExclusion> GetExclusion(
      google::logging::v2::GetExclusionRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Creates a new exclusion in the _Default sink in a specified parent
  /// resource. Only log entries belonging to that resource can be excluded. You
  /// can have up to 10 exclusions in a resource.
  ///
  /// @param parent  Required. The parent resource in which to create the exclusion:
  ///  @n
  ///      "projects/[PROJECT_ID]"
  ///      "organizations/[ORGANIZATION_ID]"
  ///      "billingAccounts/[BILLING_ACCOUNT_ID]"
  ///      "folders/[FOLDER_ID]"
  ///  @n
  ///  For examples:
  ///  @n
  ///    `"projects/my-logging-project"`
  ///    `"organizations/123456789"`
  /// @param exclusion  Required. The new exclusion, whose `name` parameter is an exclusion name
  ///  that is not already used in the parent resource.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.logging.v2.LogExclusion])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.logging.v2.CreateExclusionRequest]: @googleapis_reference_link{google/logging/v2/logging_config.proto#L1780}
  /// [google.logging.v2.LogExclusion]: @googleapis_reference_link{google/logging/v2/logging_config.proto#L1672}
  ///
  // clang-format on
  StatusOr<google::logging::v2::LogExclusion> CreateExclusion(
      std::string const& parent,
      google::logging::v2::LogExclusion const& exclusion, Options opts = {});

  // clang-format off
  ///
  /// Creates a new exclusion in the _Default sink in a specified parent
  /// resource. Only log entries belonging to that resource can be excluded. You
  /// can have up to 10 exclusions in a resource.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.logging.v2.CreateExclusionRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.logging.v2.LogExclusion])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.logging.v2.CreateExclusionRequest]: @googleapis_reference_link{google/logging/v2/logging_config.proto#L1780}
  /// [google.logging.v2.LogExclusion]: @googleapis_reference_link{google/logging/v2/logging_config.proto#L1672}
  ///
  // clang-format on
  StatusOr<google::logging::v2::LogExclusion> CreateExclusion(
      google::logging::v2::CreateExclusionRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Changes one or more properties of an existing exclusion in the _Default
  /// sink.
  ///
  /// @param name  Required. The resource name of the exclusion to update:
  ///  @n
  ///      "projects/[PROJECT_ID]/exclusions/[EXCLUSION_ID]"
  ///      "organizations/[ORGANIZATION_ID]/exclusions/[EXCLUSION_ID]"
  ///      "billingAccounts/[BILLING_ACCOUNT_ID]/exclusions/[EXCLUSION_ID]"
  ///      "folders/[FOLDER_ID]/exclusions/[EXCLUSION_ID]"
  ///  @n
  ///  For example:
  ///  @n
  ///    `"projects/my-project/exclusions/my-exclusion"`
  /// @param exclusion  Required. New values for the existing exclusion. Only the fields specified
  ///  in `update_mask` are relevant.
  /// @param update_mask  Required. A non-empty list of fields to change in the existing exclusion.
  ///  New values for the fields are taken from the corresponding fields in the
  ///  [LogExclusion][google.logging.v2.LogExclusion] included in this request.
  ///  Fields not mentioned in `update_mask` are not changed and are ignored in
  ///  the request.
  ///  @n
  ///  For example, to change the filter and description of an exclusion,
  ///  specify an `update_mask` of `"filter,description"`.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.logging.v2.LogExclusion])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.logging.v2.LogExclusion]: @googleapis_reference_link{google/logging/v2/logging_config.proto#L1672}
  /// [google.logging.v2.UpdateExclusionRequest]: @googleapis_reference_link{google/logging/v2/logging_config.proto#L1805}
  ///
  // clang-format on
  StatusOr<google::logging::v2::LogExclusion> UpdateExclusion(
      std::string const& name,
      google::logging::v2::LogExclusion const& exclusion,
      google::protobuf::FieldMask const& update_mask, Options opts = {});

  // clang-format off
  ///
  /// Changes one or more properties of an existing exclusion in the _Default
  /// sink.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.logging.v2.UpdateExclusionRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.logging.v2.LogExclusion])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.logging.v2.LogExclusion]: @googleapis_reference_link{google/logging/v2/logging_config.proto#L1672}
  /// [google.logging.v2.UpdateExclusionRequest]: @googleapis_reference_link{google/logging/v2/logging_config.proto#L1805}
  ///
  // clang-format on
  StatusOr<google::logging::v2::LogExclusion> UpdateExclusion(
      google::logging::v2::UpdateExclusionRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Deletes an exclusion in the _Default sink.
  ///
  /// @param name  Required. The resource name of an existing exclusion to delete:
  ///  @n
  ///      "projects/[PROJECT_ID]/exclusions/[EXCLUSION_ID]"
  ///      "organizations/[ORGANIZATION_ID]/exclusions/[EXCLUSION_ID]"
  ///      "billingAccounts/[BILLING_ACCOUNT_ID]/exclusions/[EXCLUSION_ID]"
  ///      "folders/[FOLDER_ID]/exclusions/[EXCLUSION_ID]"
  ///  @n
  ///  For example:
  ///  @n
  ///    `"projects/my-project/exclusions/my-exclusion"`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [`Status`] object. If the request failed, the
  ///     status contains the details of the failure.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.logging.v2.DeleteExclusionRequest]: @googleapis_reference_link{google/logging/v2/logging_config.proto#L1840}
  ///
  // clang-format on
  Status DeleteExclusion(std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Deletes an exclusion in the _Default sink.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.logging.v2.DeleteExclusionRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [`Status`] object. If the request failed, the
  ///     status contains the details of the failure.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.logging.v2.DeleteExclusionRequest]: @googleapis_reference_link{google/logging/v2/logging_config.proto#L1840}
  ///
  // clang-format on
  Status DeleteExclusion(
      google::logging::v2::DeleteExclusionRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Gets the Logging CMEK settings for the given resource.
  ///
  /// Note: CMEK for the Log Router can be configured for Google Cloud projects,
  /// folders, organizations and billing accounts. Once configured for an
  /// organization, it applies to all projects and folders in the Google Cloud
  /// organization.
  ///
  /// See [Enabling CMEK for Log
  /// Router](https://cloud.google.com/logging/docs/routing/managed-encryption)
  /// for more information.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.logging.v2.GetCmekSettingsRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.logging.v2.CmekSettings])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.logging.v2.CmekSettings]: @googleapis_reference_link{google/logging/v2/logging_config.proto#L1940}
  /// [google.logging.v2.GetCmekSettingsRequest]: @googleapis_reference_link{google/logging/v2/logging_config.proto#L1865}
  ///
  // clang-format on
  StatusOr<google::logging::v2::CmekSettings> GetCmekSettings(
      google::logging::v2::GetCmekSettingsRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Updates the Log Router CMEK settings for the given resource.
  ///
  /// Note: CMEK for the Log Router can currently only be configured for Google
  /// Cloud organizations. Once configured, it applies to all projects and
  /// folders in the Google Cloud organization.
  ///
  /// [UpdateCmekSettings][google.logging.v2.ConfigServiceV2.UpdateCmekSettings]
  /// will fail if 1) `kms_key_name` is invalid, or 2) the associated service
  /// account does not have the required
  /// `roles/cloudkms.cryptoKeyEncrypterDecrypter` role assigned for the key, or
  /// 3) access to the key is disabled.
  ///
  /// See [Enabling CMEK for Log
  /// Router](https://cloud.google.com/logging/docs/routing/managed-encryption)
  /// for more information.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.logging.v2.UpdateCmekSettingsRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.logging.v2.CmekSettings])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.logging.v2.CmekSettings]: @googleapis_reference_link{google/logging/v2/logging_config.proto#L1940}
  /// [google.logging.v2.ConfigServiceV2.UpdateCmekSettings]: @googleapis_reference_link{google/logging/v2/logging_config.proto#L699}
  /// [google.logging.v2.UpdateCmekSettingsRequest]: @googleapis_reference_link{google/logging/v2/logging_config.proto#L1895}
  ///
  // clang-format on
  StatusOr<google::logging::v2::CmekSettings> UpdateCmekSettings(
      google::logging::v2::UpdateCmekSettingsRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Gets the Log Router settings for the given resource.
  ///
  /// Note: Settings for the Log Router can be get for Google Cloud projects,
  /// folders, organizations and billing accounts. Currently it can only be
  /// configured for organizations. Once configured for an organization, it
  /// applies to all projects and folders in the Google Cloud organization.
  ///
  /// See [Enabling CMEK for Log
  /// Router](https://cloud.google.com/logging/docs/routing/managed-encryption)
  /// for more information.
  ///
  /// @param name  Required. The resource for which to retrieve settings.
  ///  @n
  ///      "projects/[PROJECT_ID]/settings"
  ///      "organizations/[ORGANIZATION_ID]/settings"
  ///      "billingAccounts/[BILLING_ACCOUNT_ID]/settings"
  ///      "folders/[FOLDER_ID]/settings"
  ///  @n
  ///  For example:
  ///  @n
  ///    `"organizations/12345/settings"`
  ///  @n
  ///  Note: Settings for the Log Router can be get for Google Cloud projects,
  ///  folders, organizations and billing accounts. Currently it can only be
  ///  configured for organizations. Once configured for an organization, it
  ///  applies to all projects and folders in the Google Cloud organization.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.logging.v2.Settings])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.logging.v2.GetSettingsRequest]: @googleapis_reference_link{google/logging/v2/logging_config.proto#L2022}
  /// [google.logging.v2.Settings]: @googleapis_reference_link{google/logging/v2/logging_config.proto#L2086}
  ///
  // clang-format on
  StatusOr<google::logging::v2::Settings> GetSettings(std::string const& name,
                                                      Options opts = {});

  // clang-format off
  ///
  /// Gets the Log Router settings for the given resource.
  ///
  /// Note: Settings for the Log Router can be get for Google Cloud projects,
  /// folders, organizations and billing accounts. Currently it can only be
  /// configured for organizations. Once configured for an organization, it
  /// applies to all projects and folders in the Google Cloud organization.
  ///
  /// See [Enabling CMEK for Log
  /// Router](https://cloud.google.com/logging/docs/routing/managed-encryption)
  /// for more information.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.logging.v2.GetSettingsRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.logging.v2.Settings])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.logging.v2.GetSettingsRequest]: @googleapis_reference_link{google/logging/v2/logging_config.proto#L2022}
  /// [google.logging.v2.Settings]: @googleapis_reference_link{google/logging/v2/logging_config.proto#L2086}
  ///
  // clang-format on
  StatusOr<google::logging::v2::Settings> GetSettings(
      google::logging::v2::GetSettingsRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Updates the Log Router settings for the given resource.
  ///
  /// Note: Settings for the Log Router can currently only be configured for
  /// Google Cloud organizations. Once configured, it applies to all projects and
  /// folders in the Google Cloud organization.
  ///
  /// [UpdateSettings][google.logging.v2.ConfigServiceV2.UpdateSettings]
  /// will fail if 1) `kms_key_name` is invalid, or 2) the associated service
  /// account does not have the required
  /// `roles/cloudkms.cryptoKeyEncrypterDecrypter` role assigned for the key, or
  /// 3) access to the key is disabled. 4) `location_id` is not supported by
  /// Logging. 5) `location_id` violate OrgPolicy.
  ///
  /// See [Enabling CMEK for Log
  /// Router](https://cloud.google.com/logging/docs/routing/managed-encryption)
  /// for more information.
  ///
  /// @param settings  Required. The settings to update.
  ///  @n
  ///  See [Enabling CMEK for Log
  ///  Router](https://cloud.google.com/logging/docs/routing/managed-encryption)
  ///  for more information.
  /// @param update_mask  Optional. Field mask identifying which fields from `settings` should
  ///  be updated. A field will be overwritten if and only if it is in the update
  ///  mask. Output only fields cannot be updated.
  ///  @n
  ///  See [FieldMask][google.protobuf.FieldMask] for more information.
  ///  @n
  ///  For example: `"updateMask=kmsKeyName"`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.logging.v2.Settings])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.logging.v2.ConfigServiceV2.UpdateSettings]: @googleapis_reference_link{google/logging/v2/logging_config.proto#L747}
  /// [google.logging.v2.Settings]: @googleapis_reference_link{google/logging/v2/logging_config.proto#L2086}
  /// [google.logging.v2.UpdateSettingsRequest]: @googleapis_reference_link{google/logging/v2/logging_config.proto#L2052}
  ///
  // clang-format on
  StatusOr<google::logging::v2::Settings> UpdateSettings(
      google::logging::v2::Settings const& settings,
      google::protobuf::FieldMask const& update_mask, Options opts = {});

  // clang-format off
  ///
  /// Updates the Log Router settings for the given resource.
  ///
  /// Note: Settings for the Log Router can currently only be configured for
  /// Google Cloud organizations. Once configured, it applies to all projects and
  /// folders in the Google Cloud organization.
  ///
  /// [UpdateSettings][google.logging.v2.ConfigServiceV2.UpdateSettings]
  /// will fail if 1) `kms_key_name` is invalid, or 2) the associated service
  /// account does not have the required
  /// `roles/cloudkms.cryptoKeyEncrypterDecrypter` role assigned for the key, or
  /// 3) access to the key is disabled. 4) `location_id` is not supported by
  /// Logging. 5) `location_id` violate OrgPolicy.
  ///
  /// See [Enabling CMEK for Log
  /// Router](https://cloud.google.com/logging/docs/routing/managed-encryption)
  /// for more information.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.logging.v2.UpdateSettingsRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.logging.v2.Settings])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.logging.v2.ConfigServiceV2.UpdateSettings]: @googleapis_reference_link{google/logging/v2/logging_config.proto#L747}
  /// [google.logging.v2.Settings]: @googleapis_reference_link{google/logging/v2/logging_config.proto#L2086}
  /// [google.logging.v2.UpdateSettingsRequest]: @googleapis_reference_link{google/logging/v2/logging_config.proto#L2052}
  ///
  // clang-format on
  StatusOr<google::logging::v2::Settings> UpdateSettings(
      google::logging::v2::UpdateSettingsRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Copies a set of log entries from a log bucket to a Cloud Storage bucket.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.logging.v2.CopyLogEntriesRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.logging.v2.CopyLogEntriesResponse] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.logging.v2.CopyLogEntriesRequest]: @googleapis_reference_link{google/logging/v2/logging_config.proto#L2154}
  /// [google.logging.v2.CopyLogEntriesResponse]: @googleapis_reference_link{google/logging/v2/logging_config.proto#L2201}
  ///
  // clang-format on
  future<StatusOr<google::logging::v2::CopyLogEntriesResponse>> CopyLogEntries(
      google::logging::v2::CopyLogEntriesRequest const& request,
      Options opts = {});

 private:
  std::shared_ptr<ConfigServiceV2Connection> connection_;
  Options options_;
};

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace logging_v2
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_LOGGING_V2_CONFIG_SERVICE_V2_CLIENT_H
