// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/networkservices/v1/network_services.proto

#include "google/cloud/networkservices/v1/internal/network_services_connection_impl.h"
#include "google/cloud/networkservices/v1/internal/network_services_option_defaults.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/common_options.h"
#include "google/cloud/grpc_options.h"
#include "google/cloud/internal/async_long_running_operation.h"
#include "google/cloud/internal/pagination_range.h"
#include "google/cloud/internal/retry_loop.h"
#include <memory>

namespace google {
namespace cloud {
namespace networkservices_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN
namespace {

std::unique_ptr<networkservices_v1::NetworkServicesRetryPolicy> retry_policy(
    Options const& options) {
  return options.get<networkservices_v1::NetworkServicesRetryPolicyOption>()
      ->clone();
}

std::unique_ptr<BackoffPolicy> backoff_policy(Options const& options) {
  return options.get<networkservices_v1::NetworkServicesBackoffPolicyOption>()
      ->clone();
}

std::unique_ptr<networkservices_v1::NetworkServicesConnectionIdempotencyPolicy>
idempotency_policy(Options const& options) {
  return options
      .get<networkservices_v1::
               NetworkServicesConnectionIdempotencyPolicyOption>()
      ->clone();
}

std::unique_ptr<PollingPolicy> polling_policy(Options const& options) {
  return options.get<networkservices_v1::NetworkServicesPollingPolicyOption>()
      ->clone();
}

}  // namespace

NetworkServicesConnectionImpl::NetworkServicesConnectionImpl(
    std::unique_ptr<google::cloud::BackgroundThreads> background,
    std::shared_ptr<networkservices_v1_internal::NetworkServicesStub> stub,
    Options options)
    : background_(std::move(background)),
      stub_(std::move(stub)),
      options_(internal::MergeOptions(std::move(options),
                                      NetworkServicesConnection::options())) {}

StreamRange<google::cloud::networkservices::v1::EndpointPolicy>
NetworkServicesConnectionImpl::ListEndpointPolicies(
    google::cloud::networkservices::v1::ListEndpointPoliciesRequest request) {
  request.clear_page_token();
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto idempotency =
      idempotency_policy(*current)->ListEndpointPolicies(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::cloud::networkservices::v1::EndpointPolicy>>(
      std::move(request),
      [idempotency, function_name, stub = stub_,
       retry = std::shared_ptr<networkservices_v1::NetworkServicesRetryPolicy>(
           retry_policy(*current)),
       backoff = std::shared_ptr<BackoffPolicy>(backoff_policy(*current))](
          google::cloud::networkservices::v1::ListEndpointPoliciesRequest const&
              r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](grpc::ClientContext& context,
                   google::cloud::networkservices::v1::
                       ListEndpointPoliciesRequest const& request) {
              return stub->ListEndpointPolicies(context, request);
            },
            r, function_name);
      },
      [](google::cloud::networkservices::v1::ListEndpointPoliciesResponse r) {
        std::vector<google::cloud::networkservices::v1::EndpointPolicy> result(
            r.endpoint_policies().size());
        auto& messages = *r.mutable_endpoint_policies();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

StatusOr<google::cloud::networkservices::v1::EndpointPolicy>
NetworkServicesConnectionImpl::GetEndpointPolicy(
    google::cloud::networkservices::v1::GetEndpointPolicyRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->GetEndpointPolicy(request),
      [this](grpc::ClientContext& context,
             google::cloud::networkservices::v1::GetEndpointPolicyRequest const&
                 request) {
        return stub_->GetEndpointPolicy(context, request);
      },
      request, __func__);
}

future<StatusOr<google::cloud::networkservices::v1::EndpointPolicy>>
NetworkServicesConnectionImpl::CreateEndpointPolicy(
    google::cloud::networkservices::v1::CreateEndpointPolicyRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::networkservices::v1::EndpointPolicy>(
      background_->cq(), current, request,
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::cloud::networkservices::v1::CreateEndpointPolicyRequest const&
              request) {
        return stub->AsyncCreateEndpointPolicy(cq, std::move(context), options,
                                               request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     Options const& options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context), options,
                                       request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context), options,
                                          request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::networkservices::v1::EndpointPolicy>,
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->CreateEndpointPolicy(request),
      polling_policy(*current), __func__);
}

future<StatusOr<google::cloud::networkservices::v1::EndpointPolicy>>
NetworkServicesConnectionImpl::UpdateEndpointPolicy(
    google::cloud::networkservices::v1::UpdateEndpointPolicyRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::networkservices::v1::EndpointPolicy>(
      background_->cq(), current, request,
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::cloud::networkservices::v1::UpdateEndpointPolicyRequest const&
              request) {
        return stub->AsyncUpdateEndpointPolicy(cq, std::move(context), options,
                                               request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     Options const& options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context), options,
                                       request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context), options,
                                          request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::networkservices::v1::EndpointPolicy>,
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->UpdateEndpointPolicy(request),
      polling_policy(*current), __func__);
}

future<StatusOr<google::cloud::networkservices::v1::OperationMetadata>>
NetworkServicesConnectionImpl::DeleteEndpointPolicy(
    google::cloud::networkservices::v1::DeleteEndpointPolicyRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::networkservices::v1::OperationMetadata>(
      background_->cq(), current, request,
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::cloud::networkservices::v1::DeleteEndpointPolicyRequest const&
              request) {
        return stub->AsyncDeleteEndpointPolicy(cq, std::move(context), options,
                                               request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     Options const& options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context), options,
                                       request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context), options,
                                          request);
      },
      &google::cloud::internal::ExtractLongRunningResultMetadata<
          google::cloud::networkservices::v1::OperationMetadata>,
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->DeleteEndpointPolicy(request),
      polling_policy(*current), __func__);
}

StreamRange<google::cloud::networkservices::v1::Gateway>
NetworkServicesConnectionImpl::ListGateways(
    google::cloud::networkservices::v1::ListGatewaysRequest request) {
  request.clear_page_token();
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto idempotency = idempotency_policy(*current)->ListGateways(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::cloud::networkservices::v1::Gateway>>(
      std::move(request),
      [idempotency, function_name, stub = stub_,
       retry = std::shared_ptr<networkservices_v1::NetworkServicesRetryPolicy>(
           retry_policy(*current)),
       backoff = std::shared_ptr<BackoffPolicy>(backoff_policy(*current))](
          google::cloud::networkservices::v1::ListGatewaysRequest const& r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](
                grpc::ClientContext& context,
                google::cloud::networkservices::v1::ListGatewaysRequest const&
                    request) { return stub->ListGateways(context, request); },
            r, function_name);
      },
      [](google::cloud::networkservices::v1::ListGatewaysResponse r) {
        std::vector<google::cloud::networkservices::v1::Gateway> result(
            r.gateways().size());
        auto& messages = *r.mutable_gateways();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

StatusOr<google::cloud::networkservices::v1::Gateway>
NetworkServicesConnectionImpl::GetGateway(
    google::cloud::networkservices::v1::GetGatewayRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->GetGateway(request),
      [this](grpc::ClientContext& context,
             google::cloud::networkservices::v1::GetGatewayRequest const&
                 request) { return stub_->GetGateway(context, request); },
      request, __func__);
}

future<StatusOr<google::cloud::networkservices::v1::Gateway>>
NetworkServicesConnectionImpl::CreateGateway(
    google::cloud::networkservices::v1::CreateGatewayRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::networkservices::v1::Gateway>(
      background_->cq(), current, request,
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::cloud::networkservices::v1::CreateGatewayRequest const&
              request) {
        return stub->AsyncCreateGateway(cq, std::move(context), options,
                                        request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     Options const& options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context), options,
                                       request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context), options,
                                          request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::networkservices::v1::Gateway>,
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->CreateGateway(request),
      polling_policy(*current), __func__);
}

future<StatusOr<google::cloud::networkservices::v1::Gateway>>
NetworkServicesConnectionImpl::UpdateGateway(
    google::cloud::networkservices::v1::UpdateGatewayRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::networkservices::v1::Gateway>(
      background_->cq(), current, request,
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::cloud::networkservices::v1::UpdateGatewayRequest const&
              request) {
        return stub->AsyncUpdateGateway(cq, std::move(context), options,
                                        request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     Options const& options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context), options,
                                       request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context), options,
                                          request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::networkservices::v1::Gateway>,
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->UpdateGateway(request),
      polling_policy(*current), __func__);
}

future<StatusOr<google::cloud::networkservices::v1::OperationMetadata>>
NetworkServicesConnectionImpl::DeleteGateway(
    google::cloud::networkservices::v1::DeleteGatewayRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::networkservices::v1::OperationMetadata>(
      background_->cq(), current, request,
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::cloud::networkservices::v1::DeleteGatewayRequest const&
              request) {
        return stub->AsyncDeleteGateway(cq, std::move(context), options,
                                        request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     Options const& options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context), options,
                                       request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context), options,
                                          request);
      },
      &google::cloud::internal::ExtractLongRunningResultMetadata<
          google::cloud::networkservices::v1::OperationMetadata>,
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->DeleteGateway(request),
      polling_policy(*current), __func__);
}

StreamRange<google::cloud::networkservices::v1::GrpcRoute>
NetworkServicesConnectionImpl::ListGrpcRoutes(
    google::cloud::networkservices::v1::ListGrpcRoutesRequest request) {
  request.clear_page_token();
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto idempotency = idempotency_policy(*current)->ListGrpcRoutes(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::cloud::networkservices::v1::GrpcRoute>>(
      std::move(request),
      [idempotency, function_name, stub = stub_,
       retry = std::shared_ptr<networkservices_v1::NetworkServicesRetryPolicy>(
           retry_policy(*current)),
       backoff = std::shared_ptr<BackoffPolicy>(backoff_policy(*current))](
          google::cloud::networkservices::v1::ListGrpcRoutesRequest const& r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](
                grpc::ClientContext& context,
                google::cloud::networkservices::v1::ListGrpcRoutesRequest const&
                    request) { return stub->ListGrpcRoutes(context, request); },
            r, function_name);
      },
      [](google::cloud::networkservices::v1::ListGrpcRoutesResponse r) {
        std::vector<google::cloud::networkservices::v1::GrpcRoute> result(
            r.grpc_routes().size());
        auto& messages = *r.mutable_grpc_routes();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

StatusOr<google::cloud::networkservices::v1::GrpcRoute>
NetworkServicesConnectionImpl::GetGrpcRoute(
    google::cloud::networkservices::v1::GetGrpcRouteRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->GetGrpcRoute(request),
      [this](grpc::ClientContext& context,
             google::cloud::networkservices::v1::GetGrpcRouteRequest const&
                 request) { return stub_->GetGrpcRoute(context, request); },
      request, __func__);
}

future<StatusOr<google::cloud::networkservices::v1::GrpcRoute>>
NetworkServicesConnectionImpl::CreateGrpcRoute(
    google::cloud::networkservices::v1::CreateGrpcRouteRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::networkservices::v1::GrpcRoute>(
      background_->cq(), current, request,
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::cloud::networkservices::v1::CreateGrpcRouteRequest const&
              request) {
        return stub->AsyncCreateGrpcRoute(cq, std::move(context), options,
                                          request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     Options const& options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context), options,
                                       request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context), options,
                                          request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::networkservices::v1::GrpcRoute>,
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->CreateGrpcRoute(request),
      polling_policy(*current), __func__);
}

future<StatusOr<google::cloud::networkservices::v1::GrpcRoute>>
NetworkServicesConnectionImpl::UpdateGrpcRoute(
    google::cloud::networkservices::v1::UpdateGrpcRouteRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::networkservices::v1::GrpcRoute>(
      background_->cq(), current, request,
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::cloud::networkservices::v1::UpdateGrpcRouteRequest const&
              request) {
        return stub->AsyncUpdateGrpcRoute(cq, std::move(context), options,
                                          request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     Options const& options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context), options,
                                       request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context), options,
                                          request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::networkservices::v1::GrpcRoute>,
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->UpdateGrpcRoute(request),
      polling_policy(*current), __func__);
}

future<StatusOr<google::cloud::networkservices::v1::OperationMetadata>>
NetworkServicesConnectionImpl::DeleteGrpcRoute(
    google::cloud::networkservices::v1::DeleteGrpcRouteRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::networkservices::v1::OperationMetadata>(
      background_->cq(), current, request,
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::cloud::networkservices::v1::DeleteGrpcRouteRequest const&
              request) {
        return stub->AsyncDeleteGrpcRoute(cq, std::move(context), options,
                                          request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     Options const& options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context), options,
                                       request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context), options,
                                          request);
      },
      &google::cloud::internal::ExtractLongRunningResultMetadata<
          google::cloud::networkservices::v1::OperationMetadata>,
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->DeleteGrpcRoute(request),
      polling_policy(*current), __func__);
}

StreamRange<google::cloud::networkservices::v1::HttpRoute>
NetworkServicesConnectionImpl::ListHttpRoutes(
    google::cloud::networkservices::v1::ListHttpRoutesRequest request) {
  request.clear_page_token();
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto idempotency = idempotency_policy(*current)->ListHttpRoutes(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::cloud::networkservices::v1::HttpRoute>>(
      std::move(request),
      [idempotency, function_name, stub = stub_,
       retry = std::shared_ptr<networkservices_v1::NetworkServicesRetryPolicy>(
           retry_policy(*current)),
       backoff = std::shared_ptr<BackoffPolicy>(backoff_policy(*current))](
          google::cloud::networkservices::v1::ListHttpRoutesRequest const& r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](
                grpc::ClientContext& context,
                google::cloud::networkservices::v1::ListHttpRoutesRequest const&
                    request) { return stub->ListHttpRoutes(context, request); },
            r, function_name);
      },
      [](google::cloud::networkservices::v1::ListHttpRoutesResponse r) {
        std::vector<google::cloud::networkservices::v1::HttpRoute> result(
            r.http_routes().size());
        auto& messages = *r.mutable_http_routes();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

StatusOr<google::cloud::networkservices::v1::HttpRoute>
NetworkServicesConnectionImpl::GetHttpRoute(
    google::cloud::networkservices::v1::GetHttpRouteRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->GetHttpRoute(request),
      [this](grpc::ClientContext& context,
             google::cloud::networkservices::v1::GetHttpRouteRequest const&
                 request) { return stub_->GetHttpRoute(context, request); },
      request, __func__);
}

future<StatusOr<google::cloud::networkservices::v1::HttpRoute>>
NetworkServicesConnectionImpl::CreateHttpRoute(
    google::cloud::networkservices::v1::CreateHttpRouteRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::networkservices::v1::HttpRoute>(
      background_->cq(), current, request,
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::cloud::networkservices::v1::CreateHttpRouteRequest const&
              request) {
        return stub->AsyncCreateHttpRoute(cq, std::move(context), options,
                                          request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     Options const& options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context), options,
                                       request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context), options,
                                          request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::networkservices::v1::HttpRoute>,
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->CreateHttpRoute(request),
      polling_policy(*current), __func__);
}

future<StatusOr<google::cloud::networkservices::v1::HttpRoute>>
NetworkServicesConnectionImpl::UpdateHttpRoute(
    google::cloud::networkservices::v1::UpdateHttpRouteRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::networkservices::v1::HttpRoute>(
      background_->cq(), current, request,
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::cloud::networkservices::v1::UpdateHttpRouteRequest const&
              request) {
        return stub->AsyncUpdateHttpRoute(cq, std::move(context), options,
                                          request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     Options const& options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context), options,
                                       request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context), options,
                                          request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::networkservices::v1::HttpRoute>,
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->UpdateHttpRoute(request),
      polling_policy(*current), __func__);
}

future<StatusOr<google::cloud::networkservices::v1::OperationMetadata>>
NetworkServicesConnectionImpl::DeleteHttpRoute(
    google::cloud::networkservices::v1::DeleteHttpRouteRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::networkservices::v1::OperationMetadata>(
      background_->cq(), current, request,
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::cloud::networkservices::v1::DeleteHttpRouteRequest const&
              request) {
        return stub->AsyncDeleteHttpRoute(cq, std::move(context), options,
                                          request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     Options const& options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context), options,
                                       request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context), options,
                                          request);
      },
      &google::cloud::internal::ExtractLongRunningResultMetadata<
          google::cloud::networkservices::v1::OperationMetadata>,
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->DeleteHttpRoute(request),
      polling_policy(*current), __func__);
}

StreamRange<google::cloud::networkservices::v1::TcpRoute>
NetworkServicesConnectionImpl::ListTcpRoutes(
    google::cloud::networkservices::v1::ListTcpRoutesRequest request) {
  request.clear_page_token();
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto idempotency = idempotency_policy(*current)->ListTcpRoutes(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::cloud::networkservices::v1::TcpRoute>>(
      std::move(request),
      [idempotency, function_name, stub = stub_,
       retry = std::shared_ptr<networkservices_v1::NetworkServicesRetryPolicy>(
           retry_policy(*current)),
       backoff = std::shared_ptr<BackoffPolicy>(backoff_policy(*current))](
          google::cloud::networkservices::v1::ListTcpRoutesRequest const& r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](
                grpc::ClientContext& context,
                google::cloud::networkservices::v1::ListTcpRoutesRequest const&
                    request) { return stub->ListTcpRoutes(context, request); },
            r, function_name);
      },
      [](google::cloud::networkservices::v1::ListTcpRoutesResponse r) {
        std::vector<google::cloud::networkservices::v1::TcpRoute> result(
            r.tcp_routes().size());
        auto& messages = *r.mutable_tcp_routes();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

StatusOr<google::cloud::networkservices::v1::TcpRoute>
NetworkServicesConnectionImpl::GetTcpRoute(
    google::cloud::networkservices::v1::GetTcpRouteRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->GetTcpRoute(request),
      [this](grpc::ClientContext& context,
             google::cloud::networkservices::v1::GetTcpRouteRequest const&
                 request) { return stub_->GetTcpRoute(context, request); },
      request, __func__);
}

future<StatusOr<google::cloud::networkservices::v1::TcpRoute>>
NetworkServicesConnectionImpl::CreateTcpRoute(
    google::cloud::networkservices::v1::CreateTcpRouteRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::networkservices::v1::TcpRoute>(
      background_->cq(), current, request,
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::cloud::networkservices::v1::CreateTcpRouteRequest const&
              request) {
        return stub->AsyncCreateTcpRoute(cq, std::move(context), options,
                                         request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     Options const& options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context), options,
                                       request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context), options,
                                          request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::networkservices::v1::TcpRoute>,
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->CreateTcpRoute(request),
      polling_policy(*current), __func__);
}

future<StatusOr<google::cloud::networkservices::v1::TcpRoute>>
NetworkServicesConnectionImpl::UpdateTcpRoute(
    google::cloud::networkservices::v1::UpdateTcpRouteRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::networkservices::v1::TcpRoute>(
      background_->cq(), current, request,
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::cloud::networkservices::v1::UpdateTcpRouteRequest const&
              request) {
        return stub->AsyncUpdateTcpRoute(cq, std::move(context), options,
                                         request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     Options const& options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context), options,
                                       request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context), options,
                                          request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::networkservices::v1::TcpRoute>,
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->UpdateTcpRoute(request),
      polling_policy(*current), __func__);
}

future<StatusOr<google::cloud::networkservices::v1::OperationMetadata>>
NetworkServicesConnectionImpl::DeleteTcpRoute(
    google::cloud::networkservices::v1::DeleteTcpRouteRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::networkservices::v1::OperationMetadata>(
      background_->cq(), current, request,
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::cloud::networkservices::v1::DeleteTcpRouteRequest const&
              request) {
        return stub->AsyncDeleteTcpRoute(cq, std::move(context), options,
                                         request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     Options const& options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context), options,
                                       request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context), options,
                                          request);
      },
      &google::cloud::internal::ExtractLongRunningResultMetadata<
          google::cloud::networkservices::v1::OperationMetadata>,
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->DeleteTcpRoute(request),
      polling_policy(*current), __func__);
}

StreamRange<google::cloud::networkservices::v1::TlsRoute>
NetworkServicesConnectionImpl::ListTlsRoutes(
    google::cloud::networkservices::v1::ListTlsRoutesRequest request) {
  request.clear_page_token();
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto idempotency = idempotency_policy(*current)->ListTlsRoutes(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::cloud::networkservices::v1::TlsRoute>>(
      std::move(request),
      [idempotency, function_name, stub = stub_,
       retry = std::shared_ptr<networkservices_v1::NetworkServicesRetryPolicy>(
           retry_policy(*current)),
       backoff = std::shared_ptr<BackoffPolicy>(backoff_policy(*current))](
          google::cloud::networkservices::v1::ListTlsRoutesRequest const& r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](
                grpc::ClientContext& context,
                google::cloud::networkservices::v1::ListTlsRoutesRequest const&
                    request) { return stub->ListTlsRoutes(context, request); },
            r, function_name);
      },
      [](google::cloud::networkservices::v1::ListTlsRoutesResponse r) {
        std::vector<google::cloud::networkservices::v1::TlsRoute> result(
            r.tls_routes().size());
        auto& messages = *r.mutable_tls_routes();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

StatusOr<google::cloud::networkservices::v1::TlsRoute>
NetworkServicesConnectionImpl::GetTlsRoute(
    google::cloud::networkservices::v1::GetTlsRouteRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->GetTlsRoute(request),
      [this](grpc::ClientContext& context,
             google::cloud::networkservices::v1::GetTlsRouteRequest const&
                 request) { return stub_->GetTlsRoute(context, request); },
      request, __func__);
}

future<StatusOr<google::cloud::networkservices::v1::TlsRoute>>
NetworkServicesConnectionImpl::CreateTlsRoute(
    google::cloud::networkservices::v1::CreateTlsRouteRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::networkservices::v1::TlsRoute>(
      background_->cq(), current, request,
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::cloud::networkservices::v1::CreateTlsRouteRequest const&
              request) {
        return stub->AsyncCreateTlsRoute(cq, std::move(context), options,
                                         request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     Options const& options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context), options,
                                       request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context), options,
                                          request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::networkservices::v1::TlsRoute>,
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->CreateTlsRoute(request),
      polling_policy(*current), __func__);
}

future<StatusOr<google::cloud::networkservices::v1::TlsRoute>>
NetworkServicesConnectionImpl::UpdateTlsRoute(
    google::cloud::networkservices::v1::UpdateTlsRouteRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::networkservices::v1::TlsRoute>(
      background_->cq(), current, request,
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::cloud::networkservices::v1::UpdateTlsRouteRequest const&
              request) {
        return stub->AsyncUpdateTlsRoute(cq, std::move(context), options,
                                         request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     Options const& options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context), options,
                                       request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context), options,
                                          request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::networkservices::v1::TlsRoute>,
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->UpdateTlsRoute(request),
      polling_policy(*current), __func__);
}

future<StatusOr<google::cloud::networkservices::v1::OperationMetadata>>
NetworkServicesConnectionImpl::DeleteTlsRoute(
    google::cloud::networkservices::v1::DeleteTlsRouteRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::networkservices::v1::OperationMetadata>(
      background_->cq(), current, request,
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::cloud::networkservices::v1::DeleteTlsRouteRequest const&
              request) {
        return stub->AsyncDeleteTlsRoute(cq, std::move(context), options,
                                         request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     Options const& options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context), options,
                                       request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context), options,
                                          request);
      },
      &google::cloud::internal::ExtractLongRunningResultMetadata<
          google::cloud::networkservices::v1::OperationMetadata>,
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->DeleteTlsRoute(request),
      polling_policy(*current), __func__);
}

StreamRange<google::cloud::networkservices::v1::ServiceBinding>
NetworkServicesConnectionImpl::ListServiceBindings(
    google::cloud::networkservices::v1::ListServiceBindingsRequest request) {
  request.clear_page_token();
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto idempotency = idempotency_policy(*current)->ListServiceBindings(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::cloud::networkservices::v1::ServiceBinding>>(
      std::move(request),
      [idempotency, function_name, stub = stub_,
       retry = std::shared_ptr<networkservices_v1::NetworkServicesRetryPolicy>(
           retry_policy(*current)),
       backoff = std::shared_ptr<BackoffPolicy>(backoff_policy(*current))](
          google::cloud::networkservices::v1::ListServiceBindingsRequest const&
              r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](grpc::ClientContext& context,
                   google::cloud::networkservices::v1::
                       ListServiceBindingsRequest const& request) {
              return stub->ListServiceBindings(context, request);
            },
            r, function_name);
      },
      [](google::cloud::networkservices::v1::ListServiceBindingsResponse r) {
        std::vector<google::cloud::networkservices::v1::ServiceBinding> result(
            r.service_bindings().size());
        auto& messages = *r.mutable_service_bindings();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

StatusOr<google::cloud::networkservices::v1::ServiceBinding>
NetworkServicesConnectionImpl::GetServiceBinding(
    google::cloud::networkservices::v1::GetServiceBindingRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->GetServiceBinding(request),
      [this](grpc::ClientContext& context,
             google::cloud::networkservices::v1::GetServiceBindingRequest const&
                 request) {
        return stub_->GetServiceBinding(context, request);
      },
      request, __func__);
}

future<StatusOr<google::cloud::networkservices::v1::ServiceBinding>>
NetworkServicesConnectionImpl::CreateServiceBinding(
    google::cloud::networkservices::v1::CreateServiceBindingRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::networkservices::v1::ServiceBinding>(
      background_->cq(), current, request,
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::cloud::networkservices::v1::CreateServiceBindingRequest const&
              request) {
        return stub->AsyncCreateServiceBinding(cq, std::move(context), options,
                                               request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     Options const& options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context), options,
                                       request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context), options,
                                          request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::networkservices::v1::ServiceBinding>,
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->CreateServiceBinding(request),
      polling_policy(*current), __func__);
}

future<StatusOr<google::cloud::networkservices::v1::OperationMetadata>>
NetworkServicesConnectionImpl::DeleteServiceBinding(
    google::cloud::networkservices::v1::DeleteServiceBindingRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::networkservices::v1::OperationMetadata>(
      background_->cq(), current, request,
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::cloud::networkservices::v1::DeleteServiceBindingRequest const&
              request) {
        return stub->AsyncDeleteServiceBinding(cq, std::move(context), options,
                                               request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     Options const& options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context), options,
                                       request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context), options,
                                          request);
      },
      &google::cloud::internal::ExtractLongRunningResultMetadata<
          google::cloud::networkservices::v1::OperationMetadata>,
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->DeleteServiceBinding(request),
      polling_policy(*current), __func__);
}

StreamRange<google::cloud::networkservices::v1::Mesh>
NetworkServicesConnectionImpl::ListMeshes(
    google::cloud::networkservices::v1::ListMeshesRequest request) {
  request.clear_page_token();
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto idempotency = idempotency_policy(*current)->ListMeshes(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::cloud::networkservices::v1::Mesh>>(
      std::move(request),
      [idempotency, function_name, stub = stub_,
       retry = std::shared_ptr<networkservices_v1::NetworkServicesRetryPolicy>(
           retry_policy(*current)),
       backoff = std::shared_ptr<BackoffPolicy>(backoff_policy(*current))](
          google::cloud::networkservices::v1::ListMeshesRequest const& r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](grpc::ClientContext& context,
                   google::cloud::networkservices::v1::ListMeshesRequest const&
                       request) { return stub->ListMeshes(context, request); },
            r, function_name);
      },
      [](google::cloud::networkservices::v1::ListMeshesResponse r) {
        std::vector<google::cloud::networkservices::v1::Mesh> result(
            r.meshes().size());
        auto& messages = *r.mutable_meshes();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

StatusOr<google::cloud::networkservices::v1::Mesh>
NetworkServicesConnectionImpl::GetMesh(
    google::cloud::networkservices::v1::GetMeshRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->GetMesh(request),
      [this](
          grpc::ClientContext& context,
          google::cloud::networkservices::v1::GetMeshRequest const& request) {
        return stub_->GetMesh(context, request);
      },
      request, __func__);
}

future<StatusOr<google::cloud::networkservices::v1::Mesh>>
NetworkServicesConnectionImpl::CreateMesh(
    google::cloud::networkservices::v1::CreateMeshRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::networkservices::v1::Mesh>(
      background_->cq(), current, request,
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::cloud::networkservices::v1::CreateMeshRequest const&
              request) {
        return stub->AsyncCreateMesh(cq, std::move(context), options, request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     Options const& options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context), options,
                                       request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context), options,
                                          request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::networkservices::v1::Mesh>,
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->CreateMesh(request),
      polling_policy(*current), __func__);
}

future<StatusOr<google::cloud::networkservices::v1::Mesh>>
NetworkServicesConnectionImpl::UpdateMesh(
    google::cloud::networkservices::v1::UpdateMeshRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::networkservices::v1::Mesh>(
      background_->cq(), current, request,
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::cloud::networkservices::v1::UpdateMeshRequest const&
              request) {
        return stub->AsyncUpdateMesh(cq, std::move(context), options, request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     Options const& options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context), options,
                                       request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context), options,
                                          request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::networkservices::v1::Mesh>,
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->UpdateMesh(request),
      polling_policy(*current), __func__);
}

future<StatusOr<google::cloud::networkservices::v1::OperationMetadata>>
NetworkServicesConnectionImpl::DeleteMesh(
    google::cloud::networkservices::v1::DeleteMeshRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::networkservices::v1::OperationMetadata>(
      background_->cq(), current, request,
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::cloud::networkservices::v1::DeleteMeshRequest const&
              request) {
        return stub->AsyncDeleteMesh(cq, std::move(context), options, request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     Options const& options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context), options,
                                       request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context), options,
                                          request);
      },
      &google::cloud::internal::ExtractLongRunningResultMetadata<
          google::cloud::networkservices::v1::OperationMetadata>,
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->DeleteMesh(request),
      polling_policy(*current), __func__);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace networkservices_v1_internal
}  // namespace cloud
}  // namespace google
