// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/pubsub/v1/pubsub.proto

#include "google/cloud/pubsub/admin/topic_admin_client.h"
#include <memory>

namespace google {
namespace cloud {
namespace pubsub_admin {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

TopicAdminClient::TopicAdminClient(
    std::shared_ptr<TopicAdminConnection> connection, Options opts)
    : connection_(std::move(connection)),
      options_(
          internal::MergeOptions(std::move(opts), connection_->options())) {}
TopicAdminClient::~TopicAdminClient() = default;

StatusOr<google::pubsub::v1::Topic> TopicAdminClient::CreateTopic(
    std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::pubsub::v1::Topic request;
  request.set_name(name);
  return connection_->CreateTopic(request);
}

StatusOr<google::pubsub::v1::Topic> TopicAdminClient::CreateTopic(
    google::pubsub::v1::Topic const& request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateTopic(request);
}

StatusOr<google::pubsub::v1::Topic> TopicAdminClient::UpdateTopic(
    google::pubsub::v1::Topic const& topic,
    google::protobuf::FieldMask const& update_mask, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::pubsub::v1::UpdateTopicRequest request;
  *request.mutable_topic() = topic;
  *request.mutable_update_mask() = update_mask;
  return connection_->UpdateTopic(request);
}

StatusOr<google::pubsub::v1::Topic> TopicAdminClient::UpdateTopic(
    google::pubsub::v1::UpdateTopicRequest const& request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateTopic(request);
}

StatusOr<google::pubsub::v1::Topic> TopicAdminClient::GetTopic(
    std::string const& topic, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::pubsub::v1::GetTopicRequest request;
  request.set_topic(topic);
  return connection_->GetTopic(request);
}

StatusOr<google::pubsub::v1::Topic> TopicAdminClient::GetTopic(
    google::pubsub::v1::GetTopicRequest const& request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetTopic(request);
}

StreamRange<google::pubsub::v1::Topic> TopicAdminClient::ListTopics(
    std::string const& project, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::pubsub::v1::ListTopicsRequest request;
  request.set_project(project);
  return connection_->ListTopics(request);
}

StreamRange<google::pubsub::v1::Topic> TopicAdminClient::ListTopics(
    google::pubsub::v1::ListTopicsRequest request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListTopics(std::move(request));
}

StreamRange<std::string> TopicAdminClient::ListTopicSubscriptions(
    std::string const& topic, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::pubsub::v1::ListTopicSubscriptionsRequest request;
  request.set_topic(topic);
  return connection_->ListTopicSubscriptions(request);
}

StreamRange<std::string> TopicAdminClient::ListTopicSubscriptions(
    google::pubsub::v1::ListTopicSubscriptionsRequest request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListTopicSubscriptions(std::move(request));
}

StreamRange<std::string> TopicAdminClient::ListTopicSnapshots(
    std::string const& topic, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::pubsub::v1::ListTopicSnapshotsRequest request;
  request.set_topic(topic);
  return connection_->ListTopicSnapshots(request);
}

StreamRange<std::string> TopicAdminClient::ListTopicSnapshots(
    google::pubsub::v1::ListTopicSnapshotsRequest request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListTopicSnapshots(std::move(request));
}

Status TopicAdminClient::DeleteTopic(std::string const& topic, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::pubsub::v1::DeleteTopicRequest request;
  request.set_topic(topic);
  return connection_->DeleteTopic(request);
}

Status TopicAdminClient::DeleteTopic(
    google::pubsub::v1::DeleteTopicRequest const& request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteTopic(request);
}

StatusOr<google::pubsub::v1::DetachSubscriptionResponse>
TopicAdminClient::DetachSubscription(
    google::pubsub::v1::DetachSubscriptionRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DetachSubscription(request);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace pubsub_admin
}  // namespace cloud
}  // namespace google
