// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/video/livestream/v1/service.proto

#include "google/cloud/video/livestream/v1/livestream_connection_idempotency_policy.h"
#include <memory>

namespace google {
namespace cloud {
namespace video_livestream_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

using ::google::cloud::Idempotency;

LivestreamServiceConnectionIdempotencyPolicy::
    ~LivestreamServiceConnectionIdempotencyPolicy() = default;

std::unique_ptr<LivestreamServiceConnectionIdempotencyPolicy>
LivestreamServiceConnectionIdempotencyPolicy::clone() const {
  return std::make_unique<LivestreamServiceConnectionIdempotencyPolicy>(*this);
}

Idempotency LivestreamServiceConnectionIdempotencyPolicy::CreateChannel(
    google::cloud::video::livestream::v1::CreateChannelRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency LivestreamServiceConnectionIdempotencyPolicy::ListChannels(
    google::cloud::video::livestream::v1::ListChannelsRequest) {  // NOLINT
  return Idempotency::kIdempotent;
}

Idempotency LivestreamServiceConnectionIdempotencyPolicy::GetChannel(
    google::cloud::video::livestream::v1::GetChannelRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency LivestreamServiceConnectionIdempotencyPolicy::DeleteChannel(
    google::cloud::video::livestream::v1::DeleteChannelRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency LivestreamServiceConnectionIdempotencyPolicy::UpdateChannel(
    google::cloud::video::livestream::v1::UpdateChannelRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency LivestreamServiceConnectionIdempotencyPolicy::StartChannel(
    google::cloud::video::livestream::v1::StartChannelRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency LivestreamServiceConnectionIdempotencyPolicy::StopChannel(
    google::cloud::video::livestream::v1::StopChannelRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency LivestreamServiceConnectionIdempotencyPolicy::CreateInput(
    google::cloud::video::livestream::v1::CreateInputRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency LivestreamServiceConnectionIdempotencyPolicy::ListInputs(
    google::cloud::video::livestream::v1::ListInputsRequest) {  // NOLINT
  return Idempotency::kIdempotent;
}

Idempotency LivestreamServiceConnectionIdempotencyPolicy::GetInput(
    google::cloud::video::livestream::v1::GetInputRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency LivestreamServiceConnectionIdempotencyPolicy::DeleteInput(
    google::cloud::video::livestream::v1::DeleteInputRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency LivestreamServiceConnectionIdempotencyPolicy::UpdateInput(
    google::cloud::video::livestream::v1::UpdateInputRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency LivestreamServiceConnectionIdempotencyPolicy::CreateEvent(
    google::cloud::video::livestream::v1::CreateEventRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency LivestreamServiceConnectionIdempotencyPolicy::ListEvents(
    google::cloud::video::livestream::v1::ListEventsRequest) {  // NOLINT
  return Idempotency::kIdempotent;
}

Idempotency LivestreamServiceConnectionIdempotencyPolicy::GetEvent(
    google::cloud::video::livestream::v1::GetEventRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency LivestreamServiceConnectionIdempotencyPolicy::DeleteEvent(
    google::cloud::video::livestream::v1::DeleteEventRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency LivestreamServiceConnectionIdempotencyPolicy::CreateAsset(
    google::cloud::video::livestream::v1::CreateAssetRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency LivestreamServiceConnectionIdempotencyPolicy::DeleteAsset(
    google::cloud::video::livestream::v1::DeleteAssetRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency LivestreamServiceConnectionIdempotencyPolicy::GetAsset(
    google::cloud::video::livestream::v1::GetAssetRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency LivestreamServiceConnectionIdempotencyPolicy::ListAssets(
    google::cloud::video::livestream::v1::ListAssetsRequest) {  // NOLINT
  return Idempotency::kIdempotent;
}

Idempotency LivestreamServiceConnectionIdempotencyPolicy::GetPool(
    google::cloud::video::livestream::v1::GetPoolRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency LivestreamServiceConnectionIdempotencyPolicy::UpdatePool(
    google::cloud::video::livestream::v1::UpdatePoolRequest const&) {
  return Idempotency::kNonIdempotent;
}

std::unique_ptr<LivestreamServiceConnectionIdempotencyPolicy>
MakeDefaultLivestreamServiceConnectionIdempotencyPolicy() {
  return std::make_unique<LivestreamServiceConnectionIdempotencyPolicy>();
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace video_livestream_v1
}  // namespace cloud
}  // namespace google
