/*
 * Decompiled with CFR 0.152.
 */
package org.jrobin.mrtg.server;

import java.util.Vector;
import org.jrobin.mrtg.server.Device;
import org.jrobin.mrtg.server.Port;

class DeviceList {
    private Vector routers = new Vector();

    DeviceList() {
    }

    Vector getRouters() {
        return this.routers;
    }

    void setRouters(Vector vector) {
        this.routers = vector;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.routers.size(); ++i) {
            stringBuffer.append(this.routers.get(i));
        }
        return stringBuffer.toString();
    }

    Device getRouterByHost(String string) {
        for (int i = 0; i < this.routers.size(); ++i) {
            Device device = (Device)this.routers.get(i);
            if (!device.getHost().equalsIgnoreCase(string)) continue;
            return device;
        }
        return null;
    }

    int addRouter(String string, String string2, String string3, boolean bl) {
        Device device = this.getRouterByHost(string);
        if (device == null) {
            Device device2 = new Device();
            device2.setHost(string);
            device2.setCommunity(string2);
            device2.setDescr(string3);
            device2.setActive(bl);
            this.routers.add(device2);
            return 0;
        }
        return -1;
    }

    int updateRouter(String string, String string2, String string3, boolean bl) {
        Device device = this.getRouterByHost(string);
        if (device != null) {
            device.setCommunity(string2);
            device.setDescr(string3);
            device.setActive(bl);
            return 0;
        }
        return -1;
    }

    int removeRouter(String string) {
        Device device = this.getRouterByHost(string);
        if (device == null) {
            return -1;
        }
        if (device.getLinkCount() > 0) {
            return -2;
        }
        this.routers.remove(device);
        return 0;
    }

    int addLink(String string, String string2, String string3, int n, boolean bl) {
        Device device = this.getRouterByHost(string);
        if (device == null) {
            return -1;
        }
        Port port = device.getLinkByIfDescr(string2);
        if (port != null) {
            return -2;
        }
        Port port2 = new Port();
        port2.setDescr(string3);
        port2.setIfDescr(string2);
        port2.setSamplingInterval(n);
        port2.setActive(bl);
        device.addLink(port2);
        return 0;
    }

    int updateLink(String string, String string2, String string3, int n, boolean bl) {
        Device device = this.getRouterByHost(string);
        if (device == null) {
            return -1;
        }
        Port port = device.getLinkByIfDescr(string2);
        if (port == null) {
            return -2;
        }
        port.setDescr(string3);
        port.setSamplingInterval(n);
        port.setActive(bl);
        return 0;
    }

    int removeLink(String string, String string2) {
        Device device = this.getRouterByHost(string);
        if (device == null) {
            return -1;
        }
        Port port = device.getLinkByIfDescr(string2);
        if (port == null) {
            return -2;
        }
        device.removeLink(port);
        return 0;
    }
}

