/*
 * Decompiled with CFR 0.152.
 */
package org.jrobin.mrtg.client;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jrobin.mrtg.client.RouterInfo;
import org.jrobin.mrtg.client.Util;

class EditRouterDialog
extends JDialog {
    static final String ADD_TITLE = "New router";
    static final String EDIT_TITLE = "Edit router data";
    private RouterInfo routerInfo;
    private JLabel hostLabel = Util.standardLabel("Address: ");
    private JLabel communityLabel = Util.standardLabel("Community: ");
    private JLabel descrLabel = Util.standardLabel("Description: ");
    private JLabel activeLabel = Util.standardLabel("Active: ");
    private JTextField hostField = Util.standardTextField();
    private JTextField communityField = Util.standardTextField();
    private JTextField descrField = Util.standardTextField();
    private JCheckBox activeBox = new JCheckBox("", true);
    private JButton okButton = Util.standardButton("OK");
    private JButton cancelButton = Util.standardButton("Cancel");

    EditRouterDialog(Frame frame) {
        this(frame, (RouterInfo)null);
    }

    EditRouterDialog(Frame frame, RouterInfo routerInfo) {
        super(frame, routerInfo == null ? ADD_TITLE : EDIT_TITLE, true);
        this.routerInfo = routerInfo;
        this.constructUserInterface();
        this.pack();
        this.setVisible(true);
    }

    private void constructUserInterface() {
        JPanel jPanel = (JPanel)this.getContentPane();
        Box box = Box.createVerticalBox();
        box.add(Util.getPanelFor(this.hostLabel, this.hostField));
        box.add(Util.getPanelFor(this.communityLabel, this.communityField));
        box.add(Util.getPanelFor(this.descrLabel, this.descrField));
        box.add(Util.getPanelFor(this.activeLabel, this.activeBox));
        box.add(Util.getPanelFor(Util.standardLabel(), this.okButton, this.cancelButton));
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                EditRouterDialog.this.ok();
            }
        });
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                EditRouterDialog.this.cancel();
            }
        });
        jPanel.add(box);
        this.setDefaultCloseOperation(2);
        if (this.routerInfo != null) {
            this.hostField.setText(this.routerInfo.getHost());
            this.hostField.setEnabled(false);
            this.communityField.setText(this.routerInfo.getCommunity());
            this.descrField.setText(this.routerInfo.getDescr());
            this.activeBox.setSelected(this.routerInfo.isActive());
        }
        this.okButton.setMnemonic(79);
        this.cancelButton.setMnemonic(67);
        this.getRootPane().setDefaultButton(this.okButton);
        this.setDefaultCloseOperation(2);
        Util.centerOnScreen(this);
    }

    private void close() {
        this.dispatchEvent(new WindowEvent(this, 201));
    }

    private void ok() {
        if (this.hostField.getText().length() == 0) {
            Util.warn(this, "Please enter router address");
        } else if (this.communityField.getText().length() == 0) {
            Util.warn(this, "Please eneter router community");
        } else {
            this.routerInfo = new RouterInfo();
            this.routerInfo.setHost(this.hostField.getText());
            this.routerInfo.setCommunity(this.communityField.getText());
            this.routerInfo.setDescr(this.descrField.getText());
            this.routerInfo.setActive(this.activeBox.isSelected());
            this.close();
        }
    }

    private void cancel() {
        this.routerInfo = null;
        this.close();
    }

    RouterInfo getRouterInfo() {
        return this.routerInfo;
    }
}

