/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.routing.experimentalAStar3.storage;

import com.sun.electric.tool.routing.experimentalAStar3.algorithm.AStarMapBase;
import com.sun.electric.tool.routing.experimentalAStar3.algorithm.AStarNode;
import com.sun.electric.tool.routing.experimentalAStar3.algorithm.AStarOpenListBase;
import com.sun.electric.tool.routing.experimentalAStar3.storage.AStarNodePriorityQueue;
import java.util.Collection;

public class AStarOpenListPriorityQueue2
implements AStarOpenListBase<AStarNode> {
    private AStarNodePriorityQueue queue = new AStarNodePriorityQueue();
    private AStarMapBase<AStarNode> map;

    public void setMap(AStarMapBase<AStarNode> map2) {
        this.map = map2;
    }

    @Override
    public void addNodeToOpenList(AStarNode node) {
        node.markAsOpen();
        if (node.pq_i == 0) {
            this.queue.push(node);
        } else {
            this.queue.update(node);
        }
    }

    @Override
    public AStarNode findOpenNode(int x, int y, int z) {
        AStarNode node = this.map.nodeAt(x, y, z);
        if (node.isOpen()) {
            return node;
        }
        return null;
    }

    @Override
    public boolean isOpenListEmpty() {
        return this.queue.empty();
    }

    @Override
    public AStarNode removeCheapestOpenNode() {
        if (this.queue.empty()) {
            return null;
        }
        AStarNode node = (AStarNode)this.queue.top();
        this.queue.pop();
        node.markAsNoList();
        assert (node.pq_i == 0);
        return node;
    }

    public Collection<AStarNode> dumpOpenList() {
        assert (false);
        this.queue.clear();
        return null;
    }

    @Override
    public void removeNodeFromOpenList(AStarNode node) {
        assert (node.isOpen());
        node.markAsNoList();
        this.queue.remove(node);
    }

    @Override
    public void clearOpenList() {
        AStarNode[] elements = (AStarNode[])this.queue.getElements();
        for (int i = 1; i <= this.queue.size(); ++i) {
            AStarNode e = elements[i];
            e.markAsNoList();
            e.pq_i = 0;
        }
        this.queue.setEmpty();
    }
}

