//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::ptr::NonNull;
use objc2::__framework_prelude::*;
use objc2_foundation::*;

use crate::*;

/// [Apple's documentation](https://developer.apple.com/documentation/metal/mtldatatype?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct MTLDataType(pub NSUInteger);
impl MTLDataType {
    #[doc(alias = "MTLDataTypeNone")]
    pub const None: Self = Self(0);
    #[doc(alias = "MTLDataTypeStruct")]
    pub const Struct: Self = Self(1);
    #[doc(alias = "MTLDataTypeArray")]
    pub const Array: Self = Self(2);
    #[doc(alias = "MTLDataTypeFloat")]
    pub const Float: Self = Self(3);
    #[doc(alias = "MTLDataTypeFloat2")]
    pub const Float2: Self = Self(4);
    #[doc(alias = "MTLDataTypeFloat3")]
    pub const Float3: Self = Self(5);
    #[doc(alias = "MTLDataTypeFloat4")]
    pub const Float4: Self = Self(6);
    #[doc(alias = "MTLDataTypeFloat2x2")]
    pub const Float2x2: Self = Self(7);
    #[doc(alias = "MTLDataTypeFloat2x3")]
    pub const Float2x3: Self = Self(8);
    #[doc(alias = "MTLDataTypeFloat2x4")]
    pub const Float2x4: Self = Self(9);
    #[doc(alias = "MTLDataTypeFloat3x2")]
    pub const Float3x2: Self = Self(10);
    #[doc(alias = "MTLDataTypeFloat3x3")]
    pub const Float3x3: Self = Self(11);
    #[doc(alias = "MTLDataTypeFloat3x4")]
    pub const Float3x4: Self = Self(12);
    #[doc(alias = "MTLDataTypeFloat4x2")]
    pub const Float4x2: Self = Self(13);
    #[doc(alias = "MTLDataTypeFloat4x3")]
    pub const Float4x3: Self = Self(14);
    #[doc(alias = "MTLDataTypeFloat4x4")]
    pub const Float4x4: Self = Self(15);
    #[doc(alias = "MTLDataTypeHalf")]
    pub const Half: Self = Self(16);
    #[doc(alias = "MTLDataTypeHalf2")]
    pub const Half2: Self = Self(17);
    #[doc(alias = "MTLDataTypeHalf3")]
    pub const Half3: Self = Self(18);
    #[doc(alias = "MTLDataTypeHalf4")]
    pub const Half4: Self = Self(19);
    #[doc(alias = "MTLDataTypeHalf2x2")]
    pub const Half2x2: Self = Self(20);
    #[doc(alias = "MTLDataTypeHalf2x3")]
    pub const Half2x3: Self = Self(21);
    #[doc(alias = "MTLDataTypeHalf2x4")]
    pub const Half2x4: Self = Self(22);
    #[doc(alias = "MTLDataTypeHalf3x2")]
    pub const Half3x2: Self = Self(23);
    #[doc(alias = "MTLDataTypeHalf3x3")]
    pub const Half3x3: Self = Self(24);
    #[doc(alias = "MTLDataTypeHalf3x4")]
    pub const Half3x4: Self = Self(25);
    #[doc(alias = "MTLDataTypeHalf4x2")]
    pub const Half4x2: Self = Self(26);
    #[doc(alias = "MTLDataTypeHalf4x3")]
    pub const Half4x3: Self = Self(27);
    #[doc(alias = "MTLDataTypeHalf4x4")]
    pub const Half4x4: Self = Self(28);
    #[doc(alias = "MTLDataTypeInt")]
    pub const Int: Self = Self(29);
    #[doc(alias = "MTLDataTypeInt2")]
    pub const Int2: Self = Self(30);
    #[doc(alias = "MTLDataTypeInt3")]
    pub const Int3: Self = Self(31);
    #[doc(alias = "MTLDataTypeInt4")]
    pub const Int4: Self = Self(32);
    #[doc(alias = "MTLDataTypeUInt")]
    pub const UInt: Self = Self(33);
    #[doc(alias = "MTLDataTypeUInt2")]
    pub const UInt2: Self = Self(34);
    #[doc(alias = "MTLDataTypeUInt3")]
    pub const UInt3: Self = Self(35);
    #[doc(alias = "MTLDataTypeUInt4")]
    pub const UInt4: Self = Self(36);
    #[doc(alias = "MTLDataTypeShort")]
    pub const Short: Self = Self(37);
    #[doc(alias = "MTLDataTypeShort2")]
    pub const Short2: Self = Self(38);
    #[doc(alias = "MTLDataTypeShort3")]
    pub const Short3: Self = Self(39);
    #[doc(alias = "MTLDataTypeShort4")]
    pub const Short4: Self = Self(40);
    #[doc(alias = "MTLDataTypeUShort")]
    pub const UShort: Self = Self(41);
    #[doc(alias = "MTLDataTypeUShort2")]
    pub const UShort2: Self = Self(42);
    #[doc(alias = "MTLDataTypeUShort3")]
    pub const UShort3: Self = Self(43);
    #[doc(alias = "MTLDataTypeUShort4")]
    pub const UShort4: Self = Self(44);
    #[doc(alias = "MTLDataTypeChar")]
    pub const Char: Self = Self(45);
    #[doc(alias = "MTLDataTypeChar2")]
    pub const Char2: Self = Self(46);
    #[doc(alias = "MTLDataTypeChar3")]
    pub const Char3: Self = Self(47);
    #[doc(alias = "MTLDataTypeChar4")]
    pub const Char4: Self = Self(48);
    #[doc(alias = "MTLDataTypeUChar")]
    pub const UChar: Self = Self(49);
    #[doc(alias = "MTLDataTypeUChar2")]
    pub const UChar2: Self = Self(50);
    #[doc(alias = "MTLDataTypeUChar3")]
    pub const UChar3: Self = Self(51);
    #[doc(alias = "MTLDataTypeUChar4")]
    pub const UChar4: Self = Self(52);
    #[doc(alias = "MTLDataTypeBool")]
    pub const Bool: Self = Self(53);
    #[doc(alias = "MTLDataTypeBool2")]
    pub const Bool2: Self = Self(54);
    #[doc(alias = "MTLDataTypeBool3")]
    pub const Bool3: Self = Self(55);
    #[doc(alias = "MTLDataTypeBool4")]
    pub const Bool4: Self = Self(56);
    #[doc(alias = "MTLDataTypeTexture")]
    pub const Texture: Self = Self(58);
    #[doc(alias = "MTLDataTypeSampler")]
    pub const Sampler: Self = Self(59);
    #[doc(alias = "MTLDataTypePointer")]
    pub const Pointer: Self = Self(60);
    #[doc(alias = "MTLDataTypeR8Unorm")]
    pub const R8Unorm: Self = Self(62);
    #[doc(alias = "MTLDataTypeR8Snorm")]
    pub const R8Snorm: Self = Self(63);
    #[doc(alias = "MTLDataTypeR16Unorm")]
    pub const R16Unorm: Self = Self(64);
    #[doc(alias = "MTLDataTypeR16Snorm")]
    pub const R16Snorm: Self = Self(65);
    #[doc(alias = "MTLDataTypeRG8Unorm")]
    pub const RG8Unorm: Self = Self(66);
    #[doc(alias = "MTLDataTypeRG8Snorm")]
    pub const RG8Snorm: Self = Self(67);
    #[doc(alias = "MTLDataTypeRG16Unorm")]
    pub const RG16Unorm: Self = Self(68);
    #[doc(alias = "MTLDataTypeRG16Snorm")]
    pub const RG16Snorm: Self = Self(69);
    #[doc(alias = "MTLDataTypeRGBA8Unorm")]
    pub const RGBA8Unorm: Self = Self(70);
    #[doc(alias = "MTLDataTypeRGBA8Unorm_sRGB")]
    pub const RGBA8Unorm_sRGB: Self = Self(71);
    #[doc(alias = "MTLDataTypeRGBA8Snorm")]
    pub const RGBA8Snorm: Self = Self(72);
    #[doc(alias = "MTLDataTypeRGBA16Unorm")]
    pub const RGBA16Unorm: Self = Self(73);
    #[doc(alias = "MTLDataTypeRGBA16Snorm")]
    pub const RGBA16Snorm: Self = Self(74);
    #[doc(alias = "MTLDataTypeRGB10A2Unorm")]
    pub const RGB10A2Unorm: Self = Self(75);
    #[doc(alias = "MTLDataTypeRG11B10Float")]
    pub const RG11B10Float: Self = Self(76);
    #[doc(alias = "MTLDataTypeRGB9E5Float")]
    pub const RGB9E5Float: Self = Self(77);
    #[doc(alias = "MTLDataTypeRenderPipeline")]
    pub const RenderPipeline: Self = Self(78);
    #[doc(alias = "MTLDataTypeComputePipeline")]
    pub const ComputePipeline: Self = Self(79);
    #[doc(alias = "MTLDataTypeIndirectCommandBuffer")]
    pub const IndirectCommandBuffer: Self = Self(80);
    #[doc(alias = "MTLDataTypeLong")]
    pub const Long: Self = Self(81);
    #[doc(alias = "MTLDataTypeLong2")]
    pub const Long2: Self = Self(82);
    #[doc(alias = "MTLDataTypeLong3")]
    pub const Long3: Self = Self(83);
    #[doc(alias = "MTLDataTypeLong4")]
    pub const Long4: Self = Self(84);
    #[doc(alias = "MTLDataTypeULong")]
    pub const ULong: Self = Self(85);
    #[doc(alias = "MTLDataTypeULong2")]
    pub const ULong2: Self = Self(86);
    #[doc(alias = "MTLDataTypeULong3")]
    pub const ULong3: Self = Self(87);
    #[doc(alias = "MTLDataTypeULong4")]
    pub const ULong4: Self = Self(88);
    #[doc(alias = "MTLDataTypeVisibleFunctionTable")]
    pub const VisibleFunctionTable: Self = Self(115);
    #[doc(alias = "MTLDataTypeIntersectionFunctionTable")]
    pub const IntersectionFunctionTable: Self = Self(116);
    #[doc(alias = "MTLDataTypePrimitiveAccelerationStructure")]
    pub const PrimitiveAccelerationStructure: Self = Self(117);
    #[doc(alias = "MTLDataTypeInstanceAccelerationStructure")]
    pub const InstanceAccelerationStructure: Self = Self(118);
    #[doc(alias = "MTLDataTypeBFloat")]
    pub const BFloat: Self = Self(121);
    #[doc(alias = "MTLDataTypeBFloat2")]
    pub const BFloat2: Self = Self(122);
    #[doc(alias = "MTLDataTypeBFloat3")]
    pub const BFloat3: Self = Self(123);
    #[doc(alias = "MTLDataTypeBFloat4")]
    pub const BFloat4: Self = Self(124);
}

unsafe impl Encode for MTLDataType {
    const ENCODING: Encoding = NSUInteger::ENCODING;
}

unsafe impl RefEncode for MTLDataType {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// The type of a resource binding.
///
///
/// This binding represents a buffer.
///
///
/// This binding represents threadgroup memory.
///
///
/// This binding represents a texture.
///
///
/// This binding represents a sampler.
///
///
/// This binding represents an image block data.
///
///
/// This binding represents an image block.
///
///
/// This binding represents a visible function table object.
///
///
/// This binding represents a primitive acceleration structure object.
///
///
/// This binding represents an instance acceleration structure object.
///
///
/// This binding represents an intersection function table object.
///
///
/// This binding represents an object payload.
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/metal/mtlbindingtype?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct MTLBindingType(pub NSInteger);
impl MTLBindingType {
    #[doc(alias = "MTLBindingTypeBuffer")]
    pub const Buffer: Self = Self(0);
    #[doc(alias = "MTLBindingTypeThreadgroupMemory")]
    pub const ThreadgroupMemory: Self = Self(1);
    #[doc(alias = "MTLBindingTypeTexture")]
    pub const Texture: Self = Self(2);
    #[doc(alias = "MTLBindingTypeSampler")]
    pub const Sampler: Self = Self(3);
    #[doc(alias = "MTLBindingTypeImageblockData")]
    pub const ImageblockData: Self = Self(16);
    #[doc(alias = "MTLBindingTypeImageblock")]
    pub const Imageblock: Self = Self(17);
    #[doc(alias = "MTLBindingTypeVisibleFunctionTable")]
    pub const VisibleFunctionTable: Self = Self(24);
    #[doc(alias = "MTLBindingTypePrimitiveAccelerationStructure")]
    pub const PrimitiveAccelerationStructure: Self = Self(25);
    #[doc(alias = "MTLBindingTypeInstanceAccelerationStructure")]
    pub const InstanceAccelerationStructure: Self = Self(26);
    #[doc(alias = "MTLBindingTypeIntersectionFunctionTable")]
    pub const IntersectionFunctionTable: Self = Self(27);
    #[doc(alias = "MTLBindingTypeObjectPayload")]
    pub const ObjectPayload: Self = Self(34);
}

unsafe impl Encode for MTLBindingType {
    const ENCODING: Encoding = NSInteger::ENCODING;
}

unsafe impl RefEncode for MTLBindingType {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// The type for an input to a MTLRenderPipelineState or a MTLComputePipelineState
///
///
/// This input is a MTLBuffer
///
///
/// This input is a pointer to the threadgroup memory.
///
///
/// This input is a MTLTexture.
///
///
/// This input is a sampler.
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/metal/mtlargumenttype?language=objc)
// NS_ENUM
#[deprecated]
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct MTLArgumentType(pub NSUInteger);
impl MTLArgumentType {
    #[doc(alias = "MTLArgumentTypeBuffer")]
    #[deprecated]
    pub const Buffer: Self = Self(0);
    #[doc(alias = "MTLArgumentTypeThreadgroupMemory")]
    #[deprecated]
    pub const ThreadgroupMemory: Self = Self(1);
    #[doc(alias = "MTLArgumentTypeTexture")]
    #[deprecated]
    pub const Texture: Self = Self(2);
    #[doc(alias = "MTLArgumentTypeSampler")]
    #[deprecated]
    pub const Sampler: Self = Self(3);
    #[doc(alias = "MTLArgumentTypeImageblockData")]
    pub const ImageblockData: Self = Self(16);
    #[doc(alias = "MTLArgumentTypeImageblock")]
    pub const Imageblock: Self = Self(17);
    #[doc(alias = "MTLArgumentTypeVisibleFunctionTable")]
    pub const VisibleFunctionTable: Self = Self(24);
    #[doc(alias = "MTLArgumentTypePrimitiveAccelerationStructure")]
    pub const PrimitiveAccelerationStructure: Self = Self(25);
    #[doc(alias = "MTLArgumentTypeInstanceAccelerationStructure")]
    pub const InstanceAccelerationStructure: Self = Self(26);
    #[doc(alias = "MTLArgumentTypeIntersectionFunctionTable")]
    pub const IntersectionFunctionTable: Self = Self(27);
}

unsafe impl Encode for MTLArgumentType {
    const ENCODING: Encoding = NSUInteger::ENCODING;
}

unsafe impl RefEncode for MTLArgumentType {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/metal/mtlbindingaccess?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct MTLBindingAccess(pub NSUInteger);
impl MTLBindingAccess {
    #[doc(alias = "MTLBindingAccessReadOnly")]
    pub const ReadOnly: Self = Self(0);
    #[doc(alias = "MTLBindingAccessReadWrite")]
    pub const ReadWrite: Self = Self(1);
    #[doc(alias = "MTLBindingAccessWriteOnly")]
    pub const WriteOnly: Self = Self(2);
    #[deprecated]
    pub const MTLArgumentAccessReadOnly: Self = Self(MTLBindingAccess::ReadOnly.0);
    #[deprecated]
    pub const MTLArgumentAccessReadWrite: Self = Self(MTLBindingAccess::ReadWrite.0);
    #[deprecated]
    pub const MTLArgumentAccessWriteOnly: Self = Self(MTLBindingAccess::WriteOnly.0);
}

unsafe impl Encode for MTLBindingAccess {
    const ENCODING: Encoding = NSUInteger::ENCODING;
}

unsafe impl RefEncode for MTLBindingAccess {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/metal/mtlargumentaccess?language=objc)
pub type MTLArgumentAccess = MTLBindingAccess;

extern_class!(
    /// [Apple's documentation](https://developer.apple.com/documentation/metal/mtltype?language=objc)
    #[unsafe(super(NSObject))]
    #[derive(Debug, PartialEq, Eq, Hash)]
    pub struct MTLType;
);

extern_conformance!(
    unsafe impl NSObjectProtocol for MTLType {}
);

impl MTLType {
    extern_methods!(
        #[unsafe(method(dataType))]
        #[unsafe(method_family = none)]
        pub unsafe fn dataType(&self) -> MTLDataType;
    );
}

/// Methods declared on superclass `NSObject`.
impl MTLType {
    extern_methods!(
        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub unsafe fn init(this: Allocated<Self>) -> Retained<Self>;

        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub unsafe fn new() -> Retained<Self>;
    );
}

extern_class!(
    /// [Apple's documentation](https://developer.apple.com/documentation/metal/mtlstructmember?language=objc)
    #[unsafe(super(NSObject))]
    #[derive(Debug, PartialEq, Eq, Hash)]
    pub struct MTLStructMember;
);

extern_conformance!(
    unsafe impl NSObjectProtocol for MTLStructMember {}
);

impl MTLStructMember {
    extern_methods!(
        #[unsafe(method(name))]
        #[unsafe(method_family = none)]
        pub fn name(&self) -> Retained<NSString>;

        #[unsafe(method(offset))]
        #[unsafe(method_family = none)]
        pub fn offset(&self) -> NSUInteger;

        #[unsafe(method(dataType))]
        #[unsafe(method_family = none)]
        pub fn dataType(&self) -> MTLDataType;

        #[unsafe(method(structType))]
        #[unsafe(method_family = none)]
        pub fn structType(&self) -> Option<Retained<MTLStructType>>;

        #[unsafe(method(arrayType))]
        #[unsafe(method_family = none)]
        pub fn arrayType(&self) -> Option<Retained<MTLArrayType>>;

        #[unsafe(method(textureReferenceType))]
        #[unsafe(method_family = none)]
        pub unsafe fn textureReferenceType(&self) -> Option<Retained<MTLTextureReferenceType>>;

        #[unsafe(method(pointerType))]
        #[unsafe(method_family = none)]
        pub unsafe fn pointerType(&self) -> Option<Retained<MTLPointerType>>;

        #[unsafe(method(argumentIndex))]
        #[unsafe(method_family = none)]
        pub unsafe fn argumentIndex(&self) -> NSUInteger;
    );
}

/// Methods declared on superclass `NSObject`.
impl MTLStructMember {
    extern_methods!(
        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub unsafe fn init(this: Allocated<Self>) -> Retained<Self>;

        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub unsafe fn new() -> Retained<Self>;
    );
}

extern_class!(
    /// [Apple's documentation](https://developer.apple.com/documentation/metal/mtlstructtype?language=objc)
    #[unsafe(super(MTLType, NSObject))]
    #[derive(Debug, PartialEq, Eq, Hash)]
    pub struct MTLStructType;
);

extern_conformance!(
    unsafe impl NSObjectProtocol for MTLStructType {}
);

impl MTLStructType {
    extern_methods!(
        #[unsafe(method(members))]
        #[unsafe(method_family = none)]
        pub fn members(&self) -> Retained<NSArray<MTLStructMember>>;

        #[unsafe(method(memberByName:))]
        #[unsafe(method_family = none)]
        pub fn memberByName(&self, name: &NSString) -> Option<Retained<MTLStructMember>>;
    );
}

/// Methods declared on superclass `NSObject`.
impl MTLStructType {
    extern_methods!(
        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub unsafe fn init(this: Allocated<Self>) -> Retained<Self>;

        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub unsafe fn new() -> Retained<Self>;
    );
}

extern_class!(
    /// [Apple's documentation](https://developer.apple.com/documentation/metal/mtlarraytype?language=objc)
    #[unsafe(super(MTLType, NSObject))]
    #[derive(Debug, PartialEq, Eq, Hash)]
    pub struct MTLArrayType;
);

extern_conformance!(
    unsafe impl NSObjectProtocol for MTLArrayType {}
);

impl MTLArrayType {
    extern_methods!(
        #[unsafe(method(elementType))]
        #[unsafe(method_family = none)]
        pub fn elementType(&self) -> MTLDataType;

        #[unsafe(method(arrayLength))]
        #[unsafe(method_family = none)]
        pub fn arrayLength(&self) -> NSUInteger;

        #[unsafe(method(stride))]
        #[unsafe(method_family = none)]
        pub fn stride(&self) -> NSUInteger;

        #[unsafe(method(argumentIndexStride))]
        #[unsafe(method_family = none)]
        pub unsafe fn argumentIndexStride(&self) -> NSUInteger;

        #[unsafe(method(elementStructType))]
        #[unsafe(method_family = none)]
        pub fn elementStructType(&self) -> Option<Retained<MTLStructType>>;

        #[unsafe(method(elementArrayType))]
        #[unsafe(method_family = none)]
        pub fn elementArrayType(&self) -> Option<Retained<MTLArrayType>>;

        #[unsafe(method(elementTextureReferenceType))]
        #[unsafe(method_family = none)]
        pub unsafe fn elementTextureReferenceType(
            &self,
        ) -> Option<Retained<MTLTextureReferenceType>>;

        #[unsafe(method(elementPointerType))]
        #[unsafe(method_family = none)]
        pub unsafe fn elementPointerType(&self) -> Option<Retained<MTLPointerType>>;
    );
}

/// Methods declared on superclass `NSObject`.
impl MTLArrayType {
    extern_methods!(
        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub unsafe fn init(this: Allocated<Self>) -> Retained<Self>;

        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub unsafe fn new() -> Retained<Self>;
    );
}

extern_class!(
    /// [Apple's documentation](https://developer.apple.com/documentation/metal/mtlpointertype?language=objc)
    #[unsafe(super(MTLType, NSObject))]
    #[derive(Debug, PartialEq, Eq, Hash)]
    pub struct MTLPointerType;
);

extern_conformance!(
    unsafe impl NSObjectProtocol for MTLPointerType {}
);

impl MTLPointerType {
    extern_methods!(
        #[unsafe(method(elementType))]
        #[unsafe(method_family = none)]
        pub unsafe fn elementType(&self) -> MTLDataType;

        #[unsafe(method(access))]
        #[unsafe(method_family = none)]
        pub unsafe fn access(&self) -> MTLBindingAccess;

        #[unsafe(method(alignment))]
        #[unsafe(method_family = none)]
        pub unsafe fn alignment(&self) -> NSUInteger;

        #[unsafe(method(dataSize))]
        #[unsafe(method_family = none)]
        pub unsafe fn dataSize(&self) -> NSUInteger;

        #[unsafe(method(elementIsArgumentBuffer))]
        #[unsafe(method_family = none)]
        pub unsafe fn elementIsArgumentBuffer(&self) -> bool;

        #[unsafe(method(elementStructType))]
        #[unsafe(method_family = none)]
        pub unsafe fn elementStructType(&self) -> Option<Retained<MTLStructType>>;

        #[unsafe(method(elementArrayType))]
        #[unsafe(method_family = none)]
        pub unsafe fn elementArrayType(&self) -> Option<Retained<MTLArrayType>>;
    );
}

/// Methods declared on superclass `NSObject`.
impl MTLPointerType {
    extern_methods!(
        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub unsafe fn init(this: Allocated<Self>) -> Retained<Self>;

        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub unsafe fn new() -> Retained<Self>;
    );
}

extern_class!(
    /// [Apple's documentation](https://developer.apple.com/documentation/metal/mtltexturereferencetype?language=objc)
    #[unsafe(super(MTLType, NSObject))]
    #[derive(Debug, PartialEq, Eq, Hash)]
    pub struct MTLTextureReferenceType;
);

extern_conformance!(
    unsafe impl NSObjectProtocol for MTLTextureReferenceType {}
);

impl MTLTextureReferenceType {
    extern_methods!(
        #[unsafe(method(textureDataType))]
        #[unsafe(method_family = none)]
        pub unsafe fn textureDataType(&self) -> MTLDataType;

        #[cfg(feature = "MTLTexture")]
        #[unsafe(method(textureType))]
        #[unsafe(method_family = none)]
        pub unsafe fn textureType(&self) -> MTLTextureType;

        #[unsafe(method(access))]
        #[unsafe(method_family = none)]
        pub unsafe fn access(&self) -> MTLBindingAccess;

        #[unsafe(method(isDepthTexture))]
        #[unsafe(method_family = none)]
        pub unsafe fn isDepthTexture(&self) -> bool;
    );
}

/// Methods declared on superclass `NSObject`.
impl MTLTextureReferenceType {
    extern_methods!(
        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub unsafe fn init(this: Allocated<Self>) -> Retained<Self>;

        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub unsafe fn new() -> Retained<Self>;
    );
}

extern_class!(
    /// MTLArgument
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/metal/mtlargument?language=objc)
    #[unsafe(super(NSObject))]
    #[derive(Debug, PartialEq, Eq, Hash)]
    #[deprecated]
    pub struct MTLArgument;
);

extern_conformance!(
    unsafe impl NSObjectProtocol for MTLArgument {}
);

impl MTLArgument {
    extern_methods!(
        #[deprecated]
        #[unsafe(method(name))]
        #[unsafe(method_family = none)]
        pub fn name(&self) -> Retained<NSString>;

        #[deprecated]
        #[unsafe(method(type))]
        #[unsafe(method_family = none)]
        pub unsafe fn r#type(&self) -> MTLArgumentType;

        #[deprecated]
        #[unsafe(method(access))]
        #[unsafe(method_family = none)]
        pub fn access(&self) -> MTLBindingAccess;

        #[deprecated]
        #[unsafe(method(index))]
        #[unsafe(method_family = none)]
        pub fn index(&self) -> NSUInteger;

        #[deprecated]
        #[unsafe(method(isActive))]
        #[unsafe(method_family = none)]
        pub fn isActive(&self) -> bool;

        #[deprecated]
        #[unsafe(method(bufferAlignment))]
        #[unsafe(method_family = none)]
        pub fn bufferAlignment(&self) -> NSUInteger;

        #[deprecated]
        #[unsafe(method(bufferDataSize))]
        #[unsafe(method_family = none)]
        pub fn bufferDataSize(&self) -> NSUInteger;

        #[deprecated]
        #[unsafe(method(bufferDataType))]
        #[unsafe(method_family = none)]
        pub fn bufferDataType(&self) -> MTLDataType;

        #[deprecated]
        #[unsafe(method(bufferStructType))]
        #[unsafe(method_family = none)]
        pub fn bufferStructType(&self) -> Option<Retained<MTLStructType>>;

        #[unsafe(method(bufferPointerType))]
        #[unsafe(method_family = none)]
        pub unsafe fn bufferPointerType(&self) -> Option<Retained<MTLPointerType>>;

        #[deprecated]
        #[unsafe(method(threadgroupMemoryAlignment))]
        #[unsafe(method_family = none)]
        pub fn threadgroupMemoryAlignment(&self) -> NSUInteger;

        #[deprecated]
        #[unsafe(method(threadgroupMemoryDataSize))]
        #[unsafe(method_family = none)]
        pub fn threadgroupMemoryDataSize(&self) -> NSUInteger;

        #[cfg(feature = "MTLTexture")]
        #[deprecated]
        #[unsafe(method(textureType))]
        #[unsafe(method_family = none)]
        pub fn textureType(&self) -> MTLTextureType;

        #[deprecated]
        #[unsafe(method(textureDataType))]
        #[unsafe(method_family = none)]
        pub fn textureDataType(&self) -> MTLDataType;

        #[unsafe(method(isDepthTexture))]
        #[unsafe(method_family = none)]
        pub unsafe fn isDepthTexture(&self) -> bool;

        #[unsafe(method(arrayLength))]
        #[unsafe(method_family = none)]
        pub unsafe fn arrayLength(&self) -> NSUInteger;
    );
}

/// Methods declared on superclass `NSObject`.
impl MTLArgument {
    extern_methods!(
        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub unsafe fn init(this: Allocated<Self>) -> Retained<Self>;

        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub unsafe fn new() -> Retained<Self>;
    );
}

extern_protocol!(
    /// [Apple's documentation](https://developer.apple.com/documentation/metal/mtlbinding?language=objc)
    pub unsafe trait MTLBinding: NSObjectProtocol {
        #[unsafe(method(name))]
        #[unsafe(method_family = none)]
        unsafe fn name(&self) -> Retained<NSString>;

        #[unsafe(method(type))]
        #[unsafe(method_family = none)]
        unsafe fn r#type(&self) -> MTLBindingType;

        #[unsafe(method(access))]
        #[unsafe(method_family = none)]
        unsafe fn access(&self) -> MTLBindingAccess;

        #[unsafe(method(index))]
        #[unsafe(method_family = none)]
        unsafe fn index(&self) -> NSUInteger;

        #[unsafe(method(isUsed))]
        #[unsafe(method_family = none)]
        unsafe fn isUsed(&self) -> bool;

        #[unsafe(method(isArgument))]
        #[unsafe(method_family = none)]
        unsafe fn isArgument(&self) -> bool;
    }
);

extern_protocol!(
    /// [Apple's documentation](https://developer.apple.com/documentation/metal/mtlbufferbinding?language=objc)
    pub unsafe trait MTLBufferBinding: MTLBinding {
        #[unsafe(method(bufferAlignment))]
        #[unsafe(method_family = none)]
        unsafe fn bufferAlignment(&self) -> NSUInteger;

        #[unsafe(method(bufferDataSize))]
        #[unsafe(method_family = none)]
        unsafe fn bufferDataSize(&self) -> NSUInteger;

        #[unsafe(method(bufferDataType))]
        #[unsafe(method_family = none)]
        unsafe fn bufferDataType(&self) -> MTLDataType;

        #[unsafe(method(bufferStructType))]
        #[unsafe(method_family = none)]
        unsafe fn bufferStructType(&self) -> Option<Retained<MTLStructType>>;

        #[unsafe(method(bufferPointerType))]
        #[unsafe(method_family = none)]
        unsafe fn bufferPointerType(&self) -> Option<Retained<MTLPointerType>>;
    }
);

extern_protocol!(
    /// [Apple's documentation](https://developer.apple.com/documentation/metal/mtlthreadgroupbinding?language=objc)
    pub unsafe trait MTLThreadgroupBinding: MTLBinding {
        #[unsafe(method(threadgroupMemoryAlignment))]
        #[unsafe(method_family = none)]
        unsafe fn threadgroupMemoryAlignment(&self) -> NSUInteger;

        #[unsafe(method(threadgroupMemoryDataSize))]
        #[unsafe(method_family = none)]
        unsafe fn threadgroupMemoryDataSize(&self) -> NSUInteger;
    }
);

extern_protocol!(
    /// [Apple's documentation](https://developer.apple.com/documentation/metal/mtltexturebinding?language=objc)
    pub unsafe trait MTLTextureBinding: MTLBinding {
        #[cfg(feature = "MTLTexture")]
        #[unsafe(method(textureType))]
        #[unsafe(method_family = none)]
        unsafe fn textureType(&self) -> MTLTextureType;

        #[unsafe(method(textureDataType))]
        #[unsafe(method_family = none)]
        unsafe fn textureDataType(&self) -> MTLDataType;

        #[unsafe(method(isDepthTexture))]
        #[unsafe(method_family = none)]
        unsafe fn isDepthTexture(&self) -> bool;

        #[unsafe(method(arrayLength))]
        #[unsafe(method_family = none)]
        unsafe fn arrayLength(&self) -> NSUInteger;
    }
);

extern_protocol!(
    /// [Apple's documentation](https://developer.apple.com/documentation/metal/mtlobjectpayloadbinding?language=objc)
    pub unsafe trait MTLObjectPayloadBinding: MTLBinding {
        #[unsafe(method(objectPayloadAlignment))]
        #[unsafe(method_family = none)]
        unsafe fn objectPayloadAlignment(&self) -> NSUInteger;

        #[unsafe(method(objectPayloadDataSize))]
        #[unsafe(method_family = none)]
        unsafe fn objectPayloadDataSize(&self) -> NSUInteger;
    }
);
