/*
 * Decompiled with CFR 0.152.
 */
package net.gcalc.calc.main;

import java.util.Hashtable;
import java.util.Stack;
import java.util.Vector;
import net.gcalc.calc.main.SymbolTableException;
import net.gcalc.calc.math.CircularDefinitionException;
import net.gcalc.calc.math.InvalidSymbolException;
import net.gcalc.calc.math.functions.Function;
import net.gcalc.calc.math.functions.FunctionFactory;
import net.gcalc.calc.parser.ParseTree;
import net.gcalc.calc.parser.Token;
import net.gcalc.calc.parser.VariableToken;

public class SymbolTable {
    private final Hashtable H = new Hashtable();

    public static void main(String[] args) throws Exception {
        SymbolTable symtable = new SymbolTable();
        symtable.setVariable(new VariableToken("f"), FunctionFactory.getFunction("x^2+y z"));
    }

    public Function getFunction(Token var) {
        if (this.H.containsKey(var)) {
            return (Function)this.H.get(var);
        }
        return null;
    }

    public ParseTree getParseTree(Token var) {
        if (this.H.containsKey(var)) {
            return (Function)this.H.get(var);
        }
        return null;
    }

    public void removeVariable(Token var) {
        if (this.H.containsKey(var)) {
            this.H.remove(var);
        }
    }

    public boolean containsVariable(Token var) {
        return this.H.containsKey(var);
    }

    public void setVariable(Token var, ParseTree expr) throws SymbolTableException {
        Object temp;
        boolean DEBUG = false;
        if (!var.isVariable()) {
            throw new InvalidSymbolException(var + " cannot be placed into the symbol table.");
        }
        Stack S = new Stack();
        if (DEBUG) {
            System.out.println("[SymbolTable.setExpression] Adding " + var + "=" + expr);
        }
        Vector varList = expr.getVars();
        int i = 0;
        while (i < varList.size()) {
            temp = varList.elementAt(i);
            if (var.equals(temp)) {
                throw new CircularDefinitionException("Circular definition.  Can't proceed.");
            }
            if (!S.contains(temp)) {
                S.push(temp);
            }
            ++i;
        }
        while (!S.isEmpty()) {
            Token V = (Token)S.pop();
            Function E = this.getFunction(V);
            if (E == null) continue;
            varList = E.getVars();
            int i2 = 0;
            while (i2 < varList.size()) {
                temp = varList.elementAt(i2);
                if (var.equals(temp)) {
                    throw new CircularDefinitionException();
                }
                if (!S.contains(temp)) {
                    S.push(temp);
                }
                ++i2;
            }
        }
        this.H.put(var, expr);
    }

    public synchronized void clear() {
        this.H.clear();
    }

    public String toString() {
        return this.H.toString();
    }
}

