/*
 * Decompiled with CFR 0.152.
 */
package net.gcalc.calc.math.functions;

import java.util.Vector;
import net.gcalc.calc.main.SymbolTable;
import net.gcalc.calc.main.ValueTable;
import net.gcalc.calc.math.functions.Function;
import net.gcalc.calc.math.functions.FunctionFactory;
import net.gcalc.calc.math.functions.VariableArityFunction;
import net.gcalc.calc.parser.ParseTree;

public class Sum
extends VariableArityFunction {
    public Sum(ParseTree pt) {
        super(pt);
        this.IDENTITY = ZERO;
    }

    public double evaluate(SymbolTable st, ValueTable vt) {
        if (this.getNumberOfArgs() == 0) {
            return 0.0;
        }
        double sum = 0.0;
        int i = 0;
        while (i < this.getNumberOfArgs()) {
            double t = ((Function)this.getArg(i)).evaluate(st, vt);
            if (Double.isNaN(t)) {
                return t;
            }
            sum += t;
            ++i;
        }
        return sum;
    }

    public Function derivative(Vector vars) {
        Vector<Function> newArgs = new Vector<Function>(this.getNumberOfArgs());
        int i = 0;
        while (i < newArgs.size()) {
            newArgs.add(FunctionFactory.getFunction(this.getArg(i)).derivative(vars));
            ++i;
        }
        return FunctionFactory.getFunction(this.getRoot(), newArgs).simplify();
    }

    protected boolean isIdentity(Function f) {
        return f.isZero();
    }
}

