/*
 * Decompiled with CFR 0.152.
 */
package net.gcalc.calc.models;

import java.util.Vector;
import javax.swing.AbstractListModel;
import net.gcalc.calc.models.Model;
import net.gcalc.calc.models.RenderableModel;

public class ModelList
extends AbstractListModel {
    private Vector list = new Vector();

    public ModelList() {
    }

    public ModelList(Model m) {
        this();
        this.add(m);
    }

    public synchronized void removeAllModels() {
        this.list.removeAllElements();
    }

    public synchronized void add(Model model) {
        this.list.add(model);
        this.fireContentsChanged(this, 0, this.list.size() - 1);
    }

    public synchronized void setModelAt(Model model, int n) {
        this.list.set(n, model);
        this.fireContentsChanged(this, 0, this.list.size() - 1);
    }

    public synchronized Object getElementAt(int n) {
        return this.list.elementAt(n);
    }

    public Model getModelAt(int n) {
        return (Model)this.getElementAt(n);
    }

    public synchronized void removeElementAt(int n) {
        this.list.removeElementAt(n);
        this.fireContentsChanged(this, 0, this.list.size() - 1);
    }

    public synchronized void flagAll(boolean b) {
        int i = 0;
        while (i < this.list.size()) {
            Model model = this.getModelAt(i);
            if (model != null && model instanceof RenderableModel) {
                ((RenderableModel)model).setDrawn(b);
            }
            ++i;
        }
    }

    public synchronized void deleteCache() {
        int i = 0;
        while (i < this.list.size()) {
            Model model = this.getModelAt(i);
            if (model != null && model instanceof RenderableModel) {
                ((RenderableModel)model).setImage(null);
            }
            ++i;
        }
    }

    public synchronized int getSize() {
        return this.list.size();
    }

    public synchronized Object[] getModelArray() {
        return this.list.toArray();
    }

    public synchronized Object[] getNotDrawnModels() {
        Vector<Model> v = new Vector<Model>();
        int i = 0;
        while (i < this.getSize()) {
            Model m = this.getModelAt(i);
            if (m instanceof RenderableModel && !((RenderableModel)m).isDrawn()) {
                v.add(this.getModelAt(i));
            }
            ++i;
        }
        return v.toArray();
    }

    public void poke() {
        this.fireContentsChanged(this, 0, this.list.size() - 1);
    }
}

