/*
 * Decompiled with CFR 0.152.
 */
package net.gcalc.calc.parser;

import java.util.Vector;
import net.gcalc.calc.math.functions.FunctionFactory;
import net.gcalc.calc.parser.Token;

public class ParseTree
implements Cloneable,
Comparable {
    private String id;
    private Vector args;
    private Token root;
    protected Vector vars = null;

    public Object clone() {
        ParseTree pt = new ParseTree(this.root, this.args);
        pt.setID(this.getID());
        return pt;
    }

    public ParseTree(Token tk, Vector v) {
        this.args = v;
        this.root = tk;
    }

    public ParseTree(Token tk) {
        this(tk, null);
    }

    protected ParseTree(ParseTree pt) {
        this(pt.root, pt.args);
        this.vars = pt.vars;
    }

    public void setID(String s) {
        this.id = s;
    }

    public String getID() {
        if (this.id == null) {
            return "";
        }
        return this.id;
    }

    public ParseTree getArg(int n) {
        return (ParseTree)this.args.elementAt(n);
    }

    public Vector getVars() {
        return this.getVars(null);
    }

    protected Vector getVars(Vector vars) {
        if (vars == null) {
            vars = new Vector<Token>();
        }
        if (this.args == null) {
            if (this.root.isVariable() && !vars.contains(this.root)) {
                vars.add(this.root);
            }
            return vars;
        }
        int i = 0;
        while (i < this.args.size()) {
            vars.addAll(this.getArg(i).getVars());
            ++i;
        }
        return vars;
    }

    public Token getRoot() {
        return this.root;
    }

    public int getNumberOfArgs() {
        if (this.args == null) {
            return 0;
        }
        return this.args.size();
    }

    public Vector getArgs() {
        return new Vector(this.args);
    }

    public static ParseTree removeUnnecessaryComma(ParseTree parseTree) {
        String id = parseTree.getID();
        if (parseTree.getNumberOfArgs() == 1 && parseTree.getRoot().isComma()) {
            parseTree = parseTree.getArg(0);
        }
        parseTree.setID(id);
        return parseTree;
    }

    public static ParseTree removeUnnecessarySemiColon(ParseTree parseTree) {
        String id = parseTree.getID();
        if (parseTree.getNumberOfArgs() == 1 && parseTree.getRoot().isSemiColon()) {
            parseTree = parseTree.getArg(0);
        }
        parseTree.setID(id);
        return parseTree;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("[(");
        sb.append(this.root.toString());
        sb.append(") ");
        if (this.args != null) {
            int i = 0;
            while (i < this.args.size()) {
                sb.append(this.getArg(i).toString());
                ++i;
            }
        }
        sb.append("]");
        return sb.toString();
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public int compareTo(Object o) {
        int m;
        int n = this.hashCode();
        if (n < (m = o.hashCode())) {
            return -1;
        }
        if (n > m) {
            return 1;
        }
        return 0;
    }

    public boolean equals(Object o) {
        return o instanceof ParseTree && o.toString().equals(this.toString());
    }

    public String toInfix() {
        if (this.args == null) {
            return this.root.toString();
        }
        if (this.root.isSemiColon()) {
            String s = ((ParseTree)this.args.elementAt(0)).toInfix();
            int i = 1;
            while (i < this.args.size()) {
                s = String.valueOf(s) + ";" + ((ParseTree)this.args.elementAt(i)).toInfix();
                ++i;
            }
            return s;
        }
        if (this.args.size() == 0) {
            return this.root.toString();
        }
        if (this.args.size() == 1) {
            return String.valueOf(this.root.toString()) + "(" + ((ParseTree)this.args.elementAt(0)).toInfix() + ")";
        }
        if (this.root.isBinary()) {
            ParseTree a0 = (ParseTree)this.args.elementAt(0);
            ParseTree a1 = (ParseTree)this.args.elementAt(1);
            String s = "";
            s = a0.root.isBinary() && a0.root.precedence() > this.root.precedence() ? String.valueOf(s) + "(" + a0.toInfix() + ")" : String.valueOf(s) + a0.toInfix();
            s = String.valueOf(s) + this.root.toString();
            s = a1.root.isBinary() && a1.root.precedence() > this.root.precedence() ? String.valueOf(s) + "(" + a1.toInfix() + ")" : String.valueOf(s) + a1.toInfix();
            return s;
        }
        String s = String.valueOf(this.root.toString()) + "(" + ((ParseTree)this.args.elementAt(0)).toInfix();
        int i = 1;
        while (i < this.args.size()) {
            s = String.valueOf(s) + "," + ((ParseTree)this.args.elementAt(i)).toInfix();
            ++i;
        }
        return String.valueOf(s) + ")";
    }

    public static void print(ParseTree pt) {
        ParseTree.print(pt, 0);
    }

    private static void print(ParseTree pt, int n) {
        int i = 0;
        while (i < n) {
            System.out.print(" ");
            ++i;
        }
        System.out.println(pt.root);
        if (pt.args != null) {
            i = 0;
            while (i < pt.args.size()) {
                ParseTree.print((ParseTree)pt.args.elementAt(i), n + 1);
                ++i;
            }
        }
    }

    protected void convertArgumentsToFunction() {
        int i = 0;
        while (i < this.args.size()) {
            this.args.set(i, FunctionFactory.getFunction((ParseTree)this.args.elementAt(i)));
            ++i;
        }
    }
}

