/*
 * Decompiled with CFR 0.152.
 */
package net.gcalc.plugin.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Arrays;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import net.gcalc.calc.gui.SwingGUI;
import net.gcalc.plugin.gui.InputPanel;
import net.gcalc.plugin.gui.RecallJTextField;

public class TextInputPanel
extends InputPanel
implements ActionListener,
KeyListener {
    protected JTextField inputTF;
    protected JButton inputButton;
    protected Vector history = new Vector();
    private int cursor;
    protected JTextField[] inputTFs;
    protected String title;

    public TextInputPanel(String title, String[] labels) {
        this(title, labels, null);
    }

    public TextInputPanel(String title, String[] labels, String[] values) {
        this(title, "Graph!", labels, values);
    }

    public TextInputPanel(String title, String buttonText, String[] labels, String[] values) {
        super(new BorderLayout());
        Box inputBox = this.createInputBox(buttonText, labels, values);
        this.add(SwingGUI.wrapTitledBorder(inputBox, title));
    }

    protected Box createInputBox(String buttonText, String[] labels, String[] values) {
        Box inputBox = Box.createHorizontalBox();
        int n = -1;
        n = values == null && labels == null ? 0 : (values == null ? labels.length : values.length);
        this.inputTFs = new RecallJTextField[n];
        if (buttonText != null) {
            this.inputButton = new JButton(buttonText);
            this.inputButton.addActionListener(this);
        }
        switch (n) {
            case 0: {
                return null;
            }
            case 1: {
                if (labels != null) {
                    inputBox.add(new JLabel(labels[0]));
                }
                this.inputTFs[0] = this.inputTF = new RecallJTextField(values == null ? "" : values[0]);
                inputBox.add(this.inputTF);
                if (this.inputButton != null) {
                    inputBox.add(this.inputButton);
                }
                this.inputTF.addActionListener(this);
                this.inputTF.addKeyListener(this);
                break;
            }
            default: {
                Box box = Box.createVerticalBox();
                box.add(this.createInputSubPanel(n, labels, values));
                box.add(Box.createVerticalGlue());
                inputBox.add(box);
                if (this.inputButton == null) break;
                Box b = Box.createVerticalBox();
                b.add(this.inputButton);
                b.add(Box.createVerticalGlue());
                inputBox.add(b);
            }
        }
        return inputBox;
    }

    protected JPanel createInputSubPanel(int n, String[] labels, String[] values) {
        JLabel[] lhs = new JLabel[n];
        GridBagLayout gb = new GridBagLayout();
        JPanel jp = new JPanel(gb);
        int i = 0;
        while (i < n) {
            if (labels != null) {
                lhs[i] = new JLabel(labels[i], 4);
                this.addLeftSide(jp, gb, lhs[i]);
            }
            this.inputTFs[i] = new RecallJTextField(values == null ? "" : values[i]);
            this.inputTFs[i].addActionListener(this);
            this.inputTFs[i].addKeyListener(this);
            this.inputTF = this.inputTFs[i];
            this.addRightSide(jp, gb, this.inputTF);
            ++i;
        }
        return jp;
    }

    protected void addLeftSide(JPanel panel, GridBagLayout gb, Component component) {
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 22;
        c.fill = 0;
        c.weightx = 1.0;
        c.gridwidth = -1;
        gb.setConstraints(component, c);
        panel.add(component);
    }

    protected void addRightSide(JPanel panel, GridBagLayout gb, Component component) {
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.gridwidth = 0;
        c.weightx = 10.0;
        gb.setConstraints(component, c);
        panel.add(component);
    }

    public String[] getValues() {
        String[] ret = new String[this.inputTFs.length];
        int i = 0;
        while (i < this.inputTFs.length) {
            ret[i] = this.inputTFs[i].getText();
            ++i;
        }
        return ret;
    }

    public void clear() {
        int i = 0;
        while (i < this.inputTFs.length) {
            this.inputTFs[i].setText("");
            ++i;
        }
    }

    public void actionPerformed(ActionEvent e) {
        this.fireActionEvent();
    }

    public void keyPressed(KeyEvent e) {
        int code = e.getKeyCode();
        int size = this.history.size();
        if (size == 0) {
            return;
        }
        if (code == 33) {
            this.cursor = (this.cursor + size - 1) % size;
            this.setValues((String[])this.history.elementAt(this.cursor));
        } else if (code == 34) {
            this.cursor = (this.cursor + 1) % size;
            this.setValues((String[])this.history.elementAt(this.cursor));
        }
    }

    public void keyReleased(KeyEvent e) {
    }

    public void keyTyped(KeyEvent e) {
    }

    public void resetRecallCursor() {
        this.cursor = 0;
    }

    public void addCurrentValuesToHistory() {
        Object[] s = this.getValues();
        if (this.history.isEmpty() || !Arrays.equals((String[])this.history.lastElement(), s)) {
            this.history.add(s);
        }
        this.resetRecallCursor();
    }

    public void clearHistory() {
        this.clear();
        this.history = new Vector();
        this.history.add(this.getValues());
        this.resetRecallCursor();
    }

    public void setValues(String[] val) {
        int i = 0;
        while (i < this.inputTFs.length) {
            this.inputTFs[i].setText(val[i]);
            ++i;
        }
    }

    public void incrementFocusedTextField() {
        int i = 0;
        while (i < this.inputTFs.length - 1) {
            if (this.inputTFs[i].hasFocus()) {
                this.inputTFs[(i + 1) % this.inputTFs.length].requestFocusInWindow();
                return;
            }
            ++i;
        }
    }
}

