/*
 * Decompiled with CFR 0.152.
 */
package net.gcalc.plugin.plane.graph;

import java.awt.Graphics;
import java.util.Vector;
import net.gcalc.calc.models.ModelList;
import net.gcalc.plugin.gui.AbstractCartesianGraphPlugin;
import net.gcalc.plugin.plane.graph.CartesianGraph;
import net.gcalc.plugin.plane.graph.DrawingThread;
import net.gcalc.plugin.plane.graph.ImplicitFunctionDrawingThread;
import net.gcalc.plugin.properties.GraphProperties;

public class ImplicitFunctionGraph
extends CartesianGraph {
    private DrawingThread thread = null;

    public ImplicitFunctionGraph(AbstractCartesianGraphPlugin plugin) {
        super(plugin);
        this.getProperties().put(GraphProperties.V_TITLE_STRING, "y");
    }

    protected Vector makeZoomsVector() {
        Vector v = super.makeZoomsVector();
        int i = v.size() - 1;
        while (i >= 0) {
            if (v.elementAt(i) instanceof CartesianGraph.FitZoom) {
                v.removeElementAt(i);
            }
            --i;
        }
        return v;
    }

    public void setDefaultGraphElements() {
        boolean b = true;
        this.properties.initDefault(GraphProperties.H_AXIS, b);
        this.properties.initDefault(GraphProperties.H_GRID, b);
        this.properties.initDefault(GraphProperties.H_SCALE, b);
        this.properties.initDefault(GraphProperties.V_AXIS, b);
        this.properties.initDefault(GraphProperties.V_GRID, b);
        this.properties.initDefault(GraphProperties.V_SCALE, b);
        this.properties.initDefault(GraphProperties.V_TITLE, b);
        this.properties.initDefault(GraphProperties.H_TITLE, b);
        this.properties.initDefault(GraphProperties.V_LABEL, b);
        this.properties.initDefault(GraphProperties.H_LABEL, b);
        this.properties.initDefault(GraphProperties.INTERACTIVE_ZOOM, b);
    }

    public void drawModelList() {
        ModelList modelList = this.getModelList();
        if (this.thread != null) {
            this.thread.kill();
        }
        this.thread = new ImplicitFunctionDrawingThread(this, (Graphics)this.gr, modelList);
        this.thread.start();
    }
}

