# genomicDups.sql was originally generated by the autoSql program, which also 
# generated genomicDups.c and genomicDups.h.  This creates the database representation of
# an object which can be loaded and saved from RAM in a fairly 
# automatic way.

#Summary of large genomic Duplications (>1KB >90% similar)
CREATE TABLE genomicDups (
    bin smallint unsigned not null,     # Bin number for fast range index
    chrom varchar(255) not null,	# Human chromosome
    chromStart int unsigned not null,	# Start position in chromosome
    chromEnd int unsigned not null,	# End position in chromosome
    name varchar(255) not null,	# Other FPC contig involved
    score int unsigned not null,	# Score from 900-1000.  1000 is best
    strand char(1) not null,	# Value should be + or -
    otherChrom varchar(255) not null,	# Human chromosome
    otherStart int unsigned not null,	# Start in other sequence
    otherEnd int unsigned not null,	# End in other sequence
    alignB int unsigned not null,	# bases Aligned
    matchB int unsigned not null,	# aligned bases that match
    mismatchB int unsigned not null,	# aligned bases that do not match
    fracMatch float not null,	# fraction of matching bases
    jcK float not null,	# K-value calculated with Jukes-Cantor
              #Indices
    INDEX(chrom(8),bin),
    INDEX(chrom(8),chromStart)
);
